import{s as Xn,n as Pn,o as qn}from"../chunks/scheduler.0cf4ef2e.js";import{S as Kn,i as ei,e as i,s as a,c,h as li,a as T,d as t,b as n,f as zn,g as o,j as M,k as Bl,l as ti,m as s,n as d,t as h,o as J,p as r}from"../chunks/index.abc433bf.js";import{C as si}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as U}from"../chunks/CodeBlock.00dcd05e.js";import{H as p,E as ai}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function ni(pa){let f,El,Ll,Vl,I,Wl,j,Sl,u,fa="<code>huggingface_hub</code> utilizes the local disk as two caches, which avoid re-downloading items again. The first cache is a file-based cache, which caches individual files downloaded from the Hub and ensures that the same file is not downloaded again when a repo gets updated. The second cache is a chunk cache, where each chunk represents a byte range from a file and ensures that chunks that are shared across files are only downloaded once.",Hl,C,zl,g,ya=`The Hugging Face Hub cache-system is designed to be the central cache shared across libraries
that depend on the Hub. It has been updated in v0.8.0 to prevent re-downloading same files
between revisions.`,Xl,b,wa="The caching system is designed as follows:",Pl,A,ql,k,ma="The default <code>&lt;CACHE_DIR&gt;</code> is <code>~/.cache/huggingface/hub</code>. However, it is customizable with the <code>cache_dir</code> argument on all methods, or by specifying either <code>HF_HOME</code> or <code>HF_HUB_CACHE</code> environment variable.",Kl,N,Ia=`Models, datasets and spaces share a common root. Each of these repositories contains the
repository type, the namespace (organization or username) if it exists and the
repository name:`,et,v,lt,Z,ja=`It is within these folders that all files will now be downloaded from the Hub. Caching ensures that
a file isn’t downloaded twice if it already exists and wasn’t updated; but if it was updated,
and you’re asking for the latest file, then it will download the latest file (while keeping
the previous file intact in case you need it again).`,tt,$,ua="In order to achieve this, all folders contain the same skeleton:",st,x,at,Q,Ca="Each folder is designed to contain the following:",nt,_,it,R,ga=`The <code>refs</code> folder contains files which indicates the latest revision of the given reference. For example,
if we have previously fetched a file from the <code>main</code> branch of a repository, the <code>refs</code>
folder will contain a file named <code>main</code>, which will itself contain the commit identifier of the current head.`,Tt,O,ba="If the latest commit of <code>main</code> has <code>aaaaaa</code> as identifier, then it will contain <code>aaaaaa</code>.",Mt,F,Aa=`If that same branch gets updated with a new commit, that has <code>bbbbbb</code> as an identifier, then
re-downloading a file from that reference will update the <code>refs/main</code> file to contain <code>bbbbbb</code>.`,ct,D,ot,Y,ka="The <code>blobs</code> folder contains the actual files that we have downloaded. The name of each file is their hash.",dt,L,ht,G,Na=`The <code>snapshots</code> folder contains symlinks to the blobs mentioned above. It is itself made up of several folders:
one per known revision!`,Jt,B,va=`In the explanation above, we had initially fetched a file from the <code>aaaaaa</code> revision, before fetching a file from
the <code>bbbbbb</code> revision. In this situation, we would now have two folders in the <code>snapshots</code> folder: <code>aaaaaa</code>
and <code>bbbbbb</code>.`,rt,E,Za=`In each of these folders, live symlinks that have the names of the files that we have downloaded. For example,
if we had downloaded the <code>README.md</code> file at revision <code>aaaaaa</code>, we would have the following path:`,Ut,V,pt,W,$a="That <code>README.md</code> file is actually a symlink linking to the blob that has the hash of the file.",ft,S,xa=`By creating the skeleton this way we open the mechanism to file sharing: if the same file was fetched in
revision <code>bbbbbb</code>, it would have the same hash and the file would not need to be re-downloaded.`,yt,H,wt,z,Qa=`In addition to the <code>blobs</code>, <code>refs</code> and <code>snapshots</code> folders, you might also find a <code>.no_exist</code> folder
in your cache. This folder keeps track of files that you’ve tried to download once but don’t exist
on the Hub. Its structure is the same as the <code>snapshots</code> folder with 1 subfolder per known revision:`,mt,X,It,P,_a=`Unlike the <code>snapshots</code> folder, files are simple empty files (no symlinks). In this example,
the file <code>&quot;config_that_does_not_exist.json&quot;</code> does not exist on the Hub for the revision <code>&quot;aaaaaa&quot;</code>.
As it only stores empty files, this folder is neglectable in term of disk usage.`,jt,q,Ra=`So now you might wonder, why is this information even relevant?
In some cases, a framework tries to load optional files for a model. Saving the non-existence
of optional files makes it faster to load a model as it saves 1 HTTP call per possible optional file.
This is for example the case in <code>transformers</code> where each tokenizer can support additional files.
The first time you load the tokenizer on your machine, it will cache which optional files exist (and
which doesn’t) to make the loading time faster for the next initializations.`,ut,K,Oa=`To test if a file is cached locally (without making any HTTP request), you can use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.try_to_load_from_cache">try_to_load_from_cache()</a>
helper. It will either return the filepath (if exists and cached), the object <code>_CACHED_NO_EXIST</code> (if non-existence
is cached) or <code>None</code> (if we don’t know).`,Ct,ee,gt,le,bt,te,Fa="In practice, your cache should look like the following tree:",At,se,kt,ae,Nt,ne,Da=`In order to have an efficient cache-system, <code>huggingface-hub</code> uses symlinks. However,
symlinks are not supported on all machines. This is a known limitation especially on
Windows. When this is the case, <code>huggingface_hub</code> do not use the <code>blobs/</code> directory but
directly stores the files in the <code>snapshots/</code> directory instead. This workaround allows
users to download and cache files from the Hub exactly the same way. Tools to inspect
and delete the cache (see below) are also supported. However, the cache-system is less
efficient as a single file might be downloaded several times if multiple revisions of
the same repo is downloaded.`,vt,ie,Ya=`If you want to benefit from the symlink-based cache-system on a Windows machine, you
either need to <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">activate Developer Mode</a>
or to run Python as an administrator.`,Zt,Te,La=`When symlinks are not supported, a warning message is displayed to the user to alert
them they are using a degraded version of the cache-system. This warning can be disabled
by setting the <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> environment variable to true.`,$t,Me,xt,ce,Ga='To provide more efficient file transfers, <code>hf_xet</code> adds a <code>xet</code> directory to the existing <code>huggingface_hub</code> cache, creating additional caching layer to enable chunk-based deduplication. This cache holds chunks (immutable byte ranges of files ~64KB in size) and shards (a data structure that maps files to chunks). For more information on the Xet Storage system, see this <a href="https://huggingface.co/docs/hub/xet/index" rel="nofollow">section</a>.',Qt,oe,Ba="The <code>xet</code> directory, located at <code>~/.cache/huggingface/xet</code> by default, contains two caches, utilized for uploads and downloads. It has the following structure:",_t,de,Rt,he,Ea='The <code>environment_identifier</code> directory is an encoded string (it may appear on your machine as <code>https___cas_serv-tGqkUaZf_CBPHQ6h</code>). This is used during development allowing for local and production versions of the cache to exist alongside each other simultaneously. It is also used when downloading from repositories that reside in different <a href="https://huggingface.co/docs/hub/storage-regions" rel="nofollow">storage regions</a>. You may see multiple such entries in the <code>xet</code> directory, each corresponding to a different environment, but their internal structure is the same.',Ot,Je,Va="The internal directories serve the following purposes:",Ft,re,Wa="<li><code>chunk-cache</code> contains cached data chunks that are used to speed up downloads.</li> <li><code>shard-cache</code> contains cached shards that are utilized on the upload path.</li> <li><code>staging</code> is a workspace designed to support resumable uploads.</li>",Dt,Ue,Sa="These are documented below.",Yt,pe,Ha="Note that the <code>xet</code> caching system, like the rest of <code>hf_xet</code> is fully integrated with <code>huggingface_hub</code>.  If you use the existing APIs for interacting with cached assets, there is no need to update your workflow. The <code>xet</code> caches are built as an optimization layer on top of the existing <code>hf_xet</code> chunk-based deduplication and <code>huggingface_hub</code> cache system.",Lt,fe,Gt,ye,za="This cache is used on the download path. The cache directory structure is based on a base-64 encoded hash from the content-addressed store (CAS) that backs each Xet-enabled repository. A CAS hash serves as the key to lookup the offsets of where the data is stored. Note: as of <code>hf_xet</code> 1.2.0 the chunk_cache is disabled by default. To enable it, set the <code>HF_XET_CHUNK_CACHE_SIZE_BYTES</code> environment variable to the appropriate size prior to launching the Python process.",Bt,we,Xa="At the topmost level, the first two letters of the base 64 encoded CAS hash are used to create a subdirectory in the <code>chunk_cache</code> (keys that share these first two letters are grouped here).  The inner levels are comprised of subdirectories with the full key as the directory name. At the base are the cache items which are ranges of blocks that contain the cached chunks.",Et,me,Vt,Ie,Pa="When requesting a file, the first thing <code>hf_xet</code> does is communicate with Xet storage’s content addressed store (CAS) for reconstruction information. The reconstruction information contains information about the CAS keys required to download the file in its entirety.",Wt,je,qa="Before executing the requests for the CAS keys, the <code>chunk_cache</code> is consulted. If a key in the cache matches a CAS key, then there is no reason to issue a request for that content. <code>hf_xet</code> uses the chunks stored in the directory instead.",St,ue,Ka="As the <code>chunk_cache</code> is purely an optimization, not a guarantee, <code>hf_xet</code> utilizes a computationally efficient eviction policy. When the <code>chunk_cache</code> is full (see <code>Limits and Limitations</code> below), <code>hf_xet</code> implements a random eviction policy when selecting an eviction candidate. This significantly reduces the overhead of managing a robust caching system (e.g., LRU) while still providing most of the benefits of caching chunks.",Ht,Ce,zt,ge,en="This cache is used when uploading content to the Hub. The directory is flat, comprising only of shard files, each using an ID for the shard name.",Xt,be,Pt,Ae,ln="The <code>shard_cache</code> contains shards that are:",qt,ke,tn="<li>Locally generated and successfully uploaded to the CAS</li> <li>Downloaded from CAS as part of the global deduplication algorithm</li>",Kt,Ne,sn="Shards provide a mapping between files and chunks. During uploads, each file is chunked and the hash of the chunk is saved. Every shard in the cache is then consulted. If a shard contains a chunk hash that is present in the local file being uploaded, then that chunk can be discarded as it is already stored in CAS.",es,ve,an="All shards have an expiration date of 3-4 weeks from when they are downloaded. Shards that are expired are not loaded during upload and are deleted one week after expiration.",ls,Ze,ts,$e,nn="When an upload terminates before the new content has been committed to the repository, you will need to resume the file transfer. However, it is possible that some chunks were successfully uploaded prior to the interruption.",ss,xe,Tn="So that you do not have to restart from the beginning, the <code>staging</code> directory acts as a workspace during uploads, storing metadata for successfully uploaded chunks. The <code>staging</code> directory has the following shape:",as,Qe,ns,_e,Mn="As files are processed and chunks successfully uploaded, their metadata is stored in <code>xorb-metadata</code> as a shard. Upon resuming an upload session, each file is processed again and the shards in this directory are consulted. Any content that was successfully uploaded is skipped, and any new content is uploaded (and its metadata saved).",is,Re,cn="Meanwhile, <code>shard-session</code> stores file and chunk information for processed files. On successful completion of an upload, the content from these shards is moved to the more persistent <code>shard-cache</code>.",Ts,Oe,Ms,Fe,on="The <code>chunk_cache</code> is limited to 10GB in size while the <code>shard_cache</code> has a soft limit of 4GB.  By design, both caches are without high-level APIs, although their size is configurable through the <code>HF_XET_CHUNK_CACHE_SIZE_BYTES</code> and <code>HF_XET_SHARD_CACHE_SIZE_LIMIT</code> environment variables.",cs,De,dn='These caches are used primarily to facilitate the reconstruction (download) or upload of a file. To interact with the assets themselves, it’s recommended that you use the <a href="https://huggingface.co/docs/huggingface_hub/guides/manage-cache" rel="nofollow"><code>huggingface_hub</code> cache system APIs</a>.',os,Ye,hn="If you need to reclaim the space utilized by either cache or need to debug any potential cache-related issues, simply remove the <code>xet</code> cache entirely by running <code>rm -rf ~/&lt;cache_dir&gt;/xet</code> where <code>&lt;cache_dir&gt;</code> is the location of your Hugging Face cache, typically <code>~/.cache/huggingface</code>",ds,Le,Jn="Example full <code>xet</code>cache directory tree:",hs,Ge,Js,Be,rn='To learn more about Xet Storage, see this <a href="https://huggingface.co/docs/hub/xet/index" rel="nofollow">section</a>.',rs,Ee,Us,Ve,Un=`In addition to caching files from the Hub, downstream libraries often requires to cache
other files related to HF but not handled directly by <code>huggingface_hub</code> (example: file
downloaded from GitHub, preprocessed data, logs,…). In order to cache those files,
called <code>assets</code>, one can use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a>. This small helper generates paths
in the HF cache in a unified way based on the name of the library requesting it and
optionally on a namespace and a subfolder name. The goal is to let every downstream
libraries manage its assets its own way (e.g. no rule on the structure) as long as it
stays in the right assets folder. Those libraries can then leverage tools from
<code>huggingface_hub</code> to manage the cache, in particular scanning and deleting parts of the
assets from a CLI command.`,ps,We,fs,Se,pn=`<p>[!TIP][cached_assets_path()](/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path) is the recommended way to store assets but is not mandatory. If
your library already uses its own cache, feel free to use it!</p>`,ys,He,ws,ze,fn="In practice, your assets cache should look like the following tree:",ms,Xe,Is,Pe,js,qe,us,Ke,yn=`At the moment, cached files are never deleted from your local directory: when you download
a new revision of a branch, previous files are kept in case you need them again.
Therefore it can be useful to inspect your cache directory in order to know which repos
and revisions are taking the most disk space. <code>huggingface_hub</code> provides helpers you can
use from the <code>hf</code> CLI or from Python.`,Cs,el,wn="<strong>Inspect cache from the terminal</strong>",gs,ll,mn=`Run <code>hf cache ls</code> to explore what is stored locally. By default the command aggregates
information by repository:`,bs,tl,As,sl,In=`Add <code>--revisions</code> to list every cached snapshot and chain filters to focus on what
matters. Filters understand human-friendly sizes and durations, so expressions such as
<code>size&gt;1GB</code> or <code>accessed&gt;30d</code> work out of the box:`,ks,al,Ns,nl,jn=`Need machine-friendly output? Use <code>--format json</code> to get structured objects or
<code>--format csv</code> for spreadsheets. Alternatively <code>--quiet</code> prints only identifiers (one
per line) so you can pipe them into other tooling. Use <code>--sort</code> to order entries by <code>accessed</code>, <code>modified</code>, <code>name</code>, or <code>size</code> (append <code>:asc</code> or <code>:desc</code> to control order), and <code>--limit</code> to restrict results to the top N entries. Combine these options with
<code>--cache-dir</code> when you need to inspect a cache stored outside of <code>HF_HOME</code>.`,vs,il,un="<strong>Filter with common shell tools</strong>",Zs,Tl,Cn=`Tabular output means you can keep using the tooling you already know. For instance, the
snippet below finds every cached revision related to <code>t5-small</code>:`,$s,Ml,xs,cl,gn="<strong>Inspect cache from Python</strong>",Qs,ol,bn=`For a more advanced usage, use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a> which is the python utility called by
the CLI tool.`,_s,dl,An="You can use it to get a detailed report structured around 4 dataclasses:",Rs,hl,kn='<li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a>: complete report returned by <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a></li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRepoInfo">CachedRepoInfo</a>: information about a cached repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRevisionInfo">CachedRevisionInfo</a>: information about a cached revision (e.g. “snapshot”) inside a repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedFileInfo">CachedFileInfo</a>: information about a cached file in a snapshot</li>',Os,Jl,Nn="Here is a simple usage example. See reference for details.",Fs,rl,Ds,Ul,Ys,pl,vn="<code>huggingface_hub</code> can verify that your cached files match the checksums on the Hub. Use <code>hf cache verify</code> CLI to validate file consistency for a specific revision of a specific repository:",Ls,fl,Gs,yl,Zn="Verify a specific cached revision:",Bs,wl,Es,y,$n='<p>Check the <a href="../package_reference/cli#hf-cache-verify"><code>hf cache verify</code> CLI reference</a> for more details about the usage and a complete list of options.</p>',Vs,ml,Ws,Il,xn=`Scanning your cache is interesting but what you really want to do next is usually to
delete some portions to free up some space on your drive. This is possible using the
<code>hf cache rm</code> and <code>hf cache prune</code> CLI commands. One can also programmatically use the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> helper from the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a> object returned when
scanning the cache.`,Ss,jl,Qn="<strong>Delete strategy</strong>",Hs,ul,_n=`To delete some cache, you need to pass a list of revisions to delete. The tool will
define a strategy to free up the space based on this list. It returns a
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object that describes which files and folders will be deleted.
The <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> allows give you how much space is expected to be freed.
Once you agree with the deletion, you must execute it to make the deletion effective. In
order to avoid discrepancies, you cannot edit a strategy object manually.`,zs,Cl,Rn="The strategy to delete revisions is the following:",Xs,gl,On="<li>the <code>snapshot</code> folder containing the revision symlinks is deleted.</li> <li>blobs files that are targeted only by revisions to be deleted are deleted as well.</li> <li>if a revision is linked to 1 or more <code>refs</code>, references are deleted.</li> <li>if all revisions from a repo are deleted, the entire cached repository is deleted.</li>",Ps,w,Fn=`<p>Revision hashes are unique across all repositories. <code>hf cache rm</code> therefore accepts either
a repo identifier (for example <code>model/bert-base-uncased</code>) or a bare revision hash; when
passing a hash you don’t need to specify the repo separately.</p>`,qs,m,Dn=`<p>If a revision is not found in the cache, it will be silently ignored. Besides, if a file
or folder cannot be found while trying to delete it, a warning will be logged but no
error is thrown. The deletion continues for other paths contained in the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object.</p>`,Ks,bl,Yn="<strong>Clean cache from the terminal</strong>",ea,Al,Ln=`Use <code>hf cache rm</code> to permanently delete repositories or revisions from your cache. Pass
one or more repo identifiers (for example <code>model/bert-base-uncased</code>) or revision hashes:`,la,kl,ta,Nl,Gn="You can also use <code>hf cache rm</code> in combination with <code>hf cache ls --quiet</code> to bulk-delete entries identified by a filter:",sa,vl,aa,Zl,Bn=`Mix repositories and revisions in the same call. Add <code>--dry-run</code> to preview the impact,
or <code>--yes</code> to skip the confirmation prompt when scripting:`,na,$l,ia,xl,En=`When working outside the default cache location, pair the command with
<code>--cache-dir PATH</code>.`,Ta,Ql,Vn=`To clean up detached snapshots in bulk, run <code>hf cache prune</code>. It automatically selects
revisions that are no longer referenced by a branch or tag:`,Ma,_l,ca,Rl,Wn=`Both commands support <code>--dry-run</code>, <code>--yes</code>, and <code>--cache-dir</code> so you can preview, automate,
and target alternate cache directories as needed.`,oa,Ol,Sn="<strong>Clean cache from Python</strong>",da,Fl,Hn=`For more flexibility, you can also use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> method
programmatically. Here is a simple example. See reference for details.`,ha,Dl,Ja,Yl,ra,Gl,Ua;return I=new si({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new p({props:{title:"Understand caching",local:"understand-caching",headingTag:"h1"}}),C=new p({props:{title:"File-based caching",local:"file-based-caching",headingTag:"h2"}}),A=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`,wrap:!1}}),v=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`,wrap:!1}}),x=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`,wrap:!1}}),_=new p({props:{title:"Refs",local:"refs",headingTag:"h3"}}),D=new p({props:{title:"Blobs",local:"blobs",headingTag:"h3"}}),L=new p({props:{title:"Snapshots",local:"snapshots",headingTag:"h3"}}),V=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md',wrap:!1}}),H=new p({props:{title:".no_exist (advanced)",local:"noexist-advanced",headingTag:"h3"}}),X=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json',wrap:!1}}),ee=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`,wrap:!1}}),le=new p({props:{title:"In practice",local:"in-practice",headingTag:"h3"}}),se=new U({props:{code:"JTIwJTIwJTIwJTIwJTVCJTIwJTIwOTYlNUQlMjAlMjAuJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwMTYwJTVEJTIwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMDE2MCU1RCUyMCUyMGJsb2JzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCMzIxTSU1RCUyMCUyMDQwMzQ1MGUyMzRkNjU5NDNhN2RjZjdlMDVhNzcxY2UzYzkyZmFhODRkZDA3ZGI0YWMyMGY1OTIwMzdhMWU0YmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAzOTglNUQlMjAlMjA3Y2IxOGRjOWJhZmJmY2Y3NDYyOWE0Yjc2MGFmMWIxNjA5NTdhODNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCMS40SyU1RCUyMCUyMGQ3ZWRmNmJkMmE2ODFmYjAxNzVmNzczNTI5OTgzMWVlMWIyMmI4MTIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA5NiU1RCUyMCUyMHJlZnMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA0MCU1RCUyMCUyMG1haW4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAxMjglNUQlMjAlMjBzbmFwc2hvdHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAxMjglNUQlMjAlMjAyNDM5ZjYwZWYzM2EwZDQ2ZDg1ZGE1MDAxZDUyYWVkYTViMDBjZTlmJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwJTIwNTIlNUQlMjAlMjBSRUFETUUubWQlMjAtJTNFJTIwLi4lMkYuLiUyRmJsb2JzJTJGZDdlZGY2YmQyYTY4MWZiMDE3NWY3NzM1Mjk5ODMxZWUxYjIyYjgxMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMCUyMDc2JTVEJTIwJTIwcHl0b3JjaF9tb2RlbC5iaW4lMjAtJTNFJTIwLi4lMkYuLiUyRmJsb2JzJTJGNDAzNDUwZTIzNGQ2NTk0M2E3ZGNmN2UwNWE3NzFjZTNjOTJmYWE4NGRkMDdkYjRhYzIwZjU5MjAzN2ExZTRiZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMDEyOCU1RCUyMCUyMGJiYzc3YzgxMzJhZjFjYzVjZjY3OGRhM2YxZGRmMmRlNDM2MDZkNDglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA1MiU1RCUyMCUyMFJFQURNRS5tZCUyMC0lM0UlMjAuLiUyRi4uJTJGYmxvYnMlMkY3Y2IxOGRjOWJhZmJmY2Y3NDYyOWE0Yjc2MGFmMWIxNjA5NTdhODNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwJTIwNzYlNUQlMjAlMjBweXRvcmNoX21vZGVsLmJpbiUyMC0lM0UlMjAuLiUyRi4uJTJGYmxvYnMlMkY0MDM0NTBlMjM0ZDY1OTQzYTdkY2Y3ZTA1YTc3MWNlM2M5MmZhYTg0ZGQwN2RiNGFjMjBmNTkyMDM3YTFlNGJk",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),ae=new p({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),Me=new p({props:{title:"Chunk-based caching (Xet)",local:"chunk-based-caching-xet",headingTag:"h2"}}),de=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwZW52aXJvbm1lbnRfaWRlbnRpZmllciUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMGNodW5rX2NhY2hlJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzdGFnaW5n",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ environment_identifier
│  │  ├─ chunk_cache
│  │  ├─ shard_cache
│  │  ├─ staging`,wrap:!1}}),fe=new p({props:{title:"chunk_cache",local:"chunkcache",headingTag:"h3"}}),me=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEExR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQQ==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ A1
│  │  │  ├─ A1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
`,wrap:!1}}),Ce=new p({props:{title:"shard_cache",local:"shardcache",headingTag:"h3"}}),be=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjAxZmU0ZmZkNWNmMGMzMzc1ZjFlZjlhZWM1MDE2Y2Y3NzNjY2M1Y2EyOTQyOTNkM2Y5MmQ5Mjc3MWRhY2ZjMTVkLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDkwNmVlMTg0ZGMxY2QwNjE1MTY0YTg5ZWQ2NGU4MTQ3YjNmZGNjZDExNjNkODBkNzk0YzY2ODE0YjNiMDk5OTIubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2VlZWI3ZWE0Y2Y2YzBhOGQzOTVhMmNmOWMwODg3MTIxMWZiYmQxN2I5YjVkYzEwMDU4MTE4NDUzMDdlNmI4Zi5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBlODUzNTE1NWIxYjExZWJkODk0YzkwOGU5MWExZTE0ZTM0NjFkZGRkMTM5MjY5NWRkYzkwYWU1NGE1NDhkOGIyLm1kYg==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb`,wrap:!1}}),Ze=new p({props:{title:"staging",local:"staging",headingTag:"h3"}}),Qe=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc3RhZ2luZyUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMHNoYXJkLXNlc3Npb24lMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjA5MDZlZTE4NGRjMWNkMDYxNTE2NGE4OWVkNjRlODE0N2IzZmRjY2QxMTYzZDgwZDc5NGM2NjgxNGIzYjA5OTkyLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMHhvcmItbWV0YWRhdGElMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjAxZmU0ZmZkNWNmMGMzMzc1ZjFlZjlhZWM1MDE2Y2Y3NzNjY2M1Y2EyOTQyOTNkM2Y5MmQ5Mjc3MWRhY2ZjMTVkLm1kYg==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ <span class="hljs-number">906</span>ee<span class="hljs-number">184</span>dc<span class="hljs-number">1</span>cd<span class="hljs-number">0615164</span>a<span class="hljs-number">89</span>ed<span class="hljs-number">64e8147</span>b<span class="hljs-number">3</span>fdccd<span class="hljs-number">1163</span>d<span class="hljs-number">80</span>d<span class="hljs-number">794</span><span class="hljs-keyword">c</span><span class="hljs-number">66814</span>b<span class="hljs-number">3</span>b<span class="hljs-number">09992</span>.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ <span class="hljs-number">1</span>fe<span class="hljs-number">4</span>ffd<span class="hljs-number">5</span>cf<span class="hljs-number">0</span><span class="hljs-keyword">c</span><span class="hljs-number">3375</span>f<span class="hljs-number">1</span>ef<span class="hljs-number">9</span>aec<span class="hljs-number">5016</span>cf<span class="hljs-number">773</span><span class="hljs-keyword">ccc</span><span class="hljs-number">5</span>ca<span class="hljs-number">294293</span>d<span class="hljs-number">3</span>f<span class="hljs-number">92</span>d<span class="hljs-number">92771</span>dacfc<span class="hljs-number">15</span>d.mdb`,wrap:!1}}),Oe=new p({props:{title:"Limits and Limitations",local:"limits-and-limitations",headingTag:"h3"}}),Ge=new U({props:{code:"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",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ L1
│  │  │  ├─ L1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb`,wrap:!1}}),Ee=new p({props:{title:"Caching assets",local:"caching-assets",headingTag:"h2"}}),We=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBEbyUyMGFueXRoaW5nJTIweW91JTIwbGlrZSUyMGluJTIweW91ciUyMGFzc2V0cyUyMGZvbGRlciUyMCE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Do anything you like in your assets folder !</span>`,wrap:!1}}),He=new p({props:{title:"Assets in practice",local:"assets-in-practice",headingTag:"h3"}}),Xe=new U({props:{code:"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",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`,wrap:!1}}),Pe=new p({props:{title:"Manage your file-based cache",local:"manage-your-file-based-cache",headingTag:"h2"}}),qe=new p({props:{title:"Inspect your cache",local:"inspect-your-cache",headingTag:"h3"}}),tl=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMGxzJTBBSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTSVpFJTIwJTIwJTIwTEFTVF9BQ0NFU1NFRCUyMExBU1RfTU9ESUZJRUQlMjBSRUZTJTBBLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTIwLS0tLS0tLSUyMC0tLS0tLS0tLS0tLS0lMjAtLS0tLS0tLS0tLS0tJTIwLS0tLS0tLS0tLS0tLS0tLS0tLSUwQWRhdGFzZXQlMkZnbHVlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTE2LjNLJTIwNCUyMGRheXMlMjBhZ28lMjAlMjAlMjAlMjAlMjA0JTIwZGF5cyUyMGFnbyUyMCUyMCUyMCUyMCUyMDIuNC4wJTIwbWFpbiUyMDEuMTcuMCUwQWRhdGFzZXQlMkZnb29nbGUlMkZmbGV1cnMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA2NC45TSUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwJTIwMSUyMHdlZWslMjBhZ28lMjAlMjAlMjAlMjAlMjBtYWluJTIwcmVmcyUyRnByJTJGMSUwQW1vZGVsJTJGSmVhbi1CYXB0aXN0ZSUyRmNhbWVtYmVydC1uZXIlMjAlMjAlMjAlMjA0NDEuME0lMjAyJTIwd2Vla3MlMjBhZ28lMjAlMjAlMjAlMjAxNiUyMGhvdXJzJTIwYWdvJTIwJTIwJTIwbWFpbiUwQW1vZGVsJTJGYmVydC1iYXNlLWNhc2VkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45RyUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwJTIwMiUyMHllYXJzJTIwYWdvJTBBbW9kZWwlMkZ0NS1iYXNlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAuMUslMjAzJTIwbW9udGhzJTIwYWdvJTIwJTIwJTIwMyUyMG1vbnRocyUyMGFnbyUyMCUyMCUyMG1haW4lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOTcwLjdNJTIwMyUyMGRheXMlMjBhZ28lMjAlMjAlMjAlMjAlMjAzJTIwZGF5cyUyMGFnbyUyMCUyMCUyMCUyMCUyMG1haW4lMjByZWZzJTJGcHIlMkYxJTBBJTBBRm91bmQlMjA2JTIwcmVwbyhzKSUyMGZvciUyMGElMjB0b3RhbCUyMG9mJTIwMTIlMjByZXZpc2lvbihzKSUyMGFuZCUyMDMuNEclMjBvbiUyMGRpc2su",highlighted:`➜ hf cache ls
ID                                   SIZE   LAST_ACCESSED LAST_MODIFIED REFS
------------------------------------ ------- ------------- ------------- -------------------
dataset/glue                         116.3K 4 days ago     4 days ago     2.4.0 main 1.17.0
dataset/google/fleurs                 64.9M 1 week ago     1 week ago     main refs/pr/1
model/Jean-Baptiste/camembert-ner    441.0M 2 weeks ago    16 hours ago   main
model/bert-base-cased                  1.9G 1 week ago     2 years ago
model/t5-base                          10.1K 3 months ago   3 months ago   main
model/t5-small                        970.7M 3 days ago     3 days ago     main refs/pr/1

Found 6 repo(s) for a total of 12 revision(s) and 3.4G on disk.`,wrap:!1}}),al=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMGxzJTIwLS1yZXZpc2lvbnMlMjAtLWZpbHRlciUyMCUyMnNpemUlM0UxR0IlMjIlMjAtLWZpbHRlciUyMCUyMmFjY2Vzc2VkJTNFMzBkJTIyJTBBSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSRVZJU0lPTiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNJWkUlMjAlMjAlMjBMQVNUX01PRElGSUVEJTIwUkVGUyUwQS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyMC0tLS0tLS0tLS0tLS0tLS0tLSUyMC0tLS0tLS0lMjAtLS0tLS0tLS0tLS0tJTIwLS0tLS0tLS0tLS0tLS0tLS0tLSUwQW1vZGVsJTJGYmVydC1iYXNlLWNhc2VkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNmQxZDdhMWEyYTZjZjRjMiUyMCUyMCUyMCUyMDEuOUclMjAlMjAyJTIweWVhcnMlMjBhZ28lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMWM2MTBmNmIzZjVlN2Q4YSUyMCUyMCUyMCUyMDEuMUclMjAlMjAzJTIwbW9udGhzJTIwYWdvJTIwJTIwbWFpbiUwQSUwQUZvdW5kJTIwMiUyMHJlcG8ocyklMjBmb3IlMjBhJTIwdG90YWwlMjBvZiUyMDIlMjByZXZpc2lvbihzKSUyMGFuZCUyMDMuMEclMjBvbiUyMGRpc2su",highlighted:`➜ hf cache ls --revisions --filter &quot;size&gt;1GB&quot; --filter &quot;accessed&gt;30d&quot;
ID                                   REVISION            SIZE   LAST_MODIFIED REFS
------------------------------------ ------------------ ------- ------------- -------------------
model/bert-base-cased                6d1d7a1a2a6cf4c2    1.9G  2 years ago
model/t5-small                       1c610f6b3f5e7d8a    1.1G  3 months ago  main

Found 2 repo(s) for a total of 2 revision(s) and 3.0G on disk.`,wrap:!1}}),Ml=new U({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmhmJTIwY2FjaGUlMjBscyUyMC0tcmV2aXNpb25zJTIyJTIwJTdDJTIwZ3JlcCUyMCUyMnQ1LXNtYWxsJTIyJTBBbW9kZWwlMkZ0NS1zbWFsbCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDFjNjEwZjZiM2Y1ZTdkOGElMjAlMjAlMjAlMjAxLjFHJTIwJTIwMyUyMG1vbnRocyUyMGFnbyUyMCUyMG1haW4lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOGYzYWQxYzkwZmVkN2E2MiUyMCUyMCUyMCUyMDgyMC4xTSUyMDIlMjB3ZWVrcyUyMGFnbyUyMCUyMCUyMHJlZnMlMkZwciUyRjE=",highlighted:`➜ eval &quot;hf cache ls --revisions&quot; | grep &quot;t5-small&quot;
model/t5-small                       1c610f6b3f5e7d8a    1.1G  3 months ago  main
model/t5-small                       8f3ad1c90fed7a62    820.1M 2 weeks ago   refs/pr/1`,wrap:!1}}),rl=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`,wrap:!1}}),Ul=new p({props:{title:"Verify your cache",local:"verify-your-cache",headingTag:"h3"}}),fl=new U({props:{code:"aGYlMjBjYWNoZSUyMHZlcmlmeSUyMG1ldGEtbGxhbWElMkZMbGFtYS0zLjItMUItSW5zdHJ1Y3Q=",highlighted:`&gt;&gt;&gt; hf cache verify meta-llama/Llama-3.2-1B-Instruct
✅ Verified 13 file(s) <span class="hljs-keyword">for</span> <span class="hljs-string">&#x27;meta-llama/Llama-3.2-1B-Instruct&#x27;</span> (model) <span class="hljs-keyword">in</span> ~/.cache/huggingface/hub/models--meta-llama--Llama-3.2-1B-Instruct/snapshots/9213176726f574b556790deb65791e0c5aa438b6
  All checksums match.`,wrap:!1}}),wl=new U({props:{code:"aGYlMjBjYWNoZSUyMHZlcmlmeSUyMG1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjAtLXJldmlzaW9uJTIwMGU5ZTM5ZjI0OWExNjk3NjkxOGY2NTY0Yjg4MzBiYzg5NGM4OTY1OQ==",highlighted:"&gt;&gt;&gt; hf cache verify meta-llama/Llama-3.1-8B-Instruct --revision 0e9e39f249a16976918f6564b8830bc894c89659",wrap:!1}}),ml=new p({props:{title:"Clean your cache",local:"clean-your-cache",headingTag:"h3"}}),kl=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZiZXJ0LWJhc2UtY2FzZWQlMEFBYm91dCUyMHRvJTIwZGVsZXRlJTIwMSUyMHJlcG8ocyklMjB0b3RhbGxpbmclMjAxLjlHLiUwQSUyMCUyMC0lMjBtb2RlbCUyRmJlcnQtYmFzZS1jYXNlZCUyMChlbnRpcmUlMjByZXBvKSUwQVByb2NlZWQlMjB3aXRoJTIwZGVsZXRpb24lM0YlMjAlNUJ5JTJGTiU1RCUzQSUyMHklMEFEZWxldGVkJTIwMSUyMHJlcG8ocyklMjBhbmQlMjAxJTIwcmV2aXNpb24ocyklM0IlMjBmcmVlZCUyMDEuOUcu",highlighted:`➜ hf cache rm model/bert-base-cased
About to delete 1 repo(s) totalling 1.9G.
  - model/bert-base-cased (entire repo)
Proceed with deletion? [y/N]: y
Deleted 1 repo(s) and 1 revision(s); freed 1.9G.`,wrap:!1}}),vl=new U({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwJTI0KGhmJTIwY2FjaGUlMjBscyUyMC0tZmlsdGVyJTIwJTIyYWNjZXNzZWQlM0UxeSUyMiUyMC1xKSUyMC15",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> $(hf cache <span class="hljs-built_in">ls</span> --filter <span class="hljs-string">&quot;accessed&gt;1y&quot;</span> -q) -y
About to delete 2 repo(s) totalling 5.31G.
  - model/meta-llama/Llama-3.2-1B-Instruct (entire repo)
  - model/hexgrad/Kokoro-82M (entire repo)
Delete repo: ~/.cache/huggingface/hub/models--meta-llama--Llama-3.2-1B-Instruct
Delete repo: ~/.cache/huggingface/hub/models--hexgrad--Kokoro-82M
Cache deletion <span class="hljs-keyword">done</span>. Saved 5.31G.
Deleted 2 repo(s) and 2 revision(s); freed 5.31G.`,wrap:!1}}),$l=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZ0NS1zbWFsbCUyMDhmM2FkMWMlMjAtLWRyeS1ydW4lMEFBYm91dCUyMHRvJTIwZGVsZXRlJTIwMSUyMHJlcG8ocyklMjBhbmQlMjAxJTIwcmV2aXNpb24ocyklMjB0b3RhbGxpbmclMjAxLjFHLiUwQSUyMCUyMC0lMjBtb2RlbCUyRnQ1LXNtYWxsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwOGYzYWQxYyUyMCU1Qm1haW4lNUQlMjAxLjFHJTBBRHJ5JTIwcnVuJTNBJTIwbm8lMjBmaWxlcyUyMHdlcmUlMjBkZWxldGVkLg==",highlighted:`➜ hf cache rm model/t5-small 8f3ad1c --dry-run
About to delete 1 repo(s) and 1 revision(s) totalling 1.1G.
  - model/t5-small:
      8f3ad1c [main] 1.1G
Dry run: no files were deleted.`,wrap:!1}}),_l=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHBydW5lJTBBQWJvdXQlMjB0byUyMGRlbGV0ZSUyMDMlMjB1bnJlZmVyZW5jZWQlMjByZXZpc2lvbihzKSUyMCgyLjRHJTIwdG90YWwpLiUwQSUyMCUyMC0lMjBtb2RlbCUyRnQ1LXNtYWxsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwMWM2MTBmNmIlMjAlNUJyZWZzJTJGcHIlMkYxJTVEJTIwODIwLjFNJTBBJTIwJTIwJTIwJTIwJTIwJTIwZDRlYzliNzIlMjAlNUIoZGV0YWNoZWQpJTVEJTIwNjQwLjVNJTBBJTIwJTIwLSUyMGRhdGFzZXQlMkZnb29nbGUlMkZmbGV1cnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAyYjkxYzhkZCUyMCU1QihkZXRhY2hlZCklNUQlMjA5MzcuNk0lMEFQcm9jZWVkJTNGJTIwJTVCeSUyRk4lNUQlM0ElMjB5JTBBRGVsZXRlZCUyMDMlMjB1bnJlZmVyZW5jZWQlMjByZXZpc2lvbihzKSUzQiUyMGZyZWVkJTIwMi40Ry4=",highlighted:`➜ hf cache prune
About to delete 3 unreferenced revision(s) (2.4G total).
  - model/t5-small:
      1c610f6b [refs/pr/1] 820.1M
      d4ec9b72 [(detached)] 640.5M
  - dataset/google/fleurs:
      2b91c8dd [(detached)] 937.6M
Proceed? [y/N]: y
Deleted 3 unreferenced revision(s); freed 2.4G.`,wrap:!1}}),Dl=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`,wrap:!1}}),Yl=new ai({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/manage-cache.md"}}),{c(){f=i("meta"),El=a(),Ll=i("p"),Vl=a(),c(I.$$.fragment),Wl=a(),c(j.$$.fragment),Sl=a(),u=i("p"),u.innerHTML=fa,Hl=a(),c(C.$$.fragment),zl=a(),g=i("p"),g.textContent=ya,Xl=a(),b=i("p"),b.textContent=wa,Pl=a(),c(A.$$.fragment),ql=a(),k=i("p"),k.innerHTML=ma,Kl=a(),N=i("p"),N.textContent=Ia,et=a(),c(v.$$.fragment),lt=a(),Z=i("p"),Z.textContent=ja,tt=a(),$=i("p"),$.textContent=ua,st=a(),c(x.$$.fragment),at=a(),Q=i("p"),Q.textContent=Ca,nt=a(),c(_.$$.fragment),it=a(),R=i("p"),R.innerHTML=ga,Tt=a(),O=i("p"),O.innerHTML=ba,Mt=a(),F=i("p"),F.innerHTML=Aa,ct=a(),c(D.$$.fragment),ot=a(),Y=i("p"),Y.innerHTML=ka,dt=a(),c(L.$$.fragment),ht=a(),G=i("p"),G.innerHTML=Na,Jt=a(),B=i("p"),B.innerHTML=va,rt=a(),E=i("p"),E.innerHTML=Za,Ut=a(),c(V.$$.fragment),pt=a(),W=i("p"),W.innerHTML=$a,ft=a(),S=i("p"),S.innerHTML=xa,yt=a(),c(H.$$.fragment),wt=a(),z=i("p"),z.innerHTML=Qa,mt=a(),c(X.$$.fragment),It=a(),P=i("p"),P.innerHTML=_a,jt=a(),q=i("p"),q.innerHTML=Ra,ut=a(),K=i("p"),K.innerHTML=Oa,Ct=a(),c(ee.$$.fragment),gt=a(),c(le.$$.fragment),bt=a(),te=i("p"),te.textContent=Fa,At=a(),c(se.$$.fragment),kt=a(),c(ae.$$.fragment),Nt=a(),ne=i("p"),ne.innerHTML=Da,vt=a(),ie=i("p"),ie.innerHTML=Ya,Zt=a(),Te=i("p"),Te.innerHTML=La,$t=a(),c(Me.$$.fragment),xt=a(),ce=i("p"),ce.innerHTML=Ga,Qt=a(),oe=i("p"),oe.innerHTML=Ba,_t=a(),c(de.$$.fragment),Rt=a(),he=i("p"),he.innerHTML=Ea,Ot=a(),Je=i("p"),Je.textContent=Va,Ft=a(),re=i("ul"),re.innerHTML=Wa,Dt=a(),Ue=i("p"),Ue.textContent=Sa,Yt=a(),pe=i("p"),pe.innerHTML=Ha,Lt=a(),c(fe.$$.fragment),Gt=a(),ye=i("p"),ye.innerHTML=za,Bt=a(),we=i("p"),we.innerHTML=Xa,Et=a(),c(me.$$.fragment),Vt=a(),Ie=i("p"),Ie.innerHTML=Pa,Wt=a(),je=i("p"),je.innerHTML=qa,St=a(),ue=i("p"),ue.innerHTML=Ka,Ht=a(),c(Ce.$$.fragment),zt=a(),ge=i("p"),ge.textContent=en,Xt=a(),c(be.$$.fragment),Pt=a(),Ae=i("p"),Ae.innerHTML=ln,qt=a(),ke=i("ul"),ke.innerHTML=tn,Kt=a(),Ne=i("p"),Ne.textContent=sn,es=a(),ve=i("p"),ve.textContent=an,ls=a(),c(Ze.$$.fragment),ts=a(),$e=i("p"),$e.textContent=nn,ss=a(),xe=i("p"),xe.innerHTML=Tn,as=a(),c(Qe.$$.fragment),ns=a(),_e=i("p"),_e.innerHTML=Mn,is=a(),Re=i("p"),Re.innerHTML=cn,Ts=a(),c(Oe.$$.fragment),Ms=a(),Fe=i("p"),Fe.innerHTML=on,cs=a(),De=i("p"),De.innerHTML=dn,os=a(),Ye=i("p"),Ye.innerHTML=hn,ds=a(),Le=i("p"),Le.innerHTML=Jn,hs=a(),c(Ge.$$.fragment),Js=a(),Be=i("p"),Be.innerHTML=rn,rs=a(),c(Ee.$$.fragment),Us=a(),Ve=i("p"),Ve.innerHTML=Un,ps=a(),c(We.$$.fragment),fs=a(),Se=i("blockquote"),Se.innerHTML=pn,ys=a(),c(He.$$.fragment),ws=a(),ze=i("p"),ze.textContent=fn,ms=a(),c(Xe.$$.fragment),Is=a(),c(Pe.$$.fragment),js=a(),c(qe.$$.fragment),us=a(),Ke=i("p"),Ke.innerHTML=yn,Cs=a(),el=i("p"),el.innerHTML=wn,gs=a(),ll=i("p"),ll.innerHTML=mn,bs=a(),c(tl.$$.fragment),As=a(),sl=i("p"),sl.innerHTML=In,ks=a(),c(al.$$.fragment),Ns=a(),nl=i("p"),nl.innerHTML=jn,vs=a(),il=i("p"),il.innerHTML=un,Zs=a(),Tl=i("p"),Tl.innerHTML=Cn,$s=a(),c(Ml.$$.fragment),xs=a(),cl=i("p"),cl.innerHTML=gn,Qs=a(),ol=i("p"),ol.innerHTML=bn,_s=a(),dl=i("p"),dl.textContent=An,Rs=a(),hl=i("ul"),hl.innerHTML=kn,Os=a(),Jl=i("p"),Jl.textContent=Nn,Fs=a(),c(rl.$$.fragment),Ds=a(),c(Ul.$$.fragment),Ys=a(),pl=i("p"),pl.innerHTML=vn,Ls=a(),c(fl.$$.fragment),Gs=a(),yl=i("p"),yl.textContent=Zn,Bs=a(),c(wl.$$.fragment),Es=a(),y=i("blockquote"),y.innerHTML=$n,Vs=a(),c(ml.$$.fragment),Ws=a(),Il=i("p"),Il.innerHTML=xn,Ss=a(),jl=i("p"),jl.innerHTML=Qn,Hs=a(),ul=i("p"),ul.innerHTML=_n,zs=a(),Cl=i("p"),Cl.textContent=Rn,Xs=a(),gl=i("ul"),gl.innerHTML=On,Ps=a(),w=i("blockquote"),w.innerHTML=Fn,qs=a(),m=i("blockquote"),m.innerHTML=Dn,Ks=a(),bl=i("p"),bl.innerHTML=Yn,ea=a(),Al=i("p"),Al.innerHTML=Ln,la=a(),c(kl.$$.fragment),ta=a(),Nl=i("p"),Nl.innerHTML=Gn,sa=a(),c(vl.$$.fragment),aa=a(),Zl=i("p"),Zl.innerHTML=Bn,na=a(),c($l.$$.fragment),ia=a(),xl=i("p"),xl.innerHTML=En,Ta=a(),Ql=i("p"),Ql.innerHTML=Vn,Ma=a(),c(_l.$$.fragment),ca=a(),Rl=i("p"),Rl.innerHTML=Wn,oa=a(),Ol=i("p"),Ol.innerHTML=Sn,da=a(),Fl=i("p"),Fl.innerHTML=Hn,ha=a(),c(Dl.$$.fragment),Ja=a(),c(Yl.$$.fragment),ra=a(),Gl=i("p"),this.h()},l(e){const l=li("svelte-u9bgzb",document.head);f=T(l,"META",{name:!0,content:!0}),l.forEach(t),El=n(e),Ll=T(e,"P",{}),zn(Ll).forEach(t),Vl=n(e),o(I.$$.fragment,e),Wl=n(e),o(j.$$.fragment,e),Sl=n(e),u=T(e,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1s3yler"&&(u.innerHTML=fa),Hl=n(e),o(C.$$.fragment,e),zl=n(e),g=T(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-7434pt"&&(g.textContent=ya),Xl=n(e),b=T(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-bm5pxs"&&(b.textContent=wa),Pl=n(e),o(A.$$.fragment,e),ql=n(e),k=T(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-lw0yzm"&&(k.innerHTML=ma),Kl=n(e),N=T(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1xsylbb"&&(N.textContent=Ia),et=n(e),o(v.$$.fragment,e),lt=n(e),Z=T(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-smirw4"&&(Z.textContent=ja),tt=n(e),$=T(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-hxzvg9"&&($.textContent=ua),st=n(e),o(x.$$.fragment,e),at=n(e),Q=T(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1o80jr1"&&(Q.textContent=Ca),nt=n(e),o(_.$$.fragment,e),it=n(e),R=T(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-z6cr2z"&&(R.innerHTML=ga),Tt=n(e),O=T(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-15cx8ge"&&(O.innerHTML=ba),Mt=n(e),F=T(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1u7b6sn"&&(F.innerHTML=Aa),ct=n(e),o(D.$$.fragment,e),ot=n(e),Y=T(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-9jec47"&&(Y.innerHTML=ka),dt=n(e),o(L.$$.fragment,e),ht=n(e),G=T(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1mswky"&&(G.innerHTML=Na),Jt=n(e),B=T(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1f9g1u2"&&(B.innerHTML=va),rt=n(e),E=T(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1ezxfdw"&&(E.innerHTML=Za),Ut=n(e),o(V.$$.fragment,e),pt=n(e),W=T(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-7nae39"&&(W.innerHTML=$a),ft=n(e),S=T(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-sjd8l1"&&(S.innerHTML=xa),yt=n(e),o(H.$$.fragment,e),wt=n(e),z=T(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-dxew1x"&&(z.innerHTML=Qa),mt=n(e),o(X.$$.fragment,e),It=n(e),P=T(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-f64xkc"&&(P.innerHTML=_a),jt=n(e),q=T(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-178rlr8"&&(q.innerHTML=Ra),ut=n(e),K=T(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-lua08t"&&(K.innerHTML=Oa),Ct=n(e),o(ee.$$.fragment,e),gt=n(e),o(le.$$.fragment,e),bt=n(e),te=T(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1cw24ss"&&(te.textContent=Fa),At=n(e),o(se.$$.fragment,e),kt=n(e),o(ae.$$.fragment,e),Nt=n(e),ne=T(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1foktgq"&&(ne.innerHTML=Da),vt=n(e),ie=T(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-x8ev9q"&&(ie.innerHTML=Ya),Zt=n(e),Te=T(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1ue61z6"&&(Te.innerHTML=La),$t=n(e),o(Me.$$.fragment,e),xt=n(e),ce=T(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-ewtcly"&&(ce.innerHTML=Ga),Qt=n(e),oe=T(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-o7am1f"&&(oe.innerHTML=Ba),_t=n(e),o(de.$$.fragment,e),Rt=n(e),he=T(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-15i0o7a"&&(he.innerHTML=Ea),Ot=n(e),Je=T(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-nj5twx"&&(Je.textContent=Va),Ft=n(e),re=T(e,"UL",{"data-svelte-h":!0}),M(re)!=="svelte-15a5775"&&(re.innerHTML=Wa),Dt=n(e),Ue=T(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-68d6zk"&&(Ue.textContent=Sa),Yt=n(e),pe=T(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1fqunt1"&&(pe.innerHTML=Ha),Lt=n(e),o(fe.$$.fragment,e),Gt=n(e),ye=T(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-hgwq07"&&(ye.innerHTML=za),Bt=n(e),we=T(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-im7pgk"&&(we.innerHTML=Xa),Et=n(e),o(me.$$.fragment,e),Vt=n(e),Ie=T(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-gkyc1z"&&(Ie.innerHTML=Pa),Wt=n(e),je=T(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-16gi99u"&&(je.innerHTML=qa),St=n(e),ue=T(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1nna80w"&&(ue.innerHTML=Ka),Ht=n(e),o(Ce.$$.fragment,e),zt=n(e),ge=T(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1shtud2"&&(ge.textContent=en),Xt=n(e),o(be.$$.fragment,e),Pt=n(e),Ae=T(e,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-h63bo"&&(Ae.innerHTML=ln),qt=n(e),ke=T(e,"UL",{"data-svelte-h":!0}),M(ke)!=="svelte-1sf7fpu"&&(ke.innerHTML=tn),Kt=n(e),Ne=T(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-5htz2c"&&(Ne.textContent=sn),es=n(e),ve=T(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-imyi1b"&&(ve.textContent=an),ls=n(e),o(Ze.$$.fragment,e),ts=n(e),$e=T(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1gjzgfe"&&($e.textContent=nn),ss=n(e),xe=T(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-1ced4p2"&&(xe.innerHTML=Tn),as=n(e),o(Qe.$$.fragment,e),ns=n(e),_e=T(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-wvh9oo"&&(_e.innerHTML=Mn),is=n(e),Re=T(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-o4afuj"&&(Re.innerHTML=cn),Ts=n(e),o(Oe.$$.fragment,e),Ms=n(e),Fe=T(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-1ki79zi"&&(Fe.innerHTML=on),cs=n(e),De=T(e,"P",{"data-svelte-h":!0}),M(De)!=="svelte-1qzo8xt"&&(De.innerHTML=dn),os=n(e),Ye=T(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-yngdyh"&&(Ye.innerHTML=hn),ds=n(e),Le=T(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-er0a1o"&&(Le.innerHTML=Jn),hs=n(e),o(Ge.$$.fragment,e),Js=n(e),Be=T(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-p22kya"&&(Be.innerHTML=rn),rs=n(e),o(Ee.$$.fragment,e),Us=n(e),Ve=T(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-1r0ndhn"&&(Ve.innerHTML=Un),ps=n(e),o(We.$$.fragment,e),fs=n(e),Se=T(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(Se)!=="svelte-1capgup"&&(Se.innerHTML=pn),ys=n(e),o(He.$$.fragment,e),ws=n(e),ze=T(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-1lsljsl"&&(ze.textContent=fn),ms=n(e),o(Xe.$$.fragment,e),Is=n(e),o(Pe.$$.fragment,e),js=n(e),o(qe.$$.fragment,e),us=n(e),Ke=T(e,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-1n21pft"&&(Ke.innerHTML=yn),Cs=n(e),el=T(e,"P",{"data-svelte-h":!0}),M(el)!=="svelte-2a98ae"&&(el.innerHTML=wn),gs=n(e),ll=T(e,"P",{"data-svelte-h":!0}),M(ll)!=="svelte-fyocup"&&(ll.innerHTML=mn),bs=n(e),o(tl.$$.fragment,e),As=n(e),sl=T(e,"P",{"data-svelte-h":!0}),M(sl)!=="svelte-13i0bg7"&&(sl.innerHTML=In),ks=n(e),o(al.$$.fragment,e),Ns=n(e),nl=T(e,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-1c1swfj"&&(nl.innerHTML=jn),vs=n(e),il=T(e,"P",{"data-svelte-h":!0}),M(il)!=="svelte-9g91kr"&&(il.innerHTML=un),Zs=n(e),Tl=T(e,"P",{"data-svelte-h":!0}),M(Tl)!=="svelte-1jgwyig"&&(Tl.innerHTML=Cn),$s=n(e),o(Ml.$$.fragment,e),xs=n(e),cl=T(e,"P",{"data-svelte-h":!0}),M(cl)!=="svelte-nzo9gl"&&(cl.innerHTML=gn),Qs=n(e),ol=T(e,"P",{"data-svelte-h":!0}),M(ol)!=="svelte-1bx4n8u"&&(ol.innerHTML=bn),_s=n(e),dl=T(e,"P",{"data-svelte-h":!0}),M(dl)!=="svelte-83019z"&&(dl.textContent=An),Rs=n(e),hl=T(e,"UL",{"data-svelte-h":!0}),M(hl)!=="svelte-qwuhrl"&&(hl.innerHTML=kn),Os=n(e),Jl=T(e,"P",{"data-svelte-h":!0}),M(Jl)!=="svelte-xp69b3"&&(Jl.textContent=Nn),Fs=n(e),o(rl.$$.fragment,e),Ds=n(e),o(Ul.$$.fragment,e),Ys=n(e),pl=T(e,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-16i2009"&&(pl.innerHTML=vn),Ls=n(e),o(fl.$$.fragment,e),Gs=n(e),yl=T(e,"P",{"data-svelte-h":!0}),M(yl)!=="svelte-1dcv4sb"&&(yl.textContent=Zn),Bs=n(e),o(wl.$$.fragment,e),Es=n(e),y=T(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(y)!=="svelte-fgblpb"&&(y.innerHTML=$n),Vs=n(e),o(ml.$$.fragment,e),Ws=n(e),Il=T(e,"P",{"data-svelte-h":!0}),M(Il)!=="svelte-3oea8m"&&(Il.innerHTML=xn),Ss=n(e),jl=T(e,"P",{"data-svelte-h":!0}),M(jl)!=="svelte-s9tc9t"&&(jl.innerHTML=Qn),Hs=n(e),ul=T(e,"P",{"data-svelte-h":!0}),M(ul)!=="svelte-1wode1b"&&(ul.innerHTML=_n),zs=n(e),Cl=T(e,"P",{"data-svelte-h":!0}),M(Cl)!=="svelte-19y0r7c"&&(Cl.textContent=Rn),Xs=n(e),gl=T(e,"UL",{"data-svelte-h":!0}),M(gl)!=="svelte-o7nsmh"&&(gl.innerHTML=On),Ps=n(e),w=T(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(w)!=="svelte-1ve8ddd"&&(w.innerHTML=Fn),qs=n(e),m=T(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(m)!=="svelte-p3c4og"&&(m.innerHTML=Dn),Ks=n(e),bl=T(e,"P",{"data-svelte-h":!0}),M(bl)!=="svelte-13xgrrb"&&(bl.innerHTML=Yn),ea=n(e),Al=T(e,"P",{"data-svelte-h":!0}),M(Al)!=="svelte-581am3"&&(Al.innerHTML=Ln),la=n(e),o(kl.$$.fragment,e),ta=n(e),Nl=T(e,"P",{"data-svelte-h":!0}),M(Nl)!=="svelte-x93r3r"&&(Nl.innerHTML=Gn),sa=n(e),o(vl.$$.fragment,e),aa=n(e),Zl=T(e,"P",{"data-svelte-h":!0}),M(Zl)!=="svelte-1m1mjoy"&&(Zl.innerHTML=Bn),na=n(e),o($l.$$.fragment,e),ia=n(e),xl=T(e,"P",{"data-svelte-h":!0}),M(xl)!=="svelte-r7ky4r"&&(xl.innerHTML=En),Ta=n(e),Ql=T(e,"P",{"data-svelte-h":!0}),M(Ql)!=="svelte-naqyn5"&&(Ql.innerHTML=Vn),Ma=n(e),o(_l.$$.fragment,e),ca=n(e),Rl=T(e,"P",{"data-svelte-h":!0}),M(Rl)!=="svelte-46np3h"&&(Rl.innerHTML=Wn),oa=n(e),Ol=T(e,"P",{"data-svelte-h":!0}),M(Ol)!=="svelte-1ayyols"&&(Ol.innerHTML=Sn),da=n(e),Fl=T(e,"P",{"data-svelte-h":!0}),M(Fl)!=="svelte-qm6d3g"&&(Fl.innerHTML=Hn),ha=n(e),o(Dl.$$.fragment,e),Ja=n(e),o(Yl.$$.fragment,e),ra=n(e),Gl=T(e,"P",{}),zn(Gl).forEach(t),this.h()},h(){Bl(f,"name","hf:doc:metadata"),Bl(f,"content",ii),Bl(y,"class","tip"),Bl(w,"class","tip"),Bl(m,"class","warning")},m(e,l){ti(document.head,f),s(e,El,l),s(e,Ll,l),s(e,Vl,l),d(I,e,l),s(e,Wl,l),d(j,e,l),s(e,Sl,l),s(e,u,l),s(e,Hl,l),d(C,e,l),s(e,zl,l),s(e,g,l),s(e,Xl,l),s(e,b,l),s(e,Pl,l),d(A,e,l),s(e,ql,l),s(e,k,l),s(e,Kl,l),s(e,N,l),s(e,et,l),d(v,e,l),s(e,lt,l),s(e,Z,l),s(e,tt,l),s(e,$,l),s(e,st,l),d(x,e,l),s(e,at,l),s(e,Q,l),s(e,nt,l),d(_,e,l),s(e,it,l),s(e,R,l),s(e,Tt,l),s(e,O,l),s(e,Mt,l),s(e,F,l),s(e,ct,l),d(D,e,l),s(e,ot,l),s(e,Y,l),s(e,dt,l),d(L,e,l),s(e,ht,l),s(e,G,l),s(e,Jt,l),s(e,B,l),s(e,rt,l),s(e,E,l),s(e,Ut,l),d(V,e,l),s(e,pt,l),s(e,W,l),s(e,ft,l),s(e,S,l),s(e,yt,l),d(H,e,l),s(e,wt,l),s(e,z,l),s(e,mt,l),d(X,e,l),s(e,It,l),s(e,P,l),s(e,jt,l),s(e,q,l),s(e,ut,l),s(e,K,l),s(e,Ct,l),d(ee,e,l),s(e,gt,l),d(le,e,l),s(e,bt,l),s(e,te,l),s(e,At,l),d(se,e,l),s(e,kt,l),d(ae,e,l),s(e,Nt,l),s(e,ne,l),s(e,vt,l),s(e,ie,l),s(e,Zt,l),s(e,Te,l),s(e,$t,l),d(Me,e,l),s(e,xt,l),s(e,ce,l),s(e,Qt,l),s(e,oe,l),s(e,_t,l),d(de,e,l),s(e,Rt,l),s(e,he,l),s(e,Ot,l),s(e,Je,l),s(e,Ft,l),s(e,re,l),s(e,Dt,l),s(e,Ue,l),s(e,Yt,l),s(e,pe,l),s(e,Lt,l),d(fe,e,l),s(e,Gt,l),s(e,ye,l),s(e,Bt,l),s(e,we,l),s(e,Et,l),d(me,e,l),s(e,Vt,l),s(e,Ie,l),s(e,Wt,l),s(e,je,l),s(e,St,l),s(e,ue,l),s(e,Ht,l),d(Ce,e,l),s(e,zt,l),s(e,ge,l),s(e,Xt,l),d(be,e,l),s(e,Pt,l),s(e,Ae,l),s(e,qt,l),s(e,ke,l),s(e,Kt,l),s(e,Ne,l),s(e,es,l),s(e,ve,l),s(e,ls,l),d(Ze,e,l),s(e,ts,l),s(e,$e,l),s(e,ss,l),s(e,xe,l),s(e,as,l),d(Qe,e,l),s(e,ns,l),s(e,_e,l),s(e,is,l),s(e,Re,l),s(e,Ts,l),d(Oe,e,l),s(e,Ms,l),s(e,Fe,l),s(e,cs,l),s(e,De,l),s(e,os,l),s(e,Ye,l),s(e,ds,l),s(e,Le,l),s(e,hs,l),d(Ge,e,l),s(e,Js,l),s(e,Be,l),s(e,rs,l),d(Ee,e,l),s(e,Us,l),s(e,Ve,l),s(e,ps,l),d(We,e,l),s(e,fs,l),s(e,Se,l),s(e,ys,l),d(He,e,l),s(e,ws,l),s(e,ze,l),s(e,ms,l),d(Xe,e,l),s(e,Is,l),d(Pe,e,l),s(e,js,l),d(qe,e,l),s(e,us,l),s(e,Ke,l),s(e,Cs,l),s(e,el,l),s(e,gs,l),s(e,ll,l),s(e,bs,l),d(tl,e,l),s(e,As,l),s(e,sl,l),s(e,ks,l),d(al,e,l),s(e,Ns,l),s(e,nl,l),s(e,vs,l),s(e,il,l),s(e,Zs,l),s(e,Tl,l),s(e,$s,l),d(Ml,e,l),s(e,xs,l),s(e,cl,l),s(e,Qs,l),s(e,ol,l),s(e,_s,l),s(e,dl,l),s(e,Rs,l),s(e,hl,l),s(e,Os,l),s(e,Jl,l),s(e,Fs,l),d(rl,e,l),s(e,Ds,l),d(Ul,e,l),s(e,Ys,l),s(e,pl,l),s(e,Ls,l),d(fl,e,l),s(e,Gs,l),s(e,yl,l),s(e,Bs,l),d(wl,e,l),s(e,Es,l),s(e,y,l),s(e,Vs,l),d(ml,e,l),s(e,Ws,l),s(e,Il,l),s(e,Ss,l),s(e,jl,l),s(e,Hs,l),s(e,ul,l),s(e,zs,l),s(e,Cl,l),s(e,Xs,l),s(e,gl,l),s(e,Ps,l),s(e,w,l),s(e,qs,l),s(e,m,l),s(e,Ks,l),s(e,bl,l),s(e,ea,l),s(e,Al,l),s(e,la,l),d(kl,e,l),s(e,ta,l),s(e,Nl,l),s(e,sa,l),d(vl,e,l),s(e,aa,l),s(e,Zl,l),s(e,na,l),d($l,e,l),s(e,ia,l),s(e,xl,l),s(e,Ta,l),s(e,Ql,l),s(e,Ma,l),d(_l,e,l),s(e,ca,l),s(e,Rl,l),s(e,oa,l),s(e,Ol,l),s(e,da,l),s(e,Fl,l),s(e,ha,l),d(Dl,e,l),s(e,Ja,l),d(Yl,e,l),s(e,ra,l),s(e,Gl,l),Ua=!0},p:Pn,i(e){Ua||(h(I.$$.fragment,e),h(j.$$.fragment,e),h(C.$$.fragment,e),h(A.$$.fragment,e),h(v.$$.fragment,e),h(x.$$.fragment,e),h(_.$$.fragment,e),h(D.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(me.$$.fragment,e),h(Ce.$$.fragment,e),h(be.$$.fragment,e),h(Ze.$$.fragment,e),h(Qe.$$.fragment,e),h(Oe.$$.fragment,e),h(Ge.$$.fragment,e),h(Ee.$$.fragment,e),h(We.$$.fragment,e),h(He.$$.fragment,e),h(Xe.$$.fragment,e),h(Pe.$$.fragment,e),h(qe.$$.fragment,e),h(tl.$$.fragment,e),h(al.$$.fragment,e),h(Ml.$$.fragment,e),h(rl.$$.fragment,e),h(Ul.$$.fragment,e),h(fl.$$.fragment,e),h(wl.$$.fragment,e),h(ml.$$.fragment,e),h(kl.$$.fragment,e),h(vl.$$.fragment,e),h($l.$$.fragment,e),h(_l.$$.fragment,e),h(Dl.$$.fragment,e),h(Yl.$$.fragment,e),Ua=!0)},o(e){J(I.$$.fragment,e),J(j.$$.fragment,e),J(C.$$.fragment,e),J(A.$$.fragment,e),J(v.$$.fragment,e),J(x.$$.fragment,e),J(_.$$.fragment,e),J(D.$$.fragment,e),J(L.$$.fragment,e),J(V.$$.fragment,e),J(H.$$.fragment,e),J(X.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(se.$$.fragment,e),J(ae.$$.fragment,e),J(Me.$$.fragment,e),J(de.$$.fragment,e),J(fe.$$.fragment,e),J(me.$$.fragment,e),J(Ce.$$.fragment,e),J(be.$$.fragment,e),J(Ze.$$.fragment,e),J(Qe.$$.fragment,e),J(Oe.$$.fragment,e),J(Ge.$$.fragment,e),J(Ee.$$.fragment,e),J(We.$$.fragment,e),J(He.$$.fragment,e),J(Xe.$$.fragment,e),J(Pe.$$.fragment,e),J(qe.$$.fragment,e),J(tl.$$.fragment,e),J(al.$$.fragment,e),J(Ml.$$.fragment,e),J(rl.$$.fragment,e),J(Ul.$$.fragment,e),J(fl.$$.fragment,e),J(wl.$$.fragment,e),J(ml.$$.fragment,e),J(kl.$$.fragment,e),J(vl.$$.fragment,e),J($l.$$.fragment,e),J(_l.$$.fragment,e),J(Dl.$$.fragment,e),J(Yl.$$.fragment,e),Ua=!1},d(e){e&&(t(El),t(Ll),t(Vl),t(Wl),t(Sl),t(u),t(Hl),t(zl),t(g),t(Xl),t(b),t(Pl),t(ql),t(k),t(Kl),t(N),t(et),t(lt),t(Z),t(tt),t($),t(st),t(at),t(Q),t(nt),t(it),t(R),t(Tt),t(O),t(Mt),t(F),t(ct),t(ot),t(Y),t(dt),t(ht),t(G),t(Jt),t(B),t(rt),t(E),t(Ut),t(pt),t(W),t(ft),t(S),t(yt),t(wt),t(z),t(mt),t(It),t(P),t(jt),t(q),t(ut),t(K),t(Ct),t(gt),t(bt),t(te),t(At),t(kt),t(Nt),t(ne),t(vt),t(ie),t(Zt),t(Te),t($t),t(xt),t(ce),t(Qt),t(oe),t(_t),t(Rt),t(he),t(Ot),t(Je),t(Ft),t(re),t(Dt),t(Ue),t(Yt),t(pe),t(Lt),t(Gt),t(ye),t(Bt),t(we),t(Et),t(Vt),t(Ie),t(Wt),t(je),t(St),t(ue),t(Ht),t(zt),t(ge),t(Xt),t(Pt),t(Ae),t(qt),t(ke),t(Kt),t(Ne),t(es),t(ve),t(ls),t(ts),t($e),t(ss),t(xe),t(as),t(ns),t(_e),t(is),t(Re),t(Ts),t(Ms),t(Fe),t(cs),t(De),t(os),t(Ye),t(ds),t(Le),t(hs),t(Js),t(Be),t(rs),t(Us),t(Ve),t(ps),t(fs),t(Se),t(ys),t(ws),t(ze),t(ms),t(Is),t(js),t(us),t(Ke),t(Cs),t(el),t(gs),t(ll),t(bs),t(As),t(sl),t(ks),t(Ns),t(nl),t(vs),t(il),t(Zs),t(Tl),t($s),t(xs),t(cl),t(Qs),t(ol),t(_s),t(dl),t(Rs),t(hl),t(Os),t(Jl),t(Fs),t(Ds),t(Ys),t(pl),t(Ls),t(Gs),t(yl),t(Bs),t(Es),t(y),t(Vs),t(Ws),t(Il),t(Ss),t(jl),t(Hs),t(ul),t(zs),t(Cl),t(Xs),t(gl),t(Ps),t(w),t(qs),t(m),t(Ks),t(bl),t(ea),t(Al),t(la),t(ta),t(Nl),t(sa),t(aa),t(Zl),t(na),t(ia),t(xl),t(Ta),t(Ql),t(Ma),t(ca),t(Rl),t(oa),t(Ol),t(da),t(Fl),t(ha),t(Ja),t(ra),t(Gl)),t(f),r(I,e),r(j,e),r(C,e),r(A,e),r(v,e),r(x,e),r(_,e),r(D,e),r(L,e),r(V,e),r(H,e),r(X,e),r(ee,e),r(le,e),r(se,e),r(ae,e),r(Me,e),r(de,e),r(fe,e),r(me,e),r(Ce,e),r(be,e),r(Ze,e),r(Qe,e),r(Oe,e),r(Ge,e),r(Ee,e),r(We,e),r(He,e),r(Xe,e),r(Pe,e),r(qe,e),r(tl,e),r(al,e),r(Ml,e),r(rl,e),r(Ul,e),r(fl,e),r(wl,e),r(ml,e),r(kl,e),r(vl,e),r($l,e),r(_l,e),r(Dl,e),r(Yl,e)}}}const ii='{"title":"Understand caching","local":"understand-caching","sections":[{"title":"File-based caching","local":"file-based-caching","sections":[{"title":"Refs","local":"refs","sections":[],"depth":3},{"title":"Blobs","local":"blobs","sections":[],"depth":3},{"title":"Snapshots","local":"snapshots","sections":[],"depth":3},{"title":".no_exist (advanced)","local":"noexist-advanced","sections":[],"depth":3},{"title":"In practice","local":"in-practice","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Chunk-based caching (Xet)","local":"chunk-based-caching-xet","sections":[{"title":"chunk_cache","local":"chunkcache","sections":[],"depth":3},{"title":"shard_cache","local":"shardcache","sections":[],"depth":3},{"title":"staging","local":"staging","sections":[],"depth":3},{"title":"Limits and Limitations","local":"limits-and-limitations","sections":[],"depth":3}],"depth":2},{"title":"Caching assets","local":"caching-assets","sections":[{"title":"Assets in practice","local":"assets-in-practice","sections":[],"depth":3}],"depth":2},{"title":"Manage your file-based cache","local":"manage-your-file-based-cache","sections":[{"title":"Inspect your cache","local":"inspect-your-cache","sections":[],"depth":3},{"title":"Verify your cache","local":"verify-your-cache","sections":[],"depth":3},{"title":"Clean your cache","local":"clean-your-cache","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ti(pa){return qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ji extends Kn{constructor(f){super(),ei(this,f,Ti,ni,Xn,{})}}export{Ji as component};
