import{s as Ca,n as Za,o as $a}from"../chunks/scheduler.0cf4ef2e.js";import{S as Ba,i as Ea,e as p,s as e,c,h as xa,a as i,d as a,b as n,f as Ua,g as h,j as M,k as Fs,l as Ia,m as t,n as r,t as d,o,p as j}from"../chunks/index.abc433bf.js";import{C as Ga}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as m}from"../chunks/CodeBlock.00dcd05e.js";import{H as y,E as Ra}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function Xa(Ss){let u,xl,Bl,Il,J,Gl,f,Rl,b,Vs=`The <code>huggingface_hub</code> library provides a Python interface to create, share, and update Model Cards.
Visit <a href="https://huggingface.co/docs/hub/models-cards" rel="nofollow">the dedicated documentation page</a>
for a deeper view of what Model Cards on the Hub are, and how they work under the hood.`,Xl,T,kl,U,Hs='To load an existing card from the Hub, you can use the <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.RepoCard.load">ModelCard.load()</a> function. Here, we’ll load the card from <a href="https://huggingface.co/nateraw/vit-base-beans" rel="nofollow"><code>nateraw/vit-base-beans</code></a>.',Yl,C,Al,Z,Ls="This card has some helpful attributes that you may want to access/leverage:",_l,$,zs='<li><code>card.data</code>: Returns a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> instance with the model card’s metadata. Call <code>.to_dict()</code> on this instance to get the representation as a dictionary.</li> <li><code>card.text</code>: Returns the text of the card, <em>excluding the metadata header</em>.</li> <li><code>card.content</code>: Returns the text content of the card, <em>including the metadata header</em>.</li>',vl,B,Wl,E,Nl,x,qs="To initialize a Model Card from text, just pass the text content of the card to the <code>ModelCard</code> on init.",Ql,I,Fl,G,Ds="Another way you might want to do this is with f-strings. In the following example, we:",Sl,R,Ps='<li>Use <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.CardData.to_yaml">ModelCardData.to_yaml()</a> to convert metadata we defined to YAML so we can use it to insert the YAML block in the model card.</li> <li>Show how you might use a template variable via Python f-strings.</li>',Vl,X,Hl,k,Ks="The above example would leave us with a card that looks like this:",Ll,Y,zl,A,ql,_,Os="If you have <code>Jinja2</code> installed, you can create Model Cards from a jinja template file. Let’s see a basic example:",Dl,v,Pl,W,la="The resulting card’s markdown looks like this:",Kl,N,Ol,Q,sa="If you update any card.data, it’ll reflect in the card itself.",ls,F,ss,S,aa="Now, as you can see, the metadata header has been updated:",as,V,ts,H,ta='As you update the card data, you can validate the card is still valid against the Hub by calling <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.RepoCard.validate">ModelCard.validate()</a>. This ensures that the card passes any validation rules set up on the Hugging Face Hub.',es,L,ns,z,ea='Instead of using your own template, you can also use the <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md" rel="nofollow">default template</a>, which is a fully featured model card with tons of sections you may want to fill out. Under the hood, it uses <a href="https://jinja.palletsprojects.com/en/3.1.x/" rel="nofollow">Jinja2</a> to fill out a template file.',ps,w,na="<p>Note that you will have to have Jinja2 installed to use <code>from_template</code>. You can do so with <code>pip install Jinja2</code>.</p>",is,q,Ms,D,cs,P,pa='If you’re authenticated with the Hugging Face Hub (either by using <code>hf auth login</code> or <a href="/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login">login()</a>), you can push cards to the Hub by simply calling <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.RepoCard.push_to_hub">ModelCard.push_to_hub()</a>. Let’s take a look at how to do that…',hs,K,ia="First, we’ll create a new repo called ‘hf-hub-modelcards-pr-test’ under the authenticated user’s namespace:",rs,O,ds,ll,Ma="Then, we’ll create a card from the default template (same as the one defined in the section above):",os,sl,js,al,ca="Finally, we’ll push that up to the hub",ms,tl,us,el,ha='You can check out the resulting card <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/blob/main/README.md" rel="nofollow">here</a>.',ys,nl,ra="If you instead wanted to push a card as a pull request, you can just say <code>create_pr=True</code> when calling <code>push_to_hub</code>:",ws,pl,gs,il,da='A resulting PR created from this command can be seen <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/discussions/3" rel="nofollow">here</a>.',Js,Ml,fs,cl,oa="In this section we will see what metadata are in repo cards and how to update them.",bs,hl,ja=`<code>metadata</code> refers to a hash map (or key value) context that provides some high-level information about a model, dataset or Space. That information can include details such as the model’s <code>pipeline type</code>, <code>model_id</code> or <code>model_description</code>. For more detail you can take a look to these guides: <a href="https://huggingface.co/docs/hub/model-cards#model-card-metadata" rel="nofollow">Model Card</a>, <a href="https://huggingface.co/docs/hub/datasets-cards#dataset-card-metadata" rel="nofollow">Dataset Card</a> and <a href="https://huggingface.co/docs/hub/spaces-settings#spaces-settings" rel="nofollow">Spaces Settings</a>.
Now lets see some examples on how to update those metadata.`,Ts,rl,ma="Let’s start with a first example:",Us,dl,Cs,ol,ua="With these two lines of code you will update the metadata to set a new <code>pipeline_tag</code>.",Zs,jl,ya=`By default, you cannot update a key that is already existing on the card. If you want to do so, you must pass
<code>overwrite=True</code> explicitly:`,$s,ml,Bs,ul,wa=`It often happens that you want to suggest some changes to a repository
on which you don’t have write permission. You can do that by creating a PR on that repo which will allow the owners to
review and merge your suggestions.`,Es,yl,xs,wl,Is,gl,ga='To include evaluation results in the metadata <code>model-index</code>, you can pass an <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.EvalResult">EvalResult</a> or a list of <code>EvalResult</code> with your associated evaluation results. Under the hood it’ll create the <code>model-index</code> when you call <code>card.data.to_dict()</code>. For more information on how this works, you can check out <a href="https://huggingface.co/docs/hub/models-cards#evaluation-results" rel="nofollow">this section of the Hub docs</a>.',Gs,g,Ja='<p>Note that using this function requires you to include the <code>model_name</code> attribute in <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a>.</p>',Rs,Jl,Xs,fl,fa="The resulting <code>card.data</code> should look like this:",ks,bl,Ys,Tl,ba="If you have more than one evaluation result you’d like to share, just pass a list of <code>EvalResult</code>:",As,Ul,_s,Cl,Ta="Which should leave you with the following <code>card.data</code>:",vs,Zl,Ws,$l,Ns,El,Qs;return J=new Ga({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new y({props:{title:"Create and share Model Cards",local:"create-and-share-model-cards",headingTag:"h1"}}),T=new y({props:{title:"Load a Model Card from the Hub",local:"load-a-model-card-from-the-hub",headingTag:"h2"}}),C=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQubG9hZCgnbmF0ZXJhdyUyRnZpdC1iYXNlLWJlYW5zJyk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard

card = ModelCard.load(<span class="hljs-string">&#x27;nateraw/vit-base-beans&#x27;</span>)`,wrap:!1}}),B=new y({props:{title:"Create Model Cards",local:"create-model-cards",headingTag:"h2"}}),E=new y({props:{title:"From Text",local:"from-text",headingTag:"h3"}}),I=new m({props:{code:"Y29udGVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQS0tLSUwQWxhbmd1YWdlJTNBJTIwZW4lMEFsaWNlbnNlJTNBJTIwbWl0JTBBLS0tJTBBJTBBJTIzJTIwTXklMjBNb2RlbCUyMENhcmQlMEElMjIlMjIlMjIlMEElMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkKGNvbnRlbnQpJTBBY2FyZC5kYXRhLnRvX2RpY3QoKSUyMCUzRCUzRCUyMCU3QidsYW5ndWFnZSclM0ElMjAnZW4nJTJDJTIwJ2xpY2Vuc2UnJTNBJTIwJ21pdCclN0QlMjAlMjAlMjMlMjBUcnVl",highlighted:`content = <span class="hljs-string">&quot;&quot;&quot;
---
language: en
license: mit
---

# My Model Card
&quot;&quot;&quot;</span>

card = ModelCard(content)
card.data.to_dict() == {<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>}  <span class="hljs-comment"># True</span>`,wrap:!1}}),X=new m({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5JTNEJ3RpbW0nKSUwQSUwQWV4YW1wbGVfdGVtcGxhdGVfdmFyJTIwJTNEJTIwJ25hdGVyYXcnJTBBY29udGVudCUyMCUzRCUyMGYlMjIlMjIlMjIlMEEtLS0lMEElN0IlMjBjYXJkX2RhdGEudG9feWFtbCgpJTIwJTdEJTBBLS0tJTBBJTBBJTIzJTIwTXklMjBNb2RlbCUyMENhcmQlMEElMEFUaGlzJTIwbW9kZWwlMjBjcmVhdGVkJTIwYnklMjAlNUIlNDAlN0JleGFtcGxlX3RlbXBsYXRlX3ZhciU3RCU1RChodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlN0JleGFtcGxlX3RlbXBsYXRlX3ZhciU3RCklMEElMjIlMjIlMjIlMEElMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkKGNvbnRlbnQpJTBBcHJpbnQoY2FyZCk=",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library=<span class="hljs-string">&#x27;timm&#x27;</span>)

example_template_var = <span class="hljs-string">&#x27;nateraw&#x27;</span>
content = <span class="hljs-string">f&quot;&quot;&quot;
---
<span class="hljs-subst">{ card_data.to_yaml() }</span>
---

# My Model Card

This model created by [@<span class="hljs-subst">{example_template_var}</span>](https://github.com/<span class="hljs-subst">{example_template_var}</span>)
&quot;&quot;&quot;</span>

card = ModelCard(content)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),Y=new m({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5JTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyME15JTIwTW9kZWwlMjBDYXJkJTBBJTBBVGhpcyUyMG1vZGVsJTIwY3JlYXRlZCUyMGJ5JTIwJTVCJTQwbmF0ZXJhdyU1RChodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZuYXRlcmF3KQ==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># My Model Card</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://github.com/nateraw)</span>`,wrap:!1}}),A=new y({props:{title:"From a Jinja Template",local:"from-a-jinja-template",headingTag:"h3"}}),v=new m({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEElMjMlMjBEZWZpbmUlMjB5b3VyJTIwamluamElMjB0ZW1wbGF0ZSUwQXRlbXBsYXRlX3RleHQlMjAlM0QlMjAlMjIlMjIlMjIlMEEtLS0lMEElN0IlN0IlMjBjYXJkX2RhdGElMjAlN0QlN0QlMEEtLS0lMEElMEElMjMlMjBNb2RlbCUyMENhcmQlMjBmb3IlMjBNeUNvb2xNb2RlbCUwQSUwQVRoaXMlMjBtb2RlbCUyMGRvZXMlMjB0aGlzJTIwYW5kJTIwdGhhdC4lMEElMEFUaGlzJTIwbW9kZWwlMjB3YXMlMjBjcmVhdGVkJTIwYnklMjAlNUIlNDAlN0IlN0IlMjBhdXRob3IlMjAlN0QlN0QlNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRiU3QiU3QmF1dGhvciU3RCU3RCkuJTBBJTIyJTIyJTIyLnN0cmlwKCklMEElMEElMjMlMjBXcml0ZSUyMHRoZSUyMHRlbXBsYXRlJTIwdG8lMjBhJTIwZmlsZSUwQVBhdGgoJ2N1c3RvbV90ZW1wbGF0ZS5tZCcpLndyaXRlX3RleHQodGVtcGxhdGVfdGV4dCklMEElMEElMjMlMjBEZWZpbmUlMjBjYXJkJTIwbWV0YWRhdGElMEFjYXJkX2RhdGElMjAlM0QlMjBNb2RlbENhcmREYXRhKGxhbmd1YWdlJTNEJ2VuJyUyQyUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUyMGxpYnJhcnlfbmFtZSUzRCdrZXJhcycpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY2FyZCUyMGZyb20lMjB0ZW1wbGF0ZSUyQyUyMHBhc3NpbmclMjBpdCUyMGFueSUyMGppbmphJTIwdGVtcGxhdGUlMjB2YXJpYWJsZXMlMjB5b3UlMjB3YW50LiUwQSUyMyUyMEluJTIwb3VyJTIwY2FzZSUyQyUyMHdlJ2xsJTIwcGFzcyUyMGF1dGhvciUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZShjYXJkX2RhdGElMkMlMjB0ZW1wbGF0ZV9wYXRoJTNEJ2N1c3RvbV90ZW1wbGF0ZS5tZCclMkMlMjBhdXRob3IlM0QnbmF0ZXJhdycpJTBBY2FyZC5zYXZlKCdteV9tb2RlbF9jYXJkXzEubWQnKSUwQXByaW50KGNhcmQp",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-comment"># Define your jinja template</span>
template_text = <span class="hljs-string">&quot;&quot;&quot;
---
{{ card_data }}
---

# Model Card for MyCoolModel

This model does this and that.

This model was created by [@{{ author }}](https://hf.co/{{author}}).
&quot;&quot;&quot;</span>.strip()

<span class="hljs-comment"># Write the template to a file</span>
Path(<span class="hljs-string">&#x27;custom_template.md&#x27;</span>).write_text(template_text)

<span class="hljs-comment"># Define card metadata</span>
card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)

<span class="hljs-comment"># Create card from template, passing it any jinja template variables you want.</span>
<span class="hljs-comment"># In our case, we&#x27;ll pass author</span>
card = ModelCard.from_template(card_data, template_path=<span class="hljs-string">&#x27;custom_template.md&#x27;</span>, author=<span class="hljs-string">&#x27;nateraw&#x27;</span>)
card.save(<span class="hljs-string">&#x27;my_model_card_1.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),N=new m({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5X25hbWUlM0ElMjBrZXJhcyUwQS0tLSUwQSUwQSUyMyUyME1vZGVsJTIwQ2FyZCUyMGZvciUyME15Q29vbE1vZGVsJTBBJTBBVGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0LiUwQSUwQVRoaXMlMjBtb2RlbCUyMHdhcyUyMGNyZWF0ZWQlMjBieSUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpLg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">keras</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># Model Card for MyCoolModel</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">does</span> <span class="hljs-string">this</span> <span class="hljs-string">and</span> <span class="hljs-string">that.</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">was</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw).</span>`,wrap:!1}}),F=new m({props:{code:"Y2FyZC5kYXRhLmxpYnJhcnlfbmFtZSUyMCUzRCUyMCd0aW1tJyUwQWNhcmQuZGF0YS5sYW5ndWFnZSUyMCUzRCUyMCdmciclMEFjYXJkLmRhdGEubGljZW5zZSUyMCUzRCUyMCdhcGFjaGUtMi4wJyUwQXByaW50KGNhcmQp",highlighted:`card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.library_name</span> = <span class="hljs-string">&#x27;timm&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.language</span> = <span class="hljs-string">&#x27;fr&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.license</span> = <span class="hljs-string">&#x27;apache-2.0&#x27;</span>
<span class="hljs-function"><span class="hljs-title">print</span><span class="hljs-params">(card)</span></span>`,wrap:!1}}),V=new m({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBmciUwQWxpY2Vuc2UlM0ElMjBhcGFjaGUtMi4wJTBBbGlicmFyeV9uYW1lJTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyME1vZGVsJTIwQ2FyZCUyMGZvciUyME15Q29vbE1vZGVsJTBBJTBBVGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0LiUwQSUwQVRoaXMlMjBtb2RlbCUyMHdhcyUyMGNyZWF0ZWQlMjBieSUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpLg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">fr</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">apache-2.0</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># Model Card for MyCoolModel</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">does</span> <span class="hljs-string">this</span> <span class="hljs-string">and</span> <span class="hljs-string">that.</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">was</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw).</span>`,wrap:!1}}),L=new y({props:{title:"From the Default Template",local:"from-the-default-template",headingTag:"h3"}}),q=new m({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEpJTBBY2FyZC5zYXZlKCdteV9tb2RlbF9jYXJkXzIubWQnKSUwQXByaW50KGNhcmQp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)
card.save(<span class="hljs-string">&#x27;my_model_card_2.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),D=new y({props:{title:"Share Model Cards",local:"share-model-cards",headingTag:"h2"}}),O=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdob2FtaSUyQyUyMGNyZWF0ZV9yZXBvJTBBJTBBdXNlciUyMCUzRCUyMHdob2FtaSgpJTVCJ25hbWUnJTVEJTBBcmVwb19pZCUyMCUzRCUyMGYnJTdCdXNlciU3RCUyRmhmLWh1Yi1tb2RlbGNhcmRzLXByLXRlc3QnJTBBdXJsJTIwJTNEJTIwY3JlYXRlX3JlcG8ocmVwb19pZCUyQyUyMGV4aXN0X29rJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> whoami, create_repo

user = whoami()[<span class="hljs-string">&#x27;name&#x27;</span>]
repo_id = <span class="hljs-string">f&#x27;<span class="hljs-subst">{user}</span>/hf-hub-modelcards-pr-test&#x27;</span>
url = create_repo(repo_id, exist_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),sl=new m({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)`,wrap:!1}}),tl=new m({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkKQ==",highlighted:"card.push_to_hub(repo_id)",wrap:!1}}),pl=new m({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:'card.push_to_hub(repo_id, create_pr=<span class="hljs-literal">True</span>)',wrap:!1}}),Ml=new y({props:{title:"Update metadata",local:"update-metadata",headingTag:"h2"}}),dl=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;image-classification&quot;</span>})`,wrap:!1}}),ml=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlN0QlMkMlMjBvdmVyd3JpdGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-generation&quot;</span>}, overwrite=<span class="hljs-literal">True</span>)`,wrap:!1}}),yl=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJzb21lb25lJTJGbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTdEJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;someone/model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-classification&quot;</span>}, create_pr=<span class="hljs-literal">True</span>)`,wrap:!1}}),wl=new y({props:{title:"Include Evaluation Results",local:"include-evaluation-results",headingTag:"h2"}}),Jl=new m({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjApJTBBKSUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZShjYXJkX2RhdGEpJTBBcHJpbnQoY2FyZC5kYXRhKQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = EvalResult(
        task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
        dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
        dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
        metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
        metric_value=<span class="hljs-number">0.7</span>
    )
)

card = ModelCard.from_template(card_data)
<span class="hljs-built_in">print</span>(card.data)`,wrap:!1}}),bl=new m({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>`,wrap:!1}}),Ul=new m({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdmMSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjY1JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkLmZyb21fdGVtcGxhdGUoY2FyZF9kYXRhKSUwQWNhcmQuZGF0YQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = [
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
            metric_value=<span class="hljs-number">0.7</span>
        ),
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;f1&#x27;</span>,
            metric_value=<span class="hljs-number">0.65</span>
        )
    ]
)
card = ModelCard.from_template(card_data)
card.data`,wrap:!1}}),Zl=new m({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43JTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBmMSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC42NQ==",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: f1</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.65</span>`,wrap:!1}}),$l=new Ra({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/model-cards.md"}}),{c(){u=p("meta"),xl=e(),Bl=p("p"),Il=e(),c(J.$$.fragment),Gl=e(),c(f.$$.fragment),Rl=e(),b=p("p"),b.innerHTML=Vs,Xl=e(),c(T.$$.fragment),kl=e(),U=p("p"),U.innerHTML=Hs,Yl=e(),c(C.$$.fragment),Al=e(),Z=p("p"),Z.textContent=Ls,_l=e(),$=p("ul"),$.innerHTML=zs,vl=e(),c(B.$$.fragment),Wl=e(),c(E.$$.fragment),Nl=e(),x=p("p"),x.innerHTML=qs,Ql=e(),c(I.$$.fragment),Fl=e(),G=p("p"),G.textContent=Ds,Sl=e(),R=p("ul"),R.innerHTML=Ps,Vl=e(),c(X.$$.fragment),Hl=e(),k=p("p"),k.textContent=Ks,Ll=e(),c(Y.$$.fragment),zl=e(),c(A.$$.fragment),ql=e(),_=p("p"),_.innerHTML=Os,Dl=e(),c(v.$$.fragment),Pl=e(),W=p("p"),W.textContent=la,Kl=e(),c(N.$$.fragment),Ol=e(),Q=p("p"),Q.textContent=sa,ls=e(),c(F.$$.fragment),ss=e(),S=p("p"),S.textContent=aa,as=e(),c(V.$$.fragment),ts=e(),H=p("p"),H.innerHTML=ta,es=e(),c(L.$$.fragment),ns=e(),z=p("p"),z.innerHTML=ea,ps=e(),w=p("blockquote"),w.innerHTML=na,is=e(),c(q.$$.fragment),Ms=e(),c(D.$$.fragment),cs=e(),P=p("p"),P.innerHTML=pa,hs=e(),K=p("p"),K.textContent=ia,rs=e(),c(O.$$.fragment),ds=e(),ll=p("p"),ll.textContent=Ma,os=e(),c(sl.$$.fragment),js=e(),al=p("p"),al.textContent=ca,ms=e(),c(tl.$$.fragment),us=e(),el=p("p"),el.innerHTML=ha,ys=e(),nl=p("p"),nl.innerHTML=ra,ws=e(),c(pl.$$.fragment),gs=e(),il=p("p"),il.innerHTML=da,Js=e(),c(Ml.$$.fragment),fs=e(),cl=p("p"),cl.textContent=oa,bs=e(),hl=p("p"),hl.innerHTML=ja,Ts=e(),rl=p("p"),rl.textContent=ma,Us=e(),c(dl.$$.fragment),Cs=e(),ol=p("p"),ol.innerHTML=ua,Zs=e(),jl=p("p"),jl.innerHTML=ya,$s=e(),c(ml.$$.fragment),Bs=e(),ul=p("p"),ul.textContent=wa,Es=e(),c(yl.$$.fragment),xs=e(),c(wl.$$.fragment),Is=e(),gl=p("p"),gl.innerHTML=ga,Gs=e(),g=p("blockquote"),g.innerHTML=Ja,Rs=e(),c(Jl.$$.fragment),Xs=e(),fl=p("p"),fl.innerHTML=fa,ks=e(),c(bl.$$.fragment),Ys=e(),Tl=p("p"),Tl.innerHTML=ba,As=e(),c(Ul.$$.fragment),_s=e(),Cl=p("p"),Cl.innerHTML=Ta,vs=e(),c(Zl.$$.fragment),Ws=e(),c($l.$$.fragment),Ns=e(),El=p("p"),this.h()},l(l){const s=xa("svelte-u9bgzb",document.head);u=i(s,"META",{name:!0,content:!0}),s.forEach(a),xl=n(l),Bl=i(l,"P",{}),Ua(Bl).forEach(a),Il=n(l),h(J.$$.fragment,l),Gl=n(l),h(f.$$.fragment,l),Rl=n(l),b=i(l,"P",{"data-svelte-h":!0}),M(b)!=="svelte-sb4v4f"&&(b.innerHTML=Vs),Xl=n(l),h(T.$$.fragment,l),kl=n(l),U=i(l,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1ezm0us"&&(U.innerHTML=Hs),Yl=n(l),h(C.$$.fragment,l),Al=n(l),Z=i(l,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-10yvqaf"&&(Z.textContent=Ls),_l=n(l),$=i(l,"UL",{"data-svelte-h":!0}),M($)!=="svelte-xs8zal"&&($.innerHTML=zs),vl=n(l),h(B.$$.fragment,l),Wl=n(l),h(E.$$.fragment,l),Nl=n(l),x=i(l,"P",{"data-svelte-h":!0}),M(x)!=="svelte-17iybkb"&&(x.innerHTML=qs),Ql=n(l),h(I.$$.fragment,l),Fl=n(l),G=i(l,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1i1nzes"&&(G.textContent=Ds),Sl=n(l),R=i(l,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-1a2t6et"&&(R.innerHTML=Ps),Vl=n(l),h(X.$$.fragment,l),Hl=n(l),k=i(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-azweip"&&(k.textContent=Ks),Ll=n(l),h(Y.$$.fragment,l),zl=n(l),h(A.$$.fragment,l),ql=n(l),_=i(l,"P",{"data-svelte-h":!0}),M(_)!=="svelte-w5ezj2"&&(_.innerHTML=Os),Dl=n(l),h(v.$$.fragment,l),Pl=n(l),W=i(l,"P",{"data-svelte-h":!0}),M(W)!=="svelte-186asy8"&&(W.textContent=la),Kl=n(l),h(N.$$.fragment,l),Ol=n(l),Q=i(l,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1uu9tt7"&&(Q.textContent=sa),ls=n(l),h(F.$$.fragment,l),ss=n(l),S=i(l,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1pjyyfy"&&(S.textContent=aa),as=n(l),h(V.$$.fragment,l),ts=n(l),H=i(l,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1d3izsf"&&(H.innerHTML=ta),es=n(l),h(L.$$.fragment,l),ns=n(l),z=i(l,"P",{"data-svelte-h":!0}),M(z)!=="svelte-bhtooo"&&(z.innerHTML=ea),ps=n(l),w=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(w)!=="svelte-1ja4awb"&&(w.innerHTML=na),is=n(l),h(q.$$.fragment,l),Ms=n(l),h(D.$$.fragment,l),cs=n(l),P=i(l,"P",{"data-svelte-h":!0}),M(P)!=="svelte-2cecz7"&&(P.innerHTML=pa),hs=n(l),K=i(l,"P",{"data-svelte-h":!0}),M(K)!=="svelte-4nym2l"&&(K.textContent=ia),rs=n(l),h(O.$$.fragment,l),ds=n(l),ll=i(l,"P",{"data-svelte-h":!0}),M(ll)!=="svelte-m495as"&&(ll.textContent=Ma),os=n(l),h(sl.$$.fragment,l),js=n(l),al=i(l,"P",{"data-svelte-h":!0}),M(al)!=="svelte-17rhkin"&&(al.textContent=ca),ms=n(l),h(tl.$$.fragment,l),us=n(l),el=i(l,"P",{"data-svelte-h":!0}),M(el)!=="svelte-1ecq7w8"&&(el.innerHTML=ha),ys=n(l),nl=i(l,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-1wkut12"&&(nl.innerHTML=ra),ws=n(l),h(pl.$$.fragment,l),gs=n(l),il=i(l,"P",{"data-svelte-h":!0}),M(il)!=="svelte-bvjuqo"&&(il.innerHTML=da),Js=n(l),h(Ml.$$.fragment,l),fs=n(l),cl=i(l,"P",{"data-svelte-h":!0}),M(cl)!=="svelte-1r8ornf"&&(cl.textContent=oa),bs=n(l),hl=i(l,"P",{"data-svelte-h":!0}),M(hl)!=="svelte-1k83g63"&&(hl.innerHTML=ja),Ts=n(l),rl=i(l,"P",{"data-svelte-h":!0}),M(rl)!=="svelte-1myl3lm"&&(rl.textContent=ma),Us=n(l),h(dl.$$.fragment,l),Cs=n(l),ol=i(l,"P",{"data-svelte-h":!0}),M(ol)!=="svelte-1tsl7te"&&(ol.innerHTML=ua),Zs=n(l),jl=i(l,"P",{"data-svelte-h":!0}),M(jl)!=="svelte-jfkfc6"&&(jl.innerHTML=ya),$s=n(l),h(ml.$$.fragment,l),Bs=n(l),ul=i(l,"P",{"data-svelte-h":!0}),M(ul)!=="svelte-189jrnw"&&(ul.textContent=wa),Es=n(l),h(yl.$$.fragment,l),xs=n(l),h(wl.$$.fragment,l),Is=n(l),gl=i(l,"P",{"data-svelte-h":!0}),M(gl)!=="svelte-w53c2y"&&(gl.innerHTML=ga),Gs=n(l),g=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(g)!=="svelte-zrrdmw"&&(g.innerHTML=Ja),Rs=n(l),h(Jl.$$.fragment,l),Xs=n(l),fl=i(l,"P",{"data-svelte-h":!0}),M(fl)!=="svelte-ejf86q"&&(fl.innerHTML=fa),ks=n(l),h(bl.$$.fragment,l),Ys=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),M(Tl)!=="svelte-1k9vy6l"&&(Tl.innerHTML=ba),As=n(l),h(Ul.$$.fragment,l),_s=n(l),Cl=i(l,"P",{"data-svelte-h":!0}),M(Cl)!=="svelte-12f1f8r"&&(Cl.innerHTML=Ta),vs=n(l),h(Zl.$$.fragment,l),Ws=n(l),h($l.$$.fragment,l),Ns=n(l),El=i(l,"P",{}),Ua(El).forEach(a),this.h()},h(){Fs(u,"name","hf:doc:metadata"),Fs(u,"content",ka),Fs(w,"class","tip"),Fs(g,"class","tip")},m(l,s){Ia(document.head,u),t(l,xl,s),t(l,Bl,s),t(l,Il,s),r(J,l,s),t(l,Gl,s),r(f,l,s),t(l,Rl,s),t(l,b,s),t(l,Xl,s),r(T,l,s),t(l,kl,s),t(l,U,s),t(l,Yl,s),r(C,l,s),t(l,Al,s),t(l,Z,s),t(l,_l,s),t(l,$,s),t(l,vl,s),r(B,l,s),t(l,Wl,s),r(E,l,s),t(l,Nl,s),t(l,x,s),t(l,Ql,s),r(I,l,s),t(l,Fl,s),t(l,G,s),t(l,Sl,s),t(l,R,s),t(l,Vl,s),r(X,l,s),t(l,Hl,s),t(l,k,s),t(l,Ll,s),r(Y,l,s),t(l,zl,s),r(A,l,s),t(l,ql,s),t(l,_,s),t(l,Dl,s),r(v,l,s),t(l,Pl,s),t(l,W,s),t(l,Kl,s),r(N,l,s),t(l,Ol,s),t(l,Q,s),t(l,ls,s),r(F,l,s),t(l,ss,s),t(l,S,s),t(l,as,s),r(V,l,s),t(l,ts,s),t(l,H,s),t(l,es,s),r(L,l,s),t(l,ns,s),t(l,z,s),t(l,ps,s),t(l,w,s),t(l,is,s),r(q,l,s),t(l,Ms,s),r(D,l,s),t(l,cs,s),t(l,P,s),t(l,hs,s),t(l,K,s),t(l,rs,s),r(O,l,s),t(l,ds,s),t(l,ll,s),t(l,os,s),r(sl,l,s),t(l,js,s),t(l,al,s),t(l,ms,s),r(tl,l,s),t(l,us,s),t(l,el,s),t(l,ys,s),t(l,nl,s),t(l,ws,s),r(pl,l,s),t(l,gs,s),t(l,il,s),t(l,Js,s),r(Ml,l,s),t(l,fs,s),t(l,cl,s),t(l,bs,s),t(l,hl,s),t(l,Ts,s),t(l,rl,s),t(l,Us,s),r(dl,l,s),t(l,Cs,s),t(l,ol,s),t(l,Zs,s),t(l,jl,s),t(l,$s,s),r(ml,l,s),t(l,Bs,s),t(l,ul,s),t(l,Es,s),r(yl,l,s),t(l,xs,s),r(wl,l,s),t(l,Is,s),t(l,gl,s),t(l,Gs,s),t(l,g,s),t(l,Rs,s),r(Jl,l,s),t(l,Xs,s),t(l,fl,s),t(l,ks,s),r(bl,l,s),t(l,Ys,s),t(l,Tl,s),t(l,As,s),r(Ul,l,s),t(l,_s,s),t(l,Cl,s),t(l,vs,s),r(Zl,l,s),t(l,Ws,s),r($l,l,s),t(l,Ns,s),t(l,El,s),Qs=!0},p:Za,i(l){Qs||(d(J.$$.fragment,l),d(f.$$.fragment,l),d(T.$$.fragment,l),d(C.$$.fragment,l),d(B.$$.fragment,l),d(E.$$.fragment,l),d(I.$$.fragment,l),d(X.$$.fragment,l),d(Y.$$.fragment,l),d(A.$$.fragment,l),d(v.$$.fragment,l),d(N.$$.fragment,l),d(F.$$.fragment,l),d(V.$$.fragment,l),d(L.$$.fragment,l),d(q.$$.fragment,l),d(D.$$.fragment,l),d(O.$$.fragment,l),d(sl.$$.fragment,l),d(tl.$$.fragment,l),d(pl.$$.fragment,l),d(Ml.$$.fragment,l),d(dl.$$.fragment,l),d(ml.$$.fragment,l),d(yl.$$.fragment,l),d(wl.$$.fragment,l),d(Jl.$$.fragment,l),d(bl.$$.fragment,l),d(Ul.$$.fragment,l),d(Zl.$$.fragment,l),d($l.$$.fragment,l),Qs=!0)},o(l){o(J.$$.fragment,l),o(f.$$.fragment,l),o(T.$$.fragment,l),o(C.$$.fragment,l),o(B.$$.fragment,l),o(E.$$.fragment,l),o(I.$$.fragment,l),o(X.$$.fragment,l),o(Y.$$.fragment,l),o(A.$$.fragment,l),o(v.$$.fragment,l),o(N.$$.fragment,l),o(F.$$.fragment,l),o(V.$$.fragment,l),o(L.$$.fragment,l),o(q.$$.fragment,l),o(D.$$.fragment,l),o(O.$$.fragment,l),o(sl.$$.fragment,l),o(tl.$$.fragment,l),o(pl.$$.fragment,l),o(Ml.$$.fragment,l),o(dl.$$.fragment,l),o(ml.$$.fragment,l),o(yl.$$.fragment,l),o(wl.$$.fragment,l),o(Jl.$$.fragment,l),o(bl.$$.fragment,l),o(Ul.$$.fragment,l),o(Zl.$$.fragment,l),o($l.$$.fragment,l),Qs=!1},d(l){l&&(a(xl),a(Bl),a(Il),a(Gl),a(Rl),a(b),a(Xl),a(kl),a(U),a(Yl),a(Al),a(Z),a(_l),a($),a(vl),a(Wl),a(Nl),a(x),a(Ql),a(Fl),a(G),a(Sl),a(R),a(Vl),a(Hl),a(k),a(Ll),a(zl),a(ql),a(_),a(Dl),a(Pl),a(W),a(Kl),a(Ol),a(Q),a(ls),a(ss),a(S),a(as),a(ts),a(H),a(es),a(ns),a(z),a(ps),a(w),a(is),a(Ms),a(cs),a(P),a(hs),a(K),a(rs),a(ds),a(ll),a(os),a(js),a(al),a(ms),a(us),a(el),a(ys),a(nl),a(ws),a(gs),a(il),a(Js),a(fs),a(cl),a(bs),a(hl),a(Ts),a(rl),a(Us),a(Cs),a(ol),a(Zs),a(jl),a($s),a(Bs),a(ul),a(Es),a(xs),a(Is),a(gl),a(Gs),a(g),a(Rs),a(Xs),a(fl),a(ks),a(Ys),a(Tl),a(As),a(_s),a(Cl),a(vs),a(Ws),a(Ns),a(El)),a(u),j(J,l),j(f,l),j(T,l),j(C,l),j(B,l),j(E,l),j(I,l),j(X,l),j(Y,l),j(A,l),j(v,l),j(N,l),j(F,l),j(V,l),j(L,l),j(q,l),j(D,l),j(O,l),j(sl,l),j(tl,l),j(pl,l),j(Ml,l),j(dl,l),j(ml,l),j(yl,l),j(wl,l),j(Jl,l),j(bl,l),j(Ul,l),j(Zl,l),j($l,l)}}}const ka='{"title":"Create and share Model Cards","local":"create-and-share-model-cards","sections":[{"title":"Load a Model Card from the Hub","local":"load-a-model-card-from-the-hub","sections":[],"depth":2},{"title":"Create Model Cards","local":"create-model-cards","sections":[{"title":"From Text","local":"from-text","sections":[],"depth":3},{"title":"From a Jinja Template","local":"from-a-jinja-template","sections":[],"depth":3},{"title":"From the Default Template","local":"from-the-default-template","sections":[],"depth":3}],"depth":2},{"title":"Share Model Cards","local":"share-model-cards","sections":[],"depth":2},{"title":"Update metadata","local":"update-metadata","sections":[],"depth":2},{"title":"Include Evaluation Results","local":"include-evaluation-results","sections":[],"depth":2}],"depth":1}';function Ya(Ss){return $a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends Ba{constructor(u){super(),Ea(this,u,Ya,Xa,Ca,{})}}export{Qa as component};
