import{s as ha,n as pa,o as ra}from"../chunks/scheduler.0cf4ef2e.js";import{S as ca,i as ua,e as o,s as l,c as p,h as ya,a as i,d as a,b as n,f as ia,g as r,j as h,k as Je,l as da,m as s,n as c,t as u,o as y,p as d}from"../chunks/index.abc433bf.js";import{C as ba}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as w}from"../chunks/CodeBlock.00dcd05e.js";import{H as b,E as wa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function ga($t){let g,Ue,Te,je,T,ve,k,Ie,U,Gt="Webhooks are a foundation for MLOps-related features. They allow you to listen for new changes on specific repos or to all repos belonging to particular users/organizations you’re interested in following. This guide will first explain how to manage webhooks programmatically. Then we’ll see how to leverage <code>huggingface_hub</code> to create a server listening to webhooks and deploy it to a Space.",We,j,Ct='This guide assumes you are familiar with the concept of webhooks on the Huggingface Hub. To learn more about webhooks themselves, you should read this <a href="https://huggingface.co/docs/hub/webhooks" rel="nofollow">guide</a> first.',Ze,v,$e,I,Bt="<code>huggingface_hub</code> allows you to manage your webhooks programmatically. You can list your existing webhooks, create new ones, and update, enable, disable or delete them. This section guides you through the procedures using the Hugging Face Hub’s API functions.",Ge,W,Ce,Z,_t='To create a new webhook, use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_webhook">create_webhook()</a> and specify the URL where payloads should be sent, what events should be watched, and optionally set a domain and a secret for security.',Be,$,_e,G,St=`A webhook can also trigger a Job to run on Hugging face infrastructure instead of sending the payload to an URL.
In this case you need to pass the ID of a source Job.`,Se,C,Ye,B,Yt=`The webhook triggers the Job with the webhook payload in the environment variable <code>WEBHOOK_PAYLOAD</code>.
For more information on Hugging Face Jobs, available hardware (CPU, GPU) and UV scripts, see the <a href="./jobs">Jobs documentation</a>.`,He,_,Ve,S,Ht='To see all the webhooks you have configured, you can list them with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_webhooks">list_webhooks()</a>. This is useful to review their IDs, URLs, and statuses.',Ee,Y,Qe,H,Xe,V,Vt='If you need to change the configuration of an existing webhook, such as the URL or the events it watches, you can update it using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_webhook">update_webhook()</a>.',Fe,E,Re,Q,qe,X,Et='You might want to temporarily disable a webhook without deleting it. This can be done using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.disable_webhook">disable_webhook()</a>, and the webhook can be re-enabled later with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.enable_webhook">enable_webhook()</a>.',xe,F,Le,R,Ne,q,Qt='When a webhook is no longer needed, it can be permanently deleted using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_webhook">delete_webhook()</a>.',ze,x,Ae,L,Pe,N,Xt=`The base class that we will use in this guides section is <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. It is a class for easily configuring a server that
can receive webhooks from the Huggingface Hub. The server is based on a <a href="https://gradio.app/" rel="nofollow">Gradio</a> app. It has a UI
to display instructions for you or your users and an API to listen to webhooks.`,De,M,Ft=`<p>To see a running example of a webhook server, check out the <a href="https://huggingface.co/spaces/spaces-ci-bot/webhook" rel="nofollow">Spaces CI Bot</a>
one. It is a Space that launches ephemeral environments when a PR is opened on a Space.</p>`,Oe,m,Rt=`<p>This is an <a href="../package_reference/environment_variables#hfhubdisableexperimentalwarning">experimental feature</a>. This
means that we are still working on improving the API. Breaking changes might be introduced in the future without prior
notice. Make sure to pin the version of <code>huggingface_hub</code> in your requirements.</p>`,Ke,z,et,A,qt=`Implementing a webhook endpoint is as simple as decorating a function. Let’s see a first example to explain the main
concepts:`,tt,P,at,D,xt="Save this snippet in a file called <code>&#39;app.py&#39;</code> and run it with <code>&#39;python app.py&#39;</code>. You should see a message like this:",st,O,lt,K,Lt="Good job! You just launched a webhook server! Let’s break down what happened exactly:",nt,ee,Nt=`<li>By decorating a function with <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.webhook_endpoint">webhook_endpoint()</a>, a <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object has been created in the background.
As you can see, this server is a Gradio app running on <a href="http://127.0.0.1:7860" rel="nofollow">http://127.0.0.1:7860</a>. If you open this URL in your browser, you
will see a landing page with instructions about the registered webhooks.</li> <li>A Gradio app is a FastAPI server under the hood. A new POST route <code>/webhooks/trigger_training</code> has been added to it.
This is the route that will listen to webhooks and run the <code>trigger_training</code> function when triggered. FastAPI will
automatically parse the payload and pass it to the function as a <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.WebhookPayload">WebhookPayload</a> object. This is a <code>pydantic</code> object
that contains all the information about the event that triggered the webhook.</li> <li>The Gradio app also opened a tunnel to receive requests from the internet. This is the interesting part: you can
configure a Webhook on <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a> pointing to your local machine. This is useful for
debugging your webhook server and quickly iterating before deploying it to a Space.</li> <li>Finally, the logs also tell you that your server is currently not secured by a secret. This is not problematic for
local debugging but is to keep in mind for later.</li>`,ot,f,zt=`<p>By default, the server is started at the end of your script. If you are running it in a notebook, you can start the
server manually by calling <code>decorated_function.run()</code>. Since a unique server is used, you only have to start the server
once even if you have multiple endpoints.</p>`,it,te,ht,ae,At=`Now that you have a webhook server running, you want to configure a Webhook to start receiving messages.
Go to <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>, click on “Add a new webhook” and configure your Webhook. Set the target
repositories you want to watch and the Webhook URL, here <code>https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training</code>.`,pt,J,Pt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/configure_webhook.png"/>',rt,se,Dt=`And that’s it! You can now trigger that webhook by updating the target repository (e.g. push a commit). Check the
Activity tab of your Webhook to see the events that have been triggered. Now that you have a working setup, you can
test it and quickly iterate. If you modify your code and restart the server, your public URL might change. Make sure
to update the webhook configuration on the Hub if needed.`,ct,le,ut,ne,Ot=`Now that you have a working webhook server, the goal is to deploy it to a Space. Go to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>
to create a Space. Give it a name, select the Gradio SDK and click on “Create Space”. Upload your code to the Space
in a file called <code>app.py</code>. Your Space will start automatically! For more details about Spaces, please refer to this
<a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">guide</a>.`,yt,oe,Kt=`Your webhook server is now running on a public Space. If most cases, you will want to secure it with a secret. Go to
your Space settings &gt; Section “Repository secrets” &gt; “Add a secret”. Set the <code>WEBHOOK_SECRET</code> environment variable to
the value of your choice. Go back to the <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Webhooks settings</a> and set the
secret in the webhook configuration. Now, only requests with the correct secret will be accepted by your server.`,dt,ie,ea=`And this is it! Your Space is now ready to receive webhooks from the Hub. Please keep in mind that if you run the Space
on a free ‘cpu-basic’ hardware, it will be shut down after 48 hours of inactivity. If you need a permanent Space, you
should consider setting to an <a href="https://huggingface.co/docs/hub/spaces-gpus#hardware-specs" rel="nofollow">upgraded hardware</a>.`,bt,he,wt,pe,ta=`The guide above explained the quickest way to setup a <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. In this section, we will see how to customize
it further.`,gt,re,Mt,ce,aa=`You can register multiple endpoints on the same server. For example, you might want to have one endpoint to trigger
a training job and another one to trigger a model evaluation. You can do this by adding multiple <code>@webhook_endpoint</code>
decorators:`,mt,ue,ft,ye,sa="Which will create two endpoints:",Jt,de,Tt,be,kt,we,la=`To get more flexibility, you can also create a <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object directly. This is useful if you want to
customize the landing page of your server. You can do this by passing a <a href="https://gradio.app/docs/#blocks" rel="nofollow">Gradio UI</a>
that will overwrite the default one. For example, you can add instructions for your users or add a form to manually
trigger the webhooks. When creating a <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>, you can register new webhooks using the
<code>add_webhook()</code> decorator.`,Ut,ge,na="Here is a complete example:",jt,Me,vt,me,oa=`<li>We define a custom UI using Gradio blocks. This UI will be displayed on the landing page of the server.</li> <li>We create a <a href="/docs/huggingface_hub/main/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object with a custom UI and a secret. The secret is optional and can be set with
the <code>WEBHOOK_SECRET</code> environment variable.</li> <li>We register a webhook with an explicit name. This will create an endpoint at <code>/webhooks/say_hello</code>.</li> <li>We register a webhook with an implicit name. This will create an endpoint at <code>/webhooks/goodbye</code>.</li> <li>We start the server. This is optional as your server will automatically be started at the end of the script.</li>`,It,fe,Wt,ke,Zt;return T=new ba({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),k=new b({props:{title:"Webhooks",local:"webhooks",headingTag:"h1"}}),v=new b({props:{title:"Managing Webhooks",local:"managing-webhooks",headingTag:"h2"}}),W=new b({props:{title:"Creating a Webhook",local:"creating-a-webhook",headingTag:"h3"}}),$=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMENyZWF0aW5nJTIwYSUyMHdlYmhvb2slMEF3ZWJob29rJTIwJTNEJTIwY3JlYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwdXJsJTNEJTIyaHR0cHMlM0ElMkYlMkZ3ZWJob29rLnNpdGUlMkZ5b3VyLWN1c3RvbS11cmwlMjIlMkMlMEElMjAlMjAlMjAlMjB3YXRjaGVkJTNEJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIyeW91ci11c2VybmFtZSUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIyeW91ci1vcmctbmFtZSUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTJDJTIwJTIyZGlzY3Vzc2lvbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldCUzRCUyMnlvdXItc2VjcmV0JTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook

<span class="hljs-comment"># Example: Creating a webhook</span>
webhook = create_webhook(
    url=<span class="hljs-string">&quot;https://webhook.site/your-custom-url&quot;</span>,
    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-username&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-org-name&quot;</span>}],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;your-secret&quot;</span>
)`,wrap:!1}}),C=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMENyZWF0aW5nJTIwYSUyMHdlYmhvb2slMjB0aGF0JTIwdHJpZ2dlcnMlMjBhJTIwSm9iJTBBd2ViaG9vayUyMCUzRCUyMGNyZWF0ZV93ZWJob29rKCUwQSUyMCUyMCUyMCUyMGpvYl9pZCUzRGpvYl9pZCUyQyUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJ5b3VyLXVzZXJuYW1lJTIyJTdEJTJDJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMm9yZyUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJ5b3VyLW9yZy1uYW1lJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwZG9tYWlucyUzRCU1QiUyMnJlcG8lMjIlMkMlMjAlMjJkaXNjdXNzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIyeW91ci1zZWNyZXQlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook

<span class="hljs-comment"># Example: Creating a webhook that triggers a Job</span>
webhook = create_webhook(
    job_id=job_id,
    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-username&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-org-name&quot;</span>}],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;your-secret&quot;</span>
)`,wrap:!1}}),_=new b({props:{title:"Listing Webhooks",local:"listing-webhooks",headingTag:"h3"}}),Y=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfd2ViaG9va3MlMEElMEElMjMlMjBFeGFtcGxlJTNBJTIwTGlzdGluZyUyMGFsbCUyMHdlYmhvb2tzJTBBd2ViaG9va3MlMjAlM0QlMjBsaXN0X3dlYmhvb2tzKCklMEFmb3IlMjB3ZWJob29rJTIwaW4lMjB3ZWJob29rcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHdlYmhvb2sp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_webhooks

<span class="hljs-comment"># Example: Listing all webhooks</span>
webhooks = list_webhooks()
<span class="hljs-keyword">for</span> webhook <span class="hljs-keyword">in</span> webhooks:
    <span class="hljs-built_in">print</span>(webhook)`,wrap:!1}}),H=new b({props:{title:"Updating a Webhook",local:"updating-a-webhook",headingTag:"h3"}}),E=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMFVwZGF0aW5nJTIwYSUyMHdlYmhvb2slMEF1cGRhdGVkX3dlYmhvb2slMjAlM0QlMjB1cGRhdGVfd2ViaG9vayglMEElMjAlMjAlMjAlMjB3ZWJob29rX2lkJTNEJTIyeW91ci13ZWJob29rLWlkJTIyJTJDJTBBJTIwJTIwJTIwJTIwdXJsJTNEJTIyaHR0cHMlM0ElMkYlMkZuZXcud2ViaG9vay5zaXRlJTJGdXJsJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2F0Y2hlZCUzRCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMm5ldy11c2VybmFtZSUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTVEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_webhook

<span class="hljs-comment"># Example: Updating a webhook</span>
updated_webhook = update_webhook(
    webhook_id=<span class="hljs-string">&quot;your-webhook-id&quot;</span>,
    url=<span class="hljs-string">&quot;https://new.webhook.site/url&quot;</span>,
    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;new-username&quot;</span>}],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>]
)`,wrap:!1}}),Q=new b({props:{title:"Enabling and Disabling Webhooks",local:"enabling-and-disabling-webhooks",headingTag:"h3"}}),F=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGVuYWJsZV93ZWJob29rJTJDJTIwZGlzYWJsZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMEVuYWJsaW5nJTIwYSUyMHdlYmhvb2slMEFlbmFibGVkX3dlYmhvb2slMjAlM0QlMjBlbmFibGVfd2ViaG9vayglMjJ5b3VyLXdlYmhvb2staWQlMjIpJTBBcHJpbnQoJTIyRW5hYmxlZCUzQSUyMiUyQyUyMGVuYWJsZWRfd2ViaG9vayklMEElMEElMjMlMjBFeGFtcGxlJTNBJTIwRGlzYWJsaW5nJTIwYSUyMHdlYmhvb2slMEFkaXNhYmxlZF93ZWJob29rJTIwJTNEJTIwZGlzYWJsZV93ZWJob29rKCUyMnlvdXItd2ViaG9vay1pZCUyMiklMEFwcmludCglMjJEaXNhYmxlZCUzQSUyMiUyQyUyMGRpc2FibGVkX3dlYmhvb2sp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> enable_webhook, disable_webhook

<span class="hljs-comment"># Example: Enabling a webhook</span>
enabled_webhook = enable_webhook(<span class="hljs-string">&quot;your-webhook-id&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Enabled:&quot;</span>, enabled_webhook)

<span class="hljs-comment"># Example: Disabling a webhook</span>
disabled_webhook = disable_webhook(<span class="hljs-string">&quot;your-webhook-id&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Disabled:&quot;</span>, disabled_webhook)`,wrap:!1}}),R=new b({props:{title:"Deleting a Webhook",local:"deleting-a-webhook",headingTag:"h3"}}),x=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMERlbGV0aW5nJTIwYSUyMHdlYmhvb2slMEFkZWxldGVfd2ViaG9vayglMjJ5b3VyLXdlYmhvb2staWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_webhook

<span class="hljs-comment"># Example: Deleting a webhook</span>
delete_webhook(<span class="hljs-string">&quot;your-webhook-id&quot;</span>)`,wrap:!1}}),L=new b({props:{title:"Webhooks Server",local:"webhooks-server",headingTag:"h2"}}),z=new b({props:{title:"Create an endpoint",local:"create-an-endpoint",headingTag:"h3"}}),P=new w({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...`,wrap:!1}}),O=new w({props:{code:"V2ViaG9vayUyMHNlY3JldCUyMGlzJTIwbm90JTIwZGVmaW5lZC4lMjBUaGlzJTIwbWVhbnMlMjB5b3VyJTIwd2ViaG9vayUyMGVuZHBvaW50cyUyMHdpbGwlMjBiZSUyMG9wZW4lMjB0byUyMGV2ZXJ5b25lLiUwQVRvJTIwYWRkJTIwYSUyMHNlY3JldCUyQyUyMHNldCUyMCU2MFdFQkhPT0tfU0VDUkVUJTYwJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwb3IlMjBwYXNzJTIwaXQlMjBhdCUyMGluaXRpYWxpemF0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTYwYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIod2ViaG9va19zZWNyZXQlM0QnbXlfc2VjcmV0JyUyQyUyMC4uLiklNjAlMEFGb3IlMjBtb3JlJTIwZGV0YWlscyUyMGFib3V0JTIwd2ViaG9vayUyMHNlY3JldHMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZ3ZWJob29rcyUyM3dlYmhvb2stc2VjcmV0LiUwQVJ1bm5pbmclMjBvbiUyMGxvY2FsJTIwVVJMJTNBJTIwJTIwaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTc4NjAlMEFSdW5uaW5nJTIwb24lMjBwdWJsaWMlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRjFmYWRiMGY1MmQ4YmY4MjVmYy5ncmFkaW8ubGl2ZSUwQSUwQVRoaXMlMjBzaGFyZSUyMGxpbmslMjBleHBpcmVzJTIwaW4lMjA3MiUyMGhvdXJzLiUyMEZvciUyMGZyZWUlMjBwZXJtYW5lbnQlMjBob3N0aW5nJTIwYW5kJTIwR1BVJTIwdXBncmFkZXMlMjAoTkVXISklMkMlMjBjaGVjayUyMG91dCUyMFNwYWNlcyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMEElMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEFHbyUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGd2ViaG9va3MlMjB0byUyMHNldHVwJTIweW91ciUyMHdlYmhvb2tzLg==",highlighted:`Webhook secret is not defined. This means your webhook endpoints will be open to everyone.
To add a secret, set \`WEBHOOK_SECRET\` as environment variable or pass it at initialization:
        \`app = WebhooksServer(webhook_secret=&#x27;my_secret&#x27;, ...)\`
For more details about webhook secrets, please refer to https://huggingface.co/docs/hub/webhooks#webhook-secret.
Running on local URL:  http://127.0.0.1:7860
Running on public URL: https://1fadb0f52d8bf825fc.gradio.live

This share link expires in 72 hours. For free permanent hosting and GPU upgrades (NEW!), check out Spaces: https://huggingface.co/spaces

Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
Go to https://huggingface.co/settings/webhooks to setup your webhooks.`,wrap:!1}}),te=new b({props:{title:"Configure a Webhook",local:"configure-a-webhook",headingTag:"h3"}}),le=new b({props:{title:"Deploy to a Space",local:"deploy-to-a-space",headingTag:"h3"}}),he=new b({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h3"}}),re=new b({props:{title:"Multiple endpoints",local:"multiple-endpoints",headingTag:"h4"}}),ue=new w({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTQwd2ViaG9va19lbmRwb2ludCUwQWFzeW5jJTIwZGVmJTIwdHJpZ2dlcl9ldmFsdWF0aW9uKHBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGF5bG9hZC5yZXBvLnR5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUyMGFuZCUyMHBheWxvYWQuZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTIwJTIydXBkYXRlJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVHJpZ2dlciUyMGFuJTIwZXZhbHVhdGlvbiUyMGpvYiUyMGlmJTIwYSUyMG1vZGVsJTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_evaluation</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger an evaluation job if a model is updated</span>
        ...`,wrap:!1}}),de=new w({props:{code:"KC4uLiklMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEElMjAlMjAtJTIwUE9TVCUyMGh0dHBzJTNBJTJGJTJGMWZhZGIwZjUyZDhiZjgyNWZjLmdyYWRpby5saXZlJTJGd2ViaG9va3MlMkZ0cmlnZ2VyX2V2YWx1YXRpb24=",highlighted:`(...)
Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_evaluation`,wrap:!1}}),be=new b({props:{title:"Custom server",local:"custom-server",headingTag:"h4"}}),Me=new w({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBXZWJob29rc1NlcnZlciUyQyUyMFdlYmhvb2tQYXlsb2FkJTBBJTBBJTIzJTIwMS4lMjBEZWZpbmUlMjAlMjBVSSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwdWklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMFdlYmhvb2tzU2VydmVyJTIwd2l0aCUyMGN1c3RvbSUyMFVJJTIwYW5kJTIwc2VjcmV0JTBBYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIodWklM0R1aSUyQyUyMHdlYmhvb2tfc2VjcmV0JTNEJTIybXlfc2VjcmV0X2tleSUyMiklMEElMEElMjMlMjAzLiUyMFJlZ2lzdGVyJTIwd2ViaG9vayUyMHdpdGglMjBleHBsaWNpdCUyMG5hbWUlMEElNDBhcHAuYWRkX3dlYmhvb2soJTIyJTJGc2F5X2hlbGxvJTIyKSUwQWFzeW5jJTIwZGVmJTIwaGVsbG8ocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJoZWxsbyUyMiU3RCUwQSUwQSUyMyUyMDQuJTIwUmVnaXN0ZXIlMjB3ZWJob29rJTIwd2l0aCUyMGltcGxpY2l0JTIwbmFtZSUwQSU0MGFwcC5hZGRfd2ViaG9vayUwQWFzeW5jJTIwZGVmJTIwZ29vZGJ5ZShwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybWVzc2FnZSUyMiUzQSUyMCUyMmdvb2RieWUlMjIlN0QlMEElMEElMjMlMjA1LiUyMFN0YXJ0JTIwc2VydmVyJTIwKG9wdGlvbmFsKSUwQWFwcC5ydW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> WebhooksServer, WebhookPayload

<span class="hljs-comment"># 1. Define  UI</span>
<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> ui:
    ...

<span class="hljs-comment"># 2. Create WebhooksServer with custom UI and secret</span>
app = WebhooksServer(ui=ui, webhook_secret=<span class="hljs-string">&quot;my_secret_key&quot;</span>)

<span class="hljs-comment"># 3. Register webhook with explicit name</span>
<span class="hljs-meta">@app.add_webhook(<span class="hljs-params"><span class="hljs-string">&quot;/say_hello&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">hello</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;hello&quot;</span>}

<span class="hljs-comment"># 4. Register webhook with implicit name</span>
<span class="hljs-meta">@app.add_webhook</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">goodbye</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;goodbye&quot;</span>}

<span class="hljs-comment"># 5. Start server (optional)</span>
app.run()`,wrap:!1}}),fe=new wa({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/webhooks.md"}}),{c(){g=o("meta"),Ue=l(),Te=o("p"),je=l(),p(T.$$.fragment),ve=l(),p(k.$$.fragment),Ie=l(),U=o("p"),U.innerHTML=Gt,We=l(),j=o("p"),j.innerHTML=Ct,Ze=l(),p(v.$$.fragment),$e=l(),I=o("p"),I.innerHTML=Bt,Ge=l(),p(W.$$.fragment),Ce=l(),Z=o("p"),Z.innerHTML=_t,Be=l(),p($.$$.fragment),_e=l(),G=o("p"),G.textContent=St,Se=l(),p(C.$$.fragment),Ye=l(),B=o("p"),B.innerHTML=Yt,He=l(),p(_.$$.fragment),Ve=l(),S=o("p"),S.innerHTML=Ht,Ee=l(),p(Y.$$.fragment),Qe=l(),p(H.$$.fragment),Xe=l(),V=o("p"),V.innerHTML=Vt,Fe=l(),p(E.$$.fragment),Re=l(),p(Q.$$.fragment),qe=l(),X=o("p"),X.innerHTML=Et,xe=l(),p(F.$$.fragment),Le=l(),p(R.$$.fragment),Ne=l(),q=o("p"),q.innerHTML=Qt,ze=l(),p(x.$$.fragment),Ae=l(),p(L.$$.fragment),Pe=l(),N=o("p"),N.innerHTML=Xt,De=l(),M=o("blockquote"),M.innerHTML=Ft,Oe=l(),m=o("blockquote"),m.innerHTML=Rt,Ke=l(),p(z.$$.fragment),et=l(),A=o("p"),A.textContent=qt,tt=l(),p(P.$$.fragment),at=l(),D=o("p"),D.innerHTML=xt,st=l(),p(O.$$.fragment),lt=l(),K=o("p"),K.textContent=Lt,nt=l(),ee=o("ol"),ee.innerHTML=Nt,ot=l(),f=o("blockquote"),f.innerHTML=zt,it=l(),p(te.$$.fragment),ht=l(),ae=o("p"),ae.innerHTML=At,pt=l(),J=o("div"),J.innerHTML=Pt,rt=l(),se=o("p"),se.textContent=Dt,ct=l(),p(le.$$.fragment),ut=l(),ne=o("p"),ne.innerHTML=Ot,yt=l(),oe=o("p"),oe.innerHTML=Kt,dt=l(),ie=o("p"),ie.innerHTML=ea,bt=l(),p(he.$$.fragment),wt=l(),pe=o("p"),pe.innerHTML=ta,gt=l(),p(re.$$.fragment),Mt=l(),ce=o("p"),ce.innerHTML=aa,mt=l(),p(ue.$$.fragment),ft=l(),ye=o("p"),ye.textContent=sa,Jt=l(),p(de.$$.fragment),Tt=l(),p(be.$$.fragment),kt=l(),we=o("p"),we.innerHTML=la,Ut=l(),ge=o("p"),ge.textContent=na,jt=l(),p(Me.$$.fragment),vt=l(),me=o("ol"),me.innerHTML=oa,It=l(),p(fe.$$.fragment),Wt=l(),ke=o("p"),this.h()},l(e){const t=ya("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(a),Ue=n(e),Te=i(e,"P",{}),ia(Te).forEach(a),je=n(e),r(T.$$.fragment,e),ve=n(e),r(k.$$.fragment,e),Ie=n(e),U=i(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-10vagzm"&&(U.innerHTML=Gt),We=n(e),j=i(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-p4l94c"&&(j.innerHTML=Ct),Ze=n(e),r(v.$$.fragment,e),$e=n(e),I=i(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-1ao4rts"&&(I.innerHTML=Bt),Ge=n(e),r(W.$$.fragment,e),Ce=n(e),Z=i(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-xo1ooa"&&(Z.innerHTML=_t),Be=n(e),r($.$$.fragment,e),_e=n(e),G=i(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1170rmm"&&(G.textContent=St),Se=n(e),r(C.$$.fragment,e),Ye=n(e),B=i(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1x0i2e2"&&(B.innerHTML=Yt),He=n(e),r(_.$$.fragment,e),Ve=n(e),S=i(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1cf3w2p"&&(S.innerHTML=Ht),Ee=n(e),r(Y.$$.fragment,e),Qe=n(e),r(H.$$.fragment,e),Xe=n(e),V=i(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-1rm71te"&&(V.innerHTML=Vt),Fe=n(e),r(E.$$.fragment,e),Re=n(e),r(Q.$$.fragment,e),qe=n(e),X=i(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-avpkbc"&&(X.innerHTML=Et),xe=n(e),r(F.$$.fragment,e),Le=n(e),r(R.$$.fragment,e),Ne=n(e),q=i(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1kldaew"&&(q.innerHTML=Qt),ze=n(e),r(x.$$.fragment,e),Ae=n(e),r(L.$$.fragment,e),Pe=n(e),N=i(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1qorj4p"&&(N.innerHTML=Xt),De=n(e),M=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(M)!=="svelte-n0nuoe"&&(M.innerHTML=Ft),Oe=n(e),m=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(m)!=="svelte-14rjnhk"&&(m.innerHTML=Rt),Ke=n(e),r(z.$$.fragment,e),et=n(e),A=i(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1dl6tkz"&&(A.textContent=qt),tt=n(e),r(P.$$.fragment,e),at=n(e),D=i(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-nkdywa"&&(D.innerHTML=xt),st=n(e),r(O.$$.fragment,e),lt=n(e),K=i(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-bjh0uv"&&(K.textContent=Lt),nt=n(e),ee=i(e,"OL",{"data-svelte-h":!0}),h(ee)!=="svelte-1ku5351"&&(ee.innerHTML=Nt),ot=n(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(f)!=="svelte-111d5gh"&&(f.innerHTML=zt),it=n(e),r(te.$$.fragment,e),ht=n(e),ae=i(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-febs9a"&&(ae.innerHTML=At),pt=n(e),J=i(e,"DIV",{class:!0,"data-svelte-h":!0}),h(J)!=="svelte-9ld38f"&&(J.innerHTML=Pt),rt=n(e),se=i(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-1sr65c9"&&(se.textContent=Dt),ct=n(e),r(le.$$.fragment,e),ut=n(e),ne=i(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-apq0kg"&&(ne.innerHTML=Ot),yt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-1h3f73"&&(oe.innerHTML=Kt),dt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1cxtt3c"&&(ie.innerHTML=ea),bt=n(e),r(he.$$.fragment,e),wt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-1shdkxc"&&(pe.innerHTML=ta),gt=n(e),r(re.$$.fragment,e),Mt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-gotrx0"&&(ce.innerHTML=aa),mt=n(e),r(ue.$$.fragment,e),ft=n(e),ye=i(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-o8x9sv"&&(ye.textContent=sa),Jt=n(e),r(de.$$.fragment,e),Tt=n(e),r(be.$$.fragment,e),kt=n(e),we=i(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-1lnz8cm"&&(we.innerHTML=la),Ut=n(e),ge=i(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-1plkp10"&&(ge.textContent=na),jt=n(e),r(Me.$$.fragment,e),vt=n(e),me=i(e,"OL",{"data-svelte-h":!0}),h(me)!=="svelte-134pmbq"&&(me.innerHTML=oa),It=n(e),r(fe.$$.fragment,e),Wt=n(e),ke=i(e,"P",{}),ia(ke).forEach(a),this.h()},h(){Je(g,"name","hf:doc:metadata"),Je(g,"content",Ma),Je(M,"class","tip"),Je(m,"class","warning"),Je(f,"class","warning"),Je(J,"class","flex justify-center")},m(e,t){da(document.head,g),s(e,Ue,t),s(e,Te,t),s(e,je,t),c(T,e,t),s(e,ve,t),c(k,e,t),s(e,Ie,t),s(e,U,t),s(e,We,t),s(e,j,t),s(e,Ze,t),c(v,e,t),s(e,$e,t),s(e,I,t),s(e,Ge,t),c(W,e,t),s(e,Ce,t),s(e,Z,t),s(e,Be,t),c($,e,t),s(e,_e,t),s(e,G,t),s(e,Se,t),c(C,e,t),s(e,Ye,t),s(e,B,t),s(e,He,t),c(_,e,t),s(e,Ve,t),s(e,S,t),s(e,Ee,t),c(Y,e,t),s(e,Qe,t),c(H,e,t),s(e,Xe,t),s(e,V,t),s(e,Fe,t),c(E,e,t),s(e,Re,t),c(Q,e,t),s(e,qe,t),s(e,X,t),s(e,xe,t),c(F,e,t),s(e,Le,t),c(R,e,t),s(e,Ne,t),s(e,q,t),s(e,ze,t),c(x,e,t),s(e,Ae,t),c(L,e,t),s(e,Pe,t),s(e,N,t),s(e,De,t),s(e,M,t),s(e,Oe,t),s(e,m,t),s(e,Ke,t),c(z,e,t),s(e,et,t),s(e,A,t),s(e,tt,t),c(P,e,t),s(e,at,t),s(e,D,t),s(e,st,t),c(O,e,t),s(e,lt,t),s(e,K,t),s(e,nt,t),s(e,ee,t),s(e,ot,t),s(e,f,t),s(e,it,t),c(te,e,t),s(e,ht,t),s(e,ae,t),s(e,pt,t),s(e,J,t),s(e,rt,t),s(e,se,t),s(e,ct,t),c(le,e,t),s(e,ut,t),s(e,ne,t),s(e,yt,t),s(e,oe,t),s(e,dt,t),s(e,ie,t),s(e,bt,t),c(he,e,t),s(e,wt,t),s(e,pe,t),s(e,gt,t),c(re,e,t),s(e,Mt,t),s(e,ce,t),s(e,mt,t),c(ue,e,t),s(e,ft,t),s(e,ye,t),s(e,Jt,t),c(de,e,t),s(e,Tt,t),c(be,e,t),s(e,kt,t),s(e,we,t),s(e,Ut,t),s(e,ge,t),s(e,jt,t),c(Me,e,t),s(e,vt,t),s(e,me,t),s(e,It,t),c(fe,e,t),s(e,Wt,t),s(e,ke,t),Zt=!0},p:pa,i(e){Zt||(u(T.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(W.$$.fragment,e),u($.$$.fragment,e),u(C.$$.fragment,e),u(_.$$.fragment,e),u(Y.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(R.$$.fragment,e),u(x.$$.fragment,e),u(L.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(he.$$.fragment,e),u(re.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(fe.$$.fragment,e),Zt=!0)},o(e){y(T.$$.fragment,e),y(k.$$.fragment,e),y(v.$$.fragment,e),y(W.$$.fragment,e),y($.$$.fragment,e),y(C.$$.fragment,e),y(_.$$.fragment,e),y(Y.$$.fragment,e),y(H.$$.fragment,e),y(E.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(R.$$.fragment,e),y(x.$$.fragment,e),y(L.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(he.$$.fragment,e),y(re.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(be.$$.fragment,e),y(Me.$$.fragment,e),y(fe.$$.fragment,e),Zt=!1},d(e){e&&(a(Ue),a(Te),a(je),a(ve),a(Ie),a(U),a(We),a(j),a(Ze),a($e),a(I),a(Ge),a(Ce),a(Z),a(Be),a(_e),a(G),a(Se),a(Ye),a(B),a(He),a(Ve),a(S),a(Ee),a(Qe),a(Xe),a(V),a(Fe),a(Re),a(qe),a(X),a(xe),a(Le),a(Ne),a(q),a(ze),a(Ae),a(Pe),a(N),a(De),a(M),a(Oe),a(m),a(Ke),a(et),a(A),a(tt),a(at),a(D),a(st),a(lt),a(K),a(nt),a(ee),a(ot),a(f),a(it),a(ht),a(ae),a(pt),a(J),a(rt),a(se),a(ct),a(ut),a(ne),a(yt),a(oe),a(dt),a(ie),a(bt),a(wt),a(pe),a(gt),a(Mt),a(ce),a(mt),a(ft),a(ye),a(Jt),a(Tt),a(kt),a(we),a(Ut),a(ge),a(jt),a(vt),a(me),a(It),a(Wt),a(ke)),a(g),d(T,e),d(k,e),d(v,e),d(W,e),d($,e),d(C,e),d(_,e),d(Y,e),d(H,e),d(E,e),d(Q,e),d(F,e),d(R,e),d(x,e),d(L,e),d(z,e),d(P,e),d(O,e),d(te,e),d(le,e),d(he,e),d(re,e),d(ue,e),d(de,e),d(be,e),d(Me,e),d(fe,e)}}}const Ma='{"title":"Webhooks","local":"webhooks","sections":[{"title":"Managing Webhooks","local":"managing-webhooks","sections":[{"title":"Creating a Webhook","local":"creating-a-webhook","sections":[],"depth":3},{"title":"Listing Webhooks","local":"listing-webhooks","sections":[],"depth":3},{"title":"Updating a Webhook","local":"updating-a-webhook","sections":[],"depth":3},{"title":"Enabling and Disabling Webhooks","local":"enabling-and-disabling-webhooks","sections":[],"depth":3},{"title":"Deleting a Webhook","local":"deleting-a-webhook","sections":[],"depth":3}],"depth":2},{"title":"Webhooks Server","local":"webhooks-server","sections":[{"title":"Create an endpoint","local":"create-an-endpoint","sections":[],"depth":3},{"title":"Configure a Webhook","local":"configure-a-webhook","sections":[],"depth":3},{"title":"Deploy to a Space","local":"deploy-to-a-space","sections":[],"depth":3},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Multiple endpoints","local":"multiple-endpoints","sections":[],"depth":4},{"title":"Custom server","local":"custom-server","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function ma($t){return ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ja extends ca{constructor(g){super(),ua(this,g,ma,ga,ha,{})}}export{ja as component};
