import{s as At,o as Zt,n as kt}from"../chunks/scheduler.0cf4ef2e.js";import{S as Wt,i as Bt,e as i,s as n,c as u,h as Nt,a as r,d as o,b as a,f as I,g as f,j as m,k as J,l as t,m as h,n as _,t as b,o as M,p as y}from"../chunks/index.abc433bf.js";import{C as Et}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{D as $}from"../chunks/Docstring.e4170f41.js";import{C as $t}from"../chunks/CodeBlock.00dcd05e.js";import{E as Ht}from"../chunks/ExampleCodeBlock.9d6d4e26.js";import{H as xe,E as Gt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function Vt(oe){let d,C="Example:",j,g,w;return g=new $t({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15Q3VzdG9tTW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTW9kZWxIdWJNaXhpbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMm15LWxpYnJhcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YWdzJTNEJTVCJTIyY29tcHV0ZXItdmlzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb191cmwlM0QlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm15LWNvb2wtbGlicmFyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcGVyX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMjMwNC4xMjI0NCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvY3NfdXJsJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZteS1jb29sLWxpYnJhcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlNUUlMjBvcHRpb25hbCUyMG1ldGFkYXRhJTIwdG8lMjBnZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwc2l6ZSUzQSUyMGludCUyMCUzRCUyMDUxMiUyQyUyMGRldmljZSUzQSUyMHN0ciUyMCUzRCUyMCUyMmNwdSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkZWZpbmUlMjBob3clMjB0byUyMGluaXRpYWxpemUlMjB5b3VyJTIwbW9kZWwlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkZWZpbmUlMjBob3clMjB0byUyMHNlcmlhbGl6ZSUyMHlvdXIlMjBtb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCU0MGNsYXNzbWV0aG9kJTBBJTIwJTIwJTIwJTIwZGVmJTIwZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNscyUzQSUyMHR5cGUlNUJUJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0ElMjBVbmlvbiU1QnN0ciUyQyUyMFBhdGglNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yY2VfZG93bmxvYWQlM0ElMjBib29sJTIwJTNEJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbiUzQSUyME9wdGlvbmFsJTVCVW5pb24lNUJzdHIlMkMlMjBib29sJTVEJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlX2RpciUzQSUyME9wdGlvbmFsJTVCVW5pb24lNUJzdHIlMkMlMjBQYXRoJTVEJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvY2FsX2ZpbGVzX29ubHklM0ElMjBib29sJTIwJTNEJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXZpc2lvbiUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqbW9kZWxfa3dhcmdzJTJDJTBBJTIwJTIwJTIwJTIwKSUyMC0lM0UlMjBUJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVmaW5lJTIwaG93JTIwdG8lMjBkZXNlcmlhbGl6ZSUyMHlvdXIlMjBtb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUwQW1vZGVsJTIwJTNEJTIwTXlDdXN0b21Nb2RlbChzaXplJTNEMjU2JTJDJTIwZGV2aWNlJTNEJTIyZ3B1JTIyKSUwQSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBcmVsb2FkZWRfbW9kZWwlMjAlM0QlMjBNeUN1c3RvbU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBcmVsb2FkZWRfbW9kZWwuc2l6ZSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBNb2RlbENhcmQlMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkLmxvYWQoJTIydXNlcm5hbWUlMkZteS1hd2Vzb21lLW1vZGVsJTIyKSUwQWNhcmQuZGF0YS50YWdzJTBBY2FyZC5kYXRhLmxpYnJhcnlfbmFtZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-comment"># Inherit from ModelHubMixin</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomModel</span>(
<span class="hljs-meta">... </span>        ModelHubMixin,
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;my-library&quot;</span>,
<span class="hljs-meta">... </span>        tags=[<span class="hljs-string">&quot;computer-vision&quot;</span>],
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/huggingface/my-cool-library&quot;</span>,
<span class="hljs-meta">... </span>        paper_url=<span class="hljs-string">&quot;https://arxiv.org/abs/2304.12244&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://huggingface.co/docs/my-cool-library&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to initialize your model</span>
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        ...
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to serialize your model</span>
<span class="hljs-meta">... </span>        ...
...
<span class="hljs-meta">... </span>    @<span class="hljs-built_in">classmethod</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">
<span class="hljs-meta">... </span>        cls: <span class="hljs-built_in">type</span>[T],
<span class="hljs-meta">... </span>        pretrained_model_name_or_path: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, Path],
<span class="hljs-meta">... </span>        *,
<span class="hljs-meta">... </span>        force_download: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        token: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>]] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        cache_dir: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, Path]] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        local_files_only: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        revision: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        **model_kwargs,
<span class="hljs-meta">... </span>    </span>) -&gt; T:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to deserialize your model</span>
<span class="hljs-meta">... </span>        ...

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyCustomModel(size=<span class="hljs-number">256</span>, device=<span class="hljs-string">&quot;gpu&quot;</span>)

<span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_model = MyCustomModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_model.size
<span class="hljs-number">256</span>

<span class="hljs-comment"># Model card has been correctly populated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.load(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.tags
[<span class="hljs-string">&quot;x-custom-tag&quot;</span>, <span class="hljs-string">&quot;pytorch_model_hub_mixin&quot;</span>, <span class="hljs-string">&quot;model_hub_mixin&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.library_name
<span class="hljs-string">&quot;my-library&quot;</span>`,wrap:!1}}),{c(){d=i("p"),d.textContent=C,j=n(),u(g.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=C),j=a(l),f(g.$$.fragment,l)},m(l,T){h(l,d,T),h(l,j,T),_(g,l,T),w=!0},p:kt,i(l){w||(b(g.$$.fragment,l),w=!0)},o(l){M(g.$$.fragment,l),w=!1},d(l){l&&(o(d),o(j)),y(g,l)}}}function zt(oe){let d,C="Example:",j,g,w;return g=new $t({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTW9kdWxlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X25hbWUlM0QlMjJrZXJhcy1ubHAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmtlcmFzLXRlYW0lMkZrZXJhcy1ubHAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXBlcl91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmFyeGl2Lm9yZyUyRmFicyUyRjIzMDQuMTIyNDQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb2NzX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGa2VyYXMuaW8lMkZrZXJhc19ubHAlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlNUUlMjBvcHRpb25hbCUyMG1ldGFkYXRhJTIwdG8lMjBnZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwaGlkZGVuX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA1MTIlMkMlMjB2b2NhYl9zaXplJTNBJTIwaW50JTIwJTNEJTIwMzAwMDAlMkMlMjBvdXRwdXRfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYXJhbSUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKGhpZGRlbl9zaXplJTJDJTIwdm9jYWJfc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIob3V0cHV0X3NpemUlMkMlMjB2b2NhYl9zaXplKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5saW5lYXIoeCUyMCUyQiUyMHNlbGYucGFyYW0pJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKGhpZGRlbl9zaXplJTNEMjU2KSUwQSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBbW9kZWwuaGlkZGVuX3NpemU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
<span class="hljs-meta">... </span>        nn.Module,
<span class="hljs-meta">... </span>        PyTorchModelHubMixin,
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/keras-team/keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        paper_url=<span class="hljs-string">&quot;https://arxiv.org/abs/2304.12244&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://keras.io/keras_nlp/&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">256</span>)

<span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.hidden_size
<span class="hljs-number">256</span>`,wrap:!1}}),{c(){d=i("p"),d.textContent=C,j=n(),u(g.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=C),j=a(l),f(g.$$.fragment,l)},m(l,T){h(l,d,T),h(l,j,T),_(g,l,T),w=!0},p:kt,i(l){w||(b(g.$$.fragment,l),w=!0)},o(l){M(g.$$.fragment,l),w=!1},d(l){l&&(o(d),o(j)),y(g,l)}}}function St(oe){let d,C,j,g,w,l,T,Ue,z,ve,S,pt=`The <code>huggingface_hub</code> library offers a range of mixins that can be used as a parent class for your objects, in order to
provide simple uploading and downloading functions. Check out our <a href="../guides/integrations">integration guide</a> to learn
how to integrate any ML framework with the Hub.`,Je,L,Ie,c,X,Ve,se,ht="A generic mixin to integrate ANY machine learning framework with the Hub.",ze,le,mt=`To integrate your framework, your model class must inherit from this class. Custom logic for saving/loading models
have to be overwritten in  <code>_from_pretrained</code> and <code>_save_pretrained</code>. <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a> is a good example
of mixin integration with the Hub. Check out our <a href="../guides/integrations">integration guide</a> for more instructions.`,Se,ie,gt=`When inheriting from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>, you can define class-level attributes. These attributes are not passed to
<code>__init__</code> but to the class definition itself. This is useful to define metadata about the library integrating
<a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.`,Le,re,ut='For more details on how to integrate the mixin with your library, checkout the <a href="../guides/integrations">integration guide</a>.',Xe,A,Qe,Z,Q,Fe,ce,ft=`Overwrite this method in subclass to define how to save your model.
Check out our <a href="../guides/integrations">integration guide</a> for instructions.`,Pe,v,F,Re,de,_t="Overwrite this method in subclass to define how to load your model from pretrained.",qe,pe,bt=`Use <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> to download files from the Hub before loading them. Most
args taken as input can be directly passed to those 2 methods. If needed, you can add more arguments to this
method using “model_kwargs”. For example <code>PyTorchModelHubMixin._from_pretrained()</code> takes as input a <code>map_location</code>
parameter to set on which device the model should be loaded.`,De,he,Mt='Check out our <a href="../guides/integrations">integration guide</a> for more instructions.',Ye,W,P,Oe,me,yt="Download a model from the Huggingface Hub and instantiate it.",Ke,H,R,et,ge,wt="Upload model checkpoint to the Hub.",tt,ue,jt=`Use <code>allow_patterns</code> and <code>ignore_patterns</code> to precisely filter which files should be pushed to the hub. Use
<code>delete_patterns</code> to delete existing remote files in the same commit. See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> reference for more
details.`,nt,B,q,at,fe,Tt="Save weights in local directory.",Ce,D,He,x,Y,ot,_e,xt=`Implementation of <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> to provide model Hub upload/download capabilities to PyTorch models. The model
is set in evaluation mode by default using <code>model.eval()</code> (dropout modules are deactivated). To train the model,
you should first set it back in training mode with <code>model.train()</code>.`,st,be,Ut='See <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> for more details on how to use the mixin.',lt,N,ke,O,$e,k,K,it,Me,vt="Load pretrained fastai model from the Hub or from a local directory.",Ae,U,ee,rt,ye,Jt="Upload learner checkpoint files to the Hub.",ct,we,It=`Use <em>allow_patterns</em> and <em>ignore_patterns</em> to precisely filter which files should be pushed to the hub. Use
<em>delete_patterns</em> to delete existing remote files in the same commit. See [<em>upload_folder</em>] reference for more
details.`,dt,te,Ct=`<p>Raises the following error:</p> <ul><li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><em>ValueError</em></a>
if the user is not log on to the Hugging Face Hub.</li></ul>`,Ze,ne,We,Te,Be;return w=new Et({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new xe({props:{title:"Mixins & serialization methods",local:"mixins--serialization-methods",headingTag:"h1"}}),z=new xe({props:{title:"Mixins",local:"mixins",headingTag:"h2"}}),L=new xe({props:{title:"Generic",local:"huggingface_hub.ModelHubMixin",headingTag:"h3"}}),X=new $({props:{name:"class huggingface_hub.ModelHubMixin",anchor:"huggingface_hub.ModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.repo_url",description:`<strong>repo_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the library repository. Used to generate model card.`,name:"repo_url"},{anchor:"huggingface_hub.ModelHubMixin.paper_url",description:`<strong>paper_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the library paper. Used to generate model card.`,name:"paper_url"},{anchor:"huggingface_hub.ModelHubMixin.docs_url",description:`<strong>docs_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the library documentation. Used to generate model card.`,name:"docs_url"},{anchor:"huggingface_hub.ModelHubMixin.model_card_template",description:`<strong>model_card_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Template of the model card. Used to generate model card. Defaults to a generic template.`,name:"model_card_template"},{anchor:"huggingface_hub.ModelHubMixin.language",description:`<strong>language</strong> (<code>str</code> or <code>list[str]</code>, <em>optional</em>) &#x2014;
Language supported by the library. Used to generate model card.`,name:"language"},{anchor:"huggingface_hub.ModelHubMixin.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the library integrating ModelHubMixin. Used to generate model card.`,name:"library_name"},{anchor:"huggingface_hub.ModelHubMixin.license",description:`<strong>license</strong> (<code>str</code>, <em>optional</em>) &#x2014;
License of the library integrating ModelHubMixin. Used to generate model card.
E.g: &#x201C;apache-2.0&#x201D;`,name:"license"},{anchor:"huggingface_hub.ModelHubMixin.license_name",description:`<strong>license_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the library integrating ModelHubMixin. Used to generate model card.
Only used if <code>license</code> is set to <code>other</code>.
E.g: &#x201C;coqui-public-model-license&#x201D;.`,name:"license_name"},{anchor:"huggingface_hub.ModelHubMixin.license_link",description:`<strong>license_link</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL to the license of the library integrating ModelHubMixin. Used to generate model card.
Only used if <code>license</code> is set to <code>other</code> and <code>license_name</code> is set.
E.g: &#x201D;<a href="https://coqui.ai/cpml%22" rel="nofollow">https://coqui.ai/cpml&#x201D;</a>.`,name:"license_link"},{anchor:"huggingface_hub.ModelHubMixin.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Tag of the pipeline. Used to generate model card. E.g. &#x201C;text-classification&#x201D;.`,name:"pipeline_tag"},{anchor:"huggingface_hub.ModelHubMixin.tags",description:`<strong>tags</strong> (<code>list[str]</code>, <em>optional</em>) &#x2014;
Tags to be added to the model card. Used to generate model card. E.g. [&#x201C;computer-vision&#x201D;]`,name:"tags"},{anchor:"huggingface_hub.ModelHubMixin.coders",description:`<strong>coders</strong> (<code>dict[Type, tuple[Callable, Callable]]</code>, <em>optional</em>) &#x2014;
Dictionary of custom types and their encoders/decoders. Used to encode/decode arguments that are not
jsonable by default. E.g. dataclasses, argparse.Namespace, OmegaConf, etc.`,name:"coders"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L76"}}),A=new Ht({props:{anchor:"huggingface_hub.ModelHubMixin.example",$$slots:{default:[Vt]},$$scope:{ctx:oe}}}),Q=new $({props:{name:"_save_pretrained",anchor:"huggingface_hub.ModelHubMixin._save_pretrained",parameters:[{name:"save_directory",val:": Path"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L449"}}),F=new $({props:{name:"_from_pretrained",anchor:"huggingface_hub.ModelHubMixin._from_pretrained",parameters:[{name:"model_id",val:": str"},{name:"revision",val:": typing.Optional[str]"},{name:"cache_dir",val:": typing.Union[str, pathlib.Path, NoneType]"},{name:"force_download",val:": bool"},{name:"local_files_only",val:": bool"},{name:"token",val:": typing.Union[str, bool, NoneType]"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
ID of the model to load from the Huggingface Hub (e.g. <code>bigscience/bloom</code>).`,name:"model_id"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id. Defaults to the
latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>hf auth login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.model_kwargs",description:`<strong>model_kwargs</strong> &#x2014;
Additional keyword arguments passed along to the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a> method.`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L576"}}),P=new $({props:{name:"from_pretrained",anchor:"huggingface_hub.ModelHubMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"force_download",val:": bool = False"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"cache_dir",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"local_files_only",val:": bool = False"},{name:"revision",val:": typing.Optional[str] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code>, <code>Path</code>) &#x2014;
<ul>
<li>Either the <code>model_id</code> (string) of a model hosted on the Hub, e.g. <code>bigscience/bloom</code>.</li>
<li>Or a path to a <code>directory</code> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g., <code>../path/to/my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id.
Defaults to the latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>hf auth login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional kwargs to pass to the model during initialization.`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L460"}}),R=new $({props:{name:"push_to_hub",anchor:"huggingface_hub.ModelHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"config",val:": typing.Union[dict, huggingface_hub.hub_mixin.DataclassInstance, NoneType] = None"},{name:"commit_message",val:": str = 'Push model using huggingface_hub.'"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"branch",val:": typing.Optional[str] = None"},{name:"create_pr",val:": typing.Optional[bool] = None"},{name:"allow_patterns",val:": typing.Union[list[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[list[str], str, NoneType] = None"},{name:"delete_patterns",val:": typing.Union[list[str], str, NoneType] = None"},{name:"model_card_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repository to push to (example: <code>&quot;username/my-model&quot;</code>).`,name:"repo_id"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.config",description:`<strong>config</strong> (<code>dict</code> or <code>DataclassInstance</code>, <em>optional</em>) &#x2014;
Model configuration specified as a key/value dictionary or a dataclass instance.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository created should be private.
If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private.`,name:"private"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>hf auth login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to <code>&quot;main&quot;</code>.`,name:"branch"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>branch</code> with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.allow_patterns",description:`<strong>allow_patterns</strong> (<code>list[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>list[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.delete_patterns",description:`<strong>delete_patterns</strong> (<code>list[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.model_card_kwargs",description:`<strong>model_card_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments passed to the model card template to customize the model card.`,name:"model_card_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),q=new $({props:{name:"save_pretrained",anchor:"huggingface_hub.ModelHubMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, pathlib.Path]"},{name:"config",val:": typing.Union[dict, huggingface_hub.hub_mixin.DataclassInstance, NoneType] = None"},{name:"repo_id",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"model_card_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"**push_to_hub_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.config",description:`<strong>config</strong> (<code>dict</code> or <code>DataclassInstance</code>, <em>optional</em>) &#x2014;
Model configuration specified as a key/value dictionary or a dataclass instance.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Huggingface Hub after saving it.`,name:"push_to_hub"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of your repository on the Hub. Used only if <code>push_to_hub=True</code>. Will default to the folder name if
not provided.`,name:"repo_id"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.model_card_kwargs",description:`<strong>model_card_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments passed to the model card template to customize the model card.`,name:"model_card_kwargs"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.push_to_hub_kwargs",description:`<strong>push_to_hub_kwargs</strong> &#x2014;
Additional key word arguments passed along to the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"push_to_hub_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url of the commit on the Hub if <code>push_to_hub=True</code>, <code>None</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>None</code></p>
`}}),D=new xe({props:{title:"PyTorch",local:"huggingface_hub.PyTorchModelHubMixin",headingTag:"h3"}}),Y=new $({props:{name:"class huggingface_hub.PyTorchModelHubMixin",anchor:"huggingface_hub.PyTorchModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L701"}}),N=new Ht({props:{anchor:"huggingface_hub.PyTorchModelHubMixin.example",$$slots:{default:[zt]},$$scope:{ctx:oe}}}),O=new xe({props:{title:"Fastai",local:"huggingface_hub.from_pretrained_fastai",headingTag:"h3"}}),K=new $({props:{name:"huggingface_hub.from_pretrained_fastai",anchor:"huggingface_hub.from_pretrained_fastai",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.from_pretrained_fastai.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The location where the pickled fastai.Learner is. It can be either of the two:
<ul>
<li>Hosted on the Hugging Face Hub. E.g.: &#x2018;espejelomar/fatai-pet-breeds-classification&#x2019; or &#x2018;distilgpt2&#x2019;.
You can add a <code>revision</code> by appending <code>@</code> at the end of <code>repo_id</code>. E.g.: <code>dbmdz/bert-base-german-cased@main</code>.
Revision is the specific model version to use. Since we use a git-based system for storing models and other
artifacts on the Hugging Face Hub, it can be a branch name, a tag name, or a commit id.</li>
<li>Hosted locally. <code>repo_id</code> would be a directory containing the pickle and a pyproject.toml
indicating the fastai and fastcore versions used to build the <code>fastai.Learner</code>. E.g.: <code>./my_model_directory/</code>.</li>
</ul>`,name:"repo_id"},{anchor:"huggingface_hub.from_pretrained_fastai.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision at which the repo&#x2019;s files are downloaded. See documentation of <code>snapshot_download</code>.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/fastai_utils.py#L289",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>fastai.Learner</code> model in the <code>repo_id</code> repo.</p>
`}}),ee=new $({props:{name:"huggingface_hub.push_to_hub_fastai",anchor:"huggingface_hub.push_to_hub_fastai",parameters:[{name:"learner",val:""},{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Push FastAI model using huggingface_hub.'"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"config",val:": typing.Optional[dict] = None"},{name:"branch",val:": typing.Optional[str] = None"},{name:"create_pr",val:": typing.Optional[bool] = None"},{name:"allow_patterns",val:": typing.Union[list[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[list[str], str, NoneType] = None"},{name:"delete_patterns",val:": typing.Union[list[str], str, NoneType] = None"},{name:"api_endpoint",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.push_to_hub_fastai.learner",description:`<strong>learner</strong> (<em>Learner</em>) &#x2014;
The *fastai.Learner&#x2019; you&#x2019;d like to push to the Hub.`,name:"learner"},{anchor:"huggingface_hub.push_to_hub_fastai.repo_id",description:`<strong>repo_id</strong> (<em>str</em>) &#x2014;
The repository id for your model in Hub in the format of &#x201C;namespace/repo_name&#x201D;. The namespace can be your individual account or an organization to which you have write access (for example, &#x2018;stanfordnlp/stanza-de&#x2019;).`,name:"repo_id"},{anchor:"huggingface_hub.push_to_hub_fastai.commit_message",description:"<strong>commit_message</strong> (<em>str`, </em>optional*) &#x2014; Message to commit while pushing. Will default to <code>&quot;add model&quot;</code>.",name:"commit_message"},{anchor:"huggingface_hub.push_to_hub_fastai.private",description:`<strong>private</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.
If <em>None</em> (default), will default to been public except if the organization&#x2019;s default is private.`,name:"private"},{anchor:"huggingface_hub.push_to_hub_fastai.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The Hugging Face account token to use as HTTP bearer authorization for remote files. If <code>None</code>, the token will be asked by a prompt.`,name:"token"},{anchor:"huggingface_hub.push_to_hub_fastai.config",description:`<strong>config</strong> (<em>dict</em>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.push_to_hub_fastai.branch",description:`<strong>branch</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to
the default branch as specified in your repository, which
defaults to <em>&#x201C;main&#x201D;</em>.`,name:"branch"},{anchor:"huggingface_hub.push_to_hub_fastai.create_pr",description:`<strong>create_pr</strong> (<em>boolean</em>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <em>branch</em> with that commit.
Defaults to <em>False</em>.`,name:"create_pr"},{anchor:"huggingface_hub.push_to_hub_fastai.api_endpoint",description:`<strong>api_endpoint</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.push_to_hub_fastai.allow_patterns",description:`<strong>allow_patterns</strong> (<em>list[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.ignore_patterns",description:`<strong>ignore_patterns</strong> (<em>list[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.delete_patterns",description:`<strong>delete_patterns</strong> (<em>list[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/fastai_utils.py#L334",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),ne=new Gt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/mixins.md"}}),{c(){d=i("meta"),C=n(),j=i("p"),g=n(),u(w.$$.fragment),l=n(),u(T.$$.fragment),Ue=n(),u(z.$$.fragment),ve=n(),S=i("p"),S.innerHTML=pt,Je=n(),u(L.$$.fragment),Ie=n(),c=i("div"),u(X.$$.fragment),Ve=n(),se=i("p"),se.textContent=ht,ze=n(),le=i("p"),le.innerHTML=mt,Se=n(),ie=i("p"),ie.innerHTML=gt,Le=n(),re=i("p"),re.innerHTML=ut,Xe=n(),u(A.$$.fragment),Qe=n(),Z=i("div"),u(Q.$$.fragment),Fe=n(),ce=i("p"),ce.innerHTML=ft,Pe=n(),v=i("div"),u(F.$$.fragment),Re=n(),de=i("p"),de.textContent=_t,qe=n(),pe=i("p"),pe.innerHTML=bt,De=n(),he=i("p"),he.innerHTML=Mt,Ye=n(),W=i("div"),u(P.$$.fragment),Oe=n(),me=i("p"),me.textContent=yt,Ke=n(),H=i("div"),u(R.$$.fragment),et=n(),ge=i("p"),ge.textContent=wt,tt=n(),ue=i("p"),ue.innerHTML=jt,nt=n(),B=i("div"),u(q.$$.fragment),at=n(),fe=i("p"),fe.textContent=Tt,Ce=n(),u(D.$$.fragment),He=n(),x=i("div"),u(Y.$$.fragment),ot=n(),_e=i("p"),_e.innerHTML=xt,st=n(),be=i("p"),be.innerHTML=Ut,lt=n(),u(N.$$.fragment),ke=n(),u(O.$$.fragment),$e=n(),k=i("div"),u(K.$$.fragment),it=n(),Me=i("p"),Me.textContent=vt,Ae=n(),U=i("div"),u(ee.$$.fragment),rt=n(),ye=i("p"),ye.textContent=Jt,ct=n(),we=i("p"),we.innerHTML=It,dt=n(),te=i("blockquote"),te.innerHTML=Ct,Ze=n(),u(ne.$$.fragment),We=n(),Te=i("p"),this.h()},l(e){const s=Nt("svelte-u9bgzb",document.head);d=r(s,"META",{name:!0,content:!0}),s.forEach(o),C=a(e),j=r(e,"P",{}),I(j).forEach(o),g=a(e),f(w.$$.fragment,e),l=a(e),f(T.$$.fragment,e),Ue=a(e),f(z.$$.fragment,e),ve=a(e),S=r(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-by7ppc"&&(S.innerHTML=pt),Je=a(e),f(L.$$.fragment,e),Ie=a(e),c=r(e,"DIV",{class:!0});var p=I(c);f(X.$$.fragment,p),Ve=a(p),se=r(p,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1q74itk"&&(se.textContent=ht),ze=a(p),le=r(p,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1g82wpt"&&(le.innerHTML=mt),Se=a(p),ie=r(p,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-llbfhb"&&(ie.innerHTML=gt),Le=a(p),re=r(p,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1gs2y95"&&(re.innerHTML=ut),Xe=a(p),f(A.$$.fragment,p),Qe=a(p),Z=r(p,"DIV",{class:!0});var ae=I(Z);f(Q.$$.fragment,ae),Fe=a(ae),ce=r(ae,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1fdydm0"&&(ce.innerHTML=ft),ae.forEach(o),Pe=a(p),v=r(p,"DIV",{class:!0});var E=I(v);f(F.$$.fragment,E),Re=a(E),de=r(E,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1totzue"&&(de.textContent=_t),qe=a(E),pe=r(E,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-90qthw"&&(pe.innerHTML=bt),De=a(E),he=r(E,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1xccgfy"&&(he.innerHTML=Mt),E.forEach(o),Ye=a(p),W=r(p,"DIV",{class:!0});var Ne=I(W);f(P.$$.fragment,Ne),Oe=a(Ne),me=r(Ne,"P",{"data-svelte-h":!0}),m(me)!=="svelte-ydwjgk"&&(me.textContent=yt),Ne.forEach(o),Ke=a(p),H=r(p,"DIV",{class:!0});var je=I(H);f(R.$$.fragment,je),et=a(je),ge=r(je,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-skcyeb"&&(ge.textContent=wt),tt=a(je),ue=r(je,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-mlktc5"&&(ue.innerHTML=jt),je.forEach(o),nt=a(p),B=r(p,"DIV",{class:!0});var Ee=I(B);f(q.$$.fragment,Ee),at=a(Ee),fe=r(Ee,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-usyekl"&&(fe.textContent=Tt),Ee.forEach(o),p.forEach(o),Ce=a(e),f(D.$$.fragment,e),He=a(e),x=r(e,"DIV",{class:!0});var G=I(x);f(Y.$$.fragment,G),ot=a(G),_e=r(G,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1gq77ie"&&(_e.innerHTML=xt),st=a(G),be=r(G,"P",{"data-svelte-h":!0}),m(be)!=="svelte-f7arwt"&&(be.innerHTML=Ut),lt=a(G),f(N.$$.fragment,G),G.forEach(o),ke=a(e),f(O.$$.fragment,e),$e=a(e),k=r(e,"DIV",{class:!0});var Ge=I(k);f(K.$$.fragment,Ge),it=a(Ge),Me=r(Ge,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1fexh91"&&(Me.textContent=vt),Ge.forEach(o),Ae=a(e),U=r(e,"DIV",{class:!0});var V=I(U);f(ee.$$.fragment,V),rt=a(V),ye=r(V,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-18c83zg"&&(ye.textContent=Jt),ct=a(V),we=r(V,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1jbgd9l"&&(we.innerHTML=It),dt=a(V),te=r(V,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(te)!=="svelte-8anwqt"&&(te.innerHTML=Ct),V.forEach(o),Ze=a(e),f(ne.$$.fragment,e),We=a(e),Te=r(e,"P",{}),I(Te).forEach(o),this.h()},h(){J(d,"name","hf:doc:metadata"),J(d,"content",Lt),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(te,"class","tip"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,d),h(e,C,s),h(e,j,s),h(e,g,s),_(w,e,s),h(e,l,s),_(T,e,s),h(e,Ue,s),_(z,e,s),h(e,ve,s),h(e,S,s),h(e,Je,s),_(L,e,s),h(e,Ie,s),h(e,c,s),_(X,c,null),t(c,Ve),t(c,se),t(c,ze),t(c,le),t(c,Se),t(c,ie),t(c,Le),t(c,re),t(c,Xe),_(A,c,null),t(c,Qe),t(c,Z),_(Q,Z,null),t(Z,Fe),t(Z,ce),t(c,Pe),t(c,v),_(F,v,null),t(v,Re),t(v,de),t(v,qe),t(v,pe),t(v,De),t(v,he),t(c,Ye),t(c,W),_(P,W,null),t(W,Oe),t(W,me),t(c,Ke),t(c,H),_(R,H,null),t(H,et),t(H,ge),t(H,tt),t(H,ue),t(c,nt),t(c,B),_(q,B,null),t(B,at),t(B,fe),h(e,Ce,s),_(D,e,s),h(e,He,s),h(e,x,s),_(Y,x,null),t(x,ot),t(x,_e),t(x,st),t(x,be),t(x,lt),_(N,x,null),h(e,ke,s),_(O,e,s),h(e,$e,s),h(e,k,s),_(K,k,null),t(k,it),t(k,Me),h(e,Ae,s),h(e,U,s),_(ee,U,null),t(U,rt),t(U,ye),t(U,ct),t(U,we),t(U,dt),t(U,te),h(e,Ze,s),_(ne,e,s),h(e,We,s),h(e,Te,s),Be=!0},p(e,[s]){const p={};s&2&&(p.$$scope={dirty:s,ctx:e}),A.$set(p);const ae={};s&2&&(ae.$$scope={dirty:s,ctx:e}),N.$set(ae)},i(e){Be||(b(w.$$.fragment,e),b(T.$$.fragment,e),b(z.$$.fragment,e),b(L.$$.fragment,e),b(X.$$.fragment,e),b(A.$$.fragment,e),b(Q.$$.fragment,e),b(F.$$.fragment,e),b(P.$$.fragment,e),b(R.$$.fragment,e),b(q.$$.fragment,e),b(D.$$.fragment,e),b(Y.$$.fragment,e),b(N.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(ne.$$.fragment,e),Be=!0)},o(e){M(w.$$.fragment,e),M(T.$$.fragment,e),M(z.$$.fragment,e),M(L.$$.fragment,e),M(X.$$.fragment,e),M(A.$$.fragment,e),M(Q.$$.fragment,e),M(F.$$.fragment,e),M(P.$$.fragment,e),M(R.$$.fragment,e),M(q.$$.fragment,e),M(D.$$.fragment,e),M(Y.$$.fragment,e),M(N.$$.fragment,e),M(O.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),Be=!1},d(e){e&&(o(C),o(j),o(g),o(l),o(Ue),o(ve),o(S),o(Je),o(Ie),o(c),o(Ce),o(He),o(x),o(ke),o($e),o(k),o(Ae),o(U),o(Ze),o(We),o(Te)),o(d),y(w,e),y(T,e),y(z,e),y(L,e),y(X),y(A),y(Q),y(F),y(P),y(R),y(q),y(D,e),y(Y),y(N),y(O,e),y(K),y(ee),y(ne,e)}}}const Lt='{"title":"Mixins & serialization methods","local":"mixins--serialization-methods","sections":[{"title":"Mixins","local":"mixins","sections":[{"title":"Generic","local":"huggingface_hub.ModelHubMixin","sections":[],"depth":3},{"title":"PyTorch","local":"huggingface_hub.PyTorchModelHubMixin","sections":[],"depth":3},{"title":"Fastai","local":"huggingface_hub.from_pretrained_fastai","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xt(oe){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Wt{constructor(d){super(),Bt(this,d,Xt,St,At,{})}}export{Ot as component};
