import{s as zm,n as Pm,o as Em}from"../chunks/scheduler.0cf4ef2e.js";import{S as qm,i as Dm,e as d,s as a,c as i,h as Om,a as r,d as l,b as n,f as Qm,g as o,j as h,k as y,l as Km,m as s,n as p,t as f,o as c,p as m}from"../chunks/index.abc433bf.js";import{C as ed}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as u}from"../chunks/CodeBlock.00dcd05e.js";import{H as g,E as td}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function ld(_f){let M,ja,ba,va,G,Ja,I,Ua,k,Zf="The <code>huggingface_hub</code> Python package comes with a built-in CLI called <code>hf</code>. This tool allows you to interact with the Hugging Face Hub directly from a terminal. For example, you can log in to your account, create a repository, upload and download files, etc. It also comes with handy features to configure your machine or manage your cache. In this guide, we will have a look at the main features of the CLI and how to use them.",Ca,$,Bf=`<p>This guide covers the most important features of the <code>hf</code> CLI.
For a complete reference of all commands and options, see the <a href="../package_reference/cli.md">CLI reference</a>.</p>`,Ga,_,Ia,Z,xf="First of all, let’s install the CLI:",ka,B,_a,w,Hf="<p>The CLI ships with the core <code>huggingface_hub</code> package.</p>",Za,x,Lf="Alternatively, you can install the <code>hf</code> CLI with a single command:",Ba,H,Yf="On macOS and Linux:",xa,L,Ha,Y,Wf="On Windows:",La,W,Ya,R,Rf="Alternatively, you can install the <code>hf</code> CLI with a single command:",Wa,X,Xf="On macOS and Linux:",Ra,N,Xa,V,Nf="On Windows:",Na,S,Va,F,Vf="Once installed, you can check that the CLI is correctly setup:",Sa,A,Fa,Q,Sf='If the CLI is correctly installed, you should see a list of all the options available in the CLI. If you get an error message such as <code>command not found: hf</code>, please refer to the <a href="../installation">Installation</a> guide.',Aa,b,Ff="<p>The <code>--help</code> option is very convenient for getting more details about a command. You can use it anytime to list all available options and their details. For example, <code>hf upload --help</code> provides more information on how to upload files using the CLI.</p>",Qa,z,za,P,Pa,E,Af='You can install and run the <code>hf</code> CLI with <a href="https://docs.astral.sh/uv/" rel="nofollow">uv</a>.',Ea,q,Qf="Make sure uv is installed (adds <code>uv</code> and <code>uvx</code> to your PATH):",qa,D,Da,O,zf="Then install the CLI globally and use it anywhere:",Oa,K,Ka,ee,Pf="Alternatively, run the CLI ephemerally with <code>uvx</code> (no global install):",en,te,tn,le,ln,se,Ef='You can also install the CLI using <a href="https://brew.sh/" rel="nofollow">Homebrew</a>:',sn,ae,an,ne,qf='Check out the Homebrew huggingface page <a href="https://formulae.brew.sh/formula/huggingface-cli" rel="nofollow">here</a> for more details.',nn,ie,on,oe,Df='In many cases, you must be logged in to a Hugging Face account to interact with the Hub (download private repos, upload files, create PRs, etc.). To do so, you need a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a> from your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Settings page</a>. The User Access Token is used to authenticate your identity to the Hub. Make sure to set a token with write access if you want to upload or modify content.',pn,pe,Of="Once you have your token, run the following command in your terminal:",fn,fe,cn,ce,Kf="This command will prompt you for a token. Copy-paste yours and press <em>Enter</em>. Then, you’ll be asked if the token should also be saved as a git credential. Press <em>Enter</em> again (default to yes) if you plan to use <code>git</code> locally. Finally, it will call the Hub to check that your token is valid and save it locally.",mn,me,dn,de,ec="Alternatively, if you want to log-in without being prompted, you can pass the token directly from the command line. To be more secure, we recommend passing your token as an environment variable to avoid pasting it in your command history.",rn,re,hn,he,tc='For more details about authentication, check out <a href="../quick-start#authentication">this section</a>.',un,ue,gn,ge,lc="If you want to know if you are logged in, you can use <code>hf auth whoami</code>. This command doesn’t have any options and simply prints your username and the organizations you are a part of on the Hub:",yn,ye,Mn,Me,sc="If you are not logged in, an error message will be printed.",$n,$e,wn,we,ac="This command logs you out. In practice, it will delete all tokens stored on your machine. If you want to remove a specific token, you can specify the token name as an argument.",bn,be,nc='This command will not log you out if you are logged in using the <code>HF_TOKEN</code> environment variable (see <a href="../package_reference/environment_variables#hftoken">reference</a>). If that is the case, you must unset the environment variable in your machine configuration.',Tn,Te,jn,je,ic='Use the <code>hf download</code> command to download files from the Hub directly. Internally, it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described in the <a href="./download">Download</a> guide and prints the returned path to the terminal. In the examples below, we will walk through the most common use cases. For a full list of available options, you can run:',vn,ve,Jn,Je,Un,Ue,oc="To download a single file from a repo, simply provide the repo_id and filename as follows:",Cn,Ce,Gn,Ge,pc="The command will always print on the last line the path to the file on your local machine.",In,Ie,fc="To download a file located in a subdirectory of the repo, you should provide the path of the file in the repo in posix format like this:",kn,ke,_n,_e,Zn,Ze,cc="In some cases, you just want to download all the files from a repository. This can be done by just specifying the repo id:",Bn,Be,xn,xe,Hn,He,mc="You can also download a subset of the files from a repository with a single command. This can be done in two ways. If you already have a precise list of the files you want to download, you can simply provide them sequentially:",Ln,Le,Yn,Ye,dc='The other approach is to provide patterns to filter which files you want to download using <code>--include</code> and <code>--exclude</code>. For example, if you want to download all safetensors files from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>, except the files in FP16 precision:',Wn,We,Rn,Re,Xn,Xe,rc="The examples above show how to download from a model repository. To download a dataset or a Space, use the <code>--repo-type</code> option:",Nn,Ne,Vn,Ve,Sn,Se,hc="The examples above show how to download from the latest commit on the main branch. To download from a specific revision (commit hash, branch name or tag), use the <code>--revision</code> option:",Fn,Fe,An,Ae,Qn,Qe,uc="The recommended (and default) way to download files from the Hub is to use the cache-system. However, in some cases you want to download files and move them to a specific folder. This is useful to get a workflow closer to what git commands offer. You can do that using the <code>--local-dir</code> option.",zn,ze,gc="A <code>.cache/huggingface/</code> folder is created at the root of your local directory containing metadata about the downloaded files. This prevents re-downloading files if they’re already up-to-date. If the metadata has changed, then the new file version is downloaded. This makes the <code>local-dir</code> optimized for pulling only the latest changes.",Pn,T,yc='<p>For more details on how downloading to a local file works, check out the <a href="./download#download-files-to-a-local-folder">download</a> guide.</p>',En,Pe,qn,Ee,Dn,qe,Mc="In some cases, you would like to check which files would be downloaded before actually downloading them. You can check this using the <code>--dry-run</code> parameter. It lists all files to download on the repo and checks whether they are already downloaded or not. This gives an idea of how many files have to be downloaded and their sizes.",On,De,Kn,Oe,$c='For more details, check out the <a href="./download.md#dry-run-mode">download guide</a>.',ei,Ke,ti,et,wc='If not using <code>--local-dir</code>, all files will be downloaded by default to the cache directory defined by the <code>HF_HOME</code> <a href="../package_reference/environment_variables#hfhome">environment variable</a>. You can specify a custom cache using <code>--cache-dir</code>:',li,tt,si,lt,ai,st,bc="To access private or gated repositories, you must use a token. By default, the token saved locally (using <code>hf auth login</code>) will be used. If you want to authenticate explicitly, use the <code>--token</code> option:",ni,at,ii,nt,oi,it,Tc="By default, the <code>hf download</code> command will be verbose. It will print details such as warning messages, information about the downloaded files, and progress bars. If you want to silence all of this, use the <code>--quiet</code> option. Only the last line (i.e. the path to the downloaded files) is printed. This can prove useful if you want to pass the output to another command in a script.",pi,ot,fi,pt,ci,ft,jc="On machines with slow connections, you might encounter timeout issues like this one:",mi,ct,di,mt,vc="To mitigate this issue, you can set the <code>HF_HUB_DOWNLOAD_TIMEOUT</code> environment variable to a higher value (default is 10):",ri,dt,hi,rt,Jc='For more details, check out the <a href="../package_reference/environment_variables#hfhubdownloadtimeout">environment variables reference</a>. And rerun your download command.',ui,ht,gi,ut,Uc='Use the <code>hf upload</code> command to upload files to the Hub directly. Internally, it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> helpers described in the <a href="./upload">Upload</a> guide. In the examples below, we will walk through the most common use cases. For a full list of available options, you can run:',yi,gt,Mi,yt,$i,Mt,Cc="The default usage for this command is:",wi,$t,bi,wt,Gc="To upload the current directory at the root of the repo, use:",Ti,bt,ji,j,Ic="<p>If the repo doesn’t exist yet, it will be created automatically.</p>",vi,Tt,kc="You can also upload a specific folder:",Ji,jt,Ui,vt,_c="Finally, you can upload a folder to a specific destination on the repo:",Ci,Jt,Gi,Ut,Ii,Ct,Zc="You can also upload a single file by setting <code>local_path</code> to point to a file on your machine. If that’s the case, <code>path_in_repo</code> is optional and will default to the name of your local file:",ki,Gt,_i,It,Bc="If you want to upload a single file to a specific directory, set <code>path_in_repo</code> accordingly:",Zi,kt,Bi,_t,xi,Zt,xc="To upload multiple files from a folder at once without uploading the entire folder, use the <code>--include</code> and <code>--exclude</code> patterns. It can also be combined with the <code>--delete</code> option to delete files on the repo while uploading new ones. In the example below, we sync the local Space by deleting remote files and uploading all files except the ones in <code>/logs</code>:",Hi,Bt,Li,xt,Yi,Ht,Hc="To upload to a dataset or a Space, use the <code>--repo-type</code> option:",Wi,Lt,Ri,Yt,Xi,Wt,Lc="To upload content to a repo owned by an organization instead of a personal repo, you must explicitly specify it in the <code>repo_id</code>:",Ni,Rt,Vi,Xt,Si,Nt,Yc="By default, files are uploaded to the <code>main</code> branch. If you want to upload files to another branch or reference, use the <code>--revision</code> option:",Fi,Vt,Ai,St,Wc="<strong>Note:</strong> if <code>revision</code> does not exist and <code>--create-pr</code> is not set, a branch will be created automatically from the <code>main</code> branch.",Qi,Ft,zi,At,Rc="If you don’t have the permission to push to a repo, you must open a PR and let the authors know about the changes you want to make. This can be done by setting the <code>--create-pr</code> option:",Pi,Qt,Ei,zt,qi,Pt,Xc="In some cases, you might want to push regular updates to a repo. For example, this is useful if you’re training a model and you want to upload the logs folder every 10 minutes. You can do this using the <code>--every</code> option:",Di,Et,Oi,qt,Ki,Dt,Nc="Use the <code>--commit-message</code> and <code>--commit-description</code> to set a custom message and description for your commit instead of the default one",eo,Ot,to,Kt,lo,el,Vc="To upload files, you must use a token. By default, the token saved locally (using <code>hf auth login</code>) will be used. If you want to authenticate explicitly, use the <code>--token</code> option:",so,tl,ao,ll,no,sl,Sc="By default, the <code>hf upload</code> command will be verbose. It will print details such as warning messages, information about the uploaded files, and progress bars. If you want to silence all of this, use the <code>--quiet</code> option. Only the last line (i.e. the URL to the uploaded files) is printed. This can prove useful if you want to pass the output to another command in a script.",io,al,oo,nl,po,il,Fc="<code>hf repo</code> lets you create, delete, move repositories and update their settings on the Hugging Face Hub. It also includes subcommands to manage branches and tags.",fo,ol,co,pl,mo,fl,Ac="Create a private dataset or a Space:",ro,cl,ho,ml,Qc="Use <code>--exist-ok</code> if the repo may already exist, and <code>--resource-group-id</code> to target an Enterprise resource group.",uo,dl,go,rl,yo,hl,zc="Datasets and Spaces:",Mo,ul,$o,gl,wo,yl,bo,Ml,To,$l,jo,wl,Pc="<li><code>--gated</code>: one of <code>auto</code>, <code>manual</code>, <code>false</code></li> <li><code>--private true|false</code>: set repository privacy</li>",vo,bl,Jo,Tl,Uo,v,Ec="<p>All commands accept <code>--repo-type</code> (one of <code>model</code>, <code>dataset</code>, <code>space</code>) and <code>--token</code> if you need to authenticate explicitly. Use <code>--help</code> on any command to see all options.</p>",Co,jl,Go,vl,qc="If you want to delete files from a Hugging Face repository, use the <code>hf repo-files</code> command.",Io,Jl,ko,Ul,Dc="The <code>hf repo-files delete &lt;repo_id&gt;</code> sub-command allows you to delete files from a repository. Here are some usage examples.",_o,Cl,Oc="Delete a folder :",Zo,Gl,Bo,Il,Kc="Delete multiple files:",xo,kl,Ho,_l,em="Use Unix-style wildcards to delete sets of files:",Lo,Zl,Yo,Bl,Wo,xl,tm="To delete files from a repo you must be authenticated and authorized. By default, the token saved locally (using <code>hf auth login</code>) will be used. If you want to authenticate explicitly, use the <code>--token</code> option:",Ro,Hl,Xo,Ll,No,Yl,lm="Use <code>hf cache ls</code> to inspect what is stored locally in your Hugging Face cache. By default it aggregates information by repository:",Vo,Wl,So,Rl,sm="Add <code>--revisions</code> to drill down to specific snapshots, and chain filters to focus on what matters:",Fo,Xl,Ao,Nl,am='The command supports several output formats for scripting: <code>--format json</code> prints structured objects, <code>--format csv</code> writes comma-separated rows, and <code>--quiet</code> prints only IDs. Use <code>--sort</code> to order entries by <code>accessed</code>, <code>modified</code>, <code>name</code>, or <code>size</code> (append <code>:asc</code> or <code>:desc</code> to control order), and <code>--limit</code> to restrict results to the top N entries. Combine these with <code>--cache-dir</code> to target alternative cache locations. See the <a href="./manage-cache">Manage your cache</a> guide for advanced workflows.',Qo,Vl,nm="Delete cache entries selected with <code>hf cache ls --q</code> by piping the IDs into <code>hf cache rm</code>:",zo,Sl,Po,Fl,Eo,Al,im="<code>hf cache rm</code> removes cached repositories or individual revisions. Pass one or more repo IDs (<code>model/bert-base-uncased</code>) or revision hashes:",qo,Ql,Do,zl,om="Mix repositories and specific revisions in the same call. Use <code>--dry-run</code> to preview the impact, or <code>--yes</code> to skip the confirmation prompt—handy in automated scripts:",Oo,Pl,Ko,El,pm="When working outside the default cache location, pair the command with <code>--cache-dir PATH</code>.",ep,ql,tp,Dl,fm="<code>hf cache prune</code> is a convenience shortcut that deletes every detached (unreferenced) revision in your cache. This keeps only revisions that are still reachable through a branch or tag:",lp,Ol,sp,Kl,cm='As with the other cache commands, <code>--dry-run</code>, <code>--yes</code>, and <code>--cache-dir</code> are available. Refer to the <a href="./manage-cache">Manage your cache</a> guide for more examples.',ap,es,np,ts,mm="Use <code>hf cache verify</code> to validate local files against their checksums on the Hub. You can verify either a cache snapshot or a regular local directory.",ip,ls,dm="Examples:",op,ss,pp,as,rm="By default, the command warns about missing or extra files. Use flags to turn these warnings into errors:",fp,ns,cp,is,hm="On success, you will see a summary:",mp,os,dp,ps,um="If mismatches are detected, the command prints a detailed list and exits with a non-zero status.",rp,fs,hp,cs,gm="The <code>hf repo tag create</code> command allows you to tag, untag, and list tags for repositories.",up,ms,gp,ds,ym="To tag a repo, you need to provide the <code>repo_id</code> and the <code>tag</code> name:",yp,rs,Mp,hs,$p,us,Mm="If you want to tag a specific revision, you can use the <code>--revision</code> option. By default, the tag will be created on the <code>main</code> branch:",wp,gs,bp,ys,Tp,Ms,$m="If you want to tag a dataset or Space, you must specify the <code>--repo-type</code> option:",jp,$s,vp,ws,Jp,bs,wm="To list all tags for a repository, use the <code>-l</code> or <code>--list</code> option:",Up,Ts,Cp,js,Gp,vs,bm="To delete a tag, use the <code>-d</code> or <code>--delete</code> option:",Ip,Js,kp,Us,Tm="You can also pass <code>-y</code> to skip the confirmation step.",_p,Cs,Zp,Gs,jm='The <code>hf env</code> command prints details about your machine setup. This is useful when you open an issue on <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">GitHub</a> to help the maintainers investigate your problem.',Bp,Is,xp,ks,Hp,_s,vm="Run compute jobs on Hugging Face infrastructure with a familiar Docker-like interface.",Lp,Zs,Jm="<code>hf jobs</code> is a command-line tool that lets you run anything on Hugging Face’s infrastructure (including GPUs and TPUs!) with simple commands. Think <code>docker run</code>, but for running code on A100s.",Yp,Bs,Wp,xs,Rp,Hs,Um="<li>🐳 <strong>Docker-like CLI</strong>: Familiar commands (<code>run</code>, <code>ps</code>, <code>logs</code>, <code>inspect</code>) to run and manage jobs</li> <li>🔥 <strong>Any Hardware</strong>: From CPUs to A100 GPUs and TPU pods - switch with a simple flag</li> <li>📦 <strong>Run Anything</strong>: Use Docker images, HF Spaces, or your custom containers</li> <li>🔐 <strong>Simple Auth</strong>: Just use your HF token</li> <li>📊 <strong>Live Monitoring</strong>: Stream logs in real-time, just like running locally</li> <li>💰 <strong>Pay-as-you-go</strong>: Only pay for the seconds you use</li>",Xp,J,Cm='<p><strong>Hugging Face Jobs</strong> are available only to <a href="https://huggingface.co/pro" rel="nofollow">Pro users</a> and <a href="https://huggingface.co/enterprise" rel="nofollow">Team or Enterprise organizations</a>. Upgrade your plan to get started!</p>',Np,Ls,Vp,Ys,Sp,Ws,Fp,Rs,Gm="This command runs the job and shows the logs. You can pass <code>--detach</code> to run the Job in the background and only print the Job ID.",Ap,Xs,Qp,Ns,zp,Vs,Pp,Ss,Im="You can also run jobs on GPUs or TPUs with the <code>--flavor</code> option. For example, to run a PyTorch job on an A10G GPU:",Ep,Fs,qp,As,km="Running this will show the following output!",Dp,Qs,Op,zs,_m="That’s it! You’re now running code on Hugging Face’s infrastructure.",Kp,Ps,ef,Es,Zm="<li><strong>Model Training</strong>: Fine-tune or train models on GPUs (T4, A10G, A100) without managing infrastructure</li> <li><strong>Synthetic Data Generation</strong>: Generate large-scale datasets using LLMs on powerful hardware</li> <li><strong>Data Processing</strong>: Process massive datasets with high-CPU configurations for parallel workloads</li> <li><strong>Batch Inference</strong>: Run offline inference on thousands of samples using optimized GPU setups</li> <li><strong>Experiments &amp; Benchmarks</strong>: Run ML experiments on consistent hardware for reproducible results</li> <li><strong>Development &amp; Debugging</strong>: Test GPU code without local CUDA setup</li>",tf,qs,lf,Ds,Bm="You can pass environment variables to your job using",sf,Os,af,Ks,nf,ea,of,ta,pf,U,xm=`<p>Use <code>--secrets HF_TOKEN</code> to pass your local Hugging Face token implicitly.
With this syntax, the secret is retrieved from the environment variable.
For <code>HF_TOKEN</code>, it may read the token file located in the Hugging Face home folder if the environment variable is unset.</p>`,ff,la,cf,sa,Hm="Available <code>--flavor</code> options:",mf,aa,Lm="<li>CPU: <code>cpu-basic</code>, <code>cpu-upgrade</code></li> <li>GPU: <code>t4-small</code>, <code>t4-medium</code>, <code>l4x1</code>, <code>l4x4</code>, <code>a10g-small</code>, <code>a10g-large</code>, <code>a10g-largex2</code>, <code>a10g-largex4</code>,<code>a100-large</code></li> <li>TPU: <code>v5e-1x1</code>, <code>v5e-2x2</code>, <code>v5e-2x4</code></li>",df,na,Ym='(updated in 07/2025 from Hugging Face <a href="https://huggingface.co/docs/hub/en/spaces-config-reference" rel="nofollow">suggested_hardware docs</a>)',rf,ia,hf,oa,Wm="Run UV scripts (Python scripts with inline dependencies) on HF infrastructure:",uf,pa,gf,fa,Rm='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax. This makes them perfect for self-contained tasks that don’t require complex project setups. Learn more about UV scripts in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',yf,ca,Mf,ma,Xm="Schedule and manage jobs that will run on HF infrastructure.",$f,da,Nm="The schedule should be one of <code>@annually</code>, <code>@yearly</code>, <code>@monthly</code>, <code>@weekly</code>, <code>@daily</code>, <code>@hourly</code>, or a CRON schedule expression (e.g., <code>&quot;0 9 * * 1&quot;</code> for 9 AM every Monday).",wf,ra,bf,ha,Vm="Use the same parameters as <code>hf jobs run</code> to pass environment variables, secrets, timeout, etc.",Tf,ua,Sm="Manage scheduled jobs using",jf,ga,vf,ya,Jf,Ma,Fm=`Use <code>hf endpoints</code> to list, deploy, describe, and manage Inference Endpoints directly from the terminal. The legacy
<code>hf inference-endpoints</code> alias remains available for compatibility.`,Uf,$a,Cf,C,Am="<p>Add <code>--namespace</code> to target an organization, <code>--token</code> to override authentication.</p>",Gf,wa,If,Ta,kf;return G=new ed({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new g({props:{title:"Command Line Interface (CLI)",local:"command-line-interface-cli",headingTag:"h1"}}),_=new g({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),B=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwJTIyaHVnZ2luZ2ZhY2VfaHViJTIy",highlighted:'<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install -U <span class="hljs-string">&quot;huggingface_hub&quot;</span></span>',wrap:!1}}),L=new u({props:{code:"Y3VybCUyMC1Mc1NmJTIwaHR0cHMlM0ElMkYlMkZoZi5jbyUyRmNsaSUyRmluc3RhbGwuc2glMjAlN0MlMjBiYXNo",highlighted:"&gt;&gt;&gt; curl -LsSf https://hf.co/cli/install.sh | bash",wrap:!1}}),W=new u({props:{code:"cG93ZXJzaGVsbCUyMC1FeGVjdXRpb25Qb2xpY3klMjBCeVBhc3MlMjAtYyUyMCUyMmlybSUyMGh0dHBzJTNBJTJGJTJGaGYuY28lMkZjbGklMkZpbnN0YWxsLnBzMSUyMCU3QyUyMGlleCUyMg==",highlighted:'&gt;&gt;&gt; powershell <span class="hljs-literal">-ExecutionPolicy</span> ByPass <span class="hljs-literal">-c</span> <span class="hljs-string">&quot;irm https://hf.co/cli/install.ps1 | iex&quot;</span>',wrap:!1}}),N=new u({props:{code:"Y3VybCUyMC1Mc1NmJTIwaHR0cHMlM0ElMkYlMkZoZi5jbyUyRmNsaSUyRmluc3RhbGwuc2glMjAlN0MlMjBzaA==",highlighted:"&gt;&gt;&gt; curl -LsSf https://hf.co/cli/install.sh | sh",wrap:!1}}),S=new u({props:{code:"cG93ZXJzaGVsbCUyMC1FeGVjdXRpb25Qb2xpY3klMjBCeVBhc3MlMjAtYyUyMCUyMmlybSUyMGh0dHBzJTNBJTJGJTJGaGYuY28lMkZjbGklMkZpbnN0YWxsLnBzMSUyMCU3QyUyMGlleCUyMg==",highlighted:'&gt;&gt;&gt; powershell <span class="hljs-literal">-ExecutionPolicy</span> ByPass <span class="hljs-literal">-c</span> <span class="hljs-string">&quot;irm https://hf.co/cli/install.ps1 | iex&quot;</span>',wrap:!1}}),A=new u({props:{code:"aGYlMjAtLWhlbHAlMEElMEElMEE=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-comment">--help</span>
Usage: hf [OPTIONS] COMMAND [ARGS]...

  Hugging Face Hub CLI

Options:
  <span class="hljs-comment">--install-completion  Install completion for the current shell.</span>
  <span class="hljs-comment">--show-completion     Show completion for the current shell, to copy it or</span>
                        customize <span class="hljs-keyword">the</span> installation.
  <span class="hljs-comment">--help                Show this message and exit.</span>

Commands:
  auth                 Manage authentication (login, logout, etc.).
  cache                Manage <span class="hljs-built_in">local</span> cache <span class="hljs-built_in">directory</span>.
  download             Download <span class="hljs-built_in">files</span> <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> Hub.
  env                  Print information about <span class="hljs-keyword">the</span> environment.
  jobs                 Run <span class="hljs-keyword">and</span> manage Jobs <span class="hljs-keyword">on</span> <span class="hljs-title">the</span> <span class="hljs-title">Hub</span>.
  repo                 Manage repos <span class="hljs-keyword">on</span> <span class="hljs-title">the</span> <span class="hljs-title">Hub</span>.
  repo-<span class="hljs-built_in">files</span>           Manage <span class="hljs-built_in">files</span> <span class="hljs-keyword">in</span> <span class="hljs-keyword">a</span> repo <span class="hljs-keyword">on</span> <span class="hljs-title">the</span> <span class="hljs-title">Hub</span>.
  upload               Upload <span class="hljs-keyword">a</span> <span class="hljs-built_in">file</span> <span class="hljs-keyword">or</span> <span class="hljs-keyword">a</span> <span class="hljs-built_in">folder</span> <span class="hljs-built_in">to</span> <span class="hljs-keyword">the</span> Hub.
  upload-large-<span class="hljs-built_in">folder</span>  Upload <span class="hljs-keyword">a</span> large <span class="hljs-built_in">folder</span> <span class="hljs-built_in">to</span> <span class="hljs-keyword">the</span> Hub.
  <span class="hljs-built_in">version</span>              Print information about <span class="hljs-keyword">the</span> hf <span class="hljs-built_in">version</span>.`,wrap:!1}}),z=new g({props:{title:"Other installation methods",local:"other-installation-methods",headingTag:"h3"}}),P=new g({props:{title:"Using uv",local:"using-uv",headingTag:"h4"}}),D=new u({props:{code:"Y3VybCUyMC1Mc1NmJTIwaHR0cHMlM0ElMkYlMkZhc3RyYWwuc2glMkZ1diUyRmluc3RhbGwuc2glMjAlN0MlMjBzaA==",highlighted:"&gt;&gt;&gt; curl -LsSf https://astral.sh/uv/install.sh | sh",wrap:!1}}),K=new u({props:{code:"dXYlMjB0b29sJTIwaW5zdGFsbCUyMCUyMmh1Z2dpbmdmYWNlX2h1YiUyMiUwQWhmJTIwYXV0aCUyMHdob2FtaQ==",highlighted:`&gt;&gt;&gt; uv tool install <span class="hljs-string">&quot;huggingface_hub&quot;</span>
&gt;&gt;&gt; hf auth <span class="hljs-built_in">whoami</span>`,wrap:!1}}),te=new u({props:{code:"dXZ4JTIwLS1mcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaGYlMjBhdXRoJTIwd2hvYW1p",highlighted:'&gt;&gt;&gt; uvx --from huggingface_hub hf auth <span class="hljs-built_in">whoami</span>',wrap:!1}}),le=new g({props:{title:"Using Homebrew",local:"using-homebrew",headingTag:"h4"}}),ae=new u({props:{code:"YnJldyUyMGluc3RhbGwlMjBodWdnaW5nZmFjZS1jbGk=",highlighted:"&gt;&gt;&gt; brew install huggingface-cli",wrap:!1}}),ie=new g({props:{title:"hf auth login",local:"hf-auth-login",headingTag:"h2"}}),fe=new u({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:"&gt;&gt;&gt; hf auth login",wrap:!1}}),me=new u({props:{code:"XyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQV8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMEFfJTdDXyU3Q18lN0NfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0MlMEFfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTBBXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUwQVRvJTIwbG9nJTIwaW4lMkMlMjAlNjBodWdnaW5nZmFjZV9odWIlNjAlMjByZXF1aXJlcyUyMGElMjB0b2tlbiUyMGdlbmVyYXRlZCUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMlMjAuJTBBRW50ZXIlMjB5b3VyJTIwdG9rZW4lMjAoaW5wdXQlMjB3aWxsJTIwbm90JTIwYmUlMjB2aXNpYmxlKSUzQSUwQUFkZCUyMHRva2VuJTIwYXMlMjBnaXQlMjBjcmVkZW50aWFsJTNGJTIwKFklMkZuKSUwQVRva2VuJTIwaXMlMjB2YWxpZCUyMChwZXJtaXNzaW9uJTNBJTIwd3JpdGUpLiUwQVlvdXIlMjB0b2tlbiUyMGhhcyUyMGJlZW4lMjBzYXZlZCUyMGluJTIweW91ciUyMGNvbmZpZ3VyZWQlMjBnaXQlMjBjcmVkZW50aWFsJTIwaGVscGVycyUyMChzdG9yZSkuJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZob21lJTJGd2F1cGxpbiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGdG9rZW4lMEFMb2dpbiUyMHN1Y2Nlc3NmdWw=",highlighted:`<span class="hljs-keyword">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|          <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|            <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|

<span class="hljs-type">To</span> log <span class="hljs-built_in">in</span>, \`huggingface_hub\` requires a token generated from https://huggingface.co/settings/tokens .
Enter your token (input will not be visible):
<span class="hljs-keyword">Add</span> token <span class="hljs-built_in">as</span> git credential? (Y/n)
Token is valid (permission: write).
Your token has been saved <span class="hljs-built_in">in</span> your configured git credential helpers (store).
Your token has been saved to /home/wauplin/.cache/huggingface/token
Login successful`,wrap:!1}}),re=new u({props:{code:"aGYlMjBhdXRoJTIwbG9naW4lMjAtLXRva2VuJTIwJTI0SEZfVE9LRU4lMjAtLWFkZC10by1naXQtY3JlZGVudGlhbA==",highlighted:`<span class="hljs-comment"># Or using an environment variable</span>
&gt;&gt;&gt; hf auth login --token <span class="hljs-variable">$HF_TOKEN</span> --add-to-git-credential
Token is valid (permission: write).
The token \`token_name\` has been saved to /home/wauplin/.cache/huggingface/stored_tokens
Your token has been saved <span class="hljs-keyword">in</span> your configured git credential helpers (store).
Your token has been saved to /home/wauplin/.cache/huggingface/token
Login successful
The current active token is: \`token_name\``,wrap:!1}}),ue=new g({props:{title:"hf auth whoami",local:"hf-auth-whoami",headingTag:"h2"}}),ye=new u({props:{code:"aGYlMjBhdXRoJTIwd2hvYW1pJTBBV2F1cGxpbiUwQW9yZ3MlM0ElMjAlMjBodWdnaW5nZmFjZSUyQ2V1LXRlc3QlMkNPQXV0aFRlc3RlcnMlMkNoZi1hY2NlbGVyYXRlJTJDSEZTbW9sQ2x1c3Rlcg==",highlighted:`hf auth <span class="hljs-built_in">whoami</span>
Wauplin
orgs:  huggingface,eu-test,OAuthTesters,hf-accelerate,HFSmolCluster`,wrap:!1}}),$e=new g({props:{title:"hf auth logout",local:"hf-auth-logout",headingTag:"h2"}}),Te=new g({props:{title:"hf download",local:"hf-download",headingTag:"h2"}}),ve=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMC0taGVscA==",highlighted:'hf download --<span class="hljs-built_in">help</span>',wrap:!1}}),Je=new g({props:{title:"Download a single file",local:"download-a-single-file",headingTag:"h3"}}),Ce=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbg==",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json
downloading https://huggingface.co/gpt2/resolve/main/config.json to /home/wauplin/.cache/huggingface/hub/tmpwrq8dm5o
(…)ingface.co/gpt2/resolve/main/config.json: 100%|██████████████████████████████████| 665/665 [00:00&lt;00:00, 2.49MB/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),ke=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMEhpRHJlYW0tYWklMkZIaURyZWFtLUkxLUZ1bGwlMjB0ZXh0X2VuY29kZXIlMkZtb2RlbC5zYWZldGVuc29ycw==",highlighted:"&gt;&gt;&gt; hf download HiDream-ai/HiDream-I1-Full text_encoder/model.safetensors",wrap:!1}}),_e=new g({props:{title:"Download an entire repository",local:"download-an-entire-repository",headingTag:"h3"}}),Be=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMEh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YQ==",highlighted:`&gt;&gt;&gt; hf download HuggingFaceH4/zephyr-7b-beta
Fetching 23 files:   0%|                                                | 0/23 [00:00&lt;?, ?it/s]
...
...
/home/wauplin/.cache/huggingface/hub/models--HuggingFaceH4--zephyr-7b-beta/snapshots/3bac358730f8806e5c3dc7c7e19eb36e045bf720`,wrap:!1}}),xe=new g({props:{title:"Download multiple files",local:"download-multiple-files",headingTag:"h3"}}),Le=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMG1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json model.safetensors
Fetching 2 files:   0%|                                                                        | 0/2 [00:00&lt;?, ?it/s]
downloading https://huggingface.co/gpt2/resolve/11c5a3d5811f50298f278a704980280950aedb10/model.safetensors to /home/wauplin/.cache/huggingface/hub/tmpdachpl3o
(…)8f278a7049802950aedb10/model.safetensors: 100%|██████████████████████████████| 8.09k/8.09k [00:00&lt;00:00, 40.5MB/s]
Fetching 2 files: 100%|████████████████████████████████████████████████████████████████| 2/2 [00:00&lt;00:00,  3.76it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),We=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMHN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMC0taW5jbHVkZSUyMCUyMiouc2FmZXRlbnNvcnMlMjIlMjAtLWV4Y2x1ZGUlMjAlMjIqLmZwMTYuKiUyMio=",highlighted:`&gt;&gt;&gt; hf download stabilityai/stable-diffusion-xl-base-1.0 --include <span class="hljs-string">&quot;*.safetensors&quot;</span> --exclude <span class="hljs-string">&quot;*.fp16.*&quot;</span>*
Fetching 8 files:   0%|                                                                         | 0/8 [00:00&lt;?, ?it/s]
...
...
Fetching 8 files: 100%|█████████████████████████████████████████████████████████████████████████| 8/8 (...)
/home/wauplin/.cache/huggingface/hub/models--stabilityai--stable-diffusion-xl-base-1.0/snapshots/462165984030d82259a11f4367a4eed129e94a7b`,wrap:!1}}),Re=new g({props:{title:"Download a dataset or a Space",local:"download-a-dataset-or-a-space",headingTag:"h3"}}),Ne=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMEh1Z2dpbmdGYWNlSDQlMkZ1bHRyYWNoYXRfMjAwayUyMC0tcmVwby10eXBlJTIwZGF0YXNldCUwQSUwQWhmJTIwZG93bmxvYWQlMjBIdWdnaW5nRmFjZUg0JTJGemVwaHlyLWNoYXQlMjAtLXJlcG8tdHlwZSUyMHNwYWNlJTBB",highlighted:`<span class="hljs-comment"># https://huggingface.co/datasets/HuggingFaceH4/ultrachat_200k</span>
&gt;&gt;&gt; hf download HuggingFaceH4/ultrachat_200k --repo-type dataset

<span class="hljs-comment"># https://huggingface.co/spaces/HuggingFaceH4/zephyr-chat</span>
&gt;&gt;&gt; hf download HuggingFaceH4/zephyr-chat --repo-type space

...`,wrap:!1}}),Ve=new g({props:{title:"Download a specific revision",local:"download-a-specific-revision",headingTag:"h3"}}),Fe=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGJpZ2NvZGUlMkZ0aGUtc3RhY2slMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjAtLXJldmlzaW9uJTIwdjEuMQ==",highlighted:`&gt;&gt;&gt; hf download bigcode/the-stack --repo-type dataset --revision v1.1
...`,wrap:!1}}),Ae=new g({props:{title:"Download to a local folder",local:"download-to-a-local-folder",headingTag:"h3"}}),Pe=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGFkZXB0JTJGZnV5dS04YiUyMG1vZGVsLTAwMDAxLW9mLTAwMDAyLnNhZmV0ZW5zb3JzJTIwLS1sb2NhbC1kaXIlMjBmdXl1",highlighted:`&gt;&gt;&gt; hf download adept/fuyu-8b model-00001-of-00002.safetensors --local-dir fuyu
...
fuyu/model-00001-of-00002.safetensors`,wrap:!1}}),Ee=new g({props:{title:"Dry-run mode",local:"dry-run-mode",headingTag:"h3"}}),De=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwLS1kcnktcnVu",highlighted:`&gt;&gt;&gt; hf download openai-community/gpt2 --dry-run
[dry-run] Fetching 26 files: 100%|█████████████| 26/26 [00:04&lt;00:00,  6.26it/s]
[dry-run] Will download 11 files (out of 26) totalling 5.6G.
File                              Bytes to download
--------------------------------- -----------------
.gitattributes                    -
64-8bits.tflite                   125.2M
64-fp16.tflite                    248.3M
64.tflite                         495.8M
README.md                         -
config.json                       -
flax_model.msgpack                497.8M
generation_config.json            -
merges.txt                        -
model.safetensors                 548.1M
onnx/config.json                  -
onnx/decoder_model.onnx           653.7M
onnx/decoder_model_merged.onnx    655.2M
onnx/decoder_with_past_model.onnx 653.7M
onnx/generation_config.json       -
onnx/merges.txt                   -
onnx/special_tokens_map.json      -
onnx/tokenizer.json               -
onnx/tokenizer_config.json        -
onnx/vocab.json                   -
pytorch_model.bin                 548.1M
rust_model.ot                     702.5M
tf_model.h5                       497.9M
tokenizer.json                    -
tokenizer_config.json             -
vocab.json                        -`,wrap:!1}}),Ke=new g({props:{title:"Specify cache directory",local:"specify-cache-directory",headingTag:"h3"}}),tt=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGFkZXB0JTJGZnV5dS04YiUyMC0tY2FjaGUtZGlyJTIwLiUyRnBhdGglMkZ0byUyRmNhY2hl",highlighted:`&gt;&gt;&gt; hf download adept/fuyu-8b --cache-dir ./path/to/cache
...
./path/to/cache/models--adept--fuyu-8b/snapshots/ddcacbcf5fdf9cc59ff01f6be6d6662624d9c745`,wrap:!1}}),lt=new g({props:{title:"Specify a token",local:"specify-a-token",headingTag:"h3"}}),at=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMC0tdG9rZW4lM0RoZl8qKioq",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json --token=hf_****
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),nt=new g({props:{title:"Quiet mode",local:"quiet-mode",headingTag:"h3"}}),ot=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjAtLXF1aWV0",highlighted:`&gt;&gt;&gt; hf download gpt2 --quiet
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),pt=new g({props:{title:"Download timeout",local:"download-timeout",headingTag:"h3"}}),ct=new u({props:{code:"JTYwaHR0cHguVGltZW91dEV4Y2VwdGlvbiUzQSUyMChUaW1lb3V0RXhjZXB0aW9uKCUyMkhUVFBTQ29ubmVjdGlvblBvb2woaG9zdCUzRCdjZG4tbGZzLXVzLTEuaHVnZ2luZ2ZhY2UuY28nJTJDJTIwcG9ydCUzRDQ0MyklM0ElMjBSZWFkJTIwdGltZWQlMjBvdXQuJTIwKHJlYWQlMjB0aW1lb3V0JTNEMTApJTIyKSUyQyUyMCcoUmVxdWVzdCUyMElEJTNBJTIwYTMzZDkxMGMtODRjNi00NTE0LTgzNjItYzcwNWUyMDM5ZDM4KScpJTYw",highlighted:'`httpx.TimeoutException: (TimeoutException(<span class="hljs-string">&quot;HTTPSConnectionPool(host=&#x27;cdn-lfs-us-1.huggingface.co&#x27;, port=443): Read timed out. (read timeout=10)&quot;</span>), <span class="hljs-string">&#x27;(Request ID: a33d910c-84c6-4514-8362-c705e2039d38)&#x27;</span>)`',wrap:!1}}),dt=new u({props:{code:"ZXhwb3J0JTIwSEZfSFVCX0RPV05MT0FEX1RJTUVPVVQlM0QzMA==",highlighted:'<span class="hljs-built_in">export</span> HF_HUB_DOWNLOAD_TIMEOUT=30',wrap:!1}}),ht=new g({props:{title:"hf upload",local:"hf-upload",headingTag:"h2"}}),gt=new u({props:{code:"aGYlMjB1cGxvYWQlMjAtLWhlbHA=",highlighted:'&gt;&gt;&gt; hf upload --<span class="hljs-built_in">help</span>',wrap:!1}}),yt=new g({props:{title:"Upload an entire folder",local:"upload-an-entire-folder",headingTag:"h3"}}),$t=new u({props:{code:"JTIzJTIwVXNhZ2UlM0ElMjAlMjBoZiUyMHVwbG9hZCUyMCU1QnJlcG9faWQlNUQlMjAlNUJsb2NhbF9wYXRoJTVEJTIwJTVCcGF0aF9pbl9yZXBvJTVE",highlighted:'<span class="hljs-comment"># Usage:  hf upload [repo_id] [local_path] [path_in_repo]</span>',wrap:!1}}),bt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBteS1jb29sLW1vZGVsJTIwLiUyMC4=",highlighted:`&gt;&gt;&gt; hf upload my-cool-model . .
https://huggingface.co/Wauplin/my-cool-model/tree/main/`,wrap:!1}}),jt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBteS1jb29sLW1vZGVsJTIwLiUyRm1vZGVscyUyMC4=",highlighted:`&gt;&gt;&gt; hf upload my-cool-model ./models .
https://huggingface.co/Wauplin/my-cool-model/tree/main/`,wrap:!1}}),Jt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBteS1jb29sLW1vZGVsJTIwLiUyRnBhdGglMkZ0byUyRmN1cmF0ZWQlMkZkYXRhJTIwJTJGZGF0YSUyRnRyYWlu",highlighted:`&gt;&gt;&gt; hf upload my-cool-model ./path/to/curated/data /data/train
https://huggingface.co/Wauplin/my-cool-model/tree/main/data/train`,wrap:!1}}),Ut=new g({props:{title:"Upload a single file",local:"upload-a-single-file",headingTag:"h3"}}),Gt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMkZtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models/model.safetensors
https://huggingface.co/Wauplin/my-cool-model/blob/main/model.safetensors`,wrap:!1}}),kt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMkZtb2RlbC5zYWZldGVuc29ycyUyMCUyRnZhZSUyRm1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models/model.safetensors /vae/model.safetensors
https://huggingface.co/Wauplin/my-cool-model/blob/main/vae/model.safetensors`,wrap:!1}}),_t=new g({props:{title:"Upload multiple files",local:"upload-multiple-files",headingTag:"h3"}}),Bt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGc3BhY2UtZXhhbXBsZSUyMC0tcmVwby10eXBlJTNEc3BhY2UlMjAtLWV4Y2x1ZGUlM0QlMjIlMkZsb2dzJTJGKiUyMiUyMC0tZGVsZXRlJTNEJTIyKiUyMiUyMC0tY29tbWl0LW1lc3NhZ2UlM0QlMjJTeW5jJTIwbG9jYWwlMjBTcGFjZSUyMHdpdGglMjBIdWIlMjI=",highlighted:`<span class="hljs-comment"># Sync local Space with Hub (upload new files except from logs/, delete removed files)</span>
&gt;&gt;&gt; hf upload Wauplin/space-example --repo-type=space --exclude=<span class="hljs-string">&quot;/logs/*&quot;</span> --delete=<span class="hljs-string">&quot;*&quot;</span> --commit-message=<span class="hljs-string">&quot;Sync local Space with Hub&quot;</span>
...`,wrap:!1}}),xt=new g({props:{title:"Upload to a dataset or Space",local:"upload-to-a-dataset-or-space",headingTag:"h3"}}),Lt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1kYXRhc2V0JTIwLiUyRmRhdGElMjAlMkZ0cmFpbiUyMC0tcmVwby10eXBlJTNEZGF0YXNldA==",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-dataset ./data /train --repo-type=dataset
...`,wrap:!1}}),Yt=new g({props:{title:"Upload to an organization",local:"upload-to-an-organization",headingTag:"h3"}}),Rt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBNeUNvb2xPcmdhbml6YXRpb24lMkZteS1jb29sLW1vZGVsJTIwLiUyMC4=",highlighted:`&gt;&gt;&gt; hf upload MyCoolOrganization/my-cool-model . .
https://huggingface.co/MyCoolOrganization/my-cool-model/tree/main/`,wrap:!1}}),Xt=new g({props:{title:"Upload to a specific revision",local:"upload-to-a-specific-revision",headingTag:"h3"}}),Vt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBiaWdjb2RlJTJGdGhlLXN0YWNrJTIwLiUyMC4lMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjAtLXJldmlzaW9uJTIwcmVmcyUyRnByJTJGMTA0",highlighted:`<span class="hljs-comment"># Upload files to a PR</span>
&gt;&gt;&gt; hf upload bigcode/the-stack . . --repo-type dataset --revision refs/pr/104
...`,wrap:!1}}),Ft=new g({props:{title:"Upload and create a PR",local:"upload-and-create-a-pr",headingTag:"h3"}}),Qt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBiaWdjb2RlJTJGdGhlLXN0YWNrJTIwLiUyMC4lMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjAtLXJldmlzaW9uJTIwcmVmcyUyRnByJTJGMTA0",highlighted:`<span class="hljs-comment"># Create a PR and upload the files to it</span>
&gt;&gt;&gt; hf upload bigcode/the-stack . . --repo-type dataset --revision refs/pr/104
https://huggingface.co/datasets/bigcode/the-stack/blob/refs%2Fpr%2F104/`,wrap:!1}}),zt=new g({props:{title:"Upload at regular intervals",local:"upload-at-regular-intervals",headingTag:"h3"}}),Et=new u({props:{code:"JTIzJTIwVXBsb2FkJTIwbmV3JTIwbG9ncyUyMGV2ZXJ5JTIwMTAlMjBtaW51dGVzJTBBaGYlMjB1cGxvYWQlMjB0cmFpbmluZy1tb2RlbCUyMGxvZ3MlMkYlMjAtLWV2ZXJ5JTNEMTA=",highlighted:`<span class="hljs-comment"># Upload new logs every 10 minutes</span>
hf upload training-model logs/ --every=10`,wrap:!1}}),qt=new g({props:{title:"Specify a commit message",local:"specify-a-commit-message",headingTag:"h3"}}),Ot=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMjAuJTIwLS1jb21taXQtbWVzc2FnZSUzRCUyMkVwb2NoJTIwMzQlMkY1MCUyMiUyMC0tY29tbWl0LWRlc2NyaXB0aW9uJTNEJTIyVmFsJTIwYWNjdXJhY3klM0ElMjA2OCUyNS4lMjBDaGVjayUyMHRlbnNvcmJvYXJkJTIwZm9yJTIwbW9yZSUyMGRldGFpbHMuJTIy",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models . --commit-message=<span class="hljs-string">&quot;Epoch 34/50&quot;</span> --commit-description=<span class="hljs-string">&quot;Val accuracy: 68%. Check tensorboard for more details.&quot;</span>
...
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),Kt=new g({props:{title:"Specify a token",local:"specify-a-token",headingTag:"h3"}}),tl=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMjAuJTIwLS10b2tlbiUzRGhmXyoqKio=",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models . --token=hf_****
...
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),ll=new g({props:{title:"Quiet mode",local:"quiet-mode",headingTag:"h3"}}),al=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMjAuJTIwLS1xdWlldA==",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models . --quiet
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),nl=new g({props:{title:"hf repo",local:"hf-repo",headingTag:"h2"}}),ol=new g({props:{title:"Create a repo",local:"create-a-repo",headingTag:"h3"}}),pl=new u({props:{code:"aGYlMjByZXBvJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWw=",highlighted:`&gt;&gt;&gt; hf repo create Wauplin/my-cool-model
Successfully created Wauplin/my-cool-model on the Hub.
Your repo is now available at https://huggingface.co/Wauplin/my-cool-model`,wrap:!1}}),cl=new u({props:{code:"aGYlMjByZXBvJTIwY3JlYXRlJTIwbXktY29vbC1kYXRhc2V0JTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTIwLS1wcml2YXRlJTBBaGYlMjByZXBvJTIwY3JlYXRlJTIwbXktZ3JhZGlvLXNwYWNlJTIwLS1yZXBvLXR5cGUlMjBzcGFjZSUyMC0tc3BhY2Utc2RrJTIwZ3JhZGlv",highlighted:`&gt;&gt;&gt; hf repo create my-cool-dataset --repo-type dataset --private
&gt;&gt;&gt; hf repo create my-gradio-space --repo-type space --space-sdk gradio`,wrap:!1}}),dl=new g({props:{title:"Delete a repo",local:"delete-a-repo",headingTag:"h3"}}),rl=new u({props:{code:"aGYlMjByZXBvJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWw=",highlighted:"&gt;&gt;&gt; hf repo delete Wauplin/my-cool-model",wrap:!1}}),ul=new u({props:{code:"aGYlMjByZXBvJTIwZGVsZXRlJTIwbXktY29vbC1kYXRhc2V0JTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTBBaGYlMjByZXBvJTIwZGVsZXRlJTIwbXktZ3JhZGlvLXNwYWNlJTIwLS1yZXBvLXR5cGUlMjBzcGFjZQ==",highlighted:`&gt;&gt;&gt; hf repo delete my-cool-dataset --repo-type dataset
&gt;&gt;&gt; hf repo delete my-gradio-space --repo-type space`,wrap:!1}}),gl=new g({props:{title:"Move a repo",local:"move-a-repo",headingTag:"h3"}}),yl=new u({props:{code:"aGYlMjByZXBvJTIwbW92ZSUyMG9sZC1uYW1lc3BhY2UlMkZteS1tb2RlbCUyMG5ldy1uYW1lc3BhY2UlMkZteS1tb2RlbA==",highlighted:"&gt;&gt;&gt; hf repo move old-namespace/my-model new-namespace/my-model",wrap:!1}}),Ml=new g({props:{title:"Update repo settings",local:"update-repo-settings",headingTag:"h3"}}),$l=new u({props:{code:"aGYlMjByZXBvJTIwc2V0dGluZ3MlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC0tZ2F0ZWQlMjBhdXRvJTBBaGYlMjByZXBvJTIwc2V0dGluZ3MlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC0tcHJpdmF0ZSUyMHRydWUlMEFoZiUyMHJlcG8lMjBzZXR0aW5ncyUyMFdhdXBsaW4lMkZteS1jb29sLW1vZGVsJTIwLS1wcml2YXRlJTIwZmFsc2U=",highlighted:`&gt;&gt;&gt; hf repo settings Wauplin/my-cool-model --gated auto
&gt;&gt;&gt; hf repo settings Wauplin/my-cool-model --private <span class="hljs-literal">true</span>
&gt;&gt;&gt; hf repo settings Wauplin/my-cool-model --private <span class="hljs-literal">false</span>`,wrap:!1}}),bl=new g({props:{title:"Manage branches",local:"manage-branches",headingTag:"h3"}}),Tl=new u({props:{code:"aGYlMjByZXBvJTIwYnJhbmNoJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjBkZXYlMEFoZiUyMHJlcG8lMjBicmFuY2glMjBjcmVhdGUlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMHJlbGVhc2UtMSUyMC0tcmV2aXNpb24lMjByZWZzJTJGcHIlMkYxMDQlMEFoZiUyMHJlcG8lMjBicmFuY2glMjBkZWxldGUlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMGRldg==",highlighted:`&gt;&gt;&gt; hf repo branch create Wauplin/my-cool-model dev
&gt;&gt;&gt; hf repo branch create Wauplin/my-cool-model release-1 --revision refs/pr/104
&gt;&gt;&gt; hf repo branch delete Wauplin/my-cool-model dev`,wrap:!1}}),jl=new g({props:{title:"hf repo-files",local:"hf-repo-files",headingTag:"h2"}}),Jl=new g({props:{title:"Delete files",local:"delete-files",headingTag:"h3"}}),Gl=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjBmb2xkZXIlMkY=",highlighted:`&gt;&gt;&gt; hf repo-files delete Wauplin/my-cool-model folder/
Files correctly deleted from repo. Commit: https://huggingface.co/Wauplin/my-cool-mo...`,wrap:!1}}),kl=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjBmaWxlLnR4dCUyMGZvbGRlciUyRnB5dG9yY2hfbW9kZWwuYmlu",highlighted:`&gt;&gt;&gt; hf repo-files delete Wauplin/my-cool-model file.txt folder/pytorch_model.bin
Files correctly deleted from repo. Commit: https://huggingface.co/Wauplin/my-cool-mo...`,wrap:!1}}),Zl=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjAlMjIqLnR4dCUyMiUyMCUyMmZvbGRlciUyRiouYmluJTIy",highlighted:`&gt;&gt;&gt; hf repo-files delete Wauplin/my-cool-model <span class="hljs-string">&quot;*.txt&quot;</span> <span class="hljs-string">&quot;folder/*.bin&quot;</span>
Files correctly deleted from repo. Commit: https://huggingface.co/Wauplin/my-cool-mo...`,wrap:!1}}),Bl=new g({props:{title:"Specify a token",local:"specify-a-token",headingTag:"h3"}}),Hl=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwLS10b2tlbiUzRGhmXyoqKiolMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMGZpbGUudHh0",highlighted:"&gt;&gt;&gt; hf repo-files delete --token=hf_**** Wauplin/my-cool-model file.txt",wrap:!1}}),Ll=new g({props:{title:"hf cache ls",local:"hf-cache-ls",headingTag:"h2"}}),Wl=new u({props:{code:"aGYlMjBjYWNoZSUyMGxzJTBB",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">ls</span>
ID                          SIZE     LAST_ACCESSED LAST_MODIFIED REFS        
--------------------------- -------- ------------- ------------- ----------- 
dataset/nyu-mll/glue          157.4M 2 days ago    2 days ago    main script 
model/LiquidAI/LFM2-VL-1.6B     3.2G 4 days ago    4 days ago    main        
model/microsoft/UserLM-8b      32.1G 4 days ago    4 days ago    main  

Found 3 repo(s) <span class="hljs-keyword">for</span> a total of 5 revision(s) and 35.5G on disk.`,wrap:!1}}),Xl=new u({props:{code:"aGYlMjBjYWNoZSUyMGxzJTIwLS1maWx0ZXIlMjAlMjJzaXplJTNFMzBnJTIyJTIwLS1yZXZpc2lvbnMlMEE=",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">ls</span> --filter <span class="hljs-string">&quot;size&gt;30g&quot;</span> --revisions
ID                        REVISION                                 SIZE     LAST_MODIFIED REFS 
------------------------- ---------------------------------------- -------- ------------- ---- 
model/microsoft/UserLM-8b be8f2069189bdf443e554c24e488ff3ff6952691    32.1G 4 days ago    main 

Found 1 repo(s) <span class="hljs-keyword">for</span> a total of 1 revision(s) and 32.1G on disk.`,wrap:!1}}),Sl=new u({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwJTI0KGhmJTIwY2FjaGUlMjBscyUyMC0tZmlsdGVyJTIwJTIyYWNjZXNzZWQlM0UxeSUyMiUyMC1xKSUyMC15",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> $(hf cache <span class="hljs-built_in">ls</span> --filter <span class="hljs-string">&quot;accessed&gt;1y&quot;</span> -q) -y
About to delete 2 repo(s) totalling 5.31G.
  - model/meta-llama/Llama-3.2-1B-Instruct (entire repo)
  - model/hexgrad/Kokoro-82M (entire repo)
Delete repo: ~/.cache/huggingface/hub/models--meta-llama--Llama-3.2-1B-Instruct
Delete repo: ~/.cache/huggingface/hub/models--hexgrad--Kokoro-82M
Cache deletion <span class="hljs-keyword">done</span>. Saved 5.31G.
Deleted 2 repo(s) and 2 revision(s); freed 5.31G.`,wrap:!1}}),Fl=new g({props:{title:"hf cache rm",local:"hf-cache-rm",headingTag:"h2"}}),Ql=new u({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZMaXF1aWRBSSUyRkxGTTItVkwtMS42Qg==",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> model/LiquidAI/LFM2-VL-1.6B
About to delete 1 repo(s) totalling 3.2G.
  - model/LiquidAI/LFM2-VL-1.6B (entire repo)
Proceed with deletion? [y/N]: y
Delete repo: ~/.cache/huggingface/hub/models--LiquidAI--LFM2-VL-1.6B
Cache deletion <span class="hljs-keyword">done</span>. Saved 3.2G.
Deleted 1 repo(s) and 2 revision(s); freed 3.2G.`,wrap:!1}}),Pl=new u({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZ0NS1zbWFsbCUyMDhmM2FkMWMlMjAtLWRyeS1ydW4=",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> model/t5-small 8f3ad1c --dry-run
About to delete 1 repo(s) and 1 revision(s) totalling 1.1G.
  - model/t5-small:
      8f3ad1c [main] 1.1G
Dry run: no files were deleted.`,wrap:!1}}),ql=new g({props:{title:"hf cache prune",local:"hf-cache-prune",headingTag:"h2"}}),Ol=new u({props:{code:"aGYlMjBjYWNoZSUyMHBydW5l",highlighted:`&gt;&gt;&gt; hf cache prune
About to delete 3 unreferenced revision(s) (2.4G total).
  - model/t5-small:
      1c610f6b [refs/pr/1] 820.1M
      d4ec9b72 [(detached)] 640.5M
  - dataset/google/fleurs:
      2b91c8dd [(detached)] 937.6M
Proceed? [y/N]: y
Deleted 3 unreferenced revision(s); freed 2.4G.`,wrap:!1}}),es=new g({props:{title:"hf cache verify",local:"hf-cache-verify",headingTag:"h2"}}),ss=new u({props:{code:"aGYlMjBjYWNoZSUyMHZlcmlmeSUyMGRlZXBzZWVrLWFpJTJGRGVlcFNlZWstT0NSJTBBJTBBaGYlMjBjYWNoZSUyMHZlcmlmeSUyMGRlZXBzZWVrLWFpJTJGRGVlcFNlZWstT0NSJTIwLS1yZXZpc2lvbiUyMHJlZnMlMkZwciUyRjUlMEFoZiUyMGNhY2hlJTIwdmVyaWZ5JTIwZGVlcHNlZWstYWklMkZEZWVwU2Vlay1PQ1IlMjAtLXJldmlzaW9uJTIwZWY5M2JmNGEzNzdjNWQ1ZWQ5ZGNhNzhlMGJjNGVhNTBiMjZmZTZhNCUwQSUwQWhmJTIwY2FjaGUlMjB2ZXJpZnklMjBtZSUyRnByaXZhdGUtbW9kZWwlMjAtLXRva2VuJTIwaGZfKioqJTBBJTBBaGYlMjBjYWNoZSUyMHZlcmlmeSUyMGthcnBhdGh5JTJGZmluZXdlYi1lZHUtMTAwYi1zaHVmZmxlJTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTBBJTBBaGYlMjBjYWNoZSUyMHZlcmlmeSUyMGRlZXBzZWVrLWFpJTJGRGVlcFNlZWstT0NSJTIwLS1sb2NhbC1kaXIlMjAlMkZwYXRoJTJGdG8lMkZyZXBv",highlighted:`<span class="hljs-comment"># Verify main revision of a model in cache</span>
&gt;&gt;&gt; hf cache verify deepseek-ai/DeepSeek-OCR

<span class="hljs-comment"># Verify a specific revision</span>
&gt;&gt;&gt; hf cache verify deepseek-ai/DeepSeek-OCR --revision refs/pr/5
&gt;&gt;&gt; hf cache verify deepseek-ai/DeepSeek-OCR --revision ef93bf4a377c5d5ed9dca78e0bc4ea50b26fe6a4

<span class="hljs-comment"># Verify a private repo</span>
&gt;&gt;&gt; hf cache verify me/private-model --token hf_***

<span class="hljs-comment"># Verify a dataset</span>
&gt;&gt;&gt; hf cache verify karpathy/fineweb-edu-100b-shuffle --repo-type dataset

<span class="hljs-comment"># Verify files in a local directory</span>
&gt;&gt;&gt; hf cache verify deepseek-ai/DeepSeek-OCR --local-dir /path/to/repo`,wrap:!1}}),ns=new u({props:{code:"aGYlMjBjYWNoZSUyMHZlcmlmeSUyMGRlZXBzZWVrLWFpJTJGRGVlcFNlZWstT0NSJTIwLS1mYWlsLW9uLW1pc3NpbmctZmlsZXMlMjAtLWZhaWwtb24tZXh0cmEtZmlsZXM=",highlighted:"&gt;&gt;&gt; hf cache verify deepseek-ai/DeepSeek-OCR --fail-on-missing-files --fail-on-extra-files",wrap:!1}}),os=new u({props:{code:"JUUyJTlDJTg1JTIwVmVyaWZpZWQlMjAxMyUyMGZpbGUocyklMjBmb3IlMjAnZGVlcHNlZWstYWklMkZEZWVwU2Vlay1PQ1InJTIwKG1vZGVsKSUyMGluJTIwfiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGaHViJTJGbW9kZWxzLS1tZXRhLWxsYW1hLS1MbGFtYS0zLjItMUItSW5zdHJ1Y3QlMkZzbmFwc2hvdHMlMkY5MjEzMTc2NzI2ZjU3NGI1NTY3OTBkZWI2NTc5MWUwYzVhYTQzOGI2JTBBJTIwJTIwQWxsJTIwY2hlY2tzdW1zJTIwbWF0Y2gu",highlighted:`✅ Verified 13 file(s) for &#x27;deepseek-ai/DeepSeek-OCR&#x27; (model) in ~/.cache/huggingface/hub/models--meta-llama--Llama-3.2-1B-Instruct/snapshots/9213176726f574b556790deb65791e0c5aa438b6
  All checksums match.`,wrap:!1}}),fs=new g({props:{title:"hf repo tag create",local:"hf-repo-tag-create",headingTag:"h2"}}),ms=new g({props:{title:"Tag a model",local:"tag-a-model",headingTag:"h3"}}),rs=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjB2MS4w",highlighted:`&gt;&gt;&gt; hf repo tag create Wauplin/my-cool-model v1.0
You are about to create tag v1.0 on model Wauplin/my-cool-model
Tag v1.0 created on Wauplin/my-cool-model`,wrap:!1}}),hs=new g({props:{title:"Tag a model at a specific revision",local:"tag-a-model-at-a-specific-revision",headingTag:"h3"}}),gs=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjB2MS4wJTIwLS1yZXZpc2lvbiUyMHJlZnMlMkZwciUyRjEwNA==",highlighted:`&gt;&gt;&gt; hf repo tag create Wauplin/my-cool-model v1.0 --revision refs/pr/104
You are about to create tag v1.0 on model Wauplin/my-cool-model
Tag v1.0 created on Wauplin/my-cool-model`,wrap:!1}}),ys=new g({props:{title:"Tag a dataset or a Space",local:"tag-a-dataset-or-a-space",headingTag:"h3"}}),$s=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwYmlnY29kZSUyRnRoZS1zdGFjayUyMHYxLjAlMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQ=",highlighted:`&gt;&gt;&gt; hf repo tag create bigcode/the-stack v1.0 --repo-type dataset
You are about to create tag v1.0 on dataset bigcode/the-stack
Tag v1.0 created on bigcode/the-stack`,wrap:!1}}),ws=new g({props:{title:"List tags",local:"list-tags",headingTag:"h3"}}),Ts=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwV2F1cGxpbiUyRmdyYWRpby1zcGFjZS1jaSUyMC1sJTIwLS1yZXBvLXR5cGUlMjBzcGFjZQ==",highlighted:`&gt;&gt;&gt; hf repo tag create Wauplin/gradio-space-ci -l --repo-type space
Tags <span class="hljs-keyword">for</span> space Wauplin/gradio-space-ci:
0.2.2
0.2.1
0.2.0
0.1.2
0.0.2
0.0.1`,wrap:!1}}),js=new g({props:{title:"Delete a tag",local:"delete-a-tag",headingTag:"h3"}}),Js=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwLWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMHYxLjA=",highlighted:`&gt;&gt;&gt; hf repo tag create -d Wauplin/my-cool-model v1.0
You are about to delete tag v1.0 on model Wauplin/my-cool-model
Proceed? [Y/n] y
Tag v1.0 deleted on Wauplin/my-cool-model`,wrap:!1}}),Cs=new g({props:{title:"hf env",local:"hf-env",headingTag:"h2"}}),Is=new u({props:{code:"aGYlMjBlbnYlMEElMEE=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">env</span>

Copy-and-paste the text below <span class="hljs-keyword">in</span> your GitHub issue.

- huggingface_hub version: 1.0.0.rc6
- Platform: Linux-6.8.0-85-generic-x86_64-with-glibc2.35
- Python version: 3.11.14
- Running <span class="hljs-keyword">in</span> iPython ?: No
- Running <span class="hljs-keyword">in</span> notebook ?: No
- Running <span class="hljs-keyword">in</span> Google Colab ?: No
- Running <span class="hljs-keyword">in</span> Google Colab Enterprise ?: No
- Token path ?: /home/wauplin/.cache/huggingface/token
- Has saved token ?: True
- Who am I ?: Wauplin
- Configured git credential helpers: store
- Installation method: unknown
- Torch: N/A
- httpx: 0.28.1
- hf_xet: 1.1.10
- gradio: 5.41.1
- tensorboard: N/A
- pydantic: 2.11.7
- ENDPOINT: https://huggingface.co
- HF_HUB_CACHE: /home/wauplin/.cache/huggingface/hub
- HF_ASSETS_CACHE: /home/wauplin/.cache/huggingface/assets
- HF_TOKEN_PATH: /home/wauplin/.cache/huggingface/token
- HF_STORED_TOKENS_PATH: /home/wauplin/.cache/huggingface/stored_tokens
- HF_HUB_OFFLINE: False
- HF_HUB_DISABLE_TELEMETRY: False
- HF_HUB_DISABLE_PROGRESS_BARS: None
- HF_HUB_DISABLE_SYMLINKS_WARNING: False
- HF_HUB_DISABLE_EXPERIMENTAL_WARNING: False
- HF_HUB_DISABLE_IMPLICIT_TOKEN: False
- HF_HUB_DISABLE_XET: False
- HF_HUB_ETAG_TIMEOUT: 10
- HF_HUB_DOWNLOAD_TIMEOUT: 10`,wrap:!1}}),ks=new g({props:{title:"hf jobs",local:"hf-jobs",headingTag:"h2"}}),Bs=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJ3ByaW50KCUyMkhlbGxvJTIwZnJvbSUyMHRoZSUyMGNsb3VkISUyMiknJTBBJTBBaGYlMjBqb2JzJTIwcnVuJTIwLS1mbGF2b3IlMjBhMTBnLXNtYWxsJTIwcHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjAlNUMlMEFweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMHRvcmNoJTNCJTIwcHJpbnQodG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSklMjIlMEElMEFoZiUyMGpvYnMlMjBydW4lMjAtLW5hbWVzcGFjZSUyMG15LW9yZy1uYW1lJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJTIycHJpbnQoJ1J1bm5pbmclMjBpbiUyMGFuJTIwb3JnJTIwYWNjb3VudCcpJTIyJTBBJTBBaGYlMjBqb2JzJTIwcnVuJTIwaGYuY28lMkZzcGFjZXMlMkZsaG9lc3RxJTJGZHVja2RiJTIwZHVja2RiJTIwLWMlMjAlMjJzZWxlY3QlMjAnaGVsbG8lMjB3b3JsZCclMjIlMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMG15X3NjcmlwdC5weQ==",highlighted:`<span class="hljs-comment"># Directly run Python code</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run python:3.12 python -c <span class="hljs-string">&#x27;print(&quot;Hello from the cloud!&quot;)&#x27;</span>

<span class="hljs-comment"># Use GPUs without any setup</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel \\
... python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>

<span class="hljs-comment"># Run in an organization account</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --namespace my-org-name python:3.12 python -c <span class="hljs-string">&quot;print(&#x27;Running in an org account&#x27;)&quot;</span>

<span class="hljs-comment"># Run from Hugging Face Spaces</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run hf.co/spaces/lhoestq/duckdb duckdb -c <span class="hljs-string">&quot;select &#x27;hello world&#x27;&quot;</span>

<span class="hljs-comment"># Run a Python script with \`uv\` (experimental)</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py`,wrap:!1}}),xs=new g({props:{title:"✨ Key Features",local:"-key-features",headingTag:"h3"}}),Ls=new g({props:{title:"Quick Start",local:"quick-start",headingTag:"h3"}}),Ys=new g({props:{title:"1. Run your first job",local:"1-run-your-first-job",headingTag:"h4"}}),Ws=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMg==",highlighted:`<span class="hljs-comment"># Run a simple Python script</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run python:3.12 python -c <span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>`,wrap:!1}}),Xs=new g({props:{title:"2. Check job status",local:"2-check-job-status",headingTag:"h4"}}),Ns=new u({props:{code:"aGYlMjBqb2JzJTIwcHMlMEElMEFoZiUyMGpvYnMlMjBpbnNwZWN0JTIwJTNDam9iX2lkJTNFJTBBJTBBaGYlMjBqb2JzJTIwbG9ncyUyMCUzQ2pvYl9pZCUzRSUwQSUwQWhmJTIwam9icyUyMGNhbmNlbCUyMCUzQ2pvYl9pZCUzRQ==",highlighted:`<span class="hljs-comment"># List your running jobs</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> ps

<span class="hljs-comment"># Inspect the status of a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> inspect &lt;job_id&gt;

<span class="hljs-comment"># View logs from a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> logs &lt;job_id&gt;

<span class="hljs-comment"># Cancel a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> cancel &lt;job_id&gt;`,wrap:!1}}),Vs=new g({props:{title:"3. Run on GPU",local:"3-run-on-gpu",headingTag:"h4"}}),Fs=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLS1mbGF2b3IlMjBhMTBnLXNtYWxsJTIwcHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjAlNUMlMEFweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMHRvcmNoJTNCJTIwcHJpbnQoZiUyMlRoaXMlMjBjb2RlJTIwcmFuJTIwd2l0aCUyMHRoZSUyMGZvbGxvd2luZyUyMEdQVSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCklN0QlMjIpJTIy",highlighted:`<span class="hljs-comment"># Use an A10G GPU to check PyTorch CUDA</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel \\
... python -c <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran with the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>`,wrap:!1}}),Qs=new u({props:{code:"VGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwTlZJRElBJTIwQTEwRw==",highlighted:"This code ran with the following GPU: NVIDIA A10G",wrap:!1}}),Ps=new g({props:{title:"Common Use Cases",local:"common-use-cases",headingTag:"h3"}}),qs=new g({props:{title:"Pass Environment variables and Secrets",local:"pass-environment-variables-and-secrets",headingTag:"h3"}}),Os=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLWUlMjBGT08lM0Rmb28lMjAtZSUyMEJBUiUzRGJhciUyMHB5dGhvbiUzQTMuMTIlMjBweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidGT08nJTVEJTJDJTIwb3MuZW52aXJvbiU1QidCQVInJTVEKSUyMg==",highlighted:`<span class="hljs-comment"># Pass environment variables</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run -e FOO=foo -e BAR=bar python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;FOO&#x27;], os.environ[&#x27;BAR&#x27;])&quot;</span>`,wrap:!1}}),Ks=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLS1lbnYtZmlsZSUyMC5lbnYlMjBweXRob24lM0EzLjEyJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjBvcyUzQiUyMHByaW50KG9zLmVudmlyb24lNUInRk9PJyU1RCUyQyUyMG9zLmVudmlyb24lNUInQkFSJyU1RCklMjI=",highlighted:`<span class="hljs-comment"># Pass an environment from a local .env file</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --env-file .<span class="hljs-built_in">env</span> python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;FOO&#x27;], os.environ[&#x27;BAR&#x27;])&quot;</span>`,wrap:!1}}),ea=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLXMlMjBNWV9TRUNSRVQlM0Rwc3N3cmQlMjBweXRob24lM0EzLjEyJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjBvcyUzQiUyMHByaW50KG9zLmVudmlyb24lNUInTVlfU0VDUkVUJyU1RCklMjI=",highlighted:`<span class="hljs-comment"># Pass secrets - they will be encrypted server side</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run -s MY_SECRET=psswrd python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;MY_SECRET&#x27;])&quot;</span>`,wrap:!1}}),ta=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLS1zZWNyZXRzLWZpbGUlMjAuZW52LnNlY3JldHMlMjBweXRob24lM0EzLjEyJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjBvcyUzQiUyMHByaW50KG9zLmVudmlyb24lNUInTVlfU0VDUkVUJyU1RCklMjI=",highlighted:`<span class="hljs-comment"># Pass secrets from a local .env.secrets file - they will be encrypted server side</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --secrets-file .env.secrets python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;MY_SECRET&#x27;])&quot;</span>`,wrap:!1}}),la=new g({props:{title:"Hardware",local:"hardware",headingTag:"h3"}}),ia=new g({props:{title:"UV Scripts (Experimental)",local:"uv-scripts-experimental",headingTag:"h3"}}),pa=new u({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjBteV9zY3JpcHQucHklMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMG15X3NjcmlwdC5weSUyMC0tcmVwbyUyMG15LXV2LXNjcmlwdHMlMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMG1sX3RyYWluaW5nLnB5JTIwLS1mbGF2b3IlMjBncHUtdDQtc21hbGwlMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMHByb2Nlc3MucHklMjBpbnB1dC5jc3YlMjBvdXRwdXQucGFycXVldCUwQSUwQWhmJTIwam9icyUyMHV2JTIwcnVuJTIwLS13aXRoJTIwdHJhbnNmb3JtZXJzJTIwLS13aXRoJTIwdG9yY2glMjB0cmFpbi5weSUwQSUwQWhmJTIwam9icyUyMHV2JTIwcnVuJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZzY3JpcHRzJTJGcmVzb2x2ZSUyRm1haW4lMkZleGFtcGxlLnB5JTBBJTBBaGYlMjBqb2JzJTIwdXYlMjBydW4lMjAtLXdpdGglMjBsaWdodGV2YWwlMjBweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMGxpZ2h0ZXZhbCUyMg==",highlighted:`<span class="hljs-comment"># Run a UV script (creates temporary repo)</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py

<span class="hljs-comment"># Run with persistent repo</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py --repo my-uv-scripts

<span class="hljs-comment"># Run with GPU</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run ml_training.py --flavor gpu-t4-small

<span class="hljs-comment"># Pass arguments to script</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run process.py input.csv output.parquet

<span class="hljs-comment"># Add dependencies</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run --with transformers --with torch train.py

<span class="hljs-comment"># Run a script directly from a URL</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run https://huggingface.co/datasets/username/scripts/resolve/main/example.py

<span class="hljs-comment"># Run a command</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run --with lighteval python -c <span class="hljs-string">&quot;import lighteval&quot;</span>`,wrap:!1}}),ca=new g({props:{title:"Scheduled Jobs",local:"scheduled-jobs",headingTag:"h3"}}),ra=new u({props:{code:"aGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcnVuJTIwJTQwaG91cmx5JTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJ3ByaW50KCUyMlRoaXMlMjBydW5zJTIwZXZlcnklMjBob3VyISUyMiknJTBBJTBBaGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcnVuJTIwJTIyKiUyRjUlMjAqJTIwKiUyMColMjAqJTIyJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJ3ByaW50KCUyMlRoaXMlMjBydW5zJTIwZXZlcnklMjA1JTIwbWludXRlcyElMjIpJyUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMHJ1biUyMCU0MGhvdXJseSUyMC0tZmxhdm9yJTIwYTEwZy1zbWFsbCUyMHB5dG9yY2glMkZweXRvcmNoJTNBMi42LjAtY3VkYTEyLjQtY3Vkbm45LWRldmVsJTIwJTVDJTBBcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KGYlMjJUaGlzJTIwY29kZSUyMHJhbiUyMHdpdGglMjB0aGUlMjBmb2xsb3dpbmclMjBHUFUlM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgpJTdEJTIyKSUyMiUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMHV2JTIwcnVuJTIwJTQwaG91cmx5JTIwbXlfc2NyaXB0LnB5",highlighted:`<span class="hljs-comment"># Schedule a job that runs every hour</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled run @hourly python:3.12 python -c <span class="hljs-string">&#x27;print(&quot;This runs every hour!&quot;)&#x27;</span>

<span class="hljs-comment"># Use the CRON syntax</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled run <span class="hljs-string">&quot;*/5 * * * *&quot;</span> python:3.12 python -c <span class="hljs-string">&#x27;print(&quot;This runs every 5 minutes!&quot;)&#x27;</span>

<span class="hljs-comment"># Schedule with GPU</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled run @hourly --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel \\
... python -c <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran with the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>

<span class="hljs-comment"># Schedule a UV script</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled uv run @hourly my_script.py`,wrap:!1}}),ga=new u({props:{code:"aGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcHMlMEElMEFoZiUyMGpvYnMlMjBzY2hlZHVsZWQlMjBpbnNwZWN0JTIwJTNDc2NoZWR1bGVkX2pvYl9pZCUzRSUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMHN1c3BlbmQlMjAlM0NzY2hlZHVsZWRfam9iX2lkJTNFJTBBJTBBaGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcmVzdW1lJTIwJTNDc2NoZWR1bGVkX2pvYl9pZCUzRSUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMGRlbGV0ZSUyMCUzQ3NjaGVkdWxlZF9qb2JfaWQlM0U=",highlighted:`<span class="hljs-comment"># List your active scheduled jobs</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled ps

<span class="hljs-comment"># Inspect the status of a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled inspect &lt;scheduled_job_id&gt;

<span class="hljs-comment"># Suspend (pause) a scheduled job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled <span class="hljs-built_in">suspend</span> &lt;scheduled_job_id&gt;

<span class="hljs-comment"># Resume a scheduled job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled resume &lt;scheduled_job_id&gt;

<span class="hljs-comment"># Delete a scheduled job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled delete &lt;scheduled_job_id&gt;`,wrap:!1}}),ya=new g({props:{title:"hf endpoints",local:"hf-endpoints",headingTag:"h2"}}),$a=new u({props:{code:"aGYlMjBlbmRwb2ludHMlMjBscyUwQSUwQWhmJTIwZW5kcG9pbnRzJTIwY2F0YWxvZyUyMGRlcGxveSUyMC0tcmVwbyUyMG9wZW5haSUyRmdwdC1vc3MtMTIwYiUyMC0tbmFtZSUyMG15LWVuZHBvaW50JTBBJTBBaGYlMjBlbmRwb2ludHMlMjBkZXBsb3klMjBteS1lbmRwb2ludCUyMC0tcmVwbyUyMGdwdDIlMjAtLWZyYW1ld29yayUyMHB5dG9yY2glMjAtLWFjY2VsZXJhdG9yJTIwY3B1JTIwLS1pbnN0YW5jZS1zaXplJTIweDIlMjAtLWluc3RhbmNlLXR5cGUlMjBpbnRlbC1pY2wlMEElMEFoZiUyMGVuZHBvaW50cyUyMGNhdGFsb2clMjBscyUwQSUwQWhmJTIwZW5kcG9pbnRzJTIwZGVzY3JpYmUlMjBteS1lbmRwb2ludCUwQSUwQWhmJTIwZW5kcG9pbnRzJTIwcGF1c2UlMjBteS1lbmRwb2ludCUwQSUwQWhmJTIwZW5kcG9pbnRzJTIwZGVsZXRlJTIwbXktZW5kcG9pbnQlMjAtLXllcw==",highlighted:`<span class="hljs-comment"># Lists endpoints in your namespace</span>
&gt;&gt;&gt; hf endpoints <span class="hljs-built_in">ls</span>

<span class="hljs-comment"># Deploy an endpoint from Model Catalog</span>
&gt;&gt;&gt; hf endpoints catalog deploy --repo openai/gpt-oss-120b --name my-endpoint

<span class="hljs-comment"># Deploy an endpoint from the Hugging Face Hub </span>
&gt;&gt;&gt; hf endpoints deploy my-endpoint --repo gpt2 --framework pytorch --accelerator cpu --instance-size x2 --instance-type intel-icl

<span class="hljs-comment"># List catalog entries</span>
&gt;&gt;&gt; hf endpoints catalog <span class="hljs-built_in">ls</span>

<span class="hljs-comment"># Show status and metadata</span>
&gt;&gt;&gt; hf endpoints describe my-endpoint

<span class="hljs-comment"># Pause the endpoint</span>
&gt;&gt;&gt; hf endpoints pause my-endpoint

<span class="hljs-comment"># Delete without confirmation prompt</span>
&gt;&gt;&gt; hf endpoints delete my-endpoint --<span class="hljs-built_in">yes</span>`,wrap:!1}}),wa=new td({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/cli.md"}}),{c(){M=d("meta"),ja=a(),ba=d("p"),va=a(),i(G.$$.fragment),Ja=a(),i(I.$$.fragment),Ua=a(),k=d("p"),k.innerHTML=Zf,Ca=a(),$=d("blockquote"),$.innerHTML=Bf,Ga=a(),i(_.$$.fragment),Ia=a(),Z=d("p"),Z.textContent=xf,ka=a(),i(B.$$.fragment),_a=a(),w=d("blockquote"),w.innerHTML=Hf,Za=a(),x=d("p"),x.innerHTML=Lf,Ba=a(),H=d("p"),H.textContent=Yf,xa=a(),i(L.$$.fragment),Ha=a(),Y=d("p"),Y.textContent=Wf,La=a(),i(W.$$.fragment),Ya=a(),R=d("p"),R.innerHTML=Rf,Wa=a(),X=d("p"),X.textContent=Xf,Ra=a(),i(N.$$.fragment),Xa=a(),V=d("p"),V.textContent=Nf,Na=a(),i(S.$$.fragment),Va=a(),F=d("p"),F.textContent=Vf,Sa=a(),i(A.$$.fragment),Fa=a(),Q=d("p"),Q.innerHTML=Sf,Aa=a(),b=d("blockquote"),b.innerHTML=Ff,Qa=a(),i(z.$$.fragment),za=a(),i(P.$$.fragment),Pa=a(),E=d("p"),E.innerHTML=Af,Ea=a(),q=d("p"),q.innerHTML=Qf,qa=a(),i(D.$$.fragment),Da=a(),O=d("p"),O.textContent=zf,Oa=a(),i(K.$$.fragment),Ka=a(),ee=d("p"),ee.innerHTML=Pf,en=a(),i(te.$$.fragment),tn=a(),i(le.$$.fragment),ln=a(),se=d("p"),se.innerHTML=Ef,sn=a(),i(ae.$$.fragment),an=a(),ne=d("p"),ne.innerHTML=qf,nn=a(),i(ie.$$.fragment),on=a(),oe=d("p"),oe.innerHTML=Df,pn=a(),pe=d("p"),pe.textContent=Of,fn=a(),i(fe.$$.fragment),cn=a(),ce=d("p"),ce.innerHTML=Kf,mn=a(),i(me.$$.fragment),dn=a(),de=d("p"),de.textContent=ec,rn=a(),i(re.$$.fragment),hn=a(),he=d("p"),he.innerHTML=tc,un=a(),i(ue.$$.fragment),gn=a(),ge=d("p"),ge.innerHTML=lc,yn=a(),i(ye.$$.fragment),Mn=a(),Me=d("p"),Me.textContent=sc,$n=a(),i($e.$$.fragment),wn=a(),we=d("p"),we.textContent=ac,bn=a(),be=d("p"),be.innerHTML=nc,Tn=a(),i(Te.$$.fragment),jn=a(),je=d("p"),je.innerHTML=ic,vn=a(),i(ve.$$.fragment),Jn=a(),i(Je.$$.fragment),Un=a(),Ue=d("p"),Ue.textContent=oc,Cn=a(),i(Ce.$$.fragment),Gn=a(),Ge=d("p"),Ge.textContent=pc,In=a(),Ie=d("p"),Ie.textContent=fc,kn=a(),i(ke.$$.fragment),_n=a(),i(_e.$$.fragment),Zn=a(),Ze=d("p"),Ze.textContent=cc,Bn=a(),i(Be.$$.fragment),xn=a(),i(xe.$$.fragment),Hn=a(),He=d("p"),He.textContent=mc,Ln=a(),i(Le.$$.fragment),Yn=a(),Ye=d("p"),Ye.innerHTML=dc,Wn=a(),i(We.$$.fragment),Rn=a(),i(Re.$$.fragment),Xn=a(),Xe=d("p"),Xe.innerHTML=rc,Nn=a(),i(Ne.$$.fragment),Vn=a(),i(Ve.$$.fragment),Sn=a(),Se=d("p"),Se.innerHTML=hc,Fn=a(),i(Fe.$$.fragment),An=a(),i(Ae.$$.fragment),Qn=a(),Qe=d("p"),Qe.innerHTML=uc,zn=a(),ze=d("p"),ze.innerHTML=gc,Pn=a(),T=d("blockquote"),T.innerHTML=yc,En=a(),i(Pe.$$.fragment),qn=a(),i(Ee.$$.fragment),Dn=a(),qe=d("p"),qe.innerHTML=Mc,On=a(),i(De.$$.fragment),Kn=a(),Oe=d("p"),Oe.innerHTML=$c,ei=a(),i(Ke.$$.fragment),ti=a(),et=d("p"),et.innerHTML=wc,li=a(),i(tt.$$.fragment),si=a(),i(lt.$$.fragment),ai=a(),st=d("p"),st.innerHTML=bc,ni=a(),i(at.$$.fragment),ii=a(),i(nt.$$.fragment),oi=a(),it=d("p"),it.innerHTML=Tc,pi=a(),i(ot.$$.fragment),fi=a(),i(pt.$$.fragment),ci=a(),ft=d("p"),ft.textContent=jc,mi=a(),i(ct.$$.fragment),di=a(),mt=d("p"),mt.innerHTML=vc,ri=a(),i(dt.$$.fragment),hi=a(),rt=d("p"),rt.innerHTML=Jc,ui=a(),i(ht.$$.fragment),gi=a(),ut=d("p"),ut.innerHTML=Uc,yi=a(),i(gt.$$.fragment),Mi=a(),i(yt.$$.fragment),$i=a(),Mt=d("p"),Mt.textContent=Cc,wi=a(),i($t.$$.fragment),bi=a(),wt=d("p"),wt.textContent=Gc,Ti=a(),i(bt.$$.fragment),ji=a(),j=d("blockquote"),j.innerHTML=Ic,vi=a(),Tt=d("p"),Tt.textContent=kc,Ji=a(),i(jt.$$.fragment),Ui=a(),vt=d("p"),vt.textContent=_c,Ci=a(),i(Jt.$$.fragment),Gi=a(),i(Ut.$$.fragment),Ii=a(),Ct=d("p"),Ct.innerHTML=Zc,ki=a(),i(Gt.$$.fragment),_i=a(),It=d("p"),It.innerHTML=Bc,Zi=a(),i(kt.$$.fragment),Bi=a(),i(_t.$$.fragment),xi=a(),Zt=d("p"),Zt.innerHTML=xc,Hi=a(),i(Bt.$$.fragment),Li=a(),i(xt.$$.fragment),Yi=a(),Ht=d("p"),Ht.innerHTML=Hc,Wi=a(),i(Lt.$$.fragment),Ri=a(),i(Yt.$$.fragment),Xi=a(),Wt=d("p"),Wt.innerHTML=Lc,Ni=a(),i(Rt.$$.fragment),Vi=a(),i(Xt.$$.fragment),Si=a(),Nt=d("p"),Nt.innerHTML=Yc,Fi=a(),i(Vt.$$.fragment),Ai=a(),St=d("p"),St.innerHTML=Wc,Qi=a(),i(Ft.$$.fragment),zi=a(),At=d("p"),At.innerHTML=Rc,Pi=a(),i(Qt.$$.fragment),Ei=a(),i(zt.$$.fragment),qi=a(),Pt=d("p"),Pt.innerHTML=Xc,Di=a(),i(Et.$$.fragment),Oi=a(),i(qt.$$.fragment),Ki=a(),Dt=d("p"),Dt.innerHTML=Nc,eo=a(),i(Ot.$$.fragment),to=a(),i(Kt.$$.fragment),lo=a(),el=d("p"),el.innerHTML=Vc,so=a(),i(tl.$$.fragment),ao=a(),i(ll.$$.fragment),no=a(),sl=d("p"),sl.innerHTML=Sc,io=a(),i(al.$$.fragment),oo=a(),i(nl.$$.fragment),po=a(),il=d("p"),il.innerHTML=Fc,fo=a(),i(ol.$$.fragment),co=a(),i(pl.$$.fragment),mo=a(),fl=d("p"),fl.textContent=Ac,ro=a(),i(cl.$$.fragment),ho=a(),ml=d("p"),ml.innerHTML=Qc,uo=a(),i(dl.$$.fragment),go=a(),i(rl.$$.fragment),yo=a(),hl=d("p"),hl.textContent=zc,Mo=a(),i(ul.$$.fragment),$o=a(),i(gl.$$.fragment),wo=a(),i(yl.$$.fragment),bo=a(),i(Ml.$$.fragment),To=a(),i($l.$$.fragment),jo=a(),wl=d("ul"),wl.innerHTML=Pc,vo=a(),i(bl.$$.fragment),Jo=a(),i(Tl.$$.fragment),Uo=a(),v=d("blockquote"),v.innerHTML=Ec,Co=a(),i(jl.$$.fragment),Go=a(),vl=d("p"),vl.innerHTML=qc,Io=a(),i(Jl.$$.fragment),ko=a(),Ul=d("p"),Ul.innerHTML=Dc,_o=a(),Cl=d("p"),Cl.textContent=Oc,Zo=a(),i(Gl.$$.fragment),Bo=a(),Il=d("p"),Il.textContent=Kc,xo=a(),i(kl.$$.fragment),Ho=a(),_l=d("p"),_l.textContent=em,Lo=a(),i(Zl.$$.fragment),Yo=a(),i(Bl.$$.fragment),Wo=a(),xl=d("p"),xl.innerHTML=tm,Ro=a(),i(Hl.$$.fragment),Xo=a(),i(Ll.$$.fragment),No=a(),Yl=d("p"),Yl.innerHTML=lm,Vo=a(),i(Wl.$$.fragment),So=a(),Rl=d("p"),Rl.innerHTML=sm,Fo=a(),i(Xl.$$.fragment),Ao=a(),Nl=d("p"),Nl.innerHTML=am,Qo=a(),Vl=d("p"),Vl.innerHTML=nm,zo=a(),i(Sl.$$.fragment),Po=a(),i(Fl.$$.fragment),Eo=a(),Al=d("p"),Al.innerHTML=im,qo=a(),i(Ql.$$.fragment),Do=a(),zl=d("p"),zl.innerHTML=om,Oo=a(),i(Pl.$$.fragment),Ko=a(),El=d("p"),El.innerHTML=pm,ep=a(),i(ql.$$.fragment),tp=a(),Dl=d("p"),Dl.innerHTML=fm,lp=a(),i(Ol.$$.fragment),sp=a(),Kl=d("p"),Kl.innerHTML=cm,ap=a(),i(es.$$.fragment),np=a(),ts=d("p"),ts.innerHTML=mm,ip=a(),ls=d("p"),ls.textContent=dm,op=a(),i(ss.$$.fragment),pp=a(),as=d("p"),as.textContent=rm,fp=a(),i(ns.$$.fragment),cp=a(),is=d("p"),is.textContent=hm,mp=a(),i(os.$$.fragment),dp=a(),ps=d("p"),ps.textContent=um,rp=a(),i(fs.$$.fragment),hp=a(),cs=d("p"),cs.innerHTML=gm,up=a(),i(ms.$$.fragment),gp=a(),ds=d("p"),ds.innerHTML=ym,yp=a(),i(rs.$$.fragment),Mp=a(),i(hs.$$.fragment),$p=a(),us=d("p"),us.innerHTML=Mm,wp=a(),i(gs.$$.fragment),bp=a(),i(ys.$$.fragment),Tp=a(),Ms=d("p"),Ms.innerHTML=$m,jp=a(),i($s.$$.fragment),vp=a(),i(ws.$$.fragment),Jp=a(),bs=d("p"),bs.innerHTML=wm,Up=a(),i(Ts.$$.fragment),Cp=a(),i(js.$$.fragment),Gp=a(),vs=d("p"),vs.innerHTML=bm,Ip=a(),i(Js.$$.fragment),kp=a(),Us=d("p"),Us.innerHTML=Tm,_p=a(),i(Cs.$$.fragment),Zp=a(),Gs=d("p"),Gs.innerHTML=jm,Bp=a(),i(Is.$$.fragment),xp=a(),i(ks.$$.fragment),Hp=a(),_s=d("p"),_s.textContent=vm,Lp=a(),Zs=d("p"),Zs.innerHTML=Jm,Yp=a(),i(Bs.$$.fragment),Wp=a(),i(xs.$$.fragment),Rp=a(),Hs=d("ul"),Hs.innerHTML=Um,Xp=a(),J=d("blockquote"),J.innerHTML=Cm,Np=a(),i(Ls.$$.fragment),Vp=a(),i(Ys.$$.fragment),Sp=a(),i(Ws.$$.fragment),Fp=a(),Rs=d("p"),Rs.innerHTML=Gm,Ap=a(),i(Xs.$$.fragment),Qp=a(),i(Ns.$$.fragment),zp=a(),i(Vs.$$.fragment),Pp=a(),Ss=d("p"),Ss.innerHTML=Im,Ep=a(),i(Fs.$$.fragment),qp=a(),As=d("p"),As.textContent=km,Dp=a(),i(Qs.$$.fragment),Op=a(),zs=d("p"),zs.textContent=_m,Kp=a(),i(Ps.$$.fragment),ef=a(),Es=d("ul"),Es.innerHTML=Zm,tf=a(),i(qs.$$.fragment),lf=a(),Ds=d("p"),Ds.textContent=Bm,sf=a(),i(Os.$$.fragment),af=a(),i(Ks.$$.fragment),nf=a(),i(ea.$$.fragment),of=a(),i(ta.$$.fragment),pf=a(),U=d("blockquote"),U.innerHTML=xm,ff=a(),i(la.$$.fragment),cf=a(),sa=d("p"),sa.innerHTML=Hm,mf=a(),aa=d("ul"),aa.innerHTML=Lm,df=a(),na=d("p"),na.innerHTML=Ym,rf=a(),i(ia.$$.fragment),hf=a(),oa=d("p"),oa.textContent=Wm,uf=a(),i(pa.$$.fragment),gf=a(),fa=d("p"),fa.innerHTML=Rm,yf=a(),i(ca.$$.fragment),Mf=a(),ma=d("p"),ma.textContent=Xm,$f=a(),da=d("p"),da.innerHTML=Nm,wf=a(),i(ra.$$.fragment),bf=a(),ha=d("p"),ha.innerHTML=Vm,Tf=a(),ua=d("p"),ua.textContent=Sm,jf=a(),i(ga.$$.fragment),vf=a(),i(ya.$$.fragment),Jf=a(),Ma=d("p"),Ma.innerHTML=Fm,Uf=a(),i($a.$$.fragment),Cf=a(),C=d("blockquote"),C.innerHTML=Am,Gf=a(),i(wa.$$.fragment),If=a(),Ta=d("p"),this.h()},l(e){const t=Om("svelte-u9bgzb",document.head);M=r(t,"META",{name:!0,content:!0}),t.forEach(l),ja=n(e),ba=r(e,"P",{}),Qm(ba).forEach(l),va=n(e),o(G.$$.fragment,e),Ja=n(e),o(I.$$.fragment,e),Ua=n(e),k=r(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1we55rn"&&(k.innerHTML=Zf),Ca=n(e),$=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h($)!=="svelte-6e9q8v"&&($.innerHTML=Bf),Ga=n(e),o(_.$$.fragment,e),Ia=n(e),Z=r(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-10zz5cd"&&(Z.textContent=xf),ka=n(e),o(B.$$.fragment,e),_a=n(e),w=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-1uvhxnq"&&(w.innerHTML=Hf),Za=n(e),x=r(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-gjtl8q"&&(x.innerHTML=Lf),Ba=n(e),H=r(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-qsqm1n"&&(H.textContent=Yf),xa=n(e),o(L.$$.fragment,e),Ha=n(e),Y=r(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-l29ize"&&(Y.textContent=Wf),La=n(e),o(W.$$.fragment,e),Ya=n(e),R=r(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-gjtl8q"&&(R.innerHTML=Rf),Wa=n(e),X=r(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-qsqm1n"&&(X.textContent=Xf),Ra=n(e),o(N.$$.fragment,e),Xa=n(e),V=r(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-l29ize"&&(V.textContent=Nf),Na=n(e),o(S.$$.fragment,e),Va=n(e),F=r(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-d7tj5q"&&(F.textContent=Vf),Sa=n(e),o(A.$$.fragment,e),Fa=n(e),Q=r(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-y5heuv"&&(Q.innerHTML=Sf),Aa=n(e),b=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(b)!=="svelte-1lo81f3"&&(b.innerHTML=Ff),Qa=n(e),o(z.$$.fragment,e),za=n(e),o(P.$$.fragment,e),Pa=n(e),E=r(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-181peu1"&&(E.innerHTML=Af),Ea=n(e),q=r(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1ago8fp"&&(q.innerHTML=Qf),qa=n(e),o(D.$$.fragment,e),Da=n(e),O=r(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1sf0sf1"&&(O.textContent=zf),Oa=n(e),o(K.$$.fragment,e),Ka=n(e),ee=r(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-kvynom"&&(ee.innerHTML=Pf),en=n(e),o(te.$$.fragment,e),tn=n(e),o(le.$$.fragment,e),ln=n(e),se=r(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-137ry2f"&&(se.innerHTML=Ef),sn=n(e),o(ae.$$.fragment,e),an=n(e),ne=r(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-1psu2ck"&&(ne.innerHTML=qf),nn=n(e),o(ie.$$.fragment,e),on=n(e),oe=r(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-17ebf3s"&&(oe.innerHTML=Df),pn=n(e),pe=r(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-mop55u"&&(pe.textContent=Of),fn=n(e),o(fe.$$.fragment,e),cn=n(e),ce=r(e,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-1ytpaeb"&&(ce.innerHTML=Kf),mn=n(e),o(me.$$.fragment,e),dn=n(e),de=r(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-dukffe"&&(de.textContent=ec),rn=n(e),o(re.$$.fragment,e),hn=n(e),he=r(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-pa4dpn"&&(he.innerHTML=tc),un=n(e),o(ue.$$.fragment,e),gn=n(e),ge=r(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-od6mgp"&&(ge.innerHTML=lc),yn=n(e),o(ye.$$.fragment,e),Mn=n(e),Me=r(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-1wtb0t3"&&(Me.textContent=sc),$n=n(e),o($e.$$.fragment,e),wn=n(e),we=r(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-1od3hyk"&&(we.textContent=ac),bn=n(e),be=r(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-nhbnel"&&(be.innerHTML=nc),Tn=n(e),o(Te.$$.fragment,e),jn=n(e),je=r(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1b0zk8b"&&(je.innerHTML=ic),vn=n(e),o(ve.$$.fragment,e),Jn=n(e),o(Je.$$.fragment,e),Un=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-w23prt"&&(Ue.textContent=oc),Cn=n(e),o(Ce.$$.fragment,e),Gn=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-yyvpy"&&(Ge.textContent=pc),In=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-1i2qcd2"&&(Ie.textContent=fc),kn=n(e),o(ke.$$.fragment,e),_n=n(e),o(_e.$$.fragment,e),Zn=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1bio1ld"&&(Ze.textContent=cc),Bn=n(e),o(Be.$$.fragment,e),xn=n(e),o(xe.$$.fragment,e),Hn=n(e),He=r(e,"P",{"data-svelte-h":!0}),h(He)!=="svelte-9c54x0"&&(He.textContent=mc),Ln=n(e),o(Le.$$.fragment,e),Yn=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-vn835n"&&(Ye.innerHTML=dc),Wn=n(e),o(We.$$.fragment,e),Rn=n(e),o(Re.$$.fragment,e),Xn=n(e),Xe=r(e,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-1ttrjh8"&&(Xe.innerHTML=rc),Nn=n(e),o(Ne.$$.fragment,e),Vn=n(e),o(Ve.$$.fragment,e),Sn=n(e),Se=r(e,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-60zmht"&&(Se.innerHTML=hc),Fn=n(e),o(Fe.$$.fragment,e),An=n(e),o(Ae.$$.fragment,e),Qn=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-1el3i2v"&&(Qe.innerHTML=uc),zn=n(e),ze=r(e,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-i0s4w6"&&(ze.innerHTML=gc),Pn=n(e),T=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(T)!=="svelte-qjt4ju"&&(T.innerHTML=yc),En=n(e),o(Pe.$$.fragment,e),qn=n(e),o(Ee.$$.fragment,e),Dn=n(e),qe=r(e,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-qlsyc4"&&(qe.innerHTML=Mc),On=n(e),o(De.$$.fragment,e),Kn=n(e),Oe=r(e,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-l2ug5a"&&(Oe.innerHTML=$c),ei=n(e),o(Ke.$$.fragment,e),ti=n(e),et=r(e,"P",{"data-svelte-h":!0}),h(et)!=="svelte-13ae2or"&&(et.innerHTML=wc),li=n(e),o(tt.$$.fragment,e),si=n(e),o(lt.$$.fragment,e),ai=n(e),st=r(e,"P",{"data-svelte-h":!0}),h(st)!=="svelte-1eocq9t"&&(st.innerHTML=bc),ni=n(e),o(at.$$.fragment,e),ii=n(e),o(nt.$$.fragment,e),oi=n(e),it=r(e,"P",{"data-svelte-h":!0}),h(it)!=="svelte-ly469j"&&(it.innerHTML=Tc),pi=n(e),o(ot.$$.fragment,e),fi=n(e),o(pt.$$.fragment,e),ci=n(e),ft=r(e,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-19x7buo"&&(ft.textContent=jc),mi=n(e),o(ct.$$.fragment,e),di=n(e),mt=r(e,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-1fv8i0u"&&(mt.innerHTML=vc),ri=n(e),o(dt.$$.fragment,e),hi=n(e),rt=r(e,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-1r9xuva"&&(rt.innerHTML=Jc),ui=n(e),o(ht.$$.fragment,e),gi=n(e),ut=r(e,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-18scwa0"&&(ut.innerHTML=Uc),yi=n(e),o(gt.$$.fragment,e),Mi=n(e),o(yt.$$.fragment,e),$i=n(e),Mt=r(e,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-1lf6ab7"&&(Mt.textContent=Cc),wi=n(e),o($t.$$.fragment,e),bi=n(e),wt=r(e,"P",{"data-svelte-h":!0}),h(wt)!=="svelte-1qct02s"&&(wt.textContent=Gc),Ti=n(e),o(bt.$$.fragment,e),ji=n(e),j=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(j)!=="svelte-1v46bff"&&(j.innerHTML=Ic),vi=n(e),Tt=r(e,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-m60jhs"&&(Tt.textContent=kc),Ji=n(e),o(jt.$$.fragment,e),Ui=n(e),vt=r(e,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-kcq38o"&&(vt.textContent=_c),Ci=n(e),o(Jt.$$.fragment,e),Gi=n(e),o(Ut.$$.fragment,e),Ii=n(e),Ct=r(e,"P",{"data-svelte-h":!0}),h(Ct)!=="svelte-1mpi1wt"&&(Ct.innerHTML=Zc),ki=n(e),o(Gt.$$.fragment,e),_i=n(e),It=r(e,"P",{"data-svelte-h":!0}),h(It)!=="svelte-1iulhrs"&&(It.innerHTML=Bc),Zi=n(e),o(kt.$$.fragment,e),Bi=n(e),o(_t.$$.fragment,e),xi=n(e),Zt=r(e,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-1ywqnga"&&(Zt.innerHTML=xc),Hi=n(e),o(Bt.$$.fragment,e),Li=n(e),o(xt.$$.fragment,e),Yi=n(e),Ht=r(e,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-txm5rx"&&(Ht.innerHTML=Hc),Wi=n(e),o(Lt.$$.fragment,e),Ri=n(e),o(Yt.$$.fragment,e),Xi=n(e),Wt=r(e,"P",{"data-svelte-h":!0}),h(Wt)!=="svelte-1xth5d1"&&(Wt.innerHTML=Lc),Ni=n(e),o(Rt.$$.fragment,e),Vi=n(e),o(Xt.$$.fragment,e),Si=n(e),Nt=r(e,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-1l1ub93"&&(Nt.innerHTML=Yc),Fi=n(e),o(Vt.$$.fragment,e),Ai=n(e),St=r(e,"P",{"data-svelte-h":!0}),h(St)!=="svelte-1eodha9"&&(St.innerHTML=Wc),Qi=n(e),o(Ft.$$.fragment,e),zi=n(e),At=r(e,"P",{"data-svelte-h":!0}),h(At)!=="svelte-1mne3q7"&&(At.innerHTML=Rc),Pi=n(e),o(Qt.$$.fragment,e),Ei=n(e),o(zt.$$.fragment,e),qi=n(e),Pt=r(e,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-9drzqd"&&(Pt.innerHTML=Xc),Di=n(e),o(Et.$$.fragment,e),Oi=n(e),o(qt.$$.fragment,e),Ki=n(e),Dt=r(e,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-14b5hg3"&&(Dt.innerHTML=Nc),eo=n(e),o(Ot.$$.fragment,e),to=n(e),o(Kt.$$.fragment,e),lo=n(e),el=r(e,"P",{"data-svelte-h":!0}),h(el)!=="svelte-1vujg1i"&&(el.innerHTML=Vc),so=n(e),o(tl.$$.fragment,e),ao=n(e),o(ll.$$.fragment,e),no=n(e),sl=r(e,"P",{"data-svelte-h":!0}),h(sl)!=="svelte-11zzu90"&&(sl.innerHTML=Sc),io=n(e),o(al.$$.fragment,e),oo=n(e),o(nl.$$.fragment,e),po=n(e),il=r(e,"P",{"data-svelte-h":!0}),h(il)!=="svelte-1bknus5"&&(il.innerHTML=Fc),fo=n(e),o(ol.$$.fragment,e),co=n(e),o(pl.$$.fragment,e),mo=n(e),fl=r(e,"P",{"data-svelte-h":!0}),h(fl)!=="svelte-ji1ygu"&&(fl.textContent=Ac),ro=n(e),o(cl.$$.fragment,e),ho=n(e),ml=r(e,"P",{"data-svelte-h":!0}),h(ml)!=="svelte-akzc6j"&&(ml.innerHTML=Qc),uo=n(e),o(dl.$$.fragment,e),go=n(e),o(rl.$$.fragment,e),yo=n(e),hl=r(e,"P",{"data-svelte-h":!0}),h(hl)!=="svelte-rlqaq9"&&(hl.textContent=zc),Mo=n(e),o(ul.$$.fragment,e),$o=n(e),o(gl.$$.fragment,e),wo=n(e),o(yl.$$.fragment,e),bo=n(e),o(Ml.$$.fragment,e),To=n(e),o($l.$$.fragment,e),jo=n(e),wl=r(e,"UL",{"data-svelte-h":!0}),h(wl)!=="svelte-9gpkzp"&&(wl.innerHTML=Pc),vo=n(e),o(bl.$$.fragment,e),Jo=n(e),o(Tl.$$.fragment,e),Uo=n(e),v=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(v)!=="svelte-1aepcmc"&&(v.innerHTML=Ec),Co=n(e),o(jl.$$.fragment,e),Go=n(e),vl=r(e,"P",{"data-svelte-h":!0}),h(vl)!=="svelte-7je92s"&&(vl.innerHTML=qc),Io=n(e),o(Jl.$$.fragment,e),ko=n(e),Ul=r(e,"P",{"data-svelte-h":!0}),h(Ul)!=="svelte-1rlrd4r"&&(Ul.innerHTML=Dc),_o=n(e),Cl=r(e,"P",{"data-svelte-h":!0}),h(Cl)!=="svelte-coq0se"&&(Cl.textContent=Oc),Zo=n(e),o(Gl.$$.fragment,e),Bo=n(e),Il=r(e,"P",{"data-svelte-h":!0}),h(Il)!=="svelte-1c2af94"&&(Il.textContent=Kc),xo=n(e),o(kl.$$.fragment,e),Ho=n(e),_l=r(e,"P",{"data-svelte-h":!0}),h(_l)!=="svelte-1ehfkwh"&&(_l.textContent=em),Lo=n(e),o(Zl.$$.fragment,e),Yo=n(e),o(Bl.$$.fragment,e),Wo=n(e),xl=r(e,"P",{"data-svelte-h":!0}),h(xl)!=="svelte-di7lx0"&&(xl.innerHTML=tm),Ro=n(e),o(Hl.$$.fragment,e),Xo=n(e),o(Ll.$$.fragment,e),No=n(e),Yl=r(e,"P",{"data-svelte-h":!0}),h(Yl)!=="svelte-12x038b"&&(Yl.innerHTML=lm),Vo=n(e),o(Wl.$$.fragment,e),So=n(e),Rl=r(e,"P",{"data-svelte-h":!0}),h(Rl)!=="svelte-1ujkuhn"&&(Rl.innerHTML=sm),Fo=n(e),o(Xl.$$.fragment,e),Ao=n(e),Nl=r(e,"P",{"data-svelte-h":!0}),h(Nl)!=="svelte-7ld5lh"&&(Nl.innerHTML=am),Qo=n(e),Vl=r(e,"P",{"data-svelte-h":!0}),h(Vl)!=="svelte-h2s478"&&(Vl.innerHTML=nm),zo=n(e),o(Sl.$$.fragment,e),Po=n(e),o(Fl.$$.fragment,e),Eo=n(e),Al=r(e,"P",{"data-svelte-h":!0}),h(Al)!=="svelte-1n112qz"&&(Al.innerHTML=im),qo=n(e),o(Ql.$$.fragment,e),Do=n(e),zl=r(e,"P",{"data-svelte-h":!0}),h(zl)!=="svelte-my607i"&&(zl.innerHTML=om),Oo=n(e),o(Pl.$$.fragment,e),Ko=n(e),El=r(e,"P",{"data-svelte-h":!0}),h(El)!=="svelte-5qqgdh"&&(El.innerHTML=pm),ep=n(e),o(ql.$$.fragment,e),tp=n(e),Dl=r(e,"P",{"data-svelte-h":!0}),h(Dl)!=="svelte-18cutgs"&&(Dl.innerHTML=fm),lp=n(e),o(Ol.$$.fragment,e),sp=n(e),Kl=r(e,"P",{"data-svelte-h":!0}),h(Kl)!=="svelte-8hn497"&&(Kl.innerHTML=cm),ap=n(e),o(es.$$.fragment,e),np=n(e),ts=r(e,"P",{"data-svelte-h":!0}),h(ts)!=="svelte-l57kr4"&&(ts.innerHTML=mm),ip=n(e),ls=r(e,"P",{"data-svelte-h":!0}),h(ls)!=="svelte-kvfsh7"&&(ls.textContent=dm),op=n(e),o(ss.$$.fragment,e),pp=n(e),as=r(e,"P",{"data-svelte-h":!0}),h(as)!=="svelte-i6w7m5"&&(as.textContent=rm),fp=n(e),o(ns.$$.fragment,e),cp=n(e),is=r(e,"P",{"data-svelte-h":!0}),h(is)!=="svelte-oop5er"&&(is.textContent=hm),mp=n(e),o(os.$$.fragment,e),dp=n(e),ps=r(e,"P",{"data-svelte-h":!0}),h(ps)!=="svelte-1oltlj5"&&(ps.textContent=um),rp=n(e),o(fs.$$.fragment,e),hp=n(e),cs=r(e,"P",{"data-svelte-h":!0}),h(cs)!=="svelte-19enu7t"&&(cs.innerHTML=gm),up=n(e),o(ms.$$.fragment,e),gp=n(e),ds=r(e,"P",{"data-svelte-h":!0}),h(ds)!=="svelte-128u7bb"&&(ds.innerHTML=ym),yp=n(e),o(rs.$$.fragment,e),Mp=n(e),o(hs.$$.fragment,e),$p=n(e),us=r(e,"P",{"data-svelte-h":!0}),h(us)!=="svelte-1vhfxqv"&&(us.innerHTML=Mm),wp=n(e),o(gs.$$.fragment,e),bp=n(e),o(ys.$$.fragment,e),Tp=n(e),Ms=r(e,"P",{"data-svelte-h":!0}),h(Ms)!=="svelte-10hqfbc"&&(Ms.innerHTML=$m),jp=n(e),o($s.$$.fragment,e),vp=n(e),o(ws.$$.fragment,e),Jp=n(e),bs=r(e,"P",{"data-svelte-h":!0}),h(bs)!=="svelte-1hhwdda"&&(bs.innerHTML=wm),Up=n(e),o(Ts.$$.fragment,e),Cp=n(e),o(js.$$.fragment,e),Gp=n(e),vs=r(e,"P",{"data-svelte-h":!0}),h(vs)!=="svelte-1lxlrp3"&&(vs.innerHTML=bm),Ip=n(e),o(Js.$$.fragment,e),kp=n(e),Us=r(e,"P",{"data-svelte-h":!0}),h(Us)!=="svelte-1j69va"&&(Us.innerHTML=Tm),_p=n(e),o(Cs.$$.fragment,e),Zp=n(e),Gs=r(e,"P",{"data-svelte-h":!0}),h(Gs)!=="svelte-vjzrog"&&(Gs.innerHTML=jm),Bp=n(e),o(Is.$$.fragment,e),xp=n(e),o(ks.$$.fragment,e),Hp=n(e),_s=r(e,"P",{"data-svelte-h":!0}),h(_s)!=="svelte-bmrfz1"&&(_s.textContent=vm),Lp=n(e),Zs=r(e,"P",{"data-svelte-h":!0}),h(Zs)!=="svelte-10n6zcq"&&(Zs.innerHTML=Jm),Yp=n(e),o(Bs.$$.fragment,e),Wp=n(e),o(xs.$$.fragment,e),Rp=n(e),Hs=r(e,"UL",{"data-svelte-h":!0}),h(Hs)!=="svelte-oddjsg"&&(Hs.innerHTML=Um),Xp=n(e),J=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(J)!=="svelte-686p08"&&(J.innerHTML=Cm),Np=n(e),o(Ls.$$.fragment,e),Vp=n(e),o(Ys.$$.fragment,e),Sp=n(e),o(Ws.$$.fragment,e),Fp=n(e),Rs=r(e,"P",{"data-svelte-h":!0}),h(Rs)!=="svelte-7rpon3"&&(Rs.innerHTML=Gm),Ap=n(e),o(Xs.$$.fragment,e),Qp=n(e),o(Ns.$$.fragment,e),zp=n(e),o(Vs.$$.fragment,e),Pp=n(e),Ss=r(e,"P",{"data-svelte-h":!0}),h(Ss)!=="svelte-stito2"&&(Ss.innerHTML=Im),Ep=n(e),o(Fs.$$.fragment,e),qp=n(e),As=r(e,"P",{"data-svelte-h":!0}),h(As)!=="svelte-130z5ko"&&(As.textContent=km),Dp=n(e),o(Qs.$$.fragment,e),Op=n(e),zs=r(e,"P",{"data-svelte-h":!0}),h(zs)!=="svelte-u6u7ww"&&(zs.textContent=_m),Kp=n(e),o(Ps.$$.fragment,e),ef=n(e),Es=r(e,"UL",{"data-svelte-h":!0}),h(Es)!=="svelte-6zsta5"&&(Es.innerHTML=Zm),tf=n(e),o(qs.$$.fragment,e),lf=n(e),Ds=r(e,"P",{"data-svelte-h":!0}),h(Ds)!=="svelte-1vsg713"&&(Ds.textContent=Bm),sf=n(e),o(Os.$$.fragment,e),af=n(e),o(Ks.$$.fragment,e),nf=n(e),o(ea.$$.fragment,e),of=n(e),o(ta.$$.fragment,e),pf=n(e),U=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(U)!=="svelte-13grfj0"&&(U.innerHTML=xm),ff=n(e),o(la.$$.fragment,e),cf=n(e),sa=r(e,"P",{"data-svelte-h":!0}),h(sa)!=="svelte-31jqx4"&&(sa.innerHTML=Hm),mf=n(e),aa=r(e,"UL",{"data-svelte-h":!0}),h(aa)!=="svelte-13lveum"&&(aa.innerHTML=Lm),df=n(e),na=r(e,"P",{"data-svelte-h":!0}),h(na)!=="svelte-2bse8c"&&(na.innerHTML=Ym),rf=n(e),o(ia.$$.fragment,e),hf=n(e),oa=r(e,"P",{"data-svelte-h":!0}),h(oa)!=="svelte-qbe5en"&&(oa.textContent=Wm),uf=n(e),o(pa.$$.fragment,e),gf=n(e),fa=r(e,"P",{"data-svelte-h":!0}),h(fa)!=="svelte-1dnltsa"&&(fa.innerHTML=Rm),yf=n(e),o(ca.$$.fragment,e),Mf=n(e),ma=r(e,"P",{"data-svelte-h":!0}),h(ma)!=="svelte-1hrxwrr"&&(ma.textContent=Xm),$f=n(e),da=r(e,"P",{"data-svelte-h":!0}),h(da)!=="svelte-10ad6rn"&&(da.innerHTML=Nm),wf=n(e),o(ra.$$.fragment,e),bf=n(e),ha=r(e,"P",{"data-svelte-h":!0}),h(ha)!=="svelte-5l4bl6"&&(ha.innerHTML=Vm),Tf=n(e),ua=r(e,"P",{"data-svelte-h":!0}),h(ua)!=="svelte-l9xue4"&&(ua.textContent=Sm),jf=n(e),o(ga.$$.fragment,e),vf=n(e),o(ya.$$.fragment,e),Jf=n(e),Ma=r(e,"P",{"data-svelte-h":!0}),h(Ma)!=="svelte-qja6ex"&&(Ma.innerHTML=Fm),Uf=n(e),o($a.$$.fragment,e),Cf=n(e),C=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(C)!=="svelte-1r8xtrv"&&(C.innerHTML=Am),Gf=n(e),o(wa.$$.fragment,e),If=n(e),Ta=r(e,"P",{}),Qm(Ta).forEach(l),this.h()},h(){y(M,"name","hf:doc:metadata"),y(M,"content",sd),y($,"class","tip"),y(w,"class","tip"),y(b,"class","tip"),y(T,"class","tip"),y(j,"class","tip"),y(v,"class","tip"),y(J,"class","tip"),y(U,"class","tip"),y(C,"class","tip")},m(e,t){Km(document.head,M),s(e,ja,t),s(e,ba,t),s(e,va,t),p(G,e,t),s(e,Ja,t),p(I,e,t),s(e,Ua,t),s(e,k,t),s(e,Ca,t),s(e,$,t),s(e,Ga,t),p(_,e,t),s(e,Ia,t),s(e,Z,t),s(e,ka,t),p(B,e,t),s(e,_a,t),s(e,w,t),s(e,Za,t),s(e,x,t),s(e,Ba,t),s(e,H,t),s(e,xa,t),p(L,e,t),s(e,Ha,t),s(e,Y,t),s(e,La,t),p(W,e,t),s(e,Ya,t),s(e,R,t),s(e,Wa,t),s(e,X,t),s(e,Ra,t),p(N,e,t),s(e,Xa,t),s(e,V,t),s(e,Na,t),p(S,e,t),s(e,Va,t),s(e,F,t),s(e,Sa,t),p(A,e,t),s(e,Fa,t),s(e,Q,t),s(e,Aa,t),s(e,b,t),s(e,Qa,t),p(z,e,t),s(e,za,t),p(P,e,t),s(e,Pa,t),s(e,E,t),s(e,Ea,t),s(e,q,t),s(e,qa,t),p(D,e,t),s(e,Da,t),s(e,O,t),s(e,Oa,t),p(K,e,t),s(e,Ka,t),s(e,ee,t),s(e,en,t),p(te,e,t),s(e,tn,t),p(le,e,t),s(e,ln,t),s(e,se,t),s(e,sn,t),p(ae,e,t),s(e,an,t),s(e,ne,t),s(e,nn,t),p(ie,e,t),s(e,on,t),s(e,oe,t),s(e,pn,t),s(e,pe,t),s(e,fn,t),p(fe,e,t),s(e,cn,t),s(e,ce,t),s(e,mn,t),p(me,e,t),s(e,dn,t),s(e,de,t),s(e,rn,t),p(re,e,t),s(e,hn,t),s(e,he,t),s(e,un,t),p(ue,e,t),s(e,gn,t),s(e,ge,t),s(e,yn,t),p(ye,e,t),s(e,Mn,t),s(e,Me,t),s(e,$n,t),p($e,e,t),s(e,wn,t),s(e,we,t),s(e,bn,t),s(e,be,t),s(e,Tn,t),p(Te,e,t),s(e,jn,t),s(e,je,t),s(e,vn,t),p(ve,e,t),s(e,Jn,t),p(Je,e,t),s(e,Un,t),s(e,Ue,t),s(e,Cn,t),p(Ce,e,t),s(e,Gn,t),s(e,Ge,t),s(e,In,t),s(e,Ie,t),s(e,kn,t),p(ke,e,t),s(e,_n,t),p(_e,e,t),s(e,Zn,t),s(e,Ze,t),s(e,Bn,t),p(Be,e,t),s(e,xn,t),p(xe,e,t),s(e,Hn,t),s(e,He,t),s(e,Ln,t),p(Le,e,t),s(e,Yn,t),s(e,Ye,t),s(e,Wn,t),p(We,e,t),s(e,Rn,t),p(Re,e,t),s(e,Xn,t),s(e,Xe,t),s(e,Nn,t),p(Ne,e,t),s(e,Vn,t),p(Ve,e,t),s(e,Sn,t),s(e,Se,t),s(e,Fn,t),p(Fe,e,t),s(e,An,t),p(Ae,e,t),s(e,Qn,t),s(e,Qe,t),s(e,zn,t),s(e,ze,t),s(e,Pn,t),s(e,T,t),s(e,En,t),p(Pe,e,t),s(e,qn,t),p(Ee,e,t),s(e,Dn,t),s(e,qe,t),s(e,On,t),p(De,e,t),s(e,Kn,t),s(e,Oe,t),s(e,ei,t),p(Ke,e,t),s(e,ti,t),s(e,et,t),s(e,li,t),p(tt,e,t),s(e,si,t),p(lt,e,t),s(e,ai,t),s(e,st,t),s(e,ni,t),p(at,e,t),s(e,ii,t),p(nt,e,t),s(e,oi,t),s(e,it,t),s(e,pi,t),p(ot,e,t),s(e,fi,t),p(pt,e,t),s(e,ci,t),s(e,ft,t),s(e,mi,t),p(ct,e,t),s(e,di,t),s(e,mt,t),s(e,ri,t),p(dt,e,t),s(e,hi,t),s(e,rt,t),s(e,ui,t),p(ht,e,t),s(e,gi,t),s(e,ut,t),s(e,yi,t),p(gt,e,t),s(e,Mi,t),p(yt,e,t),s(e,$i,t),s(e,Mt,t),s(e,wi,t),p($t,e,t),s(e,bi,t),s(e,wt,t),s(e,Ti,t),p(bt,e,t),s(e,ji,t),s(e,j,t),s(e,vi,t),s(e,Tt,t),s(e,Ji,t),p(jt,e,t),s(e,Ui,t),s(e,vt,t),s(e,Ci,t),p(Jt,e,t),s(e,Gi,t),p(Ut,e,t),s(e,Ii,t),s(e,Ct,t),s(e,ki,t),p(Gt,e,t),s(e,_i,t),s(e,It,t),s(e,Zi,t),p(kt,e,t),s(e,Bi,t),p(_t,e,t),s(e,xi,t),s(e,Zt,t),s(e,Hi,t),p(Bt,e,t),s(e,Li,t),p(xt,e,t),s(e,Yi,t),s(e,Ht,t),s(e,Wi,t),p(Lt,e,t),s(e,Ri,t),p(Yt,e,t),s(e,Xi,t),s(e,Wt,t),s(e,Ni,t),p(Rt,e,t),s(e,Vi,t),p(Xt,e,t),s(e,Si,t),s(e,Nt,t),s(e,Fi,t),p(Vt,e,t),s(e,Ai,t),s(e,St,t),s(e,Qi,t),p(Ft,e,t),s(e,zi,t),s(e,At,t),s(e,Pi,t),p(Qt,e,t),s(e,Ei,t),p(zt,e,t),s(e,qi,t),s(e,Pt,t),s(e,Di,t),p(Et,e,t),s(e,Oi,t),p(qt,e,t),s(e,Ki,t),s(e,Dt,t),s(e,eo,t),p(Ot,e,t),s(e,to,t),p(Kt,e,t),s(e,lo,t),s(e,el,t),s(e,so,t),p(tl,e,t),s(e,ao,t),p(ll,e,t),s(e,no,t),s(e,sl,t),s(e,io,t),p(al,e,t),s(e,oo,t),p(nl,e,t),s(e,po,t),s(e,il,t),s(e,fo,t),p(ol,e,t),s(e,co,t),p(pl,e,t),s(e,mo,t),s(e,fl,t),s(e,ro,t),p(cl,e,t),s(e,ho,t),s(e,ml,t),s(e,uo,t),p(dl,e,t),s(e,go,t),p(rl,e,t),s(e,yo,t),s(e,hl,t),s(e,Mo,t),p(ul,e,t),s(e,$o,t),p(gl,e,t),s(e,wo,t),p(yl,e,t),s(e,bo,t),p(Ml,e,t),s(e,To,t),p($l,e,t),s(e,jo,t),s(e,wl,t),s(e,vo,t),p(bl,e,t),s(e,Jo,t),p(Tl,e,t),s(e,Uo,t),s(e,v,t),s(e,Co,t),p(jl,e,t),s(e,Go,t),s(e,vl,t),s(e,Io,t),p(Jl,e,t),s(e,ko,t),s(e,Ul,t),s(e,_o,t),s(e,Cl,t),s(e,Zo,t),p(Gl,e,t),s(e,Bo,t),s(e,Il,t),s(e,xo,t),p(kl,e,t),s(e,Ho,t),s(e,_l,t),s(e,Lo,t),p(Zl,e,t),s(e,Yo,t),p(Bl,e,t),s(e,Wo,t),s(e,xl,t),s(e,Ro,t),p(Hl,e,t),s(e,Xo,t),p(Ll,e,t),s(e,No,t),s(e,Yl,t),s(e,Vo,t),p(Wl,e,t),s(e,So,t),s(e,Rl,t),s(e,Fo,t),p(Xl,e,t),s(e,Ao,t),s(e,Nl,t),s(e,Qo,t),s(e,Vl,t),s(e,zo,t),p(Sl,e,t),s(e,Po,t),p(Fl,e,t),s(e,Eo,t),s(e,Al,t),s(e,qo,t),p(Ql,e,t),s(e,Do,t),s(e,zl,t),s(e,Oo,t),p(Pl,e,t),s(e,Ko,t),s(e,El,t),s(e,ep,t),p(ql,e,t),s(e,tp,t),s(e,Dl,t),s(e,lp,t),p(Ol,e,t),s(e,sp,t),s(e,Kl,t),s(e,ap,t),p(es,e,t),s(e,np,t),s(e,ts,t),s(e,ip,t),s(e,ls,t),s(e,op,t),p(ss,e,t),s(e,pp,t),s(e,as,t),s(e,fp,t),p(ns,e,t),s(e,cp,t),s(e,is,t),s(e,mp,t),p(os,e,t),s(e,dp,t),s(e,ps,t),s(e,rp,t),p(fs,e,t),s(e,hp,t),s(e,cs,t),s(e,up,t),p(ms,e,t),s(e,gp,t),s(e,ds,t),s(e,yp,t),p(rs,e,t),s(e,Mp,t),p(hs,e,t),s(e,$p,t),s(e,us,t),s(e,wp,t),p(gs,e,t),s(e,bp,t),p(ys,e,t),s(e,Tp,t),s(e,Ms,t),s(e,jp,t),p($s,e,t),s(e,vp,t),p(ws,e,t),s(e,Jp,t),s(e,bs,t),s(e,Up,t),p(Ts,e,t),s(e,Cp,t),p(js,e,t),s(e,Gp,t),s(e,vs,t),s(e,Ip,t),p(Js,e,t),s(e,kp,t),s(e,Us,t),s(e,_p,t),p(Cs,e,t),s(e,Zp,t),s(e,Gs,t),s(e,Bp,t),p(Is,e,t),s(e,xp,t),p(ks,e,t),s(e,Hp,t),s(e,_s,t),s(e,Lp,t),s(e,Zs,t),s(e,Yp,t),p(Bs,e,t),s(e,Wp,t),p(xs,e,t),s(e,Rp,t),s(e,Hs,t),s(e,Xp,t),s(e,J,t),s(e,Np,t),p(Ls,e,t),s(e,Vp,t),p(Ys,e,t),s(e,Sp,t),p(Ws,e,t),s(e,Fp,t),s(e,Rs,t),s(e,Ap,t),p(Xs,e,t),s(e,Qp,t),p(Ns,e,t),s(e,zp,t),p(Vs,e,t),s(e,Pp,t),s(e,Ss,t),s(e,Ep,t),p(Fs,e,t),s(e,qp,t),s(e,As,t),s(e,Dp,t),p(Qs,e,t),s(e,Op,t),s(e,zs,t),s(e,Kp,t),p(Ps,e,t),s(e,ef,t),s(e,Es,t),s(e,tf,t),p(qs,e,t),s(e,lf,t),s(e,Ds,t),s(e,sf,t),p(Os,e,t),s(e,af,t),p(Ks,e,t),s(e,nf,t),p(ea,e,t),s(e,of,t),p(ta,e,t),s(e,pf,t),s(e,U,t),s(e,ff,t),p(la,e,t),s(e,cf,t),s(e,sa,t),s(e,mf,t),s(e,aa,t),s(e,df,t),s(e,na,t),s(e,rf,t),p(ia,e,t),s(e,hf,t),s(e,oa,t),s(e,uf,t),p(pa,e,t),s(e,gf,t),s(e,fa,t),s(e,yf,t),p(ca,e,t),s(e,Mf,t),s(e,ma,t),s(e,$f,t),s(e,da,t),s(e,wf,t),p(ra,e,t),s(e,bf,t),s(e,ha,t),s(e,Tf,t),s(e,ua,t),s(e,jf,t),p(ga,e,t),s(e,vf,t),p(ya,e,t),s(e,Jf,t),s(e,Ma,t),s(e,Uf,t),p($a,e,t),s(e,Cf,t),s(e,C,t),s(e,Gf,t),p(wa,e,t),s(e,If,t),s(e,Ta,t),kf=!0},p:Pm,i(e){kf||(f(G.$$.fragment,e),f(I.$$.fragment,e),f(_.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(W.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(A.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(fe.$$.fragment,e),f(me.$$.fragment,e),f(re.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f($e.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(Je.$$.fragment,e),f(Ce.$$.fragment,e),f(ke.$$.fragment,e),f(_e.$$.fragment,e),f(Be.$$.fragment,e),f(xe.$$.fragment,e),f(Le.$$.fragment,e),f(We.$$.fragment,e),f(Re.$$.fragment,e),f(Ne.$$.fragment,e),f(Ve.$$.fragment,e),f(Fe.$$.fragment,e),f(Ae.$$.fragment,e),f(Pe.$$.fragment,e),f(Ee.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(tt.$$.fragment,e),f(lt.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(ct.$$.fragment,e),f(dt.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(yt.$$.fragment,e),f($t.$$.fragment,e),f(bt.$$.fragment,e),f(jt.$$.fragment,e),f(Jt.$$.fragment,e),f(Ut.$$.fragment,e),f(Gt.$$.fragment,e),f(kt.$$.fragment,e),f(_t.$$.fragment,e),f(Bt.$$.fragment,e),f(xt.$$.fragment,e),f(Lt.$$.fragment,e),f(Yt.$$.fragment,e),f(Rt.$$.fragment,e),f(Xt.$$.fragment,e),f(Vt.$$.fragment,e),f(Ft.$$.fragment,e),f(Qt.$$.fragment,e),f(zt.$$.fragment,e),f(Et.$$.fragment,e),f(qt.$$.fragment,e),f(Ot.$$.fragment,e),f(Kt.$$.fragment,e),f(tl.$$.fragment,e),f(ll.$$.fragment,e),f(al.$$.fragment,e),f(nl.$$.fragment,e),f(ol.$$.fragment,e),f(pl.$$.fragment,e),f(cl.$$.fragment,e),f(dl.$$.fragment,e),f(rl.$$.fragment,e),f(ul.$$.fragment,e),f(gl.$$.fragment,e),f(yl.$$.fragment,e),f(Ml.$$.fragment,e),f($l.$$.fragment,e),f(bl.$$.fragment,e),f(Tl.$$.fragment,e),f(jl.$$.fragment,e),f(Jl.$$.fragment,e),f(Gl.$$.fragment,e),f(kl.$$.fragment,e),f(Zl.$$.fragment,e),f(Bl.$$.fragment,e),f(Hl.$$.fragment,e),f(Ll.$$.fragment,e),f(Wl.$$.fragment,e),f(Xl.$$.fragment,e),f(Sl.$$.fragment,e),f(Fl.$$.fragment,e),f(Ql.$$.fragment,e),f(Pl.$$.fragment,e),f(ql.$$.fragment,e),f(Ol.$$.fragment,e),f(es.$$.fragment,e),f(ss.$$.fragment,e),f(ns.$$.fragment,e),f(os.$$.fragment,e),f(fs.$$.fragment,e),f(ms.$$.fragment,e),f(rs.$$.fragment,e),f(hs.$$.fragment,e),f(gs.$$.fragment,e),f(ys.$$.fragment,e),f($s.$$.fragment,e),f(ws.$$.fragment,e),f(Ts.$$.fragment,e),f(js.$$.fragment,e),f(Js.$$.fragment,e),f(Cs.$$.fragment,e),f(Is.$$.fragment,e),f(ks.$$.fragment,e),f(Bs.$$.fragment,e),f(xs.$$.fragment,e),f(Ls.$$.fragment,e),f(Ys.$$.fragment,e),f(Ws.$$.fragment,e),f(Xs.$$.fragment,e),f(Ns.$$.fragment,e),f(Vs.$$.fragment,e),f(Fs.$$.fragment,e),f(Qs.$$.fragment,e),f(Ps.$$.fragment,e),f(qs.$$.fragment,e),f(Os.$$.fragment,e),f(Ks.$$.fragment,e),f(ea.$$.fragment,e),f(ta.$$.fragment,e),f(la.$$.fragment,e),f(ia.$$.fragment,e),f(pa.$$.fragment,e),f(ca.$$.fragment,e),f(ra.$$.fragment,e),f(ga.$$.fragment,e),f(ya.$$.fragment,e),f($a.$$.fragment,e),f(wa.$$.fragment,e),kf=!0)},o(e){c(G.$$.fragment,e),c(I.$$.fragment,e),c(_.$$.fragment,e),c(B.$$.fragment,e),c(L.$$.fragment,e),c(W.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(A.$$.fragment,e),c(z.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(fe.$$.fragment,e),c(me.$$.fragment,e),c(re.$$.fragment,e),c(ue.$$.fragment,e),c(ye.$$.fragment,e),c($e.$$.fragment,e),c(Te.$$.fragment,e),c(ve.$$.fragment,e),c(Je.$$.fragment,e),c(Ce.$$.fragment,e),c(ke.$$.fragment,e),c(_e.$$.fragment,e),c(Be.$$.fragment,e),c(xe.$$.fragment,e),c(Le.$$.fragment,e),c(We.$$.fragment,e),c(Re.$$.fragment,e),c(Ne.$$.fragment,e),c(Ve.$$.fragment,e),c(Fe.$$.fragment,e),c(Ae.$$.fragment,e),c(Pe.$$.fragment,e),c(Ee.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(at.$$.fragment,e),c(nt.$$.fragment,e),c(ot.$$.fragment,e),c(pt.$$.fragment,e),c(ct.$$.fragment,e),c(dt.$$.fragment,e),c(ht.$$.fragment,e),c(gt.$$.fragment,e),c(yt.$$.fragment,e),c($t.$$.fragment,e),c(bt.$$.fragment,e),c(jt.$$.fragment,e),c(Jt.$$.fragment,e),c(Ut.$$.fragment,e),c(Gt.$$.fragment,e),c(kt.$$.fragment,e),c(_t.$$.fragment,e),c(Bt.$$.fragment,e),c(xt.$$.fragment,e),c(Lt.$$.fragment,e),c(Yt.$$.fragment,e),c(Rt.$$.fragment,e),c(Xt.$$.fragment,e),c(Vt.$$.fragment,e),c(Ft.$$.fragment,e),c(Qt.$$.fragment,e),c(zt.$$.fragment,e),c(Et.$$.fragment,e),c(qt.$$.fragment,e),c(Ot.$$.fragment,e),c(Kt.$$.fragment,e),c(tl.$$.fragment,e),c(ll.$$.fragment,e),c(al.$$.fragment,e),c(nl.$$.fragment,e),c(ol.$$.fragment,e),c(pl.$$.fragment,e),c(cl.$$.fragment,e),c(dl.$$.fragment,e),c(rl.$$.fragment,e),c(ul.$$.fragment,e),c(gl.$$.fragment,e),c(yl.$$.fragment,e),c(Ml.$$.fragment,e),c($l.$$.fragment,e),c(bl.$$.fragment,e),c(Tl.$$.fragment,e),c(jl.$$.fragment,e),c(Jl.$$.fragment,e),c(Gl.$$.fragment,e),c(kl.$$.fragment,e),c(Zl.$$.fragment,e),c(Bl.$$.fragment,e),c(Hl.$$.fragment,e),c(Ll.$$.fragment,e),c(Wl.$$.fragment,e),c(Xl.$$.fragment,e),c(Sl.$$.fragment,e),c(Fl.$$.fragment,e),c(Ql.$$.fragment,e),c(Pl.$$.fragment,e),c(ql.$$.fragment,e),c(Ol.$$.fragment,e),c(es.$$.fragment,e),c(ss.$$.fragment,e),c(ns.$$.fragment,e),c(os.$$.fragment,e),c(fs.$$.fragment,e),c(ms.$$.fragment,e),c(rs.$$.fragment,e),c(hs.$$.fragment,e),c(gs.$$.fragment,e),c(ys.$$.fragment,e),c($s.$$.fragment,e),c(ws.$$.fragment,e),c(Ts.$$.fragment,e),c(js.$$.fragment,e),c(Js.$$.fragment,e),c(Cs.$$.fragment,e),c(Is.$$.fragment,e),c(ks.$$.fragment,e),c(Bs.$$.fragment,e),c(xs.$$.fragment,e),c(Ls.$$.fragment,e),c(Ys.$$.fragment,e),c(Ws.$$.fragment,e),c(Xs.$$.fragment,e),c(Ns.$$.fragment,e),c(Vs.$$.fragment,e),c(Fs.$$.fragment,e),c(Qs.$$.fragment,e),c(Ps.$$.fragment,e),c(qs.$$.fragment,e),c(Os.$$.fragment,e),c(Ks.$$.fragment,e),c(ea.$$.fragment,e),c(ta.$$.fragment,e),c(la.$$.fragment,e),c(ia.$$.fragment,e),c(pa.$$.fragment,e),c(ca.$$.fragment,e),c(ra.$$.fragment,e),c(ga.$$.fragment,e),c(ya.$$.fragment,e),c($a.$$.fragment,e),c(wa.$$.fragment,e),kf=!1},d(e){e&&(l(ja),l(ba),l(va),l(Ja),l(Ua),l(k),l(Ca),l($),l(Ga),l(Ia),l(Z),l(ka),l(_a),l(w),l(Za),l(x),l(Ba),l(H),l(xa),l(Ha),l(Y),l(La),l(Ya),l(R),l(Wa),l(X),l(Ra),l(Xa),l(V),l(Na),l(Va),l(F),l(Sa),l(Fa),l(Q),l(Aa),l(b),l(Qa),l(za),l(Pa),l(E),l(Ea),l(q),l(qa),l(Da),l(O),l(Oa),l(Ka),l(ee),l(en),l(tn),l(ln),l(se),l(sn),l(an),l(ne),l(nn),l(on),l(oe),l(pn),l(pe),l(fn),l(cn),l(ce),l(mn),l(dn),l(de),l(rn),l(hn),l(he),l(un),l(gn),l(ge),l(yn),l(Mn),l(Me),l($n),l(wn),l(we),l(bn),l(be),l(Tn),l(jn),l(je),l(vn),l(Jn),l(Un),l(Ue),l(Cn),l(Gn),l(Ge),l(In),l(Ie),l(kn),l(_n),l(Zn),l(Ze),l(Bn),l(xn),l(Hn),l(He),l(Ln),l(Yn),l(Ye),l(Wn),l(Rn),l(Xn),l(Xe),l(Nn),l(Vn),l(Sn),l(Se),l(Fn),l(An),l(Qn),l(Qe),l(zn),l(ze),l(Pn),l(T),l(En),l(qn),l(Dn),l(qe),l(On),l(Kn),l(Oe),l(ei),l(ti),l(et),l(li),l(si),l(ai),l(st),l(ni),l(ii),l(oi),l(it),l(pi),l(fi),l(ci),l(ft),l(mi),l(di),l(mt),l(ri),l(hi),l(rt),l(ui),l(gi),l(ut),l(yi),l(Mi),l($i),l(Mt),l(wi),l(bi),l(wt),l(Ti),l(ji),l(j),l(vi),l(Tt),l(Ji),l(Ui),l(vt),l(Ci),l(Gi),l(Ii),l(Ct),l(ki),l(_i),l(It),l(Zi),l(Bi),l(xi),l(Zt),l(Hi),l(Li),l(Yi),l(Ht),l(Wi),l(Ri),l(Xi),l(Wt),l(Ni),l(Vi),l(Si),l(Nt),l(Fi),l(Ai),l(St),l(Qi),l(zi),l(At),l(Pi),l(Ei),l(qi),l(Pt),l(Di),l(Oi),l(Ki),l(Dt),l(eo),l(to),l(lo),l(el),l(so),l(ao),l(no),l(sl),l(io),l(oo),l(po),l(il),l(fo),l(co),l(mo),l(fl),l(ro),l(ho),l(ml),l(uo),l(go),l(yo),l(hl),l(Mo),l($o),l(wo),l(bo),l(To),l(jo),l(wl),l(vo),l(Jo),l(Uo),l(v),l(Co),l(Go),l(vl),l(Io),l(ko),l(Ul),l(_o),l(Cl),l(Zo),l(Bo),l(Il),l(xo),l(Ho),l(_l),l(Lo),l(Yo),l(Wo),l(xl),l(Ro),l(Xo),l(No),l(Yl),l(Vo),l(So),l(Rl),l(Fo),l(Ao),l(Nl),l(Qo),l(Vl),l(zo),l(Po),l(Eo),l(Al),l(qo),l(Do),l(zl),l(Oo),l(Ko),l(El),l(ep),l(tp),l(Dl),l(lp),l(sp),l(Kl),l(ap),l(np),l(ts),l(ip),l(ls),l(op),l(pp),l(as),l(fp),l(cp),l(is),l(mp),l(dp),l(ps),l(rp),l(hp),l(cs),l(up),l(gp),l(ds),l(yp),l(Mp),l($p),l(us),l(wp),l(bp),l(Tp),l(Ms),l(jp),l(vp),l(Jp),l(bs),l(Up),l(Cp),l(Gp),l(vs),l(Ip),l(kp),l(Us),l(_p),l(Zp),l(Gs),l(Bp),l(xp),l(Hp),l(_s),l(Lp),l(Zs),l(Yp),l(Wp),l(Rp),l(Hs),l(Xp),l(J),l(Np),l(Vp),l(Sp),l(Fp),l(Rs),l(Ap),l(Qp),l(zp),l(Pp),l(Ss),l(Ep),l(qp),l(As),l(Dp),l(Op),l(zs),l(Kp),l(ef),l(Es),l(tf),l(lf),l(Ds),l(sf),l(af),l(nf),l(of),l(pf),l(U),l(ff),l(cf),l(sa),l(mf),l(aa),l(df),l(na),l(rf),l(hf),l(oa),l(uf),l(gf),l(fa),l(yf),l(Mf),l(ma),l($f),l(da),l(wf),l(bf),l(ha),l(Tf),l(ua),l(jf),l(vf),l(Jf),l(Ma),l(Uf),l(Cf),l(C),l(Gf),l(If),l(Ta)),l(M),m(G,e),m(I,e),m(_,e),m(B,e),m(L,e),m(W,e),m(N,e),m(S,e),m(A,e),m(z,e),m(P,e),m(D,e),m(K,e),m(te,e),m(le,e),m(ae,e),m(ie,e),m(fe,e),m(me,e),m(re,e),m(ue,e),m(ye,e),m($e,e),m(Te,e),m(ve,e),m(Je,e),m(Ce,e),m(ke,e),m(_e,e),m(Be,e),m(xe,e),m(Le,e),m(We,e),m(Re,e),m(Ne,e),m(Ve,e),m(Fe,e),m(Ae,e),m(Pe,e),m(Ee,e),m(De,e),m(Ke,e),m(tt,e),m(lt,e),m(at,e),m(nt,e),m(ot,e),m(pt,e),m(ct,e),m(dt,e),m(ht,e),m(gt,e),m(yt,e),m($t,e),m(bt,e),m(jt,e),m(Jt,e),m(Ut,e),m(Gt,e),m(kt,e),m(_t,e),m(Bt,e),m(xt,e),m(Lt,e),m(Yt,e),m(Rt,e),m(Xt,e),m(Vt,e),m(Ft,e),m(Qt,e),m(zt,e),m(Et,e),m(qt,e),m(Ot,e),m(Kt,e),m(tl,e),m(ll,e),m(al,e),m(nl,e),m(ol,e),m(pl,e),m(cl,e),m(dl,e),m(rl,e),m(ul,e),m(gl,e),m(yl,e),m(Ml,e),m($l,e),m(bl,e),m(Tl,e),m(jl,e),m(Jl,e),m(Gl,e),m(kl,e),m(Zl,e),m(Bl,e),m(Hl,e),m(Ll,e),m(Wl,e),m(Xl,e),m(Sl,e),m(Fl,e),m(Ql,e),m(Pl,e),m(ql,e),m(Ol,e),m(es,e),m(ss,e),m(ns,e),m(os,e),m(fs,e),m(ms,e),m(rs,e),m(hs,e),m(gs,e),m(ys,e),m($s,e),m(ws,e),m(Ts,e),m(js,e),m(Js,e),m(Cs,e),m(Is,e),m(ks,e),m(Bs,e),m(xs,e),m(Ls,e),m(Ys,e),m(Ws,e),m(Xs,e),m(Ns,e),m(Vs,e),m(Fs,e),m(Qs,e),m(Ps,e),m(qs,e),m(Os,e),m(Ks,e),m(ea,e),m(ta,e),m(la,e),m(ia,e),m(pa,e),m(ca,e),m(ra,e),m(ga,e),m(ya,e),m($a,e),m(wa,e)}}}const sd='{"title":"Command Line Interface (CLI)","local":"command-line-interface-cli","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Other installation methods","local":"other-installation-methods","sections":[{"title":"Using uv","local":"using-uv","sections":[],"depth":4},{"title":"Using Homebrew","local":"using-homebrew","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"hf auth login","local":"hf-auth-login","sections":[],"depth":2},{"title":"hf auth whoami","local":"hf-auth-whoami","sections":[],"depth":2},{"title":"hf auth logout","local":"hf-auth-logout","sections":[],"depth":2},{"title":"hf download","local":"hf-download","sections":[{"title":"Download a single file","local":"download-a-single-file","sections":[],"depth":3},{"title":"Download an entire repository","local":"download-an-entire-repository","sections":[],"depth":3},{"title":"Download multiple files","local":"download-multiple-files","sections":[],"depth":3},{"title":"Download a dataset or a Space","local":"download-a-dataset-or-a-space","sections":[],"depth":3},{"title":"Download a specific revision","local":"download-a-specific-revision","sections":[],"depth":3},{"title":"Download to a local folder","local":"download-to-a-local-folder","sections":[],"depth":3},{"title":"Dry-run mode","local":"dry-run-mode","sections":[],"depth":3},{"title":"Specify cache directory","local":"specify-cache-directory","sections":[],"depth":3},{"title":"Specify a token","local":"specify-a-token","sections":[],"depth":3},{"title":"Quiet mode","local":"quiet-mode","sections":[],"depth":3},{"title":"Download timeout","local":"download-timeout","sections":[],"depth":3}],"depth":2},{"title":"hf upload","local":"hf-upload","sections":[{"title":"Upload an entire folder","local":"upload-an-entire-folder","sections":[],"depth":3},{"title":"Upload a single file","local":"upload-a-single-file","sections":[],"depth":3},{"title":"Upload multiple files","local":"upload-multiple-files","sections":[],"depth":3},{"title":"Upload to a dataset or Space","local":"upload-to-a-dataset-or-space","sections":[],"depth":3},{"title":"Upload to an organization","local":"upload-to-an-organization","sections":[],"depth":3},{"title":"Upload to a specific revision","local":"upload-to-a-specific-revision","sections":[],"depth":3},{"title":"Upload and create a PR","local":"upload-and-create-a-pr","sections":[],"depth":3},{"title":"Upload at regular intervals","local":"upload-at-regular-intervals","sections":[],"depth":3},{"title":"Specify a commit message","local":"specify-a-commit-message","sections":[],"depth":3},{"title":"Specify a token","local":"specify-a-token","sections":[],"depth":3},{"title":"Quiet mode","local":"quiet-mode","sections":[],"depth":3}],"depth":2},{"title":"hf repo","local":"hf-repo","sections":[{"title":"Create a repo","local":"create-a-repo","sections":[],"depth":3},{"title":"Delete a repo","local":"delete-a-repo","sections":[],"depth":3},{"title":"Move a repo","local":"move-a-repo","sections":[],"depth":3},{"title":"Update repo settings","local":"update-repo-settings","sections":[],"depth":3},{"title":"Manage branches","local":"manage-branches","sections":[],"depth":3}],"depth":2},{"title":"hf repo-files","local":"hf-repo-files","sections":[{"title":"Delete files","local":"delete-files","sections":[],"depth":3},{"title":"Specify a token","local":"specify-a-token","sections":[],"depth":3}],"depth":2},{"title":"hf cache ls","local":"hf-cache-ls","sections":[],"depth":2},{"title":"hf cache rm","local":"hf-cache-rm","sections":[],"depth":2},{"title":"hf cache prune","local":"hf-cache-prune","sections":[],"depth":2},{"title":"hf cache verify","local":"hf-cache-verify","sections":[],"depth":2},{"title":"hf repo tag create","local":"hf-repo-tag-create","sections":[{"title":"Tag a model","local":"tag-a-model","sections":[],"depth":3},{"title":"Tag a model at a specific revision","local":"tag-a-model-at-a-specific-revision","sections":[],"depth":3},{"title":"Tag a dataset or a Space","local":"tag-a-dataset-or-a-space","sections":[],"depth":3},{"title":"List tags","local":"list-tags","sections":[],"depth":3},{"title":"Delete a tag","local":"delete-a-tag","sections":[],"depth":3}],"depth":2},{"title":"hf env","local":"hf-env","sections":[],"depth":2},{"title":"hf jobs","local":"hf-jobs","sections":[{"title":"✨ Key Features","local":"-key-features","sections":[],"depth":3},{"title":"Quick Start","local":"quick-start","sections":[{"title":"1. Run your first job","local":"1-run-your-first-job","sections":[],"depth":4},{"title":"2. Check job status","local":"2-check-job-status","sections":[],"depth":4},{"title":"3. Run on GPU","local":"3-run-on-gpu","sections":[],"depth":4}],"depth":3},{"title":"Common Use Cases","local":"common-use-cases","sections":[],"depth":3},{"title":"Pass Environment variables and Secrets","local":"pass-environment-variables-and-secrets","sections":[],"depth":3},{"title":"Hardware","local":"hardware","sections":[],"depth":3},{"title":"UV Scripts (Experimental)","local":"uv-scripts-experimental","sections":[],"depth":3},{"title":"Scheduled Jobs","local":"scheduled-jobs","sections":[],"depth":3}],"depth":2},{"title":"hf endpoints","local":"hf-endpoints","sections":[],"depth":2}],"depth":1}';function ad(_f){return Em(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cd extends qm{constructor(M){super(),Dm(this,M,ad,ld,zm,{})}}export{cd as component};
