import{s as kn,n as Jn,o as Hn}from"../chunks/scheduler.0cf4ef2e.js";import{S as Zn,i as Cn,e as s,s as l,c as r,h as Ln,a as i,d as n,b as o,f as xn,g as h,j as d,k as Bt,l as qn,m as a,n as f,t as p,o as c,p as u}from"../chunks/index.abc433bf.js";import{C as Un}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as m}from"../chunks/CodeBlock.00dcd05e.js";import{H as g,E as Gn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function In(zt){let w,He,ke,Ze,_,Ce,$,Le,M,Ft=`The <code>huggingface_hub</code> library provides functions to download files from the repositories
stored on the Hub. You can use these functions independently or integrate them into your
own library, making it more convenient for your users to interact with the Hub. This
guide will show you how to:`,qe,v,Nt="<li>Download and cache a single file.</li> <li>Download and cache an entire repository.</li> <li>Download files to a local folder.</li>",Ue,T,Ge,j,Pt=`The <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> function is the main function for downloading files from the Hub.
It downloads the remote file, caches it on disk (in a version-aware way), and returns its local file path.`,Ie,b,Qt=`<p>The returned filepath is a pointer to the HF local cache. Therefore, it is important to not modify the file to avoid
having a corrupted cache. If you are interested in getting to know more about how files are cached, please refer to our
<a href="./manage-cache">caching guide</a>.</p>`,Ye,x,We,k,St=`Select the file to download using the <code>repo_id</code>, <code>repo_type</code> and <code>filename</code> parameters. By default, the file will
be considered as being part of a <code>model</code> repo.`,Xe,J,Re,H,Be,Z,Dt=`By default, the latest version from the <code>main</code> branch is downloaded. However, in some cases you want to download a file
at a particular version (e.g. from a specific branch, a PR, a tag or a commit hash).
To do so, use the <code>revision</code> parameter:`,ze,C,Fe,L,Vt="<strong>Note:</strong> When using the commit hash, it must be the full-length hash instead of a 7-character commit hash.",Ne,q,Pe,U,At=`In case you want to construct the URL used to download a file from a repo, you can use <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a> which returns a URL.
Note that it is used internally by <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a>.`,Qe,G,Se,I,Et=`<a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads an entire repository at a given revision. It uses internally <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> which
means all downloaded files are also cached on your local disk. Downloads are made concurrently to speed up the process.`,De,Y,Kt="To download a whole repository, just pass the <code>repo_id</code> and <code>repo_type</code>:",Ve,W,Ae,X,Ot=`<a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads the latest revision by default. If you want a specific repository revision, use the
<code>revision</code> parameter:`,Ee,R,Ke,B,Oe,z,en=`<a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> provides an easy way to download a repository. However, you don’t always want to download the
entire content of a repository. For example, you might want to prevent downloading all <code>.bin</code> files if you know you’ll
only use the <code>.safetensors</code> weights. You can do that using <code>allow_patterns</code> and <code>ignore_patterns</code> parameters.`,et,F,tn=`These parameters accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing
patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. The pattern matching is
based on <a href="https://docs.python.org/3/library/fnmatch.html" rel="nofollow"><code>fnmatch</code></a>.`,tt,N,nn="For example, you can use <code>allow_patterns</code> to only download JSON configuration files:",nt,P,at,Q,an=`On the other hand, <code>ignore_patterns</code> can exclude certain files from being downloaded. The
following example ignores the <code>.msgpack</code> and <code>.h5</code> file extensions:`,lt,S,ot,D,ln=`Finally, you can combine both to precisely filter your download. Here is an example to download all json and markdown
files except <code>vocab.json</code>.`,st,V,it,A,dt,E,on='By default, we recommend using the <a href="./manage-cache">cache system</a> to download files from the Hub. You can specify a custom cache location using the <code>cache_dir</code> parameter in <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a>, or by setting the <a href="../package_reference/environment_variables#hf_home"><code>HF_HOME</code></a> environment variable.',rt,K,sn="However, if you need to download files to a specific folder, you can pass a <code>local_dir</code> parameter to the download function. This is useful to get a workflow closer to what the <code>git</code> command offers. The downloaded files will maintain their original file structure within the specified folder. For example, if <code>filename=&quot;data/train.csv&quot;</code> and <code>local_dir=&quot;path/to/folder&quot;</code>, the resulting filepath will be <code>&quot;path/to/folder/data/train.csv&quot;</code>.",ht,O,dn="A <code>.cache/huggingface/</code> folder is created at the root of your local directory containing metadata about the downloaded files. This prevents re-downloading files if they’re already up-to-date. If the metadata has changed, then the new file version is downloaded. This makes the <code>local_dir</code> optimized for pulling only the latest changes.",ft,ee,rn="After completing the download, you can safely remove the <code>.cache/huggingface/</code> folder if you no longer need it. However, be aware that re-running your script without this folder may result in longer recovery times, as metadata will be lost. Rest assured that your local data will remain intact and unaffected.",pt,y,hn='<p>Don’t worry about the <code>.cache/huggingface/</code> folder when committing changes to the Hub! This folder is automatically ignored by both <code>git</code> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>.</p>',ct,te,ut,ne,fn=`You can use the <code>hf download</code> command from the terminal to directly download files from the Hub.
Internally, it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described above and prints the
returned path to the terminal.`,mt,ae,gt,le,pn=`You can download multiple files at once which displays a progress bar and returns the snapshot path in which the files
are located:`,wt,oe,bt,se,cn='For more details about the CLI download command, please refer to the <a href="./cli#hf-download">CLI guide</a>.',yt,ie,_t,de,un="In some cases, you would like to check which files would be downloaded before actually downloading them. You can check this using the <code>--dry-run</code> parameter. It lists all files to download on the repo and checks whether they are already downloaded or not. This gives an idea of how many files have to be downloaded and their sizes.",$t,re,mn="Here is an example, checking on a single file:",Mt,he,vt,fe,gn="And if the file is already cached:",Tt,pe,jt,ce,wn="You can also execute a dry-run on an entire repository:",xt,ue,kt,me,bn="And with files filtering:",Jt,ge,Ht,we,yn='Finally, you can also make a dry-run programmatically by passing <code>dry_run=True</code> to <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a>. It will return a <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DryRunFileInfo">DryRunFileInfo</a> (respectively a list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DryRunFileInfo">DryRunFileInfo</a>) with for each file, their commit hash, file name and file size, whether the file is cached and whether the file would be downloaded. In practice, the file will be downloaded if not cached or if <code>force_download=True</code> is passed.',Zt,be,Ct,ye,_n=`Take advantage of faster downloads through <code>hf_xet</code>, the Python binding to the <a href="https://github.com/huggingface/xet-core" rel="nofollow"><code>xet-core</code></a> library that enables
chunk-based deduplication for faster downloads and uploads. <code>hf_xet</code> integrates seamlessly with <code>huggingface_hub</code>, but uses the Rust <code>xet-core</code> library and Xet storage instead of LFS.`,Lt,_e,$n="<code>hf_xet</code> uses the Xet storage system, which breaks files down into immutable chunks, storing collections of these chunks (called blocks or xorbs) remotely and retrieving them to reassemble the file when requested. When downloading, after confirming the user is authorized to access the files, <code>hf_xet</code> will query the Xet content-addressable service (CAS) with the LFS SHA256 hash for this file to receive the reconstruction metadata (ranges within xorbs) to assemble these files, along with presigned URLs to download the xorbs directly. Then <code>hf_xet</code> will efficiently download the xorb ranges necessary and will write out the files on disk.",qt,$e,Mn="To enable it, simply install the latest version of <code>huggingface_hub</code>:",Ut,Me,Gt,ve,vn="As of <code>huggingface_hub</code> 0.32.0, this will also install <code>hf_xet</code>.",It,Te,Tn='All other <code>huggingface_hub</code> APIs will continue to work without any modification. To learn more about the benefits of Xet storage and <code>hf_xet</code>, refer to this <a href="https://huggingface.co/docs/hub/xet/index" rel="nofollow">section</a>.',Yt,je,jn="Note: <code>hf_transfer</code> was formerly used with the LFS storage backend and is now deprecated; use <code>hf_xet</code> instead.",Wt,xe,Xt,Je,Rt;return _=new Un({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),$=new g({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h1"}}),T=new g({props:{title:"Download a single file",local:"download-a-single-file",headingTag:"h2"}}),x=new g({props:{title:"From latest version",local:"from-latest-version",headingTag:"h3"}}),J=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIyZ29vZ2xlJTJGZmxldXJzJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJmbGV1cnMucHklMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>

<span class="hljs-comment"># Download from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, filename=<span class="hljs-string">&quot;fleurs.py&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34/fleurs.py&#x27;</span>`,wrap:!1}}),H=new g({props:{title:"From specific version",local:"from-specific-version",headingTag:"h3"}}),C=new m({props:{code:"aGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnYxLjAlMjIpJTBBJTBBaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnRlc3QtYnJhbmNoJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYzJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-comment"># Download from the \`v1.0\` tag</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;v1.0&quot;</span>)

<span class="hljs-comment"># Download from the \`test-branch\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;test-branch&quot;</span>)

<span class="hljs-comment"># Download from Pull Request #3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/3&quot;</span>)

<span class="hljs-comment"># Download from a specific commit hash</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),q=new g({props:{title:"Construct a download URL",local:"construct-a-download-url",headingTag:"h3"}}),G=new g({props:{title:"Download an entire repository",local:"download-an-entire-repository",headingTag:"h2"}}),W=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKSUwQSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJnb29nbGUlMkZmbGV1cnMlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>

<span class="hljs-comment"># Or from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34&#x27;</span>`,wrap:!1}}),R=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/1&quot;</span>)`,wrap:!1}}),B=new g({props:{title:"Filter files to download",local:"filter-files-to-download",headingTag:"h3"}}),P=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, allow_patterns=<span class="hljs-string">&quot;*.json&quot;</span>)`,wrap:!1}}),S=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwaWdub3JlX3BhdHRlcm5zJTNEJTVCJTIyKi5tc2dwYWNrJTIyJTJDJTIwJTIyKi5oNSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, ignore_patterns=[<span class="hljs-string">&quot;*.msgpack&quot;</span>, <span class="hljs-string">&quot;*.h5&quot;</span>])`,wrap:!1}}),V=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmdwdDIlMjIlMkMlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMioubWQlMjIlMkMlMjAlMjIqLmpzb24lMjIlNUQlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjJ2b2NhYi5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;gpt2&quot;</span>, allow_patterns=[<span class="hljs-string">&quot;*.md&quot;</span>, <span class="hljs-string">&quot;*.json&quot;</span>], ignore_patterns=<span class="hljs-string">&quot;vocab.json&quot;</span>)`,wrap:!1}}),A=new g({props:{title:"Download file(s) to a local folder",local:"download-files-to-a-local-folder",headingTag:"h2"}}),te=new g({props:{title:"Download from the CLI",local:"download-from-the-cli",headingTag:"h2"}}),ae=new m({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbg==",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),oe=new m({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMG1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json model.safetensors
Fetching 2 files: 100%|████████████████████████████████████████████| 2/2 [00:00&lt;00:00, 23831.27it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),ie=new g({props:{title:"Dry-run mode",local:"dry-run-mode",headingTag:"h2"}}),he=new m({props:{code:"aGYlMjBkb3dubG9hZCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwb25ueCUyRmRlY29kZXJfbW9kZWxfbWVyZ2VkLm9ubnglMjAtLWRyeS1ydW4=",highlighted:`&gt;&gt;&gt; hf download openai-community/gpt2 onnx/decoder_model_merged.onnx --dry-run
[dry-run] Will download 1 files (out of 1) totalling 655.2M
File                           Bytes to download
------------------------------ -----------------
onnx/decoder_model_merged.onnx 655.2M`,wrap:!1}}),pe=new m({props:{code:"aGYlMjBkb3dubG9hZCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwb25ueCUyRmRlY29kZXJfbW9kZWxfbWVyZ2VkLm9ubnglMjAtLWRyeS1ydW4=",highlighted:`&gt;&gt;&gt; hf download openai-community/gpt2 onnx/decoder_model_merged.onnx --dry-run
[dry-run] Will download 0 files (out of 1) totalling 0.0.
File                           Bytes to download
------------------------------ -----------------
onnx/decoder_model_merged.onnx -`,wrap:!1}}),ue=new m({props:{code:"aGYlMjBkb3dubG9hZCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwLS1kcnktcnVu",highlighted:`&gt;&gt;&gt; hf download openai-community/gpt2 --dry-run
[dry-run] Fetching 26 files: 100%|█████████████| 26/26 [00:04&lt;00:00,  6.26it/s]
[dry-run] Will download 11 files (out of 26) totalling 5.6G.
File                              Bytes to download
--------------------------------- -----------------
.gitattributes                    -
64-8bits.tflite                   125.2M
64-fp16.tflite                    248.3M
64.tflite                         495.8M
README.md                         -
config.json                       -
flax_model.msgpack                497.8M
generation_config.json            -
merges.txt                        -
model.safetensors                 548.1M
onnx/config.json                  -
onnx/decoder_model.onnx           653.7M
onnx/decoder_model_merged.onnx    655.2M
onnx/decoder_with_past_model.onnx 653.7M
onnx/generation_config.json       -
onnx/merges.txt                   -
onnx/special_tokens_map.json      -
onnx/tokenizer.json               -
onnx/tokenizer_config.json        -
onnx/vocab.json                   -
pytorch_model.bin                 548.1M
rust_model.ot                     702.5M
tf_model.h5                       497.9M
tokenizer.json                    -
tokenizer_config.json             -
vocab.json                        -`,wrap:!1}}),ge=new m({props:{code:"aGYlMjBkb3dubG9hZCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwLS1pbmNsdWRlJTIwJTIyKi5qc29uJTIyJTIwJTIwLS1kcnktcnVu",highlighted:`&gt;&gt;&gt; hf download openai-community/gpt2 --include <span class="hljs-string">&quot;*.json&quot;</span>  --dry-run
[dry-run] Fetching 11 files: 100%|█████████████| 11/11 [00:00&lt;00:00, 80518.92it/s]
[dry-run] Will download 0 files (out of 11) totalling 0.0.
File                         Bytes to download
---------------------------- -----------------
config.json                  -
generation_config.json       -
onnx/config.json             -
onnx/generation_config.json  -
onnx/special_tokens_map.json -
onnx/tokenizer.json          -
onnx/tokenizer_config.json   -
onnx/vocab.json              -
tokenizer.json               -
tokenizer_config.json        -
vocab.json                   -`,wrap:!1}}),be=new g({props:{title:"Faster downloads",local:"faster-downloads",headingTag:"h2"}}),Me=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwJTIyaHVnZ2luZ2ZhY2VfaHViJTIy",highlighted:'pip install -U <span class="hljs-string">&quot;huggingface_hub&quot;</span>',wrap:!1}}),xe=new Gn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/download.md"}}),{c(){w=s("meta"),He=l(),ke=s("p"),Ze=l(),r(_.$$.fragment),Ce=l(),r($.$$.fragment),Le=l(),M=s("p"),M.innerHTML=Ft,qe=l(),v=s("ul"),v.innerHTML=Nt,Ue=l(),r(T.$$.fragment),Ge=l(),j=s("p"),j.innerHTML=Pt,Ie=l(),b=s("blockquote"),b.innerHTML=Qt,Ye=l(),r(x.$$.fragment),We=l(),k=s("p"),k.innerHTML=St,Xe=l(),r(J.$$.fragment),Re=l(),r(H.$$.fragment),Be=l(),Z=s("p"),Z.innerHTML=Dt,ze=l(),r(C.$$.fragment),Fe=l(),L=s("p"),L.innerHTML=Vt,Ne=l(),r(q.$$.fragment),Pe=l(),U=s("p"),U.innerHTML=At,Qe=l(),r(G.$$.fragment),Se=l(),I=s("p"),I.innerHTML=Et,De=l(),Y=s("p"),Y.innerHTML=Kt,Ve=l(),r(W.$$.fragment),Ae=l(),X=s("p"),X.innerHTML=Ot,Ee=l(),r(R.$$.fragment),Ke=l(),r(B.$$.fragment),Oe=l(),z=s("p"),z.innerHTML=en,et=l(),F=s("p"),F.innerHTML=tn,tt=l(),N=s("p"),N.innerHTML=nn,nt=l(),r(P.$$.fragment),at=l(),Q=s("p"),Q.innerHTML=an,lt=l(),r(S.$$.fragment),ot=l(),D=s("p"),D.innerHTML=ln,st=l(),r(V.$$.fragment),it=l(),r(A.$$.fragment),dt=l(),E=s("p"),E.innerHTML=on,rt=l(),K=s("p"),K.innerHTML=sn,ht=l(),O=s("p"),O.innerHTML=dn,ft=l(),ee=s("p"),ee.innerHTML=rn,pt=l(),y=s("blockquote"),y.innerHTML=hn,ct=l(),r(te.$$.fragment),ut=l(),ne=s("p"),ne.innerHTML=fn,mt=l(),r(ae.$$.fragment),gt=l(),le=s("p"),le.textContent=pn,wt=l(),r(oe.$$.fragment),bt=l(),se=s("p"),se.innerHTML=cn,yt=l(),r(ie.$$.fragment),_t=l(),de=s("p"),de.innerHTML=un,$t=l(),re=s("p"),re.textContent=mn,Mt=l(),r(he.$$.fragment),vt=l(),fe=s("p"),fe.textContent=gn,Tt=l(),r(pe.$$.fragment),jt=l(),ce=s("p"),ce.textContent=wn,xt=l(),r(ue.$$.fragment),kt=l(),me=s("p"),me.textContent=bn,Jt=l(),r(ge.$$.fragment),Ht=l(),we=s("p"),we.innerHTML=yn,Zt=l(),r(be.$$.fragment),Ct=l(),ye=s("p"),ye.innerHTML=_n,Lt=l(),_e=s("p"),_e.innerHTML=$n,qt=l(),$e=s("p"),$e.innerHTML=Mn,Ut=l(),r(Me.$$.fragment),Gt=l(),ve=s("p"),ve.innerHTML=vn,It=l(),Te=s("p"),Te.innerHTML=Tn,Yt=l(),je=s("p"),je.innerHTML=jn,Wt=l(),r(xe.$$.fragment),Xt=l(),Je=s("p"),this.h()},l(e){const t=Ln("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(n),He=o(e),ke=i(e,"P",{}),xn(ke).forEach(n),Ze=o(e),h(_.$$.fragment,e),Ce=o(e),h($.$$.fragment,e),Le=o(e),M=i(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-10amgpw"&&(M.innerHTML=Ft),qe=o(e),v=i(e,"UL",{"data-svelte-h":!0}),d(v)!=="svelte-1jcodts"&&(v.innerHTML=Nt),Ue=o(e),h(T.$$.fragment,e),Ge=o(e),j=i(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1h7nepg"&&(j.innerHTML=Pt),Ie=o(e),b=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(b)!=="svelte-18rdyla"&&(b.innerHTML=Qt),Ye=o(e),h(x.$$.fragment,e),We=o(e),k=i(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-18kdxej"&&(k.innerHTML=St),Xe=o(e),h(J.$$.fragment,e),Re=o(e),h(H.$$.fragment,e),Be=o(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-16duplw"&&(Z.innerHTML=Dt),ze=o(e),h(C.$$.fragment,e),Fe=o(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1inqh8h"&&(L.innerHTML=Vt),Ne=o(e),h(q.$$.fragment,e),Pe=o(e),U=i(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1g8f65c"&&(U.innerHTML=At),Qe=o(e),h(G.$$.fragment,e),Se=o(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10w4lgg"&&(I.innerHTML=Et),De=o(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-18b676r"&&(Y.innerHTML=Kt),Ve=o(e),h(W.$$.fragment,e),Ae=o(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1omhhlo"&&(X.innerHTML=Ot),Ee=o(e),h(R.$$.fragment,e),Ke=o(e),h(B.$$.fragment,e),Oe=o(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1ddox2e"&&(z.innerHTML=en),et=o(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-u3vbhu"&&(F.innerHTML=tn),tt=o(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1dn885x"&&(N.innerHTML=nn),nt=o(e),h(P.$$.fragment,e),at=o(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-uzetax"&&(Q.innerHTML=an),lt=o(e),h(S.$$.fragment,e),ot=o(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-ndvph"&&(D.innerHTML=ln),st=o(e),h(V.$$.fragment,e),it=o(e),h(A.$$.fragment,e),dt=o(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1mbgx4u"&&(E.innerHTML=on),rt=o(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-7dqi55"&&(K.innerHTML=sn),ht=o(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-xmbqlw"&&(O.innerHTML=dn),ft=o(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-9mgyuw"&&(ee.innerHTML=rn),pt=o(e),y=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(y)!=="svelte-1ciwfv9"&&(y.innerHTML=hn),ct=o(e),h(te.$$.fragment,e),ut=o(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-15e6l7c"&&(ne.innerHTML=fn),mt=o(e),h(ae.$$.fragment,e),gt=o(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-c19wqr"&&(le.textContent=pn),wt=o(e),h(oe.$$.fragment,e),bt=o(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-okh1lr"&&(se.innerHTML=cn),yt=o(e),h(ie.$$.fragment,e),_t=o(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-qlsyc4"&&(de.innerHTML=un),$t=o(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-6n2dv"&&(re.textContent=mn),Mt=o(e),h(he.$$.fragment,e),vt=o(e),fe=i(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-16nbuc7"&&(fe.textContent=gn),Tt=o(e),h(pe.$$.fragment,e),jt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1t7lhic"&&(ce.textContent=wn),xt=o(e),h(ue.$$.fragment,e),kt=o(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-10q3fz4"&&(me.textContent=bn),Jt=o(e),h(ge.$$.fragment,e),Ht=o(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-uorpe3"&&(we.innerHTML=yn),Zt=o(e),h(be.$$.fragment,e),Ct=o(e),ye=i(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-dgqlzs"&&(ye.innerHTML=_n),Lt=o(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-w12l45"&&(_e.innerHTML=$n),qt=o(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1ocnvge"&&($e.innerHTML=Mn),Ut=o(e),h(Me.$$.fragment,e),Gt=o(e),ve=i(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-9vjh74"&&(ve.innerHTML=vn),It=o(e),Te=i(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1wkire6"&&(Te.innerHTML=Tn),Yt=o(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-14ud9ed"&&(je.innerHTML=jn),Wt=o(e),h(xe.$$.fragment,e),Xt=o(e),Je=i(e,"P",{}),xn(Je).forEach(n),this.h()},h(){Bt(w,"name","hf:doc:metadata"),Bt(w,"content",Yn),Bt(b,"class","tip"),Bt(y,"class","tip")},m(e,t){qn(document.head,w),a(e,He,t),a(e,ke,t),a(e,Ze,t),f(_,e,t),a(e,Ce,t),f($,e,t),a(e,Le,t),a(e,M,t),a(e,qe,t),a(e,v,t),a(e,Ue,t),f(T,e,t),a(e,Ge,t),a(e,j,t),a(e,Ie,t),a(e,b,t),a(e,Ye,t),f(x,e,t),a(e,We,t),a(e,k,t),a(e,Xe,t),f(J,e,t),a(e,Re,t),f(H,e,t),a(e,Be,t),a(e,Z,t),a(e,ze,t),f(C,e,t),a(e,Fe,t),a(e,L,t),a(e,Ne,t),f(q,e,t),a(e,Pe,t),a(e,U,t),a(e,Qe,t),f(G,e,t),a(e,Se,t),a(e,I,t),a(e,De,t),a(e,Y,t),a(e,Ve,t),f(W,e,t),a(e,Ae,t),a(e,X,t),a(e,Ee,t),f(R,e,t),a(e,Ke,t),f(B,e,t),a(e,Oe,t),a(e,z,t),a(e,et,t),a(e,F,t),a(e,tt,t),a(e,N,t),a(e,nt,t),f(P,e,t),a(e,at,t),a(e,Q,t),a(e,lt,t),f(S,e,t),a(e,ot,t),a(e,D,t),a(e,st,t),f(V,e,t),a(e,it,t),f(A,e,t),a(e,dt,t),a(e,E,t),a(e,rt,t),a(e,K,t),a(e,ht,t),a(e,O,t),a(e,ft,t),a(e,ee,t),a(e,pt,t),a(e,y,t),a(e,ct,t),f(te,e,t),a(e,ut,t),a(e,ne,t),a(e,mt,t),f(ae,e,t),a(e,gt,t),a(e,le,t),a(e,wt,t),f(oe,e,t),a(e,bt,t),a(e,se,t),a(e,yt,t),f(ie,e,t),a(e,_t,t),a(e,de,t),a(e,$t,t),a(e,re,t),a(e,Mt,t),f(he,e,t),a(e,vt,t),a(e,fe,t),a(e,Tt,t),f(pe,e,t),a(e,jt,t),a(e,ce,t),a(e,xt,t),f(ue,e,t),a(e,kt,t),a(e,me,t),a(e,Jt,t),f(ge,e,t),a(e,Ht,t),a(e,we,t),a(e,Zt,t),f(be,e,t),a(e,Ct,t),a(e,ye,t),a(e,Lt,t),a(e,_e,t),a(e,qt,t),a(e,$e,t),a(e,Ut,t),f(Me,e,t),a(e,Gt,t),a(e,ve,t),a(e,It,t),a(e,Te,t),a(e,Yt,t),a(e,je,t),a(e,Wt,t),f(xe,e,t),a(e,Xt,t),a(e,Je,t),Rt=!0},p:Jn,i(e){Rt||(p(_.$$.fragment,e),p($.$$.fragment,e),p(T.$$.fragment,e),p(x.$$.fragment,e),p(J.$$.fragment,e),p(H.$$.fragment,e),p(C.$$.fragment,e),p(q.$$.fragment,e),p(G.$$.fragment,e),p(W.$$.fragment,e),p(R.$$.fragment,e),p(B.$$.fragment,e),p(P.$$.fragment,e),p(S.$$.fragment,e),p(V.$$.fragment,e),p(A.$$.fragment,e),p(te.$$.fragment,e),p(ae.$$.fragment,e),p(oe.$$.fragment,e),p(ie.$$.fragment,e),p(he.$$.fragment,e),p(pe.$$.fragment,e),p(ue.$$.fragment,e),p(ge.$$.fragment,e),p(be.$$.fragment,e),p(Me.$$.fragment,e),p(xe.$$.fragment,e),Rt=!0)},o(e){c(_.$$.fragment,e),c($.$$.fragment,e),c(T.$$.fragment,e),c(x.$$.fragment,e),c(J.$$.fragment,e),c(H.$$.fragment,e),c(C.$$.fragment,e),c(q.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(B.$$.fragment,e),c(P.$$.fragment,e),c(S.$$.fragment,e),c(V.$$.fragment,e),c(A.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(ie.$$.fragment,e),c(he.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(ge.$$.fragment,e),c(be.$$.fragment,e),c(Me.$$.fragment,e),c(xe.$$.fragment,e),Rt=!1},d(e){e&&(n(He),n(ke),n(Ze),n(Ce),n(Le),n(M),n(qe),n(v),n(Ue),n(Ge),n(j),n(Ie),n(b),n(Ye),n(We),n(k),n(Xe),n(Re),n(Be),n(Z),n(ze),n(Fe),n(L),n(Ne),n(Pe),n(U),n(Qe),n(Se),n(I),n(De),n(Y),n(Ve),n(Ae),n(X),n(Ee),n(Ke),n(Oe),n(z),n(et),n(F),n(tt),n(N),n(nt),n(at),n(Q),n(lt),n(ot),n(D),n(st),n(it),n(dt),n(E),n(rt),n(K),n(ht),n(O),n(ft),n(ee),n(pt),n(y),n(ct),n(ut),n(ne),n(mt),n(gt),n(le),n(wt),n(bt),n(se),n(yt),n(_t),n(de),n($t),n(re),n(Mt),n(vt),n(fe),n(Tt),n(jt),n(ce),n(xt),n(kt),n(me),n(Jt),n(Ht),n(we),n(Zt),n(Ct),n(ye),n(Lt),n(_e),n(qt),n($e),n(Ut),n(Gt),n(ve),n(It),n(Te),n(Yt),n(je),n(Wt),n(Xt),n(Je)),n(w),u(_,e),u($,e),u(T,e),u(x,e),u(J,e),u(H,e),u(C,e),u(q,e),u(G,e),u(W,e),u(R,e),u(B,e),u(P,e),u(S,e),u(V,e),u(A,e),u(te,e),u(ae,e),u(oe,e),u(ie,e),u(he,e),u(pe,e),u(ue,e),u(ge,e),u(be,e),u(Me,e),u(xe,e)}}}const Yn='{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Download a single file","local":"download-a-single-file","sections":[{"title":"From latest version","local":"from-latest-version","sections":[],"depth":3},{"title":"From specific version","local":"from-specific-version","sections":[],"depth":3},{"title":"Construct a download URL","local":"construct-a-download-url","sections":[],"depth":3}],"depth":2},{"title":"Download an entire repository","local":"download-an-entire-repository","sections":[{"title":"Filter files to download","local":"filter-files-to-download","sections":[],"depth":3}],"depth":2},{"title":"Download file(s) to a local folder","local":"download-files-to-a-local-folder","sections":[],"depth":2},{"title":"Download from the CLI","local":"download-from-the-cli","sections":[],"depth":2},{"title":"Dry-run mode","local":"dry-run-mode","sections":[],"depth":2},{"title":"Faster downloads","local":"faster-downloads","sections":[],"depth":2}],"depth":1}';function Wn(zt){return Hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends Zn{constructor(w){super(),Cn(this,w,Wn,In,kn,{})}}export{Nn as component};
