import{s as Ke,n as Oe,o as es}from"../chunks/scheduler.0cf4ef2e.js";import{S as ss,i as ts,e as i,s as l,c as m,h as as,a as p,d as t,b as n,f as V,g as c,j as o,k as Se,l as u,m as a,n as r,t as h,o as g,p as d}from"../chunks/index.abc433bf.js";import{C as ls}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as P}from"../chunks/CodeBlock.00dcd05e.js";import{H as _e,E as ns}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function is(Fe){let f,O,D,ee,J,se,w,te,T,He='In addition to the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, the <code>huggingface_hub</code> library provides <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>, a pythonic <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> file interface to the Hugging Face Hub. The <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> builds on top of the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> and offers typical filesystem style operations like <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, and <code>put_file</code>.',ae,j,Be=`<p>[!WARNING][HfFileSystem](/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem) provides fsspec compatibility, which is useful for libraries that require it (e.g., reading
Hugging Face datasets directly with <code>pandas</code>). However, it introduces additional overhead due to this compatibility
layer. For better performance and reliability, it’s recommended to use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> methods when possible.</p>`,le,b,ne,U,ie,k,We="The optional <code>revision</code> argument can be passed to run an operation from a specific commit such as a branch, tag name, or a commit hash.",pe,Z,Ce="Unlike Python’s built-in <code>open</code>, <code>fsspec</code>’s <code>open</code> defaults to binary mode, <code>&quot;rb&quot;</code>. This means you must explicitly set mode as <code>&quot;r&quot;</code> for reading and <code>&quot;w&quot;</code> for writing in text mode. Appending to a file (modes <code>&quot;a&quot;</code> and <code>&quot;ab&quot;</code>) is not supported yet.",oe,I,me,G,Ye='The <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> can be used with any library that integrates <code>fsspec</code>, provided the URL follows the scheme:',ce,_,re,y,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/hf_urls.png"/>',he,v,Ee="The <code>repo_type_prefix</code> is <code>datasets/</code> for datasets, <code>spaces/</code> for spaces, and models don’t need a prefix in the URL.",ge,$,qe='Some interesting integrations where <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> simplifies interacting with the Hub are listed below:',de,L,X,N,ze='Reading/writing a <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame from/to a Hub repository:',ve,R,ue,S,Ve='The same workflow can also be used for <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> and <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',fe,M,F,Q,Le='Querying (remote) Hub files with <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',$e,H,Xe,B,A,Ne='Using the Hub as an array store with <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Re,W,ye,C,Me,Y,Qe='In many cases, you must be logged in with a Hugging Face account to interact with the Hub. Refer to the <a href="../quick-start#authentication">Authentication</a> section of the documentation to learn more about authentication methods on the Hub.',Je,x,Ae='It is also possible to log in programmatically by passing your <code>token</code> as an argument to <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>:',we,E,Te,q,Pe="If you log in this way, be careful not to accidentally leak the token when sharing your source code!",je,z,be,K,Ue;return J=new ls({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new _e({props:{title:"Interact with the Hub through the Filesystem API",local:"interact-with-the-hub-through-the-filesystem-api",headingTag:"h1"}}),b=new _e({props:{title:"Usage",local:"usage",headingTag:"h2"}}),U=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwYWxsJTIwZmlsZXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMExpc3QlMjBhbGwlMjAlMjIuY3N2JTIyJTIwZmlsZXMlMjBpbiUyMGElMjByZXBvJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiolMkYqLmNzdiUyMiklMEElMEElMjMlMjBSZWFkJTIwYSUyMHJlbW90ZSUyMGZpbGUlMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnRyYWluLmNzdiUyMiUyQyUyMCUyMnIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YSUyMCUzRCUyMGYucmVhZGxpbmVzKCklMEElMEElMjMlMjBSZWFkJTIwdGhlJTIwY29udGVudCUyMG9mJTIwYSUyMHJlbW90ZSUyMGZpbGUlMjBhcyUyMGElMjBzdHJpbmclMEF0cmFpbl9kYXRhJTIwJTNEJTIwZnMucmVhZF90ZXh0KCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJkZXYlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwcmVtb3RlJTIwZmlsZSUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdmFsaWRhdGlvbi5jc3YlMjIlMkMlMjAlMjJ3JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIydGV4dCUyQ2xhYmVsJTIyKSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIyRmFudGFzdGljJTIwbW92aWUhJTJDZ29vZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all files in a directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all &quot;.csv&quot; files in a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**/*.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read the content of a remote file as a string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),I=new _e({props:{title:"Integrations",local:"integrations",headingTag:"h2"}}),_=new P({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),R=new P({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUyMGludG8lMjBhJTIwZGF0YWZyYW1lJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0cmFpbi5jc3YlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwZGF0YWZyYW1lJTIwdG8lMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote CSV file into a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a dataframe to a remote CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),H=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBRdWVyeSUyMGElMjByZW1vdGUlMjBmaWxlJTIwYW5kJTIwZ2V0JTIwdGhlJTIwcmVzdWx0JTIwYmFjayUyMGFzJTIwYSUyMGRhdGFmcmFtZSUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Query a remote file and get the result back as a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),W=new P({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGFuJTIwYXJyYXklMjB0byUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnclMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZm9vJTIwJTNEJTIwcm9vdC5jcmVhdGVfZ3JvdXAoJTIyZW1iZWRkaW5ncyUyMiklMEElMjAlMjAlMjBmb29iYXIlMjAlM0QlMjBmb28uemVyb3MoJ2V4cGVyaW1lbnRfMCclMkMlMjBzaGFwZSUzRCg1MDAwMCUyQyUyMDEwMDApJTJDJTIwY2h1bmtzJTNEKDEwMDAwJTJDJTIwMTAwMCklMkMlMjBkdHlwZSUzRCdmNCcpJTBBJTIwJTIwJTIwZm9vYmFyJTVCJTNBJTVEJTIwJTNEJTIwZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFJlYWQlMjBhbiUyMGFycmF5JTIwZnJvbSUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write an array to a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read an array from a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),C=new _e({props:{title:"Authentication",local:"authentication",headingTag:"h2"}}),E=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),z=new ns({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/hf_file_system.md"}}),{c(){f=i("meta"),O=l(),D=i("p"),ee=l(),m(J.$$.fragment),se=l(),m(w.$$.fragment),te=l(),T=i("p"),T.innerHTML=He,ae=l(),j=i("blockquote"),j.innerHTML=Be,le=l(),m(b.$$.fragment),ne=l(),m(U.$$.fragment),ie=l(),k=i("p"),k.innerHTML=We,pe=l(),Z=i("p"),Z.innerHTML=Ce,oe=l(),m(I.$$.fragment),me=l(),G=i("p"),G.innerHTML=Ye,ce=l(),m(_.$$.fragment),re=l(),y=i("div"),y.innerHTML=xe,he=l(),v=i("p"),v.innerHTML=Ee,ge=l(),$=i("p"),$.innerHTML=qe,de=l(),L=i("ul"),X=i("li"),N=i("p"),N.innerHTML=ze,ve=l(),m(R.$$.fragment),ue=l(),S=i("p"),S.innerHTML=Ve,fe=l(),M=i("ul"),F=i("li"),Q=i("p"),Q.innerHTML=Le,$e=l(),m(H.$$.fragment),Xe=l(),B=i("li"),A=i("p"),A.innerHTML=Ne,Re=l(),m(W.$$.fragment),ye=l(),m(C.$$.fragment),Me=l(),Y=i("p"),Y.innerHTML=Qe,Je=l(),x=i("p"),x.innerHTML=Ae,we=l(),m(E.$$.fragment),Te=l(),q=i("p"),q.textContent=Pe,je=l(),m(z.$$.fragment),be=l(),K=i("p"),this.h()},l(e){const s=as("svelte-u9bgzb",document.head);f=p(s,"META",{name:!0,content:!0}),s.forEach(t),O=n(e),D=p(e,"P",{}),V(D).forEach(t),ee=n(e),c(J.$$.fragment,e),se=n(e),c(w.$$.fragment,e),te=n(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1tojfmw"&&(T.innerHTML=He),ae=n(e),j=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(j)!=="svelte-249v2n"&&(j.innerHTML=Be),le=n(e),c(b.$$.fragment,e),ne=n(e),c(U.$$.fragment,e),ie=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-fkc5g9"&&(k.innerHTML=We),pe=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-2xrojz"&&(Z.innerHTML=Ce),oe=n(e),c(I.$$.fragment,e),me=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-qh16s5"&&(G.innerHTML=Ye),ce=n(e),c(_.$$.fragment,e),re=n(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-167v4fl"&&(y.innerHTML=xe),he=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1x0g0bv"&&(v.innerHTML=Ee),ge=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-v2qldv"&&($.innerHTML=qe),de=n(e),L=p(e,"UL",{});var De=V(L);X=p(De,"LI",{});var ke=V(X);N=p(ke,"P",{"data-svelte-h":!0}),o(N)!=="svelte-8bmxp4"&&(N.innerHTML=ze),ve=n(ke),c(R.$$.fragment,ke),ke.forEach(t),De.forEach(t),ue=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-evo4u9"&&(S.innerHTML=Ve),fe=n(e),M=p(e,"UL",{});var Ze=V(M);F=p(Ze,"LI",{});var Ie=V(F);Q=p(Ie,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-14x5nlf"&&(Q.innerHTML=Le),$e=n(Ie),c(H.$$.fragment,Ie),Ie.forEach(t),Xe=n(Ze),B=p(Ze,"LI",{});var Ge=V(B);A=p(Ge,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1abwu1e"&&(A.innerHTML=Ne),Re=n(Ge),c(W.$$.fragment,Ge),Ge.forEach(t),Ze.forEach(t),ye=n(e),c(C.$$.fragment,e),Me=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-kwqcxw"&&(Y.innerHTML=Qe),Je=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-cxfkyz"&&(x.innerHTML=Ae),we=n(e),c(E.$$.fragment,e),Te=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-172urp9"&&(q.textContent=Pe),je=n(e),c(z.$$.fragment,e),be=n(e),K=p(e,"P",{}),V(K).forEach(t),this.h()},h(){Se(f,"name","hf:doc:metadata"),Se(f,"content",ps),Se(y,"class","flex justify-center")},m(e,s){u(document.head,f),a(e,O,s),a(e,D,s),a(e,ee,s),r(J,e,s),a(e,se,s),r(w,e,s),a(e,te,s),a(e,T,s),a(e,ae,s),a(e,j,s),a(e,le,s),r(b,e,s),a(e,ne,s),r(U,e,s),a(e,ie,s),a(e,k,s),a(e,pe,s),a(e,Z,s),a(e,oe,s),r(I,e,s),a(e,me,s),a(e,G,s),a(e,ce,s),r(_,e,s),a(e,re,s),a(e,y,s),a(e,he,s),a(e,v,s),a(e,ge,s),a(e,$,s),a(e,de,s),a(e,L,s),u(L,X),u(X,N),u(X,ve),r(R,X,null),a(e,ue,s),a(e,S,s),a(e,fe,s),a(e,M,s),u(M,F),u(F,Q),u(F,$e),r(H,F,null),u(M,Xe),u(M,B),u(B,A),u(B,Re),r(W,B,null),a(e,ye,s),r(C,e,s),a(e,Me,s),a(e,Y,s),a(e,Je,s),a(e,x,s),a(e,we,s),r(E,e,s),a(e,Te,s),a(e,q,s),a(e,je,s),r(z,e,s),a(e,be,s),a(e,K,s),Ue=!0},p:Oe,i(e){Ue||(h(J.$$.fragment,e),h(w.$$.fragment,e),h(b.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(W.$$.fragment,e),h(C.$$.fragment,e),h(E.$$.fragment,e),h(z.$$.fragment,e),Ue=!0)},o(e){g(J.$$.fragment,e),g(w.$$.fragment,e),g(b.$$.fragment,e),g(U.$$.fragment,e),g(I.$$.fragment,e),g(_.$$.fragment,e),g(R.$$.fragment,e),g(H.$$.fragment,e),g(W.$$.fragment,e),g(C.$$.fragment,e),g(E.$$.fragment,e),g(z.$$.fragment,e),Ue=!1},d(e){e&&(t(O),t(D),t(ee),t(se),t(te),t(T),t(ae),t(j),t(le),t(ne),t(ie),t(k),t(pe),t(Z),t(oe),t(me),t(G),t(ce),t(re),t(y),t(he),t(v),t(ge),t($),t(de),t(L),t(ue),t(S),t(fe),t(M),t(ye),t(Me),t(Y),t(Je),t(x),t(we),t(Te),t(q),t(je),t(be),t(K)),t(f),d(J,e),d(w,e),d(b,e),d(U,e),d(I,e),d(_,e),d(R),d(H),d(W),d(C,e),d(E,e),d(z,e)}}}const ps='{"title":"Interact with the Hub through the Filesystem API","local":"interact-with-the-hub-through-the-filesystem-api","sections":[{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Integrations","local":"integrations","sections":[],"depth":2},{"title":"Authentication","local":"authentication","sections":[],"depth":2}],"depth":1}';function os(Fe){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends ss{constructor(f){super(),ts(this,f,os,is,Ke,{})}}export{ds as component};
