import{s as Ql,n as Xl,o as Rl}from"../chunks/scheduler.de5597d1.js";import{S as Sl,i as Ll,e as i,s as a,c as p,h as Yl,a as o,d as s,b as n,f as zl,g as M,j as r,k as pl,l as ql,m as t,n as d,t as u,o as c,p as m}from"../chunks/index.bf1177c2.js";import{C as Fl,H as y,E as Nl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.fdb12f74.js";import{C as Me}from"../chunks/CodeBlock.1b37f620.js";function Pl(Ml){let h,ce,de,me,U,ye,w,he,j,dl=`Le Hugging Face Hub facilite l’hébergement et le partage de modèles et de jeux de données.
Des <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dizaines de librairies</a> sont intégrées à cet écosystème. La communauté travaille constamment à en intégrer de nouvelles et contribue ainsi à faciliter la collaboration dans le milieu du machine learning. La librairie <code>huggingface_hub</code> joue un rôle clé dans ce processus puisqu’elle permet d’interagir avec le Hub depuis n’importe quel script Python.`,Te,b,ul="Il existe quatre façons principales d’intégrer une bibliothèque au Hub :",Je,f,cl='<li><strong>Push to Hub</strong>  implémente une méthode pour upload un modèle sur le Hub. Cela inclut les paramètres du modèle, sa fiche descriptive (appelée <a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">Model Card</a>) et toute autre information pertinente liée au modèle (par exemple, les logs d’entraînement). Cette méthode est souvent appelée <code>push_to_hub()</code>.</li> <li><strong>Download from Hub</strong> implémente une méthode pour charger un modèle depuis le Hub. La méthode doit télécharger la configuration et les poids du modèle puis instancier celui-ci. Cette méthode est souvent appelée <code>from_pretrained</code> ou <code>load_from_hub()</code>.</li> <li><strong>Widgets</strong> affiche un widget sur la page d’accueil de votre modèle dans le Hub. Les widgets permettent aux utilisateurs de rapidement tester un modèle depuis le navigateur.</li>',Ue,C,ml="Dans ce guide, nous nous concentrerons sur les deux premiers sujets. Nous présenterons les deux approches principales que vous pouvez utiliser pour intégrer une librairie, avec leurs avantages et leurs inconvénients. Tout est résumé à la fin du guide pour vous aider à choisir entre les deux. Veuillez garder à l’esprit que ce ne sont que des conseils, et vous êtes libres de les adapter à votre cas d’usage.",we,I,yl='Si les Widgets vous intéressent, vous pouvez suivre <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">ce guide</a>. Dans les deux cas, vous pouvez nous contacter si vous intégrez une librairie au Hub et que vous voulez être listé <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dans la documentation officielle</a>.',je,v,be,g,hl=`La première approche pour intégrer une librairie au Hub est d’implémenter les méthodes <code>push_to_hub</code> et <code>from_pretrained</code>
vous-même. Ceci vous donne une flexibilité totale sur le choix du fichier que vous voulez upload/download et sur comment
gérer les inputs spécifiques à votre framework. Vous pouvez vous référer aux guides : <a href="./upload">upload des fichiers</a>
et <a href="./download">télécharger des fichiers</a> pour en savoir plus sur la manière de faire. Par example, c’est de cette manière que l’intégration
de FastAI est implémentée (voir <code>push_to_hub_fastai()</code> et <code>from_pretrained_fastai()</code>).`,fe,_,Tl="L’implémentation peut varier entre différentes librairies, mais le workflow est souvent similaire.",Ce,Z,Ie,G,Jl="Voici un exemple classique pour implémenter la méthode <code>from_pretrained</code>:",ve,B,ge,x,_e,V,Ul=`La méthode <code>push_to_hub</code> demande souvent un peu plus de complexité pour gérer la création du dépôt git, générer la model card et enregistrer les paramètres.
Une approche commune est de sauvegarder tous ces fichiers dans un dossier temporaire, les transférer sur le Hub avant de les supprimer localement.`,Ze,H,Ge,A,wl=`Ceci n’est qu’un exemple. Si vous êtes intéressés par des manipulations plus complexes (supprimer des fichiers distants,
upload des poids à la volée, maintenir les poids localement, etc.) consultez le guide <a href="./upload">upload des fichiers</a>.`,Be,k,xe,$,jl=`Bien que très flexible, cette approche a quelques défauts, particulièrement en termes de maintenance. Les utilisateurs
d’Hugging Face sont habitués à utiliser certaines fonctionnalités lorsqu’ils travaillent avec <code>huggingface_hub</code>. Par exemple,
lors du chargement de fichiers depuis le Hub, il est commun de passer des paramètres tels que:`,Ve,E,bl="<li><code>token</code>: pour télécharger depuis un dépôt privé</li> <li><code>revision</code>: pour télécharger depuis une branche spécifique</li> <li><code>cache_dir</code>: pour paramétrer la mise en cache des fichiers</li> <li><code>force_download</code>: pour désactiver le cache</li> <li><code>api_endpoint</code>/<code>proxies</code>: pour configurer la session HTTP</li>",He,W,fl="Lorsque vous pushez des modèles, des paramètres similaires sont utilisables:",Ae,z,Cl="<li><code>commit_message</code>: message de commit personnalisé</li> <li><code>private</code>: crée un dépôt privé s’il en manque un</li> <li><code>create_pr</code>: crée une pull request au lieu de push vers <code>main</code></li> <li><code>branch</code>: push vers une branche au lieu de push sur <code>main</code></li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filtre les fichiers à upload</li> <li><code>token</code></li> <li><code>api_endpoint</code></li> <li>…</li>",ke,Q,Il=`Tous ces paramètres peuvent être ajoutés aux implémentations vues ci-dessus et passés aux méthodes de <code>huggingface_hub</code>.
Toutefois, si un paramètre change ou qu’une nouvelle fonctionnalité est ajoutée, vous devrez mettre à jour votre package.
Supporter ces paramètres implique aussi plus de documentation à maintenir de votre côté. Dans la prochaine section, nous allons voir comment dépasser ces limitations.`,$e,X,Ee,R,vl=`Comme vu ci-dessus, deux méthodes principales sont à inclure dans votre librairie pour l’intégrer avec le Hub:
la méthode permettant d’upload des fichiers (<code>push_to_hub</code>) et celle pour télécharger des fichiers (<code>from_pretrained</code>).
Vous pouvez implémenter ces méthodes vous-même mais cela a des inconvénients. Pour gérer ça, <code>huggingface_hub</code> fournit
un outil qui utilise l’héritage de classe. Regardons comment ça marche !`,We,S,gl=`Dans beaucoup de cas, une librairie définit déjà les modèles comme des classes Python. La classe contient les
propriétés du modèle et des méthodes pour charger, lancer, entraîner et évaluer le modèle. Notre approche est d’étendre
cette classe pour inclure les fonctionnalités upload et download en utilisant les mixins. Une <a href="https://stackoverflow.com/a/547714" rel="nofollow">mixin</a>
est une classe qui est faite pour étendre une classe existante avec une liste de fonctionnalités spécifiques en utilisant l’héritage de classe.
<code>huggingface_hub</code> offre son propre mixin, le <code>ModelHubMixin</code>. La clef ici est de comprendre son comportement et comment le customiser.`,ze,L,_l=`La classe <code>ModelHubMixin</code> implémente 3 méthodes <em>public</em> (<code>push_to_hub</code>, <code>save_pretrained</code> et <code>from_pretrained</code>). Ce
sont les méthodes que vos utilisateurs appelleront pour charger/enregistrer des modèles avec votre librairie.
<code>ModelHubMixin</code> définit aussi 2 méthodes <em>private</em> (<code>_save_pretrained</code> et <code>from_pretrained</code>). Ce sont celles que vous
devez implémenter. Ainsi, pour intégrer votre librairie, vous devez :`,Qe,Y,Zl=`<li>Faire en sorte que votre classe Model hérite de <code>ModelHubMixin</code>.</li> <li>Implémenter les méthodes privées:
<ul><li><code>_save_pretrained()</code>: méthode qui prend en entrée un chemin vers un directory et qui sauvegarde le modèle.
Vous devez écrire toute la logique pour dump votre modèle de cette manière: model card, poids du modèle, fichiers de configuration,
et logs d’entraînement. Toute information pertinente pour ce modèle doit être gérée par cette méthode. Les
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">model cards</a> sont particulièrement importantes pour décrire votre modèle. Vérifiez
<a href="./model-cards">notre guide d’implémentation</a> pour plus de détails.</li> <li><code>_from_pretrained()</code>: <strong>méthode de classe</strong> prenant en entrée un <code>model_id</code> et qui retourne un modèle instancié.
Cette méthode doit télécharger un ou plusieurs fichier(s) et le(s) charger.</li></ul></li> <li>Fini!</li>`,Xe,q,Gl=`L’avantage d’utiliser <code>ModelHubMixin</code> est qu’une fois que vous vous êtes occupés de la sérialisation et du chargement du fichier,
vous êtes prêts. Vous n’avez pas besoin de vous soucier de la création du dépôt, des commits, des pull requests ou des révisions.
Tout ceci est géré par le mixin et est disponible pour vos utilisateurs. Le Mixin s’assure aussi que les méthodes publiques sont
bien documentées et que les annotations de typage sont spécifiées.`,Re,F,Se,N,Bl=`Un bon exemple de ce que nous avons vu ci-dessus est <code>PyTorchModelHubMixin</code>, notre intégration pour le framework PyTorch.
C’est une intégration prête à l’emploi.`,Le,P,Ye,D,xl="Voici comment n’importe quel utilisateur peut charger/enregistrer un modèle Pytorch depuis/vers le Hub:",qe,K,Fe,O,Ne,ee,Vl='L’implémentation est très succincte (voir <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">ici</a>).',Pe,le,Hl="<li>Premièrement, faites hériter votre classe de <code>ModelHubMixin</code>:</li>",De,se,Ke,T,Al="<li>Implémentez la méthode <code>_save_pretrained</code>:</li>",Oe,te,el,J,kl="<li>Implémentez la méthode <code>_from_pretrained</code>:</li>",ll,ae,sl,ne,$l="Et c’est fini ! Votre librairie permet maintenant aux utilisateurs d’upload et de télécharger des fichiers vers et depuis le Hub.",tl,ie,al,oe,El=`Résumons rapidement les deux approches que nous avons vu avec leurs avantages et leurs défauts. Le tableau ci-dessous
est purement indicatif. Votre framework aura peut-êre des spécificités à prendre en compte. Ce guide
est ici pour vous donner des indications et des idées sur comment gérer l’intégration. Dans tous les cas,
n’hésitez pas à nous contacter si vous avez une question !`,nl,re,Wl='<thead><tr><th align="center">Intégration</th> <th align="center">Utilisant des helpers</th> <th align="center">Utilisant <code>ModelHubMixin</code></th></tr></thead> <tbody><tr><td align="center">Expérience utilisateur</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexible</td> <td align="center">Très flexible.<br/>Vous controllez complètement l’implémentation.</td> <td align="center">Moins flexible.<br/>Votre framework doit avoir une classe de modèle.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">Plus de maintenance pour ajouter du support pour la configuration, et de nouvelles fonctionnalités. Peut aussi nécessiter de fixx des problèmes signalés par les utilisateurs.</td> <td align="center">Moins de maintenance vu que la plupart des intégrations avec le Hub sont implémentés dans <code>huggingface_hub</code></td></tr> <tr><td align="center">Documentation / Anotation de type</td> <td align="center">A écrire à la main</td> <td align="center">Géré partiellement par <code>huggingface_hub</code>.</td></tr></tbody>',il,pe,ol,ue,rl;return U=new Fl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new y({props:{title:"Intégrez votre framework de ML avec le Hub",local:"intégrez-votre-framework-de-ml-avec-le-hub",headingTag:"h1"}}),v=new y({props:{title:"Une approche flexible: les helpers",local:"une-approche-flexible-les-helpers",headingTag:"h2"}}),Z=new y({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),B=new Me({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBUJUMzJUE5bCVDMyVBOWNoYXJnZW1lbnQlMjBkZXMlMjBwYXJhbSVDMyVBOHRyZXMlMjBkZXB1aXMlMjBsZSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwSW5zdGFuY2lhdGlvbiUyMGR1JTIwbW9kJUMzJUE4bGUlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkX21vZGVsKGNhY2hlZF9tb2RlbCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Téléchargement des paramètres depuis le Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Instanciation du modèle</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),x=new y({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),H=new Me({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3IlQzMlQTlleiUyMGQndW4lMjBkJUMzJUE5cCVDMyVCNHQlMjBzJ2lsJTIwbidleGlzdGUlMjBwYXMlMjBlbmNvcmUlMkMlMjBldCUyMG9idGVuZXolMjBsZSUyMHJlcG9faWQlMjBhc3NvY2klQzMlQTklMEElMjAlMjAlMjByZXBvX2lkJTIwJTNEJTIwYXBpLmNyZWF0ZV9yZXBvKHJlcG9fbmFtZSUyQyUyMGV4aXN0X29rJTNEVHJ1ZSkucmVwb19pZCUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdXZlZ2FyZGV6JTIwdG91cyUyMGxlcyUyMGZpY2hpZXJzJTIwZGFucyUyMHVuJTIwY2hlbWluJTIwdGVtcG9yYWlyZSUyQyUyMGV0JTIwcHVzaGV6JTIwbGVzJTIwZW4lMjB1biUyMHNldWwlMjBjb21taXQlMEElMjAlMjAlMjB3aXRoJTIwVGVtcG9yYXJ5RGlyZWN0b3J5KCklMjBhcyUyMHRtcGRpciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHRtcGRpciUyMCUzRCUyMFBhdGgodG1wZGlyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdXZlZ2FyZGV6JTIwbGVzJTIwcG9pZHMlMEElMjAlMjAlMjAlMjAlMjAlMjBzYXZlX21vZGVsKG1vZGVsJTJDJTIwdG1wZGlyJTIwJTJGJTIwJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRyVDMyVBOW4lQzMlQTlyZXolMjBsYSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXV2ZWdhcmRleiUyMGxlcyUyMGxvZ3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXV2ZWdhcmRleiUyMGxlJTIwbSVDMyVBOXRyaXF1ZXMlMjBkJyVDMyVBOXZhbHVhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFB1c2hleiUyMHZlcnMlMjBsZSUyMEh1YiUwQSUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFwaS51cGxvYWRfZm9sZGVyKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwZm9sZGVyX3BhdGglM0R0bXBkaXIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Créez d&#x27;un dépôt s&#x27;il n&#x27;existe pas encore, et obtenez le repo_id associé</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>).repo_id

   <span class="hljs-comment"># Sauvegardez tous les fichiers dans un chemin temporaire, et pushez les en un seul commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Sauvegardez les poids</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Générez la model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Sauvegardez les logs</span>
      <span class="hljs-comment"># Sauvegardez le métriques d&#x27;évaluation</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Pushez vers le Hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),k=new y({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),X=new y({props:{title:"Une approche plus complexe: l’héritage de classe",local:"une-approche-plus-complexe-lhéritage-de-classe",headingTag:"h2"}}),F=new y({props:{title:"Un exemple concret: PyTorch",local:"un-exemple-concret-pytorch",headingTag:"h3"}}),P=new y({props:{title:"Comment l’utiliser ?",local:"comment-lutiliser-",headingTag:"h4"}}),K=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwaCVDMyVBOXJpdGFnZSUyMG11bHRpcGxlJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhcmFtJTIwJTNEJTIwbm4uUGFyYW1ldGVyKHRvcmNoLnJhbmQoMyUyQyUyMDQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwbm4uTGluZWFyKDQlMkMlMjA1KSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5saW5lYXIoeCUyMCUyQiUyMHNlbGYucGFyYW0pJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKCklMEElMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGbXktYXdlc29tZS1tb2RlbCUyMiklMEElMEFtb2RlbC5wdXNoX3RvX2h1YiglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydXNlcm5hbWUlMkZteS1hd2Vzb21lLW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 1. Définissez votre modèle Pytorch exactement comme vous êtes habitués à le faire</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># héritage multiple</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__() 
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># 2. (optionnel) Sauvegarder le modèle dans un chemin local</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Pushez les poids du modèle vers le Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. initialisez le modèle depuis le Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),O=new y({props:{title:"Implémentation",local:"implémentation",headingTag:"h4"}}),se=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),te=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyRyVDMyVBOW4lQzMlQTlyZXolMjB1bmUlMjBtb2RlbCUyMGNhcmQlMjBldCUyMGVucmVnaXN0cmV6JTIwbGVzJTIwcG9pZHMlMjBkJ3VuJTIwbW9kJUMzJUE4bGUlMjBQeXRyb2NoJTIwdmVycyUyMHVuJTIwY2hlbWluJTIwbG9jYWwuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfY2FyZCUyMCUzRCUyME1vZGVsQ2FyZC5mcm9tX3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRfZGF0YSUzRE1vZGVsQ2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGljZW5zZSUzRCdtaXQnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9zdW1tYXJ5JTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAoc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoc3RyKG1vZGVsKSklMEElMjAlMjAlMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG9iaiUzRHNlbGYubW9kdWxlLnN0YXRlX2RpY3QoKSUyQyUyMGYlM0RzYXZlX2RpcmVjdG9yeSUyMCUyRiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Générez une model card et enregistrez les poids d&#x27;un modèle Pytroch vers un chemin local.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),ae=new Me({props:{code:"Y2xhc3MlMjBQeVRvcmNoTW9kZWxIdWJNaXhpbihNb2RlbEh1Yk1peGluKSUzQSUwQSUyMCUyMCUyMCguLi4pJTBBJTBBJTIwJTIwJTIwJTQwY2xhc3NtZXRob2QlMjAlMjMlMjBEb2l0JTIwYWJzb2x1bWVudCUyMCVDMyVBQXRyZSUyMHVuZSUyMG0lQzMlQTl0aG9kZSUyMGRlJTIwY2xhc2UlMjAhJTBBJTIwJTIwJTIwZGVmJTIwX2Zyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjBjbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0ElMjBzdHIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjByZXZpc2lvbiUzQSUyMHN0ciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlX2RpciUzQSUyMHN0ciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZvcmNlX2Rvd25sb2FkJTNBJTIwYm9vbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGxvY2FsX2ZpbGVzX29ubHklM0ElMjBib29sJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW4lM0ElMjBVbmlvbiU1QnN0ciUyQyUyMGJvb2wlMkMlMjBOb25lJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbWFwX2xvY2F0aW9uJTNBJTIwc3RyJTIwJTNEJTIwJTIyY3B1JTIyJTJDJTIwJTIzJTIwYXJndW1lbnQlMjBzdXBwbCVDMyVBOW1lbnRhaXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwc3RyaWN0JTNBJTIwYm9vbCUyMCUzRCUyMEZhbHNlJTJDJTIwJTIzJTIwYXJndW1lbnQlMjBzdXBwbCVDMyVBOW1lbnRhaXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwKiptb2RlbF9rd2FyZ3MlMkMlMEElMjAlMjAlMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ2hhcmdleiUyMGxlcyUyMHBvaWRzJTIwcHIlQzMlQTktZW50cmFpbiVDMyVBOXMlMjBldCUyMHJlbnZveWV6JTIwbGVzJTIwYXUlMjBtb2QlQzMlQThsZSUyMGNoYXJnJUMzJUE5LiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwb3MucGF0aC5pc2Rpcihtb2RlbF9pZCklM0ElMjAlMjMlMjBQZXV0JTIwJUMzJUFBdHJlJTIwdW4lMjBjaGVtaW4lMjBsb2NhbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkxvYWRpbmclMjB3ZWlnaHRzJTIwZnJvbSUyMGxvY2FsJTIwZGlyZWN0b3J5JTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2ZpbGUlMjAlM0QlMjBvcy5wYXRoLmpvaW4obW9kZWxfaWQlMkMlMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTIwJTIzJTIwT3UlMjB1biUyMG1vZCVDMyVBOGxlJTIwZHUlMjBIdWIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9maWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUyMCUyMyUyMFQlQzMlQTlsJUMzJUE5Y2hhcmdleiUyMGRlcHVpcyUyMGxlJTIwSHViJTJDJTIwZW4lMjBwYXNzYW50JTIwbGUlMjBtJUMzJUFBbWVzJTIwYXJndW1lbnRzJTIwZCdlbnRyJUMzJUE5ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0Rtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXZpc2lvbiUzRHJldmlzaW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGVfZGlyJTNEY2FjaGVfZGlyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yY2VfZG93bmxvYWQlM0Rmb3JjZV9kb3dubG9hZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEdG9rZW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhbF9maWxlc19vbmx5JTNEbG9jYWxfZmlsZXNfb25seSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDaGFyZ2V6JTIwbGUlMjBtb2QlQzMlQThsZSUyMGV0JTIwcmVvdXRuZXolMjB1bmUlMjBsb2dpcXVlJTIwcGVyc29ubmFsaXMlQzMlQTllJTIwZCVDMyVBOXBlbmRhbnQlMjBkZSUyMHZvdHJlJTIwZnJhbWV3b3JrJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBjbHMoKiptb2RlbF9rd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGVfZGljdCUyMCUzRCUyMHRvcmNoLmxvYWQobW9kZWxfZmlsZSUyQyUyMG1hcF9sb2NhdGlvbiUzRHRvcmNoLmRldmljZShtYXBfbG9jYXRpb24pKSUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwc3RyaWN0JTNEc3RyaWN0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG1vZGVs",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Doit absolument être une méthode de clase !</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># argument supplémentaire</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># argument supplémentaire</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Chargez les poids pré-entrainés et renvoyez les au modèle chargé.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Peut être un chemin local</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Ou un modèle du Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Téléchargez depuis le Hub, en passant le mêmes arguments d&#x27;entrée</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Chargez le modèle et reoutnez une logique personnalisée dépendant de votre framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`,wrap:!1}}),ie=new y({props:{title:"Comparaison",local:"comparaison",headingTag:"h2"}}),pe=new Nl({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/fr/guides/integrations.md"}}),{c(){h=i("meta"),ce=a(),de=i("p"),me=a(),p(U.$$.fragment),ye=a(),p(w.$$.fragment),he=a(),j=i("p"),j.innerHTML=dl,Te=a(),b=i("p"),b.textContent=ul,Je=a(),f=i("ol"),f.innerHTML=cl,Ue=a(),C=i("p"),C.textContent=ml,we=a(),I=i("p"),I.innerHTML=yl,je=a(),p(v.$$.fragment),be=a(),g=i("p"),g.innerHTML=hl,fe=a(),_=i("p"),_.textContent=Tl,Ce=a(),p(Z.$$.fragment),Ie=a(),G=i("p"),G.innerHTML=Jl,ve=a(),p(B.$$.fragment),ge=a(),p(x.$$.fragment),_e=a(),V=i("p"),V.innerHTML=Ul,Ze=a(),p(H.$$.fragment),Ge=a(),A=i("p"),A.innerHTML=wl,Be=a(),p(k.$$.fragment),xe=a(),$=i("p"),$.innerHTML=jl,Ve=a(),E=i("ul"),E.innerHTML=bl,He=a(),W=i("p"),W.textContent=fl,Ae=a(),z=i("ul"),z.innerHTML=Cl,ke=a(),Q=i("p"),Q.innerHTML=Il,$e=a(),p(X.$$.fragment),Ee=a(),R=i("p"),R.innerHTML=vl,We=a(),S=i("p"),S.innerHTML=gl,ze=a(),L=i("p"),L.innerHTML=_l,Qe=a(),Y=i("ol"),Y.innerHTML=Zl,Xe=a(),q=i("p"),q.innerHTML=Gl,Re=a(),p(F.$$.fragment),Se=a(),N=i("p"),N.innerHTML=Bl,Le=a(),p(P.$$.fragment),Ye=a(),D=i("p"),D.textContent=xl,qe=a(),p(K.$$.fragment),Fe=a(),p(O.$$.fragment),Ne=a(),ee=i("p"),ee.innerHTML=Vl,Pe=a(),le=i("ol"),le.innerHTML=Hl,De=a(),p(se.$$.fragment),Ke=a(),T=i("ol"),T.innerHTML=Al,Oe=a(),p(te.$$.fragment),el=a(),J=i("ol"),J.innerHTML=kl,ll=a(),p(ae.$$.fragment),sl=a(),ne=i("p"),ne.textContent=$l,tl=a(),p(ie.$$.fragment),al=a(),oe=i("p"),oe.textContent=El,nl=a(),re=i("table"),re.innerHTML=Wl,il=a(),p(pe.$$.fragment),ol=a(),ue=i("p"),this.h()},l(e){const l=Yl("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(s),ce=n(e),de=o(e,"P",{}),zl(de).forEach(s),me=n(e),M(U.$$.fragment,e),ye=n(e),M(w.$$.fragment,e),he=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-mirtrh"&&(j.innerHTML=dl),Te=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-lch9h7"&&(b.textContent=ul),Je=n(e),f=o(e,"OL",{"data-svelte-h":!0}),r(f)!=="svelte-obk831"&&(f.innerHTML=cl),Ue=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1m2dv"&&(C.textContent=ml),we=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1uuol13"&&(I.innerHTML=yl),je=n(e),M(v.$$.fragment,e),be=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1qdxn8o"&&(g.innerHTML=hl),fe=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1mpuo70"&&(_.textContent=Tl),Ce=n(e),M(Z.$$.fragment,e),Ie=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1qkz3sm"&&(G.innerHTML=Jl),ve=n(e),M(B.$$.fragment,e),ge=n(e),M(x.$$.fragment,e),_e=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1dt02hs"&&(V.innerHTML=Ul),Ze=n(e),M(H.$$.fragment,e),Ge=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-u256fg"&&(A.innerHTML=wl),Be=n(e),M(k.$$.fragment,e),xe=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-5vkp22"&&($.innerHTML=jl),Ve=n(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-13keayf"&&(E.innerHTML=bl),He=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1rvzx3t"&&(W.textContent=fl),Ae=n(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-4xb4sl"&&(z.innerHTML=Cl),ke=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-36ifoq"&&(Q.innerHTML=Il),$e=n(e),M(X.$$.fragment,e),Ee=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1712uhi"&&(R.innerHTML=vl),We=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-q1s7fi"&&(S.innerHTML=gl),ze=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-156tn70"&&(L.innerHTML=_l),Qe=n(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-17x6hem"&&(Y.innerHTML=Zl),Xe=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1h46380"&&(q.innerHTML=Gl),Re=n(e),M(F.$$.fragment,e),Se=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-rzlgnm"&&(N.innerHTML=Bl),Le=n(e),M(P.$$.fragment,e),Ye=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1qhg0n9"&&(D.textContent=xl),qe=n(e),M(K.$$.fragment,e),Fe=n(e),M(O.$$.fragment,e),Ne=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-15qqbl2"&&(ee.innerHTML=Vl),Pe=n(e),le=o(e,"OL",{"data-svelte-h":!0}),r(le)!=="svelte-r5vsjg"&&(le.innerHTML=Hl),De=n(e),M(se.$$.fragment,e),Ke=n(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-1ue2kw7"&&(T.innerHTML=Al),Oe=n(e),M(te.$$.fragment,e),el=n(e),J=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(J)!=="svelte-1ntce4z"&&(J.innerHTML=kl),ll=n(e),M(ae.$$.fragment,e),sl=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-gfrff"&&(ne.textContent=$l),tl=n(e),M(ie.$$.fragment,e),al=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-7eam1e"&&(oe.textContent=El),nl=n(e),re=o(e,"TABLE",{"data-svelte-h":!0}),r(re)!=="svelte-ybnuf2"&&(re.innerHTML=Wl),il=n(e),M(pe.$$.fragment,e),ol=n(e),ue=o(e,"P",{}),zl(ue).forEach(s),this.h()},h(){pl(h,"name","hf:doc:metadata"),pl(h,"content",Dl),pl(T,"start","2"),pl(J,"start","3")},m(e,l){ql(document.head,h),t(e,ce,l),t(e,de,l),t(e,me,l),d(U,e,l),t(e,ye,l),d(w,e,l),t(e,he,l),t(e,j,l),t(e,Te,l),t(e,b,l),t(e,Je,l),t(e,f,l),t(e,Ue,l),t(e,C,l),t(e,we,l),t(e,I,l),t(e,je,l),d(v,e,l),t(e,be,l),t(e,g,l),t(e,fe,l),t(e,_,l),t(e,Ce,l),d(Z,e,l),t(e,Ie,l),t(e,G,l),t(e,ve,l),d(B,e,l),t(e,ge,l),d(x,e,l),t(e,_e,l),t(e,V,l),t(e,Ze,l),d(H,e,l),t(e,Ge,l),t(e,A,l),t(e,Be,l),d(k,e,l),t(e,xe,l),t(e,$,l),t(e,Ve,l),t(e,E,l),t(e,He,l),t(e,W,l),t(e,Ae,l),t(e,z,l),t(e,ke,l),t(e,Q,l),t(e,$e,l),d(X,e,l),t(e,Ee,l),t(e,R,l),t(e,We,l),t(e,S,l),t(e,ze,l),t(e,L,l),t(e,Qe,l),t(e,Y,l),t(e,Xe,l),t(e,q,l),t(e,Re,l),d(F,e,l),t(e,Se,l),t(e,N,l),t(e,Le,l),d(P,e,l),t(e,Ye,l),t(e,D,l),t(e,qe,l),d(K,e,l),t(e,Fe,l),d(O,e,l),t(e,Ne,l),t(e,ee,l),t(e,Pe,l),t(e,le,l),t(e,De,l),d(se,e,l),t(e,Ke,l),t(e,T,l),t(e,Oe,l),d(te,e,l),t(e,el,l),t(e,J,l),t(e,ll,l),d(ae,e,l),t(e,sl,l),t(e,ne,l),t(e,tl,l),d(ie,e,l),t(e,al,l),t(e,oe,l),t(e,nl,l),t(e,re,l),t(e,il,l),d(pe,e,l),t(e,ol,l),t(e,ue,l),rl=!0},p:Xl,i(e){rl||(u(U.$$.fragment,e),u(w.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(x.$$.fragment,e),u(H.$$.fragment,e),u(k.$$.fragment,e),u(X.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),rl=!0)},o(e){c(U.$$.fragment,e),c(w.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),rl=!1},d(e){e&&(s(ce),s(de),s(me),s(ye),s(he),s(j),s(Te),s(b),s(Je),s(f),s(Ue),s(C),s(we),s(I),s(je),s(be),s(g),s(fe),s(_),s(Ce),s(Ie),s(G),s(ve),s(ge),s(_e),s(V),s(Ze),s(Ge),s(A),s(Be),s(xe),s($),s(Ve),s(E),s(He),s(W),s(Ae),s(z),s(ke),s(Q),s($e),s(Ee),s(R),s(We),s(S),s(ze),s(L),s(Qe),s(Y),s(Xe),s(q),s(Re),s(Se),s(N),s(Le),s(Ye),s(D),s(qe),s(Fe),s(Ne),s(ee),s(Pe),s(le),s(De),s(Ke),s(T),s(Oe),s(el),s(J),s(ll),s(sl),s(ne),s(tl),s(al),s(oe),s(nl),s(re),s(il),s(ol),s(ue)),s(h),m(U,e),m(w,e),m(v,e),m(Z,e),m(B,e),m(x,e),m(H,e),m(k,e),m(X,e),m(F,e),m(P,e),m(K,e),m(O,e),m(se,e),m(te,e),m(ae,e),m(ie,e),m(pe,e)}}}const Dl='{"title":"Intégrez votre framework de ML avec le Hub","local":"intégrez-votre-framework-de-ml-avec-le-hub","sections":[{"title":"Une approche flexible: les helpers","local":"une-approche-flexible-les-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Une approche plus complexe: l’héritage de classe","local":"une-approche-plus-complexe-lhéritage-de-classe","sections":[{"title":"Un exemple concret: PyTorch","local":"un-exemple-concret-pytorch","sections":[{"title":"Comment l’utiliser ?","local":"comment-lutiliser-","sections":[],"depth":4},{"title":"Implémentation","local":"implémentation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Comparaison","local":"comparaison","sections":[],"depth":2}],"depth":1}';function Kl(Ml){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Sl{constructor(h){super(),Ll(this,h,Kl,Pl,Ql,{})}}export{ts as component};
