# Space 런타임 관리[[managing-your-space-runtime]]

Hub의 Space를 관리하는 메소드에 대한 자세한 설명은 [HfApi](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi)페이지를 확인하세요.

- Space 복제: [duplicate_space()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space)
- 현재 런타임 가져오기: [get_space_runtime()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_space_runtime)
- 보안 관리: [add_space_secret()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.add_space_secret) 및 [delete_space_secret()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_space_secret)
- 하드웨어 관리: [request_space_hardware()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.request_space_hardware)
- 상태 관리: [pause_space()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_space), [restart_space()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.restart_space), [set_space_sleep_time()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.set_space_sleep_time)

## 데이터 구조[[data-structures]]

### SpaceRuntime[[huggingface_hub.SpaceRuntime]][[huggingface_hub.SpaceRuntime]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SpaceRuntime</name><anchor>huggingface_hub.SpaceRuntime</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_space_api.py#L103</source><parameters>[{"name": "data", "val": ": dict"}]</parameters><paramsdesc>- **stage** (`str`) --
  Current stage of the space. Example: RUNNING.
- **hardware** (`str` or `None`) --
  Current hardware of the space. Example: "cpu-basic". Can be `None` if Space
  is `BUILDING` for the first time.
- **requested_hardware** (`str` or `None`) --
  Requested hardware. Can be different from `hardware` especially if the request
  has just been made. Example: "t4-medium". Can be `None` if no hardware has
  been requested yet.
- **sleep_time** (`int` or `None`) --
  Number of seconds the Space will be kept alive after the last request. By default (if value is `None`), the
  Space will never go to sleep if it's running on an upgraded hardware, while it will go to sleep after 48
  hours on a free 'cpu-basic' hardware. For more details, see https://huggingface.co/docs/hub/spaces-gpus#sleep-time.
- **raw** (`dict`) --
  Raw response from the server. Contains more information about the Space
  runtime like number of replicas, number of cpu, memory size,...</paramsdesc><paramgroups>0</paramgroups></docstring>

Contains information about the current runtime of a Space.




</div>

### SpaceHardware[[huggingface_hub.SpaceHardware]][[huggingface_hub.SpaceHardware]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SpaceHardware</name><anchor>huggingface_hub.SpaceHardware</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_space_api.py#L48</source><parameters>[{"name": "value", "val": ""}, {"name": "names", "val": " = None"}, {"name": "module", "val": " = None"}, {"name": "qualname", "val": " = None"}, {"name": "type", "val": " = None"}, {"name": "start", "val": " = 1"}]</parameters></docstring>

Enumeration of hardwares available to run your Space on the Hub.

<ExampleCodeBlock anchor="huggingface_hub.SpaceHardware.example">

Value can be compared to a string:
```py
assert SpaceHardware.CPU_BASIC == "cpu-basic"
```

</ExampleCodeBlock>

Taken from https://github.com/huggingface-internal/moon-landing/blob/main/server/repo_types/SpaceHardwareFlavor.ts (private url).


</div>

### SpaceStage[[huggingface_hub.SpaceStage]][[huggingface_hub.SpaceStage]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SpaceStage</name><anchor>huggingface_hub.SpaceStage</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_space_api.py#L23</source><parameters>[{"name": "value", "val": ""}, {"name": "names", "val": " = None"}, {"name": "module", "val": " = None"}, {"name": "qualname", "val": " = None"}, {"name": "type", "val": " = None"}, {"name": "start", "val": " = 1"}]</parameters></docstring>

Enumeration of possible stage of a Space on the Hub.

<ExampleCodeBlock anchor="huggingface_hub.SpaceStage.example">

Value can be compared to a string:
```py
assert SpaceStage.BUILDING == "BUILDING"
```

</ExampleCodeBlock>

Taken from https://github.com/huggingface/moon-landing/blob/main/server/repo_types/SpaceInfo.ts#L61 (private url).


</div>

### SpaceStorage[[huggingface_hub.SpaceStorage]][[huggingface_hub.SpaceStorage]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SpaceStorage</name><anchor>huggingface_hub.SpaceStorage</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_space_api.py#L85</source><parameters>[{"name": "value", "val": ""}, {"name": "names", "val": " = None"}, {"name": "module", "val": " = None"}, {"name": "qualname", "val": " = None"}, {"name": "type", "val": " = None"}, {"name": "start", "val": " = 1"}]</parameters></docstring>

Enumeration of persistent storage available for your Space on the Hub.

<ExampleCodeBlock anchor="huggingface_hub.SpaceStorage.example">

Value can be compared to a string:
```py
assert SpaceStorage.SMALL == "small"
```

</ExampleCodeBlock>

Taken from https://github.com/huggingface/moon-landing/blob/main/server/repo_types/SpaceHardwareFlavor.ts#L24 (private url).


</div>

### SpaceVariable[[huggingface_hub.SpaceVariable]][[huggingface_hub.SpaceVariable]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SpaceVariable</name><anchor>huggingface_hub.SpaceVariable</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_space_api.py#L143</source><parameters>[{"name": "key", "val": ": str"}, {"name": "values", "val": ": dict"}]</parameters><paramsdesc>- **key** (`str`) --
  Variable key. Example: `"MODEL_REPO_ID"`
- **value** (`str`) --
  Variable value. Example: `"the_model_repo_id"`.
- **description** (`str` or None) --
  Description of the variable. Example: `"Model Repo ID of the implemented model"`.
- **updatedAt** (`datetime` or None) --
  datetime of the last update of the variable (if the variable has been updated at least once).</paramsdesc><paramgroups>0</paramgroups></docstring>

Contains information about the current variables of a Space.




</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/space_runtime.md" />