import{s as Ct,n as Xt,o as zt}from"../chunks/scheduler.defa9a21.js";import{S as xt,i as Rt,g as s,s as a,r as d,A as Wt,h as o,f as l,c as i,j as Zt,u as m,x as p,k as kt,y as qt,a as n,v as r,d as u,t as f,w as c}from"../chunks/index.fe795e71.js";import{C as b}from"../chunks/CodeBlock.204b6c34.js";import{H as g,E as Bt}from"../chunks/index.d995652d.js";function Ht(nt){let h,me,pe,re,w,ue,M,fe,y,at="Accelerate brings <code>bitsandbytes</code> quantization to your model. You can now load any pytorch model in 8-bit or 4-bit with a few lines of code.",ce,$,it='If you want to use Transformers models with <code>bitsandbytes</code>, you should follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a>.',be,T,st='To learn more about how the <code>bitsandbytes</code> quantization works, check out the blog posts on <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">8-bit quantization</a> and <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">4-bit quantization</a>.',he,_,ge,J,ot="You will need to install the following requirements:",we,v,pt="<li>Install <code>bitsandbytes</code> library</li>",Me,j,ye,G,dt='For non-cuda devices, you can refer to the bitsandbytes installation guide <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">here</a>.',$e,U,mt="<li>Install latest <code>accelerate</code> from source</li>",Te,Z,_e,k,rt="<li>Install <code>minGPT</code> and <code>huggingface_hub</code> to run examples</li>",Je,C,ve,X,je,z,ut='First, we need to initialize our model. To save memory, we can initialize an empty model using the context manager <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a>.',Ge,x,ft="Let’s take the GPT2 model from minGPT library.",Ue,R,Ze,W,ct="Then, we need to get the path to the weights of your model. The path can be the state_dict file (e.g. “pytorch_model.bin”) or a folder containing the sharded checkpoints.",ke,q,Ce,B,bt='Finally, you need to set your quantization configuration with <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig">BnbQuantizationConfig</a>.',Xe,H,ht="Here’s an example for 8-bit quantization:",ze,Y,xe,F,gt="Here’s an example for 4-bit quantization:",Re,I,We,P,wt='To quantize your empty model with the selected configuration, you need to use <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.load_and_quantize_model">load_and_quantize_model()</a>.',qe,L,Be,V,He,Q,Mt='You can save your 8-bit model with accelerate using <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a>.',Ye,N,Fe,A,yt="Note that 4-bit model serialization is currently not supported.",Ie,E,Pe,S,$t=`You can offload some modules to cpu/disk if you don’t have enough space on the GPU to store the entire model on your GPUs.
This uses big model inference under the hood. Check this <a href="https://huggingface.co/docs/accelerate/usage_guides/big_modeling" rel="nofollow">documentation</a> for more details.`,Le,D,Tt="For 8-bit quantization, the selected modules will be converted to 8-bit precision.",Ve,K,_t="For 4-bit quantization, the selected modules will be kept in <code>torch_dtype</code> that the user passed in <code>BnbQuantizationConfig</code>.  We will add support to convert these offloaded modules in 4-bit when 4-bit serialization will be possible.",Qe,O,Jt="You just need to pass a custom <code>device_map</code> in order to offload modules on cpu/disk. The offload modules will be dispatched on the GPU when needed. Here’s an example :",Ne,ee,Ae,te,Ee,le,vt='It is not possible to perform pure 8bit or 4bit training on these models. However, you can train these models by leveraging parameter efficient fine tuning methods (PEFT) and train for example adapters on top of them. Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow">peft</a> library for more details.',Se,ne,jt='Currently, you can’t add adapters on top of any quantized model. However, with the official support of adapters with Transformers models, you can fine-tune quantized models. If you want to finetune a Transformers model , follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a> instead. Check out this <a href="https://colab.research.google.com/drive/1VoYNfYDKcKRQRor98Zbf2-9VQTtGJ24k?usp=sharing" rel="nofollow">demo</a> on how to fine-tune a 4-bit Transformers model.',De,ae,Gt="Note that you don’t need to pass <code>device_map</code> when loading the model for training. It will automatically load your model on your GPU. Please note that <code>device_map=auto</code> should be used for inference only.",Ke,ie,Oe,se,Ut='Check out the Google Colab <a href="https://colab.research.google.com/drive/1T1pOgewAWVpR9gKpaEWw4orOrzPFb3yM?usp=sharing" rel="nofollow">demo</a> for running quantized models on a GPT2 model. The GPT2-1.5B model checkpoint is in FP32 which uses 6GB of memory. After quantization, it uses 1.6GB with 8-bit modules and 1.2GB with 4-bit modules.',et,oe,tt,de,lt;return w=new g({props:{title:"Model quantization",local:"model-quantization",headingTag:"h1"}}),M=new g({props:{title:"bitsandbytes Integration",local:"bitsandbytes-integration",headingTag:"h2"}}),_=new g({props:{title:"Pre-Requisites",local:"pre-requisites",headingTag:"h3"}}),j=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),Z=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGYWNjZWxlcmF0ZS5naXQ=",highlighted:"pip install git+https://github.com/huggingface/accelerate.git",wrap:!1}}),C=new b({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZrYXJwYXRoeSUyRm1pbkdQVC5naXQlMEFwaXAlMjBpbnN0YWxsJTIwbWluR1BUJTJGJTBBcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/karpathy/minGPT.git
pip install minGPT/
pip install huggingface_hub`,wrap:!1}}),X=new g({props:{title:"How it works",local:"how-it-works",headingTag:"h3"}}),R=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwbWluZ3B0Lm1vZGVsJTIwaW1wb3J0JTIwR1BUJTBBJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwR1BULmdldF9kZWZhdWx0X2NvbmZpZygpJTBBbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlMjAlM0QlMjAnZ3B0Mi14bCclMEFtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUyMCUzRCUyMDUwMjU3JTBBbW9kZWxfY29uZmlnLmJsb2NrX3NpemUlMjAlM0QlMjAxMDI0JTBBJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwZW1wdHlfbW9kZWwlMjAlM0QlMjBHUFQobW9kZWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)`,wrap:!1}}),q=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBd2VpZ2h0c19sb2NhdGlvbiUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJtYXJjc3VuMTMlMkZncHQyLXhsLWxpbmVhci1zaGFyZGVkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
weights_location = snapshot_download(repo_id=<span class="hljs-string">&quot;marcsun13/gpt2-xl-linear-sharded&quot;</span>)`,wrap:!1}}),Y=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwbGxtX2ludDhfdGhyZXNob2xkJTIwJTNEJTIwNik=",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold = <span class="hljs-number">6</span>)`,wrap:!1}}),I=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>)`,wrap:!1}}),L=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2FuZF9xdWFudGl6ZV9tb2RlbCUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> load_and_quantize_model
quantized_model = load_and_quantize_model(empty_model, weights_location=weights_location, bnb_quantization_config=bnb_quantization_config)`,wrap:!1}}),V=new g({props:{title:"Saving and loading 8-bit model",local:"saving-and-loading-8-bit-model",headingTag:"h3"}}),N=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdGUlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBbmV3X3dlaWdodHNfbG9jYXRpb24lMjAlM0QlMjAlMjJwYXRoJTJGdG8lMkZzYXZlX2RpcmVjdG9yeSUyMiUwQWFjY2VsZXJhdGUuc2F2ZV9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBuZXdfd2VpZ2h0c19sb2NhdGlvbiklMEElMEFxdWFudGl6ZWRfbW9kZWxfZnJvbV9zYXZlZCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRG5ld193ZWlnaHRzX2xvY2F0aW9uJTJDJTIwYm5iX3F1YW50aXphdGlvbl9jb25maWclM0RibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlMjAlM0QlMjAlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerate = Accelerator()
new_weights_location = <span class="hljs-string">&quot;path/to/save_directory&quot;</span>
accelerate.save_model(quantized_model, new_weights_location)

quantized_model_from_saved = load_and_quantize_model(empty_model, weights_location=new_weights_location, bnb_quantization_config=bnb_quantization_config, device_map = <span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),E=new g({props:{title:"Offload modules to cpu and disk",local:"offload-modules-to-cpu-and-disk",headingTag:"h3"}}),ee=new b({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLnd0ZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53cGUlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIuZHJvcCUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIubG5fZiUyMiUzQSUyMCUyMmRpc2slMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJsbV9oZWFkJTIyJTNBJTIwJTIyZGlzayUyMiUyQyUwQSU3RA==",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.wte&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.wpe&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.drop&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
}`,wrap:!1}}),te=new g({props:{title:"Fine-tune a quantized model",local:"fine-tune-a-quantized-model",headingTag:"h3"}}),ie=new g({props:{title:"Example demo - running GPT2 1.5b on a Google Colab",local:"example-demo---running-gpt2-15b-on-a-google-colab",headingTag:"h3"}}),oe=new Bt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/quantization.md"}}),{c(){h=s("meta"),me=a(),pe=s("p"),re=a(),d(w.$$.fragment),ue=a(),d(M.$$.fragment),fe=a(),y=s("p"),y.innerHTML=at,ce=a(),$=s("p"),$.innerHTML=it,be=a(),T=s("p"),T.innerHTML=st,he=a(),d(_.$$.fragment),ge=a(),J=s("p"),J.textContent=ot,we=a(),v=s("ul"),v.innerHTML=pt,Me=a(),d(j.$$.fragment),ye=a(),G=s("p"),G.innerHTML=dt,$e=a(),U=s("ul"),U.innerHTML=mt,Te=a(),d(Z.$$.fragment),_e=a(),k=s("ul"),k.innerHTML=rt,Je=a(),d(C.$$.fragment),ve=a(),d(X.$$.fragment),je=a(),z=s("p"),z.innerHTML=ut,Ge=a(),x=s("p"),x.textContent=ft,Ue=a(),d(R.$$.fragment),Ze=a(),W=s("p"),W.textContent=ct,ke=a(),d(q.$$.fragment),Ce=a(),B=s("p"),B.innerHTML=bt,Xe=a(),H=s("p"),H.textContent=ht,ze=a(),d(Y.$$.fragment),xe=a(),F=s("p"),F.textContent=gt,Re=a(),d(I.$$.fragment),We=a(),P=s("p"),P.innerHTML=wt,qe=a(),d(L.$$.fragment),Be=a(),d(V.$$.fragment),He=a(),Q=s("p"),Q.innerHTML=Mt,Ye=a(),d(N.$$.fragment),Fe=a(),A=s("p"),A.textContent=yt,Ie=a(),d(E.$$.fragment),Pe=a(),S=s("p"),S.innerHTML=$t,Le=a(),D=s("p"),D.textContent=Tt,Ve=a(),K=s("p"),K.innerHTML=_t,Qe=a(),O=s("p"),O.innerHTML=Jt,Ne=a(),d(ee.$$.fragment),Ae=a(),d(te.$$.fragment),Ee=a(),le=s("p"),le.innerHTML=vt,Se=a(),ne=s("p"),ne.innerHTML=jt,De=a(),ae=s("p"),ae.innerHTML=Gt,Ke=a(),d(ie.$$.fragment),Oe=a(),se=s("p"),se.innerHTML=Ut,et=a(),d(oe.$$.fragment),tt=a(),de=s("p"),this.h()},l(e){const t=Wt("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),me=i(e),pe=o(e,"P",{}),Zt(pe).forEach(l),re=i(e),m(w.$$.fragment,e),ue=i(e),m(M.$$.fragment,e),fe=i(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1uk3wou"&&(y.innerHTML=at),ce=i(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1p54xze"&&($.innerHTML=it),be=i(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-hrid2v"&&(T.innerHTML=st),he=i(e),m(_.$$.fragment,e),ge=i(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-50fa4n"&&(J.textContent=ot),we=i(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-t2geh8"&&(v.innerHTML=pt),Me=i(e),m(j.$$.fragment,e),ye=i(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-s1psu3"&&(G.innerHTML=dt),$e=i(e),U=o(e,"UL",{"data-svelte-h":!0}),p(U)!=="svelte-l0cm28"&&(U.innerHTML=mt),Te=i(e),m(Z.$$.fragment,e),_e=i(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-1c2t6dx"&&(k.innerHTML=rt),Je=i(e),m(C.$$.fragment,e),ve=i(e),m(X.$$.fragment,e),je=i(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1x1205t"&&(z.innerHTML=ut),Ge=i(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1fwkss5"&&(x.textContent=ft),Ue=i(e),m(R.$$.fragment,e),Ze=i(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-bbyjp5"&&(W.textContent=ct),ke=i(e),m(q.$$.fragment,e),Ce=i(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-194hcd9"&&(B.innerHTML=bt),Xe=i(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-4hyyr7"&&(H.textContent=ht),ze=i(e),m(Y.$$.fragment,e),xe=i(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1qtcdkv"&&(F.textContent=gt),Re=i(e),m(I.$$.fragment,e),We=i(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1yj9o2t"&&(P.innerHTML=wt),qe=i(e),m(L.$$.fragment,e),Be=i(e),m(V.$$.fragment,e),He=i(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-13ka0pr"&&(Q.innerHTML=Mt),Ye=i(e),m(N.$$.fragment,e),Fe=i(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1x0s82b"&&(A.textContent=yt),Ie=i(e),m(E.$$.fragment,e),Pe=i(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1vy35js"&&(S.innerHTML=$t),Le=i(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-11qxtld"&&(D.textContent=Tt),Ve=i(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-qaw7ck"&&(K.innerHTML=_t),Qe=i(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-gyjts5"&&(O.innerHTML=Jt),Ne=i(e),m(ee.$$.fragment,e),Ae=i(e),m(te.$$.fragment,e),Ee=i(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-rtwtrf"&&(le.innerHTML=vt),Se=i(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-phiimi"&&(ne.innerHTML=jt),De=i(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1n8dj9v"&&(ae.innerHTML=Gt),Ke=i(e),m(ie.$$.fragment,e),Oe=i(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-19uggsw"&&(se.innerHTML=Ut),et=i(e),m(oe.$$.fragment,e),tt=i(e),de=o(e,"P",{}),Zt(de).forEach(l),this.h()},h(){kt(h,"name","hf:doc:metadata"),kt(h,"content",Yt)},m(e,t){qt(document.head,h),n(e,me,t),n(e,pe,t),n(e,re,t),r(w,e,t),n(e,ue,t),r(M,e,t),n(e,fe,t),n(e,y,t),n(e,ce,t),n(e,$,t),n(e,be,t),n(e,T,t),n(e,he,t),r(_,e,t),n(e,ge,t),n(e,J,t),n(e,we,t),n(e,v,t),n(e,Me,t),r(j,e,t),n(e,ye,t),n(e,G,t),n(e,$e,t),n(e,U,t),n(e,Te,t),r(Z,e,t),n(e,_e,t),n(e,k,t),n(e,Je,t),r(C,e,t),n(e,ve,t),r(X,e,t),n(e,je,t),n(e,z,t),n(e,Ge,t),n(e,x,t),n(e,Ue,t),r(R,e,t),n(e,Ze,t),n(e,W,t),n(e,ke,t),r(q,e,t),n(e,Ce,t),n(e,B,t),n(e,Xe,t),n(e,H,t),n(e,ze,t),r(Y,e,t),n(e,xe,t),n(e,F,t),n(e,Re,t),r(I,e,t),n(e,We,t),n(e,P,t),n(e,qe,t),r(L,e,t),n(e,Be,t),r(V,e,t),n(e,He,t),n(e,Q,t),n(e,Ye,t),r(N,e,t),n(e,Fe,t),n(e,A,t),n(e,Ie,t),r(E,e,t),n(e,Pe,t),n(e,S,t),n(e,Le,t),n(e,D,t),n(e,Ve,t),n(e,K,t),n(e,Qe,t),n(e,O,t),n(e,Ne,t),r(ee,e,t),n(e,Ae,t),r(te,e,t),n(e,Ee,t),n(e,le,t),n(e,Se,t),n(e,ne,t),n(e,De,t),n(e,ae,t),n(e,Ke,t),r(ie,e,t),n(e,Oe,t),n(e,se,t),n(e,et,t),r(oe,e,t),n(e,tt,t),n(e,de,t),lt=!0},p:Xt,i(e){lt||(u(w.$$.fragment,e),u(M.$$.fragment,e),u(_.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(C.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(q.$$.fragment,e),u(Y.$$.fragment,e),u(I.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),lt=!0)},o(e){f(w.$$.fragment,e),f(M.$$.fragment,e),f(_.$$.fragment,e),f(j.$$.fragment,e),f(Z.$$.fragment,e),f(C.$$.fragment,e),f(X.$$.fragment,e),f(R.$$.fragment,e),f(q.$$.fragment,e),f(Y.$$.fragment,e),f(I.$$.fragment,e),f(L.$$.fragment,e),f(V.$$.fragment,e),f(N.$$.fragment,e),f(E.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),lt=!1},d(e){e&&(l(me),l(pe),l(re),l(ue),l(fe),l(y),l(ce),l($),l(be),l(T),l(he),l(ge),l(J),l(we),l(v),l(Me),l(ye),l(G),l($e),l(U),l(Te),l(_e),l(k),l(Je),l(ve),l(je),l(z),l(Ge),l(x),l(Ue),l(Ze),l(W),l(ke),l(Ce),l(B),l(Xe),l(H),l(ze),l(xe),l(F),l(Re),l(We),l(P),l(qe),l(Be),l(He),l(Q),l(Ye),l(Fe),l(A),l(Ie),l(Pe),l(S),l(Le),l(D),l(Ve),l(K),l(Qe),l(O),l(Ne),l(Ae),l(Ee),l(le),l(Se),l(ne),l(De),l(ae),l(Ke),l(Oe),l(se),l(et),l(tt),l(de)),l(h),c(w,e),c(M,e),c(_,e),c(j,e),c(Z,e),c(C,e),c(X,e),c(R,e),c(q,e),c(Y,e),c(I,e),c(L,e),c(V,e),c(N,e),c(E,e),c(ee,e),c(te,e),c(ie,e),c(oe,e)}}}const Yt='{"title":"Model quantization","local":"model-quantization","sections":[{"title":"bitsandbytes Integration","local":"bitsandbytes-integration","sections":[{"title":"Pre-Requisites","local":"pre-requisites","sections":[],"depth":3},{"title":"How it works","local":"how-it-works","sections":[],"depth":3},{"title":"Saving and loading 8-bit model","local":"saving-and-loading-8-bit-model","sections":[],"depth":3},{"title":"Offload modules to cpu and disk","local":"offload-modules-to-cpu-and-disk","sections":[],"depth":3},{"title":"Fine-tune a quantized model","local":"fine-tune-a-quantized-model","sections":[],"depth":3},{"title":"Example demo - running GPT2 1.5b on a Google Colab","local":"example-demo---running-gpt2-15b-on-a-google-colab","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ft(nt){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends xt{constructor(h){super(),Rt(this,h,Ft,Ht,Ct,{})}}export{Qt as component};
