import{s as aa,n as ua,o as ma}from"../chunks/scheduler.b108d059.js";import{S as pa,i as ca,g as o,s as n,r as u,A as fa,h as r,f as s,c as i,j as h,u as m,x as d,k as a,y as Ta,a as l,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as $r}from"../chunks/CodeBlock.3968c746.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function ha(yr){let $,Rs,js,Ps,y,ks,M,Es,b,Mr="Helper module for <code>Tensor</code> processing.",Is,v,br=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Ds,C,vr='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.transpose"><code>.transpose(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..ONNXTensor"><code>~ONNXTensor</code></a> : <code>Object</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',qs,Ns,Vs,x,Bs,H,Qs,L,Cr='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Ss,w,xr='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Ks,Os,Ws,A,Ys,U,Fs,g,Hr="Create a new Tensor or copy an existing Tensor.",Xs,J,Lr="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Gs,Zs,el,j,tl,z,sl,R,wr=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,ll,P,Ar='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',nl,il,ol,k,rl,E,dl,I,Ur="Index into a Tensor object.",al,D,gr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',ul,q,Jr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",ml,pl,cl,N,fl,V,Tl,B,jr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',hl,Q,zr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",_l,$l,yl,S,Ml,K,bl,O,Rr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',vl,W,Pr="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",Cl,xl,Hl,Y,Ll,F,wl,X,kr=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Al,G,Er='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Ul,Z,Ir="<li><code>Error</code> If the tensor has more than one element.</li>",gl,Jl,jl,ee,zl,te,Rl,se,Dr="Convert tensor data to a n-dimensional JS list",Pl,le,qr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',kl,El,Il,ne,Dl,ie,ql,oe,Nr="Return a new Tensor with the sigmoid function applied to each element.",Nl,re,Vr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Vl,Bl,Ql,de,Sl,ae,Kl,ue,Br="Applies the sigmoid function to the tensor in place.",Ol,me,Qr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Wl,Yl,Fl,pe,Xl,ce,Gl,fe,Sr="Return a transposed version of this Tensor, according to the provided dimensions.",Zl,Te,Kr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',en,he,Or="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to transpose.</p></td></tr></tbody>",tn,sn,ln,_e,nn,$e,on,ye,Wr="Returns the sum of each row of the input tensor in the given dimension dim.",rn,Me,Yr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',dn,be,Fr="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",an,un,mn,ve,pn,Ce,cn,xe,Xr="Returns the matrix norm or vector norm of a given tensor.",fn,He,Gr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Tn,Le,Zr=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,hn,_n,$n,we,yn,Ae,Mn,Ue,ed="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",bn,ge,td='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',vn,Je,sd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Cn,xn,Hn,je,Ln,ze,wn,Re,ld="Performs <code>L_p</code> normalization of inputs over specified dimension.",An,Pe,nd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Un,ke,id="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",gn,Jn,jn,Ee,zn,Ie,Rn,De,od=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,Pn,qe,rd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',kn,En,In,Ne,Dn,Ve,qn,Be,dd="Returns a tensor with all specified dimensions of input of size 1 removed.",Nn,Qe,ad=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Vn,Se,ud='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',Bn,Ke,md="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",Qn,Sn,Kn,Oe,On,We,Wn,Ye,pd='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',Yn,Fe,cd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Fn,Xn,Gn,Xe,Zn,Ge,ei,Ze,fd="Returns a new tensor with a dimension of size one inserted at the specified position.",ti,et,Td="NOTE: The returned tensor shares the same underlying data with this tensor.",si,tt,hd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',li,st,_d="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",ni,ii,oi,lt,ri,nt,di,it,$d='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',ai,ot,yd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ui,mi,pi,rt,ci,dt,fi,at,Md='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Ti,ut,bd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',hi,_i,$i,mt,yi,pt,Mi,ct,vd=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,bi,ft,Cd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',vi,Tt,xd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Ci,xi,Hi,ht,Li,_t,wi,$t,Hd="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Ai,yt,Ld='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',Ui,Mt,wd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",gi,Ji,ji,bt,zi,vt,Ri,Ct,Ad="Transposes a tensor according to the provided axes.",Pi,xt,Ud='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',ki,Ht,gd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to transpose.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to transpose the tensor along.</p></td></tr></tbody>",Ei,Ii,Di,Lt,qi,wt,Ni,At,Jd="Interpolates an Tensor to the given size.",Vi,Ut,jd='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Bi,gt,zd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Qi,Si,Ki,Jt,Oi,jt,Wi,zt,Rd="Perform mean pooling of the last hidden state followed by a normalization step.",Yi,Rt,Pd='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',Fi,Pt,kd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Xi,Gi,Zi,kt,eo,Et,to,It,Ed="Concatenates an array of tensors along a specified dimension.",so,Dt,Id='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',lo,qt,Dd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",no,io,oo,Nt,ro,Vt,ao,Bt,qd="Stack an array of tensors along a specified dimension.",uo,Qt,Nd='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',mo,St,Vd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",po,co,fo,Kt,To,Ot,ho,Wt,Bd="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",_o,Yt,Qd='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',$o,Ft,Sd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",yo,Mo,bo,Xt,vo,Gt,Co,Zt,Kd="Returns the mean value of each row of the input tensor in the given dimension dim.",xo,es,Od='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',Ho,ts,Wd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Lo,wo,Ao,ss,Uo,ls,go,ns,Yd=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Jo,is,Fd='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',jo,os,Xd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",zo,Ro,Po,rs,ko,ds,Eo,as,Gd='<strong>Kind</strong>: inner constant of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Io,Do,qo,us,No,ms,Vo,ps,Zd="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Bo,cs,ea='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',Qo,fs,ta="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array.&lt;T&gt;</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",So,Ts,sa="<strong>Example</strong>",Ko,hs,Oo,Wo,Yo,_s,Fo,$s,Xo,ys,la='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',Go,Zo,er,Ms,tr,bs,sr,vs,na='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',lr,nr,ir,Cs,or,xs,rr,Hs,ia="This creates a nested array of a given type and depth (see examples).",dr,Ls,oa='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',ar,ws,ur,As,ra="<strong>Example</strong>",mr,Us,pr,gs,da="<strong>Example</strong>",cr,Js,fr,Tr,hr,zs,_r;return M=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),U=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),E=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),K=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),F=new _({props:{title:"tensor.item() ⇒ <code> number </code>",local:"tensoritem--code-number-code",headingTag:"h3"}}),te=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),ie=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ae=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ce=new _({props:{title:"tensor.transpose(...dims) ⇒ <code> Tensor </code>",local:"tensortransposedims--code-tensor-code",headingTag:"h3"}}),$e=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),Ce=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),Ae=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),ze=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Ie=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Ve=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),We=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Ge=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),nt=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),dt=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),pt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),_t=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),vt=new _({props:{title:"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensortransposetensor-axes--code-tensor-code",headingTag:"h2"}}),wt=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),jt=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Et=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Vt=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Ot=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Gt=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),ls=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),ds=new _({props:{title:"utils/tensor~ONNXTensor : <code> Object </code>",local:"utilstensoronnxtensor--code-object-code",headingTag:"h2"}}),ms=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),hs=new $r({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),$s=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),bs=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),xs=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),ws=new $r({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Us=new $r({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Js=new $r({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),{c(){$=o("meta"),Rs=n(),js=o("p"),Ps=n(),y=o("a"),ks=n(),u(M.$$.fragment),Es=n(),b=o("p"),b.innerHTML=Mr,Is=n(),v=o("p"),v.textContent=br,Ds=n(),C=o("ul"),C.innerHTML=vr,qs=n(),Ns=o("hr"),Vs=n(),x=o("a"),Bs=n(),u(H.$$.fragment),Qs=n(),L=o("p"),L.innerHTML=Cr,Ss=n(),w=o("ul"),w.innerHTML=xr,Ks=n(),Os=o("hr"),Ws=n(),A=o("a"),Ys=n(),u(U.$$.fragment),Fs=n(),g=o("p"),g.textContent=Hr,Xs=n(),J=o("table"),J.innerHTML=Lr,Gs=n(),Zs=o("hr"),el=n(),j=o("a"),tl=n(),u(z.$$.fragment),sl=n(),R=o("p"),R.textContent=wr,ll=n(),P=o("p"),P.innerHTML=Ar,nl=n(),il=o("hr"),ol=n(),k=o("a"),rl=n(),u(E.$$.fragment),dl=n(),I=o("p"),I.textContent=Ur,al=n(),D=o("p"),D.innerHTML=gr,ul=n(),q=o("table"),q.innerHTML=Jr,ml=n(),pl=o("hr"),cl=n(),N=o("a"),fl=n(),u(V.$$.fragment),Tl=n(),B=o("p"),B.innerHTML=jr,hl=n(),Q=o("table"),Q.innerHTML=zr,_l=n(),$l=o("hr"),yl=n(),S=o("a"),Ml=n(),u(K.$$.fragment),bl=n(),O=o("p"),O.innerHTML=Rr,vl=n(),W=o("table"),W.innerHTML=Pr,Cl=n(),xl=o("hr"),Hl=n(),Y=o("a"),Ll=n(),u(F.$$.fragment),wl=n(),X=o("p"),X.innerHTML=kr,Al=n(),G=o("p"),G.innerHTML=Er,Ul=n(),Z=o("ul"),Z.innerHTML=Ir,gl=n(),Jl=o("hr"),jl=n(),ee=o("a"),zl=n(),u(te.$$.fragment),Rl=n(),se=o("p"),se.textContent=Dr,Pl=n(),le=o("p"),le.innerHTML=qr,kl=n(),El=o("hr"),Il=n(),ne=o("a"),Dl=n(),u(ie.$$.fragment),ql=n(),oe=o("p"),oe.textContent=Nr,Nl=n(),re=o("p"),re.innerHTML=Vr,Vl=n(),Bl=o("hr"),Ql=n(),de=o("a"),Sl=n(),u(ae.$$.fragment),Kl=n(),ue=o("p"),ue.textContent=Br,Ol=n(),me=o("p"),me.innerHTML=Qr,Wl=n(),Yl=o("hr"),Fl=n(),pe=o("a"),Xl=n(),u(ce.$$.fragment),Gl=n(),fe=o("p"),fe.textContent=Sr,Zl=n(),Te=o("p"),Te.innerHTML=Kr,en=n(),he=o("table"),he.innerHTML=Or,tn=n(),sn=o("hr"),ln=n(),_e=o("a"),nn=n(),u($e.$$.fragment),on=n(),ye=o("p"),ye.textContent=Wr,rn=n(),Me=o("p"),Me.innerHTML=Yr,dn=n(),be=o("table"),be.innerHTML=Fr,an=n(),un=o("hr"),mn=n(),ve=o("a"),pn=n(),u(Ce.$$.fragment),cn=n(),xe=o("p"),xe.textContent=Xr,fn=n(),He=o("p"),He.innerHTML=Gr,Tn=n(),Le=o("table"),Le.innerHTML=Zr,hn=n(),_n=o("hr"),$n=n(),we=o("a"),yn=n(),u(Ae.$$.fragment),Mn=n(),Ue=o("p"),Ue.innerHTML=ed,bn=n(),ge=o("p"),ge.innerHTML=td,vn=n(),Je=o("table"),Je.innerHTML=sd,Cn=n(),xn=o("hr"),Hn=n(),je=o("a"),Ln=n(),u(ze.$$.fragment),wn=n(),Re=o("p"),Re.innerHTML=ld,An=n(),Pe=o("p"),Pe.innerHTML=nd,Un=n(),ke=o("table"),ke.innerHTML=id,gn=n(),Jn=o("hr"),jn=n(),Ee=o("a"),zn=n(),u(Ie.$$.fragment),Rn=n(),De=o("p"),De.textContent=od,Pn=n(),qe=o("p"),qe.innerHTML=rd,kn=n(),En=o("hr"),In=n(),Ne=o("a"),Dn=n(),u(Ve.$$.fragment),qn=n(),Be=o("p"),Be.textContent=dd,Nn=n(),Qe=o("p"),Qe.innerHTML=ad,Vn=n(),Se=o("p"),Se.innerHTML=ud,Bn=n(),Ke=o("table"),Ke.innerHTML=md,Qn=n(),Sn=o("hr"),Kn=n(),Oe=o("a"),On=n(),u(We.$$.fragment),Wn=n(),Ye=o("p"),Ye.innerHTML=pd,Yn=n(),Fe=o("p"),Fe.innerHTML=cd,Fn=n(),Xn=o("hr"),Gn=n(),Xe=o("a"),Zn=n(),u(Ge.$$.fragment),ei=n(),Ze=o("p"),Ze.textContent=fd,ti=n(),et=o("p"),et.textContent=Td,si=n(),tt=o("p"),tt.innerHTML=hd,li=n(),st=o("table"),st.innerHTML=_d,ni=n(),ii=o("hr"),oi=n(),lt=o("a"),ri=n(),u(nt.$$.fragment),di=n(),it=o("p"),it.innerHTML=$d,ai=n(),ot=o("p"),ot.innerHTML=yd,ui=n(),mi=o("hr"),pi=n(),rt=o("a"),ci=n(),u(dt.$$.fragment),fi=n(),at=o("p"),at.innerHTML=Md,Ti=n(),ut=o("p"),ut.innerHTML=bd,hi=n(),_i=o("hr"),$i=n(),mt=o("a"),yi=n(),u(pt.$$.fragment),Mi=n(),ct=o("p"),ct.innerHTML=vd,bi=n(),ft=o("p"),ft.innerHTML=Cd,vi=n(),Tt=o("table"),Tt.innerHTML=xd,Ci=n(),xi=o("hr"),Hi=n(),ht=o("a"),Li=n(),u(_t.$$.fragment),wi=n(),$t=o("p"),$t.innerHTML=Hd,Ai=n(),yt=o("p"),yt.innerHTML=Ld,Ui=n(),Mt=o("table"),Mt.innerHTML=wd,gi=n(),Ji=o("hr"),ji=n(),bt=o("a"),zi=n(),u(vt.$$.fragment),Ri=n(),Ct=o("p"),Ct.textContent=Ad,Pi=n(),xt=o("p"),xt.innerHTML=Ud,ki=n(),Ht=o("table"),Ht.innerHTML=gd,Ei=n(),Ii=o("hr"),Di=n(),Lt=o("a"),qi=n(),u(wt.$$.fragment),Ni=n(),At=o("p"),At.textContent=Jd,Vi=n(),Ut=o("p"),Ut.innerHTML=jd,Bi=n(),gt=o("table"),gt.innerHTML=zd,Qi=n(),Si=o("hr"),Ki=n(),Jt=o("a"),Oi=n(),u(jt.$$.fragment),Wi=n(),zt=o("p"),zt.textContent=Rd,Yi=n(),Rt=o("p"),Rt.innerHTML=Pd,Fi=n(),Pt=o("table"),Pt.innerHTML=kd,Xi=n(),Gi=o("hr"),Zi=n(),kt=o("a"),eo=n(),u(Et.$$.fragment),to=n(),It=o("p"),It.textContent=Ed,so=n(),Dt=o("p"),Dt.innerHTML=Id,lo=n(),qt=o("table"),qt.innerHTML=Dd,no=n(),io=o("hr"),oo=n(),Nt=o("a"),ro=n(),u(Vt.$$.fragment),ao=n(),Bt=o("p"),Bt.textContent=qd,uo=n(),Qt=o("p"),Qt.innerHTML=Nd,mo=n(),St=o("table"),St.innerHTML=Vd,po=n(),co=o("hr"),fo=n(),Kt=o("a"),To=n(),u(Ot.$$.fragment),ho=n(),Wt=o("p"),Wt.innerHTML=Bd,_o=n(),Yt=o("p"),Yt.innerHTML=Qd,$o=n(),Ft=o("table"),Ft.innerHTML=Sd,yo=n(),Mo=o("hr"),bo=n(),Xt=o("a"),vo=n(),u(Gt.$$.fragment),Co=n(),Zt=o("p"),Zt.textContent=Kd,xo=n(),es=o("p"),es.innerHTML=Od,Ho=n(),ts=o("table"),ts.innerHTML=Wd,Lo=n(),wo=o("hr"),Ao=n(),ss=o("a"),Uo=n(),u(ls.$$.fragment),go=n(),ns=o("p"),ns.textContent=Yd,Jo=n(),is=o("p"),is.innerHTML=Fd,jo=n(),os=o("table"),os.innerHTML=Xd,zo=n(),Ro=o("hr"),Po=n(),rs=o("a"),ko=n(),u(ds.$$.fragment),Eo=n(),as=o("p"),as.innerHTML=Gd,Io=n(),Do=o("hr"),qo=n(),us=o("a"),No=n(),u(ms.$$.fragment),Vo=n(),ps=o("p"),ps.textContent=Zd,Bo=n(),cs=o("p"),cs.innerHTML=ea,Qo=n(),fs=o("table"),fs.innerHTML=ta,So=n(),Ts=o("p"),Ts.innerHTML=sa,Ko=n(),u(hs.$$.fragment),Oo=n(),Wo=o("hr"),Yo=n(),_s=o("a"),Fo=n(),u($s.$$.fragment),Xo=n(),ys=o("p"),ys.innerHTML=la,Go=n(),Zo=o("hr"),er=n(),Ms=o("a"),tr=n(),u(bs.$$.fragment),sr=n(),vs=o("p"),vs.innerHTML=na,lr=n(),nr=o("hr"),ir=n(),Cs=o("a"),or=n(),u(xs.$$.fragment),rr=n(),Hs=o("p"),Hs.textContent=ia,dr=n(),Ls=o("p"),Ls.innerHTML=oa,ar=n(),u(ws.$$.fragment),ur=n(),As=o("p"),As.innerHTML=ra,mr=n(),u(Us.$$.fragment),pr=n(),gs=o("p"),gs.innerHTML=da,cr=n(),u(Js.$$.fragment),fr=n(),Tr=o("hr"),hr=n(),zs=o("p"),this.h()},l(e){const t=fa("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(s),Rs=i(e),js=r(e,"P",{}),h(js).forEach(s),Ps=i(e),y=r(e,"A",{id:!0,class:!0}),h(y).forEach(s),ks=i(e),m(M.$$.fragment,e),Es=i(e),b=r(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-uw4y1m"&&(b.innerHTML=Mr),Is=i(e),v=r(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-il3kl8"&&(v.textContent=br),Ds=i(e),C=r(e,"UL",{"data-svelte-h":!0}),d(C)!=="svelte-1j2tvp1"&&(C.innerHTML=vr),qs=i(e),Ns=r(e,"HR",{}),Vs=i(e),x=r(e,"A",{id:!0,class:!0}),h(x).forEach(s),Bs=i(e),m(H.$$.fragment,e),Qs=i(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=Cr),Ss=i(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-1mit4ax"&&(w.innerHTML=xr),Ks=i(e),Os=r(e,"HR",{}),Ws=i(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(s),Ys=i(e),m(U.$$.fragment,e),Fs=i(e),g=r(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-55wecd"&&(g.textContent=Hr),Xs=i(e),J=r(e,"TABLE",{"data-svelte-h":!0}),d(J)!=="svelte-ee7emz"&&(J.innerHTML=Lr),Gs=i(e),Zs=r(e,"HR",{}),el=i(e),j=r(e,"A",{id:!0,class:!0}),h(j).forEach(s),tl=i(e),m(z.$$.fragment,e),sl=i(e),R=r(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1adn56z"&&(R.textContent=wr),ll=i(e),P=r(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1gxgvk6"&&(P.innerHTML=Ar),nl=i(e),il=r(e,"HR",{}),ol=i(e),k=r(e,"A",{id:!0,class:!0}),h(k).forEach(s),rl=i(e),m(E.$$.fragment,e),dl=i(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1u97xg1"&&(I.textContent=Ur),al=i(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1afa2dz"&&(D.innerHTML=gr),ul=i(e),q=r(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-1kq04ga"&&(q.innerHTML=Jr),ml=i(e),pl=r(e,"HR",{}),cl=i(e),N=r(e,"A",{id:!0,class:!0}),h(N).forEach(s),fl=i(e),m(V.$$.fragment,e),Tl=i(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1cg22af"&&(B.innerHTML=jr),hl=i(e),Q=r(e,"TABLE",{"data-svelte-h":!0}),d(Q)!=="svelte-1hful42"&&(Q.innerHTML=zr),_l=i(e),$l=r(e,"HR",{}),yl=i(e),S=r(e,"A",{id:!0,class:!0}),h(S).forEach(s),Ml=i(e),m(K.$$.fragment,e),bl=i(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1mr58c3"&&(O.innerHTML=Rr),vl=i(e),W=r(e,"TABLE",{"data-svelte-h":!0}),d(W)!=="svelte-153ftfy"&&(W.innerHTML=Pr),Cl=i(e),xl=r(e,"HR",{}),Hl=i(e),Y=r(e,"A",{id:!0,class:!0}),h(Y).forEach(s),Ll=i(e),m(F.$$.fragment,e),wl=i(e),X=r(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-13nzfs3"&&(X.innerHTML=kr),Al=i(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-18jnqwq"&&(G.innerHTML=Er),Ul=i(e),Z=r(e,"UL",{"data-svelte-h":!0}),d(Z)!=="svelte-5t2sg3"&&(Z.innerHTML=Ir),gl=i(e),Jl=r(e,"HR",{}),jl=i(e),ee=r(e,"A",{id:!0,class:!0}),h(ee).forEach(s),zl=i(e),m(te.$$.fragment,e),Rl=i(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-87xdyr"&&(se.textContent=Dr),Pl=i(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1mr58c3"&&(le.innerHTML=qr),kl=i(e),El=r(e,"HR",{}),Il=i(e),ne=r(e,"A",{id:!0,class:!0}),h(ne).forEach(s),Dl=i(e),m(ie.$$.fragment,e),ql=i(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-2wti2w"&&(oe.textContent=Nr),Nl=i(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-kpq7mo"&&(re.innerHTML=Vr),Vl=i(e),Bl=r(e,"HR",{}),Ql=i(e),de=r(e,"A",{id:!0,class:!0}),h(de).forEach(s),Sl=i(e),m(ae.$$.fragment,e),Kl=i(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1edu6c8"&&(ue.textContent=Br),Ol=i(e),me=r(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1hc4oxa"&&(me.innerHTML=Qr),Wl=i(e),Yl=r(e,"HR",{}),Fl=i(e),pe=r(e,"A",{id:!0,class:!0}),h(pe).forEach(s),Xl=i(e),m(ce.$$.fragment,e),Gl=i(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-lesh1u"&&(fe.textContent=Sr),Zl=i(e),Te=r(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-rvzl1t"&&(Te.innerHTML=Kr),en=i(e),he=r(e,"TABLE",{"data-svelte-h":!0}),d(he)!=="svelte-onq75m"&&(he.innerHTML=Or),tn=i(e),sn=r(e,"HR",{}),ln=i(e),_e=r(e,"A",{id:!0,class:!0}),h(_e).forEach(s),nn=i(e),m($e.$$.fragment,e),on=i(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-yjryb1"&&(ye.textContent=Wr),rn=i(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-xtr8tc"&&(Me.innerHTML=Yr),dn=i(e),be=r(e,"TABLE",{"data-svelte-h":!0}),d(be)!=="svelte-6xvdso"&&(be.innerHTML=Fr),an=i(e),un=r(e,"HR",{}),mn=i(e),ve=r(e,"A",{id:!0,class:!0}),h(ve).forEach(s),pn=i(e),m(Ce.$$.fragment,e),cn=i(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1okfsqx"&&(xe.textContent=Xr),fn=i(e),He=r(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1t556pk"&&(He.innerHTML=Gr),Tn=i(e),Le=r(e,"TABLE",{"data-svelte-h":!0}),d(Le)!=="svelte-13m2wni"&&(Le.innerHTML=Zr),hn=i(e),_n=r(e,"HR",{}),$n=i(e),we=r(e,"A",{id:!0,class:!0}),h(we).forEach(s),yn=i(e),m(Ae.$$.fragment,e),Mn=i(e),Ue=r(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1htpbrk"&&(Ue.innerHTML=ed),bn=i(e),ge=r(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1t0m8l6"&&(ge.innerHTML=td),vn=i(e),Je=r(e,"TABLE",{"data-svelte-h":!0}),d(Je)!=="svelte-1qi99pl"&&(Je.innerHTML=sd),Cn=i(e),xn=r(e,"HR",{}),Hn=i(e),je=r(e,"A",{id:!0,class:!0}),h(je).forEach(s),Ln=i(e),m(ze.$$.fragment,e),wn=i(e),Re=r(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1ztgqp"&&(Re.innerHTML=ld),An=i(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-mvb39p"&&(Pe.innerHTML=nd),Un=i(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-1qi99pl"&&(ke.innerHTML=id),gn=i(e),Jn=r(e,"HR",{}),jn=i(e),Ee=r(e,"A",{id:!0,class:!0}),h(Ee).forEach(s),zn=i(e),m(Ie.$$.fragment,e),Rn=i(e),De=r(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1a7u185"&&(De.textContent=od),Pn=i(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1eu3doh"&&(qe.innerHTML=rd),kn=i(e),En=r(e,"HR",{}),In=i(e),Ne=r(e,"A",{id:!0,class:!0}),h(Ne).forEach(s),Dn=i(e),m(Ve.$$.fragment,e),qn=i(e),Be=r(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-qls17b"&&(Be.textContent=dd),Nn=i(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-5nabmy"&&(Qe.innerHTML=ad),Vn=i(e),Se=r(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1skbfxl"&&(Se.innerHTML=ud),Bn=i(e),Ke=r(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-52pnzr"&&(Ke.innerHTML=md),Qn=i(e),Sn=r(e,"HR",{}),Kn=i(e),Oe=r(e,"A",{id:!0,class:!0}),h(Oe).forEach(s),On=i(e),m(We.$$.fragment,e),Wn=i(e),Ye=r(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-19w0pic"&&(Ye.innerHTML=pd),Yn=i(e),Fe=r(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1mr58c3"&&(Fe.innerHTML=cd),Fn=i(e),Xn=r(e,"HR",{}),Gn=i(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(s),Zn=i(e),m(Ge.$$.fragment,e),ei=i(e),Ze=r(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-18ws76n"&&(Ze.textContent=fd),ti=i(e),et=r(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1tnr5gm"&&(et.textContent=Td),si=i(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1aoa5jo"&&(tt.innerHTML=hd),li=i(e),st=r(e,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-1u9lyxp"&&(st.innerHTML=_d),ni=i(e),ii=r(e,"HR",{}),oi=i(e),lt=r(e,"A",{id:!0,class:!0}),h(lt).forEach(s),ri=i(e),m(nt.$$.fragment,e),di=i(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1b9ygao"&&(it.innerHTML=$d),ai=i(e),ot=r(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1mr58c3"&&(ot.innerHTML=yd),ui=i(e),mi=r(e,"HR",{}),pi=i(e),rt=r(e,"A",{id:!0,class:!0}),h(rt).forEach(s),ci=i(e),m(dt.$$.fragment,e),fi=i(e),at=r(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1vkr5xo"&&(at.innerHTML=Md),Ti=i(e),ut=r(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1mr58c3"&&(ut.innerHTML=bd),hi=i(e),_i=r(e,"HR",{}),$i=i(e),mt=r(e,"A",{id:!0,class:!0}),h(mt).forEach(s),yi=i(e),m(pt.$$.fragment,e),Mi=i(e),ct=r(e,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1gguudf"&&(ct.innerHTML=vd),bi=i(e),ft=r(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-9ffe42"&&(ft.innerHTML=Cd),vi=i(e),Tt=r(e,"TABLE",{"data-svelte-h":!0}),d(Tt)!=="svelte-z6whez"&&(Tt.innerHTML=xd),Ci=i(e),xi=r(e,"HR",{}),Hi=i(e),ht=r(e,"A",{id:!0,class:!0}),h(ht).forEach(s),Li=i(e),m(_t.$$.fragment,e),wi=i(e),$t=r(e,"P",{"data-svelte-h":!0}),d($t)!=="svelte-d6gvut"&&($t.innerHTML=Hd),Ai=i(e),yt=r(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-18n9ux4"&&(yt.innerHTML=Ld),Ui=i(e),Mt=r(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-jj58dd"&&(Mt.innerHTML=wd),gi=i(e),Ji=r(e,"HR",{}),ji=i(e),bt=r(e,"A",{id:!0,class:!0}),h(bt).forEach(s),zi=i(e),m(vt.$$.fragment,e),Ri=i(e),Ct=r(e,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-15z3tv8"&&(Ct.textContent=Ad),Pi=i(e),xt=r(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-sv4gxb"&&(xt.innerHTML=Ud),ki=i(e),Ht=r(e,"TABLE",{"data-svelte-h":!0}),d(Ht)!=="svelte-q8pfpb"&&(Ht.innerHTML=gd),Ei=i(e),Ii=r(e,"HR",{}),Di=i(e),Lt=r(e,"A",{id:!0,class:!0}),h(Lt).forEach(s),qi=i(e),m(wt.$$.fragment,e),Ni=i(e),At=r(e,"P",{"data-svelte-h":!0}),d(At)!=="svelte-fju8tm"&&(At.textContent=Jd),Vi=i(e),Ut=r(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-13s6o0v"&&(Ut.innerHTML=jd),Bi=i(e),gt=r(e,"TABLE",{"data-svelte-h":!0}),d(gt)!=="svelte-8i278m"&&(gt.innerHTML=zd),Qi=i(e),Si=r(e,"HR",{}),Ki=i(e),Jt=r(e,"A",{id:!0,class:!0}),h(Jt).forEach(s),Oi=i(e),m(jt.$$.fragment,e),Wi=i(e),zt=r(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-11ei68w"&&(zt.textContent=Rd),Yi=i(e),Rt=r(e,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-1p3llh"&&(Rt.innerHTML=Pd),Fi=i(e),Pt=r(e,"TABLE",{"data-svelte-h":!0}),d(Pt)!=="svelte-1xe0vb8"&&(Pt.innerHTML=kd),Xi=i(e),Gi=r(e,"HR",{}),Zi=i(e),kt=r(e,"A",{id:!0,class:!0}),h(kt).forEach(s),eo=i(e),m(Et.$$.fragment,e),to=i(e),It=r(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-k6p1db"&&(It.textContent=Ed),so=i(e),Dt=r(e,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-1o30xnd"&&(Dt.innerHTML=Id),lo=i(e),qt=r(e,"TABLE",{"data-svelte-h":!0}),d(qt)!=="svelte-101obk2"&&(qt.innerHTML=Dd),no=i(e),io=r(e,"HR",{}),oo=i(e),Nt=r(e,"A",{id:!0,class:!0}),h(Nt).forEach(s),ro=i(e),m(Vt.$$.fragment,e),ao=i(e),Bt=r(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-8afo9v"&&(Bt.textContent=qd),uo=i(e),Qt=r(e,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1vvmhgz"&&(Qt.innerHTML=Nd),mo=i(e),St=r(e,"TABLE",{"data-svelte-h":!0}),d(St)!=="svelte-wz2jkw"&&(St.innerHTML=Vd),po=i(e),co=r(e,"HR",{}),fo=i(e),Kt=r(e,"A",{id:!0,class:!0}),h(Kt).forEach(s),To=i(e),m(Ot.$$.fragment,e),ho=i(e),Wt=r(e,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-11plveb"&&(Wt.innerHTML=Bd),_o=i(e),Yt=r(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-1wu8g4g"&&(Yt.innerHTML=Qd),$o=i(e),Ft=r(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1vsvca3"&&(Ft.innerHTML=Sd),yo=i(e),Mo=r(e,"HR",{}),bo=i(e),Xt=r(e,"A",{id:!0,class:!0}),h(Xt).forEach(s),vo=i(e),m(Gt.$$.fragment,e),Co=i(e),Zt=r(e,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-17f4oxi"&&(Zt.textContent=Kd),xo=i(e),es=r(e,"P",{"data-svelte-h":!0}),d(es)!=="svelte-1lh8r1a"&&(es.innerHTML=Od),Ho=i(e),ts=r(e,"TABLE",{"data-svelte-h":!0}),d(ts)!=="svelte-m4z8c4"&&(ts.innerHTML=Wd),Lo=i(e),wo=r(e,"HR",{}),Ao=i(e),ss=r(e,"A",{id:!0,class:!0}),h(ss).forEach(s),Uo=i(e),m(ls.$$.fragment,e),go=i(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-kcewlk"&&(ns.textContent=Yd),Jo=i(e),is=r(e,"P",{"data-svelte-h":!0}),d(is)!=="svelte-17f480h"&&(is.innerHTML=Fd),jo=i(e),os=r(e,"TABLE",{"data-svelte-h":!0}),d(os)!=="svelte-1to7jw8"&&(os.innerHTML=Xd),zo=i(e),Ro=r(e,"HR",{}),Po=i(e),rs=r(e,"A",{id:!0,class:!0}),h(rs).forEach(s),ko=i(e),m(ds.$$.fragment,e),Eo=i(e),as=r(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-l5lzdu"&&(as.innerHTML=Gd),Io=i(e),Do=r(e,"HR",{}),qo=i(e),us=r(e,"A",{id:!0,class:!0}),h(us).forEach(s),No=i(e),m(ms.$$.fragment,e),Vo=i(e),ps=r(e,"P",{"data-svelte-h":!0}),d(ps)!=="svelte-40isdg"&&(ps.textContent=Zd),Bo=i(e),cs=r(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-tlsa2h"&&(cs.innerHTML=ea),Qo=i(e),fs=r(e,"TABLE",{"data-svelte-h":!0}),d(fs)!=="svelte-1j7v21a"&&(fs.innerHTML=ta),So=i(e),Ts=r(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-1aswmub"&&(Ts.innerHTML=sa),Ko=i(e),m(hs.$$.fragment,e),Oo=i(e),Wo=r(e,"HR",{}),Yo=i(e),_s=r(e,"A",{id:!0,class:!0}),h(_s).forEach(s),Fo=i(e),m($s.$$.fragment,e),Xo=i(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-kp31r8"&&(ys.innerHTML=la),Go=i(e),Zo=r(e,"HR",{}),er=i(e),Ms=r(e,"A",{id:!0,class:!0}),h(Ms).forEach(s),tr=i(e),m(bs.$$.fragment,e),sr=i(e),vs=r(e,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-1fs9no9"&&(vs.innerHTML=na),lr=i(e),nr=r(e,"HR",{}),ir=i(e),Cs=r(e,"A",{id:!0,class:!0}),h(Cs).forEach(s),or=i(e),m(xs.$$.fragment,e),rr=i(e),Hs=r(e,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-2mif9c"&&(Hs.textContent=ia),dr=i(e),Ls=r(e,"P",{"data-svelte-h":!0}),d(Ls)!=="svelte-1jas2kw"&&(Ls.innerHTML=oa),ar=i(e),m(ws.$$.fragment,e),ur=i(e),As=r(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-1aswmub"&&(As.innerHTML=ra),mr=i(e),m(Us.$$.fragment,e),pr=i(e),gs=r(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-1aswmub"&&(gs.innerHTML=da),cr=i(e),m(Js.$$.fragment,e),fr=i(e),Tr=r(e,"HR",{}),hr=i(e),zs=r(e,"P",{}),h(zs).forEach(s),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",_a),a(y,"id","module_utils/tensor"),a(y,"class","group"),a(x,"id","module_utils/tensor.Tensor"),a(x,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(j,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(j,"class","group"),a(k,"id","module_utils/tensor.Tensor+_getitem"),a(k,"class","group"),a(N,"id","module_utils/tensor.Tensor+indexOf"),a(N,"class","group"),a(S,"id","module_utils/tensor.Tensor+_subarray"),a(S,"class","group"),a(Y,"id","module_utils/tensor.Tensor+item"),a(Y,"class","group"),a(ee,"id","module_utils/tensor.Tensor+tolist"),a(ee,"class","group"),a(ne,"id","module_utils/tensor.Tensor+sigmoid"),a(ne,"class","group"),a(de,"id","module_utils/tensor.Tensor+sigmoid_"),a(de,"class","group"),a(pe,"id","module_utils/tensor.Tensor+transpose"),a(pe,"class","group"),a(_e,"id","module_utils/tensor.Tensor+sum"),a(_e,"class","group"),a(ve,"id","module_utils/tensor.Tensor+norm"),a(ve,"class","group"),a(we,"id","module_utils/tensor.Tensor+normalize_"),a(we,"class","group"),a(je,"id","module_utils/tensor.Tensor+normalize"),a(je,"class","group"),a(Ee,"id","module_utils/tensor.Tensor+stride"),a(Ee,"class","group"),a(Ne,"id","module_utils/tensor.Tensor+squeeze"),a(Ne,"class","group"),a(Oe,"id","module_utils/tensor.Tensor+squeeze_"),a(Oe,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+unsqueeze"),a(Xe,"class","group"),a(lt,"id","module_utils/tensor.Tensor+unsqueeze_"),a(lt,"class","group"),a(rt,"id","module_utils/tensor.Tensor+flatten_"),a(rt,"class","group"),a(mt,"id","module_utils/tensor.Tensor+flatten"),a(mt,"class","group"),a(ht,"id","module_utils/tensor.Tensor+view"),a(ht,"class","group"),a(bt,"id","module_utils/tensor.transpose"),a(bt,"class","group"),a(Lt,"id","module_utils/tensor.interpolate"),a(Lt,"class","group"),a(Jt,"id","module_utils/tensor.mean_pooling"),a(Jt,"class","group"),a(kt,"id","module_utils/tensor.cat"),a(kt,"class","group"),a(Nt,"id","module_utils/tensor.stack"),a(Nt,"class","group"),a(Kt,"id","module_utils/tensor.std_mean"),a(Kt,"class","group"),a(Xt,"id","module_utils/tensor.mean"),a(Xt,"class","group"),a(ss,"id","module_utils/tensor.dynamicTimeWarping"),a(ss,"class","group"),a(rs,"id","module_utils/tensor..ONNXTensor"),a(rs,"class","group"),a(us,"id","module_utils/tensor..reshape"),a(us,"class","group"),a(_s,"id","module_utils/tensor..reshape..reshapedArray"),a(_s,"class","group"),a(Ms,"id","module_utils/tensor..DataArray"),a(Ms,"class","group"),a(Cs,"id","module_utils/tensor..NestArray"),a(Cs,"class","group")},m(e,t){Ta(document.head,$),l(e,Rs,t),l(e,js,t),l(e,Ps,t),l(e,y,t),l(e,ks,t),p(M,e,t),l(e,Es,t),l(e,b,t),l(e,Is,t),l(e,v,t),l(e,Ds,t),l(e,C,t),l(e,qs,t),l(e,Ns,t),l(e,Vs,t),l(e,x,t),l(e,Bs,t),p(H,e,t),l(e,Qs,t),l(e,L,t),l(e,Ss,t),l(e,w,t),l(e,Ks,t),l(e,Os,t),l(e,Ws,t),l(e,A,t),l(e,Ys,t),p(U,e,t),l(e,Fs,t),l(e,g,t),l(e,Xs,t),l(e,J,t),l(e,Gs,t),l(e,Zs,t),l(e,el,t),l(e,j,t),l(e,tl,t),p(z,e,t),l(e,sl,t),l(e,R,t),l(e,ll,t),l(e,P,t),l(e,nl,t),l(e,il,t),l(e,ol,t),l(e,k,t),l(e,rl,t),p(E,e,t),l(e,dl,t),l(e,I,t),l(e,al,t),l(e,D,t),l(e,ul,t),l(e,q,t),l(e,ml,t),l(e,pl,t),l(e,cl,t),l(e,N,t),l(e,fl,t),p(V,e,t),l(e,Tl,t),l(e,B,t),l(e,hl,t),l(e,Q,t),l(e,_l,t),l(e,$l,t),l(e,yl,t),l(e,S,t),l(e,Ml,t),p(K,e,t),l(e,bl,t),l(e,O,t),l(e,vl,t),l(e,W,t),l(e,Cl,t),l(e,xl,t),l(e,Hl,t),l(e,Y,t),l(e,Ll,t),p(F,e,t),l(e,wl,t),l(e,X,t),l(e,Al,t),l(e,G,t),l(e,Ul,t),l(e,Z,t),l(e,gl,t),l(e,Jl,t),l(e,jl,t),l(e,ee,t),l(e,zl,t),p(te,e,t),l(e,Rl,t),l(e,se,t),l(e,Pl,t),l(e,le,t),l(e,kl,t),l(e,El,t),l(e,Il,t),l(e,ne,t),l(e,Dl,t),p(ie,e,t),l(e,ql,t),l(e,oe,t),l(e,Nl,t),l(e,re,t),l(e,Vl,t),l(e,Bl,t),l(e,Ql,t),l(e,de,t),l(e,Sl,t),p(ae,e,t),l(e,Kl,t),l(e,ue,t),l(e,Ol,t),l(e,me,t),l(e,Wl,t),l(e,Yl,t),l(e,Fl,t),l(e,pe,t),l(e,Xl,t),p(ce,e,t),l(e,Gl,t),l(e,fe,t),l(e,Zl,t),l(e,Te,t),l(e,en,t),l(e,he,t),l(e,tn,t),l(e,sn,t),l(e,ln,t),l(e,_e,t),l(e,nn,t),p($e,e,t),l(e,on,t),l(e,ye,t),l(e,rn,t),l(e,Me,t),l(e,dn,t),l(e,be,t),l(e,an,t),l(e,un,t),l(e,mn,t),l(e,ve,t),l(e,pn,t),p(Ce,e,t),l(e,cn,t),l(e,xe,t),l(e,fn,t),l(e,He,t),l(e,Tn,t),l(e,Le,t),l(e,hn,t),l(e,_n,t),l(e,$n,t),l(e,we,t),l(e,yn,t),p(Ae,e,t),l(e,Mn,t),l(e,Ue,t),l(e,bn,t),l(e,ge,t),l(e,vn,t),l(e,Je,t),l(e,Cn,t),l(e,xn,t),l(e,Hn,t),l(e,je,t),l(e,Ln,t),p(ze,e,t),l(e,wn,t),l(e,Re,t),l(e,An,t),l(e,Pe,t),l(e,Un,t),l(e,ke,t),l(e,gn,t),l(e,Jn,t),l(e,jn,t),l(e,Ee,t),l(e,zn,t),p(Ie,e,t),l(e,Rn,t),l(e,De,t),l(e,Pn,t),l(e,qe,t),l(e,kn,t),l(e,En,t),l(e,In,t),l(e,Ne,t),l(e,Dn,t),p(Ve,e,t),l(e,qn,t),l(e,Be,t),l(e,Nn,t),l(e,Qe,t),l(e,Vn,t),l(e,Se,t),l(e,Bn,t),l(e,Ke,t),l(e,Qn,t),l(e,Sn,t),l(e,Kn,t),l(e,Oe,t),l(e,On,t),p(We,e,t),l(e,Wn,t),l(e,Ye,t),l(e,Yn,t),l(e,Fe,t),l(e,Fn,t),l(e,Xn,t),l(e,Gn,t),l(e,Xe,t),l(e,Zn,t),p(Ge,e,t),l(e,ei,t),l(e,Ze,t),l(e,ti,t),l(e,et,t),l(e,si,t),l(e,tt,t),l(e,li,t),l(e,st,t),l(e,ni,t),l(e,ii,t),l(e,oi,t),l(e,lt,t),l(e,ri,t),p(nt,e,t),l(e,di,t),l(e,it,t),l(e,ai,t),l(e,ot,t),l(e,ui,t),l(e,mi,t),l(e,pi,t),l(e,rt,t),l(e,ci,t),p(dt,e,t),l(e,fi,t),l(e,at,t),l(e,Ti,t),l(e,ut,t),l(e,hi,t),l(e,_i,t),l(e,$i,t),l(e,mt,t),l(e,yi,t),p(pt,e,t),l(e,Mi,t),l(e,ct,t),l(e,bi,t),l(e,ft,t),l(e,vi,t),l(e,Tt,t),l(e,Ci,t),l(e,xi,t),l(e,Hi,t),l(e,ht,t),l(e,Li,t),p(_t,e,t),l(e,wi,t),l(e,$t,t),l(e,Ai,t),l(e,yt,t),l(e,Ui,t),l(e,Mt,t),l(e,gi,t),l(e,Ji,t),l(e,ji,t),l(e,bt,t),l(e,zi,t),p(vt,e,t),l(e,Ri,t),l(e,Ct,t),l(e,Pi,t),l(e,xt,t),l(e,ki,t),l(e,Ht,t),l(e,Ei,t),l(e,Ii,t),l(e,Di,t),l(e,Lt,t),l(e,qi,t),p(wt,e,t),l(e,Ni,t),l(e,At,t),l(e,Vi,t),l(e,Ut,t),l(e,Bi,t),l(e,gt,t),l(e,Qi,t),l(e,Si,t),l(e,Ki,t),l(e,Jt,t),l(e,Oi,t),p(jt,e,t),l(e,Wi,t),l(e,zt,t),l(e,Yi,t),l(e,Rt,t),l(e,Fi,t),l(e,Pt,t),l(e,Xi,t),l(e,Gi,t),l(e,Zi,t),l(e,kt,t),l(e,eo,t),p(Et,e,t),l(e,to,t),l(e,It,t),l(e,so,t),l(e,Dt,t),l(e,lo,t),l(e,qt,t),l(e,no,t),l(e,io,t),l(e,oo,t),l(e,Nt,t),l(e,ro,t),p(Vt,e,t),l(e,ao,t),l(e,Bt,t),l(e,uo,t),l(e,Qt,t),l(e,mo,t),l(e,St,t),l(e,po,t),l(e,co,t),l(e,fo,t),l(e,Kt,t),l(e,To,t),p(Ot,e,t),l(e,ho,t),l(e,Wt,t),l(e,_o,t),l(e,Yt,t),l(e,$o,t),l(e,Ft,t),l(e,yo,t),l(e,Mo,t),l(e,bo,t),l(e,Xt,t),l(e,vo,t),p(Gt,e,t),l(e,Co,t),l(e,Zt,t),l(e,xo,t),l(e,es,t),l(e,Ho,t),l(e,ts,t),l(e,Lo,t),l(e,wo,t),l(e,Ao,t),l(e,ss,t),l(e,Uo,t),p(ls,e,t),l(e,go,t),l(e,ns,t),l(e,Jo,t),l(e,is,t),l(e,jo,t),l(e,os,t),l(e,zo,t),l(e,Ro,t),l(e,Po,t),l(e,rs,t),l(e,ko,t),p(ds,e,t),l(e,Eo,t),l(e,as,t),l(e,Io,t),l(e,Do,t),l(e,qo,t),l(e,us,t),l(e,No,t),p(ms,e,t),l(e,Vo,t),l(e,ps,t),l(e,Bo,t),l(e,cs,t),l(e,Qo,t),l(e,fs,t),l(e,So,t),l(e,Ts,t),l(e,Ko,t),p(hs,e,t),l(e,Oo,t),l(e,Wo,t),l(e,Yo,t),l(e,_s,t),l(e,Fo,t),p($s,e,t),l(e,Xo,t),l(e,ys,t),l(e,Go,t),l(e,Zo,t),l(e,er,t),l(e,Ms,t),l(e,tr,t),p(bs,e,t),l(e,sr,t),l(e,vs,t),l(e,lr,t),l(e,nr,t),l(e,ir,t),l(e,Cs,t),l(e,or,t),p(xs,e,t),l(e,rr,t),l(e,Hs,t),l(e,dr,t),l(e,Ls,t),l(e,ar,t),p(ws,e,t),l(e,ur,t),l(e,As,t),l(e,mr,t),p(Us,e,t),l(e,pr,t),l(e,gs,t),l(e,cr,t),p(Js,e,t),l(e,fr,t),l(e,Tr,t),l(e,hr,t),l(e,zs,t),_r=!0},p:ua,i(e){_r||(c(M.$$.fragment,e),c(H.$$.fragment,e),c(U.$$.fragment,e),c(z.$$.fragment,e),c(E.$$.fragment,e),c(V.$$.fragment,e),c(K.$$.fragment,e),c(F.$$.fragment,e),c(te.$$.fragment,e),c(ie.$$.fragment,e),c(ae.$$.fragment,e),c(ce.$$.fragment,e),c($e.$$.fragment,e),c(Ce.$$.fragment,e),c(Ae.$$.fragment,e),c(ze.$$.fragment,e),c(Ie.$$.fragment,e),c(Ve.$$.fragment,e),c(We.$$.fragment,e),c(Ge.$$.fragment,e),c(nt.$$.fragment,e),c(dt.$$.fragment,e),c(pt.$$.fragment,e),c(_t.$$.fragment,e),c(vt.$$.fragment,e),c(wt.$$.fragment,e),c(jt.$$.fragment,e),c(Et.$$.fragment,e),c(Vt.$$.fragment,e),c(Ot.$$.fragment,e),c(Gt.$$.fragment,e),c(ls.$$.fragment,e),c(ds.$$.fragment,e),c(ms.$$.fragment,e),c(hs.$$.fragment,e),c($s.$$.fragment,e),c(bs.$$.fragment,e),c(xs.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),c(Js.$$.fragment,e),_r=!0)},o(e){f(M.$$.fragment,e),f(H.$$.fragment,e),f(U.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(V.$$.fragment,e),f(K.$$.fragment,e),f(F.$$.fragment,e),f(te.$$.fragment,e),f(ie.$$.fragment,e),f(ae.$$.fragment,e),f(ce.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ae.$$.fragment,e),f(ze.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(nt.$$.fragment,e),f(dt.$$.fragment,e),f(pt.$$.fragment,e),f(_t.$$.fragment,e),f(vt.$$.fragment,e),f(wt.$$.fragment,e),f(jt.$$.fragment,e),f(Et.$$.fragment,e),f(Vt.$$.fragment,e),f(Ot.$$.fragment,e),f(Gt.$$.fragment,e),f(ls.$$.fragment,e),f(ds.$$.fragment,e),f(ms.$$.fragment,e),f(hs.$$.fragment,e),f($s.$$.fragment,e),f(bs.$$.fragment,e),f(xs.$$.fragment,e),f(ws.$$.fragment,e),f(Us.$$.fragment,e),f(Js.$$.fragment,e),_r=!1},d(e){e&&(s(Rs),s(js),s(Ps),s(y),s(ks),s(Es),s(b),s(Is),s(v),s(Ds),s(C),s(qs),s(Ns),s(Vs),s(x),s(Bs),s(Qs),s(L),s(Ss),s(w),s(Ks),s(Os),s(Ws),s(A),s(Ys),s(Fs),s(g),s(Xs),s(J),s(Gs),s(Zs),s(el),s(j),s(tl),s(sl),s(R),s(ll),s(P),s(nl),s(il),s(ol),s(k),s(rl),s(dl),s(I),s(al),s(D),s(ul),s(q),s(ml),s(pl),s(cl),s(N),s(fl),s(Tl),s(B),s(hl),s(Q),s(_l),s($l),s(yl),s(S),s(Ml),s(bl),s(O),s(vl),s(W),s(Cl),s(xl),s(Hl),s(Y),s(Ll),s(wl),s(X),s(Al),s(G),s(Ul),s(Z),s(gl),s(Jl),s(jl),s(ee),s(zl),s(Rl),s(se),s(Pl),s(le),s(kl),s(El),s(Il),s(ne),s(Dl),s(ql),s(oe),s(Nl),s(re),s(Vl),s(Bl),s(Ql),s(de),s(Sl),s(Kl),s(ue),s(Ol),s(me),s(Wl),s(Yl),s(Fl),s(pe),s(Xl),s(Gl),s(fe),s(Zl),s(Te),s(en),s(he),s(tn),s(sn),s(ln),s(_e),s(nn),s(on),s(ye),s(rn),s(Me),s(dn),s(be),s(an),s(un),s(mn),s(ve),s(pn),s(cn),s(xe),s(fn),s(He),s(Tn),s(Le),s(hn),s(_n),s($n),s(we),s(yn),s(Mn),s(Ue),s(bn),s(ge),s(vn),s(Je),s(Cn),s(xn),s(Hn),s(je),s(Ln),s(wn),s(Re),s(An),s(Pe),s(Un),s(ke),s(gn),s(Jn),s(jn),s(Ee),s(zn),s(Rn),s(De),s(Pn),s(qe),s(kn),s(En),s(In),s(Ne),s(Dn),s(qn),s(Be),s(Nn),s(Qe),s(Vn),s(Se),s(Bn),s(Ke),s(Qn),s(Sn),s(Kn),s(Oe),s(On),s(Wn),s(Ye),s(Yn),s(Fe),s(Fn),s(Xn),s(Gn),s(Xe),s(Zn),s(ei),s(Ze),s(ti),s(et),s(si),s(tt),s(li),s(st),s(ni),s(ii),s(oi),s(lt),s(ri),s(di),s(it),s(ai),s(ot),s(ui),s(mi),s(pi),s(rt),s(ci),s(fi),s(at),s(Ti),s(ut),s(hi),s(_i),s($i),s(mt),s(yi),s(Mi),s(ct),s(bi),s(ft),s(vi),s(Tt),s(Ci),s(xi),s(Hi),s(ht),s(Li),s(wi),s($t),s(Ai),s(yt),s(Ui),s(Mt),s(gi),s(Ji),s(ji),s(bt),s(zi),s(Ri),s(Ct),s(Pi),s(xt),s(ki),s(Ht),s(Ei),s(Ii),s(Di),s(Lt),s(qi),s(Ni),s(At),s(Vi),s(Ut),s(Bi),s(gt),s(Qi),s(Si),s(Ki),s(Jt),s(Oi),s(Wi),s(zt),s(Yi),s(Rt),s(Fi),s(Pt),s(Xi),s(Gi),s(Zi),s(kt),s(eo),s(to),s(It),s(so),s(Dt),s(lo),s(qt),s(no),s(io),s(oo),s(Nt),s(ro),s(ao),s(Bt),s(uo),s(Qt),s(mo),s(St),s(po),s(co),s(fo),s(Kt),s(To),s(ho),s(Wt),s(_o),s(Yt),s($o),s(Ft),s(yo),s(Mo),s(bo),s(Xt),s(vo),s(Co),s(Zt),s(xo),s(es),s(Ho),s(ts),s(Lo),s(wo),s(Ao),s(ss),s(Uo),s(go),s(ns),s(Jo),s(is),s(jo),s(os),s(zo),s(Ro),s(Po),s(rs),s(ko),s(Eo),s(as),s(Io),s(Do),s(qo),s(us),s(No),s(Vo),s(ps),s(Bo),s(cs),s(Qo),s(fs),s(So),s(Ts),s(Ko),s(Oo),s(Wo),s(Yo),s(_s),s(Fo),s(Xo),s(ys),s(Go),s(Zo),s(er),s(Ms),s(tr),s(sr),s(vs),s(lr),s(nr),s(ir),s(Cs),s(or),s(rr),s(Hs),s(dr),s(Ls),s(ar),s(ur),s(As),s(mr),s(pr),s(gs),s(cr),s(fr),s(Tr),s(hr),s(zs)),s($),T(M,e),T(H,e),T(U,e),T(z,e),T(E,e),T(V,e),T(K,e),T(F,e),T(te,e),T(ie,e),T(ae,e),T(ce,e),T($e,e),T(Ce,e),T(Ae,e),T(ze,e),T(Ie,e),T(Ve,e),T(We,e),T(Ge,e),T(nt,e),T(dt,e),T(pt,e),T(_t,e),T(vt,e),T(wt,e),T(jt,e),T(Et,e),T(Vt,e),T(Ot,e),T(Gt,e),T(ls,e),T(ds,e),T(ms,e),T(hs,e),T($s,e),T(bs,e),T(xs,e),T(ws,e),T(Us,e),T(Js,e)}}}const _a='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code>","local":"tensoritem--code-number-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.transpose(...dims) ⇒ <code> Tensor </code>","local":"tensortransposedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensortransposetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor~ONNXTensor : <code> Object </code>","local":"utilstensoronnxtensor--code-object-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function $a(yr){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ca extends pa{constructor($){super(),ca(this,$,$a,ha,aa,{})}}export{Ca as component};
