import{s as Mu,n as mu,o as Tu}from"../chunks/scheduler.b108d059.js";import{S as yu,i as uu,g as a,s as i,r as c,A as Ju,h as p,f as l,c as n,j as u,u as r,x as o,k as d,y as hu,a as s,v as M,d as m,t as T,w as y}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as J}from"../chunks/Heading.88bfeb84.js";function wu(tm){let w,Mn,cn,mn,j,Tn,U,yn,f,lm="Pipelines provide a high-level, easy to use, API for running machine learning models.",un,b,sm="<strong>Example:</strong> Instantiate pipeline using the <code>pipeline</code> function.",Jn,x,hn,C,im='<li><a href="#module_pipelines">pipelines</a><ul><li><em>static</em><ul><li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call(question, context, options)</code></a> ⇒ <code>QuestionAnsweringReturnType</code></li></ul></li> <li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call(texts, [options])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a></li> <li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a></li> <li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call(texts, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call(texts, options)</code></a> ⇒</li></ul></li> <li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.pipeline"><code>.pipeline(task, [model], [options])</code></a> ⇒ <code>Promise.&lt;Pipeline&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_pipelines..QuestionAnsweringResult"><code>~QuestionAnsweringResult</code></a> : <code>object</code></li> <li><a href="#module_pipelines..QuestionAnsweringReturnType"><code>~QuestionAnsweringReturnType</code></a> : <code>Promise.&lt;(QuestionAnsweringResult|Array&lt;QuestionAnsweringResult&gt;)&gt;</code></li> <li><a href="#module_pipelines..ChunkCallback"><code>~ChunkCallback</code></a> : <code>function</code></li></ul></li></ul></li>',wn,jn,Un,g,fn,I,bn,k,nm=`The Pipeline class is the class from which all pipelines inherit.
Refer to this class for methods shared across different pipelines.`,xn,B,am='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Cn,G,pm='<li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',gn,In,kn,Q,Bn,N,Gn,Z,om="Create a new Pipeline.",Qn,v,dm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><code></code></td><td><p>The tokenizer to use (if any).</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><code></code></td><td><p>The processor to use (if any).</p></td></tr></tbody>",Nn,Zn,vn,A,An,$,$n,_,cm="Disposes the model.",_n,R,rm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;void&gt;</code> - A promise that resolves when the model has been disposed.',Rn,Vn,Yn,V,Pn,Y,En,P,Mm="Executes the task associated with the pipeline.",Hn,E,mm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A promise that resolves to an array containing the inputs and outputs of the task.',Wn,H,Tm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be processed.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Sn,zn,Xn,W,Ln,S,Fn,z,ym="Text classification pipeline using any <code>ModelForSequenceClassification</code>.",Dn,X,um="<strong>Example:</strong> Sentiment-analysis w/ <code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code>.",qn,L,On,F,Jm="<strong>Example:</strong> Multilingual sentiment-analysis w/ <code>Xenova/bert-base-multilingual-uncased-sentiment</code> (and return top 5 classes).",Kn,D,ea,q,hm="<strong>Example:</strong> Toxic comment classification w/ <code>Xenova/toxic-bert</code> (and return all classes).",ta,O,la,K,wm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',sa,ia,na,ee,aa,te,pa,le,jm="Executes the text classification task.",oa,se,Um='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextClassificationPipeline"><code>TextClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',da,ie,fm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",ca,ra,Ma,ne,ma,ae,Ta,pe,bm="Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>.",ya,oe,xm="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code>.",ua,de,Ja,ce,Cm="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code> (and return all labels).",ha,re,wa,Me,gm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ja,Ua,fa,me,ba,Te,xa,ye,Im="Executes the token classification task.",Ca,ue,km='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TokenClassificationPipeline"><code>TokenClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',ga,Je,Bm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>An optional object containing the following properties:</p></td></tr></tbody>",Ia,ka,Ba,he,Ga,we,Qa,je,Gm="Question Answering pipeline using any <code>ModelForQuestionAnswering</code>.",Na,Ue,Qm="<strong>Example:</strong> Run question answering with <code>Xenova/distilbert-base-uncased-distilled-squad</code>.",Za,fe,va,be,Nm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Aa,$a,_a,xe,Ra,Ce,Va,ge,Zm="Executes the question answering task.",Ya,Ie,vm=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.QuestionAnsweringPipeline"><code>QuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>QuestionAnsweringReturnType</code> - A promise that resolves to an array or object
containing the predicted answers and scores.`,Pa,ke,Am="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>question</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The question(s) to be answered.</p></td> </tr><tr><td>context</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The context(s) where the answer(s) can be found.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top answer predictions to be returned.</p></td></tr></tbody>",Ea,Ha,Wa,Be,Sa,Ge,za,Qe,$m="Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>.",Xa,Ne,_m="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-uncased</code>.",La,Ze,Fa,ve,Rm="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-cased</code> (and return top result).",Da,Ae,qa,$e,Vm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Oa,Ka,ep,_e,tp,Re,lp,Ve,Ym="Fill the masked token in the text(s) given as inputs.",sp,Ye,Pm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FillMaskPipeline"><code>FillMaskPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted tokens and scores.',ip,Pe,Em="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The masked input texts.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",np,ap,pp,Ee,op,He,dp,We,Hm="Text2TextGenerationPipeline class for generating text using a model that performs text-to-text generation tasks.",cp,Se,Wm="<strong>Example:</strong> Text-to-text generation w/ <code>Xenova/LaMini-Flan-T5-783M</code>.",rp,ze,Mp,Xe,Sm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',mp,Tp,yp,Le,up,Fe,Jp,De,zm="Fill the masked token in the text(s) given as inputs.",hp,qe,Xm=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of objects containing the score, predicted token, predicted token string,
and the sequence with the predicted token filled in, or an array of such arrays (one for each input text).
If only one input text is given, the output will be an array of objects.<br/> <strong>Throws</strong>:`,wp,Oe,Lm="<li><code>Error</code> When the mask token is not found in the input text.</li>",jp,Ke,Fm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text or array of texts to be processed.</p></td> </tr><tr><td>[options]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Options for the fill-mask pipeline.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top-k predictions to return.</p></td></tr></tbody>",Up,fp,bp,et,xp,tt,Cp,lt,Dm="A pipeline for summarization tasks, inheriting from Text2TextGenerationPipeline.",gp,st,qm="<strong>Example:</strong> Summarization w/ <code>Xenova/distilbart-cnn-6-6</code>.",Ip,it,kp,nt,Om='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Bp,Gp,Qp,at,Np,pt,Zp,ot,Km="Translates text from one language to another.",vp,dt,eT="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/nllb-200-distilled-600M</code>.",Ap,ct,tT=`See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,$p,rt,_p,Mt,lT="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/m2m100_418M</code>.",Rp,mt,sT=`See <a href="https://huggingface.co/facebook/m2m100_418M#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,Vp,Tt,Yp,yt,iT="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/mbart-large-50-many-to-many-mmt</code>.",Pp,ut,nT=`See <a href="https://huggingface.co/facebook/mbart-large-50-many-to-many-mmt#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,Ep,Jt,Hp,ht,aT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Wp,Sp,zp,wt,Xp,jt,Lp,Ut,pT=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>.
This pipeline predicts the words that will follow a specified text prompt.
NOTE: For the full list of generation parameters, see <a href="./utils/generation#module_utils/generation.GenerationConfig"><code>GenerationConfig</code></a>.`,Fp,ft,oT="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (default settings).",Dp,bt,qp,xt,dT="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (custom settings).",Op,Ct,Kp,gt,cT="<strong>Example:</strong> Run code generation with <code>Xenova/codegen-350M-mono</code>.",eo,It,to,kt,rT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',lo,so,io,Bt,no,Gt,ao,Qt,MT="Generates text based on an input prompt.",po,Nt,mT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextGenerationPipeline"><code>TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The generated text or texts.',oo,Zt,TT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input prompt or prompts to generate text from.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional arguments for text generation.</p></td></tr></tbody>",co,ro,Mo,vt,mo,At,To,$t,yT=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code>
trained on NLI (natural language inference) tasks. Equivalent of <code>text-classification</code>
pipelines, but these models don’t require a hardcoded number of potential classes, they
can be chosen at runtime. It usually means it’s slower but it is <strong>much</strong> more flexible.`,yo,_t,uT="<strong>Example:</strong> Zero shot classification with <code>Xenova/mobilebert-uncased-mnli</code>.",uo,Rt,Jo,Vt,JT="<strong>Example:</strong> Zero shot classification with <code>Xenova/nli-deberta-v3-xsmall</code> (multi-label).",ho,Yt,wo,Pt,hT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',jo,Et,wT='<li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Uo,fo,bo,Ht,xo,Wt,Co,St,jT="Create a new ZeroShotClassificationPipeline.",go,zt,UT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td></tr></tbody>",Io,ko,Bo,Xt,Go,Lt,Qo,Ft,fT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - The prediction(s), as a map (or list of maps) from label to score.',No,Dt,bT=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;any&gt;</code></td><td></td><td></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This example is {}.&quot;&quot;</code></td><td><p>The template used to turn each
candidate label into an NLI-style hypothesis. The candidate label will replace the &amp;#123;} placeholder.</p></td> </tr><tr><td>[options.multi_label]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not multiple candidate labels can be true.
If <code>false</code>, the scores are normalized such that the sum of the label likelihoods for each sequence
is 1. If <code>true</code>, the labels are considered independent and probabilities are normalized for each
candidate by doing a softmax of the entailment score vs. the contradiction score.</p></td></tr></tbody>`,Zo,vo,Ao,qt,$o,Ot,_o,Kt,xT=`Feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,Ro,el,CT="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (without pooling/normalization).",Vo,tl,Yo,ll,gT="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (with pooling/normalization).",Po,sl,Eo,il,IT="<strong>Example:</strong> Calculating embeddings with <code>sentence-transformers</code> models.",Ho,nl,Wo,al,kT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',So,zo,Xo,pl,Lo,ol,Fo,dl,BT="Extract the features of the input(s).",Do,cl,GT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FeatureExtractionPipeline"><code>FeatureExtractionPipeline</code></a><br/> <strong>Returns</strong>: The features computed by the model.',qo,rl,QT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The input texts</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.pooling]</td><td><code>string</code></td><td><code>&quot;&quot;none&quot;&quot;</code></td><td><p>The pooling method to use. Can be one of: &quot;none&quot;, &quot;mean&quot;.</p></td> </tr><tr><td>[options.normalize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to normalize the embeddings in the last dimension.</p></td></tr></tbody>",Oo,Ko,ed,Ml,td,ml,ld,Tl,NT=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>.
This pipeline predicts the class of a raw waveform or an audio file.`,sd,yl,ZT="<strong>Example:</strong> Perform audio classification.",id,ul,nd,Jl,vT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ad,hl,AT='<li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li>',pd,od,dd,wl,cd,jl,rd,Ul,$T="Create a new AudioClassificationPipeline.",Md,fl,_T="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",md,Td,yd,bl,ud,xl,Jd,Cl,RT="Executes the audio classification task.",hd,gl,VT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AudioClassificationPipeline"><code>AudioClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',wd,Il,YT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td></td><td><p>The input audio files to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",jd,Ud,fd,kl,bd,Bl,xd,Gl,PT="Pipeline that aims at extracting spoken text contained within some audio.",Cd,Ql,ET="<strong>Example:</strong> Transcribe English.",gd,Nl,Id,Zl,HT="<strong>Example:</strong> Transcribe English w/ timestamps.",kd,vl,Bd,Al,WT="<strong>Example:</strong> Transcribe English w/ word-level timestamps.",Gd,$l,Qd,_l,ST="<strong>Example:</strong> Transcribe French.",Nd,Rl,Zd,Vl,zT="<strong>Example:</strong> Translate French to English.",vd,Yl,Ad,Pl,XT="<strong>Example:</strong> Transcribe/translate audio longer than 30 seconds.",$d,El,_d,Hl,LT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Rd,Wl,FT='<li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Vd,Yd,Pd,Sl,Ed,zl,Hd,Xl,DT="Create a new AutomaticSpeechRecognitionPipeline.",Wd,Ll,qT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Sd,zd,Xd,Fl,Ld,Dl,Fd,ql,OT="Asynchronously processes audio and generates text transcription using the model.",Dd,Ol,KT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AutomaticSpeechRecognitionPipeline"><code>AutomaticSpeechRecognitionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves to an object containing the transcription text and optionally timestamps if <code>return_timestamps</code> is <code>true</code>.',qd,Kl,ey=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code> | <code>Array&lt;Float32Array&gt;</code></td><td></td><td><p>The audio to be transcribed. Can be a single Float32Array or an array of Float32Arrays.</p></td> </tr><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional arguments.</p></td> </tr><tr><td>[kwargs.return_timestamps]</td><td><code>boolean</code> | <code>&#39;word&#39;</code></td><td></td><td><p>Whether to return timestamps or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.chunk_length_s]</td><td><code>number</code></td><td></td><td><p>The length of audio chunks to process in seconds. Default is 0 (no chunking).</p></td> </tr><tr><td>[kwargs.stride_length_s]</td><td><code>number</code></td><td></td><td><p>The length of overlap between consecutive audio chunks in seconds. If not provided, defaults to <code>chunk_length_s / 6</code>.</p></td> </tr><tr><td>[kwargs.chunk_callback]</td><td><code>ChunkCallback</code></td><td></td><td><p>Callback function to be called with each chunk processed.</p></td> </tr><tr><td>[kwargs.force_full_sequences]</td><td><code>boolean</code></td><td></td><td><p>Whether to force outputting full sequences or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.language]</td><td><code>string</code></td><td></td><td><p>The source language. Default is <code>null</code>, meaning it should be auto-detected. Use this to potentially improve performance if the source language is known.</p></td> </tr><tr><td>[kwargs.task]</td><td><code>string</code></td><td></td><td><p>The task to perform. Default is <code>null</code>, meaning it should be auto-detected.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices
that will be forced before sampling. For example, [[1, 123]] means the second generated token will always be a token of index 123.</p></td></tr></tbody>`,Od,Kd,ec,es,tc,ts,lc,ls,ty="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",sc,ss,ly="<strong>Example:</strong> Generate a caption for an image w/ <code>Xenova/vit-gpt2-image-captioning</code>.",ic,is,nc,ns,sy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ac,as,iy='<li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',pc,oc,dc,ps,cc,os,rc,ds,ny="Create a new ImageToTextPipeline.",Mc,cs,ay="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",mc,Tc,yc,rs,uc,Ms,Jc,ms,py="Assign labels to the image(s) passed as inputs.",hc,Ts,oy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToTextPipeline"><code>ImageToTextPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',wc,ys,dy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The images to be captioned.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",jc,Uc,fc,us,bc,Js,xc,hs,cy=`Image classification pipeline using any <code>AutoModelForImageClassification</code>.
This pipeline predicts the class of an image.`,Cc,ws,ry="<strong>Example:</strong> Classify an image.",gc,js,Ic,Us,My="<strong>Example:</strong> Classify an image and return top <code>n</code> classes.",kc,fs,Bc,bs,my="<strong>Example:</strong> Classify an image and return all classes.",Gc,xs,Qc,Cs,Ty='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Nc,gs,yy='<li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Zc,vc,Ac,Is,$c,ks,_c,Bs,uy="Create a new ImageClassificationPipeline.",Rc,Gs,Jy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Vc,Yc,Pc,Qs,Ec,Ns,Hc,Zs,hy="Classify the given images.",Wc,vs,wy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageClassificationPipeline"><code>ImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The top classification results for the images.',Sc,As,jy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td></td><td><p>The images to classify.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for classification.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top results to return.</p></td></tr></tbody>",zc,Xc,Lc,$s,Fc,_s,Dc,Rs,Uy=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>.
This pipeline predicts masks of objects and their classes.`,qc,Vs,fy="<strong>Example:</strong> Perform image segmentation with <code>Xenova/detr-resnet-50-panoptic</code>.",Oc,Ys,Kc,Ps,by='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',er,Es,xy='<li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li>',tr,lr,sr,Hs,ir,Ws,nr,Ss,Cy="Create a new ImageSegmentationPipeline.",ar,zs,gy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",pr,or,dr,Xs,cr,Ls,rr,Fs,Iy="Segment the input images.",Mr,Ds,ky='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageSegmentationPipeline"><code>ImageSegmentationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Array&gt;</code> - The annotated segments.',mr,qs,By="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for segmentation.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Probability threshold to filter out predicted masks.</p></td> </tr><tr><td>[options.mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[options.overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>Mask overlap threshold to eliminate small, disconnected segments.</p></td> </tr><tr><td>[options.subtask]</td><td><code>null</code> | <code>string</code></td><td><code></code></td><td><p>Segmentation task to be performed. One of [<code>panoptic</code>, <code>instance</code>, and <code>semantic</code>], depending on model capabilities. If not set, the pipeline will attempt to resolve (in that order).</p></td> </tr><tr><td>[options.label_ids_to_fuse]</td><td><code>Array</code></td><td><code></code></td><td><p>List of label ids to fuse. If not set, do not fuse any labels.</p></td> </tr><tr><td>[options.target_sizes]</td><td><code>Array</code></td><td><code></code></td><td><p>List of target sizes for the input images. If not set, use the original image sizes.</p></td></tr></tbody>",Tr,yr,ur,Os,Jr,Ks,hr,ei,Gy=`Zero shot image classification pipeline. This pipeline predicts the class of
an image when you provide an image and a set of <code>candidate_labels</code>.`,wr,ti,Qy="<strong>Example:</strong> Zero shot image classification w/ <code>Xenova/clip-vit-base-patch32</code>.",jr,li,Ur,si,Ny='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',fr,ii,Zy='<li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',br,xr,Cr,ni,gr,ai,Ir,pi,vy="Create a new ZeroShotImageClassificationPipeline.",kr,oi,Ay="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Br,Gr,Qr,di,Nr,ci,Zr,ri,$y="Classify the input images with candidate labels using a zero-shot approach.",vr,Mi,_y='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotImageClassificationPipeline"><code>ZeroShotImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',Ar,mi,Ry="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><p>The hypothesis template to use for zero-shot classification. Default: &quot;This is a photo of &amp;#123;}&quot;.</p></td></tr></tbody>",$r,_r,Rr,Ti,Vr,yi,Yr,ui,Vy=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>.
This pipeline predicts bounding boxes of objects and their classes.`,Pr,Ji,Yy="<strong>Example:</strong> Run object-detection with <code>facebook/detr-resnet-50</code>.",Er,hi,Hr,wi,Py='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Wr,ji,Ey='<li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li>',Sr,zr,Xr,Ui,Lr,fi,Fr,bi,Hy="Create a new ObjectDetectionPipeline.",Dr,xi,Wy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",qr,Or,Kr,Ci,eM,gi,tM,Ii,Sy="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",lM,ki,zy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ObjectDetectionPipeline"><code>ObjectDetectionPipeline</code></a>',sM,Bi,Xy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the object detection.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.9</code></td><td><p>The threshold used to filter boxes by score.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>",iM,nM,aM,Gi,pM,Qi,oM,Ni,Ly=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>.
The inputs/outputs are similar to the (extractive) question answering pipeline; however,
the pipeline takes an image (and optional OCR’d words/boxes) as input instead of text context.`,dM,Zi,Fy="<strong>Example:</strong> Answer questions about a document with <code>Xenova/donut-base-finetuned-docvqa</code>.",cM,vi,rM,Ai,Dy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',MM,$i,qy='<li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',mM,TM,yM,_i,uM,Ri,JM,Vi,Oy="Create a new DocumentQuestionAnsweringPipeline.",hM,Yi,Ky="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",wM,jM,UM,Pi,fM,Ei,bM,Hi,eu="Answer the question given as input by using the document.",xM,Wi,tu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DocumentQuestionAnsweringPipeline"><code>DocumentQuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',CM,Si,lu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>any</code></td><td></td><td><p>The image of the document to use.</p></td> </tr><tr><td>question</td><td><code>string</code></td><td></td><td><p>A question to ask of the document.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",gM,IM,kM,zi,BM,Xi,GM,Li,su="Utility factory method to build a [<code>Pipeline</code>] object.",QM,Fi,iu='<strong>Kind</strong>: static method of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Pipeline&gt;</code> - A Pipeline object for the specified task.<br/> <strong>Throws</strong>:',NM,Di,nu="<li><code>Error</code> If an unsupported pipeline is requested.</li>",ZM,qi,au="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td></td><td><p>The task defining which pipeline will be returned. Currently accepted tasks are:</p> <ul><li><code>&quot;audio-classification&quot;</code>: will return a <code>AudioClassificationPipeline</code>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <code>AutomaticSpeechRecognitionPipeline</code>.</li> <li><code>&quot;document-question-answering&quot;</code>: will return a <code>DocumentQuestionAnsweringPipeline</code>.</li> <li><code>&quot;feature-extraction&quot;</code>: will return a <code>FeatureExtractionPipeline</code>.</li> <li><code>&quot;fill-mask&quot;</code>: will return a <code>FillMaskPipeline</code>.</li> <li><code>&quot;image-classification&quot;</code>: will return a <code>ImageClassificationPipeline</code>.</li> <li><code>&quot;image-segmentation&quot;</code>: will return a <code>ImageSegmentationPipeline</code>.</li> <li><code>&quot;image-to-text&quot;</code>: will return a <code>ImageToTextPipeline</code>.</li> <li><code>&quot;object-detection&quot;</code>: will return a <code>ObjectDetectionPipeline</code>.</li> <li><code>&quot;question-answering&quot;</code>: will return a <code>QuestionAnsweringPipeline</code>.</li> <li><code>&quot;summarization&quot;</code>: will return a <code>SummarizationPipeline</code>.</li> <li><code>&quot;text2text-generation&quot;</code>: will return a <code>Text2TextGenerationPipeline</code>.</li> <li><code>&quot;text-classification&quot;</code> (alias &quot;sentiment-analysis&quot; available): will return a <code>TextClassificationPipeline</code>.</li> <li><code>&quot;text-generation&quot;</code>: will return a <code>TextGenerationPipeline</code>.</li> <li><code>&quot;token-classification&quot;</code> (alias &quot;ner&quot; available): will return a <code>TokenClassificationPipeline</code>.</li> <li><code>&quot;translation&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;zero-shot-classification&quot;</code>: will return a <code>ZeroShotClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <code>ZeroShotImageClassificationPipeline</code>.</li></ul></td> </tr><tr><td>[model]</td><td><code>string</code></td><td><code>null</code></td><td><p>The name of the pre-trained model to use. If not specified, the default model for the task will be used.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td></td><td><p>Optional parameters for the pipeline.</p></td></tr></tbody>",vM,AM,$M,Oi,_M,Ki,RM,en,pu='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',VM,tn,ou="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>answer</td><td><code>string</code></td><td><p>The answer.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score.</p></td></tr></tbody>",YM,PM,EM,ln,HM,sn,WM,nn,du='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',SM,zM,XM,an,LM,pn,FM,on,cu='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',DM,dn,ru="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>chunk</td><td><code>Chunk</code></td><td><p>The chunk to process.</p></td></tr></tbody>",qM,OM,KM,rn,em;return U=new J({props:{title:"pipelines",local:"pipelines",headingTag:"h1"}}),x=new h({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4MTc2ODYlN0QlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),I=new J({props:{title:"pipelines.Pipeline ⇐ <code> Callable </code>",local:"pipelinespipeline--code-callable-code",headingTag:"h2"}}),N=new J({props:{title:"new Pipeline(options)",local:"new-pipelineoptions",headingTag:"h3"}}),$=new J({props:{title:"pipeline.dispose() ⇒ <code> Promise. < void > </code>",local:"pipelinedispose--code-promise--void--code",headingTag:"h3"}}),Y=new J({props:{title:"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>",local:"pipelinecalltexts-args--code-promise--any--code",headingTag:"h3"}}),S=new J({props:{title:"pipelines.TextClassificationPipeline",local:"pipelinestextclassificationpipeline",headingTag:"h2"}}),L=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBsYWJlbCUzQSUyMCdQT1NJVElWRSclMkMlMjBzY29yZSUzQSUyMDAuOTk5Nzg4NzYxMTM4OTE2JTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{ label: &#x27;POSITIVE&#x27;, score: 0.999788761138916 }]</span>`,wrap:!1}}),D=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdMZSUyMG1laWxsZXVyJTIwZmlsbSUyMGRlJTIwdG91cyUyMGxlcyUyMHRlbXBzLiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwNSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjk2MTA3NTk2MTU4OTgxMzIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc0JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAzMzIzMzUxNTkxODI1NDg1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMyUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDM2MTU1MTgxMDA1NTk3MTE1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMSUyMHN0YXInJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTEzMjU5Njc0OTgxMjM2NDYlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCcyJTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDk0MjM5NzEwNTk3MzIxMzklMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Le meilleur film de tous les temps.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;5 stars&#x27;, score: 0.9610759615898132 },</span>
<span class="hljs-comment">//   { label: &#x27;4 stars&#x27;, score: 0.03323351591825485 },</span>
<span class="hljs-comment">//   { label: &#x27;3 stars&#x27;, score: 0.0036155181005597115 },</span>
<span class="hljs-comment">//   { label: &#x27;1 star&#x27;, score: 0.0011325967498123646 },</span>
<span class="hljs-comment">//   { label: &#x27;2 stars&#x27;, score: 0.0009423971059732139 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),O=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnRveGljLWJlcnQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGhhdGUlMjB5b3UhJyUyQyUyMCU3QiUyMHRvcGslM0ElMjBudWxsJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC45NTkzMTQwNDgyOTAyNTI3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaW5zdWx0JyUyQyUyMHNjb3JlJTNBJTIwMC4xNjE4NzMzNDA2MDY2ODk0NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ29ic2NlbmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzNDUyNjgwNjMyNDcyMDM4JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaWRlbnRpdHlfaGF0ZSclMkMlMjBzY29yZSUzQSUyMDAuMDIyMzI1MDU3NTM2MzYzNiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RocmVhdCclMkMlMjBzY29yZSUzQSUyMDAuMDE5MTk3MDQxMTY4ODA4OTM3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnc2V2ZXJlX3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDU2NTEwOTk2MDczNDg0NDIlMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/toxic-bert&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I hate you!&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-literal">null</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;toxic&#x27;, score: 0.9593140482902527 },</span>
<span class="hljs-comment">//   { label: &#x27;insult&#x27;, score: 0.16187334060668945 },</span>
<span class="hljs-comment">//   { label: &#x27;obscene&#x27;, score: 0.03452680632472038 },</span>
<span class="hljs-comment">//   { label: &#x27;identity_hate&#x27;, score: 0.0223250575363636 },</span>
<span class="hljs-comment">//   { label: &#x27;threat&#x27;, score: 0.019197041168808937 },</span>
<span class="hljs-comment">//   { label: &#x27;severe_toxic&#x27;, score: 0.005651099607348442 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),te=new J({props:{title:"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),ae=new J({props:{title:"pipelines.TokenClassificationPipeline",local:"pipelinestokenclassificationpipeline",headingTag:"h2"}}),de=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ015JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwTG9uZG9uJyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1QRVInJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODAyMDI5MTMyODQzMDIlMkMlMjBpbmRleCUzQSUyMDQlMkMlMjB3b3JkJTNBJTIwJ1NhcmFoJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NDQ3NDA1MzM4Mjg3NCUyQyUyMGluZGV4JTNBJTIwOSUyQyUyMHdvcmQlM0ElMjAnTG9uZG9uJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;My name is Sarah and I live in London&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9980202913284302, index: 4, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9994474053382874, index: 9, word: &#x27;London&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),re=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ1NhcmFoJTIwbGl2ZXMlMjBpbiUyMHRoZSUyMFVuaXRlZCUyMFN0YXRlcyUyMG9mJTIwQW1lcmljYSclMkMlMjAlN0IlMjBpZ25vcmVfbGFiZWxzJTNBJTIwJTVCJTVEJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLVBFUiclMkMlMjBzY29yZSUzQSUyMDAuOTk2NjU4NzQyNDI3ODI1OSUyQyUyMGluZGV4JTNBJTIwMSUyQyUyMHdvcmQlM0ElMjAnU2FyYWgnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ08nJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODczODU4NjkwMjYxODQlMkMlMjBpbmRleCUzQSUyMDIlMkMlMjB3b3JkJTNBJTIwJ2xpdmVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdPJyUyQyUyMHNjb3JlJTNBJTIwMC45OTkwMDcyODQ2NDEyNjU5JTJDJTIwaW5kZXglM0ElMjAzJTJDJTIwd29yZCUzQSUyMCdpbiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnTyclMkMlMjBzY29yZSUzQSUyMDAuOTk4ODI5ODQxNjEzNzY5NSUyQyUyMGluZGV4JTNBJTIwNCUyQyUyMHdvcmQlM0ElMjAndGhlJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NTUxMDU3ODE1NTUxOCUyQyUyMGluZGV4JTNBJTIwNSUyQyUyMHdvcmQlM0ElMjAnVW5pdGVkJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5MDM5NTMwNzU0MDg5NCUyQyUyMGluZGV4JTNBJTIwNiUyQyUyMHdvcmQlM0ElMjAnU3RhdGVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk4NjcyNDg1MzUxNTYyNSUyQyUyMGluZGV4JTNBJTIwNyUyQyUyMHdvcmQlM0ElMjAnb2YnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ0ktTE9DJyUyQyUyMHNjb3JlJTNBJTIwMC45OTc1Mjk0NDcwNzg3MDQ4JTJDJTIwaW5kZXglM0ElMjA4JTJDJTIwd29yZCUzQSUyMCdBbWVyaWNhJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Sarah lives in the United States of America&#x27;</span>, { <span class="hljs-attr">ignore_labels</span>: [] });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9966587424278259, index: 1, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9987385869026184, index: 2, word: &#x27;lives&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9990072846412659, index: 3, word: &#x27;in&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9988298416137695, index: 4, word: &#x27;the&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9995510578155518, index: 5, word: &#x27;United&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9990395307540894, index: 6, word: &#x27;States&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9986724853515625, index: 7, word: &#x27;of&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9975294470787048, index: 8, word: &#x27;America&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Te=new J({props:{title:"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),we=new J({props:{title:"pipelines.QuestionAnsweringPipeline",local:"pipelinesquestionansweringpipeline",headingTag:"h2"}}),fe=new h({props:{code:"bGV0JTIwcXVlc3Rpb24lMjAlM0QlMjAnV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJyUzQiUwQWxldCUyMGNvbnRleHQlMjAlM0QlMjAnSmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQuJyUzQiUwQSUwQWxldCUyMGFuc3dlcmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgncXVlc3Rpb24tYW5zd2VyaW5nJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwYW5zd2VyZXIocXVlc3Rpb24lMkMlMjBjb250ZXh0KSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMmElMjBuaWNlJTIwcHVwcGV0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjAwLjU3Njg5MTE1MDI1MjY3NDElMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;Who was Jim Henson?&#x27;</span>;
<span class="hljs-keyword">let</span> context = <span class="hljs-string">&#x27;Jim Henson was a nice puppet.&#x27;</span>;

<span class="hljs-keyword">let</span> answerer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-distilled-squad&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">answerer</span>(question, context);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;answer&quot;: &quot;a nice puppet&quot;,</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.5768911502526741</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ce=new J({props:{title:"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>",local:"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code",headingTag:"h3"}}),Ge=new J({props:{title:"pipelines.FillMaskPipeline",local:"pipelinesfillmaskpipeline",headingTag:"h2"}}),Ze=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4nKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdzdXJ2aXZhbCclMkMlMjBzY29yZSUzQSUyMDAuMDYxMzc0MTk0OTIwMDYzMDIlMkMlMjB0b2tlbiUzQSUyMDgxMTUlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBzdXJ2aXZhbC4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2xvdmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzOTAyNDUwMjAzODk1NTY5JTJDJTIwdG9rZW4lM0ElMjAxNTY3JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwbG92ZS4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2hhcHBpbmVzcyclMkMlMjBzY29yZSUzQSUyMDAuMDMyNTMxODM1MTM4Nzk3NzYlMkMlMjB0b2tlbiUzQSUyMDkyNjYlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBoYXBwaW5lc3MuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdmcmVlZG9tJyUyQyUyMHNjb3JlJTNBJTIwMC4wMTg3MzYzMDY1Nzc5MjA5MTQlMkMlMjB0b2tlbiUzQSUyMDQ0MzglMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBmcmVlZG9tLiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnbGlmZSclMkMlMjBzY29yZSUzQSUyMDAuMDE4NTk3OTQ3NDMzNTkwODklMkMlMjB0b2tlbiUzQSUyMDEyOTclMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBsaWZlLiclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The goal of life is [MASK].&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { token_str: &#x27;survival&#x27;, score: 0.06137419492006302, token: 8115, sequence: &#x27;The goal of life is survival.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;love&#x27;, score: 0.03902450203895569, token: 1567, sequence: &#x27;The goal of life is love.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;happiness&#x27;, score: 0.03253183513879776, token: 9266, sequence: &#x27;The goal of life is happiness.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;freedom&#x27;, score: 0.018736306577920914, token: 4438, sequence: &#x27;The goal of life is freedom.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;life&#x27;, score: 0.01859794743359089, token: 1297, sequence: &#x27;The goal of life is life.&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ae=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwTWlsa3klMjBXYXklMjBpcyUyMGElMjAlNUJNQVNLJTVEJTIwZ2FsYXh5LiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwMSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0b2tlbl9zdHIlM0ElMjAnc3BpcmFsJyUyQyUyMHNjb3JlJTNBJTIwMC42Mjk5OTg3NDM1MzQwODgxJTJDJTIwdG9rZW4lM0ElMjAxNDA2MSUyQyUyMHNlcXVlbmNlJTNBJTIwJ1RoZSUyME1pbGt5JTIwV2F5JTIwaXMlMjBhJTIwc3BpcmFsJTIwZ2FsYXh5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The Milky Way is a [MASK] galaxy.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">1</span> });
<span class="hljs-comment">// [{ token_str: &#x27;spiral&#x27;, score: 0.6299987435340881, token: 14061, sequence: &#x27;The Milky Way is a spiral galaxy.&#x27; }]</span>`,wrap:!1}}),Re=new J({props:{title:"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),He=new J({props:{title:"pipelines.Text2TextGenerationPipeline",local:"pipelinestext2textgenerationpipeline",headingTag:"h2"}}),ze=new h({props:{code:"bGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dDJ0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRkxhTWluaS1GbGFuLVQ1LTc4M00nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKCdob3clMjBjYW4lMjBJJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklM0YnJTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMDAlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTIwJ1RvJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklMkMlMjB5b3UlMjBjYW4lM0ElMjAxLiUyMEVhdCUyMGElMjBiYWxhbmNlZCUyMGRpZXQlMjB3aXRoJTIwcGxlbnR5JTIwb2YlMjBmcnVpdHMlMkMlMjB2ZWdldGFibGVzJTJDJTIwd2hvbGUlMjBncmFpbnMlMkMlMjBsZWFuJTIwcHJvdGVpbnMlMkMlMjBhbmQlMjBoZWFsdGh5JTIwZmF0cy4lMjAyLiUyMFN0YXklMjBoeWRyYXRlZCUyMGJ5JTIwZHJpbmtpbmclMjBwbGVudHklMjBvZiUyMHdhdGVyLiUyMDMuJTIwR2V0JTIwZW5vdWdoJTIwc2xlZXAlMjBhbmQlMjBtYW5hZ2UlMjBzdHJlc3MlMjBsZXZlbHMuJTIwNC4lMjBBdm9pZCUyMHNtb2tpbmclMjBhbmQlMjBleGNlc3NpdmUlMjBhbGNvaG9sJTIwY29uc3VtcHRpb24uJTIwNS4lMjBSZWd1bGFybHklMjBleGVyY2lzZSUyMGFuZCUyMG1haW50YWluJTIwYSUyMGhlYWx0aHklMjB3ZWlnaHQuJTIwNi4lMjBQcmFjdGljZSUyMGdvb2QlMjBoeWdpZW5lJTIwYW5kJTIwc2FuaXRhdGlvbi4lMjA3LiUyMFNlZWslMjBtZWRpY2FsJTIwYXR0ZW50aW9uJTIwaWYlMjB5b3UlMjBleHBlcmllbmNlJTIwYW55JTIwaGVhbHRoJTIwaXNzdWVzLiclMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(<span class="hljs-string">&#x27;how can I become more healthy?&#x27;</span>, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [ &#x27;To become more healthy, you can: 1. Eat a balanced diet with plenty of fruits, vegetables, whole grains, lean proteins, and healthy fats. 2. Stay hydrated by drinking plenty of water. 3. Get enough sleep and manage stress levels. 4. Avoid smoking and excessive alcohol consumption. 5. Regularly exercise and maintain a healthy weight. 6. Practice good hygiene and sanitation. 7. Seek medical attention if you experience any health issues.&#x27; ]</span>`,wrap:!1}}),Fe=new J({props:{title:"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>",local:"text2textgenerationpipelinecalltexts-options--code-promise--any--code",headingTag:"h3"}}),tt=new J({props:{title:"pipelines.SummarizationPipeline",local:"pipelinessummarizationpipeline",headingTag:"h2"}}),it=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, &#x27;</span> +
  <span class="hljs-string">&#x27;and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. &#x27;</span> +
  <span class="hljs-string">&#x27;During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest &#x27;</span> +
  <span class="hljs-string">&#x27;man-made structure in the world, a title it held for 41 years until the Chrysler Building in New &#x27;</span> +
  <span class="hljs-string">&#x27;York City was finished in 1930. It was the first structure to reach a height of 300 metres. Due to &#x27;</span> +
  <span class="hljs-string">&#x27;the addition of a broadcasting aerial at the top of the tower in 1957, it is now taller than the &#x27;</span> +
  <span class="hljs-string">&#x27;Chrysler Building by 5.2 metres (17 ft). Excluding transmitters, the Eiffel Tower is the second &#x27;</span> +
  <span class="hljs-string">&#x27;tallest free-standing structure in France after the Millau Viaduct.&#x27;</span>;

<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;summarization&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbart-cnn-6-6&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ summary_text: &#x27; The Eiffel Tower is about the same height as an 81-storey building and the tallest structure in Paris. It is the second tallest free-standing structure in France after the Millau Viaduct.&#x27; }]</span>`,wrap:!1}}),pt=new J({props:{title:"pipelines.TranslationPipeline",local:"pipelinestranslationpipeline",headingTag:"h2"}}),rt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTAlQTQlOUMlRTAlQTUlODAlRTAlQTQlQjUlRTAlQTQlQTglMjAlRTAlQTQlOEYlRTAlQTQlOTUlMjAlRTAlQTQlOUElRTAlQTUlODklRTAlQTQlOTUlRTAlQTQlQjIlRTAlQTUlODclRTAlQTQlOUYlMjAlRTAlQTQlQUMlRTAlQTUlODklRTAlQTQlOTUlRTAlQTUlOEQlRTAlQTQlQjglMjAlRTAlQTQlOTUlRTAlQTUlODAlMjAlRTAlQTQlQTQlRTAlQTQlQjAlRTAlQTQlQjklMjAlRTAlQTQlQjklRTAlQTUlODglRTAlQTUlQTQnJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnaGluX0RldmEnJTJDJTIwJTJGJTJGJTIwSGluZGklMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdmcmFfTGF0biclMkMlMjAlMkYlMkYlMjBGcmVuY2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMYSUyMHZpZSUyMGVzdCUyMGNvbW1lJTIwdW5lJTIwYm8lQzMlQUV0ZSUyMCVDMyVBMCUyMGNob2NvbGF0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;जीवन एक चॉकलेट बॉक्स की तरह है।&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hin_Deva&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fra_Latn&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;La vie est comme une boîte à chocolat.&#x27; }]</span>`,wrap:!1}}),Tt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtMm0xMDBfNDE4TScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTclOTQlOUYlRTYlQjQlQkIlRTUlQjAlQjElRTUlODMlOEYlRTQlQjglODAlRTclOUIlOTIlRTUlQjclQTclRTUlODUlOEIlRTUlOEElOUIlRTMlODAlODInJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnemgnJTJDJTIwJTJGJTJGJTIwQ2hpbmVzZSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuJyUyQyUyMCUyRiUyRiUyMEVuZ2xpc2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMaWZlJTIwaXMlMjBsaWtlJTIwYSUyMGJveCUyMG9mJTIwY2hvY29sYXRlLiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/m2m100_418M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;生活就像一盒巧克力。&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;zh&#x27;</span>, <span class="hljs-comment">// Chinese</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-comment">// English</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Life is like a box of chocolate.&#x27; }]</span>`,wrap:!1}}),Jt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zbGF0b3IoJyVFMCVBNCVCOCVFMCVBNCU4MiVFMCVBNCVBRiVFMCVBNSU4MSVFMCVBNCU5NSVFMCVBNSU4RCVFMCVBNCVBNCUyMCVFMCVBNCVCMCVFMCVBNCVCRSVFMCVBNCVCNyVFMCVBNSU4RCVFMCVBNCU5RiVFMCVBNSU4RCVFMCVBNCVCMCUyMCVFMCVBNCU5NSVFMCVBNSU4NyUyMCVFMCVBNCVBQSVFMCVBNSU4RCVFMCVBNCVCMCVFMCVBNCVBRSVFMCVBNSU4MSVFMCVBNCU5NiUyMCVFMCVBNCU5NSVFMCVBNCVCRSUyMCVFMCVBNCU5NSVFMCVBNCVCOSVFMCVBNCVBOCVFMCVBNCVCRSUyMCVFMCVBNCVCOSVFMCVBNSU4OCUyMCVFMCVBNCU5NSVFMCVBNCVCRiUyMCVFMCVBNCVCOCVFMCVBNSU4MCVFMCVBNCVCMCVFMCVBNCVCRiVFMCVBNCVBRiVFMCVBNCVCRSUyMCVFMCVBNCVBRSVFMCVBNSU4NyVFMCVBNCU4MiUyMCVFMCVBNCU5NSVFMCVBNSU4QiVFMCVBNCU4OCUyMCVFMCVBNCVCOCVFMCVBNSU4OCVFMCVBNCVBOCVFMCVBNSU4RCVFMCVBNCVBRiUyMCVFMCVBNCVCOCVFMCVBNCVBRSVFMCVBNCVCRSVFMCVBNCVBNyVFMCVBNCVCRSVFMCVBNCVBOCUyMCVFMCVBNCVBOCVFMCVBNCVCOSVFMCVBNSU4MCVFMCVBNCU4MiUyMCVFMCVBNCVCOSVFMCVBNSU4OCclMkMlMjAlN0IlMEElMjAlMjBzcmNfbGFuZyUzQSUyMCdoaV9JTiclMkMlMjAlMkYlMkYlMjBIaW5kaSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2ZyX1hYJyUyQyUyMCUyRiUyRiUyMEZyZW5jaCUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0xlJTIwY2hlZiUyMGRlcyUyME5hdGlvbnMlMjBhZmZpcm1lJTIwcXUlMjAnaWwlMjBuJTIwJ3klMjBhJTIwbWlsaXRhcnklMjBzb2x1dGlvbiUyMGluJTIwU3lyaWEuJyUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mbart-large-50-many-to-many-mmt&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;संयुक्त राष्ट्र के प्रमुख का कहना है कि सीरिया में कोई सैन्य समाधान नहीं है&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hi_IN&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fr_XX&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Le chef des Nations affirme qu &#x27;il n &#x27;y a military solution in Syria.&#x27; }]</span>`,wrap:!1}}),jt=new J({props:{title:"pipelines.TextGenerationPipeline",local:"pipelinestextgenerationpipeline",headingTag:"h2"}}),bt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyclM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxncHQyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodGV4dCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCUyMkklMjBlbmpveSUyMHdhbGtpbmclMjB3aXRoJTIwbXklMjBjdXRlJTIwZG9nJTJDJTIwYW5kJTIwSSUyMGxvdmUlMjB0byUyMHBsYXklMjB3aXRoJTIwdGhlJTIwb3RoZXIlMjBkb2dzLiUyMiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I enjoy walking with my cute dog,&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text);
<span class="hljs-comment">// [{ generated_text: &quot;I enjoy walking with my cute dog, and I love to play with the other dogs.&quot; }]</span>`,wrap:!1}}),Ct=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMnJTNCJTBBbGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtZ2VuZXJhdGlvbiclMkMlMjAnWGVub3ZhJTJGZGlzdGlsZ3B0MicpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjAlN0IlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDIlMkMlMEElMjAlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDEwJTJDJTBBJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNBJTIwMS41JTJDJTBBJTIwJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0ElMjAyJTJDJTBBJTIwJTIwbnVtX2JlYW1zJTNBJTIwMiUyQyUwQSUyMCUyMG51bV9yZXR1cm5fc2VxdWVuY2VzJTNBJTIwMiUyQyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJnZW5lcmF0ZWRfdGV4dCUyMiUzQSUyMCUyMk9uY2UlMjB1cG9uJTIwYSUyMHRpbWUlMkMlMjB0aGVyZSUyMHdhcyUyMGFuJTIwYWJ1bmRhbmNlJTIwb2YlMjBpbmZvcm1hdGlvbiUyMGFib3V0JTIwdGhlJTIwaGlzdG9yeSUyMGFuZCUyMGFjdGl2aXRpZXMlMjB0aGF0JTIyJTBBJTJGJTJGJTIwJTdEJTJDJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIyZ2VuZXJhdGVkX3RleHQlMjIlM0ElMjAlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMlMjBhbiUyMGFidW5kYW5jZSUyMG9mJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMHRoZSUyMG1vc3QlMjBpbXBvcnRhbnQlMjBhbmQlMjBpbmZsdWVudGlhbCUyMiUwQSUyRiUyRiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Once upon a time, there was&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, {
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">10</span>,
  <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">1.5</span>,
  <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_beams</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_return_sequences</span>: <span class="hljs-number">2</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the history and activities that&quot;</span>
<span class="hljs-comment">// }, {</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the most important and influential&quot;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),It=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdkZWYlMjBmaWIobiklM0EnJTNCJTBBbGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtZ2VuZXJhdGlvbiclMkMlMjAnWGVub3ZhJTJGY29kZWdlbi0zNTBNLW1vbm8nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjA0NCUyQyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCdkZWYlMjBmaWIobiklM0ElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBpZiUyMG4lMjAlM0QlM0QlMjAwJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwMCU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMGVsaWYlMjBuJTIwJTNEJTNEJTIwMSUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMDElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBlbHNlJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmliKG4tMSklMjAlMkIlMjBmaWIobi0yKSU1Q24nJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;def fib(n):&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/codegen-350M-mono&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">44</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   generated_text: &#x27;def fib(n):\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    if n == 0:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 0\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    elif n == 1:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 1\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    else:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return fib(n-1) + fib(n-2)\\n&#x27;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),Gt=new J({props:{title:"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>",local:"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code",headingTag:"h3"}}),At=new J({props:{title:"pipelines.ZeroShotClassificationPipeline",local:"pipelineszeroshotclassificationpipeline",headingTag:"h2"}}),Rt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdMYXN0JTIwd2VlayUyMEklMjB1cGdyYWRlZCUyMG15JTIwaU9TJTIwdmVyc2lvbiUyMGFuZCUyMGV2ZXIlMjBzaW5jZSUyMHRoZW4lMjBteSUyMHBob25lJTIwaGFzJTIwYmVlbiUyMG92ZXJoZWF0aW5nJTIwd2hlbmV2ZXIlMjBJJTIwdXNlJTIweW91ciUyMGFwcC4nJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ21vYmlsZSclMkMlMjAnYmlsbGluZyclMkMlMjAnd2Vic2l0ZSclMkMlMjAnYWNjb3VudCUyMGFjY2VzcyclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZtb2JpbGViZXJ0LXVuY2FzZWQtbW5saScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjBsYWJlbHMpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwc2VxdWVuY2UlM0ElMjAnTGFzdCUyMHdlZWslMjBJJTIwdXBncmFkZWQlMjBteSUyMGlPUyUyMHZlcnNpb24lMjBhbmQlMjBldmVyJTIwc2luY2UlMjB0aGVuJTIwbXklMjBwaG9uZSUyMGhhcyUyMGJlZW4lMjBvdmVyaGVhdGluZyUyMHdoZW5ldmVyJTIwSSUyMHVzZSUyMHlvdXIlMjBhcHAuJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVscyUzQSUyMCU1QiUyMCdtb2JpbGUnJTJDJTIwJ3dlYnNpdGUnJTJDJTIwJ2JpbGxpbmcnJTJDJTIwJ2FjY291bnQlMjBhY2Nlc3MnJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2NvcmVzJTNBJTIwJTVCJTIwMC41NTYyMDkxMDQwNDgyMDE4JTJDJTIwMC4xODQzNjIxMzA3ODYwODUzJTJDJTIwMC4xMzk0MjY0NjYzOTMzNjM3NiUyQyUyMDAuMTIwMDAyMjk4NzcyMzQ5MjMlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;mobile&#x27;</span>, <span class="hljs-string">&#x27;billing&#x27;</span>, <span class="hljs-string">&#x27;website&#x27;</span>, <span class="hljs-string">&#x27;account access&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mobilebert-uncased-mnli&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;mobile&#x27;, &#x27;website&#x27;, &#x27;billing&#x27;, &#x27;account access&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.5562091040482018, 0.1843621307860853, 0.13942646639336376, 0.12000229877234923 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Yt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEnJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ3VyZ2VudCclMkMlMjAnbm90JTIwdXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAndGFibGV0JyUyQyUyMCdjb21wdXRlciclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZubGktZGViZXJ0YS12My14c21hbGwnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwJTdCJTIwbXVsdGlfbGFiZWwlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHNlcXVlbmNlJTNBJTIwJ0klMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISclMkMlMEElMkYlMkYlMjAlMjAlMjBsYWJlbHMlM0ElMjAlNUIlMjAndXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAnY29tcHV0ZXInJTJDJTIwJ3RhYmxldCclMkMlMjAnbm90JTIwdXJnZW50JyUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHNjb3JlcyUzQSUyMCU1QiUyMDAuOTk1ODg3MDk1NjM2MDI3NSUyQyUyMDAuOTkyMzk2MzQwMDY5NzAzNSUyQyUyMDAuMDAyMzMzNTM3OTQ2MTYwMjM1JTJDJTIwMC4wMDE1MTM0MTM4NTY3NTk4NzY1JTJDJTIwMC4wMDEwNjk5Mzg0MjA4Mzc3MTYzJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nli-deberta-v3-xsmall&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels, { <span class="hljs-attr">multi_label</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;urgent&#x27;, &#x27;phone&#x27;, &#x27;computer&#x27;, &#x27;tablet&#x27;, &#x27;not urgent&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.9958870956360275, 0.9923963400697035, 0.002333537946160235, 0.0015134138567598765, 0.0010699384208377163 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Wt=new J({props:{title:"new ZeroShotClassificationPipeline(options)",local:"new-zeroshotclassificationpipelineoptions",headingTag:"h3"}}),Lt=new J({props:{title:"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code",headingTag:"h3"}}),Ot=new J({props:{title:"pipelines.FeatureExtractionPipeline",local:"pipelinesfeatureextractionpipeline",headingTag:"h2"}}),tl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDU5Mzk5MjQ3MTY5NDk0NjMlMkMlMjAwLjAyMTY1NTkzNTc5NDExNTA2NyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwOCUyQyUyMDc2OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.05939924716949463, 0.021655935794115067, ...],</span>
<span class="hljs-comment">//   dims: [1, 8, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),sl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wMzM3Mzc3ODk4Mzk1MDYxNSUyQyUyMC0wLjAxMDEwNjA3NzQxNzczMTI4NSUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwNzY4JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.03373778983950615, -0.010106077417731285, ...],</span>
<span class="hljs-comment">//   dims: [1, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),nl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wOTA5NDk4MjU5NDI1MTYzMyUyQyUyMC0wLjAxNDc3NDI0NjE0MTMxNDUwNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwMzg0JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.09094982594251633, -0.014774246141314507, ...],</span>
<span class="hljs-comment">//   dims: [1, 384]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ol=new J({props:{title:"featureExtractionPipeline._call(texts, options) ⇒",local:"featureextractionpipelinecalltexts-options-",headingTag:"h3"}}),ml=new J({props:{title:"pipelines.AudioClassificationPipeline",local:"pipelinesaudioclassificationpipeline",headingTag:"h2"}}),ul=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdWRpby1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGd2F2MnZlYzItbGFyZ2UteGxzci01My1nZW5kZXItcmVjb2duaXRpb24tbGlicmlzcGVlY2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuOTk4MTU0MjIyOTY1MjQwNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2ZlbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuMDAxODQ1NzQ3ODE0NTEzNzQzJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;male&#x27;, score: 0.9981542229652405 },</span>
<span class="hljs-comment">//   { label: &#x27;female&#x27;, score: 0.001845747814513743 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),jl=new J({props:{title:"new AudioClassificationPipeline(options)",local:"new-audioclassificationpipelineoptions",headingTag:"h3"}}),xl=new J({props:{title:"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code",headingTag:"h3"}}),Bl=new J({props:{title:"pipelines.AutomaticSpeechRecognitionPipeline",local:"pipelinesautomaticspeechrecognitionpipeline",headingTag:"h2"}}),Nl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-comment">// { text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot; }</span>`,wrap:!1}}),vl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTBBJTJGJTJGJTIwJTIwJTIwY2h1bmtzJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCMCUyQyUyMDglNUQlMkMlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTIyJTIwJTdEJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCOCUyQyUyMDExJTVEJTJDJTIwdGV4dCUzQSUyMCUyMiUyMGFzayUyMHdoYXQlMjB5b3UlMjBjYW4lMjBkbyUyMGZvciUyMHlvdXIlMjBjb3VudHJ5LiUyMiUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot;</span>
<span class="hljs-comment">//   chunks: [</span>
<span class="hljs-comment">//     { timestamp: [0, 8],  text: &quot; And so my fellow Americans ask not what your country can do for you&quot; }</span>
<span class="hljs-comment">//     { timestamp: [8, 11], text: &quot; ask what you can do for your country.&quot; }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),$l=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNBJTIwJ291dHB1dF9hdHRlbnRpb25zJyUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwJ3dvcmQnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UlMjBhc2slMjB3aGF0JTIweW91JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3VyJTIwY291bnRyeS4lMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJjaHVua3MlMjIlM0ElMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwQW5kJTIyJTJDJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwJTVCMCUyQyUyMDAuNzglNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwc28lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIwLjc4JTJDJTIwMS4wNiU1RCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBteSUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjEuMDYlMkMlMjAxLjQ2JTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMGZvciUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjkuNzIlMkMlMjA5LjkyJTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMHlvdXIlMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUI5LjkyJTJDJTIwMTAuMjIlNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwY291bnRyeS4lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIxMC4yMiUyQyUyMDEzLjUlNUQlMjAlN0QlMEElMkYlMkYlMjAlMjAlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-string">&#x27;word&#x27;</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;text&quot;: &quot; And so my fellow Americans ask not what your country can do for you ask what you can do for your country.&quot;,</span>
<span class="hljs-comment">//   &quot;chunks&quot;: [</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; And&quot;, &quot;timestamp&quot;: [0, 0.78] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; so&quot;, &quot;timestamp&quot;: [0.78, 1.06] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; my&quot;, &quot;timestamp&quot;: [1.06, 1.46] },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; for&quot;, &quot;timestamp&quot;: [9.72, 9.92] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; your&quot;, &quot;timestamp&quot;: [9.92, 10.22] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; country.&quot;, &quot;timestamp&quot;: [10.22, 13.5] }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Rl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2NyaWJlJyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwSidhZG9yZSUyQyUyMGonYWltZSUyQyUyMGplJTIwbidhaW1lJTIwcGFzJTJDJTIwamUlMjBkJUMzJUE5dGVzdGUuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;transcribe&#x27;</span> });
<span class="hljs-comment">// { text: &quot; J&#x27;adore, j&#x27;aime, je n&#x27;aime pas, je déteste.&quot; }</span>`,wrap:!1}}),Yl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2xhdGUnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBJJTIwbG92ZSUyQyUyMEklMjBsaWtlJTJDJTIwSSUyMGRvbid0JTIwbGlrZSUyQyUyMEklMjBoYXRlLiUyMiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;translate&#x27;</span> });
<span class="hljs-comment">// { text: &quot; I love, I like, I don&#x27;t like, I hate.&quot; }</span>`,wrap:!1}}),El=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0ZWRfNjAud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMGNodW5rX2xlbmd0aF9zJTNBJTIwMzAlMkMlMjBzdHJpZGVfbGVuZ3RoX3MlM0ElMjA1JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBTbyUyMGluJTIwY29sbGVnZSUyQyUyMEklMjB3YXMlMjBhJTIwZ292ZXJubWVudCUyMG1ham9yJTJDJTIwd2hpY2glMjBtZWFucyUyMCU1Qi4uLiU1RCUyMFNvJTIwSSdkJTIwc3RhcnQlMjBvZmYlMjBsaWdodCUyMGFuZCUyMEknZCUyMGJ1bXAlMjBpdCUyMHVwJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/ted_60.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">chunk_length_s</span>: <span class="hljs-number">30</span>, <span class="hljs-attr">stride_length_s</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// { text: &quot; So in college, I was a government major, which means [...] So I&#x27;d start off light and I&#x27;d bump it up&quot; }</span>`,wrap:!1}}),zl=new J({props:{title:"new AutomaticSpeechRecognitionPipeline(options)",local:"new-automaticspeechrecognitionpipelineoptions",headingTag:"h3"}}),Dl=new J({props:{title:"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>",local:"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code",headingTag:"h3"}}),ts=new J({props:{title:"pipelines.ImageToTextPipeline",local:"pipelinesimagetotextpipeline",headingTag:"h2"}}),is=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNhcHRpb25lcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnYSUyMGNhdCUyMGxheWluZyUyMG9uJTIwYSUyMGNvdWNoJTIwd2l0aCUyMGFub3RoZXIlMjBjYXQnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-gpt2-image-captioning&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;a cat laying on a couch with another cat&#x27; }]</span>`,wrap:!1}}),os=new J({props:{title:"new ImageToTextPipeline(options)",local:"new-imagetotextpipelineoptions",headingTag:"h3"}}),Ms=new J({props:{title:"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Js=new J({props:{title:"pipelines.ImageClassificationPipeline",local:"pipelinesimageclassificationpipeline",headingTag:"h2"}}),js=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0JsYWJlbCUzQSUyMCd0aWdlciUyQyUyMFBhbnRoZXJhJTIwdGlncmlzJyUyQyUyMHNjb3JlJTNBJTIwMC42MzI2OTU3MzQ1MDA4ODUlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),fs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAzJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">3</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),xs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAwJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ2phZ3VhciUyQyUyMHBhbnRoZXIlMkMlMjBQYW50aGVyYSUyMG9uY2ElMkMlMjBGZWxpcyUyMG9uY2EnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDM1NDY1NDk5OTY4MjY3OTc3JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">0</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">//   {label: &#x27;tiger cat&#x27;, score: 0.3634825646877289},</span>
<span class="hljs-comment">//   {label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707},</span>
<span class="hljs-comment">//   {label: &#x27;jaguar, panther, Panthera onca, Felis onca&#x27;, score: 0.00035465499968267977},</span>
<span class="hljs-comment">//   ...</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ks=new J({props:{title:"new ImageClassificationPipeline(options)",local:"new-imageclassificationpipelineoptions",headingTag:"h3"}}),Ns=new J({props:{title:"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>",local:"imageclassificationpipelinecallimages-options--code-promise--any--code",headingTag:"h3"}}),_s=new J({props:{title:"pipelines.ImageSegmentationPipeline",local:"pipelinesimagesegmentationpipeline",headingTag:"h2"}}),Ys=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBzZWdtZW50ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS1zZWdtZW50YXRpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHNlZ21lbnRlcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAncmVtb3RlJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg0NjQ5NDE5Nzg0NTQ2JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC45OTk0MzE2MTAxMDc0MjE5JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> segmenter = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-segmentation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50-panoptic&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">segmenter</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;remote&#x27;, score: 0.9984649419784546, mask: RawImage { ... } },</span>
<span class="hljs-comment">//   { label: &#x27;cat&#x27;, score: 0.9994316101074219, mask: RawImage { ... } }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ws=new J({props:{title:"new ImageSegmentationPipeline(options)",local:"new-imagesegmentationpipelineoptions",headingTag:"h3"}}),Ls=new J({props:{title:"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>",local:"imagesegmentationpipelinecallimages-options--code-promise--array--code",headingTag:"h3"}}),Ks=new J({props:{title:"pipelines.ZeroShotImageClassificationPipeline",local:"pipelineszeroshotimageclassificationpipeline",headingTag:"h2"}}),li=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3plcm8tc2hvdC1pbWFnZS1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJyklM0IlMEFsZXQlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyclM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodXJsJTJDJTIwJTVCJ3RpZ2VyJyUyQyUyMCdob3JzZSclMkMlMjAnZG9nJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5MzkxNzk0MjA0NzExOSUyQyUyMGxhYmVsJTNBJTIwJ3RpZ2VyJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHNjb3JlJTNBJTIwMC4wMDAzNTE5Mjk0ODQxNjgwNjc2JTJDJTIwbGFiZWwlM0ElMjAnaG9yc2UnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDI1NjI2OTg3OTE3MzQ4NzQlMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, [<span class="hljs-string">&#x27;tiger&#x27;</span>, <span class="hljs-string">&#x27;horse&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993917942047119, label: &#x27;tiger&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0003519294841680676, label: &#x27;horse&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0002562698791734874, label: &#x27;dog&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ai=new J({props:{title:"new ZeroShotImageClassificationPipeline(options)",local:"new-zeroshotimageclassificationpipelineoptions",headingTag:"h3"}}),ci=new J({props:{title:"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),yi=new J({props:{title:"pipelines.ObjectDetectionPipeline",local:"pipelinesobjectdetectionpipeline",headingTag:"h2"}}),hi=new h({props:{code:"bGV0JTIwaW1nJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEElMEFsZXQlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ29iamVjdC1kZXRlY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZyUyQyUyMCU3QiUyMHRocmVzaG9sZCUzQSUyMDAuOSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk3NjM3MDkzMDY3MTY5MiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIycmVtb3RlJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMxJTJDJTIwJTIyeW1pbiUyMiUzQSUyMDY4JTJDJTIwJTIyeG1heCUyMiUzQSUyMDE5MCUyQyUyMCUyMnltYXglMjIlM0ElMjAxMTglMjAlN0QlMEElMkYlMkYlMjAlN0QlMkMlMEElMkYlMkYlMjAuLi4lMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk4NDA5MjExNjM1NTg5NiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2F0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMzMSUyQyUyMCUyMnltaW4lMjIlM0ElMjAxOSUyQyUyMCUyMnhtYXglMjIlM0ElMjA2NDklMkMlMjAlMjJ5bWF4JTIyJTNBJTIwMzcxJTIwJTdEJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> img = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;

<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img, { <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.9</span> });
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9976370930671692,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;remote&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 31, &quot;ymin&quot;: 68, &quot;xmax&quot;: 190, &quot;ymax&quot;: 118 }</span>
<span class="hljs-comment">// },</span>
<span class="hljs-comment">// ...</span>
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9984092116355896,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;cat&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 331, &quot;ymin&quot;: 19, &quot;xmax&quot;: 649, &quot;ymax&quot;: 371 }</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),fi=new J({props:{title:"new ObjectDetectionPipeline(options)",local:"new-objectdetectionpipelineoptions",headingTag:"h3"}}),gi=new J({props:{title:"objectDetectionPipeline._call(images, options)",local:"objectdetectionpipelinecallimages-options",headingTag:"h3"}}),Qi=new J({props:{title:"pipelines.DocumentQuestionAnsweringPipeline",local:"pipelinesdocumentquestionansweringpipeline",headingTag:"h2"}}),vi=new h({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmludm9pY2UucG5nJyUzQiUwQWxldCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1doYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YnJTNCJTBBJTBBbGV0JTIwcWFfcGlwZWxpbmUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmcnJTJDJTIwJ1hlbm92YSUyRmRvbnV0LWJhc2UtZmluZXR1bmVkLWRvY3ZxYScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBxYV9waXBlbGluZShpbWFnZSUyQyUyMHF1ZXN0aW9uKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMGFuc3dlciUzQSUyMCd1cy0wMDEnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/invoice.png&#x27;</span>;
<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;What is the invoice number?&#x27;</span>;

<span class="hljs-keyword">let</span> qa_pipeline = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;document-question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/donut-base-finetuned-docvqa&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">qa_pipeline</span>(image, question);
<span class="hljs-comment">// [{ answer: &#x27;us-001&#x27; }]</span>`,wrap:!1}}),Ri=new J({props:{title:"new DocumentQuestionAnsweringPipeline(options)",local:"new-documentquestionansweringpipelineoptions",headingTag:"h3"}}),Ei=new J({props:{title:"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Xi=new J({props:{title:"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>",local:"pipelinespipelinetask-model-options--code-promise--pipeline--code",headingTag:"h2"}}),Ki=new J({props:{title:"pipelines~QuestionAnsweringResult : <code> object </code>",local:"pipelinesquestionansweringresult--code-object-code",headingTag:"h2"}}),sn=new J({props:{title:"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>",local:"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code",headingTag:"h2"}}),pn=new J({props:{title:"pipelines~ChunkCallback : <code> function </code>",local:"pipelineschunkcallback--code-function-code",headingTag:"h2"}}),{c(){w=a("meta"),Mn=i(),cn=a("p"),mn=i(),j=a("a"),Tn=i(),c(U.$$.fragment),yn=i(),f=a("p"),f.textContent=lm,un=i(),b=a("p"),b.innerHTML=sm,Jn=i(),c(x.$$.fragment),hn=i(),C=a("ul"),C.innerHTML=im,wn=i(),jn=a("hr"),Un=i(),g=a("a"),fn=i(),c(I.$$.fragment),bn=i(),k=a("p"),k.textContent=nm,xn=i(),B=a("p"),B.innerHTML=am,Cn=i(),G=a("ul"),G.innerHTML=pm,gn=i(),In=a("hr"),kn=i(),Q=a("a"),Bn=i(),c(N.$$.fragment),Gn=i(),Z=a("p"),Z.textContent=om,Qn=i(),v=a("table"),v.innerHTML=dm,Nn=i(),Zn=a("hr"),vn=i(),A=a("a"),An=i(),c($.$$.fragment),$n=i(),_=a("p"),_.textContent=cm,_n=i(),R=a("p"),R.innerHTML=rm,Rn=i(),Vn=a("hr"),Yn=i(),V=a("a"),Pn=i(),c(Y.$$.fragment),En=i(),P=a("p"),P.textContent=Mm,Hn=i(),E=a("p"),E.innerHTML=mm,Wn=i(),H=a("table"),H.innerHTML=Tm,Sn=i(),zn=a("hr"),Xn=i(),W=a("a"),Ln=i(),c(S.$$.fragment),Fn=i(),z=a("p"),z.innerHTML=ym,Dn=i(),X=a("p"),X.innerHTML=um,qn=i(),c(L.$$.fragment),On=i(),F=a("p"),F.innerHTML=Jm,Kn=i(),c(D.$$.fragment),ea=i(),q=a("p"),q.innerHTML=hm,ta=i(),c(O.$$.fragment),la=i(),K=a("p"),K.innerHTML=wm,sa=i(),ia=a("hr"),na=i(),ee=a("a"),aa=i(),c(te.$$.fragment),pa=i(),le=a("p"),le.textContent=jm,oa=i(),se=a("p"),se.innerHTML=Um,da=i(),ie=a("table"),ie.innerHTML=fm,ca=i(),ra=a("hr"),Ma=i(),ne=a("a"),ma=i(),c(ae.$$.fragment),Ta=i(),pe=a("p"),pe.innerHTML=bm,ya=i(),oe=a("p"),oe.innerHTML=xm,ua=i(),c(de.$$.fragment),Ja=i(),ce=a("p"),ce.innerHTML=Cm,ha=i(),c(re.$$.fragment),wa=i(),Me=a("p"),Me.innerHTML=gm,ja=i(),Ua=a("hr"),fa=i(),me=a("a"),ba=i(),c(Te.$$.fragment),xa=i(),ye=a("p"),ye.textContent=Im,Ca=i(),ue=a("p"),ue.innerHTML=km,ga=i(),Je=a("table"),Je.innerHTML=Bm,Ia=i(),ka=a("hr"),Ba=i(),he=a("a"),Ga=i(),c(we.$$.fragment),Qa=i(),je=a("p"),je.innerHTML=Gm,Na=i(),Ue=a("p"),Ue.innerHTML=Qm,Za=i(),c(fe.$$.fragment),va=i(),be=a("p"),be.innerHTML=Nm,Aa=i(),$a=a("hr"),_a=i(),xe=a("a"),Ra=i(),c(Ce.$$.fragment),Va=i(),ge=a("p"),ge.textContent=Zm,Ya=i(),Ie=a("p"),Ie.innerHTML=vm,Pa=i(),ke=a("table"),ke.innerHTML=Am,Ea=i(),Ha=a("hr"),Wa=i(),Be=a("a"),Sa=i(),c(Ge.$$.fragment),za=i(),Qe=a("p"),Qe.innerHTML=$m,Xa=i(),Ne=a("p"),Ne.innerHTML=_m,La=i(),c(Ze.$$.fragment),Fa=i(),ve=a("p"),ve.innerHTML=Rm,Da=i(),c(Ae.$$.fragment),qa=i(),$e=a("p"),$e.innerHTML=Vm,Oa=i(),Ka=a("hr"),ep=i(),_e=a("a"),tp=i(),c(Re.$$.fragment),lp=i(),Ve=a("p"),Ve.textContent=Ym,sp=i(),Ye=a("p"),Ye.innerHTML=Pm,ip=i(),Pe=a("table"),Pe.innerHTML=Em,np=i(),ap=a("hr"),pp=i(),Ee=a("a"),op=i(),c(He.$$.fragment),dp=i(),We=a("p"),We.textContent=Hm,cp=i(),Se=a("p"),Se.innerHTML=Wm,rp=i(),c(ze.$$.fragment),Mp=i(),Xe=a("p"),Xe.innerHTML=Sm,mp=i(),Tp=a("hr"),yp=i(),Le=a("a"),up=i(),c(Fe.$$.fragment),Jp=i(),De=a("p"),De.textContent=zm,hp=i(),qe=a("p"),qe.innerHTML=Xm,wp=i(),Oe=a("ul"),Oe.innerHTML=Lm,jp=i(),Ke=a("table"),Ke.innerHTML=Fm,Up=i(),fp=a("hr"),bp=i(),et=a("a"),xp=i(),c(tt.$$.fragment),Cp=i(),lt=a("p"),lt.textContent=Dm,gp=i(),st=a("p"),st.innerHTML=qm,Ip=i(),c(it.$$.fragment),kp=i(),nt=a("p"),nt.innerHTML=Om,Bp=i(),Gp=a("hr"),Qp=i(),at=a("a"),Np=i(),c(pt.$$.fragment),Zp=i(),ot=a("p"),ot.textContent=Km,vp=i(),dt=a("p"),dt.innerHTML=eT,Ap=i(),ct=a("p"),ct.innerHTML=tT,$p=i(),c(rt.$$.fragment),_p=i(),Mt=a("p"),Mt.innerHTML=lT,Rp=i(),mt=a("p"),mt.innerHTML=sT,Vp=i(),c(Tt.$$.fragment),Yp=i(),yt=a("p"),yt.innerHTML=iT,Pp=i(),ut=a("p"),ut.innerHTML=nT,Ep=i(),c(Jt.$$.fragment),Hp=i(),ht=a("p"),ht.innerHTML=aT,Wp=i(),Sp=a("hr"),zp=i(),wt=a("a"),Xp=i(),c(jt.$$.fragment),Lp=i(),Ut=a("p"),Ut.innerHTML=pT,Fp=i(),ft=a("p"),ft.innerHTML=oT,Dp=i(),c(bt.$$.fragment),qp=i(),xt=a("p"),xt.innerHTML=dT,Op=i(),c(Ct.$$.fragment),Kp=i(),gt=a("p"),gt.innerHTML=cT,eo=i(),c(It.$$.fragment),to=i(),kt=a("p"),kt.innerHTML=rT,lo=i(),so=a("hr"),io=i(),Bt=a("a"),no=i(),c(Gt.$$.fragment),ao=i(),Qt=a("p"),Qt.textContent=MT,po=i(),Nt=a("p"),Nt.innerHTML=mT,oo=i(),Zt=a("table"),Zt.innerHTML=TT,co=i(),ro=a("hr"),Mo=i(),vt=a("a"),mo=i(),c(At.$$.fragment),To=i(),$t=a("p"),$t.innerHTML=yT,yo=i(),_t=a("p"),_t.innerHTML=uT,uo=i(),c(Rt.$$.fragment),Jo=i(),Vt=a("p"),Vt.innerHTML=JT,ho=i(),c(Yt.$$.fragment),wo=i(),Pt=a("p"),Pt.innerHTML=hT,jo=i(),Et=a("ul"),Et.innerHTML=wT,Uo=i(),fo=a("hr"),bo=i(),Ht=a("a"),xo=i(),c(Wt.$$.fragment),Co=i(),St=a("p"),St.textContent=jT,go=i(),zt=a("table"),zt.innerHTML=UT,Io=i(),ko=a("hr"),Bo=i(),Xt=a("a"),Go=i(),c(Lt.$$.fragment),Qo=i(),Ft=a("p"),Ft.innerHTML=fT,No=i(),Dt=a("table"),Dt.innerHTML=bT,Zo=i(),vo=a("hr"),Ao=i(),qt=a("a"),$o=i(),c(Ot.$$.fragment),_o=i(),Kt=a("p"),Kt.textContent=xT,Ro=i(),el=a("p"),el.innerHTML=CT,Vo=i(),c(tl.$$.fragment),Yo=i(),ll=a("p"),ll.innerHTML=gT,Po=i(),c(sl.$$.fragment),Eo=i(),il=a("p"),il.innerHTML=IT,Ho=i(),c(nl.$$.fragment),Wo=i(),al=a("p"),al.innerHTML=kT,So=i(),zo=a("hr"),Xo=i(),pl=a("a"),Lo=i(),c(ol.$$.fragment),Fo=i(),dl=a("p"),dl.textContent=BT,Do=i(),cl=a("p"),cl.innerHTML=GT,qo=i(),rl=a("table"),rl.innerHTML=QT,Oo=i(),Ko=a("hr"),ed=i(),Ml=a("a"),td=i(),c(ml.$$.fragment),ld=i(),Tl=a("p"),Tl.innerHTML=NT,sd=i(),yl=a("p"),yl.innerHTML=ZT,id=i(),c(ul.$$.fragment),nd=i(),Jl=a("p"),Jl.innerHTML=vT,ad=i(),hl=a("ul"),hl.innerHTML=AT,pd=i(),od=a("hr"),dd=i(),wl=a("a"),cd=i(),c(jl.$$.fragment),rd=i(),Ul=a("p"),Ul.textContent=$T,Md=i(),fl=a("table"),fl.innerHTML=_T,md=i(),Td=a("hr"),yd=i(),bl=a("a"),ud=i(),c(xl.$$.fragment),Jd=i(),Cl=a("p"),Cl.textContent=RT,hd=i(),gl=a("p"),gl.innerHTML=VT,wd=i(),Il=a("table"),Il.innerHTML=YT,jd=i(),Ud=a("hr"),fd=i(),kl=a("a"),bd=i(),c(Bl.$$.fragment),xd=i(),Gl=a("p"),Gl.textContent=PT,Cd=i(),Ql=a("p"),Ql.innerHTML=ET,gd=i(),c(Nl.$$.fragment),Id=i(),Zl=a("p"),Zl.innerHTML=HT,kd=i(),c(vl.$$.fragment),Bd=i(),Al=a("p"),Al.innerHTML=WT,Gd=i(),c($l.$$.fragment),Qd=i(),_l=a("p"),_l.innerHTML=ST,Nd=i(),c(Rl.$$.fragment),Zd=i(),Vl=a("p"),Vl.innerHTML=zT,vd=i(),c(Yl.$$.fragment),Ad=i(),Pl=a("p"),Pl.innerHTML=XT,$d=i(),c(El.$$.fragment),_d=i(),Hl=a("p"),Hl.innerHTML=LT,Rd=i(),Wl=a("ul"),Wl.innerHTML=FT,Vd=i(),Yd=a("hr"),Pd=i(),Sl=a("a"),Ed=i(),c(zl.$$.fragment),Hd=i(),Xl=a("p"),Xl.textContent=DT,Wd=i(),Ll=a("table"),Ll.innerHTML=qT,Sd=i(),zd=a("hr"),Xd=i(),Fl=a("a"),Ld=i(),c(Dl.$$.fragment),Fd=i(),ql=a("p"),ql.textContent=OT,Dd=i(),Ol=a("p"),Ol.innerHTML=KT,qd=i(),Kl=a("table"),Kl.innerHTML=ey,Od=i(),Kd=a("hr"),ec=i(),es=a("a"),tc=i(),c(ts.$$.fragment),lc=i(),ls=a("p"),ls.innerHTML=ty,sc=i(),ss=a("p"),ss.innerHTML=ly,ic=i(),c(is.$$.fragment),nc=i(),ns=a("p"),ns.innerHTML=sy,ac=i(),as=a("ul"),as.innerHTML=iy,pc=i(),oc=a("hr"),dc=i(),ps=a("a"),cc=i(),c(os.$$.fragment),rc=i(),ds=a("p"),ds.textContent=ny,Mc=i(),cs=a("table"),cs.innerHTML=ay,mc=i(),Tc=a("hr"),yc=i(),rs=a("a"),uc=i(),c(Ms.$$.fragment),Jc=i(),ms=a("p"),ms.textContent=py,hc=i(),Ts=a("p"),Ts.innerHTML=oy,wc=i(),ys=a("table"),ys.innerHTML=dy,jc=i(),Uc=a("hr"),fc=i(),us=a("a"),bc=i(),c(Js.$$.fragment),xc=i(),hs=a("p"),hs.innerHTML=cy,Cc=i(),ws=a("p"),ws.innerHTML=ry,gc=i(),c(js.$$.fragment),Ic=i(),Us=a("p"),Us.innerHTML=My,kc=i(),c(fs.$$.fragment),Bc=i(),bs=a("p"),bs.innerHTML=my,Gc=i(),c(xs.$$.fragment),Qc=i(),Cs=a("p"),Cs.innerHTML=Ty,Nc=i(),gs=a("ul"),gs.innerHTML=yy,Zc=i(),vc=a("hr"),Ac=i(),Is=a("a"),$c=i(),c(ks.$$.fragment),_c=i(),Bs=a("p"),Bs.textContent=uy,Rc=i(),Gs=a("table"),Gs.innerHTML=Jy,Vc=i(),Yc=a("hr"),Pc=i(),Qs=a("a"),Ec=i(),c(Ns.$$.fragment),Hc=i(),Zs=a("p"),Zs.textContent=hy,Wc=i(),vs=a("p"),vs.innerHTML=wy,Sc=i(),As=a("table"),As.innerHTML=jy,zc=i(),Xc=a("hr"),Lc=i(),$s=a("a"),Fc=i(),c(_s.$$.fragment),Dc=i(),Rs=a("p"),Rs.innerHTML=Uy,qc=i(),Vs=a("p"),Vs.innerHTML=fy,Oc=i(),c(Ys.$$.fragment),Kc=i(),Ps=a("p"),Ps.innerHTML=by,er=i(),Es=a("ul"),Es.innerHTML=xy,tr=i(),lr=a("hr"),sr=i(),Hs=a("a"),ir=i(),c(Ws.$$.fragment),nr=i(),Ss=a("p"),Ss.textContent=Cy,ar=i(),zs=a("table"),zs.innerHTML=gy,pr=i(),or=a("hr"),dr=i(),Xs=a("a"),cr=i(),c(Ls.$$.fragment),rr=i(),Fs=a("p"),Fs.textContent=Iy,Mr=i(),Ds=a("p"),Ds.innerHTML=ky,mr=i(),qs=a("table"),qs.innerHTML=By,Tr=i(),yr=a("hr"),ur=i(),Os=a("a"),Jr=i(),c(Ks.$$.fragment),hr=i(),ei=a("p"),ei.innerHTML=Gy,wr=i(),ti=a("p"),ti.innerHTML=Qy,jr=i(),c(li.$$.fragment),Ur=i(),si=a("p"),si.innerHTML=Ny,fr=i(),ii=a("ul"),ii.innerHTML=Zy,br=i(),xr=a("hr"),Cr=i(),ni=a("a"),gr=i(),c(ai.$$.fragment),Ir=i(),pi=a("p"),pi.textContent=vy,kr=i(),oi=a("table"),oi.innerHTML=Ay,Br=i(),Gr=a("hr"),Qr=i(),di=a("a"),Nr=i(),c(ci.$$.fragment),Zr=i(),ri=a("p"),ri.textContent=$y,vr=i(),Mi=a("p"),Mi.innerHTML=_y,Ar=i(),mi=a("table"),mi.innerHTML=Ry,$r=i(),_r=a("hr"),Rr=i(),Ti=a("a"),Vr=i(),c(yi.$$.fragment),Yr=i(),ui=a("p"),ui.innerHTML=Vy,Pr=i(),Ji=a("p"),Ji.innerHTML=Yy,Er=i(),c(hi.$$.fragment),Hr=i(),wi=a("p"),wi.innerHTML=Py,Wr=i(),ji=a("ul"),ji.innerHTML=Ey,Sr=i(),zr=a("hr"),Xr=i(),Ui=a("a"),Lr=i(),c(fi.$$.fragment),Fr=i(),bi=a("p"),bi.textContent=Hy,Dr=i(),xi=a("table"),xi.innerHTML=Wy,qr=i(),Or=a("hr"),Kr=i(),Ci=a("a"),eM=i(),c(gi.$$.fragment),tM=i(),Ii=a("p"),Ii.textContent=Sy,lM=i(),ki=a("p"),ki.innerHTML=zy,sM=i(),Bi=a("table"),Bi.innerHTML=Xy,iM=i(),nM=a("hr"),aM=i(),Gi=a("a"),pM=i(),c(Qi.$$.fragment),oM=i(),Ni=a("p"),Ni.innerHTML=Ly,dM=i(),Zi=a("p"),Zi.innerHTML=Fy,cM=i(),c(vi.$$.fragment),rM=i(),Ai=a("p"),Ai.innerHTML=Dy,MM=i(),$i=a("ul"),$i.innerHTML=qy,mM=i(),TM=a("hr"),yM=i(),_i=a("a"),uM=i(),c(Ri.$$.fragment),JM=i(),Vi=a("p"),Vi.textContent=Oy,hM=i(),Yi=a("table"),Yi.innerHTML=Ky,wM=i(),jM=a("hr"),UM=i(),Pi=a("a"),fM=i(),c(Ei.$$.fragment),bM=i(),Hi=a("p"),Hi.textContent=eu,xM=i(),Wi=a("p"),Wi.innerHTML=tu,CM=i(),Si=a("table"),Si.innerHTML=lu,gM=i(),IM=a("hr"),kM=i(),zi=a("a"),BM=i(),c(Xi.$$.fragment),GM=i(),Li=a("p"),Li.innerHTML=su,QM=i(),Fi=a("p"),Fi.innerHTML=iu,NM=i(),Di=a("ul"),Di.innerHTML=nu,ZM=i(),qi=a("table"),qi.innerHTML=au,vM=i(),AM=a("hr"),$M=i(),Oi=a("a"),_M=i(),c(Ki.$$.fragment),RM=i(),en=a("p"),en.innerHTML=pu,VM=i(),tn=a("table"),tn.innerHTML=ou,YM=i(),PM=a("hr"),EM=i(),ln=a("a"),HM=i(),c(sn.$$.fragment),WM=i(),nn=a("p"),nn.innerHTML=du,SM=i(),zM=a("hr"),XM=i(),an=a("a"),LM=i(),c(pn.$$.fragment),FM=i(),on=a("p"),on.innerHTML=cu,DM=i(),dn=a("table"),dn.innerHTML=ru,qM=i(),OM=a("hr"),KM=i(),rn=a("p"),this.h()},l(e){const t=Ju("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(l),Mn=n(e),cn=p(e,"P",{}),u(cn).forEach(l),mn=n(e),j=p(e,"A",{id:!0,class:!0}),u(j).forEach(l),Tn=n(e),r(U.$$.fragment,e),yn=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1inm2t9"&&(f.textContent=lm),un=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pjech"&&(b.innerHTML=sm),Jn=n(e),r(x.$$.fragment,e),hn=n(e),C=p(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-7ezcbi"&&(C.innerHTML=im),wn=n(e),jn=p(e,"HR",{}),Un=n(e),g=p(e,"A",{id:!0,class:!0}),u(g).forEach(l),fn=n(e),r(I.$$.fragment,e),bn=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-16ix8v2"&&(k.textContent=nm),xn=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1olpg2f"&&(B.innerHTML=am),Cn=n(e),G=p(e,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-1wo4saj"&&(G.innerHTML=pm),gn=n(e),In=p(e,"HR",{}),kn=n(e),Q=p(e,"A",{id:!0,class:!0}),u(Q).forEach(l),Bn=n(e),r(N.$$.fragment,e),Gn=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-10jkwj"&&(Z.textContent=om),Qn=n(e),v=p(e,"TABLE",{"data-svelte-h":!0}),o(v)!=="svelte-13q0syp"&&(v.innerHTML=dm),Nn=n(e),Zn=p(e,"HR",{}),vn=n(e),A=p(e,"A",{id:!0,class:!0}),u(A).forEach(l),An=n(e),r($.$$.fragment,e),$n=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1yhr8qe"&&(_.textContent=cm),_n=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1yqombv"&&(R.innerHTML=rm),Rn=n(e),Vn=p(e,"HR",{}),Yn=n(e),V=p(e,"A",{id:!0,class:!0}),u(V).forEach(l),Pn=n(e),r(Y.$$.fragment,e),En=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-phuke9"&&(P.textContent=Mm),Hn=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1xajepz"&&(E.innerHTML=mm),Wn=n(e),H=p(e,"TABLE",{"data-svelte-h":!0}),o(H)!=="svelte-1dl6le6"&&(H.innerHTML=Tm),Sn=n(e),zn=p(e,"HR",{}),Xn=n(e),W=p(e,"A",{id:!0,class:!0}),u(W).forEach(l),Ln=n(e),r(S.$$.fragment,e),Fn=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1aega0x"&&(z.innerHTML=ym),Dn=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-twv4w2"&&(X.innerHTML=um),qn=n(e),r(L.$$.fragment,e),On=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-9l8wqs"&&(F.innerHTML=Jm),Kn=n(e),r(D.$$.fragment,e),ea=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-63pkoo"&&(q.innerHTML=hm),ta=n(e),r(O.$$.fragment,e),la=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-s10qq4"&&(K.innerHTML=wm),sa=n(e),ia=p(e,"HR",{}),na=n(e),ee=p(e,"A",{id:!0,class:!0}),u(ee).forEach(l),aa=n(e),r(te.$$.fragment,e),pa=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-319swt"&&(le.textContent=jm),oa=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vshn55"&&(se.innerHTML=Um),da=n(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),o(ie)!=="svelte-mqkhxk"&&(ie.innerHTML=fm),ca=n(e),ra=p(e,"HR",{}),Ma=n(e),ne=p(e,"A",{id:!0,class:!0}),u(ne).forEach(l),ma=n(e),r(ae.$$.fragment,e),Ta=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-199l8oj"&&(pe.innerHTML=bm),ya=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-3ojewp"&&(oe.innerHTML=xm),ua=n(e),r(de.$$.fragment,e),Ja=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ln7q61"&&(ce.innerHTML=Cm),ha=n(e),r(re.$$.fragment,e),wa=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-s10qq4"&&(Me.innerHTML=gm),ja=n(e),Ua=p(e,"HR",{}),fa=n(e),me=p(e,"A",{id:!0,class:!0}),u(me).forEach(l),ba=n(e),r(Te.$$.fragment,e),xa=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-qfvk6r"&&(ye.textContent=Im),Ca=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1tvkl0p"&&(ue.innerHTML=km),ga=n(e),Je=p(e,"TABLE",{"data-svelte-h":!0}),o(Je)!=="svelte-1p6smdx"&&(Je.innerHTML=Bm),Ia=n(e),ka=p(e,"HR",{}),Ba=n(e),he=p(e,"A",{id:!0,class:!0}),u(he).forEach(l),Ga=n(e),r(we.$$.fragment,e),Qa=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-14f3xkz"&&(je.innerHTML=Gm),Na=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-o2pgcr"&&(Ue.innerHTML=Qm),Za=n(e),r(fe.$$.fragment,e),va=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-s10qq4"&&(be.innerHTML=Nm),Aa=n(e),$a=p(e,"HR",{}),_a=n(e),xe=p(e,"A",{id:!0,class:!0}),u(xe).forEach(l),Ra=n(e),r(Ce.$$.fragment,e),Va=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-v1s8i"&&(ge.textContent=Zm),Ya=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jet258"&&(Ie.innerHTML=vm),Pa=n(e),ke=p(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-dmekw3"&&(ke.innerHTML=Am),Ea=n(e),Ha=p(e,"HR",{}),Wa=n(e),Be=p(e,"A",{id:!0,class:!0}),u(Be).forEach(l),Sa=n(e),r(Ge.$$.fragment,e),za=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-nzjx48"&&(Qe.innerHTML=$m),Xa=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1xict4f"&&(Ne.innerHTML=_m),La=n(e),r(Ze.$$.fragment,e),Fa=n(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1sz7ava"&&(ve.innerHTML=Rm),Da=n(e),r(Ae.$$.fragment,e),qa=n(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-s10qq4"&&($e.innerHTML=Vm),Oa=n(e),Ka=p(e,"HR",{}),ep=n(e),_e=p(e,"A",{id:!0,class:!0}),u(_e).forEach(l),tp=n(e),r(Re.$$.fragment,e),lp=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1dgb1r"&&(Ve.textContent=Ym),sp=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-ht5bcu"&&(Ye.innerHTML=Pm),ip=n(e),Pe=p(e,"TABLE",{"data-svelte-h":!0}),o(Pe)!=="svelte-dhvci0"&&(Pe.innerHTML=Em),np=n(e),ap=p(e,"HR",{}),pp=n(e),Ee=p(e,"A",{id:!0,class:!0}),u(Ee).forEach(l),op=n(e),r(He.$$.fragment,e),dp=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-e2spcq"&&(We.textContent=Hm),cp=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-j4hwgn"&&(Se.innerHTML=Wm),rp=n(e),r(ze.$$.fragment,e),Mp=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-s10qq4"&&(Xe.innerHTML=Sm),mp=n(e),Tp=p(e,"HR",{}),yp=n(e),Le=p(e,"A",{id:!0,class:!0}),u(Le).forEach(l),up=n(e),r(Fe.$$.fragment,e),Jp=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1dgb1r"&&(De.textContent=zm),hp=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-k5n4xx"&&(qe.innerHTML=Xm),wp=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),o(Oe)!=="svelte-wmzf9w"&&(Oe.innerHTML=Lm),jp=n(e),Ke=p(e,"TABLE",{"data-svelte-h":!0}),o(Ke)!=="svelte-18cf78d"&&(Ke.innerHTML=Fm),Up=n(e),fp=p(e,"HR",{}),bp=n(e),et=p(e,"A",{id:!0,class:!0}),u(et).forEach(l),xp=n(e),r(tt.$$.fragment,e),Cp=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1axdht2"&&(lt.textContent=Dm),gp=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1416cqx"&&(st.innerHTML=qm),Ip=n(e),r(it.$$.fragment,e),kp=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-s10qq4"&&(nt.innerHTML=Om),Bp=n(e),Gp=p(e,"HR",{}),Qp=n(e),at=p(e,"A",{id:!0,class:!0}),u(at).forEach(l),Np=n(e),r(pt.$$.fragment,e),Zp=n(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-3abd20"&&(ot.textContent=Km),vp=n(e),dt=p(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1ut0vme"&&(dt.innerHTML=eT),Ap=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-dr1wsd"&&(ct.innerHTML=tT),$p=n(e),r(rt.$$.fragment,e),_p=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-mqh15a"&&(Mt.innerHTML=lT),Rp=n(e),mt=p(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-zf4dht"&&(mt.innerHTML=sT),Vp=n(e),r(Tt.$$.fragment,e),Yp=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1877ohf"&&(yt.innerHTML=iT),Pp=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1ox1juk"&&(ut.innerHTML=nT),Ep=n(e),r(Jt.$$.fragment,e),Hp=n(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-s10qq4"&&(ht.innerHTML=aT),Wp=n(e),Sp=p(e,"HR",{}),zp=n(e),wt=p(e,"A",{id:!0,class:!0}),u(wt).forEach(l),Xp=n(e),r(jt.$$.fragment,e),Lp=n(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1yek3op"&&(Ut.innerHTML=pT),Fp=n(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-11p32pq"&&(ft.innerHTML=oT),Dp=n(e),r(bt.$$.fragment,e),qp=n(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1uqom1e"&&(xt.innerHTML=dT),Op=n(e),r(Ct.$$.fragment,e),Kp=n(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1a7k67n"&&(gt.innerHTML=cT),eo=n(e),r(It.$$.fragment,e),to=n(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-s10qq4"&&(kt.innerHTML=rT),lo=n(e),so=p(e,"HR",{}),io=n(e),Bt=p(e,"A",{id:!0,class:!0}),u(Bt).forEach(l),no=n(e),r(Gt.$$.fragment,e),ao=n(e),Qt=p(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-6m3xhk"&&(Qt.textContent=MT),po=n(e),Nt=p(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1f5btis"&&(Nt.innerHTML=mT),oo=n(e),Zt=p(e,"TABLE",{"data-svelte-h":!0}),o(Zt)!=="svelte-5kvkn6"&&(Zt.innerHTML=TT),co=n(e),ro=p(e,"HR",{}),Mo=n(e),vt=p(e,"A",{id:!0,class:!0}),u(vt).forEach(l),mo=n(e),r(At.$$.fragment,e),To=n(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-104v5zf"&&($t.innerHTML=yT),yo=n(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-17n9q32"&&(_t.innerHTML=uT),uo=n(e),r(Rt.$$.fragment,e),Jo=n(e),Vt=p(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-v99qry"&&(Vt.innerHTML=JT),ho=n(e),r(Yt.$$.fragment,e),wo=n(e),Pt=p(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-s10qq4"&&(Pt.innerHTML=hT),jo=n(e),Et=p(e,"UL",{"data-svelte-h":!0}),o(Et)!=="svelte-svwcak"&&(Et.innerHTML=wT),Uo=n(e),fo=p(e,"HR",{}),bo=n(e),Ht=p(e,"A",{id:!0,class:!0}),u(Ht).forEach(l),xo=n(e),r(Wt.$$.fragment,e),Co=n(e),St=p(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-1n1xlcl"&&(St.textContent=jT),go=n(e),zt=p(e,"TABLE",{"data-svelte-h":!0}),o(zt)!=="svelte-1h8f"&&(zt.innerHTML=UT),Io=n(e),ko=p(e,"HR",{}),Bo=n(e),Xt=p(e,"A",{id:!0,class:!0}),u(Xt).forEach(l),Go=n(e),r(Lt.$$.fragment,e),Qo=n(e),Ft=p(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-c8gx4u"&&(Ft.innerHTML=fT),No=n(e),Dt=p(e,"TABLE",{"data-svelte-h":!0}),o(Dt)!=="svelte-y9oo3q"&&(Dt.innerHTML=bT),Zo=n(e),vo=p(e,"HR",{}),Ao=n(e),qt=p(e,"A",{id:!0,class:!0}),u(qt).forEach(l),$o=n(e),r(Ot.$$.fragment,e),_o=n(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-tzucv0"&&(Kt.textContent=xT),Ro=n(e),el=p(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-zrdgvs"&&(el.innerHTML=CT),Vo=n(e),r(tl.$$.fragment,e),Yo=n(e),ll=p(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-et9i9m"&&(ll.innerHTML=gT),Po=n(e),r(sl.$$.fragment,e),Eo=n(e),il=p(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-162t9ct"&&(il.innerHTML=IT),Ho=n(e),r(nl.$$.fragment,e),Wo=n(e),al=p(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-s10qq4"&&(al.innerHTML=kT),So=n(e),zo=p(e,"HR",{}),Xo=n(e),pl=p(e,"A",{id:!0,class:!0}),u(pl).forEach(l),Lo=n(e),r(ol.$$.fragment,e),Fo=n(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-11eoigb"&&(dl.textContent=BT),Do=n(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-un4fzt"&&(cl.innerHTML=GT),qo=n(e),rl=p(e,"TABLE",{"data-svelte-h":!0}),o(rl)!=="svelte-1qj38gf"&&(rl.innerHTML=QT),Oo=n(e),Ko=p(e,"HR",{}),ed=n(e),Ml=p(e,"A",{id:!0,class:!0}),u(Ml).forEach(l),td=n(e),r(ml.$$.fragment,e),ld=n(e),Tl=p(e,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-9xhkxa"&&(Tl.innerHTML=NT),sd=n(e),yl=p(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-gobmso"&&(yl.innerHTML=ZT),id=n(e),r(ul.$$.fragment,e),nd=n(e),Jl=p(e,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-s10qq4"&&(Jl.innerHTML=vT),ad=n(e),hl=p(e,"UL",{"data-svelte-h":!0}),o(hl)!=="svelte-fjr04l"&&(hl.innerHTML=AT),pd=n(e),od=p(e,"HR",{}),dd=n(e),wl=p(e,"A",{id:!0,class:!0}),u(wl).forEach(l),cd=n(e),r(jl.$$.fragment,e),rd=n(e),Ul=p(e,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1enract"&&(Ul.textContent=$T),Md=n(e),fl=p(e,"TABLE",{"data-svelte-h":!0}),o(fl)!=="svelte-dgeggs"&&(fl.innerHTML=_T),md=n(e),Td=p(e,"HR",{}),yd=n(e),bl=p(e,"A",{id:!0,class:!0}),u(bl).forEach(l),ud=n(e),r(xl.$$.fragment,e),Jd=n(e),Cl=p(e,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-19qhuwa"&&(Cl.textContent=RT),hd=n(e),gl=p(e,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1gq3dbn"&&(gl.innerHTML=VT),wd=n(e),Il=p(e,"TABLE",{"data-svelte-h":!0}),o(Il)!=="svelte-17m2nm1"&&(Il.innerHTML=YT),jd=n(e),Ud=p(e,"HR",{}),fd=n(e),kl=p(e,"A",{id:!0,class:!0}),u(kl).forEach(l),bd=n(e),r(Bl.$$.fragment,e),xd=n(e),Gl=p(e,"P",{"data-svelte-h":!0}),o(Gl)!=="svelte-vm8asa"&&(Gl.textContent=PT),Cd=n(e),Ql=p(e,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-p9nqmy"&&(Ql.innerHTML=ET),gd=n(e),r(Nl.$$.fragment,e),Id=n(e),Zl=p(e,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-1xb4yln"&&(Zl.innerHTML=HT),kd=n(e),r(vl.$$.fragment,e),Bd=n(e),Al=p(e,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-aly754"&&(Al.innerHTML=WT),Gd=n(e),r($l.$$.fragment,e),Qd=n(e),_l=p(e,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-127z1r2"&&(_l.innerHTML=ST),Nd=n(e),r(Rl.$$.fragment,e),Zd=n(e),Vl=p(e,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-5ad2vc"&&(Vl.innerHTML=zT),vd=n(e),r(Yl.$$.fragment,e),Ad=n(e),Pl=p(e,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-1ybp4y9"&&(Pl.innerHTML=XT),$d=n(e),r(El.$$.fragment,e),_d=n(e),Hl=p(e,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-s10qq4"&&(Hl.innerHTML=LT),Rd=n(e),Wl=p(e,"UL",{"data-svelte-h":!0}),o(Wl)!=="svelte-32csn1"&&(Wl.innerHTML=FT),Vd=n(e),Yd=p(e,"HR",{}),Pd=n(e),Sl=p(e,"A",{id:!0,class:!0}),u(Sl).forEach(l),Ed=n(e),r(zl.$$.fragment,e),Hd=n(e),Xl=p(e,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-1kkefov"&&(Xl.textContent=DT),Wd=n(e),Ll=p(e,"TABLE",{"data-svelte-h":!0}),o(Ll)!=="svelte-1a94q5m"&&(Ll.innerHTML=qT),Sd=n(e),zd=p(e,"HR",{}),Xd=n(e),Fl=p(e,"A",{id:!0,class:!0}),u(Fl).forEach(l),Ld=n(e),r(Dl.$$.fragment,e),Fd=n(e),ql=p(e,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-d8vj38"&&(ql.textContent=OT),Dd=n(e),Ol=p(e,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-hgdjqs"&&(Ol.innerHTML=KT),qd=n(e),Kl=p(e,"TABLE",{"data-svelte-h":!0}),o(Kl)!=="svelte-1usuiaq"&&(Kl.innerHTML=ey),Od=n(e),Kd=p(e,"HR",{}),ec=n(e),es=p(e,"A",{id:!0,class:!0}),u(es).forEach(l),tc=n(e),r(ts.$$.fragment,e),lc=n(e),ls=p(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-yuzbfo"&&(ls.innerHTML=ty),sc=n(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-gwolyd"&&(ss.innerHTML=ly),ic=n(e),r(is.$$.fragment,e),nc=n(e),ns=p(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-s10qq4"&&(ns.innerHTML=sy),ac=n(e),as=p(e,"UL",{"data-svelte-h":!0}),o(as)!=="svelte-3k2o01"&&(as.innerHTML=iy),pc=n(e),oc=p(e,"HR",{}),dc=n(e),ps=p(e,"A",{id:!0,class:!0}),u(ps).forEach(l),cc=n(e),r(os.$$.fragment,e),rc=n(e),ds=p(e,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-10qze5e"&&(ds.textContent=ny),Mc=n(e),cs=p(e,"TABLE",{"data-svelte-h":!0}),o(cs)!=="svelte-1a94q5m"&&(cs.innerHTML=ay),mc=n(e),Tc=p(e,"HR",{}),yc=n(e),rs=p(e,"A",{id:!0,class:!0}),u(rs).forEach(l),uc=n(e),r(Ms.$$.fragment,e),Jc=n(e),ms=p(e,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-ypfmt8"&&(ms.textContent=py),hc=n(e),Ts=p(e,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-sv0g8q"&&(Ts.innerHTML=oy),wc=n(e),ys=p(e,"TABLE",{"data-svelte-h":!0}),o(ys)!=="svelte-1d2oy3p"&&(ys.innerHTML=dy),jc=n(e),Uc=p(e,"HR",{}),fc=n(e),us=p(e,"A",{id:!0,class:!0}),u(us).forEach(l),bc=n(e),r(Js.$$.fragment,e),xc=n(e),hs=p(e,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-w5osnc"&&(hs.innerHTML=cy),Cc=n(e),ws=p(e,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1h4310j"&&(ws.innerHTML=ry),gc=n(e),r(js.$$.fragment,e),Ic=n(e),Us=p(e,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-xv6hak"&&(Us.innerHTML=My),kc=n(e),r(fs.$$.fragment,e),Bc=n(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-1ids6l"&&(bs.innerHTML=my),Gc=n(e),r(xs.$$.fragment,e),Qc=n(e),Cs=p(e,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-s10qq4"&&(Cs.innerHTML=Ty),Nc=n(e),gs=p(e,"UL",{"data-svelte-h":!0}),o(gs)!=="svelte-z3581k"&&(gs.innerHTML=yy),Zc=n(e),vc=p(e,"HR",{}),Ac=n(e),Is=p(e,"A",{id:!0,class:!0}),u(Is).forEach(l),$c=n(e),r(ks.$$.fragment,e),_c=n(e),Bs=p(e,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-71b02w"&&(Bs.textContent=uy),Rc=n(e),Gs=p(e,"TABLE",{"data-svelte-h":!0}),o(Gs)!=="svelte-dgeggs"&&(Gs.innerHTML=Jy),Vc=n(e),Yc=p(e,"HR",{}),Pc=n(e),Qs=p(e,"A",{id:!0,class:!0}),u(Qs).forEach(l),Ec=n(e),r(Ns.$$.fragment,e),Hc=n(e),Zs=p(e,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-1rpepg8"&&(Zs.textContent=hy),Wc=n(e),vs=p(e,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-zgzruq"&&(vs.innerHTML=wy),Sc=n(e),As=p(e,"TABLE",{"data-svelte-h":!0}),o(As)!=="svelte-17j2fmt"&&(As.innerHTML=jy),zc=n(e),Xc=p(e,"HR",{}),Lc=n(e),$s=p(e,"A",{id:!0,class:!0}),u($s).forEach(l),Fc=n(e),r(_s.$$.fragment,e),Dc=n(e),Rs=p(e,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-1rwi35s"&&(Rs.innerHTML=Uy),qc=n(e),Vs=p(e,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1tpbwb6"&&(Vs.innerHTML=fy),Oc=n(e),r(Ys.$$.fragment,e),Kc=n(e),Ps=p(e,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-s10qq4"&&(Ps.innerHTML=by),er=n(e),Es=p(e,"UL",{"data-svelte-h":!0}),o(Es)!=="svelte-1n3ebqn"&&(Es.innerHTML=xy),tr=n(e),lr=p(e,"HR",{}),sr=n(e),Hs=p(e,"A",{id:!0,class:!0}),u(Hs).forEach(l),ir=n(e),r(Ws.$$.fragment,e),nr=n(e),Ss=p(e,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1ctgtyq"&&(Ss.textContent=Cy),ar=n(e),zs=p(e,"TABLE",{"data-svelte-h":!0}),o(zs)!=="svelte-dgeggs"&&(zs.innerHTML=gy),pr=n(e),or=p(e,"HR",{}),dr=n(e),Xs=p(e,"A",{id:!0,class:!0}),u(Xs).forEach(l),cr=n(e),r(Ls.$$.fragment,e),rr=n(e),Fs=p(e,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-1v51wpq"&&(Fs.textContent=Iy),Mr=n(e),Ds=p(e,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-7em0sw"&&(Ds.innerHTML=ky),mr=n(e),qs=p(e,"TABLE",{"data-svelte-h":!0}),o(qs)!=="svelte-usc03t"&&(qs.innerHTML=By),Tr=n(e),yr=p(e,"HR",{}),ur=n(e),Os=p(e,"A",{id:!0,class:!0}),u(Os).forEach(l),Jr=n(e),r(Ks.$$.fragment,e),hr=n(e),ei=p(e,"P",{"data-svelte-h":!0}),o(ei)!=="svelte-20dgme"&&(ei.innerHTML=Gy),wr=n(e),ti=p(e,"P",{"data-svelte-h":!0}),o(ti)!=="svelte-eob2i5"&&(ti.innerHTML=Qy),jr=n(e),r(li.$$.fragment,e),Ur=n(e),si=p(e,"P",{"data-svelte-h":!0}),o(si)!=="svelte-s10qq4"&&(si.innerHTML=Ny),fr=n(e),ii=p(e,"UL",{"data-svelte-h":!0}),o(ii)!=="svelte-1psrxkl"&&(ii.innerHTML=Zy),br=n(e),xr=p(e,"HR",{}),Cr=n(e),ni=p(e,"A",{id:!0,class:!0}),u(ni).forEach(l),gr=n(e),r(ai.$$.fragment,e),Ir=n(e),pi=p(e,"P",{"data-svelte-h":!0}),o(pi)!=="svelte-3wys82"&&(pi.textContent=vy),kr=n(e),oi=p(e,"TABLE",{"data-svelte-h":!0}),o(oi)!=="svelte-1a94q5m"&&(oi.innerHTML=Ay),Br=n(e),Gr=p(e,"HR",{}),Qr=n(e),di=p(e,"A",{id:!0,class:!0}),u(di).forEach(l),Nr=n(e),r(ci.$$.fragment,e),Zr=n(e),ri=p(e,"P",{"data-svelte-h":!0}),o(ri)!=="svelte-g4x6jx"&&(ri.textContent=$y),vr=n(e),Mi=p(e,"P",{"data-svelte-h":!0}),o(Mi)!=="svelte-zhb55f"&&(Mi.innerHTML=_y),Ar=n(e),mi=p(e,"TABLE",{"data-svelte-h":!0}),o(mi)!=="svelte-tncnks"&&(mi.innerHTML=Ry),$r=n(e),_r=p(e,"HR",{}),Rr=n(e),Ti=p(e,"A",{id:!0,class:!0}),u(Ti).forEach(l),Vr=n(e),r(yi.$$.fragment,e),Yr=n(e),ui=p(e,"P",{"data-svelte-h":!0}),o(ui)!=="svelte-11wm84h"&&(ui.innerHTML=Vy),Pr=n(e),Ji=p(e,"P",{"data-svelte-h":!0}),o(Ji)!=="svelte-yzldbw"&&(Ji.innerHTML=Yy),Er=n(e),r(hi.$$.fragment,e),Hr=n(e),wi=p(e,"P",{"data-svelte-h":!0}),o(wi)!=="svelte-s10qq4"&&(wi.innerHTML=Py),Wr=n(e),ji=p(e,"UL",{"data-svelte-h":!0}),o(ji)!=="svelte-1kysuxh"&&(ji.innerHTML=Ey),Sr=n(e),zr=p(e,"HR",{}),Xr=n(e),Ui=p(e,"A",{id:!0,class:!0}),u(Ui).forEach(l),Lr=n(e),r(fi.$$.fragment,e),Fr=n(e),bi=p(e,"P",{"data-svelte-h":!0}),o(bi)!=="svelte-1la8w69"&&(bi.textContent=Hy),Dr=n(e),xi=p(e,"TABLE",{"data-svelte-h":!0}),o(xi)!=="svelte-dgeggs"&&(xi.innerHTML=Wy),qr=n(e),Or=p(e,"HR",{}),Kr=n(e),Ci=p(e,"A",{id:!0,class:!0}),u(Ci).forEach(l),eM=n(e),r(gi.$$.fragment,e),tM=n(e),Ii=p(e,"P",{"data-svelte-h":!0}),o(Ii)!=="svelte-1ws18e1"&&(Ii.textContent=Sy),lM=n(e),ki=p(e,"P",{"data-svelte-h":!0}),o(ki)!=="svelte-i9mudt"&&(ki.innerHTML=zy),sM=n(e),Bi=p(e,"TABLE",{"data-svelte-h":!0}),o(Bi)!=="svelte-th688q"&&(Bi.innerHTML=Xy),iM=n(e),nM=p(e,"HR",{}),aM=n(e),Gi=p(e,"A",{id:!0,class:!0}),u(Gi).forEach(l),pM=n(e),r(Qi.$$.fragment,e),oM=n(e),Ni=p(e,"P",{"data-svelte-h":!0}),o(Ni)!=="svelte-iv1c6p"&&(Ni.innerHTML=Ly),dM=n(e),Zi=p(e,"P",{"data-svelte-h":!0}),o(Zi)!=="svelte-1mtx2cy"&&(Zi.innerHTML=Fy),cM=n(e),r(vi.$$.fragment,e),rM=n(e),Ai=p(e,"P",{"data-svelte-h":!0}),o(Ai)!=="svelte-s10qq4"&&(Ai.innerHTML=Dy),MM=n(e),$i=p(e,"UL",{"data-svelte-h":!0}),o($i)!=="svelte-1x43yje"&&($i.innerHTML=qy),mM=n(e),TM=p(e,"HR",{}),yM=n(e),_i=p(e,"A",{id:!0,class:!0}),u(_i).forEach(l),uM=n(e),r(Ri.$$.fragment,e),JM=n(e),Vi=p(e,"P",{"data-svelte-h":!0}),o(Vi)!=="svelte-at8fug"&&(Vi.textContent=Oy),hM=n(e),Yi=p(e,"TABLE",{"data-svelte-h":!0}),o(Yi)!=="svelte-1a94q5m"&&(Yi.innerHTML=Ky),wM=n(e),jM=p(e,"HR",{}),UM=n(e),Pi=p(e,"A",{id:!0,class:!0}),u(Pi).forEach(l),fM=n(e),r(Ei.$$.fragment,e),bM=n(e),Hi=p(e,"P",{"data-svelte-h":!0}),o(Hi)!=="svelte-bu7lod"&&(Hi.textContent=eu),xM=n(e),Wi=p(e,"P",{"data-svelte-h":!0}),o(Wi)!=="svelte-1or1fiw"&&(Wi.innerHTML=tu),CM=n(e),Si=p(e,"TABLE",{"data-svelte-h":!0}),o(Si)!=="svelte-55abd5"&&(Si.innerHTML=lu),gM=n(e),IM=p(e,"HR",{}),kM=n(e),zi=p(e,"A",{id:!0,class:!0}),u(zi).forEach(l),BM=n(e),r(Xi.$$.fragment,e),GM=n(e),Li=p(e,"P",{"data-svelte-h":!0}),o(Li)!=="svelte-mcsd8f"&&(Li.innerHTML=su),QM=n(e),Fi=p(e,"P",{"data-svelte-h":!0}),o(Fi)!=="svelte-lb0vbj"&&(Fi.innerHTML=iu),NM=n(e),Di=p(e,"UL",{"data-svelte-h":!0}),o(Di)!=="svelte-wk6owh"&&(Di.innerHTML=nu),ZM=n(e),qi=p(e,"TABLE",{"data-svelte-h":!0}),o(qi)!=="svelte-1hm9kaq"&&(qi.innerHTML=au),vM=n(e),AM=p(e,"HR",{}),$M=n(e),Oi=p(e,"A",{id:!0,class:!0}),u(Oi).forEach(l),_M=n(e),r(Ki.$$.fragment,e),RM=n(e),en=p(e,"P",{"data-svelte-h":!0}),o(en)!=="svelte-ptv3i7"&&(en.innerHTML=pu),VM=n(e),tn=p(e,"TABLE",{"data-svelte-h":!0}),o(tn)!=="svelte-2eqjop"&&(tn.innerHTML=ou),YM=n(e),PM=p(e,"HR",{}),EM=n(e),ln=p(e,"A",{id:!0,class:!0}),u(ln).forEach(l),HM=n(e),r(sn.$$.fragment,e),WM=n(e),nn=p(e,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-1axcw5l"&&(nn.innerHTML=du),SM=n(e),zM=p(e,"HR",{}),XM=n(e),an=p(e,"A",{id:!0,class:!0}),u(an).forEach(l),LM=n(e),r(pn.$$.fragment,e),FM=n(e),on=p(e,"P",{"data-svelte-h":!0}),o(on)!=="svelte-1axcw5l"&&(on.innerHTML=cu),DM=n(e),dn=p(e,"TABLE",{"data-svelte-h":!0}),o(dn)!=="svelte-flnl7b"&&(dn.innerHTML=ru),qM=n(e),OM=p(e,"HR",{}),KM=n(e),rn=p(e,"P",{}),u(rn).forEach(l),this.h()},h(){d(w,"name","hf:doc:metadata"),d(w,"content",ju),d(j,"id","module_pipelines"),d(j,"class","group"),d(g,"id","module_pipelines.Pipeline"),d(g,"class","group"),d(Q,"id","new_module_pipelines.Pipeline_new"),d(Q,"class","group"),d(A,"id","module_pipelines.Pipeline+dispose"),d(A,"class","group"),d(V,"id","module_pipelines.Pipeline+_call"),d(V,"class","group"),d(W,"id","module_pipelines.TextClassificationPipeline"),d(W,"class","group"),d(ee,"id","module_pipelines.TextClassificationPipeline+_call"),d(ee,"class","group"),d(ne,"id","module_pipelines.TokenClassificationPipeline"),d(ne,"class","group"),d(me,"id","module_pipelines.TokenClassificationPipeline+_call"),d(me,"class","group"),d(he,"id","module_pipelines.QuestionAnsweringPipeline"),d(he,"class","group"),d(xe,"id","module_pipelines.QuestionAnsweringPipeline+_call"),d(xe,"class","group"),d(Be,"id","module_pipelines.FillMaskPipeline"),d(Be,"class","group"),d(_e,"id","module_pipelines.FillMaskPipeline+_call"),d(_e,"class","group"),d(Ee,"id","module_pipelines.Text2TextGenerationPipeline"),d(Ee,"class","group"),d(Le,"id","module_pipelines.Text2TextGenerationPipeline+_call"),d(Le,"class","group"),d(et,"id","module_pipelines.SummarizationPipeline"),d(et,"class","group"),d(at,"id","module_pipelines.TranslationPipeline"),d(at,"class","group"),d(wt,"id","module_pipelines.TextGenerationPipeline"),d(wt,"class","group"),d(Bt,"id","module_pipelines.TextGenerationPipeline+_call"),d(Bt,"class","group"),d(vt,"id","module_pipelines.ZeroShotClassificationPipeline"),d(vt,"class","group"),d(Ht,"id","new_module_pipelines.ZeroShotClassificationPipeline_new"),d(Ht,"class","group"),d(Xt,"id","module_pipelines.ZeroShotClassificationPipeline+_call"),d(Xt,"class","group"),d(qt,"id","module_pipelines.FeatureExtractionPipeline"),d(qt,"class","group"),d(pl,"id","module_pipelines.FeatureExtractionPipeline+_call"),d(pl,"class","group"),d(Ml,"id","module_pipelines.AudioClassificationPipeline"),d(Ml,"class","group"),d(wl,"id","new_module_pipelines.AudioClassificationPipeline_new"),d(wl,"class","group"),d(bl,"id","module_pipelines.AudioClassificationPipeline+_call"),d(bl,"class","group"),d(kl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline"),d(kl,"class","group"),d(Sl,"id","new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"),d(Sl,"class","group"),d(Fl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline+_call"),d(Fl,"class","group"),d(es,"id","module_pipelines.ImageToTextPipeline"),d(es,"class","group"),d(ps,"id","new_module_pipelines.ImageToTextPipeline_new"),d(ps,"class","group"),d(rs,"id","module_pipelines.ImageToTextPipeline+_call"),d(rs,"class","group"),d(us,"id","module_pipelines.ImageClassificationPipeline"),d(us,"class","group"),d(Is,"id","new_module_pipelines.ImageClassificationPipeline_new"),d(Is,"class","group"),d(Qs,"id","module_pipelines.ImageClassificationPipeline+_call"),d(Qs,"class","group"),d($s,"id","module_pipelines.ImageSegmentationPipeline"),d($s,"class","group"),d(Hs,"id","new_module_pipelines.ImageSegmentationPipeline_new"),d(Hs,"class","group"),d(Xs,"id","module_pipelines.ImageSegmentationPipeline+_call"),d(Xs,"class","group"),d(Os,"id","module_pipelines.ZeroShotImageClassificationPipeline"),d(Os,"class","group"),d(ni,"id","new_module_pipelines.ZeroShotImageClassificationPipeline_new"),d(ni,"class","group"),d(di,"id","module_pipelines.ZeroShotImageClassificationPipeline+_call"),d(di,"class","group"),d(Ti,"id","module_pipelines.ObjectDetectionPipeline"),d(Ti,"class","group"),d(Ui,"id","new_module_pipelines.ObjectDetectionPipeline_new"),d(Ui,"class","group"),d(Ci,"id","module_pipelines.ObjectDetectionPipeline+_call"),d(Ci,"class","group"),d(Gi,"id","module_pipelines.DocumentQuestionAnsweringPipeline"),d(Gi,"class","group"),d(_i,"id","new_module_pipelines.DocumentQuestionAnsweringPipeline_new"),d(_i,"class","group"),d(Pi,"id","module_pipelines.DocumentQuestionAnsweringPipeline+_call"),d(Pi,"class","group"),d(zi,"id","module_pipelines.pipeline"),d(zi,"class","group"),d(Oi,"id","module_pipelines..QuestionAnsweringResult"),d(Oi,"class","group"),d(ln,"id","module_pipelines..QuestionAnsweringReturnType"),d(ln,"class","group"),d(an,"id","module_pipelines..ChunkCallback"),d(an,"class","group")},m(e,t){hu(document.head,w),s(e,Mn,t),s(e,cn,t),s(e,mn,t),s(e,j,t),s(e,Tn,t),M(U,e,t),s(e,yn,t),s(e,f,t),s(e,un,t),s(e,b,t),s(e,Jn,t),M(x,e,t),s(e,hn,t),s(e,C,t),s(e,wn,t),s(e,jn,t),s(e,Un,t),s(e,g,t),s(e,fn,t),M(I,e,t),s(e,bn,t),s(e,k,t),s(e,xn,t),s(e,B,t),s(e,Cn,t),s(e,G,t),s(e,gn,t),s(e,In,t),s(e,kn,t),s(e,Q,t),s(e,Bn,t),M(N,e,t),s(e,Gn,t),s(e,Z,t),s(e,Qn,t),s(e,v,t),s(e,Nn,t),s(e,Zn,t),s(e,vn,t),s(e,A,t),s(e,An,t),M($,e,t),s(e,$n,t),s(e,_,t),s(e,_n,t),s(e,R,t),s(e,Rn,t),s(e,Vn,t),s(e,Yn,t),s(e,V,t),s(e,Pn,t),M(Y,e,t),s(e,En,t),s(e,P,t),s(e,Hn,t),s(e,E,t),s(e,Wn,t),s(e,H,t),s(e,Sn,t),s(e,zn,t),s(e,Xn,t),s(e,W,t),s(e,Ln,t),M(S,e,t),s(e,Fn,t),s(e,z,t),s(e,Dn,t),s(e,X,t),s(e,qn,t),M(L,e,t),s(e,On,t),s(e,F,t),s(e,Kn,t),M(D,e,t),s(e,ea,t),s(e,q,t),s(e,ta,t),M(O,e,t),s(e,la,t),s(e,K,t),s(e,sa,t),s(e,ia,t),s(e,na,t),s(e,ee,t),s(e,aa,t),M(te,e,t),s(e,pa,t),s(e,le,t),s(e,oa,t),s(e,se,t),s(e,da,t),s(e,ie,t),s(e,ca,t),s(e,ra,t),s(e,Ma,t),s(e,ne,t),s(e,ma,t),M(ae,e,t),s(e,Ta,t),s(e,pe,t),s(e,ya,t),s(e,oe,t),s(e,ua,t),M(de,e,t),s(e,Ja,t),s(e,ce,t),s(e,ha,t),M(re,e,t),s(e,wa,t),s(e,Me,t),s(e,ja,t),s(e,Ua,t),s(e,fa,t),s(e,me,t),s(e,ba,t),M(Te,e,t),s(e,xa,t),s(e,ye,t),s(e,Ca,t),s(e,ue,t),s(e,ga,t),s(e,Je,t),s(e,Ia,t),s(e,ka,t),s(e,Ba,t),s(e,he,t),s(e,Ga,t),M(we,e,t),s(e,Qa,t),s(e,je,t),s(e,Na,t),s(e,Ue,t),s(e,Za,t),M(fe,e,t),s(e,va,t),s(e,be,t),s(e,Aa,t),s(e,$a,t),s(e,_a,t),s(e,xe,t),s(e,Ra,t),M(Ce,e,t),s(e,Va,t),s(e,ge,t),s(e,Ya,t),s(e,Ie,t),s(e,Pa,t),s(e,ke,t),s(e,Ea,t),s(e,Ha,t),s(e,Wa,t),s(e,Be,t),s(e,Sa,t),M(Ge,e,t),s(e,za,t),s(e,Qe,t),s(e,Xa,t),s(e,Ne,t),s(e,La,t),M(Ze,e,t),s(e,Fa,t),s(e,ve,t),s(e,Da,t),M(Ae,e,t),s(e,qa,t),s(e,$e,t),s(e,Oa,t),s(e,Ka,t),s(e,ep,t),s(e,_e,t),s(e,tp,t),M(Re,e,t),s(e,lp,t),s(e,Ve,t),s(e,sp,t),s(e,Ye,t),s(e,ip,t),s(e,Pe,t),s(e,np,t),s(e,ap,t),s(e,pp,t),s(e,Ee,t),s(e,op,t),M(He,e,t),s(e,dp,t),s(e,We,t),s(e,cp,t),s(e,Se,t),s(e,rp,t),M(ze,e,t),s(e,Mp,t),s(e,Xe,t),s(e,mp,t),s(e,Tp,t),s(e,yp,t),s(e,Le,t),s(e,up,t),M(Fe,e,t),s(e,Jp,t),s(e,De,t),s(e,hp,t),s(e,qe,t),s(e,wp,t),s(e,Oe,t),s(e,jp,t),s(e,Ke,t),s(e,Up,t),s(e,fp,t),s(e,bp,t),s(e,et,t),s(e,xp,t),M(tt,e,t),s(e,Cp,t),s(e,lt,t),s(e,gp,t),s(e,st,t),s(e,Ip,t),M(it,e,t),s(e,kp,t),s(e,nt,t),s(e,Bp,t),s(e,Gp,t),s(e,Qp,t),s(e,at,t),s(e,Np,t),M(pt,e,t),s(e,Zp,t),s(e,ot,t),s(e,vp,t),s(e,dt,t),s(e,Ap,t),s(e,ct,t),s(e,$p,t),M(rt,e,t),s(e,_p,t),s(e,Mt,t),s(e,Rp,t),s(e,mt,t),s(e,Vp,t),M(Tt,e,t),s(e,Yp,t),s(e,yt,t),s(e,Pp,t),s(e,ut,t),s(e,Ep,t),M(Jt,e,t),s(e,Hp,t),s(e,ht,t),s(e,Wp,t),s(e,Sp,t),s(e,zp,t),s(e,wt,t),s(e,Xp,t),M(jt,e,t),s(e,Lp,t),s(e,Ut,t),s(e,Fp,t),s(e,ft,t),s(e,Dp,t),M(bt,e,t),s(e,qp,t),s(e,xt,t),s(e,Op,t),M(Ct,e,t),s(e,Kp,t),s(e,gt,t),s(e,eo,t),M(It,e,t),s(e,to,t),s(e,kt,t),s(e,lo,t),s(e,so,t),s(e,io,t),s(e,Bt,t),s(e,no,t),M(Gt,e,t),s(e,ao,t),s(e,Qt,t),s(e,po,t),s(e,Nt,t),s(e,oo,t),s(e,Zt,t),s(e,co,t),s(e,ro,t),s(e,Mo,t),s(e,vt,t),s(e,mo,t),M(At,e,t),s(e,To,t),s(e,$t,t),s(e,yo,t),s(e,_t,t),s(e,uo,t),M(Rt,e,t),s(e,Jo,t),s(e,Vt,t),s(e,ho,t),M(Yt,e,t),s(e,wo,t),s(e,Pt,t),s(e,jo,t),s(e,Et,t),s(e,Uo,t),s(e,fo,t),s(e,bo,t),s(e,Ht,t),s(e,xo,t),M(Wt,e,t),s(e,Co,t),s(e,St,t),s(e,go,t),s(e,zt,t),s(e,Io,t),s(e,ko,t),s(e,Bo,t),s(e,Xt,t),s(e,Go,t),M(Lt,e,t),s(e,Qo,t),s(e,Ft,t),s(e,No,t),s(e,Dt,t),s(e,Zo,t),s(e,vo,t),s(e,Ao,t),s(e,qt,t),s(e,$o,t),M(Ot,e,t),s(e,_o,t),s(e,Kt,t),s(e,Ro,t),s(e,el,t),s(e,Vo,t),M(tl,e,t),s(e,Yo,t),s(e,ll,t),s(e,Po,t),M(sl,e,t),s(e,Eo,t),s(e,il,t),s(e,Ho,t),M(nl,e,t),s(e,Wo,t),s(e,al,t),s(e,So,t),s(e,zo,t),s(e,Xo,t),s(e,pl,t),s(e,Lo,t),M(ol,e,t),s(e,Fo,t),s(e,dl,t),s(e,Do,t),s(e,cl,t),s(e,qo,t),s(e,rl,t),s(e,Oo,t),s(e,Ko,t),s(e,ed,t),s(e,Ml,t),s(e,td,t),M(ml,e,t),s(e,ld,t),s(e,Tl,t),s(e,sd,t),s(e,yl,t),s(e,id,t),M(ul,e,t),s(e,nd,t),s(e,Jl,t),s(e,ad,t),s(e,hl,t),s(e,pd,t),s(e,od,t),s(e,dd,t),s(e,wl,t),s(e,cd,t),M(jl,e,t),s(e,rd,t),s(e,Ul,t),s(e,Md,t),s(e,fl,t),s(e,md,t),s(e,Td,t),s(e,yd,t),s(e,bl,t),s(e,ud,t),M(xl,e,t),s(e,Jd,t),s(e,Cl,t),s(e,hd,t),s(e,gl,t),s(e,wd,t),s(e,Il,t),s(e,jd,t),s(e,Ud,t),s(e,fd,t),s(e,kl,t),s(e,bd,t),M(Bl,e,t),s(e,xd,t),s(e,Gl,t),s(e,Cd,t),s(e,Ql,t),s(e,gd,t),M(Nl,e,t),s(e,Id,t),s(e,Zl,t),s(e,kd,t),M(vl,e,t),s(e,Bd,t),s(e,Al,t),s(e,Gd,t),M($l,e,t),s(e,Qd,t),s(e,_l,t),s(e,Nd,t),M(Rl,e,t),s(e,Zd,t),s(e,Vl,t),s(e,vd,t),M(Yl,e,t),s(e,Ad,t),s(e,Pl,t),s(e,$d,t),M(El,e,t),s(e,_d,t),s(e,Hl,t),s(e,Rd,t),s(e,Wl,t),s(e,Vd,t),s(e,Yd,t),s(e,Pd,t),s(e,Sl,t),s(e,Ed,t),M(zl,e,t),s(e,Hd,t),s(e,Xl,t),s(e,Wd,t),s(e,Ll,t),s(e,Sd,t),s(e,zd,t),s(e,Xd,t),s(e,Fl,t),s(e,Ld,t),M(Dl,e,t),s(e,Fd,t),s(e,ql,t),s(e,Dd,t),s(e,Ol,t),s(e,qd,t),s(e,Kl,t),s(e,Od,t),s(e,Kd,t),s(e,ec,t),s(e,es,t),s(e,tc,t),M(ts,e,t),s(e,lc,t),s(e,ls,t),s(e,sc,t),s(e,ss,t),s(e,ic,t),M(is,e,t),s(e,nc,t),s(e,ns,t),s(e,ac,t),s(e,as,t),s(e,pc,t),s(e,oc,t),s(e,dc,t),s(e,ps,t),s(e,cc,t),M(os,e,t),s(e,rc,t),s(e,ds,t),s(e,Mc,t),s(e,cs,t),s(e,mc,t),s(e,Tc,t),s(e,yc,t),s(e,rs,t),s(e,uc,t),M(Ms,e,t),s(e,Jc,t),s(e,ms,t),s(e,hc,t),s(e,Ts,t),s(e,wc,t),s(e,ys,t),s(e,jc,t),s(e,Uc,t),s(e,fc,t),s(e,us,t),s(e,bc,t),M(Js,e,t),s(e,xc,t),s(e,hs,t),s(e,Cc,t),s(e,ws,t),s(e,gc,t),M(js,e,t),s(e,Ic,t),s(e,Us,t),s(e,kc,t),M(fs,e,t),s(e,Bc,t),s(e,bs,t),s(e,Gc,t),M(xs,e,t),s(e,Qc,t),s(e,Cs,t),s(e,Nc,t),s(e,gs,t),s(e,Zc,t),s(e,vc,t),s(e,Ac,t),s(e,Is,t),s(e,$c,t),M(ks,e,t),s(e,_c,t),s(e,Bs,t),s(e,Rc,t),s(e,Gs,t),s(e,Vc,t),s(e,Yc,t),s(e,Pc,t),s(e,Qs,t),s(e,Ec,t),M(Ns,e,t),s(e,Hc,t),s(e,Zs,t),s(e,Wc,t),s(e,vs,t),s(e,Sc,t),s(e,As,t),s(e,zc,t),s(e,Xc,t),s(e,Lc,t),s(e,$s,t),s(e,Fc,t),M(_s,e,t),s(e,Dc,t),s(e,Rs,t),s(e,qc,t),s(e,Vs,t),s(e,Oc,t),M(Ys,e,t),s(e,Kc,t),s(e,Ps,t),s(e,er,t),s(e,Es,t),s(e,tr,t),s(e,lr,t),s(e,sr,t),s(e,Hs,t),s(e,ir,t),M(Ws,e,t),s(e,nr,t),s(e,Ss,t),s(e,ar,t),s(e,zs,t),s(e,pr,t),s(e,or,t),s(e,dr,t),s(e,Xs,t),s(e,cr,t),M(Ls,e,t),s(e,rr,t),s(e,Fs,t),s(e,Mr,t),s(e,Ds,t),s(e,mr,t),s(e,qs,t),s(e,Tr,t),s(e,yr,t),s(e,ur,t),s(e,Os,t),s(e,Jr,t),M(Ks,e,t),s(e,hr,t),s(e,ei,t),s(e,wr,t),s(e,ti,t),s(e,jr,t),M(li,e,t),s(e,Ur,t),s(e,si,t),s(e,fr,t),s(e,ii,t),s(e,br,t),s(e,xr,t),s(e,Cr,t),s(e,ni,t),s(e,gr,t),M(ai,e,t),s(e,Ir,t),s(e,pi,t),s(e,kr,t),s(e,oi,t),s(e,Br,t),s(e,Gr,t),s(e,Qr,t),s(e,di,t),s(e,Nr,t),M(ci,e,t),s(e,Zr,t),s(e,ri,t),s(e,vr,t),s(e,Mi,t),s(e,Ar,t),s(e,mi,t),s(e,$r,t),s(e,_r,t),s(e,Rr,t),s(e,Ti,t),s(e,Vr,t),M(yi,e,t),s(e,Yr,t),s(e,ui,t),s(e,Pr,t),s(e,Ji,t),s(e,Er,t),M(hi,e,t),s(e,Hr,t),s(e,wi,t),s(e,Wr,t),s(e,ji,t),s(e,Sr,t),s(e,zr,t),s(e,Xr,t),s(e,Ui,t),s(e,Lr,t),M(fi,e,t),s(e,Fr,t),s(e,bi,t),s(e,Dr,t),s(e,xi,t),s(e,qr,t),s(e,Or,t),s(e,Kr,t),s(e,Ci,t),s(e,eM,t),M(gi,e,t),s(e,tM,t),s(e,Ii,t),s(e,lM,t),s(e,ki,t),s(e,sM,t),s(e,Bi,t),s(e,iM,t),s(e,nM,t),s(e,aM,t),s(e,Gi,t),s(e,pM,t),M(Qi,e,t),s(e,oM,t),s(e,Ni,t),s(e,dM,t),s(e,Zi,t),s(e,cM,t),M(vi,e,t),s(e,rM,t),s(e,Ai,t),s(e,MM,t),s(e,$i,t),s(e,mM,t),s(e,TM,t),s(e,yM,t),s(e,_i,t),s(e,uM,t),M(Ri,e,t),s(e,JM,t),s(e,Vi,t),s(e,hM,t),s(e,Yi,t),s(e,wM,t),s(e,jM,t),s(e,UM,t),s(e,Pi,t),s(e,fM,t),M(Ei,e,t),s(e,bM,t),s(e,Hi,t),s(e,xM,t),s(e,Wi,t),s(e,CM,t),s(e,Si,t),s(e,gM,t),s(e,IM,t),s(e,kM,t),s(e,zi,t),s(e,BM,t),M(Xi,e,t),s(e,GM,t),s(e,Li,t),s(e,QM,t),s(e,Fi,t),s(e,NM,t),s(e,Di,t),s(e,ZM,t),s(e,qi,t),s(e,vM,t),s(e,AM,t),s(e,$M,t),s(e,Oi,t),s(e,_M,t),M(Ki,e,t),s(e,RM,t),s(e,en,t),s(e,VM,t),s(e,tn,t),s(e,YM,t),s(e,PM,t),s(e,EM,t),s(e,ln,t),s(e,HM,t),M(sn,e,t),s(e,WM,t),s(e,nn,t),s(e,SM,t),s(e,zM,t),s(e,XM,t),s(e,an,t),s(e,LM,t),M(pn,e,t),s(e,FM,t),s(e,on,t),s(e,DM,t),s(e,dn,t),s(e,qM,t),s(e,OM,t),s(e,KM,t),s(e,rn,t),em=!0},p:mu,i(e){em||(m(U.$$.fragment,e),m(x.$$.fragment,e),m(I.$$.fragment,e),m(N.$$.fragment,e),m($.$$.fragment,e),m(Y.$$.fragment,e),m(S.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(de.$$.fragment,e),m(re.$$.fragment,e),m(Te.$$.fragment,e),m(we.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(Ge.$$.fragment,e),m(Ze.$$.fragment,e),m(Ae.$$.fragment,e),m(Re.$$.fragment,e),m(He.$$.fragment,e),m(ze.$$.fragment,e),m(Fe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(rt.$$.fragment,e),m(Tt.$$.fragment,e),m(Jt.$$.fragment,e),m(jt.$$.fragment,e),m(bt.$$.fragment,e),m(Ct.$$.fragment,e),m(It.$$.fragment,e),m(Gt.$$.fragment,e),m(At.$$.fragment,e),m(Rt.$$.fragment,e),m(Yt.$$.fragment,e),m(Wt.$$.fragment,e),m(Lt.$$.fragment,e),m(Ot.$$.fragment,e),m(tl.$$.fragment,e),m(sl.$$.fragment,e),m(nl.$$.fragment,e),m(ol.$$.fragment,e),m(ml.$$.fragment,e),m(ul.$$.fragment,e),m(jl.$$.fragment,e),m(xl.$$.fragment,e),m(Bl.$$.fragment,e),m(Nl.$$.fragment,e),m(vl.$$.fragment,e),m($l.$$.fragment,e),m(Rl.$$.fragment,e),m(Yl.$$.fragment,e),m(El.$$.fragment,e),m(zl.$$.fragment,e),m(Dl.$$.fragment,e),m(ts.$$.fragment,e),m(is.$$.fragment,e),m(os.$$.fragment,e),m(Ms.$$.fragment,e),m(Js.$$.fragment,e),m(js.$$.fragment,e),m(fs.$$.fragment,e),m(xs.$$.fragment,e),m(ks.$$.fragment,e),m(Ns.$$.fragment,e),m(_s.$$.fragment,e),m(Ys.$$.fragment,e),m(Ws.$$.fragment,e),m(Ls.$$.fragment,e),m(Ks.$$.fragment,e),m(li.$$.fragment,e),m(ai.$$.fragment,e),m(ci.$$.fragment,e),m(yi.$$.fragment,e),m(hi.$$.fragment,e),m(fi.$$.fragment,e),m(gi.$$.fragment,e),m(Qi.$$.fragment,e),m(vi.$$.fragment,e),m(Ri.$$.fragment,e),m(Ei.$$.fragment,e),m(Xi.$$.fragment,e),m(Ki.$$.fragment,e),m(sn.$$.fragment,e),m(pn.$$.fragment,e),em=!0)},o(e){T(U.$$.fragment,e),T(x.$$.fragment,e),T(I.$$.fragment,e),T(N.$$.fragment,e),T($.$$.fragment,e),T(Y.$$.fragment,e),T(S.$$.fragment,e),T(L.$$.fragment,e),T(D.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(de.$$.fragment,e),T(re.$$.fragment,e),T(Te.$$.fragment,e),T(we.$$.fragment,e),T(fe.$$.fragment,e),T(Ce.$$.fragment,e),T(Ge.$$.fragment,e),T(Ze.$$.fragment,e),T(Ae.$$.fragment,e),T(Re.$$.fragment,e),T(He.$$.fragment,e),T(ze.$$.fragment,e),T(Fe.$$.fragment,e),T(tt.$$.fragment,e),T(it.$$.fragment,e),T(pt.$$.fragment,e),T(rt.$$.fragment,e),T(Tt.$$.fragment,e),T(Jt.$$.fragment,e),T(jt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(It.$$.fragment,e),T(Gt.$$.fragment,e),T(At.$$.fragment,e),T(Rt.$$.fragment,e),T(Yt.$$.fragment,e),T(Wt.$$.fragment,e),T(Lt.$$.fragment,e),T(Ot.$$.fragment,e),T(tl.$$.fragment,e),T(sl.$$.fragment,e),T(nl.$$.fragment,e),T(ol.$$.fragment,e),T(ml.$$.fragment,e),T(ul.$$.fragment,e),T(jl.$$.fragment,e),T(xl.$$.fragment,e),T(Bl.$$.fragment,e),T(Nl.$$.fragment,e),T(vl.$$.fragment,e),T($l.$$.fragment,e),T(Rl.$$.fragment,e),T(Yl.$$.fragment,e),T(El.$$.fragment,e),T(zl.$$.fragment,e),T(Dl.$$.fragment,e),T(ts.$$.fragment,e),T(is.$$.fragment,e),T(os.$$.fragment,e),T(Ms.$$.fragment,e),T(Js.$$.fragment,e),T(js.$$.fragment,e),T(fs.$$.fragment,e),T(xs.$$.fragment,e),T(ks.$$.fragment,e),T(Ns.$$.fragment,e),T(_s.$$.fragment,e),T(Ys.$$.fragment,e),T(Ws.$$.fragment,e),T(Ls.$$.fragment,e),T(Ks.$$.fragment,e),T(li.$$.fragment,e),T(ai.$$.fragment,e),T(ci.$$.fragment,e),T(yi.$$.fragment,e),T(hi.$$.fragment,e),T(fi.$$.fragment,e),T(gi.$$.fragment,e),T(Qi.$$.fragment,e),T(vi.$$.fragment,e),T(Ri.$$.fragment,e),T(Ei.$$.fragment,e),T(Xi.$$.fragment,e),T(Ki.$$.fragment,e),T(sn.$$.fragment,e),T(pn.$$.fragment,e),em=!1},d(e){e&&(l(Mn),l(cn),l(mn),l(j),l(Tn),l(yn),l(f),l(un),l(b),l(Jn),l(hn),l(C),l(wn),l(jn),l(Un),l(g),l(fn),l(bn),l(k),l(xn),l(B),l(Cn),l(G),l(gn),l(In),l(kn),l(Q),l(Bn),l(Gn),l(Z),l(Qn),l(v),l(Nn),l(Zn),l(vn),l(A),l(An),l($n),l(_),l(_n),l(R),l(Rn),l(Vn),l(Yn),l(V),l(Pn),l(En),l(P),l(Hn),l(E),l(Wn),l(H),l(Sn),l(zn),l(Xn),l(W),l(Ln),l(Fn),l(z),l(Dn),l(X),l(qn),l(On),l(F),l(Kn),l(ea),l(q),l(ta),l(la),l(K),l(sa),l(ia),l(na),l(ee),l(aa),l(pa),l(le),l(oa),l(se),l(da),l(ie),l(ca),l(ra),l(Ma),l(ne),l(ma),l(Ta),l(pe),l(ya),l(oe),l(ua),l(Ja),l(ce),l(ha),l(wa),l(Me),l(ja),l(Ua),l(fa),l(me),l(ba),l(xa),l(ye),l(Ca),l(ue),l(ga),l(Je),l(Ia),l(ka),l(Ba),l(he),l(Ga),l(Qa),l(je),l(Na),l(Ue),l(Za),l(va),l(be),l(Aa),l($a),l(_a),l(xe),l(Ra),l(Va),l(ge),l(Ya),l(Ie),l(Pa),l(ke),l(Ea),l(Ha),l(Wa),l(Be),l(Sa),l(za),l(Qe),l(Xa),l(Ne),l(La),l(Fa),l(ve),l(Da),l(qa),l($e),l(Oa),l(Ka),l(ep),l(_e),l(tp),l(lp),l(Ve),l(sp),l(Ye),l(ip),l(Pe),l(np),l(ap),l(pp),l(Ee),l(op),l(dp),l(We),l(cp),l(Se),l(rp),l(Mp),l(Xe),l(mp),l(Tp),l(yp),l(Le),l(up),l(Jp),l(De),l(hp),l(qe),l(wp),l(Oe),l(jp),l(Ke),l(Up),l(fp),l(bp),l(et),l(xp),l(Cp),l(lt),l(gp),l(st),l(Ip),l(kp),l(nt),l(Bp),l(Gp),l(Qp),l(at),l(Np),l(Zp),l(ot),l(vp),l(dt),l(Ap),l(ct),l($p),l(_p),l(Mt),l(Rp),l(mt),l(Vp),l(Yp),l(yt),l(Pp),l(ut),l(Ep),l(Hp),l(ht),l(Wp),l(Sp),l(zp),l(wt),l(Xp),l(Lp),l(Ut),l(Fp),l(ft),l(Dp),l(qp),l(xt),l(Op),l(Kp),l(gt),l(eo),l(to),l(kt),l(lo),l(so),l(io),l(Bt),l(no),l(ao),l(Qt),l(po),l(Nt),l(oo),l(Zt),l(co),l(ro),l(Mo),l(vt),l(mo),l(To),l($t),l(yo),l(_t),l(uo),l(Jo),l(Vt),l(ho),l(wo),l(Pt),l(jo),l(Et),l(Uo),l(fo),l(bo),l(Ht),l(xo),l(Co),l(St),l(go),l(zt),l(Io),l(ko),l(Bo),l(Xt),l(Go),l(Qo),l(Ft),l(No),l(Dt),l(Zo),l(vo),l(Ao),l(qt),l($o),l(_o),l(Kt),l(Ro),l(el),l(Vo),l(Yo),l(ll),l(Po),l(Eo),l(il),l(Ho),l(Wo),l(al),l(So),l(zo),l(Xo),l(pl),l(Lo),l(Fo),l(dl),l(Do),l(cl),l(qo),l(rl),l(Oo),l(Ko),l(ed),l(Ml),l(td),l(ld),l(Tl),l(sd),l(yl),l(id),l(nd),l(Jl),l(ad),l(hl),l(pd),l(od),l(dd),l(wl),l(cd),l(rd),l(Ul),l(Md),l(fl),l(md),l(Td),l(yd),l(bl),l(ud),l(Jd),l(Cl),l(hd),l(gl),l(wd),l(Il),l(jd),l(Ud),l(fd),l(kl),l(bd),l(xd),l(Gl),l(Cd),l(Ql),l(gd),l(Id),l(Zl),l(kd),l(Bd),l(Al),l(Gd),l(Qd),l(_l),l(Nd),l(Zd),l(Vl),l(vd),l(Ad),l(Pl),l($d),l(_d),l(Hl),l(Rd),l(Wl),l(Vd),l(Yd),l(Pd),l(Sl),l(Ed),l(Hd),l(Xl),l(Wd),l(Ll),l(Sd),l(zd),l(Xd),l(Fl),l(Ld),l(Fd),l(ql),l(Dd),l(Ol),l(qd),l(Kl),l(Od),l(Kd),l(ec),l(es),l(tc),l(lc),l(ls),l(sc),l(ss),l(ic),l(nc),l(ns),l(ac),l(as),l(pc),l(oc),l(dc),l(ps),l(cc),l(rc),l(ds),l(Mc),l(cs),l(mc),l(Tc),l(yc),l(rs),l(uc),l(Jc),l(ms),l(hc),l(Ts),l(wc),l(ys),l(jc),l(Uc),l(fc),l(us),l(bc),l(xc),l(hs),l(Cc),l(ws),l(gc),l(Ic),l(Us),l(kc),l(Bc),l(bs),l(Gc),l(Qc),l(Cs),l(Nc),l(gs),l(Zc),l(vc),l(Ac),l(Is),l($c),l(_c),l(Bs),l(Rc),l(Gs),l(Vc),l(Yc),l(Pc),l(Qs),l(Ec),l(Hc),l(Zs),l(Wc),l(vs),l(Sc),l(As),l(zc),l(Xc),l(Lc),l($s),l(Fc),l(Dc),l(Rs),l(qc),l(Vs),l(Oc),l(Kc),l(Ps),l(er),l(Es),l(tr),l(lr),l(sr),l(Hs),l(ir),l(nr),l(Ss),l(ar),l(zs),l(pr),l(or),l(dr),l(Xs),l(cr),l(rr),l(Fs),l(Mr),l(Ds),l(mr),l(qs),l(Tr),l(yr),l(ur),l(Os),l(Jr),l(hr),l(ei),l(wr),l(ti),l(jr),l(Ur),l(si),l(fr),l(ii),l(br),l(xr),l(Cr),l(ni),l(gr),l(Ir),l(pi),l(kr),l(oi),l(Br),l(Gr),l(Qr),l(di),l(Nr),l(Zr),l(ri),l(vr),l(Mi),l(Ar),l(mi),l($r),l(_r),l(Rr),l(Ti),l(Vr),l(Yr),l(ui),l(Pr),l(Ji),l(Er),l(Hr),l(wi),l(Wr),l(ji),l(Sr),l(zr),l(Xr),l(Ui),l(Lr),l(Fr),l(bi),l(Dr),l(xi),l(qr),l(Or),l(Kr),l(Ci),l(eM),l(tM),l(Ii),l(lM),l(ki),l(sM),l(Bi),l(iM),l(nM),l(aM),l(Gi),l(pM),l(oM),l(Ni),l(dM),l(Zi),l(cM),l(rM),l(Ai),l(MM),l($i),l(mM),l(TM),l(yM),l(_i),l(uM),l(JM),l(Vi),l(hM),l(Yi),l(wM),l(jM),l(UM),l(Pi),l(fM),l(bM),l(Hi),l(xM),l(Wi),l(CM),l(Si),l(gM),l(IM),l(kM),l(zi),l(BM),l(GM),l(Li),l(QM),l(Fi),l(NM),l(Di),l(ZM),l(qi),l(vM),l(AM),l($M),l(Oi),l(_M),l(RM),l(en),l(VM),l(tn),l(YM),l(PM),l(EM),l(ln),l(HM),l(WM),l(nn),l(SM),l(zM),l(XM),l(an),l(LM),l(FM),l(on),l(DM),l(dn),l(qM),l(OM),l(KM),l(rn)),l(w),y(U,e),y(x,e),y(I,e),y(N,e),y($,e),y(Y,e),y(S,e),y(L,e),y(D,e),y(O,e),y(te,e),y(ae,e),y(de,e),y(re,e),y(Te,e),y(we,e),y(fe,e),y(Ce,e),y(Ge,e),y(Ze,e),y(Ae,e),y(Re,e),y(He,e),y(ze,e),y(Fe,e),y(tt,e),y(it,e),y(pt,e),y(rt,e),y(Tt,e),y(Jt,e),y(jt,e),y(bt,e),y(Ct,e),y(It,e),y(Gt,e),y(At,e),y(Rt,e),y(Yt,e),y(Wt,e),y(Lt,e),y(Ot,e),y(tl,e),y(sl,e),y(nl,e),y(ol,e),y(ml,e),y(ul,e),y(jl,e),y(xl,e),y(Bl,e),y(Nl,e),y(vl,e),y($l,e),y(Rl,e),y(Yl,e),y(El,e),y(zl,e),y(Dl,e),y(ts,e),y(is,e),y(os,e),y(Ms,e),y(Js,e),y(js,e),y(fs,e),y(xs,e),y(ks,e),y(Ns,e),y(_s,e),y(Ys,e),y(Ws,e),y(Ls,e),y(Ks,e),y(li,e),y(ai,e),y(ci,e),y(yi,e),y(hi,e),y(fi,e),y(gi,e),y(Qi,e),y(vi,e),y(Ri,e),y(Ei,e),y(Xi,e),y(Ki,e),y(sn,e),y(pn,e)}}}const ju='{"title":"pipelines","local":"pipelines","sections":[{"title":"pipelines.Pipeline ⇐ <code> Callable </code>","local":"pipelinespipeline--code-callable-code","sections":[{"title":"new Pipeline(options)","local":"new-pipelineoptions","sections":[],"depth":3},{"title":"pipeline.dispose() ⇒ <code> Promise. < void > </code>","local":"pipelinedispose--code-promise--void--code","sections":[],"depth":3},{"title":"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>","local":"pipelinecalltexts-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextClassificationPipeline","local":"pipelinestextclassificationpipeline","sections":[{"title":"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TokenClassificationPipeline","local":"pipelinestokenclassificationpipeline","sections":[{"title":"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.QuestionAnsweringPipeline","local":"pipelinesquestionansweringpipeline","sections":[{"title":"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>","local":"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FillMaskPipeline","local":"pipelinesfillmaskpipeline","sections":[{"title":"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.Text2TextGenerationPipeline","local":"pipelinestext2textgenerationpipeline","sections":[{"title":"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>","local":"text2textgenerationpipelinecalltexts-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.SummarizationPipeline","local":"pipelinessummarizationpipeline","sections":[],"depth":2},{"title":"pipelines.TranslationPipeline","local":"pipelinestranslationpipeline","sections":[],"depth":2},{"title":"pipelines.TextGenerationPipeline","local":"pipelinestextgenerationpipeline","sections":[{"title":"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>","local":"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotClassificationPipeline","local":"pipelineszeroshotclassificationpipeline","sections":[{"title":"new ZeroShotClassificationPipeline(options)","local":"new-zeroshotclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FeatureExtractionPipeline","local":"pipelinesfeatureextractionpipeline","sections":[{"title":"featureExtractionPipeline._call(texts, options) ⇒","local":"featureextractionpipelinecalltexts-options-","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AudioClassificationPipeline","local":"pipelinesaudioclassificationpipeline","sections":[{"title":"new AudioClassificationPipeline(options)","local":"new-audioclassificationpipelineoptions","sections":[],"depth":3},{"title":"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AutomaticSpeechRecognitionPipeline","local":"pipelinesautomaticspeechrecognitionpipeline","sections":[{"title":"new AutomaticSpeechRecognitionPipeline(options)","local":"new-automaticspeechrecognitionpipelineoptions","sections":[],"depth":3},{"title":"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>","local":"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToTextPipeline","local":"pipelinesimagetotextpipeline","sections":[{"title":"new ImageToTextPipeline(options)","local":"new-imagetotextpipelineoptions","sections":[],"depth":3},{"title":"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageClassificationPipeline","local":"pipelinesimageclassificationpipeline","sections":[{"title":"new ImageClassificationPipeline(options)","local":"new-imageclassificationpipelineoptions","sections":[],"depth":3},{"title":"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>","local":"imageclassificationpipelinecallimages-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageSegmentationPipeline","local":"pipelinesimagesegmentationpipeline","sections":[{"title":"new ImageSegmentationPipeline(options)","local":"new-imagesegmentationpipelineoptions","sections":[],"depth":3},{"title":"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>","local":"imagesegmentationpipelinecallimages-options--code-promise--array--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotImageClassificationPipeline","local":"pipelineszeroshotimageclassificationpipeline","sections":[{"title":"new ZeroShotImageClassificationPipeline(options)","local":"new-zeroshotimageclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ObjectDetectionPipeline","local":"pipelinesobjectdetectionpipeline","sections":[{"title":"new ObjectDetectionPipeline(options)","local":"new-objectdetectionpipelineoptions","sections":[],"depth":3},{"title":"objectDetectionPipeline._call(images, options)","local":"objectdetectionpipelinecallimages-options","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DocumentQuestionAnsweringPipeline","local":"pipelinesdocumentquestionansweringpipeline","sections":[{"title":"new DocumentQuestionAnsweringPipeline(options)","local":"new-documentquestionansweringpipelineoptions","sections":[],"depth":3},{"title":"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>","local":"pipelinespipelinetask-model-options--code-promise--pipeline--code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringResult : <code> object </code>","local":"pipelinesquestionansweringresult--code-object-code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>","local":"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code","sections":[],"depth":2},{"title":"pipelines~ChunkCallback : <code> function </code>","local":"pipelineschunkcallback--code-function-code","sections":[],"depth":2}],"depth":1}';function Uu(tm){return Tu(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gu extends yu{constructor(w){super(),uu(this,w,Uu,wu,Mu,{})}}export{gu as component};
