import{s as As,n as Ns,o as Gs}from"../chunks/scheduler.9bc65507.js";import{S as Rs,i as xs,g as p,s as l,r as o,A as Fs,h as r,f as e,c as n,j as Hs,u as m,x as i,k as Qs,y as Ss,a as t,v as c,d as y,t as M,w as J}from"../chunks/index.707bf1b6.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{H as fs}from"../chunks/Heading.342b1fa6.js";function zs(Is){let h,S,x,z,u,E,j,Cs='🤗 Transformers provides a <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> class optimized for training 🤗 Transformers models, making it easier to start training without manually writing your own training loop. The <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> provides API for hyperparameter search. This doc shows how to enable it in example.',D,w,L,U,bs=`<a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> supports four hyperparameter search backends currently:
<a href="https://optuna.org/" rel="nofollow">optuna</a>, <a href="https://sigopt.com/" rel="nofollow">sigopt</a>, <a href="https://docs.ray.io/en/latest/tune/index.html" rel="nofollow">raytune</a> and <a href="https://wandb.ai/site/sweeps" rel="nofollow">wandb</a>.`,P,d,gs="you should install them before using them as the hyperparameter search backend",K,f,O,I,ss,C,_s="Define the hyperparameter search space, different backends need different format.",as,b,$s='For sigopt, see sigopt <a href="https://docs.sigopt.com/ai-module-api-references/api_reference/objects/object_parameter" rel="nofollow">object_parameter</a>, it’s like following:',es,g,ts,_,qs='For optuna, see optuna <a href="https://optuna.readthedocs.io/en/stable/tutorial/10_key_features/002_configurations.html#sphx-glr-tutorial-10-key-features-002-configurations-py" rel="nofollow">object_parameter</a>, it’s like following:',ls,$,ns,q,vs='Optuna provides multi-objective HPO. You can pass <code>direction</code> in <code>hyperparameter_search</code> and define your own compute_objective to return multiple objective values. The Pareto Front (<code>List[BestRun]</code>) will be returned in hyperparameter_search, you should refer to the test case <code>TrainerHyperParameterMultiObjectOptunaIntegrationTest</code> in <a href="https://github.com/huggingface/transformers/blob/main/tests/trainer/test_trainer.py" rel="nofollow">test_trainer</a>. It’s like following',ps,v,rs,X,Xs='For raytune, see raytune <a href="https://docs.ray.io/en/latest/tune/api/search_space.html" rel="nofollow">object_parameter</a>, it’s like following:',is,W,os,Y,Ws='For wandb, see wandb <a href="https://docs.wandb.ai/guides/sweeps/configuration" rel="nofollow">object_parameter</a>, it’s like following:',ms,k,cs,B,Ys='Define a <code>model_init</code> function and pass it to the <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>, as an example:',ys,Z,Ms,V,ks='Create a <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> with your <code>model_init</code> function, training arguments, training and test datasets, and evaluation function:',Js,H,hs,Q,Bs="Call hyperparameter search, get the best trial parameters, backend could be <code>&quot;optuna&quot;</code>/<code>&quot;sigopt&quot;</code>/<code>&quot;wandb&quot;</code>/<code>&quot;ray&quot;</code>. direction can be<code>&quot;minimize&quot;</code> or <code>&quot;maximize&quot;</code>, which indicates whether to optimize greater or lower objective.",Ts,A,Zs="You could define your own compute_objective function, if not defined, the default compute_objective will be called, and the sum of eval metric like f1 is returned as objective value.",us,N,js,G,ws,R,Vs="Currently, Hyperparameter search for DDP is enabled for optuna and sigopt. Only the rank-zero process will generate the search trial and pass the argument to other ranks.",Us,F,ds;return u=new fs({props:{title:"Hyperparameter Search using Trainer API",local:"hyperparameter-search-using-trainer-api",headingTag:"h1"}}),w=new fs({props:{title:"Hyperparameter Search backend",local:"hyperparameter-search-backend",headingTag:"h2"}}),f=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdHVuYSUyRnNpZ29wdCUyRndhbmRiJTJGcmF5JTVCdHVuZSU1RCUyMA==",highlighted:"pip install optuna/sigopt/wandb/ray[tune] ",wrap:!1}}),I=new fs({props:{title:"How to enable Hyperparameter search in example",local:"how-to-enable-hyperparameter-search-in-example",headingTag:"h2"}}),g=new T({props:{code:"ZGVmJTIwc2lnb3B0X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMmJvdW5kcyUyMiUzQSUyMCU3QiUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZG91YmxlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcmljYWxfdmFsdWVzJTIyJTNBJTIwJTVCJTIyMTYlMjIlMkMlMjAlMjIzMiUyMiUyQyUyMCUyMjY0JTIyJTJDJTIwJTIyMTI4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJjYXRlZ29yaWNhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sigopt_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;bounds&quot;</span>: {<span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>}, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;double&quot;</span>},
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;categorical_values&quot;</span>: [<span class="hljs-string">&quot;16&quot;</span>, <span class="hljs-string">&quot;32&quot;</span>, <span class="hljs-string">&quot;64&quot;</span>, <span class="hljs-string">&quot;128&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;categorical&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ]`,wrap:!1}}),$=new T({props:{code:"ZGVmJTIwb3B0dW5hX2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2Zsb2F0KCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtNCUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjAlNUIxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">optuna_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),v=new T({props:{code:"YmVzdF90cmlhbHMlMjAlM0QlMjB0cmFpbmVyLmh5cGVycGFyYW1ldGVyX3NlYXJjaCglMEElMjAlMjAlMjAlMjBkaXJlY3Rpb24lM0QlNUIlMjJtaW5pbWl6ZSUyMiUyQyUyMCUyMm1heGltaXplJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trials = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=[<span class="hljs-string">&quot;minimize&quot;</span>, <span class="hljs-string">&quot;maximize&quot;</span>],
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new T({props:{code:"ZGVmJTIwcmF5X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0dW5lLmxvZ3VuaWZvcm0oMWUtNiUyQyUyMDFlLTQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHVuZS5jaG9pY2UoJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEKSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">ray_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: tune.loguniform(<span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: tune.choice([<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),k=new T({props:{code:"ZGVmJTIwd2FuZGJfaHBfc3BhY2UodHJpYWwpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0aG9kJTIyJTNBJTIwJTIycmFuZG9tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljJTIyJTNBJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMm9iamVjdGl2ZSUyMiUyQyUyMCUyMmdvYWwlMjIlM0ElMjAlMjJtaW5pbWl6ZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwJTdCJTIyZGlzdHJpYnV0aW9uJTIyJTNBJTIwJTIydW5pZm9ybSUyMiUyQyUyMCUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwJTdCJTIydmFsdWVzJTIyJTNBJTIwJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">wandb_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;method&quot;</span>: <span class="hljs-string">&quot;random&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;metric&quot;</span>: {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;objective&quot;</span>, <span class="hljs-string">&quot;goal&quot;</span>: <span class="hljs-string">&quot;minimize&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;learning_rate&quot;</span>: {<span class="hljs-string">&quot;distribution&quot;</span>: <span class="hljs-string">&quot;uniform&quot;</span>, <span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: {<span class="hljs-string">&quot;values&quot;</span>: [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    }`,wrap:!1}}),Z=new T({props:{code:"ZGVmJTIwbW9kZWxfaW5pdCh0cmlhbCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyb21fdGYlM0Rib29sKCUyMi5ja3B0JTIyJTIwaW4lMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWclM0Rjb25maWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9kaXIlM0Rtb2RlbF9hcmdzLmNhY2hlX2RpciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUyMGlmJTIwbW9kZWxfYXJncy51c2VfYXV0aF90b2tlbiUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>        model_args.model_name_or_path,
<span class="hljs-meta">... </span>        from_tf=<span class="hljs-built_in">bool</span>(<span class="hljs-string">&quot;.ckpt&quot;</span> <span class="hljs-keyword">in</span> model_args.model_name_or_path),
<span class="hljs-meta">... </span>        config=config,
<span class="hljs-meta">... </span>        cache_dir=model_args.cache_dir,
<span class="hljs-meta">... </span>        revision=model_args.model_revision,
<span class="hljs-meta">... </span>        use_auth_token=<span class="hljs-literal">True</span> <span class="hljs-keyword">if</span> model_args.use_auth_token <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),H=new T({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEc21hbGxfdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHNtYWxsX2V2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXQlM0Rtb2RlbF9pbml0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    model_init=model_init,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new T({props:{code:"YmVzdF90cmlhbCUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trial = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),G=new fs({props:{title:"Hyperparameter search For DDP finetune",local:"hyperparameter-search-for-ddp-finetune",headingTag:"h2"}}),{c(){h=p("meta"),S=l(),x=p("p"),z=l(),o(u.$$.fragment),E=l(),j=p("p"),j.innerHTML=Cs,D=l(),o(w.$$.fragment),L=l(),U=p("p"),U.innerHTML=bs,P=l(),d=p("p"),d.textContent=gs,K=l(),o(f.$$.fragment),O=l(),o(I.$$.fragment),ss=l(),C=p("p"),C.textContent=_s,as=l(),b=p("p"),b.innerHTML=$s,es=l(),o(g.$$.fragment),ts=l(),_=p("p"),_.innerHTML=qs,ls=l(),o($.$$.fragment),ns=l(),q=p("p"),q.innerHTML=vs,ps=l(),o(v.$$.fragment),rs=l(),X=p("p"),X.innerHTML=Xs,is=l(),o(W.$$.fragment),os=l(),Y=p("p"),Y.innerHTML=Ws,ms=l(),o(k.$$.fragment),cs=l(),B=p("p"),B.innerHTML=Ys,ys=l(),o(Z.$$.fragment),Ms=l(),V=p("p"),V.innerHTML=ks,Js=l(),o(H.$$.fragment),hs=l(),Q=p("p"),Q.innerHTML=Bs,Ts=l(),A=p("p"),A.textContent=Zs,us=l(),o(N.$$.fragment),js=l(),o(G.$$.fragment),ws=l(),R=p("p"),R.textContent=Vs,Us=l(),F=p("p"),this.h()},l(s){const a=Fs("svelte-u9bgzb",document.head);h=r(a,"META",{name:!0,content:!0}),a.forEach(e),S=n(s),x=r(s,"P",{}),Hs(x).forEach(e),z=n(s),m(u.$$.fragment,s),E=n(s),j=r(s,"P",{"data-svelte-h":!0}),i(j)!=="svelte-ypngjw"&&(j.innerHTML=Cs),D=n(s),m(w.$$.fragment,s),L=n(s),U=r(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1dmffdr"&&(U.innerHTML=bs),P=n(s),d=r(s,"P",{"data-svelte-h":!0}),i(d)!=="svelte-ttiwiu"&&(d.textContent=gs),K=n(s),m(f.$$.fragment,s),O=n(s),m(I.$$.fragment,s),ss=n(s),C=r(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1jwax0f"&&(C.textContent=_s),as=n(s),b=r(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-dng8fq"&&(b.innerHTML=$s),es=n(s),m(g.$$.fragment,s),ts=n(s),_=r(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1o2m9k6"&&(_.innerHTML=qs),ls=n(s),m($.$$.fragment,s),ns=n(s),q=r(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-e3s4e6"&&(q.innerHTML=vs),ps=n(s),m(v.$$.fragment,s),rs=n(s),X=r(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1fs958e"&&(X.innerHTML=Xs),is=n(s),m(W.$$.fragment,s),os=n(s),Y=r(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-uzyw2c"&&(Y.innerHTML=Ws),ms=n(s),m(k.$$.fragment,s),cs=n(s),B=r(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1qp7v5y"&&(B.innerHTML=Ys),ys=n(s),m(Z.$$.fragment,s),Ms=n(s),V=r(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-n22xdz"&&(V.innerHTML=ks),Js=n(s),m(H.$$.fragment,s),hs=n(s),Q=r(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-rd47zq"&&(Q.innerHTML=Bs),Ts=n(s),A=r(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-v9khww"&&(A.textContent=Zs),us=n(s),m(N.$$.fragment,s),js=n(s),m(G.$$.fragment,s),ws=n(s),R=r(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1ib1l1l"&&(R.textContent=Vs),Us=n(s),F=r(s,"P",{}),Hs(F).forEach(e),this.h()},h(){Qs(h,"name","hf:doc:metadata"),Qs(h,"content",Es)},m(s,a){Ss(document.head,h),t(s,S,a),t(s,x,a),t(s,z,a),c(u,s,a),t(s,E,a),t(s,j,a),t(s,D,a),c(w,s,a),t(s,L,a),t(s,U,a),t(s,P,a),t(s,d,a),t(s,K,a),c(f,s,a),t(s,O,a),c(I,s,a),t(s,ss,a),t(s,C,a),t(s,as,a),t(s,b,a),t(s,es,a),c(g,s,a),t(s,ts,a),t(s,_,a),t(s,ls,a),c($,s,a),t(s,ns,a),t(s,q,a),t(s,ps,a),c(v,s,a),t(s,rs,a),t(s,X,a),t(s,is,a),c(W,s,a),t(s,os,a),t(s,Y,a),t(s,ms,a),c(k,s,a),t(s,cs,a),t(s,B,a),t(s,ys,a),c(Z,s,a),t(s,Ms,a),t(s,V,a),t(s,Js,a),c(H,s,a),t(s,hs,a),t(s,Q,a),t(s,Ts,a),t(s,A,a),t(s,us,a),c(N,s,a),t(s,js,a),c(G,s,a),t(s,ws,a),t(s,R,a),t(s,Us,a),t(s,F,a),ds=!0},p:Ns,i(s){ds||(y(u.$$.fragment,s),y(w.$$.fragment,s),y(f.$$.fragment,s),y(I.$$.fragment,s),y(g.$$.fragment,s),y($.$$.fragment,s),y(v.$$.fragment,s),y(W.$$.fragment,s),y(k.$$.fragment,s),y(Z.$$.fragment,s),y(H.$$.fragment,s),y(N.$$.fragment,s),y(G.$$.fragment,s),ds=!0)},o(s){M(u.$$.fragment,s),M(w.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(g.$$.fragment,s),M($.$$.fragment,s),M(v.$$.fragment,s),M(W.$$.fragment,s),M(k.$$.fragment,s),M(Z.$$.fragment,s),M(H.$$.fragment,s),M(N.$$.fragment,s),M(G.$$.fragment,s),ds=!1},d(s){s&&(e(S),e(x),e(z),e(E),e(j),e(D),e(L),e(U),e(P),e(d),e(K),e(O),e(ss),e(C),e(as),e(b),e(es),e(ts),e(_),e(ls),e(ns),e(q),e(ps),e(rs),e(X),e(is),e(os),e(Y),e(ms),e(cs),e(B),e(ys),e(Ms),e(V),e(Js),e(hs),e(Q),e(Ts),e(A),e(us),e(js),e(ws),e(R),e(Us),e(F)),e(h),J(u,s),J(w,s),J(f,s),J(I,s),J(g,s),J($,s),J(v,s),J(W,s),J(k,s),J(Z,s),J(H,s),J(N,s),J(G,s)}}}const Es='{"title":"Hyperparameter Search using Trainer API","local":"hyperparameter-search-using-trainer-api","sections":[{"title":"Hyperparameter Search backend","local":"hyperparameter-search-backend","sections":[],"depth":2},{"title":"How to enable Hyperparameter search in example","local":"how-to-enable-hyperparameter-search-in-example","sections":[],"depth":2},{"title":"Hyperparameter search For DDP finetune","local":"hyperparameter-search-for-ddp-finetune","sections":[],"depth":2}],"depth":1}';function Ds(Is){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Rs{constructor(h){super(),xs(this,h,Ds,zs,As,{})}}export{sa as component};
