import{s as vt,o as Rt,n as Ge}from"../chunks/scheduler.8c3d61f6.js";import{S as Xt,i as It,g as m,s as i,r as c,A as Gt,h as d,f as s,c as o,j as _t,u as M,x as f,k as ft,y as zt,a as l,v as J,d as b,t as h,w as T}from"../chunks/index.da70eac4.js";import{T as Ie}from"../chunks/Tip.1d9b8c37.js";import{C as N}from"../chunks/CodeBlock.a9c4becf.js";import{H as ee,E as kt}from"../chunks/index.a831177d.js";import{H as qt,a as $t}from"../chunks/HfOption.6ab18950.js";function Qt(R){let a,w='The <code>CLIPTextModel</code> and <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.';return{c(){a=m("p"),a.innerHTML=w},l(p){a=d(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1bd21r0"&&(a.innerHTML=w)},m(p,u){l(p,a,u)},p:Ge,d(p){p&&s(a)}}}function Nt(R){let a,w="Quantizing a model in 8-bit halves the memory-usage:",p,u,y=`bitsandbytes is supported in both Transformers and Diffusers, so you can quantize both the
<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,g,U,S="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",W,j,x,_,k,X,D="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",q,I,V,B,te="Let’s generate an image using our quantized models.",F,C,P=`Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the
CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.`,Q,G,E,Z,K='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/8bit.png"/>',z,$,Y='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',L,v,H='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 8-bit models locally with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',A;return j=new Ie({props:{warning:!1,$$slots:{default:[Qt]},$$scope:{ctx:R}}}),_=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlJTJDKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzhiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlJTJDKSUwQSUwQXRyYW5zZm9ybWVyXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

transformer_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),I=new N({props:{code:"dHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTJCJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`transformer_8bit = AutoModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),G=new N({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSgqKnBpcGVfa3dhcmdzJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCklMkMpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_8bit,
    text_encoder_2=text_encoder_2_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=m("p"),a.textContent=w,p=i(),u=m("p"),u.innerHTML=y,g=i(),U=m("p"),U.innerHTML=S,W=i(),c(j.$$.fragment),x=i(),c(_.$$.fragment),k=i(),X=m("p"),X.innerHTML=D,q=i(),c(I.$$.fragment),V=i(),B=m("p"),B.textContent=te,F=i(),C=m("p"),C.innerHTML=P,Q=i(),c(G.$$.fragment),E=i(),Z=m("div"),Z.innerHTML=K,z=i(),$=m("p"),$.innerHTML=Y,L=i(),v=m("p"),v.innerHTML=H,this.h()},l(t){a=d(t,"P",{"data-svelte-h":!0}),f(a)!=="svelte-4djpqq"&&(a.textContent=w),p=o(t),u=d(t,"P",{"data-svelte-h":!0}),f(u)!=="svelte-8t0085"&&(u.innerHTML=y),g=o(t),U=d(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-mdqrzc"&&(U.innerHTML=S),W=o(t),M(j.$$.fragment,t),x=o(t),M(_.$$.fragment,t),k=o(t),X=d(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1qozsrk"&&(X.innerHTML=D),q=o(t),M(I.$$.fragment,t),V=o(t),B=d(t,"P",{"data-svelte-h":!0}),f(B)!=="svelte-2bde4h"&&(B.textContent=te),F=o(t),C=d(t,"P",{"data-svelte-h":!0}),f(C)!=="svelte-1eyrcy7"&&(C.innerHTML=P),Q=o(t),M(G.$$.fragment,t),E=o(t),Z=d(t,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-14afenp"&&(Z.innerHTML=K),z=o(t),$=d(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-uz8m1k"&&($.innerHTML=Y),L=o(t),v=d(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-13z5cfr"&&(v.innerHTML=H),this.h()},h(){ft(Z,"class","flex justify-center")},m(t,r){l(t,a,r),l(t,p,r),l(t,u,r),l(t,g,r),l(t,U,r),l(t,W,r),J(j,t,r),l(t,x,r),J(_,t,r),l(t,k,r),l(t,X,r),l(t,q,r),J(I,t,r),l(t,V,r),l(t,B,r),l(t,F,r),l(t,C,r),l(t,Q,r),J(G,t,r),l(t,E,r),l(t,Z,r),l(t,z,r),l(t,$,r),l(t,L,r),l(t,v,r),A=!0},p(t,r){const O={};r&2&&(O.$$scope={dirty:r,ctx:t}),j.$set(O)},i(t){A||(b(j.$$.fragment,t),b(_.$$.fragment,t),b(I.$$.fragment,t),b(G.$$.fragment,t),A=!0)},o(t){h(j.$$.fragment,t),h(_.$$.fragment,t),h(I.$$.fragment,t),h(G.$$.fragment,t),A=!1},d(t){t&&(s(a),s(p),s(u),s(g),s(U),s(W),s(x),s(k),s(X),s(q),s(V),s(B),s(F),s(C),s(Q),s(E),s(Z),s(z),s($),s(L),s(v)),T(j,t),T(_,t),T(I,t),T(G,t)}}}function Wt(R){let a,w='The <code>CLIPTextModel</code> and <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.';return{c(){a=m("p"),a.innerHTML=w},l(p){a=d(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1bd21r0"&&(a.innerHTML=w)},m(p,u){l(p,a,u)},p:Ge,d(p){p&&s(a)}}}function Vt(R){let a,w="Quantizing a model in 4-bit reduces your memory-usage by 4x:",p,u,y=`bitsandbytes is supported in both Transformers and Diffusers, so you can can quantize both the
<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,g,U,S="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",W,j,x,_,k,X,D="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",q,I,V,B,te="Let’s generate an image using our quantized models.",F,C,P="Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.",Q,G,E,Z,K='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/4bit.png"/>',z,$,Y='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',L,v,H='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 4-bit models locally with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',A;return j=new Ie({props:{warning:!1,$$slots:{default:[Wt]},$$scope:{ctx:R}}}),_=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDKSUwQSUwQXRyYW5zZm9ybWVyXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),I=new N({props:{code:"dHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTJCJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`transformer_4bit = AutoModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),G=new N({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSgqKnBpcGVfa3dhcmdzJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCklMkMpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_4bit,
    text_encoder_2=text_encoder_2_4bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=m("p"),a.textContent=w,p=i(),u=m("p"),u.innerHTML=y,g=i(),U=m("p"),U.innerHTML=S,W=i(),c(j.$$.fragment),x=i(),c(_.$$.fragment),k=i(),X=m("p"),X.innerHTML=D,q=i(),c(I.$$.fragment),V=i(),B=m("p"),B.textContent=te,F=i(),C=m("p"),C.innerHTML=P,Q=i(),c(G.$$.fragment),E=i(),Z=m("div"),Z.innerHTML=K,z=i(),$=m("p"),$.innerHTML=Y,L=i(),v=m("p"),v.innerHTML=H,this.h()},l(t){a=d(t,"P",{"data-svelte-h":!0}),f(a)!=="svelte-i07c71"&&(a.textContent=w),p=o(t),u=d(t,"P",{"data-svelte-h":!0}),f(u)!=="svelte-q3mf8r"&&(u.innerHTML=y),g=o(t),U=d(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-mdqrzc"&&(U.innerHTML=S),W=o(t),M(j.$$.fragment,t),x=o(t),M(_.$$.fragment,t),k=o(t),X=d(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1qozsrk"&&(X.innerHTML=D),q=o(t),M(I.$$.fragment,t),V=o(t),B=d(t,"P",{"data-svelte-h":!0}),f(B)!=="svelte-2bde4h"&&(B.textContent=te),F=o(t),C=d(t,"P",{"data-svelte-h":!0}),f(C)!=="svelte-6ilppp"&&(C.innerHTML=P),Q=o(t),M(G.$$.fragment,t),E=o(t),Z=d(t,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-qev6y1"&&(Z.innerHTML=K),z=o(t),$=d(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-uz8m1k"&&($.innerHTML=Y),L=o(t),v=d(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1wxqg1v"&&(v.innerHTML=H),this.h()},h(){ft(Z,"class","flex justify-center")},m(t,r){l(t,a,r),l(t,p,r),l(t,u,r),l(t,g,r),l(t,U,r),l(t,W,r),J(j,t,r),l(t,x,r),J(_,t,r),l(t,k,r),l(t,X,r),l(t,q,r),J(I,t,r),l(t,V,r),l(t,B,r),l(t,F,r),l(t,C,r),l(t,Q,r),J(G,t,r),l(t,E,r),l(t,Z,r),l(t,z,r),l(t,$,r),l(t,L,r),l(t,v,r),A=!0},p(t,r){const O={};r&2&&(O.$$scope={dirty:r,ctx:t}),j.$set(O)},i(t){A||(b(j.$$.fragment,t),b(_.$$.fragment,t),b(I.$$.fragment,t),b(G.$$.fragment,t),A=!0)},o(t){h(j.$$.fragment,t),h(_.$$.fragment,t),h(I.$$.fragment,t),h(G.$$.fragment,t),A=!1},d(t){t&&(s(a),s(p),s(u),s(g),s(U),s(W),s(x),s(k),s(X),s(q),s(V),s(B),s(F),s(C),s(Q),s(E),s(Z),s(z),s($),s(L),s(v)),T(j,t),T(_,t),T(I,t),T(G,t)}}}function Ft(R){let a,w,p,u;return a=new $t({props:{id:"bnb",option:"8-bit",$$slots:{default:[Nt]},$$scope:{ctx:R}}}),p=new $t({props:{id:"bnb",option:"4-bit",$$slots:{default:[Vt]},$$scope:{ctx:R}}}),{c(){c(a.$$.fragment),w=i(),c(p.$$.fragment)},l(y){M(a.$$.fragment,y),w=o(y),M(p.$$.fragment,y)},m(y,g){J(a,y,g),l(y,w,g),J(p,y,g),u=!0},p(y,g){const U={};g&2&&(U.$$scope={dirty:g,ctx:y}),a.$set(U);const S={};g&2&&(S.$$scope={dirty:g,ctx:y}),p.$set(S)},i(y){u||(b(a.$$.fragment,y),b(p.$$.fragment,y),u=!0)},o(y){h(a.$$.fragment,y),h(p.$$.fragment,y),u=!1},d(y){y&&s(w),T(a,y),T(p,y)}}}function Et(R){let a,w="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){a=m("p"),a.innerHTML=w},l(p){a=d(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-of9sym"&&(a.innerHTML=w)},m(p,u){l(p,a,u)},p:Ge,d(p){p&&s(a)}}}function At(R){let a,w='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){a=m("p"),a.innerHTML=w},l(p){a=d(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1bb05fp"&&(a.innerHTML=w)},m(p,u){l(p,a,u)},p:Ge,d(p){p&&s(a)}}}function Yt(R){let a,w='Learn more about its details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){a=m("p"),a.innerHTML=w},l(p){a=d(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kpdzjq"&&(a.innerHTML=w)},m(p,u){l(p,a,u)},p:Ge,d(p){p&&s(a)}}}function Ht(R){let a,w,p,u,y,g,U,S='<a href="https://huggingface.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance.',W,j,x='4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',_,k,X=`This guide demonstrates how quantization can enable running
<a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a>
on less than 16GB of VRAM and even on a free Google
Colab instance.`,D,q,I='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/comparison.png" alt="comparison image"/>',V,B,te="To use bitsandbytes, make sure you have the following libraries installed:",F,C,P,Q,G='Now you can quantize a model by passing a <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',E,Z,K,z,$,Y,L="Check your memory footprint with the <code>get_memory_footprint</code> method:",v,H,A,t,r='Quantized models can be loaded from the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method without needing to specify the <code>quantization_config</code> parameters:',O,ne,ze,ae,ke,se,qe,ie,ut="This section explores some of the specific features of 8-bit models, such as outlier thresholds and skipping module conversion.",Qe,oe,Ne,re,yt="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",We,pe,ct='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ve,me,Fe,de,Ee,fe,Mt='For some models, you don’t need to quantize every module to 8-bit which can actually cause instability. For example, for diffusion models like <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>, the <code>proj_out</code> module can be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ae,ue,Ye,ye,He,le,xe,ce,Jt="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",Le,Me,Se,Je,bt='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',De,be,Pe,he,Ke,Te,ht='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Oe,we,et,Ue,Tt="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",tt,Ze,st,je,wt="Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter.",lt,ge,nt,Be,at,Ce,Ut="Once quantized, you can dequantize a model to its original precision, but this might result in a small loss of quality. Make sure you have enough GPU RAM to fit the dequantized model.",it,_e,ot,$e,rt,ve,Zt='<li><a href="https://gist.github.com/sayakpaul/c76bd845b48759e11687ac550b99d8b4" rel="nofollow">End-to-end notebook showing Flux.1 Dev inference in a free-tier Colab</a></li> <li><a href="https://gist.github.com/sayakpaul/05afd428bc089b47af7c016e42004527" rel="nofollow">Training</a></li>',pt,Re,mt,Xe,dt;return y=new ee({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),C=new N({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMjAtVQ==",highlighted:"pip install diffusers transformers accelerate bitsandbytes -U",wrap:!1}}),Z=new qt({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Ft]},$$scope:{ctx:R}}}),z=new Ie({props:{warning:!0,$$slots:{default:[Et]},$$scope:{ctx:R}}}),H=new N({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),ne=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSklMEElMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZmx1eC4xLWRldi1uZjQtcGtnJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;hf-internal-testing/flux.1-dev-nf4-pkg&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>
)`,wrap:!1}}),ae=new ee({props:{title:"8-bit (LLM.int8() algorithm)",local:"8-bit-llmint8-algorithm",headingTag:"h2"}}),se=new Ie({props:{$$slots:{default:[At]},$$scope:{ctx:R}}}),oe=new ee({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),me=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3RocmVzaG9sZCUzRDEwJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),de=new ee({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),ue=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3NraXBfbW9kdWxlcyUzRCU1QiUyMnByb2pfb3V0JTIyJTVEJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_skip_modules=[<span class="hljs-string">&quot;proj_out&quot;</span>],
)

model_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),ye=new ee({props:{title:"4-bit (QLoRA algorithm)",local:"4-bit-qlora-algorithm",headingTag:"h2"}}),le=new Ie({props:{$$slots:{default:[Yt]},$$scope:{ctx:R}}}),Me=new ee({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),be=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),he=new ee({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),we=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Ze=new ee({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),ge=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Be=new ee({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),_e=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdC5kZXF1YW50aXplKCklMEF0cmFuc2Zvcm1lcl80Yml0LmRlcXVhbnRpemUoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

text_encoder_2_4bit.dequantize()
transformer_4bit.dequantize()`,wrap:!1}}),$e=new ee({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Re=new kt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){a=m("meta"),w=i(),p=m("p"),u=i(),c(y.$$.fragment),g=i(),U=m("p"),U.innerHTML=S,W=i(),j=m("p"),j.innerHTML=x,_=i(),k=m("p"),k.innerHTML=X,D=i(),q=m("p"),q.innerHTML=I,V=i(),B=m("p"),B.textContent=te,F=i(),c(C.$$.fragment),P=i(),Q=m("p"),Q.innerHTML=G,E=i(),c(Z.$$.fragment),K=i(),c(z.$$.fragment),$=i(),Y=m("p"),Y.innerHTML=L,v=i(),c(H.$$.fragment),A=i(),t=m("p"),t.innerHTML=r,O=i(),c(ne.$$.fragment),ze=i(),c(ae.$$.fragment),ke=i(),c(se.$$.fragment),qe=i(),ie=m("p"),ie.textContent=ut,Qe=i(),c(oe.$$.fragment),Ne=i(),re=m("p"),re.textContent=yt,We=i(),pe=m("p"),pe.innerHTML=ct,Ve=i(),c(me.$$.fragment),Fe=i(),c(de.$$.fragment),Ee=i(),fe=m("p"),fe.innerHTML=Mt,Ae=i(),c(ue.$$.fragment),Ye=i(),c(ye.$$.fragment),He=i(),c(le.$$.fragment),xe=i(),ce=m("p"),ce.textContent=Jt,Le=i(),c(Me.$$.fragment),Se=i(),Je=m("p"),Je.innerHTML=bt,De=i(),c(be.$$.fragment),Pe=i(),c(he.$$.fragment),Ke=i(),Te=m("p"),Te.innerHTML=ht,Oe=i(),c(we.$$.fragment),et=i(),Ue=m("p"),Ue.innerHTML=Tt,tt=i(),c(Ze.$$.fragment),st=i(),je=m("p"),je.textContent=wt,lt=i(),c(ge.$$.fragment),nt=i(),c(Be.$$.fragment),at=i(),Ce=m("p"),Ce.textContent=Ut,it=i(),c(_e.$$.fragment),ot=i(),c($e.$$.fragment),rt=i(),ve=m("ul"),ve.innerHTML=Zt,pt=i(),c(Re.$$.fragment),mt=i(),Xe=m("p"),this.h()},l(e){const n=Gt("svelte-u9bgzb",document.head);a=d(n,"META",{name:!0,content:!0}),n.forEach(s),w=o(e),p=d(e,"P",{}),_t(p).forEach(s),u=o(e),M(y.$$.fragment,e),g=o(e),U=d(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1m50ob7"&&(U.innerHTML=S),W=o(e),j=d(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-11pyf03"&&(j.innerHTML=x),_=o(e),k=d(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1erhi5i"&&(k.innerHTML=X),D=o(e),q=d(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-ryfe7d"&&(q.innerHTML=I),V=o(e),B=d(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-gf36q7"&&(B.textContent=te),F=o(e),M(C.$$.fragment,e),P=o(e),Q=d(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-17fqaf"&&(Q.innerHTML=G),E=o(e),M(Z.$$.fragment,e),K=o(e),M(z.$$.fragment,e),$=o(e),Y=d(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-139tok6"&&(Y.innerHTML=L),v=o(e),M(H.$$.fragment,e),A=o(e),t=d(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-10wvd51"&&(t.innerHTML=r),O=o(e),M(ne.$$.fragment,e),ze=o(e),M(ae.$$.fragment,e),ke=o(e),M(se.$$.fragment,e),qe=o(e),ie=d(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1myadau"&&(ie.textContent=ut),Qe=o(e),M(oe.$$.fragment,e),Ne=o(e),re=d(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-ur5rgd"&&(re.textContent=yt),We=o(e),pe=d(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1pta66b"&&(pe.innerHTML=ct),Ve=o(e),M(me.$$.fragment,e),Fe=o(e),M(de.$$.fragment,e),Ee=o(e),fe=d(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1rff4ou"&&(fe.innerHTML=Mt),Ae=o(e),M(ue.$$.fragment,e),Ye=o(e),M(ye.$$.fragment,e),He=o(e),M(le.$$.fragment,e),xe=o(e),ce=d(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-7ob7j"&&(ce.textContent=Jt),Le=o(e),M(Me.$$.fragment,e),Se=o(e),Je=d(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-19knmj2"&&(Je.innerHTML=bt),De=o(e),M(be.$$.fragment,e),Pe=o(e),M(he.$$.fragment,e),Ke=o(e),Te=d(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-6pxdrm"&&(Te.innerHTML=ht),Oe=o(e),M(we.$$.fragment,e),et=o(e),Ue=d(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1qoc2ct"&&(Ue.innerHTML=Tt),tt=o(e),M(Ze.$$.fragment,e),st=o(e),je=d(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-ep1hhf"&&(je.textContent=wt),lt=o(e),M(ge.$$.fragment,e),nt=o(e),M(Be.$$.fragment,e),at=o(e),Ce=d(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-lubruw"&&(Ce.textContent=Ut),it=o(e),M(_e.$$.fragment,e),ot=o(e),M($e.$$.fragment,e),rt=o(e),ve=d(e,"UL",{"data-svelte-h":!0}),f(ve)!=="svelte-vejlmz"&&(ve.innerHTML=Zt),pt=o(e),M(Re.$$.fragment,e),mt=o(e),Xe=d(e,"P",{}),_t(Xe).forEach(s),this.h()},h(){ft(a,"name","hf:doc:metadata"),ft(a,"content",xt)},m(e,n){zt(document.head,a),l(e,w,n),l(e,p,n),l(e,u,n),J(y,e,n),l(e,g,n),l(e,U,n),l(e,W,n),l(e,j,n),l(e,_,n),l(e,k,n),l(e,D,n),l(e,q,n),l(e,V,n),l(e,B,n),l(e,F,n),J(C,e,n),l(e,P,n),l(e,Q,n),l(e,E,n),J(Z,e,n),l(e,K,n),J(z,e,n),l(e,$,n),l(e,Y,n),l(e,v,n),J(H,e,n),l(e,A,n),l(e,t,n),l(e,O,n),J(ne,e,n),l(e,ze,n),J(ae,e,n),l(e,ke,n),J(se,e,n),l(e,qe,n),l(e,ie,n),l(e,Qe,n),J(oe,e,n),l(e,Ne,n),l(e,re,n),l(e,We,n),l(e,pe,n),l(e,Ve,n),J(me,e,n),l(e,Fe,n),J(de,e,n),l(e,Ee,n),l(e,fe,n),l(e,Ae,n),J(ue,e,n),l(e,Ye,n),J(ye,e,n),l(e,He,n),J(le,e,n),l(e,xe,n),l(e,ce,n),l(e,Le,n),J(Me,e,n),l(e,Se,n),l(e,Je,n),l(e,De,n),J(be,e,n),l(e,Pe,n),J(he,e,n),l(e,Ke,n),l(e,Te,n),l(e,Oe,n),J(we,e,n),l(e,et,n),l(e,Ue,n),l(e,tt,n),J(Ze,e,n),l(e,st,n),l(e,je,n),l(e,lt,n),J(ge,e,n),l(e,nt,n),J(Be,e,n),l(e,at,n),l(e,Ce,n),l(e,it,n),J(_e,e,n),l(e,ot,n),J($e,e,n),l(e,rt,n),l(e,ve,n),l(e,pt,n),J(Re,e,n),l(e,mt,n),l(e,Xe,n),dt=!0},p(e,[n]){const jt={};n&2&&(jt.$$scope={dirty:n,ctx:e}),Z.$set(jt);const gt={};n&2&&(gt.$$scope={dirty:n,ctx:e}),z.$set(gt);const Bt={};n&2&&(Bt.$$scope={dirty:n,ctx:e}),se.$set(Bt);const Ct={};n&2&&(Ct.$$scope={dirty:n,ctx:e}),le.$set(Ct)},i(e){dt||(b(y.$$.fragment,e),b(C.$$.fragment,e),b(Z.$$.fragment,e),b(z.$$.fragment,e),b(H.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(oe.$$.fragment,e),b(me.$$.fragment,e),b(de.$$.fragment,e),b(ue.$$.fragment,e),b(ye.$$.fragment,e),b(le.$$.fragment,e),b(Me.$$.fragment,e),b(be.$$.fragment,e),b(he.$$.fragment,e),b(we.$$.fragment,e),b(Ze.$$.fragment,e),b(ge.$$.fragment,e),b(Be.$$.fragment,e),b(_e.$$.fragment,e),b($e.$$.fragment,e),b(Re.$$.fragment,e),dt=!0)},o(e){h(y.$$.fragment,e),h(C.$$.fragment,e),h(Z.$$.fragment,e),h(z.$$.fragment,e),h(H.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(le.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(he.$$.fragment,e),h(we.$$.fragment,e),h(Ze.$$.fragment,e),h(ge.$$.fragment,e),h(Be.$$.fragment,e),h(_e.$$.fragment,e),h($e.$$.fragment,e),h(Re.$$.fragment,e),dt=!1},d(e){e&&(s(w),s(p),s(u),s(g),s(U),s(W),s(j),s(_),s(k),s(D),s(q),s(V),s(B),s(F),s(P),s(Q),s(E),s(K),s($),s(Y),s(v),s(A),s(t),s(O),s(ze),s(ke),s(qe),s(ie),s(Qe),s(Ne),s(re),s(We),s(pe),s(Ve),s(Fe),s(Ee),s(fe),s(Ae),s(Ye),s(He),s(xe),s(ce),s(Le),s(Se),s(Je),s(De),s(Pe),s(Ke),s(Te),s(Oe),s(et),s(Ue),s(tt),s(st),s(je),s(lt),s(nt),s(at),s(Ce),s(it),s(ot),s(rt),s(ve),s(pt),s(mt),s(Xe)),s(a),T(y,e),T(C,e),T(Z,e),T(z,e),T(H,e),T(ne,e),T(ae,e),T(se,e),T(oe,e),T(me,e),T(de,e),T(ue,e),T(ye,e),T(le,e),T(Me,e),T(be,e),T(he,e),T(we,e),T(Ze,e),T(ge,e),T(Be,e),T(_e,e),T($e,e),T(Re,e)}}}const xt='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit (LLM.int8() algorithm)","local":"8-bit-llmint8-algorithm","sections":[{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3}],"depth":2},{"title":"4-bit (QLoRA algorithm)","local":"4-bit-qlora-algorithm","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Lt(R){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Xt{constructor(a){super(),It(this,a,Lt,Ht,vt,{})}}export{ts as component};
