import{S as Yi,i as Gi,s as Vi,e as n,k as d,w as p,t as s,M as Qi,c as r,d as l,m as f,a as i,x as y,h as o,b as h,G as t,g as c,y as M,q as w,o as J,B as b,v as zi}from"../chunks/vendor-hf-doc-builder.js";import{T as ar}from"../chunks/Tip-hf-doc-builder.js";import{I as Wt}from"../chunks/IconCopyLink-hf-doc-builder.js";import{C as U}from"../chunks/CodeBlock-hf-doc-builder.js";function Fi(K){let m,_;return{c(){m=n("p"),_=s("If your model is very similar to a model inside the library, you can re-use the same configuration as this model.")},l(u){m=r(u,"P",{});var T=i(m);_=o(T,"If your model is very similar to a model inside the library, you can re-use the same configuration as this model."),T.forEach(l)},m(u,T){c(u,m,T),t(m,_)},d(u){u&&l(m)}}}function Si(K){let m,_;return{c(){m=n("p"),_=s("This API is experimental and may have some slight breaking changes in the next releases.")},l(u){m=r(u,"P",{});var T=i(m);_=o(T,"This API is experimental and may have some slight breaking changes in the next releases."),T.forEach(l)},m(u,T){c(u,m,T),t(m,_)},d(u){u&&l(m)}}}function Hi(K){let m,_,u,T,S;return{c(){m=n("p"),_=s(`If copying a modeling files from the library, you will need to replace all the relative imports at the top of the file
to import from the `),u=n("code"),T=s("transformers"),S=s(" package.")},l(I){m=r(I,"P",{});var N=i(m);_=o(N,`If copying a modeling files from the library, you will need to replace all the relative imports at the top of the file
to import from the `),u=r(N,"CODE",{});var ee=i(u);T=o(ee,"transformers"),ee.forEach(l),S=o(N," package."),N.forEach(l)},m(I,N){c(I,m,N),t(m,_),t(m,u),t(u,T),t(m,S)},d(I){I&&l(m)}}}function xi(K){let m,_,u,T,S,I,N,ee,to,kl,xe,lo,Nl,Pe,so,$l,$,oo,be,ao,no,De,ro,io,Wl,H,te,Bt,Te,co,Rt,fo,Bl,le,ho,Xt,mo,uo,Rl,qe,po,Xl,je,Yl,Oe,yo,Gl,W,Ue,Mo,Yt,wo,Jo,bo,x,To,Gt,jo,Uo,Vt,_o,go,Co,P,Io,Qt,vo,Eo,zt,Zo,Ao,Vl,B,ko,Ft,No,$o,St,Wo,Bo,Ql,R,Ro,Ht,Xo,Yo,xt,Go,Vo,zl,Le,Qo,Fl,_e,Sl,v,zo,Pt,Fo,So,Dt,Ho,xo,qt,Po,Do,Hl,ge,xl,X,qo,Ke,Oo,Lo,et,Ko,ea,Pl,D,se,Ot,Ce,ta,Lt,la,Dl,Y,sa,tt,oa,aa,lt,na,ra,ql,oe,ia,Kt,ca,da,Ol,Ie,Ll,st,fa,Kl,ve,es,C,ha,el,ma,ua,tl,pa,ya,ll,Ma,wa,sl,Ja,ba,ts,ae,ls,G,Ta,ol,ja,Ua,ot,_a,ga,ss,at,Ca,os,Ee,as,E,Ia,nt,va,Ea,rt,Za,Aa,it,ka,Na,ns,ct,$a,rs,Ze,is,V,Wa,dt,Ba,Ra,ft,Xa,Ya,cs,q,ne,al,Ae,Ga,nl,Va,ds,re,fs,j,Qa,rl,za,Fa,il,Sa,Ha,cl,xa,Pa,dl,Da,qa,fl,Oa,La,hl,Ka,en,ml,tn,ln,hs,ke,ms,Q,sn,ul,on,an,pl,nn,rn,us,ie,ps,ht,cn,ys,mt,dn,Ms,Ne,ws,ce,fn,yl,hn,mn,Js,$e,bs,de,un,ut,pn,yn,Ts,pt,Mn,js,We,Us,yt,wn,_s,Be,gs,Mt,Jn,Cs,Re,Is,wt,bn,vs,Xe,Es,Z,Tn,Ml,jn,Un,wl,_n,gn,Ye,Cn,In,Zs,fe,vn,Jt,En,Zn,As,O,he,Jl,Ge,An,bl,kn,ks,A,Nn,Tl,$n,Wn,Ve,Bn,Rn,jl,Xn,Yn,Ns,Qe,$s,me,Gn,Ul,Vn,Qn,Ws,ze,Bs,bt,zn,Rs,L,ue,_l,Fe,Fn,gl,Sn,Xs,Tt,Hn,Ys,z,xn,Cl,Pn,Dn,Il,qn,On,Gs,Se,Vs,k,Ln,jt,Kn,er,vl,tr,lr,El,sr,or,Qs;return I=new Wt({}),Te=new Wt({}),je=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`}}),_e=new U({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`}}),ge=new U({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)'}}),Ce=new Wt({}),Ie=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`}}),ve=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),ae=new ar({props:{$$slots:{default:[Fi]},$$scope:{ctx:K}}}),Ee=new U({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)"}}),Ze=new U({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),Ae=new Wt({}),re=new ar({props:{warning:!0,$$slots:{default:[Si]},$$scope:{ctx:K}}}),ke=new U({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
\u2514\u2500\u2500 resnet_model
    \u251C\u2500\u2500 __init__.<span class="hljs-keyword">py</span>
    \u251C\u2500\u2500 configuration_resnet.<span class="hljs-keyword">py</span>
    \u2514\u2500\u2500 modeling_resnet.<span class="hljs-keyword">py</span>`}}),ie=new ar({props:{warning:!0,$$slots:{default:[Hi]},$$scope:{ctx:K}}}),Ne=new U({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`}}),$e=new U({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`}}),We=new U({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),Be=new U({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),Re=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),Xe=new U({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)'}}),Ge=new Wt({}),Qe=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),ze=new U({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`}}),Fe=new Wt({}),Se=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`}}),{c(){m=n("meta"),_=d(),u=n("h1"),T=n("a"),S=n("span"),p(I.$$.fragment),N=d(),ee=n("span"),to=s("Sharing custom models"),kl=d(),xe=n("p"),lo=s(`The \u{1F917} Transformers library is designed to be easily extensible. Every model is fully coded in a given subfolder
of the repository with no abstraction, so you can easily copy a modeling file and tweak it to your needs.`),Nl=d(),Pe=n("p"),so=s(`If you are writing a brand new model, it might be easier to start from scratch. In this tutorial, we will show you
how to write a custom model and its configuration so it can be used inside Transformers, and how you can share it
with the community (with the code it relies on) so that anyone can use it, even if it\u2019s not present in the \u{1F917}
Transformers library.`),$l=d(),$=n("p"),oo=s(`We will illustrate all of this on a ResNet model, by wrapping the ResNet class of the
`),be=n("a"),ao=s("timm library"),no=s(" into a "),De=n("a"),ro=s("PreTrainedModel"),io=s("."),Wl=d(),H=n("h2"),te=n("a"),Bt=n("span"),p(Te.$$.fragment),co=d(),Rt=n("span"),fo=s("Writing a custom configuration"),Bl=d(),le=n("p"),ho=s(`Before we dive into the model, let\u2019s first write its configuration. The configuration of a model is an object that
will contain all the necessary information to build the model. As we will see in the next section, the model can only
take a `),Xt=n("code"),mo=s("config"),uo=s(" to be initialized, so we really need that object to be as complete as possible."),Rl=d(),qe=n("p"),po=s(`In our example, we will take a couple of arguments of the ResNet class that we might want to tweak. Different
configurations will then give us the different types of ResNets that are possible. We then just store those arguments,
after checking the validity of a few of them.`),Xl=d(),p(je.$$.fragment),Yl=d(),Oe=n("p"),yo=s("The three important things to remember when writing you own configuration are the following:"),Gl=d(),W=n("ul"),Ue=n("li"),Mo=s("you have to inherit from "),Yt=n("code"),wo=s("PretrainedConfig"),Jo=s(","),bo=d(),x=n("li"),To=s("the "),Gt=n("code"),jo=s("__init__"),Uo=s(" of your "),Vt=n("code"),_o=s("PretrainedConfig"),go=s(" must accept any kwargs,"),Co=d(),P=n("li"),Io=s("those "),Qt=n("code"),vo=s("kwargs"),Eo=s(" need to be passed to the superclass "),zt=n("code"),Zo=s("__init__"),Ao=s("."),Vl=d(),B=n("p"),ko=s(`The inheritance is to make sure you get all the functionality from the \u{1F917} Transformers library, while the two other
constraints come from the fact a `),Ft=n("code"),No=s("PretrainedConfig"),$o=s(` has more fields than the ones you are setting. When reloading a
config with the `),St=n("code"),Wo=s("from_pretrained"),Bo=s(` method, those fields need to be accepted by your config and then sent to the
superclass.`),Ql=d(),R=n("p"),Ro=s("Defining a "),Ht=n("code"),Xo=s("model_type"),Yo=s(" for your configuration (here "),xt=n("code"),Go=s('model_type="resnet"'),Vo=s(`) is not mandatory, unless you want to
register your model with the auto classes (see last section).`),zl=d(),Le=n("p"),Qo=s(`With this done, you can easily create and save your configuration like you would do with any other model config of the
library. Here is how we can create a resnet50d config and save it:`),Fl=d(),p(_e.$$.fragment),Sl=d(),v=n("p"),zo=s("This will save a file named "),Pt=n("code"),Fo=s("config.json"),So=s(" inside the folder "),Dt=n("code"),Ho=s("custom-resnet"),xo=s(`. You can then reload your config with the
`),qt=n("code"),Po=s("from_pretrained"),Do=s(" method:"),Hl=d(),p(ge.$$.fragment),xl=d(),X=n("p"),qo=s("You can also use any other method of the "),Ke=n("a"),Oo=s("PretrainedConfig"),Lo=s(" class, like "),et=n("a"),Ko=s("push_to_hub()"),ea=s(` to
directly upload your config to the Hub.`),Pl=d(),D=n("h2"),se=n("a"),Ot=n("span"),p(Ce.$$.fragment),ta=d(),Lt=n("span"),la=s("Writing a custom model"),Dl=d(),Y=n("p"),sa=s(`Now that we have our ResNet configuration, we can go on writing the model. We will actually write two: one that
extracts the hidden features from a batch of images (like `),tt=n("a"),oa=s("BertModel"),aa=s(`) and one that is suitable for image
classification (like `),lt=n("a"),na=s("BertForSequenceClassification"),ra=s(")."),ql=d(),oe=n("p"),ia=s(`As we mentioned before, we\u2019ll only write a loose wrapper of the model to keep it simple for this example. The only
thing we need to do before writing this class is a map between the block types and actual block classes. Then the
model is defined from the configuration by passing everything to the `),Kt=n("code"),ca=s("ResNet"),da=s(" class:"),Ol=d(),p(Ie.$$.fragment),Ll=d(),st=n("p"),fa=s("For the model that will classify images, we just change the forward method:"),Kl=d(),p(ve.$$.fragment),es=d(),C=n("p"),ha=s("In both cases, notice how we inherit from "),el=n("code"),ma=s("PreTrainedModel"),ua=s(" and call the superclass initialization with the "),tl=n("code"),pa=s("config"),ya=s(`
(a bit like when you write a regular `),ll=n("code"),Ma=s("torch.nn.Module"),wa=s("). The line that sets the "),sl=n("code"),Ja=s("config_class"),ba=s(` is not mandatory, unless
you want to register your model with the auto classes (see last section).`),ts=d(),p(ae.$$.fragment),ls=d(),G=n("p"),Ta=s(`You can have your model return anything you want, but returning a dictionary like we did for
`),ol=n("code"),ja=s("ResnetModelForImageClassification"),Ua=s(`, with the loss included when labels are passed, will make your model directly
usable inside the `),ot=n("a"),_a=s("Trainer"),ga=s(` class. Using another output format is fine as long as you are planning on using your own
training loop or another library for training.`),ss=d(),at=n("p"),Ca=s("Now that we have our model class, let\u2019s create one:"),os=d(),p(Ee.$$.fragment),as=d(),E=n("p"),Ia=s("Again, you can use any of the methods of "),nt=n("a"),va=s("PreTrainedModel"),Ea=s(", like "),rt=n("a"),Za=s("save_pretrained()"),Aa=s(` or
`),it=n("a"),ka=s("push_to_hub()"),Na=s(`. We will use the second in the next section, and see how to push the model weights
with the code of our model. But first, let\u2019s load some pretrained weights inside our model.`),ns=d(),ct=n("p"),$a=s(`In your own use case, you will probably be training your custom model on your own data. To go fast for this tutorial,
we will use the pretrained version of the resnet50d. Since our model is just a wrapper around it, it\u2019s going to be
easy to transfer those weights:`),rs=d(),p(Ze.$$.fragment),is=d(),V=n("p"),Wa=s("Now let\u2019s see how to make sure that when we do "),dt=n("a"),Ba=s("save_pretrained()"),Ra=s(" or "),ft=n("a"),Xa=s("push_to_hub()"),Ya=s(`, the
code of the model is saved.`),cs=d(),q=n("h2"),ne=n("a"),al=n("span"),p(Ae.$$.fragment),Ga=d(),nl=n("span"),Va=s("Sending the code to the Hub"),ds=d(),p(re.$$.fragment),fs=d(),j=n("p"),Qa=s("First, make sure your model is fully defined in a "),rl=n("code"),za=s(".py"),Fa=s(` file. It can rely on relative imports to some other files as
long as all the files are in the same directory (we don\u2019t support submodules for this feature yet). For our example,
we\u2019ll define a `),il=n("code"),Sa=s("modeling_resnet.py"),Ha=s(" file and a "),cl=n("code"),xa=s("configuration_resnet.py"),Pa=s(` file in a folder of the current working
directory named `),dl=n("code"),Da=s("resnet_model"),qa=s(". The configuration file contains the code for "),fl=n("code"),Oa=s("ResnetConfig"),La=s(` and the modeling file
contains the code of `),hl=n("code"),Ka=s("ResnetModel"),en=s(" and "),ml=n("code"),tn=s("ResnetModelForImageClassification"),ln=s("."),hs=d(),p(ke.$$.fragment),ms=d(),Q=n("p"),sn=s("The "),ul=n("code"),on=s("__init__.py"),an=s(" can be empty, it\u2019s just there so that Python detects "),pl=n("code"),nn=s("resnet_model"),rn=s(" can be use as a module."),us=d(),p(ie.$$.fragment),ps=d(),ht=n("p"),cn=s("Note that you can re-use (or subclass) an existing configuration/model."),ys=d(),mt=n("p"),dn=s(`To share your model with the community, follow those steps: first import the ResNet model and config from the newly
created files:`),Ms=d(),p(Ne.$$.fragment),ws=d(),ce=n("p"),fn=s("Then you have to tell the library you want to copy the code files of those objects when using the "),yl=n("code"),hn=s("save_pretrained"),mn=s(`
method and properly register them with a given Auto class (especially for models), just run:`),Js=d(),p($e.$$.fragment),bs=d(),de=n("p"),un=s(`Note that there is no need to specify an auto class for the configuration (there is only one auto class for them,
`),ut=n("a"),pn=s("AutoConfig"),yn=s(`) but it\u2019s different for models. Your custom model could be suitable for many different tasks, so you
have to specify which one of the auto classes is the correct one for your model.`),Ts=d(),pt=n("p"),Mn=s("Next, let\u2019s create the config and models as we did before:"),js=d(),p(We.$$.fragment),Us=d(),yt=n("p"),wn=s("Now to send the model to the Hub, make sure you are logged in. Either run in your terminal:"),_s=d(),p(Be.$$.fragment),gs=d(),Mt=n("p"),Jn=s("or from a notebook:"),Cs=d(),p(Re.$$.fragment),Is=d(),wt=n("p"),bn=s("You can then push to your own namespace (or an organization you are a member of) like this:"),vs=d(),p(Xe.$$.fragment),Es=d(),Z=n("p"),Tn=s(`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration `),Ml=n("code"),jn=s(".py"),Un=s(" files in the folder "),wl=n("code"),_n=s("custom-resnet50d"),gn=s(` and uploaded the result to the Hub. You can check the result
in this `),Ye=n("a"),Cn=s("model repo"),In=s("."),Zs=d(),fe=n("p"),vn=s("See the "),Jt=n("a"),En=s("sharing tutorial"),Zn=s(" for more information on the push to Hub method."),As=d(),O=n("h2"),he=n("a"),Jl=n("span"),p(Ge.$$.fragment),An=d(),bl=n("span"),kn=s("Using a model with custom code"),ks=d(),A=n("p"),Nn=s(`You can use any configuration, model or tokenizer with custom code files in its repository with the auto-classes and
the `),Tl=n("code"),$n=s("from_pretrained"),Wn=s(" method. All files and code uploaded to the Hub are scanned for malware (refer to the "),Ve=n("a"),Bn=s("Hub security"),Rn=s(` documentation for more information), but you should still
review the model code and author to avoid executing malicious code on your machine. Set `),jl=n("code"),Xn=s("trust_remote_code=True"),Yn=s(` to use
a model with custom code:`),Ns=d(),p(Qe.$$.fragment),$s=d(),me=n("p"),Gn=s("It is also strongly encouraged to pass a commit hash as a "),Ul=n("code"),Vn=s("revision"),Qn=s(` to make sure the author of the models did not
update the code with some malicious new lines (unless you fully trust the authors of the models).`),Ws=d(),p(ze.$$.fragment),Bs=d(),bt=n("p"),zn=s(`Note that when browsing the commit history of the model repo on the Hub, there is a button to easily copy the commit
hash of any commit.`),Rs=d(),L=n("h2"),ue=n("a"),_l=n("span"),p(Fe.$$.fragment),Fn=d(),gl=n("span"),Sn=s("Registering a model with custom code to the auto classes"),Xs=d(),Tt=n("p"),Hn=s(`If you are writing a library that extends \u{1F917} Transformers, you may want to extend the auto classes to include your own
model. This is different from pushing the code to the Hub in the sense that users will need to import your library to
get the custom models (contrarily to automatically downloading the model code from the Hub).`),Ys=d(),z=n("p"),xn=s("As long as your config has a "),Cl=n("code"),Pn=s("model_type"),Dn=s(` attribute that is different from existing model types, and that your model
classes have the right `),Il=n("code"),qn=s("config_class"),On=s(" attributes, you can just add them to the auto classes likes this:"),Gs=d(),p(Se.$$.fragment),Vs=d(),k=n("p"),Ln=s("Note that the first argument used when registering your custom config to "),jt=n("a"),Kn=s("AutoConfig"),er=s(" needs to match the "),vl=n("code"),tr=s("model_type"),lr=s(`
of your custom config, and the first argument used when registering your custom models to any auto model class needs
to match the `),El=n("code"),sr=s("config_class"),or=s(" of those models."),this.h()},l(e){const a=Qi('[data-svelte="svelte-1phssyn"]',document.head);m=r(a,"META",{name:!0,content:!0}),a.forEach(l),_=f(e),u=r(e,"H1",{class:!0});var He=i(u);T=r(He,"A",{id:!0,class:!0,href:!0});var Zl=i(T);S=r(Zl,"SPAN",{});var Al=i(S);y(I.$$.fragment,Al),Al.forEach(l),Zl.forEach(l),N=f(He),ee=r(He,"SPAN",{});var nr=i(ee);to=o(nr,"Sharing custom models"),nr.forEach(l),He.forEach(l),kl=f(e),xe=r(e,"P",{});var rr=i(xe);lo=o(rr,`The \u{1F917} Transformers library is designed to be easily extensible. Every model is fully coded in a given subfolder
of the repository with no abstraction, so you can easily copy a modeling file and tweak it to your needs.`),rr.forEach(l),Nl=f(e),Pe=r(e,"P",{});var ir=i(Pe);so=o(ir,`If you are writing a brand new model, it might be easier to start from scratch. In this tutorial, we will show you
how to write a custom model and its configuration so it can be used inside Transformers, and how you can share it
with the community (with the code it relies on) so that anyone can use it, even if it\u2019s not present in the \u{1F917}
Transformers library.`),ir.forEach(l),$l=f(e),$=r(e,"P",{});var Ut=i($);oo=o(Ut,`We will illustrate all of this on a ResNet model, by wrapping the ResNet class of the
`),be=r(Ut,"A",{href:!0,rel:!0});var cr=i(be);ao=o(cr,"timm library"),cr.forEach(l),no=o(Ut," into a "),De=r(Ut,"A",{href:!0});var dr=i(De);ro=o(dr,"PreTrainedModel"),dr.forEach(l),io=o(Ut,"."),Ut.forEach(l),Wl=f(e),H=r(e,"H2",{class:!0});var zs=i(H);te=r(zs,"A",{id:!0,class:!0,href:!0});var fr=i(te);Bt=r(fr,"SPAN",{});var hr=i(Bt);y(Te.$$.fragment,hr),hr.forEach(l),fr.forEach(l),co=f(zs),Rt=r(zs,"SPAN",{});var mr=i(Rt);fo=o(mr,"Writing a custom configuration"),mr.forEach(l),zs.forEach(l),Bl=f(e),le=r(e,"P",{});var Fs=i(le);ho=o(Fs,`Before we dive into the model, let\u2019s first write its configuration. The configuration of a model is an object that
will contain all the necessary information to build the model. As we will see in the next section, the model can only
take a `),Xt=r(Fs,"CODE",{});var ur=i(Xt);mo=o(ur,"config"),ur.forEach(l),uo=o(Fs," to be initialized, so we really need that object to be as complete as possible."),Fs.forEach(l),Rl=f(e),qe=r(e,"P",{});var pr=i(qe);po=o(pr,`In our example, we will take a couple of arguments of the ResNet class that we might want to tweak. Different
configurations will then give us the different types of ResNets that are possible. We then just store those arguments,
after checking the validity of a few of them.`),pr.forEach(l),Xl=f(e),y(je.$$.fragment,e),Yl=f(e),Oe=r(e,"P",{});var yr=i(Oe);yo=o(yr,"The three important things to remember when writing you own configuration are the following:"),yr.forEach(l),Gl=f(e),W=r(e,"UL",{});var _t=i(W);Ue=r(_t,"LI",{});var Ss=i(Ue);Mo=o(Ss,"you have to inherit from "),Yt=r(Ss,"CODE",{});var Mr=i(Yt);wo=o(Mr,"PretrainedConfig"),Mr.forEach(l),Jo=o(Ss,","),Ss.forEach(l),bo=f(_t),x=r(_t,"LI",{});var gt=i(x);To=o(gt,"the "),Gt=r(gt,"CODE",{});var wr=i(Gt);jo=o(wr,"__init__"),wr.forEach(l),Uo=o(gt," of your "),Vt=r(gt,"CODE",{});var Jr=i(Vt);_o=o(Jr,"PretrainedConfig"),Jr.forEach(l),go=o(gt," must accept any kwargs,"),gt.forEach(l),Co=f(_t),P=r(_t,"LI",{});var Ct=i(P);Io=o(Ct,"those "),Qt=r(Ct,"CODE",{});var br=i(Qt);vo=o(br,"kwargs"),br.forEach(l),Eo=o(Ct," need to be passed to the superclass "),zt=r(Ct,"CODE",{});var Tr=i(zt);Zo=o(Tr,"__init__"),Tr.forEach(l),Ao=o(Ct,"."),Ct.forEach(l),_t.forEach(l),Vl=f(e),B=r(e,"P",{});var It=i(B);ko=o(It,`The inheritance is to make sure you get all the functionality from the \u{1F917} Transformers library, while the two other
constraints come from the fact a `),Ft=r(It,"CODE",{});var jr=i(Ft);No=o(jr,"PretrainedConfig"),jr.forEach(l),$o=o(It,` has more fields than the ones you are setting. When reloading a
config with the `),St=r(It,"CODE",{});var Ur=i(St);Wo=o(Ur,"from_pretrained"),Ur.forEach(l),Bo=o(It,` method, those fields need to be accepted by your config and then sent to the
superclass.`),It.forEach(l),Ql=f(e),R=r(e,"P",{});var vt=i(R);Ro=o(vt,"Defining a "),Ht=r(vt,"CODE",{});var _r=i(Ht);Xo=o(_r,"model_type"),_r.forEach(l),Yo=o(vt," for your configuration (here "),xt=r(vt,"CODE",{});var gr=i(xt);Go=o(gr,'model_type="resnet"'),gr.forEach(l),Vo=o(vt,`) is not mandatory, unless you want to
register your model with the auto classes (see last section).`),vt.forEach(l),zl=f(e),Le=r(e,"P",{});var Cr=i(Le);Qo=o(Cr,`With this done, you can easily create and save your configuration like you would do with any other model config of the
library. Here is how we can create a resnet50d config and save it:`),Cr.forEach(l),Fl=f(e),y(_e.$$.fragment,e),Sl=f(e),v=r(e,"P",{});var pe=i(v);zo=o(pe,"This will save a file named "),Pt=r(pe,"CODE",{});var Ir=i(Pt);Fo=o(Ir,"config.json"),Ir.forEach(l),So=o(pe," inside the folder "),Dt=r(pe,"CODE",{});var vr=i(Dt);Ho=o(vr,"custom-resnet"),vr.forEach(l),xo=o(pe,`. You can then reload your config with the
`),qt=r(pe,"CODE",{});var Er=i(qt);Po=o(Er,"from_pretrained"),Er.forEach(l),Do=o(pe," method:"),pe.forEach(l),Hl=f(e),y(ge.$$.fragment,e),xl=f(e),X=r(e,"P",{});var Et=i(X);qo=o(Et,"You can also use any other method of the "),Ke=r(Et,"A",{href:!0});var Zr=i(Ke);Oo=o(Zr,"PretrainedConfig"),Zr.forEach(l),Lo=o(Et," class, like "),et=r(Et,"A",{href:!0});var Ar=i(et);Ko=o(Ar,"push_to_hub()"),Ar.forEach(l),ea=o(Et,` to
directly upload your config to the Hub.`),Et.forEach(l),Pl=f(e),D=r(e,"H2",{class:!0});var Hs=i(D);se=r(Hs,"A",{id:!0,class:!0,href:!0});var kr=i(se);Ot=r(kr,"SPAN",{});var Nr=i(Ot);y(Ce.$$.fragment,Nr),Nr.forEach(l),kr.forEach(l),ta=f(Hs),Lt=r(Hs,"SPAN",{});var $r=i(Lt);la=o($r,"Writing a custom model"),$r.forEach(l),Hs.forEach(l),Dl=f(e),Y=r(e,"P",{});var Zt=i(Y);sa=o(Zt,`Now that we have our ResNet configuration, we can go on writing the model. We will actually write two: one that
extracts the hidden features from a batch of images (like `),tt=r(Zt,"A",{href:!0});var Wr=i(tt);oa=o(Wr,"BertModel"),Wr.forEach(l),aa=o(Zt,`) and one that is suitable for image
classification (like `),lt=r(Zt,"A",{href:!0});var Br=i(lt);na=o(Br,"BertForSequenceClassification"),Br.forEach(l),ra=o(Zt,")."),Zt.forEach(l),ql=f(e),oe=r(e,"P",{});var xs=i(oe);ia=o(xs,`As we mentioned before, we\u2019ll only write a loose wrapper of the model to keep it simple for this example. The only
thing we need to do before writing this class is a map between the block types and actual block classes. Then the
model is defined from the configuration by passing everything to the `),Kt=r(xs,"CODE",{});var Rr=i(Kt);ca=o(Rr,"ResNet"),Rr.forEach(l),da=o(xs," class:"),xs.forEach(l),Ol=f(e),y(Ie.$$.fragment,e),Ll=f(e),st=r(e,"P",{});var Xr=i(st);fa=o(Xr,"For the model that will classify images, we just change the forward method:"),Xr.forEach(l),Kl=f(e),y(ve.$$.fragment,e),es=f(e),C=r(e,"P",{});var F=i(C);ha=o(F,"In both cases, notice how we inherit from "),el=r(F,"CODE",{});var Yr=i(el);ma=o(Yr,"PreTrainedModel"),Yr.forEach(l),ua=o(F," and call the superclass initialization with the "),tl=r(F,"CODE",{});var Gr=i(tl);pa=o(Gr,"config"),Gr.forEach(l),ya=o(F,`
(a bit like when you write a regular `),ll=r(F,"CODE",{});var Vr=i(ll);Ma=o(Vr,"torch.nn.Module"),Vr.forEach(l),wa=o(F,"). The line that sets the "),sl=r(F,"CODE",{});var Qr=i(sl);Ja=o(Qr,"config_class"),Qr.forEach(l),ba=o(F,` is not mandatory, unless
you want to register your model with the auto classes (see last section).`),F.forEach(l),ts=f(e),y(ae.$$.fragment,e),ls=f(e),G=r(e,"P",{});var At=i(G);Ta=o(At,`You can have your model return anything you want, but returning a dictionary like we did for
`),ol=r(At,"CODE",{});var zr=i(ol);ja=o(zr,"ResnetModelForImageClassification"),zr.forEach(l),Ua=o(At,`, with the loss included when labels are passed, will make your model directly
usable inside the `),ot=r(At,"A",{href:!0});var Fr=i(ot);_a=o(Fr,"Trainer"),Fr.forEach(l),ga=o(At,` class. Using another output format is fine as long as you are planning on using your own
training loop or another library for training.`),At.forEach(l),ss=f(e),at=r(e,"P",{});var Sr=i(at);Ca=o(Sr,"Now that we have our model class, let\u2019s create one:"),Sr.forEach(l),os=f(e),y(Ee.$$.fragment,e),as=f(e),E=r(e,"P",{});var ye=i(E);Ia=o(ye,"Again, you can use any of the methods of "),nt=r(ye,"A",{href:!0});var Hr=i(nt);va=o(Hr,"PreTrainedModel"),Hr.forEach(l),Ea=o(ye,", like "),rt=r(ye,"A",{href:!0});var xr=i(rt);Za=o(xr,"save_pretrained()"),xr.forEach(l),Aa=o(ye,` or
`),it=r(ye,"A",{href:!0});var Pr=i(it);ka=o(Pr,"push_to_hub()"),Pr.forEach(l),Na=o(ye,`. We will use the second in the next section, and see how to push the model weights
with the code of our model. But first, let\u2019s load some pretrained weights inside our model.`),ye.forEach(l),ns=f(e),ct=r(e,"P",{});var Dr=i(ct);$a=o(Dr,`In your own use case, you will probably be training your custom model on your own data. To go fast for this tutorial,
we will use the pretrained version of the resnet50d. Since our model is just a wrapper around it, it\u2019s going to be
easy to transfer those weights:`),Dr.forEach(l),rs=f(e),y(Ze.$$.fragment,e),is=f(e),V=r(e,"P",{});var kt=i(V);Wa=o(kt,"Now let\u2019s see how to make sure that when we do "),dt=r(kt,"A",{href:!0});var qr=i(dt);Ba=o(qr,"save_pretrained()"),qr.forEach(l),Ra=o(kt," or "),ft=r(kt,"A",{href:!0});var Or=i(ft);Xa=o(Or,"push_to_hub()"),Or.forEach(l),Ya=o(kt,`, the
code of the model is saved.`),kt.forEach(l),cs=f(e),q=r(e,"H2",{class:!0});var Ps=i(q);ne=r(Ps,"A",{id:!0,class:!0,href:!0});var Lr=i(ne);al=r(Lr,"SPAN",{});var Kr=i(al);y(Ae.$$.fragment,Kr),Kr.forEach(l),Lr.forEach(l),Ga=f(Ps),nl=r(Ps,"SPAN",{});var ei=i(nl);Va=o(ei,"Sending the code to the Hub"),ei.forEach(l),Ps.forEach(l),ds=f(e),y(re.$$.fragment,e),fs=f(e),j=r(e,"P",{});var g=i(j);Qa=o(g,"First, make sure your model is fully defined in a "),rl=r(g,"CODE",{});var ti=i(rl);za=o(ti,".py"),ti.forEach(l),Fa=o(g,` file. It can rely on relative imports to some other files as
long as all the files are in the same directory (we don\u2019t support submodules for this feature yet). For our example,
we\u2019ll define a `),il=r(g,"CODE",{});var li=i(il);Sa=o(li,"modeling_resnet.py"),li.forEach(l),Ha=o(g," file and a "),cl=r(g,"CODE",{});var si=i(cl);xa=o(si,"configuration_resnet.py"),si.forEach(l),Pa=o(g,` file in a folder of the current working
directory named `),dl=r(g,"CODE",{});var oi=i(dl);Da=o(oi,"resnet_model"),oi.forEach(l),qa=o(g,". The configuration file contains the code for "),fl=r(g,"CODE",{});var ai=i(fl);Oa=o(ai,"ResnetConfig"),ai.forEach(l),La=o(g,` and the modeling file
contains the code of `),hl=r(g,"CODE",{});var ni=i(hl);Ka=o(ni,"ResnetModel"),ni.forEach(l),en=o(g," and "),ml=r(g,"CODE",{});var ri=i(ml);tn=o(ri,"ResnetModelForImageClassification"),ri.forEach(l),ln=o(g,"."),g.forEach(l),hs=f(e),y(ke.$$.fragment,e),ms=f(e),Q=r(e,"P",{});var Nt=i(Q);sn=o(Nt,"The "),ul=r(Nt,"CODE",{});var ii=i(ul);on=o(ii,"__init__.py"),ii.forEach(l),an=o(Nt," can be empty, it\u2019s just there so that Python detects "),pl=r(Nt,"CODE",{});var ci=i(pl);nn=o(ci,"resnet_model"),ci.forEach(l),rn=o(Nt," can be use as a module."),Nt.forEach(l),us=f(e),y(ie.$$.fragment,e),ps=f(e),ht=r(e,"P",{});var di=i(ht);cn=o(di,"Note that you can re-use (or subclass) an existing configuration/model."),di.forEach(l),ys=f(e),mt=r(e,"P",{});var fi=i(mt);dn=o(fi,`To share your model with the community, follow those steps: first import the ResNet model and config from the newly
created files:`),fi.forEach(l),Ms=f(e),y(Ne.$$.fragment,e),ws=f(e),ce=r(e,"P",{});var Ds=i(ce);fn=o(Ds,"Then you have to tell the library you want to copy the code files of those objects when using the "),yl=r(Ds,"CODE",{});var hi=i(yl);hn=o(hi,"save_pretrained"),hi.forEach(l),mn=o(Ds,`
method and properly register them with a given Auto class (especially for models), just run:`),Ds.forEach(l),Js=f(e),y($e.$$.fragment,e),bs=f(e),de=r(e,"P",{});var qs=i(de);un=o(qs,`Note that there is no need to specify an auto class for the configuration (there is only one auto class for them,
`),ut=r(qs,"A",{href:!0});var mi=i(ut);pn=o(mi,"AutoConfig"),mi.forEach(l),yn=o(qs,`) but it\u2019s different for models. Your custom model could be suitable for many different tasks, so you
have to specify which one of the auto classes is the correct one for your model.`),qs.forEach(l),Ts=f(e),pt=r(e,"P",{});var ui=i(pt);Mn=o(ui,"Next, let\u2019s create the config and models as we did before:"),ui.forEach(l),js=f(e),y(We.$$.fragment,e),Us=f(e),yt=r(e,"P",{});var pi=i(yt);wn=o(pi,"Now to send the model to the Hub, make sure you are logged in. Either run in your terminal:"),pi.forEach(l),_s=f(e),y(Be.$$.fragment,e),gs=f(e),Mt=r(e,"P",{});var yi=i(Mt);Jn=o(yi,"or from a notebook:"),yi.forEach(l),Cs=f(e),y(Re.$$.fragment,e),Is=f(e),wt=r(e,"P",{});var Mi=i(wt);bn=o(Mi,"You can then push to your own namespace (or an organization you are a member of) like this:"),Mi.forEach(l),vs=f(e),y(Xe.$$.fragment,e),Es=f(e),Z=r(e,"P",{});var Me=i(Z);Tn=o(Me,`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration `),Ml=r(Me,"CODE",{});var wi=i(Ml);jn=o(wi,".py"),wi.forEach(l),Un=o(Me," files in the folder "),wl=r(Me,"CODE",{});var Ji=i(wl);_n=o(Ji,"custom-resnet50d"),Ji.forEach(l),gn=o(Me,` and uploaded the result to the Hub. You can check the result
in this `),Ye=r(Me,"A",{href:!0,rel:!0});var bi=i(Ye);Cn=o(bi,"model repo"),bi.forEach(l),In=o(Me,"."),Me.forEach(l),Zs=f(e),fe=r(e,"P",{});var Os=i(fe);vn=o(Os,"See the "),Jt=r(Os,"A",{href:!0});var Ti=i(Jt);En=o(Ti,"sharing tutorial"),Ti.forEach(l),Zn=o(Os," for more information on the push to Hub method."),Os.forEach(l),As=f(e),O=r(e,"H2",{class:!0});var Ls=i(O);he=r(Ls,"A",{id:!0,class:!0,href:!0});var ji=i(he);Jl=r(ji,"SPAN",{});var Ui=i(Jl);y(Ge.$$.fragment,Ui),Ui.forEach(l),ji.forEach(l),An=f(Ls),bl=r(Ls,"SPAN",{});var _i=i(bl);kn=o(_i,"Using a model with custom code"),_i.forEach(l),Ls.forEach(l),ks=f(e),A=r(e,"P",{});var we=i(A);Nn=o(we,`You can use any configuration, model or tokenizer with custom code files in its repository with the auto-classes and
the `),Tl=r(we,"CODE",{});var gi=i(Tl);$n=o(gi,"from_pretrained"),gi.forEach(l),Wn=o(we," method. All files and code uploaded to the Hub are scanned for malware (refer to the "),Ve=r(we,"A",{href:!0,rel:!0});var Ci=i(Ve);Bn=o(Ci,"Hub security"),Ci.forEach(l),Rn=o(we,` documentation for more information), but you should still
review the model code and author to avoid executing malicious code on your machine. Set `),jl=r(we,"CODE",{});var Ii=i(jl);Xn=o(Ii,"trust_remote_code=True"),Ii.forEach(l),Yn=o(we,` to use
a model with custom code:`),we.forEach(l),Ns=f(e),y(Qe.$$.fragment,e),$s=f(e),me=r(e,"P",{});var Ks=i(me);Gn=o(Ks,"It is also strongly encouraged to pass a commit hash as a "),Ul=r(Ks,"CODE",{});var vi=i(Ul);Vn=o(vi,"revision"),vi.forEach(l),Qn=o(Ks,` to make sure the author of the models did not
update the code with some malicious new lines (unless you fully trust the authors of the models).`),Ks.forEach(l),Ws=f(e),y(ze.$$.fragment,e),Bs=f(e),bt=r(e,"P",{});var Ei=i(bt);zn=o(Ei,`Note that when browsing the commit history of the model repo on the Hub, there is a button to easily copy the commit
hash of any commit.`),Ei.forEach(l),Rs=f(e),L=r(e,"H2",{class:!0});var eo=i(L);ue=r(eo,"A",{id:!0,class:!0,href:!0});var Zi=i(ue);_l=r(Zi,"SPAN",{});var Ai=i(_l);y(Fe.$$.fragment,Ai),Ai.forEach(l),Zi.forEach(l),Fn=f(eo),gl=r(eo,"SPAN",{});var ki=i(gl);Sn=o(ki,"Registering a model with custom code to the auto classes"),ki.forEach(l),eo.forEach(l),Xs=f(e),Tt=r(e,"P",{});var Ni=i(Tt);Hn=o(Ni,`If you are writing a library that extends \u{1F917} Transformers, you may want to extend the auto classes to include your own
model. This is different from pushing the code to the Hub in the sense that users will need to import your library to
get the custom models (contrarily to automatically downloading the model code from the Hub).`),Ni.forEach(l),Ys=f(e),z=r(e,"P",{});var $t=i(z);xn=o($t,"As long as your config has a "),Cl=r($t,"CODE",{});var $i=i(Cl);Pn=o($i,"model_type"),$i.forEach(l),Dn=o($t,` attribute that is different from existing model types, and that your model
classes have the right `),Il=r($t,"CODE",{});var Wi=i(Il);qn=o(Wi,"config_class"),Wi.forEach(l),On=o($t," attributes, you can just add them to the auto classes likes this:"),$t.forEach(l),Gs=f(e),y(Se.$$.fragment,e),Vs=f(e),k=r(e,"P",{});var Je=i(k);Ln=o(Je,"Note that the first argument used when registering your custom config to "),jt=r(Je,"A",{href:!0});var Bi=i(jt);Kn=o(Bi,"AutoConfig"),Bi.forEach(l),er=o(Je," needs to match the "),vl=r(Je,"CODE",{});var Ri=i(vl);tr=o(Ri,"model_type"),Ri.forEach(l),lr=o(Je,`
of your custom config, and the first argument used when registering your custom models to any auto model class needs
to match the `),El=r(Je,"CODE",{});var Xi=i(El);sr=o(Xi,"config_class"),Xi.forEach(l),or=o(Je," of those models."),Je.forEach(l),this.h()},h(){h(m,"name","hf:doc:metadata"),h(m,"content",JSON.stringify(Pi)),h(T,"id","sharing-custom-models"),h(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(T,"href","#sharing-custom-models"),h(u,"class","relative group"),h(be,"href","https://github.com/rwightman/pytorch-image-models"),h(be,"rel","nofollow"),h(De,"href","/docs/transformers/v4.32.1/en/main_classes/model#transformers.PreTrainedModel"),h(te,"id","writing-a-custom-configuration"),h(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(te,"href","#writing-a-custom-configuration"),h(H,"class","relative group"),h(Ke,"href","/docs/transformers/v4.32.1/en/main_classes/configuration#transformers.PretrainedConfig"),h(et,"href","/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub"),h(se,"id","writing-a-custom-model"),h(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(se,"href","#writing-a-custom-model"),h(D,"class","relative group"),h(tt,"href","/docs/transformers/v4.32.1/en/model_doc/bert#transformers.BertModel"),h(lt,"href","/docs/transformers/v4.32.1/en/model_doc/bert#transformers.BertForSequenceClassification"),h(ot,"href","/docs/transformers/v4.32.1/en/main_classes/trainer#transformers.Trainer"),h(nt,"href","/docs/transformers/v4.32.1/en/main_classes/model#transformers.PreTrainedModel"),h(rt,"href","/docs/transformers/v4.32.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained"),h(it,"href","/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub"),h(dt,"href","/docs/transformers/v4.32.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained"),h(ft,"href","/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub"),h(ne,"id","sending-the-code-to-the-hub"),h(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ne,"href","#sending-the-code-to-the-hub"),h(q,"class","relative group"),h(ut,"href","/docs/transformers/v4.32.1/en/model_doc/auto#transformers.AutoConfig"),h(Ye,"href","https://huggingface.co/sgugger/custom-resnet50d"),h(Ye,"rel","nofollow"),h(Jt,"href","model_sharing"),h(he,"id","using-a-model-with-custom-code"),h(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(he,"href","#using-a-model-with-custom-code"),h(O,"class","relative group"),h(Ve,"href","https://huggingface.co/docs/hub/security#malware-scanning"),h(Ve,"rel","nofollow"),h(ue,"id","registering-a-model-with-custom-code-to-the-auto-classes"),h(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ue,"href","#registering-a-model-with-custom-code-to-the-auto-classes"),h(L,"class","relative group"),h(jt,"href","/docs/transformers/v4.32.1/en/model_doc/auto#transformers.AutoConfig")},m(e,a){t(document.head,m),c(e,_,a),c(e,u,a),t(u,T),t(T,S),M(I,S,null),t(u,N),t(u,ee),t(ee,to),c(e,kl,a),c(e,xe,a),t(xe,lo),c(e,Nl,a),c(e,Pe,a),t(Pe,so),c(e,$l,a),c(e,$,a),t($,oo),t($,be),t(be,ao),t($,no),t($,De),t(De,ro),t($,io),c(e,Wl,a),c(e,H,a),t(H,te),t(te,Bt),M(Te,Bt,null),t(H,co),t(H,Rt),t(Rt,fo),c(e,Bl,a),c(e,le,a),t(le,ho),t(le,Xt),t(Xt,mo),t(le,uo),c(e,Rl,a),c(e,qe,a),t(qe,po),c(e,Xl,a),M(je,e,a),c(e,Yl,a),c(e,Oe,a),t(Oe,yo),c(e,Gl,a),c(e,W,a),t(W,Ue),t(Ue,Mo),t(Ue,Yt),t(Yt,wo),t(Ue,Jo),t(W,bo),t(W,x),t(x,To),t(x,Gt),t(Gt,jo),t(x,Uo),t(x,Vt),t(Vt,_o),t(x,go),t(W,Co),t(W,P),t(P,Io),t(P,Qt),t(Qt,vo),t(P,Eo),t(P,zt),t(zt,Zo),t(P,Ao),c(e,Vl,a),c(e,B,a),t(B,ko),t(B,Ft),t(Ft,No),t(B,$o),t(B,St),t(St,Wo),t(B,Bo),c(e,Ql,a),c(e,R,a),t(R,Ro),t(R,Ht),t(Ht,Xo),t(R,Yo),t(R,xt),t(xt,Go),t(R,Vo),c(e,zl,a),c(e,Le,a),t(Le,Qo),c(e,Fl,a),M(_e,e,a),c(e,Sl,a),c(e,v,a),t(v,zo),t(v,Pt),t(Pt,Fo),t(v,So),t(v,Dt),t(Dt,Ho),t(v,xo),t(v,qt),t(qt,Po),t(v,Do),c(e,Hl,a),M(ge,e,a),c(e,xl,a),c(e,X,a),t(X,qo),t(X,Ke),t(Ke,Oo),t(X,Lo),t(X,et),t(et,Ko),t(X,ea),c(e,Pl,a),c(e,D,a),t(D,se),t(se,Ot),M(Ce,Ot,null),t(D,ta),t(D,Lt),t(Lt,la),c(e,Dl,a),c(e,Y,a),t(Y,sa),t(Y,tt),t(tt,oa),t(Y,aa),t(Y,lt),t(lt,na),t(Y,ra),c(e,ql,a),c(e,oe,a),t(oe,ia),t(oe,Kt),t(Kt,ca),t(oe,da),c(e,Ol,a),M(Ie,e,a),c(e,Ll,a),c(e,st,a),t(st,fa),c(e,Kl,a),M(ve,e,a),c(e,es,a),c(e,C,a),t(C,ha),t(C,el),t(el,ma),t(C,ua),t(C,tl),t(tl,pa),t(C,ya),t(C,ll),t(ll,Ma),t(C,wa),t(C,sl),t(sl,Ja),t(C,ba),c(e,ts,a),M(ae,e,a),c(e,ls,a),c(e,G,a),t(G,Ta),t(G,ol),t(ol,ja),t(G,Ua),t(G,ot),t(ot,_a),t(G,ga),c(e,ss,a),c(e,at,a),t(at,Ca),c(e,os,a),M(Ee,e,a),c(e,as,a),c(e,E,a),t(E,Ia),t(E,nt),t(nt,va),t(E,Ea),t(E,rt),t(rt,Za),t(E,Aa),t(E,it),t(it,ka),t(E,Na),c(e,ns,a),c(e,ct,a),t(ct,$a),c(e,rs,a),M(Ze,e,a),c(e,is,a),c(e,V,a),t(V,Wa),t(V,dt),t(dt,Ba),t(V,Ra),t(V,ft),t(ft,Xa),t(V,Ya),c(e,cs,a),c(e,q,a),t(q,ne),t(ne,al),M(Ae,al,null),t(q,Ga),t(q,nl),t(nl,Va),c(e,ds,a),M(re,e,a),c(e,fs,a),c(e,j,a),t(j,Qa),t(j,rl),t(rl,za),t(j,Fa),t(j,il),t(il,Sa),t(j,Ha),t(j,cl),t(cl,xa),t(j,Pa),t(j,dl),t(dl,Da),t(j,qa),t(j,fl),t(fl,Oa),t(j,La),t(j,hl),t(hl,Ka),t(j,en),t(j,ml),t(ml,tn),t(j,ln),c(e,hs,a),M(ke,e,a),c(e,ms,a),c(e,Q,a),t(Q,sn),t(Q,ul),t(ul,on),t(Q,an),t(Q,pl),t(pl,nn),t(Q,rn),c(e,us,a),M(ie,e,a),c(e,ps,a),c(e,ht,a),t(ht,cn),c(e,ys,a),c(e,mt,a),t(mt,dn),c(e,Ms,a),M(Ne,e,a),c(e,ws,a),c(e,ce,a),t(ce,fn),t(ce,yl),t(yl,hn),t(ce,mn),c(e,Js,a),M($e,e,a),c(e,bs,a),c(e,de,a),t(de,un),t(de,ut),t(ut,pn),t(de,yn),c(e,Ts,a),c(e,pt,a),t(pt,Mn),c(e,js,a),M(We,e,a),c(e,Us,a),c(e,yt,a),t(yt,wn),c(e,_s,a),M(Be,e,a),c(e,gs,a),c(e,Mt,a),t(Mt,Jn),c(e,Cs,a),M(Re,e,a),c(e,Is,a),c(e,wt,a),t(wt,bn),c(e,vs,a),M(Xe,e,a),c(e,Es,a),c(e,Z,a),t(Z,Tn),t(Z,Ml),t(Ml,jn),t(Z,Un),t(Z,wl),t(wl,_n),t(Z,gn),t(Z,Ye),t(Ye,Cn),t(Z,In),c(e,Zs,a),c(e,fe,a),t(fe,vn),t(fe,Jt),t(Jt,En),t(fe,Zn),c(e,As,a),c(e,O,a),t(O,he),t(he,Jl),M(Ge,Jl,null),t(O,An),t(O,bl),t(bl,kn),c(e,ks,a),c(e,A,a),t(A,Nn),t(A,Tl),t(Tl,$n),t(A,Wn),t(A,Ve),t(Ve,Bn),t(A,Rn),t(A,jl),t(jl,Xn),t(A,Yn),c(e,Ns,a),M(Qe,e,a),c(e,$s,a),c(e,me,a),t(me,Gn),t(me,Ul),t(Ul,Vn),t(me,Qn),c(e,Ws,a),M(ze,e,a),c(e,Bs,a),c(e,bt,a),t(bt,zn),c(e,Rs,a),c(e,L,a),t(L,ue),t(ue,_l),M(Fe,_l,null),t(L,Fn),t(L,gl),t(gl,Sn),c(e,Xs,a),c(e,Tt,a),t(Tt,Hn),c(e,Ys,a),c(e,z,a),t(z,xn),t(z,Cl),t(Cl,Pn),t(z,Dn),t(z,Il),t(Il,qn),t(z,On),c(e,Gs,a),M(Se,e,a),c(e,Vs,a),c(e,k,a),t(k,Ln),t(k,jt),t(jt,Kn),t(k,er),t(k,vl),t(vl,tr),t(k,lr),t(k,El),t(El,sr),t(k,or),Qs=!0},p(e,[a]){const He={};a&2&&(He.$$scope={dirty:a,ctx:e}),ae.$set(He);const Zl={};a&2&&(Zl.$$scope={dirty:a,ctx:e}),re.$set(Zl);const Al={};a&2&&(Al.$$scope={dirty:a,ctx:e}),ie.$set(Al)},i(e){Qs||(w(I.$$.fragment,e),w(Te.$$.fragment,e),w(je.$$.fragment,e),w(_e.$$.fragment,e),w(ge.$$.fragment,e),w(Ce.$$.fragment,e),w(Ie.$$.fragment,e),w(ve.$$.fragment,e),w(ae.$$.fragment,e),w(Ee.$$.fragment,e),w(Ze.$$.fragment,e),w(Ae.$$.fragment,e),w(re.$$.fragment,e),w(ke.$$.fragment,e),w(ie.$$.fragment,e),w(Ne.$$.fragment,e),w($e.$$.fragment,e),w(We.$$.fragment,e),w(Be.$$.fragment,e),w(Re.$$.fragment,e),w(Xe.$$.fragment,e),w(Ge.$$.fragment,e),w(Qe.$$.fragment,e),w(ze.$$.fragment,e),w(Fe.$$.fragment,e),w(Se.$$.fragment,e),Qs=!0)},o(e){J(I.$$.fragment,e),J(Te.$$.fragment,e),J(je.$$.fragment,e),J(_e.$$.fragment,e),J(ge.$$.fragment,e),J(Ce.$$.fragment,e),J(Ie.$$.fragment,e),J(ve.$$.fragment,e),J(ae.$$.fragment,e),J(Ee.$$.fragment,e),J(Ze.$$.fragment,e),J(Ae.$$.fragment,e),J(re.$$.fragment,e),J(ke.$$.fragment,e),J(ie.$$.fragment,e),J(Ne.$$.fragment,e),J($e.$$.fragment,e),J(We.$$.fragment,e),J(Be.$$.fragment,e),J(Re.$$.fragment,e),J(Xe.$$.fragment,e),J(Ge.$$.fragment,e),J(Qe.$$.fragment,e),J(ze.$$.fragment,e),J(Fe.$$.fragment,e),J(Se.$$.fragment,e),Qs=!1},d(e){l(m),e&&l(_),e&&l(u),b(I),e&&l(kl),e&&l(xe),e&&l(Nl),e&&l(Pe),e&&l($l),e&&l($),e&&l(Wl),e&&l(H),b(Te),e&&l(Bl),e&&l(le),e&&l(Rl),e&&l(qe),e&&l(Xl),b(je,e),e&&l(Yl),e&&l(Oe),e&&l(Gl),e&&l(W),e&&l(Vl),e&&l(B),e&&l(Ql),e&&l(R),e&&l(zl),e&&l(Le),e&&l(Fl),b(_e,e),e&&l(Sl),e&&l(v),e&&l(Hl),b(ge,e),e&&l(xl),e&&l(X),e&&l(Pl),e&&l(D),b(Ce),e&&l(Dl),e&&l(Y),e&&l(ql),e&&l(oe),e&&l(Ol),b(Ie,e),e&&l(Ll),e&&l(st),e&&l(Kl),b(ve,e),e&&l(es),e&&l(C),e&&l(ts),b(ae,e),e&&l(ls),e&&l(G),e&&l(ss),e&&l(at),e&&l(os),b(Ee,e),e&&l(as),e&&l(E),e&&l(ns),e&&l(ct),e&&l(rs),b(Ze,e),e&&l(is),e&&l(V),e&&l(cs),e&&l(q),b(Ae),e&&l(ds),b(re,e),e&&l(fs),e&&l(j),e&&l(hs),b(ke,e),e&&l(ms),e&&l(Q),e&&l(us),b(ie,e),e&&l(ps),e&&l(ht),e&&l(ys),e&&l(mt),e&&l(Ms),b(Ne,e),e&&l(ws),e&&l(ce),e&&l(Js),b($e,e),e&&l(bs),e&&l(de),e&&l(Ts),e&&l(pt),e&&l(js),b(We,e),e&&l(Us),e&&l(yt),e&&l(_s),b(Be,e),e&&l(gs),e&&l(Mt),e&&l(Cs),b(Re,e),e&&l(Is),e&&l(wt),e&&l(vs),b(Xe,e),e&&l(Es),e&&l(Z),e&&l(Zs),e&&l(fe),e&&l(As),e&&l(O),b(Ge),e&&l(ks),e&&l(A),e&&l(Ns),b(Qe,e),e&&l($s),e&&l(me),e&&l(Ws),b(ze,e),e&&l(Bs),e&&l(bt),e&&l(Rs),e&&l(L),b(Fe),e&&l(Xs),e&&l(Tt),e&&l(Ys),e&&l(z),e&&l(Gs),b(Se,e),e&&l(Vs),e&&l(k)}}}const Pi={local:"sharing-custom-models",sections:[{local:"writing-a-custom-configuration",title:"Writing a custom configuration"},{local:"writing-a-custom-model",title:"Writing a custom model"},{local:"sending-the-code-to-the-hub",title:"Sending the code to the Hub"},{local:"using-a-model-with-custom-code",title:"Using a model with custom code"},{local:"registering-a-model-with-custom-code-to-the-auto-classes",title:"Registering a model with custom code to the auto classes"}],title:"Sharing custom models"};function Di(K){return zi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ec extends Yi{constructor(m){super();Gi(this,m,Di,xi,Vi,{})}}export{ec as default,Pi as metadata};
