import{s as Vt,o as xt,n as qe}from"../chunks/scheduler.56730f09.js";import{S as Qt,i as Ht,g as a,s as n,r as y,A as Et,h as i,f as t,c as M,j as Gt,u as c,x as p,k as Yt,y as zt,a as s,v as d,d as m,t as J,w}from"../chunks/index.1f144517.js";import{T as Se}from"../chunks/Tip.41e845e5.js";import{C as r}from"../chunks/CodeBlock.738eeccb.js";import{H as Nl,E as Ft}from"../chunks/EditOnGithub.854793f1.js";function Lt(f){let o,j="라이브러리에 존재하는 모델과 굉장히 유사하다면, 모델을 생성할 때 구성을 참조해 재사용할 수 있습니다.";return{c(){o=a("p"),o.textContent=j},l(T){o=i(T,"P",{"data-svelte-h":!0}),p(o)!=="svelte-hf6zh1"&&(o.textContent=j)},m(T,U){s(T,o,U)},p:qe,d(T){T&&t(o)}}}function St(f){let o,j="이 API는 실험적이며 다음 릴리스에서 약간의 변경 사항이 있을 수 있습니다.";return{c(){o=a("p"),o.textContent=j},l(T){o=i(T,"P",{"data-svelte-h":!0}),p(o)!=="svelte-11fial7"&&(o.textContent=j)},m(T,U){s(T,o,U)},p:qe,d(T){T&&t(o)}}}function qt(f){let o,j=`라이브러리에서 모델링 파일을 복사하는 경우,
모든 파일 상단에 있는 상대 경로 임포트(relative import) 부분을 <code>transformers</code> 패키지에서 임포트 하도록 변경해야 합니다.`;return{c(){o=a("p"),o.innerHTML=j},l(T){o=i(T,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1igyulw"&&(o.innerHTML=j)},m(T,U){s(T,o,U)},p:qe,d(T){T&&t(o)}}}function Pt(f){let o,j,T,U,I,Rl,Z,Pe=`🤗 Transformers 라이브러리는 쉽게 확장할 수 있도록 설계되었습니다.
모든 모델은 추상화 없이 저장소의 지정된 하위 폴더에 완전히 코딩되어 있으므로, 손쉽게 모델링 파일을 복사하고 필요에 따라 조정할 수 있습니다.`,vl,_,De=`완전히 새로운 모델을 만드는 경우에는 처음부터 시작하는 것이 더 쉬울 수 있습니다.
이 튜토리얼에서는 Transformers 내에서 사용할 수 있도록 사용자 정의 모델과 구성을 작성하는 방법과
🤗 Transformers 라이브러리에 없는 경우에도 누구나 사용할 수 있도록 (의존성과 함께) 커뮤니티에 공유하는 방법을 배울 수 있습니다.`,Xl,h,Ke='<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm 라이브러리</a>의 ResNet 클래스를 <code>PreTrainedModel</code>로 래핑한 ResNet 모델을 예로 모든 것을 설명합니다.',Gl,g,Yl,$,Oe=`모델에 들어가기 전에 먼저 구성을 작성해보도록 하겠습니다.
모델의 <code>configuration</code>은 모델을 만들기 위해 필요한 모든 중요한 것들을 포함하고 있는 객체입니다.
다음 섹션에서 볼 수 있듯이, 모델은 <code>config</code>를 사용해서만 초기화할 수 있기 때문에 완벽한 구성이 필요합니다.`,Vl,A,lt=`아래 예시에서는 ResNet 클래스의 인수(argument)를 조정해보겠습니다.
다른 구성은 가능한 ResNet 중 다른 유형을 제공합니다.
그런 다음 몇 가지 유효성을 확인한 후 해당 인수를 저장합니다.`,xl,k,Ql,B,et="사용자 정의 <code>configuration</code>을 작성할 때 기억해야 할 세 가지 중요한 사항은 다음과 같습니다:",Hl,N,tt="<li><code>PretrainedConfig</code>을 상속해야 합니다.</li> <li><code>PretrainedConfig</code>의 <code>__init__</code>은 모든 kwargs를 허용해야 하고,</li> <li>이러한 <code>kwargs</code>는 상위 클래스 <code>__init__</code>에 전달되어야 합니다.</li>",El,W,st=`상속은 🤗 Transformers 라이브러리에서 모든 기능을 가져오는 것입니다.
이러한 점으로부터 비롯되는 두 가지 제약 조건은 <code>PretrainedConfig</code>에 설정하는 것보다 더 많은 필드가 있습니다.
<code>from_pretrained</code> 메서드로 구성을 다시 로드할 때 해당 필드는 구성에서 수락한 후 상위 클래스로 보내야 합니다.`,zl,R,nt="모델을 auto 클래스에 등록하지 않는 한, <code>configuration</code>에서 <code>model_type</code>을 정의(여기서 <code>model_type=&quot;resnet&quot;</code>)하는 것은 필수 사항이 아닙니다 (마지막 섹션 참조).",Fl,v,Mt=`이렇게 하면 라이브러리의 다른 모델 구성과 마찬가지로 구성을 쉽게 만들고 저장할 수 있습니다.
다음은 resnet50d 구성을 생성하고 저장하는 방법입니다:`,Ll,X,Sl,G,at=`이렇게 하면 <code>custom-resnet</code> 폴더 안에 <code>config.json</code>이라는 파일이 저장됩니다.
그런 다음 <code>from_pretrained</code> 메서드를 사용하여 구성을 다시 로드할 수 있습니다.`,ql,Y,Pl,V,it="구성을 Hub에 직접 업로드하기 위해 <code>PretrainedConfig</code> 클래스의 <code>push_to_hub()</code>와 같은 다른 메서드를 사용할 수 있습니다.",Dl,x,Kl,Q,pt=`이제 ResNet 구성이 있으므로 모델을 작성할 수 있습니다.
실제로는 두 개를 작성할 것입니다. 하나는 이미지 배치에서 hidden features를 추출하는 것(<code>BertModel</code>과 같이), 다른 하나는 이미지 분류에 적합한 것입니다(<code>BertForSequenceClassification</code>과 같이).`,Ol,H,ot=`이전에 언급했듯이 이 예제에서는 단순하게 하기 위해 모델의 느슨한 래퍼(loose wrapper)만 작성할 것입니다.
이 클래스를 작성하기 전에 블록 유형과 실제 블록 클래스 간의 매핑 작업만 하면 됩니다.
그런 다음 <code>ResNet</code> 클래스로 전달되어 <code>configuration</code>을 통해 모델이 선언됩니다:`,le,E,ee,z,yt="이미지 분류 모델을 만들기 위해서는 forward 메소드만 변경하면 됩니다:",te,F,se,L,ct=`두 경우 모두 <code>PreTrainedModel</code>를 상속받고, <code>config</code>를 통해 상위 클래스 초기화를 호출하다는 점을 기억하세요 (일반적인 <code>torch.nn.Module</code>을 작성할 때와 비슷함).
모델을 auto 클래스에 등록하고 싶은 경우에는 <code>config_class</code>를 설정하는 부분이 필수입니다 (마지막 섹션 참조).`,ne,u,Me,S,dt=`원하는 것을 모델이 반환하도록 할 수 있지만, <code>ResnetModelForImageClassification</code>에서 했던 것 처럼
레이블을 통과시켰을 때 손실과 함께 사전 형태로 반환하는 것이 <code>Trainer</code> 클래스 내에서 직접 모델을 사용하기에 유용합니다.
자신만의 학습 루프 또는 다른 학습 라이브러리를 사용할 계획이라면 다른 출력 형식을 사용해도 좋습니다.`,ae,q,mt="이제 모델 클래스가 있으므로 하나 생성해 보겠습니다:",ie,P,pe,D,Jt=`다시 말하지만, <code>save_pretrained()</code>또는 <code>push_to_hub()</code>처럼 <code>PreTrainedModel</code>에 속하는 모든 메소드를 사용할 수 있습니다.
다음 섹션에서 두 번째 메소드를 사용해 모델 코드와 모델 가중치를 업로드하는 방법을 살펴보겠습니다.
먼저, 모델 내부에 사전 훈련된 가중치를 로드해 보겠습니다.`,oe,K,wt=`이 예제를 활용할 때는, 사용자 정의 모델을 자신만의 데이터로 학습시킬 것입니다.
이 튜토리얼에서는 빠르게 진행하기 위해 사전 훈련된 resnet50d를 사용하겠습니다.
아래 모델은 resnet50d의 래퍼이기 때문에, 가중치를 쉽게 로드할 수 있습니다.`,ye,O,ce,ll,Tt="이제 <code>save_pretrained()</code> 또는 <code>push_to_hub()</code>를 사용할 때 모델 코드가 저장되는지 확인해봅시다.",de,el,me,C,Je,tl,rt=`먼저 모델이 <code>.py</code> 파일에 완전히 정의되어 있는지 확인하세요.
모든 파일이 동일한 작업 경로에 있기 때문에 상대경로 임포트(relative import)에 의존할 수 있습니다 (transformers에서는 이 기능에 대한 하위 모듈을 지원하지 않습니다).
이 예시에서는 작업 경로 안의 <code>resnet_model</code>에서 <code>modeling_resnet.py</code> 파일과 <code>configuration_resnet.py</code> 파일을 정의합니다.
구성 파일에는 <code>ResnetConfig</code>에 대한 코드가 있고 모델링 파일에는 <code>ResnetModel</code> 및 <code>ResnetModelForImageClassification</code>에 대한 코드가 있습니다.`,we,sl,Te,nl,jt="Python이 <code>resnet_model</code>을 모듈로 사용할 수 있도록 감지하는 목적이기 때문에 <code>__init__.py</code>는 비어 있을 수 있습니다.",re,b,je,Ml,Ut="기존 구성이나 모델을 재사용(또는 서브 클래스화)할 수 있습니다.",Ue,al,ft=`커뮤니티에 모델을 공유하기 위해서는 다음 단계를 따라야 합니다:
먼저, 새로 만든 파일에 ResNet 모델과 구성을 임포트합니다:`,fe,il,ue,pl,ut=`다음으로 <code>save_pretrained</code> 메소드를 사용해 해당 객체의 코드 파일을 복사하고,
복사한 파일을 Auto 클래스로 등록하고(모델인 경우) 실행합니다:`,Ce,ol,be,yl,Ct=`<code>configuration</code>에 대한 auto 클래스를 지정할 필요는 없지만(<code>configuration</code> 관련 auto 클래스는 AutoConfig 클래스 하나만 있음), 모델의 경우에는 지정해야 합니다.
사용자 지정 모델은 다양한 작업에 적합할 수 있으므로, 모델에 맞는 auto 클래스를 지정해야 합니다.`,Ie,cl,bt="다음으로, 이전에 작업했던 것과 마찬가지로 구성과 모델을 작성합니다:",Ze,dl,_e,ml,It=`이제 모델을 Hub로 업로드하기 위해 로그인 상태인지 확인하세요.
터미널에서 다음 코드를 실행해 확인할 수 있습니다:`,he,Jl,ge,wl,Zt="주피터 노트북의 경우에는 다음과 같습니다:",$e,Tl,Ae,rl,_t="그런 다음 이렇게 자신의 네임스페이스(또는 자신이 속한 조직)에 업로드할 수 있습니다:",ke,jl,Be,Ul,ht=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.
json 형식의 모델링 가중치와 구성 외에도 <code>custom-resnet50d</code> 폴더 안의 모델링과 구성 <code>.py</code> 파일을 복사하해 Hub에 업로드합니다.
<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">모델 저장소</a>에서 결과를 확인할 수 있습니다.`,Ne,fl,gt='<a href="model_sharing">sharing tutorial</a> 문서의 <code>push_to_hub</code> 메소드에서 자세한 내용을 확인할 수 있습니다.',We,ul,Re,Cl,$t=`auto 클래스와 <code>from_pretrained</code> 메소드를 사용하여 사용자 지정 코드 파일과 함께 모든 구성, 모델, 토크나이저를 사용할 수 있습니다.
Hub에 업로드된 모든 파일 및 코드는 멜웨어가 있는지 검사되지만 (자세한 내용은 <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub 보안</a> 설명 참조),
자신의 컴퓨터에서 모델 코드와 작성자가 악성 코드를 실행하지 않는지 확인해야 합니다.
사용자 정의 코드로 모델을 사용하려면 <code>trust_remote_code=True</code>로 설정하세요:`,ve,bl,Xe,Il,At="모델 작성자가 악의적으로 코드를 업데이트하지 않았다는 점을 확인하기 위해, 커밋 해시(commit hash)를 <code>revision</code>으로 전달하는 것도 강력히 권장됩니다 (모델 작성자를 완전히 신뢰하지 않는 경우).",Ge,Zl,Ye,_l,kt="Hub에서 모델 저장소의 커밋 기록을 찾아볼 때, 모든 커밋의 커밋 해시를 쉽게 복사할 수 있는 버튼이 있습니다.",Ve,hl,xe,gl,Bt=`🤗 Transformers를 상속하는 라이브러리를 작성하는 경우 사용자 정의 모델을 auto 클래스에 추가할 수 있습니다.
사용자 정의 모델을 사용하기 위해 해당 라이브러리를 임포트해야 하기 때문에, 이는 Hub로 코드를 업로드하는 것과 다릅니다 (Hub에서 자동적으로 모델 코드를 다운로드 하는 것과 반대).`,Qe,$l,Nt=`구성에 기존 모델 유형과 다른 <code>model_type</code> 속성이 있고 모델 클래스에 올바른 <code>config_class</code> 속성이 있는 한,
다음과 같이 auto 클래스에 추가할 수 있습니다:`,He,Al,Ee,kl,Wt=`사용자 정의 구성을 <code>AutoConfig</code>에 등록할 때 사용되는 첫 번째 인수는 사용자 정의 구성의 <code>model_type</code>과 일치해야 합니다.
또한, 사용자 정의 모델을 auto 클래스에 등록할 때 사용되는 첫 번째 인수는 해당 모델의 <code>config_class</code>와 일치해야 합니다.`,ze,Bl,Fe,Wl,Le;return I=new Nl({props:{title:"사용자 정의 모델 공유하기",local:"sharing-custom-models",headingTag:"h1"}}),g=new Nl({props:{title:"사용자 정의 구성 작성하기",local:"writing-a-custom-configuration",headingTag:"h2"}}),k=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new r({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),Y=new r({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),x=new Nl({props:{title:"사용자 정의 모델 작성하기",local:"writing-a-custom-model",headingTag:"h2"}}),E=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),u=new Se({props:{$$slots:{default:[Lt]},$$scope:{ctx:f}}}),P=new r({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new r({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),el=new Nl({props:{title:"Hub로 코드 업로드하기",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),C=new Se({props:{warning:!0,$$slots:{default:[St]},$$scope:{ctx:f}}}),sl=new r({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Se({props:{warning:!0,$$slots:{default:[qt]},$$scope:{ctx:f}}}),il=new r({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),ol=new r({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),dl=new r({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Jl=new r({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Tl=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),jl=new r({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),ul=new Nl({props:{title:"사용자 정의 코드로 모델 사용하기",local:"using-a-model-with-custom-code",headingTag:"h2"}}),bl=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Zl=new r({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),hl=new Nl({props:{title:"사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),Al=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),Bl=new Ft({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/custom_models.md"}}),{c(){o=a("meta"),j=n(),T=a("p"),U=n(),y(I.$$.fragment),Rl=n(),Z=a("p"),Z.textContent=Pe,vl=n(),_=a("p"),_.textContent=De,Xl=n(),h=a("p"),h.innerHTML=Ke,Gl=n(),y(g.$$.fragment),Yl=n(),$=a("p"),$.innerHTML=Oe,Vl=n(),A=a("p"),A.textContent=lt,xl=n(),y(k.$$.fragment),Ql=n(),B=a("p"),B.innerHTML=et,Hl=n(),N=a("ul"),N.innerHTML=tt,El=n(),W=a("p"),W.innerHTML=st,zl=n(),R=a("p"),R.innerHTML=nt,Fl=n(),v=a("p"),v.textContent=Mt,Ll=n(),y(X.$$.fragment),Sl=n(),G=a("p"),G.innerHTML=at,ql=n(),y(Y.$$.fragment),Pl=n(),V=a("p"),V.innerHTML=it,Dl=n(),y(x.$$.fragment),Kl=n(),Q=a("p"),Q.innerHTML=pt,Ol=n(),H=a("p"),H.innerHTML=ot,le=n(),y(E.$$.fragment),ee=n(),z=a("p"),z.textContent=yt,te=n(),y(F.$$.fragment),se=n(),L=a("p"),L.innerHTML=ct,ne=n(),y(u.$$.fragment),Me=n(),S=a("p"),S.innerHTML=dt,ae=n(),q=a("p"),q.textContent=mt,ie=n(),y(P.$$.fragment),pe=n(),D=a("p"),D.innerHTML=Jt,oe=n(),K=a("p"),K.textContent=wt,ye=n(),y(O.$$.fragment),ce=n(),ll=a("p"),ll.innerHTML=Tt,de=n(),y(el.$$.fragment),me=n(),y(C.$$.fragment),Je=n(),tl=a("p"),tl.innerHTML=rt,we=n(),y(sl.$$.fragment),Te=n(),nl=a("p"),nl.innerHTML=jt,re=n(),y(b.$$.fragment),je=n(),Ml=a("p"),Ml.textContent=Ut,Ue=n(),al=a("p"),al.textContent=ft,fe=n(),y(il.$$.fragment),ue=n(),pl=a("p"),pl.innerHTML=ut,Ce=n(),y(ol.$$.fragment),be=n(),yl=a("p"),yl.innerHTML=Ct,Ie=n(),cl=a("p"),cl.textContent=bt,Ze=n(),y(dl.$$.fragment),_e=n(),ml=a("p"),ml.textContent=It,he=n(),y(Jl.$$.fragment),ge=n(),wl=a("p"),wl.textContent=Zt,$e=n(),y(Tl.$$.fragment),Ae=n(),rl=a("p"),rl.textContent=_t,ke=n(),y(jl.$$.fragment),Be=n(),Ul=a("p"),Ul.innerHTML=ht,Ne=n(),fl=a("p"),fl.innerHTML=gt,We=n(),y(ul.$$.fragment),Re=n(),Cl=a("p"),Cl.innerHTML=$t,ve=n(),y(bl.$$.fragment),Xe=n(),Il=a("p"),Il.innerHTML=At,Ge=n(),y(Zl.$$.fragment),Ye=n(),_l=a("p"),_l.textContent=kt,Ve=n(),y(hl.$$.fragment),xe=n(),gl=a("p"),gl.textContent=Bt,Qe=n(),$l=a("p"),$l.innerHTML=Nt,He=n(),y(Al.$$.fragment),Ee=n(),kl=a("p"),kl.innerHTML=Wt,ze=n(),y(Bl.$$.fragment),Fe=n(),Wl=a("p"),this.h()},l(l){const e=Et("svelte-u9bgzb",document.head);o=i(e,"META",{name:!0,content:!0}),e.forEach(t),j=M(l),T=i(l,"P",{}),Gt(T).forEach(t),U=M(l),c(I.$$.fragment,l),Rl=M(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-al07n"&&(Z.textContent=Pe),vl=M(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1lxcxix"&&(_.textContent=De),Xl=M(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-119rg2w"&&(h.innerHTML=Ke),Gl=M(l),c(g.$$.fragment,l),Yl=M(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-la43mp"&&($.innerHTML=Oe),Vl=M(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1qc22zw"&&(A.textContent=lt),xl=M(l),c(k.$$.fragment,l),Ql=M(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-nxq6mo"&&(B.innerHTML=et),Hl=M(l),N=i(l,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-1tfxli8"&&(N.innerHTML=tt),El=M(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-x5ckqo"&&(W.innerHTML=st),zl=M(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1kaub1g"&&(R.innerHTML=nt),Fl=M(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-ovl0zx"&&(v.textContent=Mt),Ll=M(l),c(X.$$.fragment,l),Sl=M(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-d1xscf"&&(G.innerHTML=at),ql=M(l),c(Y.$$.fragment,l),Pl=M(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-g1m52h"&&(V.innerHTML=it),Dl=M(l),c(x.$$.fragment,l),Kl=M(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-6nuh70"&&(Q.innerHTML=pt),Ol=M(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1ufn8h6"&&(H.innerHTML=ot),le=M(l),c(E.$$.fragment,l),ee=M(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-10szka3"&&(z.textContent=yt),te=M(l),c(F.$$.fragment,l),se=M(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1g3ya33"&&(L.innerHTML=ct),ne=M(l),c(u.$$.fragment,l),Me=M(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1f99hcg"&&(S.innerHTML=dt),ae=M(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-68rs2x"&&(q.textContent=mt),ie=M(l),c(P.$$.fragment,l),pe=M(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-10d07s4"&&(D.innerHTML=Jt),oe=M(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1319e67"&&(K.textContent=wt),ye=M(l),c(O.$$.fragment,l),ce=M(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-rtsgc0"&&(ll.innerHTML=Tt),de=M(l),c(el.$$.fragment,l),me=M(l),c(C.$$.fragment,l),Je=M(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-q87di4"&&(tl.innerHTML=rt),we=M(l),c(sl.$$.fragment,l),Te=M(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-fw3tvd"&&(nl.innerHTML=jt),re=M(l),c(b.$$.fragment,l),je=M(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-19tqquy"&&(Ml.textContent=Ut),Ue=M(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-1tgl3y3"&&(al.textContent=ft),fe=M(l),c(il.$$.fragment,l),ue=M(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-85qz6h"&&(pl.innerHTML=ut),Ce=M(l),c(ol.$$.fragment,l),be=M(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-urqb2q"&&(yl.innerHTML=Ct),Ie=M(l),cl=i(l,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-th8o9z"&&(cl.textContent=bt),Ze=M(l),c(dl.$$.fragment,l),_e=M(l),ml=i(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-1xhzef1"&&(ml.textContent=It),he=M(l),c(Jl.$$.fragment,l),ge=M(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-4bt266"&&(wl.textContent=Zt),$e=M(l),c(Tl.$$.fragment,l),Ae=M(l),rl=i(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-xc5sk0"&&(rl.textContent=_t),ke=M(l),c(jl.$$.fragment,l),Be=M(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-dnw5aw"&&(Ul.innerHTML=ht),Ne=M(l),fl=i(l,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-2rsbbb"&&(fl.innerHTML=gt),We=M(l),c(ul.$$.fragment,l),Re=M(l),Cl=i(l,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-1m1cooj"&&(Cl.innerHTML=$t),ve=M(l),c(bl.$$.fragment,l),Xe=M(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-18oh14g"&&(Il.innerHTML=At),Ge=M(l),c(Zl.$$.fragment,l),Ye=M(l),_l=i(l,"P",{"data-svelte-h":!0}),p(_l)!=="svelte-eerkzr"&&(_l.textContent=kt),Ve=M(l),c(hl.$$.fragment,l),xe=M(l),gl=i(l,"P",{"data-svelte-h":!0}),p(gl)!=="svelte-1w0yfzt"&&(gl.textContent=Bt),Qe=M(l),$l=i(l,"P",{"data-svelte-h":!0}),p($l)!=="svelte-xh4cqs"&&($l.innerHTML=Nt),He=M(l),c(Al.$$.fragment,l),Ee=M(l),kl=i(l,"P",{"data-svelte-h":!0}),p(kl)!=="svelte-9j79lz"&&(kl.innerHTML=Wt),ze=M(l),c(Bl.$$.fragment,l),Fe=M(l),Wl=i(l,"P",{}),Gt(Wl).forEach(t),this.h()},h(){Yt(o,"name","hf:doc:metadata"),Yt(o,"content",Dt)},m(l,e){zt(document.head,o),s(l,j,e),s(l,T,e),s(l,U,e),d(I,l,e),s(l,Rl,e),s(l,Z,e),s(l,vl,e),s(l,_,e),s(l,Xl,e),s(l,h,e),s(l,Gl,e),d(g,l,e),s(l,Yl,e),s(l,$,e),s(l,Vl,e),s(l,A,e),s(l,xl,e),d(k,l,e),s(l,Ql,e),s(l,B,e),s(l,Hl,e),s(l,N,e),s(l,El,e),s(l,W,e),s(l,zl,e),s(l,R,e),s(l,Fl,e),s(l,v,e),s(l,Ll,e),d(X,l,e),s(l,Sl,e),s(l,G,e),s(l,ql,e),d(Y,l,e),s(l,Pl,e),s(l,V,e),s(l,Dl,e),d(x,l,e),s(l,Kl,e),s(l,Q,e),s(l,Ol,e),s(l,H,e),s(l,le,e),d(E,l,e),s(l,ee,e),s(l,z,e),s(l,te,e),d(F,l,e),s(l,se,e),s(l,L,e),s(l,ne,e),d(u,l,e),s(l,Me,e),s(l,S,e),s(l,ae,e),s(l,q,e),s(l,ie,e),d(P,l,e),s(l,pe,e),s(l,D,e),s(l,oe,e),s(l,K,e),s(l,ye,e),d(O,l,e),s(l,ce,e),s(l,ll,e),s(l,de,e),d(el,l,e),s(l,me,e),d(C,l,e),s(l,Je,e),s(l,tl,e),s(l,we,e),d(sl,l,e),s(l,Te,e),s(l,nl,e),s(l,re,e),d(b,l,e),s(l,je,e),s(l,Ml,e),s(l,Ue,e),s(l,al,e),s(l,fe,e),d(il,l,e),s(l,ue,e),s(l,pl,e),s(l,Ce,e),d(ol,l,e),s(l,be,e),s(l,yl,e),s(l,Ie,e),s(l,cl,e),s(l,Ze,e),d(dl,l,e),s(l,_e,e),s(l,ml,e),s(l,he,e),d(Jl,l,e),s(l,ge,e),s(l,wl,e),s(l,$e,e),d(Tl,l,e),s(l,Ae,e),s(l,rl,e),s(l,ke,e),d(jl,l,e),s(l,Be,e),s(l,Ul,e),s(l,Ne,e),s(l,fl,e),s(l,We,e),d(ul,l,e),s(l,Re,e),s(l,Cl,e),s(l,ve,e),d(bl,l,e),s(l,Xe,e),s(l,Il,e),s(l,Ge,e),d(Zl,l,e),s(l,Ye,e),s(l,_l,e),s(l,Ve,e),d(hl,l,e),s(l,xe,e),s(l,gl,e),s(l,Qe,e),s(l,$l,e),s(l,He,e),d(Al,l,e),s(l,Ee,e),s(l,kl,e),s(l,ze,e),d(Bl,l,e),s(l,Fe,e),s(l,Wl,e),Le=!0},p(l,[e]){const Rt={};e&2&&(Rt.$$scope={dirty:e,ctx:l}),u.$set(Rt);const vt={};e&2&&(vt.$$scope={dirty:e,ctx:l}),C.$set(vt);const Xt={};e&2&&(Xt.$$scope={dirty:e,ctx:l}),b.$set(Xt)},i(l){Le||(m(I.$$.fragment,l),m(g.$$.fragment,l),m(k.$$.fragment,l),m(X.$$.fragment,l),m(Y.$$.fragment,l),m(x.$$.fragment,l),m(E.$$.fragment,l),m(F.$$.fragment,l),m(u.$$.fragment,l),m(P.$$.fragment,l),m(O.$$.fragment,l),m(el.$$.fragment,l),m(C.$$.fragment,l),m(sl.$$.fragment,l),m(b.$$.fragment,l),m(il.$$.fragment,l),m(ol.$$.fragment,l),m(dl.$$.fragment,l),m(Jl.$$.fragment,l),m(Tl.$$.fragment,l),m(jl.$$.fragment,l),m(ul.$$.fragment,l),m(bl.$$.fragment,l),m(Zl.$$.fragment,l),m(hl.$$.fragment,l),m(Al.$$.fragment,l),m(Bl.$$.fragment,l),Le=!0)},o(l){J(I.$$.fragment,l),J(g.$$.fragment,l),J(k.$$.fragment,l),J(X.$$.fragment,l),J(Y.$$.fragment,l),J(x.$$.fragment,l),J(E.$$.fragment,l),J(F.$$.fragment,l),J(u.$$.fragment,l),J(P.$$.fragment,l),J(O.$$.fragment,l),J(el.$$.fragment,l),J(C.$$.fragment,l),J(sl.$$.fragment,l),J(b.$$.fragment,l),J(il.$$.fragment,l),J(ol.$$.fragment,l),J(dl.$$.fragment,l),J(Jl.$$.fragment,l),J(Tl.$$.fragment,l),J(jl.$$.fragment,l),J(ul.$$.fragment,l),J(bl.$$.fragment,l),J(Zl.$$.fragment,l),J(hl.$$.fragment,l),J(Al.$$.fragment,l),J(Bl.$$.fragment,l),Le=!1},d(l){l&&(t(j),t(T),t(U),t(Rl),t(Z),t(vl),t(_),t(Xl),t(h),t(Gl),t(Yl),t($),t(Vl),t(A),t(xl),t(Ql),t(B),t(Hl),t(N),t(El),t(W),t(zl),t(R),t(Fl),t(v),t(Ll),t(Sl),t(G),t(ql),t(Pl),t(V),t(Dl),t(Kl),t(Q),t(Ol),t(H),t(le),t(ee),t(z),t(te),t(se),t(L),t(ne),t(Me),t(S),t(ae),t(q),t(ie),t(pe),t(D),t(oe),t(K),t(ye),t(ce),t(ll),t(de),t(me),t(Je),t(tl),t(we),t(Te),t(nl),t(re),t(je),t(Ml),t(Ue),t(al),t(fe),t(ue),t(pl),t(Ce),t(be),t(yl),t(Ie),t(cl),t(Ze),t(_e),t(ml),t(he),t(ge),t(wl),t($e),t(Ae),t(rl),t(ke),t(Be),t(Ul),t(Ne),t(fl),t(We),t(Re),t(Cl),t(ve),t(Xe),t(Il),t(Ge),t(Ye),t(_l),t(Ve),t(xe),t(gl),t(Qe),t($l),t(He),t(Ee),t(kl),t(ze),t(Fe),t(Wl)),t(o),w(I,l),w(g,l),w(k,l),w(X,l),w(Y,l),w(x,l),w(E,l),w(F,l),w(u,l),w(P,l),w(O,l),w(el,l),w(C,l),w(sl,l),w(b,l),w(il,l),w(ol,l),w(dl,l),w(Jl,l),w(Tl,l),w(jl,l),w(ul,l),w(bl,l),w(Zl,l),w(hl,l),w(Al,l),w(Bl,l)}}}const Dt='{"title":"사용자 정의 모델 공유하기","local":"sharing-custom-models","sections":[{"title":"사용자 정의 구성 작성하기","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"사용자 정의 모델 작성하기","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Hub로 코드 업로드하기","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"사용자 정의 코드로 모델 사용하기","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function Kt(f){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Qt{constructor(o){super(),Ht(this,o,Kt,Pt,Vt,{})}}export{ns as component};
