import{s as Ut,n as Ot,o as Vt}from"../chunks/scheduler.9039eef2.js";import{S as Nt,i as Ft,g as n,s as a,r as p,A as St,h as o,f as r,c as l,j as f,u,x as m,k as z,y as t,a as d,v as c,d as h,t as g,w as _}from"../chunks/index.cdcc3d35.js";import{D as y}from"../chunks/Docstring.fff63cfc.js";import{H as ve}from"../chunks/Heading.96ce3702.js";function Wt(ht){let T,ye,$e,Pe,I,Te,q,gt="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",we,U,Ce,O,_t="The main task in distributed training / inference is being able to shard things such as the model weights, the gradient, and/or the optimizer state. We built <code>Parallelizer</code> classes to handle the sharding.",Me,V,Le,N,bt="The <code>Parallelizer</code> class is the base abstract class being derived for every model supporting model parallelism. It provides methods to parallelize the model and save and load sharded checkpoints.",De,s,F,Re,ae,ft="Base abstract class that handles model parallelism.",Xe,C,S,Ge,le,zt=`Parallelizes the model by transforming regular layer into their parallel counterparts.
Each concrete class must implement it.`,Je,P,W,Ke,ie,vt=`Parallelizes the model by transforming regular layer into their parallel counterparts using
<code>cls._parallelize()</code>.`,Qe,ne,$t=`It also makes sure that each parameter has loaded its weights or has been initialized if there is no pre-trained
weights associated to it.`,Ye,x,A,Ze,oe,xt="Creates an optimizer ready for a parallelized model from an existing optimizer.",et,de,yt="There are two cases:",tt,se,Pt=`<li>The optimizer has been created via a lazy constructor from
<code>optimum.neuron.distributed.utils.make_optimizer_constructor_lazy</code>, it which case the exactly intended optimizer is
created for tensor parallelism.</li> <li>The optimizer was created with a regular constructor. In this case the optimizer for tensor parallelism
is created as close as possible to what was intended but that is not guaranteed.</li>`,rt,me,j,at,pe,B,ke,R,Ee,X,Tt="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",He,v,G,lt,M,J,it,ue,wt="Provides the list of supported model types for parallelization.",nt,L,K,ot,ce,Ct="Returns <code>True</code> if the model can be parallelized, <code>False</code> otherwise.",dt,D,Q,st,he,Mt="Returns the parallelizer class associated to the model.",Ie,Y,qe,Z,Ue,ee,Lt="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",Oe,$,te,mt,ge,Dt="Context manager that makes the loading of a model lazy for model parallelism:",pt,_e,kt=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_mp</code> docstring.</li>`,ut,be,Et="If both <code>tensor_parallel_size</code> and <code>pipeline_parallel_size</code> are set to 1, no lazy loading is performed.",Ve,w,re,ct,fe,Ht=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,Ne,xe,Fe;return I=new ve({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),U=new ve({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),V=new ve({props:{title:"Base Parallelizer",local:"optimum.neuron.distributed.Parallelizer",headingTag:"h3"}}),F=new y({props:{name:"class optimum.neuron.distributed.Parallelizer",anchor:"optimum.neuron.distributed.Parallelizer",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L135"}}),S=new y({props:{name:"_parallelize",anchor:"optimum.neuron.distributed.Parallelizer._parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L238",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),W=new y({props:{name:"parallelize",anchor:"optimum.neuron.distributed.Parallelizer.parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"pipeline_parallel_input_names",val:": Union = None"},{name:"pipeline_parallel_num_microbatches",val:": int = 1"},{name:"pipeline_parallel_use_zero1_optimizer",val:": bool = False"},{name:"checkpoint_dir",val:": Union = None"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_num_microbatches",description:`<strong>pipeline_parallel_num_microbatches</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of microbatches used for pipeline execution.`,name:"pipeline_parallel_num_microbatches"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_use_zero1_optimizer",description:`<strong>pipeline_parallel_use_zero1_optimizer</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When zero-1 optimizer is used, set this to True, so the PP model will understand that zero-1 optimizer
will handle data parallel gradient averaging.`,name:"pipeline_parallel_use_zero1_optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>Optional[Union[str, Path]]</code>) &#x2014;
Path to a sharded checkpoint. If specified, the checkpoint weights will be loaded to the parallelized
model.`,name:"checkpoint_dir"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),A=new y({props:{name:"optimizer_for_mp",anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"orig_param_to_parallel_param_on_xla",val:": Mapping"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
The original optimizer.`,name:"optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.orig_param_to_parallel_param_on_xla",description:`<strong>orig_param_to_parallel_param_on_xla</strong> (<code>Mapping[int, torch.nn.Parameter]</code>) &#x2014;
A mapping (e.g. dict-like) that maps the id of a parameter in <code>optimizer</code> to the id of its
parallelized counterpart on an XLA device.`,name:"orig_param_to_parallel_param_on_xla"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L610",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor parallelism ready optimizer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.optim.Optimizer</code></p>
`}}),j=new y({props:{name:"save_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.save_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"output_dir",val:": Union"},{name:"as_regular",val:": bool = False"},{name:"as_sharded",val:": bool = True"},{name:"optimizer",val:": Optional = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L757"}}),B=new y({props:{name:"load_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.load_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"load_dir",val:": Union"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L789"}}),R=new ve({props:{title:"Selecting Model-Specific Parallelizer Classes",local:"optimum.neuron.distributed.ParallelizersManager",headingTag:"h3"}}),G=new y({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L52"}}),J=new y({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L65"}}),K=new y({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L85"}}),Q=new y({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L97"}}),Y=new ve({props:{title:"Utils",local:"utils",headingTag:"h2"}}),Z=new ve({props:{title:"Lazy Loading",local:"optimum.neuron.distributed.lazy_load_for_parallelism",headingTag:"h3"}}),te=new y({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"},{name:"pipeline_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The tensor parallel size considered.`,name:"tensor_parallel_size"},{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.pipeline_parallel_size",description:`<strong>pipeline_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The pipeline parallel size considered.`,name:"pipeline_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/utils.py#L789"}}),re=new y({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": Type"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/utils.py#L835"}}),{c(){T=n("meta"),ye=a(),$e=n("p"),Pe=a(),p(I.$$.fragment),Te=a(),q=n("p"),q.innerHTML=gt,we=a(),p(U.$$.fragment),Ce=a(),O=n("p"),O.innerHTML=_t,Me=a(),p(V.$$.fragment),Le=a(),N=n("p"),N.innerHTML=bt,De=a(),s=n("div"),p(F.$$.fragment),Re=a(),ae=n("p"),ae.textContent=ft,Xe=a(),C=n("div"),p(S.$$.fragment),Ge=a(),le=n("p"),le.textContent=zt,Je=a(),P=n("div"),p(W.$$.fragment),Ke=a(),ie=n("p"),ie.innerHTML=vt,Qe=a(),ne=n("p"),ne.textContent=$t,Ye=a(),x=n("div"),p(A.$$.fragment),Ze=a(),oe=n("p"),oe.textContent=xt,et=a(),de=n("p"),de.textContent=yt,tt=a(),se=n("ol"),se.innerHTML=Pt,rt=a(),me=n("div"),p(j.$$.fragment),at=a(),pe=n("div"),p(B.$$.fragment),ke=a(),p(R.$$.fragment),Ee=a(),X=n("p"),X.innerHTML=Tt,He=a(),v=n("div"),p(G.$$.fragment),lt=a(),M=n("div"),p(J.$$.fragment),it=a(),ue=n("p"),ue.textContent=wt,nt=a(),L=n("div"),p(K.$$.fragment),ot=a(),ce=n("p"),ce.innerHTML=Ct,dt=a(),D=n("div"),p(Q.$$.fragment),st=a(),he=n("p"),he.textContent=Mt,Ie=a(),p(Y.$$.fragment),qe=a(),p(Z.$$.fragment),Ue=a(),ee=n("p"),ee.textContent=Lt,Oe=a(),$=n("div"),p(te.$$.fragment),mt=a(),ge=n("p"),ge.textContent=Dt,pt=a(),_e=n("ul"),_e.innerHTML=kt,ut=a(),be=n("p"),be.innerHTML=Et,Ve=a(),w=n("div"),p(re.$$.fragment),ct=a(),fe=n("p"),fe.textContent=Ht,Ne=a(),xe=n("p"),this.h()},l(e){const i=St("svelte-u9bgzb",document.head);T=o(i,"META",{name:!0,content:!0}),i.forEach(r),ye=l(e),$e=o(e,"P",{}),f($e).forEach(r),Pe=l(e),u(I.$$.fragment,e),Te=l(e),q=o(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-it0u39"&&(q.innerHTML=gt),we=l(e),u(U.$$.fragment,e),Ce=l(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-5ss4zj"&&(O.innerHTML=_t),Me=l(e),u(V.$$.fragment,e),Le=l(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1bsvcro"&&(N.innerHTML=bt),De=l(e),s=o(e,"DIV",{class:!0});var b=f(s);u(F.$$.fragment,b),Re=l(b),ae=o(b,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-h4ipsc"&&(ae.textContent=ft),Xe=l(b),C=o(b,"DIV",{class:!0});var Se=f(C);u(S.$$.fragment,Se),Ge=l(Se),le=o(Se,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1e0iews"&&(le.textContent=zt),Se.forEach(r),Je=l(b),P=o(b,"DIV",{class:!0});var ze=f(P);u(W.$$.fragment,ze),Ke=l(ze),ie=o(ze,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1ytdrar"&&(ie.innerHTML=vt),Qe=l(ze),ne=o(ze,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-3oskg6"&&(ne.textContent=$t),ze.forEach(r),Ye=l(b),x=o(b,"DIV",{class:!0});var k=f(x);u(A.$$.fragment,k),Ze=l(k),oe=o(k,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-gytsrb"&&(oe.textContent=xt),et=l(k),de=o(k,"P",{"data-svelte-h":!0}),m(de)!=="svelte-k6ubrx"&&(de.textContent=yt),tt=l(k),se=o(k,"OL",{"data-svelte-h":!0}),m(se)!=="svelte-ogaf4b"&&(se.innerHTML=Pt),k.forEach(r),rt=l(b),me=o(b,"DIV",{class:!0});var It=f(me);u(j.$$.fragment,It),It.forEach(r),at=l(b),pe=o(b,"DIV",{class:!0});var qt=f(pe);u(B.$$.fragment,qt),qt.forEach(r),b.forEach(r),ke=l(e),u(R.$$.fragment,e),Ee=l(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1x1mrd0"&&(X.innerHTML=Tt),He=l(e),v=o(e,"DIV",{class:!0});var E=f(v);u(G.$$.fragment,E),lt=l(E),M=o(E,"DIV",{class:!0});var We=f(M);u(J.$$.fragment,We),it=l(We),ue=o(We,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-esrxt2"&&(ue.textContent=wt),We.forEach(r),nt=l(E),L=o(E,"DIV",{class:!0});var Ae=f(L);u(K.$$.fragment,Ae),ot=l(Ae),ce=o(Ae,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1bapgxn"&&(ce.innerHTML=Ct),Ae.forEach(r),dt=l(E),D=o(E,"DIV",{class:!0});var je=f(D);u(Q.$$.fragment,je),st=l(je),he=o(je,"P",{"data-svelte-h":!0}),m(he)!=="svelte-3qe9b8"&&(he.textContent=Mt),je.forEach(r),E.forEach(r),Ie=l(e),u(Y.$$.fragment,e),qe=l(e),u(Z.$$.fragment,e),Ue=l(e),ee=o(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-4ddlue"&&(ee.textContent=Lt),Oe=l(e),$=o(e,"DIV",{class:!0});var H=f($);u(te.$$.fragment,H),mt=l(H),ge=o(H,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-bh7x4"&&(ge.textContent=Dt),pt=l(H),_e=o(H,"UL",{"data-svelte-h":!0}),m(_e)!=="svelte-1j7gypf"&&(_e.innerHTML=kt),ut=l(H),be=o(H,"P",{"data-svelte-h":!0}),m(be)!=="svelte-oha5tr"&&(be.innerHTML=Et),H.forEach(r),Ve=l(e),w=o(e,"DIV",{class:!0});var Be=f(w);u(re.$$.fragment,Be),ct=l(Be),fe=o(Be,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1agud9l"&&(fe.textContent=Ht),Be.forEach(r),Ne=l(e),xe=o(e,"P",{}),f(xe).forEach(r),this.h()},h(){z(T,"name","hf:doc:metadata"),z(T,"content",At),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,T),d(e,ye,i),d(e,$e,i),d(e,Pe,i),c(I,e,i),d(e,Te,i),d(e,q,i),d(e,we,i),c(U,e,i),d(e,Ce,i),d(e,O,i),d(e,Me,i),c(V,e,i),d(e,Le,i),d(e,N,i),d(e,De,i),d(e,s,i),c(F,s,null),t(s,Re),t(s,ae),t(s,Xe),t(s,C),c(S,C,null),t(C,Ge),t(C,le),t(s,Je),t(s,P),c(W,P,null),t(P,Ke),t(P,ie),t(P,Qe),t(P,ne),t(s,Ye),t(s,x),c(A,x,null),t(x,Ze),t(x,oe),t(x,et),t(x,de),t(x,tt),t(x,se),t(s,rt),t(s,me),c(j,me,null),t(s,at),t(s,pe),c(B,pe,null),d(e,ke,i),c(R,e,i),d(e,Ee,i),d(e,X,i),d(e,He,i),d(e,v,i),c(G,v,null),t(v,lt),t(v,M),c(J,M,null),t(M,it),t(M,ue),t(v,nt),t(v,L),c(K,L,null),t(L,ot),t(L,ce),t(v,dt),t(v,D),c(Q,D,null),t(D,st),t(D,he),d(e,Ie,i),c(Y,e,i),d(e,qe,i),c(Z,e,i),d(e,Ue,i),d(e,ee,i),d(e,Oe,i),d(e,$,i),c(te,$,null),t($,mt),t($,ge),t($,pt),t($,_e),t($,ut),t($,be),d(e,Ve,i),d(e,w,i),c(re,w,null),t(w,ct),t(w,fe),d(e,Ne,i),d(e,xe,i),Fe=!0},p:Ot,i(e){Fe||(h(I.$$.fragment,e),h(U.$$.fragment,e),h(V.$$.fragment,e),h(F.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(R.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(K.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(Z.$$.fragment,e),h(te.$$.fragment,e),h(re.$$.fragment,e),Fe=!0)},o(e){g(I.$$.fragment,e),g(U.$$.fragment,e),g(V.$$.fragment,e),g(F.$$.fragment,e),g(S.$$.fragment,e),g(W.$$.fragment,e),g(A.$$.fragment,e),g(j.$$.fragment,e),g(B.$$.fragment,e),g(R.$$.fragment,e),g(G.$$.fragment,e),g(J.$$.fragment,e),g(K.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(Z.$$.fragment,e),g(te.$$.fragment,e),g(re.$$.fragment,e),Fe=!1},d(e){e&&(r(ye),r($e),r(Pe),r(Te),r(q),r(we),r(Ce),r(O),r(Me),r(Le),r(N),r(De),r(s),r(ke),r(Ee),r(X),r(He),r(v),r(Ie),r(qe),r(Ue),r(ee),r(Oe),r($),r(Ve),r(w),r(Ne),r(xe)),r(T),_(I,e),_(U,e),_(V,e),_(F),_(S),_(W),_(A),_(j),_(B),_(R,e),_(G),_(J),_(K),_(Q),_(Y,e),_(Z,e),_(te),_(re)}}}const At='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Base Parallelizer","local":"optimum.neuron.distributed.Parallelizer","sections":[],"depth":3},{"title":"Selecting Model-Specific Parallelizer Classes","local":"optimum.neuron.distributed.ParallelizersManager","sections":[],"depth":3}],"depth":2},{"title":"Utils","local":"utils","sections":[{"title":"Lazy Loading","local":"optimum.neuron.distributed.lazy_load_for_parallelism","sections":[],"depth":3}],"depth":2}],"depth":1}';function jt(ht){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends Nt{constructor(T){super(),Ft(this,T,jt,Wt,Ut,{})}}export{Jt as component};
