import{s as fs,n as Us,o as bs}from"../chunks/scheduler.9039eef2.js";import{S as js,i as Is,g as i,s as n,r as p,A as Cs,h as o,f as l,c as a,j as Ts,u as c,x as r,k as Js,y as gs,a as s,v as m,d,t as u,w as M}from"../chunks/index.cdcc3d35.js";import{C as h}from"../chunks/CodeBlock.e3ac94d9.js";import{H as Ne}from"../chunks/Heading.96ce3702.js";function vs(Jl){let y,Le,ze,Ye,w,Ae,T,fl='This tutorial will teach you how to fine-tune open LLMs like <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf" rel="nofollow">Llama 2</a> on AWS Trainium. In our example, we are going to leverage Hugging Face <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">https://huggingface.co/docs/optimum-neuron/index</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">https://huggingface.co/docs/datasets/index</a>.',Ee,J,Ul="You will learn how to:",qe,f,bl='<li><a href="#1-setup-aws-environment">Setup AWS environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer">Fine-tune Llama on AWS Trainium using the <code>NeuronTrainer</code></a></li> <li><a href="#4-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',Pe,U,De,b,jl='<a href="https://aws.amazon.com/de/ec2/instance-types/trn1/" rel="nofollow">AWS Trainium (Trn1)</a> is a purpose-built EC2 for deep learning (DL) training workloads. Trainium is the successor of <a href="https://aws.amazon.com/ec2/instance-types/inf1/?nc1=h_ls" rel="nofollow">AWS Inferentia</a> focused on high-performance training workloads. Trainium has been optimized for training natural language processing, computer vision, and recommender models. The accelerator supports a wide range of data types, including FP32, TF32, BF16, FP16, UINT8, and configurable FP8.',Ke,j,Il='The biggest Trainium instance, the <code>trn1.32xlarge</code> comes with over 500GB of memory, making it easy to fine-tune ~10B parameter models on a single instance. Below you will find an overview of the available instance types. More details <a href="https://aws.amazon.com/de/ec2/instance-types/trn1/#Product_details" rel="nofollow">here</a>:',Oe,I,Cl="<thead><tr><th>instance size</th> <th>accelerators</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>price per hour</th></tr></thead> <tbody><tr><td>trn1.2xlarge</td> <td>1</td> <td>32</td> <td>8</td> <td>32</td> <td>\\$1.34</td></tr> <tr><td>trn1.32xlarge</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>\\$21.50</td></tr> <tr><td>trn1n.32xlarge (2x bandwidth)</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>\\$24.78</td></tr></tbody>",et,C,gl="<em>Note: This tutorial was created on a trn1.32xlarge AWS EC2 Instance.</em>",tt,g,lt,v,vl='In this example, we will use the <code>trn1.32xlarge</code> instance on AWS with 16 Accelerator, including 32 Neuron Cores and the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>. The Hugging Face AMI comes with all important libraries, like Transformers, Datasets, Optimum and Neuron packages pre-installed. This makes it super easy to get started, since there is no need for environment management.',st,B,Bl='This tutorial doesn’t cover how to create the instance in detail. You can check out the dedicated tutorial about <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">“Setting up AWS Trainium for Hugging Face Transformers”</a>, which includes a step-by-step guide on setting up the environment.',nt,G,Gl="Once the instance is up and running, we can ssh into it. But instead of developing inside a terminal we want to use a <code>Jupyter</code> environment, which we can use for preparing our dataset and launching the training. For this, we need to add a port for forwarding in the <code>ssh</code> command, which will tunnel our localhost traffic to the Trainium instance.",at,k,it,Z,kl='Let’s now pull the optimum repository with the <a href="https://github.com/huggingface/optimum-neuron/tree/main/notebooks/text-generation" rel="nofollow">example notebook and scripts</a>.',ot,W,rt,_,Zl="Next we can change our directory to <code>notbooks/text-generation</code> and launch the <code>jupyter</code> environment.",pt,x,ct,$,Wl="You should see a familiar <strong><code>jupyter</code></strong> output with a URL to the notebook.",mt,S,_l="<strong><code>http://localhost:8080/?token=8c1739aff1755bd7958c4cfccc8d08cb5da5234f61f129a9</code></strong>",dt,H,xl="We can click on it, and a <strong><code>jupyter</code></strong> environment opens in our local browser. Open the notebook <strong><code>llama2-7b-fine-tuning.ipynb</code></strong> and lets get started.",ut,X,$l="<em>Note: We are going to use the Jupyter environment only for preparing the dataset and then <code>torchrun</code> for launching our training script for distributed training.</em>",Mt,Q,Sl="If you are going to use official Llama 2 checkpoint you need to login into our hugging face account, which has access to the model, to use your token for accessing the gated repository. We can do this by running the following command:",ht,R,Hl="<em>Note: We also provide an ungated checkpoint.</em>",yt,V,wt,N,Tt,z,Xl='We will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a> an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',Jt,F,ft,L,Ql="To load the <code>dolly</code> dataset, we use the <code>load_dataset()</code> method from the 🤗 Datasets library.",Ut,Y,bt,A,Rl="To instruct tune our model we need to convert our structured examples into a collection of tasks described via instructions. We define a <code>formatting_function</code> that takes a sample and returns a string with our format instruction.",jt,E,It,q,Vl="let’s test our formatting function on a random example.",Ct,P,gt,D,Nl='In addition, to formatting our samples we also want to pack multiple samples to one sequence to have a more efficient training. This means that we are stacking multiple samples to one sequence and split them with an EOS Token. This makes the training more efficient. Packing/stacking samples can be done during training or before. We will do it before training to save time. We created a utility method <a href="https://github.com/huggingface/optimum-neuron/tree/main/notebooks/text-generation/scripts/utils/pack_dataset.py" rel="nofollow">pack_dataset</a> that takes a dataset and a packing function and returns a packed dataset.',vt,K,Bt,O,zl="To pack/stack our dataset we need to first tokenize it and then we can pack it with the <code>pack_dataset</code> method. To prepare our dataset we will now:",Gt,ee,Fl="<li>Format our samples using the template method and add an EOS token at the end of each sample</li> <li>Tokenize our dataset to convert it from text to tokens</li> <li>Pack our dataset to 2048 tokens</li>",kt,te,Zt,le,Ll="After we processed the datasets we are going save it to disk. You could also save it to S3 or the Hugging Face Hub for later use.",Wt,se,Yl="<em>Note: Packing and preprocessing your dataset can be run outside of the Trainium instance.</em>",_t,ne,xt,ae,$t,ie,Al='Normally you would use the <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a></strong> and <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a></strong> to fine-tune PyTorch-based transformer models.',St,oe,El="But together with AWS, we have developed a <code>NeuronTrainer</code> to improve performance, robustness, and safety when training on Trainium instances. The <code>NeuronTrainer</code> is part of the <code>optimum-neuron</code> library and can be used as a 1-to-1 replacement for the <code>Trainer</code>.",Ht,re,ql="When it comes to distributed training on AWS Trainium there are a few things we need to take care of. Since Llama is a big model it might not fit on a single accelerator, thats why we added support for different distributed training strategies to the <code>NeuronTrainer</code> including:",Xt,pe,Pl='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: shards the optimizer state over multiple devices.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: shards the model parameters along a given dimension on multiple devices, defined with <code>tensor_parallel_size</code></li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a> shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: <em>coming soon</em></li>',Qt,ce,Dl='We prepared a <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generation/scripts/run_clm.py" rel="nofollow">run_clm.py</a>, which implements those distributed training strategies for you already. If you want to know more about the details you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>. When training models on AWS Accelerators we first need to compile our model with our training arguments.',Rt,me,Kl='To overcome this we added a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">model cache</a>, which allows us to use precompiled models and configuration from Hugging Face Hub to skip the compilation step. But every change in the config, will lead to a new compilation, which could result in some cache misses.',Vt,de,Ol='<em>Note: If your configuration is not cached please open an issue on <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Github</a>, we are happy to include it.</em>',Nt,ue,es="We pre-compiled the config for our training already meaning you can either skip the cell below or rerun it will only take a few minutes since it reuses the cached configuration.",zt,Me,Ft,he,ts="<em>Note: Compiling without a cache can take ~40 minutes. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you we have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",Lt,ye,Yt,we,ls=`After the compilation is done we can start our training with a similar command, we just need to remove the <code>neuron_parallel_compile</code>. We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.
The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.`,At,Te,ss="Launch the training, with the following command.",Et,Je,qt,fe,ns="Thats it, we successfully trained Llama 7B on AWS Trainium. The training took for 3 epochs on dolly (15k samples) took 43:24 minutes where the raw training time was only 31:46 minutes. This leads to a cost of ~$15.5 for the e2e training on the trn1.32xlarge instance. Not Bad!",Pt,Ue,as="But before we can share and test our model we need to consolidate our model. Since we used Tensor Parallelism during training, we need to consolidate the model weights before we can use it. Tensor Parallelism shards the model weights accross different workers, only sharded checkpoints will be saved during training.",Dt,be,is="The Optimum CLI provides a way of doing that very easily via the `optimum neuron consolidate“ command:",Kt,je,Ot,Ie,os="Lets remove our “sharded” checkpoints as we have consolidated them already to safetensors.",el,Ce,tl,ge,ll,ve,rs="Similar to training to be able to run inferece on AWS Trainium or AWS Inferentia2 we need to compile our model for the correct use. We will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 for inference.",sl,Be,ps="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",nl,Ge,al,ke,cs="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",il,Ze,ol,We,ms="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",rl,_e,pl,xe,ds="Lets test inference. First we test without a context.",cl,$e,us="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",ml,Se,dl,He,Ms="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",ul,Xe,hs="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications",Ml,Qe,hl,Re,ys="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",yl,Ve,ws="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",wl,Fe,Tl;return w=new Ne({props:{title:"Fine-tune and Test Llama 2 7B on AWS Trainium",local:"fine-tune-and-test-llama-2-7b-on-aws-trainium",headingTag:"h1"}}),U=new Ne({props:{title:"Quick intro: AWS Trainium",local:"quick-intro-aws-trainium",headingTag:"h2"}}),g=new Ne({props:{title:"1. Setup AWS environment",local:"1-setup-aws-environment",headingTag:"h2"}}),k=new h({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUyQyUyMGUuZy4lMjBlYzItMy04MC0uLi4uJTBBS0VZX1BBVEglM0QlMjIlMjIlMjAlMjMlMjBsb2NhbCUyMHBhdGglMjB0byUyMGtleSUyQyUyMGUuZy4lMjBzc2glMkZ0cm4ucGVtJTBBJTBBc3NoJTIwLUwlMjA4MDgwJTNBbG9jYWxob3N0JTNBODA4MCUyMC1pJTIwJTI0JTdCS0VZX05BTUUlN0QucGVtJTIwdWJ1bnR1JTQwJTI0UFVCTElDX0ROUw==",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address, e.g. ec2-3-80-....</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key, e.g. ssh/trn.pem</span>

ssh -L 8080:localhost:8080 -i <span class="hljs-variable">\${KEY_NAME}</span>.pem ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),W=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),x=new h({props:{code:"JTIzJTIwY2hhbmdlJTIwZGlyZWN0b3J5JTBBY2QlMjBvcHRpbXVtLW5ldXJvbiUyRm5vdGVib29rcyUyRnRleHQtZ2VuZXJhdGlvbiUwQSUyMyUyMGxhdW5jaCUyMGp1cHl0ZXIlMEFweXRob24lMjAtbSUyMG5vdGVib29rJTIwLS1hbGxvdy1yb290JTIwLS1wb3J0JTNEODA4MA==",highlighted:`<span class="hljs-comment"># change directory</span>
<span class="hljs-built_in">cd</span> optimum-neuron/notebooks/text-generation
<span class="hljs-comment"># launch jupyter</span>
python -m notebook --allow-root --port=8080`,wrap:!1}}),V=new h({props:{code:"IWh1Z2dpbmdmYWNlLWNsaSUyMGxvZ2luJTIwLS10b2tlbiUyMFlPVVJfVE9LRU4=",highlighted:"!huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),N=new Ne({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),F=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAlMjJXb3JsZCUyMG9mJTIwd2FyY3JhZnQlMjBpcyUyMGElMjBtYXNzaXZlJTIwb25saW5lJTIwbXVsdGklMjBwbGF5ZXIlMjByb2xlJTIwcGxheWluZyUyMGdhbWUuJTIwSXQlMjB3YXMlMjByZWxlYXNlZCUyMGluJTIwMjAwNCUyMGJ5JTIwYml6YXJyZSUyMGVudGVydGFpbm1lbnQlMjIlMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. It was released in 2004 by bizarre entertainment&quot;</span>
}`,wrap:!1}}),Y=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTElMEE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>
`,wrap:!1}}),E=new h({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiU1Q24lN0JzYW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBDb250ZXh0JTVDbiU3QnNhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUyMGlmJTIwbGVuKHNhbXBsZSU1QiUyMmNvbnRleHQlMjIlNUQpJTIwJTNFJTIwMCUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiU3QnNhbXBsZSU1QidyZXNwb25zZSclNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBqb2luJTIwYWxsJTIwdGhlJTIwcGFydHMlMjB0b2dldGhlciUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt
`,wrap:!1}}),P=new h({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQXByaW50KGZvcm1hdF9kb2xseShkYXRhc2V0JTVCcmFuZHJhbmdlKGxlbihkYXRhc2V0KSklNUQpKQ==",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-built_in">print</span>(format_dolly(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))]))`,wrap:!1}}),K=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBIdWdnaW5nJTIwRmFjZSUyMG1vZGVsJTIwaWQlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnBoaWxzY2htaWQlMkZMbGFtYS0yLTdiLWhmJTIyJTIwJTIzJTIwdW5nYXRlZCUwQSUyMyUyMG1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMjAlMjMlMjBnYXRlZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Hugging Face model id</span>
model_id = <span class="hljs-string">&quot;philschmid/Llama-2-7b-hf&quot;</span> <span class="hljs-comment"># ungated</span>
<span class="hljs-comment"># model_id = &quot;meta-llama/Llama-2-7b-hf&quot; # gated</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)`,wrap:!1}}),te=new h({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRpbnQlMEElMjMlMjBhZGQlMjB1dGlscyUyMG1ldGhvZCUyMHRvJTIwcGF0aCUyMGZvciUyMGxvYWRpbmclMjBkYXRhc2V0JTBBaW1wb3J0JTIwc3lzJTBBc3lzLnBhdGguYXBwZW5kKCUyMi4lMkZzY3JpcHRzJTJGdXRpbHMlMjIpJTIwJTIzJTIwbWFrZSUyMHN1cmUlMjB5b3UlMjBjaGFuZ2UlMjB0aGlzJTIwdG8lMjB0aGUlMjBjb3JyZWN0JTIwcGF0aCUwQWZyb20lMjBwYWNrX2RhdGFzZXQlMjBpbXBvcnQlMjBwYWNrX2RhdGFzZXQlMEElMEElMEElMjMlMjB0ZW1wbGF0ZSUyMGRhdGFzZXQlMjB0byUyMGFkZCUyMHByb21wdCUyMHRvJTIwZWFjaCUyMHNhbXBsZSUwQWRlZiUyMHRlbXBsYXRlX2RhdGFzZXQoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMnRleHQlMjIlNUQlMjAlM0QlMjBmJTIyJTdCZm9ybWF0X2RvbGx5KHNhbXBsZSklN0QlN0J0b2tlbml6ZXIuZW9zX3Rva2VuJTdEJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBJTIzJTIwYXBwbHklMjBwcm9tcHQlMjB0ZW1wbGF0ZSUyMHBlciUyMHNhbXBsZSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCh0ZW1wbGF0ZV9kYXRhc2V0JTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RsaXN0KGRhdGFzZXQuZmVhdHVyZXMpKSUwQSUyMyUyMHByaW50JTIwcmFuZG9tJTIwc2FtcGxlJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRpbnQoMCUyQyUyMGxlbihkYXRhc2V0KSklNUQlNUIlMjJ0ZXh0JTIyJTVEKSUwQSUwQSUyMyUyMHRva2VuaXplJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBzYW1wbGUlM0ElMjB0b2tlbml6ZXIoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEbGlzdChkYXRhc2V0LmZlYXR1cmVzKSUwQSklMEElMEElMjMlMjBjaHVuayUyMGRhdGFzZXQlMEFsbV9kYXRhc2V0JTIwJTNEJTIwcGFja19kYXRhc2V0KGRhdGFzZXQlMkMlMjBjaHVua19sZW5ndGglM0QyMDQ4KSUyMCUyMyUyMFdlJTIwdXNlJTIwMjA0OCUyMGFzJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUyMGZvciUyMHBhY2tpbmc=",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint
<span class="hljs-comment"># add utils method to path for loading dataset</span>
<span class="hljs-keyword">import</span> sys
sys.path.append(<span class="hljs-string">&quot;./scripts/utils&quot;</span>) <span class="hljs-comment"># make sure you change this to the correct path</span>
<span class="hljs-keyword">from</span> pack_dataset <span class="hljs-keyword">import</span> pack_dataset


<span class="hljs-comment"># template dataset to add prompt to each sample</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">template_dataset</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;text&quot;</span>] = <span class="hljs-string">f&quot;<span class="hljs-subst">{format_dolly(sample)}</span><span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>
    <span class="hljs-keyword">return</span> sample

<span class="hljs-comment"># apply prompt template per sample</span>
dataset = dataset.<span class="hljs-built_in">map</span>(template_dataset, remove_columns=<span class="hljs-built_in">list</span>(dataset.features))
<span class="hljs-comment"># print random sample</span>
<span class="hljs-built_in">print</span>(dataset[randint(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset))][<span class="hljs-string">&quot;text&quot;</span>])

<span class="hljs-comment"># tokenize dataset</span>
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> sample: tokenizer(sample[<span class="hljs-string">&quot;text&quot;</span>]), batched=<span class="hljs-literal">True</span>, remove_columns=<span class="hljs-built_in">list</span>(dataset.features)
)

<span class="hljs-comment"># chunk dataset</span>
lm_dataset = pack_dataset(dataset, chunk_length=<span class="hljs-number">2048</span>) <span class="hljs-comment"># We use 2048 as the maximum length for packing</span>`,wrap:!1}}),ne=new h({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMGRpc2slMEFkYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJ0b2tlbml6ZWRfZG9sbHklMjIlMEFsbV9kYXRhc2V0LnNhdmVfdG9fZGlzayhkYXRhc2V0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to disk</span>
dataset_path = <span class="hljs-string">&quot;tokenized_dolly&quot;</span>
lm_dataset.save_to_disk(dataset_path)`,wrap:!1}}),ae=new Ne({props:{title:"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer",local:"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer",headingTag:"h2"}}),Me=new h({props:{code:"JTIzJTIwcHJlY29tcGlsYXRpb24lMjBjb21tYW5kJTBBIU1BTExPQ19BUkVOQV9NQVglM0Q2NCUyMG5ldXJvbl9wYXJhbGxlbF9jb21waWxlJTIwdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMzIlMjBzY3JpcHRzJTJGcnVuX2NsbS5weSUyMCU1QyUwQSUyMC0tbW9kZWxfaWQlMjAlN0Jtb2RlbF9pZCU3RCUyMCU1QyUwQSUyMC0tZGF0YXNldF9wYXRoJTIwJTdCZGF0YXNldF9wYXRoJTdEJTIwJTVDJTBBJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAtLW91dHB1dF9kaXIlMjBkb2xseV9sbGFtYSUyMCU1QyUwQSUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjBUcnVlJTIwJTVDJTBBJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjA4JTIwJTVDJTBBJTIwLS1tYXhfc3RlcHMlMjAxMCUyMCU1QyUwQSUyMC0tbG9nZ2luZ19zdGVwcyUyMDEwJTIwJTVDJTBBJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAxNg==",highlighted:`<span class="hljs-comment"># precompilation command</span>
!MALLOC_ARENA_MAX=<span class="hljs-number">64</span> neuron_parallel_compile torchrun --nproc_per_node=<span class="hljs-number">32</span> scripts/run_clm.py \\
 --model_id {model_id} \\
 --dataset_path {dataset_path} \\
 --bf16 <span class="hljs-literal">True</span> \\
 --learning_rate <span class="hljs-number">5e-5</span> \\
 --output_dir dolly_llama \\
 --overwrite_output_dir <span class="hljs-literal">True</span> \\
 --per_device_train_batch_size <span class="hljs-number">1</span> \\
 --gradient_checkpointing <span class="hljs-literal">True</span> \\
 --tensor_parallel_size <span class="hljs-number">8</span> \\
 --max_steps <span class="hljs-number">10</span> \\
 --logging_steps <span class="hljs-number">10</span> \\
 --gradient_accumulation_steps <span class="hljs-number">16</span>`,wrap:!1}}),ye=new h({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQSFybSUyMC1yZiUyMGRvbGx5X2xsYW1h",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
!rm -rf dolly_llama`,wrap:!1}}),Je=new h({props:{code:"IU1BTExPQ19BUkVOQV9NQVglM0Q2NCUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDMyJTIwc2NyaXB0cyUyRnJ1bl9jbG0ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwJTdCbW9kZWxfaWQlN0QlMjAlNUMlMEElMjAtLWRhdGFzZXRfcGF0aCUyMCU3QmRhdGFzZXRfcGF0aCU3RCUyMCU1QyUwQSUyMC0tYmYxNiUyMFRydWUlMjAlNUMlMEElMjAtLWxlYXJuaW5nX3JhdGUlMjA1ZS01JTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTIwZG9sbHlfbGxhbWElMjAlNUMlMEElMjAtLW92ZXJ3cml0ZV9vdXRwdXRfZGlyJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tc2tpcF9jYWNoZV9wdXNoJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMFRydWUlMjAlNUMlMEElMjAtLXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwOCUyMCU1QyUwQSUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAtLWxvZ2dpbmdfc3RlcHMlMjAxMCUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMTY=",highlighted:`!MALLOC_ARENA_MAX=<span class="hljs-number">64</span> torchrun --nproc_per_node=<span class="hljs-number">32</span> scripts/run_clm.py \\
 --model_id {model_id} \\
 --dataset_path {dataset_path} \\
 --bf16 <span class="hljs-literal">True</span> \\
 --learning_rate <span class="hljs-number">5e-5</span> \\
 --output_dir dolly_llama \\
 --overwrite_output_dir <span class="hljs-literal">True</span> \\
 --skip_cache_push <span class="hljs-literal">True</span> \\
 --per_device_train_batch_size <span class="hljs-number">1</span> \\
 --gradient_checkpointing <span class="hljs-literal">True</span> \\
 --tensor_parallel_size <span class="hljs-number">8</span> \\
 --num_train_epochs <span class="hljs-number">3</span> \\
 --logging_steps <span class="hljs-number">10</span> \\
 --gradient_accumulation_steps <span class="hljs-number">16</span>`,wrap:!1}}),je=new h({props:{code:"IW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY29uc29saWRhdGUlMjBkb2xseV9sbGFtYSUyRnRlbnNvcl9wYXJhbGxlbF9zaGFyZHMlMjBkb2xseV9sbGFtYQ==",highlighted:"!optimum-cli neuron consolidate dolly_llama/tensor_parallel_shards dolly_llama",wrap:!1}}),Ce=new h({props:{code:"IXJtJTIwLXJmJTIwZG9sbHlfbGxhbWElMkZ0ZW5zb3JfcGFyYWxsZWxfc2hhcmRz",highlighted:"!rm -rf dolly_llama/tensor_parallel_shards",wrap:!1}}),ge=new Ne({props:{title:"4. Evaluate and test fine-tuned Llama model",local:"4-evaluate-and-test-fine-tuned-llama-model",headingTag:"h2"}}),Ge=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMpJTBB",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)
`,wrap:!1}}),Ze=new h({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),_e=new h({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMCUyMyUyMGpvaW4lMjBhbGwlMjB0aGUlMjBwYXJ0cyUyMHRvZ2V0aGVyJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJpJTIwZm9yJTIwaSUyMGluJTIwJTVCaW5zdHJ1Y3Rpb24lMkMlMjBjb250ZXh0JTJDJTIwcmVzcG9uc2UlNUQlMjBpZiUyMGklMjBpcyUyMG5vdCUyME5vbmUlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHJvbXB0JTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMGZvcm1hdF9kb2xseV9pbmZlcmVuY2Uoc2FtcGxlKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC45JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9wX2slM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9wJTNEMC45KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCbGVuKHByb21wdCklM0ElNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(**inputs,
                         max_new_tokens=<span class="hljs-number">512</span>,
                         do_sample=<span class="hljs-literal">True</span>,
                         temperature=<span class="hljs-number">0.9</span>,
                         top_k=<span class="hljs-number">50</span>,
                         top_p=<span class="hljs-number">0.9</span>)
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Se=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Qe=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){y=i("meta"),Le=n(),ze=i("p"),Ye=n(),p(w.$$.fragment),Ae=n(),T=i("p"),T.innerHTML=fl,Ee=n(),J=i("p"),J.textContent=Ul,qe=n(),f=i("ol"),f.innerHTML=bl,Pe=n(),p(U.$$.fragment),De=n(),b=i("p"),b.innerHTML=jl,Ke=n(),j=i("p"),j.innerHTML=Il,Oe=n(),I=i("table"),I.innerHTML=Cl,et=n(),C=i("p"),C.innerHTML=gl,tt=n(),p(g.$$.fragment),lt=n(),v=i("p"),v.innerHTML=vl,st=n(),B=i("p"),B.innerHTML=Bl,nt=n(),G=i("p"),G.innerHTML=Gl,at=n(),p(k.$$.fragment),it=n(),Z=i("p"),Z.innerHTML=kl,ot=n(),p(W.$$.fragment),rt=n(),_=i("p"),_.innerHTML=Zl,pt=n(),p(x.$$.fragment),ct=n(),$=i("p"),$.innerHTML=Wl,mt=n(),S=i("p"),S.innerHTML=_l,dt=n(),H=i("p"),H.innerHTML=xl,ut=n(),X=i("p"),X.innerHTML=$l,Mt=n(),Q=i("p"),Q.textContent=Sl,ht=n(),R=i("p"),R.innerHTML=Hl,yt=n(),p(V.$$.fragment),wt=n(),p(N.$$.fragment),Tt=n(),z=i("p"),z.innerHTML=Xl,Jt=n(),p(F.$$.fragment),ft=n(),L=i("p"),L.innerHTML=Ql,Ut=n(),p(Y.$$.fragment),bt=n(),A=i("p"),A.innerHTML=Rl,jt=n(),p(E.$$.fragment),It=n(),q=i("p"),q.textContent=Vl,Ct=n(),p(P.$$.fragment),gt=n(),D=i("p"),D.innerHTML=Nl,vt=n(),p(K.$$.fragment),Bt=n(),O=i("p"),O.innerHTML=zl,Gt=n(),ee=i("ol"),ee.innerHTML=Fl,kt=n(),p(te.$$.fragment),Zt=n(),le=i("p"),le.textContent=Ll,Wt=n(),se=i("p"),se.innerHTML=Yl,_t=n(),p(ne.$$.fragment),xt=n(),p(ae.$$.fragment),$t=n(),ie=i("p"),ie.innerHTML=Al,St=n(),oe=i("p"),oe.innerHTML=El,Ht=n(),re=i("p"),re.innerHTML=ql,Xt=n(),pe=i("ul"),pe.innerHTML=Pl,Qt=n(),ce=i("p"),ce.innerHTML=Dl,Rt=n(),me=i("p"),me.innerHTML=Kl,Vt=n(),de=i("p"),de.innerHTML=Ol,Nt=n(),ue=i("p"),ue.textContent=es,zt=n(),p(Me.$$.fragment),Ft=n(),he=i("p"),he.innerHTML=ts,Lt=n(),p(ye.$$.fragment),Yt=n(),we=i("p"),we.innerHTML=ls,At=n(),Te=i("p"),Te.textContent=ss,Et=n(),p(Je.$$.fragment),qt=n(),fe=i("p"),fe.textContent=ns,Pt=n(),Ue=i("p"),Ue.textContent=as,Dt=n(),be=i("p"),be.textContent=is,Kt=n(),p(je.$$.fragment),Ot=n(),Ie=i("p"),Ie.textContent=os,el=n(),p(Ce.$$.fragment),tl=n(),p(ge.$$.fragment),ll=n(),ve=i("p"),ve.textContent=rs,sl=n(),Be=i("p"),Be.innerHTML=ps,nl=n(),p(Ge.$$.fragment),al=n(),ke=i("p"),ke.innerHTML=cs,il=n(),p(Ze.$$.fragment),ol=n(),We=i("p"),We.innerHTML=ms,rl=n(),p(_e.$$.fragment),pl=n(),xe=i("p"),xe.textContent=ds,cl=n(),$e=i("p"),$e.innerHTML=us,ml=n(),p(Se.$$.fragment),dl=n(),He=i("blockquote"),He.innerHTML=Ms,ul=n(),Xe=i("p"),Xe.textContent=hs,Ml=n(),p(Qe.$$.fragment),hl=n(),Re=i("blockquote"),Re.innerHTML=ys,yl=n(),Ve=i("p"),Ve.textContent=ws,wl=n(),Fe=i("p"),this.h()},l(e){const t=Cs("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),Le=a(e),ze=o(e,"P",{}),Ts(ze).forEach(l),Ye=a(e),c(w.$$.fragment,e),Ae=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-bteys1"&&(T.innerHTML=fl),Ee=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1hahfn0"&&(J.textContent=Ul),qe=a(e),f=o(e,"OL",{"data-svelte-h":!0}),r(f)!=="svelte-1baq49t"&&(f.innerHTML=bl),Pe=a(e),c(U.$$.fragment,e),De=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1gu40it"&&(b.innerHTML=jl),Ke=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-f3jgz1"&&(j.innerHTML=Il),Oe=a(e),I=o(e,"TABLE",{"data-svelte-h":!0}),r(I)!=="svelte-48yzfd"&&(I.innerHTML=Cl),et=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1qrp4mv"&&(C.innerHTML=gl),tt=a(e),c(g.$$.fragment,e),lt=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-jip0oh"&&(v.innerHTML=vl),st=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-s32fl1"&&(B.innerHTML=Bl),nt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1w4fiht"&&(G.innerHTML=Gl),at=a(e),c(k.$$.fragment,e),it=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-p2qobr"&&(Z.innerHTML=kl),ot=a(e),c(W.$$.fragment,e),rt=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1hi5xni"&&(_.innerHTML=Zl),pt=a(e),c(x.$$.fragment,e),ct=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-si97e0"&&($.innerHTML=Wl),mt=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-7s5jat"&&(S.innerHTML=_l),dt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-wrj5fl"&&(H.innerHTML=xl),ut=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-k7cbiv"&&(X.innerHTML=$l),Mt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1o2i2ph"&&(Q.textContent=Sl),ht=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-rga01y"&&(R.innerHTML=Hl),yt=a(e),c(V.$$.fragment,e),wt=a(e),c(N.$$.fragment,e),Tt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-170rdxe"&&(z.innerHTML=Xl),Jt=a(e),c(F.$$.fragment,e),ft=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-nx074l"&&(L.innerHTML=Ql),Ut=a(e),c(Y.$$.fragment,e),bt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-jgf9sc"&&(A.innerHTML=Rl),jt=a(e),c(E.$$.fragment,e),It=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-123z1dj"&&(q.textContent=Vl),Ct=a(e),c(P.$$.fragment,e),gt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ya9sie"&&(D.innerHTML=Nl),vt=a(e),c(K.$$.fragment,e),Bt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1v8dcxr"&&(O.innerHTML=zl),Gt=a(e),ee=o(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-v6jbub"&&(ee.innerHTML=Fl),kt=a(e),c(te.$$.fragment,e),Zt=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-16jyes1"&&(le.textContent=Ll),Wt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1qdlstl"&&(se.innerHTML=Yl),_t=a(e),c(ne.$$.fragment,e),xt=a(e),c(ae.$$.fragment,e),$t=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-3kvj29"&&(ie.innerHTML=Al),St=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-16nqarb"&&(oe.innerHTML=El),Ht=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-d5p0c0"&&(re.innerHTML=ql),Xt=a(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-1cjxveo"&&(pe.innerHTML=Pl),Qt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-6yisi"&&(ce.innerHTML=Dl),Rt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1gx5zns"&&(me.innerHTML=Kl),Vt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1efdq7y"&&(de.innerHTML=Ol),Nt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1brtt7t"&&(ue.textContent=es),zt=a(e),c(Me.$$.fragment,e),Ft=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-ro2mv7"&&(he.innerHTML=ts),Lt=a(e),c(ye.$$.fragment,e),Yt=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1lieax4"&&(we.innerHTML=ls),At=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-17lv8z9"&&(Te.textContent=ss),Et=a(e),c(Je.$$.fragment,e),qt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-159xyop"&&(fe.textContent=ns),Pt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1nzjqkj"&&(Ue.textContent=as),Dt=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-szrdkh"&&(be.textContent=is),Kt=a(e),c(je.$$.fragment,e),Ot=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-15qqwtu"&&(Ie.textContent=os),el=a(e),c(Ce.$$.fragment,e),tl=a(e),c(ge.$$.fragment,e),ll=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-8ad54z"&&(ve.textContent=rs),sl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1pgrxrm"&&(Be.innerHTML=ps),nl=a(e),c(Ge.$$.fragment,e),al=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1sinvz7"&&(ke.innerHTML=cs),il=a(e),c(Ze.$$.fragment,e),ol=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-jx2yqv"&&(We.innerHTML=ms),rl=a(e),c(_e.$$.fragment,e),pl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-uuj81b"&&(xe.textContent=ds),cl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1j8w2o0"&&($e.innerHTML=us),ml=a(e),c(Se.$$.fragment,e),dl=a(e),He=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(He)!=="svelte-6l4k0q"&&(He.innerHTML=Ms),ul=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-u3q76o"&&(Xe.textContent=hs),Ml=a(e),c(Qe.$$.fragment,e),hl=a(e),Re=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Re)!=="svelte-15xrtpx"&&(Re.innerHTML=ys),yl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-q9f4rf"&&(Ve.textContent=ws),wl=a(e),Fe=o(e,"P",{}),Ts(Fe).forEach(l),this.h()},h(){Js(y,"name","hf:doc:metadata"),Js(y,"content",Bs)},m(e,t){gs(document.head,y),s(e,Le,t),s(e,ze,t),s(e,Ye,t),m(w,e,t),s(e,Ae,t),s(e,T,t),s(e,Ee,t),s(e,J,t),s(e,qe,t),s(e,f,t),s(e,Pe,t),m(U,e,t),s(e,De,t),s(e,b,t),s(e,Ke,t),s(e,j,t),s(e,Oe,t),s(e,I,t),s(e,et,t),s(e,C,t),s(e,tt,t),m(g,e,t),s(e,lt,t),s(e,v,t),s(e,st,t),s(e,B,t),s(e,nt,t),s(e,G,t),s(e,at,t),m(k,e,t),s(e,it,t),s(e,Z,t),s(e,ot,t),m(W,e,t),s(e,rt,t),s(e,_,t),s(e,pt,t),m(x,e,t),s(e,ct,t),s(e,$,t),s(e,mt,t),s(e,S,t),s(e,dt,t),s(e,H,t),s(e,ut,t),s(e,X,t),s(e,Mt,t),s(e,Q,t),s(e,ht,t),s(e,R,t),s(e,yt,t),m(V,e,t),s(e,wt,t),m(N,e,t),s(e,Tt,t),s(e,z,t),s(e,Jt,t),m(F,e,t),s(e,ft,t),s(e,L,t),s(e,Ut,t),m(Y,e,t),s(e,bt,t),s(e,A,t),s(e,jt,t),m(E,e,t),s(e,It,t),s(e,q,t),s(e,Ct,t),m(P,e,t),s(e,gt,t),s(e,D,t),s(e,vt,t),m(K,e,t),s(e,Bt,t),s(e,O,t),s(e,Gt,t),s(e,ee,t),s(e,kt,t),m(te,e,t),s(e,Zt,t),s(e,le,t),s(e,Wt,t),s(e,se,t),s(e,_t,t),m(ne,e,t),s(e,xt,t),m(ae,e,t),s(e,$t,t),s(e,ie,t),s(e,St,t),s(e,oe,t),s(e,Ht,t),s(e,re,t),s(e,Xt,t),s(e,pe,t),s(e,Qt,t),s(e,ce,t),s(e,Rt,t),s(e,me,t),s(e,Vt,t),s(e,de,t),s(e,Nt,t),s(e,ue,t),s(e,zt,t),m(Me,e,t),s(e,Ft,t),s(e,he,t),s(e,Lt,t),m(ye,e,t),s(e,Yt,t),s(e,we,t),s(e,At,t),s(e,Te,t),s(e,Et,t),m(Je,e,t),s(e,qt,t),s(e,fe,t),s(e,Pt,t),s(e,Ue,t),s(e,Dt,t),s(e,be,t),s(e,Kt,t),m(je,e,t),s(e,Ot,t),s(e,Ie,t),s(e,el,t),m(Ce,e,t),s(e,tl,t),m(ge,e,t),s(e,ll,t),s(e,ve,t),s(e,sl,t),s(e,Be,t),s(e,nl,t),m(Ge,e,t),s(e,al,t),s(e,ke,t),s(e,il,t),m(Ze,e,t),s(e,ol,t),s(e,We,t),s(e,rl,t),m(_e,e,t),s(e,pl,t),s(e,xe,t),s(e,cl,t),s(e,$e,t),s(e,ml,t),m(Se,e,t),s(e,dl,t),s(e,He,t),s(e,ul,t),s(e,Xe,t),s(e,Ml,t),m(Qe,e,t),s(e,hl,t),s(e,Re,t),s(e,yl,t),s(e,Ve,t),s(e,wl,t),s(e,Fe,t),Tl=!0},p:Us,i(e){Tl||(d(w.$$.fragment,e),d(U.$$.fragment,e),d(g.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(x.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(Me.$$.fragment,e),d(ye.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(Ce.$$.fragment,e),d(ge.$$.fragment,e),d(Ge.$$.fragment,e),d(Ze.$$.fragment,e),d(_e.$$.fragment,e),d(Se.$$.fragment,e),d(Qe.$$.fragment,e),Tl=!0)},o(e){u(w.$$.fragment,e),u(U.$$.fragment,e),u(g.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(x.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(ge.$$.fragment,e),u(Ge.$$.fragment,e),u(Ze.$$.fragment,e),u(_e.$$.fragment,e),u(Se.$$.fragment,e),u(Qe.$$.fragment,e),Tl=!1},d(e){e&&(l(Le),l(ze),l(Ye),l(Ae),l(T),l(Ee),l(J),l(qe),l(f),l(Pe),l(De),l(b),l(Ke),l(j),l(Oe),l(I),l(et),l(C),l(tt),l(lt),l(v),l(st),l(B),l(nt),l(G),l(at),l(it),l(Z),l(ot),l(rt),l(_),l(pt),l(ct),l($),l(mt),l(S),l(dt),l(H),l(ut),l(X),l(Mt),l(Q),l(ht),l(R),l(yt),l(wt),l(Tt),l(z),l(Jt),l(ft),l(L),l(Ut),l(bt),l(A),l(jt),l(It),l(q),l(Ct),l(gt),l(D),l(vt),l(Bt),l(O),l(Gt),l(ee),l(kt),l(Zt),l(le),l(Wt),l(se),l(_t),l(xt),l($t),l(ie),l(St),l(oe),l(Ht),l(re),l(Xt),l(pe),l(Qt),l(ce),l(Rt),l(me),l(Vt),l(de),l(Nt),l(ue),l(zt),l(Ft),l(he),l(Lt),l(Yt),l(we),l(At),l(Te),l(Et),l(qt),l(fe),l(Pt),l(Ue),l(Dt),l(be),l(Kt),l(Ot),l(Ie),l(el),l(tl),l(ll),l(ve),l(sl),l(Be),l(nl),l(al),l(ke),l(il),l(ol),l(We),l(rl),l(pl),l(xe),l(cl),l($e),l(ml),l(dl),l(He),l(ul),l(Xe),l(Ml),l(hl),l(Re),l(yl),l(Ve),l(wl),l(Fe)),l(y),M(w,e),M(U,e),M(g,e),M(k,e),M(W,e),M(x,e),M(V,e),M(N,e),M(F,e),M(Y,e),M(E,e),M(P,e),M(K,e),M(te,e),M(ne,e),M(ae,e),M(Me,e),M(ye,e),M(Je,e),M(je,e),M(Ce,e),M(ge,e),M(Ge,e),M(Ze,e),M(_e,e),M(Se,e),M(Qe,e)}}}const Bs='{"title":"Fine-tune and Test Llama 2 7B on AWS Trainium","local":"fine-tune-and-test-llama-2-7b-on-aws-trainium","sections":[{"title":"Quick intro: AWS Trainium","local":"quick-intro-aws-trainium","sections":[],"depth":2},{"title":"1. Setup AWS environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer","local":"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer","sections":[],"depth":2},{"title":"4. Evaluate and test fine-tuned Llama model","local":"4-evaluate-and-test-fine-tuned-llama-model","sections":[],"depth":2}],"depth":1}';function Gs(Jl){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends js{constructor(y){super(),Is(this,y,Gs,vs,fs,{})}}export{xs as component};
