import{s as Us,o as ws,n as Js}from"../chunks/scheduler.987d3921.js";import{S as Ts,i as $s,g as i,s as t,r,A as xs,h as p,f as n,c as a,j as bs,u as o,x as u,k as Ke,y as ks,a as l,v as m,d as c,t as d,w as h}from"../chunks/index.c8b1fed4.js";import{T as Is}from"../chunks/Tip.6bc1e794.js";import{C as M}from"../chunks/CodeBlock.e6da2eac.js";import{H as pe,E as Zs}from"../chunks/index.cb1d4ec5.js";function vs(oe){let g,b="Eine vollständige Liste der unterstützten Aufgaben und verfügbaren Parameter finden Sie in der <code>pipeline()</code>-Dokumentation.";return{c(){g=i("p"),g.innerHTML=b},l(j){g=p(j,"P",{"data-svelte-h":!0}),u(g)!=="svelte-13a0a0h"&&(g.innerHTML=b)},m(j,ie){l(j,g,ie)},p:Js,d(j){j&&n(g)}}}function Cs(oe){let g,b,j,ie,U,me,w,Oe='Die <code>pipeline()</code> macht es einfach, jedes beliebige Modell aus dem <a href="https://huggingface.co/models" rel="nofollow">Hub</a> für die Inferenz auf jede Sprache, Computer Vision, Sprache und multimodale Aufgaben zu verwenden. Selbst wenn Sie keine Erfahrung mit einer bestimmten Modalität haben oder nicht mit dem zugrundeliegenden Code hinter den Modellen vertraut sind, können Sie sie mit der <code>pipeline()</code> für Inferenzen verwenden! In diesem Beispiel lernen Sie, wie:',ce,J,es="<li>Eine <code>pipeline()</code> für Inferenz zu verwenden.</li> <li>Einen bestimmten Tokenizer oder ein bestimmtes Modell zu verwenden.</li> <li>Eine <code>pipeline()</code> für Audio-, Vision- und multimodale Aufgaben zu verwenden.</li>",de,y,he,T,ue,$,ss="Obwohl jede Aufgabe eine zugehörige <code>pipeline()</code> hat, ist es einfacher, die allgemeine <code>pipeline()</code>-Abstraktion zu verwenden, die alle aufgabenspezifischen Pipelines enthält. Die <code>pipeline()</code> lädt automatisch ein Standardmodell und eine Vorverarbeitungsklasse, die für Ihre Aufgabe inferenzfähig ist.",ge,x,ns="<li>Beginnen Sie mit der Erstellung einer <code>pipeline()</code> und geben Sie eine Inferenzaufgabe an:</li>",Me,k,je,f,ls="<li>Übergeben Sie Ihren Eingabetext an die <code>pipeline()</code>:</li>",ye,I,fe,Z,ts="Wenn Sie mehr als eine Eingabe haben, übergeben Sie die Eingabe als Liste:",be,v,Ue,C,as="Alle zusätzlichen Parameter für Ihre Aufgabe können auch in die <code>pipeline()</code> aufgenommen werden. Die Aufgabe <code>Text-Generierung</code> hat eine <code>generate()</code>-Methode mit mehreren Parametern zur Steuerung der Ausgabe. Wenn Sie zum Beispiel mehr als eine Ausgabe erzeugen wollen, setzen Sie den Parameter <code>num_return_sequences</code>:",we,G,Je,B,Te,W,is='Die <code>pipeline()</code> akzeptiert jedes Modell aus dem <a href="https://huggingface.co/models" rel="nofollow">Hub</a>. Auf dem Hub gibt es Tags, mit denen Sie nach einem Modell filtern können, das Sie für Ihre Aufgabe verwenden möchten. Sobald Sie ein passendes Modell ausgewählt haben, laden Sie es mit der entsprechenden <code>AutoModelFor</code> und <code>AutoTokenizer</code> Klasse. Laden Sie zum Beispiel die Klasse <code>AutoModelForCausalLM</code> für eine kausale Sprachmodellierungsaufgabe:',$e,z,xe,V,ps="Erstellen Sie eine <code>pipeline()</code> für Ihre Aufgabe, und geben Sie das Modell und den Tokenizer an, die Sie geladen haben:",ke,S,Ie,H,rs="Übergeben Sie Ihren Eingabetext an die <code>pipeline()</code> , um einen Text zu erzeugen:",Ze,R,ve,q,Ce,E,os="Die <code>pipeline()</code> unterstützt auch Audioaufgaben wie Audioklassifizierung und automatische Spracherkennung.",Ge,Q,ms="Lassen Sie uns zum Beispiel die Emotion in diesem Audioclip klassifizieren:",Be,A,We,_,cs='Finden Sie ein <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">Audioklassifikation</a> Modell auf dem Model Hub für Emotionserkennung und laden Sie es in die <code>pipeline()</code>:',ze,N,Ve,X,ds="Übergeben Sie die Audiodatei an die <code>pipeline()</code>:",Se,L,He,F,Re,Y,hs="Die Verwendung einer <code>pipeline()</code> für Bildverarbeitungsaufgaben ist praktisch identisch.",qe,P,us="Geben Sie Ihre Aufgabe an und übergeben Sie Ihr Bild an den Klassifikator. Das Bild kann ein Link oder ein lokaler Pfad zu dem Bild sein. Zum Beispiel: Welche Katzenart ist unten abgebildet?",Ee,D,gs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Qe,K,Ae,O,_e,ee,Ms="Die <code>pipeline()</code> unterstützt mehr als eine Modalität. Eine Aufgabe zur Beantwortung visueller Fragen (VQA) kombiniert zum Beispiel Text und Bild. Verwenden Sie einen beliebigen Bildlink und eine Frage, die Sie zu dem Bild stellen möchten. Das Bild kann eine URL oder ein lokaler Pfad zu dem Bild sein.",Ne,se,js="Wenn Sie zum Beispiel das gleiche Bild wie in der obigen Vision-Pipeline verwenden:",Xe,ne,Le,le,ys="Erstellen Sie eine Pipeline für “vqa” und übergeben Sie ihr das Bild und die Frage:",Fe,te,Ye,ae,Pe,re,De;return U=new pe({props:{title:"Pipelines für Inferenzen",local:"pipelines-für-inferenzen",headingTag:"h1"}}),y=new Is({props:{$$slots:{default:[vs]},$$scope:{ctx:oe}}}),T=new pe({props:{title:"Verwendung von Pipelines",local:"verwendung-von-pipelines",headingTag:"h2"}}),k=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),I=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),v=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),G=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),B=new pe({props:{title:"Wählen Sie ein Modell und einen Tokenizer",local:"wählen-sie-ein-modell-und-einen-tokenizer",headingTag:"h3"}}),z=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)`,wrap:!1}}),S=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),R=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),q=new pe({props:{title:"Audio-Pipeline",local:"audio-pipeline",headingTag:"h2"}}),A=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFhdWRpb19maWxlJTIwJTNEJTIwZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJwYXRoJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),N=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),L=new M({props:{code:"cHJlZHMlMjAlM0QlMjBhdWRpb19jbGFzc2lmaWVyKGF1ZGlvX2ZpbGUpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>preds = audio_classifier(audio_file)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1315</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1307</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neutral&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1274</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1261</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1242</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>}]`,wrap:!1}}),F=new pe({props:{title:"Bildverarbeitungs-Pipeline",local:"bildverarbeitungs-pipeline",headingTag:"h2"}}),K=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjB2aXNpb25fY2xhc3NpZmllciglMEElMjAlMjAlMjAlMjBpbWFnZXMlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),O=new pe({props:{title:"Multimodale Pipeline",local:"multimodale-pipeline",headingTag:"h2"}}),ne=new M({props:{code:"aW1hZ2UlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMGNhdCUzRiUyMg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;Where is the cat?&quot;</span>`,wrap:!1}}),te=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnZxYSUyMiklMEFwcmVkcyUyMCUzRCUyMHZxYShpbWFnZSUzRGltYWdlJTJDJTIwcXVlc3Rpb24lM0RxdWVzdGlvbiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJhbnN3ZXIlMjIlM0ElMjBwcmVkJTVCJTIyYW5zd2VyJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(task=<span class="hljs-string">&quot;vqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vqa(image=image, question=question)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;answer&quot;</span>: pred[<span class="hljs-string">&quot;answer&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9112</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.8796</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;in snow&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.6717</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;outside&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0291</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;on ground&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.027</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;ground&#x27;</span>}]`,wrap:!1}}),ae=new Zs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/de/pipeline_tutorial.md"}}),{c(){g=i("meta"),b=t(),j=i("p"),ie=t(),r(U.$$.fragment),me=t(),w=i("p"),w.innerHTML=Oe,ce=t(),J=i("ul"),J.innerHTML=es,de=t(),r(y.$$.fragment),he=t(),r(T.$$.fragment),ue=t(),$=i("p"),$.innerHTML=ss,ge=t(),x=i("ol"),x.innerHTML=ns,Me=t(),r(k.$$.fragment),je=t(),f=i("ol"),f.innerHTML=ls,ye=t(),r(I.$$.fragment),fe=t(),Z=i("p"),Z.textContent=ts,be=t(),r(v.$$.fragment),Ue=t(),C=i("p"),C.innerHTML=as,we=t(),r(G.$$.fragment),Je=t(),r(B.$$.fragment),Te=t(),W=i("p"),W.innerHTML=is,$e=t(),r(z.$$.fragment),xe=t(),V=i("p"),V.innerHTML=ps,ke=t(),r(S.$$.fragment),Ie=t(),H=i("p"),H.innerHTML=rs,Ze=t(),r(R.$$.fragment),ve=t(),r(q.$$.fragment),Ce=t(),E=i("p"),E.innerHTML=os,Ge=t(),Q=i("p"),Q.textContent=ms,Be=t(),r(A.$$.fragment),We=t(),_=i("p"),_.innerHTML=cs,ze=t(),r(N.$$.fragment),Ve=t(),X=i("p"),X.innerHTML=ds,Se=t(),r(L.$$.fragment),He=t(),r(F.$$.fragment),Re=t(),Y=i("p"),Y.innerHTML=hs,qe=t(),P=i("p"),P.textContent=us,Ee=t(),D=i("p"),D.innerHTML=gs,Qe=t(),r(K.$$.fragment),Ae=t(),r(O.$$.fragment),_e=t(),ee=i("p"),ee.innerHTML=Ms,Ne=t(),se=i("p"),se.textContent=js,Xe=t(),r(ne.$$.fragment),Le=t(),le=i("p"),le.textContent=ys,Fe=t(),r(te.$$.fragment),Ye=t(),r(ae.$$.fragment),Pe=t(),re=i("p"),this.h()},l(e){const s=xs("svelte-u9bgzb",document.head);g=p(s,"META",{name:!0,content:!0}),s.forEach(n),b=a(e),j=p(e,"P",{}),bs(j).forEach(n),ie=a(e),o(U.$$.fragment,e),me=a(e),w=p(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-pgo72q"&&(w.innerHTML=Oe),ce=a(e),J=p(e,"UL",{"data-svelte-h":!0}),u(J)!=="svelte-1r97160"&&(J.innerHTML=es),de=a(e),o(y.$$.fragment,e),he=a(e),o(T.$$.fragment,e),ue=a(e),$=p(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-131iydd"&&($.innerHTML=ss),ge=a(e),x=p(e,"OL",{"data-svelte-h":!0}),u(x)!=="svelte-7ukubc"&&(x.innerHTML=ns),Me=a(e),o(k.$$.fragment,e),je=a(e),f=p(e,"OL",{start:!0,"data-svelte-h":!0}),u(f)!=="svelte-576cei"&&(f.innerHTML=ls),ye=a(e),o(I.$$.fragment,e),fe=a(e),Z=p(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-5edsts"&&(Z.textContent=ts),be=a(e),o(v.$$.fragment,e),Ue=a(e),C=p(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-18y937w"&&(C.innerHTML=as),we=a(e),o(G.$$.fragment,e),Je=a(e),o(B.$$.fragment,e),Te=a(e),W=p(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-2xb0dv"&&(W.innerHTML=is),$e=a(e),o(z.$$.fragment,e),xe=a(e),V=p(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1pg1bwk"&&(V.innerHTML=ps),ke=a(e),o(S.$$.fragment,e),Ie=a(e),H=p(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-tafigc"&&(H.innerHTML=rs),Ze=a(e),o(R.$$.fragment,e),ve=a(e),o(q.$$.fragment,e),Ce=a(e),E=p(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-xr6iji"&&(E.innerHTML=os),Ge=a(e),Q=p(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-focxr8"&&(Q.textContent=ms),Be=a(e),o(A.$$.fragment,e),We=a(e),_=p(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-y0dy9h"&&(_.innerHTML=cs),ze=a(e),o(N.$$.fragment,e),Ve=a(e),X=p(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-abxu8t"&&(X.innerHTML=ds),Se=a(e),o(L.$$.fragment,e),He=a(e),o(F.$$.fragment,e),Re=a(e),Y=p(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-z5s5d7"&&(Y.innerHTML=hs),qe=a(e),P=p(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-zwmd7x"&&(P.textContent=us),Ee=a(e),D=p(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1bks2jw"&&(D.innerHTML=gs),Qe=a(e),o(K.$$.fragment,e),Ae=a(e),o(O.$$.fragment,e),_e=a(e),ee=p(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-11yqw70"&&(ee.innerHTML=Ms),Ne=a(e),se=p(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-18cdahu"&&(se.textContent=js),Xe=a(e),o(ne.$$.fragment,e),Le=a(e),le=p(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-14oafxv"&&(le.textContent=ys),Fe=a(e),o(te.$$.fragment,e),Ye=a(e),o(ae.$$.fragment,e),Pe=a(e),re=p(e,"P",{}),bs(re).forEach(n),this.h()},h(){Ke(g,"name","hf:doc:metadata"),Ke(g,"content",Gs),Ke(f,"start","2")},m(e,s){ks(document.head,g),l(e,b,s),l(e,j,s),l(e,ie,s),m(U,e,s),l(e,me,s),l(e,w,s),l(e,ce,s),l(e,J,s),l(e,de,s),m(y,e,s),l(e,he,s),m(T,e,s),l(e,ue,s),l(e,$,s),l(e,ge,s),l(e,x,s),l(e,Me,s),m(k,e,s),l(e,je,s),l(e,f,s),l(e,ye,s),m(I,e,s),l(e,fe,s),l(e,Z,s),l(e,be,s),m(v,e,s),l(e,Ue,s),l(e,C,s),l(e,we,s),m(G,e,s),l(e,Je,s),m(B,e,s),l(e,Te,s),l(e,W,s),l(e,$e,s),m(z,e,s),l(e,xe,s),l(e,V,s),l(e,ke,s),m(S,e,s),l(e,Ie,s),l(e,H,s),l(e,Ze,s),m(R,e,s),l(e,ve,s),m(q,e,s),l(e,Ce,s),l(e,E,s),l(e,Ge,s),l(e,Q,s),l(e,Be,s),m(A,e,s),l(e,We,s),l(e,_,s),l(e,ze,s),m(N,e,s),l(e,Ve,s),l(e,X,s),l(e,Se,s),m(L,e,s),l(e,He,s),m(F,e,s),l(e,Re,s),l(e,Y,s),l(e,qe,s),l(e,P,s),l(e,Ee,s),l(e,D,s),l(e,Qe,s),m(K,e,s),l(e,Ae,s),m(O,e,s),l(e,_e,s),l(e,ee,s),l(e,Ne,s),l(e,se,s),l(e,Xe,s),m(ne,e,s),l(e,Le,s),l(e,le,s),l(e,Fe,s),m(te,e,s),l(e,Ye,s),m(ae,e,s),l(e,Pe,s),l(e,re,s),De=!0},p(e,[s]){const fs={};s&2&&(fs.$$scope={dirty:s,ctx:e}),y.$set(fs)},i(e){De||(c(U.$$.fragment,e),c(y.$$.fragment,e),c(T.$$.fragment,e),c(k.$$.fragment,e),c(I.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),c(R.$$.fragment,e),c(q.$$.fragment,e),c(A.$$.fragment,e),c(N.$$.fragment,e),c(L.$$.fragment,e),c(F.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ne.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),De=!0)},o(e){d(U.$$.fragment,e),d(y.$$.fragment,e),d(T.$$.fragment,e),d(k.$$.fragment,e),d(I.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(z.$$.fragment,e),d(S.$$.fragment,e),d(R.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(F.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(ne.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),De=!1},d(e){e&&(n(b),n(j),n(ie),n(me),n(w),n(ce),n(J),n(de),n(he),n(ue),n($),n(ge),n(x),n(Me),n(je),n(f),n(ye),n(fe),n(Z),n(be),n(Ue),n(C),n(we),n(Je),n(Te),n(W),n($e),n(xe),n(V),n(ke),n(Ie),n(H),n(Ze),n(ve),n(Ce),n(E),n(Ge),n(Q),n(Be),n(We),n(_),n(ze),n(Ve),n(X),n(Se),n(He),n(Re),n(Y),n(qe),n(P),n(Ee),n(D),n(Qe),n(Ae),n(_e),n(ee),n(Ne),n(se),n(Xe),n(Le),n(le),n(Fe),n(Ye),n(Pe),n(re)),n(g),h(U,e),h(y,e),h(T,e),h(k,e),h(I,e),h(v,e),h(G,e),h(B,e),h(z,e),h(S,e),h(R,e),h(q,e),h(A,e),h(N,e),h(L,e),h(F,e),h(K,e),h(O,e),h(ne,e),h(te,e),h(ae,e)}}}const Gs='{"title":"Pipelines für Inferenzen","local":"pipelines-für-inferenzen","sections":[{"title":"Verwendung von Pipelines","local":"verwendung-von-pipelines","sections":[{"title":"Wählen Sie ein Modell und einen Tokenizer","local":"wählen-sie-ein-modell-und-einen-tokenizer","sections":[],"depth":3}],"depth":2},{"title":"Audio-Pipeline","local":"audio-pipeline","sections":[],"depth":2},{"title":"Bildverarbeitungs-Pipeline","local":"bildverarbeitungs-pipeline","sections":[],"depth":2},{"title":"Multimodale Pipeline","local":"multimodale-pipeline","sections":[],"depth":2}],"depth":1}';function Bs(oe){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends Ts{constructor(g){super(),$s(this,g,Bs,Cs,Us,{})}}export{Rs as component};
