import{s as lo,o as io,n as Ge}from"../chunks/scheduler.18a86fab.js";import{S as co,i as mo,g as i,s,r as h,A as po,h as c,f as a,c as r,j as x,x as u,u as g,k as B,l as uo,y as o,a as d,v as b,d as M,t as _,w as y}from"../chunks/index.98837b22.js";import{T as ro}from"../chunks/Tip.77304350.js";import{D as F}from"../chunks/Docstring.6758ea23.js";import{C as st}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ao}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ze}from"../chunks/Heading.7e7e0c5b.js";import{H as fo,a as ho}from"../chunks/HfOption.6641485e.js";import{E as go}from"../chunks/index.92f616ba.js";function bo($){let t,f="Click on the ColPali models in the right sidebar for more examples of how to use ColPali for image retrieval.";return{c(){t=i("p"),t.textContent=f},l(l){t=c(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-19qg7yk"&&(t.textContent=f)},m(l,p){d(l,t,p)},p:Ge,d(l){l&&a(t)}}}function Mo($){let t,f;return t=new st({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ColPaliForRetrieval, ColPaliProcessor

<span class="hljs-comment"># Load model (bfloat16 support is limited; fallback to float32 if needed)</span>
model = ColPaliForRetrieval.from_pretrained(
    <span class="hljs-string">&quot;vidore/colpali-v1.2-hf&quot;</span>,
    torch_dtype=torch.bfloat16 <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.float32,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># &quot;cpu&quot;, &quot;cuda&quot;, or &quot;mps&quot; for Apple Silicon</span>
).<span class="hljs-built_in">eval</span>()

processor = ColPaliProcessor.from_pretrained(model_name)

url1 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/89/US-original-Declaration-1776.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Romeoandjuliet1597.jpg/500px-Romeoandjuliet1597.jpg&quot;</span>

images = [
    Image.<span class="hljs-built_in">open</span>(requests.get(url1, stream=<span class="hljs-literal">True</span>).raw),
    Image.<span class="hljs-built_in">open</span>(requests.get(url2, stream=<span class="hljs-literal">True</span>).raw),
]

queries = [
    <span class="hljs-string">&quot;Who printed the edition of Romeo and Juliet?&quot;</span>,
    <span class="hljs-string">&quot;When was the United States Declaration of Independence proclaimed?&quot;</span>,
]

<span class="hljs-comment"># Process the inputs</span>
inputs_images = processor(images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
inputs_text = processor(text=queries, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Forward pass</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    image_embeddings = model(**inputs_images).embeddings
    query_embeddings = model(**inputs_text).embeddings

scores = processor.score_retrieval(query_embeddings, image_embeddings)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retrieval scores (query x image):&quot;</span>)
<span class="hljs-built_in">print</span>(scores)`,wrap:!1}}),{c(){h(t.$$.fragment)},l(l){g(t.$$.fragment,l)},m(l,p){b(t,l,p),f=!0},p:Ge,i(l){f||(M(t.$$.fragment,l),f=!0)},o(l){_(t.$$.fragment,l),f=!1},d(l){y(t,l)}}}function _o($){let t,f;return t=new ho({props:{id:"usage",option:"image retrieval",$$slots:{default:[Mo]},$$scope:{ctx:$}}}),{c(){h(t.$$.fragment)},l(l){g(t.$$.fragment,l)},m(l,p){b(t,l,p),f=!0},p(l,p){const T={};p&2&&(T.$$scope={dirty:p,ctx:l}),t.$set(T)},i(l){f||(M(t.$$.fragment,l),f=!0)},o(l){_(t.$$.fragment,l),f=!1},d(l){y(t,l)}}}function yo($){let t,f="Example:",l,p,T;return p=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuY29scGFsaSUyMGltcG9ydCUyMENvbFBhbGlDb25maWclMkMlMjBDb2xQYWxpRm9yUmV0cmlldmFsJTBBJTBBY29uZmlnJTIwJTNEJTIwQ29sUGFsaUNvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBDb2xQYWxpRm9yUmV0cmlldmFsKGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers.models.colpali <span class="hljs-keyword">import</span> ColPaliConfig, ColPaliForRetrieval

config = ColPaliConfig()
model = ColPaliForRetrieval(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=f,l=s(),h(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=f),l=r(m),g(p.$$.fragment,m)},m(m,P){d(m,t,P),d(m,l,P),b(p,m,P),T=!0},p:Ge,i(m){T||(M(p.$$.fragment,m),T=!0)},o(m){_(p.$$.fragment,m),T=!1},d(m){m&&(a(t),a(l)),y(p,m)}}}function To($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=i("p"),t.innerHTML=f},l(l){t=c(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(l,p){d(l,t,p)},p:Ge,d(l){l&&a(t)}}}function vo($){let t,f="Example:",l,p,T;return p=new st({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=i("p"),t.textContent=f,l=s(),h(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=f),l=r(m),g(p.$$.fragment,m)},m(m,P){d(m,t,P),d(m,l,P),b(p,m,P),T=!0},p:Ge,i(m){T||(M(p.$$.fragment,m),T=!0)},o(m){_(p.$$.fragment,m),T=!1},d(m){m&&(a(t),a(l)),y(p,m)}}}function wo($){let t,f,l,p,T,m='<div class="flex flex-wrap space-x-1"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/></div>',P,Q,Ve,X,Wt='<a href="https://huggingface.co/papers/2407.01449" rel="nofollow">ColPali</a> is a model designed to retrieve documents by analyzing their visual features. Unlike traditional systems that rely heavily on text extraction and OCR, ColPali treats each page as an image. It uses <a href="./paligemma">Paligemma-3B</a> to capture not only text, but also the layout, tables, charts, and other visual elements to create detailed embeddings. This offers a more comprehensive understanding of documents and enables more efficient and accurate retrieval.',Ee,Y,Rt='You can find all the original ColPali checkpoints under the <a href="https://huggingface.co/collections/vidore/hf-native-colvision-models-6755d68fc60a8553acaa96f7" rel="nofollow">ColPali</a> collection.',He,z,Le,G,qe,S,It='Quantization reduces the memory burden of large models by representing the weights in a lower precision. Refer to the <a href="../quantization/overview">Quantization</a> overview for more available quantization backends.',Ne,A,Ft='The example below uses <a href="../quantization/bitsandbytes.md">bitsandbytes</a> to quantize the weights to int4.',Qe,D,Xe,K,Ye,O,zt='<li><a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliProcessor.score_retrieval">score_retrieval()</a> returns a 2D tensor where the first dimension is the number of queries and the second dimension is the number of images. A higher score indicates more similarity between the query and image.</li>',Se,ee,Ae,w,te,rt,he,Gt=`Configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliForRetrieval">ColPaliForRetrieval</a>. It is used to instantiate an instance
of <code>ColPaliForRetrieval</code> according to the specified arguments, defining the model architecture following the methodology
from the “ColPali: Efficient Document Retrieval with Vision Language Models” paper.`,at,ge,Vt=`Creating a configuration with the default settings will result in a configuration where the VLM backbone is set to the
default PaliGemma configuration, i.e the one from <a href="https://huggingface.co/vidore/colpali-v1.2" rel="nofollow">vidore/colpali-v1.2</a>.`,lt,be,Et="The ColPali config is very similar to <code>PaligemmaConfig</code>, but with an extra attribute defining the embedding dimension.",it,Me,Ht=`Note that contrarily to what the class name suggests (actually the name refers to the ColPali <strong>methodology</strong>), you can
use a different VLM backbone model than PaliGemma by passing the corresponding VLM configuration to the class constructor.`,ct,_e,Lt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,dt,V,De,oe,Ke,v,ne,mt,ye,qt=`Constructs a ColPali processor which wraps a PaliGemmaProcessor and special methods to process images and queries, as
well as to compute the late-interaction retrieval score.`,pt,Te,Nt=`<a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliProcessor">ColPaliProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/paligemma#transformers.PaliGemmaProcessor">PaliGemmaProcessor</a>. See the <code>__call__()</code>
for more information.`,ut,E,se,ft,ve,Qt=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,ht,H,re,gt,we,Xt=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,bt,Z,ae,Mt,Je,Yt=`Prepare for the model one or several image(s). This method is a wrapper around the <code>__call__</code> method of the ColPaliProcessor’s
<code>ColPaliProcessor.__call__()</code>.`,_t,Ce,St='This method forwards the <code>images</code> and <code>kwargs</code> arguments to SiglipImageProcessor’s <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__"><strong>call</strong>()</a>.',yt,W,le,Tt,je,At=`Prepare for the model one or several texts. This method is a wrapper around the <code>__call__</code> method of the ColPaliProcessor’s
<code>ColPaliProcessor.__call__()</code>.`,vt,$e,Dt='This method forwards the <code>text</code> and <code>kwargs</code> arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>.',wt,R,ie,Jt,Pe,Kt=`Compute the late-interaction/MaxSim score (ColBERT-like) for the given multi-vector
query embeddings (<code>qs</code>) and passage embeddings (<code>ps</code>). For ColPali, a passage is the
image of a document page.`,Ct,Ue,Ot=`Because the embedding tensors are multi-vector and can thus have different shapes, they
should be fed as:
(1) a list of tensors, where the i-th tensor is of shape (sequence_length_i, embedding_dim)
(2) a single tensor of shape (n_passages, max_sequence_length, embedding_dim) -> usually
obtained by padding the list of tensors.`,Oe,ce,et,C,de,jt,ke,eo=`In our proposed ColPali approach, we leverage VLMs to construct efficient multi-vector embeddings directly
from document images (“screenshots”) for document retrieval. We train the model to maximize the similarity
between these document embeddings and the corresponding query embeddings, using the late interaction method
introduced in ColBERT.`,$t,xe,to=`Using ColPali removes the need for potentially complex and brittle layout recognition and OCR pipelines with a
single model that can take into account both the textual and visual content (layout, charts, etc.) of a document.`,Pt,Be,oo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ut,Ze,no=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,kt,U,me,xt,We,so='The <a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliForRetrieval">ColPaliForRetrieval</a> forward method, overrides the <code>__call__</code> special method.',Bt,L,Zt,q,tt,pe,ot,Fe,nt;return Q=new ze({props:{title:"ColPali",local:"colpali",headingTag:"h1"}}),z=new ro({props:{warning:!1,$$slots:{default:[bo]},$$scope:{ctx:$}}}),G=new fo({props:{id:"usage",options:["image retrieval"],$$slots:{default:[_o]},$$scope:{ctx:$}}}),D=new st({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ColPaliForRetrieval, ColPaliProcessor
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

<span class="hljs-comment"># 4-bit quantization configuration</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model_name = <span class="hljs-string">&quot;vidore/colpali-v1.2-hf&quot;</span>

<span class="hljs-comment"># Load model </span>
model = ColPaliForRetrieval.from_pretrained(
    model_name,
    quantization_config=bnb_config,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
).<span class="hljs-built_in">eval</span>()

processor = ColPaliProcessor.from_pretrained(model_name)

url1 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/89/US-original-Declaration-1776.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Romeoandjuliet1597.jpg/500px-Romeoandjuliet1597.jpg&quot;</span>

images = [
    Image.<span class="hljs-built_in">open</span>(requests.get(url1, stream=<span class="hljs-literal">True</span>).raw),
    Image.<span class="hljs-built_in">open</span>(requests.get(url2, stream=<span class="hljs-literal">True</span>).raw),
]

queries = [
    <span class="hljs-string">&quot;Who printed the edition of Romeo and Juliet?&quot;</span>,
    <span class="hljs-string">&quot;When was the United States Declaration of Independence proclaimed?&quot;</span>,
]

<span class="hljs-comment"># Process the inputs</span>
inputs_images = processor(images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
inputs_text = processor(text=queries, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Forward pass</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    image_embeddings = model(**inputs_images).embeddings
    query_embeddings = model(**inputs_text).embeddings

scores = processor.score_retrieval(query_embeddings, image_embeddings)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retrieval scores (query x image):&quot;</span>)
<span class="hljs-built_in">print</span>(scores)`,wrap:!1}}),K=new ze({props:{title:"Notes",local:"notes",headingTag:"h2"}}),ee=new ze({props:{title:"ColPaliConfig",local:"transformers.ColPaliConfig",headingTag:"h2"}}),te=new F({props:{name:"class transformers.ColPaliConfig",anchor:"transformers.ColPaliConfig",parameters:[{name:"vlm_config",val:" = None"},{name:"text_config",val:" = None"},{name:"embedding_dim",val:": int = 128"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliConfig.vlm_config",description:`<strong>vlm_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
Configuration of the VLM backbone model.`,name:"vlm_config"},{anchor:"transformers.ColPaliConfig.text_config",description:`<strong>text_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
Configuration of the text backbone model. Overrides the <code>text_config</code> attribute of the <code>vlm_config</code> if provided.`,name:"text_config"},{anchor:"transformers.ColPaliConfig.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimension of the multi-vector embeddings produced by the model.`,name:"embedding_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/configuration_colpali.py#L27"}}),V=new ao({props:{anchor:"transformers.ColPaliConfig.example",$$slots:{default:[yo]},$$scope:{ctx:$}}}),oe=new ze({props:{title:"ColPaliProcessor",local:"transformers.ColPaliProcessor",headingTag:"h2"}}),ne=new F({props:{name:"class transformers.ColPaliProcessor",anchor:"transformers.ColPaliProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.ColPaliProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.ColPaliProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L75"}}),se=new F({props:{name:"batch_decode",anchor:"transformers.ColPaliProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L259"}}),re=new F({props:{name:"decode",anchor:"transformers.ColPaliProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L266"}}),ae=new F({props:{name:"process_images",anchor:"transformers.ColPaliProcessor.process_images",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colpali.processing_colpali.ColPaliProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.process_images.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. In case of a NumPy array/PyTorch tensor, each image should be of shape (C, H, W), where C is a
number of channels, H and W are image height and width.`,name:"images"},{anchor:"transformers.ColPaliProcessor.process_images.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L288",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>images</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),le=new F({props:{name:"process_queries",anchor:"transformers.ColPaliProcessor.process_queries",parameters:[{name:"text",val:": typing.Union[str, typing.List[str]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colpali.processing_colpali.ColPaliProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.process_queries.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.ColPaliProcessor.process_queries.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L323",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),ie=new F({props:{name:"score_retrieval",anchor:"transformers.ColPaliProcessor.score_retrieval",parameters:[{name:"query_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"passage_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"batch_size",val:": int = 128"},{name:"output_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"output_device",val:": typing.Union[ForwardRef('torch.device'), str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.score_retrieval.query_embeddings",description:"<strong>query_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Query embeddings.",name:"query_embeddings"},{anchor:"transformers.ColPaliProcessor.score_retrieval.passage_embeddings",description:"<strong>passage_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Passage embeddings.",name:"passage_embeddings"},{anchor:"transformers.ColPaliProcessor.score_retrieval.batch_size",description:"<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; Batch size for computing scores.",name:"batch_size"},{anchor:"transformers.ColPaliProcessor.score_retrieval.output_dtype",description:`<strong>output_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014; The dtype of the output tensor.
If <code>None</code>, the dtype of the input embeddings is used.`,name:"output_dtype"},{anchor:"transformers.ColPaliProcessor.score_retrieval.output_device",description:"<strong>output_device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cpu&#x201D;) &#x2014; The device of the output tensor.",name:"output_device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L357",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape <code>(n_queries, n_passages)</code> containing the scores. The score
tensor is saved on the “cpu” device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),ce=new ze({props:{title:"ColPaliForRetrieval",local:"transformers.ColPaliForRetrieval",headingTag:"h2"}}),de=new F({props:{name:"class transformers.ColPaliForRetrieval",anchor:"transformers.ColPaliForRetrieval",parameters:[{name:"config",val:": ColPaliConfig"}],parametersDescription:[{anchor:"transformers.ColPaliForRetrieval.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliConfig">ColPaliConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/modeling_colpali.py#L99"}}),me=new F({props:{name:"forward",anchor:"transformers.ColPaliForRetrieval.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliForRetrieval.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ColPaliForRetrieval.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.ColPaliForRetrieval.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ColPaliForRetrieval.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ColPaliForRetrieval.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ColPaliForRetrieval.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/modeling_colpali.py#L129",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.colpali.modeling_colpali.ColPaliForRetrievalOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliConfig"
>ColPaliConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — The embeddings of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder after projecting last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.colpali.modeling_colpali.ColPaliForRetrievalOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new ro({props:{$$slots:{default:[To]},$$scope:{ctx:$}}}),q=new ao({props:{anchor:"transformers.ColPaliForRetrieval.forward.example",$$slots:{default:[vo]},$$scope:{ctx:$}}}),pe=new go({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/colpali.md"}}),{c(){t=i("meta"),f=s(),l=i("p"),p=s(),T=i("div"),T.innerHTML=m,P=s(),h(Q.$$.fragment),Ve=s(),X=i("p"),X.innerHTML=Wt,Ee=s(),Y=i("p"),Y.innerHTML=Rt,He=s(),h(z.$$.fragment),Le=s(),h(G.$$.fragment),qe=s(),S=i("p"),S.innerHTML=It,Ne=s(),A=i("p"),A.innerHTML=Ft,Qe=s(),h(D.$$.fragment),Xe=s(),h(K.$$.fragment),Ye=s(),O=i("ul"),O.innerHTML=zt,Se=s(),h(ee.$$.fragment),Ae=s(),w=i("div"),h(te.$$.fragment),rt=s(),he=i("p"),he.innerHTML=Gt,at=s(),ge=i("p"),ge.innerHTML=Vt,lt=s(),be=i("p"),be.innerHTML=Et,it=s(),Me=i("p"),Me.innerHTML=Ht,ct=s(),_e=i("p"),_e.innerHTML=Lt,dt=s(),h(V.$$.fragment),De=s(),h(oe.$$.fragment),Ke=s(),v=i("div"),h(ne.$$.fragment),mt=s(),ye=i("p"),ye.textContent=qt,pt=s(),Te=i("p"),Te.innerHTML=Nt,ut=s(),E=i("div"),h(se.$$.fragment),ft=s(),ve=i("p"),ve.innerHTML=Qt,ht=s(),H=i("div"),h(re.$$.fragment),gt=s(),we=i("p"),we.innerHTML=Xt,bt=s(),Z=i("div"),h(ae.$$.fragment),Mt=s(),Je=i("p"),Je.innerHTML=Yt,_t=s(),Ce=i("p"),Ce.innerHTML=St,yt=s(),W=i("div"),h(le.$$.fragment),Tt=s(),je=i("p"),je.innerHTML=At,vt=s(),$e=i("p"),$e.innerHTML=Dt,wt=s(),R=i("div"),h(ie.$$.fragment),Jt=s(),Pe=i("p"),Pe.innerHTML=Kt,Ct=s(),Ue=i("p"),Ue.textContent=Ot,Oe=s(),h(ce.$$.fragment),et=s(),C=i("div"),h(de.$$.fragment),jt=s(),ke=i("p"),ke.textContent=eo,$t=s(),xe=i("p"),xe.textContent=to,Pt=s(),Be=i("p"),Be.innerHTML=oo,Ut=s(),Ze=i("p"),Ze.innerHTML=no,kt=s(),U=i("div"),h(me.$$.fragment),xt=s(),We=i("p"),We.innerHTML=so,Bt=s(),h(L.$$.fragment),Zt=s(),h(q.$$.fragment),tt=s(),h(pe.$$.fragment),ot=s(),Fe=i("p"),this.h()},l(e){const n=po("svelte-u9bgzb",document.head);t=c(n,"META",{name:!0,content:!0}),n.forEach(a),f=r(e),l=c(e,"P",{}),x(l).forEach(a),p=r(e),T=c(e,"DIV",{style:!0,"data-svelte-h":!0}),u(T)!=="svelte-wa5t4p"&&(T.innerHTML=m),P=r(e),g(Q.$$.fragment,e),Ve=r(e),X=c(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1ouzqbs"&&(X.innerHTML=Wt),Ee=r(e),Y=c(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1s9akgr"&&(Y.innerHTML=Rt),He=r(e),g(z.$$.fragment,e),Le=r(e),g(G.$$.fragment,e),qe=r(e),S=c(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-nf5ooi"&&(S.innerHTML=It),Ne=r(e),A=c(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1u51sr7"&&(A.innerHTML=Ft),Qe=r(e),g(D.$$.fragment,e),Xe=r(e),g(K.$$.fragment,e),Ye=r(e),O=c(e,"UL",{"data-svelte-h":!0}),u(O)!=="svelte-1zb4tp"&&(O.innerHTML=zt),Se=r(e),g(ee.$$.fragment,e),Ae=r(e),w=c(e,"DIV",{class:!0});var j=x(w);g(te.$$.fragment,j),rt=r(j),he=c(j,"P",{"data-svelte-h":!0}),u(he)!=="svelte-bap4zu"&&(he.innerHTML=Gt),at=r(j),ge=c(j,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-1fyeyvm"&&(ge.innerHTML=Vt),lt=r(j),be=c(j,"P",{"data-svelte-h":!0}),u(be)!=="svelte-a9ftw5"&&(be.innerHTML=Et),it=r(j),Me=c(j,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-bnl7k3"&&(Me.innerHTML=Ht),ct=r(j),_e=c(j,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-o55m63"&&(_e.innerHTML=Lt),dt=r(j),g(V.$$.fragment,j),j.forEach(a),De=r(e),g(oe.$$.fragment,e),Ke=r(e),v=c(e,"DIV",{class:!0});var J=x(v);g(ne.$$.fragment,J),mt=r(J),ye=c(J,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1xjue1y"&&(ye.textContent=qt),pt=r(J),Te=c(J,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1gyme3e"&&(Te.innerHTML=Nt),ut=r(J),E=c(J,"DIV",{class:!0});var ue=x(E);g(se.$$.fragment,ue),ft=r(ue),ve=c(ue,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-4dbgxy"&&(ve.innerHTML=Qt),ue.forEach(a),ht=r(J),H=c(J,"DIV",{class:!0});var fe=x(H);g(re.$$.fragment,fe),gt=r(fe),we=c(fe,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1ha4zc4"&&(we.innerHTML=Xt),fe.forEach(a),bt=r(J),Z=c(J,"DIV",{class:!0});var I=x(Z);g(ae.$$.fragment,I),Mt=r(I),Je=c(I,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1gls1hp"&&(Je.innerHTML=Yt),_t=r(I),Ce=c(I,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-7k3dfz"&&(Ce.innerHTML=St),I.forEach(a),yt=r(J),W=c(J,"DIV",{class:!0});var Re=x(W);g(le.$$.fragment,Re),Tt=r(Re),je=c(Re,"P",{"data-svelte-h":!0}),u(je)!=="svelte-d7fz8o"&&(je.innerHTML=At),vt=r(Re),$e=c(Re,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1bjrmgh"&&($e.innerHTML=Dt),Re.forEach(a),wt=r(J),R=c(J,"DIV",{class:!0});var Ie=x(R);g(ie.$$.fragment,Ie),Jt=r(Ie),Pe=c(Ie,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-1728slr"&&(Pe.innerHTML=Kt),Ct=r(Ie),Ue=c(Ie,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-3nd4tx"&&(Ue.textContent=Ot),Ie.forEach(a),J.forEach(a),Oe=r(e),g(ce.$$.fragment,e),et=r(e),C=c(e,"DIV",{class:!0});var k=x(C);g(de.$$.fragment,k),jt=r(k),ke=c(k,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-kuaus5"&&(ke.textContent=eo),$t=r(k),xe=c(k,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-rxcp7f"&&(xe.textContent=to),Pt=r(k),Be=c(k,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-6pahdo"&&(Be.innerHTML=oo),Ut=r(k),Ze=c(k,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-hswkmf"&&(Ze.innerHTML=no),kt=r(k),U=c(k,"DIV",{class:!0});var N=x(U);g(me.$$.fragment,N),xt=r(N),We=c(N,"P",{"data-svelte-h":!0}),u(We)!=="svelte-1cncon1"&&(We.innerHTML=so),Bt=r(N),g(L.$$.fragment,N),Zt=r(N),g(q.$$.fragment,N),N.forEach(a),k.forEach(a),tt=r(e),g(pe.$$.fragment,e),ot=r(e),Fe=c(e,"P",{}),x(Fe).forEach(a),this.h()},h(){B(t,"name","hf:doc:metadata"),B(t,"content",Jo),uo(T,"float","right"),B(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){o(document.head,t),d(e,f,n),d(e,l,n),d(e,p,n),d(e,T,n),d(e,P,n),b(Q,e,n),d(e,Ve,n),d(e,X,n),d(e,Ee,n),d(e,Y,n),d(e,He,n),b(z,e,n),d(e,Le,n),b(G,e,n),d(e,qe,n),d(e,S,n),d(e,Ne,n),d(e,A,n),d(e,Qe,n),b(D,e,n),d(e,Xe,n),b(K,e,n),d(e,Ye,n),d(e,O,n),d(e,Se,n),b(ee,e,n),d(e,Ae,n),d(e,w,n),b(te,w,null),o(w,rt),o(w,he),o(w,at),o(w,ge),o(w,lt),o(w,be),o(w,it),o(w,Me),o(w,ct),o(w,_e),o(w,dt),b(V,w,null),d(e,De,n),b(oe,e,n),d(e,Ke,n),d(e,v,n),b(ne,v,null),o(v,mt),o(v,ye),o(v,pt),o(v,Te),o(v,ut),o(v,E),b(se,E,null),o(E,ft),o(E,ve),o(v,ht),o(v,H),b(re,H,null),o(H,gt),o(H,we),o(v,bt),o(v,Z),b(ae,Z,null),o(Z,Mt),o(Z,Je),o(Z,_t),o(Z,Ce),o(v,yt),o(v,W),b(le,W,null),o(W,Tt),o(W,je),o(W,vt),o(W,$e),o(v,wt),o(v,R),b(ie,R,null),o(R,Jt),o(R,Pe),o(R,Ct),o(R,Ue),d(e,Oe,n),b(ce,e,n),d(e,et,n),d(e,C,n),b(de,C,null),o(C,jt),o(C,ke),o(C,$t),o(C,xe),o(C,Pt),o(C,Be),o(C,Ut),o(C,Ze),o(C,kt),o(C,U),b(me,U,null),o(U,xt),o(U,We),o(U,Bt),b(L,U,null),o(U,Zt),b(q,U,null),d(e,tt,n),b(pe,e,n),d(e,ot,n),d(e,Fe,n),nt=!0},p(e,[n]){const j={};n&2&&(j.$$scope={dirty:n,ctx:e}),z.$set(j);const J={};n&2&&(J.$$scope={dirty:n,ctx:e}),G.$set(J);const ue={};n&2&&(ue.$$scope={dirty:n,ctx:e}),V.$set(ue);const fe={};n&2&&(fe.$$scope={dirty:n,ctx:e}),L.$set(fe);const I={};n&2&&(I.$$scope={dirty:n,ctx:e}),q.$set(I)},i(e){nt||(M(Q.$$.fragment,e),M(z.$$.fragment,e),M(G.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(V.$$.fragment,e),M(oe.$$.fragment,e),M(ne.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(ae.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(L.$$.fragment,e),M(q.$$.fragment,e),M(pe.$$.fragment,e),nt=!0)},o(e){_(Q.$$.fragment,e),_(z.$$.fragment,e),_(G.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(V.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(le.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(L.$$.fragment,e),_(q.$$.fragment,e),_(pe.$$.fragment,e),nt=!1},d(e){e&&(a(f),a(l),a(p),a(T),a(P),a(Ve),a(X),a(Ee),a(Y),a(He),a(Le),a(qe),a(S),a(Ne),a(A),a(Qe),a(Xe),a(Ye),a(O),a(Se),a(Ae),a(w),a(De),a(Ke),a(v),a(Oe),a(et),a(C),a(tt),a(ot),a(Fe)),a(t),y(Q,e),y(z,e),y(G,e),y(D,e),y(K,e),y(ee,e),y(te),y(V),y(oe,e),y(ne),y(se),y(re),y(ae),y(le),y(ie),y(ce,e),y(de),y(me),y(L),y(q),y(pe,e)}}}const Jo='{"title":"ColPali","local":"colpali","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"ColPaliConfig","local":"transformers.ColPaliConfig","sections":[],"depth":2},{"title":"ColPaliProcessor","local":"transformers.ColPaliProcessor","sections":[],"depth":2},{"title":"ColPaliForRetrieval","local":"transformers.ColPaliForRetrieval","sections":[],"depth":2}],"depth":1}';function Co($){return io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ro extends co{constructor(t){super(),mo(this,t,Co,wo,lo,{})}}export{Ro as component};
