import{s as Vs,z as Gs,o as Ss,n as wt}from"../chunks/scheduler.18a86fab.js";import{S as Xs,i as qs,g as r,s as n,r as m,A as Qs,h as i,f as o,c as a,j as C,u as h,x as p,k as v,y as l,a as s,v as g,d as f,t as u,w as _}from"../chunks/index.98837b22.js";import{T as Ls}from"../chunks/Tip.77304350.js";import{D as W}from"../chunks/Docstring.6758ea23.js";import{C as O}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Qo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as J}from"../chunks/Heading.7e7e0c5b.js";import{E as As}from"../chunks/index.92f616ba.js";function Ys(x){let d,M="Example:",y,b,w;return b=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Nb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBEZXB0aFBybyUyMGFwcGxlJTJGRGVwdGhQcm8lMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRGVwdGhQcm9Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwYXBwbGUlMkZEZXB0aFBybyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwRGVwdGhQcm9Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthPro apple/DepthPro style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthProConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the apple/DepthPro style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=r("p"),d.textContent=M,y=n(),m(b.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),p(d)!=="svelte-11lpom8"&&(d.textContent=M),y=a(c),h(b.$$.fragment,c)},m(c,T){s(c,d,T),s(c,y,T),g(b,c,T),w=!0},p:wt,i(c){w||(f(b.$$.fragment,c),w=!0)},o(c){u(b.$$.fragment,c),w=!1},d(c){c&&(o(d),o(y)),_(b,c)}}}function Os(x){let d,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=M},l(y){d=i(y,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fincs2"&&(d.innerHTML=M)},m(y,b){s(y,d,b)},p:wt,d(y){y&&o(d)}}}function Ks(x){let d,M="Examples:",y,b,w;return b=new O({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwRGVwdGhQcm9Nb2RlbCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGd3d3LmlsYW5rZWxtYW4ub3JnJTJGc3RvcHNpZ25zJTJGYXVzdHJhbGlhLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJhcHBsZSUyRkRlcHRoUHJvLWhmJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMERlcHRoUHJvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFvdXRwdXQubGFzdF9oaWRkZW5fc3RhdGUuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, DepthProModel

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProModel.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    output = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>output.last_hidden_state.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">35</span>, <span class="hljs-number">577</span>, <span class="hljs-number">1024</span>])`,wrap:!1}}),{c(){d=r("p"),d.textContent=M,y=n(),m(b.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),p(d)!=="svelte-kvfsh7"&&(d.textContent=M),y=a(c),h(b.$$.fragment,c)},m(c,T){s(c,d,T),s(c,y,T),g(b,c,T),w=!0},p:wt,i(c){w||(f(b.$$.fragment,c),w=!0)},o(c){u(b.$$.fragment,c),w=!1},d(c){c&&(o(d),o(y)),_(b,c)}}}function en(x){let d,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=M},l(y){d=i(y,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fincs2"&&(d.innerHTML=M)},m(y,b){s(y,d,b)},p:wt,d(y){y&&o(d)}}}function tn(x){let d,M="Examples:",y,b,w;return b=new O({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the field of view (fov) predictions</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>field_of_view = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;field_of_view&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>focal_length = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;focal_length&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){d=r("p"),d.textContent=M,y=n(),m(b.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),p(d)!=="svelte-kvfsh7"&&(d.textContent=M),y=a(c),h(b.$$.fragment,c)},m(c,T){s(c,d,T),s(c,y,T),g(b,c,T),w=!0},p:wt,i(c){w||(f(b.$$.fragment,c),w=!0)},o(c){u(b.$$.fragment,c),w=!1},d(c){c&&(o(d),o(y)),_(b,c)}}}function on(x){let d,M,y,b,w,c,T,Ao='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Tt,K,vt,ee,Yo='The DepthPro model was proposed in <a href="https://arxiv.org/abs/2410.02073" rel="nofollow">Depth Pro: Sharp Monocular Metric Depth in Less Than a Second</a> by Aleksei Bochkovskii, Amaël Delaunoy, Hugo Germain, Marcel Santos, Yichao Zhou, Stephan R. Richter, Vladlen Koltun.',Mt,te,Oo="DepthPro is a foundation model for zero-shot metric monocular depth estimation, designed to generate high-resolution depth maps with remarkable sharpness and fine-grained details. It employs a multi-scale Vision Transformer (ViT)-based architecture, where images are downsampled, divided into patches, and processed using a shared Dinov2 encoder. The extracted patch-level features are merged, upsampled, and refined using a DPT-like fusion stage, enabling precise depth estimation.",Pt,oe,Ko="The abstract from the paper is the following:",Dt,se,es="<em>We present a foundation model for zero-shot metric monocular depth estimation. Our model, Depth Pro, synthesizes high-resolution depth maps with unparalleled sharpness and high-frequency details. The predictions are metric, with absolute scale, without relying on the availability of metadata such as camera intrinsics. And the model is fast, producing a 2.25-megapixel depth map in 0.3 seconds on a standard GPU. These characteristics are enabled by a number of technical contributions, including an efficient multi-scale vision transformer for dense prediction, a training protocol that combines real and synthetic datasets to achieve high metric accuracy alongside fine boundary tracing, dedicated evaluation metrics for boundary accuracy in estimated depth maps, and state-of-the-art focal length estimation from a single image. Extensive experiments analyze specific design choices and demonstrate that Depth Pro outperforms prior work along multiple dimensions.</em>",$t,E,ts,It,ne,os='DepthPro Outputs. Taken from the <a href="https://github.com/apple/ml-depth-pro" target="_blank">official code</a>.',jt,ae,ss='This model was contributed by <a href="https://github.com/geetu040" rel="nofollow">geetu040</a>. The original code can be found <a href="https://github.com/apple/ml-depth-pro" rel="nofollow">here</a>.',Ut,re,Ct,ie,ns="The DepthPro model processes an input image by first downsampling it at multiple scales and splitting each scaled version into patches. These patches are then encoded using a shared Vision Transformer (ViT)-based Dinov2 patch encoder, while the full image is processed by a separate image encoder. The extracted patch features are merged into feature maps, upsampled, and fused using a DPT-like decoder to generate the final depth estimation. If enabled, an additional Field of View (FOV) encoder processes the image for estimating the camera’s field of view, aiding in depth accuracy.",xt,le,Rt,de,Ft,H,as,Jt,ce,rs='DepthPro architecture. Taken from the <a href="https://arxiv.org/abs/2410.02073" target="_blank">original paper</a>.',zt,pe,is="The <code>DepthProForDepthEstimation</code> model uses a <code>DepthProEncoder</code>, for encoding the input image and a <code>FeatureFusionStage</code> for fusing the output features from encoder.",Zt,me,ls="The <code>DepthProEncoder</code> further uses two encoders:",Wt,he,ds="<li><code>patch_encoder</code><ul><li>Input image is scaled with multiple ratios, as specified in the <code>scaled_images_ratios</code> configuration.</li> <li>Each scaled image is split into smaller <strong>patches</strong> of size <code>patch_size</code> with overlapping areas determined by <code>scaled_images_overlap_ratios</code>.</li> <li>These patches are processed by the <strong><code>patch_encoder</code></strong></li></ul></li> <li><code>image_encoder</code><ul><li>Input image is also rescaled to <code>patch_size</code> and processed by the <strong><code>image_encoder</code></strong></li></ul></li>",kt,ge,cs="Both these encoders can be configured via <code>patch_model_config</code> and <code>image_model_config</code> respectively, both of which are separate <code>Dinov2Model</code> by default.",Bt,fe,ps="Outputs from both encoders (<code>last_hidden_state</code>) and selected intermediate states (<code>hidden_states</code>) from <strong><code>patch_encoder</code></strong> are fused by a <code>DPT</code>-based <code>FeatureFusionStage</code> for depth estimation.",Et,ue,Ht,_e,ms="The network is supplemented with a focal length estimation head. A small convolutional head ingests frozen features from the depth estimation network and task-specific features from a separate ViT image encoder to predict the horizontal angular field-of-view.",Nt,ye,hs="The <code>use_fov_model</code> parameter in <code>DepthProConfig</code> controls whether <strong>FOV prediction</strong> is enabled. By default, it is set to <code>False</code> to conserve memory and computation. When enabled, the <strong>FOV encoder</strong> is instantiated based on the <code>fov_model_config</code> parameter, which defaults to a <code>Dinov2Model</code>. The <code>use_fov_model</code> parameter can also be passed when initializing the <code>DepthProForDepthEstimation</code> model.",Gt,be,gs="The pretrained model at checkpoint <code>apple/DepthPro-hf</code> uses the FOV encoder. To use the pretrained-model without FOV encoder, set <code>use_fov_model=False</code> when loading the model, which saves computation.",Lt,we,Vt,Te,fs="To instantiate a new model with FOV encoder, set <code>use_fov_model=True</code> in the config.",St,ve,Xt,Me,us="Or set <code>use_fov_model=True</code> when initializing the model, which overrides the value in config.",qt,Pe,Qt,De,At,$e,_s=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Yt,Ie,ys=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,Ot,je,Kt,Ue,bs="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",eo,Ce,ws="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>google/vit-base-patch16-224</code> model, we saw the following speedups during inference.",to,xe,Ts="<thead><tr><th>Batch size</th> <th>Average inference time (ms), eager mode</th> <th>Average inference time (ms), sdpa model</th> <th>Speed up, Sdpa / Eager (x)</th></tr></thead> <tbody><tr><td>1</td> <td>7</td> <td>6</td> <td>1.17</td></tr> <tr><td>2</td> <td>8</td> <td>6</td> <td>1.33</td></tr> <tr><td>4</td> <td>8</td> <td>6</td> <td>1.33</td></tr> <tr><td>8</td> <td>8</td> <td>6</td> <td>1.33</td></tr></tbody>",oo,Re,so,Fe,vs="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DepthPro:",no,Je,Ms='<li>Research Paper: <a href="https://arxiv.org/pdf/2410.02073" rel="nofollow">Depth Pro: Sharp Monocular Metric Depth in Less Than a Second</a></li> <li>Official Implementation: <a href="https://github.com/apple/ml-depth-pro" rel="nofollow">apple/ml-depth-pro</a></li> <li>DepthPro Inference Notebook: <a href="https://github.com/qubvel/transformers-notebooks/blob/main/notebooks/DepthPro_inference.ipynb" rel="nofollow">DepthPro Inference</a></li> <li>DepthPro for Super Resolution and Image Segmentation<ul><li>Read blog on Medium: <a href="https://medium.com/@raoarmaghanshakir040/depth-pro-beyond-depth-9d822fc557ba" rel="nofollow">Depth Pro: Beyond Depth</a></li> <li>Code on Github: <a href="https://github.com/geetu040/depthpro-beyond-depth" rel="nofollow">geetu040/depthpro-beyond-depth</a></li></ul></li>',ao,ze,Ps="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",ro,Ze,io,j,We,To,tt,Ds=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProModel">DepthProModel</a>. It is used to instantiate a
DepthPro model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the DepthPro
<a href="https://huggingface.co/apple/DepthPro" rel="nofollow">apple/DepthPro</a> architecture.`,vo,ot,$s=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mo,N,lo,ke,co,U,Be,Po,st,Is="Constructs a DepthPro image processor.",Do,G,Ee,$o,nt,js="Preprocess an image or batch of images.",Io,L,He,jo,at,Us=`Post-processes the raw depth predictions from the model to generate
final depth predictions which is caliberated using the field of view if provided
and resized to specified target sizes if provided.`,po,Ne,mo,P,Ge,Uo,rt,Cs="Constructs a fast Depth Pro image processor.",Co,it,xs=`data_format (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>):
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.
input_data_format (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>):
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:`,xo,lt,Rs=`<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li> <li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li> <li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.
device (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>):
The device to process the images on. If unset, the device is inferred from the input images.</li>`,Ro,dt,Le,Fo,V,Ve,Jo,ct,Fs=`Post-processes the raw depth predictions from the model to generate
final depth predictions which is caliberated using the field of view if provided
and resized to specified target sizes if provided.`,ho,Se,go,D,Xe,zo,pt,Js="The bare Depth Pro Model outputting raw hidden-states without any specific head on top.",Zo,mt,zs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wo,ht,Zs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ko,R,qe,Bo,gt,Ws='The <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProModel">DepthProModel</a> forward method, overrides the <code>__call__</code> special method.',Eo,S,Ho,X,fo,Qe,uo,$,Ae,No,ft,ks="DepthPro Model with a depth estimation head on top (consisting of 3 convolutional layers).",Go,ut,Bs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Lo,_t,Es=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Vo,F,Ye,So,yt,Hs='The <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProForDepthEstimation">DepthProForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',Xo,q,qo,Q,_o,Oe,yo,bt,bo;return w=new J({props:{title:"DepthPro",local:"depthpro",headingTag:"h1"}}),K=new J({props:{title:"Overview",local:"overview",headingTag:"h2"}}),re=new J({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h2"}}),le=new O({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBEZXB0aFByb0ltYWdlUHJvY2Vzc29yRmFzdCUyQyUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQXVybCUyMCUzRCUyMCdodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJyUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMERlcHRoUHJvSW1hZ2VQcm9jZXNzb3JGYXN0LmZyb21fcHJldHJhaW5lZCglMjJhcHBsZSUyRkRlcHRoUHJvLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmFwcGxlJTJGRGVwdGhQcm8taGYlMjIpLnRvKGRldmljZSklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFwb3N0X3Byb2Nlc3NlZF9vdXRwdXQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2RlcHRoX2VzdGltYXRpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRCU1QihpbWFnZS5oZWlnaHQlMkMlMjBpbWFnZS53aWR0aCklNUQlMkMlMEEpJTBBJTBBZmllbGRfb2ZfdmlldyUyMCUzRCUyMHBvc3RfcHJvY2Vzc2VkX291dHB1dCU1QjAlNUQlNUIlMjJmaWVsZF9vZl92aWV3JTIyJTVEJTBBZm9jYWxfbGVuZ3RoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMmZvY2FsX2xlbmd0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwKGRlcHRoJTIwLSUyMGRlcHRoLm1pbigpKSUyMCUyRiUyMGRlcHRoLm1heCgpJTBBZGVwdGglMjAlM0QlMjBkZXB0aCUyMColMjAyNTUuJTBBZGVwdGglMjAlM0QlMjBkZXB0aC5kZXRhY2goKS5jcHUoKS5udW1weSgpJTBBZGVwdGglMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoZGVwdGguYXN0eXBlKCUyMnVpbnQ4JTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProImageProcessorFast, DepthProForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = DepthProImageProcessorFast.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>field_of_view = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;field_of_view&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>focal_length = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;focal_length&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (depth - depth.<span class="hljs-built_in">min</span>()) / depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth * <span class="hljs-number">255.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),de=new J({props:{title:"Architecture and Configuration",local:"architecture-and-configuration",headingTag:"h3"}}),ue=new J({props:{title:"Field-of-View (FOV) Prediction",local:"field-of-view-fov-prediction",headingTag:"h3"}}),we=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXBwbGUlMkZEZXB0aFByby1oZiUyMiUyQyUyMHVzZV9mb3ZfbW9kZWwlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>, use_fov_model=<span class="hljs-literal">False</span>)`,wrap:!1}}),ve=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24lMEFjb25maWclMjAlM0QlMjBEZXB0aFByb0NvbmZpZyh1c2VfZm92X21vZGVsJTNEVHJ1ZSklMEFtb2RlbCUyMCUzRCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>config = DepthProConfig(use_fov_model=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation(config)`,wrap:!1}}),Pe=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24lMEFjb25maWclMjAlM0QlMjBEZXB0aFByb0NvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbihjb25maWclMkMlMjB1c2VfZm92X21vZGVsJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>config = DepthProConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation(config, use_fov_model=<span class="hljs-literal">True</span>)`,wrap:!1}}),De=new J({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),je=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXBwbGUlMkZEZXB0aFByby1oZiUyMiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJzZHBhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProForDepthEstimation
model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>, attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),Re=new J({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ze=new J({props:{title:"DepthProConfig",local:"transformers.DepthProConfig",headingTag:"h2"}}),We=new W({props:{name:"class transformers.DepthProConfig",anchor:"transformers.DepthProConfig",parameters:[{name:"fusion_hidden_size",val:" = 256"},{name:"patch_size",val:" = 384"},{name:"initializer_range",val:" = 0.02"},{name:"intermediate_hook_ids",val:" = [11, 5]"},{name:"intermediate_feature_dims",val:" = [256, 256]"},{name:"scaled_images_ratios",val:" = [0.25, 0.5, 1]"},{name:"scaled_images_overlap_ratios",val:" = [0.0, 0.5, 0.25]"},{name:"scaled_images_feature_dims",val:" = [1024, 1024, 512]"},{name:"merge_padding_value",val:" = 3"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_bias_in_fusion_residual",val:" = True"},{name:"use_fov_model",val:" = False"},{name:"num_fov_head_layers",val:" = 2"},{name:"image_model_config",val:" = None"},{name:"patch_model_config",val:" = None"},{name:"fov_model_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthProConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthProConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The size (resolution) of each patch. This is also the image_size for backbone model.`,name:"patch_size"},{anchor:"transformers.DepthProConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthProConfig.intermediate_hook_ids",description:`<strong>intermediate_hook_ids</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[11, 5]</code>) &#x2014;
Indices of the intermediate hidden states from the patch encoder to use for fusion.`,name:"intermediate_hook_ids"},{anchor:"transformers.DepthProConfig.intermediate_feature_dims",description:`<strong>intermediate_feature_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 256]</code>) &#x2014;
Hidden state dimensions during upsampling for each intermediate hidden state in <code>intermediate_hook_ids</code>.`,name:"intermediate_feature_dims"},{anchor:"transformers.DepthProConfig.scaled_images_ratios",description:`<strong>scaled_images_ratios</strong> (<code>List[float]</code>, <em>optional</em>, defaults to <code>[0.25, 0.5, 1]</code>) &#x2014;
Ratios of scaled images to be used by the patch encoder.`,name:"scaled_images_ratios"},{anchor:"transformers.DepthProConfig.scaled_images_overlap_ratios",description:`<strong>scaled_images_overlap_ratios</strong> (<code>List[float]</code>, <em>optional</em>, defaults to <code>[0.0, 0.5, 0.25]</code>) &#x2014;
Overlap ratios between patches for each scaled image in <code>scaled_images_ratios</code>.`,name:"scaled_images_overlap_ratios"},{anchor:"transformers.DepthProConfig.scaled_images_feature_dims",description:`<strong>scaled_images_feature_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1024, 1024, 512]</code>) &#x2014;
Hidden state dimensions during upsampling for each scaled image in <code>scaled_images_ratios</code>.`,name:"scaled_images_feature_dims"},{anchor:"transformers.DepthProConfig.merge_padding_value",description:`<strong>merge_padding_value</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
When merging smaller patches back to the image size, overlapping sections of this size are removed.`,name:"merge_padding_value"},{anchor:"transformers.DepthProConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.DepthProConfig.use_bias_in_fusion_residual",description:`<strong>use_bias_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the pre-activate residual units of the fusion blocks.`,name:"use_bias_in_fusion_residual"},{anchor:"transformers.DepthProConfig.use_fov_model",description:`<strong>use_fov_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use <code>DepthProFovModel</code> to generate the field of view.`,name:"use_fov_model"},{anchor:"transformers.DepthProConfig.num_fov_head_layers",description:`<strong>num_fov_head_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of convolution layers in the head of <code>DepthProFovModel</code>.`,name:"num_fov_head_layers"},{anchor:"transformers.DepthProConfig.image_model_config",description:`<strong>image_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the image encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"image_model_config"},{anchor:"transformers.DepthProConfig.patch_model_config",description:`<strong>patch_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the patch encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"patch_model_config"},{anchor:"transformers.DepthProConfig.fov_model_config",description:`<strong>fov_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the fov encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"fov_model_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/configuration_depth_pro.py#L27"}}),N=new Qo({props:{anchor:"transformers.DepthProConfig.example",$$slots:{default:[Ys]},$$scope:{ctx:x}}}),ke=new J({props:{title:"DepthProImageProcessor",local:"transformers.DepthProImageProcessor",headingTag:"h2"}}),Be=new W({props:{name:"class transformers.DepthProImageProcessor",anchor:"transformers.DepthProImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 1536, &quot;width&quot;: 1536}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.DepthProImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.DepthProImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L55"}}),Ee=new W({props:{name:"preprocess",anchor:"transformers.DepthProImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": typing.Optional[PIL.Image.Resampling] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> specifying the size of the output image after
resizing.`,name:"size"},{anchor:"transformers.DepthProImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PILImageResampling</code> filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DepthProImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DepthProImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L191"}}),He=new W({props:{name:"post_process_depth_estimation",anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation",parameters:[{name:"outputs",val:": DepthProDepthEstimatorOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation.outputs",description:`<strong>outputs</strong> (<code>DepthProDepthEstimatorOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation.target_sizes",description:`<strong>target_sizes</strong> (<code>Optional[Union[TensorType, List[Tuple[int, int]], None]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target sizes to resize the depth predictions. Can be a tensor of shape <code>(batch_size, 2)</code>
or a list of tuples <code>(height, width)</code> for each image in the batch. If <code>None</code>, no resizing
is performed.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L317",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries of tensors representing the processed depth
predictions, and field of view (degrees) and focal length (pixels) if <code>field_of_view</code> is given in <code>outputs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict[str, TensorType]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the lengths of <code>predicted_depths</code>, <code>fovs</code>, or <code>target_sizes</code> are mismatched.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ne=new J({props:{title:"DepthProImageProcessorFast",local:"transformers.DepthProImageProcessorFast",headingTag:"h2"}}),Ge=new W({props:{name:"class transformers.DepthProImageProcessorFast",anchor:"transformers.DepthProImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 1536, &apos;width&apos;: 1536}</code>):
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.DepthProImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.DepthProImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DepthProImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.DepthProImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.DepthProImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.DepthProImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.DepthProImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.DepthProImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.DepthProImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.DepthProImageProcessorFast.Returns",description:"<strong>Returns</strong> stacked tensors if set to `pt, otherwise returns a list of tensors. &#x2014;",name:"Returns"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro_fast.py#L62"}}),Le=new W({props:{name:"preprocess",anchor:"transformers.DepthProImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"*args",val:""},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, list[&apos;PIL.Image.Image&apos;], list[numpy.ndarray], list[&apos;torch.Tensor&apos;]]</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils_fast.py#L571",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),Ve=new W({props:{name:"post_process_depth_estimation",anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation",parameters:[{name:"outputs",val:": DepthProDepthEstimatorOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation.outputs",description:`<strong>outputs</strong> (<code>DepthProDepthEstimatorOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation.target_sizes",description:`<strong>target_sizes</strong> (<code>Optional[Union[TensorType, List[Tuple[int, int]], None]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target sizes to resize the depth predictions. Can be a tensor of shape <code>(batch_size, 2)</code>
or a list of tuples <code>(height, width)</code> for each image in the batch. If <code>None</code>, no resizing
is performed.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro_fast.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries of tensors representing the processed depth
predictions, and field of view (degrees) and focal length (pixels) if <code>field_of_view</code> is given in <code>outputs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict[str, TensorType]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the lengths of <code>predicted_depths</code>, <code>fovs</code>, or <code>target_sizes</code> are mismatched.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Se=new J({props:{title:"DepthProModel",local:"transformers.DepthProModel",headingTag:"h2"}}),Xe=new W({props:{name:"class transformers.DepthProModel",anchor:"transformers.DepthProModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthProModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProModel">DepthProModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L655"}}),qe=new W({props:{name:"forward",anchor:"transformers.DepthProModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthProModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.DepthProModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DepthProModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthProModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthProModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L668",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.depth_pro.modeling_depth_pro.DepthProOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig"
>DepthProConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, n_patches_per_batch, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>features</strong> (<code>Union[torch.FloatTensor, List[torch.FloatTensor]]</code>, <em>optional</em>) — Features from encoders. Can be a single feature or a list of features.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, n_patches_per_batch, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer and the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, n_patches_per_batch, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.depth_pro.modeling_depth_pro.DepthProOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new Ls({props:{$$slots:{default:[Os]},$$scope:{ctx:x}}}),X=new Qo({props:{anchor:"transformers.DepthProModel.forward.example",$$slots:{default:[Ks]},$$scope:{ctx:x}}}),Qe=new J({props:{title:"DepthProForDepthEstimation",local:"transformers.DepthProForDepthEstimation",headingTag:"h2"}}),Ae=new W({props:{name:"class transformers.DepthProForDepthEstimation",anchor:"transformers.DepthProForDepthEstimation",parameters:[{name:"config",val:""},{name:"use_fov_model",val:" = None"}],parametersDescription:[{anchor:"transformers.DepthProForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProForDepthEstimation">DepthProForDepthEstimation</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.DepthProForDepthEstimation.use_fov_model",description:`<strong>use_fov_model</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the field of view model.`,name:"use_fov_model"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L1024"}}),Ye=new W({props:{name:"forward",anchor:"transformers.DepthProForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthProForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.DepthProForDepthEstimation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DepthProForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"},{anchor:"transformers.DepthProForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthProForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthProForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L1054",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.depth_pro.modeling_depth_pro.DepthProDepthEstimatorOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig"
>DepthProConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>field_of_view</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>, returned when <code>use_fov_model</code> is provided) — Field of View Scaler.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, n_patches_per_batch, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer and the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, n_patches_per_batch, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.depth_pro.modeling_depth_pro.DepthProDepthEstimatorOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new Ls({props:{$$slots:{default:[en]},$$scope:{ctx:x}}}),Q=new Qo({props:{anchor:"transformers.DepthProForDepthEstimation.forward.example",$$slots:{default:[tn]},$$scope:{ctx:x}}}),Oe=new As({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_pro.md"}}),{c(){d=r("meta"),M=n(),y=r("p"),b=n(),m(w.$$.fragment),c=n(),T=r("div"),T.innerHTML=Ao,Tt=n(),m(K.$$.fragment),vt=n(),ee=r("p"),ee.innerHTML=Yo,Mt=n(),te=r("p"),te.textContent=Oo,Pt=n(),oe=r("p"),oe.textContent=Ko,Dt=n(),se=r("p"),se.innerHTML=es,$t=n(),E=r("img"),It=n(),ne=r("small"),ne.innerHTML=os,jt=n(),ae=r("p"),ae.innerHTML=ss,Ut=n(),m(re.$$.fragment),Ct=n(),ie=r("p"),ie.textContent=ns,xt=n(),m(le.$$.fragment),Rt=n(),m(de.$$.fragment),Ft=n(),H=r("img"),Jt=n(),ce=r("small"),ce.innerHTML=rs,zt=n(),pe=r("p"),pe.innerHTML=is,Zt=n(),me=r("p"),me.innerHTML=ls,Wt=n(),he=r("ul"),he.innerHTML=ds,kt=n(),ge=r("p"),ge.innerHTML=cs,Bt=n(),fe=r("p"),fe.innerHTML=ps,Et=n(),m(ue.$$.fragment),Ht=n(),_e=r("p"),_e.textContent=ms,Nt=n(),ye=r("p"),ye.innerHTML=hs,Gt=n(),be=r("p"),be.innerHTML=gs,Lt=n(),m(we.$$.fragment),Vt=n(),Te=r("p"),Te.innerHTML=fs,St=n(),m(ve.$$.fragment),Xt=n(),Me=r("p"),Me.innerHTML=us,qt=n(),m(Pe.$$.fragment),Qt=n(),m(De.$$.fragment),At=n(),$e=r("p"),$e.innerHTML=_s,Yt=n(),Ie=r("p"),Ie.innerHTML=ys,Ot=n(),m(je.$$.fragment),Kt=n(),Ue=r("p"),Ue.innerHTML=bs,eo=n(),Ce=r("p"),Ce.innerHTML=ws,to=n(),xe=r("table"),xe.innerHTML=Ts,oo=n(),m(Re.$$.fragment),so=n(),Fe=r("p"),Fe.textContent=vs,no=n(),Je=r("ul"),Je.innerHTML=Ms,ao=n(),ze=r("p"),ze.textContent=Ps,ro=n(),m(Ze.$$.fragment),io=n(),j=r("div"),m(We.$$.fragment),To=n(),tt=r("p"),tt.innerHTML=Ds,vo=n(),ot=r("p"),ot.innerHTML=$s,Mo=n(),m(N.$$.fragment),lo=n(),m(ke.$$.fragment),co=n(),U=r("div"),m(Be.$$.fragment),Po=n(),st=r("p"),st.textContent=Is,Do=n(),G=r("div"),m(Ee.$$.fragment),$o=n(),nt=r("p"),nt.textContent=js,Io=n(),L=r("div"),m(He.$$.fragment),jo=n(),at=r("p"),at.textContent=Us,po=n(),m(Ne.$$.fragment),mo=n(),P=r("div"),m(Ge.$$.fragment),Uo=n(),rt=r("p"),rt.textContent=Cs,Co=n(),it=r("p"),it.innerHTML=xs,xo=n(),lt=r("ul"),lt.innerHTML=Rs,Ro=n(),dt=r("div"),m(Le.$$.fragment),Fo=n(),V=r("div"),m(Ve.$$.fragment),Jo=n(),ct=r("p"),ct.textContent=Fs,ho=n(),m(Se.$$.fragment),go=n(),D=r("div"),m(Xe.$$.fragment),zo=n(),pt=r("p"),pt.textContent=Js,Zo=n(),mt=r("p"),mt.innerHTML=zs,Wo=n(),ht=r("p"),ht.innerHTML=Zs,ko=n(),R=r("div"),m(qe.$$.fragment),Bo=n(),gt=r("p"),gt.innerHTML=Ws,Eo=n(),m(S.$$.fragment),Ho=n(),m(X.$$.fragment),fo=n(),m(Qe.$$.fragment),uo=n(),$=r("div"),m(Ae.$$.fragment),No=n(),ft=r("p"),ft.textContent=ks,Go=n(),ut=r("p"),ut.innerHTML=Bs,Lo=n(),_t=r("p"),_t.innerHTML=Es,Vo=n(),F=r("div"),m(Ye.$$.fragment),So=n(),yt=r("p"),yt.innerHTML=Hs,Xo=n(),m(q.$$.fragment),qo=n(),m(Q.$$.fragment),_o=n(),m(Oe.$$.fragment),yo=n(),bt=r("p"),this.h()},l(e){const t=Qs("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(o),M=a(e),y=i(e,"P",{}),C(y).forEach(o),b=a(e),h(w.$$.fragment,e),c=a(e),T=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-13t8s2t"&&(T.innerHTML=Ao),Tt=a(e),h(K.$$.fragment,e),vt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-17nz7v2"&&(ee.innerHTML=Yo),Mt=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-iw0dw2"&&(te.textContent=Oo),Pt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-vfdo9a"&&(oe.textContent=Ko),Dt=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1nlf61n"&&(se.innerHTML=es),$t=a(e),E=i(e,"IMG",{src:!0,alt:!0,width:!0}),It=a(e),ne=i(e,"SMALL",{"data-svelte-h":!0}),p(ne)!=="svelte-v29z6c"&&(ne.innerHTML=os),jt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-l2shq"&&(ae.innerHTML=ss),Ut=a(e),h(re.$$.fragment,e),Ct=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-186igip"&&(ie.textContent=ns),xt=a(e),h(le.$$.fragment,e),Rt=a(e),h(de.$$.fragment,e),Ft=a(e),H=i(e,"IMG",{src:!0,alt:!0,width:!0}),Jt=a(e),ce=i(e,"SMALL",{"data-svelte-h":!0}),p(ce)!=="svelte-1ru2d7g"&&(ce.innerHTML=rs),zt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-tuav9r"&&(pe.innerHTML=is),Zt=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1j3kmo3"&&(me.innerHTML=ls),Wt=a(e),he=i(e,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-z5afbx"&&(he.innerHTML=ds),kt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-2yjsdx"&&(ge.innerHTML=cs),Bt=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-52bz7i"&&(fe.innerHTML=ps),Et=a(e),h(ue.$$.fragment,e),Ht=a(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1ndzez1"&&(_e.textContent=ms),Nt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-g9cm15"&&(ye.innerHTML=hs),Gt=a(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-a9hyvq"&&(be.innerHTML=gs),Lt=a(e),h(we.$$.fragment,e),Vt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1npevgz"&&(Te.innerHTML=fs),St=a(e),h(ve.$$.fragment,e),Xt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1becr2q"&&(Me.innerHTML=us),qt=a(e),h(Pe.$$.fragment,e),Qt=a(e),h(De.$$.fragment,e),At=a(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1cid2pe"&&($e.innerHTML=_s),Yt=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1x11lxg"&&(Ie.innerHTML=ys),Ot=a(e),h(je.$$.fragment,e),Kt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-djb2w0"&&(Ue.innerHTML=bs),eo=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-18g4o0h"&&(Ce.innerHTML=ws),to=a(e),xe=i(e,"TABLE",{"data-svelte-h":!0}),p(xe)!=="svelte-vyu660"&&(xe.innerHTML=Ts),oo=a(e),h(Re.$$.fragment,e),so=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1ub7hfb"&&(Fe.textContent=vs),no=a(e),Je=i(e,"UL",{"data-svelte-h":!0}),p(Je)!=="svelte-yhgtws"&&(Je.innerHTML=Ms),ao=a(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1xesile"&&(ze.textContent=Ps),ro=a(e),h(Ze.$$.fragment,e),io=a(e),j=i(e,"DIV",{class:!0});var z=C(j);h(We.$$.fragment,z),To=a(z),tt=i(z,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-160h4tq"&&(tt.innerHTML=Ds),vo=a(z),ot=i(z,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-o55m63"&&(ot.innerHTML=$s),Mo=a(z),h(N.$$.fragment,z),z.forEach(o),lo=a(e),h(ke.$$.fragment,e),co=a(e),U=i(e,"DIV",{class:!0});var Z=C(U);h(Be.$$.fragment,Z),Po=a(Z),st=i(Z,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1s0ef1w"&&(st.textContent=Is),Do=a(Z),G=i(Z,"DIV",{class:!0});var Ke=C(G);h(Ee.$$.fragment,Ke),$o=a(Ke),nt=i(Ke,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1x3yxsa"&&(nt.textContent=js),Ke.forEach(o),Io=a(Z),L=i(Z,"DIV",{class:!0});var et=C(L);h(He.$$.fragment,et),jo=a(et),at=i(et,"P",{"data-svelte-h":!0}),p(at)!=="svelte-nc01ic"&&(at.textContent=Us),et.forEach(o),Z.forEach(o),po=a(e),h(Ne.$$.fragment,e),mo=a(e),P=i(e,"DIV",{class:!0});var I=C(P);h(Ge.$$.fragment,I),Uo=a(I),rt=i(I,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-319q28"&&(rt.textContent=Cs),Co=a(I),it=i(I,"P",{"data-svelte-h":!0}),p(it)!=="svelte-7883m0"&&(it.innerHTML=xs),xo=a(I),lt=i(I,"UL",{"data-svelte-h":!0}),p(lt)!=="svelte-1qslv4f"&&(lt.innerHTML=Rs),Ro=a(I),dt=i(I,"DIV",{class:!0});var Ns=C(dt);h(Le.$$.fragment,Ns),Ns.forEach(o),Fo=a(I),V=i(I,"DIV",{class:!0});var wo=C(V);h(Ve.$$.fragment,wo),Jo=a(wo),ct=i(wo,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-nc01ic"&&(ct.textContent=Fs),wo.forEach(o),I.forEach(o),ho=a(e),h(Se.$$.fragment,e),go=a(e),D=i(e,"DIV",{class:!0});var k=C(D);h(Xe.$$.fragment,k),zo=a(k),pt=i(k,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-65t3so"&&(pt.textContent=Js),Zo=a(k),mt=i(k,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-6pahdo"&&(mt.innerHTML=zs),Wo=a(k),ht=i(k,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-hswkmf"&&(ht.innerHTML=Zs),ko=a(k),R=i(k,"DIV",{class:!0});var A=C(R);h(qe.$$.fragment,A),Bo=a(A),gt=i(A,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-y3si4a"&&(gt.innerHTML=Ws),Eo=a(A),h(S.$$.fragment,A),Ho=a(A),h(X.$$.fragment,A),A.forEach(o),k.forEach(o),fo=a(e),h(Qe.$$.fragment,e),uo=a(e),$=i(e,"DIV",{class:!0});var B=C($);h(Ae.$$.fragment,B),No=a(B),ft=i(B,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1nk4p0z"&&(ft.textContent=ks),Go=a(B),ut=i(B,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-6pahdo"&&(ut.innerHTML=Bs),Lo=a(B),_t=i(B,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-hswkmf"&&(_t.innerHTML=Es),Vo=a(B),F=i(B,"DIV",{class:!0});var Y=C(F);h(Ye.$$.fragment,Y),So=a(Y),yt=i(Y,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1n6bje0"&&(yt.innerHTML=Hs),Xo=a(Y),h(q.$$.fragment,Y),qo=a(Y),h(Q.$$.fragment,Y),Y.forEach(o),B.forEach(o),_o=a(e),h(Oe.$$.fragment,e),yo=a(e),bt=i(e,"P",{}),C(bt).forEach(o),this.h()},h(){v(d,"name","hf:doc:metadata"),v(d,"content",sn),v(T,"class","flex flex-wrap space-x-1"),Gs(E.src,ts="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_pro_teaser.png")||v(E,"src",ts),v(E,"alt","drawing"),v(E,"width","600"),Gs(H.src,as="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_pro_architecture.png")||v(H,"src",as),v(H,"alt","drawing"),v(H,"width","600"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,d),s(e,M,t),s(e,y,t),s(e,b,t),g(w,e,t),s(e,c,t),s(e,T,t),s(e,Tt,t),g(K,e,t),s(e,vt,t),s(e,ee,t),s(e,Mt,t),s(e,te,t),s(e,Pt,t),s(e,oe,t),s(e,Dt,t),s(e,se,t),s(e,$t,t),s(e,E,t),s(e,It,t),s(e,ne,t),s(e,jt,t),s(e,ae,t),s(e,Ut,t),g(re,e,t),s(e,Ct,t),s(e,ie,t),s(e,xt,t),g(le,e,t),s(e,Rt,t),g(de,e,t),s(e,Ft,t),s(e,H,t),s(e,Jt,t),s(e,ce,t),s(e,zt,t),s(e,pe,t),s(e,Zt,t),s(e,me,t),s(e,Wt,t),s(e,he,t),s(e,kt,t),s(e,ge,t),s(e,Bt,t),s(e,fe,t),s(e,Et,t),g(ue,e,t),s(e,Ht,t),s(e,_e,t),s(e,Nt,t),s(e,ye,t),s(e,Gt,t),s(e,be,t),s(e,Lt,t),g(we,e,t),s(e,Vt,t),s(e,Te,t),s(e,St,t),g(ve,e,t),s(e,Xt,t),s(e,Me,t),s(e,qt,t),g(Pe,e,t),s(e,Qt,t),g(De,e,t),s(e,At,t),s(e,$e,t),s(e,Yt,t),s(e,Ie,t),s(e,Ot,t),g(je,e,t),s(e,Kt,t),s(e,Ue,t),s(e,eo,t),s(e,Ce,t),s(e,to,t),s(e,xe,t),s(e,oo,t),g(Re,e,t),s(e,so,t),s(e,Fe,t),s(e,no,t),s(e,Je,t),s(e,ao,t),s(e,ze,t),s(e,ro,t),g(Ze,e,t),s(e,io,t),s(e,j,t),g(We,j,null),l(j,To),l(j,tt),l(j,vo),l(j,ot),l(j,Mo),g(N,j,null),s(e,lo,t),g(ke,e,t),s(e,co,t),s(e,U,t),g(Be,U,null),l(U,Po),l(U,st),l(U,Do),l(U,G),g(Ee,G,null),l(G,$o),l(G,nt),l(U,Io),l(U,L),g(He,L,null),l(L,jo),l(L,at),s(e,po,t),g(Ne,e,t),s(e,mo,t),s(e,P,t),g(Ge,P,null),l(P,Uo),l(P,rt),l(P,Co),l(P,it),l(P,xo),l(P,lt),l(P,Ro),l(P,dt),g(Le,dt,null),l(P,Fo),l(P,V),g(Ve,V,null),l(V,Jo),l(V,ct),s(e,ho,t),g(Se,e,t),s(e,go,t),s(e,D,t),g(Xe,D,null),l(D,zo),l(D,pt),l(D,Zo),l(D,mt),l(D,Wo),l(D,ht),l(D,ko),l(D,R),g(qe,R,null),l(R,Bo),l(R,gt),l(R,Eo),g(S,R,null),l(R,Ho),g(X,R,null),s(e,fo,t),g(Qe,e,t),s(e,uo,t),s(e,$,t),g(Ae,$,null),l($,No),l($,ft),l($,Go),l($,ut),l($,Lo),l($,_t),l($,Vo),l($,F),g(Ye,F,null),l(F,So),l(F,yt),l(F,Xo),g(q,F,null),l(F,qo),g(Q,F,null),s(e,_o,t),g(Oe,e,t),s(e,yo,t),s(e,bt,t),bo=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),N.$set(z);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),S.$set(Z);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),X.$set(Ke);const et={};t&2&&(et.$$scope={dirty:t,ctx:e}),q.$set(et);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),Q.$set(I)},i(e){bo||(f(w.$$.fragment,e),f(K.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(ue.$$.fragment,e),f(we.$$.fragment,e),f(ve.$$.fragment,e),f(Pe.$$.fragment,e),f(De.$$.fragment,e),f(je.$$.fragment,e),f(Re.$$.fragment,e),f(Ze.$$.fragment,e),f(We.$$.fragment,e),f(N.$$.fragment,e),f(ke.$$.fragment,e),f(Be.$$.fragment,e),f(Ee.$$.fragment,e),f(He.$$.fragment,e),f(Ne.$$.fragment,e),f(Ge.$$.fragment,e),f(Le.$$.fragment,e),f(Ve.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(qe.$$.fragment,e),f(S.$$.fragment,e),f(X.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(Ye.$$.fragment,e),f(q.$$.fragment,e),f(Q.$$.fragment,e),f(Oe.$$.fragment,e),bo=!0)},o(e){u(w.$$.fragment,e),u(K.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(we.$$.fragment,e),u(ve.$$.fragment,e),u(Pe.$$.fragment,e),u(De.$$.fragment,e),u(je.$$.fragment,e),u(Re.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(N.$$.fragment,e),u(ke.$$.fragment,e),u(Be.$$.fragment,e),u(Ee.$$.fragment,e),u(He.$$.fragment,e),u(Ne.$$.fragment,e),u(Ge.$$.fragment,e),u(Le.$$.fragment,e),u(Ve.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(qe.$$.fragment,e),u(S.$$.fragment,e),u(X.$$.fragment,e),u(Qe.$$.fragment,e),u(Ae.$$.fragment,e),u(Ye.$$.fragment,e),u(q.$$.fragment,e),u(Q.$$.fragment,e),u(Oe.$$.fragment,e),bo=!1},d(e){e&&(o(M),o(y),o(b),o(c),o(T),o(Tt),o(vt),o(ee),o(Mt),o(te),o(Pt),o(oe),o(Dt),o(se),o($t),o(E),o(It),o(ne),o(jt),o(ae),o(Ut),o(Ct),o(ie),o(xt),o(Rt),o(Ft),o(H),o(Jt),o(ce),o(zt),o(pe),o(Zt),o(me),o(Wt),o(he),o(kt),o(ge),o(Bt),o(fe),o(Et),o(Ht),o(_e),o(Nt),o(ye),o(Gt),o(be),o(Lt),o(Vt),o(Te),o(St),o(Xt),o(Me),o(qt),o(Qt),o(At),o($e),o(Yt),o(Ie),o(Ot),o(Kt),o(Ue),o(eo),o(Ce),o(to),o(xe),o(oo),o(so),o(Fe),o(no),o(Je),o(ao),o(ze),o(ro),o(io),o(j),o(lo),o(co),o(U),o(po),o(mo),o(P),o(ho),o(go),o(D),o(fo),o(uo),o($),o(_o),o(yo),o(bt)),o(d),_(w,e),_(K,e),_(re,e),_(le,e),_(de,e),_(ue,e),_(we,e),_(ve,e),_(Pe,e),_(De,e),_(je,e),_(Re,e),_(Ze,e),_(We),_(N),_(ke,e),_(Be),_(Ee),_(He),_(Ne,e),_(Ge),_(Le),_(Ve),_(Se,e),_(Xe),_(qe),_(S),_(X),_(Qe,e),_(Ae),_(Ye),_(q),_(Q),_(Oe,e)}}}const sn='{"title":"DepthPro","local":"depthpro","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Tips","local":"usage-tips","sections":[{"title":"Architecture and Configuration","local":"architecture-and-configuration","sections":[],"depth":3},{"title":"Field-of-View (FOV) Prediction","local":"field-of-view-fov-prediction","sections":[],"depth":3},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthProConfig","local":"transformers.DepthProConfig","sections":[],"depth":2},{"title":"DepthProImageProcessor","local":"transformers.DepthProImageProcessor","sections":[],"depth":2},{"title":"DepthProImageProcessorFast","local":"transformers.DepthProImageProcessorFast","sections":[],"depth":2},{"title":"DepthProModel","local":"transformers.DepthProModel","sections":[],"depth":2},{"title":"DepthProForDepthEstimation","local":"transformers.DepthProForDepthEstimation","sections":[],"depth":2}],"depth":1}';function nn(x){return Ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends Xs{constructor(d){super(),qs(this,d,nn,on,Vs,{})}}export{gn as component};
