import{s as en,z as tn,o as on,n as Ze}from"../chunks/scheduler.18a86fab.js";import{S as nn,i as sn,g as d,s as n,r as h,A as an,h as c,f as o,c as s,j as M,u as f,x as T,k as $,y as i,a as l,v as g,d as u,t as _,w as b}from"../chunks/index.98837b22.js";import{T as $o}from"../chunks/Tip.77304350.js";import{D as z}from"../chunks/Docstring.6758ea23.js";import{C as ct}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Zt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Z}from"../chunks/Heading.7e7e0c5b.js";import{E as rn}from"../chunks/index.92f616ba.js";function ln(P){let a,v="Example:",m,p,y;return p=new ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERQVE1vZGVsJTJDJTIwRFBUQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERQVCUyMGRwdC1sYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEUFRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBkcHQtbGFyZ2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMERQVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTModel, DPTConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DPT dpt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the dpt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=d("p"),a.textContent=v,m=n(),h(p.$$.fragment)},l(r){a=c(r,"P",{"data-svelte-h":!0}),T(a)!=="svelte-11lpom8"&&(a.textContent=v),m=s(r),f(p.$$.fragment,r)},m(r,w){l(r,a,w),l(r,m,w),g(p,r,w),y=!0},p:Ze,i(r){y||(u(p.$$.fragment,r),y=!0)},o(r){_(p.$$.fragment,r),y=!1},d(r){r&&(o(a),o(m)),b(p,r)}}}function dn(P){let a,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=d("p"),a.innerHTML=v},l(m){a=c(m,"P",{"data-svelte-h":!0}),T(a)!=="svelte-fincs2"&&(a.innerHTML=v)},m(m,p){l(m,a,p)},p:Ze,d(m){m&&o(a)}}}function cn(P){let a,v="Example:",m,p,y;return p=new ct({props:{code:"",highlighted:"",wrap:!1}}),{c(){a=d("p"),a.textContent=v,m=n(),h(p.$$.fragment)},l(r){a=c(r,"P",{"data-svelte-h":!0}),T(a)!=="svelte-11lpom8"&&(a.textContent=v),m=s(r),f(p.$$.fragment,r)},m(r,w){l(r,a,w),l(r,m,w),g(p,r,w),y=!0},p:Ze,i(r){y||(u(p.$$.fragment,r),y=!0)},o(r){_(p.$$.fragment,r),y=!1},d(r){r&&(o(a),o(m)),b(p,r)}}}function mn(P){let a,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=d("p"),a.innerHTML=v},l(m){a=c(m,"P",{"data-svelte-h":!0}),T(a)!=="svelte-fincs2"&&(a.innerHTML=v)},m(m,p){l(m,a,p)},p:Ze,d(m){m&&o(a)}}}function pn(P){let a,v="Examples:",m,p,y;return p=new ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMERQVEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySW50ZWwlMkZkcHQtbGFyZ2UlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXBvc3RfcHJvY2Vzc2VkX291dHB1dCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZGVwdGhfZXN0aW1hdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcHJlZGljdGVkX2RlcHRoJTIwKiUyMDI1NSUyMCUyRiUyMHByZWRpY3RlZF9kZXB0aC5tYXgoKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){a=d("p"),a.textContent=v,m=n(),h(p.$$.fragment)},l(r){a=c(r,"P",{"data-svelte-h":!0}),T(a)!=="svelte-kvfsh7"&&(a.textContent=v),m=s(r),f(p.$$.fragment,r)},m(r,w){l(r,a,w),l(r,m,w),g(p,r,w),y=!0},p:Ze,i(r){y||(u(p.$$.fragment,r),y=!0)},o(r){_(p.$$.fragment,r),y=!1},d(r){r&&(o(a),o(m)),b(p,r)}}}function hn(P){let a,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=d("p"),a.innerHTML=v},l(m){a=c(m,"P",{"data-svelte-h":!0}),T(a)!=="svelte-fincs2"&&(a.innerHTML=v)},m(m,p){l(m,a,p)},p:Ze,d(m){m&&o(a)}}}function fn(P){let a,v="Examples:",m,p,y;return p=new ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZS1hZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBEUFRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySW50ZWwlMkZkcHQtbGFyZ2UtYWRlJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){a=d("p"),a.textContent=v,m=n(),h(p.$$.fragment)},l(r){a=c(r,"P",{"data-svelte-h":!0}),T(a)!=="svelte-kvfsh7"&&(a.textContent=v),m=s(r),f(p.$$.fragment,r)},m(r,w){l(r,a,w),l(r,m,w),g(p,r,w),y=!0},p:Ze,i(r){y||(u(p.$$.fragment,r),y=!0)},o(r){_(p.$$.fragment,r),y=!1},d(r){r&&(o(a),o(m)),b(p,r)}}}function gn(P){let a,v,m,p,y,r,w,Po='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',mt,se,pt,ae,Mo=`The DPT model was proposed in <a href="https://arxiv.org/abs/2103.13413" rel="nofollow">Vision Transformers for Dense Prediction</a> by René Ranftl, Alexey Bochkovskiy, Vladlen Koltun.
DPT is a model that leverages the <a href="vit">Vision Transformer (ViT)</a> as backbone for dense prediction tasks like semantic segmentation and depth estimation.`,ht,re,Do="The abstract from the paper is the following:",ft,ie,xo="<em>We introduce dense vision transformers, an architecture that leverages vision transformers in place of convolutional networks as a backbone for dense prediction tasks. We assemble tokens from various stages of the vision transformer into image-like representations at various resolutions and progressively combine them into full-resolution predictions using a convolutional decoder. The transformer backbone processes representations at a constant and relatively high resolution and has a global receptive field at every stage. These properties allow the dense vision transformer to provide finer-grained and more globally coherent predictions when compared to fully-convolutional networks. Our experiments show that this architecture yields substantial improvements on dense prediction tasks, especially when a large amount of training data is available. For monocular depth estimation, we observe an improvement of up to 28% in relative performance when compared to a state-of-the-art fully-convolutional network. When applied to semantic segmentation, dense vision transformers set a new state of the art on ADE20K with 49.02% mIoU. We further show that the architecture can be fine-tuned on smaller datasets such as NYUv2, KITTI, and Pascal Context where it also sets the new state of the art.</em>",gt,L,ko,ut,le,Co='DPT architecture. Taken from the <a href="https://arxiv.org/abs/2103.13413" target="_blank">original paper</a>.',_t,de,zo='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/isl-org/DPT" rel="nofollow">here</a>.',bt,ce,Tt,me,Io='DPT is compatible with the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> class. This allows to use the DPT framework with various computer vision backbones available in the library, such as <code>VitDetBackbone</code> or <code>Dinov2Backbone</code>. One can create it as follows:',yt,pe,vt,he,wt,fe,Uo="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DPT.",$t,ge,Fo='<li><p>Demo notebooks for <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/DPT" rel="nofollow">here</a>.</p></li> <li><p><a href="../tasks/semantic_segmentation">Semantic segmentation task guide</a></p></li> <li><p><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></p></li>',Pt,ue,jo="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Mt,_e,Dt,D,be,Bt,Be,Jo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTModel">DPTModel</a>. It is used to instantiate an DPT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DPT
<a href="https://huggingface.co/Intel/dpt-large" rel="nofollow">Intel/dpt-large</a> architecture.`,Lt,Le,Wo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ht,H,Vt,V,Te,Gt,He,Eo=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,xt,ye,kt,W,ve,qt,Ve,we,Yt,G,$e,At,Ge,Ro='Converts the output of <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Ct,Pe,zt,I,Me,Xt,qe,So="Constructs a DPT image processor.",Qt,q,De,Ot,Ye,No="Preprocess an image or batch of images.",Kt,Y,xe,eo,Ae,Zo='Converts the output of <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',It,ke,Ut,x,Ce,to,Xe,Bo="The bare Dpt Model outputting raw hidden-states without any specific head on top.",oo,Qe,Lo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,no,Oe,Ho=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,so,F,ze,ao,Ke,Vo='The <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> forward method, overrides the <code>__call__</code> special method.',ro,A,io,X,Ft,Ie,jt,k,Ue,lo,et,Go="DPT Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",co,tt,qo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,mo,ot,Yo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,po,j,Fe,ho,nt,Ao='The <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',fo,Q,go,O,Jt,je,Wt,C,Je,uo,st,Xo="The Dpt Model with a semantic segmentation head on top e.g. for ADE20K, CityScapes.",_o,at,Qo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bo,rt,Oo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,To,J,We,yo,it,Ko='The <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> forward method, overrides the <code>__call__</code> special method.',vo,K,wo,ee,Et,Ee,Rt,lt,St;return y=new Z({props:{title:"DPT",local:"dpt",headingTag:"h1"}}),se=new Z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ce=new Z({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),pe=new ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERpbm92MkNvbmZpZyUyQyUyMERQVENvbmZpZyUyQyUyMERQVEZvckRlcHRoRXN0aW1hdGlvbiUwQSUwQSUyMyUyMGluaXRpYWxpemUlMjB3aXRoJTIwYSUyMFRyYW5zZm9ybWVyLWJhc2VkJTIwYmFja2JvbmUlMjBzdWNoJTIwYXMlMjBESU5PdjIlMEElMjMlMjBpbiUyMHRoYXQlMjBjYXNlJTJDJTIwd2UlMjBhbHNvJTIwc3BlY2lmeSUyMCU2MHJlc2hhcGVfaGlkZGVuX3N0YXRlcyUzREZhbHNlJTYwJTIwdG8lMjBnZXQlMjBmZWF0dXJlJTIwbWFwcyUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9jaGFubmVscyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSUwQWJhY2tib25lX2NvbmZpZyUyMCUzRCUyMERpbm92MkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkaW5vdjItYmFzZSUyMiUyQyUyMG91dF9mZWF0dXJlcyUzRCU1QiUyMnN0YWdlMSUyMiUyQyUyMCUyMnN0YWdlMiUyMiUyQyUyMCUyMnN0YWdlMyUyMiUyQyUyMCUyMnN0YWdlNCUyMiU1RCUyQyUyMHJlc2hhcGVfaGlkZGVuX3N0YXRlcyUzREZhbHNlKSUwQSUwQWNvbmZpZyUyMCUzRCUyMERQVENvbmZpZyhiYWNrYm9uZV9jb25maWclM0RiYWNrYm9uZV9jb25maWcpJTBBbW9kZWwlMjAlM0QlMjBEUFRGb3JEZXB0aEVzdGltYXRpb24oY29uZmlnJTNEY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Dinov2Config, DPTConfig, DPTForDepthEstimation

<span class="hljs-comment"># initialize with a Transformer-based backbone such as DINOv2</span>
<span class="hljs-comment"># in that case, we also specify \`reshape_hidden_states=False\` to get feature maps of shape (batch_size, num_channels, height, width)</span>
backbone_config = Dinov2Config.from_pretrained(<span class="hljs-string">&quot;facebook/dinov2-base&quot;</span>, out_features=[<span class="hljs-string">&quot;stage1&quot;</span>, <span class="hljs-string">&quot;stage2&quot;</span>, <span class="hljs-string">&quot;stage3&quot;</span>, <span class="hljs-string">&quot;stage4&quot;</span>], reshape_hidden_states=<span class="hljs-literal">False</span>)

config = DPTConfig(backbone_config=backbone_config)
model = DPTForDepthEstimation(config=config)`,wrap:!1}}),he=new Z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new Z({props:{title:"DPTConfig",local:"transformers.DPTConfig",headingTag:"h2"}}),be=new z({props:{name:"class transformers.DPTConfig",anchor:"transformers.DPTConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 384"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"is_hybrid",val:" = False"},{name:"qkv_bias",val:" = True"},{name:"backbone_out_indices",val:" = [2, 5, 8, 11]"},{name:"readout_type",val:" = 'project'"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [96, 192, 384, 768]"},{name:"fusion_hidden_size",val:" = 256"},{name:"head_in_index",val:" = -1"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_bias_in_fusion_residual",val:" = None"},{name:"add_projection",val:" = False"},{name:"use_auxiliary_head",val:" = True"},{name:"auxiliary_loss_weight",val:" = 0.4"},{name:"semantic_loss_ignore_index",val:" = 255"},{name:"semantic_classifier_dropout",val:" = 0.1"},{name:"backbone_featmap_shape",val:" = [1, 1024, 24, 24]"},{name:"neck_ignore_stages",val:" = [0, 1]"},{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"pooler_output_size",val:" = None"},{name:"pooler_act",val:" = 'tanh'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.DPTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.DPTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.DPTConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.DPTConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.DPTConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.DPTConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.DPTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DPTConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.DPTConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.DPTConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.DPTConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DPTConfig.is_hybrid",description:`<strong>is_hybrid</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a hybrid backbone. Useful in the context of loading DPT-Hybrid models.`,name:"is_hybrid"},{anchor:"transformers.DPTConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.DPTConfig.backbone_out_indices",description:`<strong>backbone_out_indices</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 5, 8, 11]</code>) &#x2014;
Indices of the intermediate hidden states to use from backbone.`,name:"backbone_out_indices"},{anchor:"transformers.DPTConfig.readout_type",description:`<strong>readout_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;project&quot;</code>) &#x2014;
The readout type to use when processing the readout token (CLS token) of the intermediate hidden states of
the ViT backbone. Can be one of [<code>&quot;ignore&quot;</code>, <code>&quot;add&quot;</code>, <code>&quot;project&quot;</code>].</p>
<ul>
<li>&#x201C;ignore&#x201D; simply ignores the CLS token.</li>
<li>&#x201C;add&#x201D; passes the information from the CLS token to all other tokens by adding the representations.</li>
<li>&#x201C;project&#x201D; passes information to the other tokens by concatenating the readout to all other tokens before
projecting the
representation to the original feature dimension D using a linear layer followed by a GELU non-linearity.</li>
</ul>`,name:"readout_type"},{anchor:"transformers.DPTConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DPTConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[96, 192, 384, 768]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DPTConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DPTConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the heads.`,name:"head_in_index"},{anchor:"transformers.DPTConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.DPTConfig.use_bias_in_fusion_residual",description:`<strong>use_bias_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the pre-activate residual units of the fusion blocks.`,name:"use_bias_in_fusion_residual"},{anchor:"transformers.DPTConfig.add_projection",description:`<strong>add_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a projection layer before the depth estimation head.`,name:"add_projection"},{anchor:"transformers.DPTConfig.use_auxiliary_head",description:`<strong>use_auxiliary_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use an auxiliary head during training.`,name:"use_auxiliary_head"},{anchor:"transformers.DPTConfig.auxiliary_loss_weight",description:`<strong>auxiliary_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Weight of the cross-entropy loss of the auxiliary head.`,name:"auxiliary_loss_weight"},{anchor:"transformers.DPTConfig.semantic_loss_ignore_index",description:`<strong>semantic_loss_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
The index that is ignored by the loss function of the semantic segmentation model.`,name:"semantic_loss_ignore_index"},{anchor:"transformers.DPTConfig.semantic_classifier_dropout",description:`<strong>semantic_classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the semantic classification head.`,name:"semantic_classifier_dropout"},{anchor:"transformers.DPTConfig.backbone_featmap_shape",description:`<strong>backbone_featmap_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 1024, 24, 24]</code>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The shape of the feature maps of the backbone.`,name:"backbone_featmap_shape"},{anchor:"transformers.DPTConfig.neck_ignore_stages",description:`<strong>neck_ignore_stages</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[0, 1]</code>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The stages of the readout layers to ignore.`,name:"neck_ignore_stages"},{anchor:"transformers.DPTConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>is_hybrid</code> is <code>True</code> or in case you want to
leverage the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> API.`,name:"backbone_config"},{anchor:"transformers.DPTConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DPTConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DPTConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.DPTConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DPTConfig.pooler_output_size",description:`<strong>pooler_output_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimensionality of the pooler layer. If None, defaults to <code>hidden_size</code>.`,name:"pooler_output_size"},{anchor:"transformers.DPTConfig.pooler_act",description:`<strong>pooler_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;tanh&quot;</code>) &#x2014;
The activation function to be used by the pooler. Keys of ACT2FN are supported for Flax and
Pytorch, and elements of <a href="https://www.tensorflow.org/api_docs/python/tf/keras/activations" rel="nofollow">https://www.tensorflow.org/api_docs/python/tf/keras/activations</a> are
supported for Tensorflow.`,name:"pooler_act"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/configuration_dpt.py#L29"}}),H=new Zt({props:{anchor:"transformers.DPTConfig.example",$$slots:{default:[ln]},$$scope:{ctx:P}}}),Te=new z({props:{name:"to_dict",anchor:"transformers.DPTConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/configuration_dpt.py#L282"}}),ye=new Z({props:{title:"DPTFeatureExtractor",local:"transformers.DPTFeatureExtractor",headingTag:"h2"}}),ve=new z({props:{name:"class transformers.DPTFeatureExtractor",anchor:"transformers.DPTFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/feature_extraction_dpt.py#L27"}}),we=new z({props:{name:"__call__",anchor:"transformers.DPTFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/image_processing_dpt.py#L432"}}),$e=new z({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/image_processing_dpt.py#L595",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),Pe=new Z({props:{title:"DPTImageProcessor",local:"transformers.DPTImageProcessor",headingTag:"h2"}}),Me=new z({props:{name:"class transformers.DPTImageProcessor",anchor:"transformers.DPTImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"keep_aspect_ratio",val:": bool = False"},{name:"ensure_multiple_of",val:": int = 1"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": bool = False"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions. Can be overridden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.DPTImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 384}</code>):
Size of the image after resizing. Can be overridden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.DPTImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.DPTImageProcessor.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the image is resized to the largest possible size such that the aspect ratio is preserved. Can
be overridden by <code>keep_aspect_ratio</code> in <code>preprocess</code>.`,name:"keep_aspect_ratio"},{anchor:"transformers.DPTImageProcessor.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
If <code>do_resize</code> is <code>True</code>, the image is resized to a size that is a multiple of this value. Can be overridden
by <code>ensure_multiple_of</code> in <code>preprocess</code>.`,name:"ensure_multiple_of"},{anchor:"transformers.DPTImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
<code>preprocess</code>.`,name:"do_rescale"},{anchor:"transformers.DPTImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in <code>preprocess</code>.`,name:"rescale_factor"},{anchor:"transformers.DPTImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.DPTImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DPTImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DPTImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply center padding. This was introduced in the DINOv2 paper, which uses the model in
combination with DPT.`,name:"do_pad"},{anchor:"transformers.DPTImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If <code>do_pad</code> is <code>True</code>, pads the image dimensions to be divisible by this value. This was introduced in the
DINOv2 paper, which uses the model in combination with DPT.`,name:"size_divisor"},{anchor:"transformers.DPTImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0 is
used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k). The
background label will be replaced by 255. Can be overridden by the <code>do_reduce_labels</code> parameter in the
<code>preprocess</code> method.`,name:"do_reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/image_processing_dpt.py#L107"}}),De=new z({props:{name:"preprocess",anchor:"transformers.DPTImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[int] = None"},{name:"keep_aspect_ratio",val:": typing.Optional[bool] = None"},{name:"ensure_multiple_of",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DPTImageProcessor.preprocess.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
Segmentation map to preprocess.`,name:"segmentation_maps"},{anchor:"transformers.DPTImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DPTImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after reszing. If <code>keep_aspect_ratio</code> is <code>True</code>, the image is resized to the largest
possible size such that the aspect ratio is preserved. If <code>ensure_multiple_of</code> is set, the image is
resized to a size that is a multiple of this value.`,name:"size"},{anchor:"transformers.DPTImageProcessor.preprocess.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.keep_aspect_ratio</code>) &#x2014;
Whether to keep the aspect ratio of the image. If False, the image will be resized to (size, size). If
True, the image will be resized to keep the aspect ratio and the size will be the maximum possible.`,name:"keep_aspect_ratio"},{anchor:"transformers.DPTImageProcessor.preprocess.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.ensure_multiple_of</code>) &#x2014;
Ensure that the image size is a multiple of this value.`,name:"ensure_multiple_of"},{anchor:"transformers.DPTImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DPTImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.DPTImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DPTImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DPTImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.DPTImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.DPTImageProcessor.preprocess.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_reduce_labels</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g.
ADE20k). The background label will be replaced by 255.`,name:"do_reduce_labels"},{anchor:"transformers.DPTImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DPTImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DPTImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/image_processing_dpt.py#L437"}}),xe=new z({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/image_processing_dpt.py#L595",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),ke=new Z({props:{title:"DPTModel",local:"transformers.DPTModel",headingTag:"h2"}}),Ce=new z({props:{name:"class transformers.DPTModel",anchor:"transformers.DPTModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.DPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTModel">DPTModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.DPTModel.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a pooling layer`,name:"add_pooling_layer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/modeling_dpt.py#L846"}}),ze=new z({props:{name:"forward",anchor:"transformers.DPTModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.DPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/modeling_dpt.py#L883",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.dpt.modeling_dpt.BaseModelOutputWithPoolingAndIntermediateActivations</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>intermediate_activations</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Intermediate activations that can be used to compute hidden states of the model at various layers.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.dpt.modeling_dpt.BaseModelOutputWithPoolingAndIntermediateActivations</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new $o({props:{$$slots:{default:[dn]},$$scope:{ctx:P}}}),X=new Zt({props:{anchor:"transformers.DPTModel.forward.example",$$slots:{default:[cn]},$$scope:{ctx:P}}}),Ie=new Z({props:{title:"DPTForDepthEstimation",local:"transformers.DPTForDepthEstimation",headingTag:"h2"}}),Ue=new z({props:{name:"class transformers.DPTForDepthEstimation",anchor:"transformers.DPTForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DPTForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/modeling_dpt.py#L1044"}}),Fe=new z({props:{name:"forward",anchor:"transformers.DPTForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.DPTForDepthEstimation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"},{anchor:"transformers.DPTForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/modeling_dpt.py#L1068",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new $o({props:{$$slots:{default:[mn]},$$scope:{ctx:P}}}),O=new Zt({props:{anchor:"transformers.DPTForDepthEstimation.forward.example",$$slots:{default:[pn]},$$scope:{ctx:P}}}),je=new Z({props:{title:"DPTForSemanticSegmentation",local:"transformers.DPTForSemanticSegmentation",headingTag:"h2"}}),Je=new z({props:{name:"class transformers.DPTForSemanticSegmentation",anchor:"transformers.DPTForSemanticSegmentation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DPTForSemanticSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/modeling_dpt.py#L1224"}}),We=new z({props:{name:"forward",anchor:"transformers.DPTForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.DPTForSemanticSegmentation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTForSemanticSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth semantic segmentation maps for computing the loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code>, a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.DPTForSemanticSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTForSemanticSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTForSemanticSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dpt/modeling_dpt.py#L1241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) — Classification scores for each pixel.</p>
<Tip warning={true}>
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>
</Tip>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new $o({props:{$$slots:{default:[hn]},$$scope:{ctx:P}}}),ee=new Zt({props:{anchor:"transformers.DPTForSemanticSegmentation.forward.example",$$slots:{default:[fn]},$$scope:{ctx:P}}}),Ee=new rn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/dpt.md"}}),{c(){a=d("meta"),v=n(),m=d("p"),p=n(),h(y.$$.fragment),r=n(),w=d("div"),w.innerHTML=Po,mt=n(),h(se.$$.fragment),pt=n(),ae=d("p"),ae.innerHTML=Mo,ht=n(),re=d("p"),re.textContent=Do,ft=n(),ie=d("p"),ie.innerHTML=xo,gt=n(),L=d("img"),ut=n(),le=d("small"),le.innerHTML=Co,_t=n(),de=d("p"),de.innerHTML=zo,bt=n(),h(ce.$$.fragment),Tt=n(),me=d("p"),me.innerHTML=Io,yt=n(),h(pe.$$.fragment),vt=n(),h(he.$$.fragment),wt=n(),fe=d("p"),fe.textContent=Uo,$t=n(),ge=d("ul"),ge.innerHTML=Fo,Pt=n(),ue=d("p"),ue.textContent=jo,Mt=n(),h(_e.$$.fragment),Dt=n(),D=d("div"),h(be.$$.fragment),Bt=n(),Be=d("p"),Be.innerHTML=Jo,Lt=n(),Le=d("p"),Le.innerHTML=Wo,Ht=n(),h(H.$$.fragment),Vt=n(),V=d("div"),h(Te.$$.fragment),Gt=n(),He=d("p"),He.innerHTML=Eo,xt=n(),h(ye.$$.fragment),kt=n(),W=d("div"),h(ve.$$.fragment),qt=n(),Ve=d("div"),h(we.$$.fragment),Yt=n(),G=d("div"),h($e.$$.fragment),At=n(),Ge=d("p"),Ge.innerHTML=Ro,Ct=n(),h(Pe.$$.fragment),zt=n(),I=d("div"),h(Me.$$.fragment),Xt=n(),qe=d("p"),qe.textContent=So,Qt=n(),q=d("div"),h(De.$$.fragment),Ot=n(),Ye=d("p"),Ye.textContent=No,Kt=n(),Y=d("div"),h(xe.$$.fragment),eo=n(),Ae=d("p"),Ae.innerHTML=Zo,It=n(),h(ke.$$.fragment),Ut=n(),x=d("div"),h(Ce.$$.fragment),to=n(),Xe=d("p"),Xe.textContent=Bo,oo=n(),Qe=d("p"),Qe.innerHTML=Lo,no=n(),Oe=d("p"),Oe.innerHTML=Ho,so=n(),F=d("div"),h(ze.$$.fragment),ao=n(),Ke=d("p"),Ke.innerHTML=Vo,ro=n(),h(A.$$.fragment),io=n(),h(X.$$.fragment),Ft=n(),h(Ie.$$.fragment),jt=n(),k=d("div"),h(Ue.$$.fragment),lo=n(),et=d("p"),et.textContent=Go,co=n(),tt=d("p"),tt.innerHTML=qo,mo=n(),ot=d("p"),ot.innerHTML=Yo,po=n(),j=d("div"),h(Fe.$$.fragment),ho=n(),nt=d("p"),nt.innerHTML=Ao,fo=n(),h(Q.$$.fragment),go=n(),h(O.$$.fragment),Jt=n(),h(je.$$.fragment),Wt=n(),C=d("div"),h(Je.$$.fragment),uo=n(),st=d("p"),st.textContent=Xo,_o=n(),at=d("p"),at.innerHTML=Qo,bo=n(),rt=d("p"),rt.innerHTML=Oo,To=n(),J=d("div"),h(We.$$.fragment),yo=n(),it=d("p"),it.innerHTML=Ko,vo=n(),h(K.$$.fragment),wo=n(),h(ee.$$.fragment),Et=n(),h(Ee.$$.fragment),Rt=n(),lt=d("p"),this.h()},l(e){const t=an("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(o),v=s(e),m=c(e,"P",{}),M(m).forEach(o),p=s(e),f(y.$$.fragment,e),r=s(e),w=c(e,"DIV",{class:!0,"data-svelte-h":!0}),T(w)!=="svelte-b95w5j"&&(w.innerHTML=Po),mt=s(e),f(se.$$.fragment,e),pt=s(e),ae=c(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-19gxegr"&&(ae.innerHTML=Mo),ht=s(e),re=c(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-vfdo9a"&&(re.textContent=Do),ft=s(e),ie=c(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-17tgro5"&&(ie.innerHTML=xo),gt=s(e),L=c(e,"IMG",{src:!0,alt:!0,width:!0}),ut=s(e),le=c(e,"SMALL",{"data-svelte-h":!0}),T(le)!=="svelte-6ly4vl"&&(le.innerHTML=Co),_t=s(e),de=c(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-d1d7zy"&&(de.innerHTML=zo),bt=s(e),f(ce.$$.fragment,e),Tt=s(e),me=c(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-ee2mjm"&&(me.innerHTML=Io),yt=s(e),f(pe.$$.fragment,e),vt=s(e),f(he.$$.fragment,e),wt=s(e),fe=c(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1b0rfkj"&&(fe.textContent=Uo),$t=s(e),ge=c(e,"UL",{"data-svelte-h":!0}),T(ge)!=="svelte-u0adub"&&(ge.innerHTML=Fo),Pt=s(e),ue=c(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1xesile"&&(ue.textContent=jo),Mt=s(e),f(_e.$$.fragment,e),Dt=s(e),D=c(e,"DIV",{class:!0});var U=M(D);f(be.$$.fragment,U),Bt=s(U),Be=c(U,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-19dbh15"&&(Be.innerHTML=Jo),Lt=s(U),Le=c(U,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-o55m63"&&(Le.innerHTML=Wo),Ht=s(U),f(H.$$.fragment,U),Vt=s(U),V=c(U,"DIV",{class:!0});var Re=M(V);f(Te.$$.fragment,Re),Gt=s(Re),He=c(Re,"P",{"data-svelte-h":!0}),T(He)!=="svelte-f91b28"&&(He.innerHTML=Eo),Re.forEach(o),U.forEach(o),xt=s(e),f(ye.$$.fragment,e),kt=s(e),W=c(e,"DIV",{class:!0});var B=M(W);f(ve.$$.fragment,B),qt=s(B),Ve=c(B,"DIV",{class:!0});var dt=M(Ve);f(we.$$.fragment,dt),dt.forEach(o),Yt=s(B),G=c(B,"DIV",{class:!0});var Se=M(G);f($e.$$.fragment,Se),At=s(Se),Ge=c(Se,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-1mxdwkm"&&(Ge.innerHTML=Ro),Se.forEach(o),B.forEach(o),Ct=s(e),f(Pe.$$.fragment,e),zt=s(e),I=c(e,"DIV",{class:!0});var E=M(I);f(Me.$$.fragment,E),Xt=s(E),qe=c(E,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-oc8yhy"&&(qe.textContent=So),Qt=s(E),q=c(E,"DIV",{class:!0});var Ne=M(q);f(De.$$.fragment,Ne),Ot=s(Ne),Ye=c(Ne,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-1x3yxsa"&&(Ye.textContent=No),Ne.forEach(o),Kt=s(E),Y=c(E,"DIV",{class:!0});var Nt=M(Y);f(xe.$$.fragment,Nt),eo=s(Nt),Ae=c(Nt,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-1mxdwkm"&&(Ae.innerHTML=Zo),Nt.forEach(o),E.forEach(o),It=s(e),f(ke.$$.fragment,e),Ut=s(e),x=c(e,"DIV",{class:!0});var R=M(x);f(Ce.$$.fragment,R),to=s(R),Xe=c(R,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-1hvfp4a"&&(Xe.textContent=Bo),oo=s(R),Qe=c(R,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-6pahdo"&&(Qe.innerHTML=Lo),no=s(R),Oe=c(R,"P",{"data-svelte-h":!0}),T(Oe)!=="svelte-hswkmf"&&(Oe.innerHTML=Ho),so=s(R),F=c(R,"DIV",{class:!0});var te=M(F);f(ze.$$.fragment,te),ao=s(te),Ke=c(te,"P",{"data-svelte-h":!0}),T(Ke)!=="svelte-1strmip"&&(Ke.innerHTML=Vo),ro=s(te),f(A.$$.fragment,te),io=s(te),f(X.$$.fragment,te),te.forEach(o),R.forEach(o),Ft=s(e),f(Ie.$$.fragment,e),jt=s(e),k=c(e,"DIV",{class:!0});var S=M(k);f(Ue.$$.fragment,S),lo=s(S),et=c(S,"P",{"data-svelte-h":!0}),T(et)!=="svelte-1w35xhv"&&(et.textContent=Go),co=s(S),tt=c(S,"P",{"data-svelte-h":!0}),T(tt)!=="svelte-6pahdo"&&(tt.innerHTML=qo),mo=s(S),ot=c(S,"P",{"data-svelte-h":!0}),T(ot)!=="svelte-hswkmf"&&(ot.innerHTML=Yo),po=s(S),j=c(S,"DIV",{class:!0});var oe=M(j);f(Fe.$$.fragment,oe),ho=s(oe),nt=c(oe,"P",{"data-svelte-h":!0}),T(nt)!=="svelte-1y4sd4b"&&(nt.innerHTML=Ao),fo=s(oe),f(Q.$$.fragment,oe),go=s(oe),f(O.$$.fragment,oe),oe.forEach(o),S.forEach(o),Jt=s(e),f(je.$$.fragment,e),Wt=s(e),C=c(e,"DIV",{class:!0});var N=M(C);f(Je.$$.fragment,N),uo=s(N),st=c(N,"P",{"data-svelte-h":!0}),T(st)!=="svelte-i6t4gj"&&(st.textContent=Xo),_o=s(N),at=c(N,"P",{"data-svelte-h":!0}),T(at)!=="svelte-6pahdo"&&(at.innerHTML=Qo),bo=s(N),rt=c(N,"P",{"data-svelte-h":!0}),T(rt)!=="svelte-hswkmf"&&(rt.innerHTML=Oo),To=s(N),J=c(N,"DIV",{class:!0});var ne=M(J);f(We.$$.fragment,ne),yo=s(ne),it=c(ne,"P",{"data-svelte-h":!0}),T(it)!=="svelte-1402pfp"&&(it.innerHTML=Ko),vo=s(ne),f(K.$$.fragment,ne),wo=s(ne),f(ee.$$.fragment,ne),ne.forEach(o),N.forEach(o),Et=s(e),f(Ee.$$.fragment,e),Rt=s(e),lt=c(e,"P",{}),M(lt).forEach(o),this.h()},h(){$(a,"name","hf:doc:metadata"),$(a,"content",un),$(w,"class","flex flex-wrap space-x-1"),tn(L.src,ko="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/dpt_architecture.jpg")||$(L,"src",ko),$(L,"alt","drawing"),$(L,"width","600"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,a),l(e,v,t),l(e,m,t),l(e,p,t),g(y,e,t),l(e,r,t),l(e,w,t),l(e,mt,t),g(se,e,t),l(e,pt,t),l(e,ae,t),l(e,ht,t),l(e,re,t),l(e,ft,t),l(e,ie,t),l(e,gt,t),l(e,L,t),l(e,ut,t),l(e,le,t),l(e,_t,t),l(e,de,t),l(e,bt,t),g(ce,e,t),l(e,Tt,t),l(e,me,t),l(e,yt,t),g(pe,e,t),l(e,vt,t),g(he,e,t),l(e,wt,t),l(e,fe,t),l(e,$t,t),l(e,ge,t),l(e,Pt,t),l(e,ue,t),l(e,Mt,t),g(_e,e,t),l(e,Dt,t),l(e,D,t),g(be,D,null),i(D,Bt),i(D,Be),i(D,Lt),i(D,Le),i(D,Ht),g(H,D,null),i(D,Vt),i(D,V),g(Te,V,null),i(V,Gt),i(V,He),l(e,xt,t),g(ye,e,t),l(e,kt,t),l(e,W,t),g(ve,W,null),i(W,qt),i(W,Ve),g(we,Ve,null),i(W,Yt),i(W,G),g($e,G,null),i(G,At),i(G,Ge),l(e,Ct,t),g(Pe,e,t),l(e,zt,t),l(e,I,t),g(Me,I,null),i(I,Xt),i(I,qe),i(I,Qt),i(I,q),g(De,q,null),i(q,Ot),i(q,Ye),i(I,Kt),i(I,Y),g(xe,Y,null),i(Y,eo),i(Y,Ae),l(e,It,t),g(ke,e,t),l(e,Ut,t),l(e,x,t),g(Ce,x,null),i(x,to),i(x,Xe),i(x,oo),i(x,Qe),i(x,no),i(x,Oe),i(x,so),i(x,F),g(ze,F,null),i(F,ao),i(F,Ke),i(F,ro),g(A,F,null),i(F,io),g(X,F,null),l(e,Ft,t),g(Ie,e,t),l(e,jt,t),l(e,k,t),g(Ue,k,null),i(k,lo),i(k,et),i(k,co),i(k,tt),i(k,mo),i(k,ot),i(k,po),i(k,j),g(Fe,j,null),i(j,ho),i(j,nt),i(j,fo),g(Q,j,null),i(j,go),g(O,j,null),l(e,Jt,t),g(je,e,t),l(e,Wt,t),l(e,C,t),g(Je,C,null),i(C,uo),i(C,st),i(C,_o),i(C,at),i(C,bo),i(C,rt),i(C,To),i(C,J),g(We,J,null),i(J,yo),i(J,it),i(J,vo),g(K,J,null),i(J,wo),g(ee,J,null),l(e,Et,t),g(Ee,e,t),l(e,Rt,t),l(e,lt,t),St=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),H.$set(U);const Re={};t&2&&(Re.$$scope={dirty:t,ctx:e}),A.$set(Re);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),X.$set(B);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),Q.$set(dt);const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),O.$set(Se);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),K.$set(E);const Ne={};t&2&&(Ne.$$scope={dirty:t,ctx:e}),ee.$set(Ne)},i(e){St||(u(y.$$.fragment,e),u(se.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(H.$$.fragment,e),u(Te.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(Pe.$$.fragment,e),u(Me.$$.fragment,e),u(De.$$.fragment,e),u(xe.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(ze.$$.fragment,e),u(A.$$.fragment,e),u(X.$$.fragment,e),u(Ie.$$.fragment,e),u(Ue.$$.fragment,e),u(Fe.$$.fragment,e),u(Q.$$.fragment,e),u(O.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(We.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(Ee.$$.fragment,e),St=!0)},o(e){_(y.$$.fragment,e),_(se.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(H.$$.fragment,e),_(Te.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(Pe.$$.fragment,e),_(Me.$$.fragment,e),_(De.$$.fragment,e),_(xe.$$.fragment,e),_(ke.$$.fragment,e),_(Ce.$$.fragment,e),_(ze.$$.fragment,e),_(A.$$.fragment,e),_(X.$$.fragment,e),_(Ie.$$.fragment,e),_(Ue.$$.fragment,e),_(Fe.$$.fragment,e),_(Q.$$.fragment,e),_(O.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_(We.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(Ee.$$.fragment,e),St=!1},d(e){e&&(o(v),o(m),o(p),o(r),o(w),o(mt),o(pt),o(ae),o(ht),o(re),o(ft),o(ie),o(gt),o(L),o(ut),o(le),o(_t),o(de),o(bt),o(Tt),o(me),o(yt),o(vt),o(wt),o(fe),o($t),o(ge),o(Pt),o(ue),o(Mt),o(Dt),o(D),o(xt),o(kt),o(W),o(Ct),o(zt),o(I),o(It),o(Ut),o(x),o(Ft),o(jt),o(k),o(Jt),o(Wt),o(C),o(Et),o(Rt),o(lt)),o(a),b(y,e),b(se,e),b(ce,e),b(pe,e),b(he,e),b(_e,e),b(be),b(H),b(Te),b(ye,e),b(ve),b(we),b($e),b(Pe,e),b(Me),b(De),b(xe),b(ke,e),b(Ce),b(ze),b(A),b(X),b(Ie,e),b(Ue),b(Fe),b(Q),b(O),b(je,e),b(Je),b(We),b(K),b(ee),b(Ee,e)}}}const un='{"title":"DPT","local":"dpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DPTConfig","local":"transformers.DPTConfig","sections":[],"depth":2},{"title":"DPTFeatureExtractor","local":"transformers.DPTFeatureExtractor","sections":[],"depth":2},{"title":"DPTImageProcessor","local":"transformers.DPTImageProcessor","sections":[],"depth":2},{"title":"DPTModel","local":"transformers.DPTModel","sections":[],"depth":2},{"title":"DPTForDepthEstimation","local":"transformers.DPTForDepthEstimation","sections":[],"depth":2},{"title":"DPTForSemanticSegmentation","local":"transformers.DPTForSemanticSegmentation","sections":[],"depth":2}],"depth":1}';function _n(P){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dn extends nn{constructor(a){super(),sn(this,a,_n,gn,en,{})}}export{Dn as component};
