import{s as Ro,o as Bo,n as R}from"../chunks/scheduler.18a86fab.js";import{S as Ho,i as Eo,g as m,s as a,r as h,A as qo,h as p,f as s,c as r,j as J,u as g,x as y,k as $,y as d,a as l,v as u,d as _,t as T,w as b}from"../chunks/index.98837b22.js";import{T as Ct}from"../chunks/Tip.77304350.js";import{D as j}from"../chunks/Docstring.6758ea23.js";import{C as nt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ot}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as D}from"../chunks/Heading.7e7e0c5b.js";import{E as So}from"../chunks/index.92f616ba.js";function Do(w){let o,I="IDEFICS modeling code in Transformers is for finetuning and inferencing the pre-trained IDEFICS models.",c,i,f="To train a new IDEFICS model from scratch use the m4 codebase (a link will be provided once it’s made public)";return{c(){o=m("p"),o.textContent=I,c=a(),i=m("p"),i.textContent=f},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-1avuyik"&&(o.textContent=I),c=r(t),i=p(t,"P",{"data-svelte-h":!0}),y(i)!=="svelte-22xyvf"&&(i.textContent=f)},m(t,v){l(t,o,v),l(t,c,v),l(t,i,v)},p:R,d(t){t&&(s(o),s(c),s(i))}}}function Ao(w){let o,I="Example:",c,i,f;return i=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElkZWZpY3NNb2RlbCUyQyUyMElkZWZpY3NDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwSWRlZmljcyUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSWRlZmljc0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMElkZWZpY3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsModel, IdeficsConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Idefics idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = IdeficsConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=I,c=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=I),c=r(t),g(i.$$.fragment,t)},m(t,v){l(t,o,v),l(t,c,v),u(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(c)),b(i,t)}}}function Go(w){let o,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=I},l(c){o=p(c,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=I)},m(c,i){l(c,o,i)},p:R,d(c){c&&s(o)}}}function Oo(w){let o,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=I},l(c){o=p(c,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=I)},m(c,i){l(c,o,i)},p:R,d(c){c&&s(o)}}}function Yo(w){let o,I="Example:",c,i,f;return i=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0JTBBJTBBbW9kZWwlMjAlM0QlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0LmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEElMEFkb2dzX2ltYWdlX3VybF8xJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX25sdnIyJTJGcmF3JTJGbWFpbiUyRmltYWdlMS5qcGVnJTIyJTBBZG9nc19pbWFnZV91cmxfMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19ubHZyMiUyRnJhdyUyRm1haW4lMkZpbWFnZTIuanBlZyUyMiUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBkb2dzLiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, IdeficsForVisionText2Text

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image1.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image2.jpeg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_1,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of two dogs.\\n&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_2,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=I,c=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=I),c=r(t),g(i.$$.fragment,t)},m(t,v){l(t,o,v),l(t,c,v),u(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(c)),b(i,t)}}}function Xo(w){let o,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=I},l(c){o=p(c,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=I)},m(c,i){l(c,o,i)},p:R,d(c){c&&s(o)}}}function Qo(w){let o,I="Example:",c,i,f;return i=new nt({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURklkZWZpY3NGb3JWaXNpb25UZXh0MlRleHQlMEElMEElM0UlM0UlMjBtb2RlbCUyMCUzRCUyMFRGSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MtOWIlMjIpJTBBJTNFJTNFJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MtOWIlMjIpJTBBJTBBJTNFJTNFJTIwcHJvbXB0JTIwJTNEJTIwJTIySGV5JTJDJTIwYXJlJTIweW91JTIwY29uc2Npb3VycyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBJTNFJTNFJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBJTNFJTNFJTIwJTIzJTIwR2VuZXJhdGUlMEElM0UlM0UlMjBnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQSUzRSUzRSUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQSUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cnMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiU1Q25JJ20lMjBub3QlMjBjb25zY2lvdXJzJTJDJTIwYnV0JTIwSSUyMGNhbiUyMHRhbGslMjB0byUyMHlvdS4lMjI=",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFIdeficsForVisionText2Text

&gt;&gt; model = TFIdeficsForVisionText2Text.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?\\nI&#x27;m not consciours, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=I,c=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=I),c=r(t),g(i.$$.fragment,t)},m(t,v){l(t,o,v),l(t,c,v),u(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(c)),b(i,t)}}}function Ko(w){let o,I="Example:",c,i,f;return i=new nt({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmN1dGUtcGhvdG9zLW9mLWNhdHMtaW4tZ3Jhc3MtMTU5MzE4NDc3Ny5qcGclMjIlMEFpbWclMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLmZldGNoX2ltYWdlcyglNUJ1cmwlNUQpJTVCMCU1RCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1nJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMEFuJTIwaW1hZ2UlMjBvZiUyMHR3byUyMGtpdHRlbnMlMjBpbiUyMGdyYXNzLiUwQSUwQSUyMCUyMCUyMCUyMCUyMlVzZXIlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmRvZy1wdW5zLTE1ODE3MDgyMDguanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X2xlbmd0aCUzRDEwMCklMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)
url = <span class="hljs-string">&quot;https://hips.hearstapps.com/hmg-prod/images/cute-photos-of-cats-in-grass-1593184777.jpg&quot;</span>
img = processor.image_processor.fetch_images([url])[<span class="hljs-number">0</span>]

prompts = [
    <span class="hljs-string">&quot;User:&quot;</span>,
    img,
    <span class="hljs-string">&quot;Describe this image.
t: An image of two kittens in grass.

    &quot;</span>User:<span class="hljs-string">&quot;,
    &quot;</span>https://hips.hearstapps.com/hmg-prod/images/dog-puns-<span class="hljs-number">1581708208.j</span>pg<span class="hljs-string">&quot;,
    &quot;</span>Describe this image.
t:<span class="hljs-string">&quot;,
]

inputs = processor(text=prompts, return_tensors=&quot;</span>pt<span class="hljs-string">&quot;)
generated_ids = model.generate(**inputs, max_length=100)
generated_text = processor.batch_decode(generated_ids, skip_special_tokens=True)[0]</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=I,c=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=I),c=r(t),g(i.$$.fragment,t)},m(t,v){l(t,o,v),l(t,c,v),u(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(c)),b(i,t)}}}function en(w){let o,I="In this example the <code>prompts</code> will be converted into:",c,i,f;return i=new nt({props:{code:"JTNDcyUzRVVzZXIlM0ElM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUzQ2ltYWdlJTNFJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0VEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lMEFBc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBraXR0ZW5zJTIwaW4lMjBncmFzcy4lMEFVc2VyJTNBJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBQXNzaXN0YW50JTNBJw==",highlighted:`&lt;s&gt;<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span>: <span class="hljs-title class_">An</span> image of two kittens <span class="hljs-keyword">in</span> grass.
<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span><span class="hljs-symbol">:<span class="hljs-string">&#x27;</span></span>`,wrap:!1}}),{c(){o=m("p"),o.innerHTML=I,c=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-c8byn"&&(o.innerHTML=I),c=r(t),g(i.$$.fragment,t)},m(t,v){l(t,o,v),l(t,c,v),u(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(c)),b(i,t)}}}function tn(w){let o,I="To do training do:",c,i,f;return i=new nt({props:{code:"aW1hZ2VfdHJhbnNmb3JtJTIwJTNEJTIwdHJhbnNmb3Jtcy5Db21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tUmVzaXplZENyb3AoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHclMkMlMjBoKSUyQyUyMHNjYWxlJTNEKDAuOSUyQyUyMDEuMCklMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUNVQklDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKG1lYW4lM0RzZWxmLmltYWdlX21lYW4lMkMlMjBzdGQlM0RzZWxmLmltYWdlX3N0ZCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHRzJTJDJTIwdHJhbnNmb3JtJTNEaW1hZ2VfdHJhbnNmb3JtJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`image_transform = transforms.Compose(
    [
        transforms.RandomResizedCrop(
            (w, h), scale=(<span class="hljs-number">0.9</span>, <span class="hljs-number">1.0</span>), interpolation=transforms.InterpolationMode.BICUBIC
        ),
        transforms.ToTensor(),
        transforms.Normalize(mean=self.image_mean, std=self.image_std),
    ]
)
inputs = processor(text=prompts, transform=image_transform, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=I,c=a(),h(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-1jbe3nb"&&(o.textContent=I),c=r(t),g(i.$$.fragment,t)},m(t,v){l(t,o,v),l(t,c,v),u(i,t,v),f=!0},p:R,i(t){f||(_(i.$$.fragment,t),f=!0)},o(t){T(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(c)),b(i,t)}}}function on(w){let o,I,c,i,f,t,v,ho='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat&amp;logo=tensorflow&amp;logoColor=white"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',rt,ae,it,re,go='The IDEFICS model was proposed in <a href="https://huggingface.co/papers/2306.16527" rel="nofollow">OBELICS: An Open Web-Scale Filtered Dataset of Interleaved Image-Text Documents</a> by Hugo Laurençon, Lucile Saulnier, Léo Tronchon, Stas Bekman, Amanpreet Singh, Anton Lozhkov, Thomas Wang, Siddharth Karamcheti, Alexander M. Rush, Douwe Kiela, Matthieu Cord, Victor Sanh',dt,ie,uo="The abstract from the paper is the following:",ct,de,_o="<em>Large multimodal models trained on natural documents, which interleave images and text, outperform models trained on image-text pairs on various multimodal benchmarks that require reasoning over one or multiple images to generate a text. However, the datasets used to train these models have not been released, and the collection process has not been fully specified. We introduce the OBELICS dataset, an open web-scale filtered dataset of interleaved image-text documents comprising 141 million web pages extracted from Common Crawl, 353 million associated images, and 115 billion text tokens. We describe the dataset creation process, present comprehensive filtering rules, and provide an analysis of the dataset’s content. To show the viability of OBELISC, we train an 80 billion parameters vision and language model on the dataset and obtain competitive performance on various multimodal benchmarks. We release the code to reproduce the dataset along with the dataset itself.</em>",lt,ce,To='This model was contributed by <a href="https://huggingface.co/HuggingFaceM4" rel="nofollow">HuggingFaceM4</a>. The original code can be found <a href="INSERT%20LINK%20TO%20GITHUB%20REPO%20HERE">here</a>. (TODO: don’t have a public link yet).',mt,A,pt,le,ft,k,me,Ut,Ne,bo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a>. It is used to instantiate an
Idefics model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Idefics-9B.`,Ft,We,yo='e.g. <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">HuggingFaceM4/idefics-9b</a>',jt,Ze,vo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Nt,G,ht,pe,gt,z,fe,Wt,Ve,Io="The bare Idefics Model outputting raw hidden-states without any specific head on top.",Zt,Pe,Mo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vt,Le,xo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pt,L,he,Lt,Re,wo='The <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> forward method, overrides the <code>__call__</code> special method.',Rt,O,ut,ge,_t,B,ue,Bt,N,_e,Ht,Be,$o='The <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',Et,Y,qt,X,Tt,Te,bt,H,be,St,He,ye,yt,ve,vt,E,Ie,Dt,W,Me,At,Ee,ko='The <a href="/docs/transformers/main/en/model_doc/idefics#transformers.TFIdeficsForVisionText2Text">TFIdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',Gt,Q,Ot,K,It,xe,Mt,Z,we,Yt,qe,zo="Constructs a Idefics image processor.",Xt,ee,$e,Qt,Se,Jo="Preprocess a batch of images.",xt,ke,wt,C,ze,Kt,De,Co="Constructs a IDEFICS processor which wraps a LLama tokenizer and IDEFICS image processor into a single processor.",eo,Ae,Uo=`<a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See
the docstring of <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,to,M,Je,oo,Ge,Fo=`This method takes batched or non-batched prompts made of text and images and converts them into prompts that
the model was trained on and prepares the image pixel values for the model to process.`,no,Oe,jo="Detailed explanation:",so,Ye,No="Each entry in <code>text</code> is either a text to be passed as is or an image that will be processed.",ao,Xe,Wo="An image can be either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",ro,Qe,Zo=`When the processor encounters an image it’ll inject <code>&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;</code>
entry into the prompt.`,io,te,co,oe,lo,Ke,Vo=`and the two images will be massaged using <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">IdeficsImageProcessor.<strong>call</strong>()</a> method and placed inside the
<code>pixel_values</code> dict entry of the return value.`,mo,et,Po=`This example also exemplifies that images can be passed as objects or as text urls. It can be seen that the
first image is passed as object and the second one as a url.`,po,ne,fo,tt,Lo="In order to help debug prompt generation enable <code>debug=True</code> which will show you what’s happening.",$t,Ce,kt,st,zt;return f=new D({props:{title:"IDEFICS",local:"idefics",headingTag:"h1"}}),ae=new D({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new Ct({props:{warning:!0,$$slots:{default:[Do]},$$scope:{ctx:w}}}),le=new D({props:{title:"IdeficsConfig",local:"transformers.IdeficsConfig",headingTag:"h2"}}),me=new j({props:{name:"class transformers.IdeficsConfig",anchor:"transformers.IdeficsConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"additional_vocab_size",val:" = 0"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.02"},{name:"alpha_initializer",val:" = 'zeros'"},{name:"alphas_initializer_range",val:" = 0.0"},{name:"alpha_type",val:" = 'float'"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"cross_layer_interval",val:" = 1"},{name:"qk_layer_norms",val:" = False"},{name:"freeze_text_layers",val:" = True"},{name:"freeze_text_module_exceptions",val:" = []"},{name:"freeze_lm_head",val:" = False"},{name:"freeze_vision_layers",val:" = True"},{name:"freeze_vision_module_exceptions",val:" = []"},{name:"use_resampler",val:" = False"},{name:"vision_config",val:" = None"},{name:"perceiver_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsConfig.additional_vocab_size",description:`<strong>additional_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Additional vocabulary size of the model, typically for the special &#x201D;<img>&#x201D; token. Additional vocab tokens
are always trainable whereas regular vocab tokens can be frozen or not.`,name:"additional_vocab_size"},{anchor:"transformers.IdeficsConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Idefics model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">~IdeficsModel</a>`,name:"vocab_size"},{anchor:"transformers.IdeficsConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.IdeficsConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.IdeficsConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.IdeficsConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.IdeficsConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.IdeficsConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.IdeficsConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_initializer",description:`<strong>alpha_initializer</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;zeros&quot;</code>) &#x2014;
Initialization type for the alphas.`,name:"alpha_initializer"},{anchor:"transformers.IdeficsConfig.alphas_initializer_range",description:`<strong>alphas_initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing the alphas in the Gated Cross
Attention.`,name:"alphas_initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_type",description:`<strong>alpha_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;float&quot;</code>) &#x2014;
Whether the gating alphas should be vectors or single floats.`,name:"alpha_type"},{anchor:"transformers.IdeficsConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.IdeficsConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.IdeficsConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.IdeficsConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.IdeficsConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.IdeficsConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.IdeficsConfig.cross_layer_interval",description:`<strong>cross_layer_interval</strong> (<code>int</code>, <em>optional</em>, default to 1) &#x2014;
Interval for cross attention (from text to image) layers.`,name:"cross_layer_interval"},{anchor:"transformers.IdeficsConfig.qk_layer_norms",description:"<strong>qk_layer_norms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to add layer norm after q and k",name:"qk_layer_norms"},{anchor:"transformers.IdeficsConfig.freeze_text_layers",description:"<strong>freeze_text_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to freeze text layers",name:"freeze_text_layers"},{anchor:"transformers.IdeficsConfig.freeze_text_module_exceptions",description:`<strong>freeze_text_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing text layers when <code>freeze_text_layers</code> is <code>True</code>`,name:"freeze_text_module_exceptions"},{anchor:"transformers.IdeficsConfig.freeze_lm_head",description:"<strong>freeze_lm_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to freeze lm head",name:"freeze_lm_head"},{anchor:"transformers.IdeficsConfig.freeze_vision_layers",description:"<strong>freeze_vision_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;  Whether to freeze vision layers",name:"freeze_vision_layers"},{anchor:"transformers.IdeficsConfig.freeze_vision_module_exceptions",description:`<strong>freeze_vision_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing vision layers when <code>freeze_vision_layers</code> is <code>True</code>`,name:"freeze_vision_module_exceptions"},{anchor:"transformers.IdeficsConfig.use_resampler",description:"<strong>use_resampler</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to use the Resampler",name:"use_resampler"},{anchor:"transformers.IdeficsConfig.vision_config",description:"<strong>vision_config</strong> (<code>IdeficsVisionConfig</code>,  <em>optional</em>) &#x2014; Custom vision config or dict",name:"vision_config"},{anchor:"transformers.IdeficsConfig.perceiver_config",description:"<strong>perceiver_config</strong> (<code>IdeficsPerceiverConfig</code>,  <em>optional</em>) &#x2014; Custom perceiver config or dict",name:"perceiver_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/configuration_idefics.py#L154"}}),G=new ot({props:{anchor:"transformers.IdeficsConfig.example",$$slots:{default:[Ao]},$$scope:{ctx:w}}}),pe=new D({props:{title:"IdeficsModel",local:"transformers.IdeficsModel",headingTag:"h2"}}),fe=new j({props:{name:"class transformers.IdeficsModel",anchor:"transformers.IdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"}],parametersDescription:[{anchor:"transformers.IdeficsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L961"}}),he=new j({props:{name:"forward",anchor:"transformers.IdeficsModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_encoder_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"perceiver_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = False"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.IdeficsModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.IdeficsModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.IdeficsModel.forward.image_encoder_embeddings",description:`<strong>image_encoder_embeddings</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
The output of the image encoder.`,name:"image_encoder_embeddings"},{anchor:"transformers.IdeficsModel.forward.perceiver_embeddings",description:`<strong>perceiver_embeddings</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
The output of the perceiver resampler.`,name:"perceiver_embeddings"},{anchor:"transformers.IdeficsModel.forward.image_attention_mask",description:`<strong>image_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The attention mask for the image encoder.`,name:"image_attention_mask"},{anchor:"transformers.IdeficsModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.IdeficsModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.IdeficsModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L1041",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_idefics.IdeficsBaseModelOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_idefics.IdeficsBaseModelOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Ct({props:{$$slots:{default:[Go]},$$scope:{ctx:w}}}),ge=new D({props:{title:"IdeficsForVisionText2Text",local:"transformers.IdeficsForVisionText2Text",headingTag:"h2"}}),ue=new j({props:{name:"class transformers.IdeficsForVisionText2Text",anchor:"transformers.IdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L1445"}}),_e=new j({props:{name:"forward",anchor:"transformers.IdeficsForVisionText2Text.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_encoder_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"perceiver_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = False"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.idefics.modeling_idefics.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.IdeficsForVisionText2Text.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.IdeficsForVisionText2Text.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsForVisionText2Text.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsForVisionText2Text.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.IdeficsForVisionText2Text.forward.image_encoder_embeddings",description:`<strong>image_encoder_embeddings</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
The output of the image encoder.`,name:"image_encoder_embeddings"},{anchor:"transformers.IdeficsForVisionText2Text.forward.perceiver_embeddings",description:`<strong>perceiver_embeddings</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
The output of the perceiver resampler.`,name:"perceiver_embeddings"},{anchor:"transformers.IdeficsForVisionText2Text.forward.image_attention_mask",description:`<strong>image_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The attention mask for the image encoder.`,name:"image_attention_mask"},{anchor:"transformers.IdeficsForVisionText2Text.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.IdeficsForVisionText2Text.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsForVisionText2Text.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.IdeficsForVisionText2Text.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.IdeficsForVisionText2Text.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L1502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new Ct({props:{$$slots:{default:[Oo]},$$scope:{ctx:w}}}),X=new ot({props:{anchor:"transformers.IdeficsForVisionText2Text.forward.example",$$slots:{default:[Yo]},$$scope:{ctx:w}}}),Te=new D({props:{title:"TFIdeficsModel",local:"transformers.TFIdeficsModel",headingTag:"h2"}}),be=new j({props:{name:"class transformers.TFIdeficsModel",anchor:"transformers.TFIdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_tf_idefics.py#L1559"}}),ye=new j({props:{name:"call",anchor:"transformers.TFIdeficsModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": Optional[tf.Tensor] = None"},{name:"position_ids",val:": Optional[tf.Tensor] = None"},{name:"past_key_values",val:": Optional[List[tf.Tensor]] = None"},{name:"inputs_embeds",val:": Optional[tf.Tensor] = None"},{name:"pixel_values",val:": Optional[tf.Tensor] = None"},{name:"image_encoder_embeddings",val:": Optional[tf.Tensor] = None"},{name:"perceiver_embeddings",val:": Optional[tf.Tensor] = None"},{name:"image_attention_mask",val:": Optional[tf.Tensor] = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": Optional[bool] = False"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_tf_idefics.py#L1565"}}),ve=new D({props:{title:"TFIdeficsForVisionText2Text",local:"transformers.TFIdeficsForVisionText2Text",headingTag:"h2"}}),Ie=new j({props:{name:"class transformers.TFIdeficsForVisionText2Text",anchor:"transformers.TFIdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_tf_idefics.py#L1611"}}),Me=new j({props:{name:"call",anchor:"transformers.TFIdeficsForVisionText2Text.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": Optional[tf.Tensor] = None"},{name:"position_ids",val:": Optional[tf.Tensor] = None"},{name:"past_key_values",val:": Optional[List[tf.Tensor]] = None"},{name:"inputs_embeds",val:": Optional[tf.Tensor] = None"},{name:"pixel_values",val:": Optional[tf.Tensor] = None"},{name:"image_encoder_embeddings",val:": Optional[tf.Tensor] = None"},{name:"perceiver_embeddings",val:": Optional[tf.Tensor] = None"},{name:"image_attention_mask",val:": Optional[tf.Tensor] = None"},{name:"labels",val:": Optional[tf.Tensor] = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": Optional[bool] = False"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:" = False"}],parametersDescription:[{anchor:"transformers.TFIdeficsForVisionText2Text.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(tf.Tensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_tf_idefics.py#L1667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_tf_idefics.TFIdeficsCausalLMOutputWithPast</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(tf.Tensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>) — Tuple of <code>tf.Tensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_tf_idefics.TFIdeficsCausalLMOutputWithPast</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Q=new Ct({props:{$$slots:{default:[Xo]},$$scope:{ctx:w}}}),K=new ot({props:{anchor:"transformers.TFIdeficsForVisionText2Text.call.example",$$slots:{default:[Qo]},$$scope:{ctx:w}}}),xe=new D({props:{title:"IdeficsImageProcessor",local:"transformers.IdeficsImageProcessor",headingTag:"h2"}}),we=new j({props:{name:"class transformers.IdeficsImageProcessor",anchor:"transformers.IdeficsImageProcessor",parameters:[{name:"image_size",val:": int = 224"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_num_channels",val:": typing.Optional[int] = 3"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of image channels.`,name:"image_num_channels"},{anchor:"transformers.IdeficsImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.IdeficsImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/image_processing_idefics.py#L51"}}),$e=new j({props:{name:"preprocess",anchor:"transformers.IdeficsImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"image_num_channels",val:": typing.Optional[int] = 3"},{name:"image_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"transform",val:": typing.Optional[typing.Callable] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = <TensorType.PYTORCH: 'pt'>"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
A list of images to preprocess.`,name:"images"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_size</code>) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_num_channels</code>) &#x2014;
Number of image channels.`,name:"image_num_channels"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can
be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.preprocess.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple transforms. If <code>None</code> - an inference mode is
assumed - and then a preset of inference-specific transforms will be applied to the images`,name:"transform"},{anchor:"transformers.IdeficsImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.IdeficsImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/image_processing_idefics.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a PyTorch tensor of the processed images</p>
`}}),ke=new D({props:{title:"IdeficsProcessor",local:"transformers.IdeficsProcessor",headingTag:"h2"}}),ze=new j({props:{name:"class transformers.IdeficsProcessor",anchor:"transformers.IdeficsProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:" = None"},{name:"image_size",val:" = 224"},{name:"add_end_of_utterance_token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.image_processor",description:`<strong>image_processor</strong> (<code>IdeficsImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.IdeficsProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>LlamaTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.IdeficsProcessor.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
Image size (assuming a square image)`,name:"image_size"},{anchor:"transformers.IdeficsProcessor.add_end_of_utterance_token",description:`<strong>add_end_of_utterance_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The string representation of token representing end of utterance`,name:"add_end_of_utterance_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/processing_idefics.py#L195"}}),Je=new j({props:{name:"__call__",anchor:"transformers.IdeficsProcessor.__call__",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]], str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], typing.List[typing.List[typing.List[str]]]] = None"},{name:"audio",val:" = None"},{name:"videos",val:" = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.idefics.processing_idefics.IdeficsProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.__call__.images",description:`<strong>images</strong> (<code>Union[ImageInput, List[ImageInput], str, List[str], List[List[str]]]</code>) &#x2014;
either a single image or a batched list of images - can be passed in when text contains only text prompts,
in order to use the image-text-to-text behavior.`,name:"images"},{anchor:"transformers.IdeficsProcessor.__call__.text",description:`<strong>text</strong> (<code>Union[List[TextInput], [List[List[TextInput]]]]</code>) &#x2014;
either a single prompt or a batched list of prompts - see the detailed description immediately after
the end of the arguments doc section.`,name:"text"},{anchor:"transformers.IdeficsProcessor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>TensorType.PYTORCH</code>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/processing_idefics.py#L244",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>input_ids</code>, <code>attention_mask</code>, <code>pixel_values</code>, <code>image_attention_mask</code> which can be
directly passed to <code>model.generate</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a dict with entries</p>
`}}),te=new ot({props:{anchor:"transformers.IdeficsProcessor.__call__.example",$$slots:{default:[Ko]},$$scope:{ctx:w}}}),oe=new ot({props:{anchor:"transformers.IdeficsProcessor.__call__.example-2",$$slots:{default:[en]},$$scope:{ctx:w}}}),ne=new ot({props:{anchor:"transformers.IdeficsProcessor.__call__.example-3",$$slots:{default:[tn]},$$scope:{ctx:w}}}),Ce=new So({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/idefics.md"}}),{c(){o=m("meta"),I=a(),c=m("p"),i=a(),h(f.$$.fragment),t=a(),v=m("div"),v.innerHTML=ho,rt=a(),h(ae.$$.fragment),it=a(),re=m("p"),re.innerHTML=go,dt=a(),ie=m("p"),ie.textContent=uo,ct=a(),de=m("p"),de.innerHTML=_o,lt=a(),ce=m("p"),ce.innerHTML=To,mt=a(),h(A.$$.fragment),pt=a(),h(le.$$.fragment),ft=a(),k=m("div"),h(me.$$.fragment),Ut=a(),Ne=m("p"),Ne.innerHTML=bo,Ft=a(),We=m("p"),We.innerHTML=yo,jt=a(),Ze=m("p"),Ze.innerHTML=vo,Nt=a(),h(G.$$.fragment),ht=a(),h(pe.$$.fragment),gt=a(),z=m("div"),h(fe.$$.fragment),Wt=a(),Ve=m("p"),Ve.textContent=Io,Zt=a(),Pe=m("p"),Pe.innerHTML=Mo,Vt=a(),Le=m("p"),Le.innerHTML=xo,Pt=a(),L=m("div"),h(he.$$.fragment),Lt=a(),Re=m("p"),Re.innerHTML=wo,Rt=a(),h(O.$$.fragment),ut=a(),h(ge.$$.fragment),_t=a(),B=m("div"),h(ue.$$.fragment),Bt=a(),N=m("div"),h(_e.$$.fragment),Ht=a(),Be=m("p"),Be.innerHTML=$o,Et=a(),h(Y.$$.fragment),qt=a(),h(X.$$.fragment),Tt=a(),h(Te.$$.fragment),bt=a(),H=m("div"),h(be.$$.fragment),St=a(),He=m("div"),h(ye.$$.fragment),yt=a(),h(ve.$$.fragment),vt=a(),E=m("div"),h(Ie.$$.fragment),Dt=a(),W=m("div"),h(Me.$$.fragment),At=a(),Ee=m("p"),Ee.innerHTML=ko,Gt=a(),h(Q.$$.fragment),Ot=a(),h(K.$$.fragment),It=a(),h(xe.$$.fragment),Mt=a(),Z=m("div"),h(we.$$.fragment),Yt=a(),qe=m("p"),qe.textContent=zo,Xt=a(),ee=m("div"),h($e.$$.fragment),Qt=a(),Se=m("p"),Se.textContent=Jo,xt=a(),h(ke.$$.fragment),wt=a(),C=m("div"),h(ze.$$.fragment),Kt=a(),De=m("p"),De.textContent=Co,eo=a(),Ae=m("p"),Ae.innerHTML=Uo,to=a(),M=m("div"),h(Je.$$.fragment),oo=a(),Ge=m("p"),Ge.textContent=Fo,no=a(),Oe=m("p"),Oe.textContent=jo,so=a(),Ye=m("p"),Ye.innerHTML=No,ao=a(),Xe=m("p"),Xe.innerHTML=Wo,ro=a(),Qe=m("p"),Qe.innerHTML=Zo,io=a(),h(te.$$.fragment),co=a(),h(oe.$$.fragment),lo=a(),Ke=m("p"),Ke.innerHTML=Vo,mo=a(),et=m("p"),et.textContent=Po,po=a(),h(ne.$$.fragment),fo=a(),tt=m("p"),tt.innerHTML=Lo,$t=a(),h(Ce.$$.fragment),kt=a(),st=m("p"),this.h()},l(e){const n=qo("svelte-u9bgzb",document.head);o=p(n,"META",{name:!0,content:!0}),n.forEach(s),I=r(e),c=p(e,"P",{}),J(c).forEach(s),i=r(e),g(f.$$.fragment,e),t=r(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),y(v)!=="svelte-1i2zane"&&(v.innerHTML=ho),rt=r(e),g(ae.$$.fragment,e),it=r(e),re=p(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-jddp08"&&(re.innerHTML=go),dt=r(e),ie=p(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-vfdo9a"&&(ie.textContent=uo),ct=r(e),de=p(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-18xi2yr"&&(de.innerHTML=_o),lt=r(e),ce=p(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-1nhi3a3"&&(ce.innerHTML=To),mt=r(e),g(A.$$.fragment,e),pt=r(e),g(le.$$.fragment,e),ft=r(e),k=p(e,"DIV",{class:!0});var U=J(k);g(me.$$.fragment,U),Ut=r(U),Ne=p(U,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-vk0gw8"&&(Ne.innerHTML=bo),Ft=r(U),We=p(U,"P",{"data-svelte-h":!0}),y(We)!=="svelte-n7bqeh"&&(We.innerHTML=yo),jt=r(U),Ze=p(U,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-o55m63"&&(Ze.innerHTML=vo),Nt=r(U),g(G.$$.fragment,U),U.forEach(s),ht=r(e),g(pe.$$.fragment,e),gt=r(e),z=p(e,"DIV",{class:!0});var F=J(z);g(fe.$$.fragment,F),Wt=r(F),Ve=p(F,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-18x08mj"&&(Ve.textContent=Io),Zt=r(F),Pe=p(F,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-6pahdo"&&(Pe.innerHTML=Mo),Vt=r(F),Le=p(F,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-hswkmf"&&(Le.innerHTML=xo),Pt=r(F),L=p(F,"DIV",{class:!0});var q=J(L);g(he.$$.fragment,q),Lt=r(q),Re=p(q,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-fnr21g"&&(Re.innerHTML=wo),Rt=r(q),g(O.$$.fragment,q),q.forEach(s),F.forEach(s),ut=r(e),g(ge.$$.fragment,e),_t=r(e),B=p(e,"DIV",{class:!0});var Ue=J(B);g(ue.$$.fragment,Ue),Bt=r(Ue),N=p(Ue,"DIV",{class:!0});var V=J(N);g(_e.$$.fragment,V),Ht=r(V),Be=p(V,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-1mawjh8"&&(Be.innerHTML=$o),Et=r(V),g(Y.$$.fragment,V),qt=r(V),g(X.$$.fragment,V),V.forEach(s),Ue.forEach(s),Tt=r(e),g(Te.$$.fragment,e),bt=r(e),H=p(e,"DIV",{class:!0});var Fe=J(H);g(be.$$.fragment,Fe),St=r(Fe),He=p(Fe,"DIV",{class:!0});var at=J(He);g(ye.$$.fragment,at),at.forEach(s),Fe.forEach(s),yt=r(e),g(ve.$$.fragment,e),vt=r(e),E=p(e,"DIV",{class:!0});var je=J(E);g(Ie.$$.fragment,je),Dt=r(je),W=p(je,"DIV",{class:!0});var P=J(W);g(Me.$$.fragment,P),At=r(P),Ee=p(P,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-umput8"&&(Ee.innerHTML=ko),Gt=r(P),g(Q.$$.fragment,P),Ot=r(P),g(K.$$.fragment,P),P.forEach(s),je.forEach(s),It=r(e),g(xe.$$.fragment,e),Mt=r(e),Z=p(e,"DIV",{class:!0});var S=J(Z);g(we.$$.fragment,S),Yt=r(S),qe=p(S,"P",{"data-svelte-h":!0}),y(qe)!=="svelte-1m1ucrf"&&(qe.textContent=zo),Xt=r(S),ee=p(S,"DIV",{class:!0});var Jt=J(ee);g($e.$$.fragment,Jt),Qt=r(Jt),Se=p(Jt,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-1xds4wy"&&(Se.textContent=Jo),Jt.forEach(s),S.forEach(s),xt=r(e),g(ke.$$.fragment,e),wt=r(e),C=p(e,"DIV",{class:!0});var se=J(C);g(ze.$$.fragment,se),Kt=r(se),De=p(se,"P",{"data-svelte-h":!0}),y(De)!=="svelte-ntsjs9"&&(De.textContent=Co),eo=r(se),Ae=p(se,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-9y5i42"&&(Ae.innerHTML=Uo),to=r(se),M=p(se,"DIV",{class:!0});var x=J(M);g(Je.$$.fragment,x),oo=r(x),Ge=p(x,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-1dgzv8j"&&(Ge.textContent=Fo),no=r(x),Oe=p(x,"P",{"data-svelte-h":!0}),y(Oe)!=="svelte-qv5ndj"&&(Oe.textContent=jo),so=r(x),Ye=p(x,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-19vf3ea"&&(Ye.innerHTML=No),ao=r(x),Xe=p(x,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-15i05k0"&&(Xe.innerHTML=Wo),ro=r(x),Qe=p(x,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-gstss4"&&(Qe.innerHTML=Zo),io=r(x),g(te.$$.fragment,x),co=r(x),g(oe.$$.fragment,x),lo=r(x),Ke=p(x,"P",{"data-svelte-h":!0}),y(Ke)!=="svelte-1actnum"&&(Ke.innerHTML=Vo),mo=r(x),et=p(x,"P",{"data-svelte-h":!0}),y(et)!=="svelte-133asib"&&(et.textContent=Po),po=r(x),g(ne.$$.fragment,x),fo=r(x),tt=p(x,"P",{"data-svelte-h":!0}),y(tt)!=="svelte-1drva0b"&&(tt.innerHTML=Lo),x.forEach(s),se.forEach(s),$t=r(e),g(Ce.$$.fragment,e),kt=r(e),st=p(e,"P",{}),J(st).forEach(s),this.h()},h(){$(o,"name","hf:doc:metadata"),$(o,"content",nn),$(v,"class","flex flex-wrap space-x-1"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){d(document.head,o),l(e,I,n),l(e,c,n),l(e,i,n),u(f,e,n),l(e,t,n),l(e,v,n),l(e,rt,n),u(ae,e,n),l(e,it,n),l(e,re,n),l(e,dt,n),l(e,ie,n),l(e,ct,n),l(e,de,n),l(e,lt,n),l(e,ce,n),l(e,mt,n),u(A,e,n),l(e,pt,n),u(le,e,n),l(e,ft,n),l(e,k,n),u(me,k,null),d(k,Ut),d(k,Ne),d(k,Ft),d(k,We),d(k,jt),d(k,Ze),d(k,Nt),u(G,k,null),l(e,ht,n),u(pe,e,n),l(e,gt,n),l(e,z,n),u(fe,z,null),d(z,Wt),d(z,Ve),d(z,Zt),d(z,Pe),d(z,Vt),d(z,Le),d(z,Pt),d(z,L),u(he,L,null),d(L,Lt),d(L,Re),d(L,Rt),u(O,L,null),l(e,ut,n),u(ge,e,n),l(e,_t,n),l(e,B,n),u(ue,B,null),d(B,Bt),d(B,N),u(_e,N,null),d(N,Ht),d(N,Be),d(N,Et),u(Y,N,null),d(N,qt),u(X,N,null),l(e,Tt,n),u(Te,e,n),l(e,bt,n),l(e,H,n),u(be,H,null),d(H,St),d(H,He),u(ye,He,null),l(e,yt,n),u(ve,e,n),l(e,vt,n),l(e,E,n),u(Ie,E,null),d(E,Dt),d(E,W),u(Me,W,null),d(W,At),d(W,Ee),d(W,Gt),u(Q,W,null),d(W,Ot),u(K,W,null),l(e,It,n),u(xe,e,n),l(e,Mt,n),l(e,Z,n),u(we,Z,null),d(Z,Yt),d(Z,qe),d(Z,Xt),d(Z,ee),u($e,ee,null),d(ee,Qt),d(ee,Se),l(e,xt,n),u(ke,e,n),l(e,wt,n),l(e,C,n),u(ze,C,null),d(C,Kt),d(C,De),d(C,eo),d(C,Ae),d(C,to),d(C,M),u(Je,M,null),d(M,oo),d(M,Ge),d(M,no),d(M,Oe),d(M,so),d(M,Ye),d(M,ao),d(M,Xe),d(M,ro),d(M,Qe),d(M,io),u(te,M,null),d(M,co),u(oe,M,null),d(M,lo),d(M,Ke),d(M,mo),d(M,et),d(M,po),u(ne,M,null),d(M,fo),d(M,tt),l(e,$t,n),u(Ce,e,n),l(e,kt,n),l(e,st,n),zt=!0},p(e,[n]){const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),A.$set(U);const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),G.$set(F);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),O.$set(q);const Ue={};n&2&&(Ue.$$scope={dirty:n,ctx:e}),Y.$set(Ue);const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),X.$set(V);const Fe={};n&2&&(Fe.$$scope={dirty:n,ctx:e}),Q.$set(Fe);const at={};n&2&&(at.$$scope={dirty:n,ctx:e}),K.$set(at);const je={};n&2&&(je.$$scope={dirty:n,ctx:e}),te.$set(je);const P={};n&2&&(P.$$scope={dirty:n,ctx:e}),oe.$set(P);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),ne.$set(S)},i(e){zt||(_(f.$$.fragment,e),_(ae.$$.fragment,e),_(A.$$.fragment,e),_(le.$$.fragment,e),_(me.$$.fragment,e),_(G.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(O.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(Y.$$.fragment,e),_(X.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(Ie.$$.fragment,e),_(Me.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(xe.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(ke.$$.fragment,e),_(ze.$$.fragment,e),_(Je.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(Ce.$$.fragment,e),zt=!0)},o(e){T(f.$$.fragment,e),T(ae.$$.fragment,e),T(A.$$.fragment,e),T(le.$$.fragment,e),T(me.$$.fragment,e),T(G.$$.fragment,e),T(pe.$$.fragment,e),T(fe.$$.fragment,e),T(he.$$.fragment,e),T(O.$$.fragment,e),T(ge.$$.fragment,e),T(ue.$$.fragment,e),T(_e.$$.fragment,e),T(Y.$$.fragment,e),T(X.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(ye.$$.fragment,e),T(ve.$$.fragment,e),T(Ie.$$.fragment,e),T(Me.$$.fragment,e),T(Q.$$.fragment,e),T(K.$$.fragment,e),T(xe.$$.fragment,e),T(we.$$.fragment,e),T($e.$$.fragment,e),T(ke.$$.fragment,e),T(ze.$$.fragment,e),T(Je.$$.fragment,e),T(te.$$.fragment,e),T(oe.$$.fragment,e),T(ne.$$.fragment,e),T(Ce.$$.fragment,e),zt=!1},d(e){e&&(s(I),s(c),s(i),s(t),s(v),s(rt),s(it),s(re),s(dt),s(ie),s(ct),s(de),s(lt),s(ce),s(mt),s(pt),s(ft),s(k),s(ht),s(gt),s(z),s(ut),s(_t),s(B),s(Tt),s(bt),s(H),s(yt),s(vt),s(E),s(It),s(Mt),s(Z),s(xt),s(wt),s(C),s($t),s(kt),s(st)),s(o),b(f,e),b(ae,e),b(A,e),b(le,e),b(me),b(G),b(pe,e),b(fe),b(he),b(O),b(ge,e),b(ue),b(_e),b(Y),b(X),b(Te,e),b(be),b(ye),b(ve,e),b(Ie),b(Me),b(Q),b(K),b(xe,e),b(we),b($e),b(ke,e),b(ze),b(Je),b(te),b(oe),b(ne),b(Ce,e)}}}const nn='{"title":"IDEFICS","local":"idefics","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"IdeficsConfig","local":"transformers.IdeficsConfig","sections":[],"depth":2},{"title":"IdeficsModel","local":"transformers.IdeficsModel","sections":[],"depth":2},{"title":"IdeficsForVisionText2Text","local":"transformers.IdeficsForVisionText2Text","sections":[],"depth":2},{"title":"TFIdeficsModel","local":"transformers.TFIdeficsModel","sections":[],"depth":2},{"title":"TFIdeficsForVisionText2Text","local":"transformers.TFIdeficsForVisionText2Text","sections":[],"depth":2},{"title":"IdeficsImageProcessor","local":"transformers.IdeficsImageProcessor","sections":[],"depth":2},{"title":"IdeficsProcessor","local":"transformers.IdeficsProcessor","sections":[],"depth":2}],"depth":1}';function sn(w){return Bo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hn extends Ho{constructor(o){super(),Eo(this,o,sn,on,Ro,{})}}export{hn as component};
