import{s as Jt,z as jt,o as Rt,n as Ye}from"../chunks/scheduler.18a86fab.js";import{S as Zt,i as Lt,g as c,s as n,r as g,A as Gt,h as m,f as o,c as s,j as U,u as f,x as y,k as $,y as d,a,v as h,d as u,t as _,w as b}from"../chunks/index.98837b22.js";import{T as kt}from"../chunks/Tip.77304350.js";import{D as H}from"../chunks/Docstring.6758ea23.js";import{C as Wt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Nt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ge}from"../chunks/Heading.7e7e0c5b.js";import{E as Ht}from"../chunks/index.92f616ba.js";function St(F){let r,M="The model expects both the image and trimap (concatenated) as input. Use <code>ViTMatteImageProcessor</code> for this purpose.";return{c(){r=c("p"),r.innerHTML=M},l(l){r=m(l,"P",{"data-svelte-h":!0}),y(r)!=="svelte-8i6ct1"&&(r.innerHTML=M)},m(l,p){a(l,r,p)},p:Ye,d(l){l&&o(r)}}}function Dt(F){let r,M="Example:",l,p,v;return p=new Wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdE1hdHRlQ29uZmlnJTJDJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVmlUTWF0dGUlMjBodXN0dmwlMkZ2aXRtYXR0ZS1zbWFsbC1jb21wb3NpdGlvbi0xayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBWaXRNYXR0ZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBodXN0dmwlMkZ2aXRtYXR0ZS1zbWFsbC1jb21wb3NpdGlvbi0xayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmcoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitMatteConfig, VitMatteForImageMatting

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ViTMatte hustvl/vitmatte-small-composition-1k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VitMatteConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/vitmatte-small-composition-1k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitMatteForImageMatting(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=c("p"),r.textContent=M,l=n(),g(p.$$.fragment)},l(i){r=m(i,"P",{"data-svelte-h":!0}),y(r)!=="svelte-11lpom8"&&(r.textContent=M),l=s(i),f(p.$$.fragment,i)},m(i,T){a(i,r,T),a(i,l,T),h(p,i,T),v=!0},p:Ye,i(i){v||(u(p.$$.fragment,i),v=!0)},o(i){_(p.$$.fragment,i),v=!1},d(i){i&&(o(r),o(l)),b(p,i)}}}function Et(F){let r,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=c("p"),r.innerHTML=M},l(l){r=m(l,"P",{"data-svelte-h":!0}),y(r)!=="svelte-fincs2"&&(r.innerHTML=M)},m(l,p){a(l,r,p)},p:Ye,d(l){l&&o(r)}}}function qt(F){let r,M="Examples:",l,p,v;return p=new Wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdE1hdHRlSW1hZ2VQcm9jZXNzb3IlMkMlMjBWaXRNYXR0ZUZvckltYWdlTWF0dGluZyUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMFZpdE1hdHRlSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnZpdG1hdHRlLXNtYWxsLWNvbXBvc2l0aW9uLTFrJTIyKSUwQW1vZGVsJTIwJTNEJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnZpdG1hdHRlLXNtYWxsLWNvbXBvc2l0aW9uLTFrJTIyKSUwQSUwQWZpbGVwYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGaW1hZ2UtbWF0dGluZy1maXh0dXJlcyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyaW1hZ2UucG5nJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oZmlsZXBhdGgpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWZpbGVwYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGaW1hZ2UtbWF0dGluZy1maXh0dXJlcyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJpbWFwLnBuZyUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBdHJpbWFwJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlcGF0aCkuY29udmVydCglMjJMJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMCUyQiUyMHRyaW1hcCUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdHJpbWFwcyUzRHRyaW1hcCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGFscGhhcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5hbHBoYXMlMEFwcmludChhbHBoYXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitMatteImageProcessor, VitMatteForImageMatting
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VitMatteImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/vitmatte-small-composition-1k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitMatteForImageMatting.from_pretrained(<span class="hljs-string">&quot;hustvl/vitmatte-small-composition-1k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filepath = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/image-matting-fixtures&quot;</span>, filename=<span class="hljs-string">&quot;image.png&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(filepath).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>filepath = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/image-matting-fixtures&quot;</span>, filename=<span class="hljs-string">&quot;trimap.png&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trimap = Image.<span class="hljs-built_in">open</span>(filepath).convert(<span class="hljs-string">&quot;L&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image + trimap for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, trimaps=trimap, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    alphas = model(**inputs).alphas
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(alphas.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">640</span>, <span class="hljs-number">960</span>])`,wrap:!1}}),{c(){r=c("p"),r.textContent=M,l=n(),g(p.$$.fragment)},l(i){r=m(i,"P",{"data-svelte-h":!0}),y(r)!=="svelte-kvfsh7"&&(r.textContent=M),l=s(i),f(p.$$.fragment,i)},m(i,T){a(i,r,T),a(i,l,T),h(p,i,T),v=!0},p:Ye,i(i){v||(u(p.$$.fragment,i),v=!0)},o(i){_(p.$$.fragment,i),v=!1},d(i){i&&(o(r),o(l)),b(p,i)}}}function Bt(F){let r,M,l,p,v,i,T,gt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',xe,S,Ce,D,ft=`The ViTMatte model was proposed in <a href="https://arxiv.org/abs/2305.15272" rel="nofollow">Boosting Image Matting with Pretrained Plain Vision Transformers</a> by Jingfeng Yao, Xinggang Wang, Shusheng Yang, Baoyuan Wang.
ViTMatte leverages plain <a href="vit">Vision Transformers</a> for the task of image matting, which is the process of accurately estimating the foreground object in images and videos.`,ze,E,ht="The abstract from the paper is the following:",Fe,q,ut="<em>Recently, plain vision Transformers (ViTs) have shown impressive performance on various computer vision tasks, thanks to their strong modeling capacity and large-scale pretraining. However, they have not yet conquered the problem of image matting. We hypothesize that image matting could also be boosted by ViTs and present a new efficient and robust ViT-based matting system, named ViTMatte. Our method utilizes (i) a hybrid attention mechanism combined with a convolution neck to help ViTs achieve an excellent performance-computation trade-off in matting tasks. (ii) Additionally, we introduce the detail capture module, which just consists of simple lightweight convolutions to complement the detailed information required by matting. To the best of our knowledge, ViTMatte is the first work to unleash the potential of ViT on image matting with concise adaptation. It inherits many superior properties from ViT to matting, including various pretraining strategies, concise architecture design, and flexible inference strategies. We evaluate ViTMatte on Composition-1k and Distinctions-646, the most commonly used benchmark for image matting, our method achieves state-of-the-art performance and outperforms prior matting works by a large margin.</em>",Pe,B,_t=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/hustvl/ViTMatte" rel="nofollow">here</a>.`,Ue,N,bt,ke,X,yt='ViTMatte high-level overview. Taken from the <a href="https://arxiv.org/abs/2305.15272">original paper.</a>',Ne,Y,We,Q,vt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ViTMatte.",Je,O,Mt='<li>A demo notebook regarding inference with <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a>, including background replacement, can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/ViTMatte" rel="nofollow">here</a>.</li>',je,W,Re,A,Ze,w,K,Qe,fe,Tt=`This is the configuration class to store the configuration of <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a>. It is used to
instantiate a ViTMatte model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the ViTMatte
<a href="https://huggingface.co/hustvl/vitmatte-small-composition-1k" rel="nofollow">hustvl/vitmatte-small-composition-1k</a> architecture.`,Oe,he,wt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,J,Ke,j,ee,et,ue,It=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,Le,te,Ge,C,oe,tt,_e,$t="Constructs a ViTMatte image processor.",ot,R,ae,at,be,Vt="Preprocess an image or batch of images.",He,ne,Se,z,se,nt,ye,xt="Constructs a fast Vitmatte image processor.",st,ve,re,De,ie,Ee,I,ce,rt,Me,Ct="ViTMatte framework leveraging any vision backbone e.g. for ADE20k, CityScapes.",it,Te,zt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ct,we,Ft=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mt,x,me,dt,Ie,Pt='The <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a> forward method, overrides the <code>__call__</code> special method.',lt,Z,pt,L,qe,de,Be,Ve,Xe;return v=new ge({props:{title:"ViTMatte",local:"vitmatte",headingTag:"h1"}}),S=new ge({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new ge({props:{title:"Resources",local:"resources",headingTag:"h2"}}),W=new kt({props:{$$slots:{default:[St]},$$scope:{ctx:F}}}),A=new ge({props:{title:"VitMatteConfig",local:"transformers.VitMatteConfig",headingTag:"h2"}}),K=new H({props:{name:"class transformers.VitMatteConfig",anchor:"transformers.VitMatteConfig",parameters:[{name:"backbone_config",val:": PretrainedConfig = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"hidden_size",val:": int = 384"},{name:"batch_norm_eps",val:": float = 1e-05"},{name:"initializer_range",val:": float = 0.02"},{name:"convstream_hidden_sizes",val:": typing.List[int] = [48, 96, 192]"},{name:"fusion_hidden_sizes",val:": typing.List[int] = [256, 128, 64, 32]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>VitDetConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.VitMatteConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.VitMatteConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.VitMatteConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.VitMatteConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.VitMatteConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the decoder.`,name:"hidden_size"},{anchor:"transformers.VitMatteConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the batch norm layers.`,name:"batch_norm_eps"},{anchor:"transformers.VitMatteConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VitMatteConfig.convstream_hidden_sizes",description:`<strong>convstream_hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[48, 96, 192]</code>) &#x2014;
The output channels of the ConvStream module.`,name:"convstream_hidden_sizes"},{anchor:"transformers.VitMatteConfig.fusion_hidden_sizes",description:`<strong>fusion_hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 128, 64, 32]</code>) &#x2014;
The output channels of the Fusion blocks.`,name:"fusion_hidden_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/configuration_vitmatte.py#L29"}}),J=new Nt({props:{anchor:"transformers.VitMatteConfig.example",$$slots:{default:[Dt]},$$scope:{ctx:F}}}),ee=new H({props:{name:"to_dict",anchor:"transformers.VitMatteConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/configuration_vitmatte.py#L125"}}),te=new ge({props:{title:"VitMatteImageProcessor",local:"transformers.VitMatteImageProcessor",headingTag:"h2"}}),oe=new H({props:{name:"class transformers.VitMatteImageProcessor",anchor:"transformers.VitMatteImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": bool = True"},{name:"size_divisibility",val:": int = 32"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the width and height divisible by <code>size_divisibility</code>. Can be overridden
by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessor.size_divisibility",description:`<strong>size_divisibility</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The width and height of the image will be padded to be divisible by this number.`,name:"size_divisibility"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/image_processing_vitmatte.py#L42"}}),ae=new H({props:{name:"preprocess",anchor:"transformers.VitMatteImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"trimaps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"size_divisibility",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VitMatteImageProcessor.preprocess.trimaps",description:`<strong>trimaps</strong> (<code>ImageInput</code>) &#x2014;
Trimap to preprocess.`,name:"trimaps"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessor.preprocess.size_divisibility",description:`<strong>size_divisibility</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisibility</code>) &#x2014;
The size divisibility to pad the image to if <code>do_pad</code> is set to <code>True</code>.`,name:"size_divisibility"},{anchor:"transformers.VitMatteImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VitMatteImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VitMatteImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/image_processing_vitmatte.py#L132"}}),ne=new ge({props:{title:"VitMatteImageProcessorFast",local:"transformers.VitMatteImageProcessorFast",headingTag:"h2"}}),se=new H({props:{name:"class transformers.VitMatteImageProcessorFast",anchor:"transformers.VitMatteImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.vitmatte.image_processing_vitmatte_fast.VitMatteFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VitMatteImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.VitMatteImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.VitMatteImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>None</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VitMatteImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.VitMatteImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.VitMatteImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.VitMatteImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.VitMatteImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.VitMatteImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.VitMatteImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.VitMatteImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the width and height divisible by <code>size_divisibility</code>. Can be overridden
by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessorFast.size_divisibility",description:`<strong>size_divisibility</strong> (<code>&lt;class &apos;int&apos;&gt;.size_divisibility</code>, <em>optional</em>, defaults to 32) &#x2014;
The width and height of the image will be padded to be divisible by this number.`,name:"size_divisibility"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/image_processing_vitmatte_fast.py#L74"}}),re=new H({props:{name:"preprocess",anchor:"transformers.VitMatteImageProcessorFast.preprocess",parameters:[{name:"images",val:": list"},{name:"trimaps",val:": list"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.vitmatte.image_processing_vitmatte_fast.VitMatteFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>list</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.trimaps",description:`<strong>trimaps</strong> (<code>list</code>) &#x2014;
The trimaps to preprocess.`,name:"trimaps"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the width and height divisible by <code>size_divisibility</code>. Can be overridden
by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessorFast.preprocess.size_divisibility",description:`<strong>size_divisibility</strong> (<code>&lt;class &apos;int&apos;&gt;.size_divisibility</code>, <em>optional</em>, defaults to 32) &#x2014;
The width and height of the image will be padded to be divisible by this number.`,name:"size_divisibility"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/image_processing_vitmatte_fast.py#L88",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),ie=new ge({props:{title:"VitMatteForImageMatting",local:"transformers.VitMatteForImageMatting",headingTag:"h2"}}),ce=new H({props:{name:"class transformers.VitMatteForImageMatting",anchor:"transformers.VitMatteForImageMatting",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VitMatteForImageMatting.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/modeling_vitmatte.py#L214"}}),me=new H({props:{name:"forward",anchor:"transformers.VitMatteForImageMatting.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VitMatteForImageMatting.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VitMatteForImageMatting.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VitMatteForImageMatting.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VitMatteForImageMatting.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth image matting for computing the loss.`,name:"labels"},{anchor:"transformers.VitMatteForImageMatting.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/modeling_vitmatte.py#L230"}}),Z=new kt({props:{$$slots:{default:[Et]},$$scope:{ctx:F}}}),L=new Nt({props:{anchor:"transformers.VitMatteForImageMatting.forward.example",$$slots:{default:[qt]},$$scope:{ctx:F}}}),de=new Ht({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/vitmatte.md"}}),{c(){r=c("meta"),M=n(),l=c("p"),p=n(),g(v.$$.fragment),i=n(),T=c("div"),T.innerHTML=gt,xe=n(),g(S.$$.fragment),Ce=n(),D=c("p"),D.innerHTML=ft,ze=n(),E=c("p"),E.textContent=ht,Fe=n(),q=c("p"),q.innerHTML=ut,Pe=n(),B=c("p"),B.innerHTML=_t,Ue=n(),N=c("img"),ke=n(),X=c("small"),X.innerHTML=yt,Ne=n(),g(Y.$$.fragment),We=n(),Q=c("p"),Q.textContent=vt,Je=n(),O=c("ul"),O.innerHTML=Mt,je=n(),g(W.$$.fragment),Re=n(),g(A.$$.fragment),Ze=n(),w=c("div"),g(K.$$.fragment),Qe=n(),fe=c("p"),fe.innerHTML=Tt,Oe=n(),he=c("p"),he.innerHTML=wt,Ae=n(),g(J.$$.fragment),Ke=n(),j=c("div"),g(ee.$$.fragment),et=n(),ue=c("p"),ue.innerHTML=It,Le=n(),g(te.$$.fragment),Ge=n(),C=c("div"),g(oe.$$.fragment),tt=n(),_e=c("p"),_e.textContent=$t,ot=n(),R=c("div"),g(ae.$$.fragment),at=n(),be=c("p"),be.textContent=Vt,He=n(),g(ne.$$.fragment),Se=n(),z=c("div"),g(se.$$.fragment),nt=n(),ye=c("p"),ye.textContent=xt,st=n(),ve=c("div"),g(re.$$.fragment),De=n(),g(ie.$$.fragment),Ee=n(),I=c("div"),g(ce.$$.fragment),rt=n(),Me=c("p"),Me.textContent=Ct,it=n(),Te=c("p"),Te.innerHTML=zt,ct=n(),we=c("p"),we.innerHTML=Ft,mt=n(),x=c("div"),g(me.$$.fragment),dt=n(),Ie=c("p"),Ie.innerHTML=Pt,lt=n(),g(Z.$$.fragment),pt=n(),g(L.$$.fragment),qe=n(),g(de.$$.fragment),Be=n(),Ve=c("p"),this.h()},l(e){const t=Gt("svelte-u9bgzb",document.head);r=m(t,"META",{name:!0,content:!0}),t.forEach(o),M=s(e),l=m(e,"P",{}),U(l).forEach(o),p=s(e),f(v.$$.fragment,e),i=s(e),T=m(e,"DIV",{class:!0,"data-svelte-h":!0}),y(T)!=="svelte-13t8s2t"&&(T.innerHTML=gt),xe=s(e),f(S.$$.fragment,e),Ce=s(e),D=m(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1oupqpp"&&(D.innerHTML=ft),ze=s(e),E=m(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-vfdo9a"&&(E.textContent=ht),Fe=s(e),q=m(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-ejbjbx"&&(q.innerHTML=ut),Pe=s(e),B=m(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-cgl4x9"&&(B.innerHTML=_t),Ue=s(e),N=m(e,"IMG",{src:!0,alt:!0,width:!0}),ke=s(e),X=m(e,"SMALL",{"data-svelte-h":!0}),y(X)!=="svelte-htuduo"&&(X.innerHTML=yt),Ne=s(e),f(Y.$$.fragment,e),We=s(e),Q=m(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1h6mpjr"&&(Q.textContent=vt),Je=s(e),O=m(e,"UL",{"data-svelte-h":!0}),y(O)!=="svelte-v530fr"&&(O.innerHTML=Mt),je=s(e),f(W.$$.fragment,e),Re=s(e),f(A.$$.fragment,e),Ze=s(e),w=m(e,"DIV",{class:!0});var V=U(w);f(K.$$.fragment,V),Qe=s(V),fe=m(V,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-12czi7a"&&(fe.innerHTML=Tt),Oe=s(V),he=m(V,"P",{"data-svelte-h":!0}),y(he)!=="svelte-o55m63"&&(he.innerHTML=wt),Ae=s(V),f(J.$$.fragment,V),Ke=s(V),j=m(V,"DIV",{class:!0});var le=U(j);f(ee.$$.fragment,le),et=s(le),ue=m(le,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-f91b28"&&(ue.innerHTML=It),le.forEach(o),V.forEach(o),Le=s(e),f(te.$$.fragment,e),Ge=s(e),C=m(e,"DIV",{class:!0});var k=U(C);f(oe.$$.fragment,k),tt=s(k),_e=m(k,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-ohhgeg"&&(_e.textContent=$t),ot=s(k),R=m(k,"DIV",{class:!0});var pe=U(R);f(ae.$$.fragment,pe),at=s(pe),be=m(pe,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1x3yxsa"&&(be.textContent=Vt),pe.forEach(o),k.forEach(o),He=s(e),f(ne.$$.fragment,e),Se=s(e),z=m(e,"DIV",{class:!0});var $e=U(z);f(se.$$.fragment,$e),nt=s($e),ye=m($e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-87va8w"&&(ye.textContent=xt),st=s($e),ve=m($e,"DIV",{class:!0});var Ut=U(ve);f(re.$$.fragment,Ut),Ut.forEach(o),$e.forEach(o),De=s(e),f(ie.$$.fragment,e),Ee=s(e),I=m(e,"DIV",{class:!0});var P=U(I);f(ce.$$.fragment,P),rt=s(P),Me=m(P,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-hfzn9x"&&(Me.textContent=Ct),it=s(P),Te=m(P,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-6pahdo"&&(Te.innerHTML=zt),ct=s(P),we=m(P,"P",{"data-svelte-h":!0}),y(we)!=="svelte-hswkmf"&&(we.innerHTML=Ft),mt=s(P),x=m(P,"DIV",{class:!0});var G=U(x);f(me.$$.fragment,G),dt=s(G),Ie=m(G,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-frucsj"&&(Ie.innerHTML=Pt),lt=s(G),f(Z.$$.fragment,G),pt=s(G),f(L.$$.fragment,G),G.forEach(o),P.forEach(o),qe=s(e),f(de.$$.fragment,e),Be=s(e),Ve=m(e,"P",{}),U(Ve).forEach(o),this.h()},h(){$(r,"name","hf:doc:metadata"),$(r,"content",Xt),$(T,"class","flex flex-wrap space-x-1"),jt(N.src,bt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/vitmatte_architecture.png")||$(N,"src",bt),$(N,"alt","drawing"),$(N,"width","600"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,r),a(e,M,t),a(e,l,t),a(e,p,t),h(v,e,t),a(e,i,t),a(e,T,t),a(e,xe,t),h(S,e,t),a(e,Ce,t),a(e,D,t),a(e,ze,t),a(e,E,t),a(e,Fe,t),a(e,q,t),a(e,Pe,t),a(e,B,t),a(e,Ue,t),a(e,N,t),a(e,ke,t),a(e,X,t),a(e,Ne,t),h(Y,e,t),a(e,We,t),a(e,Q,t),a(e,Je,t),a(e,O,t),a(e,je,t),h(W,e,t),a(e,Re,t),h(A,e,t),a(e,Ze,t),a(e,w,t),h(K,w,null),d(w,Qe),d(w,fe),d(w,Oe),d(w,he),d(w,Ae),h(J,w,null),d(w,Ke),d(w,j),h(ee,j,null),d(j,et),d(j,ue),a(e,Le,t),h(te,e,t),a(e,Ge,t),a(e,C,t),h(oe,C,null),d(C,tt),d(C,_e),d(C,ot),d(C,R),h(ae,R,null),d(R,at),d(R,be),a(e,He,t),h(ne,e,t),a(e,Se,t),a(e,z,t),h(se,z,null),d(z,nt),d(z,ye),d(z,st),d(z,ve),h(re,ve,null),a(e,De,t),h(ie,e,t),a(e,Ee,t),a(e,I,t),h(ce,I,null),d(I,rt),d(I,Me),d(I,it),d(I,Te),d(I,ct),d(I,we),d(I,mt),d(I,x),h(me,x,null),d(x,dt),d(x,Ie),d(x,lt),h(Z,x,null),d(x,pt),h(L,x,null),a(e,qe,t),h(de,e,t),a(e,Be,t),a(e,Ve,t),Xe=!0},p(e,[t]){const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),W.$set(V);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),J.$set(le);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),Z.$set(k);const pe={};t&2&&(pe.$$scope={dirty:t,ctx:e}),L.$set(pe)},i(e){Xe||(u(v.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(W.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(J.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(Z.$$.fragment,e),u(L.$$.fragment,e),u(de.$$.fragment,e),Xe=!0)},o(e){_(v.$$.fragment,e),_(S.$$.fragment,e),_(Y.$$.fragment,e),_(W.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(J.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(Z.$$.fragment,e),_(L.$$.fragment,e),_(de.$$.fragment,e),Xe=!1},d(e){e&&(o(M),o(l),o(p),o(i),o(T),o(xe),o(Ce),o(D),o(ze),o(E),o(Fe),o(q),o(Pe),o(B),o(Ue),o(N),o(ke),o(X),o(Ne),o(We),o(Q),o(Je),o(O),o(je),o(Re),o(Ze),o(w),o(Le),o(Ge),o(C),o(He),o(Se),o(z),o(De),o(Ee),o(I),o(qe),o(Be),o(Ve)),o(r),b(v,e),b(S,e),b(Y,e),b(W,e),b(A,e),b(K),b(J),b(ee),b(te,e),b(oe),b(ae),b(ne,e),b(se),b(re),b(ie,e),b(ce),b(me),b(Z),b(L),b(de,e)}}}const Xt='{"title":"ViTMatte","local":"vitmatte","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"VitMatteConfig","local":"transformers.VitMatteConfig","sections":[],"depth":2},{"title":"VitMatteImageProcessor","local":"transformers.VitMatteImageProcessor","sections":[],"depth":2},{"title":"VitMatteImageProcessorFast","local":"transformers.VitMatteImageProcessorFast","sections":[],"depth":2},{"title":"VitMatteForImageMatting","local":"transformers.VitMatteForImageMatting","sections":[],"depth":2}],"depth":1}';function Yt(F){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class no extends Zt{constructor(r){super(),Lt(this,r,Yt,Bt,Jt,{})}}export{no as component};
