import{s as Tt,n as Ut,o as Jt}from"../chunks/scheduler.18a86fab.js";import{S as gt,i as Zt,g as o,s as a,r as p,A as Gt,h as i,f as e,c as l,j as bt,u as r,x as u,k as jt,y as _t,a as s,v as c,d as m,t as d,w as y}from"../chunks/index.98837b22.js";import{C as N}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as V}from"../chunks/Heading.7e7e0c5b.js";import{E as Bt}from"../chunks/index.92f616ba.js";function It(rt){let M,E,F,H,h,Y,w,ct=`This page describes how to use the <code>AttentionInterface</code> in order to register custom attention functions to use with
supported models.`,A,f,S,b,mt=`Most recent models can now switch from one attention function used in the Attention layer to the other, thanks to a simple mapping.
By default, we provide the implementation for <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>sdpa</code></a>,
<a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow"><code>flash_attention_2</code></a> and <a href="https://pytorch.org/docs/stable/nn.attention.flex_attention.html#module-torch.nn.attention.flex_attention" rel="nofollow"><code>flex_attention</code></a>
as well as <code>eager</code>, which is a simple matrix multiplication without any optimization on top.<br/>
This is the setting you can usually choose when instantiating a model:`,Q,j,z,T,dt=`But what if you wanted to create your own attention function? Or simply play around with existing ones, adding
a few statements here and there? You can now do so with the <code>AttentionInterface</code>! Here is an example:`,L,U,x,J,yt="You will see it prints “I just entered the attention computation” as many times as there are layers in the model (with this example, 16 times).",q,g,O,Z,Mt="You could dynamically change the model’s attention function as well, by overriding the <code>config._attn_implementation</code> field:",K,G,D,_,ut=`and it will stop printing the statements, as it now uses the <code>sdpa</code> attention.<br/>
This allows to quickly change an attention function, without needing to reload the model!`,P,B,tt,I,ht=`But indeed, what if the new function requires a new arg to be properly used? It’s no issue! Models supporting the
<code>AttentionInterface</code> propagate kwargs all the way to the Attention layers, and to the used attention function. That way,
you can simply pass the arg (as a kwargs, i.e. you need to qualify the name of the arg) in the model’s forward, and it will be correctly used in the attention. However, custom attention functions have some limitations. In particular, it must follow the signature and return format of other attention functions, i.e.`,nt,R,et,k,wt='If in doubt about what args/kwargs a given model sends to the attention function, simply check that model’s modeling code on <a href="https://github.com/huggingface/transformers/tree/main/src/transformers/models" rel="nofollow">GitHub</a>!',st,C,at,W,ft=`Most of the time, you will simply need to <code>register</code> a new function. If, however, you need to access an existing one,
and/or perform a few checks, the preferred way is to use the global <code>ALL_ATTENTION_FUNCTIONS</code>. It behaves the same way you
would expect from a usual Python dictionary:`,lt,v,ot,$,it,X,pt;return h=new V({props:{title:"Attention Interface",local:"attention-interface",headingTag:"h1"}}),f=new V({props:{title:"Customizing attention function",local:"customizing-attention-function",headingTag:"h2"}}),j=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTFCJTIyJTBBJTBBJTIzJTIwSGVyZSUyQyUyMHVzaW5nJTIwZmxhc2glMjBhdHRlbnRpb24lMjBhcyUyMGFuJTIwZXhhbXBsZSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>

<span class="hljs-comment"># Here, using flash attention as an example</span>
model = AutoModelForCausalLM.from_pretrained(model_id, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)`,wrap:!1}}),U=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXR0ZW50aW9uSW50ZXJmYWNlJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24lMjBpbXBvcnQlMjBzZHBhX2F0dGVudGlvbl9mb3J3YXJkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItMUIlMjIlMEElMEFkZWYlMjBteV9uZXdfc2RwYSgqYXJncyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkklMjBqdXN0JTIwZW50ZXJlZCUyMHRoZSUyMGF0dGVudGlvbiUyMGNvbXB1dGF0aW9uJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNkcGFfYXR0ZW50aW9uX2ZvcndhcmQoKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMEFBdHRlbnRpb25JbnRlcmZhY2UucmVnaXN0ZXIoJTIybXlfbmV3X3NkcGElMjIlMkMlMjBteV9uZXdfc2RwYSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJteV9uZXdfc2RwYSUyMiklMEElMjMlMjBUcnklMjBydW5uaW5nJTIwdGhlJTIwZm9yd2FyZCUyMHdpdGglMjB0aGUlMjBuZXclMjBhdHRlbnRpb24lMjBmdW5jdGlvbiUwQW1vZGVsKHRvcmNoLm9uZXMoMSUyQyUyMDUlMkMlMjBkdHlwZSUzRGludCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AttentionInterface
<span class="hljs-keyword">from</span> transformers.integrations.sdpa_attention <span class="hljs-keyword">import</span> sdpa_attention_forward
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_new_sdpa</span>(<span class="hljs-params">*args, **kwargs</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;I just entered the attention computation&quot;</span>)
    <span class="hljs-keyword">return</span> sdpa_attention_forward(*args, **kwargs)

AttentionInterface.register(<span class="hljs-string">&quot;my_new_sdpa&quot;</span>, my_new_sdpa)

model = AutoModelForCausalLM.from_pretrained(model_id, attn_implementation=<span class="hljs-string">&quot;my_new_sdpa&quot;</span>)
<span class="hljs-comment"># Try running the forward with the new attention function</span>
model(torch.ones(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, dtype=<span class="hljs-built_in">int</span>))`,wrap:!1}}),g=new V({props:{title:"Dynamically switching attention function",local:"dynamically-switching-attention-function",headingTag:"h2"}}),G=new N({props:{code:"JTIzJTIwQmFjayUyMHRvJTIwdXNlJTIwb3JpZ2luYWwlMjBzZHBhJTIwaW1wbGVtZW50YXRpb24lMEFtb2RlbC5jb25maWcuX2F0dG5faW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzZHBhJTIyJTBBJTBBbW9kZWwodG9yY2gub25lcygxJTJDJTIwNSUyQyUyMGR0eXBlJTNEaW50KSk=",highlighted:`<span class="hljs-comment"># Back to use original sdpa implementation</span>
model.config._attn_implementation = <span class="hljs-string">&quot;sdpa&quot;</span>

model(torch.ones(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, dtype=<span class="hljs-built_in">int</span>))`,wrap:!1}}),B=new V({props:{title:"What about new args needed in my custom attention function?",local:"what-about-new-args-needed-in-my-custom-attention-function",headingTag:"h2"}}),R=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXR0ZW50aW9uSW50ZXJmYWNlJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24lMjBpbXBvcnQlMjBzZHBhX2F0dGVudGlvbl9mb3J3YXJkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjdXN0b21fYXR0ZW50aW9uKCUwQSUyMCUyMCUyMCUyMG1vZHVsZSUzQSUyMHRvcmNoLm5uLk1vZHVsZSUyQyUyMCUyMCUyMyUyMHJlcXVpcmVkJTIwYXJnJTBBJTIwJTIwJTIwJTIwcXVlcnklM0ElMjB0b3JjaC5UZW5zb3IlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGtleSUzQSUyMHRvcmNoLlRlbnNvciUyQyUyMCUyMCUyMyUyMHJlcXVpcmVkJTIwYXJnJTBBJTIwJTIwJTIwJTIwdmFsdWUlM0ElMjB0b3JjaC5UZW5zb3IlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTNBJTIwT3B0aW9uYWwlNUJ0b3JjaC5UZW5zb3IlNUQlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGFfbmV3X2t3YXJncyUyMCUzRCUyME5vbmUlMkMlMjAlMjAlMjMlMjBZb3UlMjBjYW4lMjBub3clMjBhZGQlMjBhcyUyMG1hbnklMjBrd2FyZ3MlMjBhcyUyMHlvdSUyMG5lZWQlMEElMjAlMjAlMjAlMjBhbm90aGVyX25ld19rd2FyZ3MlMjAlM0QlMjBOb25lJTJDJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwbm93JTIwYWRkJTIwYXMlMjBtYW55JTIwa3dhcmdzJTIwYXMlMjB5b3UlMjBuZWVkJTBBJTIwJTIwJTIwJTIwKiprd2FyZ3MlMkMlMjAlMjAlMjMlMjBZb3UlMjBuZWVkJTIwdG8lMjBhY2NlcHQlMjAqKmt3YXJncyUyMGFzJTIwbW9kZWxzJTIwd2lsbCUyMHBhc3MlMjBvdGhlciUyMGFyZ3MlMEEpJTIwLSUzRSUyMFR1cGxlJTVCdG9yY2guVGVuc29yJTJDJTIwT3B0aW9uYWwlNUJ0b3JjaC5UZW5zb3IlNUQlNUQlMEElMjAlMjAlMjAlMjAuLi4lMjAlMjAlMjMlMjBkbyUyMHlvdXIlMjBtYWdpYyElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhdHRuX291dHB1dCUyQyUyMGF0dG5fd2VpZ2h0cyUyMCUyMCUyMyUyMGF0dG5fd2VpZ2h0cyUyMGFyZSUyMG9wdGlvbmFsJTIwaGVyZSUwQSUwQUF0dGVudGlvbkludGVyZmFjZS5yZWdpc3RlciglMjJjdXN0b20lMjIlMkMlMjBjdXN0b21fYXR0ZW50aW9uKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmN1c3RvbSUyMiklMEElMjMlMjBGb3J3YXJkJTIwcGFzcyUyMHdpdGglMjB0aGUlMjBuZXclMjBrd2FyZ3MlMEFtb2RlbCh0b3JjaC5vbmVzKDElMkMlMjA1JTJDJTIwZHR5cGUlM0RpbnQpJTJDJTIwYV9uZXdfa3dhcmdzJTNELi4uJTJDJTIwYW5vdGhlcl9uZXdfa3dhcmdzJTNELi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AttentionInterface
<span class="hljs-keyword">from</span> transformers.integrations.sdpa_attention <span class="hljs-keyword">import</span> sdpa_attention_forward
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_attention</span>(<span class="hljs-params">
    module: torch.nn.Module,  <span class="hljs-comment"># required arg</span>
    query: torch.Tensor,  <span class="hljs-comment"># required arg</span>
    key: torch.Tensor,  <span class="hljs-comment"># required arg</span>
    value: torch.Tensor,  <span class="hljs-comment"># required arg</span>
    attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor],  <span class="hljs-comment"># required arg</span>
    a_new_kwargs = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># You can now add as many kwargs as you need</span>
    another_new_kwargs = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># You can now add as many kwargs as you need</span>
    **kwargs,  <span class="hljs-comment"># You need to accept **kwargs as models will pass other args</span>
</span>) -&gt; <span class="hljs-type">Tuple</span>[torch.Tensor, <span class="hljs-type">Optional</span>[torch.Tensor]]
    ...  <span class="hljs-comment"># do your magic!</span>
    <span class="hljs-keyword">return</span> attn_output, attn_weights  <span class="hljs-comment"># attn_weights are optional here</span>

AttentionInterface.register(<span class="hljs-string">&quot;custom&quot;</span>, custom_attention)

model = AutoModelForCausalLM.from_pretrained(model_id, attn_implementation=<span class="hljs-string">&quot;custom&quot;</span>)
<span class="hljs-comment"># Forward pass with the new kwargs</span>
model(torch.ones(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, dtype=<span class="hljs-built_in">int</span>), a_new_kwargs=..., another_new_kwargs=...)`,wrap:!1}}),C=new V({props:{title:"Accessing current available implementations",local:"accessing-current-available-implementations",headingTag:"h2"}}),v=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ191dGlscyUyMGltcG9ydCUyMEFMTF9BVFRFTlRJT05fRlVOQ1RJT05TJTBBJTBBbGlzdChBTExfQVRURU5USU9OX0ZVTkNUSU9OUy5rZXlzKCkpJTBBJTVCJ2ZsYXNoX2F0dGVudGlvbl8yJyUyQyUyMCdmbGV4X2F0dGVudGlvbiclMkMlMjAnc2RwYSclNUQlMEElMEFBTExfQVRURU5USU9OX0ZVTkNUSU9OUyU1QiUyMnNkcGElMjIlNUQlMEElM0NmdW5jdGlvbiUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24uc2RwYV9hdHRlbnRpb25fZm9yd2FyZCUzRSUwQSUwQUFMTF9BVFRFTlRJT05fRlVOQ1RJT05TLmdldCglMjJzZHBhJTIyJTJDJTIwTm9uZSklMEElM0NmdW5jdGlvbiUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24uc2RwYV9hdHRlbnRpb25fZm9yd2FyZCUzRSUwQSUwQUFMTF9BVFRFTlRJT05fRlVOQ1RJT05TLnJlZ2lzdGVyKCUyMm5ld19mdW5jJTIyJTJDJTIwbmV3X2Z1bmMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.modeling_utils <span class="hljs-keyword">import</span> ALL_ATTENTION_FUNCTIONS

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(ALL_ATTENTION_FUNCTIONS.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span>[<span class="hljs-string">&#x27;flash_attention_2&#x27;</span>, <span class="hljs-string">&#x27;flex_attention&#x27;</span>, <span class="hljs-string">&#x27;sdpa&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_ATTENTION_FUNCTIONS[<span class="hljs-string">&quot;sdpa&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>&lt;function transformers.integrations.sdpa_attention.sdpa_attention_forward&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_ATTENTION_FUNCTIONS.get(<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>&lt;function transformers.integrations.sdpa_attention.sdpa_attention_forward&gt;

<span class="hljs-comment"># You can also globally \`register\` a new function directly on it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_ATTENTION_FUNCTIONS.register(<span class="hljs-string">&quot;new_func&quot;</span>, new_func)`,wrap:!1}}),$=new Bt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/attention_interface.md"}}),{c(){M=o("meta"),E=a(),F=o("p"),H=a(),p(h.$$.fragment),Y=a(),w=o("p"),w.innerHTML=ct,A=a(),p(f.$$.fragment),S=a(),b=o("p"),b.innerHTML=mt,Q=a(),p(j.$$.fragment),z=a(),T=o("p"),T.innerHTML=dt,L=a(),p(U.$$.fragment),x=a(),J=o("p"),J.textContent=yt,q=a(),p(g.$$.fragment),O=a(),Z=o("p"),Z.innerHTML=Mt,K=a(),p(G.$$.fragment),D=a(),_=o("p"),_.innerHTML=ut,P=a(),p(B.$$.fragment),tt=a(),I=o("p"),I.innerHTML=ht,nt=a(),p(R.$$.fragment),et=a(),k=o("p"),k.innerHTML=wt,st=a(),p(C.$$.fragment),at=a(),W=o("p"),W.innerHTML=ft,lt=a(),p(v.$$.fragment),ot=a(),p($.$$.fragment),it=a(),X=o("p"),this.h()},l(t){const n=Gt("svelte-u9bgzb",document.head);M=i(n,"META",{name:!0,content:!0}),n.forEach(e),E=l(t),F=i(t,"P",{}),bt(F).forEach(e),H=l(t),r(h.$$.fragment,t),Y=l(t),w=i(t,"P",{"data-svelte-h":!0}),u(w)!=="svelte-q2swd"&&(w.innerHTML=ct),A=l(t),r(f.$$.fragment,t),S=l(t),b=i(t,"P",{"data-svelte-h":!0}),u(b)!=="svelte-tb8yar"&&(b.innerHTML=mt),Q=l(t),r(j.$$.fragment,t),z=l(t),T=i(t,"P",{"data-svelte-h":!0}),u(T)!=="svelte-6n784k"&&(T.innerHTML=dt),L=l(t),r(U.$$.fragment,t),x=l(t),J=i(t,"P",{"data-svelte-h":!0}),u(J)!=="svelte-seluzu"&&(J.textContent=yt),q=l(t),r(g.$$.fragment,t),O=l(t),Z=i(t,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-avcttm"&&(Z.innerHTML=Mt),K=l(t),r(G.$$.fragment,t),D=l(t),_=i(t,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1fjssz0"&&(_.innerHTML=ut),P=l(t),r(B.$$.fragment,t),tt=l(t),I=i(t,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1mzkqc4"&&(I.innerHTML=ht),nt=l(t),r(R.$$.fragment,t),et=l(t),k=i(t,"P",{"data-svelte-h":!0}),u(k)!=="svelte-upb3ef"&&(k.innerHTML=wt),st=l(t),r(C.$$.fragment,t),at=l(t),W=i(t,"P",{"data-svelte-h":!0}),u(W)!=="svelte-7h0zcj"&&(W.innerHTML=ft),lt=l(t),r(v.$$.fragment,t),ot=l(t),r($.$$.fragment,t),it=l(t),X=i(t,"P",{}),bt(X).forEach(e),this.h()},h(){jt(M,"name","hf:doc:metadata"),jt(M,"content",Rt)},m(t,n){_t(document.head,M),s(t,E,n),s(t,F,n),s(t,H,n),c(h,t,n),s(t,Y,n),s(t,w,n),s(t,A,n),c(f,t,n),s(t,S,n),s(t,b,n),s(t,Q,n),c(j,t,n),s(t,z,n),s(t,T,n),s(t,L,n),c(U,t,n),s(t,x,n),s(t,J,n),s(t,q,n),c(g,t,n),s(t,O,n),s(t,Z,n),s(t,K,n),c(G,t,n),s(t,D,n),s(t,_,n),s(t,P,n),c(B,t,n),s(t,tt,n),s(t,I,n),s(t,nt,n),c(R,t,n),s(t,et,n),s(t,k,n),s(t,st,n),c(C,t,n),s(t,at,n),s(t,W,n),s(t,lt,n),c(v,t,n),s(t,ot,n),c($,t,n),s(t,it,n),s(t,X,n),pt=!0},p:Ut,i(t){pt||(m(h.$$.fragment,t),m(f.$$.fragment,t),m(j.$$.fragment,t),m(U.$$.fragment,t),m(g.$$.fragment,t),m(G.$$.fragment,t),m(B.$$.fragment,t),m(R.$$.fragment,t),m(C.$$.fragment,t),m(v.$$.fragment,t),m($.$$.fragment,t),pt=!0)},o(t){d(h.$$.fragment,t),d(f.$$.fragment,t),d(j.$$.fragment,t),d(U.$$.fragment,t),d(g.$$.fragment,t),d(G.$$.fragment,t),d(B.$$.fragment,t),d(R.$$.fragment,t),d(C.$$.fragment,t),d(v.$$.fragment,t),d($.$$.fragment,t),pt=!1},d(t){t&&(e(E),e(F),e(H),e(Y),e(w),e(A),e(S),e(b),e(Q),e(z),e(T),e(L),e(x),e(J),e(q),e(O),e(Z),e(K),e(D),e(_),e(P),e(tt),e(I),e(nt),e(et),e(k),e(st),e(at),e(W),e(lt),e(ot),e(it),e(X)),e(M),y(h,t),y(f,t),y(j,t),y(U,t),y(g,t),y(G,t),y(B,t),y(R,t),y(C,t),y(v,t),y($,t)}}}const Rt='{"title":"Attention Interface","local":"attention-interface","sections":[{"title":"Customizing attention function","local":"customizing-attention-function","sections":[],"depth":2},{"title":"Dynamically switching attention function","local":"dynamically-switching-attention-function","sections":[],"depth":2},{"title":"What about new args needed in my custom attention function?","local":"what-about-new-args-needed-in-my-custom-attention-function","sections":[],"depth":2},{"title":"Accessing current available implementations","local":"accessing-current-available-implementations","sections":[],"depth":2}],"depth":1}';function kt(rt){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends gt{constructor(M){super(),Zt(this,M,kt,It,Tt,{})}}export{Xt as component};
