import{s as Zt,o as Wt,n as At}from"../chunks/scheduler.bdbef820.js";import{S as Ot,i as xt,g as r,s,r as p,A as Ht,h as o,f as l,c as a,j as St,u as U,x as i,k as Nt,y as Ft,a as n,v as m,d as M,t as c,w as T}from"../chunks/index.33f81d56.js";import{T as zt}from"../chunks/Tip.34194030.js";import{C as Me}from"../chunks/CodeBlock.3bad7fc9.js";import{H as h,E as Dt}from"../chunks/index.9edc4842.js";function Xt(Te){let d,y=`TorchScript를 활용한 실험은 아직 초기 단계로, 가변적인 입력 크기 모델들을 통해 그 기능성을 계속 탐구하고 있습니다.
이 기능은 저희가 관심을 두고 있는 분야 중 하나이며,
앞으로 출시될 버전에서 더 많은 코드 예제, 더 유연한 구현, 그리고 Python 기반 코드와 컴파일된 TorchScript를 비교하는 벤치마크를 등을 통해 분석을 심화할 예정입니다.`;return{c(){d=r("p"),d.textContent=y},l(J){d=o(J,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1mebeqz"&&(d.textContent=y)},m(J,me){n(J,d,me)},p:At,d(J){J&&l(d)}}}function Lt(Te){let d,y,J,me,u,de,f,Je,Q,it='<a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">TorchScript 문서</a>에서는 이렇게 말합니다.',he,C,pt="<p>TorchScript는 PyTorch 코드에서 직렬화 및 최적화 가능한 모델을 생성하는 방법입니다.</p>",fe,j,Ut='<a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">JIT과 TRACE</a>는 개발자가 모델을 내보내서 효율 지향적인 C++ 프로그램과 같은 다른 프로그램에서 재사용할 수 있도록 하는 PyTorch 모듈입니다.',ye,g,mt=`PyTorch 기반 Python 프로그램과 다른 환경에서 모델을 재사용할 수 있도록, 🤗 Transformers 모델을 TorchScript로 내보낼 수 있는 인터페이스를 제공합니다.
이 문서에서는 TorchScript를 사용하여 모델을 내보내고 사용하는 방법을 설명합니다.`,ue,b,Mt="모델을 내보내려면 두 가지가 필요합니다:",Qe,$,ct="<li><code>torchscript</code> 플래그로 모델 인스턴스화</li> <li>더미 입력을 사용한 순전파(forward pass)</li>",Ce,w,Tt="이 필수 조건들은 아래에 자세히 설명된 것처럼 개발자들이 주의해야 할 여러 사항들을 의미합니다.",je,V,ge,R,dt=`<code>torchscript</code> 플래그가 필요한 이유는 대부분의 🤗 Transformers 언어 모델에서 <code>Embedding</code> 레이어와 <code>Decoding</code> 레이어 간의 묶인 가중치(tied weights)가 존재하기 때문입니다.
TorchScript는 묶인 가중치를 가진 모델을 내보낼 수 없으므로, 미리 가중치를 풀고 복제해야 합니다.`,be,E,Jt=`<code>torchscript</code> 플래그로 인스턴스화된 모델은 <code>Embedding</code> 레이어와 <code>Decoding</code> 레이어가 분리되어 있으므로 이후에 훈련해서는 안 됩니다.
훈련을 하게 되면 두 레이어 간 동기화가 해제되어 예상치 못한 결과가 발생할 수 있습니다.`,$e,k,ht=`언어 모델 헤드를 갖지 않은 모델은 가중치가 묶여 있지 않아서 이 문제가 발생하지 않습니다.
이러한 모델들은 <code>torchscript</code> 플래그 없이 안전하게 내보낼 수 있습니다.`,we,_,Ve,B,ft=`더미 입력(dummy inputs)은 모델의 순전파(forward pass)에 사용됩니다.
입력 값이 레이어를 통해 전파되는 동안, PyTorch는 각 텐서에서 실행된 다른 연산을 추적합니다.
이러한 기록된 연산은 모델의 <em>추적(trace)</em>을 생성하는 데 사용됩니다.`,Re,I,yt=`추적은 입력의 차원을 기준으로 생성됩니다.
따라서 더미 입력의 차원에 제한되어, 다른 시퀀스 길이나 배치 크기에서는 작동하지 않습니다.
다른 크기로 시도할 경우 다음과 같은 오류가 발생합니다:`,Ee,v,ke,S,ut=`추론 중 모델에 공급될 가장 큰 입력만큼 큰 더미 입력 크기로 모델을 추적하는 것이 좋습니다.
패딩은 누락된 값을 채우는 데 도움이 될 수 있습니다.
그러나 모델이 더 큰 입력 크기로 추적되기 때문에, 행렬의 차원이 커지고 계산량이 많아집니다.`,_e,N,Qt="다양한 시퀀스 길이 모델을 내보낼 때는 각 입력에 대해 수행되는 총 연산 횟수에 주의하고 성능을 주의 깊게 확인하세요.",Be,Z,Ie,W,Ct="이 섹션에서는 모델을 저장하고 가져오는 방법, 추적을 사용하여 추론하는 방법을 보여줍니다.",ve,A,Se,O,jt="<code>BertModel</code>을 TorchScript로 내보내려면 <code>BertConfig</code> 클래스에서 <code>BertModel</code>을 인스턴스화한 다음, <code>traced_bert.pt</code>라는 파일명으로 디스크에 저장하면 됩니다.",Ne,x,Ze,H,We,F,gt="이제 이전에 저장한 <code>BertModel</code>, 즉 <code>traced_bert.pt</code>를 디스크에서 가져오고, 이전에 초기화한 <code>dummy_input</code>에서 사용할 수 있습니다.",Ae,z,Oe,D,xe,X,bt="<code>__call__</code> 이중 언더스코어(dunder) 메소드를 사용하여 추론에 추적된 모델을 사용하세요:",He,L,Fe,G,ze,P,$t=`AWS가 클라우드에서 저비용, 고성능 머신 러닝 추론을 위한 <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">Amazon EC2 Inf1</a> 인스턴스 제품군을 출시했습니다.
Inf1 인스턴스는 딥러닝 추론 워크로드에 특화된 맞춤 하드웨어 가속기인 AWS Inferentia 칩으로 구동됩니다.
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/#" rel="nofollow">AWS Neuron</a>은 Inferentia를 위한 SDK로, Inf1에 배포하기 위한 transformers 모델 추적 및 최적화를 지원합니다.
Neuron SDK는 다음과 같은 기능을 제공합니다:`,De,Y,wt='<li>코드 한 줄만 변경하면 클라우드 추론를 위해 TorchScript 모델을 추적하고 최적화할 수 있는 쉬운 API</li> <li>즉시 사용 가능한 성능 최적화로 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/benchmark/%3E" rel="nofollow">비용 효율 향상</a></li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/bert_tutorial/tutorial_pretrained_bert.html" rel="nofollow">PyTorch</a> 또는 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/tensorflow/huggingface_bert/huggingface_bert.html" rel="nofollow">TensorFlow</a>로 구축된 Hugging Face transformers 모델 지원</li>',Xe,K,Le,q,Vt=`<a href="https://huggingface.co/docs/transformers/main/model_doc/bert" rel="nofollow">BERT (Bidirectional Encoder Representations from Transformers)</a> 아키텍처 또는 그 변형인 <a href="https://huggingface.co/docs/transformers/main/model_doc/distilbert" rel="nofollow">distilBERT</a> 및 <a href="https://huggingface.co/docs/transformers/main/model_doc/roberta" rel="nofollow">roBERTa</a>를 기반으로 한 Transformers 모델은 추출 기반 질의응답, 시퀀스 분류 및 토큰 분류와 같은 비생성 작업 시 Inf1에서 최상의 성능을 보입니다.
그러나 텍스트 생성 작업도 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/transformers-marianmt.html" rel="nofollow">AWS Neuron MarianMT 튜토리얼</a>을 따라 Inf1에서 실행되도록 조정할 수 있습니다.`,Ge,ee,Rt='Inferentia에서 바로 변환할 수 있는 모델에 대한 자세한 정보는 Neuron 문서의 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/models/models-inferentia.html#models-inferentia" rel="nofollow">Model Architecture Fit</a> 섹션에서 확인할 수 있습니다.',Pe,te,Ye,le,Et=`AWS Neuron을 사용하여 모델을 변환하려면 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/neuron-frameworks/pytorch-neuron/index.html#installation-guide" rel="nofollow">Neuron SDK 환경</a>이 필요합니다.
이는 <a href="https://docs.aws.amazon.com/dlami/latest/devguide/tutorial-inferentia-launching.html" rel="nofollow">AWS Deep Learning AMI</a>에 미리 구성되어 있습니다.`,Ke,ne,qe,se,kt=`<code>BertModel</code>을 추적하려면, <a href="torchscript#using-torchscript-in-python">Python에서 TorchScript 사용하기</a>에서와 동일한 코드를 사용해서 AWS NEURON용 모델을 변환합니다.
<code>torch.neuron</code> 프레임워크 익스텐션을 가져와 Python API를 통해 Neuron SDK의 구성 요소에 접근합니다:`,et,ae,tt,re,_t="다음 줄만 수정하면 됩니다:",lt,oe,nt,ie,Bt="이로써 Neuron SDK가 모델을 추적하고 Inf1 인스턴스에 최적화할 수 있게 됩니다.",st,pe,It='AWS Neuron SDK의 기능, 도구, 예제 튜토리얼 및 최신 업데이트에 대해 자세히 알아보려면 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/index.html" rel="nofollow">AWS NeuronSDK 문서</a>를 참조하세요.',at,Ue,rt,ce,ot;return u=new h({props:{title:"TorchScript로 내보내기",local:"export-to-torchscript",headingTag:"h1"}}),f=new zt({props:{$$slots:{default:[Xt]},$$scope:{ctx:Te}}}),V=new h({props:{title:"TorchScript 플래그와 묶인 가중치(tied weights)",local:"torchscript-flag-and-tied-weights",headingTag:"h2"}}),_=new h({props:{title:"더미 입력과 표준 길이",local:"dummy-inputs-and-standard-lengths",headingTag:"h2"}}),v=new Me({props:{code:"JTYwVGhlJTIwZXhwYW5kZWQlMjBzaXplJTIwb2YlMjB0aGUlMjB0ZW5zb3IlMjAoMyklMjBtdXN0JTIwbWF0Y2glMjB0aGUlMjBleGlzdGluZyUyMHNpemUlMjAoNyklMjBhdCUyMG5vbi1zaW5nbGV0b24lMjBkaW1lbnNpb24lMjAyJTYw",highlighted:'`The expanded <span class="hljs-built_in">size</span> of the tensor (<span class="hljs-number">3</span>) must match the existing <span class="hljs-built_in">size</span> (<span class="hljs-number">7</span>) at non-singleton <span class="hljs-keyword">dimension</span> <span class="hljs-number">2</span>`',wrap:!1}}),Z=new h({props:{title:"Python에서 TorchScript 사용하기",local:"using-torchscript-in-python",headingTag:"h2"}}),A=new h({props:{title:"모델 저장하기",local:"saving-a-model",headingTag:"h3"}}),x=new Me({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch

enc = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-comment"># 입력 텍스트 토큰화하기</span>
text = <span class="hljs-string">&quot;[CLS] Who was Jim Henson ? [SEP] Jim Henson was a puppeteer [SEP]&quot;</span>
tokenized_text = enc.tokenize(text)

<span class="hljs-comment"># 입력 토큰 중 하나를 마스킹하기</span>
masked_index = <span class="hljs-number">8</span>
tokenized_text[masked_index] = <span class="hljs-string">&quot;[MASK]&quot;</span>
indexed_tokens = enc.convert_tokens_to_ids(tokenized_text)
segments_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]

<span class="hljs-comment"># 더미 입력 만들기</span>
tokens_tensor = torch.tensor([indexed_tokens])
segments_tensors = torch.tensor([segments_ids])
dummy_input = [tokens_tensor, segments_tensors]

<span class="hljs-comment"># torchscript 플래그로 모델 초기화하기</span>
<span class="hljs-comment"># 이 모델은 LM 헤드가 없으므로 필요하지 않지만, 플래그를 True로 설정합니다.</span>
config = BertConfig(
    vocab_size_or_config_json_file=<span class="hljs-number">32000</span>,
    hidden_size=<span class="hljs-number">768</span>,
    num_hidden_layers=<span class="hljs-number">12</span>,
    num_attention_heads=<span class="hljs-number">12</span>,
    intermediate_size=<span class="hljs-number">3072</span>,
    torchscript=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># 모델을 인스턴트화하기</span>
model = BertModel(config)

<span class="hljs-comment"># 모델을 평가 모드로 두어야 합니다.</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># 만약 *from_pretrained*를 사용하여 모델을 인스턴스화하는 경우, TorchScript 플래그를 쉽게 설정할 수 있습니다</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, torchscript=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 추적 생성하기</span>
traced_model = torch.jit.trace(model, [tokens_tensor, segments_tensors])
torch.jit.save(traced_model, <span class="hljs-string">&quot;traced_bert.pt&quot;</span>)`,wrap:!1}}),H=new h({props:{title:"모델 가져오기",local:"loading-a-model",headingTag:"h3"}}),z=new Me({props:{code:"bG9hZGVkX21vZGVsJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydHJhY2VkX2JlcnQucHQlMjIpJTBBbG9hZGVkX21vZGVsLmV2YWwoKSUwQSUwQWFsbF9lbmNvZGVyX2xheWVycyUyQyUyMHBvb2xlZF9vdXRwdXQlMjAlM0QlMjBsb2FkZWRfbW9kZWwoKmR1bW15X2lucHV0KQ==",highlighted:`loaded_model = torch.jit.load(<span class="hljs-string">&quot;traced_bert.pt&quot;</span>)
loaded_model.<span class="hljs-built_in">eval</span>()

all_encoder_layers, pooled_output = loaded_model(*dummy_input)`,wrap:!1}}),D=new h({props:{title:"추적된 모델을 사용하여 추론하기",local:"using-a-traced-model-for-inference",headingTag:"h3"}}),L=new Me({props:{code:"dHJhY2VkX21vZGVsKHRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzKQ==",highlighted:"traced_model(tokens_tensor, segments_tensors)",wrap:!1}}),G=new h({props:{title:"Neuron SDK로 Hugging Face TorchScript 모델을 AWS에 배포하기",local:"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk",headingTag:"h2"}}),K=new h({props:{title:"시사점",local:"implications",headingTag:"h3"}}),te=new h({props:{title:"종속성",local:"dependencies",headingTag:"h3"}}),ne=new h({props:{title:"AWS Neuron으로 모델 변환하기",local:"converting-a-model-for-aws-neuron",headingTag:"h3"}}),ae=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUyQyUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Q29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5uZXVyb24=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.neuron`,wrap:!1}}),oe=new Me({props:{code:"LSUyMHRvcmNoLmppdC50cmFjZShtb2RlbCUyQyUyMCU1QnRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzJTVEKSUwQSUyQiUyMHRvcmNoLm5ldXJvbi50cmFjZShtb2RlbCUyQyUyMCU1QnRva2VuX3RlbnNvciUyQyUyMHNlZ21lbnRzX3RlbnNvcnMlNUQp",highlighted:`<span class="hljs-deletion">- torch.jit.trace(model, [tokens_tensor, segments_tensors])</span>
<span class="hljs-addition">+ torch.neuron.trace(model, [token_tensor, segments_tensors])</span>`,wrap:!1}}),Ue=new Dt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/torchscript.md"}}),{c(){d=r("meta"),y=s(),J=r("p"),me=s(),p(u.$$.fragment),de=s(),p(f.$$.fragment),Je=s(),Q=r("p"),Q.innerHTML=it,he=s(),C=r("blockquote"),C.innerHTML=pt,fe=s(),j=r("p"),j.innerHTML=Ut,ye=s(),g=r("p"),g.textContent=mt,ue=s(),b=r("p"),b.textContent=Mt,Qe=s(),$=r("ul"),$.innerHTML=ct,Ce=s(),w=r("p"),w.textContent=Tt,je=s(),p(V.$$.fragment),ge=s(),R=r("p"),R.innerHTML=dt,be=s(),E=r("p"),E.innerHTML=Jt,$e=s(),k=r("p"),k.innerHTML=ht,we=s(),p(_.$$.fragment),Ve=s(),B=r("p"),B.innerHTML=ft,Re=s(),I=r("p"),I.textContent=yt,Ee=s(),p(v.$$.fragment),ke=s(),S=r("p"),S.textContent=ut,_e=s(),N=r("p"),N.textContent=Qt,Be=s(),p(Z.$$.fragment),Ie=s(),W=r("p"),W.textContent=Ct,ve=s(),p(A.$$.fragment),Se=s(),O=r("p"),O.innerHTML=jt,Ne=s(),p(x.$$.fragment),Ze=s(),p(H.$$.fragment),We=s(),F=r("p"),F.innerHTML=gt,Ae=s(),p(z.$$.fragment),Oe=s(),p(D.$$.fragment),xe=s(),X=r("p"),X.innerHTML=bt,He=s(),p(L.$$.fragment),Fe=s(),p(G.$$.fragment),ze=s(),P=r("p"),P.innerHTML=$t,De=s(),Y=r("ol"),Y.innerHTML=wt,Xe=s(),p(K.$$.fragment),Le=s(),q=r("p"),q.innerHTML=Vt,Ge=s(),ee=r("p"),ee.innerHTML=Rt,Pe=s(),p(te.$$.fragment),Ye=s(),le=r("p"),le.innerHTML=Et,Ke=s(),p(ne.$$.fragment),qe=s(),se=r("p"),se.innerHTML=kt,et=s(),p(ae.$$.fragment),tt=s(),re=r("p"),re.textContent=_t,lt=s(),p(oe.$$.fragment),nt=s(),ie=r("p"),ie.textContent=Bt,st=s(),pe=r("p"),pe.innerHTML=It,at=s(),p(Ue.$$.fragment),rt=s(),ce=r("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=a(e),J=o(e,"P",{}),St(J).forEach(l),me=a(e),U(u.$$.fragment,e),de=a(e),U(f.$$.fragment,e),Je=a(e),Q=o(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-isybml"&&(Q.innerHTML=it),he=a(e),C=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(C)!=="svelte-1nfg3b0"&&(C.innerHTML=pt),fe=a(e),j=o(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-sp9oye"&&(j.innerHTML=Ut),ye=a(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-do9l6t"&&(g.textContent=mt),ue=a(e),b=o(e,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1w91skt"&&(b.textContent=Mt),Qe=a(e),$=o(e,"UL",{"data-svelte-h":!0}),i($)!=="svelte-k6rkk6"&&($.innerHTML=ct),Ce=a(e),w=o(e,"P",{"data-svelte-h":!0}),i(w)!=="svelte-14fy25m"&&(w.textContent=Tt),je=a(e),U(V.$$.fragment,e),ge=a(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-12irp1s"&&(R.innerHTML=dt),be=a(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-50p7lq"&&(E.innerHTML=Jt),$e=a(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1xgnj70"&&(k.innerHTML=ht),we=a(e),U(_.$$.fragment,e),Ve=a(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1q7p5d"&&(B.innerHTML=ft),Re=a(e),I=o(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-9y2g95"&&(I.textContent=yt),Ee=a(e),U(v.$$.fragment,e),ke=a(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1ujz4pz"&&(S.textContent=ut),_e=a(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-2wkzde"&&(N.textContent=Qt),Be=a(e),U(Z.$$.fragment,e),Ie=a(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-kletgn"&&(W.textContent=Ct),ve=a(e),U(A.$$.fragment,e),Se=a(e),O=o(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-sf77rs"&&(O.innerHTML=jt),Ne=a(e),U(x.$$.fragment,e),Ze=a(e),U(H.$$.fragment,e),We=a(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1r4og2d"&&(F.innerHTML=gt),Ae=a(e),U(z.$$.fragment,e),Oe=a(e),U(D.$$.fragment,e),xe=a(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1fmm5c"&&(X.innerHTML=bt),He=a(e),U(L.$$.fragment,e),Fe=a(e),U(G.$$.fragment,e),ze=a(e),P=o(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-grcwrb"&&(P.innerHTML=$t),De=a(e),Y=o(e,"OL",{"data-svelte-h":!0}),i(Y)!=="svelte-ro97hi"&&(Y.innerHTML=wt),Xe=a(e),U(K.$$.fragment,e),Le=a(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1dwgzck"&&(q.innerHTML=Vt),Ge=a(e),ee=o(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-it8cst"&&(ee.innerHTML=Rt),Pe=a(e),U(te.$$.fragment,e),Ye=a(e),le=o(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-3tyyhn"&&(le.innerHTML=Et),Ke=a(e),U(ne.$$.fragment,e),qe=a(e),se=o(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-13235e8"&&(se.innerHTML=kt),et=a(e),U(ae.$$.fragment,e),tt=a(e),re=o(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-r93qfm"&&(re.textContent=_t),lt=a(e),U(oe.$$.fragment,e),nt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-12g7lo2"&&(ie.textContent=Bt),st=a(e),pe=o(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1akz01w"&&(pe.innerHTML=It),at=a(e),U(Ue.$$.fragment,e),rt=a(e),ce=o(e,"P",{}),St(ce).forEach(l),this.h()},h(){Nt(d,"name","hf:doc:metadata"),Nt(d,"content",Gt)},m(e,t){Ft(document.head,d),n(e,y,t),n(e,J,t),n(e,me,t),m(u,e,t),n(e,de,t),m(f,e,t),n(e,Je,t),n(e,Q,t),n(e,he,t),n(e,C,t),n(e,fe,t),n(e,j,t),n(e,ye,t),n(e,g,t),n(e,ue,t),n(e,b,t),n(e,Qe,t),n(e,$,t),n(e,Ce,t),n(e,w,t),n(e,je,t),m(V,e,t),n(e,ge,t),n(e,R,t),n(e,be,t),n(e,E,t),n(e,$e,t),n(e,k,t),n(e,we,t),m(_,e,t),n(e,Ve,t),n(e,B,t),n(e,Re,t),n(e,I,t),n(e,Ee,t),m(v,e,t),n(e,ke,t),n(e,S,t),n(e,_e,t),n(e,N,t),n(e,Be,t),m(Z,e,t),n(e,Ie,t),n(e,W,t),n(e,ve,t),m(A,e,t),n(e,Se,t),n(e,O,t),n(e,Ne,t),m(x,e,t),n(e,Ze,t),m(H,e,t),n(e,We,t),n(e,F,t),n(e,Ae,t),m(z,e,t),n(e,Oe,t),m(D,e,t),n(e,xe,t),n(e,X,t),n(e,He,t),m(L,e,t),n(e,Fe,t),m(G,e,t),n(e,ze,t),n(e,P,t),n(e,De,t),n(e,Y,t),n(e,Xe,t),m(K,e,t),n(e,Le,t),n(e,q,t),n(e,Ge,t),n(e,ee,t),n(e,Pe,t),m(te,e,t),n(e,Ye,t),n(e,le,t),n(e,Ke,t),m(ne,e,t),n(e,qe,t),n(e,se,t),n(e,et,t),m(ae,e,t),n(e,tt,t),n(e,re,t),n(e,lt,t),m(oe,e,t),n(e,nt,t),n(e,ie,t),n(e,st,t),n(e,pe,t),n(e,at,t),m(Ue,e,t),n(e,rt,t),n(e,ce,t),ot=!0},p(e,[t]){const vt={};t&2&&(vt.$$scope={dirty:t,ctx:e}),f.$set(vt)},i(e){ot||(M(u.$$.fragment,e),M(f.$$.fragment,e),M(V.$$.fragment,e),M(_.$$.fragment,e),M(v.$$.fragment,e),M(Z.$$.fragment,e),M(A.$$.fragment,e),M(x.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(D.$$.fragment,e),M(L.$$.fragment,e),M(G.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(Ue.$$.fragment,e),ot=!0)},o(e){c(u.$$.fragment,e),c(f.$$.fragment,e),c(V.$$.fragment,e),c(_.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(A.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(L.$$.fragment,e),c(G.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Ue.$$.fragment,e),ot=!1},d(e){e&&(l(y),l(J),l(me),l(de),l(Je),l(Q),l(he),l(C),l(fe),l(j),l(ye),l(g),l(ue),l(b),l(Qe),l($),l(Ce),l(w),l(je),l(ge),l(R),l(be),l(E),l($e),l(k),l(we),l(Ve),l(B),l(Re),l(I),l(Ee),l(ke),l(S),l(_e),l(N),l(Be),l(Ie),l(W),l(ve),l(Se),l(O),l(Ne),l(Ze),l(We),l(F),l(Ae),l(Oe),l(xe),l(X),l(He),l(Fe),l(ze),l(P),l(De),l(Y),l(Xe),l(Le),l(q),l(Ge),l(ee),l(Pe),l(Ye),l(le),l(Ke),l(qe),l(se),l(et),l(tt),l(re),l(lt),l(nt),l(ie),l(st),l(pe),l(at),l(rt),l(ce)),l(d),T(u,e),T(f,e),T(V,e),T(_,e),T(v,e),T(Z,e),T(A,e),T(x,e),T(H,e),T(z,e),T(D,e),T(L,e),T(G,e),T(K,e),T(te,e),T(ne,e),T(ae,e),T(oe,e),T(Ue,e)}}}const Gt='{"title":"TorchScript로 내보내기","local":"export-to-torchscript","sections":[{"title":"TorchScript 플래그와 묶인 가중치(tied weights)","local":"torchscript-flag-and-tied-weights","sections":[],"depth":2},{"title":"더미 입력과 표준 길이","local":"dummy-inputs-and-standard-lengths","sections":[],"depth":2},{"title":"Python에서 TorchScript 사용하기","local":"using-torchscript-in-python","sections":[{"title":"모델 저장하기","local":"saving-a-model","sections":[],"depth":3},{"title":"모델 가져오기","local":"loading-a-model","sections":[],"depth":3},{"title":"추적된 모델을 사용하여 추론하기","local":"using-a-traced-model-for-inference","sections":[],"depth":3}],"depth":2},{"title":"Neuron SDK로 Hugging Face TorchScript 모델을 AWS에 배포하기","local":"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk","sections":[{"title":"시사점","local":"implications","sections":[],"depth":3},{"title":"종속성","local":"dependencies","sections":[],"depth":3},{"title":"AWS Neuron으로 모델 변환하기","local":"converting-a-model-for-aws-neuron","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pt(Te){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ll extends Ot{constructor(d){super(),xt(this,d,Pt,Lt,Zt,{})}}export{ll as component};
