import{s as Cl,n as _l,o as Zl}from"../chunks/scheduler.9991993c.js";import{S as kl,i as Gl,g as n,s as a,r as c,A as Hl,h as M,f as e,c as p,j as bl,u as o,x as i,k as Bl,y as Vl,a as t,v as r,d as y,t as J,w as d}from"../chunks/index.ed60ef0f.js";import{C as T}from"../chunks/CodeBlock.d4c22193.js";import{H as Ps,E as Xl}from"../chunks/index.5b62b65b.js";function gl(Ks){let j,ns,as,Ms,m,is,w,Ds='在本指南中，我们将演示如何创建一个自定义流水线并分享到 <a href="https://hf.co/models" rel="nofollow">Hub</a>，或将其添加到 🤗 Transformers 库中。',cs,u,Os=`首先，你需要决定流水线将能够接受的原始条目。它可以是字符串、原始字节、字典或任何看起来最可能是期望的输入。
尽量保持输入为纯 Python 语言，因为这样可以更容易地实现兼容性（甚至通过 JSON 在其他语言之间）。
这些将是流水线 (<code>preprocess</code>) 的 <code>inputs</code>。`,os,U,sl="然后定义 <code>outputs</code>。与 <code>inputs</code> 相同的策略。越简单越好。这些将是 <code>postprocess</code> 方法的输出。",rs,f,ll="首先继承基类 <code>Pipeline</code>，其中包含实现 <code>preprocess</code>、<code>_forward</code>、<code>postprocess</code> 和 <code>_sanitize_parameters</code> 所需的 4 个方法。",ys,h,Js,I,el="这种分解的结构旨在为 CPU/GPU 提供相对无缝的支持，同时支持在不同线程上对 CPU 进行预处理/后处理。",ds,b,tl="<code>preprocess</code> 将接受最初定义的输入，并将其转换为可供模型输入的内容。它可能包含更多信息，通常是一个 <code>Dict</code>。",Ts,B,al=`<code>_forward</code> 是实现细节，不应直接调用。<code>forward</code> 是首选的调用方法，因为它包含保障措施，以确保一切都在预期的设备上运作。
如果任何内容与实际模型相关，它应该属于 <code>_forward</code> 方法，其他内容应该在 preprocess/postprocess 中。`,js,C,pl="<code>postprocess</code> 方法将接受 <code>_forward</code> 的输出，并将其转换为之前确定的最终输出。",ms,_,nl=`<code>_sanitize_parameters</code> 存在是为了允许用户在任何时候传递任何参数，无论是在初始化时 <code>pipeline(...., maybe_arg=4)</code>
还是在调用时 <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>。`,ws,Z,Ml=`<code>_sanitize_parameters</code> 的返回值是将直接传递给 <code>preprocess</code>、<code>_forward</code> 和 <code>postprocess</code> 的 3 个关键字参数字典。
如果调用方没有使用任何额外参数调用，则不要填写任何内容。这样可以保留函数定义中的默认参数，这总是更”自然”的。`,us,k,il="在分类任务中，一个经典的例子是在后处理中使用 <code>top_k</code> 参数。",Us,G,fs,H,cl=`为了实现这一点，我们将更新我们的 <code>postprocess</code> 方法，将默认参数设置为 <code>5</code>，
并编辑 <code>_sanitize_parameters</code> 方法，以允许这个新参数。`,hs,V,Is,X,ol=`尽量保持简单输入/输出，最好是可 JSON 序列化的，因为这样可以使流水线的使用非常简单，而不需要用户了解新的对象类型。
通常也相对常见地支持许多不同类型的参数以便使用（例如音频文件，可以是文件名、URL 或纯字节）。`,bs,g,Bs,W,rl="要将你的 <code>new-task</code> 注册到支持的任务列表中，你需要将其添加到 <code>PIPELINE_REGISTRY</code> 中：",Cs,A,_s,R,yl="如果需要，你可以指定一个默认模型，此时它应该带有一个特定的修订版本（可以是分支名称或提交哈希，这里我们使用了 <code>&quot;abcdef&quot;</code>），以及类型：",Zs,N,ks,q,Gs,E,Jl=`要在 Hub 上分享你的自定义流水线，你只需要将 <code>Pipeline</code> 子类的自定义代码保存在一个 Python 文件中。
例如，假设我们想使用一个自定义流水线进行句对分类，如下所示：`,Hs,z,Vs,$,dl=`这个实现与框架无关，适用于 PyTorch 和 TensorFlow 模型。如果我们将其保存在一个名为
<code>pair_classification.py</code> 的文件中，然后我们可以像这样导入并注册它：`,Xs,v,gs,x,Tl=`完成这些步骤后，我们可以将其与预训练模型一起使用。例如，<code>sgugger/finetuned-bert-mrpc</code>
已经在 MRPC 数据集上进行了微调，用于将句子对分类为是释义或不是释义。`,Ws,Y,As,Q,jl="然后，我们可以通过在 <code>Repository</code> 中使用 <code>save_pretrained</code> 方法将其分享到 Hub 上：",Rs,F,Ns,S,ml=`这将会复制包含你定义的 <code>PairClassificationPipeline</code> 的文件到文件夹 <code>&quot;test-dynamic-pipeline&quot;</code> 中，
同时保存流水线的模型和分词器，然后将所有内容推送到仓库 <code>{your_username}/test-dynamic-pipeline</code> 中。
之后，只要提供选项 <code>trust_remote_code=True</code>，任何人都可以使用它：`,qs,L,Es,P,zs,K,wl=`如果你想将你的流水线贡献给 🤗 Transformers，你需要在 <code>pipelines</code> 子模块中添加一个新模块，
其中包含你的流水线的代码，然后将其添加到 <code>pipelines/__init__.py</code> 中定义的任务列表中。`,$s,D,ul="然后，你需要添加测试。创建一个新文件 <code>tests/test_pipelines_MY_PIPELINE.py</code>，其中包含其他测试的示例。",vs,O,Ul="<code>run_pipeline_test</code> 函数将非常通用，并在每种可能的架构上运行小型随机模型，如 <code>model_mapping</code> 和 <code>tf_model_mapping</code> 所定义。",xs,ss,fl=`这对于测试未来的兼容性非常重要，这意味着如果有人为 <code>XXXForQuestionAnswering</code> 添加了一个新模型，
流水线测试将尝试在其上运行。由于模型是随机的，所以不可能检查实际值，这就是为什么有一个帮助函数 <code>ANY</code>，它只是尝试匹配流水线的输出类型。`,Ys,ls,hl="你还 <strong>需要</strong> 实现 2（最好是 4）个测试。",Qs,es,Il=`<li><code>test_small_model_pt</code>：为这个流水线定义一个小型模型（结果是否合理并不重要），并测试流水线的输出。
结果应该与 <code>test_small_model_tf</code> 的结果相同。</li> <li><code>test_small_model_tf</code>：为这个流水线定义一个小型模型（结果是否合理并不重要），并测试流水线的输出。
结果应该与 <code>test_small_model_pt</code> 的结果相同。</li> <li><code>test_large_model_pt</code>（可选）：在一个真实的流水线上测试流水线，结果应该是有意义的。
这些测试速度较慢，应该被如此标记。这里的目标是展示流水线，并确保在未来的发布中没有漂移。</li> <li><code>test_large_model_tf</code>（可选）：在一个真实的流水线上测试流水线，结果应该是有意义的。
这些测试速度较慢，应该被如此标记。这里的目标是展示流水线，并确保在未来的发布中没有漂移。</li>`,Fs,ts,Ss,ps,Ls;return m=new Ps({props:{title:"如何创建自定义流水线？",local:"如何创建自定义流水线",headingTag:"h1"}}),h=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),G=new T({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),V=new T({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),g=new Ps({props:{title:"将其添加到支持的任务列表中",local:"将其添加到支持的任务列表中",headingTag:"h2"}}),A=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),N=new T({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),q=new Ps({props:{title:"在 Hub 上分享你的流水线",local:"在-hub-上分享你的流水线",headingTag:"h2"}}),z=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),v=new T({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),Y=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),F=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`,wrap:!1}}),L=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new Ps({props:{title:"将流水线添加到 🤗 Transformers",local:"将流水线添加到--transformers",headingTag:"h2"}}),ts=new Xl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/add_new_pipeline.md"}}),{c(){j=n("meta"),ns=a(),as=n("p"),Ms=a(),c(m.$$.fragment),is=a(),w=n("p"),w.innerHTML=Ds,cs=a(),u=n("p"),u.innerHTML=Os,os=a(),U=n("p"),U.innerHTML=sl,rs=a(),f=n("p"),f.innerHTML=ll,ys=a(),c(h.$$.fragment),Js=a(),I=n("p"),I.textContent=el,ds=a(),b=n("p"),b.innerHTML=tl,Ts=a(),B=n("p"),B.innerHTML=al,js=a(),C=n("p"),C.innerHTML=pl,ms=a(),_=n("p"),_.innerHTML=nl,ws=a(),Z=n("p"),Z.innerHTML=Ml,us=a(),k=n("p"),k.innerHTML=il,Us=a(),c(G.$$.fragment),fs=a(),H=n("p"),H.innerHTML=cl,hs=a(),c(V.$$.fragment),Is=a(),X=n("p"),X.textContent=ol,bs=a(),c(g.$$.fragment),Bs=a(),W=n("p"),W.innerHTML=rl,Cs=a(),c(A.$$.fragment),_s=a(),R=n("p"),R.innerHTML=yl,Zs=a(),c(N.$$.fragment),ks=a(),c(q.$$.fragment),Gs=a(),E=n("p"),E.innerHTML=Jl,Hs=a(),c(z.$$.fragment),Vs=a(),$=n("p"),$.innerHTML=dl,Xs=a(),c(v.$$.fragment),gs=a(),x=n("p"),x.innerHTML=Tl,Ws=a(),c(Y.$$.fragment),As=a(),Q=n("p"),Q.innerHTML=jl,Rs=a(),c(F.$$.fragment),Ns=a(),S=n("p"),S.innerHTML=ml,qs=a(),c(L.$$.fragment),Es=a(),c(P.$$.fragment),zs=a(),K=n("p"),K.innerHTML=wl,$s=a(),D=n("p"),D.innerHTML=ul,vs=a(),O=n("p"),O.innerHTML=Ul,xs=a(),ss=n("p"),ss.innerHTML=fl,Ys=a(),ls=n("p"),ls.innerHTML=hl,Qs=a(),es=n("ul"),es.innerHTML=Il,Fs=a(),c(ts.$$.fragment),Ss=a(),ps=n("p"),this.h()},l(s){const l=Hl("svelte-u9bgzb",document.head);j=M(l,"META",{name:!0,content:!0}),l.forEach(e),ns=p(s),as=M(s,"P",{}),bl(as).forEach(e),Ms=p(s),o(m.$$.fragment,s),is=p(s),w=M(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-ia2fek"&&(w.innerHTML=Ds),cs=p(s),u=M(s,"P",{"data-svelte-h":!0}),i(u)!=="svelte-rqfhkm"&&(u.innerHTML=Os),os=p(s),U=M(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-11li02j"&&(U.innerHTML=sl),rs=p(s),f=M(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1uqe9lz"&&(f.innerHTML=ll),ys=p(s),o(h.$$.fragment,s),Js=p(s),I=M(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1k9lsn2"&&(I.textContent=el),ds=p(s),b=M(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-gzvxzk"&&(b.innerHTML=tl),Ts=p(s),B=M(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1cdihds"&&(B.innerHTML=al),js=p(s),C=M(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1x5gtvf"&&(C.innerHTML=pl),ms=p(s),_=M(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-d4t2rm"&&(_.innerHTML=nl),ws=p(s),Z=M(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1i0ixpi"&&(Z.innerHTML=Ml),us=p(s),k=M(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-oow5v7"&&(k.innerHTML=il),Us=p(s),o(G.$$.fragment,s),fs=p(s),H=M(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-15x8cpa"&&(H.innerHTML=cl),hs=p(s),o(V.$$.fragment,s),Is=p(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1axfvzi"&&(X.textContent=ol),bs=p(s),o(g.$$.fragment,s),Bs=p(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-pd1e4e"&&(W.innerHTML=rl),Cs=p(s),o(A.$$.fragment,s),_s=p(s),R=M(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1pcnt1i"&&(R.innerHTML=yl),Zs=p(s),o(N.$$.fragment,s),ks=p(s),o(q.$$.fragment,s),Gs=p(s),E=M(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-12so9yg"&&(E.innerHTML=Jl),Hs=p(s),o(z.$$.fragment,s),Vs=p(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-jvth30"&&($.innerHTML=dl),Xs=p(s),o(v.$$.fragment,s),gs=p(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1hij24v"&&(x.innerHTML=Tl),Ws=p(s),o(Y.$$.fragment,s),As=p(s),Q=M(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-5v42jo"&&(Q.innerHTML=jl),Rs=p(s),o(F.$$.fragment,s),Ns=p(s),S=M(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-792yxj"&&(S.innerHTML=ml),qs=p(s),o(L.$$.fragment,s),Es=p(s),o(P.$$.fragment,s),zs=p(s),K=M(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1kt4zz1"&&(K.innerHTML=wl),$s=p(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-g2mdjg"&&(D.innerHTML=ul),vs=p(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1bz25ei"&&(O.innerHTML=Ul),xs=p(s),ss=M(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-a4o9sd"&&(ss.innerHTML=fl),Ys=p(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1f45ohx"&&(ls.innerHTML=hl),Qs=p(s),es=M(s,"UL",{"data-svelte-h":!0}),i(es)!=="svelte-1na82ye"&&(es.innerHTML=Il),Fs=p(s),o(ts.$$.fragment,s),Ss=p(s),ps=M(s,"P",{}),bl(ps).forEach(e),this.h()},h(){Bl(j,"name","hf:doc:metadata"),Bl(j,"content",Wl)},m(s,l){Vl(document.head,j),t(s,ns,l),t(s,as,l),t(s,Ms,l),r(m,s,l),t(s,is,l),t(s,w,l),t(s,cs,l),t(s,u,l),t(s,os,l),t(s,U,l),t(s,rs,l),t(s,f,l),t(s,ys,l),r(h,s,l),t(s,Js,l),t(s,I,l),t(s,ds,l),t(s,b,l),t(s,Ts,l),t(s,B,l),t(s,js,l),t(s,C,l),t(s,ms,l),t(s,_,l),t(s,ws,l),t(s,Z,l),t(s,us,l),t(s,k,l),t(s,Us,l),r(G,s,l),t(s,fs,l),t(s,H,l),t(s,hs,l),r(V,s,l),t(s,Is,l),t(s,X,l),t(s,bs,l),r(g,s,l),t(s,Bs,l),t(s,W,l),t(s,Cs,l),r(A,s,l),t(s,_s,l),t(s,R,l),t(s,Zs,l),r(N,s,l),t(s,ks,l),r(q,s,l),t(s,Gs,l),t(s,E,l),t(s,Hs,l),r(z,s,l),t(s,Vs,l),t(s,$,l),t(s,Xs,l),r(v,s,l),t(s,gs,l),t(s,x,l),t(s,Ws,l),r(Y,s,l),t(s,As,l),t(s,Q,l),t(s,Rs,l),r(F,s,l),t(s,Ns,l),t(s,S,l),t(s,qs,l),r(L,s,l),t(s,Es,l),r(P,s,l),t(s,zs,l),t(s,K,l),t(s,$s,l),t(s,D,l),t(s,vs,l),t(s,O,l),t(s,xs,l),t(s,ss,l),t(s,Ys,l),t(s,ls,l),t(s,Qs,l),t(s,es,l),t(s,Fs,l),r(ts,s,l),t(s,Ss,l),t(s,ps,l),Ls=!0},p:_l,i(s){Ls||(y(m.$$.fragment,s),y(h.$$.fragment,s),y(G.$$.fragment,s),y(V.$$.fragment,s),y(g.$$.fragment,s),y(A.$$.fragment,s),y(N.$$.fragment,s),y(q.$$.fragment,s),y(z.$$.fragment,s),y(v.$$.fragment,s),y(Y.$$.fragment,s),y(F.$$.fragment,s),y(L.$$.fragment,s),y(P.$$.fragment,s),y(ts.$$.fragment,s),Ls=!0)},o(s){J(m.$$.fragment,s),J(h.$$.fragment,s),J(G.$$.fragment,s),J(V.$$.fragment,s),J(g.$$.fragment,s),J(A.$$.fragment,s),J(N.$$.fragment,s),J(q.$$.fragment,s),J(z.$$.fragment,s),J(v.$$.fragment,s),J(Y.$$.fragment,s),J(F.$$.fragment,s),J(L.$$.fragment,s),J(P.$$.fragment,s),J(ts.$$.fragment,s),Ls=!1},d(s){s&&(e(ns),e(as),e(Ms),e(is),e(w),e(cs),e(u),e(os),e(U),e(rs),e(f),e(ys),e(Js),e(I),e(ds),e(b),e(Ts),e(B),e(js),e(C),e(ms),e(_),e(ws),e(Z),e(us),e(k),e(Us),e(fs),e(H),e(hs),e(Is),e(X),e(bs),e(Bs),e(W),e(Cs),e(_s),e(R),e(Zs),e(ks),e(Gs),e(E),e(Hs),e(Vs),e($),e(Xs),e(gs),e(x),e(Ws),e(As),e(Q),e(Rs),e(Ns),e(S),e(qs),e(Es),e(zs),e(K),e($s),e(D),e(vs),e(O),e(xs),e(ss),e(Ys),e(ls),e(Qs),e(es),e(Fs),e(Ss),e(ps)),e(j),d(m,s),d(h,s),d(G,s),d(V,s),d(g,s),d(A,s),d(N,s),d(q,s),d(z,s),d(v,s),d(Y,s),d(F,s),d(L,s),d(P,s),d(ts,s)}}}const Wl='{"title":"如何创建自定义流水线？","local":"如何创建自定义流水线","sections":[{"title":"将其添加到支持的任务列表中","local":"将其添加到支持的任务列表中","sections":[],"depth":2},{"title":"在 Hub 上分享你的流水线","local":"在-hub-上分享你的流水线","sections":[],"depth":2},{"title":"将流水线添加到 🤗 Transformers","local":"将流水线添加到--transformers","sections":[],"depth":2}],"depth":1}';function Al(Ks){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends kl{constructor(j){super(),Gl(this,j,Al,gl,Cl,{})}}export{zl as component};
