import{s as an,n as rn,o as sn}from"../chunks/scheduler.6062bdaf.js";import{S as mn,i as un,g as a,s as o,r as u,A as ln,h as r,f as n,c as i,j as h,u as l,x as f,k as b,y as e,a as m,v as d,d as c,t as p,w as g}from"../chunks/index.4bca734e.js";import{D as z}from"../chunks/Docstring.ed07512f.js";import{H as Nt}from"../chunks/Heading.723dceba.js";function dn(Pe){let q,At,Qt,Lt,M,Ft,V,Ie="The configuration classes are the way to specify how a task should be done. There are two tasks supported with the ONNX Runtime package:",Dt,R,We='<li><p>Optimization: Performed by the <a href="/docs/optimum/main/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a>, this task can be tweaked using an <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig">OptimizationConfig</a>.</p></li> <li><p>Quantization: Performed by the <a href="/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a>, quantization can be set using a <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a>. A calibration step is required in some cases (post training static quantization), which can be specified using a <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.CalibrationConfig">CalibrationConfig</a>.</p></li>',Pt,E,It,w,X,se,ut,Me=`OptimizationConfig is the configuration class handling all the ONNX Runtime optimization parameters.
There are two stacks of optimizations:`,me,lt,Ve="<li>The ONNX Runtime general-purpose optimization tool: it can work on any ONNX model.</li> <li>The ONNX Runtime transformers optimization tool: it can only work on a subset of transformers models.</li>",Wt,_,H,ue,dt,Re="Factory to create common <code>OptimizationConfig</code>.",le,Q,U,de,ct,Ee="Creates an O1 <code>~OptimizationConfig</code>.",ce,k,S,pe,pt,Xe="Creates an O2 <code>~OptimizationConfig</code>.",ge,A,G,fe,gt,He="Creates an O3 <code>~OptimizationConfig</code>.",_e,L,B,he,ft,Ue="Creates an O4 <code>~OptimizationConfig</code>.",be,F,j,xe,_t,Se="Creates an <code>~OptimizationConfig</code> with pre-defined arguments according to an optimization level.",Mt,K,Vt,$,J,ze,ht,Ge="QuantizationConfig is the configuration class handling all the ONNX Runtime quantization parameters.",Rt,Y,Et,x,Z,ve,D,tt,ye,bt,Be='Creates a <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for ARM64.',Ce,P,et,we,xt,je='Creates a <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX2 instruction set.',Oe,I,nt,qe,zt,Ke='Creates a <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX512 instruction set.',$e,v,ot,Te,vt,Je='Creates a <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX512-VNNI instruction set.',Ne,yt,Ye=`When targeting Intel AVX512-VNNI CPU underlying execution engine leverage the CPU instruction VPDPBUSD to
compute  \\i32 += i8(w) * u8(x)\\ within a single instruction.`,Qe,Ct,Ze=`AVX512-VNNI (AVX512 Vector Neural Network Instruction)
is an x86 extension Instruction set and is a part of the AVX-512 ISA.`,ke,wt,tn="AVX512 VNNI is designed to accelerate convolutional neural network for INT8 inference.",Ae,W,it,Le,Ot,en='Creates a <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for TensorRT static quantization, targetting NVIDIA GPUs.',Xt,at,Ht,T,rt,Fe,qt,nn=`CalibrationConfig is the configuration class handling all the ONNX Runtime parameters related to the calibration
step of static quantization.`,Ut,st,St,N,mt,De,$t,on=`ORTConfig is the configuration class handling all the ONNX Runtime parameters related to the ONNX IR model export,
optimization and quantization parameters.`,Gt,kt,Bt;return M=new Nt({props:{title:"Configuration",local:"configuration",headingTag:"h1"}}),E=new Nt({props:{title:"OptimizationConfig",local:"optimum.onnxruntime.OptimizationConfig",headingTag:"h2"}}),X=new z({props:{name:"class optimum.onnxruntime.OptimizationConfig",anchor:"optimum.onnxruntime.OptimizationConfig",parameters:[{name:"optimization_level",val:": int = 1"},{name:"optimize_for_gpu",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"optimize_with_onnxruntime_only",val:": typing.Optional[bool] = None"},{name:"enable_transformers_specific_optimizations",val:": bool = True"},{name:"disable_gelu",val:": typing.Optional[bool] = None"},{name:"disable_gelu_fusion",val:": bool = False"},{name:"disable_layer_norm",val:": typing.Optional[bool] = None"},{name:"disable_layer_norm_fusion",val:": bool = False"},{name:"disable_attention",val:": typing.Optional[bool] = None"},{name:"disable_attention_fusion",val:": bool = False"},{name:"disable_skip_layer_norm",val:": typing.Optional[bool] = None"},{name:"disable_skip_layer_norm_fusion",val:": bool = False"},{name:"disable_bias_skip_layer_norm",val:": typing.Optional[bool] = None"},{name:"disable_bias_skip_layer_norm_fusion",val:": bool = False"},{name:"disable_bias_gelu",val:": typing.Optional[bool] = None"},{name:"disable_bias_gelu_fusion",val:": bool = False"},{name:"disable_embed_layer_norm",val:": bool = True"},{name:"disable_embed_layer_norm_fusion",val:": bool = True"},{name:"enable_gelu_approximation",val:": bool = False"},{name:"use_mask_index",val:": bool = False"},{name:"no_attention_mask",val:": bool = False"},{name:"disable_shape_inference",val:": bool = False"},{name:"use_multi_head_attention",val:": bool = False"},{name:"enable_gemm_fast_gelu_fusion",val:": bool = False"},{name:"use_raw_attention_mask",val:": bool = False"},{name:"disable_group_norm_fusion",val:": bool = True"},{name:"disable_packed_kv",val:": bool = True"},{name:"disable_rotary_embeddings",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.OptimizationConfig.optimization_level",description:`<strong>optimization_level</strong> (<code>int</code>, defaults to 1) &#x2014;
Optimization level performed by ONNX Runtime of the loaded graph.
Supported optimization level are 0, 1, 2 and 99.<ul>
<li>0: will disable all optimizations</li>
<li>1: will enable basic optimizations</li>
<li>2: will enable basic and extended optimizations, including complex node fusions applied to the nodes
assigned to the CPU or CUDA execution provider, making the resulting optimized graph hardware dependent</li>
<li>99: will enable all available optimizations including layout optimizations</li>
</ul>`,name:"optimization_level"},{anchor:"optimum.onnxruntime.OptimizationConfig.optimize_for_gpu",description:`<strong>optimize_for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to optimize the model for GPU inference.
The optimized graph might contain operators for GPU or CPU only when <code>optimization_level</code> &gt; 1.`,name:"optimize_for_gpu"},{anchor:"optimum.onnxruntime.OptimizationConfig.fp16",description:`<strong>fp16</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether all weights and nodes should be converted from float32 to float16.`,name:"fp16"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_transformers_specific_optimizations",description:`<strong>enable_transformers_specific_optimizations</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to only use <code>transformers</code> specific optimizations on top of ONNX Runtime general optimizations.`,name:"enable_transformers_specific_optimizations"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_gelu_fusion",description:`<strong>disable_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable the Gelu fusion.`,name:"disable_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_layer_norm_fusion",description:`<strong>disable_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Layer Normalization fusion.`,name:"disable_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_attention_fusion",description:`<strong>disable_attention_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Attention fusion.`,name:"disable_attention_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_skip_layer_norm_fusion",description:`<strong>disable_skip_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable SkipLayerNormalization fusion.`,name:"disable_skip_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_bias_skip_layer_norm_fusion",description:`<strong>disable_bias_skip_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Add Bias and SkipLayerNormalization fusion.`,name:"disable_bias_skip_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_bias_gelu_fusion",description:`<strong>disable_bias_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Add Bias and Gelu / FastGelu fusion.`,name:"disable_bias_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_embed_layer_norm_fusion",description:`<strong>disable_embed_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to disable EmbedLayerNormalization fusion.
The default value is set to <code>True</code> since this fusion is incompatible with ONNX Runtime quantization.`,name:"disable_embed_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_gelu_approximation",description:`<strong>enable_gelu_approximation</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to enable Gelu / BiasGelu to FastGelu conversion.
The default value is set to <code>False</code> since this approximation might slightly impact the model&#x2019;s accuracy.`,name:"enable_gelu_approximation"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_mask_index",description:`<strong>use_mask_index</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use mask index instead of raw attention mask in the attention operator.`,name:"use_mask_index"},{anchor:"optimum.onnxruntime.OptimizationConfig.no_attention_mask",description:`<strong>no_attention_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to not use attention masks. Only works for bert model type.`,name:"no_attention_mask"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_embed_layer_norm",description:`<strong>disable_embed_layer_norm</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to disable EmbedLayerNormalization fusion.
The default value is set to <code>True</code> since this fusion is incompatible with ONNX Runtime quantization`,name:"disable_embed_layer_norm"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_shape_inference",description:`<strong>disable_shape_inference</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable symbolic shape inference.
The default value is set to <code>False</code> but symbolic shape inference might cause issues sometimes.`,name:"disable_shape_inference"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_multi_head_attention",description:`<strong>use_multi_head_attention</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Experimental argument. Use MultiHeadAttention instead of Attention operator, which has merged weights for Q/K/V projection,
which might be faster in some cases since 3 MatMul is merged into one.&#x201D;
&#x201C;Note that MultiHeadAttention might be slower than Attention when qkv are not packed. &#x201D;`,name:"use_multi_head_attention"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_gemm_fast_gelu_fusion",description:`<strong>enable_gemm_fast_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Enable GemmfastGelu fusion.`,name:"enable_gemm_fast_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_raw_attention_mask",description:`<strong>use_raw_attention_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Use raw attention mask. Use this option if your input is not right-side padding. This might deactivate fused attention and get worse performance.`,name:"use_raw_attention_mask"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_group_norm_fusion",description:`<strong>disable_group_norm_fusion</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Do not fuse GroupNorm. Only works for model_type=unet.`,name:"disable_group_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_packed_kv",description:`<strong>disable_packed_kv</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Do not use packed kv in cross attention. Only works for model_type=unet.`,name:"disable_packed_kv"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_rotary_embeddings",description:`<strong>disable_rotary_embeddings</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Rotary Embedding fusion.`,name:"disable_rotary_embeddings"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L648"}}),H=new z({props:{name:"class optimum.onnxruntime.AutoOptimizationConfig",anchor:"optimum.onnxruntime.AutoOptimizationConfig",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L822"}}),U=new z({props:{name:"O1",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L882",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O1 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),S=new z({props:{name:"O2",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L899",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O2 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),G=new z({props:{name:"O3",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L916",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O3 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),B=new z({props:{name:"O4",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4",parameters:[{name:"for_gpu",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L933",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O4 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),j=new z({props:{name:"with_optimization_level",anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level",parameters:[{name:"optimization_level",val:": str"},{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.optimization_level",description:`<strong>optimization_level</strong> (<code>str</code>) &#x2014;
The optimization level, the following values are allowed:<ul>
<li>O1: Basic general optimizations</li>
<li>O2: Basic and extended general optimizations, transformers-specific fusions.</li>
<li>O3: Same as O2 with Fast Gelu approximation.</li>
<li>O4: Same as O3 with mixed precision.</li>
</ul>`,name:"optimization_level"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L849",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the requested optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),K=new Nt({props:{title:"QuantizationConfig",local:"optimum.onnxruntime.QuantizationConfig",headingTag:"h2"}}),J=new z({props:{name:"class optimum.onnxruntime.QuantizationConfig",anchor:"optimum.onnxruntime.QuantizationConfig",parameters:[{name:"is_static",val:": bool"},{name:"format",val:": QuantFormat"},{name:"mode",val:": QuantizationMode = <QuantizationMode.QLinearOps: 1>"},{name:"activations_dtype",val:": QuantType = <QuantType.QUInt8: 1>"},{name:"activations_symmetric",val:": bool = False"},{name:"weights_dtype",val:": QuantType = <QuantType.QInt8: 0>"},{name:"weights_symmetric",val:": bool = True"},{name:"per_channel",val:": bool = False"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": typing.List[str] = <factory>"},{name:"nodes_to_exclude",val:": typing.List[str] = <factory>"},{name:"operators_to_quantize",val:": typing.List[str] = <factory>"},{name:"qdq_add_pair_to_weight",val:": bool = False"},{name:"qdq_dedicated_pair",val:": bool = False"},{name:"qdq_op_type_per_channel_support_to_axis",val:": typing.Dict[str, int] = <factory>"}],parametersDescription:[{anchor:"optimum.onnxruntime.QuantizationConfig.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Whether to apply static quantization or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.QuantizationConfig.format",description:`<strong>format</strong> (<code>QuantFormat</code>) &#x2014;
Targeted ONNX Runtime quantization representation format.
For the Operator Oriented (QOperator) format, all the quantized operators have their own ONNX definitions.
For the Tensor Oriented (QDQ) format, the model is quantized by inserting QuantizeLinear / DeQuantizeLinear
operators.`,name:"format"},{anchor:"optimum.onnxruntime.QuantizationConfig.mode",description:`<strong>mode</strong> (<code>QuantizationMode</code>, defaults to <code>QuantizationMode.QLinearOps</code>) &#x2014;
Targeted ONNX Runtime quantization mode, default is QLinearOps to match QDQ format.
When targeting dynamic quantization mode, the default value is <code>QuantizationMode.IntegerOps</code> whereas the
default value for static quantization mode is <code>QuantizationMode.QLinearOps</code>.`,name:"mode"},{anchor:"optimum.onnxruntime.QuantizationConfig.activations_dtype",description:`<strong>activations_dtype</strong> (<code>QuantType</code>, defaults to <code>QuantType.QUInt8</code>) &#x2014;
The quantization data types to use for the activations.`,name:"activations_dtype"},{anchor:"optimum.onnxruntime.QuantizationConfig.activations_symmetric",description:`<strong>activations_symmetric</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to apply symmetric quantization on the activations.`,name:"activations_symmetric"},{anchor:"optimum.onnxruntime.QuantizationConfig.weights_dtype",description:`<strong>weights_dtype</strong> (<code>QuantType</code>, defaults to <code>QuantType.QInt8</code>) &#x2014;
The quantization data types to use for the weights.`,name:"weights_dtype"},{anchor:"optimum.onnxruntime.QuantizationConfig.weights_symmetric",description:`<strong>weights_symmetric</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to apply symmetric quantization on the weights.`,name:"weights_symmetric"},{anchor:"optimum.onnxruntime.QuantizationConfig.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can increase overall
accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.QuantizationConfig.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use reduce-range 7-bits integers instead of 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.QuantizationConfig.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>List[str]</code>, defaults to <code>[]</code>) &#x2014;
List of the nodes names to quantize. When unspecified, all nodes will be quantized. If empty, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.QuantizationConfig.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>List[str]</code>, defaults to <code>[]</code>) &#x2014;
List of the nodes names to exclude when applying quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.QuantizationConfig.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>List[str]</code>) &#x2014;
List of the operators types to quantize. Defaults to all quantizable operators for the given quantization mode and format. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_add_pair_to_weight",description:`<strong>qdq_add_pair_to_weight</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
By default, floating-point weights are quantized and feed to solely inserted DeQuantizeLinear node.
If set to True, the floating-point weights will remain and both QuantizeLinear / DeQuantizeLinear nodes
will be inserted.`,name:"qdq_add_pair_to_weight"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_dedicated_pair",description:`<strong>qdq_dedicated_pair</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When inserting QDQ pair, multiple nodes can share a single QDQ pair as their inputs. If True, it will
create an identical and dedicated QDQ pair for each node.`,name:"qdq_dedicated_pair"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_op_type_per_channel_support_to_axis",description:`<strong>qdq_op_type_per_channel_support_to_axis</strong> (<code>Dict[str, int]</code>) &#x2014;
Set the channel axis for a specific operator type. Effective only when per channel quantization is
supported and <code>per_channel</code> is set to True.`,name:"qdq_op_type_per_channel_support_to_axis"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L225"}}),Y=new Nt({props:{title:"AutoQuantizationConfig",local:"optimum.onnxruntime.AutoQuantizationConfig",headingTag:"h2"}}),Z=new z({props:{name:"class optimum.onnxruntime.AutoQuantizationConfig",anchor:"optimum.onnxruntime.AutoQuantizationConfig",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L380"}}),tt=new z({props:{name:"arm64",anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"nodes_to_exclude",val:": typing.Optional[typing.List[str]] = None"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L381"}}),et=new z({props:{name:"avx2",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"nodes_to_exclude",val:": typing.Optional[typing.List[str]] = None"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
accuracy drop is significant, to try with reduced range (reduce_range = True).
Intel&#x2019;s CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L432"}}),nt=new z({props:{name:"avx512",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"nodes_to_exclude",val:": typing.Optional[typing.List[str]] = None"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
accuracy drop is significant, to try with reduced range (reduce_range = True).
Intel&#x2019;s CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L488"}}),ot=new z({props:{name:"avx512_vnni",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"nodes_to_exclude",val:": typing.Optional[typing.List[str]] = None"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L544"}}),it=new z({props:{name:"tensorrt",anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt",parameters:[{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"nodes_to_exclude",val:": typing.Optional[typing.List[str]] = None"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L601"}}),at=new Nt({props:{title:"CalibrationConfig",local:"optimum.onnxruntime.CalibrationConfig",headingTag:"h3"}}),rt=new z({props:{name:"class optimum.onnxruntime.CalibrationConfig",anchor:"optimum.onnxruntime.CalibrationConfig",parameters:[{name:"dataset_name",val:": str"},{name:"dataset_config_name",val:": str"},{name:"dataset_split",val:": str"},{name:"dataset_num_samples",val:": int"},{name:"method",val:": CalibrationMethod"},{name:"num_bins",val:": typing.Optional[int] = None"},{name:"num_quantized_bins",val:": typing.Optional[int] = None"},{name:"percentile",val:": typing.Optional[float] = None"},{name:"moving_average",val:": typing.Optional[bool] = None"},{name:"averaging_constant",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>) &#x2014;
The name of the calibration dataset.`,name:"dataset_name"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_config_name",description:`<strong>dataset_config_name</strong> (<code>str</code>) &#x2014;
The name of the calibration dataset configuration.`,name:"dataset_config_name"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_split",description:`<strong>dataset_split</strong> (<code>str</code>) &#x2014;
Which split of the dataset is used to perform the calibration step.`,name:"dataset_split"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_num_samples",description:`<strong>dataset_num_samples</strong> (<code>int</code>) &#x2014;
The number of samples composing the calibration dataset.`,name:"dataset_num_samples"},{anchor:"optimum.onnxruntime.CalibrationConfig.method",description:`<strong>method</strong> (<code>CalibrationMethod</code>) &#x2014;
The method chosen to calculate the activations quantization parameters using the calibration dataset.`,name:"method"},{anchor:"optimum.onnxruntime.CalibrationConfig.num_bins",description:`<strong>num_bins</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
The number of bins to use when creating the histogram when performing the calibration step using the
Percentile or Entropy method.`,name:"num_bins"},{anchor:"optimum.onnxruntime.CalibrationConfig.num_quantized_bins",description:`<strong>num_quantized_bins</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
The number of quantized bins to use when performing the calibration step using the Entropy method.`,name:"num_quantized_bins"},{anchor:"optimum.onnxruntime.CalibrationConfig.percentile",description:`<strong>percentile</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
The percentile to use when computing the activations quantization ranges when performing the calibration
step using the Percentile method.`,name:"percentile"},{anchor:"optimum.onnxruntime.CalibrationConfig.moving_average",description:`<strong>moving_average</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to compute the moving average of the minimum and maximum values when performing the calibration step
using the MinMax method.`,name:"moving_average"},{anchor:"optimum.onnxruntime.CalibrationConfig.averaging_constant",description:`<strong>averaging_constant</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
The constant smoothing factor to use when computing the moving average of the minimum and maximum values.
Effective only when the MinMax calibration method is selected and <code>moving_average</code> is set to True.`,name:"averaging_constant"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L48"}}),st=new Nt({props:{title:"ORTConfig",local:"optimum.onnxruntime.ORTConfig",headingTag:"h2"}}),mt=new z({props:{name:"class optimum.onnxruntime.ORTConfig",anchor:"optimum.onnxruntime.ORTConfig",parameters:[{name:"opset",val:": typing.Optional[int] = None"},{name:"use_external_data_format",val:": bool = False"},{name:"one_external_file",val:": bool = True"},{name:"optimization",val:": typing.Optional[optimum.onnxruntime.configuration.OptimizationConfig] = None"},{name:"quantization",val:": typing.Optional[optimum.onnxruntime.configuration.QuantizationConfig] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTConfig.opset",description:`<strong>opset</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
ONNX opset version to export the model with.`,name:"opset"},{anchor:"optimum.onnxruntime.ORTConfig.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Allow exporting model &gt;= than 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTConfig.one_external_file",description:`<strong>one_external_file</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
When <code>use_external_data_format=True</code>, whether to save all tensors to one external file.
If false, save each tensor to a file named with the tensor name.
(Can not be set to <code>False</code> for the quantization)`,name:"one_external_file"},{anchor:"optimum.onnxruntime.ORTConfig.optimization",description:`<strong>optimization</strong> (<code>Optional[OptimizationConfig]</code>, defaults to <code>None</code>) &#x2014;
Specify a configuration to optimize ONNX Runtime model`,name:"optimization"},{anchor:"optimum.onnxruntime.ORTConfig.quantization",description:`<strong>quantization</strong> (<code>Optional[QuantizationConfig]</code>, defaults to <code>None</code>) &#x2014;
Specify a configuration to quantize ONNX Runtime model`,name:"quantization"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/configuration.py#L951"}}),{c(){q=a("meta"),At=o(),Qt=a("p"),Lt=o(),u(M.$$.fragment),Ft=o(),V=a("p"),V.textContent=Ie,Dt=o(),R=a("ol"),R.innerHTML=We,Pt=o(),u(E.$$.fragment),It=o(),w=a("div"),u(X.$$.fragment),se=o(),ut=a("p"),ut.textContent=Me,me=o(),lt=a("ol"),lt.innerHTML=Ve,Wt=o(),_=a("div"),u(H.$$.fragment),ue=o(),dt=a("p"),dt.innerHTML=Re,le=o(),Q=a("div"),u(U.$$.fragment),de=o(),ct=a("p"),ct.innerHTML=Ee,ce=o(),k=a("div"),u(S.$$.fragment),pe=o(),pt=a("p"),pt.innerHTML=Xe,ge=o(),A=a("div"),u(G.$$.fragment),fe=o(),gt=a("p"),gt.innerHTML=He,_e=o(),L=a("div"),u(B.$$.fragment),he=o(),ft=a("p"),ft.innerHTML=Ue,be=o(),F=a("div"),u(j.$$.fragment),xe=o(),_t=a("p"),_t.innerHTML=Se,Mt=o(),u(K.$$.fragment),Vt=o(),$=a("div"),u(J.$$.fragment),ze=o(),ht=a("p"),ht.textContent=Ge,Rt=o(),u(Y.$$.fragment),Et=o(),x=a("div"),u(Z.$$.fragment),ve=o(),D=a("div"),u(tt.$$.fragment),ye=o(),bt=a("p"),bt.innerHTML=Be,Ce=o(),P=a("div"),u(et.$$.fragment),we=o(),xt=a("p"),xt.innerHTML=je,Oe=o(),I=a("div"),u(nt.$$.fragment),qe=o(),zt=a("p"),zt.innerHTML=Ke,$e=o(),v=a("div"),u(ot.$$.fragment),Te=o(),vt=a("p"),vt.innerHTML=Je,Ne=o(),yt=a("p"),yt.textContent=Ye,Qe=o(),Ct=a("p"),Ct.textContent=Ze,ke=o(),wt=a("p"),wt.textContent=tn,Ae=o(),W=a("div"),u(it.$$.fragment),Le=o(),Ot=a("p"),Ot.innerHTML=en,Xt=o(),u(at.$$.fragment),Ht=o(),T=a("div"),u(rt.$$.fragment),Fe=o(),qt=a("p"),qt.textContent=nn,Ut=o(),u(st.$$.fragment),St=o(),N=a("div"),u(mt.$$.fragment),De=o(),$t=a("p"),$t.textContent=on,Gt=o(),kt=a("p"),this.h()},l(t){const s=ln("svelte-u9bgzb",document.head);q=r(s,"META",{name:!0,content:!0}),s.forEach(n),At=i(t),Qt=r(t,"P",{}),h(Qt).forEach(n),Lt=i(t),l(M.$$.fragment,t),Ft=i(t),V=r(t,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1shhltv"&&(V.textContent=Ie),Dt=i(t),R=r(t,"OL",{"data-svelte-h":!0}),f(R)!=="svelte-4c986i"&&(R.innerHTML=We),Pt=i(t),l(E.$$.fragment,t),It=i(t),w=r(t,"DIV",{class:!0});var Tt=h(w);l(X.$$.fragment,Tt),se=i(Tt),ut=r(Tt,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-kud8lz"&&(ut.textContent=Me),me=i(Tt),lt=r(Tt,"OL",{"data-svelte-h":!0}),f(lt)!=="svelte-1347rzr"&&(lt.innerHTML=Ve),Tt.forEach(n),Wt=i(t),_=r(t,"DIV",{class:!0});var y=h(_);l(H.$$.fragment,y),ue=i(y),dt=r(y,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-z99vag"&&(dt.innerHTML=Re),le=i(y),Q=r(y,"DIV",{class:!0});var jt=h(Q);l(U.$$.fragment,jt),de=i(jt),ct=r(jt,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-o9g052"&&(ct.innerHTML=Ee),jt.forEach(n),ce=i(y),k=r(y,"DIV",{class:!0});var Kt=h(k);l(S.$$.fragment,Kt),pe=i(Kt),pt=r(Kt,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-gkopyf"&&(pt.innerHTML=Xe),Kt.forEach(n),ge=i(y),A=r(y,"DIV",{class:!0});var Jt=h(A);l(G.$$.fragment,Jt),fe=i(Jt),gt=r(Jt,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-1b21ddg"&&(gt.innerHTML=He),Jt.forEach(n),_e=i(y),L=r(y,"DIV",{class:!0});var Yt=h(L);l(B.$$.fragment,Yt),he=i(Yt),ft=r(Yt,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-mclel1"&&(ft.innerHTML=Ue),Yt.forEach(n),be=i(y),F=r(y,"DIV",{class:!0});var Zt=h(F);l(j.$$.fragment,Zt),xe=i(Zt),_t=r(Zt,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-cq6eru"&&(_t.innerHTML=Se),Zt.forEach(n),y.forEach(n),Mt=i(t),l(K.$$.fragment,t),Vt=i(t),$=r(t,"DIV",{class:!0});var te=h($);l(J.$$.fragment,te),ze=i(te),ht=r(te,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-9xjx81"&&(ht.textContent=Ge),te.forEach(n),Rt=i(t),l(Y.$$.fragment,t),Et=i(t),x=r(t,"DIV",{class:!0});var C=h(x);l(Z.$$.fragment,C),ve=i(C),D=r(C,"DIV",{class:!0});var ee=h(D);l(tt.$$.fragment,ee),ye=i(ee),bt=r(ee,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-18mnssu"&&(bt.innerHTML=Be),ee.forEach(n),Ce=i(C),P=r(C,"DIV",{class:!0});var ne=h(P);l(et.$$.fragment,ne),we=i(ne),xt=r(ne,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-1o9gfzv"&&(xt.innerHTML=je),ne.forEach(n),Oe=i(C),I=r(C,"DIV",{class:!0});var oe=h(I);l(nt.$$.fragment,oe),qe=i(oe),zt=r(oe,"P",{"data-svelte-h":!0}),f(zt)!=="svelte-muqczp"&&(zt.innerHTML=Ke),oe.forEach(n),$e=i(C),v=r(C,"DIV",{class:!0});var O=h(v);l(ot.$$.fragment,O),Te=i(O),vt=r(O,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-1tpe9nz"&&(vt.innerHTML=Je),Ne=i(O),yt=r(O,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-pb6daa"&&(yt.textContent=Ye),Qe=i(O),Ct=r(O,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-167rhrj"&&(Ct.textContent=Ze),ke=i(O),wt=r(O,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-vqsk0u"&&(wt.textContent=tn),O.forEach(n),Ae=i(C),W=r(C,"DIV",{class:!0});var ie=h(W);l(it.$$.fragment,ie),Le=i(ie),Ot=r(ie,"P",{"data-svelte-h":!0}),f(Ot)!=="svelte-1r78z9p"&&(Ot.innerHTML=en),ie.forEach(n),C.forEach(n),Xt=i(t),l(at.$$.fragment,t),Ht=i(t),T=r(t,"DIV",{class:!0});var ae=h(T);l(rt.$$.fragment,ae),Fe=i(ae),qt=r(ae,"P",{"data-svelte-h":!0}),f(qt)!=="svelte-12bp9yw"&&(qt.textContent=nn),ae.forEach(n),Ut=i(t),l(st.$$.fragment,t),St=i(t),N=r(t,"DIV",{class:!0});var re=h(N);l(mt.$$.fragment,re),De=i(re),$t=r(re,"P",{"data-svelte-h":!0}),f($t)!=="svelte-10zam97"&&($t.textContent=on),re.forEach(n),Gt=i(t),kt=r(t,"P",{}),h(kt).forEach(n),this.h()},h(){b(q,"name","hf:doc:metadata"),b(q,"content",cn),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,s){e(document.head,q),m(t,At,s),m(t,Qt,s),m(t,Lt,s),d(M,t,s),m(t,Ft,s),m(t,V,s),m(t,Dt,s),m(t,R,s),m(t,Pt,s),d(E,t,s),m(t,It,s),m(t,w,s),d(X,w,null),e(w,se),e(w,ut),e(w,me),e(w,lt),m(t,Wt,s),m(t,_,s),d(H,_,null),e(_,ue),e(_,dt),e(_,le),e(_,Q),d(U,Q,null),e(Q,de),e(Q,ct),e(_,ce),e(_,k),d(S,k,null),e(k,pe),e(k,pt),e(_,ge),e(_,A),d(G,A,null),e(A,fe),e(A,gt),e(_,_e),e(_,L),d(B,L,null),e(L,he),e(L,ft),e(_,be),e(_,F),d(j,F,null),e(F,xe),e(F,_t),m(t,Mt,s),d(K,t,s),m(t,Vt,s),m(t,$,s),d(J,$,null),e($,ze),e($,ht),m(t,Rt,s),d(Y,t,s),m(t,Et,s),m(t,x,s),d(Z,x,null),e(x,ve),e(x,D),d(tt,D,null),e(D,ye),e(D,bt),e(x,Ce),e(x,P),d(et,P,null),e(P,we),e(P,xt),e(x,Oe),e(x,I),d(nt,I,null),e(I,qe),e(I,zt),e(x,$e),e(x,v),d(ot,v,null),e(v,Te),e(v,vt),e(v,Ne),e(v,yt),e(v,Qe),e(v,Ct),e(v,ke),e(v,wt),e(x,Ae),e(x,W),d(it,W,null),e(W,Le),e(W,Ot),m(t,Xt,s),d(at,t,s),m(t,Ht,s),m(t,T,s),d(rt,T,null),e(T,Fe),e(T,qt),m(t,Ut,s),d(st,t,s),m(t,St,s),m(t,N,s),d(mt,N,null),e(N,De),e(N,$t),m(t,Gt,s),m(t,kt,s),Bt=!0},p:rn,i(t){Bt||(c(M.$$.fragment,t),c(E.$$.fragment,t),c(X.$$.fragment,t),c(H.$$.fragment,t),c(U.$$.fragment,t),c(S.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(j.$$.fragment,t),c(K.$$.fragment,t),c(J.$$.fragment,t),c(Y.$$.fragment,t),c(Z.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(nt.$$.fragment,t),c(ot.$$.fragment,t),c(it.$$.fragment,t),c(at.$$.fragment,t),c(rt.$$.fragment,t),c(st.$$.fragment,t),c(mt.$$.fragment,t),Bt=!0)},o(t){p(M.$$.fragment,t),p(E.$$.fragment,t),p(X.$$.fragment,t),p(H.$$.fragment,t),p(U.$$.fragment,t),p(S.$$.fragment,t),p(G.$$.fragment,t),p(B.$$.fragment,t),p(j.$$.fragment,t),p(K.$$.fragment,t),p(J.$$.fragment,t),p(Y.$$.fragment,t),p(Z.$$.fragment,t),p(tt.$$.fragment,t),p(et.$$.fragment,t),p(nt.$$.fragment,t),p(ot.$$.fragment,t),p(it.$$.fragment,t),p(at.$$.fragment,t),p(rt.$$.fragment,t),p(st.$$.fragment,t),p(mt.$$.fragment,t),Bt=!1},d(t){t&&(n(At),n(Qt),n(Lt),n(Ft),n(V),n(Dt),n(R),n(Pt),n(It),n(w),n(Wt),n(_),n(Mt),n(Vt),n($),n(Rt),n(Et),n(x),n(Xt),n(Ht),n(T),n(Ut),n(St),n(N),n(Gt),n(kt)),n(q),g(M,t),g(E,t),g(X),g(H),g(U),g(S),g(G),g(B),g(j),g(K,t),g(J),g(Y,t),g(Z),g(tt),g(et),g(nt),g(ot),g(it),g(at,t),g(rt),g(st,t),g(mt)}}}const cn='{"title":"Configuration","local":"configuration","sections":[{"title":"OptimizationConfig","local":"optimum.onnxruntime.OptimizationConfig","sections":[],"depth":2},{"title":"QuantizationConfig","local":"optimum.onnxruntime.QuantizationConfig","sections":[],"depth":2},{"title":"AutoQuantizationConfig","local":"optimum.onnxruntime.AutoQuantizationConfig","sections":[{"title":"CalibrationConfig","local":"optimum.onnxruntime.CalibrationConfig","sections":[],"depth":3}],"depth":2},{"title":"ORTConfig","local":"optimum.onnxruntime.ORTConfig","sections":[],"depth":2}],"depth":1}';function pn(Pe){return sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends mn{constructor(q){super(),un(this,q,pn,dn,an,{})}}export{bn as component};
