import{s as ze,n as Qe,o as Ye}from"../chunks/scheduler.389d799c.js";import{S as De,i as Re,g as o,s as a,r,A as Oe,h as i,f as n,c as l,j as Ne,u as p,x as d,k as Ve,y as Ke,a as s,v as c,d as u,t as h,w as g}from"../chunks/index.8f81d18f.js";import{C as m}from"../chunks/CodeBlock.3845caa1.js";import{H as ut}from"../chunks/Heading.41733039.js";function tn(he){let f,mt,ht,ft,T,Tt,M,Mt,y,ge="Below you can find a version table of currently available Hugging Face DLCs. The table doesn’t include the full <code>image_uri</code> here are two examples on how to construct those if needed.",yt,w,me="<strong>Manually construction the <code>image_uri</code></strong>",wt,j,fe="<code>{dlc-aws-account-id}.dkr.ecr.{region}.amazonaws.com/huggingface-{framework}-{(training | inference)}:{framework-version}-transformers{transformers-version}-{device}-{python-version}-{device-tag}</code>",jt,b,Te='<li><code>dlc-aws-account-id</code>: The AWS account ID of the account that owns the ECR repository. You can find them in the <a href="https://github.com/aws/sagemaker-python-sdk/blob/e0b9d38e1e3b48647a02af23c4be54980e53dc61/src/sagemaker/image_uri_config/huggingface.json#L21" rel="nofollow">here</a></li> <li><code>region</code>: The AWS region where you want to use it.</li> <li><code>framework</code>: The framework you want to use, either <code>pytorch</code> or <code>tensorflow</code>.</li> <li><code>(training | inference)</code>: The training or inference mode.</li> <li><code>framework-version</code>: The version of the framework you want to use.</li> <li><code>transformers-version</code>: The version of the transformers library you want to use.</li> <li><code>device</code>: The device you want to use, either <code>cpu</code> or <code>gpu</code>.</li> <li><code>python-version</code>: The version of the python of the DLC.</li> <li><code>device-tag</code>: The device tag you want to use. The device tag can include os version and cuda version</li>',bt,J,Me="<strong>Example 1: PyTorch Training:</strong> <code>763104351884.dkr.ecr.us-west-2.amazonaws.com/huggingface-pytorch-training:1.6.0-transformers4.4.2-gpu-py36-cu110-ubuntu18.04</code> <strong>Example 2: Tensorflow Inference:</strong> <code>763104351884.dkr.ecr.us-east-1.amazonaws.com/huggingface-tensorflow-inference:2.4.1-transformers4.6.1-cpu-py37-ubuntu18.04</code>",Jt,I,It,k,ye=`The Training DLC overview includes all released and available Hugging Face Training DLCs. It includes PyTorch and TensorFlow flavored
versions for GPU.`,kt,U,we="<thead><tr><th>🤗 Transformers version</th> <th>🤗 Datasets version</th> <th>PyTorch/TensorFlow version</th> <th>type</th> <th>device</th> <th>Python Version</th></tr></thead> <tbody><tr><td>4.4.2</td> <td>1.5.0</td> <td>PyTorch 1.6.0</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.4.2</td> <td>1.5.0</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.5.0</td> <td>1.5.0</td> <td>PyTorch 1.6.0</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.5.0</td> <td>1.5.0</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.6.1</td> <td>1.6.2</td> <td>PyTorch 1.6.0</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>1.6.2</td> <td>PyTorch 1.7.1</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>1.6.2</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>PyTorch 1.8.1</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>PyTorch 1.9.0</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>TensorFlow 2.5.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.11.0</td> <td>1.12.1</td> <td>PyTorch 1.9.0</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.11.0</td> <td>1.12.1</td> <td>TensorFlow 2.5.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>1.15.1</td> <td>PyTorch 1.9.1</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.12.3</td> <td>1.15.1</td> <td>TensorFlow 2.5.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.17.0</td> <td>1.18.4</td> <td>PyTorch 1.10.2</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>1.18.4</td> <td>TensorFlow 2.6.3</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.26.0</td> <td>2.9.0</td> <td>PyTorch 1.13.1</td> <td>training</td> <td>GPU</td> <td>3.9</td></tr></tbody>",Ut,v,vt,_,je=`The Inference DLC overview includes all released and available Hugging Face Inference DLCs. It includes PyTorch and TensorFlow flavored
versions for CPU, GPU & AWS Inferentia.`,_t,$,be="<thead><tr><th>🤗 Transformers version</th> <th>PyTorch/TensorFlow version</th> <th>type</th> <th>device</th> <th>Python Version</th></tr></thead> <tbody><tr><td>4.6.1</td> <td>PyTorch 1.7.1</td> <td>inference</td> <td>CPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>PyTorch 1.7.1</td> <td>inference</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.6.1</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.8.1</td> <td>inference</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.8.1</td> <td>inference</td> <td>CPU</td> <td>3.6</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.11.0</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.11.0</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.11.0</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.11.0</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>PyTorch 1.9.1</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.12.3</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>PyTorch 1.9.1</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.12.3</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>PyTorch 1.9.1</td> <td>inference</td> <td>Inferentia</td> <td>3.7</td></tr> <tr><td>4.17.0</td> <td>PyTorch 1.10.2</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>TensorFlow 2.6.3</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>PyTorch 1.10.2</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>TensorFlow 2.6.3</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.26.0</td> <td>PyTorch 1.13.1</td> <td>inference</td> <td>CPU</td> <td>3.9</td></tr> <tr><td>4.26.0</td> <td>PyTorch 1.13.1</td> <td>inference</td> <td>GPU</td> <td>3.9</td></tr></tbody>",$t,P,Pt,C,Je='Example Jupyter notebooks that demonstrate how to build, train, and deploy <a href="https://github.com/huggingface/transformers" rel="nofollow">Hugging Face Transformers</a> using <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html" rel="nofollow">Amazon SageMaker</a> and the <a href="https://sagemaker.readthedocs.io/en/stable/" rel="nofollow">Amazon SageMaker Python SDK</a>.',Ct,H,Ie='<thead><tr><th>Notebook</th> <th>Type</th> <th>Description</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">01 Getting started with PyTorch</a></td> <td>Training</td> <td>Getting started end-to-end example on how to fine-tune a pre-trained Hugging Face Transformer for Text-Classification using PyTorch</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/02_getting_started_tensorflow/sagemaker-notebook.ipynb" rel="nofollow">02 getting started with TensorFlow</a></td> <td>Training</td> <td>Getting started end-to-end example on how to fine-tune a pre-trained Hugging Face Transformer for Text-Classification using TensorFlow</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/03_distributed_training_data_parallelism/sagemaker-notebook.ipynb" rel="nofollow">03 Distributed Training: Data Parallelism</a></td> <td>Training</td> <td>End-to-end example on how to use distributed training with data-parallelism strategy for fine-tuning a pre-trained Hugging Face Transformer for Question-Answering using Amazon SageMaker Data Parallelism</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/04_distributed_training_model_parallelism/sagemaker-notebook.ipynb" rel="nofollow">04 Distributed Training: Model Parallelism</a></td> <td>Training</td> <td>End-to-end example on how to use distributed training with model-parallelism strategy to pre-trained Hugging Face Transformer using Amazon SageMaker Model Parallelism</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/05_spot_instances/sagemaker-notebook.ipynb" rel="nofollow">05 How to use Spot Instances &amp; Checkpointing</a></td> <td>Training</td> <td>End-to-end example on how to use Spot Instances and Checkpointing to reduce training cost</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/06_sagemaker_metrics/sagemaker-notebook.ipynb" rel="nofollow">06 Experiment Tracking with SageMaker Metrics</a></td> <td>Training</td> <td>End-to-end example on how to use SageMaker metrics to track your experiments and training jobs</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/07_tensorflow_distributed_training_data_parallelism/sagemaker-notebook.ipynb" rel="nofollow">07 Distributed Training: Data Parallelism</a></td> <td>Training</td> <td>End-to-end example on how to use Amazon SageMaker Data Parallelism with TensorFlow</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/08_distributed_summarization_bart_t5/sagemaker-notebook.ipynb" rel="nofollow">08 Distributed Training: Summarization with T5/BART</a></td> <td>Training</td> <td>End-to-end example on how to fine-tune BART/T5 for Summarization using Amazon SageMaker Data Parallelism</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/09_image_classification_vision_transformer/sagemaker-notebook.ipynb" rel="nofollow">09 Vision: Fine-tune ViT</a></td> <td>Training</td> <td>End-to-end example on how to fine-tune Vision Transformer for Image-Classification</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/10_deploy_model_from_s3/deploy_transformer_model_from_s3.ipynb" rel="nofollow">10 Deploy HF Transformer from Amazon S3</a></td> <td>Inference</td> <td>End-to-end example on how to deploy a model from Amazon S3</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/11_deploy_model_from_hf_hub/deploy_transformer_model_from_hf_hub.ipynb" rel="nofollow">11 Deploy HF Transformer from Hugging Face Hub</a></td> <td>Inference</td> <td>End-to-end example on how to deploy a model from the Hugging Face Hub</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/12_batch_transform_inference/sagemaker-notebook.ipynb" rel="nofollow">12 Batch Processing with Amazon SageMaker Batch Transform</a></td> <td>Inference</td> <td>End-to-end example on how to do batch processing with Amazon SageMaker Batch Transform</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/13_deploy_and_autoscaling_transformers/sagemaker-notebook.ipynb" rel="nofollow">13 Autoscaling SageMaker Endpoints</a></td> <td>Inference</td> <td>End-to-end example on how to do use autoscaling for a HF Endpoint</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/14_train_and_push_to_hub/sagemaker-notebook.ipynb" rel="nofollow">14 Fine-tune and push to Hub</a></td> <td>Training</td> <td>End-to-end example on how to do use the Hugging Face Hub as MLOps backend for saving checkpoints during training</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/15_training_compiler/sagemaker-notebook.ipynb" rel="nofollow">15 Training Compiler</a></td> <td>Training</td> <td>End-to-end example on how to do use Amazon SageMaker Training Compiler to speed up training time</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/16_async_inference_hf_hub/sagemaker-notebook.ipynb" rel="nofollow">16 Asynchronous Inference</a></td> <td>Inference</td> <td>End-to-end example on how to do use Amazon SageMaker Asynchronous Inference endpoints with Hugging Face Transformers</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/17_custom_inference_script/sagemaker-notebook.ipynb" rel="nofollow">17 Custom inference.py script</a></td> <td>Inference</td> <td>End-to-end example on how to create a custom inference.py for Sentence Transformers and sentence embeddings</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/18_inferentia_inference/sagemaker-notebook.ipynb" rel="nofollow">18 AWS Inferentia</a></td> <td>Inference</td> <td>End-to-end example on how to AWS Inferentia to speed up inference time</td></tr></tbody>',Ht,B,Bt,G,ke='The Inference Toolkit accepts inputs in the <code>inputs</code> key, and supports additional <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow"><code>pipelines</code></a> parameters in the <code>parameters</code> key. You can provide any of the supported <code>kwargs</code> from <code>pipelines</code> as <code>parameters</code>.',Gt,E,Ue="Tasks supported by the Inference Toolkit API include:",Et,q,ve="<li><strong><code>text-classification</code></strong></li> <li><strong><code>sentiment-analysis</code></strong></li> <li><strong><code>token-classification</code></strong></li> <li><strong><code>feature-extraction</code></strong></li> <li><strong><code>fill-mask</code></strong></li> <li><strong><code>summarization</code></strong></li> <li><strong><code>translation_xx_to_yy</code></strong></li> <li><strong><code>text2text-generation</code></strong></li> <li><strong><code>text-generation</code></strong></li> <li><strong><code>audio-classificatin</code></strong></li> <li><strong><code>automatic-speech-recognition</code></strong></li> <li><strong><code>conversational</code></strong></li> <li><strong><code>image-classification</code></strong></li> <li><strong><code>image-segmentation</code></strong></li> <li><strong><code>object-detection</code></strong></li> <li><strong><code>table-question-answering</code></strong></li> <li><strong><code>zero-shot-classification</code></strong></li> <li><strong><code>zero-shot-image-classification</code></strong></li>",qt,x,_e="See the following request examples for some of the tasks:",xt,F,$e="<strong><code>text-classification</code></strong>",Ft,S,St,W,Pe="<strong><code>sentiment-analysis</code></strong>",Wt,A,At,X,Ce="<strong><code>token-classification</code></strong>",Xt,Z,Zt,L,He="<strong><code>question-answering</code></strong>",Lt,N,Nt,V,Be="<strong><code>zero-shot-classification</code></strong>",Vt,z,zt,Q,Ge="<strong><code>table-question-answering</code></strong>",Qt,Y,Yt,D,Ee="<strong><code>parameterized-request</code></strong>",Dt,R,Rt,O,Ot,K,qe="The Inference Toolkit implements various additional environment variables to simplify deployment. A complete list of Hugging Face specific environment variables is shown below:",Kt,tt,xe="<strong><code>HF_TASK</code></strong>",te,et,Fe='<code>HF_TASK</code> defines the task for the 🤗 Transformers pipeline used . See <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a> for a complete list of tasks.',ee,nt,ne,st,Se="<strong><code>HF_MODEL_ID</code></strong>",se,at,We='<code>HF_MODEL_ID</code> defines the model ID which is automatically loaded from <a href="https://huggingface.co/models" rel="nofollow">hf.co/models</a> when creating a SageMaker endpoint. All of the 🤗 Hub’s 10,000+ models are available through this environment variable.',ae,lt,le,ot,Ae="<strong><code>HF_MODEL_REVISION</code></strong>",oe,it,Xe="<code>HF_MODEL_REVISION</code> is an extension to <code>HF_MODEL_ID</code> and allows you to define or pin a model revision to make sure you always load the same model on your SageMaker endpoint.",ie,dt,de,rt,Ze="<strong><code>HF_API_TOKEN</code></strong>",re,pt,Le='<code>HF_API_TOKEN</code> defines your Hugging Face authorization token. The <code>HF_API_TOKEN</code> is used as a HTTP bearer authorization for remote files like private models. You can find your token under <a href="https://huggingface.co/settings/tokens" rel="nofollow">Settings</a> of your Hugging Face account.',pe,ct,ce,gt,ue;return T=new ut({props:{title:"Reference",local:"reference",headingTag:"h1"}}),M=new ut({props:{title:"Deep Learning Container",local:"deep-learning-container",headingTag:"h2"}}),I=new ut({props:{title:"Training DLC Overview",local:"training-dlc-overview",headingTag:"h2"}}),v=new ut({props:{title:"Inference DLC Overview",local:"inference-dlc-overview",headingTag:"h2"}}),P=new ut({props:{title:"Hugging Face Transformers Amazon SageMaker Examples",local:"hugging-face-transformers-amazon-sagemaker-examples",headingTag:"h2"}}),B=new ut({props:{title:"Inference Toolkit API",local:"inference-toolkit-api",headingTag:"h2"}}),S=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),A=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyRG9uJ3QlMjB3YXN0ZSUyMHlvdXIlMjB0aW1lLiUyMCUyMFdlJTIwaGFkJTIwdHdvJTIwZGlmZmVyZW50JTIwcGVvcGxlJTIwY29tZSUyMHRvJTIwb3VyJTIwaG91c2UlMjB0byUyMGdpdmUlMjB1cyUyMGVzdGltYXRlcyUyMGZvciUwQWElMjBkZWNrJTIwKG9uZSUyMG9mJTIwdGhlbSUyMHRoZSUyME9XTkVSKS4lMjAlMjBCb3RoJTIwdGltZXMlMkMlMjB3ZSUyMG5ldmVyJTIwaGVhcmQlMjBmcm9tJTIwdGhlbS4lMjAlMjBOb3QlMjBhJTIwY2FsbCUyQyUyMG5vdCUyMHRoZSUyMGVzdGltYXRlJTJDJTIwbm90aGluZy4lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Don&#x27;t waste your time.  We had two different people come to our house to give us estimates for
a deck (one of them the OWNER).  Both times, we never heard from them.  Not a call, not the estimate, nothing.&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Z=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBTeWx2YWluJTIwYW5kJTIwSSUyMHdvcmslMjBhdCUyMEh1Z2dpbmclMjBGYWNlJTIwaW4lMjBCcm9va2x5bi4lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My name is Sylvain and I work at Hugging Face in Brooklyn.&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),N=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB1c2VkJTIwZm9yJTIwaW5mZXJlbmNlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMk15JTIwTmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjB1c2VkJTIwd2l0aCUyMHNhZ2VtYWtlciUyMGZvciUyMGluZmVyZW5jZS4lMjIlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is used for inference?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),z=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTIwJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;candidate_labels&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;refund&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;legal&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;faq&quot;</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Y=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YWJsZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJDb250cmlidXRvcnMlMjIlM0ElMjAlNUIlMjI2NTElMjIlMkMlMjAlMjI3NyUyMiUyQyUyMCUyMjM0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUyMiUzQSUyMCU1QiUyMlB5dGhvbiUyMiUyQyUyMCUyMlB5dGhvbiUyMiUyQyUyMCUyMlJ1c3QlMkMlMjBQeXRob24lMjBhbmQlMjBOb2RlSlMlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;query&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;table&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;Repository&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Transformers&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Datasets&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Tokenizers&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Stars&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;36542&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;4512&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;3934&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Contributors&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;651&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;77&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;34&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Programming language&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Rust, Python and NodeJS&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),R=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySHVnZ2luZyUyMEZhY2UlMkMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMFZlbnR1cmVCZWF0JUUyJTgwJTk5cyUyMElubm92YXRpb24lMjBpbiUyME5hdHVyYWwlMjBMYW5ndWFnZSUyMFByb2Nlc3MlMkZVbmRlcnN0YW5kaW5nJTIwQXdhcmQlMjBmb3IlMjAyMDIxJTJDJTIwaXMlMjBsb29raW5nJTIwdG8lMjBsZXZlbCUyMHRoZSUyMHBsYXlpbmclMjBmaWVsZC4lMjBUaGUlMjB0ZWFtJTJDJTIwbGF1bmNoZWQlMjBieSUyMENsJUMzJUE5bWVudCUyMERlbGFuZ3VlJTIwYW5kJTIwSnVsaWVuJTIwQ2hhdW1vbmQlMjBpbiUyMDIwMTYlMkMlMjB3YXMlMjByZWNvZ25pemVkJTIwZm9yJTIwaXRzJTIwd29yayUyMGluJTIwZGVtb2NyYXRpemluZyUyME5MUCUyQyUyMHRoZSUyMGdsb2JhbCUyMG1hcmtldCUyMHZhbHVlJTIwZm9yJTIwd2hpY2glMjBpcyUyMGV4cGVjdGVkJTIwdG8lMjBoaXQlMjAlMjQzNS4xJTIwYmlsbGlvbiUyMGJ5JTIwMjAyNi4lMjBUaGlzJTIwd2VlayUyQyUyMEdvb2dsZSVFMiU4MCU5OXMlMjBmb3JtZXIlMjBoZWFkJTIwb2YlMjBFdGhpY2FsJTIwQUklMjBNYXJnYXJldCUyME1pdGNoZWxsJTIwam9pbmVkJTIwdGhlJTIwdGVhbS4lMjIlMkMlMEElMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVwZXRpdGlvbl9wZW5hbHR5JTIyJTNBJTIwNC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybGVuZ3RoX3BlbmFsdHklMjIlM0ElMjAxLjUlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hugging Face, the winner of VentureBeat’s Innovation in Natural Language Process/Understanding Award for 2021, is looking to level the playing field. The team, launched by Clément Delangue and Julien Chaumond in 2016, was recognized for its work in democratizing NLP, the global market value for which is expected to hit $35.1 billion by 2026. This week, Google’s former head of Ethical AI Margaret Mitchell joined the team.&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;length_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.5</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),O=new ut({props:{title:"Inference Toolkit environment variables",local:"inference-toolkit-environment-variables",headingTag:"h2"}}),nt=new m({props:{code:"SEZfVEFTSyUzRCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMg==",highlighted:'HF_TASK=<span class="hljs-string">&quot;question-answering&quot;</span>',wrap:!1}}),lt=new m({props:{code:"SEZfTU9ERUxfSUQlM0QlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMg==",highlighted:'HF_MODEL_ID=<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>',wrap:!1}}),dt=new m({props:{code:"SEZfTU9ERUxfUkVWSVNJT04lM0QlMjIwM2I0ZDE5NmMxOWQwYTczYzdlMDMyMjY4NGU5N2RiMWVjMzk3NjEzJTIy",highlighted:'HF_MODEL_REVISION=<span class="hljs-string">&quot;03b4d196c19d0a73c7e0322684e97db1ec397613&quot;</span>',wrap:!1}}),ct=new m({props:{code:"SEZfQVBJX1RPS0VOJTNEJTIyYXBpX1hYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYJTIy",highlighted:'HF_API_TOKEN=<span class="hljs-string">&quot;api_XXXXXXXXXXXXXXXXXXXXXXXXXXXXX&quot;</span>',wrap:!1}}),{c(){f=o("meta"),mt=a(),ht=o("p"),ft=a(),r(T.$$.fragment),Tt=a(),r(M.$$.fragment),Mt=a(),y=o("p"),y.innerHTML=ge,yt=a(),w=o("p"),w.innerHTML=me,wt=a(),j=o("p"),j.innerHTML=fe,jt=a(),b=o("ul"),b.innerHTML=Te,bt=a(),J=o("p"),J.innerHTML=Me,Jt=a(),r(I.$$.fragment),It=a(),k=o("p"),k.textContent=ye,kt=a(),U=o("table"),U.innerHTML=we,Ut=a(),r(v.$$.fragment),vt=a(),_=o("p"),_.textContent=je,_t=a(),$=o("table"),$.innerHTML=be,$t=a(),r(P.$$.fragment),Pt=a(),C=o("p"),C.innerHTML=Je,Ct=a(),H=o("table"),H.innerHTML=Ie,Ht=a(),r(B.$$.fragment),Bt=a(),G=o("p"),G.innerHTML=ke,Gt=a(),E=o("p"),E.textContent=Ue,Et=a(),q=o("ul"),q.innerHTML=ve,qt=a(),x=o("p"),x.textContent=_e,xt=a(),F=o("p"),F.innerHTML=$e,Ft=a(),r(S.$$.fragment),St=a(),W=o("p"),W.innerHTML=Pe,Wt=a(),r(A.$$.fragment),At=a(),X=o("p"),X.innerHTML=Ce,Xt=a(),r(Z.$$.fragment),Zt=a(),L=o("p"),L.innerHTML=He,Lt=a(),r(N.$$.fragment),Nt=a(),V=o("p"),V.innerHTML=Be,Vt=a(),r(z.$$.fragment),zt=a(),Q=o("p"),Q.innerHTML=Ge,Qt=a(),r(Y.$$.fragment),Yt=a(),D=o("p"),D.innerHTML=Ee,Dt=a(),r(R.$$.fragment),Rt=a(),r(O.$$.fragment),Ot=a(),K=o("p"),K.textContent=qe,Kt=a(),tt=o("p"),tt.innerHTML=xe,te=a(),et=o("p"),et.innerHTML=Fe,ee=a(),r(nt.$$.fragment),ne=a(),st=o("p"),st.innerHTML=Se,se=a(),at=o("p"),at.innerHTML=We,ae=a(),r(lt.$$.fragment),le=a(),ot=o("p"),ot.innerHTML=Ae,oe=a(),it=o("p"),it.innerHTML=Xe,ie=a(),r(dt.$$.fragment),de=a(),rt=o("p"),rt.innerHTML=Ze,re=a(),pt=o("p"),pt.innerHTML=Le,pe=a(),r(ct.$$.fragment),ce=a(),gt=o("p"),this.h()},l(t){const e=Oe("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(n),mt=l(t),ht=i(t,"P",{}),Ne(ht).forEach(n),ft=l(t),p(T.$$.fragment,t),Tt=l(t),p(M.$$.fragment,t),Mt=l(t),y=i(t,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1s4u3mt"&&(y.innerHTML=ge),yt=l(t),w=i(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1u646kx"&&(w.innerHTML=me),wt=l(t),j=i(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1f0bs4o"&&(j.innerHTML=fe),jt=l(t),b=i(t,"UL",{"data-svelte-h":!0}),d(b)!=="svelte-1tys959"&&(b.innerHTML=Te),bt=l(t),J=i(t,"P",{"data-svelte-h":!0}),d(J)!=="svelte-grd5uv"&&(J.innerHTML=Me),Jt=l(t),p(I.$$.fragment,t),It=l(t),k=i(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1byqlum"&&(k.textContent=ye),kt=l(t),U=i(t,"TABLE",{"data-svelte-h":!0}),d(U)!=="svelte-7ymlvg"&&(U.innerHTML=we),Ut=l(t),p(v.$$.fragment,t),vt=l(t),_=i(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-14ncie8"&&(_.textContent=je),_t=l(t),$=i(t,"TABLE",{"data-svelte-h":!0}),d($)!=="svelte-iqlig"&&($.innerHTML=be),$t=l(t),p(P.$$.fragment,t),Pt=l(t),C=i(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1crg1k0"&&(C.innerHTML=Je),Ct=l(t),H=i(t,"TABLE",{"data-svelte-h":!0}),d(H)!=="svelte-6do7ie"&&(H.innerHTML=Ie),Ht=l(t),p(B.$$.fragment,t),Bt=l(t),G=i(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-12z3iiy"&&(G.innerHTML=ke),Gt=l(t),E=i(t,"P",{"data-svelte-h":!0}),d(E)!=="svelte-14avis7"&&(E.textContent=Ue),Et=l(t),q=i(t,"UL",{"data-svelte-h":!0}),d(q)!=="svelte-1swzyw"&&(q.innerHTML=ve),qt=l(t),x=i(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-fqnqo8"&&(x.textContent=_e),xt=l(t),F=i(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-zp6pme"&&(F.innerHTML=$e),Ft=l(t),p(S.$$.fragment,t),St=l(t),W=i(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-zfr1l6"&&(W.innerHTML=Pe),Wt=l(t),p(A.$$.fragment,t),At=l(t),X=i(t,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1a5sljg"&&(X.innerHTML=Ce),Xt=l(t),p(Z.$$.fragment,t),Zt=l(t),L=i(t,"P",{"data-svelte-h":!0}),d(L)!=="svelte-7ht279"&&(L.innerHTML=He),Lt=l(t),p(N.$$.fragment,t),Nt=l(t),V=i(t,"P",{"data-svelte-h":!0}),d(V)!=="svelte-455rcs"&&(V.innerHTML=Be),Vt=l(t),p(z.$$.fragment,t),zt=l(t),Q=i(t,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-w6paxw"&&(Q.innerHTML=Ge),Qt=l(t),p(Y.$$.fragment,t),Yt=l(t),D=i(t,"P",{"data-svelte-h":!0}),d(D)!=="svelte-17c454l"&&(D.innerHTML=Ee),Dt=l(t),p(R.$$.fragment,t),Rt=l(t),p(O.$$.fragment,t),Ot=l(t),K=i(t,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1hi83ly"&&(K.textContent=qe),Kt=l(t),tt=i(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-op5ire"&&(tt.innerHTML=xe),te=l(t),et=i(t,"P",{"data-svelte-h":!0}),d(et)!=="svelte-x44ycw"&&(et.innerHTML=Fe),ee=l(t),p(nt.$$.fragment,t),ne=l(t),st=i(t,"P",{"data-svelte-h":!0}),d(st)!=="svelte-at3940"&&(st.innerHTML=Se),se=l(t),at=i(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-7pv5qy"&&(at.innerHTML=We),ae=l(t),p(lt.$$.fragment,t),le=l(t),ot=i(t,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1cqzoxg"&&(ot.innerHTML=Ae),oe=l(t),it=i(t,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1xh4jnx"&&(it.innerHTML=Xe),ie=l(t),p(dt.$$.fragment,t),de=l(t),rt=i(t,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-y1zqs5"&&(rt.innerHTML=Ze),re=l(t),pt=i(t,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-wfdtbd"&&(pt.innerHTML=Le),pe=l(t),p(ct.$$.fragment,t),ce=l(t),gt=i(t,"P",{}),Ne(gt).forEach(n),this.h()},h(){Ve(f,"name","hf:doc:metadata"),Ve(f,"content",en)},m(t,e){Ke(document.head,f),s(t,mt,e),s(t,ht,e),s(t,ft,e),c(T,t,e),s(t,Tt,e),c(M,t,e),s(t,Mt,e),s(t,y,e),s(t,yt,e),s(t,w,e),s(t,wt,e),s(t,j,e),s(t,jt,e),s(t,b,e),s(t,bt,e),s(t,J,e),s(t,Jt,e),c(I,t,e),s(t,It,e),s(t,k,e),s(t,kt,e),s(t,U,e),s(t,Ut,e),c(v,t,e),s(t,vt,e),s(t,_,e),s(t,_t,e),s(t,$,e),s(t,$t,e),c(P,t,e),s(t,Pt,e),s(t,C,e),s(t,Ct,e),s(t,H,e),s(t,Ht,e),c(B,t,e),s(t,Bt,e),s(t,G,e),s(t,Gt,e),s(t,E,e),s(t,Et,e),s(t,q,e),s(t,qt,e),s(t,x,e),s(t,xt,e),s(t,F,e),s(t,Ft,e),c(S,t,e),s(t,St,e),s(t,W,e),s(t,Wt,e),c(A,t,e),s(t,At,e),s(t,X,e),s(t,Xt,e),c(Z,t,e),s(t,Zt,e),s(t,L,e),s(t,Lt,e),c(N,t,e),s(t,Nt,e),s(t,V,e),s(t,Vt,e),c(z,t,e),s(t,zt,e),s(t,Q,e),s(t,Qt,e),c(Y,t,e),s(t,Yt,e),s(t,D,e),s(t,Dt,e),c(R,t,e),s(t,Rt,e),c(O,t,e),s(t,Ot,e),s(t,K,e),s(t,Kt,e),s(t,tt,e),s(t,te,e),s(t,et,e),s(t,ee,e),c(nt,t,e),s(t,ne,e),s(t,st,e),s(t,se,e),s(t,at,e),s(t,ae,e),c(lt,t,e),s(t,le,e),s(t,ot,e),s(t,oe,e),s(t,it,e),s(t,ie,e),c(dt,t,e),s(t,de,e),s(t,rt,e),s(t,re,e),s(t,pt,e),s(t,pe,e),c(ct,t,e),s(t,ce,e),s(t,gt,e),ue=!0},p:Qe,i(t){ue||(u(T.$$.fragment,t),u(M.$$.fragment,t),u(I.$$.fragment,t),u(v.$$.fragment,t),u(P.$$.fragment,t),u(B.$$.fragment,t),u(S.$$.fragment,t),u(A.$$.fragment,t),u(Z.$$.fragment,t),u(N.$$.fragment,t),u(z.$$.fragment,t),u(Y.$$.fragment,t),u(R.$$.fragment,t),u(O.$$.fragment,t),u(nt.$$.fragment,t),u(lt.$$.fragment,t),u(dt.$$.fragment,t),u(ct.$$.fragment,t),ue=!0)},o(t){h(T.$$.fragment,t),h(M.$$.fragment,t),h(I.$$.fragment,t),h(v.$$.fragment,t),h(P.$$.fragment,t),h(B.$$.fragment,t),h(S.$$.fragment,t),h(A.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(z.$$.fragment,t),h(Y.$$.fragment,t),h(R.$$.fragment,t),h(O.$$.fragment,t),h(nt.$$.fragment,t),h(lt.$$.fragment,t),h(dt.$$.fragment,t),h(ct.$$.fragment,t),ue=!1},d(t){t&&(n(mt),n(ht),n(ft),n(Tt),n(Mt),n(y),n(yt),n(w),n(wt),n(j),n(jt),n(b),n(bt),n(J),n(Jt),n(It),n(k),n(kt),n(U),n(Ut),n(vt),n(_),n(_t),n($),n($t),n(Pt),n(C),n(Ct),n(H),n(Ht),n(Bt),n(G),n(Gt),n(E),n(Et),n(q),n(qt),n(x),n(xt),n(F),n(Ft),n(St),n(W),n(Wt),n(At),n(X),n(Xt),n(Zt),n(L),n(Lt),n(Nt),n(V),n(Vt),n(zt),n(Q),n(Qt),n(Yt),n(D),n(Dt),n(Rt),n(Ot),n(K),n(Kt),n(tt),n(te),n(et),n(ee),n(ne),n(st),n(se),n(at),n(ae),n(le),n(ot),n(oe),n(it),n(ie),n(de),n(rt),n(re),n(pt),n(pe),n(ce),n(gt)),n(f),g(T,t),g(M,t),g(I,t),g(v,t),g(P,t),g(B,t),g(S,t),g(A,t),g(Z,t),g(N,t),g(z,t),g(Y,t),g(R,t),g(O,t),g(nt,t),g(lt,t),g(dt,t),g(ct,t)}}}const en='{"title":"Reference","local":"reference","sections":[{"title":"Deep Learning Container","local":"deep-learning-container","sections":[],"depth":2},{"title":"Training DLC Overview","local":"training-dlc-overview","sections":[],"depth":2},{"title":"Inference DLC Overview","local":"inference-dlc-overview","sections":[],"depth":2},{"title":"Hugging Face Transformers Amazon SageMaker Examples","local":"hugging-face-transformers-amazon-sagemaker-examples","sections":[],"depth":2},{"title":"Inference Toolkit API","local":"inference-toolkit-api","sections":[],"depth":2},{"title":"Inference Toolkit environment variables","local":"inference-toolkit-environment-variables","sections":[],"depth":2}],"depth":1}';function nn(he){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends De{constructor(f){super(),Re(this,f,nn,tn,ze,{})}}export{dn as component};
