import{s as In,n as Rn,o as Hn}from"../chunks/scheduler.85c25b89.js";import{S as En,i as Gn,g as n,s as a,r as p,A as Sn,h as o,f as i,c as r,j as u,u as d,x as s,k as v,y as t,a as l,v as c,d as g,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.5c1d567f.js";import{H as wa,E as On}from"../chunks/EditOnGithub.b65eee75.js";function Bn(Nr){let G,Gt,Ht,St,te,Ot,ae,Fr="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",Bt,re,Vt,ne,qt,S,oe,Aa,Oe,Ir=`Legacy optimizer factory for backwards compatibility.
NOTE: Use create_optimizer_v2 for new code.`,Wt,z,ie,La,Be,Rr="Create an optimizer.",Ca,Ve,Hr=`TODO currently the model is passed in and all parameters are selected for optimization.
For more general use an interface that allows selection of parameters to optimize and lr groups, one of:`,Ta,qe,Er="<li>a filter fn interface that further breaks params into groups in a weight_decay compatible fashion</li> <li>expose the parameters interface and leave it up to caller</li>",kt,me,jt,x,se,Da,We,Gr="Implements AdaBelief algorithm. Modified from Adam in PyTorch",za,ke,Sr="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Ma,je,Or=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Pa,Ue,Br='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Na,O,le,Fa,Ze,Vr="Performs a single optimization step.",Ut,L,pe,Ia,Qe,qr=`Implements Adafactor algorithm.
This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,Ra,Xe,Wr=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,Ha,Je,kr=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,Ea,B,de,Ga,Ke,jr="Performs a single optimization step.",Zt,$,ce,Sa,Ye,Ur="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",Oa,V,ge,Ba,et,Zr="Gets all parameters in all param_groups with gradients",Va,q,fe,qa,tt,Qr="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",Wa,W,he,ka,at,Xr="Performs a single optimization step.",ja,k,ue,Ua,rt,Jr="Zeros out the accumalated hessian traces.",Qt,ve,be,Xt,C,_e,Za,nt,Kr="Implements AdamW algorithm.",Qa,ot,Yr=`The original Adam algorithm was proposed in <code>Adam: A Method for Stochastic Optimization</code><em>.
The AdamW variant was proposed in <code>Decoupled Weight Decay Regularization</code></em>.`,Xa,it,en=`.. _Adam\\: A Method for Stochastic Optimization:
<a href="https://arxiv.org/abs/1412.6980" rel="nofollow">https://arxiv.org/abs/1412.6980</a>
.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,Ja,j,ye,Ka,mt,tn="Performs a single optimization step.",Jt,T,xe,Ya,st,an=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,er,lt,rn="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",tr,pt,nn=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,ar,U,$e,rr,dt,on="Performs a single optimization step.",Kt,M,we,nr,ct,mn="LARS for PyTorch",or,gt,sn='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',ir,Z,Ae,mr,ft,ln="Performs a single optimization step.",Yt,Le,Ce,ea,y,Te,sr,ht,pn=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,lr,ut,dn='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',pr,vt,cn=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,dr,bt,gn=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,cr,_t,fn="On sparse problems both weight_decay and momentum should be set to 0.",gr,Q,De,fr,yt,hn="Performs a single optimization step.",ta,w,ze,hr,xt,un="Implements Nadam algorithm (a variant of Adam based on Nesterov momentum).",ur,$t,vn="It has been proposed in <code>Incorporating Nesterov Momentum into Adam</code>__.",vr,wt,bn='<strong><a href="http://cs229.stanford.edu/proj2015/054_report.pdf" rel="nofollow">http://cs229.stanford.edu/proj2015/054_report.pdf</a></strong> <a href="http://www.cs.toronto.edu/~fritz/absps/momentum.pdf" rel="nofollow">http://www.cs.toronto.edu/~fritz/absps/momentum.pdf</a>',br,At,_n=`Originally taken from: <a href="https://github.com/pytorch/pytorch/pull/1408" rel="nofollow">https://github.com/pytorch/pytorch/pull/1408</a>
NOTE: Has potential issues but does work well on some problems.`,_r,X,Me,yr,Lt,yn="Performs a single optimization step.",aa,I,Pe,xr,Ct,xn="Implements Novograd algorithm.",$r,J,Ne,wr,Tt,$n="Performs a single optimization step.",ra,Fe,Ie,na,_,Re,Ar,Dt,wn="Implements RMSprop algorithm (TensorFlow style epsilon)",Lr,zt,An=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,Cr,Mt,Ln="Noteworthy changes include:",Tr,Pt,Cn="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",Dr,Nt,Tn=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,zr,Ft,Dn=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,Mr,K,He,Pr,It,zn="Performs a single optimization step.",oa,Ee,Ge,ia,Se,ma,Et,sa;return te=new wa({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),re=new wa({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),ne=new wa({props:{title:"Factory functions",local:"timm.optim.create_optimizer",headingTag:"h3"}}),oe=new b({props:{name:"timm.optim.create_optimizer",anchor:"timm.optim.create_optimizer",parameters:[{name:"args",val:""},{name:"model",val:""},{name:"filter_bias_and_bn",val:" = True"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/optim_factory.py#L183"}}),ie=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:""},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": Optional = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": Optional = None"},{name:"param_group_fn",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> (nn.Module) &#x2014; model containing parameters to optimize
opt &#x2014; name of optimizer to create
lr &#x2014; initial learning rate
weight_decay &#x2014; weight decay to apply in optimizer
momentum &#x2014;  momentum for momentum based optimizers (others may use betas via kwargs)
foreach &#x2014; Enable / disable foreach (multi-tensor) operation if True / False. Choose safe default if None
filter_bias_and_bn &#x2014;  filter out bias, bn and other 1d params from weight decay
**kwargs &#x2014; extra optimizer specific kwargs to pass through`,name:"model_or_params"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/optim_factory.py#L194",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Optimizer</p>
`}}),me=new wa({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),se=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L6"}}),le=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L89"}}),pe=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L16"}}),de=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L79"}}),ce=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L9"}}),ge=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L58"}}),fe=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L74"}}),he=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L102"}}),ue=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L65"}}),be=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamp.py#L43"}}),_e=new b({props:{name:"class timm.optim.AdamW",anchor:"timm.optim.AdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.AdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.AdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"},{anchor:"timm.optim.AdamW.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L12"}}),ye=new b({props:{name:"step",anchor:"timm.optim.AdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L58"}}),xe=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L60"}}),$e=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L96"}}),we=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L17"}}),Ae=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L75"}}),Ce=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lookahead.py#L15"}}),Te=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L24"}}),De=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": Optional = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L85"}}),ze=new b({props:{name:"class timm.optim.Nadam",anchor:"timm.optim.Nadam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.002"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"schedule_decay",val:" = 0.004"}],parametersDescription:[{anchor:"timm.optim.Nadam.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.Nadam.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 2e-3)",name:"lr"},{anchor:"timm.optim.Nadam.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square`,name:"betas"},{anchor:"timm.optim.Nadam.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Nadam.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Nadam.schedule_decay",description:"<strong>schedule_decay</strong> (float, optional) &#x2014; momentum schedule decay (default: 4e-3)",name:"schedule_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L7"}}),Me=new b({props:{name:"step",anchor:"timm.optim.Nadam.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Nadam.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L43"}}),Pe=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:`<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)
grad_averaging &#x2014; gradient averaging`,name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L13"}}),Ne=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L54"}}),Ie=new b({props:{name:"class timm.optim.RAdam",anchor:"timm.optim.RAdam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/radam.py#L10"}}),Re=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L14"}}),He=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L72"}}),Ge=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdp.py#L19"}}),Se=new On({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){G=n("meta"),Gt=a(),Ht=n("p"),St=a(),p(te.$$.fragment),Ot=a(),ae=n("p"),ae.innerHTML=Fr,Bt=a(),p(re.$$.fragment),Vt=a(),p(ne.$$.fragment),qt=a(),S=n("div"),p(oe.$$.fragment),Aa=a(),Oe=n("p"),Oe.textContent=Ir,Wt=a(),z=n("div"),p(ie.$$.fragment),La=a(),Be=n("p"),Be.textContent=Rr,Ca=a(),Ve=n("p"),Ve.textContent=Hr,Ta=a(),qe=n("ul"),qe.innerHTML=Er,kt=a(),p(me.$$.fragment),jt=a(),x=n("div"),p(se.$$.fragment),Da=a(),We=n("p"),We.textContent=Gr,za=a(),ke=n("p"),ke.textContent=Sr,Ma=a(),je=n("p"),je.innerHTML=Or,Pa=a(),Ue=n("ul"),Ue.innerHTML=Br,Na=a(),O=n("div"),p(le.$$.fragment),Fa=a(),Ze=n("p"),Ze.textContent=Vr,Ut=a(),L=n("div"),p(pe.$$.fragment),Ia=a(),Qe=n("p"),Qe.innerHTML=qr,Ra=a(),Xe=n("p"),Xe.innerHTML=Wr,Ha=a(),Je=n("p"),Je.innerHTML=kr,Ea=a(),B=n("div"),p(de.$$.fragment),Ga=a(),Ke=n("p"),Ke.textContent=jr,Zt=a(),$=n("div"),p(ce.$$.fragment),Sa=a(),Ye=n("p"),Ye.textContent=Ur,Oa=a(),V=n("div"),p(ge.$$.fragment),Ba=a(),et=n("p"),et.textContent=Zr,Va=a(),q=n("div"),p(fe.$$.fragment),qa=a(),tt=n("p"),tt.textContent=Qr,Wa=a(),W=n("div"),p(he.$$.fragment),ka=a(),at=n("p"),at.textContent=Xr,ja=a(),k=n("div"),p(ue.$$.fragment),Ua=a(),rt=n("p"),rt.textContent=Jr,Qt=a(),ve=n("div"),p(be.$$.fragment),Xt=a(),C=n("div"),p(_e.$$.fragment),Za=a(),nt=n("p"),nt.textContent=Kr,Qa=a(),ot=n("p"),ot.innerHTML=Yr,Xa=a(),it=n("p"),it.innerHTML=en,Ja=a(),j=n("div"),p(ye.$$.fragment),Ka=a(),mt=n("p"),mt.textContent=tn,Jt=a(),T=n("div"),p(xe.$$.fragment),Ya=a(),st=n("p"),st.innerHTML=an,er=a(),lt=n("p"),lt.innerHTML=rn,tr=a(),pt=n("p"),pt.innerHTML=nn,ar=a(),U=n("div"),p($e.$$.fragment),rr=a(),dt=n("p"),dt.textContent=on,Kt=a(),M=n("div"),p(we.$$.fragment),nr=a(),ct=n("p"),ct.textContent=mn,or=a(),gt=n("p"),gt.innerHTML=sn,ir=a(),Z=n("div"),p(Ae.$$.fragment),mr=a(),ft=n("p"),ft.textContent=ln,Yt=a(),Le=n("div"),p(Ce.$$.fragment),ea=a(),y=n("div"),p(Te.$$.fragment),sr=a(),ht=n("p"),ht.textContent=pn,lr=a(),ut=n("p"),ut.innerHTML=dn,pr=a(),vt=n("p"),vt.textContent=cn,dr=a(),bt=n("p"),bt.textContent=gn,cr=a(),_t=n("p"),_t.textContent=fn,gr=a(),Q=n("div"),p(De.$$.fragment),fr=a(),yt=n("p"),yt.textContent=hn,ta=a(),w=n("div"),p(ze.$$.fragment),hr=a(),xt=n("p"),xt.textContent=un,ur=a(),$t=n("p"),$t.innerHTML=vn,vr=a(),wt=n("p"),wt.innerHTML=bn,br=a(),At=n("p"),At.innerHTML=_n,_r=a(),X=n("div"),p(Me.$$.fragment),yr=a(),Lt=n("p"),Lt.textContent=yn,aa=a(),I=n("div"),p(Pe.$$.fragment),xr=a(),Ct=n("p"),Ct.textContent=xn,$r=a(),J=n("div"),p(Ne.$$.fragment),wr=a(),Tt=n("p"),Tt.textContent=$n,ra=a(),Fe=n("div"),p(Ie.$$.fragment),na=a(),_=n("div"),p(Re.$$.fragment),Ar=a(),Dt=n("p"),Dt.textContent=wn,Lr=a(),zt=n("p"),zt.textContent=An,Cr=a(),Mt=n("p"),Mt.textContent=Ln,Tr=a(),Pt=n("ol"),Pt.innerHTML=Cn,Dr=a(),Nt=n("p"),Nt.innerHTML=Tn,zr=a(),Ft=n("p"),Ft.innerHTML=Dn,Mr=a(),K=n("div"),p(He.$$.fragment),Pr=a(),It=n("p"),It.textContent=zn,oa=a(),Ee=n("div"),p(Ge.$$.fragment),ia=a(),p(Se.$$.fragment),ma=a(),Et=n("p"),this.h()},l(e){const m=Sn("svelte-u9bgzb",document.head);G=o(m,"META",{name:!0,content:!0}),m.forEach(i),Gt=r(e),Ht=o(e,"P",{}),u(Ht).forEach(i),St=r(e),d(te.$$.fragment,e),Ot=r(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1c6qm22"&&(ae.innerHTML=Fr),Bt=r(e),d(re.$$.fragment,e),Vt=r(e),d(ne.$$.fragment,e),qt=r(e),S=o(e,"DIV",{class:!0});var la=u(S);d(oe.$$.fragment,la),Aa=r(la),Oe=o(la,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1dlcrvh"&&(Oe.textContent=Ir),la.forEach(i),Wt=r(e),z=o(e,"DIV",{class:!0});var Y=u(z);d(ie.$$.fragment,Y),La=r(Y),Be=o(Y,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-12lpmmq"&&(Be.textContent=Rr),Ca=r(Y),Ve=o(Y,"P",{"data-svelte-h":!0}),s(Ve)!=="svelte-ocfv4n"&&(Ve.textContent=Hr),Ta=r(Y),qe=o(Y,"UL",{"data-svelte-h":!0}),s(qe)!=="svelte-qarx5u"&&(qe.innerHTML=Er),Y.forEach(i),kt=r(e),d(me.$$.fragment,e),jt=r(e),x=o(e,"DIV",{class:!0});var P=u(x);d(se.$$.fragment,P),Da=r(P),We=o(P,"P",{"data-svelte-h":!0}),s(We)!=="svelte-1hnunr4"&&(We.textContent=Gr),za=r(P),ke=o(P,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-1cjb7xo"&&(ke.textContent=Sr),Ma=r(P),je=o(P,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1347q2l"&&(je.innerHTML=Or),Pa=r(P),Ue=o(P,"UL",{"data-svelte-h":!0}),s(Ue)!=="svelte-12x3l9q"&&(Ue.innerHTML=Br),Na=r(P),O=o(P,"DIV",{class:!0});var pa=u(O);d(le.$$.fragment,pa),Fa=r(pa),Ze=o(pa,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1gr03w4"&&(Ze.textContent=Vr),pa.forEach(i),P.forEach(i),Ut=r(e),L=o(e,"DIV",{class:!0});var R=u(L);d(pe.$$.fragment,R),Ia=r(R),Qe=o(R,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1pwmpx3"&&(Qe.innerHTML=qr),Ra=r(R),Xe=o(R,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-1i7ubkr"&&(Xe.innerHTML=Wr),Ha=r(R),Je=o(R,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-96f97i"&&(Je.innerHTML=kr),Ea=r(R),B=o(R,"DIV",{class:!0});var da=u(B);d(de.$$.fragment,da),Ga=r(da),Ke=o(da,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-1gr03w4"&&(Ke.textContent=jr),da.forEach(i),R.forEach(i),Zt=r(e),$=o(e,"DIV",{class:!0});var N=u($);d(ce.$$.fragment,N),Sa=r(N),Ye=o(N,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-1cuo0rh"&&(Ye.textContent=Ur),Oa=r(N),V=o(N,"DIV",{class:!0});var ca=u(V);d(ge.$$.fragment,ca),Ba=r(ca),et=o(ca,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1jz1hl7"&&(et.textContent=Zr),ca.forEach(i),Va=r(N),q=o(N,"DIV",{class:!0});var ga=u(q);d(fe.$$.fragment,ga),qa=r(ga),tt=o(ga,"P",{"data-svelte-h":!0}),s(tt)!=="svelte-1y1oyzd"&&(tt.textContent=Qr),ga.forEach(i),Wa=r(N),W=o(N,"DIV",{class:!0});var fa=u(W);d(he.$$.fragment,fa),ka=r(fa),at=o(fa,"P",{"data-svelte-h":!0}),s(at)!=="svelte-1gr03w4"&&(at.textContent=Xr),fa.forEach(i),ja=r(N),k=o(N,"DIV",{class:!0});var ha=u(k);d(ue.$$.fragment,ha),Ua=r(ha),rt=o(ha,"P",{"data-svelte-h":!0}),s(rt)!=="svelte-4lvf5h"&&(rt.textContent=Jr),ha.forEach(i),N.forEach(i),Qt=r(e),ve=o(e,"DIV",{class:!0});var Mn=u(ve);d(be.$$.fragment,Mn),Mn.forEach(i),Xt=r(e),C=o(e,"DIV",{class:!0});var H=u(C);d(_e.$$.fragment,H),Za=r(H),nt=o(H,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-c51pd7"&&(nt.textContent=Kr),Qa=r(H),ot=o(H,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-1cgyzi6"&&(ot.innerHTML=Yr),Xa=r(H),it=o(H,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1pe3ewc"&&(it.innerHTML=en),Ja=r(H),j=o(H,"DIV",{class:!0});var ua=u(j);d(ye.$$.fragment,ua),Ka=r(ua),mt=o(ua,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-1gr03w4"&&(mt.textContent=tn),ua.forEach(i),H.forEach(i),Jt=r(e),T=o(e,"DIV",{class:!0});var E=u(T);d(xe.$$.fragment,E),Ya=r(E),st=o(E,"P",{"data-svelte-h":!0}),s(st)!=="svelte-d5zqgn"&&(st.innerHTML=an),er=r(E),lt=o(E,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1wamkfv"&&(lt.innerHTML=rn),tr=r(E),pt=o(E,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-dty621"&&(pt.innerHTML=nn),ar=r(E),U=o(E,"DIV",{class:!0});var va=u(U);d($e.$$.fragment,va),rr=r(va),dt=o(va,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-1gr03w4"&&(dt.textContent=on),va.forEach(i),E.forEach(i),Kt=r(e),M=o(e,"DIV",{class:!0});var ee=u(M);d(we.$$.fragment,ee),nr=r(ee),ct=o(ee,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-vzcsb8"&&(ct.textContent=mn),or=r(ee),gt=o(ee,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-euart9"&&(gt.innerHTML=sn),ir=r(ee),Z=o(ee,"DIV",{class:!0});var ba=u(Z);d(Ae.$$.fragment,ba),mr=r(ba),ft=o(ba,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-1gr03w4"&&(ft.textContent=ln),ba.forEach(i),ee.forEach(i),Yt=r(e),Le=o(e,"DIV",{class:!0});var Pn=u(Le);d(Ce.$$.fragment,Pn),Pn.forEach(i),ea=r(e),y=o(e,"DIV",{class:!0});var D=u(y);d(Te.$$.fragment,D),sr=r(D),ht=o(D,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-wmmdpx"&&(ht.textContent=pn),lr=r(D),ut=o(D,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-12dyngi"&&(ut.innerHTML=dn),pr=r(D),vt=o(D,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-qjjdis"&&(vt.textContent=cn),dr=r(D),bt=o(D,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-rosfou"&&(bt.textContent=gn),cr=r(D),_t=o(D,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-hlwvkn"&&(_t.textContent=fn),gr=r(D),Q=o(D,"DIV",{class:!0});var _a=u(Q);d(De.$$.fragment,_a),fr=r(_a),yt=o(_a,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-1gr03w4"&&(yt.textContent=hn),_a.forEach(i),D.forEach(i),ta=r(e),w=o(e,"DIV",{class:!0});var F=u(w);d(ze.$$.fragment,F),hr=r(F),xt=o(F,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-1ss2c23"&&(xt.textContent=un),ur=r(F),$t=o(F,"P",{"data-svelte-h":!0}),s($t)!=="svelte-ewqetr"&&($t.innerHTML=vn),vr=r(F),wt=o(F,"P",{"data-svelte-h":!0}),s(wt)!=="svelte-1q705lb"&&(wt.innerHTML=bn),br=r(F),At=o(F,"P",{"data-svelte-h":!0}),s(At)!=="svelte-14ul3re"&&(At.innerHTML=_n),_r=r(F),X=o(F,"DIV",{class:!0});var ya=u(X);d(Me.$$.fragment,ya),yr=r(ya),Lt=o(ya,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-1gr03w4"&&(Lt.textContent=yn),ya.forEach(i),F.forEach(i),aa=r(e),I=o(e,"DIV",{class:!0});var Rt=u(I);d(Pe.$$.fragment,Rt),xr=r(Rt),Ct=o(Rt,"P",{"data-svelte-h":!0}),s(Ct)!=="svelte-5vv99d"&&(Ct.textContent=xn),$r=r(Rt),J=o(Rt,"DIV",{class:!0});var xa=u(J);d(Ne.$$.fragment,xa),wr=r(xa),Tt=o(xa,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-1gr03w4"&&(Tt.textContent=$n),xa.forEach(i),Rt.forEach(i),ra=r(e),Fe=o(e,"DIV",{class:!0});var Nn=u(Fe);d(Ie.$$.fragment,Nn),Nn.forEach(i),na=r(e),_=o(e,"DIV",{class:!0});var A=u(_);d(Re.$$.fragment,A),Ar=r(A),Dt=o(A,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1tqv0s5"&&(Dt.textContent=wn),Lr=r(A),zt=o(A,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-g10xv4"&&(zt.textContent=An),Cr=r(A),Mt=o(A,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-1acg3vg"&&(Mt.textContent=Ln),Tr=r(A),Pt=o(A,"OL",{"data-svelte-h":!0}),s(Pt)!=="svelte-15y6o6y"&&(Pt.innerHTML=Cn),Dr=r(A),Nt=o(A,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1yvkj2h"&&(Nt.innerHTML=Tn),zr=r(A),Ft=o(A,"P",{"data-svelte-h":!0}),s(Ft)!=="svelte-53x1ow"&&(Ft.innerHTML=Dn),Mr=r(A),K=o(A,"DIV",{class:!0});var $a=u(K);d(He.$$.fragment,$a),Pr=r($a),It=o($a,"P",{"data-svelte-h":!0}),s(It)!=="svelte-1gr03w4"&&(It.textContent=zn),$a.forEach(i),A.forEach(i),oa=r(e),Ee=o(e,"DIV",{class:!0});var Fn=u(Ee);d(Ge.$$.fragment,Fn),Fn.forEach(i),ia=r(e),d(Se.$$.fragment,e),ma=r(e),Et=o(e,"P",{}),u(Et).forEach(i),this.h()},h(){v(G,"name","hf:doc:metadata"),v(G,"content",Vn),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,m){t(document.head,G),l(e,Gt,m),l(e,Ht,m),l(e,St,m),c(te,e,m),l(e,Ot,m),l(e,ae,m),l(e,Bt,m),c(re,e,m),l(e,Vt,m),c(ne,e,m),l(e,qt,m),l(e,S,m),c(oe,S,null),t(S,Aa),t(S,Oe),l(e,Wt,m),l(e,z,m),c(ie,z,null),t(z,La),t(z,Be),t(z,Ca),t(z,Ve),t(z,Ta),t(z,qe),l(e,kt,m),c(me,e,m),l(e,jt,m),l(e,x,m),c(se,x,null),t(x,Da),t(x,We),t(x,za),t(x,ke),t(x,Ma),t(x,je),t(x,Pa),t(x,Ue),t(x,Na),t(x,O),c(le,O,null),t(O,Fa),t(O,Ze),l(e,Ut,m),l(e,L,m),c(pe,L,null),t(L,Ia),t(L,Qe),t(L,Ra),t(L,Xe),t(L,Ha),t(L,Je),t(L,Ea),t(L,B),c(de,B,null),t(B,Ga),t(B,Ke),l(e,Zt,m),l(e,$,m),c(ce,$,null),t($,Sa),t($,Ye),t($,Oa),t($,V),c(ge,V,null),t(V,Ba),t(V,et),t($,Va),t($,q),c(fe,q,null),t(q,qa),t(q,tt),t($,Wa),t($,W),c(he,W,null),t(W,ka),t(W,at),t($,ja),t($,k),c(ue,k,null),t(k,Ua),t(k,rt),l(e,Qt,m),l(e,ve,m),c(be,ve,null),l(e,Xt,m),l(e,C,m),c(_e,C,null),t(C,Za),t(C,nt),t(C,Qa),t(C,ot),t(C,Xa),t(C,it),t(C,Ja),t(C,j),c(ye,j,null),t(j,Ka),t(j,mt),l(e,Jt,m),l(e,T,m),c(xe,T,null),t(T,Ya),t(T,st),t(T,er),t(T,lt),t(T,tr),t(T,pt),t(T,ar),t(T,U),c($e,U,null),t(U,rr),t(U,dt),l(e,Kt,m),l(e,M,m),c(we,M,null),t(M,nr),t(M,ct),t(M,or),t(M,gt),t(M,ir),t(M,Z),c(Ae,Z,null),t(Z,mr),t(Z,ft),l(e,Yt,m),l(e,Le,m),c(Ce,Le,null),l(e,ea,m),l(e,y,m),c(Te,y,null),t(y,sr),t(y,ht),t(y,lr),t(y,ut),t(y,pr),t(y,vt),t(y,dr),t(y,bt),t(y,cr),t(y,_t),t(y,gr),t(y,Q),c(De,Q,null),t(Q,fr),t(Q,yt),l(e,ta,m),l(e,w,m),c(ze,w,null),t(w,hr),t(w,xt),t(w,ur),t(w,$t),t(w,vr),t(w,wt),t(w,br),t(w,At),t(w,_r),t(w,X),c(Me,X,null),t(X,yr),t(X,Lt),l(e,aa,m),l(e,I,m),c(Pe,I,null),t(I,xr),t(I,Ct),t(I,$r),t(I,J),c(Ne,J,null),t(J,wr),t(J,Tt),l(e,ra,m),l(e,Fe,m),c(Ie,Fe,null),l(e,na,m),l(e,_,m),c(Re,_,null),t(_,Ar),t(_,Dt),t(_,Lr),t(_,zt),t(_,Cr),t(_,Mt),t(_,Tr),t(_,Pt),t(_,Dr),t(_,Nt),t(_,zr),t(_,Ft),t(_,Mr),t(_,K),c(He,K,null),t(K,Pr),t(K,It),l(e,oa,m),l(e,Ee,m),c(Ge,Ee,null),l(e,ia,m),c(Se,e,m),l(e,ma,m),l(e,Et,m),sa=!0},p:Rn,i(e){sa||(g(te.$$.fragment,e),g(re.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(ie.$$.fragment,e),g(me.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(be.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(we.$$.fragment,e),g(Ae.$$.fragment,e),g(Ce.$$.fragment,e),g(Te.$$.fragment,e),g(De.$$.fragment,e),g(ze.$$.fragment,e),g(Me.$$.fragment,e),g(Pe.$$.fragment,e),g(Ne.$$.fragment,e),g(Ie.$$.fragment,e),g(Re.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(Se.$$.fragment,e),sa=!0)},o(e){f(te.$$.fragment,e),f(re.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(ie.$$.fragment,e),f(me.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(be.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Ae.$$.fragment,e),f(Ce.$$.fragment,e),f(Te.$$.fragment,e),f(De.$$.fragment,e),f(ze.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ie.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),sa=!1},d(e){e&&(i(Gt),i(Ht),i(St),i(Ot),i(ae),i(Bt),i(Vt),i(qt),i(S),i(Wt),i(z),i(kt),i(jt),i(x),i(Ut),i(L),i(Zt),i($),i(Qt),i(ve),i(Xt),i(C),i(Jt),i(T),i(Kt),i(M),i(Yt),i(Le),i(ea),i(y),i(ta),i(w),i(aa),i(I),i(ra),i(Fe),i(na),i(_),i(oa),i(Ee),i(ia),i(ma),i(Et)),i(G),h(te,e),h(re,e),h(ne,e),h(oe),h(ie),h(me,e),h(se),h(le),h(pe),h(de),h(ce),h(ge),h(fe),h(he),h(ue),h(be),h(_e),h(ye),h(xe),h($e),h(we),h(Ae),h(Ce),h(Te),h(De),h(ze),h(Me),h(Pe),h(Ne),h(Ie),h(Re),h(He),h(Ge),h(Se,e)}}}const Vn='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer","sections":[],"depth":3},{"title":"Optimizer Classes","local":"timm.optim.AdaBelief","sections":[],"depth":3}],"depth":2}],"depth":1}';function qn(Nr){return Hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends En{constructor(G){super(),Gn(this,G,qn,Bn,In,{})}}export{Zn as component};
