import{s as ct,n as dt,o as ft}from"../chunks/scheduler.25b97de1.js";import{S as ht,i as mt,g as i,s as l,r as o,A as ut,h as r,f as a,c as n,j as pt,u as c,x as p,k as ot,y as gt,a as s,v as d,d as f,t as h,w as m}from"../chunks/index.d9030fc9.js";import{C as g}from"../chunks/CodeBlock.e6cd0d95.js";import{H as K,E as yt}from"../chunks/EditOnGithub.91d95064.js";function wt(Ie){let u,ae,ee,se,y,le,w,Xe='<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel (FSDP)</a> is a data parallel method that shards a model’s parameters, gradients and optimizer states across the number of available GPUs (also called workers or <em>rank</em>). Unlike <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel (DDP)</a>, FSDP reduces memory-usage because a model is replicated on each GPU. This improves GPU memory-efficiency and allows you to train much larger models on fewer GPUs. FSDP is integrated with the Accelerate, a library for easily managing training in distributed environments, which means it is available for use from the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> class.',ne,_,Ge="Before you start, make sure Accelerate is installed and at least PyTorch 2.1.0 or newer.",ie,T,re,$,pe,b,ze='To start, run the <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-config" rel="nofollow"><code>accelerate config</code></a> command to create a configuration file for your training environment. Accelerate uses this configuration file to automatically setup the correct training environment based on your selected training options in <code>accelerate config</code>.',oe,M,ce,U,Le='When you run <code>accelerate config</code>, you’ll be prompted with a series of options to configure your training environment. This section covers some of the most important FSDP options. To learn more about the other available FSDP options, take a look at the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments.fsdp_config" rel="nofollow">fsdp_config</a> parameters.',de,j,fe,F,Ee="FSDP offers a number of sharding strategies to select from:",he,Z,Ye="<li><code>FULL_SHARD</code> - shards model parameters, gradients and optimizer states across workers; select <code>1</code> for this option</li> <li><code>SHARD_GRAD_OP</code>- shard gradients and optimizer states across workers; select <code>2</code> for this option</li> <li><code>NO_SHARD</code> - don’t shard anything (this is equivalent to DDP); select <code>3</code> for this option</li> <li><code>HYBRID_SHARD</code> - shard model parameters, gradients and optimizer states within each worker where each worker also has a full copy; select <code>4</code> for this option</li> <li><code>HYBRID_SHARD_ZERO2</code> - shard gradients and optimizer states within each worker where each worker also has a full copy; select <code>5</code> for this option</li>",me,J,Ae="This is enabled by the <code>fsdp_sharding_strategy</code> flag.",ue,v,ge,B,Ve="You could also offload parameters and gradients when they are not in use to the CPU to save even more GPU memory and help you fit large models where even FSDP may not be sufficient. This is enabled by setting <code>fsdp_offload_params: true</code> when running <code>accelerate config</code>.",ye,P,we,S,Qe="FSDP is applied by wrapping each layer in the network. The wrapping is usually applied in a nested way where the full weights are discarded after each forward pass to save memory for use in the next layer. The <em>auto wrapping</em> policy is the simplest way to implement this and you don’t need to change any code. You should select <code>fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP</code> to wrap a Transformer layer and <code>fsdp_transformer_layer_cls_to_wrap</code> to specify which layer to wrap (for example <code>BertLayer</code>).",_e,C,qe="Otherwise, you can choose a size-based wrapping policy where FSDP is applied to a layer if it exceeds a certain number of parameters. This is enabled by setting <code>fsdp_wrap_policy: SIZE_BASED_WRAP</code> and <code>min_num_param</code> to the desired size threshold.",Te,H,$e,x,Oe='Intermediate checkpoints should be saved with <code>fsdp_state_dict_type: SHARDED_STATE_DICT</code> because saving the full state dict with CPU offloading on rank 0 takes a lot of time and often results in <code>NCCL Timeout</code> errors due to indefinite hanging during broadcasting. You can resume training with the sharded state dicts with the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state" rel="nofollow">load_state</a>` method.',be,k,Me,N,Ke="However, when training ends, you want to save the full state dict because sharded state dict is only compatible with FSDP.",Ue,R,je,W,et="### TPU",Fe,D,tt='<a href="https://pytorch.org/xla/release/2.1/index.html" rel="nofollow">PyTorch XLA</a> supports FSDP training for TPUs and it can be enabled by modifying the FSDP configuration file generated by <code>accelerate config</code>. In addition to the sharding strategies and wrapping options specified above, you can add the parameters shown below to the file.',Ze,I,Je,X,at='The <a href="https://github.com/pytorch/xla/blob/2e6e183e0724818f137c8135b34ef273dea33318/torch_xla/distributed/fsdp/xla_fully_sharded_data_parallel.py#L128" rel="nofollow"><code>xla_fsdp_settings</code></a> allow you to configure additional XLA-specific parameters for FSDP.',ve,G,st="## Launch training",Be,z,lt="An example FSDP configuration file may look like:",Pe,L,Se,E,nt='To launch training, run the <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-launch" rel="nofollow"><code>accelerate launch</code></a> command and it’ll automatically use the configuration file you previously created with <code>accelerate config</code>.',Ce,Y,He,A,xe,V,ke,Q,it="FSDP can be a powerful tool for training really large models and you have access to more than one GPU or TPU. By sharding the model parameters, optimizer and gradient states, and even offloading them to the CPU when they’re inactive, FSDP can reduce the high cost of large-scale training. If you’re interested in learning more, the following may be helpful:",Ne,q,rt='<li>Follow along with the more in-depth Accelerate guide for <a href="https://huggingface.co/docs/accelerate/usage_guides/fsdp" rel="nofollow">FSDP</a>.</li> <li>Read the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Introducing PyTorch Fully Sharded Data Parallel (FSDP) API</a> blog post.</li> <li>Read the <a href="https://pytorch.org/blog/scaling-pytorch-models-on-cloud-tpus-with-fsdp/" rel="nofollow">Scaling PyTorch models on Cloud TPUs with FSDP</a> blog post.</li>',Re,O,We,te,De;return y=new K({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),T=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),$=new K({props:{title:"FSDP configuration",local:"fsdp-configuration",headingTag:"h2"}}),M=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),j=new K({props:{title:"Sharding strategy",local:"sharding-strategy",headingTag:"h3"}}),v=new K({props:{title:"CPU offload",local:"cpu-offload",headingTag:"h3"}}),P=new K({props:{title:"Wrapping policy",local:"wrapping-policy",headingTag:"h3"}}),H=new K({props:{title:"Checkpointing",local:"checkpointing",headingTag:"h3"}}),k=new g({props:{code:"JTIzJTIwZGlyZWN0b3J5JTIwY29udGFpbmluZyUyMGNoZWNrcG9pbnRzJTBBYWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:`<span class="hljs-comment"># directory containing checkpoints</span>
accelerator.load_state(<span class="hljs-string">&quot;ckpt&quot;</span>)`,wrap:!1}}),R=new g({props:{code:"aWYlMjB0cmFpbmVyLmlzX2ZzZHBfZW5hYmxlZCUzQSUwQSUyMCUyMCUyMCUyMHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZnNkcF9wbHVnaW4uc2V0X3N0YXRlX2RpY3RfdHlwZSglMjJGVUxMX1NUQVRFX0RJQ1QlMjIpJTBBJTBBdHJhaW5lci5zYXZlX21vZGVsKHNjcmlwdF9hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-keyword">if</span> trainer.is_fsdp_enabled:
    trainer.accelerator.state.fsdp_plugin.set_state_dict_type(<span class="hljs-string">&quot;FULL_STATE_DICT&quot;</span>)

trainer.save_model(script_args.output_dir)`,wrap:!1}}),I=new g({props:{code:"eGxhJTNBJTIwVHJ1ZSUyMCUyMyUyMG11c3QlMjBiZSUyMHNldCUyMHRvJTIwVHJ1ZSUyMHRvJTIwZW5hYmxlJTIwUHlUb3JjaCUyRlhMQSUwQXhsYV9mc2RwX3NldHRpbmdzJTNBJTIwJTIzJTIwWExBLXNwZWNpZmljJTIwRlNEUCUyMHBhcmFtZXRlcnMlMEF4bGFfZnNkcF9ncmFkX2NrcHQlM0ElMjBUcnVlJTIwJTIzJTIwdXNlJTIwZ3JhZGllbnQlMjBjaGVja3BvaW50aW5n",highlighted:`<span class="hljs-attr">xla:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># must be set to True to enable PyTorch/XLA</span>
<span class="hljs-attr">xla_fsdp_settings:</span> <span class="hljs-comment"># XLA-specific FSDP parameters</span>
<span class="hljs-attr">xla_fsdp_grad_ckpt:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># use gradient checkpointing</span>`,wrap:!1}}),L=new g({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9jcHVfcmFtX2VmZmljaWVudF9sb2FkaW5nJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfZm9yd2FyZF9wcmVmZXRjaCUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMHRydWUlMEElMjAlMjBmc2RwX3NoYXJkaW5nX3N0cmF0ZWd5JTNBJTIwMSUwQSUyMCUyMGZzZHBfc3RhdGVfZGljdF90eXBlJTNBJTIwU0hBUkRFRF9TVEFURV9ESUNUJTBBJTIwJTIwZnNkcF9zeW5jX21vZHVsZV9zdGF0ZXMlM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF90cmFuc2Zvcm1lcl9sYXllcl9jbHNfdG9fd3JhcCUzQSUyMEJlcnRMYXllciUwQSUyMCUyMGZzZHBfdXNlX29yaWdfcGFyYW1zJTNBJTIwdHJ1ZSUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch_policy:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_transformer_layer_cls_to_wrap:</span> <span class="hljs-string">BertLayer</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Y=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:"accelerate launch my-trainer-script.py",wrap:!1}}),A=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tZnNkcCUzRCUyMmZ1bGwlMjBzaGFyZCUyMiUyMC0tZnNkcF9jb25maWclM0QlMjJwYXRoJTJGdG8lMkZmc2RwX2NvbmZpZyUyRiUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:'accelerate launch --fsdp=<span class="hljs-string">&quot;full shard&quot;</span> --fsdp_config=<span class="hljs-string">&quot;path/to/fsdp_config/ my-trainer-script.py</span>',wrap:!1}}),V=new K({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),O=new yt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/fsdp.md"}}),{c(){u=i("meta"),ae=l(),ee=i("p"),se=l(),o(y.$$.fragment),le=l(),w=i("p"),w.innerHTML=Xe,ne=l(),_=i("p"),_.textContent=Ge,ie=l(),o(T.$$.fragment),re=l(),o($.$$.fragment),pe=l(),b=i("p"),b.innerHTML=ze,oe=l(),o(M.$$.fragment),ce=l(),U=i("p"),U.innerHTML=Le,de=l(),o(j.$$.fragment),fe=l(),F=i("p"),F.textContent=Ee,he=l(),Z=i("ul"),Z.innerHTML=Ye,me=l(),J=i("p"),J.innerHTML=Ae,ue=l(),o(v.$$.fragment),ge=l(),B=i("p"),B.innerHTML=Ve,ye=l(),o(P.$$.fragment),we=l(),S=i("p"),S.innerHTML=Qe,_e=l(),C=i("p"),C.innerHTML=qe,Te=l(),o(H.$$.fragment),$e=l(),x=i("p"),x.innerHTML=Oe,be=l(),o(k.$$.fragment),Me=l(),N=i("p"),N.textContent=Ke,Ue=l(),o(R.$$.fragment),je=l(),W=i("p"),W.textContent=et,Fe=l(),D=i("p"),D.innerHTML=tt,Ze=l(),o(I.$$.fragment),Je=l(),X=i("p"),X.innerHTML=at,ve=l(),G=i("p"),G.textContent=st,Be=l(),z=i("p"),z.textContent=lt,Pe=l(),o(L.$$.fragment),Se=l(),E=i("p"),E.innerHTML=nt,Ce=l(),o(Y.$$.fragment),He=l(),o(A.$$.fragment),xe=l(),o(V.$$.fragment),ke=l(),Q=i("p"),Q.textContent=it,Ne=l(),q=i("ul"),q.innerHTML=rt,Re=l(),o(O.$$.fragment),We=l(),te=i("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(a),ae=n(e),ee=r(e,"P",{}),pt(ee).forEach(a),se=n(e),c(y.$$.fragment,e),le=n(e),w=r(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1c69g1i"&&(w.innerHTML=Xe),ne=n(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-4zh7j7"&&(_.textContent=Ge),ie=n(e),c(T.$$.fragment,e),re=n(e),c($.$$.fragment,e),pe=n(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-il7v8z"&&(b.innerHTML=ze),oe=n(e),c(M.$$.fragment,e),ce=n(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-60yrb1"&&(U.innerHTML=Le),de=n(e),c(j.$$.fragment,e),fe=n(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-18pbstz"&&(F.textContent=Ee),he=n(e),Z=r(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-11pbaor"&&(Z.innerHTML=Ye),me=n(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1l7i7fk"&&(J.innerHTML=Ae),ue=n(e),c(v.$$.fragment,e),ge=n(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-ss15nf"&&(B.innerHTML=Ve),ye=n(e),c(P.$$.fragment,e),we=n(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1wisi5e"&&(S.innerHTML=Qe),_e=n(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-hh9gtt"&&(C.innerHTML=qe),Te=n(e),c(H.$$.fragment,e),$e=n(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1k4h6zf"&&(x.innerHTML=Oe),be=n(e),c(k.$$.fragment,e),Me=n(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-5bvj2l"&&(N.textContent=Ke),Ue=n(e),c(R.$$.fragment,e),je=n(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-h7rtjm"&&(W.textContent=et),Fe=n(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1worwgp"&&(D.innerHTML=tt),Ze=n(e),c(I.$$.fragment,e),Je=n(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1a1f8bc"&&(X.innerHTML=at),ve=n(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1jusazn"&&(G.textContent=st),Be=n(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-69y5on"&&(z.textContent=lt),Pe=n(e),c(L.$$.fragment,e),Se=n(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-b24kct"&&(E.innerHTML=nt),Ce=n(e),c(Y.$$.fragment,e),He=n(e),c(A.$$.fragment,e),xe=n(e),c(V.$$.fragment,e),ke=n(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-hv24fk"&&(Q.textContent=it),Ne=n(e),q=r(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-gtahwu"&&(q.innerHTML=rt),Re=n(e),c(O.$$.fragment,e),We=n(e),te=r(e,"P",{}),pt(te).forEach(a),this.h()},h(){ot(u,"name","hf:doc:metadata"),ot(u,"content",_t)},m(e,t){gt(document.head,u),s(e,ae,t),s(e,ee,t),s(e,se,t),d(y,e,t),s(e,le,t),s(e,w,t),s(e,ne,t),s(e,_,t),s(e,ie,t),d(T,e,t),s(e,re,t),d($,e,t),s(e,pe,t),s(e,b,t),s(e,oe,t),d(M,e,t),s(e,ce,t),s(e,U,t),s(e,de,t),d(j,e,t),s(e,fe,t),s(e,F,t),s(e,he,t),s(e,Z,t),s(e,me,t),s(e,J,t),s(e,ue,t),d(v,e,t),s(e,ge,t),s(e,B,t),s(e,ye,t),d(P,e,t),s(e,we,t),s(e,S,t),s(e,_e,t),s(e,C,t),s(e,Te,t),d(H,e,t),s(e,$e,t),s(e,x,t),s(e,be,t),d(k,e,t),s(e,Me,t),s(e,N,t),s(e,Ue,t),d(R,e,t),s(e,je,t),s(e,W,t),s(e,Fe,t),s(e,D,t),s(e,Ze,t),d(I,e,t),s(e,Je,t),s(e,X,t),s(e,ve,t),s(e,G,t),s(e,Be,t),s(e,z,t),s(e,Pe,t),d(L,e,t),s(e,Se,t),s(e,E,t),s(e,Ce,t),d(Y,e,t),s(e,He,t),d(A,e,t),s(e,xe,t),d(V,e,t),s(e,ke,t),s(e,Q,t),s(e,Ne,t),s(e,q,t),s(e,Re,t),d(O,e,t),s(e,We,t),s(e,te,t),De=!0},p:dt,i(e){De||(f(y.$$.fragment,e),f(T.$$.fragment,e),f($.$$.fragment,e),f(M.$$.fragment,e),f(j.$$.fragment,e),f(v.$$.fragment,e),f(P.$$.fragment,e),f(H.$$.fragment,e),f(k.$$.fragment,e),f(R.$$.fragment,e),f(I.$$.fragment,e),f(L.$$.fragment,e),f(Y.$$.fragment,e),f(A.$$.fragment,e),f(V.$$.fragment,e),f(O.$$.fragment,e),De=!0)},o(e){h(y.$$.fragment,e),h(T.$$.fragment,e),h($.$$.fragment,e),h(M.$$.fragment,e),h(j.$$.fragment,e),h(v.$$.fragment,e),h(P.$$.fragment,e),h(H.$$.fragment,e),h(k.$$.fragment,e),h(R.$$.fragment,e),h(I.$$.fragment,e),h(L.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),De=!1},d(e){e&&(a(ae),a(ee),a(se),a(le),a(w),a(ne),a(_),a(ie),a(re),a(pe),a(b),a(oe),a(ce),a(U),a(de),a(fe),a(F),a(he),a(Z),a(me),a(J),a(ue),a(ge),a(B),a(ye),a(we),a(S),a(_e),a(C),a(Te),a($e),a(x),a(be),a(Me),a(N),a(Ue),a(je),a(W),a(Fe),a(D),a(Ze),a(Je),a(X),a(ve),a(G),a(Be),a(z),a(Pe),a(Se),a(E),a(Ce),a(He),a(xe),a(ke),a(Q),a(Ne),a(q),a(Re),a(We),a(te)),a(u),m(y,e),m(T,e),m($,e),m(M,e),m(j,e),m(v,e),m(P,e),m(H,e),m(k,e),m(R,e),m(I,e),m(L,e),m(Y,e),m(A,e),m(V,e),m(O,e)}}}const _t='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[{"title":"FSDP configuration","local":"fsdp-configuration","sections":[{"title":"Sharding strategy","local":"sharding-strategy","sections":[],"depth":3},{"title":"CPU offload","local":"cpu-offload","sections":[],"depth":3},{"title":"Wrapping policy","local":"wrapping-policy","sections":[],"depth":3},{"title":"Checkpointing","local":"checkpointing","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Tt(Ie){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends ht{constructor(u){super(),mt(this,u,Tt,wt,ct,{})}}export{jt as component};
