import{s as kn,f as xn,o as On,n as uo}from"../chunks/scheduler.25b97de1.js";import{S as jn,i as Un,g as a,s as r,r as h,A as In,h as i,f as o,c as s,j as F,u as g,x as m,k as w,y as n,a as l,v as u,d as _,t as b,w as v}from"../chunks/index.d9030fc9.js";import{T as Mn}from"../chunks/Tip.baa67368.js";import{D as O}from"../chunks/Docstring.e257edda.js";import{C as Wt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Pt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as go,E as Jn}from"../chunks/EditOnGithub.91d95064.js";function zn(J){let c,x="Examples:",p,f,y;return f=new Wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9uZUZvcm1lckNvbmZpZyUyQyUyME9uZUZvcm1lck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9uZUZvcm1lciUyMHNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME9uZUZvcm1lckNvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPbmVGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerConfig, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OneFormer shi-labs/oneformer_ade20k_swin_tiny configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OneFormerConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the shi-labs/oneformer_ade20k_swin_tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=a("p"),c.textContent=x,p=r(),h(f.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=x),p=s(d),g(f.$$.fragment,d)},m(d,M){l(d,c,M),l(d,p,M),u(f,d,M),y=!0},p:uo,i(d){y||(_(f.$$.fragment,d),y=!0)},o(d){b(f.$$.fragment,d),y=!1},d(d){d&&(o(c),o(p)),v(f,d)}}}function $n(J){let c,x=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=x},l(p){c=i(p,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=x)},m(p,f){l(p,c,f)},p:uo,d(p){p&&o(c)}}}function Cn(J){let c,x="Example:",p,f,y;return f=new Wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBPbmVGb3JtZXJQcm9jZXNzb3IlMkMlMjBPbmVGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMGRvd25sb2FkJTIwdGV4dGluZyUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBwcm9jZXNzb3IlMjBmb3IlMjBwcmVwcm9jZXNzaW5nJTIwdGhlJTIwaW5wdXRzJTBBcHJvY2Vzc29yJTIwJTNEJTIwT25lRm9ybWVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwT25lRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwJTVCJTIyc2VtYW50aWMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFza19wcmVkaWN0aW9ucyUyMCUzRCUyMG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9tYXNrX3ByZWRpY3Rpb25zJTBBY2xhc3NfcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLnRyYW5zZm9ybWVyX2RlY29kZXJfY2xhc3NfcHJlZGljdGlvbnMlMEElMEFmJTIyJUYwJTlGJTkxJTg5JTIwTWFzayUyMFByZWRpY3Rpb25zJTIwU2hhcGUlM0ElMjAlN0JsaXN0KG1hc2tfcHJlZGljdGlvbnMuc2hhcGUpJTdEJTJDJTIwQ2xhc3MlMjBQcmVkaWN0aW9ucyUyMFNoYXBlJTNBJTIwJTdCbGlzdChjbGFzc19wcmVkaWN0aW9ucy5zaGFwZSklN0QlMjI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download texting image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load processor for preprocessing the inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_predictions = outputs.transformer_decoder_mask_predictions
<span class="hljs-meta">&gt;&gt;&gt; </span>class_predictions = outputs.transformer_decoder_class_predictions

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Mask Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(mask_predictions.shape)}</span>, Class Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(class_predictions.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Mask Predictions Shape: [1, 150, 128, 171], Class Predictions Shape: [1, 150, 151]&#x27;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=x,p=r(),h(f.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-11lpom8"&&(c.textContent=x),p=s(d),g(f.$$.fragment,d)},m(d,M){l(d,c,M),l(d,p,M),u(f,d,M),y=!0},p:uo,i(d){y||(_(f.$$.fragment,d),y=!0)},o(d){b(f.$$.fragment,d),y=!1},d(d){d&&(o(c),o(p)),v(f,d)}}}function Nn(J){let c,x=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=x},l(p){c=i(p,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=x)},m(p,f){l(p,c,f)},p:uo,d(p){p&&o(c)}}}function qn(J){let c,x="Universal segmentation example:",p,f,y;return f=new Wt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load OneFormer fine-tuned on ADE20k for universal segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Semantic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for semantic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Semantic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_semantic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Semantic Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Instance Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for instance postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_instance_map = processor.post_process_instance_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Instance Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_instance_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Instance Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Panoptic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for panoptic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Panoptic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Panoptic Predictions Shape: [512, 683]&#x27;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=x,p=r(),h(f.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-9x0o9r"&&(c.textContent=x),p=s(d),g(f.$$.fragment,d)},m(d,M){l(d,c,M),l(d,p,M),u(f,d,M),y=!0},p:uo,i(d){y||(_(f.$$.fragment,d),y=!0)},o(d){b(f.$$.fragment,d),y=!1},d(d){d&&(o(c),o(p)),v(f,d)}}}function Pn(J){let c,x,p,f,y,d,M,_o,oe,Zt='The OneFormer model was proposed in <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">OneFormer: One Transformer to Rule Universal Image Segmentation</a> by Jitesh Jain, Jiachen Li, MangTik Chiu, Ali Hassani, Nikita Orlov, Humphrey Shi. OneFormer is a universal image segmentation framework that can be trained on a single panoptic dataset to perform semantic, instance, and panoptic segmentation tasks. OneFormer uses a task token to condition the model on the task in focus, making the architecture task-guided for training, and task-dynamic for inference.',bo,te,Bt,vo,ne,St="The abstract from the paper is the following:",wo,re,Ht="<em>Universal Image Segmentation is not a new concept. Past attempts to unify image segmentation in the last decades include scene parsing, panoptic segmentation, and, more recently, new panoptic architectures. However, such panoptic architectures do not truly unify image segmentation because they need to be trained individually on the semantic, instance, or panoptic segmentation to achieve the best performance. Ideally, a truly universal framework should be trained only once and achieve SOTA performance across all three image segmentation tasks. To that end, we propose OneFormer, a universal image segmentation framework that unifies segmentation with a multi-task train-once design. We first propose a task-conditioned joint training strategy that enables training on ground truths of each domain (semantic, instance, and panoptic segmentation) within a single multi-task training process. Secondly, we introduce a task token to condition our model on the task at hand, making our model task-dynamic to support multi-task training and inference. Thirdly, we propose using a query-text contrastive loss during training to establish better inter-task and inter-class distinctions. Notably, our single OneFormer model outperforms specialized Mask2Former models across all three segmentation tasks on ADE20k, CityScapes, and COCO, despite the latter being trained on each of the three tasks individually with three times the resources. With new ConvNeXt and DiNAT backbones, we observe even more performance improvement. We believe OneFormer is a significant step towards making image segmentation more universal and accessible.</em>",yo,se,Gt='The figure below illustrates the architecture of OneFormer. Taken from the <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">original paper</a>.',To,ae,Vt,Fo,ie,Lt='This model was contributed by <a href="https://huggingface.co/praeclarumjj3" rel="nofollow">Jitesh Jain</a>. The original code can be found <a href="https://github.com/SHI-Labs/OneFormer" rel="nofollow">here</a>.',xo,le,Mo,ce,Rt=`<li>OneFormer requires two inputs during inference: <em>image</em> and <em>task token</em>.</li> <li>During training, OneFormer only uses panoptic annotations.</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>OneFormerLoss</code> class of <code>modeling_oneformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/SHI-Labs/OneFormer/blob/33ebb56ed34f970a30ae103e786c0cb64c653d9a/oneformer/modeling/criterion.py#L287" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> to prepare input images and task inputs for the model and optional targets for the model. <code>OneformerProcessor</code> wraps <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both prepare the images and encode the task inputs.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,ko,de,Oo,me,Xt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OneFormer.",jo,pe,Et='<li>Demo notebooks regarding inference + fine-tuning on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OneFormer" rel="nofollow">here</a>.</li>',Uo,fe,Yt=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,Io,he,Jo,B,ge,Ko,Be,Dt='Class for outputs of <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. This class returns all the needed hidden states to compute the logits.',zo,C,ue,et,Se,Qt="Class for outputs of <code>OneFormerForUniversalSegmentationOutput</code>.",ot,He,At=`This output can be directly passed to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~OneFormerImageProcessor] for details regarding usage.`,$o,_e,Kt="## OneFormerConfig[[transformers.OneFormerConfig]]",Co,I,be,tt,Ge,en=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. It is used to instantiate a
OneFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OneFormer
<a href="https://huggingface.co/shi-labs/oneformer_ade20k_swin_tiny" rel="nofollow">shi-labs/oneformer_ade20k_swin_tiny</a> architecture
trained on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,nt,Ve,on=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,rt,H,No,ve,tn="## OneFormerImageProcessor[[transformers.OneFormerImageProcessor]]",qo,T,we,st,Le,nn=`Constructs a OneFormer image processor. The image processor can be used to prepare image(s), task input(s) and
optional text inputs and targets for the model.`,at,Re,rn=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,it,Xe,ye,lt,W,Te,ct,Ee,sn="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",dt,Ye,an=`OneFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,mt,G,Fe,pt,De,ln=`Converts the output of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,ft,V,xe,ht,Qe,cn=`Converts the output of <code>OneFormerForUniversalSegmentationOutput</code> into image instance segmentation
predictions. Only supports PyTorch.`,gt,L,Me,ut,Ae,dn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Po,ke,mn="## OneFormerProcessor[[transformers.OneFormerProcessor]]",Wo,j,Oe,_t,Ke,pn=`Constructs an OneFormer processor which wraps <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into a single processor that inherits both the image processor and
tokenizer functionalities.`,bt,R,je,vt,eo,fn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.encode_inputs">OneFormerImageProcessor.encode_inputs()</a> and then tokenizes the
task_inputs. Please refer to the docstring of this method for more information.`,wt,X,Ue,yt,oo,hn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">OneFormerImageProcessor.post_process_instance_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Tt,E,Ie,Ft,to,gn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">OneFormerImageProcessor.post_process_panoptic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,xt,Y,Je,Mt,no,un=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">OneFormerImageProcessor.post_process_semantic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Zo,ze,_n="## OneFormerModel[[transformers.OneFormerModel]]",Bo,N,$e,kt,ro,bn=`The bare OneFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,Ot,z,Ce,jt,so,vn='The <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Ut,D,It,Q,So,Ne,wn="## OneFormerForUniversalSegmentation[[transformers.OneFormerForUniversalSegmentation]]",Ho,q,qe,Jt,ao,yn=`OneFormer Model for instance, semantic and panoptic image segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,zt,U,Pe,$t,io,Tn='The <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Ct,A,Nt,lo,Fn="Example:",qt,K,Go,We,Vo,fo,Lo;return y=new go({props:{title:"OneFormer",local:"oneformer",headingTag:"h1"}}),M=new go({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new go({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),de=new go({props:{title:"Resources",local:"resources",headingTag:"h2"}}),he=new go({props:{title:"OneFormer specific outputs",local:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",headingTag:"h2"}}),ge=new O({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",parameters:[{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": Optional = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": Optional = None"},{name:"text_queries",val:": Optional = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tuple of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L810"}}),ue=new O({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_predictions",val:": List = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": Optional = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": Optional = None"},{name:"text_queries",val:": Optional = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.auxiliary_predictions",description:`<strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L860"}}),be=new O({props:{name:"class transformers.OneFormerConfig",anchor:"transformers.OneFormerConfig",parameters:[{name:"backbone_config",val:": Optional = None"},{name:"backbone",val:": Optional = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": Optional = None"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 150"},{name:"no_object_weight",val:": int = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"contrastive_weight",val:": float = 0.5"},{name:"contrastive_temperature",val:": float = 0.07"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"is_training",val:": bool = False"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"output_auxiliary_logits",val:": bool = True"},{name:"strides",val:": Optional = [4, 8, 16, 32]"},{name:"task_seq_len",val:": int = 77"},{name:"text_encoder_width",val:": int = 256"},{name:"text_encoder_context_length",val:": int = 77"},{name:"text_encoder_num_layers",val:": int = 6"},{name:"text_encoder_vocab_size",val:": int = 49408"},{name:"text_encoder_proj_layers",val:": int = 2"},{name:"text_encoder_n_ctx",val:": int = 16"},{name:"conv_dim",val:": int = 256"},{name:"mask_dim",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"norm",val:": str = 'GN'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"use_task_norm",val:": bool = True"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.1"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_proj",val:": bool = False"},{name:"query_dec_layers",val:": int = 2"},{name:"common_stride",val:": int = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>, defaults to <code>SwinConfig</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.OneFormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.OneFormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.OneFormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.OneFormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.OneFormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Values to be ignored in GT label while calculating loss.`,name:"ignore_value"},{anchor:"transformers.OneFormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 150) &#x2014;
Number of object queries.`,name:"num_queries"},{anchor:"transformers.OneFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight for no-object class predictions.`,name:"no_object_weight"},{anchor:"transformers.OneFormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Weight for Classification CE loss.`,name:"class_weight"},{anchor:"transformers.OneFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for binary CE loss.`,name:"mask_weight"},{anchor:"transformers.OneFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for dice loss.`,name:"dice_weight"},{anchor:"transformers.OneFormerConfig.contrastive_weight",description:`<strong>contrastive_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Weight for contrastive loss.`,name:"contrastive_weight"},{anchor:"transformers.OneFormerConfig.contrastive_temperature",description:`<strong>contrastive_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.07) &#x2014;
Initial value for scaling the contrastive logits.`,name:"contrastive_temperature"},{anchor:"transformers.OneFormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>int</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points to sample while calculating losses on mask predictions.`,name:"train_num_points"},{anchor:"transformers.OneFormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Ratio to decide how many points to oversample.`,name:"oversample_ratio"},{anchor:"transformers.OneFormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.OneFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Standard deviation for normal intialization.`,name:"init_std"},{anchor:"transformers.OneFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Standard deviation for xavier uniform initialization.`,name:"init_xavier_std"},{anchor:"transformers.OneFormerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon for layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.OneFormerConfig.is_training",description:`<strong>is_training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to run in training or inference mode.`,name:"is_training"},{anchor:"transformers.OneFormerConfig.use_auxiliary_loss",description:`<strong>use_auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to calculate loss using intermediate predictions from transformer decoder.`,name:"use_auxiliary_loss"},{anchor:"transformers.OneFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return intermediate predictions from transformer decoder.`,name:"output_auxiliary_logits"},{anchor:"transformers.OneFormerConfig.strides",description:`<strong>strides</strong> (<code>list</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
List containing the strides for feature maps in the encoder.`,name:"strides"},{anchor:"transformers.OneFormerConfig.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for tokenizing text list input.`,name:"task_seq_len"},{anchor:"transformers.OneFormerConfig.text_encoder_width",description:`<strong>text_encoder_width</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Hidden size for text encoder.`,name:"text_encoder_width"},{anchor:"transformers.OneFormerConfig.text_encoder_context_length",description:`<strong>text_encoder_context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Input sequence length for text encoder.`,name:"text_encoder_context_length"},{anchor:"transformers.OneFormerConfig.text_encoder_num_layers",description:`<strong>text_encoder_num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers for transformer in text encoder.`,name:"text_encoder_num_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_vocab_size",description:`<strong>text_encoder_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size for tokenizer.`,name:"text_encoder_vocab_size"},{anchor:"transformers.OneFormerConfig.text_encoder_proj_layers",description:`<strong>text_encoder_proj_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in MLP for project text queries.`,name:"text_encoder_proj_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_n_ctx",description:`<strong>text_encoder_n_ctx</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of learnable text context queries.`,name:"text_encoder_n_ctx"},{anchor:"transformers.OneFormerConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Feature map dimension to map outputs from the backbone.`,name:"conv_dim"},{anchor:"transformers.OneFormerConfig.mask_dim",description:`<strong>mask_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for feature maps in pixel decoder.`,name:"mask_dim"},{anchor:"transformers.OneFormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for hidden states in transformer decoder.`,name:"hidden_dim"},{anchor:"transformers.OneFormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension for FFN layer in pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.OneFormerConfig.norm",description:`<strong>norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;GN&quot;</code>) &#x2014;
Type of normalization.`,name:"norm"},{anchor:"transformers.OneFormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.OneFormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.OneFormerConfig.use_task_norm",description:`<strong>use_task_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the task token.`,name:"use_task_norm"},{anchor:"transformers.OneFormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads in transformer layers in the pixel and transformer decoders.`,name:"num_attention_heads"},{anchor:"transformers.OneFormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Dropout probability for pixel and transformer decoders.`,name:"dropout"},{anchor:"transformers.OneFormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension for FFN layer in transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.OneFormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize hidden states before attention layers in transformer decoder.`,name:"pre_norm"},{anchor:"transformers.OneFormerConfig.enforce_input_proj",description:`<strong>enforce_input_proj</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to project hidden states in transformer decoder.`,name:"enforce_input_proj"},{anchor:"transformers.OneFormerConfig.query_dec_layers",description:`<strong>query_dec_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in query transformer.`,name:"query_dec_layers"},{anchor:"transformers.OneFormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Common stride used for features in pixel decoder.`,name:"common_stride"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/configuration_oneformer.py#L28"}}),H=new Pt({props:{anchor:"transformers.OneFormerConfig.example",$$slots:{default:[zn]},$$scope:{ctx:J}}}),we=new O({props:{name:"class transformers.OneFormerImageProcessor",anchor:"transformers.OneFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"repo_path",val:": Optional = 'shi-labs/oneformer_demo'"},{name:"class_info_file",val:": str = None"},{name:"num_text",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.OneFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.OneFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.OneFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.OneFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.OneFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.OneFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.OneFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.OneFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.OneFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.OneFormerImageProcessor.repo_path",description:`<strong>repo_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;shi-labs/oneformer_demo&quot;</code>) &#x2014;
Path to hub repo or local directory containing the JSON file with class information for the dataset.
If unset, will look for <code>class_info_file</code> in the current working directory.`,name:"repo_path"},{anchor:"transformers.OneFormerImageProcessor.class_info_file",description:`<strong>class_info_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
JSON file containing class information for the dataset. See <code>shi-labs/oneformer_demo/cityscapes_panoptic.json</code> for an example.`,name:"class_info_file"},{anchor:"transformers.OneFormerImageProcessor.num_text",description:`<strong>num_text</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of text entries in the text input list.`,name:"num_text"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L375"}}),ye=new O({props:{name:"preprocess",anchor:"transformers.OneFormerImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"task_inputs",val:": Optional = None"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Optional = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Optional = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L682"}}),Te=new O({props:{name:"encode_inputs",anchor:"transformers.OneFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": List"},{name:"task_inputs",val:": List"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.task_inputs",description:`<strong>task_inputs</strong> (<code>List[str]</code>) &#x2014;
List of task values.`,name:"task_inputs"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred from the input
image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L984",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
<li><strong>text_inputs</strong> — Optional list of text string entries to be fed to a model (when <code>annotations</code> are
provided). They identify the binary masks present in the image.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Fe=new O({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),xe=new O({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"task_type",val:": str = 'instance'"},{name:"is_demo",val:": bool = True"},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": Optional = None"},{name:"return_coco_annotation",val:": Optional = False"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<code>OneFormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <code>OneFormerForUniversalSegmentationOutput</code>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.task_type",description:`<strong>task_type</strong> (<code>str</code>, <em>optional)</em>, defaults to &#x201C;instance&#x201D;) &#x2014;
The post processing depends on the task token input. If the <code>task_type</code> is &#x201C;panoptic&#x201D;, we need to
ignore the stuff predictions.`,name:"task_type"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.is_demo",description:`<strong>is_demo</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>True</code>) &#x2014;
Whether the model is in demo mode. If true, use threshold to predict final masks.`,name:"is_demo"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>False</code>) &#x2014;
Whether to return predictions in COCO format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1169",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Me=new O({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": Optional = None"},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1289",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Oe=new O({props:{name:"class transformers.OneFormerProcessor",anchor:"transformers.OneFormerProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"max_seq_length",val:": int = 77"},{name:"task_seq_length",val:": int = 77"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.OneFormerProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.OneFormerProcessor.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77)) &#x2014;
Sequence length for input text list.`,name:"max_seq_len"},{anchor:"transformers.OneFormerProcessor.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for input task token.`,name:"task_seq_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L29"}}),je=new O({props:{name:"encode_inputs",anchor:"transformers.OneFormerProcessor.encode_inputs",parameters:[{name:"images",val:" = None"},{name:"task_inputs",val:" = None"},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L145"}}),Ue=new O({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerProcessor.post_process_instance_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L192"}}),Ie=new O({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_panoptic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L199"}}),Je=new O({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_semantic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L185"}}),$e=new O({props:{name:"class transformers.OneFormerModel",anchor:"transformers.OneFormerModel",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L2904"}}),Ce=new O({props:{name:"forward",anchor:"transformers.OneFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": Optional = None"},{name:"pixel_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerModel.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L2925",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — Tuple of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerModelOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new Mn({props:{$$slots:{default:[$n]},$$scope:{ctx:J}}}),Q=new Pt({props:{anchor:"transformers.OneFormerModel.forward.example",$$slots:{default:[Cn]},$$scope:{ctx:J}}}),qe=new O({props:{name:"class transformers.OneFormerForUniversalSegmentation",anchor:"transformers.OneFormerForUniversalSegmentation",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L3033"}}),Pe=new O({props:{name:"forward",anchor:"transformers.OneFormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": Optional = None"},{name:"mask_labels",val:": Optional = None"},{name:"class_labels",val:": Optional = None"},{name:"pixel_mask",val:": Optional = None"},{name:"output_auxiliary_logits",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.text_inputs",description:`<strong>text_inputs</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Tensor fof shape <code>(num_queries, sequence_length)</code> to be fed to a model`,name:"text_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L3104",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerUniversalSegmentationOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Mn({props:{$$slots:{default:[Nn]},$$scope:{ctx:J}}}),K=new Pt({props:{anchor:"transformers.OneFormerForUniversalSegmentation.forward.example",$$slots:{default:[qn]},$$scope:{ctx:J}}}),We=new Jn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/oneformer.md"}}),{c(){c=a("meta"),x=r(),p=a("p"),f=r(),h(y.$$.fragment),d=r(),h(M.$$.fragment),_o=r(),oe=a("p"),oe.innerHTML=Zt,bo=r(),te=a("img"),vo=r(),ne=a("p"),ne.textContent=St,wo=r(),re=a("p"),re.innerHTML=Ht,yo=r(),se=a("p"),se.innerHTML=Gt,To=r(),ae=a("img"),Fo=r(),ie=a("p"),ie.innerHTML=Lt,xo=r(),h(le.$$.fragment),Mo=r(),ce=a("ul"),ce.innerHTML=Rt,ko=r(),h(de.$$.fragment),Oo=r(),me=a("p"),me.textContent=Xt,jo=r(),pe=a("ul"),pe.innerHTML=Et,Uo=r(),fe=a("p"),fe.textContent=Yt,Io=r(),h(he.$$.fragment),Jo=r(),B=a("div"),h(ge.$$.fragment),Ko=r(),Be=a("p"),Be.innerHTML=Dt,zo=r(),C=a("div"),h(ue.$$.fragment),et=r(),Se=a("p"),Se.innerHTML=Qt,ot=r(),He=a("p"),He.innerHTML=At,$o=r(),_e=a("p"),_e.textContent=Kt,Co=r(),I=a("div"),h(be.$$.fragment),tt=r(),Ge=a("p"),Ge.innerHTML=en,nt=r(),Ve=a("p"),Ve.innerHTML=on,rt=r(),h(H.$$.fragment),No=r(),ve=a("p"),ve.textContent=tn,qo=r(),T=a("div"),h(we.$$.fragment),st=r(),Le=a("p"),Le.textContent=nn,at=r(),Re=a("p"),Re.innerHTML=rn,it=r(),Xe=a("div"),h(ye.$$.fragment),lt=r(),W=a("div"),h(Te.$$.fragment),ct=r(),Ee=a("p"),Ee.innerHTML=sn,dt=r(),Ye=a("p"),Ye.innerHTML=an,mt=r(),G=a("div"),h(Fe.$$.fragment),pt=r(),De=a("p"),De.innerHTML=ln,ft=r(),V=a("div"),h(xe.$$.fragment),ht=r(),Qe=a("p"),Qe.innerHTML=cn,gt=r(),L=a("div"),h(Me.$$.fragment),ut=r(),Ae=a("p"),Ae.innerHTML=dn,Po=r(),ke=a("p"),ke.textContent=mn,Wo=r(),j=a("div"),h(Oe.$$.fragment),_t=r(),Ke=a("p"),Ke.innerHTML=pn,bt=r(),R=a("div"),h(je.$$.fragment),vt=r(),eo=a("p"),eo.innerHTML=fn,wt=r(),X=a("div"),h(Ue.$$.fragment),yt=r(),oo=a("p"),oo.innerHTML=hn,Tt=r(),E=a("div"),h(Ie.$$.fragment),Ft=r(),to=a("p"),to.innerHTML=gn,xt=r(),Y=a("div"),h(Je.$$.fragment),Mt=r(),no=a("p"),no.innerHTML=un,Zo=r(),ze=a("p"),ze.textContent=_n,Bo=r(),N=a("div"),h($e.$$.fragment),kt=r(),ro=a("p"),ro.innerHTML=bn,Ot=r(),z=a("div"),h(Ce.$$.fragment),jt=r(),so=a("p"),so.innerHTML=vn,Ut=r(),h(D.$$.fragment),It=r(),h(Q.$$.fragment),So=r(),Ne=a("p"),Ne.textContent=wn,Ho=r(),q=a("div"),h(qe.$$.fragment),Jt=r(),ao=a("p"),ao.innerHTML=yn,zt=r(),U=a("div"),h(Pe.$$.fragment),$t=r(),io=a("p"),io.innerHTML=Tn,Ct=r(),h(A.$$.fragment),Nt=r(),lo=a("p"),lo.textContent=Fn,qt=r(),h(K.$$.fragment),Go=r(),h(We.$$.fragment),Vo=r(),fo=a("p"),this.h()},l(e){const t=In("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(o),x=s(e),p=i(e,"P",{}),F(p).forEach(o),f=s(e),g(y.$$.fragment,e),d=s(e),g(M.$$.fragment,e),_o=s(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-4uriep"&&(oe.innerHTML=Zt),bo=s(e),te=i(e,"IMG",{width:!0,src:!0}),vo=s(e),ne=i(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-vfdo9a"&&(ne.textContent=St),wo=s(e),re=i(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-lnf9ge"&&(re.innerHTML=Ht),yo=s(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-194z8jz"&&(se.innerHTML=Gt),To=s(e),ae=i(e,"IMG",{width:!0,src:!0}),Fo=s(e),ie=i(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-tphfzt"&&(ie.innerHTML=Lt),xo=s(e),g(le.$$.fragment,e),Mo=s(e),ce=i(e,"UL",{"data-svelte-h":!0}),m(ce)!=="svelte-1moxus8"&&(ce.innerHTML=Rt),ko=s(e),g(de.$$.fragment,e),Oo=s(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-e2wyhg"&&(me.textContent=Xt),jo=s(e),pe=i(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-1f4vugx"&&(pe.innerHTML=Et),Uo=s(e),fe=i(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1rggs50"&&(fe.textContent=Yt),Io=s(e),g(he.$$.fragment,e),Jo=s(e),B=i(e,"DIV",{class:!0});var Ze=F(B);g(ge.$$.fragment,Ze),Ko=s(Ze),Be=i(Ze,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-l9bgt7"&&(Be.innerHTML=Dt),Ze.forEach(o),zo=s(e),C=i(e,"DIV",{class:!0});var S=F(C);g(ue.$$.fragment,S),et=s(S),Se=i(S,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-tmsgtt"&&(Se.innerHTML=Qt),ot=s(S),He=i(S,"P",{"data-svelte-h":!0}),m(He)!=="svelte-19d5ptt"&&(He.innerHTML=At),S.forEach(o),$o=s(e),_e=i(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-di3adc"&&(_e.textContent=Kt),Co=s(e),I=i(e,"DIV",{class:!0});var P=F(I);g(be.$$.fragment,P),tt=s(P),Ge=i(P,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1vjlzio"&&(Ge.innerHTML=en),nt=s(P),Ve=i(P,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-mby5n"&&(Ve.innerHTML=on),rt=s(P),g(H.$$.fragment,P),P.forEach(o),No=s(e),ve=i(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-vhub9s"&&(ve.textContent=tn),qo=s(e),T=i(e,"DIV",{class:!0});var k=F(T);g(we.$$.fragment,k),st=s(k),Le=i(k,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-5uz02u"&&(Le.textContent=nn),at=s(k),Re=i(k,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1wh3jgn"&&(Re.innerHTML=rn),it=s(k),Xe=i(k,"DIV",{class:!0});var ho=F(Xe);g(ye.$$.fragment,ho),ho.forEach(o),lt=s(k),W=i(k,"DIV",{class:!0});var co=F(W);g(Te.$$.fragment,co),ct=s(co),Ee=i(co,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-1tetyua"&&(Ee.innerHTML=sn),dt=s(co),Ye=i(co,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-g5nqd2"&&(Ye.innerHTML=an),co.forEach(o),mt=s(k),G=i(k,"DIV",{class:!0});var Ro=F(G);g(Fe.$$.fragment,Ro),pt=s(Ro),De=i(Ro,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1e0ha1b"&&(De.innerHTML=ln),Ro.forEach(o),ft=s(k),V=i(k,"DIV",{class:!0});var Xo=F(V);g(xe.$$.fragment,Xo),ht=s(Xo),Qe=i(Xo,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-ivz9k7"&&(Qe.innerHTML=cn),Xo.forEach(o),gt=s(k),L=i(k,"DIV",{class:!0});var Eo=F(L);g(Me.$$.fragment,Eo),ut=s(Eo),Ae=i(Eo,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-pw2uru"&&(Ae.innerHTML=dn),Eo.forEach(o),k.forEach(o),Po=s(e),ke=i(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-8vwhva"&&(ke.textContent=mn),Wo=s(e),j=i(e,"DIV",{class:!0});var $=F(j);g(Oe.$$.fragment,$),_t=s($),Ke=i($,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-ufcrf4"&&(Ke.innerHTML=pn),bt=s($),R=i($,"DIV",{class:!0});var Yo=F(R);g(je.$$.fragment,Yo),vt=s(Yo),eo=i(Yo,"P",{"data-svelte-h":!0}),m(eo)!=="svelte-j3jsqj"&&(eo.innerHTML=fn),Yo.forEach(o),wt=s($),X=i($,"DIV",{class:!0});var Do=F(X);g(Ue.$$.fragment,Do),yt=s(Do),oo=i(Do,"P",{"data-svelte-h":!0}),m(oo)!=="svelte-k8l5jt"&&(oo.innerHTML=hn),Do.forEach(o),Tt=s($),E=i($,"DIV",{class:!0});var Qo=F(E);g(Ie.$$.fragment,Qo),Ft=s(Qo),to=i(Qo,"P",{"data-svelte-h":!0}),m(to)!=="svelte-16j8oa7"&&(to.innerHTML=gn),Qo.forEach(o),xt=s($),Y=i($,"DIV",{class:!0});var Ao=F(Y);g(Je.$$.fragment,Ao),Mt=s(Ao),no=i(Ao,"P",{"data-svelte-h":!0}),m(no)!=="svelte-49yjin"&&(no.innerHTML=un),Ao.forEach(o),$.forEach(o),Zo=s(e),ze=i(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1m4wguw"&&(ze.textContent=_n),Bo=s(e),N=i(e,"DIV",{class:!0});var mo=F(N);g($e.$$.fragment,mo),kt=s(mo),ro=i(mo,"P",{"data-svelte-h":!0}),m(ro)!=="svelte-ik7onw"&&(ro.innerHTML=bn),Ot=s(mo),z=i(mo,"DIV",{class:!0});var ee=F(z);g(Ce.$$.fragment,ee),jt=s(ee),so=i(ee,"P",{"data-svelte-h":!0}),m(so)!=="svelte-f3l4bc"&&(so.innerHTML=vn),Ut=s(ee),g(D.$$.fragment,ee),It=s(ee),g(Q.$$.fragment,ee),ee.forEach(o),mo.forEach(o),So=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-za3q8s"&&(Ne.textContent=wn),Ho=s(e),q=i(e,"DIV",{class:!0});var po=F(q);g(qe.$$.fragment,po),Jt=s(po),ao=i(po,"P",{"data-svelte-h":!0}),m(ao)!=="svelte-1bjfpb1"&&(ao.innerHTML=yn),zt=s(po),U=i(po,"DIV",{class:!0});var Z=F(U);g(Pe.$$.fragment,Z),$t=s(Z),io=i(Z,"P",{"data-svelte-h":!0}),m(io)!=="svelte-cqbbes"&&(io.innerHTML=Tn),Ct=s(Z),g(A.$$.fragment,Z),Nt=s(Z),lo=i(Z,"P",{"data-svelte-h":!0}),m(lo)!=="svelte-11lpom8"&&(lo.textContent=Fn),qt=s(Z),g(K.$$.fragment,Z),Z.forEach(o),po.forEach(o),Go=s(e),g(We.$$.fragment,e),Vo=s(e),fo=i(e,"P",{}),F(fo).forEach(o),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",Wn),w(te,"width","600"),xn(te.src,Bt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_teaser.png")||w(te,"src",Bt),w(ae,"width","600"),xn(ae.src,Vt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_architecture.png")||w(ae,"src",Vt),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){n(document.head,c),l(e,x,t),l(e,p,t),l(e,f,t),u(y,e,t),l(e,d,t),u(M,e,t),l(e,_o,t),l(e,oe,t),l(e,bo,t),l(e,te,t),l(e,vo,t),l(e,ne,t),l(e,wo,t),l(e,re,t),l(e,yo,t),l(e,se,t),l(e,To,t),l(e,ae,t),l(e,Fo,t),l(e,ie,t),l(e,xo,t),u(le,e,t),l(e,Mo,t),l(e,ce,t),l(e,ko,t),u(de,e,t),l(e,Oo,t),l(e,me,t),l(e,jo,t),l(e,pe,t),l(e,Uo,t),l(e,fe,t),l(e,Io,t),u(he,e,t),l(e,Jo,t),l(e,B,t),u(ge,B,null),n(B,Ko),n(B,Be),l(e,zo,t),l(e,C,t),u(ue,C,null),n(C,et),n(C,Se),n(C,ot),n(C,He),l(e,$o,t),l(e,_e,t),l(e,Co,t),l(e,I,t),u(be,I,null),n(I,tt),n(I,Ge),n(I,nt),n(I,Ve),n(I,rt),u(H,I,null),l(e,No,t),l(e,ve,t),l(e,qo,t),l(e,T,t),u(we,T,null),n(T,st),n(T,Le),n(T,at),n(T,Re),n(T,it),n(T,Xe),u(ye,Xe,null),n(T,lt),n(T,W),u(Te,W,null),n(W,ct),n(W,Ee),n(W,dt),n(W,Ye),n(T,mt),n(T,G),u(Fe,G,null),n(G,pt),n(G,De),n(T,ft),n(T,V),u(xe,V,null),n(V,ht),n(V,Qe),n(T,gt),n(T,L),u(Me,L,null),n(L,ut),n(L,Ae),l(e,Po,t),l(e,ke,t),l(e,Wo,t),l(e,j,t),u(Oe,j,null),n(j,_t),n(j,Ke),n(j,bt),n(j,R),u(je,R,null),n(R,vt),n(R,eo),n(j,wt),n(j,X),u(Ue,X,null),n(X,yt),n(X,oo),n(j,Tt),n(j,E),u(Ie,E,null),n(E,Ft),n(E,to),n(j,xt),n(j,Y),u(Je,Y,null),n(Y,Mt),n(Y,no),l(e,Zo,t),l(e,ze,t),l(e,Bo,t),l(e,N,t),u($e,N,null),n(N,kt),n(N,ro),n(N,Ot),n(N,z),u(Ce,z,null),n(z,jt),n(z,so),n(z,Ut),u(D,z,null),n(z,It),u(Q,z,null),l(e,So,t),l(e,Ne,t),l(e,Ho,t),l(e,q,t),u(qe,q,null),n(q,Jt),n(q,ao),n(q,zt),n(q,U),u(Pe,U,null),n(U,$t),n(U,io),n(U,Ct),u(A,U,null),n(U,Nt),n(U,lo),n(U,qt),u(K,U,null),l(e,Go,t),u(We,e,t),l(e,Vo,t),l(e,fo,t),Lo=!0},p(e,[t]){const Ze={};t&2&&(Ze.$$scope={dirty:t,ctx:e}),H.$set(Ze);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),D.$set(S);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),Q.$set(P);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),A.$set(k);const ho={};t&2&&(ho.$$scope={dirty:t,ctx:e}),K.$set(ho)},i(e){Lo||(_(y.$$.fragment,e),_(M.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(be.$$.fragment,e),_(H.$$.fragment,e),_(we.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),_(Fe.$$.fragment,e),_(xe.$$.fragment,e),_(Me.$$.fragment,e),_(Oe.$$.fragment,e),_(je.$$.fragment,e),_(Ue.$$.fragment,e),_(Ie.$$.fragment,e),_(Je.$$.fragment,e),_($e.$$.fragment,e),_(Ce.$$.fragment,e),_(D.$$.fragment,e),_(Q.$$.fragment,e),_(qe.$$.fragment,e),_(Pe.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(We.$$.fragment,e),Lo=!0)},o(e){b(y.$$.fragment,e),b(M.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(he.$$.fragment,e),b(ge.$$.fragment,e),b(ue.$$.fragment,e),b(be.$$.fragment,e),b(H.$$.fragment,e),b(we.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(Fe.$$.fragment,e),b(xe.$$.fragment,e),b(Me.$$.fragment,e),b(Oe.$$.fragment,e),b(je.$$.fragment,e),b(Ue.$$.fragment,e),b(Ie.$$.fragment,e),b(Je.$$.fragment,e),b($e.$$.fragment,e),b(Ce.$$.fragment,e),b(D.$$.fragment,e),b(Q.$$.fragment,e),b(qe.$$.fragment,e),b(Pe.$$.fragment,e),b(A.$$.fragment,e),b(K.$$.fragment,e),b(We.$$.fragment,e),Lo=!1},d(e){e&&(o(x),o(p),o(f),o(d),o(_o),o(oe),o(bo),o(te),o(vo),o(ne),o(wo),o(re),o(yo),o(se),o(To),o(ae),o(Fo),o(ie),o(xo),o(Mo),o(ce),o(ko),o(Oo),o(me),o(jo),o(pe),o(Uo),o(fe),o(Io),o(Jo),o(B),o(zo),o(C),o($o),o(_e),o(Co),o(I),o(No),o(ve),o(qo),o(T),o(Po),o(ke),o(Wo),o(j),o(Zo),o(ze),o(Bo),o(N),o(So),o(Ne),o(Ho),o(q),o(Go),o(Vo),o(fo)),o(c),v(y,e),v(M,e),v(le,e),v(de,e),v(he,e),v(ge),v(ue),v(be),v(H),v(we),v(ye),v(Te),v(Fe),v(xe),v(Me),v(Oe),v(je),v(Ue),v(Ie),v(Je),v($e),v(Ce),v(D),v(Q),v(qe),v(Pe),v(A),v(K),v(We,e)}}}const Wn='{"title":"OneFormer","local":"oneformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"OneFormer specific outputs","local":"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput","sections":[],"depth":2}],"depth":1}';function Zn(J){return On(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xn extends jn{constructor(c){super(),Un(this,c,Zn,Pn,kn,{})}}export{Xn as component};
