import{s as Rn,o as Ln}from"../chunks/scheduler.12fdeddc.js";import{S as Yn,i as zn,g as i,s as a,r as p,A as Qn,h as r,f as s,c as n,j as Be,u as d,x as o,k as ga,y as M,a as l,v as u,d as m,t as c,w as f,m as Sn,n as En}from"../chunks/index.88dae322.js";import{T as Nn}from"../chunks/Tip.64e66512.js";import{C as g}from"../chunks/CodeBlock.8e54a086.js";import{H as h,E as An}from"../chunks/getInferenceSnippets.06fe9bcd.js";function Dn(Ee){let J;return{c(){J=Sn("This guide is primarily designed for LLMs to help users upload datasets to the Hugging Face Hub in the most compatible format. Users can also reference this guide to understand the upload process and best practices.")},l(U){J=En(U,"This guide is primarily designed for LLMs to help users upload datasets to the Hugging Face Hub in the most compatible format. Users can also reference this guide to understand the upload process and best practices.")},m(U,I){l(U,J,I)},d(U){U&&s(J)}}}function Pn(Ee){let J,U,I,Ne,$,Ae,b,De,C,Ta="<p>Decision guide for uploading datasets to Hugging Face Hub. Optimized for Dataset Viewer compatibility and integration with the Hugging Face ecosystem.</p>",Pe,v,Ke,Z,Ja="Your goal is to help a user upload a dataset to the Hugging Face Hub. Ideally, the dataset should be compatible with the Dataset Viewer (and thus the <code>load_dataset</code> function) to ensure easy access and usability. You should aim to meet the following criteria:",Oe,_,wa="<thead><tr><th><strong>Criteria</strong></th> <th>Description</th> <th>Priority</th></tr></thead> <tbody><tr><td><strong>Respect repository limits</strong></td> <td>Ensure the dataset adheres to Hugging Face’s storage limits for file sizes, repository sizes, and file counts. See the Critical Constraints section below for specific limits.</td> <td>Required</td></tr> <tr><td><strong>Use hub-compatible formats</strong></td> <td>Use Parquet format when possible (best compression, rich typing, large dataset support). For smaller datasets (&lt;several GB), JSON/JSONL or CSV are acceptable. Raw files work well for images/audio in smaller datasets while respecting repo limits. Use WebDataset (.tar) for large media collections. Domain-specific formats can be used when conversion is impractical.</td> <td>Desired</td></tr> <tr><td><strong>Dataset Viewer compatibility</strong></td> <td>Structure data to work with the automatic Dataset Viewer, enabling preview and easy exploration. This typically means using supported formats and proper file organization. Validation steps are provided later in this guide.</td> <td>Desired</td></tr> <tr><td><strong>Organize data sensibly</strong></td> <td>Use logical folder structures that match Hub conventions (e.g., train/test splits). Configs can be used to define different configurations of the dataset. This facilitates both human understanding and automatic data loading.</td> <td>Desired</td></tr> <tr><td><strong>Use appropriate Features</strong></td> <td>When using the datasets library, specify correct feature types (e.g., Image(), Audio(), ClassLabel()) to ensure proper data handling and viewer functionality. This enables type-specific optimizations and previews.</td> <td>Required (when using datasets library)</td></tr> <tr><td><strong>Document non-standard datasets</strong></td> <td>If conversion to hub-compatible formats is impossible and custom formats must be used, ensure repository limits are strictly followed and provide clear documentation on how to download and load the dataset. Include usage examples and any special requirements.</td> <td>Required (when datasets library isn’t compatible)</td></tr></tbody>",ts,x,es,G,Ua="When you don’t have direct access to the user’s files (e.g., web interface), ask the user to run these commands to understand their dataset:",ss,B,ja="<strong>Dataset structure</strong>:",ls,X,as,F,ba="<strong>Check file sizes</strong>:",ns,W,is,V,Ia="<strong>Peek at data format</strong>:",rs,k,os,q,$a="<strong>Quick file count</strong>:",ps,H,ds,R,us,L,Ca="<strong>Storage Limits</strong>:",ms,Y,cs,z,va="<strong>Human-readable summary</strong>:",fs,Q,Za='<li>Free: 100GB private datasets</li> <li>Pro (for individuals) | Team or Enterprise (for organizations): 1TB+ private storage per seat (see <a href="https://huggingface.co/pricing" rel="nofollow">pricing</a>)</li> <li>Public: 300GB (contact <a href="mailto:datasets@huggingface.co">datasets@huggingface.co</a> for larger)</li> <li>Per file: 50GB max, 20GB recommended</li> <li>Per folder: &lt;10k files</li>',Ms,S,_a='See <a href="https://huggingface.co/docs/hub/storage-limits#repository-limitations-and-recommendations" rel="nofollow">https://huggingface.co/docs/hub/storage-limits#repository-limitations-and-recommendations</a> for current limits for current recommendations for repository sizes and file counts.',hs,E,ys,N,xa='<thead><tr><th>Your Data</th> <th>Recommended Approach</th> <th>Quick Command</th></tr></thead> <tbody><tr><td><strong>CSV/JSON files</strong></td> <td>Use built-in loaders (handles any size via memory mapping)</td> <td><code>load_dataset(&quot;csv&quot;, data_files=&quot;data.csv&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Images in folders</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/image_load" rel="nofollow">imagefolder</a> for automatic class detection</td> <td><code>load_dataset(&quot;imagefolder&quot;, data_dir=&quot;./images&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Audio files</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/audio_load" rel="nofollow">audiofolder</a> for automatic organization</td> <td><code>load_dataset(&quot;audiofolder&quot;, data_dir=&quot;./audio&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Video files</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/video_load#videofolder" rel="nofollow">videofolder</a> for automatic organization</td> <td><code>load_dataset(&quot;videofolder&quot;, data_dir=&quot;./videos&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>PDF documents</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/document_dataset#pdffolder" rel="nofollow">pdffolder</a> for text extraction</td> <td><code>load_dataset(&quot;pdffolder&quot;, data_dir=&quot;./pdfs&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Very large datasets (100GB+)</strong></td> <td>Use <code>max_shard_size</code> to control memory usage</td> <td><code>dataset.push_to_hub(&quot;username/dataset&quot;, max_shard_size=&quot;5GB&quot;)</code></td></tr> <tr><td><strong>Many files / directories (&gt;10k)</strong></td> <td>Use upload_large_folder to avoid Git limitations</td> <td><code>api.upload_large_folder(folder_path=&quot;./data&quot;, repo_id=&quot;username/dataset&quot;, repo_type=&quot;dataset&quot;)</code></td></tr> <tr><td><strong>Streaming large media</strong></td> <td>WebDataset format for efficient streaming</td> <td>Create .tar shards, then <code>upload_large_folder()</code></td></tr> <tr><td><strong>Scientific data (HDF5, NetCDF)</strong></td> <td>Convert to Parquet with Array features</td> <td>See <a href="#scientific-data">Scientific Data</a> section</td></tr> <tr><td><strong>Custom/proprietary formats</strong></td> <td>Document thoroughly if conversion impossible</td> <td><code>upload_large_folder()</code> with comprehensive README</td></tr></tbody>',gs,A,Ts,y,Xe,Ga="<p>✓ <strong>Gather dataset information</strong> (if needed):</p> <ul><li>What type of data? (images, text, audio, CSV, etc.)</li> <li>How is it organized? (folder structure, single file, multiple files)</li> <li>What’s the approximate size?</li> <li>What format are the files in?</li> <li>Any special requirements? (e.g., streaming, private access)</li> <li>Check for existing README or documentation files that describe the dataset</li></ul>",na,Fe,Ba="<p>✓ <strong>Authenticate</strong>:</p> <ul><li>CLI: <code>hf auth login</code></li> <li>Or use token: <code>HfApi(token=&quot;hf_...&quot;)</code> or set <code>HF_TOKEN</code> environment variable</li></ul>",ia,We,Xa='<p>✓ <strong>Identify your data type</strong>: Check the <a href="#quick-reference-by-data-type">Quick Reference</a> table above</p>',ra,Ve,Fa='<p>✓ <strong>Choose upload method</strong>:</p> <ul><li><strong>Small files (&lt;1GB) with hub-compatible format</strong>: Can use <a href="https://huggingface.co/new-dataset" rel="nofollow">Hub UI</a> for quick uploads</li> <li><strong>Built-in loader available</strong>: Use the loader + <code>push_to_hub()</code> (see Quick Reference table)</li> <li><strong>Large datasets or many files</strong>: Use <code>upload_large_folder()</code> for files &gt;100GB or &gt;10k files</li> <li><strong>Custom formats</strong>: Convert to hub-compatible format if possible, otherwise document thoroughly</li></ul>',oa,D,ke,Wa="✓ <strong>Test locally</strong> (if using built-in loader):",pa,P,da,K,qe,Va="✓ <strong>Upload to Hub</strong>:",ua,O,ma,He,ka='<p>✓ <strong>Verify your upload</strong>:</p> <ul><li>Check Dataset Viewer: <code>https://huggingface.co/datasets/username/dataset-name</code></li> <li>Test loading: <code>load_dataset(&quot;username/dataset-name&quot;)</code></li> <li>If viewer shows errors, check the <a href="#common-issues--solutions">Troubleshooting</a> section</li></ul>',Js,tt,ws,et,qa="When built-in loaders don’t match your data structure, use the datasets library as a compatibility layer. Convert your data to a Dataset object, then use <code>push_to_hub()</code> for maximum flexibility and Dataset Viewer compatibility.",Us,st,js,lt,Ha="If you already have your data working in pandas, polars, or other dataframe libraries, you can convert directly:",bs,at,Is,nt,$s,it,Ra="When built-in loaders don’t match your data format, convert to Dataset objects following these principles:",Cs,rt,vs,ot,La="<strong>1. Prefer wide/flat structures over joins</strong>",Zs,pt,Ya="<li>Denormalize relational data into single rows for better usability</li> <li>Include all relevant information in each example</li> <li>Lean towards bigger but more usable data - Hugging Face’s infrastructure uses advanced deduplication (XetHub) and Parquet optimizations to handle redundancy efficiently</li>",_s,dt,za="<strong>2. Use configs for logical dataset variations</strong>",xs,ut,Qa="<li>Beyond train/test/val splits, use configs for different subsets or views of your data</li> <li>Each config can have different features or data organization</li> <li>Example: language-specific configs, task-specific views, or data modalities</li>",Gs,mt,Bs,ct,Sa="<strong>Small datasets (fits in memory) - use <code>Dataset.from_dict()</code></strong>:",Xs,ft,Fs,Mt,Ea="<strong>Large datasets (memory-efficient) - use <code>Dataset.from_generator()</code></strong>:",Ws,ht,Vs,yt,Na="<strong>Tip</strong>: For large datasets, test with a subset first by adding a limit to your generator or using <code>.select(range(100))</code> after creation.",ks,gt,qs,Tt,Hs,Jt,Rs,wt,Aa="<strong>Text + Audio (speech recognition)</strong>:",Ls,Ut,Ys,jt,Da="<strong>Multiple images per example</strong>:",zs,bt,Qs,It,Pa="<strong>Note</strong>: For text + images, consider using ImageFolder with metadata.csv which handles this automatically.",Ss,$t,Es,Ct,Ka="Features define the schema and data types for your dataset columns. Specifying correct features ensures:",Ns,vt,Oa="<li>Proper data handling and type conversion</li> <li>Dataset Viewer functionality (e.g., image/audio previews)</li> <li>Efficient storage and loading</li> <li>Clear documentation of your data structure</li>",As,Zt,tn='For complete feature documentation, see: <a href="https://huggingface.co/docs/datasets/about_dataset_features" rel="nofollow">Dataset Features</a>',Ds,_t,Ps,xt,en="<strong>Basic Types</strong>:",Ks,Gt,sn="<li><code>Value</code>: Scalar values - <code>string</code>, <code>int64</code>, <code>float32</code>, <code>bool</code>, <code>binary</code>, and other numeric types</li> <li><code>ClassLabel</code>: Categorical data with named classes</li> <li><code>Sequence</code>: Lists of any feature type</li> <li><code>LargeList</code>: For very large lists</li>",Os,Bt,ln="<strong>Media Types</strong> (enable Dataset Viewer previews):",tl,Xt,an="<li><code>Image()</code>: Handles various image formats, returns PIL Image objects</li> <li><code>Audio(sampling_rate=16000)</code>: Audio with array data and optional sampling rate</li> <li><code>Video()</code>: Video files</li> <li><code>Pdf()</code>: PDF documents with text extraction</li>",el,Ft,nn="<strong>Array Types</strong> (for tensors/scientific data):",sl,Wt,rn="<li><code>Array2D</code>, <code>Array3D</code>, <code>Array4D</code>, <code>Array5D</code>: Fixed or variable-length arrays</li> <li>Example: <code>Array2D(shape=(224, 224), dtype=&#39;float32&#39;)</code></li> <li>First dimension can be <code>None</code> for variable length</li>",ll,Vt,on="<strong>Translation Types</strong>:",al,kt,pn="<li><code>Translation</code>: For translation pairs with fixed languages</li> <li><code>TranslationVariableLanguages</code>: For translations with varying language pairs</li>",nl,qt,dn="<strong>Note</strong>: New feature types are added regularly. Check the documentation for the latest additions.",il,Ht,rl,Rt,un=`<strong>Dataset objects (use push_to_hub)</strong>:
Use when you’ve loaded/converted data using the datasets library`,ol,Lt,pl,Yt,mn=`<strong>Pre-existing files (use upload_large_folder)</strong>:
Use when you have hub-compatible files (e.g., Parquet files) already prepared and organized`,dl,zt,ul,Qt,cn="<strong>Important</strong>: Before using <code>upload_large_folder</code>, verify the files meet repository limits:",ml,St,fn="<li>Check folder structure if you have file access: ensure no folder contains &gt;10k files</li> <li>Ask the user to confirm: “Are your files in a hub-compatible format (Parquet/CSV/JSON) and organized appropriately?”</li> <li>For non-standard formats, consider converting to Dataset objects first to ensure compatibility</li>",cl,Et,fl,Nt,Mn="<strong>Consider small reformatting</strong>: If data is close to a built-in loader format, suggest minor changes:",Ml,At,hn="<li>Rename columns (e.g., ‘filename’ → ‘file_name’ for ImageFolder)</li> <li>Reorganize folders (e.g., move images into class subfolders)</li> <li>Rename files to match expected patterns (e.g., ‘data.csv’ → ‘train.csv’)</li>",hl,Dt,yn="<strong>Pre-upload</strong>:",yl,w,Re,gn="<p>Test locally: <code>load_dataset(&quot;imagefolder&quot;, data_dir=&quot;./data&quot;)</code></p>",ca,Pt,Le,Tn="Verify features work correctly:",fa,Kt,Ma,Ye,Jn="<p>Check metadata.csv has ‘file_name’ column</p>",ha,ze,wn="<p>Verify relative paths, no leading slashes</p>",ya,Qe,Un="<p>Ensure no folder &gt;10k files</p>",gl,Ot,jn="<strong>Post-upload</strong>:",Tl,te,bn="<li>Check viewer: <code>https://huggingface.co/datasets/username/dataset</code></li> <li>Test loading: <code>load_dataset(&quot;username/dataset&quot;)</code></li> <li>Verify features preserved: <code>print(dataset.features)</code></li>",Jl,ee,wl,se,In="<thead><tr><th>Issue</th> <th>Solution</th></tr></thead> <tbody><tr><td>“Repository not found”</td> <td>Run <code>hf auth login</code></td></tr> <tr><td>Memory errors</td> <td>Use <code>max_shard_size=&quot;500MB&quot;</code></td></tr> <tr><td>Dataset viewer not working</td> <td>Wait 5-10min, check README.md config</td></tr> <tr><td>Timeout errors</td> <td>Use <code>multi_commits=True</code></td></tr> <tr><td>Files &gt;50GB</td> <td>Split into smaller files</td></tr> <tr><td>“File not found”</td> <td>Use relative paths in metadata</td></tr></tbody>",Ul,le,jl,ae,$n="<strong>Note</strong>: This section is primarily for datasets uploaded directly to the Hub (via UI or <code>upload_large_folder</code>). Datasets uploaded with <code>push_to_hub()</code> typically configure the viewer automatically.",bl,ne,Il,ie,Cn="The Dataset Viewer automatically detects standard structures:",$l,re,vn="<li>Files named: <code>train.csv</code>, <code>test.json</code>, <code>validation.parquet</code></li> <li>Directories named: <code>train/</code>, <code>test/</code>, <code>validation/</code></li> <li>Split names with delimiters: <code>test-data.csv</code> ✓ (not <code>testdata.csv</code> ✗)</li>",Cl,oe,vl,pe,Zn="For custom structures, add YAML to your README.md:",Zl,de,_l,ue,_n="Multiple configurations example:",xl,me,Gl,ce,Bl,fe,xn="<li><strong>No viewer after upload</strong>: Wait 5-10 minutes for processing</li> <li><strong>“Config names error”</strong>: Add <code>config_name</code> field (required!)</li> <li><strong>Files not detected</strong>: Check naming patterns (needs delimiters)</li> <li><strong>Viewer disabled</strong>: Remove <code>viewer: false</code> from README YAML</li>",Xl,Me,Fl,he,Wl,ye,Vl,ge,Gn='<strong>Core docs</strong>: <a href="https://huggingface.co/docs/hub/datasets-adding" rel="nofollow">Adding datasets</a> | <a href="https://huggingface.co/docs/hub/datasets-viewer" rel="nofollow">Dataset viewer</a> | <a href="https://huggingface.co/docs/hub/storage-limits" rel="nofollow">Storage limits</a> | <a href="https://huggingface.co/docs/datasets/upload_dataset" rel="nofollow">Upload guide</a>',kl,Te,ql,Je,Bn="Remind users to add a dataset card (README.md) with:",Hl,we,Xn="<li>Dataset description and usage</li> <li>License information</li> <li>Citation details</li>",Rl,Ue,Fn='See <a href="https://huggingface.co/docs/hub/datasets-cards" rel="nofollow">Dataset Cards guide</a> for details.',Ll,Yl,zl,je,Ql,be,Sl,Ie,Wn="For streaming large media datasets:",El,$e,Vn="<li>Create 1-5GB tar shards</li> <li>Consistent internal structure</li> <li>Upload with <code>upload_large_folder</code></li>",Nl,Ce,Al,ve,kn="<li>HDF5/NetCDF → Convert to Parquet with Array features</li> <li>Time series → Array2D(shape=(None, n))</li> <li>Complex metadata → Store as JSON strings</li>",Dl,Ze,Pl,_e,qn="For very specialized or bespoke formats:",Kl,xe,Hn='<li>Search the Hub for similar datasets: <code>https://huggingface.co/datasets</code></li> <li>Ask for advice on the <a href="https://discuss.huggingface.co/c/datasets/10" rel="nofollow">Hugging Face Forums</a></li> <li>Join the <a href="https://hf.co/join/discord" rel="nofollow">Hugging Face Discord</a> for real-time help</li> <li>Many domain-specific formats already have examples on the Hub</li>',Ol,Ge,ta,Se,ea;return $=new h({props:{title:"Hugging Face Dataset Upload Decision Guide",local:"hugging-face-dataset-upload-decision-guide",headingTag:"h1"}}),b=new Nn({props:{$$slots:{default:[Dn]},$$scope:{ctx:Ee}}}),v=new h({props:{title:"Overview",local:"overview",headingTag:"h2"}}),x=new h({props:{title:"Working Without File Access",local:"working-without-file-access",headingTag:"h2"}}),X=new g({props:{code:"JTIzJTIwU2hvdyUyMGRpcmVjdG9yeSUyMHRyZWUlMjAoaW5zdGFsbCUyMHdpdGglM0ElMjBwaXAlMjBpbnN0YWxsJTIwdHJlZSUyMG9yJTIwYnJldyUyMGluc3RhbGwlMjB0cmVlKSUwQXRyZWUlMjAtTCUyMDMlMjAtLWZpbGVsaW1pdCUyMDIwJTBBJTBBJTIzJTIwQWx0ZXJuYXRpdmUlMjB3aXRob3V0JTIwdHJlZSUzQSUwQWZpbmQlMjAuJTIwLXR5cGUlMjBmJTIwLW5hbWUlMjAlMjIqLmNzdiUyMiUyMC1vJTIwLW5hbWUlMjAlMjIqLmpzb24lMjIlMjAtbyUyMC1uYW1lJTIwJTIyKi5wYXJxdWV0JTIyJTIwJTdDJTIwaGVhZCUyMC0yMA==",highlighted:`<span class="hljs-comment"># Show directory tree (install with: pip install tree or brew install tree)</span>
tree -L 3 --filelimit 20

<span class="hljs-comment"># Alternative without tree:</span>
find . -<span class="hljs-built_in">type</span> f -name <span class="hljs-string">&quot;*.csv&quot;</span> -o -name <span class="hljs-string">&quot;*.json&quot;</span> -o -name <span class="hljs-string">&quot;*.parquet&quot;</span> | <span class="hljs-built_in">head</span> -20`,wrap:!1}}),W=new g({props:{code:"JTIzJTIwVG90YWwlMjBkYXRhc2V0JTIwc2l6ZSUwQWR1JTIwLXNoJTIwLiUwQSUwQSUyMyUyMEluZGl2aWR1YWwlMjBmaWxlJTIwc2l6ZXMlMEFscyUyMC1saCUyMGRhdGElMkY=",highlighted:`<span class="hljs-comment"># Total dataset size</span>
<span class="hljs-built_in">du</span> -sh .

<span class="hljs-comment"># Individual file sizes</span>
<span class="hljs-built_in">ls</span> -lh data/`,wrap:!1}}),k=new g({props:{code:"JTIzJTIwRmlyc3QlMjBmZXclMjBsaW5lcyUyMG9mJTIwQ1NWJTJGSlNPTiUwQWhlYWQlMjAtbiUyMDUlMjBkYXRhJTJGdHJhaW4uY3N2JTBBJTBBJTIzJTIwQ2hlY2slMjBpbWFnZSUyMGZvbGRlciUyMHN0cnVjdHVyZSUwQWxzJTIwLWxhJTIwaW1hZ2VzJTJGJTIwJTdDJTIwaGVhZCUyMC0xMA==",highlighted:`<span class="hljs-comment"># First few lines of CSV/JSON</span>
<span class="hljs-built_in">head</span> -n 5 data/train.csv

<span class="hljs-comment"># Check image folder structure</span>
<span class="hljs-built_in">ls</span> -la images/ | <span class="hljs-built_in">head</span> -10`,wrap:!1}}),H=new g({props:{code:"JTIzJTIwQ291bnQlMjBmaWxlcyUyMGJ5JTIwdHlwZSUwQWZpbmQlMjAuJTIwLW5hbWUlMjAlMjIqLmpwZyUyMiUyMCU3QyUyMHdjJTIwLWw=",highlighted:`<span class="hljs-comment"># Count files by type</span>
find . -name <span class="hljs-string">&quot;*.jpg&quot;</span> | <span class="hljs-built_in">wc</span> -l`,wrap:!1}}),R=new h({props:{title:"Critical Constraints",local:"critical-constraints",headingTag:"h2"}}),Y=new g({props:{code:"JTIzJTIwTWFjaGluZS1yZWFkYWJsZSUyMEh1YiUyMGxpbWl0cyUwQWh1Yl9saW1pdHMlM0ElMEElMjAlMjBtYXhfZmlsZV9zaXplX2diJTNBJTIwNTAlMjAlMjMlMjBhYnNvbHV0ZSUyMGhhcmQlMjBzdG9wJTIwZW5mb3JjZWQlMjBieSUyMExGUyUwQSUyMCUyMHJlY29tbWVuZGVkX2ZpbGVfc2l6ZV9nYiUzQSUyMDIwJTIwJTIzJTIwYmVzdC1wcmFjdGljZSUyMHNoYXJkJTIwc2l6ZSUwQSUyMCUyMG1heF9maWxlc19wZXJfZm9sZGVyJTNBJTIwMTAwMDAlMjAlMjMlMjBHaXQlMjBwZXJmb3JtYW5jZSUyMHRocmVzaG9sZCUwQSUyMCUyMG1heF9maWxlc19wZXJfcmVwbyUzQSUyMDEwMDAwMCUyMCUyMyUyMFJlcG9zaXRvcnklMjBmaWxlJTIwY291bnQlMjBsaW1pdCUwQSUyMCUyMHJlY29tbWVuZGVkX3JlcG9fc2l6ZV9nYiUzQSUyMDMwMCUyMCUyMyUyMHB1YmxpYy1yZXBvJTIwc29mdCUyMGNhcCUzQiUyMGNvbnRhY3QlMjBIRiUyMGlmJTIwbGFyZ2VyJTBBJTIwJTIwdmlld2VyX3Jvd19zaXplX21iJTNBJTIwMiUyMCUyMyUyMGFwcHJveGltYXRlJTIwcGVyLXJvdyUyMHZpZXdlciUyMGxpbWl0",highlighted:`<span class="hljs-comment"># Machine-readable Hub limits</span>
<span class="hljs-attr">hub_limits:</span>
  <span class="hljs-attr">max_file_size_gb:</span> <span class="hljs-number">50</span> <span class="hljs-comment"># absolute hard stop enforced by LFS</span>
  <span class="hljs-attr">recommended_file_size_gb:</span> <span class="hljs-number">20</span> <span class="hljs-comment"># best-practice shard size</span>
  <span class="hljs-attr">max_files_per_folder:</span> <span class="hljs-number">10000</span> <span class="hljs-comment"># Git performance threshold</span>
  <span class="hljs-attr">max_files_per_repo:</span> <span class="hljs-number">100000</span> <span class="hljs-comment"># Repository file count limit</span>
  <span class="hljs-attr">recommended_repo_size_gb:</span> <span class="hljs-number">300</span> <span class="hljs-comment"># public-repo soft cap; contact HF if larger</span>
  <span class="hljs-attr">viewer_row_size_mb:</span> <span class="hljs-number">2</span> <span class="hljs-comment"># approximate per-row viewer limit</span>`,wrap:!1}}),E=new h({props:{title:"Quick Reference by Data Type",local:"quick-reference-by-data-type",headingTag:"h2"}}),A=new h({props:{title:"Upload Workflow",local:"upload-workflow",headingTag:"h2"}}),P=new g({props:{code:"JTIzJTIwVmFsaWRhdGUlMjB5b3VyJTIwZGF0YXNldCUyMGxvYWRzJTIwY29ycmVjdGx5JTIwYmVmb3JlJTIwdXBsb2FkaW5nJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJsb2FkZXJfbmFtZSUyMiUyQyUyMGRhdGFfZGlyJTNEJTIyLiUyRnlvdXJfZGF0YSUyMiklMEFwcmludChkYXRhc2V0KQ==",highlighted:`<span class="hljs-comment"># Validate your dataset loads correctly before uploading</span>
dataset = load_dataset(<span class="hljs-string">&quot;loader_name&quot;</span>, data_dir=<span class="hljs-string">&quot;./your_data&quot;</span>)
<span class="hljs-built_in">print</span>(dataset)`,wrap:!1}}),O=new g({props:{code:"JTIzJTIwQmFzaWMlMjB1cGxvYWQlMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldC1uYW1lJTIyKSUwQSUwQSUyMyUyMFdpdGglMjBvcHRpb25zJTIwZm9yJTIwbGFyZ2UlMjBkYXRhc2V0cyUwQWRhdGFzZXQucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwJTIydXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjVHQiUyMiUyQyUyMCUyMCUyMyUyMENvbnRyb2wlMjBtZW1vcnklMjB1c2FnZSUwQSUyMCUyMCUyMCUyMHByaXZhdGUlM0RUcnVlJTIwJTIwJTIzJTIwRm9yJTIwcHJpdmF0ZSUyMGRhdGFzZXRzJTBBKQ==",highlighted:`<span class="hljs-comment"># Basic upload</span>
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># With options for large datasets</span>
dataset.push_to_hub(
    <span class="hljs-string">&quot;username/dataset-name&quot;</span>,
    max_shard_size=<span class="hljs-string">&quot;5GB&quot;</span>,  <span class="hljs-comment"># Control memory usage</span>
    private=<span class="hljs-literal">True</span>  <span class="hljs-comment"># For private datasets</span>
)`,wrap:!1}}),tt=new h({props:{title:"Common Conversion Patterns",local:"common-conversion-patterns",headingTag:"h2"}}),st=new h({props:{title:"From DataFrames",local:"from-dataframes",headingTag:"h3"}}),at=new g({props:{code:"JTIzJTIwRnJvbSUyMHBhbmRhcyUyMERhdGFGcmFtZSUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJ5b3VyX2RhdGEuY3N2JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fcGFuZGFzKGRmKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjIpJTBBJTBBJTIzJTIwRnJvbSUyMHBvbGFycyUyMERhdGFGcmFtZSUyMChkaXJlY3QlMjBtZXRob2QpJTBBaW1wb3J0JTIwcG9sYXJzJTIwYXMlMjBwbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEElMEFkZiUyMCUzRCUyMHBsLnJlYWRfY3N2KCUyMnlvdXJfZGF0YS5jc3YlMjIpJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9wb2xhcnMoZGYpJTIwJTIwJTIzJTIwRGlyZWN0JTIwY29udmVyc2lvbiUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjIpJTBBJTBBJTIzJTIwRnJvbSUyMFB5QXJyb3clMjBUYWJsZSUyMCh1c2VmdWwlMjBmb3IlMjBzY2llbnRpZmljJTIwZGF0YSklMEFpbXBvcnQlMjBweWFycm93JTIwYXMlMjBwYSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEElMEElMjMlMjBJZiUyMHlvdSUyMGhhdmUlMjBhJTIwUHlBcnJvdyUyMHRhYmxlJTBBdGFibGUlMjAlM0QlMjBwYS50YWJsZSglN0InZGF0YSclM0ElMjAlNUIxJTJDJTIwMiUyQyUyMDMlNUQlMkMlMjAnbGFiZWxzJyUzQSUyMCU1QidhJyUyQyUyMCdiJyUyQyUyMCdjJyU1RCU3RCklMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldCh0YWJsZSklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldC1uYW1lJTIyKSUwQSUwQSUyMyUyMEZvciUyMFNwYXJrJTJGRGFzayUyMGRhdGFmcmFtZXMlMkMlMjBzZWUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZG9jcyUyRmh1YiUyRmRhdGFzZXRzLWxpYnJhcmllcw==",highlighted:`<span class="hljs-comment"># From pandas DataFrame</span>
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

df = pd.read_csv(<span class="hljs-string">&quot;your_data.csv&quot;</span>)
dataset = Dataset.from_pandas(df)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># From polars DataFrame (direct method)</span>
<span class="hljs-keyword">import</span> polars <span class="hljs-keyword">as</span> pl
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

df = pl.read_csv(<span class="hljs-string">&quot;your_data.csv&quot;</span>)
dataset = Dataset.from_polars(df)  <span class="hljs-comment"># Direct conversion</span>
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># From PyArrow Table (useful for scientific data)</span>
<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pa
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

<span class="hljs-comment"># If you have a PyArrow table</span>
table = pa.table({<span class="hljs-string">&#x27;data&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>]})
dataset = Dataset(table)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># For Spark/Dask dataframes, see https://huggingface.co/docs/hub/datasets-libraries</span>`,wrap:!1}}),nt=new h({props:{title:"Custom Format Conversion",local:"custom-format-conversion",headingTag:"h2"}}),rt=new h({props:{title:"Design Principles",local:"design-principles",headingTag:"h3"}}),mt=new h({props:{title:"Conversion Methods",local:"conversion-methods",headingTag:"h3"}}),ft=new g({props:{code:"JTIzJTIwUGFyc2UlMjB5b3VyJTIwY3VzdG9tJTIwZm9ybWF0JTIwaW50byUyMGElMjBkaWN0aW9uYXJ5JTBBZGF0YV9kaWN0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCU1QiUyMmV4YW1wbGUxJTIyJTJDJTIwJTIyZXhhbXBsZTIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbCUyMiUzQSUyMCU1QiUyMnBvc2l0aXZlJTIyJTJDJTIwJTIybmVnYXRpdmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMCU1QjAuOSUyQyUyMDAuMiU1RCUwQSU3RCUwQSUwQSUyMyUyMENyZWF0ZSUyMGRhdGFzZXQlMjB3aXRoJTIwYXBwcm9wcmlhdGUlMjBmZWF0dXJlcyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMkMlMjBGZWF0dXJlcyUyQyUyMFZhbHVlJTJDJTIwQ2xhc3NMYWJlbCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTBBJTIwJTIwJTIwJTIwJ3RleHQnJTNBJTIwVmFsdWUoJ3N0cmluZycpJTJDJTBBJTIwJTIwJTIwJTIwJ2xhYmVsJyUzQSUyMENsYXNzTGFiZWwobmFtZXMlM0QlNUInbmVnYXRpdmUnJTJDJTIwJ3Bvc2l0aXZlJyU1RCklMkMlMEElMjAlMjAlMjAlMjAnc2NvcmUnJTNBJTIwVmFsdWUoJ2Zsb2F0MzInKSUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZGF0YV9kaWN0JTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldCUyMik=",highlighted:`<span class="hljs-comment"># Parse your custom format into a dictionary</span>
data_dict = {
    <span class="hljs-string">&quot;text&quot;</span>: [<span class="hljs-string">&quot;example1&quot;</span>, <span class="hljs-string">&quot;example2&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>],
    <span class="hljs-string">&quot;score&quot;</span>: [<span class="hljs-number">0.9</span>, <span class="hljs-number">0.2</span>]
}

<span class="hljs-comment"># Create dataset with appropriate features</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Value, ClassLabel
features = Features({
    <span class="hljs-string">&#x27;text&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>),
    <span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>]),
    <span class="hljs-string">&#x27;score&#x27;</span>: Value(<span class="hljs-string">&#x27;float32&#x27;</span>)
})

dataset = Dataset.from_dict(data_dict, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>)`,wrap:!1}}),ht=new g({props:{code:"ZGVmJTIwZGF0YV9nZW5lcmF0b3IoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFBhcnNlJTIweW91ciUyMGN1c3RvbSUyMGZvcm1hdCUyMHByb2dyZXNzaXZlbHklMEElMjAlMjAlMjAlMjBmb3IlMjBpdGVtJTIwaW4lMjBwYXJzZV9sYXJnZV9maWxlKCUyMmRhdGEuY3VzdG9tJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMGl0ZW0lNUIlMjJjb250ZW50JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGFiZWwlMjIlM0ElMjBpdGVtJTVCJTIyY2F0ZWdvcnklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbWJlZGRpbmclMjIlM0ElMjBpdGVtJTVCJTIydmVjdG9yJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIzJTIwU3BlY2lmeSUyMGZlYXR1cmVzJTIwZm9yJTIwRGF0YXNldCUyMFZpZXdlciUyMGNvbXBhdGliaWxpdHklMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBGZWF0dXJlcyUyQyUyMFZhbHVlJTJDJTIwQ2xhc3NMYWJlbCUyQyUyMExpc3QlMEFmZWF0dXJlcyUyMCUzRCUyMEZlYXR1cmVzKCU3QiUwQSUyMCUyMCUyMCUyMCd0ZXh0JyUzQSUyMFZhbHVlKCdzdHJpbmcnKSUyQyUwQSUyMCUyMCUyMCUyMCdsYWJlbCclM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJ2NhdDEnJTJDJTIwJ2NhdDInJTJDJTIwJ2NhdDMnJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCdlbWJlZGRpbmcnJTNBJTIwTGlzdChmZWF0dXJlJTNEVmFsdWUoJ2Zsb2F0MzInKSUyQyUyMGxlbmd0aCUzRDc2OCklMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9nZW5lcmF0b3IoZGF0YV9nZW5lcmF0b3IlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0JTIyJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjIxR0IlMjIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data_generator</span>():
    <span class="hljs-comment"># Parse your custom format progressively</span>
    <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> parse_large_file(<span class="hljs-string">&quot;data.custom&quot;</span>):
        <span class="hljs-keyword">yield</span> {
            <span class="hljs-string">&quot;text&quot;</span>: item[<span class="hljs-string">&quot;content&quot;</span>],
            <span class="hljs-string">&quot;label&quot;</span>: item[<span class="hljs-string">&quot;category&quot;</span>],
            <span class="hljs-string">&quot;embedding&quot;</span>: item[<span class="hljs-string">&quot;vector&quot;</span>]
        }

<span class="hljs-comment"># Specify features for Dataset Viewer compatibility</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Features, Value, ClassLabel, <span class="hljs-type">List</span>
features = Features({
    <span class="hljs-string">&#x27;text&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>),
    <span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(names=[<span class="hljs-string">&#x27;cat1&#x27;</span>, <span class="hljs-string">&#x27;cat2&#x27;</span>, <span class="hljs-string">&#x27;cat3&#x27;</span>]),
    <span class="hljs-string">&#x27;embedding&#x27;</span>: <span class="hljs-type">List</span>(feature=Value(<span class="hljs-string">&#x27;float32&#x27;</span>), length=<span class="hljs-number">768</span>)
})

dataset = Dataset.from_generator(data_generator, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>)`,wrap:!1}}),gt=new h({props:{title:"Using Configs for Dataset Variations",local:"using-configs-for-dataset-variations",headingTag:"h3"}}),Tt=new g({props:{code:"JTIzJTIwUHVzaCUyMGRpZmZlcmVudCUyMGNvbmZpZ3VyYXRpb25zJTIwb2YlMjB5b3VyJTIwZGF0YXNldCUwQWRhdGFzZXRfZW4lMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdChlbmdsaXNoX2RhdGElMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXRfZW4ucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZtdWx0aWxpbmd1YWwtZGF0YXNldCUyMiUyQyUyMGNvbmZpZ19uYW1lJTNEJTIyZW5nbGlzaCUyMiklMEElMEFkYXRhc2V0X2ZyJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZnJlbmNoX2RhdGElMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXRfZnIucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZtdWx0aWxpbmd1YWwtZGF0YXNldCUyMiUyQyUyMGNvbmZpZ19uYW1lJTNEJTIyZnJlbmNoJTIyKSUwQSUwQSUyMyUyMFVzZXJzJTIwY2FuJTIwdGhlbiUyMGxvYWQlMjBzcGVjaWZpYyUyMGNvbmZpZ3MlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnVzZXJuYW1lJTJGbXVsdGlsaW5ndWFsLWRhdGFzZXQlMjIlMkMlMjAlMjJlbmdsaXNoJTIyKQ==",highlighted:`<span class="hljs-comment"># Push different configurations of your dataset</span>
dataset_en = Dataset.from_dict(english_data, features=features)
dataset_en.push_to_hub(<span class="hljs-string">&quot;username/multilingual-dataset&quot;</span>, config_name=<span class="hljs-string">&quot;english&quot;</span>)

dataset_fr = Dataset.from_dict(french_data, features=features)
dataset_fr.push_to_hub(<span class="hljs-string">&quot;username/multilingual-dataset&quot;</span>, config_name=<span class="hljs-string">&quot;french&quot;</span>)

<span class="hljs-comment"># Users can then load specific configs</span>
dataset = load_dataset(<span class="hljs-string">&quot;username/multilingual-dataset&quot;</span>, <span class="hljs-string">&quot;english&quot;</span>)`,wrap:!1}}),Jt=new h({props:{title:"Multi-modal Examples",local:"multi-modal-examples",headingTag:"h3"}}),Ut=new g({props:{code:"ZGVmJTIwc3BlZWNoX2dlbmVyYXRvcigpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYXVkaW9fZmlsZSUyMGluJTIwUGF0aCglMjJhdWRpbyUyRiUyMikuZ2xvYiglMjIqLndhdiUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2NyaXB0X2ZpbGUlMjAlM0QlMjBhdWRpb19maWxlLndpdGhfc3VmZml4KCUyMi50eHQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMHN0cihhdWRpb19maWxlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjB0cmFuc2NyaXB0X2ZpbGUucmVhZF90ZXh0KCkuc3RyaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwZWFrZXJfaWQlMjIlM0ElMjBhdWRpb19maWxlLnN0ZW0uc3BsaXQoJTIyXyUyMiklNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMEElMjAlMjAlMjAlMjAnYXVkaW8nJTNBJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSUyQyUwQSUyMCUyMCUyMCUyMCd0ZXh0JyUzQSUyMFZhbHVlKCdzdHJpbmcnKSUyQyUwQSUyMCUyMCUyMCUyMCdzcGVha2VyX2lkJyUzQSUyMFZhbHVlKCdzdHJpbmcnKSUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2dlbmVyYXRvcihzcGVlY2hfZ2VuZXJhdG9yJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGc3BlZWNoLWRhdGFzZXQlMjIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_generator</span>():
    <span class="hljs-keyword">for</span> audio_file <span class="hljs-keyword">in</span> Path(<span class="hljs-string">&quot;audio/&quot;</span>).glob(<span class="hljs-string">&quot;*.wav&quot;</span>):
        transcript_file = audio_file.with_suffix(<span class="hljs-string">&quot;.txt&quot;</span>)
        <span class="hljs-keyword">yield</span> {
            <span class="hljs-string">&quot;audio&quot;</span>: <span class="hljs-built_in">str</span>(audio_file),
            <span class="hljs-string">&quot;text&quot;</span>: transcript_file.read_text().strip(),
            <span class="hljs-string">&quot;speaker_id&quot;</span>: audio_file.stem.split(<span class="hljs-string">&quot;_&quot;</span>)[<span class="hljs-number">0</span>]
        }

features = Features({
    <span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>),
    <span class="hljs-string">&#x27;text&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>),
    <span class="hljs-string">&#x27;speaker_id&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>)
})

dataset = Dataset.from_generator(speech_generator, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/speech-dataset&quot;</span>)`,wrap:!1}}),bt=new g({props:{code:"JTIzJTIwQmVmb3JlJTJGYWZ0ZXIlMjBpbWFnZXMlMkMlMjBtZWRpY2FsJTIwaW1hZ2luZyUyQyUyMGV0Yy4lMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW1hZ2VfYmVmb3JlJTIyJTNBJTIwJTVCJTIyaW1nMV9iZWZvcmUuanBnJTIyJTJDJTIwJTIyaW1nMl9iZWZvcmUuanBnJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyaW1hZ2VfYWZ0ZXIlMjIlM0ElMjAlNUIlMjJpbWcxX2FmdGVyLmpwZyUyMiUyQyUyMCUyMmltZzJfYWZ0ZXIuanBnJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJlYXRtZW50JTIyJTNBJTIwJTVCJTIybWV0aG9kX0ElMjIlMkMlMjAlMjJtZXRob2RfQiUyMiU1RCUwQSU3RCUwQSUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTBBJTIwJTIwJTIwJTIwJ2ltYWdlX2JlZm9yZSclM0ElMjBJbWFnZSgpJTJDJTBBJTIwJTIwJTIwJTIwJ2ltYWdlX2FmdGVyJyUzQSUyMEltYWdlKCklMkMlMEElMjAlMjAlMjAlMjAndHJlYXRtZW50JyUzQSUyMENsYXNzTGFiZWwobmFtZXMlM0QlNUInbWV0aG9kX0EnJTJDJTIwJ21ldGhvZF9CJyU1RCklMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGRhdGElMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZiZWZvcmUtYWZ0ZXItaW1hZ2VzJTIyKQ==",highlighted:`<span class="hljs-comment"># Before/after images, medical imaging, etc.</span>
data = {
    <span class="hljs-string">&quot;image_before&quot;</span>: [<span class="hljs-string">&quot;img1_before.jpg&quot;</span>, <span class="hljs-string">&quot;img2_before.jpg&quot;</span>],
    <span class="hljs-string">&quot;image_after&quot;</span>: [<span class="hljs-string">&quot;img1_after.jpg&quot;</span>, <span class="hljs-string">&quot;img2_after.jpg&quot;</span>],
    <span class="hljs-string">&quot;treatment&quot;</span>: [<span class="hljs-string">&quot;method_A&quot;</span>, <span class="hljs-string">&quot;method_B&quot;</span>]
}

features = Features({
    <span class="hljs-string">&#x27;image_before&#x27;</span>: Image(),
    <span class="hljs-string">&#x27;image_after&#x27;</span>: Image(),
    <span class="hljs-string">&#x27;treatment&#x27;</span>: ClassLabel(names=[<span class="hljs-string">&#x27;method_A&#x27;</span>, <span class="hljs-string">&#x27;method_B&#x27;</span>])
})

dataset = Dataset.from_dict(data, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/before-after-images&quot;</span>)`,wrap:!1}}),$t=new h({props:{title:"Essential Features",local:"essential-features",headingTag:"h2"}}),_t=new h({props:{title:"Feature Types Overview",local:"feature-types-overview",headingTag:"h3"}}),Ht=new h({props:{title:"Upload Methods",local:"upload-methods",headingTag:"h2"}}),Lt=new g({props:{code:"ZGF0YXNldC5wdXNoX3RvX2h1YiglMjJ1c2VybmFtZSUyRmRhdGFzZXQlMjIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjVHQiUyMik=",highlighted:'dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>, max_shard_size=<span class="hljs-string">&quot;5GB&quot;</span>)',wrap:!1}}),zt=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfbGFyZ2VfZm9sZGVyKGZvbGRlcl9wYXRoJTNEJTIyLiUyRmRhdGElMjIlMkMlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZkYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMG51bV93b3JrZXJzJTNEMTYp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()
api.upload_large_folder(folder_path=<span class="hljs-string">&quot;./data&quot;</span>, repo_id=<span class="hljs-string">&quot;username/dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, num_workers=<span class="hljs-number">16</span>)`,wrap:!1}}),Et=new h({props:{title:"Validation",local:"validation",headingTag:"h2"}}),Kt=new g({props:{code:"JTIzJTIwVGVzdCUyMGZpcnN0JTIwZXhhbXBsZSUwQXByaW50KGRhdGFzZXQlNUIwJTVEKSUwQSUwQSUyMyUyMEZvciUyMGltYWdlcyUzQSUyMHZlcmlmeSUyMHRoZXklMjBsb2FkJTBBaWYlMjAnaW1hZ2UnJTIwaW4lMjBkYXRhc2V0LmZlYXR1cmVzJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCU1QjAlNUQlNUInaW1hZ2UnJTVEJTIwJTIwJTIzJTIwU2hvdWxkJTIwcmV0dXJuJTIwUElMJTIwSW1hZ2UlMEElMEElMjMlMjBDaGVjayUyMGRhdGFzZXQlMjBzaXplJTIwYmVmb3JlJTIwdXBsb2FkJTBBcHJpbnQoZiUyMlNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjBleGFtcGxlcyUyMik=",highlighted:`<span class="hljs-comment"># Test first example</span>
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-number">0</span>])

<span class="hljs-comment"># For images: verify they load</span>
<span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;image&#x27;</span> <span class="hljs-keyword">in</span> dataset.features:
    dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image&#x27;</span>]  <span class="hljs-comment"># Should return PIL Image</span>

<span class="hljs-comment"># Check dataset size before upload</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span> examples&quot;</span>)`,wrap:!1}}),ee=new h({props:{title:"Common Issues → Solutions",local:"common-issues--solutions",headingTag:"h2"}}),le=new h({props:{title:"Dataset Viewer Configuration",local:"dataset-viewer-configuration",headingTag:"h2"}}),ne=new h({props:{title:"When automatic detection works",local:"when-automatic-detection-works",headingTag:"h3"}}),oe=new h({props:{title:"Manual configuration",local:"manual-configuration",headingTag:"h3"}}),de=new g({props:{code:"LS0tJTBBY29uZmlncyUzQSUwQSUyMCUyMC0lMjBjb25maWdfbmFtZSUzQSUyMGRlZmF1bHQlMjAlMjMlMjBSZXF1aXJlZCUyMGV2ZW4lMjBmb3IlMjBzaW5nbGUlMjBjb25maWchJTBBJTIwJTIwJTIwJTIwZGF0YV9maWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMC0lMjBzcGxpdCUzQSUyMHRyYWluJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aCUzQSUyMCUyMmRhdGElMkZ0cmFpbiUyRioucGFycXVldCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMC0lMjBzcGxpdCUzQSUyMHRlc3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoJTNBJTIwJTIyZGF0YSUyRnRlc3QlMkYqLnBhcnF1ZXQlMjIlMEEtLS0=",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">configs:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-attr">config_name:</span> <span class="hljs-string">default</span> <span class="hljs-comment"># Required even for single config!</span>
    <span class="hljs-attr">data_files:</span>
      <span class="hljs-bullet">-</span> <span class="hljs-attr">split:</span> <span class="hljs-string">train</span>
        <span class="hljs-attr">path:</span> <span class="hljs-string">&quot;data/train/*.parquet&quot;</span>
      <span class="hljs-bullet">-</span> <span class="hljs-attr">split:</span> <span class="hljs-string">test</span>
        <span class="hljs-attr">path:</span> <span class="hljs-string">&quot;data/test/*.parquet&quot;</span>
<span class="hljs-meta">---</span>`,wrap:!1}}),me=new g({props:{code:"LS0tJTBBY29uZmlncyUzQSUwQSUyMCUyMC0lMjBjb25maWdfbmFtZSUzQSUyMGVuZ2xpc2glMEElMjAlMjAlMjAlMjBkYXRhX2ZpbGVzJTNBJTIwJTIyZW4lMkYqLnBhcnF1ZXQlMjIlMEElMjAlMjAtJTIwY29uZmlnX25hbWUlM0ElMjBmcmVuY2glMEElMjAlMjAlMjAlMjBkYXRhX2ZpbGVzJTNBJTIwJTIyZnIlMkYqLnBhcnF1ZXQlMjIlMEEtLS0=",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">configs:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-attr">config_name:</span> <span class="hljs-string">english</span>
    <span class="hljs-attr">data_files:</span> <span class="hljs-string">&quot;en/*.parquet&quot;</span>
  <span class="hljs-bullet">-</span> <span class="hljs-attr">config_name:</span> <span class="hljs-string">french</span>
    <span class="hljs-attr">data_files:</span> <span class="hljs-string">&quot;fr/*.parquet&quot;</span>
<span class="hljs-meta">---</span>`,wrap:!1}}),ce=new h({props:{title:"Common viewer issues",local:"common-viewer-issues",headingTag:"h3"}}),Me=new h({props:{title:"Quick Templates",local:"quick-templates",headingTag:"h2"}}),he=new g({props:{code:"JTIzJTIwSW1hZ2VGb2xkZXIlMjB3aXRoJTIwbWV0YWRhdGElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltYWdlZm9sZGVyJTIyJTJDJTIwZGF0YV9kaXIlM0QlMjIuJTJGaW1hZ2VzJTIyKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0JTIyKSUwQSUwQSUyMyUyME1lbW9yeS1lZmZpY2llbnQlMjB1cGxvYWQlMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldCUyMiUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyNTAwTUIlMjIpJTBBJTBBJTIzJTIwTXVsdGlwbGUlMjBDU1YlMjBmaWxlcyUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ2NzdiclMkMlMjBkYXRhX2ZpbGVzJTNEJTdCJ3RyYWluJyUzQSUyMCd0cmFpbi5jc3YnJTJDJTIwJ3Rlc3QnJTNBJTIwJ3Rlc3QuY3N2JyU3RCklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldCUyMik=",highlighted:`<span class="hljs-comment"># ImageFolder with metadata</span>
dataset = load_dataset(<span class="hljs-string">&quot;imagefolder&quot;</span>, data_dir=<span class="hljs-string">&quot;./images&quot;</span>)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>)

<span class="hljs-comment"># Memory-efficient upload</span>
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>, max_shard_size=<span class="hljs-string">&quot;500MB&quot;</span>)

<span class="hljs-comment"># Multiple CSV files</span>
dataset = load_dataset(<span class="hljs-string">&#x27;csv&#x27;</span>, data_files={<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;train.csv&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>: <span class="hljs-string">&#x27;test.csv&#x27;</span>})
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>)`,wrap:!1}}),ye=new h({props:{title:"Documentation",local:"documentation",headingTag:"h2"}}),Te=new h({props:{title:"Dataset Cards",local:"dataset-cards",headingTag:"h2"}}),je=new h({props:{title:"Appendix: Special Cases",local:"appendix-special-cases",headingTag:"h2"}}),be=new h({props:{title:"WebDataset Structure",local:"webdataset-structure",headingTag:"h3"}}),Ce=new h({props:{title:"Scientific Data",local:"scientific-data",headingTag:"h3"}}),Ze=new h({props:{title:"Community Resources",local:"community-resources",headingTag:"h3"}}),Ge=new An({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-upload-guide-llm.md"}}),{c(){J=i("meta"),U=a(),I=i("p"),Ne=a(),p($.$$.fragment),Ae=a(),p(b.$$.fragment),De=a(),C=i("blockquote"),C.innerHTML=Ta,Pe=a(),p(v.$$.fragment),Ke=a(),Z=i("p"),Z.innerHTML=Ja,Oe=a(),_=i("table"),_.innerHTML=wa,ts=a(),p(x.$$.fragment),es=a(),G=i("p"),G.textContent=Ua,ss=a(),B=i("p"),B.innerHTML=ja,ls=a(),p(X.$$.fragment),as=a(),F=i("p"),F.innerHTML=ba,ns=a(),p(W.$$.fragment),is=a(),V=i("p"),V.innerHTML=Ia,rs=a(),p(k.$$.fragment),os=a(),q=i("p"),q.innerHTML=$a,ps=a(),p(H.$$.fragment),ds=a(),p(R.$$.fragment),us=a(),L=i("p"),L.innerHTML=Ca,ms=a(),p(Y.$$.fragment),cs=a(),z=i("p"),z.innerHTML=va,fs=a(),Q=i("ul"),Q.innerHTML=Za,Ms=a(),S=i("p"),S.innerHTML=_a,hs=a(),p(E.$$.fragment),ys=a(),N=i("table"),N.innerHTML=xa,gs=a(),p(A.$$.fragment),Ts=a(),y=i("ol"),Xe=i("li"),Xe.innerHTML=Ga,na=a(),Fe=i("li"),Fe.innerHTML=Ba,ia=a(),We=i("li"),We.innerHTML=Xa,ra=a(),Ve=i("li"),Ve.innerHTML=Fa,oa=a(),D=i("li"),ke=i("p"),ke.innerHTML=Wa,pa=a(),p(P.$$.fragment),da=a(),K=i("li"),qe=i("p"),qe.innerHTML=Va,ua=a(),p(O.$$.fragment),ma=a(),He=i("li"),He.innerHTML=ka,Js=a(),p(tt.$$.fragment),ws=a(),et=i("p"),et.innerHTML=qa,Us=a(),p(st.$$.fragment),js=a(),lt=i("p"),lt.textContent=Ha,bs=a(),p(at.$$.fragment),Is=a(),p(nt.$$.fragment),$s=a(),it=i("p"),it.textContent=Ra,Cs=a(),p(rt.$$.fragment),vs=a(),ot=i("p"),ot.innerHTML=La,Zs=a(),pt=i("ul"),pt.innerHTML=Ya,_s=a(),dt=i("p"),dt.innerHTML=za,xs=a(),ut=i("ul"),ut.innerHTML=Qa,Gs=a(),p(mt.$$.fragment),Bs=a(),ct=i("p"),ct.innerHTML=Sa,Xs=a(),p(ft.$$.fragment),Fs=a(),Mt=i("p"),Mt.innerHTML=Ea,Ws=a(),p(ht.$$.fragment),Vs=a(),yt=i("p"),yt.innerHTML=Na,ks=a(),p(gt.$$.fragment),qs=a(),p(Tt.$$.fragment),Hs=a(),p(Jt.$$.fragment),Rs=a(),wt=i("p"),wt.innerHTML=Aa,Ls=a(),p(Ut.$$.fragment),Ys=a(),jt=i("p"),jt.innerHTML=Da,zs=a(),p(bt.$$.fragment),Qs=a(),It=i("p"),It.innerHTML=Pa,Ss=a(),p($t.$$.fragment),Es=a(),Ct=i("p"),Ct.textContent=Ka,Ns=a(),vt=i("ul"),vt.innerHTML=Oa,As=a(),Zt=i("p"),Zt.innerHTML=tn,Ds=a(),p(_t.$$.fragment),Ps=a(),xt=i("p"),xt.innerHTML=en,Ks=a(),Gt=i("ul"),Gt.innerHTML=sn,Os=a(),Bt=i("p"),Bt.innerHTML=ln,tl=a(),Xt=i("ul"),Xt.innerHTML=an,el=a(),Ft=i("p"),Ft.innerHTML=nn,sl=a(),Wt=i("ul"),Wt.innerHTML=rn,ll=a(),Vt=i("p"),Vt.innerHTML=on,al=a(),kt=i("ul"),kt.innerHTML=pn,nl=a(),qt=i("p"),qt.innerHTML=dn,il=a(),p(Ht.$$.fragment),rl=a(),Rt=i("p"),Rt.innerHTML=un,ol=a(),p(Lt.$$.fragment),pl=a(),Yt=i("p"),Yt.innerHTML=mn,dl=a(),p(zt.$$.fragment),ul=a(),Qt=i("p"),Qt.innerHTML=cn,ml=a(),St=i("ul"),St.innerHTML=fn,cl=a(),p(Et.$$.fragment),fl=a(),Nt=i("p"),Nt.innerHTML=Mn,Ml=a(),At=i("ul"),At.innerHTML=hn,hl=a(),Dt=i("p"),Dt.innerHTML=yn,yl=a(),w=i("ul"),Re=i("li"),Re.innerHTML=gn,ca=a(),Pt=i("li"),Le=i("p"),Le.textContent=Tn,fa=a(),p(Kt.$$.fragment),Ma=a(),Ye=i("li"),Ye.innerHTML=Jn,ha=a(),ze=i("li"),ze.innerHTML=wn,ya=a(),Qe=i("li"),Qe.innerHTML=Un,gl=a(),Ot=i("p"),Ot.innerHTML=jn,Tl=a(),te=i("ul"),te.innerHTML=bn,Jl=a(),p(ee.$$.fragment),wl=a(),se=i("table"),se.innerHTML=In,Ul=a(),p(le.$$.fragment),jl=a(),ae=i("p"),ae.innerHTML=$n,bl=a(),p(ne.$$.fragment),Il=a(),ie=i("p"),ie.textContent=Cn,$l=a(),re=i("ul"),re.innerHTML=vn,Cl=a(),p(oe.$$.fragment),vl=a(),pe=i("p"),pe.textContent=Zn,Zl=a(),p(de.$$.fragment),_l=a(),ue=i("p"),ue.textContent=_n,xl=a(),p(me.$$.fragment),Gl=a(),p(ce.$$.fragment),Bl=a(),fe=i("ul"),fe.innerHTML=xn,Xl=a(),p(Me.$$.fragment),Fl=a(),p(he.$$.fragment),Wl=a(),p(ye.$$.fragment),Vl=a(),ge=i("p"),ge.innerHTML=Gn,kl=a(),p(Te.$$.fragment),ql=a(),Je=i("p"),Je.textContent=Bn,Hl=a(),we=i("ul"),we.innerHTML=Xn,Rl=a(),Ue=i("p"),Ue.innerHTML=Fn,Ll=a(),Yl=i("hr"),zl=a(),p(je.$$.fragment),Ql=a(),p(be.$$.fragment),Sl=a(),Ie=i("p"),Ie.textContent=Wn,El=a(),$e=i("ul"),$e.innerHTML=Vn,Nl=a(),p(Ce.$$.fragment),Al=a(),ve=i("ul"),ve.innerHTML=kn,Dl=a(),p(Ze.$$.fragment),Pl=a(),_e=i("p"),_e.textContent=qn,Kl=a(),xe=i("ul"),xe.innerHTML=Hn,Ol=a(),p(Ge.$$.fragment),ta=a(),Se=i("p"),this.h()},l(t){const e=Qn("svelte-u9bgzb",document.head);J=r(e,"META",{name:!0,content:!0}),e.forEach(s),U=n(t),I=r(t,"P",{}),Be(I).forEach(s),Ne=n(t),d($.$$.fragment,t),Ae=n(t),d(b.$$.fragment,t),De=n(t),C=r(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(C)!=="svelte-1fajnvg"&&(C.innerHTML=Ta),Pe=n(t),d(v.$$.fragment,t),Ke=n(t),Z=r(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-hun1os"&&(Z.innerHTML=Ja),Oe=n(t),_=r(t,"TABLE",{"data-svelte-h":!0}),o(_)!=="svelte-1x2va0m"&&(_.innerHTML=wa),ts=n(t),d(x.$$.fragment,t),es=n(t),G=r(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-s1susn"&&(G.textContent=Ua),ss=n(t),B=r(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-183nx4y"&&(B.innerHTML=ja),ls=n(t),d(X.$$.fragment,t),as=n(t),F=r(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ddy51v"&&(F.innerHTML=ba),ns=n(t),d(W.$$.fragment,t),is=n(t),V=r(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1x9yqrg"&&(V.innerHTML=Ia),rs=n(t),d(k.$$.fragment,t),os=n(t),q=r(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1lf1f1j"&&(q.innerHTML=$a),ps=n(t),d(H.$$.fragment,t),ds=n(t),d(R.$$.fragment,t),us=n(t),L=r(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-15kuw4y"&&(L.innerHTML=Ca),ms=n(t),d(Y.$$.fragment,t),cs=n(t),z=r(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-16tkzi3"&&(z.innerHTML=va),fs=n(t),Q=r(t,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1d3231s"&&(Q.innerHTML=Za),Ms=n(t),S=r(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-bpnjb2"&&(S.innerHTML=_a),hs=n(t),d(E.$$.fragment,t),ys=n(t),N=r(t,"TABLE",{"data-svelte-h":!0}),o(N)!=="svelte-1qthh5o"&&(N.innerHTML=xa),gs=n(t),d(A.$$.fragment,t),Ts=n(t),y=r(t,"OL",{start:!0});var T=Be(y);Xe=r(T,"LI",{"data-svelte-h":!0}),o(Xe)!=="svelte-coqx"&&(Xe.innerHTML=Ga),na=n(T),Fe=r(T,"LI",{"data-svelte-h":!0}),o(Fe)!=="svelte-13hzcf6"&&(Fe.innerHTML=Ba),ia=n(T),We=r(T,"LI",{"data-svelte-h":!0}),o(We)!=="svelte-1x7390r"&&(We.innerHTML=Xa),ra=n(T),Ve=r(T,"LI",{"data-svelte-h":!0}),o(Ve)!=="svelte-1lpi177"&&(Ve.innerHTML=Fa),oa=n(T),D=r(T,"LI",{});var sa=Be(D);ke=r(sa,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-docjp3"&&(ke.innerHTML=Wa),pa=n(sa),d(P.$$.fragment,sa),sa.forEach(s),da=n(T),K=r(T,"LI",{});var la=Be(K);qe=r(la,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-8stqwj"&&(qe.innerHTML=Va),ua=n(la),d(O.$$.fragment,la),la.forEach(s),ma=n(T),He=r(T,"LI",{"data-svelte-h":!0}),o(He)!=="svelte-28v5ni"&&(He.innerHTML=ka),T.forEach(s),Js=n(t),d(tt.$$.fragment,t),ws=n(t),et=r(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-au918z"&&(et.innerHTML=qa),Us=n(t),d(st.$$.fragment,t),js=n(t),lt=r(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-lvop0e"&&(lt.textContent=Ha),bs=n(t),d(at.$$.fragment,t),Is=n(t),d(nt.$$.fragment,t),$s=n(t),it=r(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-ar9k36"&&(it.textContent=Ra),Cs=n(t),d(rt.$$.fragment,t),vs=n(t),ot=r(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-iur0js"&&(ot.innerHTML=La),Zs=n(t),pt=r(t,"UL",{"data-svelte-h":!0}),o(pt)!=="svelte-1dkzusn"&&(pt.innerHTML=Ya),_s=n(t),dt=r(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-r65yvz"&&(dt.innerHTML=za),xs=n(t),ut=r(t,"UL",{"data-svelte-h":!0}),o(ut)!=="svelte-9qv5vd"&&(ut.innerHTML=Qa),Gs=n(t),d(mt.$$.fragment,t),Bs=n(t),ct=r(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-iuck5z"&&(ct.innerHTML=Sa),Xs=n(t),d(ft.$$.fragment,t),Fs=n(t),Mt=r(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-15huzsb"&&(Mt.innerHTML=Ea),Ws=n(t),d(ht.$$.fragment,t),Vs=n(t),yt=r(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-12bonk0"&&(yt.innerHTML=Na),ks=n(t),d(gt.$$.fragment,t),qs=n(t),d(Tt.$$.fragment,t),Hs=n(t),d(Jt.$$.fragment,t),Rs=n(t),wt=r(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1u8i1rn"&&(wt.innerHTML=Aa),Ls=n(t),d(Ut.$$.fragment,t),Ys=n(t),jt=r(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1jgfsm0"&&(jt.innerHTML=Da),zs=n(t),d(bt.$$.fragment,t),Qs=n(t),It=r(t,"P",{"data-svelte-h":!0}),o(It)!=="svelte-wsof8w"&&(It.innerHTML=Pa),Ss=n(t),d($t.$$.fragment,t),Es=n(t),Ct=r(t,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1odksos"&&(Ct.textContent=Ka),Ns=n(t),vt=r(t,"UL",{"data-svelte-h":!0}),o(vt)!=="svelte-t5ru0o"&&(vt.innerHTML=Oa),As=n(t),Zt=r(t,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1qjpjc5"&&(Zt.innerHTML=tn),Ds=n(t),d(_t.$$.fragment,t),Ps=n(t),xt=r(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1qg37o8"&&(xt.innerHTML=en),Ks=n(t),Gt=r(t,"UL",{"data-svelte-h":!0}),o(Gt)!=="svelte-3fng8i"&&(Gt.innerHTML=sn),Os=n(t),Bt=r(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1x89mat"&&(Bt.innerHTML=ln),tl=n(t),Xt=r(t,"UL",{"data-svelte-h":!0}),o(Xt)!=="svelte-1tm6u7n"&&(Xt.innerHTML=an),el=n(t),Ft=r(t,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-s170ij"&&(Ft.innerHTML=nn),sl=n(t),Wt=r(t,"UL",{"data-svelte-h":!0}),o(Wt)!=="svelte-1rqoami"&&(Wt.innerHTML=rn),ll=n(t),Vt=r(t,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1xno8op"&&(Vt.innerHTML=on),al=n(t),kt=r(t,"UL",{"data-svelte-h":!0}),o(kt)!=="svelte-swic33"&&(kt.innerHTML=pn),nl=n(t),qt=r(t,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-1wn0wiu"&&(qt.innerHTML=dn),il=n(t),d(Ht.$$.fragment,t),rl=n(t),Rt=r(t,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-msn4wa"&&(Rt.innerHTML=un),ol=n(t),d(Lt.$$.fragment,t),pl=n(t),Yt=r(t,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-1oorzyp"&&(Yt.innerHTML=mn),dl=n(t),d(zt.$$.fragment,t),ul=n(t),Qt=r(t,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-egl09b"&&(Qt.innerHTML=cn),ml=n(t),St=r(t,"UL",{"data-svelte-h":!0}),o(St)!=="svelte-j2q96t"&&(St.innerHTML=fn),cl=n(t),d(Et.$$.fragment,t),fl=n(t),Nt=r(t,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-tjyq6k"&&(Nt.innerHTML=Mn),Ml=n(t),At=r(t,"UL",{"data-svelte-h":!0}),o(At)!=="svelte-1dn48bv"&&(At.innerHTML=hn),hl=n(t),Dt=r(t,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-1bpf54c"&&(Dt.innerHTML=yn),yl=n(t),w=r(t,"UL",{});var j=Be(w);Re=r(j,"LI",{"data-svelte-h":!0}),o(Re)!=="svelte-v6f4tr"&&(Re.innerHTML=gn),ca=n(j),Pt=r(j,"LI",{});var aa=Be(Pt);Le=r(aa,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-15dlcf2"&&(Le.textContent=Tn),fa=n(aa),d(Kt.$$.fragment,aa),aa.forEach(s),Ma=n(j),Ye=r(j,"LI",{"data-svelte-h":!0}),o(Ye)!=="svelte-1qjx0kd"&&(Ye.innerHTML=Jn),ha=n(j),ze=r(j,"LI",{"data-svelte-h":!0}),o(ze)!=="svelte-u9u4qm"&&(ze.innerHTML=wn),ya=n(j),Qe=r(j,"LI",{"data-svelte-h":!0}),o(Qe)!=="svelte-1pgq06d"&&(Qe.innerHTML=Un),j.forEach(s),gl=n(t),Ot=r(t,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-1hyf2bz"&&(Ot.innerHTML=jn),Tl=n(t),te=r(t,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-8u5q5t"&&(te.innerHTML=bn),Jl=n(t),d(ee.$$.fragment,t),wl=n(t),se=r(t,"TABLE",{"data-svelte-h":!0}),o(se)!=="svelte-1lkt6pd"&&(se.innerHTML=In),Ul=n(t),d(le.$$.fragment,t),jl=n(t),ae=r(t,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-g003c9"&&(ae.innerHTML=$n),bl=n(t),d(ne.$$.fragment,t),Il=n(t),ie=r(t,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-16loxkj"&&(ie.textContent=Cn),$l=n(t),re=r(t,"UL",{"data-svelte-h":!0}),o(re)!=="svelte-1hto711"&&(re.innerHTML=vn),Cl=n(t),d(oe.$$.fragment,t),vl=n(t),pe=r(t,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-v9qyvd"&&(pe.textContent=Zn),Zl=n(t),d(de.$$.fragment,t),_l=n(t),ue=r(t,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-mkdef3"&&(ue.textContent=_n),xl=n(t),d(me.$$.fragment,t),Gl=n(t),d(ce.$$.fragment,t),Bl=n(t),fe=r(t,"UL",{"data-svelte-h":!0}),o(fe)!=="svelte-13hljct"&&(fe.innerHTML=xn),Xl=n(t),d(Me.$$.fragment,t),Fl=n(t),d(he.$$.fragment,t),Wl=n(t),d(ye.$$.fragment,t),Vl=n(t),ge=r(t,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-vz9qls"&&(ge.innerHTML=Gn),kl=n(t),d(Te.$$.fragment,t),ql=n(t),Je=r(t,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-3if0hu"&&(Je.textContent=Bn),Hl=n(t),we=r(t,"UL",{"data-svelte-h":!0}),o(we)!=="svelte-jr8bcr"&&(we.innerHTML=Xn),Rl=n(t),Ue=r(t,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1f9g19l"&&(Ue.innerHTML=Fn),Ll=n(t),Yl=r(t,"HR",{}),zl=n(t),d(je.$$.fragment,t),Ql=n(t),d(be.$$.fragment,t),Sl=n(t),Ie=r(t,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1cttxvh"&&(Ie.textContent=Wn),El=n(t),$e=r(t,"UL",{"data-svelte-h":!0}),o($e)!=="svelte-1pv9cl9"&&($e.innerHTML=Vn),Nl=n(t),d(Ce.$$.fragment,t),Al=n(t),ve=r(t,"UL",{"data-svelte-h":!0}),o(ve)!=="svelte-1h00ccq"&&(ve.innerHTML=kn),Dl=n(t),d(Ze.$$.fragment,t),Pl=n(t),_e=r(t,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-qsd78w"&&(_e.textContent=qn),Kl=n(t),xe=r(t,"UL",{"data-svelte-h":!0}),o(xe)!=="svelte-gadoy2"&&(xe.innerHTML=Hn),Ol=n(t),d(Ge.$$.fragment,t),ta=n(t),Se=r(t,"P",{}),Be(Se).forEach(s),this.h()},h(){ga(J,"name","hf:doc:metadata"),ga(J,"content",Kn),ga(y,"start","0")},m(t,e){M(document.head,J),l(t,U,e),l(t,I,e),l(t,Ne,e),u($,t,e),l(t,Ae,e),u(b,t,e),l(t,De,e),l(t,C,e),l(t,Pe,e),u(v,t,e),l(t,Ke,e),l(t,Z,e),l(t,Oe,e),l(t,_,e),l(t,ts,e),u(x,t,e),l(t,es,e),l(t,G,e),l(t,ss,e),l(t,B,e),l(t,ls,e),u(X,t,e),l(t,as,e),l(t,F,e),l(t,ns,e),u(W,t,e),l(t,is,e),l(t,V,e),l(t,rs,e),u(k,t,e),l(t,os,e),l(t,q,e),l(t,ps,e),u(H,t,e),l(t,ds,e),u(R,t,e),l(t,us,e),l(t,L,e),l(t,ms,e),u(Y,t,e),l(t,cs,e),l(t,z,e),l(t,fs,e),l(t,Q,e),l(t,Ms,e),l(t,S,e),l(t,hs,e),u(E,t,e),l(t,ys,e),l(t,N,e),l(t,gs,e),u(A,t,e),l(t,Ts,e),l(t,y,e),M(y,Xe),M(y,na),M(y,Fe),M(y,ia),M(y,We),M(y,ra),M(y,Ve),M(y,oa),M(y,D),M(D,ke),M(D,pa),u(P,D,null),M(y,da),M(y,K),M(K,qe),M(K,ua),u(O,K,null),M(y,ma),M(y,He),l(t,Js,e),u(tt,t,e),l(t,ws,e),l(t,et,e),l(t,Us,e),u(st,t,e),l(t,js,e),l(t,lt,e),l(t,bs,e),u(at,t,e),l(t,Is,e),u(nt,t,e),l(t,$s,e),l(t,it,e),l(t,Cs,e),u(rt,t,e),l(t,vs,e),l(t,ot,e),l(t,Zs,e),l(t,pt,e),l(t,_s,e),l(t,dt,e),l(t,xs,e),l(t,ut,e),l(t,Gs,e),u(mt,t,e),l(t,Bs,e),l(t,ct,e),l(t,Xs,e),u(ft,t,e),l(t,Fs,e),l(t,Mt,e),l(t,Ws,e),u(ht,t,e),l(t,Vs,e),l(t,yt,e),l(t,ks,e),u(gt,t,e),l(t,qs,e),u(Tt,t,e),l(t,Hs,e),u(Jt,t,e),l(t,Rs,e),l(t,wt,e),l(t,Ls,e),u(Ut,t,e),l(t,Ys,e),l(t,jt,e),l(t,zs,e),u(bt,t,e),l(t,Qs,e),l(t,It,e),l(t,Ss,e),u($t,t,e),l(t,Es,e),l(t,Ct,e),l(t,Ns,e),l(t,vt,e),l(t,As,e),l(t,Zt,e),l(t,Ds,e),u(_t,t,e),l(t,Ps,e),l(t,xt,e),l(t,Ks,e),l(t,Gt,e),l(t,Os,e),l(t,Bt,e),l(t,tl,e),l(t,Xt,e),l(t,el,e),l(t,Ft,e),l(t,sl,e),l(t,Wt,e),l(t,ll,e),l(t,Vt,e),l(t,al,e),l(t,kt,e),l(t,nl,e),l(t,qt,e),l(t,il,e),u(Ht,t,e),l(t,rl,e),l(t,Rt,e),l(t,ol,e),u(Lt,t,e),l(t,pl,e),l(t,Yt,e),l(t,dl,e),u(zt,t,e),l(t,ul,e),l(t,Qt,e),l(t,ml,e),l(t,St,e),l(t,cl,e),u(Et,t,e),l(t,fl,e),l(t,Nt,e),l(t,Ml,e),l(t,At,e),l(t,hl,e),l(t,Dt,e),l(t,yl,e),l(t,w,e),M(w,Re),M(w,ca),M(w,Pt),M(Pt,Le),M(Pt,fa),u(Kt,Pt,null),M(w,Ma),M(w,Ye),M(w,ha),M(w,ze),M(w,ya),M(w,Qe),l(t,gl,e),l(t,Ot,e),l(t,Tl,e),l(t,te,e),l(t,Jl,e),u(ee,t,e),l(t,wl,e),l(t,se,e),l(t,Ul,e),u(le,t,e),l(t,jl,e),l(t,ae,e),l(t,bl,e),u(ne,t,e),l(t,Il,e),l(t,ie,e),l(t,$l,e),l(t,re,e),l(t,Cl,e),u(oe,t,e),l(t,vl,e),l(t,pe,e),l(t,Zl,e),u(de,t,e),l(t,_l,e),l(t,ue,e),l(t,xl,e),u(me,t,e),l(t,Gl,e),u(ce,t,e),l(t,Bl,e),l(t,fe,e),l(t,Xl,e),u(Me,t,e),l(t,Fl,e),u(he,t,e),l(t,Wl,e),u(ye,t,e),l(t,Vl,e),l(t,ge,e),l(t,kl,e),u(Te,t,e),l(t,ql,e),l(t,Je,e),l(t,Hl,e),l(t,we,e),l(t,Rl,e),l(t,Ue,e),l(t,Ll,e),l(t,Yl,e),l(t,zl,e),u(je,t,e),l(t,Ql,e),u(be,t,e),l(t,Sl,e),l(t,Ie,e),l(t,El,e),l(t,$e,e),l(t,Nl,e),u(Ce,t,e),l(t,Al,e),l(t,ve,e),l(t,Dl,e),u(Ze,t,e),l(t,Pl,e),l(t,_e,e),l(t,Kl,e),l(t,xe,e),l(t,Ol,e),u(Ge,t,e),l(t,ta,e),l(t,Se,e),ea=!0},p(t,[e]){const T={};e&2&&(T.$$scope={dirty:e,ctx:t}),b.$set(T)},i(t){ea||(m($.$$.fragment,t),m(b.$$.fragment,t),m(v.$$.fragment,t),m(x.$$.fragment,t),m(X.$$.fragment,t),m(W.$$.fragment,t),m(k.$$.fragment,t),m(H.$$.fragment,t),m(R.$$.fragment,t),m(Y.$$.fragment,t),m(E.$$.fragment,t),m(A.$$.fragment,t),m(P.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(st.$$.fragment,t),m(at.$$.fragment,t),m(nt.$$.fragment,t),m(rt.$$.fragment,t),m(mt.$$.fragment,t),m(ft.$$.fragment,t),m(ht.$$.fragment,t),m(gt.$$.fragment,t),m(Tt.$$.fragment,t),m(Jt.$$.fragment,t),m(Ut.$$.fragment,t),m(bt.$$.fragment,t),m($t.$$.fragment,t),m(_t.$$.fragment,t),m(Ht.$$.fragment,t),m(Lt.$$.fragment,t),m(zt.$$.fragment,t),m(Et.$$.fragment,t),m(Kt.$$.fragment,t),m(ee.$$.fragment,t),m(le.$$.fragment,t),m(ne.$$.fragment,t),m(oe.$$.fragment,t),m(de.$$.fragment,t),m(me.$$.fragment,t),m(ce.$$.fragment,t),m(Me.$$.fragment,t),m(he.$$.fragment,t),m(ye.$$.fragment,t),m(Te.$$.fragment,t),m(je.$$.fragment,t),m(be.$$.fragment,t),m(Ce.$$.fragment,t),m(Ze.$$.fragment,t),m(Ge.$$.fragment,t),ea=!0)},o(t){c($.$$.fragment,t),c(b.$$.fragment,t),c(v.$$.fragment,t),c(x.$$.fragment,t),c(X.$$.fragment,t),c(W.$$.fragment,t),c(k.$$.fragment,t),c(H.$$.fragment,t),c(R.$$.fragment,t),c(Y.$$.fragment,t),c(E.$$.fragment,t),c(A.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(tt.$$.fragment,t),c(st.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(rt.$$.fragment,t),c(mt.$$.fragment,t),c(ft.$$.fragment,t),c(ht.$$.fragment,t),c(gt.$$.fragment,t),c(Tt.$$.fragment,t),c(Jt.$$.fragment,t),c(Ut.$$.fragment,t),c(bt.$$.fragment,t),c($t.$$.fragment,t),c(_t.$$.fragment,t),c(Ht.$$.fragment,t),c(Lt.$$.fragment,t),c(zt.$$.fragment,t),c(Et.$$.fragment,t),c(Kt.$$.fragment,t),c(ee.$$.fragment,t),c(le.$$.fragment,t),c(ne.$$.fragment,t),c(oe.$$.fragment,t),c(de.$$.fragment,t),c(me.$$.fragment,t),c(ce.$$.fragment,t),c(Me.$$.fragment,t),c(he.$$.fragment,t),c(ye.$$.fragment,t),c(Te.$$.fragment,t),c(je.$$.fragment,t),c(be.$$.fragment,t),c(Ce.$$.fragment,t),c(Ze.$$.fragment,t),c(Ge.$$.fragment,t),ea=!1},d(t){t&&(s(U),s(I),s(Ne),s(Ae),s(De),s(C),s(Pe),s(Ke),s(Z),s(Oe),s(_),s(ts),s(es),s(G),s(ss),s(B),s(ls),s(as),s(F),s(ns),s(is),s(V),s(rs),s(os),s(q),s(ps),s(ds),s(us),s(L),s(ms),s(cs),s(z),s(fs),s(Q),s(Ms),s(S),s(hs),s(ys),s(N),s(gs),s(Ts),s(y),s(Js),s(ws),s(et),s(Us),s(js),s(lt),s(bs),s(Is),s($s),s(it),s(Cs),s(vs),s(ot),s(Zs),s(pt),s(_s),s(dt),s(xs),s(ut),s(Gs),s(Bs),s(ct),s(Xs),s(Fs),s(Mt),s(Ws),s(Vs),s(yt),s(ks),s(qs),s(Hs),s(Rs),s(wt),s(Ls),s(Ys),s(jt),s(zs),s(Qs),s(It),s(Ss),s(Es),s(Ct),s(Ns),s(vt),s(As),s(Zt),s(Ds),s(Ps),s(xt),s(Ks),s(Gt),s(Os),s(Bt),s(tl),s(Xt),s(el),s(Ft),s(sl),s(Wt),s(ll),s(Vt),s(al),s(kt),s(nl),s(qt),s(il),s(rl),s(Rt),s(ol),s(pl),s(Yt),s(dl),s(ul),s(Qt),s(ml),s(St),s(cl),s(fl),s(Nt),s(Ml),s(At),s(hl),s(Dt),s(yl),s(w),s(gl),s(Ot),s(Tl),s(te),s(Jl),s(wl),s(se),s(Ul),s(jl),s(ae),s(bl),s(Il),s(ie),s($l),s(re),s(Cl),s(vl),s(pe),s(Zl),s(_l),s(ue),s(xl),s(Gl),s(Bl),s(fe),s(Xl),s(Fl),s(Wl),s(Vl),s(ge),s(kl),s(ql),s(Je),s(Hl),s(we),s(Rl),s(Ue),s(Ll),s(Yl),s(zl),s(Ql),s(Sl),s(Ie),s(El),s($e),s(Nl),s(Al),s(ve),s(Dl),s(Pl),s(_e),s(Kl),s(xe),s(Ol),s(ta),s(Se)),s(J),f($,t),f(b,t),f(v,t),f(x,t),f(X,t),f(W,t),f(k,t),f(H,t),f(R,t),f(Y,t),f(E,t),f(A,t),f(P),f(O),f(tt,t),f(st,t),f(at,t),f(nt,t),f(rt,t),f(mt,t),f(ft,t),f(ht,t),f(gt,t),f(Tt,t),f(Jt,t),f(Ut,t),f(bt,t),f($t,t),f(_t,t),f(Ht,t),f(Lt,t),f(zt,t),f(Et,t),f(Kt),f(ee,t),f(le,t),f(ne,t),f(oe,t),f(de,t),f(me,t),f(ce,t),f(Me,t),f(he,t),f(ye,t),f(Te,t),f(je,t),f(be,t),f(Ce,t),f(Ze,t),f(Ge,t)}}}const Kn='{"title":"Hugging Face Dataset Upload Decision Guide","local":"hugging-face-dataset-upload-decision-guide","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Working Without File Access","local":"working-without-file-access","sections":[],"depth":2},{"title":"Critical Constraints","local":"critical-constraints","sections":[],"depth":2},{"title":"Quick Reference by Data Type","local":"quick-reference-by-data-type","sections":[],"depth":2},{"title":"Upload Workflow","local":"upload-workflow","sections":[],"depth":2},{"title":"Common Conversion Patterns","local":"common-conversion-patterns","sections":[{"title":"From DataFrames","local":"from-dataframes","sections":[],"depth":3}],"depth":2},{"title":"Custom Format Conversion","local":"custom-format-conversion","sections":[{"title":"Design Principles","local":"design-principles","sections":[],"depth":3},{"title":"Conversion Methods","local":"conversion-methods","sections":[],"depth":3},{"title":"Using Configs for Dataset Variations","local":"using-configs-for-dataset-variations","sections":[],"depth":3},{"title":"Multi-modal Examples","local":"multi-modal-examples","sections":[],"depth":3}],"depth":2},{"title":"Essential Features","local":"essential-features","sections":[{"title":"Feature Types Overview","local":"feature-types-overview","sections":[],"depth":3}],"depth":2},{"title":"Upload Methods","local":"upload-methods","sections":[],"depth":2},{"title":"Validation","local":"validation","sections":[],"depth":2},{"title":"Common Issues → Solutions","local":"common-issues--solutions","sections":[],"depth":2},{"title":"Dataset Viewer Configuration","local":"dataset-viewer-configuration","sections":[{"title":"When automatic detection works","local":"when-automatic-detection-works","sections":[],"depth":3},{"title":"Manual configuration","local":"manual-configuration","sections":[],"depth":3},{"title":"Common viewer issues","local":"common-viewer-issues","sections":[],"depth":3}],"depth":2},{"title":"Quick Templates","local":"quick-templates","sections":[],"depth":2},{"title":"Documentation","local":"documentation","sections":[],"depth":2},{"title":"Dataset Cards","local":"dataset-cards","sections":[],"depth":2},{"title":"Appendix: Special Cases","local":"appendix-special-cases","sections":[{"title":"WebDataset Structure","local":"webdataset-structure","sections":[],"depth":3},{"title":"Scientific Data","local":"scientific-data","sections":[],"depth":3},{"title":"Community Resources","local":"community-resources","sections":[],"depth":3}],"depth":2}],"depth":1}';function On(Ee){return Ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ni extends Yn{constructor(J){super(),zn(this,J,On,Pn,Rn,{})}}export{ni as component};
