import{s as kn,o as jn,n as Ce}from"../chunks/scheduler.85c25b89.js";import{S as vn,i as $n,g as d,s as r,r as u,A as Jn,h as p,f as o,c as a,j,u as g,x as T,k as v,y as l,a as c,v as h,d as f,t as M,w as b}from"../chunks/index.c9bcf812.js";import{T as Bn}from"../chunks/Tip.d8f753fa.js";import{D as Z}from"../chunks/Docstring.af42ec0f.js";import{C as ne}from"../chunks/CodeBlock.c004bd26.js";import{E as Oe}from"../chunks/ExampleCodeBlock.9054a1f5.js";import{H as z}from"../chunks/index.9790a2b6.js";function Nn(k){let s,_="Execute <code>optimum-cli export neuron --help</code> to display all command line options and their description.";return{c(){s=d("p"),s.innerHTML=_},l(m){s=p(m,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1nu66vu"&&(s.innerHTML=_)},m(m,i){c(m,s,i)},p:Ce,d(m){m&&o(s)}}}function Cn(k){let s,_="Example:",m,i,y;return i=new ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25CZXJ0TW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLXVuY2FzZWQtbmV1cm9ueC1iczEtc3ExMjglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25CZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1uZXVyb254LWJzMS1zcTEyOCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyRGVhciUyMEV2YW4lMjBIYW5zZW4lMjBpcyUyMHRoZSUyMHdpbm5lciUyMG9mJTIwc2l4JTIwVG9ueSUyMEF3YXJkcy4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronBertModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-neuronx-bs1-sq128&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronBertModel.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-neuronx-bs1-sq128&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Dear Evan Hansen is the winner of six Tony Awards.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){s=d("p"),s.textContent=_,m=r(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),T(s)!=="svelte-11lpom8"&&(s.textContent=_),m=a(t),g(i.$$.fragment,t)},m(t,w){c(t,s,w),c(t,m,w),h(i,t,w),y=!0},p:Ce,i(t){y||(f(i.$$.fragment,t),y=!0)},o(t){M(i.$$.fragment,t),y=!1},d(t){t&&(o(s),o(m)),b(i,t)}}}function Un(k){let s,_="Example:",m,i,y;return i=new ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25CZXJ0Rm9yTWFza2VkTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGbGVnYWwtYmVydC1iYXNlLXVuY2FzZWQtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbkJlcnRGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmxlZ2FsLWJlcnQtYmFzZS11bmNhc2VkLW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoaXMlMjAlNUJNQVNLJTVEJTIwQWdyZWVtZW50JTIwaXMlMjBiZXR3ZWVuJTIwR2VuZXJhbCUyME1vdG9ycyUyMGFuZCUyMEpvaG4lMjBNdXJyYXkuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronBertForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronBertForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This [MASK] Agreement is between General Motors and John Murray.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">30522</span>]`,wrap:!1}}),{c(){s=d("p"),s.textContent=_,m=r(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),T(s)!=="svelte-11lpom8"&&(s.textContent=_),m=a(t),g(i.$$.fragment,t)},m(t,w){c(t,s,w),c(t,m,w),h(i,t,w),y=!0},p:Ce,i(t){y||(f(i.$$.fragment,t),y=!0)},o(t){M(i.$$.fragment,t),y=!1},d(t){t&&(o(s),o(m)),b(i,t)}}}function Zn(k){let s,_="Example:",m,i,y;return i=new ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25CZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtbXVsdGlsaW5ndWFsLXVuY2FzZWQtc2VudGltZW50LW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25CZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1tdWx0aWxpbmd1YWwtdW5jYXNlZC1zZW50aW1lbnQtbmV1cm9ueCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGFtaWx0b24lMjBpcyUyMGNvbnNpZGVyZWQlMjB0byUyMGJlJTIwdGhlJTIwYmVzdCUyMG11c2ljYWwlMjBvZiUyMGh1bWFuJTIwaGlzdG9yeS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronBertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-multilingual-uncased-sentiment-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronBertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-multilingual-uncased-sentiment-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hamilton is considered to be the best musical of human history.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){s=d("p"),s.textContent=_,m=r(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),T(s)!=="svelte-11lpom8"&&(s.textContent=_),m=a(t),g(i.$$.fragment,t)},m(t,w){c(t,s,w),c(t,m,w),h(i,t,w),y=!0},p:Ce,i(t){y||(f(i.$$.fragment,t),y=!0)},o(t){M(i.$$.fragment,t),y=!1},d(t){t&&(o(s),o(m)),b(i,t)}}}function Fn(k){let s,_="Example:",m,i,y;return i=new ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25CZXJ0Rm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25CZXJ0Rm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVItbmV1cm9ueCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTGluLU1hbnVlbCUyME1pcmFuZGElMjBpcyUyMGFuJTIwQW1lcmljYW4lMjBzb25nd3JpdGVyJTJDJTIwYWN0b3IlMkMlMjBzaW5nZXIlMkMlMjBmaWxtbWFrZXIlMkMlMjBhbmQlMjBwbGF5d3JpZ2h0LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronBertForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronBertForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Lin-Manuel Miranda is an American songwriter, actor, singer, filmmaker, and playwright.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">20</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){s=d("p"),s.textContent=_,m=r(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),T(s)!=="svelte-11lpom8"&&(s.textContent=_),m=a(t),g(i.$$.fragment,t)},m(t,w){c(t,s,w),c(t,m,w),h(i,t,w),y=!0},p:Ce,i(t){y||(f(i.$$.fragment,t),y=!0)},o(t){M(i.$$.fragment,t),y=!1},d(t){t&&(o(s),o(m)),b(i,t)}}}function In(k){let s,_="Example:",m,i,y;return i=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbkJlcnRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtY2FzZWQtc3F1YWQyLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25CZXJ0Rm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtY2FzZWQtc3F1YWQyLW5ldXJvbnglMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyQXJlJTIwdGhlcmUlMjB3aGVlbGNoYWlyJTIwc3BhY2VzJTIwaW4lMjB0aGUlMjB0aGVhdHJlcyUzRiUyMiUyQyUyMCUyMlllcyUyQyUyMHdlJTIwaGF2ZSUyMHJlc2VydmVkJTIwd2hlZWxjaGFpciUyMHNwYWNlcyUyMHdpdGglMjBhJTIwZ29vZCUyMHZpZXcuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHF1ZXN0aW9uJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RhcnRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjElNUQpJTBBZW5kX3Bvc2l0aW9ucyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxMiU1RCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBzdGFydF9wb3NpdGlvbnMlM0RzdGFydF9wb3NpdGlvbnMlMkMlMjBlbmRfcG9zaXRpb25zJTNEZW5kX3Bvc2l0aW9ucyklMEFzdGFydF9zY29yZXMlMjAlM0QlMjBvdXRwdXRzLnN0YXJ0X2xvZ2l0cyUwQWVuZF9zY29yZXMlMjAlM0QlMjBvdXRwdXRzLmVuZF9sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronBertForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-cased-squad2-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronBertForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-cased-squad2-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Are there wheelchair spaces in the theatres?&quot;</span>, <span class="hljs-string">&quot;Yes, we have reserved wheelchair spaces with a good view.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">12</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){s=d("p"),s.textContent=_,m=r(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),T(s)!=="svelte-11lpom8"&&(s.textContent=_),m=a(t),g(i.$$.fragment,t)},m(t,w){c(t,s,w),c(t,m,w),h(i,t,w),y=!0},p:Ce,i(t){y||(f(i.$$.fragment,t),y=!0)},o(t){M(i.$$.fragment,t),y=!1},d(t){t&&(o(s),o(m)),b(i,t)}}}function Wn(k){let s,_="Example:",m,i,y;return i=new ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25CZXJ0Rm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLWNhc2VkLXN3YWctbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbkJlcnRGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1jYXNlZC1zd2FnLW5ldXJvbnglMjIpJTBBJTBBbnVtX2Nob2ljZXMlMjAlM0QlMjA0JTBBZmlyc3Rfc2VudGVuY2UlMjAlM0QlMjAlNUIlMjJNZW1iZXJzJTIwb2YlMjB0aGUlMjBwcm9jZXNzaW9uJTIwd2FsayUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBob2xkaW5nJTIwc21hbGwlMjBob3JuJTIwYnJhc3MlMjBpbnN0cnVtZW50cy4lMjIlNUQlMjAqJTIwbnVtX2Nob2ljZXMlMEFzZWNvbmRfc2VudGVuY2UlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBwYXNzZXMlMjBieSUyMHdhbGtpbmclMjBkb3duJTIwdGhlJTIwc3RyZWV0JTIwcGxheWluZyUyMHRoZWlyJTIwaW5zdHJ1bWVudHMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwaGFzJTIwaGVhcmQlMjBhcHByb2FjaGluZyUyMHRoZW0uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwYXJyaXZlcyUyMGFuZCUyMHRoZXkncmUlMjBvdXRzaWRlJTIwZGFuY2luZyUyMGFuZCUyMGFzbGVlcC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjB0dXJucyUyMHRoZSUyMGxlYWQlMjBzaW5nZXIlMjB3YXRjaGVzJTIwdGhlJTIwcGVyZm9ybWFuY2UuJTIyJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGZpcnN0X3NlbnRlbmNlJTJDJTIwc2Vjb25kX3NlbnRlbmNlJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlNUJrJTVEJTIwJTNEJTIwJTVCdiU1QmklM0ElMjBpJTIwJTJCJTIwbnVtX2Nob2ljZXMlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHYpJTJDJTIwbnVtX2Nob2ljZXMpJTVEJTBBaW5wdXRzJTIwJTNEJTIwZGljdChpbnB1dHMuY29udmVydF90b190ZW5zb3JzKHRlbnNvcl90eXBlJTNEJTIycHQlMjIpKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxvZ2l0cy5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronBertForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-cased-swag-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronBertForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-cased-swag-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>]`,wrap:!1}}),{c(){s=d("p"),s.textContent=_,m=r(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),T(s)!=="svelte-11lpom8"&&(s.textContent=_),m=a(t),g(i.$$.fragment,t)},m(t,w){c(t,s,w),c(t,m,w),h(i,t,w),y=!0},p:Ce,i(t){y||(f(i.$$.fragment,t),y=!0)},o(t){M(i.$$.fragment,t),y=!1},d(t){t&&(o(s),o(m)),b(i,t)}}}function Xn(k){let s,_,m,i,y,t,w,et,oe,en='<a href="https://huggingface.co/papers/1810.04805" rel="nofollow">BERT</a> is a bidirectional transformer pretrained on unlabeled text to predict masked tokens in a sentence and to predict whether one sentence follows another. The main idea is that by randomly masking some tokens, the model can train on text to the left and right, giving it a more thorough understanding. BERT is also very versatile because its learned language representations can be adapted for other NLP tasks by fine-tuning an additional layer or head.',tt,se,tn='You can find all the original BERT checkpoints under the <a href="https://huggingface.co/collections/google/bert-release-64ff5e7a4be99045d1896dbc" rel="nofollow">BERT</a> collection.',nt,re,ot,ae,nn='To deploy 🤗 <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> models on Neuron devices, you first need to compile the models and export them to a serialized format for inference. Below are two approaches to compile the model, you can choose the one that best suits your needs. Here we take the <code>feature-extraction</code> as an example:',st,le,rt,ie,on="You can export the model using the Optimum command-line interface as follows:",at,ce,lt,Q,it,de,ct,pe,dt,me,pt,$,ue,jt,Ue,sn="Bare Bert Model transformer outputting raw hidden-states without any specific head on top, used for the task “feature-extraction”.",vt,Ze,rn=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,$t,x,ge,Jt,Fe,an="The <code>NeuronBertModel</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Bt,L,mt,he,ut,J,fe,Nt,Ie,ln="Masked language Bert Model with a <code>language modeling</code> head on top, for masked language modeling tasks on Neuron devices.",Ct,We,cn=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Ut,V,Me,Zt,Xe,dn="The <code>NeuronBertForMaskedLM</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Ft,Y,gt,be,ht,B,ye,It,ze,pn=`Neuron Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,Wt,xe,mn=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Xt,G,we,zt,Ve,un="The <code>NeuronBertForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",xt,P,ft,Te,Mt,N,_e,Vt,Ge,gn=`Neuron Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks.`,Gt,Ee,hn=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Et,E,ke,Rt,Re,fn="The <code>NeuronBertForTokenClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",qt,D,bt,je,yt,C,ve,Ht,qe,Mn=`Bert with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,St,He,bn=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,At,R,$e,Qt,Se,yn="The <code>NeuronBertForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Lt,O,wt,Je,Tt,U,Be,Yt,Ae,wn=`Neuron Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,Pt,Qe,Tn=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Dt,q,Ne,Ot,Le,_n="The <code>NeuronBertForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Kt,K,_t,Ke,kt;return y=new z({props:{title:"BERT",local:"bert",headingTag:"h1"}}),w=new z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),re=new z({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),le=new z({props:{title:"Option 1: CLI",local:"option-1-cli",headingTag:"h3"}}),ce=new ne({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMC0tdGFzayUyMGZlYXR1cmUtZXh0cmFjdGlvbiUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDEyOCUyMGJlcnRfZmVhdHVyZV9leHRyYWN0aW9uX25ldXJvbnglMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model google-bert/bert-base-uncased --task feature-extraction --batch_size 1 --sequence_length 128 bert_feature_extraction_neuronx/',wrap:!1}}),Q=new Bn({props:{warning:!1,$$slots:{default:[Nn]},$$scope:{ctx:k}}}),de=new z({props:{title:"Option 2: Python API",local:"option-2-python-api",headingTag:"h3"}}),pe=new ne({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMTI4JTdEJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMlMkMlMEElMjAlMjAlMjAlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMEEpJTBBJTIzJTIwU2F2ZSUyMGxvY2FsbHklMEFuZXVyb25fbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmJlcnRfZmVhdHVyZV9leHRyYWN0aW9uX25ldXJvbnglMjIpJTBBJTBBJTIzJTIwVXBsb2FkJTIwdG8lMjB0aGUlMjBIdWdnaW5nRmFjZSUyMEh1YiUwQW5ldXJvbl9tb2RlbC5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjAlMjJiZXJ0X2ZlYXR1cmVfZXh0cmFjdGlvbl9uZXVyb254JTIyJTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwSEYlMjBIdWIlMjByZXBvJTIwaWQlMEEp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForFeatureExtraction

input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">128</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
neuron_model = NeuronModelForFeatureExtraction.from_pretrained(
    <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>,
    export=<span class="hljs-literal">True</span>,
    **input_shapes,
    **compiler_args,
)
<span class="hljs-comment"># Save locally</span>
neuron_model.save_pretrained(<span class="hljs-string">&quot;bert_feature_extraction_neuronx&quot;</span>)

<span class="hljs-comment"># Upload to the HuggingFace Hub</span>
neuron_model.push_to_hub(
    <span class="hljs-string">&quot;bert_feature_extraction_neuronx&quot;</span>, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>  <span class="hljs-comment"># Replace with your HF Hub repo id</span>
)`,wrap:!1}}),me=new z({props:{title:"NeuronBertModel",local:"optimum.neuron.NeuronBertModel",headingTag:"h2"}}),ue=new Z({props:{name:"class optimum.neuron.NeuronBertModel",anchor:"optimum.neuron.NeuronBertModel",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertModel.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronBertModel.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L57"}}),ge=new Z({props:{name:"forward",anchor:"optimum.neuron.NeuronBertModel.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronBertModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronBertModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L66"}}),L=new Oe({props:{anchor:"optimum.neuron.NeuronBertModel.forward.example",$$slots:{default:[Cn]},$$scope:{ctx:k}}}),he=new z({props:{title:"NeuronBertForMaskedLM",local:"optimum.neuron.NeuronBertForMaskedLM",headingTag:"h2"}}),fe=new Z({props:{name:"class optimum.neuron.NeuronBertForMaskedLM",anchor:"optimum.neuron.NeuronBertForMaskedLM",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForMaskedLM.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronBertForMaskedLM.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L105"}}),Me=new Z({props:{name:"forward",anchor:"optimum.neuron.NeuronBertForMaskedLM.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronBertForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronBertForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L114"}}),Y=new Oe({props:{anchor:"optimum.neuron.NeuronBertForMaskedLM.forward.example",$$slots:{default:[Un]},$$scope:{ctx:k}}}),be=new z({props:{title:"NeuronBertForSequenceClassification",local:"optimum.neuron.NeuronBertForSequenceClassification",headingTag:"h2"}}),ye=new Z({props:{name:"class optimum.neuron.NeuronBertForSequenceClassification",anchor:"optimum.neuron.NeuronBertForSequenceClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForSequenceClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronBertForSequenceClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L191"}}),we=new Z({props:{name:"forward",anchor:"optimum.neuron.NeuronBertForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronBertForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronBertForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L201"}}),P=new Oe({props:{anchor:"optimum.neuron.NeuronBertForSequenceClassification.forward.example",$$slots:{default:[Zn]},$$scope:{ctx:k}}}),Te=new z({props:{title:"NeuronBertForTokenClassification",local:"optimum.neuron.NeuronBertForTokenClassification",headingTag:"h2"}}),_e=new Z({props:{name:"class optimum.neuron.NeuronBertForTokenClassification",anchor:"optimum.neuron.NeuronBertForTokenClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForTokenClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronBertForTokenClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L234"}}),ke=new Z({props:{name:"forward",anchor:"optimum.neuron.NeuronBertForTokenClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronBertForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronBertForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L244"}}),D=new Oe({props:{anchor:"optimum.neuron.NeuronBertForTokenClassification.forward.example",$$slots:{default:[Fn]},$$scope:{ctx:k}}}),je=new z({props:{title:"NeuronBertForQuestionAnswering",local:"optimum.neuron.NeuronBertForQuestionAnswering",headingTag:"h2"}}),ve=new Z({props:{name:"class optimum.neuron.NeuronBertForQuestionAnswering",anchor:"optimum.neuron.NeuronBertForQuestionAnswering",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForQuestionAnswering.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronBertForQuestionAnswering.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L147"}}),$e=new Z({props:{name:"forward",anchor:"optimum.neuron.NeuronBertForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronBertForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronBertForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L157"}}),O=new Oe({props:{anchor:"optimum.neuron.NeuronBertForQuestionAnswering.forward.example",$$slots:{default:[In]},$$scope:{ctx:k}}}),Je=new z({props:{title:"NeuronBertForMultipleChoice",local:"optimum.neuron.NeuronBertForMultipleChoice",headingTag:"h2"}}),Be=new Z({props:{name:"class optimum.neuron.NeuronBertForMultipleChoice",anchor:"optimum.neuron.NeuronBertForMultipleChoice",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForMultipleChoice.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronBertForMultipleChoice.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L278"}}),Ne=new Z({props:{name:"forward",anchor:"optimum.neuron.NeuronBertForMultipleChoice.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronBertForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronBertForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronBertForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev4/optimum/neuron/models/bert/model.py#L288"}}),K=new Oe({props:{anchor:"optimum.neuron.NeuronBertForMultipleChoice.forward.example",$$slots:{default:[Wn]},$$scope:{ctx:k}}}),{c(){s=d("meta"),_=r(),m=d("p"),i=r(),u(y.$$.fragment),t=r(),u(w.$$.fragment),et=r(),oe=d("p"),oe.innerHTML=en,tt=r(),se=d("p"),se.innerHTML=tn,nt=r(),u(re.$$.fragment),ot=r(),ae=d("p"),ae.innerHTML=nn,st=r(),u(le.$$.fragment),rt=r(),ie=d("p"),ie.textContent=on,at=r(),u(ce.$$.fragment),lt=r(),u(Q.$$.fragment),it=r(),u(de.$$.fragment),ct=r(),u(pe.$$.fragment),dt=r(),u(me.$$.fragment),pt=r(),$=d("div"),u(ue.$$.fragment),jt=r(),Ue=d("p"),Ue.textContent=sn,vt=r(),Ze=d("p"),Ze.innerHTML=rn,$t=r(),x=d("div"),u(ge.$$.fragment),Jt=r(),Fe=d("p"),Fe.innerHTML=an,Bt=r(),u(L.$$.fragment),mt=r(),u(he.$$.fragment),ut=r(),J=d("div"),u(fe.$$.fragment),Nt=r(),Ie=d("p"),Ie.innerHTML=ln,Ct=r(),We=d("p"),We.innerHTML=cn,Ut=r(),V=d("div"),u(Me.$$.fragment),Zt=r(),Xe=d("p"),Xe.innerHTML=dn,Ft=r(),u(Y.$$.fragment),gt=r(),u(be.$$.fragment),ht=r(),B=d("div"),u(ye.$$.fragment),It=r(),ze=d("p"),ze.textContent=pn,Wt=r(),xe=d("p"),xe.innerHTML=mn,Xt=r(),G=d("div"),u(we.$$.fragment),zt=r(),Ve=d("p"),Ve.innerHTML=un,xt=r(),u(P.$$.fragment),ft=r(),u(Te.$$.fragment),Mt=r(),N=d("div"),u(_e.$$.fragment),Vt=r(),Ge=d("p"),Ge.textContent=gn,Gt=r(),Ee=d("p"),Ee.innerHTML=hn,Et=r(),E=d("div"),u(ke.$$.fragment),Rt=r(),Re=d("p"),Re.innerHTML=fn,qt=r(),u(D.$$.fragment),bt=r(),u(je.$$.fragment),yt=r(),C=d("div"),u(ve.$$.fragment),Ht=r(),qe=d("p"),qe.innerHTML=Mn,St=r(),He=d("p"),He.innerHTML=bn,At=r(),R=d("div"),u($e.$$.fragment),Qt=r(),Se=d("p"),Se.innerHTML=yn,Lt=r(),u(O.$$.fragment),wt=r(),u(Je.$$.fragment),Tt=r(),U=d("div"),u(Be.$$.fragment),Yt=r(),Ae=d("p"),Ae.textContent=wn,Pt=r(),Qe=d("p"),Qe.innerHTML=Tn,Dt=r(),q=d("div"),u(Ne.$$.fragment),Ot=r(),Le=d("p"),Le.innerHTML=_n,Kt=r(),u(K.$$.fragment),_t=r(),Ke=d("p"),this.h()},l(e){const n=Jn("svelte-u9bgzb",document.head);s=p(n,"META",{name:!0,content:!0}),n.forEach(o),_=a(e),m=p(e,"P",{}),j(m).forEach(o),i=a(e),g(y.$$.fragment,e),t=a(e),g(w.$$.fragment,e),et=a(e),oe=p(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-16kuata"&&(oe.innerHTML=en),tt=a(e),se=p(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-z34ajl"&&(se.innerHTML=tn),nt=a(e),g(re.$$.fragment,e),ot=a(e),ae=p(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-huz3tp"&&(ae.innerHTML=nn),st=a(e),g(le.$$.fragment,e),rt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-87nkn2"&&(ie.textContent=on),at=a(e),g(ce.$$.fragment,e),lt=a(e),g(Q.$$.fragment,e),it=a(e),g(de.$$.fragment,e),ct=a(e),g(pe.$$.fragment,e),dt=a(e),g(me.$$.fragment,e),pt=a(e),$=p(e,"DIV",{class:!0});var F=j($);g(ue.$$.fragment,F),jt=a(F),Ue=p(F,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-hbw8e6"&&(Ue.textContent=sn),vt=a(F),Ze=p(F,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-t21i2g"&&(Ze.innerHTML=rn),$t=a(F),x=p(F,"DIV",{class:!0});var H=j(x);g(ge.$$.fragment,H),Jt=a(H),Fe=p(H,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-jiesgj"&&(Fe.innerHTML=an),Bt=a(H),g(L.$$.fragment,H),H.forEach(o),F.forEach(o),mt=a(e),g(he.$$.fragment,e),ut=a(e),J=p(e,"DIV",{class:!0});var I=j(J);g(fe.$$.fragment,I),Nt=a(I),Ie=p(I,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-j3mfpi"&&(Ie.innerHTML=ln),Ct=a(I),We=p(I,"P",{"data-svelte-h":!0}),T(We)!=="svelte-t21i2g"&&(We.innerHTML=cn),Ut=a(I),V=p(I,"DIV",{class:!0});var S=j(V);g(Me.$$.fragment,S),Zt=a(S),Xe=p(S,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-1aoqerb"&&(Xe.innerHTML=dn),Ft=a(S),g(Y.$$.fragment,S),S.forEach(o),I.forEach(o),gt=a(e),g(be.$$.fragment,e),ht=a(e),B=p(e,"DIV",{class:!0});var W=j(B);g(ye.$$.fragment,W),It=a(W),ze=p(W,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-sy64kq"&&(ze.textContent=pn),Wt=a(W),xe=p(W,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-t21i2g"&&(xe.innerHTML=mn),Xt=a(W),G=p(W,"DIV",{class:!0});var A=j(G);g(we.$$.fragment,A),zt=a(A),Ve=p(A,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-1a3qtk"&&(Ve.innerHTML=un),xt=a(A),g(P.$$.fragment,A),A.forEach(o),W.forEach(o),ft=a(e),g(Te.$$.fragment,e),Mt=a(e),N=p(e,"DIV",{class:!0});var X=j(N);g(_e.$$.fragment,X),Vt=a(X),Ge=p(X,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-16p5zms"&&(Ge.textContent=gn),Gt=a(X),Ee=p(X,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-t21i2g"&&(Ee.innerHTML=hn),Et=a(X),E=p(X,"DIV",{class:!0});var Ye=j(E);g(ke.$$.fragment,Ye),Rt=a(Ye),Re=p(Ye,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-ht9lny"&&(Re.innerHTML=fn),qt=a(Ye),g(D.$$.fragment,Ye),Ye.forEach(o),X.forEach(o),bt=a(e),g(je.$$.fragment,e),yt=a(e),C=p(e,"DIV",{class:!0});var ee=j(C);g(ve.$$.fragment,ee),Ht=a(ee),qe=p(ee,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-1k6no5p"&&(qe.innerHTML=Mn),St=a(ee),He=p(ee,"P",{"data-svelte-h":!0}),T(He)!=="svelte-t21i2g"&&(He.innerHTML=bn),At=a(ee),R=p(ee,"DIV",{class:!0});var Pe=j(R);g($e.$$.fragment,Pe),Qt=a(Pe),Se=p(Pe,"P",{"data-svelte-h":!0}),T(Se)!=="svelte-1fgv7jr"&&(Se.innerHTML=yn),Lt=a(Pe),g(O.$$.fragment,Pe),Pe.forEach(o),ee.forEach(o),wt=a(e),g(Je.$$.fragment,e),Tt=a(e),U=p(e,"DIV",{class:!0});var te=j(U);g(Be.$$.fragment,te),Yt=a(te),Ae=p(te,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-1kpvzm3"&&(Ae.textContent=wn),Pt=a(te),Qe=p(te,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-t21i2g"&&(Qe.innerHTML=Tn),Dt=a(te),q=p(te,"DIV",{class:!0});var De=j(q);g(Ne.$$.fragment,De),Ot=a(De),Le=p(De,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-ujqr1a"&&(Le.innerHTML=_n),Kt=a(De),g(K.$$.fragment,De),De.forEach(o),te.forEach(o),_t=a(e),Ke=p(e,"P",{}),j(Ke).forEach(o),this.h()},h(){v(s,"name","hf:doc:metadata"),v(s,"content",zn),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){l(document.head,s),c(e,_,n),c(e,m,n),c(e,i,n),h(y,e,n),c(e,t,n),h(w,e,n),c(e,et,n),c(e,oe,n),c(e,tt,n),c(e,se,n),c(e,nt,n),h(re,e,n),c(e,ot,n),c(e,ae,n),c(e,st,n),h(le,e,n),c(e,rt,n),c(e,ie,n),c(e,at,n),h(ce,e,n),c(e,lt,n),h(Q,e,n),c(e,it,n),h(de,e,n),c(e,ct,n),h(pe,e,n),c(e,dt,n),h(me,e,n),c(e,pt,n),c(e,$,n),h(ue,$,null),l($,jt),l($,Ue),l($,vt),l($,Ze),l($,$t),l($,x),h(ge,x,null),l(x,Jt),l(x,Fe),l(x,Bt),h(L,x,null),c(e,mt,n),h(he,e,n),c(e,ut,n),c(e,J,n),h(fe,J,null),l(J,Nt),l(J,Ie),l(J,Ct),l(J,We),l(J,Ut),l(J,V),h(Me,V,null),l(V,Zt),l(V,Xe),l(V,Ft),h(Y,V,null),c(e,gt,n),h(be,e,n),c(e,ht,n),c(e,B,n),h(ye,B,null),l(B,It),l(B,ze),l(B,Wt),l(B,xe),l(B,Xt),l(B,G),h(we,G,null),l(G,zt),l(G,Ve),l(G,xt),h(P,G,null),c(e,ft,n),h(Te,e,n),c(e,Mt,n),c(e,N,n),h(_e,N,null),l(N,Vt),l(N,Ge),l(N,Gt),l(N,Ee),l(N,Et),l(N,E),h(ke,E,null),l(E,Rt),l(E,Re),l(E,qt),h(D,E,null),c(e,bt,n),h(je,e,n),c(e,yt,n),c(e,C,n),h(ve,C,null),l(C,Ht),l(C,qe),l(C,St),l(C,He),l(C,At),l(C,R),h($e,R,null),l(R,Qt),l(R,Se),l(R,Lt),h(O,R,null),c(e,wt,n),h(Je,e,n),c(e,Tt,n),c(e,U,n),h(Be,U,null),l(U,Yt),l(U,Ae),l(U,Pt),l(U,Qe),l(U,Dt),l(U,q),h(Ne,q,null),l(q,Ot),l(q,Le),l(q,Kt),h(K,q,null),c(e,_t,n),c(e,Ke,n),kt=!0},p(e,[n]){const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),Q.$set(F);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),L.$set(H);const I={};n&2&&(I.$$scope={dirty:n,ctx:e}),Y.$set(I);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),P.$set(S);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),D.$set(W);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),O.$set(A);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),K.$set(X)},i(e){kt||(f(y.$$.fragment,e),f(w.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(Q.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(L.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(Me.$$.fragment,e),f(Y.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(P.$$.fragment,e),f(Te.$$.fragment,e),f(_e.$$.fragment,e),f(ke.$$.fragment,e),f(D.$$.fragment,e),f(je.$$.fragment,e),f(ve.$$.fragment,e),f($e.$$.fragment,e),f(O.$$.fragment,e),f(Je.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(K.$$.fragment,e),kt=!0)},o(e){M(y.$$.fragment,e),M(w.$$.fragment,e),M(re.$$.fragment,e),M(le.$$.fragment,e),M(ce.$$.fragment,e),M(Q.$$.fragment,e),M(de.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(ue.$$.fragment,e),M(ge.$$.fragment,e),M(L.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(Me.$$.fragment,e),M(Y.$$.fragment,e),M(be.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(P.$$.fragment,e),M(Te.$$.fragment,e),M(_e.$$.fragment,e),M(ke.$$.fragment,e),M(D.$$.fragment,e),M(je.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),M(O.$$.fragment,e),M(Je.$$.fragment,e),M(Be.$$.fragment,e),M(Ne.$$.fragment,e),M(K.$$.fragment,e),kt=!1},d(e){e&&(o(_),o(m),o(i),o(t),o(et),o(oe),o(tt),o(se),o(nt),o(ot),o(ae),o(st),o(rt),o(ie),o(at),o(lt),o(it),o(ct),o(dt),o(pt),o($),o(mt),o(ut),o(J),o(gt),o(ht),o(B),o(ft),o(Mt),o(N),o(bt),o(yt),o(C),o(wt),o(Tt),o(U),o(_t),o(Ke)),o(s),b(y,e),b(w,e),b(re,e),b(le,e),b(ce,e),b(Q,e),b(de,e),b(pe,e),b(me,e),b(ue),b(ge),b(L),b(he,e),b(fe),b(Me),b(Y),b(be,e),b(ye),b(we),b(P),b(Te,e),b(_e),b(ke),b(D),b(je,e),b(ve),b($e),b(O),b(Je,e),b(Be),b(Ne),b(K)}}}const zn='{"title":"BERT","local":"bert","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Export to Neuron","local":"export-to-neuron","sections":[{"title":"Option 1: CLI","local":"option-1-cli","sections":[],"depth":3},{"title":"Option 2: Python API","local":"option-2-python-api","sections":[],"depth":3}],"depth":2},{"title":"NeuronBertModel","local":"optimum.neuron.NeuronBertModel","sections":[],"depth":2},{"title":"NeuronBertForMaskedLM","local":"optimum.neuron.NeuronBertForMaskedLM","sections":[],"depth":2},{"title":"NeuronBertForSequenceClassification","local":"optimum.neuron.NeuronBertForSequenceClassification","sections":[],"depth":2},{"title":"NeuronBertForTokenClassification","local":"optimum.neuron.NeuronBertForTokenClassification","sections":[],"depth":2},{"title":"NeuronBertForQuestionAnswering","local":"optimum.neuron.NeuronBertForQuestionAnswering","sections":[],"depth":2},{"title":"NeuronBertForMultipleChoice","local":"optimum.neuron.NeuronBertForMultipleChoice","sections":[],"depth":2}],"depth":1}';function xn(k){return jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class An extends vn{constructor(s){super(),$n(this,s,xn,Xn,kn,{})}}export{An as component};
