import{s as sl,o as el,n as Oe}from"../chunks/scheduler.37c15a92.js";import{S as ll,i as tl,g as o,s as n,r as M,m as G,A as nl,h as p,f as l,c as a,j as Ue,u as w,x as i,n as Z,k as Is,y as Us,a as t,v as d,d as m,t as y,w as j}from"../chunks/index.2bf4358c.js";import{T as Ke}from"../chunks/Tip.363c041f.js";import{C as B}from"../chunks/CodeBlock.4e987730.js";import{H as g}from"../chunks/Heading.8ada512a.js";import{E as al}from"../chunks/getInferenceSnippets.54ddb825.js";function ol(hs){let c,u,h="ce <i>notebook</i>",T;return{c(){c=G("Vous pouvez suivre le code dans "),u=o("a"),u.innerHTML=h,T=G(" que vous pouvez exécuter avec Google Colab."),this.h()},l(r){c=Z(r,"Vous pouvez suivre le code dans "),u=p(r,"A",{href:!0,target:!0,"data-svelte-h":!0}),i(u)!=="svelte-ro4wwq"&&(u.innerHTML=h),T=Z(r," que vous pouvez exécuter avec Google Colab."),this.h()},h(){Is(u,"href","https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/llama-index/workflows.ipynb"),Is(u,"target","_blank")},m(r,b){t(r,c,b),t(r,u,b),t(r,T,b)},p:Oe,d(r){r&&(l(c),l(u),l(T))}}}function pl(hs){let c,u,h="workflows",T,r,b="la documentation LlamaIndex",f;return{c(){c=G("Il y a quelques nuances plus complexes aux "),u=o("i"),u.textContent=h,T=G(", que vous pouvez apprendre dans "),r=o("a"),r.textContent=b,f=G("."),this.h()},l(J){c=Z(J,"Il y a quelques nuances plus complexes aux "),u=p(J,"I",{"data-svelte-h":!0}),i(u)!=="svelte-19z039s"&&(u.textContent=h),T=Z(J,", que vous pouvez apprendre dans "),r=p(J,"A",{href:!0,"data-svelte-h":!0}),i(r)!=="svelte-15s9yx0"&&(r.textContent=b),f=Z(J,"."),this.h()},h(){Is(r,"href","https://docs.llamaindex.ai/en/stable/understanding/workflows/")},m(J,I){t(J,c,I),t(J,u,I),t(J,T,I),t(J,r,I),t(J,f,I)},p:Oe,d(J){J&&(l(c),l(u),l(T),l(r),l(f))}}}function il(hs){let c,u,h,T,r,b,f,J="Un <em>workflow</em> dans LlamaIndex fournit un moyen structuré d’organiser votre code en étapes séquentielles et gérables.",I,x,he=`Un tel <em>workflow</em> est créé en définissant des <code>Steps</code> qui sont déclenchés par des <code>Events</code>, et qui émettent eux-mêmes des <code>Events</code> pour déclencher d’autres étapes.
Jetons un coup d’œil à Alfred montrant un <em>workflow</em> LlamaIndex pour une tâche de RAG.`,Cs,V,be='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',Bs,_,ve="<strong>Les <em>workflows</em> offrent plusieurs avantages clés :</strong>",gs,E,Ie="<li>Organisation claire du code en étapes discrètes</li> <li>Architecture événementielle pour un flux de contrôle flexible</li> <li>Communication <em>type-safe</em> entre les étapes</li> <li>Gestion d’état intégrée</li> <li>Support pour des interactions d’agents simples et complexes</li>",Gs,W,ke="Comme vous l’avez peut-être deviné, <strong>les <em>workflows</em> trouvent un excellent équilibre entre l’autonomie des agents tout en maintenant le contrôle sur le <em>workflow</em> global.</strong>",Zs,$,Ce="Alors, apprenons à créer un <em>workflow</em> nous-mêmes !",xs,q,Vs,k,_s,A,Es,U,bs,Be="Installer le package <i>Workflow</i>",Je,Q,ge="section sur le LlamaHub",Te,vs,Ge="Workflow",fe,H,Ws,S,Ze=`Nous pouvons créer un <em>workflow</em> en une seule étape en définissant une classe qui hérite de <code>Workflow</code> et en décorant vos fonctions avec <code>@step</code>.
Nous devrons également ajouter <code>StartEvent</code> et <code>StopEvent</code>, qui sont des événements spéciaux utilisés pour indiquer le début et la fin du <em>workflow</em>.`,$s,X,qs,z,xe="Comme vous pouvez le voir, nous pouvons maintenant exécuter le <em>workflow</em> en appelant <code>w.run()</code>.",As,R,Qs,N,Ve=`Pour connecter plusieurs étapes, nous <strong>créons des événements personnalisés qui transportent des données entre les étapes.</strong>
Pour ce faire, nous devons ajouter un <code>Event</code> qui est passé entre les étapes et transfère la sortie de la première étape vers la deuxième étape.`,Hs,L,Ss,F,_e="L’indication de type est importante ici, car elle garantit que le <em>workflow</em> est exécuté correctement. Compliquons un peu les choses !",Xs,Y,zs,P,Ee="L’indication de type est la partie la plus puissante des <em>workflows</em> car elle nous permet de créer des branches, des boucles et des jointures pour faciliter des <em>workflows</em> plus complexes.",Rs,D,We=`Montrons un exemple de <strong>création d’une boucle</strong> en utilisant l’opérateur union <code>|</code>.
Dans l’exemple ci-dessous, nous voyons que le <code>LoopEvent</code> est pris en entrée pour l’étape et peut également être retourné en sortie.`,Ns,K,Ls,O,Fs,ss,$e="Nous pouvons également dessiner des <em>workflows</em>. Utilisons la fonction <code>draw_all_possible_flows</code> pour dessiner le <em>workflow</em>. Cela stocke le <em>workflow</em> dans un fichier HTML.",Ys,es,Ps,ls,qe='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',Ds,ts,Ae="Il y a une dernière astuce cool que nous couvrirons dans le cours, qui est la capacité d’ajouter de l’état au <em>workflow</em>.",Ks,ns,Os,as,Qe=`La gestion d’état est utile quand vous voulez garder une trace de l’état du <em>workflow</em>, pour que chaque étape ait accès au même état.
Nous pouvons faire cela en utilisant l’indication de type <code>Context</code> au-dessus d’un paramètre dans la fonction d’étape.`,se,os,ee,ps,He="Parfait ! Maintenant vous savez comment créer des <em>workflows</em> de base dans LlamaIndex !",le,C,te,is,Se="Cependant, il y a une autre façon de créer des <em>workflows</em>, qui repose sur la classe <code>AgentWorkflow</code>. Jetons un coup d’œil à comment nous pouvons utiliser cela pour créer un <em>workflow</em> multi-agents.",ne,rs,ae,us,Xe=`Au lieu de la création manuelle de <em>workflows</em>, nous pouvons utiliser la <strong>classe <code>AgentWorkflow</code> pour créer un <em>workflow</em> multi-agents</strong>.
L’<code>AgentWorkflow</code> utilise des <em>Workflow Agents</em> pour vous permettre de créer un système d’un ou plusieurs agents qui peuvent collaborer et se passer des tâches entre eux basées sur leurs capacités spécialisées.
Cela permet de construire des systèmes d’agents complexes où différents agents gèrent différents aspects d’une tâche.
Au lieu d’importer des classes de <code>llama_index.core.agent</code>, nous importerons les classes d’agents de <code>llama_index.core.agent.workflow</code>.
Un agent doit être désigné comme l’agent racine dans le constructeur <code>AgentWorkflow</code>.
Quand un message utilisateur arrive, il est d’abord routé vers l’agent racine.`,oe,cs,ze="Chaque agent peut ensuite :",pe,Ms,Re="<li>Gérer la demande directement en utilisant leurs outils</li> <li>Passer le relais à un autre agent mieux adapté à la tâche</li> <li>Retourner une réponse à l’utilisateur</li>",ie,ws,Ne="Voyons comment créer un <em>workflow</em> multi-agents.",re,ds,ue,ms,Le=`Les outils d’agents peuvent également modifier l’état du <em>workflow</em> que nous avons mentionné plus tôt. Avant de commencer le <em>workflow</em>, nous pouvons fournir un dictionnaire d’état initial qui sera disponible pour tous les agents.
L’état est stocké dans la clé d’état du contexte du <em>workflow</em>. Il sera injecté dans le <em>state_prompt</em> qui augmente chaque nouveau message utilisateur.`,ce,ys,Fe="Injectons un compteur pour compter les appels de fonctions en modifiant l’exemple précédent :",Me,js,we,Js,Ye="Félicitations ! Vous avez maintenant passer en revue les bases des agents dans LlamaIndex ! 🎉",de,Ts,Pe="Continuons avec un dernier quiz pour solidifier vos connaissances ! 🚀",me,fs,ye,ks,je;return r=new g({props:{title:"Créer des workflows agentiques dans LlamaIndex",local:"créer-des-workflows-agentiques-dans-llamaindex",headingTag:"h1"}}),q=new g({props:{title:"Créer des Workflows",local:"créer-des-workflows",headingTag:"h2"}}),k=new Ke({props:{$$slots:{default:[ol]},$$scope:{ctx:hs}}}),A=new g({props:{title:"Création de Workflow de base",local:"création-de-workflow-de-base",headingTag:"h3"}}),H=new B({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),X=new B({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),R=new g({props:{title:"Connecter plusieurs étapes",local:"connecter-plusieurs-étapes",headingTag:"h3"}}),L=new B({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyYWl0ZW1lbnQlMjBkZXMlMjBkb25uJUMzJUE5ZXMlMjBpbml0aWFsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBQcm9jZXNzaW5nRXZlbnQoaW50ZXJtZWRpYXRlX3Jlc3VsdCUzRCUyMlN0ZXAlMjAxJTIwY29tcGxldGUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVdGlsaXNlciUyMGxlJTIwciVDMyVBOXN1bHRhdCUyMGludGVybSVDMyVBOWRpYWlyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Traitement des données initiales</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Utiliser le résultat intermédiaire</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),Y=new g({props:{title:"Boucles et branches",local:"boucles-et-branches",headingTag:"h3"}}),K=new B({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVdGlsaXNlciUyMGxlJTIwciVDMyVBOXN1bHRhdCUyMGludGVybSVDMyVBOWRpYWlyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Utiliser le résultat intermédiaire</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),O=new g({props:{title:"Dessiner des Workflows",local:"dessiner-des-workflows",headingTag:"h3"}}),es=new B({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwdGVsJTIwcXVlJTIwZCVDMyVBOWZpbmklMjBkYW5zJTIwbGElMjBzZWN0aW9uJTIwcHIlQzMlQTljJUMzJUE5ZGVudGV0ZWwlMjBxdWUlMjBkJUMzJUE5ZmluaSUyMGRhbnMlMjBsYSUyMHNlY3Rpb24lMjBwciVDMyVBOWMlQzMlQTlkZW50ZSUwQWRyYXdfYWxsX3Bvc3NpYmxlX2Zsb3dzKHclMkMlMjAlMjJmbG93Lmh0bWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># tel que défini dans la section précédentetel que défini dans la section précédente</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),ns=new g({props:{title:"Gestion d’état",local:"gestion-détat",headingTag:"h3"}}),os=new B({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9ja2VyJTIwbGElMjByZXF1JUMzJUFBdGUlMjBkYW5zJTIwbGUlMjBjb250ZXh0ZSUwQSUyMCUyMCUyMCUyMGF3YWl0JTIwY3R4LnN0b3JlLnNldCglMjJxdWVyeSUyMiUyQyUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBmYWlyZSUyMHF1ZWxxdWUlMjBjaG9zZSUyMGF2ZWMlMjBsZSUyMGNvbnRleHRlJTIwZXQlMjBsJ2V2ZW50JTBBJTIwJTIwJTIwJTIwdmFsJTIwJTNEJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwciVDMyVBOWN1cCVDMyVBOXJlciUyMGxhJTIwcmVxdSVDMyVBQXRlJTIwZGFucyUyMGxlJTIwY29udGV4dGUlMEElMjAlMjAlMjAlMjBxdWVyeSUyMCUzRCUyMGF3YWl0JTIwY3R4LnN0b3JlLmdldCglMjJxdWVyeSUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBTdG9wRXZlbnQocmVzdWx0JTNEdmFsKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># stocker la requête dans le contexte</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># faire quelque chose avec le contexte et l&#x27;event</span>
    val = ...

    <span class="hljs-comment"># récupérer la requête dans le contexte</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=val)`,wrap:!1}}),C=new Ke({props:{$$slots:{default:[pl]},$$scope:{ctx:hs}}}),rs=new g({props:{title:"Automatiser les workflows avec des Multi-Agent Workflows",local:"automatiser-les-workflows-avec-des-multi-agent-workflows",headingTag:"h2"}}),ds=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Définir quelques outils</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Additionner deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplier deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># nous pouvons passer des fonctions directement sans FunctionTool -- les fn/docstring sont analysés pour le nom/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Créer le workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Exécuter le système</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),js=new B({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Définir quelques outils</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Additionner deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># mettre à jour notre comptage</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplier deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># mettre à jour notre comptage</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># exécuter le workflow avec le contexte</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># sortir et inspecter l&#x27;état</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),fs=new al({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/llama-index/workflows.mdx"}}),{c(){c=o("meta"),u=n(),h=o("p"),T=n(),M(r.$$.fragment),b=n(),f=o("p"),f.innerHTML=J,I=n(),x=o("p"),x.innerHTML=he,Cs=n(),V=o("p"),V.innerHTML=be,Bs=n(),_=o("p"),_.innerHTML=ve,gs=n(),E=o("ul"),E.innerHTML=Ie,Gs=n(),W=o("p"),W.innerHTML=ke,Zs=n(),$=o("p"),$.innerHTML=Ce,xs=n(),M(q.$$.fragment),Vs=n(),M(k.$$.fragment),_s=n(),M(A.$$.fragment),Es=n(),U=o("details"),bs=o("summary"),bs.innerHTML=Be,Je=G(`
Comme introduit dans la `),Q=o("a"),Q.textContent=ge,Te=G(", nous pouvons installer le package "),vs=o("code"),vs.textContent=Ge,fe=G(` avec la commande suivante :

	`),M(H.$$.fragment),Ws=n(),S=o("p"),S.innerHTML=Ze,$s=n(),M(X.$$.fragment),qs=n(),z=o("p"),z.innerHTML=xe,As=n(),M(R.$$.fragment),Qs=n(),N=o("p"),N.innerHTML=Ve,Hs=n(),M(L.$$.fragment),Ss=n(),F=o("p"),F.innerHTML=_e,Xs=n(),M(Y.$$.fragment),zs=n(),P=o("p"),P.innerHTML=Ee,Rs=n(),D=o("p"),D.innerHTML=We,Ns=n(),M(K.$$.fragment),Ls=n(),M(O.$$.fragment),Fs=n(),ss=o("p"),ss.innerHTML=$e,Ys=n(),M(es.$$.fragment),Ps=n(),ls=o("p"),ls.innerHTML=qe,Ds=n(),ts=o("p"),ts.innerHTML=Ae,Ks=n(),M(ns.$$.fragment),Os=n(),as=o("p"),as.innerHTML=Qe,se=n(),M(os.$$.fragment),ee=n(),ps=o("p"),ps.innerHTML=He,le=n(),M(C.$$.fragment),te=n(),is=o("p"),is.innerHTML=Se,ne=n(),M(rs.$$.fragment),ae=n(),us=o("p"),us.innerHTML=Xe,oe=n(),cs=o("p"),cs.textContent=ze,pe=n(),Ms=o("ul"),Ms.innerHTML=Re,ie=n(),ws=o("p"),ws.innerHTML=Ne,re=n(),M(ds.$$.fragment),ue=n(),ms=o("p"),ms.innerHTML=Le,ce=n(),ys=o("p"),ys.textContent=Fe,Me=n(),M(js.$$.fragment),we=n(),Js=o("p"),Js.textContent=Ye,de=n(),Ts=o("p"),Ts.textContent=Pe,me=n(),M(fs.$$.fragment),ye=n(),ks=o("p"),this.h()},l(s){const e=nl("svelte-u9bgzb",document.head);c=p(e,"META",{name:!0,content:!0}),e.forEach(l),u=a(s),h=p(s,"P",{}),Ue(h).forEach(l),T=a(s),w(r.$$.fragment,s),b=a(s),f=p(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-5cgz8d"&&(f.innerHTML=J),I=a(s),x=p(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-cbvicn"&&(x.innerHTML=he),Cs=a(s),V=p(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-whmuha"&&(V.innerHTML=be),Bs=a(s),_=p(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-klkse7"&&(_.innerHTML=ve),gs=a(s),E=p(s,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-1xmwb5a"&&(E.innerHTML=Ie),Gs=a(s),W=p(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1w1c494"&&(W.innerHTML=ke),Zs=a(s),$=p(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1b9bk90"&&($.innerHTML=Ce),xs=a(s),w(q.$$.fragment,s),Vs=a(s),w(k.$$.fragment,s),_s=a(s),w(A.$$.fragment,s),Es=a(s),U=p(s,"DETAILS",{});var v=Ue(U);bs=p(v,"SUMMARY",{"data-svelte-h":!0}),i(bs)!=="svelte-19cqk5h"&&(bs.innerHTML=Be),Je=Z(v,`
Comme introduit dans la `),Q=p(v,"A",{href:!0,"data-svelte-h":!0}),i(Q)!=="svelte-1pl43ly"&&(Q.textContent=ge),Te=Z(v,", nous pouvons installer le package "),vs=p(v,"CODE",{"data-svelte-h":!0}),i(vs)!=="svelte-sosek1"&&(vs.textContent=Ge),fe=Z(v,` avec la commande suivante :

	`),w(H.$$.fragment,v),v.forEach(l),Ws=a(s),S=p(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1sl0sod"&&(S.innerHTML=Ze),$s=a(s),w(X.$$.fragment,s),qs=a(s),z=p(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-931ze4"&&(z.innerHTML=xe),As=a(s),w(R.$$.fragment,s),Qs=a(s),N=p(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-12kywcz"&&(N.innerHTML=Ve),Hs=a(s),w(L.$$.fragment,s),Ss=a(s),F=p(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-qgro0z"&&(F.innerHTML=_e),Xs=a(s),w(Y.$$.fragment,s),zs=a(s),P=p(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-szxamf"&&(P.innerHTML=Ee),Rs=a(s),D=p(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1lfwgtw"&&(D.innerHTML=We),Ns=a(s),w(K.$$.fragment,s),Ls=a(s),w(O.$$.fragment,s),Fs=a(s),ss=p(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-1ovmdvg"&&(ss.innerHTML=$e),Ys=a(s),w(es.$$.fragment,s),Ps=a(s),ls=p(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1j5vf43"&&(ls.innerHTML=qe),Ds=a(s),ts=p(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1j9ku4g"&&(ts.innerHTML=Ae),Ks=a(s),w(ns.$$.fragment,s),Os=a(s),as=p(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1e7y3ck"&&(as.innerHTML=Qe),se=a(s),w(os.$$.fragment,s),ee=a(s),ps=p(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-dlbiw8"&&(ps.innerHTML=He),le=a(s),w(C.$$.fragment,s),te=a(s),is=p(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-qiy9vi"&&(is.innerHTML=Se),ne=a(s),w(rs.$$.fragment,s),ae=a(s),us=p(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-lpmh0e"&&(us.innerHTML=Xe),oe=a(s),cs=p(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-gkja97"&&(cs.textContent=ze),pe=a(s),Ms=p(s,"UL",{"data-svelte-h":!0}),i(Ms)!=="svelte-10bnzp4"&&(Ms.innerHTML=Re),ie=a(s),ws=p(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-j3rou5"&&(ws.innerHTML=Ne),re=a(s),w(ds.$$.fragment,s),ue=a(s),ms=p(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-181xssw"&&(ms.innerHTML=Le),ce=a(s),ys=p(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-bbhsjt"&&(ys.textContent=Fe),Me=a(s),w(js.$$.fragment,s),we=a(s),Js=p(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-101kzby"&&(Js.textContent=Ye),de=a(s),Ts=p(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-rfxun4"&&(Ts.textContent=Pe),me=a(s),w(fs.$$.fragment,s),ye=a(s),ks=p(s,"P",{}),Ue(ks).forEach(l),this.h()},h(){Is(c,"name","hf:doc:metadata"),Is(c,"content",rl),Is(Q,"href","./llama-hub")},m(s,e){Us(document.head,c),t(s,u,e),t(s,h,e),t(s,T,e),d(r,s,e),t(s,b,e),t(s,f,e),t(s,I,e),t(s,x,e),t(s,Cs,e),t(s,V,e),t(s,Bs,e),t(s,_,e),t(s,gs,e),t(s,E,e),t(s,Gs,e),t(s,W,e),t(s,Zs,e),t(s,$,e),t(s,xs,e),d(q,s,e),t(s,Vs,e),d(k,s,e),t(s,_s,e),d(A,s,e),t(s,Es,e),t(s,U,e),Us(U,bs),Us(U,Je),Us(U,Q),Us(U,Te),Us(U,vs),Us(U,fe),d(H,U,null),t(s,Ws,e),t(s,S,e),t(s,$s,e),d(X,s,e),t(s,qs,e),t(s,z,e),t(s,As,e),d(R,s,e),t(s,Qs,e),t(s,N,e),t(s,Hs,e),d(L,s,e),t(s,Ss,e),t(s,F,e),t(s,Xs,e),d(Y,s,e),t(s,zs,e),t(s,P,e),t(s,Rs,e),t(s,D,e),t(s,Ns,e),d(K,s,e),t(s,Ls,e),d(O,s,e),t(s,Fs,e),t(s,ss,e),t(s,Ys,e),d(es,s,e),t(s,Ps,e),t(s,ls,e),t(s,Ds,e),t(s,ts,e),t(s,Ks,e),d(ns,s,e),t(s,Os,e),t(s,as,e),t(s,se,e),d(os,s,e),t(s,ee,e),t(s,ps,e),t(s,le,e),d(C,s,e),t(s,te,e),t(s,is,e),t(s,ne,e),d(rs,s,e),t(s,ae,e),t(s,us,e),t(s,oe,e),t(s,cs,e),t(s,pe,e),t(s,Ms,e),t(s,ie,e),t(s,ws,e),t(s,re,e),d(ds,s,e),t(s,ue,e),t(s,ms,e),t(s,ce,e),t(s,ys,e),t(s,Me,e),d(js,s,e),t(s,we,e),t(s,Js,e),t(s,de,e),t(s,Ts,e),t(s,me,e),d(fs,s,e),t(s,ye,e),t(s,ks,e),je=!0},p(s,[e]){const v={};e&2&&(v.$$scope={dirty:e,ctx:s}),k.$set(v);const De={};e&2&&(De.$$scope={dirty:e,ctx:s}),C.$set(De)},i(s){je||(m(r.$$.fragment,s),m(q.$$.fragment,s),m(k.$$.fragment,s),m(A.$$.fragment,s),m(H.$$.fragment,s),m(X.$$.fragment,s),m(R.$$.fragment,s),m(L.$$.fragment,s),m(Y.$$.fragment,s),m(K.$$.fragment,s),m(O.$$.fragment,s),m(es.$$.fragment,s),m(ns.$$.fragment,s),m(os.$$.fragment,s),m(C.$$.fragment,s),m(rs.$$.fragment,s),m(ds.$$.fragment,s),m(js.$$.fragment,s),m(fs.$$.fragment,s),je=!0)},o(s){y(r.$$.fragment,s),y(q.$$.fragment,s),y(k.$$.fragment,s),y(A.$$.fragment,s),y(H.$$.fragment,s),y(X.$$.fragment,s),y(R.$$.fragment,s),y(L.$$.fragment,s),y(Y.$$.fragment,s),y(K.$$.fragment,s),y(O.$$.fragment,s),y(es.$$.fragment,s),y(ns.$$.fragment,s),y(os.$$.fragment,s),y(C.$$.fragment,s),y(rs.$$.fragment,s),y(ds.$$.fragment,s),y(js.$$.fragment,s),y(fs.$$.fragment,s),je=!1},d(s){s&&(l(u),l(h),l(T),l(b),l(f),l(I),l(x),l(Cs),l(V),l(Bs),l(_),l(gs),l(E),l(Gs),l(W),l(Zs),l($),l(xs),l(Vs),l(_s),l(Es),l(U),l(Ws),l(S),l($s),l(qs),l(z),l(As),l(Qs),l(N),l(Hs),l(Ss),l(F),l(Xs),l(zs),l(P),l(Rs),l(D),l(Ns),l(Ls),l(Fs),l(ss),l(Ys),l(Ps),l(ls),l(Ds),l(ts),l(Ks),l(Os),l(as),l(se),l(ee),l(ps),l(le),l(te),l(is),l(ne),l(ae),l(us),l(oe),l(cs),l(pe),l(Ms),l(ie),l(ws),l(re),l(ue),l(ms),l(ce),l(ys),l(Me),l(we),l(Js),l(de),l(Ts),l(me),l(ye),l(ks)),l(c),j(r,s),j(q,s),j(k,s),j(A,s),j(H),j(X,s),j(R,s),j(L,s),j(Y,s),j(K,s),j(O,s),j(es,s),j(ns,s),j(os,s),j(C,s),j(rs,s),j(ds,s),j(js,s),j(fs,s)}}}const rl='{"title":"Créer des workflows agentiques dans LlamaIndex","local":"créer-des-workflows-agentiques-dans-llamaindex","sections":[{"title":"Créer des Workflows","local":"créer-des-workflows","sections":[{"title":"Création de Workflow de base","local":"création-de-workflow-de-base","sections":[],"depth":3},{"title":"Connecter plusieurs étapes","local":"connecter-plusieurs-étapes","sections":[],"depth":3},{"title":"Boucles et branches","local":"boucles-et-branches","sections":[],"depth":3},{"title":"Dessiner des Workflows","local":"dessiner-des-workflows","sections":[],"depth":3},{"title":"Gestion d’état","local":"gestion-détat","sections":[],"depth":3}],"depth":2},{"title":"Automatiser les workflows avec des Multi-Agent Workflows","local":"automatiser-les-workflows-avec-des-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function ul(hs){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends ll{constructor(c){super(),tl(this,c,ul,il,sl,{})}}export{jl as component};
