import{s as dM,f as ue,n as EM,o as gM}from"../chunks/scheduler.f6b352c8.js";import{S as hM,i as _M,g as J,s,r as i,A as RM,h as n,f as e,c as U,j as me,u as y,x as T,k as w,y as Ve,a as M,v as a,d as C,t as p,w as j}from"../chunks/index.7f38e934.js";import{C as u}from"../chunks/CodeBlock.3ee8293b.js";import{H as Nl,E as vM}from"../chunks/getInferenceSnippets.b4820bde.js";function FM(Ae){let I,Gl,$l,Hl,m,ql,V,Qe,Wl,A,re="AI 에이전트(AI Agents)의 핵심 요소 중 하나는 <strong>행동(Actions)</strong>을 수행할 수 있는 능력입니다. 이러한 행동은 <strong>도구(Tools)</strong>를 사용하여 이루어집니다.",Xl,Q,ce="이번 섹션에서는 도구란 무엇이고, 어떻게 효과적으로 설계하는지, 시스템 메시지를 통해 에이전트에 통합하는 방법을 학습합니다.",Yl,r,fe=`By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!
에이전트에게 적절한 도구를 제공하고, 해당 도구의 동작 방식을 명확히 설명하면, AI의 수행 능력을 극적으로 향상시킬 수 있습니다. 함께 살펴보겠습니다!`,zl,c,Zl,f,Be="<strong>도구</strong>란 LLM에 제공하는 함수라고 할 수 있습니다. 이 함수는 <strong>명확한 목적을</strong> 수행합니다.",Pl,B,be="다음은 AI 에이전트에서 일반적으로 사용되는 도구의 예시입니다:",Kl,b,de="<thead><tr><th>도구</th> <th>설명</th></tr></thead> <tbody><tr><td>웹 검색 (Web Search)</td> <td>인터넷에서 최신 정보를 검색하여 가져옵니다.</td></tr> <tr><td>이미지 생성(Image generation)</td> <td>주어진 설명을 기반으로 이미지를 생성합니다.</td></tr> <tr><td>정보 검색 (Retrieval)</td> <td>외부 데이터 소스에서 정보를 검색하여 제공합니다.</td></tr> <tr><td>API 인터페이스</td> <td>외부 API (GitHub, YouTube, Spotify 등)와 상호작용합니다.</td></tr></tbody>",lt,d,Ee="이러한 예시는 일부일 뿐이며, 사실상 어떠한 용도를 위한 도구든지 생성할 수 있습니다!",tt,E,ge="좋은 도구는 <strong>LLM의 능력을 보완하는</strong> 역할을 수행합니다.",et,g,he="예를 들어, 계산이 필요한 경우, <strong>계산기 도구</strong>를 제공하면 모델 자체의 계산 능력보다 훨씬 정확한 결과를 얻을 수 있습니다.",Mt,h,_e="또한, <strong>LLM은 학습 데이터에 기반해 프롬프트의 다음 단어를 예측</strong>하므로, 사실상 훈련 이전 정보만 알고 있는 상태입니다. 따라서, 에이전트가 최신 데이터를 필요로하는 경우 적절한 도구를 제공해야 합니다.",st,_,Re="예를 들어, 검색 도구 없이 LLM에 직접적으로 오늘의 날씨에 대해 묻는다면, LLM은 임의로 날씨 정보를 생성(환각, hallucination)할 가능성이 높습니다.",Ut,R,ve,Jt,v,Fe="<li><p>도구는 다음을 포함해야 합니다:</p> <ul><li>함수가 <strong>수행하는 기능에 대한 설명</strong></li> <li><em>호출 가능한 함수(Callable, 실행 가능한 동작)</em></li> <li><em>인자(Arguments)</em> 명시</li> <li>(선택 사항) 출력 데이터(Outputs) 명시</li></ul></li>",nt,F,Tt,S,Se=`LLM은 본질적으로 텍스트 입력을 받아 텍스트 출력을 생성할 수 있을 뿐, 스스로 도구를 호출할 수는 없습니다.<br/>
따라서 <em>에이전트(Agent)에 도구를 제공한다는 것</em>은 LLM에게 <strong>도구의 존재를 가르치고, 필요할 때 해당 도구를 호출하는 텍스트를 생성</strong>하도록 유도하는 것을 의미합니다.
예를 들어, 특정 위치의 날씨를 조회할 수 있는 도구를 제공한 후, LLM에게 파리의 날씨를 묻는다면, LLM은 해당 질문이 “날씨” 도구를 사용할 적절한 상황임을 인식합니다. 그러면 LLM은 해당 도구를 호출하도록 코드 형태의 <em>텍스트</em>를 생성합니다.`,it,k,ke=`<strong>에이전트(Agent)</strong>는 LLM의 출력을 파싱해 도구 호출이 필요한지를 파악하고, LLM을 대신하여 해당 도구를 실행하는 역할을 담당합니다.
이후 도구에서 반환된 결과를 다시 LLM에 전달하면, LLM은 이를 바탕으로 사용자에게 제공할 최종 응답을 생성합니다.`,yt,x,xe=`도구 호출의 출력은 대화 중 하나의 메시지로 간주됩니다. 일반적으로 이러한 도구 호출 과정은 사용자에게 직접 노출되지 않습니다:
에이전트는 대화를 조회한 후, 도구를 실행하고, 결과(출력)를 얻고, 이 결과를 새로운 대화 메시지로 추가한 뒤, 업데이트된 대화를 다시 LLM에게 전달합니다.
사용자의 관점에서는 마치 LLM이 직접 도구를 사용한 것처럼 보이지만, 실제로는 <strong>에이전트(Agent)</strong>가 이를 수행한 것입니다.`,at,L,Le="이 과정에 대한 자세한 내용은 이후 세션에서 더 깊이 다룰 예정입니다.",Ct,O,pt,N,Oe="전체 과정은 복잡할 수 있지만, 기본적으로 <strong>시스템 프롬프트(system prompt)</strong>를 사용하여 LLM에게 사용 가능한 도구들의 설명을 텍스트 형태로 제공하면 됩니다:",jt,$,Ne,wt,D,$e="도구를 효과적으로 활용하려면 이 두 가지를 명확하게 LLM에게 전달해야 합니다:",It,G,De="<li><strong>이 도구가 수행하는 기능</strong></li> <li><strong>도구에게 제공해야하는 입력값의 형식</strong></li>",ut,H,Ge=`이러한 이유로, 도구에 대한 설명은 프로그래밍 언어나 JSON과 같이 표현력이 뛰어나고 구조적인 형식으로 제공하는 경우가 많습니다.
<em>반드시</em> 이런 형식을 사용할 필요는 없지만, 표현력이 뛰어나고 일관된 방식이면 어떤 형식이라도 사용할 수 있습니다.`,ot,q,He="이론적으로 들릴 수도 있으니, 구체적인 예시를 통해 이해해 보겠습니다.",mt,W,qe="두 개의 정수를 곱하는 간단한 <strong>계산기 도구</strong>를 구현해 봅시다. 이를 Python 코드로 작성하면 다음과 같습니다.",Vt,X,At,Y,We="이 도구의 이름은 <code>calculator</code>(계산기)이고, <strong>두 개의 정수를 곱하는</strong> 기능을 수행합니다. 그리고 다음과 같은 입력값을 필요로 합니다 :",Qt,z,Xe="<li><strong><code>a</code></strong> (<em>int</em>): 정수</li> <li><strong><code>b</code></strong> (<em>int</em>): 정수</li>",rt,Z,Ye="이 도구의 출력값은 정수이며, 이렇게 표현할 수 있습니다.",ct,P,ze="<li>(<em>int</em>):  <code>a</code> 와 <code>b</code>의 곱</li>",ft,K,Ze="위의 모든 세부 정보는 중요합니다. 따라서, LLM이 이 도구를 이해할 수 있도록 텍스트 형식으로 정리해 봅시다!",Bt,ll,bt,tl,Pe="<p><strong>참고:</strong> 이 텍스트 설명은 <em>LLM에게 도구에 대한 정보를 전달하기 위한 것입니다</em>.</p>",dt,el,Ke="이 문자열을 LLM의 입력으로 제공하면, 모델은 이를 도구로 인식하고, 어떤 입력값을 전달해야 하며 어떤 출력을 얻을 지 알수 있습니다.",Et,Ml,lM="추가적인 도구를 제공하려면, 항상 동일한 형식을 유지해야 합니다. 이 과정은 꽤나 까다롭고, 실수로 중요한 세부 정보를 빠뜨릴 수도 있습니다.",gt,sl,tM="더 나은 방법이 있을까요?",ht,Ul,_t,Jl,eM="우리가 만든 도구는 Python으로 작성되었으며, 이미 필요한 정보를 모두 포함하고 있습니다:",Rt,nl,MM="<li>수행 작업을 설명해주는 이름: <code>calculator</code>(계산기)</li> <li>함수의 docstring 주석을 통해 제공되는 상세 설명: <code>두 정수를 곱하세요</code></li> <li>입력값 및 변수 타입: 함수는 두 개의 <code>int</code>(정수)를 요함</li> <li>출력값의 타입</li>",vt,Tl,sM="프로그래밍 언어를 사용하는 데에는 이유가 있습니다. 표현력이 높고, 간결하며, 정확하기 때문입니다.",Ft,il,UM="Python 소스 코드를 LLM에게 도구의 명세서(specification) 로 제공할 수도 있지만, 도구가 실제로 어떻게 구현되었는지는 중요하지 않습니다. 중요한 것은 이름, 수행하는 작업, 필요한 입력값, 그리고 제공하는 출력값입니다.",St,yl,JM=`우리는 Python의 내부 정보(Introspection) 기능을 활용하여 소스 코드에서 필요한 정보를 자동으로 추출하고, 도구 설명을 생성 할 것입니다. 이를 위해 도구 구현시 타입 힌트(type hints), docstring, 그리고 직관적인 함수 이름을 사용합니다.
우리는 소스 코드에서 필요한 정보를 추출하는 코드를 작성하고, 이후에는 Python의 데코레이터(decorator) 를 사용하여  <code>calculator</code> 함수가 도구임을 표시하기만 하면 됩니다 :`,kt,al,xt,Cl,nM="함수 정의 앞에 <code>@tool</code> 데코레이터를 추가해주었습니다.",Lt,pl,TM="다음으로 볼 부분은, <code>to_string()</code> 함수를 사용해 소스 코드에서 다음과 같은 텍스트를 자동으로 가져옵니다 :",Ot,jl,Nt,wl,iM="보면 아시겠지만, 이전에 저희가 수동으로 작성한 것과 동일합니다!",$t,Il,Dt,ul,yM="우리는 여러 도구를 필요할 때마다 재사용할 수 있도록 범용적인 <code>Tool</code> 클래스를 생성할 것입니다.",Gt,ol,aM="<p><strong>참고:</strong> 이 예제는 가상이지만 실제 라이브러리에서 사용되는 방식과 유사합니다.</p>",Ht,ml,qt,Vl,CM="위 코드가 복잡해 보일 수 있지만, 하나씩 살펴보도록 하겠습니다. 이 <strong><code>Tool</code></strong>클래스는 다음을 포함합니다:",Wt,Al,pM="<li><strong><code>name</code></strong> (<em>str</em>): 도구의 이름</li> <li><strong><code>description</code></strong> (<em>str</em>): 도구의 기능 설명</li> <li><strong><code>function</code></strong> (<em>callable</em>): 도구가 실행하는 함수</li> <li><strong><code>arguments</code></strong> (<em>list</em>): 함수가 필요로 하는 입력값들</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): 함수가 반환하는 출력값</li> <li><strong><code>__call__()</code></strong>: 도구 객체가 호출될 때 함수 실행</li> <li><strong><code>to_string()</code></strong>: 구의 속성을 LLM이 이해할 수 있도록 문자열로 변환</li>",Xt,Ql,jM="이제 위 클래스를 활용하여 도구를 만들 수 있습니다:",Yt,rl,zt,cl,wM="그러나 Python의 <code>inspect</code> 모듈을 사용하면 이 정보를 자동으로 추출할 수 있습니다.바로 이 역할을 하는 것이 @tool 데코레이터입니다.",Zt,fl,IM="<p>데코레이터 구현 부분을 확인하고 싶다면 클릭하세요.</p>",Pt,o,Ol,uM="데코레이터 코드 보기",oe,Bl,Kt,bl,oM="이제 @tool 데코레이터를 활용하면, 다음과 같이 도구를 간단하게 정의할 수 있습니다.",le,dl,te,El,mM="그리고 <code>Tool</code> 클래스의 <code>to_string</code> 메서드를 사용하면 LLM이 사용할 수 있는 적절한 도구 설명을 자동으로 생성해줍니다:",ee,gl,Me,hl,VM="이 도구 설명은 시스템 프롬프트에 삽입됩니다. 이 섹션의 처음 예제를 다시 살펴보면, <code>tools_description</code>을 대체한 후 시스템 프롬프트는 다음과 같이 보이게 됩니다:",se,_l,AM,Ue,Rl,QM='<a href="actions">Actions</a> 섹션에서 우리가 방금 만든 도구를 에이전트가 어떻게 <strong>호출</strong>하는지에 대해 살펴볼 것 입니다.',Je,ne,Te,vl,rM="도구는 AI에이전트의 기능을 확장하는데 핵심적인 역할을 합니다.",ie,Fl,cM="요약:",ye,Sl,fM="<li><p><em>도구란?</em>: LLM이 계산, 외부 데이터 조회 등 추가적인 기능을 할 수 있도록 하는 함수</p></li> <li><p><em>도구 정의하는 법</em>: 명확한 텍스트 설명, 입력값, 출력값, 호출 가능한 함수 제공</p></li> <li><p><em>도구가 중요한 이유</em>: 에이전트가 사전에 학습된 정적 모델의 한계를 뛰어넘어, 실시간 작업 및 특수 기능을 수행할 수 있도록 함</p></li>",ae,kl,BM=`이제 <a href="agent-steps-and-structure">에이전트의 작동 방식(Workflow)</a>에 대해 알아볼 차례입니다!이 과정에서는 에이전트가 관찰하고, 사고하며, 행동하는 방법을 살펴보게 됩니다.
이 과정을 마치게 되면, 이제까지 배운 모든 내용을 통합하여 나만의 AI 에이전트를 만들 준비가 될 것입니다!`,Ce,xl,bM="하지만 그 전에, 짧은 퀴즈를 풀어볼까요? 😊",pe,Ll,je,Dl,we;return m=new Nl({props:{title:"도구(Tool)란?",local:"what-are-tools",headingTag:"h1"}}),c=new Nl({props:{title:"AI 도구란?",local:"what-are-ai-tools",headingTag:"h2"}}),F=new Nl({props:{title:"도구는 어떻게 작동하는가?",local:"how-do-tools-work",headingTag:"h2"}}),O=new Nl({props:{title:"LLM에게 도구를 제공하는 방법",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),X=new u({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJUVCJTkxJTkwJTIwJUVDJUEwJTk1JUVDJTg4JTk4JUVCJUE1JUJDJTIwJUVBJUIzJUIxJUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0JTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBi",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;두 정수를 곱하세요&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),ll=new u({props:{code:"VG9vbCUyME5hbWUoJUVCJThGJTg0JUVBJUI1JUFDJTIwJUVCJUFBJTg1KSUzQSUyMGNhbGN1bGF0b3IlMkMlMjBEZXNjcmlwdGlvbiglRUMlODQlQTQlRUIlQUElODUpJTNBJTIwJUVCJTkxJTkwJTIwJUVDJUEwJTk1JUVDJTg4JTk4JUVCJUE1JUJDJTIwJUVBJUIzJUIxJUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0LiUyQyUyMEFyZ3VtZW50cyglRUMlOUQlQjglRUMlOUUlOTApJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBPdXRwdXRzKCVFQyVCNiU5QyVFQiVBMCVBNSklM0ElMjBpbnQ=",highlighted:"Tool Name(도구 명): calculator, Description(설명): 두 정수를 곱하세요., Arguments(인자): a: int, b: int, Outputs(출력): int",wrap:!1}}),Ul=new Nl({props:{title:"자동 포맷팅된 도구 섹션",local:"auto-formatting-tool-sections",headingTag:"h3"}}),al=new u({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiVFQiU5MSU5MCUyMCVFQyVBMCU5NSVFQyU4OCU5OCVFQiVBNSVCQyUyMCVFQSVCMyVCMSVFRCU5NSU5OCVFQyU4NCVCOCVFQyU5QSU5NCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;두 정수를 곱하세요&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),jl=new u({props:{code:"VG9vbCUyME5hbWUoJUVCJThGJTg0JUVBJUI1JUFDJUVCJUFBJTg1KSUzQSUyMGNhbGN1bGF0b3IlMkMlMjBEZXNjcmlwdGlvbiglRUMlODQlQTQlRUIlQUElODUpJTNBJTIwTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4oJUVCJTkxJTkwJTIwJUVDJUEwJTk1JUVDJTg4JTk4JUVCJUE1JUJDJTIwJUVBJUIzJUIxJUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0KSUyQyUyMEFyZ3VtZW50cyglRUMlOUQlQjglRUMlOUUlOTApJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBPdXRwdXRzKCVFQyVCNiU5QyVFQiVBMCVBNSklM0ElMjBpbnQ=",highlighted:"Tool Name(도구명): calculator, Description(설명): Multiply two integers.(두 정수를 곱하세요), Arguments(인자): a: int, b: int, Outputs(출력): int",wrap:!1}}),Il=new Nl({props:{title:"범용적인 도구(Generic Tool) 구현",local:"generic-tool-implementation",headingTag:"h3"}}),ml=new u({props:{code:"Y2xhc3MlMjBUb29sJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJUVDJTlFJUFDJUVDJTgyJUFDJUVDJTlBJUE5JTIwJUVBJUIwJTgwJUVCJThBJUE1JUVEJTk1JTlDJTIwJUVDJUJEJTk0JUVCJTkzJTlDJTIwJUVDJUExJUIwJUVBJUIwJTgxKCVFQiU4RiU4NCVFQSVCNSVBQyklRUMlOUQlODQlMjAlRUIlODIlOTglRUQlODMlODAlRUIlODIlQjQlRUIlOEElOTQlMjAlRUQlODElQjQlRUIlOUUlOTglRUMlOEElQTQlRUMlOUUlODUlRUIlOEIlODglRUIlOEIlQTQuJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwQXR0cmlidXRlcyglRUMlODYlOEQlRUMlODQlQjEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUyMChzdHIpJTNBJTIwJUVCJThGJTg0JUVBJUI1JUFDJUVDJTlEJTk4JTIwJUVDJTlEJUI0JUVCJUE2JTg0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAoc3RyKSUzQSUyMCVFQiU4RiU4NCVFQSVCNSVBQyVFQSVCMCU4MCUyMCVFQyU4OCU5OCVFRCU5NiU4OSVFRCU5NSU5OCVFQiU4QSU5NCUyMCVFQyU5RSU5MSVFQyU5NyU4NSVFQyU5NyU5MCUyMCVFQiU4QyU4MCVFRCU5NSU5QyUyMCVFQyU4NCVBNCVFQiVBQSU4NSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZ1bmMlMjAoY2FsbGFibGUpJTNBJTIwJUVCJThGJTg0JUVBJUI1JUFDJUVBJUIwJTgwJTIwJUVEJTk4JUI4JUVDJUI2JTlDJUVEJTk1JTk4JUVCJThBJTk0JTIwJUVEJTk1JUE4JUVDJTg4JTk4JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJndW1lbnRzJTIwKGxpc3QpJTNBJTIwJUVEJTk1JUE4JUVDJTg4JTk4JUVDJTlEJTk4JTIwJUVDJTlFJTg1JUVCJUEwJUE1JUVBJUIwJTkyJTIwJUVCJUE2JUFDJUVDJThBJUE0JUVEJThBJUI4JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMChzdHIlMjAlRUIlOTglOTAlRUIlOEElOTQlMjBsaXN0KSUzQSUyMCVFRCU5NSVBOCVFQyU4OCU5OCVFQyU5RCU5OCUyMCVFQyVCNiU5QyVFQiVBMCVBNSVFQSVCMCU5MiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwc3RyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ElMjBzdHIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdW5jJTNBJTIwY2FsbGFibGUlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmd1bWVudHMlM0ElMjBsaXN0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm5hbWUlMjAlM0QlMjBuYW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXNjcmlwdGlvbiUyMCUzRCUyMGRlc2NyaXB0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5mdW5jJTIwJTNEJTIwZnVuYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYXJndW1lbnRzJTIwJTNEJTIwYXJndW1lbnRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5vdXRwdXRzJTIwJTNEJTIwb3V0cHV0cyUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRvX3N0cmluZyhzZWxmKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRUIlOEYlODQlRUElQjUlQUMlRUMlOUQlOTglMjAlRUMlODYlOEQlRUMlODQlQjElRUMlOUQlODQlMjAlRUIlQUMlQjglRUMlOUUlOTAlRUMlOTclQjQlRUIlQTElOUMlMjAlRUIlQjMlODAlRUQlOTklOTglRUQlOTUlOTglRUMlOTclQUMlMjAlRUIlQjAlOTglRUQlOTklOTglRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUyQyUyMGRlc2NyaXB0aW9uJTJDJTIwYXJndW1lbnRzJTJDJTIwb3V0cHV0cyVFQyU5RCU4NCUyMCVFRCU4RiVBQyVFRCU5NSVBOCVFRCU5NSVBOSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdzX3N0ciUyMCUzRCUyMCUyMiUyQyUyMCUyMi5qb2luKCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlN0JhcmdfbmFtZSU3RCUzQSUyMCU3QmFyZ190eXBlJTdEJTIyJTIwZm9yJTIwYXJnX25hbWUlMkMlMjBhcmdfdHlwZSUyMGluJTIwc2VsZi5hcmd1bWVudHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJUb29sJTIwTmFtZSUzQSUyMCU3QnNlbGYubmFtZSU3RCUyQyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlMjBEZXNjcmlwdGlvbiUzQSUyMCU3QnNlbGYuZGVzY3JpcHRpb24lN0QlMkMlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTIwQXJndW1lbnRzJTNBJTIwJTdCYXJnc19zdHIlN0QlMkMlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTIwT3V0cHV0cyUzQSUyMCU3QnNlbGYub3V0cHV0cyU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwKmFyZ3MlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRUMlQTAlODAlRUMlOUUlQTUlRUIlOTAlOUMlMjAlRUQlOTUlQTglRUMlODglOTgoY2FsbGFibGUpJUVCJUE1JUJDJTIwJUVDJUEzJUJDJUVDJTk2JUI0JUVDJUE3JTg0JTIwJUVDJTlFJTg1JUVCJUEwJUE1JUVBJUIwJTkyJUVDJTlDJUJDJUVCJUExJTlDJTIwJUVDJThCJUE0JUVEJTk2JTg5JUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuZnVuYygqYXJncyUyQyUyMCoqa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    재사용 가능한 코드 조각(도구)을 나타내는 클래스입니다.
    
    Attributes(속성):
        name (str): 도구의 이름
        description (str): 도구가 수행하는 작업에 대한 설명
        func (callable): 도구가 호출하는 함수
        arguments (list): 함수의 입력값 리스트
        outputs (str 또는 list): 함수의 출력값
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        도구의 속성을 문자열로 변환하여 반환합니다.
        name, description, arguments, outputs을 포함합니다.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        저장된 함수(callable)를 주어진 입력값으로 실행합니다.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),rl=new u({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwJUVCJThGJTg0JUVBJUI1JUFDJTIwJUVDJTlEJUI0JUVCJUE2JTg0JTBBJTIwJTIwJTIwJTIwJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRUMlODQlQTQlRUIlQUElODUlMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwJUVDJThCJUE0JUVEJTk2JTg5JUVEJTk1JUEwJTIwJUVEJTk1JUE4JUVDJTg4JTk4JTBBJTIwJTIwJTIwJTIwJTVCKCUyMmElMjIlMkMlMjAlMjJpbnQlMjIpJTJDJTIwKCUyMmIlMjIlMkMlMjAlMjJpbnQlMjIpJTVEJTJDJTIwJTIwJTIwJTIzJTIwJUVDJTlFJTg1JUVCJUEwJUE1JUVBJUIwJTkyJTIwKCVFQyU5RCVCNCVFQiVBNiU4NCVFQSVCMyVCQyUyMCVFRCU4MyU4MCVFQyU5RSU4NSklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRUMlQjYlOUMlRUIlQTAlQTUlRUElQjAlOTIlMjAlRUQlODMlODAlRUMlOUUlODUlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># 도구 이름</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># 설명</span>
    calculator,                     <span class="hljs-comment"># 실행할 함수</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># 입력값 (이름과 타입)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># 출력값 타입</span>
)`,wrap:!1}}),Bl=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    주어진 함수를 기반으로 Tool 인스턴스를 생성하는 데코레이터입니다.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># 함수의 서명(signature) 가져오기</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># 입력 인자 추출 (param_name, param_annotation)</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># 리턴값 타입 결정</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># 함수의 docstring을 설명으로 사용</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># 함수명을 도구 이름으로 사용</span>
    name = func.__name__
    
    <span class="hljs-comment"># Tool 인스턴스를 리턴</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),dl=new u({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiVFQiU5MSU5MCUyMCVFQyVBMCU5NSVFQyU4OCU5OCVFQiVBNSVCQyUyMCVFQSVCMyVCMSVFRCU5NSU5OCVFQyU4NCVCOCVFQyU5QSU5NCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;두 정수를 곱하세요&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),gl=new u({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),Ll=new vM({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/ko/unit1/tools.mdx"}}),{c(){I=J("meta"),Gl=s(),$l=J("p"),Hl=s(),i(m.$$.fragment),ql=s(),V=J("img"),Wl=s(),A=J("p"),A.innerHTML=re,Xl=s(),Q=J("p"),Q.textContent=ce,Yl=s(),r=J("p"),r.textContent=fe,zl=s(),i(c.$$.fragment),Zl=s(),f=J("p"),f.innerHTML=Be,Pl=s(),B=J("p"),B.textContent=be,Kl=s(),b=J("table"),b.innerHTML=de,lt=s(),d=J("p"),d.textContent=Ee,tt=s(),E=J("p"),E.innerHTML=ge,et=s(),g=J("p"),g.innerHTML=he,Mt=s(),h=J("p"),h.innerHTML=_e,st=s(),_=J("p"),_.textContent=Re,Ut=s(),R=J("img"),Jt=s(),v=J("ul"),v.innerHTML=Fe,nt=s(),i(F.$$.fragment),Tt=s(),S=J("p"),S.innerHTML=Se,it=s(),k=J("p"),k.innerHTML=ke,yt=s(),x=J("p"),x.innerHTML=xe,at=s(),L=J("p"),L.textContent=Le,Ct=s(),i(O.$$.fragment),pt=s(),N=J("p"),N.innerHTML=Oe,jt=s(),$=J("img"),wt=s(),D=J("p"),D.textContent=$e,It=s(),G=J("ol"),G.innerHTML=De,ut=s(),H=J("p"),H.innerHTML=Ge,ot=s(),q=J("p"),q.textContent=He,mt=s(),W=J("p"),W.innerHTML=qe,Vt=s(),i(X.$$.fragment),At=s(),Y=J("p"),Y.innerHTML=We,Qt=s(),z=J("ul"),z.innerHTML=Xe,rt=s(),Z=J("p"),Z.textContent=Ye,ct=s(),P=J("ul"),P.innerHTML=ze,ft=s(),K=J("p"),K.textContent=Ze,Bt=s(),i(ll.$$.fragment),bt=s(),tl=J("blockquote"),tl.innerHTML=Pe,dt=s(),el=J("p"),el.textContent=Ke,Et=s(),Ml=J("p"),Ml.textContent=lM,gt=s(),sl=J("p"),sl.textContent=tM,ht=s(),i(Ul.$$.fragment),_t=s(),Jl=J("p"),Jl.textContent=eM,Rt=s(),nl=J("ul"),nl.innerHTML=MM,vt=s(),Tl=J("p"),Tl.textContent=sM,Ft=s(),il=J("p"),il.textContent=UM,St=s(),yl=J("p"),yl.innerHTML=JM,kt=s(),i(al.$$.fragment),xt=s(),Cl=J("p"),Cl.innerHTML=nM,Lt=s(),pl=J("p"),pl.innerHTML=TM,Ot=s(),i(jl.$$.fragment),Nt=s(),wl=J("p"),wl.textContent=iM,$t=s(),i(Il.$$.fragment),Dt=s(),ul=J("p"),ul.innerHTML=yM,Gt=s(),ol=J("blockquote"),ol.innerHTML=aM,Ht=s(),i(ml.$$.fragment),qt=s(),Vl=J("p"),Vl.innerHTML=CM,Wt=s(),Al=J("ul"),Al.innerHTML=pM,Xt=s(),Ql=J("p"),Ql.textContent=jM,Yt=s(),i(rl.$$.fragment),zt=s(),cl=J("p"),cl.innerHTML=wM,Zt=s(),fl=J("blockquote"),fl.innerHTML=IM,Pt=s(),o=J("details"),Ol=J("summary"),Ol.textContent=uM,oe=s(),i(Bl.$$.fragment),Kt=s(),bl=J("p"),bl.textContent=oM,le=s(),i(dl.$$.fragment),te=s(),El=J("p"),El.innerHTML=mM,ee=s(),i(gl.$$.fragment),Me=s(),hl=J("p"),hl.innerHTML=VM,se=s(),_l=J("img"),Ue=s(),Rl=J("p"),Rl.innerHTML=QM,Je=s(),ne=J("hr"),Te=s(),vl=J("p"),vl.textContent=rM,ie=s(),Fl=J("p"),Fl.textContent=cM,ye=s(),Sl=J("ul"),Sl.innerHTML=fM,ae=s(),kl=J("p"),kl.innerHTML=BM,Ce=s(),xl=J("p"),xl.textContent=bM,pe=s(),i(Ll.$$.fragment),je=s(),Dl=J("p"),this.h()},l(l){const t=RM("svelte-u9bgzb",document.head);I=n(t,"META",{name:!0,content:!0}),t.forEach(e),Gl=U(l),$l=n(l,"P",{}),me($l).forEach(e),Hl=U(l),y(m.$$.fragment,l),ql=U(l),V=n(l,"IMG",{src:!0,alt:!0}),Wl=U(l),A=n(l,"P",{"data-svelte-h":!0}),T(A)!=="svelte-2lj48b"&&(A.innerHTML=re),Xl=U(l),Q=n(l,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-1erzl60"&&(Q.textContent=ce),Yl=U(l),r=n(l,"P",{"data-svelte-h":!0}),T(r)!=="svelte-nhsnjo"&&(r.textContent=fe),zl=U(l),y(c.$$.fragment,l),Zl=U(l),f=n(l,"P",{"data-svelte-h":!0}),T(f)!=="svelte-b0cx07"&&(f.innerHTML=Be),Pl=U(l),B=n(l,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1hskflb"&&(B.textContent=be),Kl=U(l),b=n(l,"TABLE",{"data-svelte-h":!0}),T(b)!=="svelte-f59njy"&&(b.innerHTML=de),lt=U(l),d=n(l,"P",{"data-svelte-h":!0}),T(d)!=="svelte-q0xfd8"&&(d.textContent=Ee),tt=U(l),E=n(l,"P",{"data-svelte-h":!0}),T(E)!=="svelte-1s4gqea"&&(E.innerHTML=ge),et=U(l),g=n(l,"P",{"data-svelte-h":!0}),T(g)!=="svelte-q1ut6r"&&(g.innerHTML=he),Mt=U(l),h=n(l,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1mov6i7"&&(h.innerHTML=_e),st=U(l),_=n(l,"P",{"data-svelte-h":!0}),T(_)!=="svelte-gd48l2"&&(_.textContent=Re),Ut=U(l),R=n(l,"IMG",{src:!0,alt:!0}),Jt=U(l),v=n(l,"UL",{"data-svelte-h":!0}),T(v)!=="svelte-1iw0pe0"&&(v.innerHTML=Fe),nt=U(l),y(F.$$.fragment,l),Tt=U(l),S=n(l,"P",{"data-svelte-h":!0}),T(S)!=="svelte-qvxnn6"&&(S.innerHTML=Se),it=U(l),k=n(l,"P",{"data-svelte-h":!0}),T(k)!=="svelte-12iwnao"&&(k.innerHTML=ke),yt=U(l),x=n(l,"P",{"data-svelte-h":!0}),T(x)!=="svelte-i133bk"&&(x.innerHTML=xe),at=U(l),L=n(l,"P",{"data-svelte-h":!0}),T(L)!=="svelte-4vpkzc"&&(L.textContent=Le),Ct=U(l),y(O.$$.fragment,l),pt=U(l),N=n(l,"P",{"data-svelte-h":!0}),T(N)!=="svelte-1e8132k"&&(N.innerHTML=Oe),jt=U(l),$=n(l,"IMG",{src:!0,alt:!0}),wt=U(l),D=n(l,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1nf3f0g"&&(D.textContent=$e),It=U(l),G=n(l,"OL",{"data-svelte-h":!0}),T(G)!=="svelte-1taixl7"&&(G.innerHTML=De),ut=U(l),H=n(l,"P",{"data-svelte-h":!0}),T(H)!=="svelte-a0w24d"&&(H.innerHTML=Ge),ot=U(l),q=n(l,"P",{"data-svelte-h":!0}),T(q)!=="svelte-faj8xi"&&(q.textContent=He),mt=U(l),W=n(l,"P",{"data-svelte-h":!0}),T(W)!=="svelte-223plm"&&(W.innerHTML=qe),Vt=U(l),y(X.$$.fragment,l),At=U(l),Y=n(l,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-16o9jiy"&&(Y.innerHTML=We),Qt=U(l),z=n(l,"UL",{"data-svelte-h":!0}),T(z)!=="svelte-wy9x9l"&&(z.innerHTML=Xe),rt=U(l),Z=n(l,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-1ne24fu"&&(Z.textContent=Ye),ct=U(l),P=n(l,"UL",{"data-svelte-h":!0}),T(P)!=="svelte-y08eiw"&&(P.innerHTML=ze),ft=U(l),K=n(l,"P",{"data-svelte-h":!0}),T(K)!=="svelte-1dm719v"&&(K.textContent=Ze),Bt=U(l),y(ll.$$.fragment,l),bt=U(l),tl=n(l,"BLOCKQUOTE",{"data-svelte-h":!0}),T(tl)!=="svelte-vy6e71"&&(tl.innerHTML=Pe),dt=U(l),el=n(l,"P",{"data-svelte-h":!0}),T(el)!=="svelte-1nj012o"&&(el.textContent=Ke),Et=U(l),Ml=n(l,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-1m2dsgp"&&(Ml.textContent=lM),gt=U(l),sl=n(l,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-1po3r15"&&(sl.textContent=tM),ht=U(l),y(Ul.$$.fragment,l),_t=U(l),Jl=n(l,"P",{"data-svelte-h":!0}),T(Jl)!=="svelte-1vnxojk"&&(Jl.textContent=eM),Rt=U(l),nl=n(l,"UL",{"data-svelte-h":!0}),T(nl)!=="svelte-npivcx"&&(nl.innerHTML=MM),vt=U(l),Tl=n(l,"P",{"data-svelte-h":!0}),T(Tl)!=="svelte-1xfam2p"&&(Tl.textContent=sM),Ft=U(l),il=n(l,"P",{"data-svelte-h":!0}),T(il)!=="svelte-rs7nvw"&&(il.textContent=UM),St=U(l),yl=n(l,"P",{"data-svelte-h":!0}),T(yl)!=="svelte-1bothlt"&&(yl.innerHTML=JM),kt=U(l),y(al.$$.fragment,l),xt=U(l),Cl=n(l,"P",{"data-svelte-h":!0}),T(Cl)!=="svelte-14gcwo3"&&(Cl.innerHTML=nM),Lt=U(l),pl=n(l,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-1kedr6"&&(pl.innerHTML=TM),Ot=U(l),y(jl.$$.fragment,l),Nt=U(l),wl=n(l,"P",{"data-svelte-h":!0}),T(wl)!=="svelte-1s5vsgd"&&(wl.textContent=iM),$t=U(l),y(Il.$$.fragment,l),Dt=U(l),ul=n(l,"P",{"data-svelte-h":!0}),T(ul)!=="svelte-1rw428h"&&(ul.innerHTML=yM),Gt=U(l),ol=n(l,"BLOCKQUOTE",{"data-svelte-h":!0}),T(ol)!=="svelte-u3dndf"&&(ol.innerHTML=aM),Ht=U(l),y(ml.$$.fragment,l),qt=U(l),Vl=n(l,"P",{"data-svelte-h":!0}),T(Vl)!=="svelte-gkrogk"&&(Vl.innerHTML=CM),Wt=U(l),Al=n(l,"UL",{"data-svelte-h":!0}),T(Al)!=="svelte-633ak8"&&(Al.innerHTML=pM),Xt=U(l),Ql=n(l,"P",{"data-svelte-h":!0}),T(Ql)!=="svelte-yldhqa"&&(Ql.textContent=jM),Yt=U(l),y(rl.$$.fragment,l),zt=U(l),cl=n(l,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-87agig"&&(cl.innerHTML=wM),Zt=U(l),fl=n(l,"BLOCKQUOTE",{"data-svelte-h":!0}),T(fl)!=="svelte-1wp8ghv"&&(fl.innerHTML=IM),Pt=U(l),o=n(l,"DETAILS",{});var Ie=me(o);Ol=n(Ie,"SUMMARY",{"data-svelte-h":!0}),T(Ol)!=="svelte-jpdddo"&&(Ol.textContent=uM),oe=U(Ie),y(Bl.$$.fragment,Ie),Ie.forEach(e),Kt=U(l),bl=n(l,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-nbayho"&&(bl.textContent=oM),le=U(l),y(dl.$$.fragment,l),te=U(l),El=n(l,"P",{"data-svelte-h":!0}),T(El)!=="svelte-zc2oog"&&(El.innerHTML=mM),ee=U(l),y(gl.$$.fragment,l),Me=U(l),hl=n(l,"P",{"data-svelte-h":!0}),T(hl)!=="svelte-qzwccu"&&(hl.innerHTML=VM),se=U(l),_l=n(l,"IMG",{src:!0,alt:!0}),Ue=U(l),Rl=n(l,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-1292qbx"&&(Rl.innerHTML=QM),Je=U(l),ne=n(l,"HR",{}),Te=U(l),vl=n(l,"P",{"data-svelte-h":!0}),T(vl)!=="svelte-w3dczj"&&(vl.textContent=rM),ie=U(l),Fl=n(l,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-106vzz3"&&(Fl.textContent=cM),ye=U(l),Sl=n(l,"UL",{"data-svelte-h":!0}),T(Sl)!=="svelte-12oj0ks"&&(Sl.innerHTML=fM),ae=U(l),kl=n(l,"P",{"data-svelte-h":!0}),T(kl)!=="svelte-fuhhcx"&&(kl.innerHTML=BM),Ce=U(l),xl=n(l,"P",{"data-svelte-h":!0}),T(xl)!=="svelte-gi6kft"&&(xl.textContent=bM),pe=U(l),y(Ll.$$.fragment,l),je=U(l),Dl=n(l,"P",{}),me(Dl).forEach(e),this.h()},h(){w(I,"name","hf:doc:metadata"),w(I,"content",SM),ue(V.src,Qe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||w(V,"src",Qe),w(V,"alt","Unit 1 planning"),ue(R.src,ve="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||w(R,"src",ve),w(R,"alt","Weather"),ue($.src,Ne="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||w($,"src",Ne),w($,"alt","System prompt for tools"),ue(_l.src,AM="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||w(_l,"src",AM),w(_l,"alt","System prompt for tools")},m(l,t){Ve(document.head,I),M(l,Gl,t),M(l,$l,t),M(l,Hl,t),a(m,l,t),M(l,ql,t),M(l,V,t),M(l,Wl,t),M(l,A,t),M(l,Xl,t),M(l,Q,t),M(l,Yl,t),M(l,r,t),M(l,zl,t),a(c,l,t),M(l,Zl,t),M(l,f,t),M(l,Pl,t),M(l,B,t),M(l,Kl,t),M(l,b,t),M(l,lt,t),M(l,d,t),M(l,tt,t),M(l,E,t),M(l,et,t),M(l,g,t),M(l,Mt,t),M(l,h,t),M(l,st,t),M(l,_,t),M(l,Ut,t),M(l,R,t),M(l,Jt,t),M(l,v,t),M(l,nt,t),a(F,l,t),M(l,Tt,t),M(l,S,t),M(l,it,t),M(l,k,t),M(l,yt,t),M(l,x,t),M(l,at,t),M(l,L,t),M(l,Ct,t),a(O,l,t),M(l,pt,t),M(l,N,t),M(l,jt,t),M(l,$,t),M(l,wt,t),M(l,D,t),M(l,It,t),M(l,G,t),M(l,ut,t),M(l,H,t),M(l,ot,t),M(l,q,t),M(l,mt,t),M(l,W,t),M(l,Vt,t),a(X,l,t),M(l,At,t),M(l,Y,t),M(l,Qt,t),M(l,z,t),M(l,rt,t),M(l,Z,t),M(l,ct,t),M(l,P,t),M(l,ft,t),M(l,K,t),M(l,Bt,t),a(ll,l,t),M(l,bt,t),M(l,tl,t),M(l,dt,t),M(l,el,t),M(l,Et,t),M(l,Ml,t),M(l,gt,t),M(l,sl,t),M(l,ht,t),a(Ul,l,t),M(l,_t,t),M(l,Jl,t),M(l,Rt,t),M(l,nl,t),M(l,vt,t),M(l,Tl,t),M(l,Ft,t),M(l,il,t),M(l,St,t),M(l,yl,t),M(l,kt,t),a(al,l,t),M(l,xt,t),M(l,Cl,t),M(l,Lt,t),M(l,pl,t),M(l,Ot,t),a(jl,l,t),M(l,Nt,t),M(l,wl,t),M(l,$t,t),a(Il,l,t),M(l,Dt,t),M(l,ul,t),M(l,Gt,t),M(l,ol,t),M(l,Ht,t),a(ml,l,t),M(l,qt,t),M(l,Vl,t),M(l,Wt,t),M(l,Al,t),M(l,Xt,t),M(l,Ql,t),M(l,Yt,t),a(rl,l,t),M(l,zt,t),M(l,cl,t),M(l,Zt,t),M(l,fl,t),M(l,Pt,t),M(l,o,t),Ve(o,Ol),Ve(o,oe),a(Bl,o,null),M(l,Kt,t),M(l,bl,t),M(l,le,t),a(dl,l,t),M(l,te,t),M(l,El,t),M(l,ee,t),a(gl,l,t),M(l,Me,t),M(l,hl,t),M(l,se,t),M(l,_l,t),M(l,Ue,t),M(l,Rl,t),M(l,Je,t),M(l,ne,t),M(l,Te,t),M(l,vl,t),M(l,ie,t),M(l,Fl,t),M(l,ye,t),M(l,Sl,t),M(l,ae,t),M(l,kl,t),M(l,Ce,t),M(l,xl,t),M(l,pe,t),a(Ll,l,t),M(l,je,t),M(l,Dl,t),we=!0},p:EM,i(l){we||(C(m.$$.fragment,l),C(c.$$.fragment,l),C(F.$$.fragment,l),C(O.$$.fragment,l),C(X.$$.fragment,l),C(ll.$$.fragment,l),C(Ul.$$.fragment,l),C(al.$$.fragment,l),C(jl.$$.fragment,l),C(Il.$$.fragment,l),C(ml.$$.fragment,l),C(rl.$$.fragment,l),C(Bl.$$.fragment,l),C(dl.$$.fragment,l),C(gl.$$.fragment,l),C(Ll.$$.fragment,l),we=!0)},o(l){p(m.$$.fragment,l),p(c.$$.fragment,l),p(F.$$.fragment,l),p(O.$$.fragment,l),p(X.$$.fragment,l),p(ll.$$.fragment,l),p(Ul.$$.fragment,l),p(al.$$.fragment,l),p(jl.$$.fragment,l),p(Il.$$.fragment,l),p(ml.$$.fragment,l),p(rl.$$.fragment,l),p(Bl.$$.fragment,l),p(dl.$$.fragment,l),p(gl.$$.fragment,l),p(Ll.$$.fragment,l),we=!1},d(l){l&&(e(Gl),e($l),e(Hl),e(ql),e(V),e(Wl),e(A),e(Xl),e(Q),e(Yl),e(r),e(zl),e(Zl),e(f),e(Pl),e(B),e(Kl),e(b),e(lt),e(d),e(tt),e(E),e(et),e(g),e(Mt),e(h),e(st),e(_),e(Ut),e(R),e(Jt),e(v),e(nt),e(Tt),e(S),e(it),e(k),e(yt),e(x),e(at),e(L),e(Ct),e(pt),e(N),e(jt),e($),e(wt),e(D),e(It),e(G),e(ut),e(H),e(ot),e(q),e(mt),e(W),e(Vt),e(At),e(Y),e(Qt),e(z),e(rt),e(Z),e(ct),e(P),e(ft),e(K),e(Bt),e(bt),e(tl),e(dt),e(el),e(Et),e(Ml),e(gt),e(sl),e(ht),e(_t),e(Jl),e(Rt),e(nl),e(vt),e(Tl),e(Ft),e(il),e(St),e(yl),e(kt),e(xt),e(Cl),e(Lt),e(pl),e(Ot),e(Nt),e(wl),e($t),e(Dt),e(ul),e(Gt),e(ol),e(Ht),e(qt),e(Vl),e(Wt),e(Al),e(Xt),e(Ql),e(Yt),e(zt),e(cl),e(Zt),e(fl),e(Pt),e(o),e(Kt),e(bl),e(le),e(te),e(El),e(ee),e(Me),e(hl),e(se),e(_l),e(Ue),e(Rl),e(Je),e(ne),e(Te),e(vl),e(ie),e(Fl),e(ye),e(Sl),e(ae),e(kl),e(Ce),e(xl),e(pe),e(je),e(Dl)),e(I),j(m,l),j(c,l),j(F,l),j(O,l),j(X,l),j(ll,l),j(Ul,l),j(al,l),j(jl,l),j(Il,l),j(ml,l),j(rl,l),j(Bl),j(dl,l),j(gl,l),j(Ll,l)}}}const SM='{"title":"도구(Tool)란?","local":"what-are-tools","sections":[{"title":"AI 도구란?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"도구는 어떻게 작동하는가?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"LLM에게 도구를 제공하는 방법","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"자동 포맷팅된 도구 섹션","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"범용적인 도구(Generic Tool) 구현","local":"generic-tool-implementation","sections":[],"depth":3}],"depth":2}],"depth":1}';function kM(Ae){return gM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $M extends hM{constructor(I){super(),_M(this,I,kM,FM,dM,{})}}export{$M as component};
