import{s as je,n as Ge,o as Ue}from"../chunks/scheduler.12fdeddc.js";import{S as Ze,i as _e,g as i,s as l,r as p,A as Be,h as o,f as a,c as n,j as ge,u as r,x as d,k as $e,y as Ce,a as s,v as u,d as m,t as f,w as c}from"../chunks/index.88dae322.js";import{C as h}from"../chunks/CodeBlock.8e54a086.js";import{H as ot,E as Xe}from"../chunks/getInferenceSnippets.06fe9bcd.js";function Re(Ot){let y,dt,nt,pt,M,rt,w,te='<a href="https://www.dask.org/?utm_source=hf-docs" rel="nofollow">Dask</a> is a parallel and distributed computing library that scales the existing Python and PyData ecosystem.',ut,J,ee='In particular, we can use <a href="https://docs.dask.org/en/stable/dataframe.html?utm_source=hf-docs" rel="nofollow">Dask DataFrame</a> to scale up pandas workflows. Dask DataFrame parallelizes pandas to handle large tabular data. It closely mirrors the pandas API, making it simple to transition from testing on a single dataset to processing the full dataset. Dask is particularly effective with Parquet, the default format on Hugging Face Datasets, as it supports rich data types, efficient columnar filtering, and compression.',mt,k,ae='A good practical use case for Dask is running data processing or model inference on a dataset in a distributed manner. See, for example, <a href="https://www.coiled.io/?utm_source=hf-docs" rel="nofollow">Coiled’s</a> excellent blog post on <a href="https://huggingface.co/blog/dask-scaling" rel="nofollow">Scaling AI-Based Data Processing with Hugging Face + Dask</a>.',ft,T,ct,b,se='Since Dask uses <a href="https://filesystem-spec.readthedocs.io" rel="nofollow">fsspec</a> to read and write remote data, you can use the Hugging Face paths (<a href="/docs/huggingface_hub/guides/hf_file_system#integrations"><code>hf://</code></a>) to read and write data on the Hub.',ht,g,le='First you need to <a href="/docs/huggingface_hub/quick-start#login">Login with your Hugging Face account</a>, for example using:',yt,$,Mt,j,ne='Then you can <a href="/docs/huggingface_hub/quick-start#create-a-repository">Create a dataset repository</a>, for example using:',wt,G,Jt,U,ie=`Finally, you can use <a href="/docs/huggingface_hub/guides/hf_file_system#integrations">Hugging Face paths</a> in Dask.
Dask DataFrame supports distributed writing to Parquet on Hugging Face, which uses commits to track dataset changes:`,kt,Z,Tt,_,oe="Since this creates one commit per file, it is recommended to squash the history after the upload:",bt,B,gt,C,de=`This creates a dataset repository <code>username/my_dataset</code> containing your Dask dataset in Parquet format.
You can reload it later:`,$t,X,jt,R,pe='For more information on the Hugging Face paths and how they are implemented, please refer to the <a href="/docs/huggingface_hub/guides/hf_file_system">the client library’s documentation on the HfFileSystem</a>.',Gt,I,Ut,v,re="To process a dataset in parallel using Dask, you can first define your data processing function for a pandas DataFrame or Series, and then use the Dask <code>map_partitions</code> function to apply this function to all the partitions of a dataset in parallel:",Zt,H,_t,F,ue="or a similar function using pandas string methods (faster):",Bt,V,Ct,x,me="In pandas you can use this function on a text column:",Xt,W,Rt,q,fe="And in Dask you can run this function on every partition:",It,Y,vt,z,ce=`Note that you also need to provide <code>meta</code> which is the type of the pandas Series or DataFrame in the output of your function.
This is needed because Dask DataFrame uses a lazy API. Since Dask will only run the data processing once <code>.compute()</code> is called, it needs
the <code>meta</code> argument to know the type of the new column in the meantime.`,Ht,Q,Ft,P,he="When reading Parquet data from Hugging Face, Dask automatically leverages the metadata in Parquet files to skip entire files or row groups if they are not needed. For example if you apply a filter (predicate) on a Hugging Face Dataset in Parquet format or if you select a subset of the columns (projection), Dask will read the metadata of the Parquet files to discard the parts that are not needed without downloading them.",Vt,N,ye='This is possible thanks to a <a href="https://docs.coiled.io/blog/dask-dataframe-is-fast.html?utm_source=hf-docs" rel="nofollow">reimplementation of the Dask DataFrame API</a> to support query optimization, which makes Dask faster and more robust.',xt,L,Me="For example this subset of FineWeb-Edu contains many Parquet files. If you can filter the dataset to keep the text from recent CC dumps, Dask will skip most of the files and only download the data that match the filter:",Wt,D,qt,S,we=`Dask will also read only the required columns for your computation and skip the rest.
For example if you drop a column late in your code, it will not bother to load it early on in the pipeline if it’s not needed.
This is useful when you want to manipulate a subset of the columns or for analytics:`,Yt,E,zt,A,Qt,K,Je="Most features in <code>dask</code> are optimized for a cluster or a local <code>Client</code> to launch the parallel computations:",Pt,O,Nt,tt,ke="For local usage, the <code>Client</code> uses a Dask <code>LocalCluster</code> with multiprocessing by default. You can manually configure the multiprocessing of <code>LocalCluster</code> with",Lt,et,Dt,at,Te='Note that if you use the default threaded scheduler locally without <code>Client</code>, a DataFrame can become slower after certain operations (more details <a href="https://github.com/dask/dask-expr/issues/1181" rel="nofollow">here</a>).',St,st,be='Find more information on setting up a local or cloud cluster in the <a href="https://docs.dask.org/en/latest/deploying.html" rel="nofollow">Deploying Dask documentation</a>.',Et,lt,At,it,Kt;return M=new ot({props:{title:"Dask",local:"dask",headingTag:"h1"}}),T=new ot({props:{title:"Read and Write",local:"read-and-write",headingTag:"h2"}}),$=new h({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:'<span class="hljs-attribute">hf auth login</span>',wrap:!1}}),G=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBSGZBcGkoKS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9kYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

HfApi().create_repo(repo_id=<span class="hljs-string">&quot;username/my_dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),Z=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYudG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTIyKSUwQSUwQSUyMyUyMG9yJTIwd3JpdGUlMjBpbiUyMHNlcGFyYXRlJTIwZGlyZWN0b3JpZXMlMjBpZiUyMHRoZSUyMGRhdGFzZXQlMjBoYXMlMjB0cmFpbiUyRnZhbGlkYXRpb24lMkZ0ZXN0JTIwc3BsaXRzJTBBZGZfdHJhaW4udG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdHJhaW4lMjIpJTBBZGZfdmFsaWQudG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdmFsaWRhdGlvbiUyMiklMEFkZl90ZXN0JTIwLnRvX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRnRlc3QlMjIp",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset&quot;</span>)

<span class="hljs-comment"># or write in separate directories if the dataset has train/validation/test splits</span>
df_train.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/train&quot;</span>)
df_valid.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/validation&quot;</span>)
df_test .to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/test&quot;</span>)`,wrap:!1}}),B=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBSGZBcGkoKS5zdXBlcl9zcXVhc2hfaGlzdG9yeShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

HfApi().super_squash_history(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),X=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyMiklMEElMEElMjMlMjBvciUyMHJlYWQlMjBmcm9tJTIwc2VwYXJhdGUlMjBkaXJlY3RvcmllcyUyMGlmJTIwdGhlJTIwZGF0YXNldCUyMGhhcyUyMHRyYWluJTJGdmFsaWRhdGlvbiUyRnRlc3QlMjBzcGxpdHMlMEFkZl90cmFpbiUyMCUzRCUyMGRkLnJlYWRfcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdHJhaW4lMjIpJTBBZGZfdmFsaWQlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRnZhbGlkYXRpb24lMjIpJTBBZGZfdGVzdCUyMCUyMCUzRCUyMGRkLnJlYWRfcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdGVzdCUyMik=",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset&quot;</span>)

<span class="hljs-comment"># or read from separate directories if the dataset has train/validation/test splits</span>
df_train = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/train&quot;</span>)
df_valid = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/validation&quot;</span>)
df_test  = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/test&quot;</span>)`,wrap:!1}}),I=new ot({props:{title:"Process data",local:"process-data",headingTag:"h2"}}),H=new h({props:{code:"ZGVmJTIwZHVtbXlfY291bnRfd29yZHModGV4dHMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcGQuU2VyaWVzKCU1Qmxlbih0ZXh0LnNwbGl0KCUyMiUyMCUyMikpJTIwZm9yJTIwdGV4dCUyMGluJTIwdGV4dHMlNUQp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">dummy_count_words</span>(<span class="hljs-params">texts</span>):
    <span class="hljs-keyword">return</span> pd.Series([<span class="hljs-built_in">len</span>(text.split(<span class="hljs-string">&quot; &quot;</span>)) <span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> texts])`,wrap:!1}}),V=new h({props:{code:"ZGVmJTIwZHVtbXlfY291bnRfd29yZHModGV4dHMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGV4dHMuc3RyLmNvdW50KCUyMiUyMCUyMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">dummy_count_words</span>(<span class="hljs-params">texts</span>):
    <span class="hljs-keyword">return</span> texts.<span class="hljs-built_in">str</span>.count(<span class="hljs-string">&quot; &quot;</span>)`,wrap:!1}}),W=new h({props:{code:"JTIzJTIwcGFuZGFzJTIwQVBJJTBBZGYlNUIlMjJudW1fd29yZHMlMjIlNUQlMjAlM0QlMjBkdW1teV9jb3VudF93b3JkcyhkZi50ZXh0KQ==",highlighted:`<span class="hljs-comment"># pandas API</span>
df[<span class="hljs-string">&quot;num_words&quot;</span>] = dummy_count_words(df.text)`,wrap:!1}}),Y=new h({props:{code:"JTIzJTIwRGFzayUyMEFQSSUzQSUyMHJ1biUyMHRoZSUyMGZ1bmN0aW9uJTIwb24lMjBldmVyeSUyMHBhcnRpdGlvbiUwQWRmJTVCJTIybnVtX3dvcmRzJTIyJTVEJTIwJTNEJTIwZGYudGV4dC5tYXBfcGFydGl0aW9ucyhkdW1teV9jb3VudF93b3JkcyUyQyUyMG1ldGElM0RpbnQp",highlighted:`<span class="hljs-comment"># Dask API: run the function on every partition</span>
df[<span class="hljs-string">&quot;num_words&quot;</span>] = df.text.map_partitions(dummy_count_words, meta=<span class="hljs-built_in">int</span>)`,wrap:!1}}),Q=new ot({props:{title:"Predicate and Projection Pushdown",local:"predicate-and-projection-pushdown",headingTag:"h2"}}),D=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRkh1Z2dpbmdGYWNlRlclMkZmaW5ld2ViLWVkdSUyRnNhbXBsZSUyRjEwQlQlMkYqLnBhcnF1ZXQlMjIpJTBBJTBBJTIzJTIwRGFzayUyMHdpbGwlMjBza2lwJTIwdGhlJTIwZmlsZXMlMjBvciUyMHJvdyUyMGdyb3VwcyUyMHRoYXQlMjBkb24ndCUwQSUyMyUyMG1hdGNoJTIwdGhlJTIwcXVlcnklMjB3aXRob3V0JTIwZG93bmxvYWRpbmclMjB0aGVtLiUwQWRmJTIwJTNEJTIwZGYlNUJkZi5kdW1wJTIwJTNFJTNEJTIwJTIyQ0MtTUFJTi0yMDIzJTIyJTVE",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/HuggingFaceFW/fineweb-edu/sample/10BT/*.parquet&quot;</span>)

<span class="hljs-comment"># Dask will skip the files or row groups that don&#x27;t</span>
<span class="hljs-comment"># match the query without downloading them.</span>
df = df[df.dump &gt;= <span class="hljs-string">&quot;CC-MAIN-2023&quot;</span>]`,wrap:!1}}),E=new h({props:{code:"JTIzJTIwRGFzayUyMHdpbGwlMjBkb3dubG9hZCUyMHRoZSUyMCdkdW1wJyUyMGFuZCUyMCd0b2tlbl9jb3VudCclMjBuZWVkZWQlMEElMjMlMjBmb3IlMjB0aGUlMjBmaWx0ZXJpbmclMjBhbmQlMjBjb21wdXRhdGlvbiUyMGFuZCUyMHNraXAlMjB0aGUlMjBvdGhlciUyMGNvbHVtbnMuJTBBZGYudG9rZW5fY291bnQubWVhbigpLmNvbXB1dGUoKQ==",highlighted:`<span class="hljs-comment"># Dask will download the &#x27;dump&#x27; and &#x27;token_count&#x27; needed</span>
<span class="hljs-comment"># for the filtering and computation and skip the other columns.</span>
df.token_count.mean().compute()`,wrap:!1}}),A=new ot({props:{title:"Client",local:"client",headingTag:"h2"}}),O=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBZnJvbSUyMGRpc3RyaWJ1dGVkJTIwaW1wb3J0JTIwQ2xpZW50JTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTIwJTIwJTIzJTIwbmVlZGVkJTIwZm9yJTIwY3JlYXRpbmclMjBuZXclMjBwcm9jZXNzZXMlMEElMjAlMjAlMjAlMjBjbGllbnQlMjAlM0QlMjBDbGllbnQoKSUwQSUyMCUyMCUyMCUyMGRmJTIwJTNEJTIwZGQucmVhZF9wYXJxdWV0KC4uLiklMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd
<span class="hljs-keyword">from</span> distributed <span class="hljs-keyword">import</span> Client

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:  <span class="hljs-comment"># needed for creating new processes</span>
    client = Client()
    df = dd.read_parquet(...)
    ...`,wrap:!1}}),et=new h({props:{code:"ZnJvbSUyMGRhc2suZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBMb2NhbENsdXN0ZXIlMEFjbHVzdGVyJTIwJTNEJTIwTG9jYWxDbHVzdGVyKG5fd29ya2VycyUzRDglMkMlMjB0aHJlYWRzX3Blcl93b3JrZXIlM0Q4KSUwQWNsaWVudCUyMCUzRCUyMENsaWVudChjbHVzdGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> dask.distributed <span class="hljs-keyword">import</span> Client, LocalCluster
cluster = LocalCluster(n_workers=<span class="hljs-number">8</span>, threads_per_worker=<span class="hljs-number">8</span>)
client = Client(cluster)`,wrap:!1}}),lt=new Xe({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-dask.md"}}),{c(){y=i("meta"),dt=l(),nt=i("p"),pt=l(),p(M.$$.fragment),rt=l(),w=i("p"),w.innerHTML=te,ut=l(),J=i("p"),J.innerHTML=ee,mt=l(),k=i("p"),k.innerHTML=ae,ft=l(),p(T.$$.fragment),ct=l(),b=i("p"),b.innerHTML=se,ht=l(),g=i("p"),g.innerHTML=le,yt=l(),p($.$$.fragment),Mt=l(),j=i("p"),j.innerHTML=ne,wt=l(),p(G.$$.fragment),Jt=l(),U=i("p"),U.innerHTML=ie,kt=l(),p(Z.$$.fragment),Tt=l(),_=i("p"),_.textContent=oe,bt=l(),p(B.$$.fragment),gt=l(),C=i("p"),C.innerHTML=de,$t=l(),p(X.$$.fragment),jt=l(),R=i("p"),R.innerHTML=pe,Gt=l(),p(I.$$.fragment),Ut=l(),v=i("p"),v.innerHTML=re,Zt=l(),p(H.$$.fragment),_t=l(),F=i("p"),F.textContent=ue,Bt=l(),p(V.$$.fragment),Ct=l(),x=i("p"),x.textContent=me,Xt=l(),p(W.$$.fragment),Rt=l(),q=i("p"),q.textContent=fe,It=l(),p(Y.$$.fragment),vt=l(),z=i("p"),z.innerHTML=ce,Ht=l(),p(Q.$$.fragment),Ft=l(),P=i("p"),P.textContent=he,Vt=l(),N=i("p"),N.innerHTML=ye,xt=l(),L=i("p"),L.textContent=Me,Wt=l(),p(D.$$.fragment),qt=l(),S=i("p"),S.textContent=we,Yt=l(),p(E.$$.fragment),zt=l(),p(A.$$.fragment),Qt=l(),K=i("p"),K.innerHTML=Je,Pt=l(),p(O.$$.fragment),Nt=l(),tt=i("p"),tt.innerHTML=ke,Lt=l(),p(et.$$.fragment),Dt=l(),at=i("p"),at.innerHTML=Te,St=l(),st=i("p"),st.innerHTML=be,Et=l(),p(lt.$$.fragment),At=l(),it=i("p"),this.h()},l(t){const e=Be("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(a),dt=n(t),nt=o(t,"P",{}),ge(nt).forEach(a),pt=n(t),r(M.$$.fragment,t),rt=n(t),w=o(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-7bngbf"&&(w.innerHTML=te),ut=n(t),J=o(t,"P",{"data-svelte-h":!0}),d(J)!=="svelte-i5foif"&&(J.innerHTML=ee),mt=n(t),k=o(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-x5cdod"&&(k.innerHTML=ae),ft=n(t),r(T.$$.fragment,t),ct=n(t),b=o(t,"P",{"data-svelte-h":!0}),d(b)!=="svelte-17pc16c"&&(b.innerHTML=se),ht=n(t),g=o(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1jdzygp"&&(g.innerHTML=le),yt=n(t),r($.$$.fragment,t),Mt=n(t),j=o(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-wfb25d"&&(j.innerHTML=ne),wt=n(t),r(G.$$.fragment,t),Jt=n(t),U=o(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1qjbxya"&&(U.innerHTML=ie),kt=n(t),r(Z.$$.fragment,t),Tt=n(t),_=o(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1g4eau0"&&(_.textContent=oe),bt=n(t),r(B.$$.fragment,t),gt=n(t),C=o(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-14rczfs"&&(C.innerHTML=de),$t=n(t),r(X.$$.fragment,t),jt=n(t),R=o(t,"P",{"data-svelte-h":!0}),d(R)!=="svelte-smuvdf"&&(R.innerHTML=pe),Gt=n(t),r(I.$$.fragment,t),Ut=n(t),v=o(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-jyx2ul"&&(v.innerHTML=re),Zt=n(t),r(H.$$.fragment,t),_t=n(t),F=o(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-13b7gvr"&&(F.textContent=ue),Bt=n(t),r(V.$$.fragment,t),Ct=n(t),x=o(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1qxyr3j"&&(x.textContent=me),Xt=n(t),r(W.$$.fragment,t),Rt=n(t),q=o(t,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1387ba7"&&(q.textContent=fe),It=n(t),r(Y.$$.fragment,t),vt=n(t),z=o(t,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1php7k6"&&(z.innerHTML=ce),Ht=n(t),r(Q.$$.fragment,t),Ft=n(t),P=o(t,"P",{"data-svelte-h":!0}),d(P)!=="svelte-eeqqwq"&&(P.textContent=he),Vt=n(t),N=o(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1eaadiq"&&(N.innerHTML=ye),xt=n(t),L=o(t,"P",{"data-svelte-h":!0}),d(L)!=="svelte-nn7d20"&&(L.textContent=Me),Wt=n(t),r(D.$$.fragment,t),qt=n(t),S=o(t,"P",{"data-svelte-h":!0}),d(S)!=="svelte-13j15e1"&&(S.textContent=we),Yt=n(t),r(E.$$.fragment,t),zt=n(t),r(A.$$.fragment,t),Qt=n(t),K=o(t,"P",{"data-svelte-h":!0}),d(K)!=="svelte-hps2t7"&&(K.innerHTML=Je),Pt=n(t),r(O.$$.fragment,t),Nt=n(t),tt=o(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-2utr02"&&(tt.innerHTML=ke),Lt=n(t),r(et.$$.fragment,t),Dt=n(t),at=o(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1kflfyu"&&(at.innerHTML=Te),St=n(t),st=o(t,"P",{"data-svelte-h":!0}),d(st)!=="svelte-112dp33"&&(st.innerHTML=be),Et=n(t),r(lt.$$.fragment,t),At=n(t),it=o(t,"P",{}),ge(it).forEach(a),this.h()},h(){$e(y,"name","hf:doc:metadata"),$e(y,"content",Ie)},m(t,e){Ce(document.head,y),s(t,dt,e),s(t,nt,e),s(t,pt,e),u(M,t,e),s(t,rt,e),s(t,w,e),s(t,ut,e),s(t,J,e),s(t,mt,e),s(t,k,e),s(t,ft,e),u(T,t,e),s(t,ct,e),s(t,b,e),s(t,ht,e),s(t,g,e),s(t,yt,e),u($,t,e),s(t,Mt,e),s(t,j,e),s(t,wt,e),u(G,t,e),s(t,Jt,e),s(t,U,e),s(t,kt,e),u(Z,t,e),s(t,Tt,e),s(t,_,e),s(t,bt,e),u(B,t,e),s(t,gt,e),s(t,C,e),s(t,$t,e),u(X,t,e),s(t,jt,e),s(t,R,e),s(t,Gt,e),u(I,t,e),s(t,Ut,e),s(t,v,e),s(t,Zt,e),u(H,t,e),s(t,_t,e),s(t,F,e),s(t,Bt,e),u(V,t,e),s(t,Ct,e),s(t,x,e),s(t,Xt,e),u(W,t,e),s(t,Rt,e),s(t,q,e),s(t,It,e),u(Y,t,e),s(t,vt,e),s(t,z,e),s(t,Ht,e),u(Q,t,e),s(t,Ft,e),s(t,P,e),s(t,Vt,e),s(t,N,e),s(t,xt,e),s(t,L,e),s(t,Wt,e),u(D,t,e),s(t,qt,e),s(t,S,e),s(t,Yt,e),u(E,t,e),s(t,zt,e),u(A,t,e),s(t,Qt,e),s(t,K,e),s(t,Pt,e),u(O,t,e),s(t,Nt,e),s(t,tt,e),s(t,Lt,e),u(et,t,e),s(t,Dt,e),s(t,at,e),s(t,St,e),s(t,st,e),s(t,Et,e),u(lt,t,e),s(t,At,e),s(t,it,e),Kt=!0},p:Ge,i(t){Kt||(m(M.$$.fragment,t),m(T.$$.fragment,t),m($.$$.fragment,t),m(G.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(X.$$.fragment,t),m(I.$$.fragment,t),m(H.$$.fragment,t),m(V.$$.fragment,t),m(W.$$.fragment,t),m(Y.$$.fragment,t),m(Q.$$.fragment,t),m(D.$$.fragment,t),m(E.$$.fragment,t),m(A.$$.fragment,t),m(O.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),Kt=!0)},o(t){f(M.$$.fragment,t),f(T.$$.fragment,t),f($.$$.fragment,t),f(G.$$.fragment,t),f(Z.$$.fragment,t),f(B.$$.fragment,t),f(X.$$.fragment,t),f(I.$$.fragment,t),f(H.$$.fragment,t),f(V.$$.fragment,t),f(W.$$.fragment,t),f(Y.$$.fragment,t),f(Q.$$.fragment,t),f(D.$$.fragment,t),f(E.$$.fragment,t),f(A.$$.fragment,t),f(O.$$.fragment,t),f(et.$$.fragment,t),f(lt.$$.fragment,t),Kt=!1},d(t){t&&(a(dt),a(nt),a(pt),a(rt),a(w),a(ut),a(J),a(mt),a(k),a(ft),a(ct),a(b),a(ht),a(g),a(yt),a(Mt),a(j),a(wt),a(Jt),a(U),a(kt),a(Tt),a(_),a(bt),a(gt),a(C),a($t),a(jt),a(R),a(Gt),a(Ut),a(v),a(Zt),a(_t),a(F),a(Bt),a(Ct),a(x),a(Xt),a(Rt),a(q),a(It),a(vt),a(z),a(Ht),a(Ft),a(P),a(Vt),a(N),a(xt),a(L),a(Wt),a(qt),a(S),a(Yt),a(zt),a(Qt),a(K),a(Pt),a(Nt),a(tt),a(Lt),a(Dt),a(at),a(St),a(st),a(Et),a(At),a(it)),a(y),c(M,t),c(T,t),c($,t),c(G,t),c(Z,t),c(B,t),c(X,t),c(I,t),c(H,t),c(V,t),c(W,t),c(Y,t),c(Q,t),c(D,t),c(E,t),c(A,t),c(O,t),c(et,t),c(lt,t)}}}const Ie='{"title":"Dask","local":"dask","sections":[{"title":"Read and Write","local":"read-and-write","sections":[],"depth":2},{"title":"Process data","local":"process-data","sections":[],"depth":2},{"title":"Predicate and Projection Pushdown","local":"predicate-and-projection-pushdown","sections":[],"depth":2},{"title":"Client","local":"client","sections":[],"depth":2}],"depth":1}';function ve(Ot){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends Ze{constructor(y){super(),_e(this,y,ve,Re,je,{})}}export{We as component};
