import{s as Gn,n as Hn,o as Rn}from"../chunks/scheduler.9039eef2.js";import{S as Vn,i as Nn,g as l,s as a,r as p,A as An,h as i,f as n,c as r,j as y,u as m,x as c,k as w,y as s,a as o,v as h,d as g,t as u,w as T}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{C as J}from"../chunks/CodeBlock.8580f3e8.js";import{H as $e}from"../chunks/Heading.f027f30d.js";function Xn(cn){let _,Re,Ge,Ve,Z,Ne,O,pn='TRL supports the <a href="https://arxiv.org/abs/1707.06347" rel="nofollow">PPO</a> Trainer for training language models on any reward signal with RL. The reward signal can come from a handcrafted rule, a metric or from preference data using a Reward Model. For a full example have a look at <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a>. The trainer is heavily inspired by the original <a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">OpenAI learning to summarize work</a>.',Ae,B,mn='The first step is to train your SFT model (see the <a href="sft_trainer">SFTTrainer</a>), to ensure the data we train on is in-distribution for the PPO algorithm. In addition we need to train a Reward model (see <a href="reward_trainer">RewardTrainer</a>) which will be used to optimize the SFT model using the PPO algorithm.',Xe,q,Ee,L,hn="The <code>PPOTrainer</code> expects to align a generated response with a query given the rewards obtained from the Reward model. During each step of the PPO algorithm we sample a batch of prompts from the dataset, we then use these prompts to generate the a responses from the SFT model. Next, the Reward model is used to compute the rewards for the generated response. Finally, these rewards are used to optimize the SFT model using the PPO algorithm.",Qe,W,gn="Therefore the dataset should contain a text column which we can rename to <code>query</code>. Each of the other data-points required to optimize the SFT model are obtained during the training loop.",Se,G,un='Here is an example with the <a href="https://huggingface.co/datasets/HuggingFaceH4/cherry_picked_prompts" rel="nofollow">HuggingFaceH4/cherry_picked_prompts</a> dataset:',De,H,Ye,R,Tn="Resulting in the following subset of the dataset:",Ke,V,et,N,tt,A,fn='For a detailed example have a look at the <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a> notebook. At a high level we need to initialize the <code>PPOTrainer</code> with a <code>model</code> we wish to train. Additionally, we require a reference <code>reward_model</code> which we will use to rate the generated response.',nt,X,at,E,yn="The <code>PPOConfig</code> dataclass controls all the hyperparameters and settings for the PPO algorithm and trainer.",rt,Q,ot,S,wn="Now we can initialize our model. Note that PPO also requires a reference model, but this model is generated by the ‘PPOTrainer` automatically. The model can be initialized as follows:",st,D,lt,Y,bn="As mentioned above, the reward can be generated using any function that returns a single value for a string, be it a simple rule (e.g. length of string), a metric (e.g. BLEU), or a reward model based on human preferences. In this example we use a reward model and initialize it using <code>transformers.pipeline</code> for ease of use.",it,K,dt,ee,_n="Lastly, we pretokenize our dataset using the <code>tokenizer</code> to ensure we can efficiently generate responses during the training loop:",ct,te,pt,ne,Mn="Now we are ready to initialize the <code>PPOTrainer</code> using the defined config, datasets, and model.",mt,ae,ht,re,gt,oe,Jn="Because the <code>PPOTrainer</code> needs an active <code>reward</code> per execution step, we need to define a method to get rewards during each step of the PPO algorithm. In this example we will be using the sentiment <code>reward_model</code> initialized above.",ut,se,vn='To guide the generation process we use the <code>generation_kwargs</code> which are passed to the <code>model.generate</code> method for the SFT-model during each step. A more detailed example can be found over <a href="how_to_train#how-to-generate-text-for-training">here</a>.',Tt,le,ft,ie,Pn="We can then loop over all examples in the dataset and generate a response for each query. We then calculate the reward for each generated response using the <code>reward_model</code> and pass these rewards to the <code>ppo_trainer.step</code> method. The <code>ppo_trainer.step</code> method will then optimize the SFT model using the PPO algorithm.",yt,de,wt,ce,bt,pe,In="While training and evaluating we log the following metrics:",_t,me,$n="<li><code>stats</code>: The statistics of the PPO algorithm, including the loss, entropy, etc.</li> <li><code>batch</code>: The batch of data used to train the SFT model.</li> <li><code>rewards</code>: The rewards obtained from the Reward model.</li>",Mt,he,Jt,d,ge,Lt,Ue,Un=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Wt,v,ue,Gt,xe,xn="Calculate model outputs in multiple batches.",Ht,P,Te,Rt,je,jn="Compute per token rewards from scores and KL-penalty.",Vt,I,fe,Nt,Ce,Cn="Creates and saves a model card for a TRL model.",At,$,ye,Xt,ke,kn="Gather stats from all processes. Useful in the context of distributed training.",Et,U,we,Qt,ze,zn=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,St,x,be,Dt,Fe,Fn="A function that logs all the training stats. Call it at the end of each epoch.",Yt,j,_e,Kt,Ze,Zn="Calculate policy and value losses.",en,C,Me,tn,Oe,On="Prepare the dataloader for training.",nn,k,Je,an,Be,Bn="Record training step statistics.",rn,z,ve,on,qe,qn="Run a PPO optimisation step given a list of queries, model responses, and rewards.",sn,F,Pe,ln,Le,Ln="Train one PPO minibatch",vt,M,Ie,dn,We,Wn="Configuration class for PPOTrainer",Pt,He,It;return Z=new $e({props:{title:"PPO Trainer",local:"ppo-trainer",headingTag:"h1"}}),q=new $e({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),H=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGY2hlcnJ5X3BpY2tlZF9wcm9tcHRzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW5hbWVfY29sdW1uKCUyMnByb21wdCUyMiUyQyUyMCUyMnF1ZXJ5JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMm1ldGElMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/cherry_picked_prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;query&quot;</span>)
dataset = dataset.remove_columns([<span class="hljs-string">&quot;meta&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),V=new J({props:{code:"cHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRXhwbGFpbiUyMHRoZSUyMG1vb24lMjBsYW5kaW5nJTIwdG8lMjBhJTIwNiUyMHllYXIlMjBvbGQlMjBpbiUyMGElMjBmZXclMjBzZW50ZW5jZXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2h5JTIwYXJlbiVFMiU4MCU5OXQlMjBiaXJkcyUyMHJlYWwlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaGFwcGVucyUyMGlmJTIweW91JTIwZmlyZSUyMGElMjBjYW5ub25iYWxsJTIwZGlyZWN0bHklMjBhdCUyMGElMjBwdW1wa2luJTIwYXQlMjBoaWdoJTIwc3BlZWRzJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwSSUyMHN0ZWFsJTIwZnJvbSUyMGElMjBncm9jZXJ5JTIwc3RvcmUlMjB3aXRob3V0JTIwZ2V0dGluZyUyMGNhdWdodCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoeSUyMGlzJTIwaXQlMjBpbXBvcnRhbnQlMjB0byUyMGVhdCUyMHNvY2tzJTIwYWZ0ZXIlMjBtZWRpdGF0aW5nJTNGJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`ppo_dataset_dict = {
    <span class="hljs-string">&quot;query&quot;</span>: [
        <span class="hljs-string">&quot;Explain the moon landing to a 6 year old in a few sentences.&quot;</span>,
        <span class="hljs-string">&quot;Why aren’t birds real?&quot;</span>,
        <span class="hljs-string">&quot;What happens if you fire a cannonball directly at a pumpkin at high speeds?&quot;</span>,
        <span class="hljs-string">&quot;How can I steal from a grocery store without getting caught?&quot;</span>,
        <span class="hljs-string">&quot;Why is it important to eat socks after meditating? &quot;</span>
    ]
}`,wrap:!1}}),N=new $e({props:{title:"Using the PPOTrainer",local:"using-the-ppotrainer",headingTag:"h2"}}),X=new $e({props:{title:"Initializing the PPOTrainer",local:"initializing-the-ppotrainer",headingTag:"h3"}}),Q=new J({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMFBQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxLjQxZS01JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

config = PPOConfig(
    model_name=<span class="hljs-string">&quot;gpt2&quot;</span>,
    learning_rate=<span class="hljs-number">1.41e-5</span>,
)`,wrap:!1}}),D=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwUFBPQ29uZmlnJTJDJTIwUFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEElMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer

model = AutoModelForCausalLMWithValueHead.from_pretrained(config.model_name)
tokenizer = AutoTokenizer.from_pretrained(config.model_name)

tokenizer.pad_token = tokenizer.eos_token`,wrap:!1}}),K=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcmV3YXJkX21vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

reward_model = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)`,wrap:!1}}),te=new J({props:{code:"ZGVmJTIwdG9rZW5pemUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmlucHV0X2lkcyUyMiU1RCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoc2FtcGxlJTVCJTIycXVlcnklMjIlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzREZhbHNlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenizer.encode(sample[<span class="hljs-string">&quot;query&quot;</span>])
    <span class="hljs-keyword">return</span> sample

dataset = dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">False</span>)`,wrap:!1}}),ae=new J({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMEElMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRGNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer

ppo_trainer = PPOTrainer(
    model=model,
    config=config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),re=new $e({props:{title:"Starting the training loop",local:"starting-the-training-loop",headingTag:"h3"}}),le=new J({props:{code:"Z2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtaW5fbGVuZ3RoJTIyJTNBJTIwLTElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhZF90b2tlbl9pZCUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMkMlMEElN0Q=",highlighted:`generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
}`,wrap:!1}}),de=new J({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBZm9yJTIwZXBvY2glMjBpbiUyMHRxZG0ocmFuZ2UocHBvX3RyYWluZXIuY29uZmlnLnBwb19lcG9jaHMpJTJDJTIwJTIyZXBvY2glM0ElMjAlMjIpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRxZG0ocHBvX3RyYWluZXIuZGF0YWxvYWRlciklM0ElMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeV90ZW5zb3JzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjMlMjMlMjBHZXQlMjByZXNwb25zZSUyMGZyb20lMjBTRlRNb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlX3RlbnNvcnMlMjAlM0QlMjBwcG9fdHJhaW5lci5nZW5lcmF0ZShxdWVyeV90ZW5zb3JzJTJDJTIwKipnZW5lcmF0aW9uX2t3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwJTVCdG9rZW5pemVyLmRlY29kZShyLnNxdWVlemUoKSklMjBmb3IlMjByJTIwaW4lMjByZXNwb25zZV90ZW5zb3JzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwQ29tcHV0ZSUyMHJld2FyZCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwcmV3YXJkX21vZGVsKHRleHRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMSU1RCU1QiUyMnNjb3JlJTIyJTVEKSUyMGZvciUyMG91dHB1dCUyMGluJTIwcGlwZV9vdXRwdXRzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwUnVuJTIwUFBPJTIwc3RlcCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRzJTIwJTNEJTIwcHBvX3RyYWluZXIuc3RlcChxdWVyeV90ZW5zb3JzJTJDJTIwcmVzcG9uc2VfdGVuc29ycyUyQyUyMHJld2FyZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHBvX3RyYWluZXIubG9nX3N0YXRzKHN0YXRzJTJDJTIwYmF0Y2glMkMlMjByZXdhcmRzKSUwQSUwQSUyMyUyMyUyMyUyMyUyMFNhdmUlMjBtb2RlbCUwQXBwb190cmFpbmVyLnNhdmVfbW9kZWwoJTIybXlfcHBvX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(ppo_trainer.config.ppo_epochs), <span class="hljs-string">&quot;epoch: &quot;</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> tqdm(ppo_trainer.dataloader): 
        query_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
    
        <span class="hljs-comment">#### Get response from SFTModel</span>
        response_tensors = ppo_trainer.generate(query_tensors, **generation_kwargs)
        batch[<span class="hljs-string">&quot;response&quot;</span>] = [tokenizer.decode(r.squeeze()) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> response_tensors]
    
        <span class="hljs-comment">#### Compute reward score</span>
        texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
        pipe_outputs = reward_model(texts)
        rewards = [torch.tensor(output[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;score&quot;</span>]) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]
    
        <span class="hljs-comment">#### Run PPO step</span>
        stats = ppo_trainer.step(query_tensors, response_tensors, rewards)
        ppo_trainer.log_stats(stats, batch, rewards)

<span class="hljs-comment">#### Save model</span>
ppo_trainer.save_model(<span class="hljs-string">&quot;my_ppo_model&quot;</span>)`,wrap:!1}}),ce=new $e({props:{title:"Logging",local:"logging",headingTag:"h2"}}),he=new $e({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),ge=new b({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": PPOConfig = None"},{name:"model",val:": PreTrainedModelWrapper = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L109"}}),ue=new b({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L941",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),Te=new b({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1078",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),fe=new b({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1386"}}),ye=new b({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),we=new b({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Callable = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L431",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),be=new b({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": List = ['query', 'response']"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1313"}}),_e=new b({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1160"}}),Me=new b({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L376",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),Je=new b({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1249",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),ve=new b({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Pe=new b({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1032",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),Ie=new b({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = None"},{name:"query_dataset",val:": Optional = None"},{name:"reward_model",val:": Optional = None"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 256"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 1"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L34"}}),{c(){_=l("meta"),Re=a(),Ge=l("p"),Ve=a(),p(Z.$$.fragment),Ne=a(),O=l("p"),O.innerHTML=pn,Ae=a(),B=l("p"),B.innerHTML=mn,Xe=a(),p(q.$$.fragment),Ee=a(),L=l("p"),L.innerHTML=hn,Qe=a(),W=l("p"),W.innerHTML=gn,Se=a(),G=l("p"),G.innerHTML=un,De=a(),p(H.$$.fragment),Ye=a(),R=l("p"),R.textContent=Tn,Ke=a(),p(V.$$.fragment),et=a(),p(N.$$.fragment),tt=a(),A=l("p"),A.innerHTML=fn,nt=a(),p(X.$$.fragment),at=a(),E=l("p"),E.innerHTML=yn,rt=a(),p(Q.$$.fragment),ot=a(),S=l("p"),S.textContent=wn,st=a(),p(D.$$.fragment),lt=a(),Y=l("p"),Y.innerHTML=bn,it=a(),p(K.$$.fragment),dt=a(),ee=l("p"),ee.innerHTML=_n,ct=a(),p(te.$$.fragment),pt=a(),ne=l("p"),ne.innerHTML=Mn,mt=a(),p(ae.$$.fragment),ht=a(),p(re.$$.fragment),gt=a(),oe=l("p"),oe.innerHTML=Jn,ut=a(),se=l("p"),se.innerHTML=vn,Tt=a(),p(le.$$.fragment),ft=a(),ie=l("p"),ie.innerHTML=Pn,yt=a(),p(de.$$.fragment),wt=a(),p(ce.$$.fragment),bt=a(),pe=l("p"),pe.textContent=In,_t=a(),me=l("ul"),me.innerHTML=$n,Mt=a(),p(he.$$.fragment),Jt=a(),d=l("div"),p(ge.$$.fragment),Lt=a(),Ue=l("p"),Ue.innerHTML=Un,Wt=a(),v=l("div"),p(ue.$$.fragment),Gt=a(),xe=l("p"),xe.textContent=xn,Ht=a(),P=l("div"),p(Te.$$.fragment),Rt=a(),je=l("p"),je.textContent=jn,Vt=a(),I=l("div"),p(fe.$$.fragment),Nt=a(),Ce=l("p"),Ce.textContent=Cn,At=a(),$=l("div"),p(ye.$$.fragment),Xt=a(),ke=l("p"),ke.textContent=kn,Et=a(),U=l("div"),p(we.$$.fragment),Qt=a(),ze=l("p"),ze.innerHTML=zn,St=a(),x=l("div"),p(be.$$.fragment),Dt=a(),Fe=l("p"),Fe.textContent=Fn,Yt=a(),j=l("div"),p(_e.$$.fragment),Kt=a(),Ze=l("p"),Ze.textContent=Zn,en=a(),C=l("div"),p(Me.$$.fragment),tn=a(),Oe=l("p"),Oe.textContent=On,nn=a(),k=l("div"),p(Je.$$.fragment),an=a(),Be=l("p"),Be.textContent=Bn,rn=a(),z=l("div"),p(ve.$$.fragment),on=a(),qe=l("p"),qe.textContent=qn,sn=a(),F=l("div"),p(Pe.$$.fragment),ln=a(),Le=l("p"),Le.textContent=Ln,vt=a(),M=l("div"),p(Ie.$$.fragment),dn=a(),We=l("p"),We.textContent=Wn,Pt=a(),He=l("p"),this.h()},l(e){const t=An("svelte-u9bgzb",document.head);_=i(t,"META",{name:!0,content:!0}),t.forEach(n),Re=r(e),Ge=i(e,"P",{}),y(Ge).forEach(n),Ve=r(e),m(Z.$$.fragment,e),Ne=r(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1ulw62x"&&(O.innerHTML=pn),Ae=r(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1c2evbn"&&(B.innerHTML=mn),Xe=r(e),m(q.$$.fragment,e),Ee=r(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-r47fon"&&(L.innerHTML=hn),Qe=r(e),W=i(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-nw9p0e"&&(W.innerHTML=gn),Se=r(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-ew3j45"&&(G.innerHTML=un),De=r(e),m(H.$$.fragment,e),Ye=r(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1lutirw"&&(R.textContent=Tn),Ke=r(e),m(V.$$.fragment,e),et=r(e),m(N.$$.fragment,e),tt=r(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-kuth75"&&(A.innerHTML=fn),nt=r(e),m(X.$$.fragment,e),at=r(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-15i9f61"&&(E.innerHTML=yn),rt=r(e),m(Q.$$.fragment,e),ot=r(e),S=i(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-ft92fq"&&(S.textContent=wn),st=r(e),m(D.$$.fragment,e),lt=r(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-5saaij"&&(Y.innerHTML=bn),it=r(e),m(K.$$.fragment,e),dt=r(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1tdshp6"&&(ee.innerHTML=_n),ct=r(e),m(te.$$.fragment,e),pt=r(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1dqo05b"&&(ne.innerHTML=Mn),mt=r(e),m(ae.$$.fragment,e),ht=r(e),m(re.$$.fragment,e),gt=r(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1gfcgdl"&&(oe.innerHTML=Jn),ut=r(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-xqje4x"&&(se.innerHTML=vn),Tt=r(e),m(le.$$.fragment,e),ft=r(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-jd50df"&&(ie.innerHTML=Pn),yt=r(e),m(de.$$.fragment,e),wt=r(e),m(ce.$$.fragment,e),bt=r(e),pe=i(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1jybr47"&&(pe.textContent=In),_t=r(e),me=i(e,"UL",{"data-svelte-h":!0}),c(me)!=="svelte-1qs2o7q"&&(me.innerHTML=$n),Mt=r(e),m(he.$$.fragment,e),Jt=r(e),d=i(e,"DIV",{class:!0});var f=y(d);m(ge.$$.fragment,f),Lt=r(f),Ue=i(f,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-hys9rl"&&(Ue.innerHTML=Un),Wt=r(f),v=i(f,"DIV",{class:!0});var $t=y(v);m(ue.$$.fragment,$t),Gt=r($t),xe=i($t,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-185nst0"&&(xe.textContent=xn),$t.forEach(n),Ht=r(f),P=i(f,"DIV",{class:!0});var Ut=y(P);m(Te.$$.fragment,Ut),Rt=r(Ut),je=i(Ut,"P",{"data-svelte-h":!0}),c(je)!=="svelte-3nt516"&&(je.textContent=jn),Ut.forEach(n),Vt=r(f),I=i(f,"DIV",{class:!0});var xt=y(I);m(fe.$$.fragment,xt),Nt=r(xt),Ce=i(xt,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-3jfrz9"&&(Ce.textContent=Cn),xt.forEach(n),At=r(f),$=i(f,"DIV",{class:!0});var jt=y($);m(ye.$$.fragment,jt),Xt=r(jt),ke=i(jt,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-lcc1u3"&&(ke.textContent=kn),jt.forEach(n),Et=r(f),U=i(f,"DIV",{class:!0});var Ct=y(U);m(we.$$.fragment,Ct),Qt=r(Ct),ze=i(Ct,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1gqqzmu"&&(ze.innerHTML=zn),Ct.forEach(n),St=r(f),x=i(f,"DIV",{class:!0});var kt=y(x);m(be.$$.fragment,kt),Dt=r(kt),Fe=i(kt,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-ffqz5"&&(Fe.textContent=Fn),kt.forEach(n),Yt=r(f),j=i(f,"DIV",{class:!0});var zt=y(j);m(_e.$$.fragment,zt),Kt=r(zt),Ze=i(zt,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-febvhf"&&(Ze.textContent=Zn),zt.forEach(n),en=r(f),C=i(f,"DIV",{class:!0});var Ft=y(C);m(Me.$$.fragment,Ft),tn=r(Ft),Oe=i(Ft,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-1hbodkw"&&(Oe.textContent=On),Ft.forEach(n),nn=r(f),k=i(f,"DIV",{class:!0});var Zt=y(k);m(Je.$$.fragment,Zt),an=r(Zt),Be=i(Zt,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-1hfgx92"&&(Be.textContent=Bn),Zt.forEach(n),rn=r(f),z=i(f,"DIV",{class:!0});var Ot=y(z);m(ve.$$.fragment,Ot),on=r(Ot),qe=i(Ot,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-yrsdu6"&&(qe.textContent=qn),Ot.forEach(n),sn=r(f),F=i(f,"DIV",{class:!0});var Bt=y(F);m(Pe.$$.fragment,Bt),ln=r(Bt),Le=i(Bt,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-3k7k5e"&&(Le.textContent=Ln),Bt.forEach(n),f.forEach(n),vt=r(e),M=i(e,"DIV",{class:!0});var qt=y(M);m(Ie.$$.fragment,qt),dn=r(qt),We=i(qt,"P",{"data-svelte-h":!0}),c(We)!=="svelte-aondqr"&&(We.textContent=Wn),qt.forEach(n),Pt=r(e),He=i(e,"P",{}),y(He).forEach(n),this.h()},h(){w(_,"name","hf:doc:metadata"),w(_,"content",En),w(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,_),o(e,Re,t),o(e,Ge,t),o(e,Ve,t),h(Z,e,t),o(e,Ne,t),o(e,O,t),o(e,Ae,t),o(e,B,t),o(e,Xe,t),h(q,e,t),o(e,Ee,t),o(e,L,t),o(e,Qe,t),o(e,W,t),o(e,Se,t),o(e,G,t),o(e,De,t),h(H,e,t),o(e,Ye,t),o(e,R,t),o(e,Ke,t),h(V,e,t),o(e,et,t),h(N,e,t),o(e,tt,t),o(e,A,t),o(e,nt,t),h(X,e,t),o(e,at,t),o(e,E,t),o(e,rt,t),h(Q,e,t),o(e,ot,t),o(e,S,t),o(e,st,t),h(D,e,t),o(e,lt,t),o(e,Y,t),o(e,it,t),h(K,e,t),o(e,dt,t),o(e,ee,t),o(e,ct,t),h(te,e,t),o(e,pt,t),o(e,ne,t),o(e,mt,t),h(ae,e,t),o(e,ht,t),h(re,e,t),o(e,gt,t),o(e,oe,t),o(e,ut,t),o(e,se,t),o(e,Tt,t),h(le,e,t),o(e,ft,t),o(e,ie,t),o(e,yt,t),h(de,e,t),o(e,wt,t),h(ce,e,t),o(e,bt,t),o(e,pe,t),o(e,_t,t),o(e,me,t),o(e,Mt,t),h(he,e,t),o(e,Jt,t),o(e,d,t),h(ge,d,null),s(d,Lt),s(d,Ue),s(d,Wt),s(d,v),h(ue,v,null),s(v,Gt),s(v,xe),s(d,Ht),s(d,P),h(Te,P,null),s(P,Rt),s(P,je),s(d,Vt),s(d,I),h(fe,I,null),s(I,Nt),s(I,Ce),s(d,At),s(d,$),h(ye,$,null),s($,Xt),s($,ke),s(d,Et),s(d,U),h(we,U,null),s(U,Qt),s(U,ze),s(d,St),s(d,x),h(be,x,null),s(x,Dt),s(x,Fe),s(d,Yt),s(d,j),h(_e,j,null),s(j,Kt),s(j,Ze),s(d,en),s(d,C),h(Me,C,null),s(C,tn),s(C,Oe),s(d,nn),s(d,k),h(Je,k,null),s(k,an),s(k,Be),s(d,rn),s(d,z),h(ve,z,null),s(z,on),s(z,qe),s(d,sn),s(d,F),h(Pe,F,null),s(F,ln),s(F,Le),o(e,vt,t),o(e,M,t),h(Ie,M,null),s(M,dn),s(M,We),o(e,Pt,t),o(e,He,t),It=!0},p:Hn,i(e){It||(g(Z.$$.fragment,e),g(q.$$.fragment,e),g(H.$$.fragment,e),g(V.$$.fragment,e),g(N.$$.fragment,e),g(X.$$.fragment,e),g(Q.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(Te.$$.fragment,e),g(fe.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(be.$$.fragment,e),g(_e.$$.fragment,e),g(Me.$$.fragment,e),g(Je.$$.fragment,e),g(ve.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),It=!0)},o(e){u(Z.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(X.$$.fragment,e),u(Q.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(Te.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(_e.$$.fragment,e),u(Me.$$.fragment,e),u(Je.$$.fragment,e),u(ve.$$.fragment,e),u(Pe.$$.fragment,e),u(Ie.$$.fragment,e),It=!1},d(e){e&&(n(Re),n(Ge),n(Ve),n(Ne),n(O),n(Ae),n(B),n(Xe),n(Ee),n(L),n(Qe),n(W),n(Se),n(G),n(De),n(Ye),n(R),n(Ke),n(et),n(tt),n(A),n(nt),n(at),n(E),n(rt),n(ot),n(S),n(st),n(lt),n(Y),n(it),n(dt),n(ee),n(ct),n(pt),n(ne),n(mt),n(ht),n(gt),n(oe),n(ut),n(se),n(Tt),n(ft),n(ie),n(yt),n(wt),n(bt),n(pe),n(_t),n(me),n(Mt),n(Jt),n(d),n(vt),n(M),n(Pt),n(He)),n(_),T(Z,e),T(q,e),T(H,e),T(V,e),T(N,e),T(X,e),T(Q,e),T(D,e),T(K,e),T(te,e),T(ae,e),T(re,e),T(le,e),T(de,e),T(ce,e),T(he,e),T(ge),T(ue),T(Te),T(fe),T(ye),T(we),T(be),T(_e),T(Me),T(Je),T(ve),T(Pe),T(Ie)}}}const En='{"title":"PPO Trainer","local":"ppo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the PPOTrainer","local":"using-the-ppotrainer","sections":[{"title":"Initializing the PPOTrainer","local":"initializing-the-ppotrainer","sections":[],"depth":3},{"title":"Starting the training loop","local":"starting-the-training-loop","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2}],"depth":1}';function Qn(cn){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ta extends Vn{constructor(_){super(),Nn(this,_,Qn,Xn,Gn,{})}}export{ta as component};
