import{s as ls,o as os,n as as}from"../chunks/scheduler.53228c21.js";import{S as is,i as rs,e as a,s as l,c as p,h as ps,a as i,d as s,b as o,f as v,g as c,j as u,k as w,l as r,m as n,n as m,t as d,o as M,p as h}from"../chunks/index.100fac89.js";import{D as N}from"../chunks/Docstring.d46840f1.js";import{C as we}from"../chunks/CodeBlock.d30a6509.js";import{E as cs}from"../chunks/ExampleCodeBlock.220b4f6e.js";import{H as I,E as ms}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3fcbbc76.js";function ds(Ge){let b,Q="Examples:",T,_,j;return _=new we({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQWZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8oZnJhbWVzJTJDJTIwJTIybW9jaGkubXA0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_vae_tiling()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = pipe(prompt, num_inference_steps=<span class="hljs-number">28</span>, guidance_scale=<span class="hljs-number">3.5</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>)`,wrap:!1}}),{c(){b=a("p"),b.textContent=Q,T=l(),p(_.$$.fragment)},l(g){b=i(g,"P",{"data-svelte-h":!0}),u(b)!=="svelte-kvfsh7"&&(b.textContent=Q),T=o(g),c(_.$$.fragment,g)},m(g,J){n(g,b,J),n(g,T,J),m(_,g,J),j=!0},p:as,i(g){j||(d(_.$$.fragment,g),j=!0)},o(g){M(_.$$.fragment,g),j=!1},d(g){g&&(s(b),s(T)),h(_,g)}}}function Ms(Ge){let b,Q,T,_,j,g,J,At='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Be,C,Et="<p>Only a research preview of the model weights is available at the moment.</p>",Ae,$,Xt='<a href="https://huggingface.co/genmo/mochi-1-preview" rel="nofollow">Mochi 1</a> is a video generation model by Genmo with a strong focus on prompt adherence and motion quality. The model features a 10B parameter Asmmetric Diffusion Transformer (AsymmDiT) architecture, and uses non-square QKV and output projection layers to reduce inference memory requirements. A single T5-XXL model is used to encode prompts.',Ee,Y,Vt="<em>Mochi 1 preview is an open state-of-the-art video generation model with high-fidelity motion and strong prompt adherence in preliminary evaluation. This model dramatically closes the gap between closed and open video generation systems. The model is released under a permissive Apache 2.0 license.</em>",Xe,k,Rt='<p>Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.</p>',Ve,z,Re,H,xt="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",xe,F,Nt='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/mochi#diffusers.MochiPipeline">MochiPipeline</a> for inference with bitsandbytes.',Ne,q,Qe,S,$e,L,Qt="The following example will download the full precision <code>mochi-1-preview</code> weights and produce the highest quality results but will require at least 42GB VRAM to run.",Ye,P,ze,D,He,O,$t="The following example will use the <code>bfloat16</code> variant of the model and requires 22GB VRAM to run. There is a slight drop in the quality of the generated video as a result.",Fe,K,qe,ee,Se,te,Yt='The <a href="https://github.com/genmoai/mochi/tree/main" rel="nofollow">Genmo Mochi implementation</a> uses different precision values for each stage in the inference process. The text encoder and VAE use <code>torch.float32</code>, while the DiT uses <code>torch.bfloat16</code> with the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html#torch.nn.attention.sdpa_kernel" rel="nofollow">attention kernel</a> set to <code>EFFICIENT_ATTENTION</code>. Diffusers pipelines currently do not support setting different <code>dtypes</code> for different stages of the pipeline. In order to run inference in the same way as the original implementation, please refer to the following example.',Le,W,zt="<p>The original Mochi implementation zeros out empty prompts. However, enabling this option and placing the entire pipeline under autocast can lead to numerical overflows with the T5 text encoder.</p> <p>When enabling <code>force_zeros_for_empty_prompt</code>, it is recommended to run the text encoding step outside the autocast context in full precision.</p>",Pe,G,Ht="<p>Decoding the latents in full precision is very memory intensive. You will need at least 70GB VRAM to generate the 163 frames in this example. To reduce memory, either reduce the number of frames or run the decoding step in <code>torch.bfloat16</code>.</p>",De,se,Oe,ne,Ke,le,Ft="It is possible to split the large Mochi transformer across multiple GPUs using the <code>device_map</code> and <code>max_memory</code> options in <code>from_pretrained</code>. In the following example we split the model across two GPUs, each with 24GB of VRAM.",et,oe,tt,ae,st,ie,qt="You can use <code>from_single_file</code> to load the Mochi transformer in its original format.",nt,B,St="<p>Diffusers currently doesn’t support using the FP8 scaled versions of the Mochi single file checkpoints.</p>",lt,re,ot,pe,at,f,ce,gt,_e,Lt="The mochi pipeline for text-to-video generation.",bt,je,Pt='Reference: <a href="https://github.com/genmoai/models" rel="nofollow">https://github.com/genmoai/models</a>',wt,U,me,_t,Je,Dt="Function invoked when calling the pipeline for generation.",jt,A,Jt,E,de,Tt,Te,Ot=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ut,X,Me,vt,Ue,Kt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Zt,V,he,It,ve,es=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ct,R,ue,kt,Ze,ts=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Wt,x,fe,Gt,Ie,ss="Encodes the prompt into text encoder hidden states.",it,ye,rt,Z,ge,Bt,Ce,ns="Output class for Mochi pipelines.",pt,be,ct,We,mt;return j=new I({props:{title:"Mochi 1 Preview",local:"mochi-1-preview",headingTag:"h1"}}),z=new I({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),q=new we({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, MochiTransformer3DModel, MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = MochiTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = MochiPipeline.from_pretrained(
    <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

video = pipeline(
  <span class="hljs-string">&quot;Close-up of a cats eye, with the galaxy reflected in the cats eye. Ultra high resolution 4k.&quot;</span>,
  num_inference_steps=<span class="hljs-number">28</span>,
  guidance_scale=<span class="hljs-number">3.5</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;cat.mp4&quot;</span>)`,wrap:!1}}),S=new I({props:{title:"Generating videos with Mochi-1 Preview",local:"generating-videos-with-mochi-1-preview",headingTag:"h2"}}),P=new we({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIpJTBBJTBBJTIzJTIwRW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQSUwQXdpdGglMjB0b3JjaC5hdXRvY2FzdCglMjJjdWRhJTIyJTJDJTIwdG9yY2guYmZsb2F0MTYlMkMlMjBjYWNoZV9lbmFibGVkJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNEODUpLmZyYW1lcyU1QjAlNUQlMEElMEFleHBvcnRfdG9fdmlkZW8oZnJhbWVzJTJDJTIwJTIybW9jaGkubXA0JTIyJTJDJTIwZnBzJTNEMzAp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>)

<span class="hljs-comment"># Enable memory savings</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>

<span class="hljs-keyword">with</span> torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
      frames = pipe(prompt, num_frames=<span class="hljs-number">85</span>).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),D=new I({props:{title:"Using a lower precision variant to save memory",local:"using-a-lower-precision-variant-to-save-memory",headingTag:"h2"}}),K=new we({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMkMlMjB2YXJpYW50JTNEJTIyYmYxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBJTBBJTIzJTIwRW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQWZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDg1KS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMm1vY2hpLm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># Enable memory savings</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>
frames = pipe(prompt, num_frames=<span class="hljs-number">85</span>).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),ee=new I({props:{title:"Reproducing the results from the Genmo Mochi repo",local:"reproducing-the-results-from-the-genmo-mochi-repo",headingTag:"h2"}}),se=new we({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers.video_processor <span class="hljs-keyword">import</span> VideoProcessor

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, force_zeros_for_empty_prompt=<span class="hljs-literal">True</span>)
pipe.enable_vae_tiling()
pipe.enable_model_cpu_offload()

prompt =  <span class="hljs-string">&quot;An aerial shot of a parade of elephants walking across the African savannah. The camera showcases the herd and the surrounding landscape.&quot;</span>

<span class="hljs-keyword">with</span> torch.no_grad():
    prompt_embeds, prompt_attention_mask, negative_prompt_embeds, negative_prompt_attention_mask = (
        pipe.encode_prompt(prompt=prompt)
    )

<span class="hljs-keyword">with</span> torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16):
    <span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.EFFICIENT_ATTENTION):
        frames = pipe(
            prompt_embeds=prompt_embeds,
            prompt_attention_mask=prompt_attention_mask,
            negative_prompt_embeds=negative_prompt_embeds,
            negative_prompt_attention_mask=negative_prompt_attention_mask,
            guidance_scale=<span class="hljs-number">4.5</span>,
            num_inference_steps=<span class="hljs-number">64</span>,
            height=<span class="hljs-number">480</span>,
            width=<span class="hljs-number">848</span>,
            num_frames=<span class="hljs-number">163</span>,
            generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
            output_type=<span class="hljs-string">&quot;latent&quot;</span>,
            return_dict=<span class="hljs-literal">False</span>,
        )[<span class="hljs-number">0</span>]

video_processor = VideoProcessor(vae_scale_factor=<span class="hljs-number">8</span>)
has_latents_mean = <span class="hljs-built_in">hasattr</span>(pipe.vae.config, <span class="hljs-string">&quot;latents_mean&quot;</span>) <span class="hljs-keyword">and</span> pipe.vae.config.latents_mean <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>
has_latents_std = <span class="hljs-built_in">hasattr</span>(pipe.vae.config, <span class="hljs-string">&quot;latents_std&quot;</span>) <span class="hljs-keyword">and</span> pipe.vae.config.latents_std <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> has_latents_mean <span class="hljs-keyword">and</span> has_latents_std:
    latents_mean = (
        torch.tensor(pipe.vae.config.latents_mean).view(<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>).to(frames.device, frames.dtype)
    )
    latents_std = (
        torch.tensor(pipe.vae.config.latents_std).view(<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>).to(frames.device, frames.dtype)
    )
    frames = frames * latents_std / pipe.vae.config.scaling_factor + latents_mean
<span class="hljs-keyword">else</span>:
    frames = frames / pipe.vae.config.scaling_factor

<span class="hljs-keyword">with</span> torch.no_grad():
    video = pipe.vae.decode(frames.to(pipe.vae.dtype), return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

video = video_processor.postprocess_video(video)[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),ne=new I({props:{title:"Running inference with multiple GPUs",local:"running-inference-with-multiple-gpus",headingTag:"h2"}}),oe=new we({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline, MochiTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>
transformer = MochiTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;24GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;24GB&quot;</span>}
)

pipe = MochiPipeline.from_pretrained(model_id,  transformer=transformer)
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

<span class="hljs-keyword">with</span> torch.autocast(device_type=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
    frames = pipe(
        prompt=<span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>,
        negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
        height=<span class="hljs-number">480</span>,
        width=<span class="hljs-number">848</span>,
        num_frames=<span class="hljs-number">85</span>,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">4.5</span>,
        num_videos_per_prompt=<span class="hljs-number">1</span>,
        generator=torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
        max_sequence_length=<span class="hljs-number">256</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),ae=new I({props:{title:"Using single file loading with the Mochi Transformer",local:"using-single-file-loading-with-the-mochi-transformer",headingTag:"h2"}}),re=new we({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline, MochiTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/Comfy-Org/mochi_preview_repackaged/blob/main/split_files/diffusion_models/mochi_preview_bf16.safetensors&quot;</span>

transformer = MochiTransformer3DModel.from_pretrained(ckpt_path, torch_dtype=torch.bfloat16)

pipe = MochiPipeline.from_pretrained(model_id,  transformer=transformer)
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

<span class="hljs-keyword">with</span> torch.autocast(device_type=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
    frames = pipe(
        prompt=<span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>,
        negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
        height=<span class="hljs-number">480</span>,
        width=<span class="hljs-number">848</span>,
        num_frames=<span class="hljs-number">85</span>,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">4.5</span>,
        num_videos_per_prompt=<span class="hljs-number">1</span>,
        generator=torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
        max_sequence_length=<span class="hljs-number">256</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),pe=new I({props:{title:"MochiPipeline",local:"diffusers.MochiPipeline",headingTag:"h2"}}),ce=new N({props:{name:"class diffusers.MochiPipeline",anchor:"diffusers.MochiPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLMochi"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": MochiTransformer3DModel"},{name:"force_zeros_for_empty_prompt",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/mochi_transformer3d#diffusers.MochiTransformer3DModel">MochiTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.MochiPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MochiPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_mochi#diffusers.AutoencoderKLMochi">AutoencoderKLMochi</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.MochiPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.MochiPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.MochiPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L138"}}),me=new N({props:{name:"__call__",anchor:"diffusers.MochiPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 19"},{name:"num_inference_steps",val:": int = 64"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.MochiPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.default_height</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.MochiPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.default_width</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.MochiPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>19</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.MochiPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.MochiPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.MochiPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>4.5</code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.MochiPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.MochiPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.MochiPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.MochiPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MochiPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.MochiPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MochiPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.MochiPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.MochiPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.mochi.MochiPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.MochiPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.MochiPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.MochiPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.MochiPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>256</code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L497",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.mochi.MochiPipelineOutput</code> is returned, otherwise a <code>tuple</code>
is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.mochi.MochiPipelineOutput</code> or <code>tuple</code></p>
`}}),A=new cs({props:{anchor:"diffusers.MochiPipeline.__call__.example",$$slots:{default:[ds]},$$scope:{ctx:Ge}}}),de=new N({props:{name:"disable_vae_slicing",anchor:"diffusers.MochiPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L403"}}),Me=new N({props:{name:"disable_vae_tiling",anchor:"diffusers.MochiPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L430"}}),he=new N({props:{name:"enable_vae_slicing",anchor:"diffusers.MochiPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L390"}}),ue=new N({props:{name:"enable_vae_tiling",anchor:"diffusers.MochiPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L416"}}),fe=new N({props:{name:"encode_prompt",anchor:"diffusers.MochiPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.MochiPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MochiPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MochiPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.MochiPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L254"}}),ye=new I({props:{title:"MochiPipelineOutput",local:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",headingTag:"h2"}}),ge=new N({props:{name:"class diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",anchor:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_output.py#L9"}}),be=new ms({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/mochi.md"}}),{c(){b=a("meta"),Q=l(),T=a("p"),_=l(),p(j.$$.fragment),g=l(),J=a("div"),J.innerHTML=At,Be=l(),C=a("blockquote"),C.innerHTML=Et,Ae=l(),$=a("p"),$.innerHTML=Xt,Ee=l(),Y=a("p"),Y.innerHTML=Vt,Xe=l(),k=a("blockquote"),k.innerHTML=Rt,Ve=l(),p(z.$$.fragment),Re=l(),H=a("p"),H.textContent=xt,xe=l(),F=a("p"),F.innerHTML=Nt,Ne=l(),p(q.$$.fragment),Qe=l(),p(S.$$.fragment),$e=l(),L=a("p"),L.innerHTML=Qt,Ye=l(),p(P.$$.fragment),ze=l(),p(D.$$.fragment),He=l(),O=a("p"),O.innerHTML=$t,Fe=l(),p(K.$$.fragment),qe=l(),p(ee.$$.fragment),Se=l(),te=a("p"),te.innerHTML=Yt,Le=l(),W=a("blockquote"),W.innerHTML=zt,Pe=l(),G=a("blockquote"),G.innerHTML=Ht,De=l(),p(se.$$.fragment),Oe=l(),p(ne.$$.fragment),Ke=l(),le=a("p"),le.innerHTML=Ft,et=l(),p(oe.$$.fragment),tt=l(),p(ae.$$.fragment),st=l(),ie=a("p"),ie.innerHTML=qt,nt=l(),B=a("blockquote"),B.innerHTML=St,lt=l(),p(re.$$.fragment),ot=l(),p(pe.$$.fragment),at=l(),f=a("div"),p(ce.$$.fragment),gt=l(),_e=a("p"),_e.textContent=Lt,bt=l(),je=a("p"),je.innerHTML=Pt,wt=l(),U=a("div"),p(me.$$.fragment),_t=l(),Je=a("p"),Je.textContent=Dt,jt=l(),p(A.$$.fragment),Jt=l(),E=a("div"),p(de.$$.fragment),Tt=l(),Te=a("p"),Te.innerHTML=Ot,Ut=l(),X=a("div"),p(Me.$$.fragment),vt=l(),Ue=a("p"),Ue.innerHTML=Kt,Zt=l(),V=a("div"),p(he.$$.fragment),It=l(),ve=a("p"),ve.textContent=es,Ct=l(),R=a("div"),p(ue.$$.fragment),kt=l(),Ze=a("p"),Ze.textContent=ts,Wt=l(),x=a("div"),p(fe.$$.fragment),Gt=l(),Ie=a("p"),Ie.textContent=ss,it=l(),p(ye.$$.fragment),rt=l(),Z=a("div"),p(ge.$$.fragment),Bt=l(),Ce=a("p"),Ce.textContent=ns,pt=l(),p(be.$$.fragment),ct=l(),We=a("p"),this.h()},l(e){const t=ps("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(s),Q=o(e),T=i(e,"P",{}),v(T).forEach(s),_=o(e),c(j.$$.fragment,e),g=o(e),J=i(e,"DIV",{class:!0,"data-svelte-h":!0}),u(J)!=="svelte-si9ct8"&&(J.innerHTML=At),Be=o(e),C=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(C)!=="svelte-qhuwko"&&(C.innerHTML=Et),Ae=o(e),$=i(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-19k93hq"&&($.innerHTML=Xt),Ee=o(e),Y=i(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-16aanyn"&&(Y.innerHTML=Vt),Xe=o(e),k=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(k)!=="svelte-r1jcqf"&&(k.innerHTML=Rt),Ve=o(e),c(z.$$.fragment,e),Re=o(e),H=i(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1ou2pxc"&&(H.textContent=xt),xe=o(e),F=i(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-eo746u"&&(F.innerHTML=Nt),Ne=o(e),c(q.$$.fragment,e),Qe=o(e),c(S.$$.fragment,e),$e=o(e),L=i(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-w0d3wt"&&(L.innerHTML=Qt),Ye=o(e),c(P.$$.fragment,e),ze=o(e),c(D.$$.fragment,e),He=o(e),O=i(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-gdmfoq"&&(O.innerHTML=$t),Fe=o(e),c(K.$$.fragment,e),qe=o(e),c(ee.$$.fragment,e),Se=o(e),te=i(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1ke8pbr"&&(te.innerHTML=Yt),Le=o(e),W=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-1ksyvfb"&&(W.innerHTML=zt),Pe=o(e),G=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(G)!=="svelte-1gk69hm"&&(G.innerHTML=Ht),De=o(e),c(se.$$.fragment,e),Oe=o(e),c(ne.$$.fragment,e),Ke=o(e),le=i(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-14s0l4"&&(le.innerHTML=Ft),et=o(e),c(oe.$$.fragment,e),tt=o(e),c(ae.$$.fragment,e),st=o(e),ie=i(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-14rhs7p"&&(ie.innerHTML=qt),nt=o(e),B=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(B)!=="svelte-fqbcrw"&&(B.innerHTML=St),lt=o(e),c(re.$$.fragment,e),ot=o(e),c(pe.$$.fragment,e),at=o(e),f=i(e,"DIV",{class:!0});var y=v(f);c(ce.$$.fragment,y),gt=o(y),_e=i(y,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-11luvqp"&&(_e.textContent=Lt),bt=o(y),je=i(y,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1br2zew"&&(je.innerHTML=Pt),wt=o(y),U=i(y,"DIV",{class:!0});var ke=v(U);c(me.$$.fragment,ke),_t=o(ke),Je=i(ke,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-v78lg8"&&(Je.textContent=Dt),jt=o(ke),c(A.$$.fragment,ke),ke.forEach(s),Jt=o(y),E=i(y,"DIV",{class:!0});var dt=v(E);c(de.$$.fragment,dt),Tt=o(dt),Te=i(dt,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1s3c06i"&&(Te.innerHTML=Ot),dt.forEach(s),Ut=o(y),X=i(y,"DIV",{class:!0});var Mt=v(X);c(Me.$$.fragment,Mt),vt=o(Mt),Ue=i(Mt,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-pkn4ui"&&(Ue.innerHTML=Kt),Mt.forEach(s),Zt=o(y),V=i(y,"DIV",{class:!0});var ht=v(V);c(he.$$.fragment,ht),It=o(ht),ve=i(ht,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-14bnrb6"&&(ve.textContent=es),ht.forEach(s),Ct=o(y),R=i(y,"DIV",{class:!0});var ut=v(R);c(ue.$$.fragment,ut),kt=o(ut),Ze=i(ut,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1xwrf7t"&&(Ze.textContent=ts),ut.forEach(s),Wt=o(y),x=i(y,"DIV",{class:!0});var ft=v(x);c(fe.$$.fragment,ft),Gt=o(ft),Ie=i(ft,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-16q0ax1"&&(Ie.textContent=ss),ft.forEach(s),y.forEach(s),it=o(e),c(ye.$$.fragment,e),rt=o(e),Z=i(e,"DIV",{class:!0});var yt=v(Z);c(ge.$$.fragment,yt),Bt=o(yt),Ce=i(yt,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-srx61f"&&(Ce.textContent=ns),yt.forEach(s),pt=o(e),c(be.$$.fragment,e),ct=o(e),We=i(e,"P",{}),v(We).forEach(s),this.h()},h(){w(b,"name","hf:doc:metadata"),w(b,"content",hs),w(J,"class","flex flex-wrap space-x-1"),w(C,"class","tip"),w(k,"class","tip"),w(W,"class","tip"),w(G,"class","tip"),w(B,"class","tip"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,b),n(e,Q,t),n(e,T,t),n(e,_,t),m(j,e,t),n(e,g,t),n(e,J,t),n(e,Be,t),n(e,C,t),n(e,Ae,t),n(e,$,t),n(e,Ee,t),n(e,Y,t),n(e,Xe,t),n(e,k,t),n(e,Ve,t),m(z,e,t),n(e,Re,t),n(e,H,t),n(e,xe,t),n(e,F,t),n(e,Ne,t),m(q,e,t),n(e,Qe,t),m(S,e,t),n(e,$e,t),n(e,L,t),n(e,Ye,t),m(P,e,t),n(e,ze,t),m(D,e,t),n(e,He,t),n(e,O,t),n(e,Fe,t),m(K,e,t),n(e,qe,t),m(ee,e,t),n(e,Se,t),n(e,te,t),n(e,Le,t),n(e,W,t),n(e,Pe,t),n(e,G,t),n(e,De,t),m(se,e,t),n(e,Oe,t),m(ne,e,t),n(e,Ke,t),n(e,le,t),n(e,et,t),m(oe,e,t),n(e,tt,t),m(ae,e,t),n(e,st,t),n(e,ie,t),n(e,nt,t),n(e,B,t),n(e,lt,t),m(re,e,t),n(e,ot,t),m(pe,e,t),n(e,at,t),n(e,f,t),m(ce,f,null),r(f,gt),r(f,_e),r(f,bt),r(f,je),r(f,wt),r(f,U),m(me,U,null),r(U,_t),r(U,Je),r(U,jt),m(A,U,null),r(f,Jt),r(f,E),m(de,E,null),r(E,Tt),r(E,Te),r(f,Ut),r(f,X),m(Me,X,null),r(X,vt),r(X,Ue),r(f,Zt),r(f,V),m(he,V,null),r(V,It),r(V,ve),r(f,Ct),r(f,R),m(ue,R,null),r(R,kt),r(R,Ze),r(f,Wt),r(f,x),m(fe,x,null),r(x,Gt),r(x,Ie),n(e,it,t),m(ye,e,t),n(e,rt,t),n(e,Z,t),m(ge,Z,null),r(Z,Bt),r(Z,Ce),n(e,pt,t),m(be,e,t),n(e,ct,t),n(e,We,t),mt=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),A.$set(y)},i(e){mt||(d(j.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(A.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(ye.$$.fragment,e),d(ge.$$.fragment,e),d(be.$$.fragment,e),mt=!0)},o(e){M(j.$$.fragment,e),M(z.$$.fragment,e),M(q.$$.fragment,e),M(S.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(pe.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),M(A.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(he.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),M(ye.$$.fragment,e),M(ge.$$.fragment,e),M(be.$$.fragment,e),mt=!1},d(e){e&&(s(Q),s(T),s(_),s(g),s(J),s(Be),s(C),s(Ae),s($),s(Ee),s(Y),s(Xe),s(k),s(Ve),s(Re),s(H),s(xe),s(F),s(Ne),s(Qe),s($e),s(L),s(Ye),s(ze),s(He),s(O),s(Fe),s(qe),s(Se),s(te),s(Le),s(W),s(Pe),s(G),s(De),s(Oe),s(Ke),s(le),s(et),s(tt),s(st),s(ie),s(nt),s(B),s(lt),s(ot),s(at),s(f),s(it),s(rt),s(Z),s(pt),s(ct),s(We)),s(b),h(j,e),h(z,e),h(q,e),h(S,e),h(P,e),h(D,e),h(K,e),h(ee,e),h(se,e),h(ne,e),h(oe,e),h(ae,e),h(re,e),h(pe,e),h(ce),h(me),h(A),h(de),h(Me),h(he),h(ue),h(fe),h(ye,e),h(ge),h(be,e)}}}const hs='{"title":"Mochi 1 Preview","local":"mochi-1-preview","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"Generating videos with Mochi-1 Preview","local":"generating-videos-with-mochi-1-preview","sections":[],"depth":2},{"title":"Using a lower precision variant to save memory","local":"using-a-lower-precision-variant-to-save-memory","sections":[],"depth":2},{"title":"Reproducing the results from the Genmo Mochi repo","local":"reproducing-the-results-from-the-genmo-mochi-repo","sections":[],"depth":2},{"title":"Running inference with multiple GPUs","local":"running-inference-with-multiple-gpus","sections":[],"depth":2},{"title":"Using single file loading with the Mochi Transformer","local":"using-single-file-loading-with-the-mochi-transformer","sections":[],"depth":2},{"title":"MochiPipeline","local":"diffusers.MochiPipeline","sections":[],"depth":2},{"title":"MochiPipelineOutput","local":"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput","sections":[],"depth":2}],"depth":1}';function us(Ge){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends is{constructor(b){super(),rs(this,b,us,Ms,ls,{})}}export{js as component};
