import{s as ni,n as pi,o as oi}from"../chunks/scheduler.53228c21.js";import{S as ri,i as Mi,e as n,s as a,c as r,h as ci,a as p,d as l,b as i,f as ii,g as M,j as o,k as y,l as mi,m as s,n as c,t as m,o as d,p as u}from"../chunks/index.100fac89.js";import{C as di}from"../chunks/CopyLLMTxtMenu.2cdbb51f.js";import{C as h}from"../chunks/CodeBlock.d30a6509.js";import{H as Ut,E as ui}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3fcbbc76.js";function hi(Gs){let J,It,bt,Ct,C,Zt,Z,Bt,f,xs='<img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/>',Wt,w,ks=`<p>This document has now grown outdated given the emergence of existing evaluation frameworks for diffusion models for image generation. Please check
out works like <a href="https://crfm.stanford.edu/helm/heim/latest/" rel="nofollow">HEIM</a>, <a href="https://huggingface.co/papers/2307.06350" rel="nofollow">T2I-Compbench</a>,
<a href="https://huggingface.co/papers/2310.11513" rel="nofollow">GenEval</a>.</p>`,vt,B,Xs='Evaluation of generative models like <a href="https://huggingface.co/docs/diffusers/stable_diffusion" rel="nofollow">Stable Diffusion</a> is subjective in nature. But as practitioners and researchers, we often have to make careful choices amongst many different possibilities. So, when working with different generative models (like GANs, Diffusion, etc.), how do we choose one over the other?',_t,W,Vs=`Qualitative evaluation of such models can be error-prone and might incorrectly influence a decision.
However, quantitative metrics don’t necessarily correspond to image quality. So, usually, a combination
of both qualitative and quantitative evaluations provides a stronger signal when choosing one model
over the other.`,Gt,v,Rs="In this document, we provide a non-exhaustive overview of qualitative and quantitative methods to evaluate Diffusion models. For quantitative methods, we specifically focus on how to implement them alongside <code>diffusers</code>.",xt,_,Hs='The methods shown in this document can also be used to evaluate different <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/overview" rel="nofollow">noise schedulers</a> keeping the underlying generation model fixed.',kt,G,Xt,x,Fs="We cover Diffusion models with the following pipelines:",Vt,k,Ns='<li>Text-guided image generation (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img" rel="nofollow"><code>StableDiffusionPipeline</code></a>).</li> <li>Text-guided image generation, additionally conditioned on an input image (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img" rel="nofollow"><code>StableDiffusionImg2ImgPipeline</code></a> and <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix" rel="nofollow"><code>StableDiffusionInstructPix2PixPipeline</code></a>).</li> <li>Class-conditioned image generation models (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>).</li>',Rt,X,Ht,V,Es=`Qualitative evaluation typically involves human assessment of generated images. Quality is measured across aspects such as compositionality, image-text alignment, and spatial relations. Common prompts provide a degree of uniformity for subjective metrics.
DrawBench and PartiPrompts are prompt datasets used for qualitative benchmarking. DrawBench and PartiPrompts were introduced by <a href="https://imagen.research.google/" rel="nofollow">Imagen</a> and <a href="https://parti.research.google/" rel="nofollow">Parti</a> respectively.`,Ft,R,Ys='From the <a href="https://parti.research.google/" rel="nofollow">official Parti website</a>:',Nt,H,Qs="<p>PartiPrompts (P2) is a rich set of over 1600 prompts in English that we release as part of this work. P2 can be used to measure model capabilities across various categories and challenge aspects.</p>",Et,F,As='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts.png" alt="parti-prompts"/>',Yt,N,zs="PartiPrompts has the following columns:",Qt,E,Ss="<li>Prompt</li> <li>Category of the prompt (such as “Abstract”, “World Knowledge”, etc.)</li> <li>Challenge reflecting the difficulty (such as “Basic”, “Complex”, “Writing &amp; Symbols”, etc.)</li>",At,Y,$s="These benchmarks allow for side-by-side human evaluation of different image generation models.",zt,Q,Ls="For this, the 🧨 Diffusers team has built <strong>Open Parti Prompts</strong>, which is a community-driven qualitative benchmark based on Parti Prompts to compare state-of-the-art open-source diffusion models:",St,A,qs='<li><a href="https://huggingface.co/spaces/OpenGenAI/open-parti-prompts" rel="nofollow">Open Parti Prompts Game</a>: For 10 parti prompts, 4 generated images are shown and the user selects the image that suits the prompt best.</li> <li><a href="https://huggingface.co/spaces/OpenGenAI/parti-prompts-leaderboard" rel="nofollow">Open Parti Prompts Leaderboard</a>: The leaderboard comparing the currently best open-sourced diffusion models to each other.</li>',$t,z,Ps="To manually compare images, let’s see how we can use <code>diffusers</code> on a couple of PartiPrompts.",Lt,S,Ds='Below we show some prompts sampled across different challenges: Basic, Complex, Linguistic Structures, Imagination, and Writing &amp; Symbols. Here we are using PartiPrompts as a <a href="https://huggingface.co/datasets/nateraw/parti-prompts" rel="nofollow">dataset</a>.',qt,$,Pt,L,Ks='Now we can use these prompts to generate some images using Stable Diffusion (<a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 checkpoint</a>):',Dt,q,Kt,P,Os='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-14.png" alt="parti-prompts-14"/>',Ot,D,ea='We can also set <code>num_images_per_prompt</code> accordingly to compare different images for the same prompt. Running the same pipeline but with a different checkpoint (<a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">v1-5</a>), yields:',el,K,ta='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-15.png" alt="parti-prompts-15"/>',tl,O,la=`Once several images are generated from all the prompts using multiple models (under evaluation), these results are presented to human evaluators for scoring. For
more details on the DrawBench and PartiPrompts benchmarks, refer to their respective papers.`,ll,T,sa=`<p>It is useful to look at some inference samples while a model is training to measure the
training progress. In our <a href="https://github.com/huggingface/diffusers/tree/main/examples/" rel="nofollow">training scripts</a>, we support this utility with additional support for
logging to TensorBoard and Weights &amp; Biases.</p>`,sl,ee,al,te,aa="In this section, we will walk you through how to evaluate three different diffusion pipelines using:",il,le,ia="<li>CLIP score</li> <li>CLIP directional similarity</li> <li>FID</li>",nl,se,pl,ae,na='<a href="https://huggingface.co/papers/2104.08718" rel="nofollow">CLIP score</a> measures the compatibility of image-caption pairs. Higher CLIP scores imply higher compatibility 🔼. The CLIP score is a quantitative measurement of the qualitative concept “compatibility”. Image-caption pair compatibility can also be thought of as the semantic similarity between the image and the caption. CLIP score was found to have high correlation with human judgement.',ol,ie,pa='Let’s first load a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>:',rl,ne,Ml,pe,oa="Generate some images with multiple prompts:",cl,oe,ml,re,ra="And then, we calculate the CLIP score.",dl,Me,ul,ce,Ma="In the above example, we generated one image per prompt. If we generated multiple images per prompt, we would have to take the average score from the generated images per prompt.",hl,me,ca=`Now, if we wanted to compare two checkpoints compatible with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> we should pass a generator while calling the pipeline. First, we generate images with a
fixed seed with the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 Stable Diffusion checkpoint</a>:`,yl,de,Jl,ue,ma='Then we load the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">v1-5 checkpoint</a> to generate images:',fl,he,wl,ye,da="And finally, we compare their CLIP scores:",Tl,Je,jl,fe,ua='It seems like the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">v1-5</a> checkpoint performs better than its predecessor. Note, however, that the number of prompts we used to compute the CLIP scores is quite low. For a more practical evaluation, this number should be way higher, and the prompts should be diverse.',Ul,j,ha=`<p>By construction, there are some limitations in this score. The captions in the training dataset
were crawled from the web and extracted from <code>alt</code> and similar tags associated an image on the internet.
They are not necessarily representative of what a human being would use to describe an image. Hence we
had to “engineer” some prompts here.</p>`,bl,we,gl,Te,ya='In this case, we condition the generation pipeline with an input image as well as a text prompt. Let’s take the <a href="/docs/diffusers/main/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>, as an example. It takes an edit instruction as an input prompt and an input image to be edited.',Il,je,Ja="Here is one example:",Cl,Ue,fa='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-instruction.png" alt="edit-instruction"/>',Zl,be,wa='One strategy to evaluate such a model is to measure the consistency of the change between the two images (in <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">CLIP</a> space) with the change between the two image captions (as shown in <a href="https://huggingface.co/papers/2108.00946" rel="nofollow">CLIP-Guided Domain Adaptation of Image Generators</a>). This is referred to as the ”<strong>CLIP directional similarity</strong>“.',Bl,ge,Ta="<li>Caption 1 corresponds to the input image (image 1) that is to be edited.</li> <li>Caption 2 corresponds to the edited image (image 2). It should reflect the edit instruction.</li>",Wl,Ie,ja="Following is a pictorial overview:",vl,Ce,Ua='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-consistency.png" alt="edit-consistency"/>',_l,Ze,ba="We have prepared a mini dataset to implement this metric. Let’s first load the dataset.",Gl,Be,xl,We,kl,ve,ga="Here we have:",Xl,_e,Ia="<li><code>input</code> is a caption corresponding to the <code>image</code>.</li> <li><code>edit</code> denotes the edit instruction.</li> <li><code>output</code> denotes the modified caption reflecting the <code>edit</code> instruction.</li>",Vl,Ge,Ca="Let’s take a look at a sample.",Rl,xe,Hl,ke,Fl,Xe,Za="And here is the image:",Nl,Ve,El,Re,Ba='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-dataset.png" alt="edit-dataset"/>',Yl,He,Wa="We will first edit the images of our dataset with the edit instruction and compute the directional similarity.",Ql,Fe,va='Let’s first load the <a href="/docs/diffusers/main/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>:',Al,Ne,zl,Ee,_a="Now, we perform the edits:",Sl,Ye,$l,Qe,Ga="To measure the directional similarity, we first load CLIP’s image and text encoders:",Ll,Ae,ql,ze,xa='Notice that we are using a particular CLIP checkpoint, i.e., <code>openai/clip-vit-large-patch14</code>. This is because the Stable Diffusion pre-training was performed with this CLIP variant. For more details, refer to the <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">documentation</a>.',Pl,Se,ka="Next, we prepare a PyTorch <code>nn.Module</code> to compute directional similarity:",Dl,$e,Kl,Le,Xa="Let’s put <code>DirectionalSimilarity</code> to use now.",Ol,qe,es,Pe,Va="Like the CLIP Score, the higher the CLIP directional similarity, the better it is.",ts,De,Ra="It should be noted that the <code>StableDiffusionInstructPix2PixPipeline</code> exposes two arguments, namely, <code>image_guidance_scale</code> and <code>guidance_scale</code> that let you control the quality of the final edited image. We encourage you to experiment with these two arguments and see the impact of that on the directional similarity.",ls,Ke,Ha="We can extend the idea of this metric to measure how similar the original image and edited version are. To do that, we can just do <code>F.cosine_similarity(img_feat_two, img_feat_one)</code>. For these kinds of edits, we would still want the primary semantics of the images to be preserved as much as possible, i.e., a high similarity score.",ss,Oe,Fa='We can use these metrics for similar pipelines such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix_zero#diffusers.StableDiffusionPix2PixZeroPipeline" rel="nofollow"><code>StableDiffusionPix2PixZeroPipeline</code></a>.',as,U,Na="<p>Both CLIP score and CLIP direction similarity rely on the CLIP model, which can make the evaluations biased.</p>",is,et,Ea='<strong><em>Extending metrics like IS, FID (discussed later), or KID can be difficult</em></strong> when the model under evaluation was pre-trained on a large image-captioning dataset (such as the <a href="https://laion.ai/blog/laion-5b/" rel="nofollow">LAION-5B dataset</a>). This is because underlying these metrics is an InceptionNet (pre-trained on the ImageNet-1k dataset) used for extracting intermediate image features. The pre-training dataset of Stable Diffusion may have limited overlap with the pre-training dataset of InceptionNet, so it is not a good candidate here for feature extraction.',ns,tt,Ya='<strong><em>Using the above metrics helps evaluate models that are class-conditioned. For example, <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow">DiT</a>. It was pre-trained being conditioned on the ImageNet-1k classes.</em></strong>',ps,lt,os,st,Qa='Class-conditioned generative models are usually pre-trained on a class-labeled dataset such as <a href="https://huggingface.co/datasets/imagenet-1k" rel="nofollow">ImageNet-1k</a>. Popular metrics for evaluating these models include Fréchet Inception Distance (FID), Kernel Inception Distance (KID), and Inception Score (IS). In this document, we focus on FID (<a href="https://huggingface.co/papers/1706.08500" rel="nofollow">Heusel et al.</a>). We show how to compute it with the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>, which uses the <a href="https://huggingface.co/papers/2212.09748" rel="nofollow">DiT model</a> under the hood.',rs,at,Aa='FID aims to measure how similar are two datasets of images. As per <a href="https://mmgeneration.readthedocs.io/en/latest/quick_run.html#fid" rel="nofollow">this resource</a>:',Ms,it,za="<p>Fréchet Inception Distance is a measure of similarity between two datasets of images. It was shown to correlate well with the human judgment of visual quality and is most often used to evaluate the quality of samples of Generative Adversarial Networks. FID is calculated by computing the Fréchet distance between two Gaussians fitted to feature representations of the Inception network.</p>",cs,nt,Sa="These two datasets are essentially the dataset of real images and the dataset of fake images (generated images in our case). FID is usually calculated with two large datasets. However, for this document, we will work with two mini datasets.",ms,pt,$a="Let’s first download a few images from the ImageNet-1k training set:",ds,ot,us,rt,hs,Mt,La="These are 10 images from the following ImageNet-1k classes: “cassette_player”, “chain_saw” (x2), “church”, “gas_pump” (x3), “parachute” (x2), and “tench”.",ys,b,qa='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/real-images.png" alt="real-images"/><br/> <em>Real images.</em>',Js,ct,Pa="Now that the images are loaded, let’s apply some lightweight pre-processing on them to use them for FID calculation.",fs,mt,ws,dt,Da='We now load the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a> to generate images conditioned on the above-mentioned classes.',Ts,ut,js,ht,Ka='Now, we can compute the FID using <a href="https://torchmetrics.readthedocs.io/" rel="nofollow"><code>torchmetrics</code></a>.',Us,yt,bs,Jt,Oa="The lower the FID, the better it is. Several things can influence FID here:",gs,ft,ei="<li>Number of images (both real and fake)</li> <li>Randomness induced in the diffusion process</li> <li>Number of inference steps in the diffusion process</li> <li>The scheduler being used in the diffusion process</li>",Is,wt,ti="For the last two points, it is, therefore, a good practice to run the evaluation across different seeds and inference steps, and then report an average result.",Cs,g,li=`<p>FID results tend to be fragile as they depend on a lot of factors:</p> <ul><li>The specific Inception model used during computation.</li> <li>The implementation accuracy of the computation.</li> <li>The image format (not the same if we start from PNGs vs JPGs).</li></ul> <p>Keeping that in mind, FID is often most useful when comparing similar runs, but it is
hard to reproduce paper results unless the authors carefully disclose the FID
measurement code.</p> <p>These points apply to other related metrics too, such as KID and IS.</p>`,Zs,Tt,si="As a final step, let’s visually inspect the <code>fake_images</code>.",Bs,I,ai='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/fake-images.png" alt="fake-images"/><br/> <em>Fake images.</em>',Ws,jt,vs,gt,_s;return C=new di({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),Z=new Ut({props:{title:"Evaluating Diffusion Models",local:"evaluating-diffusion-models",headingTag:"h1"}}),G=new Ut({props:{title:"Scenarios",local:"scenarios",headingTag:"h2"}}),X=new Ut({props:{title:"Qualitative Evaluation",local:"qualitative-evaluation",headingTag:"h2"}}),$=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJuYXRlcmF3JTJGcGFydGktcHJvbXB0cyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMHByb21wdHMuc2h1ZmZsZSgpJTBBJTIzJTIwc2FtcGxlX3Byb21wdHMlMjAlM0QlMjAlNUJwcm9tcHRzJTVCaSU1RCU1QiUyMlByb21wdCUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBJTBBJTIzJTIwRml4aW5nJTIwdGhlc2UlMjBzYW1wbGUlMjBwcm9tcHRzJTIwaW4lMjB0aGUlMjBpbnRlcmVzdCUyMG9mJTIwcmVwcm9kdWNpYmlsaXR5LiUwQXNhbXBsZV9wcm9tcHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNvcmdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGhvdCUyMGFpciUyMGJhbGxvb24lMjB3aXRoJTIwYSUyMHlpbi15YW5nJTIwc3ltYm9sJTJDJTIwd2l0aCUyMHRoZSUyMG1vb24lMjB2aXNpYmxlJTIwaW4lMjB0aGUlMjBkYXl0aW1lJTIwc2t5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNhciUyMHdpdGglMjBubyUyMHdpbmRvd3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhJTIwY3ViZSUyMG1hZGUlMjBvZiUyMHBvcmN1cGluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCdUaGUlMjBzYXlpbmclMjAlMjJCRSUyMEVYQ0VMTEVOVCUyMFRPJTIwRUFDSCUyME9USEVSJTIyJTIwd3JpdHRlbiUyMG9uJTIwYSUyMHJlZCUyMGJyaWNrJTIwd2FsbCUyMHdpdGglMjBhJTIwZ3JhZmZpdGklMjBpbWFnZSUyMG9mJTIwYSUyMGdyZWVuJTIwYWxpZW4lMjB3ZWFyaW5nJTIwYSUyMHR1eGVkby4lMjBBJTIweWVsbG93JTIwZmlyZSUyMGh5ZHJhbnQlMjBpcyUyMG9uJTIwYSUyMHNpZGV3YWxrJTIwaW4lMjB0aGUlMjBmb3JlZ3JvdW5kLiclMkMlMEElNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># prompts = load_dataset(&quot;nateraw/parti-prompts&quot;, split=&quot;train&quot;)</span>
<span class="hljs-comment"># prompts = prompts.shuffle()</span>
<span class="hljs-comment"># sample_prompts = [prompts[i][&quot;Prompt&quot;] for i in range(5)]</span>

<span class="hljs-comment"># Fixing these sample prompts in the interest of reproducibility.</span>
sample_prompts = [
    <span class="hljs-string">&quot;a corgi&quot;</span>,
    <span class="hljs-string">&quot;a hot air balloon with a yin-yang symbol, with the moon visible in the daytime sky&quot;</span>,
    <span class="hljs-string">&quot;a car with no windows&quot;</span>,
    <span class="hljs-string">&quot;a cube made of porcupine&quot;</span>,
    <span class="hljs-string">&#x27;The saying &quot;BE EXCELLENT TO EACH OTHER&quot; written on a red brick wall with a graffiti image of a green alien wearing a tuxedo. A yellow fire hydrant is on a sidewalk in the foreground.&#x27;</span>,
]`,wrap:!1}}),q=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzZWVkJTIwJTNEJTIwMCUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwc2RfcGlwZWxpbmUoc2FtcGxlX3Byb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch

seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(sample_prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator).images`,wrap:!1}}),ee=new Ut({props:{title:"Quantitative Evaluation",local:"quantitative-evaluation",headingTag:"h2"}}),se=new Ut({props:{title:"Text-guided image generation",local:"text-guided-image-generation",headingTag:"h3"}}),ne=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXNkX3BpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
sd_pipeline = StableDiffusionPipeline.from_pretrained(model_ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),oe=new h({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwaGlnaCUyMHRlY2glMjBzb2xhcnB1bmslMjB1dG9waWElMjBpbiUyMHRoZSUyMEFtYXpvbiUyMHJhaW5mb3Jlc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwcGlrYWNodSUyMGZpbmUlMjBkaW5pbmclMjB3aXRoJTIwYSUyMHZpZXclMjB0byUyMHRoZSUyMEVpZmZlbCUyMFRvd2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG1lY2hhJTIwcm9ib3QlMjBpbiUyMGElMjBmYXZlbGElMjBpbiUyMGV4cHJlc3Npb25pc3QlMjBzdHlsZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmFuJTIwaW5zZWN0JTIwcm9ib3QlMjBwcmVwYXJpbmclMjBhJTIwZGVsaWNpb3VzJTIwbWVhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBzbWFsbCUyMGNhYmluJTIwb24lMjB0b3AlMjBvZiUyMGElMjBzbm93eSUyMG1vdW50YWluJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwRGlzbmV5JTJDJTIwYXJ0c3RhdGlvbiUyMiUyQyUwQSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2VzJTBBJTBBcHJpbnQoaW1hZ2VzLnNoYXBlKSUwQSUyMyUyMCg2JTJDJTIwNTEyJTJDJTIwNTEyJTJDJTIwMyk=",highlighted:`prompts = [
    <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>,
    <span class="hljs-string">&quot;A high tech solarpunk utopia in the Amazon rainforest&quot;</span>,
    <span class="hljs-string">&quot;A pikachu fine dining with a view to the Eiffel Tower&quot;</span>,
    <span class="hljs-string">&quot;A mecha robot in a favela in expressionist style&quot;</span>,
    <span class="hljs-string">&quot;an insect robot preparing a delicious meal&quot;</span>,
    <span class="hljs-string">&quot;A small cabin on top of a snowy mountain in the style of Disney, artstation&quot;</span>,
]

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images

<span class="hljs-built_in">print</span>(images.shape)
<span class="hljs-comment"># (6, 512, 512, 3)</span>`,wrap:!1}}),Me=new h({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5mdW5jdGlvbmFsLm11bHRpbW9kYWwlMjBpbXBvcnQlMjBjbGlwX3Njb3JlJTBBZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEFjbGlwX3Njb3JlX2ZuJTIwJTNEJTIwcGFydGlhbChjbGlwX3Njb3JlJTJDJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTIyb3BlbmFpJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JTIyKSUwQSUwQWRlZiUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VzX2ludCUyMCUzRCUyMChpbWFnZXMlMjAqJTIwMjU1KS5hc3R5cGUoJTIydWludDglMjIpJTBBJTIwJTIwJTIwJTIwY2xpcF9zY29yZSUyMCUzRCUyMGNsaXBfc2NvcmVfZm4odG9yY2guZnJvbV9udW1weShpbWFnZXNfaW50KS5wZXJtdXRlKDAlMkMlMjAzJTJDJTIwMSUyQyUyMDIpJTJDJTIwcHJvbXB0cykuZGV0YWNoKCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByb3VuZChmbG9hdChjbGlwX3Njb3JlKSUyQyUyMDQpJTBBJTBBc2RfY2xpcF9zY29yZSUyMCUzRCUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTBBcHJpbnQoZiUyMkNMSVAlMjBzY29yZSUzQSUyMCU3QnNkX2NsaXBfc2NvcmUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMHNjb3JlJTNBJTIwMzUuNzAzOA==",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.functional.multimodal <span class="hljs-keyword">import</span> clip_score
<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

clip_score_fn = partial(clip_score, model_name_or_path=<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_clip_score</span>(<span class="hljs-params">images, prompts</span>):
    images_int = (images * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
    clip_score = clip_score_fn(torch.from_numpy(images_int).permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>), prompts).detach()
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(clip_score), <span class="hljs-number">4</span>)

sd_clip_score = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP score: <span class="hljs-subst">{sd_clip_score}</span>&quot;</span>)
<span class="hljs-comment"># CLIP score: 35.7038</span>`,wrap:!1}}),de=new h({props:{code:"c2VlZCUyMCUzRCUyMDAlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZChzZWVkKSUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2Vz",highlighted:`seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`,wrap:!1}}),he=new h({props:{code:"bW9kZWxfY2twdF8xXzUlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzZF9waXBlbGluZV8xXzUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2twdF8xXzUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2VzXzFfNSUyMCUzRCUyMHNkX3BpcGVsaW5lXzFfNShwcm9tcHRzJTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIpLmltYWdlcw==",highlighted:`model_ckpt_1_5 = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
sd_pipeline_1_5 = StableDiffusionPipeline.from_pretrained(model_ckpt_1_5, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

images_1_5 = sd_pipeline_1_5(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`,wrap:!1}}),Je=new h({props:{code:"c2RfY2xpcF9zY29yZV8xXzQlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXMlMkMlMjBwcm9tcHRzKSUwQXByaW50KGYlMjJDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAlN0JzZF9jbGlwX3Njb3JlXzFfNCU3RCUyMiklMEElMjMlMjBDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAzNC45MTAyJTBBJTBBc2RfY2xpcF9zY29yZV8xXzUlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXNfMV81JTJDJTIwcHJvbXB0cyklMEFwcmludChmJTIyQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwJTdCc2RfY2xpcF9zY29yZV8xXzUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwMzYuMjEzNw==",highlighted:`sd_clip_score_1_4 = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-4: <span class="hljs-subst">{sd_clip_score_1_4}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-4: 34.9102</span>

sd_clip_score_1_5 = calculate_clip_score(images_1_5, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-5: <span class="hljs-subst">{sd_clip_score_1_5}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-5: 36.2137</span>`,wrap:!1}}),we=new Ut({props:{title:"Image-conditioned text-to-image generation",local:"image-conditioned-text-to-image-generation",headingTag:"h3"}}),Be=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYXlha3BhdWwlMkZpbnN0cnVjdHBpeDJwaXgtZGVtbyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;sayakpaul/instructpix2pix-demo&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset.features`,wrap:!1}}),We=new h({props:{code:"JTdCJ2lucHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2VkaXQnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnb3V0cHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2ltYWdlJyUzQSUyMEltYWdlKGRlY29kZSUzRFRydWUlMkMlMjBpZCUzRE5vbmUpJTdE",highlighted:`{<span class="hljs-string">&#x27;input&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;edit&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;output&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;image&#x27;</span>: Image(decode=True, <span class="hljs-built_in">id</span>=None)}`,wrap:!1}}),xe=new h({props:{code:"aWR4JTIwJTNEJTIwMCUwQXByaW50KGYlMjJPcmlnaW5hbCUyMGNhcHRpb24lM0ElMjAlN0JkYXRhc2V0JTVCaWR4JTVEJTVCJ2lucHV0JyU1RCU3RCUyMiklMEFwcmludChmJTIyRWRpdCUyMGluc3RydWN0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidlZGl0JyU1RCU3RCUyMiklMEFwcmludChmJTIyTW9kaWZpZWQlMjBjYXB0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidvdXRwdXQnJTVEJTdEJTIyKQ==",highlighted:`idx = <span class="hljs-number">0</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Original caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;input&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Edit instruction: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;edit&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Modified caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;output&#x27;</span>]}</span>&quot;</span>)`,wrap:!1}}),ke=new h({props:{code:"T3JpZ2luYWwlMjBjYXB0aW9uJTNBJTIwMi4lMjBGQVJPRSUyMElTTEFORFMlM0ElMjBBbiUyMGFyY2hpcGVsYWdvJTIwb2YlMjAxOCUyMG1vdW50YWlub3VzJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwRmFyb2UlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyclMEFFZGl0JTIwaW5zdHJ1Y3Rpb24lM0ElMjBtYWtlJTIwdGhlJTIwaXNsZXMlMjBhbGwlMjB3aGl0ZSUyMG1hcmJsZSUwQU1vZGlmaWVkJTIwY2FwdGlvbiUzQSUyMDIuJTIwV0hJVEUlMjBNQVJCTEUlMjBJU0xBTkRTJTNBJTIwQW4lMjBhcmNoaXBlbGFnbyUyMG9mJTIwMTglMjBtb3VudGFpbm91cyUyMHdoaXRlJTIwbWFyYmxlJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwV2hpdGUlMjBNYXJibGUlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyc=",highlighted:`Original caption: 2. FAROE ISLANDS: An archipelago of 18 mountainous isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the Faroe Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>
Edit instruction: make the isles all white marble
Modified caption: 2. WHITE MARBLE ISLANDS: An archipelago of 18 mountainous white marble isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the White Marble Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>`,wrap:!1}}),Ve=new h({props:{code:"ZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVE",highlighted:'dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),Ne=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lJTBBJTBBaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ0aW1icm9va3MlMkZpbnN0cnVjdC1waXgycGl4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline

instruct_pix2pix_pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(
    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ye=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGluc3RydWN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEaW5wdXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFpbnB1dF9pbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFvcmlnaW5hbF9jYXB0aW9ucyUyMCUzRCUyMCU1QiU1RCUwQW1vZGlmaWVkX2NhcHRpb25zJTIwJTNEJTIwJTVCJTVEJTBBZWRpdGVkX2ltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGlkeCUyMGluJTIwcmFuZ2UobGVuKGRhdGFzZXQpKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0X2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMGRhdGFzZXQlNUJpZHglNUQlNUIlMjJlZGl0JTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGVkaXRfaW5zdHJ1Y3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzLmFwcGVuZChucC5hcnJheShpbnB1dF9pbWFnZSkpJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfY2FwdGlvbnMuYXBwZW5kKGRhdGFzZXQlNUJpZHglNUQlNUIlMjJpbnB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9ucy5hcHBlbmQoZGF0YXNldCU1QmlkeCU1RCU1QiUyMm91dHB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBlZGl0ZWRfaW1hZ2VzLmFwcGVuZChlZGl0ZWRfaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, instruction</span>):
    image = instruct_pix2pix_pipeline(
        instruction,
        image=input_image,
        output_type=<span class="hljs-string">&quot;np&quot;</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> image

input_images = []
original_captions = []
modified_captions = []
edited_images = []

<span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
    input_image = dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]
    edit_instruction = dataset[idx][<span class="hljs-string">&quot;edit&quot;</span>]
    edited_image = edit_image(input_image, edit_instruction)

    input_images.append(np.array(input_image))
    original_captions.append(dataset[idx][<span class="hljs-string">&quot;input&quot;</span>])
    modified_captions.append(dataset[idx][<span class="hljs-string">&quot;output&quot;</span>])
    edited_images.append(edited_image)`,wrap:!1}}),Ae=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBDTElQVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFRleHRNb2RlbFdpdGhQcm9qZWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBDTElQSW1hZ2VQcm9jZXNzb3IlMkMlMEEpJTBBJTBBY2xpcF9pZCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjbGlwX2lkKSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoY2xpcF9pZCkudG8oJTIyY3VkYSUyMiklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBDTElQSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKGNsaXBfaWQpJTBBaW1hZ2VfZW5jb2RlciUyMCUzRCUyMENMSVBWaXNpb25Nb2RlbFdpdGhQcm9qZWN0aW9uLmZyb21fcHJldHJhaW5lZChjbGlwX2lkKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    CLIPTokenizer,
    CLIPTextModelWithProjection,
    CLIPVisionModelWithProjection,
    CLIPImageProcessor,
)

clip_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
tokenizer = CLIPTokenizer.from_pretrained(clip_id)
text_encoder = CLIPTextModelWithProjection.from_pretrained(clip_id).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image_processor = CLIPImageProcessor.from_pretrained(clip_id)
image_encoder = CLIPVisionModelWithProjection.from_pretrained(clip_id).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),$e=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DirectionalSimilarity</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, tokenizer, text_encoder, image_processor, image_encoder</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.tokenizer = tokenizer
        self.text_encoder = text_encoder
        self.image_processor = image_processor
        self.image_encoder = image_encoder

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">self, image</span>):
        image = self.image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;pixel_values&quot;</span>]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: image.to(<span class="hljs-string">&quot;cuda&quot;</span>)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_text</span>(<span class="hljs-params">self, text</span>):
        inputs = self.tokenizer(
            text,
            max_length=self.tokenizer.model_max_length,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;input_ids&quot;</span>: inputs.input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_image</span>(<span class="hljs-params">self, image</span>):
        preprocessed_image = self.preprocess_image(image)
        image_features = self.image_encoder(**preprocessed_image).image_embeds
        image_features = image_features / image_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> image_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_text</span>(<span class="hljs-params">self, text</span>):
        tokenized_text = self.tokenize_text(text)
        text_features = self.text_encoder(**tokenized_text).text_embeds
        text_features = text_features / text_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> text_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_directional_similarity</span>(<span class="hljs-params">self, img_feat_one, img_feat_two, text_feat_one, text_feat_two</span>):
        sim_direction = F.cosine_similarity(img_feat_two - img_feat_one, text_feat_two - text_feat_one)
        <span class="hljs-keyword">return</span> sim_direction

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, image_one, image_two, caption_one, caption_two</span>):
        img_feat_one = self.encode_image(image_one)
        img_feat_two = self.encode_image(image_two)
        text_feat_one = self.encode_text(caption_one)
        text_feat_two = self.encode_text(caption_two)
        directional_similarity = self.compute_directional_similarity(
            img_feat_one, img_feat_two, text_feat_one, text_feat_two
        )
        <span class="hljs-keyword">return</span> directional_similarity`,wrap:!1}}),qe=new h({props:{code:"ZGlyX3NpbWlsYXJpdHklMjAlM0QlMjBEaXJlY3Rpb25hbFNpbWlsYXJpdHkodG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTJDJTIwaW1hZ2VfZW5jb2RlciklMEFzY29yZXMlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oaW5wdXRfaW1hZ2VzKSklM0ElMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGlucHV0X2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9jYXB0aW9uJTIwJTNEJTIwb3JpZ2luYWxfY2FwdGlvbnMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdGVkX2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9uJTIwJTNEJTIwbW9kaWZpZWRfY2FwdGlvbnMlNUJpJTVEJTBBJTBBJTIwJTIwJTIwJTIwc2ltaWxhcml0eV9zY29yZSUyMCUzRCUyMGRpcl9zaW1pbGFyaXR5KG9yaWdpbmFsX2ltYWdlJTJDJTIwZWRpdGVkX2ltYWdlJTJDJTIwb3JpZ2luYWxfY2FwdGlvbiUyQyUyMG1vZGlmaWVkX2NhcHRpb24pJTBBJTIwJTIwJTIwJTIwc2NvcmVzLmFwcGVuZChmbG9hdChzaW1pbGFyaXR5X3Njb3JlLmRldGFjaCgpLmNwdSgpKSklMEElMEFwcmludChmJTIyQ0xJUCUyMGRpcmVjdGlvbmFsJTIwc2ltaWxhcml0eSUzQSUyMCU3Qm5wLm1lYW4oc2NvcmVzKSU3RCUyMiklMEElMjMlMjBDTElQJTIwZGlyZWN0aW9uYWwlMjBzaW1pbGFyaXR5JTNBJTIwMC4wNzk3OTc2NTUzNDQwMDk0",highlighted:`dir_similarity = DirectionalSimilarity(tokenizer, text_encoder, image_processor, image_encoder)
scores = []

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(input_images)):
    original_image = input_images[i]
    original_caption = original_captions[i]
    edited_image = edited_images[i]
    modified_caption = modified_captions[i]

    similarity_score = dir_similarity(original_image, edited_image, original_caption, modified_caption)
    scores.append(<span class="hljs-built_in">float</span>(similarity_score.detach().cpu()))

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP directional similarity: <span class="hljs-subst">{np.mean(scores)}</span>&quot;</span>)
<span class="hljs-comment"># CLIP directional similarity: 0.0797976553440094</span>`,wrap:!1}}),lt=new Ut({props:{title:"Class-conditioned image generation",local:"class-conditioned-image-generation",headingTag:"h3"}}),ot=new h({props:{code:"ZnJvbSUyMHppcGZpbGUlMjBpbXBvcnQlMjBaaXBGaWxlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFkZWYlMjBkb3dubG9hZCh1cmwlMkMlMjBsb2NhbF9maWxlcGF0aCklM0ElMEElMjAlMjAlMjAlMjByJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihsb2NhbF9maWxlcGF0aCUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUoci5jb250ZW50KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvY2FsX2ZpbGVwYXRoJTBBJTBBZHVtbXlfZGF0YXNldF91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnNhbXBsZS1pbWFnZW5ldC1pbWFnZXMuemlwJTIyJTBBbG9jYWxfZmlsZXBhdGglMjAlM0QlMjBkb3dubG9hZChkdW1teV9kYXRhc2V0X3VybCUyQyUyMGR1bW15X2RhdGFzZXRfdXJsLnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCklMEElMEF3aXRoJTIwWmlwRmlsZShsb2NhbF9maWxlcGF0aCUyQyUyMCUyMnIlMjIpJTIwYXMlMjB6aXBwZXIlM0ElMEElMjAlMjAlMjAlMjB6aXBwZXIuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> zipfile <span class="hljs-keyword">import</span> ZipFile
<span class="hljs-keyword">import</span> requests


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download</span>(<span class="hljs-params">url, local_filepath</span>):
    r = requests.get(url)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_filepath, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(r.content)
    <span class="hljs-keyword">return</span> local_filepath

dummy_dataset_url = <span class="hljs-string">&quot;https://hf.co/datasets/sayakpaul/sample-datasets/resolve/main/sample-imagenet-images.zip&quot;</span>
local_filepath = download(dummy_dataset_url, dummy_dataset_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])

<span class="hljs-keyword">with</span> ZipFile(local_filepath, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> zipper:
    zipper.extractall(<span class="hljs-string">&quot;.&quot;</span>)`,wrap:!1}}),rt=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFkYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJzYW1wbGUtaW1hZ2VuZXQtaW1hZ2VzJTIyJTBBaW1hZ2VfcGF0aHMlMjAlM0QlMjBzb3J0ZWQoJTVCb3MucGF0aC5qb2luKGRhdGFzZXRfcGF0aCUyQyUyMHgpJTIwZm9yJTIweCUyMGluJTIwb3MubGlzdGRpcihkYXRhc2V0X3BhdGgpJTVEKSUwQSUwQXJlYWxfaW1hZ2VzJTIwJTNEJTIwJTVCbnAuYXJyYXkoSW1hZ2Uub3BlbihwYXRoKS5jb252ZXJ0KCUyMlJHQiUyMikpJTIwZm9yJTIwcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

dataset_path = <span class="hljs-string">&quot;sample-imagenet-images&quot;</span>
image_paths = <span class="hljs-built_in">sorted</span>([os.path.join(dataset_path, x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> os.listdir(dataset_path)])

real_images = [np.array(Image.<span class="hljs-built_in">open</span>(path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> image_paths]`,wrap:!1}}),mt=new h({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFkZWYlMjBwcmVwcm9jZXNzX2ltYWdlKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdG9yY2gudGVuc29yKGltYWdlKS51bnNxdWVlemUoMCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMGltYWdlLnBlcm11dGUoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMjAlMkYlMjAyNTUuMCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEYuY2VudGVyX2Nyb3AoaW1hZ2UlMkMlMjAoMjU2JTJDJTIwMjU2KSklMEElMEFyZWFsX2ltYWdlcyUyMCUzRCUyMHRvcmNoLmNhdCglNUJwcmVwcm9jZXNzX2ltYWdlKGltYWdlKSUyMGZvciUyMGltYWdlJTIwaW4lMjByZWFsX2ltYWdlcyU1RCklMEFwcmludChyZWFsX2ltYWdlcy5zaGFwZSklMEElMjMlMjB0b3JjaC5TaXplKCU1QjEwJTJDJTIwMyUyQyUyMDI1NiUyQyUyMDI1NiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">image</span>):
    image = torch.tensor(image).unsqueeze(<span class="hljs-number">0</span>)
    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>) / <span class="hljs-number">255.0</span>
    <span class="hljs-keyword">return</span> F.center_crop(image, (<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

real_images = torch.cat([preprocess_image(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> real_images])
<span class="hljs-built_in">print</span>(real_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`,wrap:!1}}),ut=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpVFBpcGVsaW5lJTJDJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwRGlUUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGRGlULVhMLTItMjU2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRpdF9waXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcoZGl0X3BpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwZGl0X3BpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBc2VlZCUyMCUzRCUyMDAlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZChzZWVkKSUwQSUwQSUwQXdvcmRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyY2Fzc2V0dGUlMjBwbGF5ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGFpbnNhdyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNoYWluc2F3JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2h1cmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FzJTIwcHVtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdhcyUyMHB1bXAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJnYXMlMjBwdW1wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycGFyYWNodXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycGFyYWNodXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVuY2glMjIlMkMlMEElNUQlMEElMEFjbGFzc19pZHMlMjAlM0QlMjBkaXRfcGlwZWxpbmUuZ2V0X2xhYmVsX2lkcyh3b3JkcyklMEFvdXRwdXQlMjAlM0QlMjBkaXRfcGlwZWxpbmUoY2xhc3NfbGFiZWxzJTNEY2xhc3NfaWRzJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMiklMEElMEFmYWtlX2ltYWdlcyUyMCUzRCUyMG91dHB1dC5pbWFnZXMlMEFmYWtlX2ltYWdlcyUyMCUzRCUyMHRvcmNoLnRlbnNvcihmYWtlX2ltYWdlcyklMEFmYWtlX2ltYWdlcyUyMCUzRCUyMGZha2VfaW1hZ2VzLnBlcm11dGUoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMEFwcmludChmYWtlX2ltYWdlcy5zaGFwZSklMEElMjMlMjB0b3JjaC5TaXplKCU1QjEwJTJDJTIwMyUyQyUyMDI1NiUyQyUyMDI1NiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiTPipeline, DPMSolverMultistepScheduler

dit_pipeline = DiTPipeline.from_pretrained(<span class="hljs-string">&quot;facebook/DiT-XL-2-256&quot;</span>, torch_dtype=torch.float16)
dit_pipeline.scheduler = DPMSolverMultistepScheduler.from_config(dit_pipeline.scheduler.config)
dit_pipeline = dit_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)


words = [
    <span class="hljs-string">&quot;cassette player&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;church&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;tench&quot;</span>,
]

class_ids = dit_pipeline.get_label_ids(words)
output = dit_pipeline(class_labels=class_ids, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>)

fake_images = output.images
fake_images = torch.tensor(fake_images)
fake_images = fake_images.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-built_in">print</span>(fake_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`,wrap:!1}}),yt=new h({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5pbWFnZS5maWQlMjBpbXBvcnQlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2UlMEElMEFmaWQlMjAlM0QlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2Uobm9ybWFsaXplJTNEVHJ1ZSklMEFmaWQudXBkYXRlKHJlYWxfaW1hZ2VzJTJDJTIwcmVhbCUzRFRydWUpJTBBZmlkLnVwZGF0ZShmYWtlX2ltYWdlcyUyQyUyMHJlYWwlM0RGYWxzZSklMEElMEFwcmludChmJTIyRklEJTNBJTIwJTdCZmxvYXQoZmlkLmNvbXB1dGUoKSklN0QlMjIpJTBBJTIzJTIwRklEJTNBJTIwMTc3LjcxNDcyMTY3OTY4NzU=",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.image.fid <span class="hljs-keyword">import</span> FrechetInceptionDistance

fid = FrechetInceptionDistance(normalize=<span class="hljs-literal">True</span>)
fid.update(real_images, real=<span class="hljs-literal">True</span>)
fid.update(fake_images, real=<span class="hljs-literal">False</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;FID: <span class="hljs-subst">{<span class="hljs-built_in">float</span>(fid.compute())}</span>&quot;</span>)
<span class="hljs-comment"># FID: 177.7147216796875</span>`,wrap:!1}}),jt=new ui({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/conceptual/evaluation.md"}}),{c(){J=n("meta"),It=a(),bt=n("p"),Ct=a(),r(C.$$.fragment),Zt=a(),r(Z.$$.fragment),Bt=a(),f=n("a"),f.innerHTML=xs,Wt=a(),w=n("blockquote"),w.innerHTML=ks,vt=a(),B=n("p"),B.innerHTML=Xs,_t=a(),W=n("p"),W.textContent=Vs,Gt=a(),v=n("p"),v.innerHTML=Rs,xt=a(),_=n("p"),_.innerHTML=Hs,kt=a(),r(G.$$.fragment),Xt=a(),x=n("p"),x.textContent=Fs,Vt=a(),k=n("ul"),k.innerHTML=Ns,Rt=a(),r(X.$$.fragment),Ht=a(),V=n("p"),V.innerHTML=Es,Ft=a(),R=n("p"),R.innerHTML=Ys,Nt=a(),H=n("blockquote"),H.innerHTML=Qs,Et=a(),F=n("p"),F.innerHTML=As,Yt=a(),N=n("p"),N.textContent=zs,Qt=a(),E=n("ul"),E.innerHTML=Ss,At=a(),Y=n("p"),Y.textContent=$s,zt=a(),Q=n("p"),Q.innerHTML=Ls,St=a(),A=n("ul"),A.innerHTML=qs,$t=a(),z=n("p"),z.innerHTML=Ps,Lt=a(),S=n("p"),S.innerHTML=Ds,qt=a(),r($.$$.fragment),Pt=a(),L=n("p"),L.innerHTML=Ks,Dt=a(),r(q.$$.fragment),Kt=a(),P=n("p"),P.innerHTML=Os,Ot=a(),D=n("p"),D.innerHTML=ea,el=a(),K=n("p"),K.innerHTML=ta,tl=a(),O=n("p"),O.textContent=la,ll=a(),T=n("blockquote"),T.innerHTML=sa,sl=a(),r(ee.$$.fragment),al=a(),te=n("p"),te.textContent=aa,il=a(),le=n("ul"),le.innerHTML=ia,nl=a(),r(se.$$.fragment),pl=a(),ae=n("p"),ae.innerHTML=na,ol=a(),ie=n("p"),ie.innerHTML=pa,rl=a(),r(ne.$$.fragment),Ml=a(),pe=n("p"),pe.textContent=oa,cl=a(),r(oe.$$.fragment),ml=a(),re=n("p"),re.textContent=ra,dl=a(),r(Me.$$.fragment),ul=a(),ce=n("p"),ce.textContent=Ma,hl=a(),me=n("p"),me.innerHTML=ca,yl=a(),r(de.$$.fragment),Jl=a(),ue=n("p"),ue.innerHTML=ma,fl=a(),r(he.$$.fragment),wl=a(),ye=n("p"),ye.textContent=da,Tl=a(),r(Je.$$.fragment),jl=a(),fe=n("p"),fe.innerHTML=ua,Ul=a(),j=n("blockquote"),j.innerHTML=ha,bl=a(),r(we.$$.fragment),gl=a(),Te=n("p"),Te.innerHTML=ya,Il=a(),je=n("p"),je.textContent=Ja,Cl=a(),Ue=n("p"),Ue.innerHTML=fa,Zl=a(),be=n("p"),be.innerHTML=wa,Bl=a(),ge=n("ul"),ge.innerHTML=Ta,Wl=a(),Ie=n("p"),Ie.textContent=ja,vl=a(),Ce=n("p"),Ce.innerHTML=Ua,_l=a(),Ze=n("p"),Ze.textContent=ba,Gl=a(),r(Be.$$.fragment),xl=a(),r(We.$$.fragment),kl=a(),ve=n("p"),ve.textContent=ga,Xl=a(),_e=n("ul"),_e.innerHTML=Ia,Vl=a(),Ge=n("p"),Ge.textContent=Ca,Rl=a(),r(xe.$$.fragment),Hl=a(),r(ke.$$.fragment),Fl=a(),Xe=n("p"),Xe.textContent=Za,Nl=a(),r(Ve.$$.fragment),El=a(),Re=n("p"),Re.innerHTML=Ba,Yl=a(),He=n("p"),He.textContent=Wa,Ql=a(),Fe=n("p"),Fe.innerHTML=va,Al=a(),r(Ne.$$.fragment),zl=a(),Ee=n("p"),Ee.textContent=_a,Sl=a(),r(Ye.$$.fragment),$l=a(),Qe=n("p"),Qe.textContent=Ga,Ll=a(),r(Ae.$$.fragment),ql=a(),ze=n("p"),ze.innerHTML=xa,Pl=a(),Se=n("p"),Se.innerHTML=ka,Dl=a(),r($e.$$.fragment),Kl=a(),Le=n("p"),Le.innerHTML=Xa,Ol=a(),r(qe.$$.fragment),es=a(),Pe=n("p"),Pe.textContent=Va,ts=a(),De=n("p"),De.innerHTML=Ra,ls=a(),Ke=n("p"),Ke.innerHTML=Ha,ss=a(),Oe=n("p"),Oe.innerHTML=Fa,as=a(),U=n("blockquote"),U.innerHTML=Na,is=a(),et=n("p"),et.innerHTML=Ea,ns=a(),tt=n("p"),tt.innerHTML=Ya,ps=a(),r(lt.$$.fragment),os=a(),st=n("p"),st.innerHTML=Qa,rs=a(),at=n("p"),at.innerHTML=Aa,Ms=a(),it=n("blockquote"),it.innerHTML=za,cs=a(),nt=n("p"),nt.textContent=Sa,ms=a(),pt=n("p"),pt.textContent=$a,ds=a(),r(ot.$$.fragment),us=a(),r(rt.$$.fragment),hs=a(),Mt=n("p"),Mt.textContent=La,ys=a(),b=n("p"),b.innerHTML=qa,Js=a(),ct=n("p"),ct.textContent=Pa,fs=a(),r(mt.$$.fragment),ws=a(),dt=n("p"),dt.innerHTML=Da,Ts=a(),r(ut.$$.fragment),js=a(),ht=n("p"),ht.innerHTML=Ka,Us=a(),r(yt.$$.fragment),bs=a(),Jt=n("p"),Jt.textContent=Oa,gs=a(),ft=n("ul"),ft.innerHTML=ei,Is=a(),wt=n("p"),wt.textContent=ti,Cs=a(),g=n("blockquote"),g.innerHTML=li,Zs=a(),Tt=n("p"),Tt.innerHTML=si,Bs=a(),I=n("p"),I.innerHTML=ai,Ws=a(),r(jt.$$.fragment),vs=a(),gt=n("p"),this.h()},l(e){const t=ci("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),It=i(e),bt=p(e,"P",{}),ii(bt).forEach(l),Ct=i(e),M(C.$$.fragment,e),Zt=i(e),M(Z.$$.fragment,e),Bt=i(e),f=p(e,"A",{target:!0,href:!0,"data-svelte-h":!0}),o(f)!=="svelte-1fn2wis"&&(f.innerHTML=xs),Wt=i(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-14gwzbu"&&(w.innerHTML=ks),vt=i(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-z81vpv"&&(B.innerHTML=Xs),_t=i(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-14o42r"&&(W.textContent=Vs),Gt=i(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-tqblgl"&&(v.innerHTML=Rs),xt=i(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1on511i"&&(_.innerHTML=Hs),kt=i(e),M(G.$$.fragment,e),Xt=i(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-cqau2t"&&(x.textContent=Fs),Vt=i(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1izcxm8"&&(k.innerHTML=Ns),Rt=i(e),M(X.$$.fragment,e),Ht=i(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-cad463"&&(V.innerHTML=Es),Ft=i(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-15hirvk"&&(R.innerHTML=Ys),Nt=i(e),H=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(H)!=="svelte-191e550"&&(H.innerHTML=Qs),Et=i(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-19xz367"&&(F.innerHTML=As),Yt=i(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-76ujpq"&&(N.textContent=zs),Qt=i(e),E=p(e,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-umnjz5"&&(E.innerHTML=Ss),At=i(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-ybl15o"&&(Y.textContent=$s),zt=i(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-f7spg1"&&(Q.innerHTML=Ls),St=i(e),A=p(e,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-18glkk1"&&(A.innerHTML=qs),$t=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-e5mnz8"&&(z.innerHTML=Ps),Lt=i(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-304bv6"&&(S.innerHTML=Ds),qt=i(e),M($.$$.fragment,e),Pt=i(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-tpmlzv"&&(L.innerHTML=Ks),Dt=i(e),M(q.$$.fragment,e),Kt=i(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-4i7yd5"&&(P.innerHTML=Os),Ot=i(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-a4b9f"&&(D.innerHTML=ea),el=i(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-gipltn"&&(K.innerHTML=ta),tl=i(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1vqr9z3"&&(O.textContent=la),ll=i(e),T=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-6xf271"&&(T.innerHTML=sa),sl=i(e),M(ee.$$.fragment,e),al=i(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-6557l0"&&(te.textContent=aa),il=i(e),le=p(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-dg8xrl"&&(le.innerHTML=ia),nl=i(e),M(se.$$.fragment,e),pl=i(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1i7u4ia"&&(ae.innerHTML=na),ol=i(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-7rr7b3"&&(ie.innerHTML=pa),rl=i(e),M(ne.$$.fragment,e),Ml=i(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-6rdsa0"&&(pe.textContent=oa),cl=i(e),M(oe.$$.fragment,e),ml=i(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1iembt3"&&(re.textContent=ra),dl=i(e),M(Me.$$.fragment,e),ul=i(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1a3tn0d"&&(ce.textContent=Ma),hl=i(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1ibhx6s"&&(me.innerHTML=ca),yl=i(e),M(de.$$.fragment,e),Jl=i(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1uab86h"&&(ue.innerHTML=ma),fl=i(e),M(he.$$.fragment,e),wl=i(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-ni3sdy"&&(ye.textContent=da),Tl=i(e),M(Je.$$.fragment,e),jl=i(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1kq1w3v"&&(fe.innerHTML=ua),Ul=i(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-7u3pnh"&&(j.innerHTML=ha),bl=i(e),M(we.$$.fragment,e),gl=i(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-18ubjo5"&&(Te.innerHTML=ya),Il=i(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-r4qmx2"&&(je.textContent=Ja),Cl=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-tnn31f"&&(Ue.innerHTML=fa),Zl=i(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-lwbe5g"&&(be.innerHTML=wa),Bl=i(e),ge=p(e,"UL",{"data-svelte-h":!0}),o(ge)!=="svelte-yda35x"&&(ge.innerHTML=Ta),Wl=i(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1bn7xvw"&&(Ie.textContent=ja),vl=i(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-fs1abj"&&(Ce.innerHTML=Ua),_l=i(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1t03m2p"&&(Ze.textContent=ba),Gl=i(e),M(Be.$$.fragment,e),xl=i(e),M(We.$$.fragment,e),kl=i(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1q1xt9i"&&(ve.textContent=ga),Xl=i(e),_e=p(e,"UL",{"data-svelte-h":!0}),o(_e)!=="svelte-mhcjab"&&(_e.innerHTML=Ia),Vl=i(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-9q1iss"&&(Ge.textContent=Ca),Rl=i(e),M(xe.$$.fragment,e),Hl=i(e),M(ke.$$.fragment,e),Fl=i(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-5rwzaj"&&(Xe.textContent=Za),Nl=i(e),M(Ve.$$.fragment,e),El=i(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1r4pb3b"&&(Re.innerHTML=Ba),Yl=i(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1n3s9hn"&&(He.textContent=Wa),Ql=i(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-ss3jc3"&&(Fe.innerHTML=va),Al=i(e),M(Ne.$$.fragment,e),zl=i(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-pfw8ud"&&(Ee.textContent=_a),Sl=i(e),M(Ye.$$.fragment,e),$l=i(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1nzzrqn"&&(Qe.textContent=Ga),Ll=i(e),M(Ae.$$.fragment,e),ql=i(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1c659ih"&&(ze.innerHTML=xa),Pl=i(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-k3cp0u"&&(Se.innerHTML=ka),Dl=i(e),M($e.$$.fragment,e),Kl=i(e),Le=p(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1tdcjay"&&(Le.innerHTML=Xa),Ol=i(e),M(qe.$$.fragment,e),es=i(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-14mrga2"&&(Pe.textContent=Va),ts=i(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-vck7qn"&&(De.innerHTML=Ra),ls=i(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-nbfdj7"&&(Ke.innerHTML=Ha),ss=i(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-9ga2iu"&&(Oe.innerHTML=Fa),as=i(e),U=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-11ujc7t"&&(U.innerHTML=Na),is=i(e),et=p(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-7qwtg3"&&(et.innerHTML=Ea),ns=i(e),tt=p(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-hcc15s"&&(tt.innerHTML=Ya),ps=i(e),M(lt.$$.fragment,e),os=i(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1tzk2c3"&&(st.innerHTML=Qa),rs=i(e),at=p(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1rk18fl"&&(at.innerHTML=Aa),Ms=i(e),it=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(it)!=="svelte-7e4j74"&&(it.innerHTML=za),cs=i(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-simh2d"&&(nt.textContent=Sa),ms=i(e),pt=p(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1h659dy"&&(pt.textContent=$a),ds=i(e),M(ot.$$.fragment,e),us=i(e),M(rt.$$.fragment,e),hs=i(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1jd4ltz"&&(Mt.textContent=La),ys=i(e),b=p(e,"P",{align:!0,"data-svelte-h":!0}),o(b)!=="svelte-94lw7t"&&(b.innerHTML=qa),Js=i(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-iw90qp"&&(ct.textContent=Pa),fs=i(e),M(mt.$$.fragment,e),ws=i(e),dt=p(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-a40j2v"&&(dt.innerHTML=Da),Ts=i(e),M(ut.$$.fragment,e),js=i(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1nlt7gv"&&(ht.innerHTML=Ka),Us=i(e),M(yt.$$.fragment,e),bs=i(e),Jt=p(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-17lmdw3"&&(Jt.textContent=Oa),gs=i(e),ft=p(e,"UL",{"data-svelte-h":!0}),o(ft)!=="svelte-16n90lm"&&(ft.innerHTML=ei),Is=i(e),wt=p(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1evgdla"&&(wt.textContent=ti),Cs=i(e),g=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-pf76q4"&&(g.innerHTML=li),Zs=i(e),Tt=p(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-ptrlon"&&(Tt.innerHTML=si),Bs=i(e),I=p(e,"P",{align:!0,"data-svelte-h":!0}),o(I)!=="svelte-16e5oh4"&&(I.innerHTML=ai),Ws=i(e),M(jt.$$.fragment,e),vs=i(e),gt=p(e,"P",{}),ii(gt).forEach(l),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",yi),y(f,"target","_blank"),y(f,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/evaluation.ipynb"),y(w,"class","tip"),y(T,"class","tip"),y(j,"class","warning"),y(U,"class","tip"),y(b,"align","center"),y(g,"class","warning"),y(I,"align","center")},m(e,t){mi(document.head,J),s(e,It,t),s(e,bt,t),s(e,Ct,t),c(C,e,t),s(e,Zt,t),c(Z,e,t),s(e,Bt,t),s(e,f,t),s(e,Wt,t),s(e,w,t),s(e,vt,t),s(e,B,t),s(e,_t,t),s(e,W,t),s(e,Gt,t),s(e,v,t),s(e,xt,t),s(e,_,t),s(e,kt,t),c(G,e,t),s(e,Xt,t),s(e,x,t),s(e,Vt,t),s(e,k,t),s(e,Rt,t),c(X,e,t),s(e,Ht,t),s(e,V,t),s(e,Ft,t),s(e,R,t),s(e,Nt,t),s(e,H,t),s(e,Et,t),s(e,F,t),s(e,Yt,t),s(e,N,t),s(e,Qt,t),s(e,E,t),s(e,At,t),s(e,Y,t),s(e,zt,t),s(e,Q,t),s(e,St,t),s(e,A,t),s(e,$t,t),s(e,z,t),s(e,Lt,t),s(e,S,t),s(e,qt,t),c($,e,t),s(e,Pt,t),s(e,L,t),s(e,Dt,t),c(q,e,t),s(e,Kt,t),s(e,P,t),s(e,Ot,t),s(e,D,t),s(e,el,t),s(e,K,t),s(e,tl,t),s(e,O,t),s(e,ll,t),s(e,T,t),s(e,sl,t),c(ee,e,t),s(e,al,t),s(e,te,t),s(e,il,t),s(e,le,t),s(e,nl,t),c(se,e,t),s(e,pl,t),s(e,ae,t),s(e,ol,t),s(e,ie,t),s(e,rl,t),c(ne,e,t),s(e,Ml,t),s(e,pe,t),s(e,cl,t),c(oe,e,t),s(e,ml,t),s(e,re,t),s(e,dl,t),c(Me,e,t),s(e,ul,t),s(e,ce,t),s(e,hl,t),s(e,me,t),s(e,yl,t),c(de,e,t),s(e,Jl,t),s(e,ue,t),s(e,fl,t),c(he,e,t),s(e,wl,t),s(e,ye,t),s(e,Tl,t),c(Je,e,t),s(e,jl,t),s(e,fe,t),s(e,Ul,t),s(e,j,t),s(e,bl,t),c(we,e,t),s(e,gl,t),s(e,Te,t),s(e,Il,t),s(e,je,t),s(e,Cl,t),s(e,Ue,t),s(e,Zl,t),s(e,be,t),s(e,Bl,t),s(e,ge,t),s(e,Wl,t),s(e,Ie,t),s(e,vl,t),s(e,Ce,t),s(e,_l,t),s(e,Ze,t),s(e,Gl,t),c(Be,e,t),s(e,xl,t),c(We,e,t),s(e,kl,t),s(e,ve,t),s(e,Xl,t),s(e,_e,t),s(e,Vl,t),s(e,Ge,t),s(e,Rl,t),c(xe,e,t),s(e,Hl,t),c(ke,e,t),s(e,Fl,t),s(e,Xe,t),s(e,Nl,t),c(Ve,e,t),s(e,El,t),s(e,Re,t),s(e,Yl,t),s(e,He,t),s(e,Ql,t),s(e,Fe,t),s(e,Al,t),c(Ne,e,t),s(e,zl,t),s(e,Ee,t),s(e,Sl,t),c(Ye,e,t),s(e,$l,t),s(e,Qe,t),s(e,Ll,t),c(Ae,e,t),s(e,ql,t),s(e,ze,t),s(e,Pl,t),s(e,Se,t),s(e,Dl,t),c($e,e,t),s(e,Kl,t),s(e,Le,t),s(e,Ol,t),c(qe,e,t),s(e,es,t),s(e,Pe,t),s(e,ts,t),s(e,De,t),s(e,ls,t),s(e,Ke,t),s(e,ss,t),s(e,Oe,t),s(e,as,t),s(e,U,t),s(e,is,t),s(e,et,t),s(e,ns,t),s(e,tt,t),s(e,ps,t),c(lt,e,t),s(e,os,t),s(e,st,t),s(e,rs,t),s(e,at,t),s(e,Ms,t),s(e,it,t),s(e,cs,t),s(e,nt,t),s(e,ms,t),s(e,pt,t),s(e,ds,t),c(ot,e,t),s(e,us,t),c(rt,e,t),s(e,hs,t),s(e,Mt,t),s(e,ys,t),s(e,b,t),s(e,Js,t),s(e,ct,t),s(e,fs,t),c(mt,e,t),s(e,ws,t),s(e,dt,t),s(e,Ts,t),c(ut,e,t),s(e,js,t),s(e,ht,t),s(e,Us,t),c(yt,e,t),s(e,bs,t),s(e,Jt,t),s(e,gs,t),s(e,ft,t),s(e,Is,t),s(e,wt,t),s(e,Cs,t),s(e,g,t),s(e,Zs,t),s(e,Tt,t),s(e,Bs,t),s(e,I,t),s(e,Ws,t),c(jt,e,t),s(e,vs,t),s(e,gt,t),_s=!0},p:pi,i(e){_s||(m(C.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m($.$$.fragment,e),m(q.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(Me.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(Je.$$.fragment,e),m(we.$$.fragment,e),m(Be.$$.fragment,e),m(We.$$.fragment,e),m(xe.$$.fragment,e),m(ke.$$.fragment,e),m(Ve.$$.fragment,e),m(Ne.$$.fragment,e),m(Ye.$$.fragment,e),m(Ae.$$.fragment,e),m($e.$$.fragment,e),m(qe.$$.fragment,e),m(lt.$$.fragment,e),m(ot.$$.fragment,e),m(rt.$$.fragment,e),m(mt.$$.fragment,e),m(ut.$$.fragment,e),m(yt.$$.fragment,e),m(jt.$$.fragment,e),_s=!0)},o(e){d(C.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(X.$$.fragment,e),d($.$$.fragment,e),d(q.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(we.$$.fragment,e),d(Be.$$.fragment,e),d(We.$$.fragment,e),d(xe.$$.fragment,e),d(ke.$$.fragment,e),d(Ve.$$.fragment,e),d(Ne.$$.fragment,e),d(Ye.$$.fragment,e),d(Ae.$$.fragment,e),d($e.$$.fragment,e),d(qe.$$.fragment,e),d(lt.$$.fragment,e),d(ot.$$.fragment,e),d(rt.$$.fragment,e),d(mt.$$.fragment,e),d(ut.$$.fragment,e),d(yt.$$.fragment,e),d(jt.$$.fragment,e),_s=!1},d(e){e&&(l(It),l(bt),l(Ct),l(Zt),l(Bt),l(f),l(Wt),l(w),l(vt),l(B),l(_t),l(W),l(Gt),l(v),l(xt),l(_),l(kt),l(Xt),l(x),l(Vt),l(k),l(Rt),l(Ht),l(V),l(Ft),l(R),l(Nt),l(H),l(Et),l(F),l(Yt),l(N),l(Qt),l(E),l(At),l(Y),l(zt),l(Q),l(St),l(A),l($t),l(z),l(Lt),l(S),l(qt),l(Pt),l(L),l(Dt),l(Kt),l(P),l(Ot),l(D),l(el),l(K),l(tl),l(O),l(ll),l(T),l(sl),l(al),l(te),l(il),l(le),l(nl),l(pl),l(ae),l(ol),l(ie),l(rl),l(Ml),l(pe),l(cl),l(ml),l(re),l(dl),l(ul),l(ce),l(hl),l(me),l(yl),l(Jl),l(ue),l(fl),l(wl),l(ye),l(Tl),l(jl),l(fe),l(Ul),l(j),l(bl),l(gl),l(Te),l(Il),l(je),l(Cl),l(Ue),l(Zl),l(be),l(Bl),l(ge),l(Wl),l(Ie),l(vl),l(Ce),l(_l),l(Ze),l(Gl),l(xl),l(kl),l(ve),l(Xl),l(_e),l(Vl),l(Ge),l(Rl),l(Hl),l(Fl),l(Xe),l(Nl),l(El),l(Re),l(Yl),l(He),l(Ql),l(Fe),l(Al),l(zl),l(Ee),l(Sl),l($l),l(Qe),l(Ll),l(ql),l(ze),l(Pl),l(Se),l(Dl),l(Kl),l(Le),l(Ol),l(es),l(Pe),l(ts),l(De),l(ls),l(Ke),l(ss),l(Oe),l(as),l(U),l(is),l(et),l(ns),l(tt),l(ps),l(os),l(st),l(rs),l(at),l(Ms),l(it),l(cs),l(nt),l(ms),l(pt),l(ds),l(us),l(hs),l(Mt),l(ys),l(b),l(Js),l(ct),l(fs),l(ws),l(dt),l(Ts),l(js),l(ht),l(Us),l(bs),l(Jt),l(gs),l(ft),l(Is),l(wt),l(Cs),l(g),l(Zs),l(Tt),l(Bs),l(I),l(Ws),l(vs),l(gt)),l(J),u(C,e),u(Z,e),u(G,e),u(X,e),u($,e),u(q,e),u(ee,e),u(se,e),u(ne,e),u(oe,e),u(Me,e),u(de,e),u(he,e),u(Je,e),u(we,e),u(Be,e),u(We,e),u(xe,e),u(ke,e),u(Ve,e),u(Ne,e),u(Ye,e),u(Ae,e),u($e,e),u(qe,e),u(lt,e),u(ot,e),u(rt,e),u(mt,e),u(ut,e),u(yt,e),u(jt,e)}}}const yi='{"title":"Evaluating Diffusion Models","local":"evaluating-diffusion-models","sections":[{"title":"Scenarios","local":"scenarios","sections":[],"depth":2},{"title":"Qualitative Evaluation","local":"qualitative-evaluation","sections":[],"depth":2},{"title":"Quantitative Evaluation","local":"quantitative-evaluation","sections":[{"title":"Text-guided image generation","local":"text-guided-image-generation","sections":[],"depth":3},{"title":"Image-conditioned text-to-image generation","local":"image-conditioned-text-to-image-generation","sections":[],"depth":3},{"title":"Class-conditioned image generation","local":"class-conditioned-image-generation","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ji(Gs){return oi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bi extends ri{constructor(J){super(),Mi(this,J,Ji,hi,ni,{})}}export{bi as component};
