import{s as fe,o as Ue,n as ce}from"../chunks/scheduler.53228c21.js";import{S as je,i as Ze,e as h,s as r,c as j,h as Ce,a as g,d as t,b as c,f as we,g as Z,j as w,k as pe,w as T,l as We,m as a,n as C,t as W,o as I,p as G}from"../chunks/index.100fac89.js";import{C as Ie}from"../chunks/CopyLLMTxtMenu.2cdbb51f.js";import{C as N}from"../chunks/CodeBlock.d30a6509.js";import{H as me,E as Ge}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3fcbbc76.js";import{H as Be,a as re}from"../chunks/HfOption.fad27e59.js";function Re(v){let o,f='Generate a canny image with <a href="https://github.com/opencv/opencv-python" rel="nofollow">opencv-python</a>.',J,M,u,d,s="Pass the canny image to the pipeline. Use the <code>controlnet_conditioning_scale</code> parameter to determine how much weight to assign to the control.",y,m,b,i,B='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">original image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat-generated.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',U;return M=new N({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbm9uLWVuaGFuY2VkLXByb21wdC5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShvcmlnaW5hbF9pbWFnZSklMEElMEFsb3dfdGhyZXNob2xkJTIwJTNEJTIwMTAwJTBBaGlnaF90aHJlc2hvbGQlMjAlM0QlMjAyMDAlMEElMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlMkMlMjBoaWdoX3RocmVzaG9sZCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)`,wrap:!1}}),m=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4Q29udHJvbE5ldFBpcGVsaW5lJTJDJTIwRmx1eENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBGbHV4Q29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJJbnN0YW50WCUyRkZMVVguMS1kZXYtQ29udHJvbG5ldC1DYW5ueSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBGbHV4Q29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBQSUyMHBob3RvcmVhbGlzdGljJTIwb3ZlcmhlYWQlMjBpbWFnZSUyMG9mJTIwYSUyMGNhdCUyMHJlY2xpbmluZyUyMHNpZGV3YXlzJTIwaW4lMjBhJTIwZmxhbWluZ28lMjBwb29sJTIwZmxvYXRpZSUyMGhvbGRpbmclMjBhJTIwbWFyZ2FyaXRhLiUyMCUwQVRoZSUyMGNhdCUyMGlzJTIwZmxvYXRpbmclMjBsZWlzdXJlbHklMjBpbiUyMHRoZSUyMHBvb2wlMjBhbmQlMjBjb21wbGV0ZWx5JTIwcmVsYXhlZCUyMGFuZCUyMGhhcHB5LiUwQSUyMiUyMiUyMiUwQSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlNetPipeline, FluxControlNetModel

controlnet = FluxControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;InstantX/FLUX.1-dev-Controlnet-Canny&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline = FluxControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, controlnet=controlnet, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
A photorealistic overhead image of a cat reclining sideways in a flamingo pool floatie holding a margarita. 
The cat is floating leisurely in the pool and completely relaxed and happy.
&quot;&quot;&quot;</span>

pipeline(
    prompt, 
    control_image=canny_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>, 
    guidance_scale=<span class="hljs-number">3.5</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=h("p"),o.innerHTML=f,J=r(),j(M.$$.fragment),u=r(),d=h("p"),d.innerHTML=s,y=r(),j(m.$$.fragment),b=r(),i=h("div"),i.innerHTML=B,this.h()},l(l){o=g(l,"P",{"data-svelte-h":!0}),w(o)!=="svelte-odtmr5"&&(o.innerHTML=f),J=c(l),Z(M.$$.fragment,l),u=c(l),d=g(l,"P",{"data-svelte-h":!0}),w(d)!=="svelte-zjofbt"&&(d.innerHTML=s),y=c(l),Z(m.$$.fragment,l),b=c(l),i=g(l,"DIV",{style:!0,"data-svelte-h":!0}),w(i)!=="svelte-y2w2wd"&&(i.innerHTML=B),this.h()},h(){T(i,"display","flex"),T(i,"gap","10px"),T(i,"justify-content","space-around"),T(i,"align-items","flex-end")},m(l,p){a(l,o,p),a(l,J,p),C(M,l,p),a(l,u,p),a(l,d,p),a(l,y,p),C(m,l,p),a(l,b,p),a(l,i,p),U=!0},p:ce,i(l){U||(W(M.$$.fragment,l),W(m.$$.fragment,l),U=!0)},o(l){I(M.$$.fragment,l),I(m.$$.fragment,l),U=!1},d(l){l&&(t(o),t(J),t(u),t(d),t(y),t(b),t(i)),G(M,l),G(m,l)}}}function ke(v){let o,f="Generate a depth map with a depth estimation pipeline from Transformers.",J,M,u,d,s="Pass the depth map to the pipeline. Use the <code>controlnet_conditioning_scale</code> parameter to determine how much weight to assign to the control.",y,m,b,i,B='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">original image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_depth_image.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">depth map</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_depth_cat.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',U;return M=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTImageProcessor, DPTForDepthEstimation
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionXLControlNetImg2ImgPipeline, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image


depth_estimator = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
feature_extractor = DPTImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image</span>):
    image = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(<span class="hljs-string">&quot;cuda&quot;</span>)
    <span class="hljs-keyword">with</span> torch.no_grad(), torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>):
        depth_map = depth_estimator(image).predicted_depth

    depth_map = torch.nn.functional.interpolate(
        depth_map.unsqueeze(<span class="hljs-number">1</span>),
        size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
        mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
        align_corners=<span class="hljs-literal">False</span>,
    )
    depth_min = torch.amin(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
    depth_max = torch.amax(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
    depth_map = (depth_map - depth_min) / (depth_max - depth_min)
    image = torch.cat([depth_map] * <span class="hljs-number">3</span>, dim=<span class="hljs-number">1</span>)
    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).cpu().numpy()[<span class="hljs-number">0</span>]
    image = Image.fromarray((image * <span class="hljs-number">255.0</span>).clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).astype(np.uint8))
    <span class="hljs-keyword">return</span> image

depth_image = get_depth_map(image)`,wrap:!1}}),m=new N({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1kZXB0aC1zZHhsLTEuMC1zbWFsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRHZhZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFBJTIwcGhvdG9yZWFsaXN0aWMlMjBvdmVyaGVhZCUyMGltYWdlJTIwb2YlMjBhJTIwY2F0JTIwcmVjbGluaW5nJTIwc2lkZXdheXMlMjBpbiUyMGElMjBmbGFtaW5nbyUyMHBvb2wlMjBmbG9hdGllJTIwaG9sZGluZyUyMGElMjBtYXJnYXJpdGEuJTIwJTBBVGhlJTIwY2F0JTIwaXMlMjBmbG9hdGluZyUyMGxlaXN1cmVseSUyMGluJTIwdGhlJTIwcG9vbCUyMGFuZCUyMGNvbXBsZXRlbHklMjByZWxheGVkJTIwYW5kJTIwaGFwcHkuJTBBJTIyJTIyJTIyJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRm5vbi1lbmhhbmNlZC1wcm9tcHQucG5nJTIyJTBBKS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSklMEFjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyMCUzRCUyMDAuNSUyMCUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEZGVwdGhfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjk5JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0-small&quot;</span>,
    torch_dtype=torch.float16,
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionXLControlNetImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    vae=vae,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
A photorealistic overhead image of a cat reclining sideways in a flamingo pool floatie holding a margarita. 
The cat is floating leisurely in the pool and completely relaxed and happy.
&quot;&quot;&quot;</span>
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png&quot;</span>
).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
controlnet_conditioning_scale = <span class="hljs-number">0.5</span> 
pipeline(
    prompt,
    image=image,
    control_image=depth_image,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
    strength=<span class="hljs-number">0.99</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=h("p"),o.textContent=f,J=r(),j(M.$$.fragment),u=r(),d=h("p"),d.innerHTML=s,y=r(),j(m.$$.fragment),b=r(),i=h("div"),i.innerHTML=B,this.h()},l(l){o=g(l,"P",{"data-svelte-h":!0}),w(o)!=="svelte-1gx6o1u"&&(o.textContent=f),J=c(l),Z(M.$$.fragment,l),u=c(l),d=g(l,"P",{"data-svelte-h":!0}),w(d)!=="svelte-19jdy5i"&&(d.innerHTML=s),y=c(l),Z(m.$$.fragment,l),b=c(l),i=g(l,"DIV",{style:!0,"data-svelte-h":!0}),w(i)!=="svelte-1ac87db"&&(i.innerHTML=B),this.h()},h(){T(i,"display","flex"),T(i,"gap","10px"),T(i,"justify-content","space-around"),T(i,"align-items","flex-end")},m(l,p){a(l,o,p),a(l,J,p),C(M,l,p),a(l,u,p),a(l,d,p),a(l,y,p),C(m,l,p),a(l,b,p),a(l,i,p),U=!0},p:ce,i(l){U||(W(M.$$.fragment,l),W(m.$$.fragment,l),U=!0)},o(l){I(M.$$.fragment,l),I(m.$$.fragment,l),U=!1},d(l){l&&(t(o),t(J),t(u),t(d),t(y),t(b),t(i)),G(M,l),G(m,l)}}}function ve(v){let o,f="Generate a mask image and convert it to a tensor to mark the pixels in the original image as masked if the corresponding pixel in the mask image is over a certain threshold.",J,M,u,d,s="Pass the mask and control image to the pipeline. Use the <code>controlnet_conditioning_scale</code> parameter to determine how much weight to assign to the control.",y,m,b,i,B='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">original image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat_mask.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">mask image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_rabbit_inpaint.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',U;return M=new N({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZub24tZW5oYW5jZWQtcHJvbXB0LnBuZyUyMiUwQSklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjIlMkZjb250ZW50JTJGY2F0X21hc2sucG5nJTIyJTBBKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBtYXNrX2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUwQSUwQWRlZiUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdlJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGluaXRfaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetInpaintPipeline, ControlNetModel

init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png&quot;</span>
)
init_image = init_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
mask_image = load_image(
    <span class="hljs-string">&quot;/content/cat_mask.png&quot;</span>
)
mask_image = mask_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
    image = np.array(image)
    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    image = Image.fromarray(image)
    <span class="hljs-keyword">return</span> image

control_image = make_canny_condition(init_image)`,wrap:!1}}),m=new N({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldElucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGN1dGUlMjBhbmQlMjBmbHVmZnklMjBidW5ueSUyMHJhYmJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuOTklMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)
pipeline = StableDiffusionXLControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
)
pipeline(
    <span class="hljs-string">&quot;a cute and fluffy bunny rabbit&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    strength=<span class="hljs-number">0.99</span>,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    image=init_image,
    mask_image=mask_image,
    control_image=control_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=h("p"),o.textContent=f,J=r(),j(M.$$.fragment),u=r(),d=h("p"),d.innerHTML=s,y=r(),j(m.$$.fragment),b=r(),i=h("div"),i.innerHTML=B,this.h()},l(l){o=g(l,"P",{"data-svelte-h":!0}),w(o)!=="svelte-1y2qw8o"&&(o.textContent=f),J=c(l),Z(M.$$.fragment,l),u=c(l),d=g(l,"P",{"data-svelte-h":!0}),w(d)!=="svelte-24u084"&&(d.innerHTML=s),y=c(l),Z(m.$$.fragment,l),b=c(l),i=g(l,"DIV",{style:!0,"data-svelte-h":!0}),w(i)!=="svelte-ggobk5"&&(i.innerHTML=B),this.h()},h(){T(i,"display","flex"),T(i,"gap","10px"),T(i,"justify-content","space-around"),T(i,"align-items","flex-end")},m(l,p){a(l,o,p),a(l,J,p),C(M,l,p),a(l,u,p),a(l,d,p),a(l,y,p),C(m,l,p),a(l,b,p),a(l,i,p),U=!0},p:ce,i(l){U||(W(M.$$.fragment,l),W(m.$$.fragment,l),U=!0)},o(l){I(M.$$.fragment,l),I(m.$$.fragment,l),U=!1},d(l){l&&(t(o),t(J),t(u),t(d),t(y),t(b),t(i)),G(M,l),G(m,l)}}}function Xe(v){let o,f,J,M,u,d;return o=new re({props:{id:"usage",option:"text-to-image",$$slots:{default:[Re]},$$scope:{ctx:v}}}),J=new re({props:{id:"usage",option:"image-to-image",$$slots:{default:[ke]},$$scope:{ctx:v}}}),u=new re({props:{id:"usage",option:"inpainting",$$slots:{default:[ve]},$$scope:{ctx:v}}}),{c(){j(o.$$.fragment),f=r(),j(J.$$.fragment),M=r(),j(u.$$.fragment)},l(s){Z(o.$$.fragment,s),f=c(s),Z(J.$$.fragment,s),M=c(s),Z(u.$$.fragment,s)},m(s,y){C(o,s,y),a(s,f,y),C(J,s,y),a(s,M,y),C(u,s,y),d=!0},p(s,y){const m={};y&2&&(m.$$scope={dirty:y,ctx:s}),o.$set(m);const b={};y&2&&(b.$$scope={dirty:y,ctx:s}),J.$set(b);const i={};y&2&&(i.$$scope={dirty:y,ctx:s}),u.$set(i)},i(s){d||(W(o.$$.fragment,s),W(J.$$.fragment,s),W(u.$$.fragment,s),d=!0)},o(s){I(o.$$.fragment,s),I(J.$$.fragment,s),I(u.$$.fragment,s),d=!1},d(s){s&&(t(f),t(M)),G(o,s),G(J,s),G(u,s)}}}function Ne(v){let o,f,J,M,u,d,s,y,m,b='<a href="https://huggingface.co/papers/2302.05543" rel="nofollow">ControlNet</a> is an adapter that enables controllable generation such as generating an image of a cat in a <em>specific pose</em> or following the lines in a sketch of a <em>specific</em> cat. It works by adding a smaller network of “zero convolution” layers and progressively training these to avoid disrupting with the original model. The original model parameters are frozen to avoid retraining it.',i,B,U="A ControlNet is conditioned on extra visual information or “structural controls” (canny edge, depth maps, human pose, etc.) that can be combined with text prompts to generate images that are guided by the visual input.",l,p,Me='<p>ControlNets are available to many models such as <a href="../api/pipelines/controlnet_flux">Flux</a>, <a href="../api/pipelines/controlnet_hunyuandit">Hunyuan-DiT</a>, <a href="../api/pipelines/controlnet_sd3">Stable Diffusion 3</a>, and more. The examples in this guide use Flux and Stable Diffusion XL.</p>',z,Y,de='Load a ControlNet conditioned on a specific control, such as canny edge, and pass it to the pipeline in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',L,X,D,_,q,x,ye="You can compose multiple ControlNet conditionings, such as canny image and a depth map, to create a <em>MultiControlNet</em>. For the best rersults, you should mask conditionings so they don’t overlap and experiment with different <code>controlnet_conditioning_scale</code> parameters to adjust how much weight is assigned to each control input.",K,Q,ue="The example below composes a canny image and depth map.",P,E,Je="Pass the ControlNets as a list to the pipeline and resize the images to the expected input size.",O,F,ee,R,he='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/multicontrolnet_depth.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">depth map</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_multi_controlnet.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',le,V,te,S,ge='<a href="https://github.com/lllyasviel/ControlNet/discussions/188" rel="nofollow">Guess mode</a> generates an image from <strong>only</strong> the control input (canny edge, depth map, pose, etc.) and without guidance from a prompt. It adjusts the scale of the ControlNet’s output residuals by a fixed ratio depending on block depth. The earlier <code>DownBlock</code> is only scaled by <code>0.1</code> and the <code>MidBlock</code> is fully scaled by <code>1.0</code>.',ae,$,ne,k,be='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/guess_mode.png" width="300" alt="Generated image (Guess mode)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',se,H,ie,A,oe;return u=new Ie({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),s=new me({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),X=new Be({props:{id:"usage",options:["text-to-image","image-to-image","inpainting"],$$slots:{default:[Xe]},$$scope:{ctx:v}}}),_=new me({props:{title:"Multi-ControlNet",local:"multi-controlnet",headingTag:"h2"}}),F=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL

controlnets = [
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0-small&quot;</span>, torch_dtype=torch.float16
    ),
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16,
    ),
]

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnets, vae=vae, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
a relaxed rabbit sitting on a striped towel next to a pool with a tropical drink nearby, 
bright sunny day, vacation scene, 35mm photograph, film, professional, 4k, highly detailed
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality, deformed, ugly&quot;</span>

images = [canny_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>)), depth_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))]

pipeline(
    prompt,
    negative_prompt=negative_prompt,
    image=images,
    num_inference_steps=<span class="hljs-number">100</span>,
    controlnet_conditioning_scale=[<span class="hljs-number">0.5</span>, <span class="hljs-number">0.5</span>],
    strength=<span class="hljs-number">0.7</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),V=new me({props:{title:"guess_mode",local:"guessmode",headingTag:"h2"}}),$=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pYW1nZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMmRpZmZ1c2VycyUyRmNvbnRyb2xuZXQtY2Fubnktc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhbm55LWNhdC5wbmclMjIpJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIyJTIyJTJDJTBBJTIwJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUwQSUyMCUyMGd1ZXNzX21vZGUlM0RUcnVlJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_iamge
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel

controlnet = ControlNetModel.from_pretrained(
  <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)
pipeline = StableDiffusionXLControlNetPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  controlnet=controlnet,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

canny_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png&quot;</span>)
pipeline(
  <span class="hljs-string">&quot;&quot;</span>,
  image=canny_image,
  guess_mode=<span class="hljs-literal">True</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),H=new Ge({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/controlnet.md"}}),{c(){o=h("meta"),f=r(),J=h("p"),M=r(),j(u.$$.fragment),d=r(),j(s.$$.fragment),y=r(),m=h("p"),m.innerHTML=b,i=r(),B=h("p"),B.textContent=U,l=r(),p=h("blockquote"),p.innerHTML=Me,z=r(),Y=h("p"),Y.innerHTML=de,L=r(),j(X.$$.fragment),D=r(),j(_.$$.fragment),q=r(),x=h("p"),x.innerHTML=ye,K=r(),Q=h("p"),Q.textContent=ue,P=r(),E=h("p"),E.textContent=Je,O=r(),j(F.$$.fragment),ee=r(),R=h("div"),R.innerHTML=he,le=r(),j(V.$$.fragment),te=r(),S=h("p"),S.innerHTML=ge,ae=r(),j($.$$.fragment),ne=r(),k=h("div"),k.innerHTML=be,se=r(),j(H.$$.fragment),ie=r(),A=h("p"),this.h()},l(e){const n=Ce("svelte-u9bgzb",document.head);o=g(n,"META",{name:!0,content:!0}),n.forEach(t),f=c(e),J=g(e,"P",{}),we(J).forEach(t),M=c(e),Z(u.$$.fragment,e),d=c(e),Z(s.$$.fragment,e),y=c(e),m=g(e,"P",{"data-svelte-h":!0}),w(m)!=="svelte-1n3ntx6"&&(m.innerHTML=b),i=c(e),B=g(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-1qp3bo6"&&(B.textContent=U),l=c(e),p=g(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),w(p)!=="svelte-17w1v3e"&&(p.innerHTML=Me),z=c(e),Y=g(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-88bwwp"&&(Y.innerHTML=de),L=c(e),Z(X.$$.fragment,e),D=c(e),Z(_.$$.fragment,e),q=c(e),x=g(e,"P",{"data-svelte-h":!0}),w(x)!=="svelte-11jp78z"&&(x.innerHTML=ye),K=c(e),Q=g(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-ueyms4"&&(Q.textContent=ue),P=c(e),E=g(e,"P",{"data-svelte-h":!0}),w(E)!=="svelte-1yb2pw9"&&(E.textContent=Je),O=c(e),Z(F.$$.fragment,e),ee=c(e),R=g(e,"DIV",{style:!0,"data-svelte-h":!0}),w(R)!=="svelte-1ols1y"&&(R.innerHTML=he),le=c(e),Z(V.$$.fragment,e),te=c(e),S=g(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-1cijut3"&&(S.innerHTML=ge),ae=c(e),Z($.$$.fragment,e),ne=c(e),k=g(e,"DIV",{style:!0,"data-svelte-h":!0}),w(k)!=="svelte-193ffwv"&&(k.innerHTML=be),se=c(e),Z(H.$$.fragment,e),ie=c(e),A=g(e,"P",{}),we(A).forEach(t),this.h()},h(){pe(o,"name","hf:doc:metadata"),pe(o,"content",Ye),pe(p,"class","tip"),T(R,"display","flex"),T(R,"gap","10px"),T(R,"justify-content","space-around"),T(R,"align-items","flex-end"),T(k,"display","flex"),T(k,"gap","10px"),T(k,"justify-content","space-around"),T(k,"align-items","flex-end")},m(e,n){We(document.head,o),a(e,f,n),a(e,J,n),a(e,M,n),C(u,e,n),a(e,d,n),C(s,e,n),a(e,y,n),a(e,m,n),a(e,i,n),a(e,B,n),a(e,l,n),a(e,p,n),a(e,z,n),a(e,Y,n),a(e,L,n),C(X,e,n),a(e,D,n),C(_,e,n),a(e,q,n),a(e,x,n),a(e,K,n),a(e,Q,n),a(e,P,n),a(e,E,n),a(e,O,n),C(F,e,n),a(e,ee,n),a(e,R,n),a(e,le,n),C(V,e,n),a(e,te,n),a(e,S,n),a(e,ae,n),C($,e,n),a(e,ne,n),a(e,k,n),a(e,se,n),C(H,e,n),a(e,ie,n),a(e,A,n),oe=!0},p(e,[n]){const Te={};n&2&&(Te.$$scope={dirty:n,ctx:e}),X.$set(Te)},i(e){oe||(W(u.$$.fragment,e),W(s.$$.fragment,e),W(X.$$.fragment,e),W(_.$$.fragment,e),W(F.$$.fragment,e),W(V.$$.fragment,e),W($.$$.fragment,e),W(H.$$.fragment,e),oe=!0)},o(e){I(u.$$.fragment,e),I(s.$$.fragment,e),I(X.$$.fragment,e),I(_.$$.fragment,e),I(F.$$.fragment,e),I(V.$$.fragment,e),I($.$$.fragment,e),I(H.$$.fragment,e),oe=!1},d(e){e&&(t(f),t(J),t(M),t(d),t(y),t(m),t(i),t(B),t(l),t(p),t(z),t(Y),t(L),t(D),t(q),t(x),t(K),t(Q),t(P),t(E),t(O),t(ee),t(R),t(le),t(te),t(S),t(ae),t(ne),t(k),t(se),t(ie),t(A)),t(o),G(u,e),G(s,e),G(X,e),G(_,e),G(F,e),G(V,e),G($,e),G(H,e)}}}const Ye='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Multi-ControlNet","local":"multi-controlnet","sections":[],"depth":2},{"title":"guess_mode","local":"guessmode","sections":[],"depth":2}],"depth":1}';function _e(v){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $e extends je{constructor(o){super(),Ze(this,o,_e,Ne,fe,{})}}export{$e as component};
