import{s as Dt,n as Et,o as Ot}from"../chunks/scheduler.53228c21.js";import{S as Kt,i as el,e as s,s as o,c as r,h as tl,a,d as l,b as i,f as zt,g as f,j as p,k as yt,l as ll,m as n,n as d,t as u,o as m,p as c}from"../chunks/index.100fac89.js";import{C as nl}from"../chunks/CopyLLMTxtMenu.2cdbb51f.js";import{C as b}from"../chunks/CodeBlock.d30a6509.js";import{H as h,E as ol}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3fcbbc76.js";function il(bt){let M,ye,he,be,w,we,v,ve,g,wt='<a href="https://developer.apple.com/documentation/coreml" rel="nofollow">Core ML</a> is the model format and machine learning library supported by Apple frameworks. If you are interested in running Stable Diffusion models inside your macOS or iOS/iPadOS apps, this guide will show you how to convert existing PyTorch checkpoints into the Core ML format and use them for inference with Python or Swift.',ge,U,vt="Core ML models can leverage all the compute engines available in Apple devices: the CPU, the GPU, and the Apple Neural Engine (or ANE, a tensor-optimized accelerator available in Apple Silicon Macs and modern iPhones/iPads). Depending on the model and the device it’s running on, Core ML can mix and match compute engines too, so some portions of the model may run on the CPU while others run on GPU, for example.",Ue,y,gt='<p>You can also run the <code>diffusers</code> Python codebase on Apple Silicon Macs using the <code>mps</code> accelerator built into PyTorch. This approach is explained in depth in <a href="mps">the mps guide</a>, but it is not compatible with native apps.</p>',Te,T,Ce,C,Ut="Stable Diffusion weights (or checkpoints) are stored in the PyTorch format, so you need to convert them to the Core ML format before we can use them inside native apps.",$e,$,Tt='Thankfully, Apple engineers developed <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">a conversion tool</a> based on <code>diffusers</code> to convert the PyTorch checkpoints to Core ML.',Je,J,Ct="Before you convert a model, though, take a moment to explore the Hugging Face Hub – chances are the model you’re interested in is already available in Core ML format:",je,j,$t='<li>the <a href="https://huggingface.co/apple" rel="nofollow">Apple</a> organization includes Stable Diffusion versions 1.4, 1.5, 2.0 base, and 2.1 base</li> <li><a href="https://huggingface.co/coreml-community" rel="nofollow">coreml community</a> includes custom finetuned models</li> <li>use this <a href="https://huggingface.co/models?pipeline_tag=text-to-image&amp;library=coreml&amp;p=2&amp;sort=likes" rel="nofollow">filter</a> to return all available Core ML checkpoints</li>',ke,k,Jt='If you can’t find the model you’re interested in, we recommend you follow the instructions for <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">Converting Models to Core ML</a> by Apple.',Le,L,Ge,G,jt="Stable Diffusion models can be converted to different Core ML variants intended for different purposes:",_e,_,kt='<li><p>The type of attention blocks used. The attention operation is used to “pay attention” to the relationship between different areas in the image representations and to understand how the image and text representations are related. Attention is compute- and memory-intensive, so different implementations exist that consider the hardware characteristics of different devices. For Core ML Stable Diffusion models, there are two attention variants:</p> <ul><li><code>split_einsum</code> (<a href="https://machinelearning.apple.com/research/neural-engine-transformers" rel="nofollow">introduced by Apple</a>) is optimized for ANE devices, which is available in modern iPhones, iPads and M-series computers.</li> <li>The “original” attention (the base implementation used in <code>diffusers</code>) is only compatible with CPU/GPU and not ANE. It can be <em>faster</em> to run your model on CPU + GPU using <code>original</code> attention than ANE. See <a href="https://huggingface.co/blog/fast-mac-diffusers#performance-benchmarks" rel="nofollow">this performance benchmark</a> as well as some <a href="https://github.com/huggingface/swift-coreml-diffusers/issues/31" rel="nofollow">additional measures provided by the community</a> for additional details.</li></ul></li> <li><p>The supported inference framework.</p> <ul><li><code>packages</code> are suitable for Python inference. This can be used to test converted Core ML models before attempting to integrate them inside native apps, or if you want to explore Core ML performance but don’t need to support native apps. For example, an application with a web UI could perfectly use a Python Core ML backend.</li> <li><code>compiled</code> models are required for Swift code. The <code>compiled</code> models in the Hub split the large UNet model weights into several files for compatibility with iOS and iPadOS devices. This corresponds to the <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow"><code>--chunk-unet</code> conversion option</a>. If you want to support native apps, then you need to select the <code>compiled</code> variant.</li></ul></li>',xe,x,Lt='The official Core ML Stable Diffusion <a href="https://huggingface.co/apple/coreml-stable-diffusion-v1-4/tree/main" rel="nofollow">models</a> include these variants, but the community ones may vary:',Ze,Z,Be,B,Gt="You can download and use the variant you need as shown below.",We,W,Ne,N,_t="Install the following libraries to run Core ML inference in Python:",Xe,X,Se,S,Ie,I,xt="To run inference in Python, use one of the versions stored in the <code>packages</code> folders because the <code>compiled</code> ones are only compatible with Swift. You may choose whether you want to use <code>original</code> or <code>split_einsum</code> attention.",Pe,P,Zt="This is how you’d download the <code>original</code> attention variant from the Hub to a directory called <code>models</code>:",Ye,Y,He,H,Re,R,Bt="Once you have downloaded a snapshot of the model, you can test it using Apple’s Python script.",Fe,F,Ae,A,Wt="Pass the path of the downloaded checkpoint with <code>-i</code> flag to the script. <code>--compute-unit</code> indicates the hardware you want to allow for inference. It must be one of the following options: <code>ALL</code>, <code>CPU_AND_GPU</code>, <code>CPU_ONLY</code>, <code>CPU_AND_NE</code>. You may also provide an optional output path, and a seed for reproducibility.",Ve,V,Nt="The inference script assumes you’re using the original version of the Stable Diffusion model, <code>CompVis/stable-diffusion-v1-4</code>. If you use another model, you <em>have</em> to specify its Hub id in the inference command line, using the <code>--model-version</code> option. This works for models already supported and custom models you trained or fine-tuned yourself.",qe,q,Xt='For example, if you want to use <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>:',Qe,Q,ze,z,De,D,St="Running inference in Swift is slightly faster than in Python because the models are already compiled in the <code>mlmodelc</code> format. This is noticeable on app startup when the model is loaded but shouldn’t be noticeable if you run several generations afterward.",Ee,E,Oe,O,It="To run inference in Swift on your Mac, you need one of the <code>compiled</code> checkpoint versions. We recommend you download them locally using Python code similar to the previous example, but with one of the <code>compiled</code> variants:",Ke,K,et,ee,tt,te,Pt="To run inference, please clone Apple’s repo:",lt,le,nt,ne,Yt='And then use Apple’s command line tool, <a href="https://www.swift.org/package-manager/#" rel="nofollow">Swift Package Manager</a>:',ot,oe,it,ie,Ht="You have to specify in <code>--resource-path</code> one of the checkpoints downloaded in the previous step, so please make sure it contains compiled Core ML bundles with the extension <code>.mlmodelc</code>. The <code>--compute-units</code> has to be one of these values: <code>all</code>, <code>cpuOnly</code>, <code>cpuAndGPU</code>, <code>cpuAndNeuralEngine</code>.",st,se,Rt='For more details, please refer to the <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">instructions in Apple’s repo</a>.',at,ae,pt,pe,Ft="The Core ML models and inference code don’t support many of the features, options, and flexibility of 🧨 Diffusers. These are some of the limitations to keep in mind:",rt,re,At="<li>Core ML models are only suitable for inference. They can’t be used for training or fine-tuning.</li> <li>Only two schedulers have been ported to Swift, the default one used by Stable Diffusion and <code>DPMSolverMultistepScheduler</code>, which we ported to Swift from our <code>diffusers</code> implementation. We recommend you use <code>DPMSolverMultistepScheduler</code>, since it produces the same quality in about half the steps.</li> <li>Negative prompts, classifier-free guidance scale, and image-to-image tasks are available in the inference code. Advanced features such as depth guidance, ControlNet, and latent upscalers are not available yet.</li>",ft,fe,Vt='Apple’s <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">conversion and inference repo</a> and our own <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">swift-coreml-diffusers</a> repos are intended as technology demonstrators to enable other developers to build upon.',dt,de,qt="If you feel strongly about any missing features, please feel free to open a feature request or, better yet, a contribution PR 🙂.",ut,ue,mt,me,Qt='One easy way to run Stable Diffusion on your own Apple hardware is to use <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">our open-source Swift repo</a>, based on <code>diffusers</code> and Apple’s conversion and inference repo. You can study the code, compile it with <a href="https://developer.apple.com/xcode/" rel="nofollow">Xcode</a> and adapt it for your own needs. For your convenience, there’s also a <a href="https://apps.apple.com/app/diffusers/id1666309574" rel="nofollow">standalone Mac app in the App Store</a>, so you can play with it without having to deal with the code or IDE. If you are a developer and have determined that Core ML is the best solution to build your Stable Diffusion app, then you can use the rest of this guide to get started with your project. We can’t wait to see what you’ll build 🙂.',ct,ce,ht,Me,Mt;return w=new nl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new h({props:{title:"How to run Stable Diffusion with Core ML",local:"how-to-run-stable-diffusion-with-core-ml",headingTag:"h1"}}),T=new h({props:{title:"Stable Diffusion Core ML Checkpoints",local:"stable-diffusion-core-ml-checkpoints",headingTag:"h2"}}),L=new h({props:{title:"Selecting the Core ML Variant to Use",local:"selecting-the-core-ml-variant-to-use",headingTag:"h2"}}),Z=new b({props:{code:"Y29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG9yaWdpbmFsJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29tcGlsZWQlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBwYWNrYWdlcyUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNwbGl0X2VpbnN1bSUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbXBpbGVkJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcGFja2FnZXM=",highlighted:`coreml-stable-<span class="hljs-keyword">diffusion-v1-4
</span>├── README.md
├── <span class="hljs-keyword">original
</span>│   ├── compiled
│   └── packages
└── split_einsum
    ├── compiled
    └── packages`,wrap:!1}}),W=new h({props:{title:"Core ML Inference in Python",local:"core-ml-inference-in-python",headingTag:"h2"}}),X=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`pip install huggingface_hub
pip install git+https://github.com/apple/ml-stable-diffusion`,wrap:!1}}),S=new h({props:{title:"Download the Model Checkpoints",local:"download-the-model-checkpoints",headingTag:"h3"}}),Y=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRnBhY2thZ2VzJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/packages&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),H=new h({props:{title:"Inference",local:"python-inference",headingTag:"h3"}}),F=new b({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtaSUyMC4lMkZtb2RlbHMlMkZjb3JlbWwtc3RhYmxlLWRpZmZ1c2lvbi12MS00X29yaWdpbmFsX3BhY2thZ2VzJTJGb3JpZ2luYWwlMkZwYWNrYWdlcyUyMC1vJTIwJTNDJTJGcGF0aCUyRnRvJTJGb3V0cHV0JTJGaW1hZ2UlM0UlMjAtLWNvbXB1dGUtdW5pdCUyMENQVV9BTkRfR1BVJTIwLS1zZWVkJTIwOTM=",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; -i ./models/coreml-stable-diffusion-v1-4_original_packages/original/packages -o &lt;/path/to/output/image&gt; --compute-unit CPU_AND_GPU --seed 93",wrap:!1}}),Q=new b({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtLWNvbXB1dGUtdW5pdCUyMEFMTCUyMC1vJTIwb3V0cHV0JTIwLS1zZWVkJTIwOTMlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTVfb3JpZ2luYWxfcGFja2FnZXMlMjAtLW1vZGVsLXZlcnNpb24lMjBzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; --compute-unit ALL -o output --seed 93 -i models/coreml-stable-diffusion-v1-5_original_packages --model-version stable-diffusion-v1-5/stable-diffusion-v1-5",wrap:!1}}),z=new h({props:{title:"Core ML inference in Swift",local:"core-ml-inference-in-swift",headingTag:"h2"}}),E=new h({props:{title:"Download",local:"download",headingTag:"h3"}}),K=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRmNvbXBpbGVkJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/compiled&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),ee=new h({props:{title:"Inference",local:"swift-inference",headingTag:"h3"}}),le=new b({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24lMEFjZCUyMG1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/apple/ml-stable-diffusion
<span class="hljs-built_in">cd</span> ml-stable-diffusion`,wrap:!1}}),oe=new b({props:{code:"c3dpZnQlMjBydW4lMjBTdGFibGVEaWZmdXNpb25TYW1wbGUlMjAtLXJlc291cmNlLXBhdGglMjBtb2RlbHMlMkZjb3JlbWwtc3RhYmxlLWRpZmZ1c2lvbi12MS00X29yaWdpbmFsX2NvbXBpbGVkJTIwLS1jb21wdXRlLXVuaXRzJTIwYWxsJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMg==",highlighted:'swift run StableDiffusionSample --resource-path models/coreml-stable-diffusion-v1-4_original_compiled --compute-units all <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>',wrap:!1}}),ae=new h({props:{title:"Supported Diffusers Features",local:"supported-diffusers-features",headingTag:"h2"}}),ue=new h({props:{title:"Native Diffusers Swift app",local:"native-diffusers-swift-app",headingTag:"h2"}}),ce=new ol({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/coreml.md"}}),{c(){M=s("meta"),ye=o(),he=s("p"),be=o(),r(w.$$.fragment),we=o(),r(v.$$.fragment),ve=o(),g=s("p"),g.innerHTML=wt,ge=o(),U=s("p"),U.textContent=vt,Ue=o(),y=s("blockquote"),y.innerHTML=gt,Te=o(),r(T.$$.fragment),Ce=o(),C=s("p"),C.textContent=Ut,$e=o(),$=s("p"),$.innerHTML=Tt,Je=o(),J=s("p"),J.textContent=Ct,je=o(),j=s("ul"),j.innerHTML=$t,ke=o(),k=s("p"),k.innerHTML=Jt,Le=o(),r(L.$$.fragment),Ge=o(),G=s("p"),G.textContent=jt,_e=o(),_=s("ul"),_.innerHTML=kt,xe=o(),x=s("p"),x.innerHTML=Lt,Ze=o(),r(Z.$$.fragment),Be=o(),B=s("p"),B.textContent=Gt,We=o(),r(W.$$.fragment),Ne=o(),N=s("p"),N.textContent=_t,Xe=o(),r(X.$$.fragment),Se=o(),r(S.$$.fragment),Ie=o(),I=s("p"),I.innerHTML=xt,Pe=o(),P=s("p"),P.innerHTML=Zt,Ye=o(),r(Y.$$.fragment),He=o(),r(H.$$.fragment),Re=o(),R=s("p"),R.textContent=Bt,Fe=o(),r(F.$$.fragment),Ae=o(),A=s("p"),A.innerHTML=Wt,Ve=o(),V=s("p"),V.innerHTML=Nt,qe=o(),q=s("p"),q.innerHTML=Xt,Qe=o(),r(Q.$$.fragment),ze=o(),r(z.$$.fragment),De=o(),D=s("p"),D.innerHTML=St,Ee=o(),r(E.$$.fragment),Oe=o(),O=s("p"),O.innerHTML=It,Ke=o(),r(K.$$.fragment),et=o(),r(ee.$$.fragment),tt=o(),te=s("p"),te.textContent=Pt,lt=o(),r(le.$$.fragment),nt=o(),ne=s("p"),ne.innerHTML=Yt,ot=o(),r(oe.$$.fragment),it=o(),ie=s("p"),ie.innerHTML=Ht,st=o(),se=s("p"),se.innerHTML=Rt,at=o(),r(ae.$$.fragment),pt=o(),pe=s("p"),pe.textContent=Ft,rt=o(),re=s("ul"),re.innerHTML=At,ft=o(),fe=s("p"),fe.innerHTML=Vt,dt=o(),de=s("p"),de.textContent=qt,ut=o(),r(ue.$$.fragment),mt=o(),me=s("p"),me.innerHTML=Qt,ct=o(),r(ce.$$.fragment),ht=o(),Me=s("p"),this.h()},l(e){const t=tl("svelte-u9bgzb",document.head);M=a(t,"META",{name:!0,content:!0}),t.forEach(l),ye=i(e),he=a(e,"P",{}),zt(he).forEach(l),be=i(e),f(w.$$.fragment,e),we=i(e),f(v.$$.fragment,e),ve=i(e),g=a(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-qaabbu"&&(g.innerHTML=wt),ge=i(e),U=a(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1orjtw1"&&(U.textContent=vt),Ue=i(e),y=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-1x3ijlm"&&(y.innerHTML=gt),Te=i(e),f(T.$$.fragment,e),Ce=i(e),C=a(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-17hueww"&&(C.textContent=Ut),$e=i(e),$=a(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-x5a2v2"&&($.innerHTML=Tt),Je=i(e),J=a(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-4w8fdi"&&(J.textContent=Ct),je=i(e),j=a(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-1lfif8r"&&(j.innerHTML=$t),ke=i(e),k=a(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-eg00q0"&&(k.innerHTML=Jt),Le=i(e),f(L.$$.fragment,e),Ge=i(e),G=a(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1tgahft"&&(G.textContent=jt),_e=i(e),_=a(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-1mnjc4n"&&(_.innerHTML=kt),xe=i(e),x=a(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1uzdjfm"&&(x.innerHTML=Lt),Ze=i(e),f(Z.$$.fragment,e),Be=i(e),B=a(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1xkemdi"&&(B.textContent=Gt),We=i(e),f(W.$$.fragment,e),Ne=i(e),N=a(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-19xoujm"&&(N.textContent=_t),Xe=i(e),f(X.$$.fragment,e),Se=i(e),f(S.$$.fragment,e),Ie=i(e),I=a(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1k484f2"&&(I.innerHTML=xt),Pe=i(e),P=a(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1vn0h7b"&&(P.innerHTML=Zt),Ye=i(e),f(Y.$$.fragment,e),He=i(e),f(H.$$.fragment,e),Re=i(e),R=a(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-83ivzw"&&(R.textContent=Bt),Fe=i(e),f(F.$$.fragment,e),Ae=i(e),A=a(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-hcctjd"&&(A.innerHTML=Wt),Ve=i(e),V=a(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-hhlwnj"&&(V.innerHTML=Nt),qe=i(e),q=a(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-hoaw7z"&&(q.innerHTML=Xt),Qe=i(e),f(Q.$$.fragment,e),ze=i(e),f(z.$$.fragment,e),De=i(e),D=a(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1j3moem"&&(D.innerHTML=St),Ee=i(e),f(E.$$.fragment,e),Oe=i(e),O=a(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1u2q3bb"&&(O.innerHTML=It),Ke=i(e),f(K.$$.fragment,e),et=i(e),f(ee.$$.fragment,e),tt=i(e),te=a(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1a6a1za"&&(te.textContent=Pt),lt=i(e),f(le.$$.fragment,e),nt=i(e),ne=a(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1sx1rnz"&&(ne.innerHTML=Yt),ot=i(e),f(oe.$$.fragment,e),it=i(e),ie=a(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-12c7wn6"&&(ie.innerHTML=Ht),st=i(e),se=a(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-14s5isr"&&(se.innerHTML=Rt),at=i(e),f(ae.$$.fragment,e),pt=i(e),pe=a(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-q86h2"&&(pe.textContent=Ft),rt=i(e),re=a(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-1jpknop"&&(re.innerHTML=At),ft=i(e),fe=a(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-5goosl"&&(fe.innerHTML=Vt),dt=i(e),de=a(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-fa2zni"&&(de.textContent=qt),ut=i(e),f(ue.$$.fragment,e),mt=i(e),me=a(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-m342fh"&&(me.innerHTML=Qt),ct=i(e),f(ce.$$.fragment,e),ht=i(e),Me=a(e,"P",{}),zt(Me).forEach(l),this.h()},h(){yt(M,"name","hf:doc:metadata"),yt(M,"content",sl),yt(y,"class","tip")},m(e,t){ll(document.head,M),n(e,ye,t),n(e,he,t),n(e,be,t),d(w,e,t),n(e,we,t),d(v,e,t),n(e,ve,t),n(e,g,t),n(e,ge,t),n(e,U,t),n(e,Ue,t),n(e,y,t),n(e,Te,t),d(T,e,t),n(e,Ce,t),n(e,C,t),n(e,$e,t),n(e,$,t),n(e,Je,t),n(e,J,t),n(e,je,t),n(e,j,t),n(e,ke,t),n(e,k,t),n(e,Le,t),d(L,e,t),n(e,Ge,t),n(e,G,t),n(e,_e,t),n(e,_,t),n(e,xe,t),n(e,x,t),n(e,Ze,t),d(Z,e,t),n(e,Be,t),n(e,B,t),n(e,We,t),d(W,e,t),n(e,Ne,t),n(e,N,t),n(e,Xe,t),d(X,e,t),n(e,Se,t),d(S,e,t),n(e,Ie,t),n(e,I,t),n(e,Pe,t),n(e,P,t),n(e,Ye,t),d(Y,e,t),n(e,He,t),d(H,e,t),n(e,Re,t),n(e,R,t),n(e,Fe,t),d(F,e,t),n(e,Ae,t),n(e,A,t),n(e,Ve,t),n(e,V,t),n(e,qe,t),n(e,q,t),n(e,Qe,t),d(Q,e,t),n(e,ze,t),d(z,e,t),n(e,De,t),n(e,D,t),n(e,Ee,t),d(E,e,t),n(e,Oe,t),n(e,O,t),n(e,Ke,t),d(K,e,t),n(e,et,t),d(ee,e,t),n(e,tt,t),n(e,te,t),n(e,lt,t),d(le,e,t),n(e,nt,t),n(e,ne,t),n(e,ot,t),d(oe,e,t),n(e,it,t),n(e,ie,t),n(e,st,t),n(e,se,t),n(e,at,t),d(ae,e,t),n(e,pt,t),n(e,pe,t),n(e,rt,t),n(e,re,t),n(e,ft,t),n(e,fe,t),n(e,dt,t),n(e,de,t),n(e,ut,t),d(ue,e,t),n(e,mt,t),n(e,me,t),n(e,ct,t),d(ce,e,t),n(e,ht,t),n(e,Me,t),Mt=!0},p:Et,i(e){Mt||(u(w.$$.fragment,e),u(v.$$.fragment,e),u(T.$$.fragment,e),u(L.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(H.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(z.$$.fragment,e),u(E.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(ue.$$.fragment,e),u(ce.$$.fragment,e),Mt=!0)},o(e){m(w.$$.fragment,e),m(v.$$.fragment,e),m(T.$$.fragment,e),m(L.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(S.$$.fragment,e),m(Y.$$.fragment,e),m(H.$$.fragment,e),m(F.$$.fragment,e),m(Q.$$.fragment,e),m(z.$$.fragment,e),m(E.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(ae.$$.fragment,e),m(ue.$$.fragment,e),m(ce.$$.fragment,e),Mt=!1},d(e){e&&(l(ye),l(he),l(be),l(we),l(ve),l(g),l(ge),l(U),l(Ue),l(y),l(Te),l(Ce),l(C),l($e),l($),l(Je),l(J),l(je),l(j),l(ke),l(k),l(Le),l(Ge),l(G),l(_e),l(_),l(xe),l(x),l(Ze),l(Be),l(B),l(We),l(Ne),l(N),l(Xe),l(Se),l(Ie),l(I),l(Pe),l(P),l(Ye),l(He),l(Re),l(R),l(Fe),l(Ae),l(A),l(Ve),l(V),l(qe),l(q),l(Qe),l(ze),l(De),l(D),l(Ee),l(Oe),l(O),l(Ke),l(et),l(tt),l(te),l(lt),l(nt),l(ne),l(ot),l(it),l(ie),l(st),l(se),l(at),l(pt),l(pe),l(rt),l(re),l(ft),l(fe),l(dt),l(de),l(ut),l(mt),l(me),l(ct),l(ht),l(Me)),l(M),c(w,e),c(v,e),c(T,e),c(L,e),c(Z,e),c(W,e),c(X,e),c(S,e),c(Y,e),c(H,e),c(F,e),c(Q,e),c(z,e),c(E,e),c(K,e),c(ee,e),c(le,e),c(oe,e),c(ae,e),c(ue,e),c(ce,e)}}}const sl='{"title":"How to run Stable Diffusion with Core ML","local":"how-to-run-stable-diffusion-with-core-ml","sections":[{"title":"Stable Diffusion Core ML Checkpoints","local":"stable-diffusion-core-ml-checkpoints","sections":[],"depth":2},{"title":"Selecting the Core ML Variant to Use","local":"selecting-the-core-ml-variant-to-use","sections":[],"depth":2},{"title":"Core ML Inference in Python","local":"core-ml-inference-in-python","sections":[{"title":"Download the Model Checkpoints","local":"download-the-model-checkpoints","sections":[],"depth":3},{"title":"Inference","local":"python-inference","sections":[],"depth":3}],"depth":2},{"title":"Core ML inference in Swift","local":"core-ml-inference-in-swift","sections":[{"title":"Download","local":"download","sections":[],"depth":3},{"title":"Inference","local":"swift-inference","sections":[],"depth":3}],"depth":2},{"title":"Supported Diffusers Features","local":"supported-diffusers-features","sections":[],"depth":2},{"title":"Native Diffusers Swift app","local":"native-diffusers-swift-app","sections":[],"depth":2}],"depth":1}';function al(bt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends Kt{constructor(M){super(),el(this,M,al,il,Dt,{})}}export{ml as component};
