import{s as Bl,o as Il,n as gl}from"../chunks/scheduler.53228c21.js";import{S as Wl,i as _l,e as y,s as p,c as b,h as vl,a as d,d as t,b as m,f as Zl,g as h,j as f,k as cl,l as Xl,m as a,n as T,t as w,o as U,p as j}from"../chunks/index.100fac89.js";import{C as Vl}from"../chunks/CopyLLMTxtMenu.2cdbb51f.js";import{C as ml}from"../chunks/CodeBlock.d30a6509.js";import{H as rl,E as Cl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3fcbbc76.js";import{H as Yl,a as Gl}from"../chunks/HfOption.fad27e59.js";function Rl(Z){let s,u='<a href="./memory#model-offloading">Model CPU offloading</a> moves an individual pipeline component, like the transformer model, to the GPU when it is needed for computation. Otherwise, it is offloaded to the CPU.',r,c,n;return c=new ml({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXRvcmNoLl9keW5hbW8uY29uZmlnLmNhY2hlX3NpemVfbGltaXQlMjAlM0QlMjAxMDAwJTBBdG9yY2guX2R5bmFtby5jb25maWcuY2FwdHVyZV9keW5hbWljX291dHB1dF9zaGFwZV9vcHMlMjAlM0QlMjBUcnVlJTBBJTBBJTIzJTIwcXVhbnRpemUlMEFwaXBlbGluZV9xdWFudF9jb25maWclMjAlM0QlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBxdWFudF9iYWNrZW5kJTNEJTIyYml0c2FuZGJ5dGVzXzRiaXQlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudF9rd2FyZ3MlM0QlN0IlMjJsb2FkX2luXzRiaXQlMjIlM0ElMjBUcnVlJTJDJTIwJTIyYm5iXzRiaXRfcXVhbnRfdHlwZSUyMiUzQSUyMCUyMm5mNCUyMiUyQyUyMCUyMmJuYl80Yml0X2NvbXB1dGVfZHR5cGUlMjIlM0ElMjB0b3JjaC5iZmxvYXQxNiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbXBvbmVudHNfdG9fcXVhbnRpemUlM0QlNUIlMjJ0cmFuc2Zvcm1lciUyMiUyQyUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTVEJTJDJTBBKSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RwaXBlbGluZV9xdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMG1vZGVsJTIwQ1BVJTIwb2ZmbG9hZGluZyUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwY29tcGlsZSUwQXBpcGVsaW5lLnRyYW5zZm9ybWVyLmNvbXBpbGUoKSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTIyJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

torch._dynamo.config.cache_size_limit = <span class="hljs-number">1000</span>
torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># model CPU offloading</span>
pipeline.enable_model_cpu_offload()

<span class="hljs-comment"># compile</span>
pipeline.transformer.<span class="hljs-built_in">compile</span>()
pipeline(
    <span class="hljs-string">&quot;cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=y("p"),s.innerHTML=u,r=p(),b(c.$$.fragment)},l(o){s=d(o,"P",{"data-svelte-h":!0}),f(s)!=="svelte-2htktv"&&(s.innerHTML=u),r=m(o),h(c.$$.fragment,o)},m(o,M){a(o,s,M),a(o,r,M),T(c,o,M),n=!0},p:gl,i(o){n||(w(c.$$.fragment,o),n=!0)},o(o){U(c.$$.fragment,o),n=!1},d(o){o&&(t(s),t(r)),j(c,o)}}}function kl(Z){let s,u='<a href="./memory#group-offloading">Group offloading</a> moves the internal layers of an individual pipeline component, like the transformer model, to the GPU for computation and offloads it when it’s not required. At the same time, it uses the <a href="./memory#cuda-stream">CUDA stream</a> feature to prefetch the next layer for execution.',r,c,n="By overlapping computation and data transfer, it is faster than model CPU offloading while also saving memory.",o,M,J;return M=new ml({props:{code:"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",highlighted:`<span class="hljs-comment"># pip install ftfy</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> UMT5EncoderModel

torch._dynamo.config.cache_size_limit = <span class="hljs-number">1000</span>
torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder&quot;</span>],
)

text_encoder = UMT5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># group offloading</span>
onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)

pipeline.transformer.enable_group_offload(
    onload_device=onload_device,
    offload_device=offload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)
pipeline.vae.enable_group_offload(
    onload_device=onload_device,
    offload_device=offload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)
apply_group_offloading(
    pipeline.text_encoder,
    onload_device=onload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># compile</span>
pipeline.transformer.<span class="hljs-built_in">compile</span>()

prompt = <span class="hljs-string">&quot;&quot;&quot;
The camera rushes from far to near in a low-angle shot, 
revealing a white ferret on a log. It plays, leaps into the water, and emerges, as the camera zooms in 
for a close-up. Water splashes berry bushes nearby, while moss, snow, and leaves blanket the ground. 
Birch trees and a light blue sky frame the scene, with ferns in the foreground. Side lighting casts dynamic 
shadows and warm highlights. Medium composition, front view, low angle, with depth of field.
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;&quot;
Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, 
low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, 
misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards
&quot;&quot;&quot;</span>

output = pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_frames=<span class="hljs-number">81</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){s=y("p"),s.innerHTML=u,r=p(),c=y("p"),c.textContent=n,o=p(),b(M.$$.fragment)},l(i){s=d(i,"P",{"data-svelte-h":!0}),f(s)!=="svelte-h38yli"&&(s.innerHTML=u),r=m(i),c=d(i,"P",{"data-svelte-h":!0}),f(c)!=="svelte-1f0mtjr"&&(c.textContent=n),o=m(i),h(M.$$.fragment,i)},m(i,G){a(i,s,G),a(i,r,G),a(i,c,G),a(i,o,G),T(M,i,G),J=!0},p:gl,i(i){J||(w(M.$$.fragment,i),J=!0)},o(i){U(M.$$.fragment,i),J=!1},d(i){i&&(t(s),t(r),t(c),t(o)),j(M,i)}}}function ql(Z){let s,u,r,c;return s=new Gl({props:{id:"offloading",option:"model CPU offloading",$$slots:{default:[Rl]},$$scope:{ctx:Z}}}),r=new Gl({props:{id:"offloading",option:"group offloading",$$slots:{default:[kl]},$$scope:{ctx:Z}}}),{c(){b(s.$$.fragment),u=p(),b(r.$$.fragment)},l(n){h(s.$$.fragment,n),u=m(n),h(r.$$.fragment,n)},m(n,o){T(s,n,o),a(n,u,o),T(r,n,o),c=!0},p(n,o){const M={};o&2&&(M.$$scope={dirty:o,ctx:n}),s.$set(M);const J={};o&2&&(J.$$scope={dirty:o,ctx:n}),r.$set(J)},i(n){c||(w(s.$$.fragment,n),w(r.$$.fragment,n),c=!0)},o(n){U(s.$$.fragment,n),U(r.$$.fragment,n),c=!1},d(n){n&&t(u),j(s,n),j(r,n)}}}function Ql(Z){let s,u,r,c,n,o,M,J,i,G='Optimizing models often involves trade-offs between <a href="./fp16">inference speed</a> and <a href="./memory">memory-usage</a>. For instance, while <a href="./cache">caching</a> can boost inference speed, it also increases memory consumption since it needs to store the outputs of intermediate attention layers. A more balanced optimization strategy combines quantizing a model, <a href="./fp16#torchcompile">torch.compile</a> and various <a href="./memory#offloading">offloading methods</a>.',x,g,Ml='<p>Check the <a href="./fp16#torchcompile">torch.compile</a> guide to learn more about compilation and how they can be applied here. For example, regional compilation can significantly reduce compilation time without giving up any speedups.</p>',H,I,yl='For image generation, combining quantization and <a href="./memory#model-offloading">model offloading</a> can often give the best trade-off between quality, speed, and memory. Group offloading is not as effective for image generation because it is usually not possible to <em>fully</em> overlap data transfer if the compute kernel finishes faster. This results in some communication overhead between the CPU and GPU.',N,W,dl='For video generation, combining quantization and <a href="./memory#group-offloading">group-offloading</a> tends to be better because video models are more compute-bound.',S,_,ul="The table below provides a comparison of optimization strategy combinations and their impact on latency and memory-usage for Flux.",A,v,fl="<thead><tr><th>combination</th> <th>latency (s)</th> <th>memory-usage (GB)</th></tr></thead> <tbody><tr><td>quantization</td> <td>32.602</td> <td>14.9453</td></tr> <tr><td>quantization, torch.compile</td> <td>25.847</td> <td>14.9448</td></tr> <tr><td>quantization, torch.compile, model CPU offloading</td> <td>32.312</td> <td>12.2369</td></tr></tbody>",L,X,Jl='These results are benchmarked on Flux with a RTX 4090. The transformer and text_encoder components are quantized. Refer to the <a href="https://gist.github.com/sayakpaul/0db9d8eeeb3d2a0e5ed7cf0d9ca19b7d">benchmarking script</a> if you&#39;re interested in evaluating your own model.',D,V,bl='This guide will show you how to compile and offload a quantized model with <a href="../quantization/bitsandbytes#torchcompile">bitsandbytes</a>. Make sure you are using <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch nightly</a> and the latest version of bitsandbytes.',P,C,K,Y,O,R,hl='Start by <a href="../quantization/overview">quantizing</a> a model to reduce the memory required for storage and <a href="./fp16#torchcompile">compiling</a> it to accelerate inference.',ll,k,Tl='Configure the <a href="https://docs.pytorch.org/docs/stable/torch.compiler_dynamo_overview.html" rel="nofollow">Dynamo</a> <code>capture_dynamic_output_shape_ops = True</code> to handle dynamic outputs when compiling bitsandbytes models.',el,q,tl,Q,al,F,wl="In addition to quantization and torch.compile, try offloading if you need to reduce memory-usage further. Offloading moves various layers or model components from the CPU to the GPU as needed for computations.",nl,z,Ul='Configure the <a href="https://docs.pytorch.org/docs/stable/torch.compiler_dynamo_overview.html" rel="nofollow">Dynamo</a> <code>cache_size_limit</code> during offloading to avoid excessive recompilation and set <code>capture_dynamic_output_shape_ops = True</code> to handle dynamic outputs when compiling bitsandbytes models.',sl,B,ol,E,il,$,pl;return n=new Vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new rl({props:{title:"Compiling and offloading quantized models",local:"compiling-and-offloading-quantized-models",headingTag:"h1"}}),C=new ml({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),Y=new rl({props:{title:"Quantization and torch.compile",local:"quantization-and-torchcompile",headingTag:"h2"}}),q=new ml({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXRvcmNoLl9keW5hbW8uY29uZmlnLmNhcHR1cmVfZHluYW1pY19vdXRwdXRfc2hhcGVfb3BzJTIwJTNEJTIwVHJ1ZSUwQSUwQSUyMyUyMHF1YW50aXplJTBBcGlwZWxpbmVfcXVhbnRfY29uZmlnJTIwJTNEJTIwUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcXVhbnRfYmFja2VuZCUzRCUyMmJpdHNhbmRieXRlc180Yml0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRfa3dhcmdzJTNEJTdCJTIybG9hZF9pbl80Yml0JTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMmJuYl80Yml0X3F1YW50X3R5cGUlMjIlM0ElMjAlMjJuZjQlMjIlMkMlMjAlMjJibmJfNGJpdF9jb21wdXRlX2R0eXBlJTIyJTNBJTIwdG9yY2guYmZsb2F0MTYlN0QlMkMlMEElMjAlMjAlMjAlMjBjb21wb25lbnRzX3RvX3F1YW50aXplJTNEJTVCJTIydHJhbnNmb3JtZXIlMjIlMkMlMjAlMjJ0ZXh0X2VuY29kZXJfMiUyMiU1RCUyQyUwQSklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBjb21waWxlJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIuY29tcGlsZShtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlbGluZSglMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQSUyMCUyMCUyMCUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># compile</span>
pipeline.transformer.to(memory_format=torch.channels_last)
pipeline.transformer.<span class="hljs-built_in">compile</span>(mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipeline(<span class="hljs-string">&quot;&quot;&quot;
    cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
    highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Q=new rl({props:{title:"Quantization, torch.compile, and offloading",local:"quantization-torchcompile-and-offloading",headingTag:"h2"}}),B=new Yl({props:{id:"offloading",options:["model CPU offloading","group offloading"],$$slots:{default:[ql]},$$scope:{ctx:Z}}}),E=new Cl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/speed-memory-optims.md"}}),{c(){s=y("meta"),u=p(),r=y("p"),c=p(),b(n.$$.fragment),o=p(),b(M.$$.fragment),J=p(),i=y("p"),i.innerHTML=G,x=p(),g=y("blockquote"),g.innerHTML=Ml,H=p(),I=y("p"),I.innerHTML=yl,N=p(),W=y("p"),W.innerHTML=dl,S=p(),_=y("p"),_.textContent=ul,A=p(),v=y("table"),v.innerHTML=fl,L=p(),X=y("small"),X.innerHTML=Jl,D=p(),V=y("p"),V.innerHTML=bl,P=p(),b(C.$$.fragment),K=p(),b(Y.$$.fragment),O=p(),R=y("p"),R.innerHTML=hl,ll=p(),k=y("p"),k.innerHTML=Tl,el=p(),b(q.$$.fragment),tl=p(),b(Q.$$.fragment),al=p(),F=y("p"),F.textContent=wl,nl=p(),z=y("p"),z.innerHTML=Ul,sl=p(),b(B.$$.fragment),ol=p(),b(E.$$.fragment),il=p(),$=y("p"),this.h()},l(l){const e=vl("svelte-u9bgzb",document.head);s=d(e,"META",{name:!0,content:!0}),e.forEach(t),u=m(l),r=d(l,"P",{}),Zl(r).forEach(t),c=m(l),h(n.$$.fragment,l),o=m(l),h(M.$$.fragment,l),J=m(l),i=d(l,"P",{"data-svelte-h":!0}),f(i)!=="svelte-xssjno"&&(i.innerHTML=G),x=m(l),g=d(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(g)!=="svelte-neoyiw"&&(g.innerHTML=Ml),H=m(l),I=d(l,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1k9tg08"&&(I.innerHTML=yl),N=m(l),W=d(l,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1gtsmte"&&(W.innerHTML=dl),S=m(l),_=d(l,"P",{"data-svelte-h":!0}),f(_)!=="svelte-1hx16oz"&&(_.textContent=ul),A=m(l),v=d(l,"TABLE",{"data-svelte-h":!0}),f(v)!=="svelte-4braeo"&&(v.innerHTML=fl),L=m(l),X=d(l,"SMALL",{"data-svelte-h":!0}),f(X)!=="svelte-t67k1s"&&(X.innerHTML=Jl),D=m(l),V=d(l,"P",{"data-svelte-h":!0}),f(V)!=="svelte-97u2df"&&(V.innerHTML=bl),P=m(l),h(C.$$.fragment,l),K=m(l),h(Y.$$.fragment,l),O=m(l),R=d(l,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1blxhao"&&(R.innerHTML=hl),ll=m(l),k=d(l,"P",{"data-svelte-h":!0}),f(k)!=="svelte-xwvm0e"&&(k.innerHTML=Tl),el=m(l),h(q.$$.fragment,l),tl=m(l),h(Q.$$.fragment,l),al=m(l),F=d(l,"P",{"data-svelte-h":!0}),f(F)!=="svelte-2st498"&&(F.textContent=wl),nl=m(l),z=d(l,"P",{"data-svelte-h":!0}),f(z)!=="svelte-136cwt1"&&(z.innerHTML=Ul),sl=m(l),h(B.$$.fragment,l),ol=m(l),h(E.$$.fragment,l),il=m(l),$=d(l,"P",{}),Zl($).forEach(t),this.h()},h(){cl(s,"name","hf:doc:metadata"),cl(s,"content",Fl),cl(g,"class","tip")},m(l,e){Xl(document.head,s),a(l,u,e),a(l,r,e),a(l,c,e),T(n,l,e),a(l,o,e),T(M,l,e),a(l,J,e),a(l,i,e),a(l,x,e),a(l,g,e),a(l,H,e),a(l,I,e),a(l,N,e),a(l,W,e),a(l,S,e),a(l,_,e),a(l,A,e),a(l,v,e),a(l,L,e),a(l,X,e),a(l,D,e),a(l,V,e),a(l,P,e),T(C,l,e),a(l,K,e),T(Y,l,e),a(l,O,e),a(l,R,e),a(l,ll,e),a(l,k,e),a(l,el,e),T(q,l,e),a(l,tl,e),T(Q,l,e),a(l,al,e),a(l,F,e),a(l,nl,e),a(l,z,e),a(l,sl,e),T(B,l,e),a(l,ol,e),T(E,l,e),a(l,il,e),a(l,$,e),pl=!0},p(l,[e]){const jl={};e&2&&(jl.$$scope={dirty:e,ctx:l}),B.$set(jl)},i(l){pl||(w(n.$$.fragment,l),w(M.$$.fragment,l),w(C.$$.fragment,l),w(Y.$$.fragment,l),w(q.$$.fragment,l),w(Q.$$.fragment,l),w(B.$$.fragment,l),w(E.$$.fragment,l),pl=!0)},o(l){U(n.$$.fragment,l),U(M.$$.fragment,l),U(C.$$.fragment,l),U(Y.$$.fragment,l),U(q.$$.fragment,l),U(Q.$$.fragment,l),U(B.$$.fragment,l),U(E.$$.fragment,l),pl=!1},d(l){l&&(t(u),t(r),t(c),t(o),t(J),t(i),t(x),t(g),t(H),t(I),t(N),t(W),t(S),t(_),t(A),t(v),t(L),t(X),t(D),t(V),t(P),t(K),t(O),t(R),t(ll),t(k),t(el),t(tl),t(al),t(F),t(nl),t(z),t(sl),t(ol),t(il),t($)),t(s),j(n,l),j(M,l),j(C,l),j(Y,l),j(q,l),j(Q,l),j(B,l),j(E,l)}}}const Fl='{"title":"Compiling and offloading quantized models","local":"compiling-and-offloading-quantized-models","sections":[{"title":"Quantization and torch.compile","local":"quantization-and-torchcompile","sections":[],"depth":2},{"title":"Quantization, torch.compile, and offloading","local":"quantization-torchcompile-and-offloading","sections":[],"depth":2}],"depth":1}';function zl(Z){return Il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Al extends Wl{constructor(s){super(),_l(this,s,zl,Ql,Bl,{})}}export{Al as component};
