import{s as kt,n as vt,o as qt}from"../chunks/scheduler.53228c21.js";import{S as _t,i as xt,e as y,s as a,c as i,h as Yt,a as d,d as l,b as s,f as zt,g as o,j as c,k as Xt,l as Bt,m as n,n as m,t as p,o as r,p as u}from"../chunks/index.100fac89.js";import{C as Gt}from"../chunks/CopyLLMTxtMenu.2cdbb51f.js";import{C as N}from"../chunks/CodeBlock.d30a6509.js";import{H as G,E as Nt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3fcbbc76.js";function Vt(bt){let f,H,V,L,M,S,w,A,h,Ut='<a href="https://github.com/huggingface/optimum-quanto" rel="nofollow">Quanto</a> is a PyTorch quantization backend for <a href="https://huggingface.co/docs/optimum/en/index" rel="nofollow">Optimum</a>. It has been designed with versatility and simplicity in mind:',D,J,Zt="<li>All features are available in eager mode (works with non-traceable models)</li> <li>Supports quantization aware training</li> <li>Quantized models are compatible with <code>torch.compile</code></li> <li>Quantized models are Device agnostic (e.g CUDA,XPU,MPS,CPU)</li>",P,T,gt="In order to use the Quanto backend, you will first need to install <code>optimum-quanto&gt;=0.2.6</code> and <code>accelerate</code>",K,b,O,U,Wt="Now you can quantize a model by passing the <code>QuantoConfig</code> object to the <code>from_pretrained()</code> method. Although the Quanto library does allow quantizing <code>nn.Conv2d</code> and <code>nn.LayerNorm</code> modules, currently, Diffusers only supports quantizing the weights in the <code>nn.Linear</code> layers of a model. The following snippet demonstrates how to apply <code>float8</code> quantization with Quanto.",tt,Z,et,g,lt,W,It="It is possible to skip applying quantization on certain modules using the <code>modules_to_not_convert</code> argument in the <code>QuantoConfig</code>. Please ensure that the modules passed in to this argument match the keys of the modules in the <code>state_dict</code>",nt,I,at,j,st,C,jt="<code>QuantoConfig</code> is compatible with <code>~FromOriginalModelMixin.from_single_file</code>.",it,$,ot,R,mt,Q,Ct="Diffusers supports serializing Quanto models using the <code>~ModelMixin.save_pretrained</code> method.",pt,F,$t=`The serialization and loading requirements are different for models quantized directly with the Quanto library and models quantized
with Diffusers using Quanto as the backend. It is currently not possible to load models quantized directly with Quanto into Diffusers using <code>~ModelMixin.from_pretrained</code>`,rt,z,ut,X,yt,k,Rt="Currently the Quanto backend supports <code>torch.compile</code> for the following quantization types:",dt,v,Qt="<li><code>int8</code> weights</li>",ct,q,ft,_,Mt,x,wt,Y,Ft="<li>float8</li> <li>int8</li> <li>int4</li> <li>int2</li>",ht,B,Jt,E,Tt;return M=new Gt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new G({props:{title:"Quanto",local:"quanto",headingTag:"h1"}}),b=new N({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tcXVhbnRvJTIwYWNjZWxlcmF0ZQ==",highlighted:"pip install optimum-quanto accelerate",wrap:!1}}),Z=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyZmxvYXQ4JTIyKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoX2R0eXBlKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
      model_id,
      subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
      quantization_config=quantization_config,
      torch_dtype=torch.bfloat16,
)

pipe = FluxPipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch_dtype)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),g=new G({props:{title:"Skipping Quantization on specific modules",local:"skipping-quantization-on-specific-modules",headingTag:"h2"}}),I=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyZmxvYXQ4JTIyJTJDJTIwbW9kdWxlc190b19ub3RfY29udmVydCUzRCU1QiUyMnByb2pfb3V0JTIyJTVEKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>, modules_to_not_convert=[<span class="hljs-string">&quot;proj_out&quot;</span>])
transformer = FluxTransformer2DModel.from_pretrained(
      model_id,
      subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
      quantization_config=quantization_config,
      torch_dtype=torch.bfloat16,
)`,wrap:!1}}),j=new G({props:{title:"Using from_single_file with the Quanto Backend",local:"using-fromsinglefile-with-the-quanto-backend",headingTag:"h2"}}),$=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQWNrcHRfcGF0aCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMkZibG9iJTJGbWFpbiUyRmZsdXgxLWRldi5zYWZldGVuc29ycyUyMiUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBRdWFudG9Db25maWcod2VpZ2h0c19kdHlwZSUzRCUyMmZsb2F0OCUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGglMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/black-forest-labs/FLUX.1-dev/blob/main/flux1-dev.safetensors&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>)
transformer = FluxTransformer2DModel.from_single_file(ckpt_path, quantization_config=quantization_config, torch_dtype=torch.bfloat16)`,wrap:!1}}),R=new G({props:{title:"Saving Quantized models",local:"saving-quantized-models",headingTag:"h2"}}),z=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyZmxvYXQ4JTIyKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMjMlMjBzYXZlJTIwcXVhbnRpemVkJTIwbW9kZWwlMjB0byUyMHJldXNlJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUzQ3lvdXIlMjBxdWFudGl6ZWQlMjBtb2RlbCUyMHNhdmUlMjBwYXRoJTNFJTIyKSUwQSUwQSUyMyUyMHlvdSUyMGNhbiUyMHJlbG9hZCUyMHlvdXIlMjBxdWFudGl6ZWQlMjBtb2RlbCUyMHdpdGglMEFtb2RlbCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ3lvdXIlMjBxdWFudGl6ZWQlMjBtb2RlbCUyMHNhdmUlMjBwYXRoJTNFJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
      model_id,
      subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
      quantization_config=quantization_config,
      torch_dtype=torch.bfloat16,
)
<span class="hljs-comment"># save quantized model to reuse</span>
transformer.save_pretrained(<span class="hljs-string">&quot;&lt;your quantized model save path&gt;&quot;</span>)

<span class="hljs-comment"># you can reload your quantized model with</span>
model = FluxTransformer2DModel.from_pretrained(<span class="hljs-string">&quot;&lt;your quantized model save path&gt;&quot;</span>)`,wrap:!1}}),X=new G({props:{title:"Using torch.compile with Quanto",local:"using-torchcompile-with-quanto",headingTag:"h2"}}),q=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyaW50OCUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdlcy5zYXZlKCUyMmZsdXgtcXVhbnRvLWNvbXBpbGUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;int8&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
transformer = torch.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

pipe = FluxPipeline.from_pretrained(
    model_id, transformer=transformer, torch_dtype=torch_dtype
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
images = pipe(<span class="hljs-string">&quot;A cat holding a sign that says hello&quot;</span>).images[<span class="hljs-number">0</span>]
images.save(<span class="hljs-string">&quot;flux-quanto-compile.png&quot;</span>)`,wrap:!1}}),_=new G({props:{title:"Supported Quantization Types",local:"supported-quantization-types",headingTag:"h2"}}),x=new G({props:{title:"Weights",local:"weights",headingTag:"h3"}}),B=new Nt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/quanto.md"}}),{c(){f=y("meta"),H=a(),V=y("p"),L=a(),i(M.$$.fragment),S=a(),i(w.$$.fragment),A=a(),h=y("p"),h.innerHTML=Ut,D=a(),J=y("ul"),J.innerHTML=Zt,P=a(),T=y("p"),T.innerHTML=gt,K=a(),i(b.$$.fragment),O=a(),U=y("p"),U.innerHTML=Wt,tt=a(),i(Z.$$.fragment),et=a(),i(g.$$.fragment),lt=a(),W=y("p"),W.innerHTML=It,nt=a(),i(I.$$.fragment),at=a(),i(j.$$.fragment),st=a(),C=y("p"),C.innerHTML=jt,it=a(),i($.$$.fragment),ot=a(),i(R.$$.fragment),mt=a(),Q=y("p"),Q.innerHTML=Ct,pt=a(),F=y("p"),F.innerHTML=$t,rt=a(),i(z.$$.fragment),ut=a(),i(X.$$.fragment),yt=a(),k=y("p"),k.innerHTML=Rt,dt=a(),v=y("ul"),v.innerHTML=Qt,ct=a(),i(q.$$.fragment),ft=a(),i(_.$$.fragment),Mt=a(),i(x.$$.fragment),wt=a(),Y=y("ul"),Y.innerHTML=Ft,ht=a(),i(B.$$.fragment),Jt=a(),E=y("p"),this.h()},l(t){const e=Yt("svelte-u9bgzb",document.head);f=d(e,"META",{name:!0,content:!0}),e.forEach(l),H=s(t),V=d(t,"P",{}),zt(V).forEach(l),L=s(t),o(M.$$.fragment,t),S=s(t),o(w.$$.fragment,t),A=s(t),h=d(t,"P",{"data-svelte-h":!0}),c(h)!=="svelte-wedqkd"&&(h.innerHTML=Ut),D=s(t),J=d(t,"UL",{"data-svelte-h":!0}),c(J)!=="svelte-yhikdz"&&(J.innerHTML=Zt),P=s(t),T=d(t,"P",{"data-svelte-h":!0}),c(T)!=="svelte-18uawxu"&&(T.innerHTML=gt),K=s(t),o(b.$$.fragment,t),O=s(t),U=d(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-il6k3t"&&(U.innerHTML=Wt),tt=s(t),o(Z.$$.fragment,t),et=s(t),o(g.$$.fragment,t),lt=s(t),W=d(t,"P",{"data-svelte-h":!0}),c(W)!=="svelte-4moh48"&&(W.innerHTML=It),nt=s(t),o(I.$$.fragment,t),at=s(t),o(j.$$.fragment,t),st=s(t),C=d(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-80xlz7"&&(C.innerHTML=jt),it=s(t),o($.$$.fragment,t),ot=s(t),o(R.$$.fragment,t),mt=s(t),Q=d(t,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1bdnm93"&&(Q.innerHTML=Ct),pt=s(t),F=d(t,"P",{"data-svelte-h":!0}),c(F)!=="svelte-18ura5r"&&(F.innerHTML=$t),rt=s(t),o(z.$$.fragment,t),ut=s(t),o(X.$$.fragment,t),yt=s(t),k=d(t,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1sftzs6"&&(k.innerHTML=Rt),dt=s(t),v=d(t,"UL",{"data-svelte-h":!0}),c(v)!=="svelte-4fwo66"&&(v.innerHTML=Qt),ct=s(t),o(q.$$.fragment,t),ft=s(t),o(_.$$.fragment,t),Mt=s(t),o(x.$$.fragment,t),wt=s(t),Y=d(t,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-gqdhfh"&&(Y.innerHTML=Ft),ht=s(t),o(B.$$.fragment,t),Jt=s(t),E=d(t,"P",{}),zt(E).forEach(l),this.h()},h(){Xt(f,"name","hf:doc:metadata"),Xt(f,"content",Et)},m(t,e){Bt(document.head,f),n(t,H,e),n(t,V,e),n(t,L,e),m(M,t,e),n(t,S,e),m(w,t,e),n(t,A,e),n(t,h,e),n(t,D,e),n(t,J,e),n(t,P,e),n(t,T,e),n(t,K,e),m(b,t,e),n(t,O,e),n(t,U,e),n(t,tt,e),m(Z,t,e),n(t,et,e),m(g,t,e),n(t,lt,e),n(t,W,e),n(t,nt,e),m(I,t,e),n(t,at,e),m(j,t,e),n(t,st,e),n(t,C,e),n(t,it,e),m($,t,e),n(t,ot,e),m(R,t,e),n(t,mt,e),n(t,Q,e),n(t,pt,e),n(t,F,e),n(t,rt,e),m(z,t,e),n(t,ut,e),m(X,t,e),n(t,yt,e),n(t,k,e),n(t,dt,e),n(t,v,e),n(t,ct,e),m(q,t,e),n(t,ft,e),m(_,t,e),n(t,Mt,e),m(x,t,e),n(t,wt,e),n(t,Y,e),n(t,ht,e),m(B,t,e),n(t,Jt,e),n(t,E,e),Tt=!0},p:vt,i(t){Tt||(p(M.$$.fragment,t),p(w.$$.fragment,t),p(b.$$.fragment,t),p(Z.$$.fragment,t),p(g.$$.fragment,t),p(I.$$.fragment,t),p(j.$$.fragment,t),p($.$$.fragment,t),p(R.$$.fragment,t),p(z.$$.fragment,t),p(X.$$.fragment,t),p(q.$$.fragment,t),p(_.$$.fragment,t),p(x.$$.fragment,t),p(B.$$.fragment,t),Tt=!0)},o(t){r(M.$$.fragment,t),r(w.$$.fragment,t),r(b.$$.fragment,t),r(Z.$$.fragment,t),r(g.$$.fragment,t),r(I.$$.fragment,t),r(j.$$.fragment,t),r($.$$.fragment,t),r(R.$$.fragment,t),r(z.$$.fragment,t),r(X.$$.fragment,t),r(q.$$.fragment,t),r(_.$$.fragment,t),r(x.$$.fragment,t),r(B.$$.fragment,t),Tt=!1},d(t){t&&(l(H),l(V),l(L),l(S),l(A),l(h),l(D),l(J),l(P),l(T),l(K),l(O),l(U),l(tt),l(et),l(lt),l(W),l(nt),l(at),l(st),l(C),l(it),l(ot),l(mt),l(Q),l(pt),l(F),l(rt),l(ut),l(yt),l(k),l(dt),l(v),l(ct),l(ft),l(Mt),l(wt),l(Y),l(ht),l(Jt),l(E)),l(f),u(M,t),u(w,t),u(b,t),u(Z,t),u(g,t),u(I,t),u(j,t),u($,t),u(R,t),u(z,t),u(X,t),u(q,t),u(_,t),u(x,t),u(B,t)}}}const Et='{"title":"Quanto","local":"quanto","sections":[{"title":"Skipping Quantization on specific modules","local":"skipping-quantization-on-specific-modules","sections":[],"depth":2},{"title":"Using from_single_file with the Quanto Backend","local":"using-fromsinglefile-with-the-quanto-backend","sections":[],"depth":2},{"title":"Saving Quantized models","local":"saving-quantized-models","sections":[],"depth":2},{"title":"Using torch.compile with Quanto","local":"using-torchcompile-with-quanto","sections":[],"depth":2},{"title":"Supported Quantization Types","local":"supported-quantization-types","sections":[{"title":"Weights","local":"weights","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ht(bt){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends _t{constructor(f){super(),xt(this,f,Ht,Vt,kt,{})}}export{Kt as component};
