import{s as Qe,o as Ne,n as Ie}from"../chunks/scheduler.53228c21.js";import{S as Se,i as He,e as b,s as p,c as h,h as ze,a as J,d as l,b as o,f as Ee,g as w,j as _,k as Q,l as Pe,m as t,n as U,t as T,o as Z,p as j}from"../chunks/index.100fac89.js";import{C as qe}from"../chunks/CopyLLMTxtMenu.2cdbb51f.js";import{C as k}from"../chunks/CodeBlock.d30a6509.js";import{H as oe,E as Le}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3fcbbc76.js";import{H as De,a as Ce}from"../chunks/HfOption.fad27e59.js";function Ke(F){let c,B,m,C='<p>The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. Additionally, you can use <code>set_pag_applied_layers</code> method to update these layers after the pipeline has been created. Check out the <a href="#pag_applied_layers">pag_applied_layers</a> section to learn more about applying PAG to other layers.</p>',u,d,r='If you already have a pipeline created and loaded, you can enable PAG on it using the <code>from_pipe</code> API with the <code>enable_pag</code> flag. Internally, a PAG pipeline is created based on the pipeline and task you specified. In the example below, since we used <code>AutoPipelineForText2Image</code> and passed a <code>StableDiffusionXLPipeline</code>, a <code>StableDiffusionXLPAGPipeline</code> is created accordingly. Note that this does not require additional memory, and you will have both <code>StableDiffusionXLPipeline</code> and  <code>StableDiffusionXLPAGPipeline</code> loaded and ready to use. You can read more about the <code>from_pipe</code> API and how to reuse pipelines in diffuser <a href="https://huggingface.co/docs/diffusers/using-diffusers/loading#reuse-a-pipeline" rel="nofollow">here</a>.',M,f,X,y,v="To generate an image, you will also need to pass a <code>pag_scale</code>. When <code>pag_scale</code> increases, images gain more semantically coherent structures and exhibit fewer artifacts. However overly large guidance scale can lead to smoother textures and slight saturation in the images, similarly to CFG. <code>pag_scale=3.0</code> is used in the official demo and works well in most of the use cases, but feel free to experiment and select the appropriate value according to your needs! PAG is disabled when <code>pag_scale=0</code>.",x,I,$,g,V='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',i;return c=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHBhZ19hcHBsaWVkX2xheWVycyUzRCU1QiUyMm1pZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),f=new k({props:{code:"cGlwZWxpbmVfc2R4bCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3NkeGwlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_sdxl = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForText2Image.from_pipe(pipeline_sdxl, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),I=new k({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQSUwQWZvciUyMHBhZ19zY2FsZSUyMGluJTIwJTVCMC4wJTJDJTIwMy4wJTVEJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2Vz",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
    images = pipeline(
        prompt=prompt,
        num_inference_steps=<span class="hljs-number">25</span>,
        guidance_scale=<span class="hljs-number">7.0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images`,wrap:!1}}),{c(){h(c.$$.fragment),B=p(),m=b("blockquote"),m.innerHTML=C,u=p(),d=b("p"),d.innerHTML=r,M=p(),h(f.$$.fragment),X=p(),y=b("p"),y.innerHTML=v,x=p(),h(I.$$.fragment),$=p(),g=b("div"),g.innerHTML=V,this.h()},l(a){w(c.$$.fragment,a),B=o(a),m=J(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),_(m)!=="svelte-1qub4u5"&&(m.innerHTML=C),u=o(a),d=J(a,"P",{"data-svelte-h":!0}),_(d)!=="svelte-ggenwh"&&(d.innerHTML=r),M=o(a),w(f.$$.fragment,a),X=o(a),y=J(a,"P",{"data-svelte-h":!0}),_(y)!=="svelte-43v4ib"&&(y.innerHTML=v),x=o(a),w(I.$$.fragment,a),$=o(a),g=J(a,"DIV",{class:!0,"data-svelte-h":!0}),_(g)!=="svelte-1ebso2i"&&(g.innerHTML=V),this.h()},h(){Q(m,"class","tip"),Q(g,"class","flex flex-row gap-4")},m(a,G){U(c,a,G),t(a,B,G),t(a,m,G),t(a,u,G),t(a,d,G),t(a,M,G),U(f,a,G),t(a,X,G),t(a,y,G),t(a,x,G),U(I,a,G),t(a,$,G),t(a,g,G),i=!0},p:Ie,i(a){i||(T(c.$$.fragment,a),T(f.$$.fragment,a),T(I.$$.fragment,a),i=!0)},o(a){Z(c.$$.fragment,a),Z(f.$$.fragment,a),Z(I.$$.fragment,a),i=!1},d(a){a&&(l(B),l(m),l(u),l(d),l(M),l(X),l(y),l(x),l($),l(g)),j(c,a),j(f,a),j(I,a)}}}function Oe(F){let c,B="You can use PAG with image-to-image pipelines.",m,C,u,d,r="If you already have a image-to-image pipeline and would like enable PAG on it, you can run this",M,f,X,y,v="It is also very easy to directly switch from a text-to-image pipeline to PAG enabled image-to-image pipeline",x,I,$,g,V="If you have a PAG enabled text-to-image pipeline, you can directly switch to a image-to-image pipeline with PAG still enabled",i,a,G,E,P="Now let’s generate an image!",Y,R,A;return C=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTVCJTIybWlkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),f=new k({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),I=new k({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3QyaSUyQyUyMGVuYWJsZV9wYWclM0RUcnVlKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),a=new k({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmVfdDJpKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, enable_pag=<span class="hljs-literal">True</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i)`,wrap:!1}}),R=new k({props:{code:"cGFnX3NjYWxlcyUyMCUzRCUyMCUyMDQuMCUwQWd1aWRhbmNlX3NjYWxlcyUyMCUzRCUyMDcuMCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtdGV4dDJpbWcucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBjYXRjaGluZyUyMGElMjBmcmlzYmVlJTIwaW4lMjB0aGUlMjBqdW5nbGUlMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjglMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGd1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX3NjYWxlJTNEcGFnX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVE",highlighted:`pag_scales =  <span class="hljs-number">4.0</span>
guidance_scales = <span class="hljs-number">7.0</span>

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;a dog catching a frisbee in the jungle&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(
    prompt,
    image=init_image,
    strength=<span class="hljs-number">0.8</span>,
    guidance_scale=guidance_scale,
    pag_scale=pag_scale,
    generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){c=b("p"),c.textContent=B,m=p(),h(C.$$.fragment),u=p(),d=b("p"),d.textContent=r,M=p(),h(f.$$.fragment),X=p(),y=b("p"),y.textContent=v,x=p(),h(I.$$.fragment),$=p(),g=b("p"),g.textContent=V,i=p(),h(a.$$.fragment),G=p(),E=b("p"),E.textContent=P,Y=p(),h(R.$$.fragment)},l(n){c=J(n,"P",{"data-svelte-h":!0}),_(c)!=="svelte-1xi6cwa"&&(c.textContent=B),m=o(n),w(C.$$.fragment,n),u=o(n),d=J(n,"P",{"data-svelte-h":!0}),_(d)!=="svelte-d1pkk8"&&(d.textContent=r),M=o(n),w(f.$$.fragment,n),X=o(n),y=J(n,"P",{"data-svelte-h":!0}),_(y)!=="svelte-11p19k6"&&(y.textContent=v),x=o(n),w(I.$$.fragment,n),$=o(n),g=J(n,"P",{"data-svelte-h":!0}),_(g)!=="svelte-nytx5w"&&(g.textContent=V),i=o(n),w(a.$$.fragment,n),G=o(n),E=J(n,"P",{"data-svelte-h":!0}),_(E)!=="svelte-3irrs3"&&(E.textContent=P),Y=o(n),w(R.$$.fragment,n)},m(n,W){t(n,c,W),t(n,m,W),U(C,n,W),t(n,u,W),t(n,d,W),t(n,M,W),U(f,n,W),t(n,X,W),t(n,y,W),t(n,x,W),U(I,n,W),t(n,$,W),t(n,g,W),t(n,i,W),U(a,n,W),t(n,G,W),t(n,E,W),t(n,Y,W),U(R,n,W),A=!0},p:Ie,i(n){A||(T(C.$$.fragment,n),T(f.$$.fragment,n),T(I.$$.fragment,n),T(a.$$.fragment,n),T(R.$$.fragment,n),A=!0)},o(n){Z(C.$$.fragment,n),Z(f.$$.fragment,n),Z(I.$$.fragment,n),Z(a.$$.fragment,n),Z(R.$$.fragment,n),A=!1},d(n){n&&(l(c),l(m),l(u),l(d),l(M),l(X),l(y),l(x),l($),l(g),l(i),l(G),l(E),l(Y)),j(C,n),j(f,n),j(I,n),j(a,n),j(R,n)}}}function el(F){let c,B,m,C="You can enable PAG on an existing inpainting pipeline like this",u,d,r,M,f="This still works when your pipeline has a different task:",X,y,v,x,I="Let’s generate an image!",$,g,V;return c=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),d=new k({props:{code:"cGlwZWxpbmVfaW5wYWludCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9waXBlKHBpcGVsaW5lX2lucGFpbnQlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_inpaint = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpainting.from_pipe(pipeline_inpaint, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),y=new k({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWl0aW5nLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpaiting.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),g=new k({props:{code:"aW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwdGlnZXIlMjBzaXR0aW5nJTIwb24lMjBhJTIwYmVuY2glMjIlMEElMEFwYWdfc2NhbGVzJTIwJTNEJTIwJTIwMy4wJTBBZ3VpZGFuY2Vfc2NhbGVzJTIwJTNEJTIwNy41JTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMSklMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>

pag_scales =  <span class="hljs-number">3.0</span>
guidance_scales = <span class="hljs-number">7.5</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
images = pipeline(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    strength=<span class="hljs-number">0.8</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){h(c.$$.fragment),B=p(),m=b("p"),m.textContent=C,u=p(),h(d.$$.fragment),r=p(),M=b("p"),M.textContent=f,X=p(),h(y.$$.fragment),v=p(),x=b("p"),x.textContent=I,$=p(),h(g.$$.fragment)},l(i){w(c.$$.fragment,i),B=o(i),m=J(i,"P",{"data-svelte-h":!0}),_(m)!=="svelte-azr2az"&&(m.textContent=C),u=o(i),w(d.$$.fragment,i),r=o(i),M=J(i,"P",{"data-svelte-h":!0}),_(M)!=="svelte-1e8wg3g"&&(M.textContent=f),X=o(i),w(y.$$.fragment,i),v=o(i),x=J(i,"P",{"data-svelte-h":!0}),_(x)!=="svelte-1yhhruz"&&(x.textContent=I),$=o(i),w(g.$$.fragment,i)},m(i,a){U(c,i,a),t(i,B,a),t(i,m,a),t(i,u,a),U(d,i,a),t(i,r,a),t(i,M,a),t(i,X,a),U(y,i,a),t(i,v,a),t(i,x,a),t(i,$,a),U(g,i,a),V=!0},p:Ie,i(i){V||(T(c.$$.fragment,i),T(d.$$.fragment,i),T(y.$$.fragment,i),T(g.$$.fragment,i),V=!0)},o(i){Z(c.$$.fragment,i),Z(d.$$.fragment,i),Z(y.$$.fragment,i),Z(g.$$.fragment,i),V=!1},d(i){i&&(l(B),l(m),l(u),l(r),l(M),l(X),l(v),l(x),l($)),j(c,i),j(d,i),j(y,i),j(g,i)}}}function ll(F){let c,B,m,C,u,d;return c=new Ce({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[Ke]},$$scope:{ctx:F}}}),m=new Ce({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[Oe]},$$scope:{ctx:F}}}),u=new Ce({props:{id:"tasks",option:"Inpainting",$$slots:{default:[el]},$$scope:{ctx:F}}}),{c(){h(c.$$.fragment),B=p(),h(m.$$.fragment),C=p(),h(u.$$.fragment)},l(r){w(c.$$.fragment,r),B=o(r),w(m.$$.fragment,r),C=o(r),w(u.$$.fragment,r)},m(r,M){U(c,r,M),t(r,B,M),U(m,r,M),t(r,C,M),U(u,r,M),d=!0},p(r,M){const f={};M&2&&(f.$$scope={dirty:M,ctx:r}),c.$set(f);const X={};M&2&&(X.$$scope={dirty:M,ctx:r}),m.$set(X);const y={};M&2&&(y.$$scope={dirty:M,ctx:r}),u.$set(y)},i(r){d||(T(c.$$.fragment,r),T(m.$$.fragment,r),T(u.$$.fragment,r),d=!0)},o(r){Z(c.$$.fragment,r),Z(m.$$.fragment,r),Z(u.$$.fragment,r),d=!1},d(r){r&&(l(B),l(C)),j(c,r),j(m,r),j(u,r)}}}function tl(F){let c,B,m,C,u,d,r,M,f,X='<a href="https://ku-cvlab.github.io/Perturbed-Attention-Guidance/" rel="nofollow">Perturbed-Attention Guidance (PAG)</a> is a new diffusion sampling guidance that improves sample quality across both unconditional and conditional settings, achieving this without requiring further training or the integration of external modules. PAG is designed to progressively enhance the structure of synthesized samples throughout the denoising process by considering the self-attention mechanisms’ ability to capture structural information. It involves generating intermediate samples with degraded structure by substituting selected self-attention maps in diffusion U-Net with an identity matrix, and guiding the denoising process away from these degraded samples.',y,v,x="This guide will show you how to use PAG for various tasks and use cases.",I,$,g,V,i='You can apply PAG to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks such as text-to-image, image-to-image, and inpainting. To enable PAG for a specific task, load the pipeline using the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> API with the <code>enable_pag=True</code> flag and the <code>pag_applied_layers</code> argument.',a,G,E='<p>🤗 Diffusers currently only supports using PAG with selected SDXL pipelines and <a href="/docs/diffusers/main/en/api/pipelines/pag#diffusers.PixArtSigmaPAGPipeline">PixArtSigmaPAGPipeline</a>. But feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you want to add PAG support to a new pipeline!</p>',P,Y,R,A,n,W,Be="To use PAG with ControlNet, first create a <code>controlnet</code>. Then, pass the <code>controlnet</code> and other PAG arguments to the <code>from_pretrained</code> method of the AutoPipeline for the specified task.",ce,q,me,N,$e="<p>If you already have a controlnet pipeline and want to enable PAG, you can use the <code>from_pipe</code> API: <code>AutoPipelineForText2Image.from_pipe(pipeline_controlnet, enable_pag=True)</code></p>",Me,L,Xe="You can use the pipeline in the same way you normally use ControlNet pipelines, with the added option to specify a <code>pag_scale</code> parameter. Note that PAG works well for unconditional generation. In this example, we will generate an image without a prompt.",de,D,ue,S,xe='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',ye,K,fe,O,ve='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is a popular model that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. You can enable PAG on a pipeline with IP-Adapter loaded.',ge,ee,be,le,Ve="PAG reduces artifacts and improves the overall compposition.",Je,H,ke='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_5.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',he,te,we,ae,Ue,se,Ye="The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. By default, it applies only to the mid blocks. Changing this setting will significantly impact the output. You can use the <code>set_pag_applied_layers</code> method to adjust the PAG layers after the pipeline is created, helping you find the optimal layers for your model.",Te,ne,Re="As an example, here is the images generated with <code>pag_layers = [&quot;down.block_2&quot;]</code> and <code>pag_layers = [&quot;down.block_2&quot;, &quot;up.block_1.attentions_0&quot;]</code>",Ze,ie,je,z,Ae='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2_up1a0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2 + up.block1.attentions_0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2</figcaption></div>',Ge,pe,We,re,_e;return u=new qe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),r=new oe({props:{title:"Perturbed-Attention Guidance",local:"perturbed-attention-guidance",headingTag:"h1"}}),$=new oe({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),Y=new De({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting"],$$slots:{default:[ll]},$$scope:{ctx:F}}}),A=new oe({props:{title:"PAG with ControlNet",local:"pag-with-controlnet",headingTag:"h2"}}),q=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBDb250cm9sTmV0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNvbnRyb2xuZXQtY2Fubnktc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTIybWlkJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, ControlNetModel
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=<span class="hljs-string">&quot;mid&quot;</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),D=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFjYW5ueV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBhZ19jb250cm9sX2lucHV0LnBuZyUyMiUwQSklMEElMEFmb3IlMjBwYWdfc2NhbGUlMjBpbiUyMCU1QjAuMCUyQyUyMDMuMCU1RCUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDEpJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjApLmltYWdlcyUwQSUyMCUyMCUyMCUyMGltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
canny_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_control_input.png&quot;</span>
)

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
    images = pipeline(
        prompt=<span class="hljs-string">&quot;&quot;</span>,
        controlnet_conditioning_scale=controlnet_conditioning_scale,
        image=canny_image,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images
    images[<span class="hljs-number">0</span>]`,wrap:!1}}),K=new oe({props:{title:"PAG with IP-Adapter",local:"pag-with-ip-adapter",headingTag:"h2"}}),ee=new k({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">import</span> torch

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    image_encoder=image_encoder,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.bin&quot;</span>)

pag_scales = <span class="hljs-number">5.0</span>
ip_adapter_scales = <span class="hljs-number">0.8</span>

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)

pipeline.set_ip_adapter_scale(ip_adapter_scale)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=<span class="hljs-number">3.0</span>,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]
`,wrap:!1}}),te=new oe({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),ae=new oe({props:{title:"pag_applied_layers",local:"pagappliedlayers",headingTag:"h3"}}),ie=new k({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQXBpcGVsaW5lLnNldF9wYWdfYXBwbGllZF9sYXllcnMocGFnX2xheWVycyklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEZ3VpZGFuY2Vfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQ=",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>
pipeline.set_pag_applied_layers(pag_layers)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),pe=new Le({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/pag.md"}}),{c(){c=b("meta"),B=p(),m=b("p"),C=p(),h(u.$$.fragment),d=p(),h(r.$$.fragment),M=p(),f=b("p"),f.innerHTML=X,y=p(),v=b("p"),v.textContent=x,I=p(),h($.$$.fragment),g=p(),V=b("p"),V.innerHTML=i,a=p(),G=b("blockquote"),G.innerHTML=E,P=p(),h(Y.$$.fragment),R=p(),h(A.$$.fragment),n=p(),W=b("p"),W.innerHTML=Be,ce=p(),h(q.$$.fragment),me=p(),N=b("blockquote"),N.innerHTML=$e,Me=p(),L=b("p"),L.innerHTML=Xe,de=p(),h(D.$$.fragment),ue=p(),S=b("div"),S.innerHTML=xe,ye=p(),h(K.$$.fragment),fe=p(),O=b("p"),O.innerHTML=ve,ge=p(),h(ee.$$.fragment),be=p(),le=b("p"),le.textContent=Ve,Je=p(),H=b("div"),H.innerHTML=ke,he=p(),h(te.$$.fragment),we=p(),h(ae.$$.fragment),Ue=p(),se=b("p"),se.innerHTML=Ye,Te=p(),ne=b("p"),ne.innerHTML=Re,Ze=p(),h(ie.$$.fragment),je=p(),z=b("div"),z.innerHTML=Ae,Ge=p(),h(pe.$$.fragment),We=p(),re=b("p"),this.h()},l(e){const s=ze("svelte-u9bgzb",document.head);c=J(s,"META",{name:!0,content:!0}),s.forEach(l),B=o(e),m=J(e,"P",{}),Ee(m).forEach(l),C=o(e),w(u.$$.fragment,e),d=o(e),w(r.$$.fragment,e),M=o(e),f=J(e,"P",{"data-svelte-h":!0}),_(f)!=="svelte-1w1c4u2"&&(f.innerHTML=X),y=o(e),v=J(e,"P",{"data-svelte-h":!0}),_(v)!=="svelte-11cdpcr"&&(v.textContent=x),I=o(e),w($.$$.fragment,e),g=o(e),V=J(e,"P",{"data-svelte-h":!0}),_(V)!=="svelte-dt4tyz"&&(V.innerHTML=i),a=o(e),G=J(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),_(G)!=="svelte-7eizy1"&&(G.innerHTML=E),P=o(e),w(Y.$$.fragment,e),R=o(e),w(A.$$.fragment,e),n=o(e),W=J(e,"P",{"data-svelte-h":!0}),_(W)!=="svelte-4m1dma"&&(W.innerHTML=Be),ce=o(e),w(q.$$.fragment,e),me=o(e),N=J(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),_(N)!=="svelte-1s4f2l1"&&(N.innerHTML=$e),Me=o(e),L=J(e,"P",{"data-svelte-h":!0}),_(L)!=="svelte-112ukzn"&&(L.innerHTML=Xe),de=o(e),w(D.$$.fragment,e),ue=o(e),S=J(e,"DIV",{class:!0,"data-svelte-h":!0}),_(S)!=="svelte-e2cxkg"&&(S.innerHTML=xe),ye=o(e),w(K.$$.fragment,e),fe=o(e),O=J(e,"P",{"data-svelte-h":!0}),_(O)!=="svelte-rjcwxp"&&(O.innerHTML=ve),ge=o(e),w(ee.$$.fragment,e),be=o(e),le=J(e,"P",{"data-svelte-h":!0}),_(le)!=="svelte-1n1gw76"&&(le.textContent=Ve),Je=o(e),H=J(e,"DIV",{class:!0,"data-svelte-h":!0}),_(H)!=="svelte-j0lguw"&&(H.innerHTML=ke),he=o(e),w(te.$$.fragment,e),we=o(e),w(ae.$$.fragment,e),Ue=o(e),se=J(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-1th38n0"&&(se.innerHTML=Ye),Te=o(e),ne=J(e,"P",{"data-svelte-h":!0}),_(ne)!=="svelte-1d06cik"&&(ne.innerHTML=Re),Ze=o(e),w(ie.$$.fragment,e),je=o(e),z=J(e,"DIV",{class:!0,"data-svelte-h":!0}),_(z)!=="svelte-1srsjub"&&(z.innerHTML=Ae),Ge=o(e),w(pe.$$.fragment,e),We=o(e),re=J(e,"P",{}),Ee(re).forEach(l),this.h()},h(){Q(c,"name","hf:doc:metadata"),Q(c,"content",al),Q(G,"class","tip"),Q(N,"class","tip"),Q(S,"class","flex flex-row gap-4"),Q(H,"class","flex flex-row gap-4"),Q(z,"class","flex flex-row gap-4")},m(e,s){Pe(document.head,c),t(e,B,s),t(e,m,s),t(e,C,s),U(u,e,s),t(e,d,s),U(r,e,s),t(e,M,s),t(e,f,s),t(e,y,s),t(e,v,s),t(e,I,s),U($,e,s),t(e,g,s),t(e,V,s),t(e,a,s),t(e,G,s),t(e,P,s),U(Y,e,s),t(e,R,s),U(A,e,s),t(e,n,s),t(e,W,s),t(e,ce,s),U(q,e,s),t(e,me,s),t(e,N,s),t(e,Me,s),t(e,L,s),t(e,de,s),U(D,e,s),t(e,ue,s),t(e,S,s),t(e,ye,s),U(K,e,s),t(e,fe,s),t(e,O,s),t(e,ge,s),U(ee,e,s),t(e,be,s),t(e,le,s),t(e,Je,s),t(e,H,s),t(e,he,s),U(te,e,s),t(e,we,s),U(ae,e,s),t(e,Ue,s),t(e,se,s),t(e,Te,s),t(e,ne,s),t(e,Ze,s),U(ie,e,s),t(e,je,s),t(e,z,s),t(e,Ge,s),U(pe,e,s),t(e,We,s),t(e,re,s),_e=!0},p(e,[s]){const Fe={};s&2&&(Fe.$$scope={dirty:s,ctx:e}),Y.$set(Fe)},i(e){_e||(T(u.$$.fragment,e),T(r.$$.fragment,e),T($.$$.fragment,e),T(Y.$$.fragment,e),T(A.$$.fragment,e),T(q.$$.fragment,e),T(D.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(ie.$$.fragment,e),T(pe.$$.fragment,e),_e=!0)},o(e){Z(u.$$.fragment,e),Z(r.$$.fragment,e),Z($.$$.fragment,e),Z(Y.$$.fragment,e),Z(A.$$.fragment,e),Z(q.$$.fragment,e),Z(D.$$.fragment,e),Z(K.$$.fragment,e),Z(ee.$$.fragment,e),Z(te.$$.fragment,e),Z(ae.$$.fragment,e),Z(ie.$$.fragment,e),Z(pe.$$.fragment,e),_e=!1},d(e){e&&(l(B),l(m),l(C),l(d),l(M),l(f),l(y),l(v),l(I),l(g),l(V),l(a),l(G),l(P),l(R),l(n),l(W),l(ce),l(me),l(N),l(Me),l(L),l(de),l(ue),l(S),l(ye),l(fe),l(O),l(ge),l(be),l(le),l(Je),l(H),l(he),l(we),l(Ue),l(se),l(Te),l(ne),l(Ze),l(je),l(z),l(Ge),l(We),l(re)),l(c),j(u,e),j(r,e),j($,e),j(Y,e),j(A,e),j(q,e),j(D,e),j(K,e),j(ee,e),j(te,e),j(ae,e),j(ie,e),j(pe,e)}}}const al='{"title":"Perturbed-Attention Guidance","local":"perturbed-attention-guidance","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"PAG with ControlNet","local":"pag-with-controlnet","sections":[],"depth":2},{"title":"PAG with IP-Adapter","local":"pag-with-ip-adapter","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"pag_applied_layers","local":"pagappliedlayers","sections":[],"depth":3}],"depth":2}],"depth":1}';function sl(F){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends Se{constructor(c){super(),He(this,c,sl,tl,Qe,{})}}export{ml as component};
