# Logging

🤗 Diffusers has a centralized logging system to easily manage the verbosity of the library. The default verbosity is set to `WARNING`.

To change the verbosity level, use one of the direct setters. For instance, to change the verbosity to the `INFO` level.

```python
import diffusers

diffusers.logging.set_verbosity_info()
```

You can also use the environment variable `DIFFUSERS_VERBOSITY` to override the default verbosity. You can set it
to one of the following: `debug`, `info`, `warning`, `error`, `critical`. For example:

```bash
DIFFUSERS_VERBOSITY=error ./myprogram.py
```

Additionally, some `warnings` can be disabled by setting the environment variable
`DIFFUSERS_NO_ADVISORY_WARNINGS` to a true value, like `1`. This disables any warning logged by
`logger.warning_advice`. For example:

```bash
DIFFUSERS_NO_ADVISORY_WARNINGS=1 ./myprogram.py
```

Here is an example of how to use the same logger as the library in your own module or script:

```python
from diffusers.utils import logging

logging.set_verbosity_info()
logger = logging.get_logger("diffusers")
logger.info("INFO")
logger.warning("WARN")
```


All methods of the logging module are documented below. The main methods are
`logging.get_verbosity` to get the current level of verbosity in the logger and
`logging.set_verbosity` to set the verbosity to the level of your choice.

In order from the least verbose to the most verbose:

|                                                    Method | Integer value |                                         Description |
|----------------------------------------------------------:|--------------:|----------------------------------------------------:|
| `diffusers.logging.CRITICAL` or `diffusers.logging.FATAL` |            50 |                only report the most critical errors |
|                                 `diffusers.logging.ERROR` |            40 |                                  only report errors |
|   `diffusers.logging.WARNING` or `diffusers.logging.WARN` |            30 |           only report errors and warnings (default) |
|                                  `diffusers.logging.INFO` |            20 | only report errors, warnings, and basic information |
|                                 `diffusers.logging.DEBUG` |            10 |                              report all information |

By default, `tqdm` progress bars are displayed during model download. `logging.disable_progress_bar` and `logging.enable_progress_bar` are used to enable or disable this behavior.

## Base setters[[diffusers.utils.logging.set_verbosity_error]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.set_verbosity_error</name><anchor>diffusers.utils.logging.set_verbosity_error</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L180</source><parameters>[]</parameters></docstring>
Set the verbosity to the `ERROR` level.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.set_verbosity_warning</name><anchor>diffusers.utils.logging.set_verbosity_warning</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L170</source><parameters>[]</parameters></docstring>
Set the verbosity to the `WARNING` level.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.set_verbosity_info</name><anchor>diffusers.utils.logging.set_verbosity_info</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L165</source><parameters>[]</parameters></docstring>
Set the verbosity to the `INFO` level.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.set_verbosity_debug</name><anchor>diffusers.utils.logging.set_verbosity_debug</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L175</source><parameters>[]</parameters></docstring>
Set the verbosity to the `DEBUG` level.

</div>

## Other functions[[diffusers.utils.logging.get_verbosity]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.get_verbosity</name><anchor>diffusers.utils.logging.get_verbosity</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L126</source><parameters>[]</parameters><rettype>`int`</rettype><retdesc>Logging level integers which can be one of:

- `50`: `diffusers.logging.CRITICAL` or `diffusers.logging.FATAL`
- `40`: `diffusers.logging.ERROR`
- `30`: `diffusers.logging.WARNING` or `diffusers.logging.WARN`
- `20`: `diffusers.logging.INFO`
- `10`: `diffusers.logging.DEBUG`</retdesc></docstring>

Return the current level for the 🤗 Diffusers' root logger as an `int`.






</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.set_verbosity</name><anchor>diffusers.utils.logging.set_verbosity</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L146</source><parameters>[{"name": "verbosity", "val": ": int"}]</parameters><paramsdesc>- **verbosity** (`int`) --
  Logging level which can be one of:

  - `diffusers.logging.CRITICAL` or `diffusers.logging.FATAL`
  - `diffusers.logging.ERROR`
  - `diffusers.logging.WARNING` or `diffusers.logging.WARN`
  - `diffusers.logging.INFO`
  - `diffusers.logging.DEBUG`</paramsdesc><paramgroups>0</paramgroups></docstring>

Set the verbosity level for the 🤗 Diffusers' root logger.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.get_logger</name><anchor>diffusers.utils.get_logger</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L112</source><parameters>[{"name": "name", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

Return a logger with the specified name.

This function is not supposed to be directly accessed unless you are writing a custom diffusers module.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.enable_default_handler</name><anchor>diffusers.utils.logging.enable_default_handler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L194</source><parameters>[]</parameters></docstring>
Enable the default handler of the 🤗 Diffusers' root logger.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.disable_default_handler</name><anchor>diffusers.utils.logging.disable_default_handler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L185</source><parameters>[]</parameters></docstring>
Disable the default handler of the 🤗 Diffusers' root logger.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.enable_explicit_format</name><anchor>diffusers.utils.logging.enable_explicit_format</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L240</source><parameters>[]</parameters></docstring>

<ExampleCodeBlock anchor="diffusers.utils.logging.enable_explicit_format.example">

Enable explicit formatting for every 🤗 Diffusers' logger. The explicit formatter is as follows:
```
[LEVELNAME|FILENAME|LINE NUMBER] TIME >> MESSAGE
```

</ExampleCodeBlock>
All handlers currently bound to the root logger are affected by this method.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.reset_format</name><anchor>diffusers.utils.logging.reset_format</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L255</source><parameters>[]</parameters></docstring>

Resets the formatting for 🤗 Diffusers' loggers.

All handlers currently bound to the root logger are affected by this method.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.enable_progress_bar</name><anchor>diffusers.utils.logging.enable_progress_bar</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L331</source><parameters>[]</parameters></docstring>
Enable tqdm progress bar.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.utils.logging.disable_progress_bar</name><anchor>diffusers.utils.logging.disable_progress_bar</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/logging.py#L337</source><parameters>[]</parameters></docstring>
Disable tqdm progress bar.

</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/logging.md" />