# FluxTransformer2DModel

A Transformer model for image-like data from [Flux](https://blackforestlabs.ai/announcing-black-forest-labs/).

## FluxTransformer2DModel[[diffusers.FluxTransformer2DModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.FluxTransformer2DModel</name><anchor>diffusers.FluxTransformer2DModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_flux.py#L525</source><parameters>[{"name": "patch_size", "val": ": int = 1"}, {"name": "in_channels", "val": ": int = 64"}, {"name": "out_channels", "val": ": typing.Optional[int] = None"}, {"name": "num_layers", "val": ": int = 19"}, {"name": "num_single_layers", "val": ": int = 38"}, {"name": "attention_head_dim", "val": ": int = 128"}, {"name": "num_attention_heads", "val": ": int = 24"}, {"name": "joint_attention_dim", "val": ": int = 4096"}, {"name": "pooled_projection_dim", "val": ": int = 768"}, {"name": "guidance_embeds", "val": ": bool = False"}, {"name": "axes_dims_rope", "val": ": typing.Tuple[int, int, int] = (16, 56, 56)"}]</parameters><paramsdesc>- **patch_size** (`int`, defaults to `1`) --
  Patch size to turn the input data into small patches.
- **in_channels** (`int`, defaults to `64`) --
  The number of channels in the input.
- **out_channels** (`int`, *optional*, defaults to `None`) --
  The number of channels in the output. If not specified, it defaults to `in_channels`.
- **num_layers** (`int`, defaults to `19`) --
  The number of layers of dual stream DiT blocks to use.
- **num_single_layers** (`int`, defaults to `38`) --
  The number of layers of single stream DiT blocks to use.
- **attention_head_dim** (`int`, defaults to `128`) --
  The number of dimensions to use for each attention head.
- **num_attention_heads** (`int`, defaults to `24`) --
  The number of attention heads to use.
- **joint_attention_dim** (`int`, defaults to `4096`) --
  The number of dimensions to use for the joint attention (embedding/channel dimension of
  `encoder_hidden_states`).
- **pooled_projection_dim** (`int`, defaults to `768`) --
  The number of dimensions to use for the pooled projection.
- **guidance_embeds** (`bool`, defaults to `False`) --
  Whether to use guidance embeddings for guidance-distilled variant of the model.
- **axes_dims_rope** (`Tuple[int]`, defaults to `(16, 56, 56)`) --
  The dimensions to use for the rotary positional embeddings.</paramsdesc><paramgroups>0</paramgroups></docstring>

The Transformer model introduced in Flux.

Reference: https://blackforestlabs.ai/announcing-black-forest-labs/





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>forward</name><anchor>diffusers.FluxTransformer2DModel.forward</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_flux.py#L637</source><parameters>[{"name": "hidden_states", "val": ": Tensor"}, {"name": "encoder_hidden_states", "val": ": Tensor = None"}, {"name": "pooled_projections", "val": ": Tensor = None"}, {"name": "timestep", "val": ": LongTensor = None"}, {"name": "img_ids", "val": ": Tensor = None"}, {"name": "txt_ids", "val": ": Tensor = None"}, {"name": "guidance", "val": ": Tensor = None"}, {"name": "joint_attention_kwargs", "val": ": typing.Optional[typing.Dict[str, typing.Any]] = None"}, {"name": "controlnet_block_samples", "val": " = None"}, {"name": "controlnet_single_block_samples", "val": " = None"}, {"name": "return_dict", "val": ": bool = True"}, {"name": "controlnet_blocks_repeat", "val": ": bool = False"}]</parameters><paramsdesc>- **hidden_states** (`torch.Tensor` of shape `(batch_size, image_sequence_length, in_channels)`) --
  Input `hidden_states`.
- **encoder_hidden_states** (`torch.Tensor` of shape `(batch_size, text_sequence_length, joint_attention_dim)`) --
  Conditional embeddings (embeddings computed from the input conditions such as prompts) to use.
- **pooled_projections** (`torch.Tensor` of shape `(batch_size, projection_dim)`) -- Embeddings projected
  from the embeddings of input conditions.
- **timestep** ( `torch.LongTensor`) --
  Used to indicate denoising step.
- **block_controlnet_hidden_states** -- (`list` of `torch.Tensor`):
  A list of tensors that if specified are added to the residuals of transformer blocks.
- **joint_attention_kwargs** (`dict`, *optional*) --
  A kwargs dictionary that if specified is passed along to the `AttentionProcessor` as defined under
  `self.processor` in
  [diffusers.models.attention_processor](https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py).
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `~models.transformer_2d.Transformer2DModelOutput` instead of a plain
  tuple.</paramsdesc><paramgroups>0</paramgroups><retdesc>If `return_dict` is True, an `~models.transformer_2d.Transformer2DModelOutput` is returned, otherwise a
`tuple` where the first element is the sample tensor.</retdesc></docstring>

The [FluxTransformer2DModel](/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel) forward method.






</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/flux_transformer.md" />