# DDIMInverseScheduler

`DDIMInverseScheduler` is the inverted scheduler from [Denoising Diffusion Implicit Models](https://huggingface.co/papers/2010.02502) (DDIM) by Jiaming Song, Chenlin Meng and Stefano Ermon.
The implementation is mostly based on the DDIM inversion definition from [Null-text Inversion for Editing Real Images using Guided Diffusion Models](https://huggingface.co/papers/2211.09794).

## DDIMInverseScheduler[[diffusers.DDIMInverseScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.DDIMInverseScheduler</name><anchor>diffusers.DDIMInverseScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddim_inverse.py#L130</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 1000"}, {"name": "beta_start", "val": ": float = 0.0001"}, {"name": "beta_end", "val": ": float = 0.02"}, {"name": "beta_schedule", "val": ": str = 'linear'"}, {"name": "trained_betas", "val": ": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"}, {"name": "clip_sample", "val": ": bool = True"}, {"name": "set_alpha_to_one", "val": ": bool = True"}, {"name": "steps_offset", "val": ": int = 0"}, {"name": "prediction_type", "val": ": str = 'epsilon'"}, {"name": "clip_sample_range", "val": ": float = 1.0"}, {"name": "timestep_spacing", "val": ": str = 'leading'"}, {"name": "rescale_betas_zero_snr", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **num_train_timesteps** (`int`, defaults to 1000) --
  The number of diffusion steps to train the model.
- **beta_start** (`float`, defaults to 0.0001) --
  The starting `beta` value of inference.
- **beta_end** (`float`, defaults to 0.02) --
  The final `beta` value.
- **beta_schedule** (`str`, defaults to `"linear"`) --
  The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
  `linear`, `scaled_linear`, or `squaredcos_cap_v2`.
- **trained_betas** (`np.ndarray`, *optional*) --
  Pass an array of betas directly to the constructor to bypass `beta_start` and `beta_end`.
- **clip_sample** (`bool`, defaults to `True`) --
  Clip the predicted sample for numerical stability.
- **clip_sample_range** (`float`, defaults to 1.0) --
  The maximum magnitude for sample clipping. Valid only when `clip_sample=True`.
- **set_alpha_to_one** (`bool`, defaults to `True`) --
  Each diffusion step uses the alphas product value at that step and at the previous one. For the final step
  there is no previous alpha. When this option is `True` the previous alpha product is fixed to 0, otherwise
  it uses the alpha value at step `num_train_timesteps - 1`.
- **steps_offset** (`int`, defaults to 0) --
  An offset added to the inference steps, as required by some model families.
- **prediction_type** (`str`, defaults to `epsilon`, *optional*) --
  Prediction type of the scheduler function; can be `epsilon` (predicts the noise of the diffusion process),
  `sample` (directly predicts the noisy sample`) or `v_prediction` (see section 2.4 of [Imagen
  Video](https://imagen.research.google/video/paper.pdf) paper).
- **timestep_spacing** (`str`, defaults to `"leading"`) --
  The way the timesteps should be scaled. Refer to Table 2 of the [Common Diffusion Noise Schedules and
  Sample Steps are Flawed](https://huggingface.co/papers/2305.08891) for more information.
- **rescale_betas_zero_snr** (`bool`, defaults to `False`) --
  Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
  dark samples instead of limiting it to samples with medium brightness. Loosely related to
  [`--offset_noise`](https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506).</paramsdesc><paramgroups>0</paramgroups></docstring>

`DDIMInverseScheduler` is the reverse scheduler of [DDIMScheduler](/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler).

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.DDIMInverseScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddim_inverse.py#L234</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.DDIMInverseScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddim_inverse.py#L251</source><parameters>[{"name": "num_inference_steps", "val": ": int"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`) --
  The number of diffusion steps used when generating samples with a pre-trained model.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.DDIMInverseScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_ddim_inverse.py#L289</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "timestep", "val": ": int"}, {"name": "sample", "val": ": Tensor"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from learned diffusion model.
- **timestep** (`float`) --
  The current discrete timestep in the diffusion chain.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.
- **eta** (`float`) --
  The weight of noise for added noise in diffusion step.
- **use_clipped_model_output** (`bool`, defaults to `False`) --
  If `True`, computes "corrected" `model_output` from the clipped predicted original sample. Necessary
  because predicted original sample is clipped to [-1, 1] when `self.config.clip_sample` is `True`. If no
  clipping has happened, "corrected" `model_output` would coincide with the one provided as input and
  `use_clipped_model_output` has no effect.
- **variance_noise** (`torch.Tensor`) --
  Alternative to generating noise with `generator` by directly providing the noise for the variance
  itself. Useful for methods such as `CycleDiffusion`.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `~schedulers.scheduling_ddim_inverse.DDIMInverseSchedulerOutput` or
  `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>`~schedulers.scheduling_ddim_inverse.DDIMInverseSchedulerOutput` or `tuple`</rettype><retdesc>If return_dict is `True`, `~schedulers.scheduling_ddim_inverse.DDIMInverseSchedulerOutput` is
returned, otherwise a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/ddim_inverse.md" />