# FlowMatchEulerDiscreteScheduler

`FlowMatchEulerDiscreteScheduler` is based on the flow-matching sampling introduced in [Stable Diffusion 3](https://huggingface.co/papers/2403.03206).

## FlowMatchEulerDiscreteScheduler[[diffusers.FlowMatchEulerDiscreteScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.FlowMatchEulerDiscreteScheduler</name><anchor>diffusers.FlowMatchEulerDiscreteScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_euler_discrete.py#L47</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 1000"}, {"name": "shift", "val": ": float = 1.0"}, {"name": "use_dynamic_shifting", "val": ": bool = False"}, {"name": "base_shift", "val": ": typing.Optional[float] = 0.5"}, {"name": "max_shift", "val": ": typing.Optional[float] = 1.15"}, {"name": "base_image_seq_len", "val": ": typing.Optional[int] = 256"}, {"name": "max_image_seq_len", "val": ": typing.Optional[int] = 4096"}, {"name": "invert_sigmas", "val": ": bool = False"}, {"name": "shift_terminal", "val": ": typing.Optional[float] = None"}, {"name": "use_karras_sigmas", "val": ": typing.Optional[bool] = False"}, {"name": "use_exponential_sigmas", "val": ": typing.Optional[bool] = False"}, {"name": "use_beta_sigmas", "val": ": typing.Optional[bool] = False"}, {"name": "time_shift_type", "val": ": str = 'exponential'"}, {"name": "stochastic_sampling", "val": ": bool = False"}]</parameters><paramsdesc>- **num_train_timesteps** (`int`, defaults to 1000) --
  The number of diffusion steps to train the model.
- **shift** (`float`, defaults to 1.0) --
  The shift value for the timestep schedule.
- **use_dynamic_shifting** (`bool`, defaults to False) --
  Whether to apply timestep shifting on-the-fly based on the image resolution.
- **base_shift** (`float`, defaults to 0.5) --
  Value to stabilize image generation. Increasing `base_shift` reduces variation and image is more consistent
  with desired output.
- **max_shift** (`float`, defaults to 1.15) --
  Value change allowed to latent vectors. Increasing `max_shift` encourages more variation and image may be
  more exaggerated or stylized.
- **base_image_seq_len** (`int`, defaults to 256) --
  The base image sequence length.
- **max_image_seq_len** (`int`, defaults to 4096) --
  The maximum image sequence length.
- **invert_sigmas** (`bool`, defaults to False) --
  Whether to invert the sigmas.
- **shift_terminal** (`float`, defaults to None) --
  The end value of the shifted timestep schedule.
- **use_karras_sigmas** (`bool`, defaults to False) --
  Whether to use Karras sigmas for step sizes in the noise schedule during sampling.
- **use_exponential_sigmas** (`bool`, defaults to False) --
  Whether to use exponential sigmas for step sizes in the noise schedule during sampling.
- **use_beta_sigmas** (`bool`, defaults to False) --
  Whether to use beta sigmas for step sizes in the noise schedule during sampling.
- **time_shift_type** (`str`, defaults to "exponential") --
  The type of dynamic resolution-dependent timestep shifting to apply. Either "exponential" or "linear".
- **stochastic_sampling** (`bool`, defaults to False) --
  Whether to use stochastic sampling.</paramsdesc><paramgroups>0</paramgroups></docstring>

Euler scheduler.

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_noise</name><anchor>diffusers.FlowMatchEulerDiscreteScheduler.scale_noise</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_euler_discrete.py#L171</source><parameters>[{"name": "sample", "val": ": FloatTensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.FloatTensor]"}, {"name": "noise", "val": ": typing.Optional[torch.FloatTensor] = None"}]</parameters><paramsdesc>- **sample** (`torch.FloatTensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.FloatTensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Forward process in flow-matching








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_begin_index</name><anchor>diffusers.FlowMatchEulerDiscreteScheduler.set_begin_index</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_euler_discrete.py#L158</source><parameters>[{"name": "begin_index", "val": ": int = 0"}]</parameters><paramsdesc>- **begin_index** (`int`) --
  The begin index for the scheduler.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the begin index for the scheduler. This function should be run from pipeline before the inference.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.FlowMatchEulerDiscreteScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_euler_discrete.py#L249</source><parameters>[{"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}, {"name": "sigmas", "val": ": typing.Optional[typing.List[float]] = None"}, {"name": "mu", "val": ": typing.Optional[float] = None"}, {"name": "timesteps", "val": ": typing.Optional[typing.List[float]] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`, *optional*) --
  The number of diffusion steps used when generating samples with a pre-trained model.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.
- **sigmas** (`List[float]`, *optional*) --
  Custom values for sigmas to be used for each diffusion step. If `None`, the sigmas are computed
  automatically.
- **mu** (`float`, *optional*) --
  Determines the amount of shifting applied to sigmas when performing resolution-dependent timestep
  shifting.
- **timesteps** (`List[float]`, *optional*) --
  Custom values for timesteps to be used for each diffusion step. If `None`, the timesteps are computed
  automatically.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.FlowMatchEulerDiscreteScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_euler_discrete.py#L373</source><parameters>[{"name": "model_output", "val": ": FloatTensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.FloatTensor]"}, {"name": "sample", "val": ": FloatTensor"}, {"name": "s_churn", "val": ": float = 0.0"}, {"name": "s_tmin", "val": ": float = 0.0"}, {"name": "s_tmax", "val": ": float = inf"}, {"name": "s_noise", "val": ": float = 1.0"}, {"name": "generator", "val": ": typing.Optional[torch._C.Generator] = None"}, {"name": "per_token_timesteps", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.FloatTensor`) --
  The direct output from learned diffusion model.
- **timestep** (`float`) --
  The current discrete timestep in the diffusion chain.
- **sample** (`torch.FloatTensor`) --
  A current instance of a sample created by the diffusion process.
- **s_churn** (`float`) --
- **s_tmin**  (`float`) --
- **s_tmax**  (`float`) --
- **s_noise** (`float`, defaults to 1.0) --
  Scaling factor for noise added to the sample.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **per_token_timesteps** (`torch.Tensor`, *optional*) --
  The timesteps for each token in the sample.
- **return_dict** (`bool`) --
  Whether or not to return a
  `FlowMatchEulerDiscreteSchedulerOutput` or tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>`FlowMatchEulerDiscreteSchedulerOutput` or `tuple`</rettype><retdesc>If return_dict is `True`,
`FlowMatchEulerDiscreteSchedulerOutput` is returned,
otherwise a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>stretch_shift_to_terminal</name><anchor>diffusers.FlowMatchEulerDiscreteScheduler.stretch_shift_to_terminal</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_euler_discrete.py#L228</source><parameters>[{"name": "t", "val": ": Tensor"}]</parameters><paramsdesc>- **t** (`torch.Tensor`) --
  A tensor of timesteps to be stretched and shifted.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A tensor of adjusted timesteps such that the final value equals `self.config.shift_terminal`.</retdesc></docstring>

Stretches and shifts the timestep schedule to ensure it terminates at the configured `shift_terminal` config
value.

Reference:
https://github.com/Lightricks/LTX-Video/blob/a01a171f8fe3d99dce2728d60a73fecf4d4238ae/ltx_video/schedulers/rf.py#L51








</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/flow_match_euler_discrete.md" />