# FlowMatchHeunDiscreteScheduler

`FlowMatchHeunDiscreteScheduler` is based on the flow-matching sampling introduced in [EDM](https://huggingface.co/papers/2403.03206).

## FlowMatchHeunDiscreteScheduler[[diffusers.FlowMatchHeunDiscreteScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.FlowMatchHeunDiscreteScheduler</name><anchor>diffusers.FlowMatchHeunDiscreteScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_heun_discrete.py#L44</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 1000"}, {"name": "shift", "val": ": float = 1.0"}]</parameters><paramsdesc>- **num_train_timesteps** (`int`, defaults to 1000) --
  The number of diffusion steps to train the model.
- **timestep_spacing** (`str`, defaults to `"linspace"`) --
  The way the timesteps should be scaled. Refer to Table 2 of the [Common Diffusion Noise Schedules and
  Sample Steps are Flawed](https://huggingface.co/papers/2305.08891) for more information.
- **shift** (`float`, defaults to 1.0) --
  The shift value for the timestep schedule.</paramsdesc><paramgroups>0</paramgroups></docstring>

Heun scheduler.

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_noise</name><anchor>diffusers.FlowMatchHeunDiscreteScheduler.scale_noise</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_heun_discrete.py#L110</source><parameters>[{"name": "sample", "val": ": FloatTensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.FloatTensor]"}, {"name": "noise", "val": ": typing.Optional[torch.FloatTensor] = None"}]</parameters><paramsdesc>- **sample** (`torch.FloatTensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.FloatTensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Forward process in flow-matching








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_begin_index</name><anchor>diffusers.FlowMatchHeunDiscreteScheduler.set_begin_index</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_heun_discrete.py#L100</source><parameters>[{"name": "begin_index", "val": ": int = 0"}]</parameters><paramsdesc>- **begin_index** (`int`) --
  The begin index for the scheduler.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the begin index for the scheduler. This function should be run from pipeline before the inference.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.FlowMatchHeunDiscreteScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_heun_discrete.py#L140</source><parameters>[{"name": "num_inference_steps", "val": ": int"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`) --
  The number of diffusion steps used when generating samples with a pre-trained model.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.FlowMatchHeunDiscreteScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_flow_match_heun_discrete.py#L200</source><parameters>[{"name": "model_output", "val": ": FloatTensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.FloatTensor]"}, {"name": "sample", "val": ": FloatTensor"}, {"name": "s_churn", "val": ": float = 0.0"}, {"name": "s_tmin", "val": ": float = 0.0"}, {"name": "s_tmax", "val": ": float = inf"}, {"name": "s_noise", "val": ": float = 1.0"}, {"name": "generator", "val": ": typing.Optional[torch._C.Generator] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.FloatTensor`) --
  The direct output from learned diffusion model.
- **timestep** (`float`) --
  The current discrete timestep in the diffusion chain.
- **sample** (`torch.FloatTensor`) --
  A current instance of a sample created by the diffusion process.
- **s_churn** (`float`) --
- **s_tmin**  (`float`) --
- **s_tmax**  (`float`) --
- **s_noise** (`float`, defaults to 1.0) --
  Scaling factor for noise added to the sample.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **return_dict** (`bool`) --
  Whether or not to return a
  `FlowMatchHeunDiscreteSchedulerOutput` tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>`FlowMatchHeunDiscreteSchedulerOutput` or `tuple`</rettype><retdesc>If return_dict is `True`,
`FlowMatchHeunDiscreteSchedulerOutput` is returned,
otherwise a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/flow_match_heun_discrete.md" />